!{\src2tex{textfont=tt}}
!!****f* ABINIT/testlda
!! NAME
!! testlda
!!
!! FUNCTION
!! Test QPLDA or ABINIT LDA or KSS type file
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG, RShaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtfil=filenames (only filkss is used)
!!  nonlocal= if true, only master will have access to the file
!!          = if false, all proc have access to the file
!! OUTPUT
!!  i1= integer defining the file format (502 or 602 if KSS file) 
!!  i2= integer defining the file format (old file formats)
!!  mpsang=1+maximum angular momentum for nonlocal pseudopotential
!!  natom=number of atoms
!!  nbnd=number of bands
!!  nkpt=number of k points
!!  npw=number of plane waves
!!  nsh=number of shells
!!  nsym=number of symmetries
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  ntypat=number of atom types
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!      hdr_clean,hdr_io,hdr_io_netcdf
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine testlda(dtfil,nsym,nkpt,nbnd,npw,nsh,i1,i2,ntypat,natom,mpsang,nsppol,mpi_enreg,nonlocal)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13io_mpi
 use interfaces_14iowfdenpot
 use interfaces_lib01hidempi
#else
 use defs_interfaces
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

#if defined MPI || defined MPI_FFT
    include 'mpif.h'
#endif
		   
!Arguments ------------------------------------
!scalars
 integer,intent(out) :: i1,i2,mpsang,natom,nbnd,nkpt,npw,nsh,nsym,ntypat,nsppol
 type(datafiles_type),intent(in) :: dtfil
 type(MPI_type),intent(in) :: mpi_enreg
 logical,intent(in)::nonlocal
!Local variables-------------------------------
!scalars
 integer,parameter :: unitkss=23
 integer :: fform,i10,i11,i12,i13,i14,i15,i16,i3,i4,i5,i6,i7,i8,i9,nsym2,rdwr,ios
 integer :: readnetcdf,status,status1,status2,status3
 logical,parameter :: DEBUG=.false.
 logical::read_ok
 type(hdr_type) :: hdr
 character(len=500) :: message
 integer::spaceComm,me,master,ierr
!arrays
 character(len=80) :: tit(2)
 
! *************************************************************************

!start clock
! call pclock(0)
!Init mpi_comm
 call xcomm_init(mpi_enreg,spaceComm)
!Init me
 call xme_init(mpi_enreg,me)
!Init master
 call xmaster_init(mpi_enreg,master)

 write(message,'(3a)')' testing Kohn-Sham structure file: ',trim(dtfil%filkss),ch10
 call wrtout(6,message,'COLL')

 if( mpi_enreg%nproc==1 .or. (.not.nonlocal) .or. me==0 )then

! Trying KSS abinit form
  open(unitkss,file=dtfil%filkss,status='old',form='unformatted',iostat=ios)
  if (ios/=0) then 
   write(message,'(5a)')&
&   ' testlda: ERROR- ',ch10,&
&   ' opening file: ',trim(dtfil%filkss),' as old'
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if

! Read the header of the GS wavefunction file
  rdwr=1
  readnetcdf = 0 ! should become input parameter and make KSS a netcdf file as well
  if (readnetcdf == 0) then
   call hdr_io(fform,hdr,rdwr,unitkss)
  else if (readnetcdf == 1) then
   call hdr_io_netcdf(fform,hdr,rdwr,unitkss)
  end if

  natom=hdr%natom
  nkpt=hdr%nkpt
  nsym=hdr%nsym
  nsppol=hdr%nsppol
  ntypat=hdr%ntypat

  if(fform==502.or.fform==602) then
   if(fform==502) then
    write(message,'(a)')' KSS abinit double precision form'
   else if(fform==602) then
    write(message,'(a)')' KSS abinit single precision form'
   else
    stop 'internal error'
   end if
   call wrtout(6,message,'COLL')
   i2 = fform

!  XG20030510 : Should be changed, later. Indeed, it is not consistent
!  with the definition of the structured datatyp hdr, and the
!  associated routines. Nothing should be read directly in the header
!  of the file : everything is already in hdr ...
   write(message,'(a,a6,a,i3)')&
&   ' generated by ABINIT ',hdr%codvsn,' header version ',hdr%headform
   call wrtout(6,message,'COLL')

   if(hdr%headform/=23 .and. hdr%headform/=34 .and. &
&     hdr%headform/=40 .and. hdr%headform/=41 .and. &
&     hdr%headform/=42 .and. hdr%headform/=44 .and. &
&     hdr%headform/=53 ) then 
    write(message,'(4a)')ch10,&
&    ' testlda : ERROR - ',ch10,&
&    ' unknown  header version '
    call wrtout(6,message,'COLL')
    call leave_new('COLL')
   end if 

!--------------------------
   read(unitkss) tit(1)
   read(unitkss) tit(2)
   write(message,'(a)')' title of file:'
   call wrtout(6,message,'COLL')
   write(message,'(1x,a79,a,1x,a79)')tit(1)(:79),ch10,tit(2)(:79)
   call wrtout(6,message,'COLL')
!  Write(*,'(1x,a79/1x,a79)') tit(1)(:79), tit(2)(:79)
   read(unitkss) nsym2, nbnd, npw, nsh, mpsang
   nsym = nsym2
   write(message,'(a,i8)')' number of atomic species      ', ntypat
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of atoms               ', natom
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of ang mom components  ', mpsang
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of symmetry operations ', nsym
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of plane waves         ', npw
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of k-points            ', nkpt
   call wrtout(6,message,'COLL')
   write(message,'(a,i8,a)')' number of bands               ',nbnd,ch10
   call wrtout(6,message,'COLL')
   close(unitkss)
   read_ok=.true.
! Return
  else
   close(unitkss)
  end if

  if(.not.read_ok)then
  
!  Trying STA or qplda form
!  open(unitkss,status='unknown',form='unformatted')
   rewind(unitkss)
   read(unitkss,iostat=status1) tit(1)
   if(DEBUG) print *, tit(1)
   read(unitkss,iostat=status2) tit(2)
   if(DEBUG) print *, tit(2)
   read(unitkss,iostat=status3) i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16
   write(6,'(1x,a80,/,1x,a80)') tit(1),tit(2)
!  flags used so far:
!  i1=0 if QPLDA file is formatted, 1 if unformatted
!  i2=0 if RWG format, 1 if BF format, 2 ABINIT format
!  i3=1 if non-symmorphic operations (+vectors) included, otherwise 0
   if(DEBUG) print *, i1,i2,i3

   if(status1/=0.or.status2/=0.or.status3/=0) then
    if(DEBUG) print *, status1, status2, status3
    stop 'unknown file form, status'
   end if

   if(i2==2) then
    write(6,*) 'STA abinit form'
   else if(i2==0.or.i2==1) then
    write(6,*)'qplda cp form'
   else
    if(DEBUG) print *, 'i2 ', i2
    stop 'unknown file form, i2'
   end if

   if(i1/=1) then
    write(6,*)'formatted file'
   else
    write(6,*)'unformatted file'
   end if
   if(i3==1) then
    write(6,*)'ERROR testlda 1: check i3'
   end if

   write(6,*)'title of file:'
   write(6,'(1x,a79/1x,a79)') tit(1)(:79), tit(2)(:79)

!  Skip real-space lattice vectors
   read(unitkss)

   read(unitkss) nsym
   write(6,*) 'number of symmetry operations ',nsym

!  Skip symmetry operations
   read(unitkss)

   read(unitkss) npw
   write(6,*) 'number of plane waves         ',npw

!  Skip g-vector
   read(unitkss)

   read(unitkss) nkpt
   write(6,*) 'number of k-points            ',nkpt

!  Skip k-points
   read(unitkss)

   read(unitkss) nbnd
   write(6,*) 'number of bands               ',nbnd

!  MG 061409
!  for compatibility reasons nsppol is set to 1 in case of qplda file format
!  note however that the qplda format is not supported anymore  
!  needed a modification of the qplda format to treat spin polarized calculations!
   nsppol=1

!  read(unitkss) nsppol
   write(*,*) 'nsppol                        ',nsppol
!  END MG

  end if ! read_ok

  call hdr_clean(hdr)

 end if !me==0

 if(mpi_enreg%nproc>1.and.nonlocal)then
  call xcast_mpi(nsym,master,spaceComm,ierr)
  call xcast_mpi(nkpt,master,spaceComm,ierr)
  call xcast_mpi(nbnd,master,spaceComm,ierr)
  call xcast_mpi(npw,master,spaceComm,ierr)
  call xcast_mpi(nsh,master,spaceComm,ierr)
  call xcast_mpi(i1,master,spaceComm,ierr)
  call xcast_mpi(i2,master,spaceComm,ierr)
  call xcast_mpi(ntypat,master,spaceComm,ierr)
  call xcast_mpi(natom,master,spaceComm,ierr)
  call xcast_mpi(mpsang,master,spaceComm,ierr)
  call xcast_mpi(nsppol,master,spaceComm,ierr)
 end if

 end subroutine testlda
!!***
