!{\src2tex{textfont=tt}}
!!****f* ABINIT/eneres3
!! *** arguments modified -- idir,rhog,rhor added
!!
!! NAME
!! eneres3
!!
!! FUNCTION
!! Compute different contribution to the variational part of the 2nd derivative
!! and assemble it, and also compute the residual potential.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (XG, DRH)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  cplex: if 1, real space 1-order functions on FFT grid are REAL,
!!     if 2, COMPLEX
!!  edocc=correction to 2nd-order total energy coming from changes of occupation
!!  eeig0=0th-order eigenenergies part of 2nd-order total energy
!!  ek0=0th-order kinetic energy part of 2nd-order total energy.
!!  ek1=1st-order kinetic energy part of 2nd-order total energy.
!!  eloc0=0th-order local (psp+vxc+Hart) part of 2nd-order total energy
!!  enl0=0th-order nonlocal pseudopot. part of 2nd-order total energy.
!!  enl1=1st-order nonlocal pseudopot. part of 2nd-order total energy.
!!  frzfermi=if 1, freeze the Fermi energy
!!  gsqcut=cutoff on (k+G)^2 (bohr^-2)
!!  idir=direction of atomic displacement (=1,2 or 3 : displacement of
!!    atom ipert along the 1st, 2nd or 3rd axis).
!!  ipert=type of the perturbation
!!  kxc(nfft,nkxc)=exchange-correlation kernel
!!  mpi_enreg=informations about MPI parallelization
!!  natom=number of atoms in cell.
!!  nfft=(effective) number of FFT grid points (for this processor)
!!  ngfft(18)=contain all needed information about 3D FFT,
!!    see ~abinit/doc/input_variables/vargs.htm#ngfft
!!  nkxc=second dimension of the array kxc, see rhohxc.f for a description
!!  nspden=number of spin-density components
!!  n3xccc=dimension of xccc3d1 ; 0 if no XC core correction is used
!!  occopt=option for occupancies
!!  qphon(3)=reduced coordinates for the phonon wavelength
!!  rhog(2,nfft)=array for Fourier transform of GS electron density
!!  rhog1(2,nfft)=RF electron density in reciprocal space
!!  rhor(nfft,nspden)=array for GS electron density in electrons/bohr**3.
!!  rhor1(cplex*nfft,nspden)=RF electron density in real space
!!     (electrons/bohr**3).
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  tsmear=smearing energy or temperature (if metal)
!!  vpsp1(cplex*nfft)=RF local psp
!!  vtrial1(cplex*nfft,nspden)=RF trial potential for the past call to vtorho
!!  xccc3d1(cplex*n3xccc)=3D change in core charge density, see n3xccc
!!
!! OUTPUT
!!  deltae=change in energy between the previous and present SCF cycle
!!          and previous SCF cycle.
!!  ehart01=inhomogeneous 1st-order Hartree part of 2nd-order total energy
!!    for strain perturbation only (zero otherwise, and not used)
!!  ehart1=1st-order Hartree part of 2nd-order total energy
!!  elpsp1=1st-order local pseudopot. part of 2nd-order total energy.
!!  evar=variational part of the 2nd-order total energy.
!!  exc1=1st-order exchange-correlation part of 2nd-order total energy
!!  vhartr1(cplex*nfft)=1-order Hartree potential
!!  vresid1(cplex*nfft,nspden)=potential residual
!!  vres2=square of the norm of the residual
!!
!! SIDE EFFECTS
!! input/output
!! elast=previous value of the total energy, needed to compute deltae,
!!      then updated (cannot simply be saved, because set to zero
!!      at each new call of scfcv3).
!!
!! PARENTS
!!      scfcv3
!!
!! CHILDREN
!!      dotprod_vn,hartre,hartrestr,metric,mkvxc3,mkvxcstr3,sqnorm_v,timab
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine eneres3(cplex,deltae,edocc,eeig0,ehart01,ehart1,ek0,ek1,&
&  elast,eloc0,&
&  elpsp1,enl0,enl1,exc1,evar,frzfermi,gsqcut,idir,ipert,kxc,mpi_enreg,natom,nfft,ngfft,&
&  nkxc,nspden,n3xccc,occopt,qphon,rhog,rhog1,rhor,rhor1,rprimd,tsmear,vhartr1,&
&  vpsp1,vresid1,vres2,vtrial1,xccc3d1)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12geometry
 use interfaces_12spacepar
 use interfaces_13xc
 use interfaces_16response, except_this_one => eneres3
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: cplex,frzfermi,idir,ipert,n3xccc,natom,nfft,nkxc,nspden
 integer,intent(in) :: occopt
 real(dp),intent(in) :: edocc,eeig0,ek0,ek1,eloc0,enl0,enl1,gsqcut,tsmear
 real(dp),intent(inout) :: elast
 real(dp),intent(out) :: deltae,ehart01,ehart1,elpsp1,evar,exc1,vres2
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: ngfft(18)
 real(dp),intent(in) :: kxc(nfft,nkxc),qphon(3),rhog(2,nfft),rhog1(2,nfft)
 real(dp),intent(in) :: rhor(nfft,nspden),rhor1(cplex*nfft,nspden),rprimd(3,3)
 real(dp),intent(in) :: vpsp1(cplex*nfft),vtrial1(cplex*nfft,nspden)
 real(dp),intent(in) :: xccc3d1(cplex*n3xccc)
 real(dp),intent(out) :: vhartr1(cplex*nfft),vresid1(cplex*nfft,nspden)

!Local variables-------------------------------
!scalars
 integer :: i1,i2,i3,ifft,ii,ir,ispden,n1,n2,n3,nfftot,option,qzero
 real(dp) :: doti,ehart_tmp,elpsp10,ensc1,rho1_dn,rho1im_dn,rho1re_dn,ucvol
 real(dp) :: vnew1
 character(len=500) :: message
!arrays
 real(dp) :: gmet(3,3),gprimd(3,3),rmet(3,3),tsec(2)
 real(dp),allocatable :: vhartr01(:),vxc1(:,:),vxc10(:,:)

! *********************************************************************

!DEBUG
!write(6,*)' eneres3 : enter, stop '
!write(6,*)rprimd
!ENDDEBUG

 if(nspden==4)then
  write(6,*)' eneres3 : does not work yet for nspden=4'
  stop
 end if

 call timab(157,1,tsec)

 nfftot=ngfft(1)*ngfft(2)*ngfft(3)

!DEBUG
!Compute NSC energy ensc1 associated with rhor1 in vtrial1, for debugging purposes
!call dotprod_vn(cplex,rhor1,ensc1,doti,nfft,nfftot,nspden,1,vtrial1,ucvol)
!write(6,*)' ek0+eeig0+eloc0=',ek0+eeig0+eloc0
!write(6,*)' ensc1=',ensc1
!ENDDEBUG


!Compute different geometric tensor, as well as ucvol, from rprimd
 call metric(gmet,gprimd,-1,rmet,rprimd,ucvol)

 allocate(vxc1(cplex*nfft,nspden),vxc10(cplex*nfft,nspden))

!------Compute the total energy and the parts of it that were missing--------

!Compute Hartree contribution
 ehart_tmp=zero
 if(ipert==natom+3 .or. ipert==natom+4) then
  allocate(vhartr01(cplex*nfft))
  call hartrestr(gmet,gprimd,gsqcut,idir,ipert,mpi_enreg,natom,nfft,ngfft,rhog,vhartr01)
  call dotprod_vn(cplex,rhor1,ehart_tmp,doti,mpi_enreg,nfft,nfftot,1,1,vhartr01,ucvol)
  ehart_tmp=2.0_dp*ehart_tmp
  ehart01=ehart_tmp
 end if

 call hartre(cplex,gmet,gsqcut,0,mpi_enreg,nfft,ngfft,qphon,rhog1,vhartr1)
 call dotprod_vn(cplex,rhor1,ehart1,doti,mpi_enreg,nfft,nfftot,1,1,vhartr1,ucvol)
 ehart1=ehart1+ehart_tmp
!Note that there is a factor 2.0_dp difference with the similar GS formula

 if(ipert==natom+3 .or. ipert==natom+4) then
  vhartr1(:)=vhartr1(:)+vhartr01(:)
  deallocate(vhartr01)
 end if

!DEBUG
!write(6,*)' eneres3 : before mkvxc3, rhor1'
!n1=ngfft(1)
!n2=ngfft(2)
!n3=ngfft(3)
!do ifft=1,nfft
! i3=(ifft-1)/n1/n2
! i2=(ifft-1-i3*n1*n2)/n1
! i1=ifft-1-i3*n1*n2-i2*n1
! if(i1==0 .and. i2==0)write(6,*)i1,i2,i3,rhor1(ifft,1)
!end do
!do ii=1,nkxc
! write(6,*)' eneres3 : before mkvxc3, kxc,ii=',ii
! do ifft=1,nfft
!  i3=(ifft-1)/n1/n2
!  i2=(ifft-1-i3*n1*n2)/n1
!  i1=ifft-1-i3*n1*n2-i2*n1
!  if(i1==0 .and. i2==0)write(6,*)i1,i2,i3,kxc(ifft,ii)
! end do
!end do
!stop
!ENDDEBUG

!Compute first-order pseudopotential (include the XC core correction)

 option=0
 if(ipert==natom+3 .or. ipert==natom+4) then
! routine for strain perturbation
  call mkvxcstr3(cplex,gmet,gsqcut,idir,ipert,kxc,mpi_enreg,natom,nfft,ngfft,&
&  nkxc,nspden,n3xccc,option,qphon,rhor,rhor1,rprimd,vxc10,xccc3d1)
 else
  call mkvxc3(cplex,gmet,gsqcut,kxc,mpi_enreg,nfft,ngfft,nkxc,nspden,n3xccc,option,&
&  qphon,rhor1,rprimd,vxc10,xccc3d1)
 end if

 call dotprod_vn(cplex,rhor1,elpsp10,doti,mpi_enreg,nfft,nfftot,nspden,1,vxc10,ucvol)
 call dotprod_vn(cplex,rhor1,elpsp1 ,doti,mpi_enreg,nfft,nfftot,1     ,1,vpsp1,ucvol)
!Note that there is a factor 2.0_dp difference with the similar GS formula
 elpsp1=two*(elpsp1+elpsp10)

!Compute xc contribution exc1 (except the XC core-correction)
 option=2
 call mkvxc3(cplex,gmet,gsqcut,kxc,mpi_enreg,nfft,ngfft,nkxc,nspden,n3xccc,option,&
& qphon,rhor1,rprimd,vxc1,xccc3d1)
 call dotprod_vn(cplex,rhor1,exc1,doti,mpi_enreg,nfft,nfftot,nspden,1,vxc1,ucvol)

!DEBUG
!write(6,*)' eneres3 : check exc1=',exc1
!ENDDEBUG

!DEBUG (do not take away)
!Compute NSC energy associated with vtrial1, for debugging purposes
!  call dotprod_vn(cplex,rhor1,ensc1,doti,mpi_enreg,nfft,nfftot,nspden,1,vtrial1,ucvol)
!  ensc1=ensc1+half*enl1
!  write(6,*)' eneres3 : check NSC energy, diff=',&
! &  ek0+edocc+eeig0+eloc0+enl0+ensc1
!  write(6,*)' evarNSC=',ek0+edocc+eeig0+eloc0+enl0
!  write(6,*)' ensc1,exc1=',ensc1,exc1
!ENDDEBUG

!Compute total energy (hartree)
 if ( ipert>=1 .and. ipert<=natom ) then
  evar=ek0+edocc+eeig0+eloc0+elpsp1+ehart1+exc1+enl0+enl1
! For ipert==natom+2, some contributions vanishes, noticeably ek1
 else if ( ipert==natom+1 .or. ipert==natom+2 )then
  evar=ek0+edocc+eeig0+eloc0+ek1+ehart1+exc1+enl0+enl1
! All terms enter for strain perturbation
 else if ( ipert==natom+3 .or. ipert==natom+4 )then
  evar=ek0+ek1+edocc+eeig0+eloc0+elpsp1+ehart1+exc1+enl0+enl1
 end if
!if(occopt>=3 .and. occopt<=7)etotal=etotal-tsmear*entropy
 deltae=evar-elast  ;  elast=evar


!------Produce residual vector and square of norm of this vector-------------

!Here, vhartr1 contains Hartree potential,
!vpsp1 contains local psp, while vxc1 contain xc potential
!(both spin-up and spin-down if nspden=2).
 if(n3xccc/=0 .or. ipert==natom+3 .or. ipert==natom+4)then
  vxc1(:,:)=vxc1(:,:)+vxc10(:,:)
 end if
 do ispden=1,nspden
  do ifft=1,cplex*nfft
   vresid1(ifft,ispden)=&
&   vhartr1(ifft)+vxc1(ifft,ispden)+vpsp1(ifft)-vtrial1(ifft,ispden)
  end do
 end do

!Compute residual
 call sqnorm_v(cplex,mpi_enreg,nfft,vres2,nspden,vresid1)

 deallocate(vxc1,vxc10)

 call timab(157,2,tsec)

!DEBUG
!write(6,*)' eneres3 : exit '
!stop
!ENDDEBUG

end subroutine eneres3
!!***
