!{\src2tex{textfont=tt}}
!!****f* ABINIT/rrho
!! NAME
!! rrho
!!
!! FUNCTION
!! Reads in the charge in mkdens3D format
!! The file was opened in the calling program, unit number 19.
!! The header was already read in the case of the unformatted file
!!
!! COPYRIGHT
!! Copyright (C) 2000-2007 ABINIT group (GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! densfileformat=integer flag :
!! 0=formatted (ASCII) or 1=unformatted (BINARY)
!! nr1=grid_full size along x
!! nr2=grid_full size along y
!! nr3=grid_full size along z
!! nspden=number of spin polartized densities (1 for non-spin polarized, 2 for spin-polarized)
!!
!! OUTPUT
!! grid_full(nr1,nr2,nr3)=grid_full matrix
!!
!! PARENTS
!!      cut3d
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rrho(densfileformat,grid_full,nr1,nr2,nr3,nspden)

 use defs_basis

 implicit none

!Arguments-------------------------------------------------------------
!scalars
 integer,intent(in) :: densfileformat,nr1,nr2,nr3,nspden
!arrays
 real(dp),intent(out) :: grid_full(nr1,nr2,nr3,nspden)

!Local variables--------------------------------------------------------
!scalars
 integer :: ifft,ii,ir1,ir2,ir3,ispden

! *************************************************************************

 select case (densfileformat)

! Formatted (only one spin component is allowed)
  case (0)
   do ir3=1,nr3
    do ir2=1,nr2
     do ir1=1,nr1
      read(unit=19,fmt=*) grid_full(ir1,ir2,ir3,1)
     end do
    end do
   end do
   close(19)

! Unformatted, on one record
  case (1)
   do ispden=1,nspden
    read(unit=19) grid_full(1:nr1,1:nr2,1:nr3,ispden)
   end do
   close(19)

  case default
   write(6,*)&
&   'Error, value for 3D function file format is invalid: ',densfileformat
   stop

 end select

end subroutine rrho
!!***
