{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
{-# LANGUAGE TupleSections #-}

{-| The parser is generated by Happy (<http://www.haskell.org/happy>).
 -
 - Ideally, ranges should be as precise as possible, to get messages that
 - emphasize precisely the faulting term(s) upon error.
 -
 - However, interactive highlighting is only applied at the end of each
 - mutual block, keywords are only highlighted once (see
 - `TypeChecking.Rules.Decl'). So if the ranges of two declarations
 - interleave, one must ensure that keyword ranges are not included in
 - the intersection. (Otherwise they are uncolored by the interactive
 - highlighting.)
 -
 -}
module Agda.Syntax.Parser.Parser (
      moduleParser
    , moduleNameParser
    , exprParser
    , exprWhereParser
    , tokensParser
    , splitOnDots  -- only used by the internal test-suite
    ) where

import Control.Monad

import Data.Char
import Data.Functor
import Data.List
import Data.Maybe
import Data.Monoid
import qualified Data.Traversable as T

import Debug.Trace

import Agda.Syntax.Position hiding (tests)
import Agda.Syntax.Parser.Monad
import Agda.Syntax.Parser.Lexer
import Agda.Syntax.Parser.Tokens
import Agda.Syntax.Concrete as C
import Agda.Syntax.Concrete.Pretty ()
import Agda.Syntax.Common
import Agda.Syntax.Fixity
import Agda.Syntax.Notation
import Agda.Syntax.Literal

import Agda.TypeChecking.Positivity.Occurrence hiding (tests)

import Agda.Utils.Either hiding (tests)
import Agda.Utils.Hash
import Agda.Utils.List ( spanJust, chopWhen )
import Agda.Utils.Monad
import Agda.Utils.Pretty
import Agda.Utils.Singleton
import Agda.Utils.Tuple

import Agda.Utils.Impossible
#include "undefined.h"
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

newtype HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84 = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn9 :: ([Token]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn9 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn9 #-}
happyOut9 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Token])
happyOut9 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut9 #-}
happyIn10 :: ([Token]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn10 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn10 #-}
happyOut10 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Token])
happyOut10 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut10 #-}
happyIn11 :: (Token) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn11 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn11 #-}
happyOut11 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Token)
happyOut11 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut11 #-}
happyIn12 :: (([Pragma], [Declaration])) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn12 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn12 #-}
happyOut12 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (([Pragma], [Declaration]))
happyOut12 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut12 #-}
happyIn13 :: t13 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn13 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn13 #-}
happyOut13 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t13
happyOut13 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut13 #-}
happyIn14 :: t14 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t14
happyOut14 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: t15 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t15
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (()) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (())
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (Integer) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Integer)
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Name) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Name)
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: ([Name]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Name])
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (Range) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Range)
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (Arg Name) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Arg Name)
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([Arg Name]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Arg Name])
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: ([Arg Name]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Arg Name])
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: (QName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (QName)
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: (QName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (QName)
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: (Name) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Name)
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([Name]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Name])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([Name]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Name])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (Either [Name] [Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Either [Name] [Expr])
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: ([WithHiding Name]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([WithHiding Name])
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: ([String]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([String])
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (String) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (String)
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: ([(Interval, String)]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([(Interval, String)])
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (Name) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Name)
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (QName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (QName)
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: ([QName]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([QName])
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: (Expr) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Expr)
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: t38 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t38
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ([Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Expr])
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ([Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Expr])
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: t41 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t41
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: (Expr) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Expr)
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: ([Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Expr])
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: t44 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t44
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: t45 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t45
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: t46 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t46
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (RecordAssignments) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (RecordAssignments)
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (RecordAssignments) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (RecordAssignments)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (RecordAssignment) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (RecordAssignment)
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (ModuleAssignment) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (ModuleAssignment)
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: ([FieldAssignment]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([FieldAssignment])
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: ([FieldAssignment]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([FieldAssignment])
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (FieldAssignment) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (FieldAssignment)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: t54 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t54
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: t55 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t55
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: ([TypedBindings]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([TypedBindings])
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: (TypedBindings) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (TypedBindings)
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (TypedBindings) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (TypedBindings)
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: (TypedBindings) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (TypedBindings)
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: ([LamBinding]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([LamBinding])
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (Either ([LamBinding], Hiding) [Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Either ([LamBinding], Hiding) [Expr])
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: ([Either Hiding LamBinding]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Either Hiding LamBinding])
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (Either [Either Hiding LamBinding] [Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Either [Either Hiding LamBinding] [Expr])
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ((LHS,RHS,WhereClause,Bool)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ((LHS,RHS,WhereClause,Bool))
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: ((LHS,RHS,WhereClause,Bool)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ((LHS,RHS,WhereClause,Bool))
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: ((LHS,RHS,WhereClause,Bool)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ((LHS,RHS,WhereClause,Bool))
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: ([(LHS,RHS,WhereClause,Bool)]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([(LHS,RHS,WhereClause,Bool)])
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: ([LamBinding]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([LamBinding])
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: ([LamBinding]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([LamBinding])
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: ([LamBinding]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([LamBinding])
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: ([LamBinding]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([LamBinding])
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (Either [LamBinding] [Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Either [LamBinding] [Expr])
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (ImportDirective) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (ImportDirective)
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: ([ImportDirective]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([ImportDirective])
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (ImportDirective) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (ImportDirective)
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: ((Using, Range)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ((Using, Range))
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (([ImportedName], Range)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (([ImportedName], Range))
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (([Renaming] , Range)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (([Renaming] , Range))
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: ([Renaming]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Renaming])
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: (Renaming) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Renaming)
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (ImportedName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (ImportedName)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (ImportedName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (ImportedName)
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: ([ImportedName]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([ImportedName])
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: t84 -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> t84
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (LHS) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (LHS)
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: ([Pattern]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Pattern])
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: ([Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Expr])
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: ([Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Expr])
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (WhereClause) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (WhereClause)
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (ExprWhere) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (ExprWhere)
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: ([Arg Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Arg Declaration])
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (RHSOrTypeSigs) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (RHSOrTypeSigs)
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyIn99 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn99 #-}
happyOut99 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut99 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut99 #-}
happyIn100 :: ((Name, IsInstance)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn100 #-}
happyOut100 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ((Name, IsInstance))
happyOut100 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut100 #-}
happyIn101 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn101 #-}
happyOut101 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut101 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut101 #-}
happyIn102 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn102 #-}
happyOut102 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut102 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut102 #-}
happyIn103 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn103 #-}
happyOut103 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut103 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut103 #-}
happyIn104 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn104 #-}
happyOut104 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut104 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut104 #-}
happyIn105 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn105 #-}
happyOut105 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut105 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut105 #-}
happyIn106 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn106 #-}
happyOut106 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut106 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut106 #-}
happyIn107 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn107 #-}
happyOut107 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut107 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut107 #-}
happyIn108 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn108 #-}
happyOut108 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut108 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut108 #-}
happyIn109 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn109 #-}
happyOut109 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut109 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut109 #-}
happyIn110 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn110 #-}
happyOut110 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut110 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut110 #-}
happyIn111 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn111 #-}
happyOut111 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut111 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut111 #-}
happyIn112 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn112 #-}
happyOut112 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut112 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut112 #-}
happyIn113 :: ([Arg Name]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn113 #-}
happyOut113 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Arg Name])
happyOut113 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut113 #-}
happyIn114 :: ([RString]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn114 #-}
happyOut114 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([RString])
happyOut114 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut114 #-}
happyIn115 :: ([NamedArg HoleName]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn115 #-}
happyOut115 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([NamedArg HoleName])
happyOut115 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut115 #-}
happyIn116 :: (NamedArg HoleName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn116 #-}
happyOut116 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (NamedArg HoleName)
happyOut116 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut116 #-}
happyIn117 :: (HoleName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn117 #-}
happyOut117 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (HoleName)
happyOut117 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut117 #-}
happyIn118 :: (HoleName) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn118 #-}
happyOut118 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (HoleName)
happyOut118 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut118 #-}
happyIn119 :: (RString) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn119 #-}
happyOut119 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (RString)
happyOut119 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut119 #-}
happyIn120 :: (Maybe Range) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn120 #-}
happyOut120 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Maybe Range)
happyOut120 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut120 #-}
happyIn121 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn121 #-}
happyOut121 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut121 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut121 #-}
happyIn122 :: ([Expr]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn122 #-}
happyOut122 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Expr])
happyOut122 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut122 #-}
happyIn123 :: ([TypedBindings] -> Parser ModuleApplication) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn123 #-}
happyOut123 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([TypedBindings] -> Parser ModuleApplication)
happyOut123 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut123 #-}
happyIn124 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn124 #-}
happyOut124 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut124 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut124 #-}
happyIn125 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn125 #-}
happyOut125 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut125 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut125 #-}
happyIn126 :: (Name) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn126 #-}
happyOut126 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Name)
happyOut126 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut126 #-}
happyIn127 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn127 #-}
happyOut127 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut127 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut127 #-}
happyIn128 :: (Declaration) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn128 #-}
happyOut128 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Declaration)
happyOut128 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut128 #-}
happyIn129 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn129 #-}
happyOut129 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut129 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut129 #-}
happyIn130 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn130 #-}
happyOut130 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut130 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut130 #-}
happyIn131 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn131 #-}
happyOut131 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut131 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut131 #-}
happyIn132 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn132 #-}
happyOut132 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut132 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut132 #-}
happyIn133 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn133 #-}
happyOut133 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut133 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut133 #-}
happyIn134 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn134 #-}
happyOut134 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut134 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut134 #-}
happyIn135 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn135 #-}
happyOut135 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut135 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut135 #-}
happyIn136 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn136 #-}
happyOut136 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut136 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut136 #-}
happyIn137 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn137 #-}
happyOut137 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut137 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut137 #-}
happyIn138 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn138 #-}
happyOut138 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut138 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut138 #-}
happyIn139 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn139 #-}
happyOut139 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut139 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut139 #-}
happyIn140 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn140 #-}
happyOut140 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut140 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut140 #-}
happyIn141 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn141 #-}
happyOut141 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut141 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut141 #-}
happyIn142 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn142 #-}
happyOut142 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut142 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut142 #-}
happyIn143 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn143 #-}
happyOut143 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut143 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut143 #-}
happyIn144 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn144 #-}
happyOut144 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut144 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut144 #-}
happyIn145 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn145 #-}
happyOut145 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut145 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut145 #-}
happyIn146 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn146 #-}
happyOut146 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut146 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut146 #-}
happyIn147 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn147 #-}
happyOut147 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut147 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut147 #-}
happyIn148 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn148 #-}
happyOut148 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut148 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut148 #-}
happyIn149 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn149 #-}
happyOut149 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut149 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut149 #-}
happyIn150 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn150 #-}
happyOut150 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut150 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut150 #-}
happyIn151 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn151 #-}
happyOut151 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut151 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut151 #-}
happyIn152 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn152 #-}
happyOut152 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut152 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut152 #-}
happyIn153 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn153 #-}
happyOut153 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut153 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut153 #-}
happyIn154 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn154 #-}
happyOut154 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut154 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut154 #-}
happyIn155 :: (Pragma) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn155 #-}
happyOut155 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Pragma)
happyOut155 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut155 #-}
happyIn156 :: ([(Range, Occurrence)]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn156 #-}
happyOut156 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([(Range, Occurrence)])
happyOut156 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut156 #-}
happyIn157 :: ((Range, Occurrence)) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn157 #-}
happyOut157 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ((Range, Occurrence))
happyOut157 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut157 #-}
happyIn158 :: ([TypeSignature]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn158 #-}
happyOut158 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([TypeSignature])
happyOut158 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut158 #-}
happyIn159 :: ([TypeSignature]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn159 #-}
happyOut159 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([TypeSignature])
happyOut159 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut159 #-}
happyIn160 :: ([Arg TypeSignature]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn160 #-}
happyOut160 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Arg TypeSignature])
happyOut160 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut160 #-}
happyIn161 :: ([Arg TypeSignature]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn161 #-}
happyOut161 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Arg TypeSignature])
happyOut161 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut161 #-}
happyIn162 :: (((Maybe (Ranged Induction), Maybe Bool, Maybe (Name, IsInstance)), [Declaration])) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn162 #-}
happyOut162 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (((Maybe (Ranged Induction), Maybe Bool, Maybe (Name, IsInstance)), [Declaration]))
happyOut162 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut162 #-}
happyIn163 :: ([RecordDirective]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn163 #-}
happyOut163 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([RecordDirective])
happyOut163 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut163 #-}
happyIn164 :: (RecordDirective) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn164 #-}
happyOut164 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (RecordDirective)
happyOut164 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut164 #-}
happyIn165 :: (Ranged Bool) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn165 #-}
happyOut165 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Ranged Bool)
happyOut165 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut165 #-}
happyIn166 :: (Ranged Induction) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn166 #-}
happyOut166 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Ranged Induction)
happyOut166 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut166 #-}
happyIn167 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn167 #-}
happyOut167 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut167 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut167 #-}
happyIn168 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn168 #-}
happyOut168 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut168 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut168 #-}
happyIn169 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn169 #-}
happyOut169 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut169 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut169 #-}
happyIn170 :: ([Declaration]) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyIn170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn170 #-}
happyOut170 :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> ([Declaration])
happyOut170 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut170 #-}
happyInTok :: (Token) -> (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84)
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn t13 t14 t15 t38 t41 t44 t45 t46 t54 t55 t84) -> (Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\xd4\x0b\xd4\x0b\xf6\x06\xde\x04\xb6\x0b\x00\x00\x9d\x04\xff\x06\x00\x00\x2c\x07\x00\x00\x00\x00\x00\x00\x00\x00\xf7\x06\x00\x00\x00\x00\xb7\x09\xef\x04\xe8\x06\xd6\x0a\xec\x06\x00\x00\x00\x00\x00\x00\xe5\x06\x00\x00\xb2\x0d\x00\x00\x67\x0d\x00\x00\x00\x00\xf1\x06\x67\x0d\x00\x00\x00\x00\x1b\x03\x9c\x09\x68\x0b\x9a\x07\x4e\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x06\xde\x06\x34\x04\xc6\x00\xea\x06\x51\x01\x68\x0b\xed\x06\x00\x00\x05\x02\xcf\x06\x25\x03\x4e\x0d\x7c\x07\x24\x07\x4e\x09\xcf\x06\xcf\x06\xe7\x06\x00\x00\xda\x06\x1b\x02\xd5\x06\x00\x00\x00\x00\xb2\xff\xb2\xff\x00\x00\xca\x06\xe3\x06\xd9\x06\xb6\x01\xd8\x06\x12\x07\xd1\x06\xc3\x06\xd8\x04\x00\x00\x00\x00\x30\x09\x24\x07\xe2\x08\x22\x0c\x22\x0c\x22\x0c\x00\x00\x20\x01\x4a\x0b\x22\x0c\x22\x0c\x00\x00\x00\x00\xf5\x0a\x22\x0c\xf5\x0a\x00\x00\x6f\x01\xbf\x06\x04\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x06\xb5\x06\xb5\x06\xb9\x06\xab\x06\xab\x06\xab\x06\xac\x06\xac\x06\xc6\xff\xac\x06\xff\xff\x9d\x06\xa8\x06\xa3\x06\xa0\x06\x03\x0d\x93\x06\xe5\x00\x93\x06\xf1\x12\x9c\x06\x00\x00\x00\x00\x49\x08\xf5\x0a\x00\x00\xa2\x06\x00\x00\x66\x0a\xb8\x05\x95\x06\xbd\x05\xf9\x01\x00\x00\xc4\x08\x6c\x08\x51\x08\xd0\x06\xea\x0c\x9b\x06\xea\x0c\x91\x06\xd8\x04\xe2\x06\xe0\x06\x3d\x06\xfd\x09\xf5\x0a\x96\x06\xfd\x09\x00\x00\x22\x0c\x22\x0c\xc6\x00\xf5\x0a\xf5\x0a\x00\x00\x00\x00\xb0\x06\x22\x0c\xea\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf5\x0a\x00\x00\x00\x00\x00\x00\x8a\x06\x00\x00\x22\x0c\xf9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\xf5\x0a\xf5\x0a\x92\x06\xea\x0c\x85\x06\x00\x00\x8d\x06\x00\x00\x00\x00\x7b\x06\x22\x0c\x84\x06\xa7\x06\x61\x01\x7f\x06\x00\x00\x04\x01\xf5\x00\x22\x0c\x7e\x06\x77\x06\x7d\x06\x00\x00\x7c\x06\x00\x00\x22\x0c\x22\x0c\x22\x0c\x00\x00\x22\x0c\x22\x0c\xd7\x0a\x94\x09\x7a\x06\x94\x09\x03\x08\xe8\x07\x89\x0a\x00\x00\x00\x00\x75\x06\x00\x00\x5c\x00\x5e\x06\x61\x06\x61\x06\x61\x06\x61\x06\x61\x06\x61\x06\x61\x06\x61\x06\x61\x06\x5f\x06\x5d\x06\x53\x06\x52\x06\x46\x06\x4e\x06\x3a\x06\x44\x06\x42\x06\x3b\x06\x36\x06\x35\x06\x33\x06\x2f\x06\x30\x06\x2e\x06\x40\x06\x3c\x06\x6e\x0a\xee\x02\xc3\x08\x00\x00\x00\x00\x27\x06\x00\x00\x23\x04\x9f\x0c\x27\x06\x00\x00\xaf\x03\xaf\x03\x00\x00\x00\x00\x00\x00\xd2\x00\x00\x00\xd2\x00\xd2\x00\x00\x00\x75\x01\xaf\x03\xaf\x03\x00\x00\x00\x00\x00\x00\x3d\x06\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x03\x5b\x06\x5a\x06\x00\x00\x00\x00\x00\x00\x22\x0c\x22\x0c\x26\x06\xb2\xff\x2b\x06\x24\x06\xb2\xff\x25\x06\x39\x00\x00\x00\xd8\x04\x00\x00\x00\x00\x6e\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x0a\x00\x00\x00\x00\x86\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x06\x1a\x06\x00\x00\x00\x00\x00\x00\x00\x00\xaf\x03\x6c\x00\xaf\x03\xe7\xff\x00\x00\x8b\x01\x29\x06\x00\x00\x69\x00\x18\x06\x8b\x01\x79\x01\x96\x00\x52\x00\x52\x00\xd2\x00\x00\x00\x00\x00\x00\x00\x43\x06\xdd\xff\xaf\x03\x86\x0c\x24\x00\x06\x07\x00\x00\x1e\x06\x1d\x06\x00\x00\x69\x00\xd9\xff\x22\x0c\xbb\x03\x00\x00\x00\x00\x00\x00\xe7\x05\x68\x00\x68\x00\x00\x00\x00\x00\x6e\x0a\x6e\x0a\x00\x00\x00\x00\x0a\x06\x00\x00\x00\x00\x08\x06\x03\x06\x00\x00\x00\x00\x05\x06\xfa\x05\x00\x00\x00\x00\x00\x00\xfc\x05\xf6\x05\x00\x00\xef\x05\xea\x05\xe2\x05\xdf\x05\xcf\x05\xcf\x05\xcf\x05\xce\x05\xcd\x05\xcd\x05\xc9\x05\xc7\x05\xc5\x05\x00\x00\xc4\x05\xc4\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x69\x00\x05\x01\xf9\x00\x78\x00\xf9\x00\x00\x00\xd2\x05\x20\x0a\x00\x00\x20\x0a\x05\x0a\x00\x00\x00\x00\x00\x00\xd8\x05\xc6\x05\x00\x00\xb3\x05\xd8\x04\x00\x00\x24\x00\x05\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x00\x00\x00\x00\xcc\x05\x00\x00\xc8\x05\xab\x05\x00\x00\xb7\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x05\xb4\x05\xad\x05\xb0\x05\xb0\x05\xaa\x05\xa9\x05\xa5\x05\x00\x00\xa4\x05\xa3\x05\xa0\x05\x00\x00\x9d\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x05\xa7\x05\x64\x00\x9c\x05\x9a\x05\xe1\xff\x00\x00\x8d\x05\x7a\x01\x86\x05\x05\x0a\x00\x00\x76\x05\x05\x0a\x05\x0a\xb2\xff\x00\x00\x00\x00\x7e\x05\x74\x05\xd8\x04\x74\x05\x00\x00\x52\x00\x82\x05\x73\x05\x73\x05\xb2\xff\x00\x00\x73\x05\x73\x05\x00\x00\x73\x05\x73\x05\x7d\x05\x00\x00\x00\x00\x75\x01\x05\x0a\x00\x00\x6e\x05\x05\x0a\x00\x00\x6e\x05\x05\x0a\x00\x00\x00\x00\x00\x00\x24\x00\x00\x00\x9f\x05\x00\x00\x9b\x05\x00\x00\x00\x00\x00\x00\x05\x0a\x6b\x05\xb2\xff\x5e\x05\xb2\xff\x8b\x01\x8b\x01\x00\x00\x00\x00\x3b\x0c\x24\x00\x00\x00\xd8\x04\x24\x00\x00\x00\x00\x00\x00\x00\x99\x05\x00\x00\x05\x05\x55\x05\x00\x00\x70\x05\x6f\x05\x68\x00\x00\x00\x6a\x05\x68\x05\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x05\x53\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\xf4\xff\x2c\x00\x00\x00\x00\x00\x5d\x05\x52\x05\x00\x00\x49\x05\x49\x05\x4d\x05\x58\x05\x75\x05\x00\x00\x00\x00\x4c\x05\x00\x00\x00\x00\x4a\x05\x00\x00\x48\x05\x48\x05\x44\x05\x43\x05\x43\x05\x00\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x37\x05\x00\x00\x00\x00\x42\x05\x00\x00\x40\x05\x00\x00\x24\x00\x00\x00\x00\x00\xb8\x06\x00\x00\x00\x00\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x00\x00\x3e\x05\x3e\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\xff\x00\x00\x00\x00\xd5\x05\x00\x00\x00\x00\x00\x00\x6d\x05\x41\x05\x3c\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x05\x2c\x05\x7c\x05\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x25\x05\x00\x00\x1d\x05\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x38\x05\xef\x12\x42\x03\x69\x05\x40\x03\xcb\x02\x66\x05\x64\x05\x00\x00\x00\x00\x16\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5e\x0b\x0e\x05\x00\x00\xb6\x02\xc4\x04\x00\x00\x00\x00\x00\x00\x57\x05\x00\x00\xcd\x00\x00\x00\x7f\x03\x00\x00\x00\x00\x11\x05\xe0\x03\x00\x00\x00\x00\xb2\x06\xd2\x12\xb5\x12\xa6\x0f\x98\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x0c\x05\x00\x00\x00\x00\x7b\x12\x00\x00\x00\x00\xf9\x04\x00\x00\x00\x00\xe0\x03\x8f\x06\x29\x0e\x6f\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50\x05\x4b\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x04\x30\x02\x00\x00\x00\x00\xcf\x0d\x00\x0e\x4c\x0e\x53\x04\x89\x0f\x76\x0f\x00\x00\x00\x00\x5c\x06\x63\x0f\x50\x0f\x00\x00\x00\x00\x5e\x12\x44\x09\x41\x12\x00\x00\xf9\xff\xf5\x03\x4f\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x04\x47\x05\x46\x05\xaa\x04\x3d\x05\x32\x05\x06\x05\x96\x04\x8f\x04\x21\x00\x84\x04\x30\x02\x0d\x05\x72\x04\x06\x04\xfa\x03\xb5\x00\x8d\x04\x81\x04\x7a\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x24\x12\x00\x00\x00\x00\x00\x00\xbe\x06\x00\x00\x00\x00\x3e\x01\x61\x00\x00\x00\x5c\x06\x90\x05\x03\x00\x40\x04\xba\x02\x00\x00\xb3\x02\x00\x00\x1a\x01\x00\x00\x00\x00\x38\x03\xfe\x06\x07\x12\x00\x00\x3c\x03\x00\x00\x3d\x0f\x2a\x0f\x41\x04\xea\x11\xcd\x11\x00\x00\x00\x00\x3f\x04\x90\x07\xf5\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x02\x73\x04\x00\x00\x00\x00\x00\x00\x00\x00\x77\x04\x93\x11\x76\x11\x00\x00\xdf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x01\xd8\x08\x04\x04\x21\x04\x00\x00\x00\x00\x00\x00\x3a\x04\x2d\x04\xeb\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\x02\x17\x0f\x04\x0f\x00\x00\xf1\x0e\xde\x0e\xa5\x01\x02\x06\x00\x00\xf9\x03\x5c\x06\x28\x05\xcb\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x04\x2b\x04\x20\x04\x09\x04\x03\x04\xfc\x03\xee\x03\xec\x03\xe5\x03\xe2\x03\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x03\xdb\x03\x00\x00\x00\x00\x00\x00\xda\x03\xc4\x03\x27\x00\xb1\x03\x00\x00\x70\x04\x00\x00\x00\x00\x59\x11\xa4\x03\xbc\x06\x00\x00\x00\x00\x04\x00\x00\x00\xff\x01\x36\x01\x9c\x03\x00\x00\x79\x06\x09\x06\x00\x00\x00\x00\x00\x00\xaf\x02\x00\x00\x88\x02\xd9\x01\x00\x00\xfb\xff\xa1\x05\x39\x05\x00\x00\x00\x00\x00\x00\xae\x02\x00\x00\x00\x00\x00\x00\x00\x00\xfc\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x0e\xa5\x0e\x00\x00\x95\x03\x00\x00\x00\x00\x81\x03\x00\x00\x00\x00\x00\x00\xfc\x01\x00\x00\x00\x00\x3c\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x11\x00\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x03\xb9\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x4f\x02\x00\x00\x00\x00\x19\x04\x00\x00\x00\x00\x26\x04\xe5\x02\xf2\x03\x6d\x03\x65\x03\x29\x05\x9d\x03\x70\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x00\xac\x00\xae\x08\xa6\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x16\x04\x00\x00\x92\x0e\x0f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x03\x62\x03\x00\x00\x00\x00\x02\x11\xe5\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x02\xbf\x02\x00\x00\x00\x00\x3e\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2e\x03\x00\x00\x09\x03\x00\x03\xf3\x02\xcd\x02\xe9\x02\xdd\x02\x00\x00\x00\x00\xcc\x02\x00\x00\xc1\x02\xa4\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x03\x00\x00\xce\x02\x00\x00\xbb\x02\x00\x00\x00\x00\x19\x01\x00\x00\x8e\x00\xc8\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x01\x00\x00\x3f\x08\xab\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x95\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x02\x80\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\x01\x00\x00\x00\x00\xf4\x01\x00\x00\xb7\x00\x00\x00\xc6\x01\x71\x10\x00\x00\x41\x00\x54\x10\x37\x10\x25\x02\x00\x00\x00\x00\x00\x00\xe0\x02\x29\x00\xd6\x02\x00\x00\x2f\x02\x00\x00\x53\x02\x43\x02\xfb\x01\x00\x00\x61\x03\x39\x03\x00\x00\x1a\x03\x12\x03\x00\x00\x00\x00\x00\x00\x41\x02\x1a\x10\x00\x00\x63\x02\xfd\x0f\x00\x00\x1c\x02\xe0\x0f\x00\x00\x00\x00\x00\x00\x9b\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x0f\x00\x00\xe2\x01\x00\x00\xd0\x01\xc9\x03\x7d\x03\x00\x00\x00\x00\x43\x00\x66\x07\x00\x00\x26\x00\x32\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x01\x68\x01\x00\x00\x00\x00\x00\x00\x22\x02\x00\x00\x00\x00\x00\x00\x07\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x02\x27\x02\x15\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x01\x5a\x01\x00\x00\x00\x00\x00\x00\x13\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\x00\xef\x00\x00\x00\xbe\x00\xae\x00\x00\x00\x00\x00\xdb\x01\x00\x00\x00\x00\x00\x00\xc9\x00\x00\x00\xc3\x00\x00\x00\x00\x00\x0e\x00\x00\x00\x08\x00\x00\x00\x29\x04\x00\x00\x00\x00\xa6\x0f\x00\x00\x00\x00\x79\x03\xd7\x02\xbc\x02\x4d\x02\x00\x00\x14\x01\x59\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x00\x00\x00\x00\x00\x24\x02\x00\x00\x00\x00\x00\x00\x9a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x35\x00\x9d\x01\x00\x00\x00\x00\x00\x00\x00\x00\xfa\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x37\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\xf7\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf9\xff\x6c\xff\x43\xff\xc9\xfe\x57\xff\x55\xff\x54\xff\x51\xff\x00\x00\x2f\xff\x2e\xff\x4e\xff\xa6\xfe\x00\x00\x00\x00\x00\x00\x3f\xff\x3d\xff\x3b\xff\x00\x00\x3c\xff\x00\x00\x3e\xff\x00\x00\x3a\xff\x39\xff\xcd\xfe\x00\x00\x40\xff\x41\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\xff\x6d\xff\x42\xff\x6c\xff\x6b\xff\x00\x00\x00\x00\x78\xfe\xc7\xfe\x58\xff\x00\x00\x00\x00\x00\x00\x20\xff\x1e\xff\x00\x00\x00\x00\x00\x00\x78\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x66\xff\x00\x00\x65\xff\x00\x00\x44\xff\x34\xff\x00\x00\x00\x00\x82\xff\x00\x00\x00\x00\x00\x00\x64\xff\x00\x00\x00\x00\x00\x00\x00\x00\x79\xfe\x35\xff\x32\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\xff\x00\x00\x78\xfe\x00\x00\x00\x00\x21\xff\x5b\xff\x00\x00\x00\x00\x00\x00\xc3\xfe\x00\x00\x00\x00\x1a\xfe\xc1\xfe\xc0\xfe\xbf\xfe\xbe\xfe\xbd\xfe\xbc\xfe\xc2\xfe\xbb\xfe\xba\xfe\xb9\xfe\xb8\xfe\xb7\xfe\xb6\xfe\xb5\xfe\xae\xfe\xb0\xfe\xaf\xfe\xb4\xfe\xb3\xfe\xb2\xfe\x8d\xff\xb1\xfe\x6a\xfe\x50\xfe\x69\xfe\x68\xfe\x67\xfe\x66\xfe\x64\xfe\x63\xfe\x65\xfe\x62\xfe\x61\xfe\x60\xfe\x5f\xfe\x5e\xfe\x5d\xfe\x5c\xfe\x53\xfe\x56\xfe\x57\xfe\x58\xfe\x55\xfe\x54\xfe\x5b\xfe\x5a\xfe\x59\xfe\x52\xfe\x51\xfe\x18\xfe\x6b\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6a\xff\xee\xfe\x04\xff\x00\x00\x48\xff\x00\x00\x0f\xff\x0c\xff\x05\xff\x00\x00\x00\x00\x00\x00\x69\xff\x78\xfe\x00\x00\x00\x00\xc9\xfe\x00\x00\x4c\xff\x47\xff\x00\x00\x2d\xff\x00\x00\x00\x00\x78\xfe\xf3\xfe\x00\x00\x00\x00\xf4\xfe\xef\xfe\x00\x00\x00\x00\xc7\xfe\x00\x00\x00\x00\x53\xff\x46\xff\xcb\xfe\x00\x00\x00\x00\xf8\xff\xf6\xff\xf5\xff\xf4\xff\xf3\xff\xf2\xff\xf1\xff\xf0\xff\xef\xff\xee\xff\xed\xff\xec\xff\xeb\xff\xea\xff\xe9\xff\xe8\xff\xe7\xff\xe6\xff\xe5\xff\xe4\xff\xe3\xff\xe2\xff\xe1\xff\xe0\xff\xdf\xff\xde\xff\xdd\xff\xdc\xff\xdb\xff\xda\xff\xd9\xff\xd8\xff\xd7\xff\xd6\xff\xd5\xff\xd4\xff\xd3\xff\xd2\xff\xd1\xff\xd0\xff\xcf\xff\xce\xff\xcd\xff\xcc\xff\xcb\xff\xca\xff\xc9\xff\xc8\xff\xc7\xff\xc6\xff\xc5\xff\xc4\xff\xc3\xff\xc2\xff\xc1\xff\xc0\xff\xbf\xff\xbe\xff\xbd\xff\xbc\xff\xbb\xff\xba\xff\xb9\xff\xb8\xff\xb7\xff\xb6\xff\xb5\xff\xb4\xff\xb3\xff\xb2\xff\xb1\xff\xb0\xff\xaf\xff\xae\xff\xad\xff\xac\xff\xab\xff\xaa\xff\xa9\xff\xa8\xff\xa7\xff\xa6\xff\xa5\xff\xa4\xff\xa3\xff\xa2\xff\xa1\xff\xa0\xff\x9f\xff\x9e\xff\x9d\xff\x9c\xff\x9b\xff\x9a\xff\x99\xff\x98\xff\x97\xff\x96\xff\x95\xff\x94\xff\x93\xff\x92\xff\x91\xff\x90\xff\x8f\xff\x33\xff\xc8\xfe\xcf\xfe\x00\x00\xa8\xfe\xa7\xfe\xa9\xfe\x66\xff\x65\xff\x4e\xff\x00\x00\xf6\xfe\xf7\xfe\x50\xff\xf5\xfe\x00\x00\x00\x00\x00\x00\x6c\xff\x74\xfe\x00\x00\x2c\xff\x2b\xff\x28\xff\x29\xff\x26\xff\x00\x00\xcd\xfe\xcb\xfe\xfe\xfe\x00\x00\xf8\xfe\x00\x00\x00\x00\x00\x00\x02\xff\x00\x00\x01\xff\x64\xff\x03\xff\xed\xfe\x00\x00\x00\x00\x00\x00\xec\xfe\x00\x00\x00\x00\x00\x00\x0b\xff\x07\xff\x0c\xff\x78\xfe\x00\x00\x00\x00\x10\xff\x52\xff\x06\xff\x36\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x60\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\xff\x00\x00\x60\xff\x00\x00\x00\x00\x83\xff\x00\x00\x00\x00\x00\x00\x00\x00\xf0\xfe\x95\xfe\x91\xfe\x00\x00\x92\xfe\x8b\xfe\x74\xfe\x00\x00\x97\xfe\xf0\xfe\xf0\xfe\x6c\xfe\x93\xfe\x94\xfe\x00\x00\x86\xff\x00\x00\x00\x00\x98\xfe\x00\x00\xf0\xfe\xf0\xfe\x96\xfe\x8e\xff\x8c\xff\x78\xfe\x89\xff\x88\xff\x1c\xfe\xc6\xfe\x00\x00\x00\x00\x00\x00\x59\xff\x56\xff\x5a\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\xff\x00\x00\x17\xff\x37\xff\x00\x00\x81\xff\x16\xff\x38\xff\x15\xff\x45\xff\x00\x00\x12\xff\x11\xff\x74\xfe\x13\xff\x1d\xff\x1b\xff\x1c\xff\x1a\xff\x18\xff\x19\xff\x00\x00\x00\x00\x1d\xfe\x8a\xff\x8b\xff\x1b\xfe\xf0\xfe\x00\x00\xf0\xfe\x00\x00\x7e\xff\x7a\xff\x00\x00\x2c\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x67\xff\x9b\xfe\x9a\xfe\x99\xfe\x00\x00\x00\x00\xf0\xfe\x74\xfe\xe3\xfe\x00\x00\x8a\xfe\x00\x00\x00\x00\x2f\xfe\x00\x00\x00\x00\x26\xff\x00\x00\x87\xfe\x85\xfe\x80\xfe\x00\x00\x00\x00\x00\x00\x7a\xfe\x90\xfe\x00\x00\x00\x00\x84\xff\x3c\xfe\x00\x00\x5d\xff\x5c\xff\x00\x00\x60\xff\x34\xfe\x5e\xff\x00\x00\x63\xff\x3d\xfe\x36\xfe\x3e\xfe\x00\x00\x00\x00\x37\xfe\x00\x00\x00\x00\x63\xff\x00\x00\x63\xff\x63\xff\x63\xff\x00\x00\x63\xff\x63\xff\x00\x00\x00\x00\x63\xff\x3a\xfe\x00\x00\x00\x00\x09\xff\x08\xff\x0a\xff\x0e\xff\x0d\xff\xfe\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfd\xfe\x00\x00\x00\x00\x4a\xff\x00\x00\x00\x00\xce\xfe\xcc\xfe\x4b\xff\x00\x00\x00\x00\x25\xff\x24\xff\x00\x00\x31\xff\xe3\xfe\x00\x00\x4d\xff\x4f\xff\x1e\xfe\xea\xfe\xeb\xfe\xca\xfe\x22\xff\x27\xff\xe5\xfe\xe3\xfe\xe1\xfe\xe0\xfe\xdf\xfe\x00\x00\xe2\xfe\x00\x00\x00\x00\x2a\xff\x00\x00\x30\xff\x00\xff\xfc\xfe\xfb\xfe\xf9\xfe\xfa\xfe\x00\x00\xe8\xfe\xe9\xfe\xe6\xfe\xe7\xfe\x49\xff\x00\x00\x00\x00\x00\x00\x63\xff\x63\xff\x00\x00\x00\x00\x00\x00\x61\xff\x00\x00\x00\x00\x00\x00\x42\xfe\x00\x00\x39\xfe\x38\xfe\x40\xfe\x3b\xfe\x62\xff\x4f\xfe\x00\x00\x5f\xff\x4c\xfe\x41\xfe\x8e\xfe\x8f\xfe\x00\x00\x7d\xfe\x00\x00\x00\x00\x7d\xfe\x00\x00\x86\xfe\x00\x00\x6c\xff\x00\x00\x00\x00\x31\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x76\xfe\x73\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x68\xff\x7c\xff\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xff\x00\x00\x00\x00\x80\xff\x00\x00\x00\x00\x00\x00\xaa\xfe\x2e\xfe\x00\x00\x00\x00\x7b\xff\x00\x00\x00\x00\xf2\xfe\x00\x00\x00\x00\xf1\xfe\xc5\xfe\xc4\xfe\xe3\xfe\x77\xfe\x00\x00\xa2\xfe\xa1\xfe\xa3\xfe\xac\xfe\x2d\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\xff\x76\xff\x7d\xff\x6d\xfe\x74\xfe\xe3\xfe\x6e\xfe\x00\x00\xe3\xfe\x8c\xfe\xad\xfe\x30\xfe\x9e\xfe\x9f\xfe\x28\xfe\x8d\xfe\x89\xfe\x00\x00\x00\x00\x00\x00\x83\xfe\x00\x00\x00\x00\x00\x00\x84\xfe\x33\xfe\x35\xfe\x32\xfe\x3f\xfe\x44\xfe\x48\xfe\x45\xfe\x4a\xfe\x46\xfe\x49\xfe\x00\x00\x00\x00\x4b\xfe\x4d\xfe\x4e\xfe\xff\xfe\x23\xff\xd3\xfe\x87\xff\xd3\xfe\xe4\xfe\xd5\xfe\xd1\xfe\x00\x00\xd2\xfe\x00\x00\x00\x00\x00\x00\xd9\xfe\x00\x00\x87\xff\xdb\xfe\x00\x00\x47\xfe\x43\xfe\x00\x00\x7d\xfe\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\xfe\x25\xfe\x00\x00\x26\xfe\x23\xfe\x24\xfe\x00\x00\x1f\xfe\x00\x00\x22\xfe\x20\xfe\x00\x00\x21\xfe\x00\x00\x75\xfe\xe3\xfe\x70\xfe\x71\xfe\x00\x00\x77\xff\x79\xff\x72\xff\x74\xff\x6e\xff\x70\xff\xab\xfe\x00\x00\x00\x00\xa4\xfe\xa5\xfe\x71\xff\x6f\xff\x75\xff\x73\xff\x00\x00\x6f\xfe\xa0\xfe\x78\xfe\x9d\xfe\x29\xfe\x2b\xfe\x78\xfe\x00\x00\x00\x00\x81\xfe\x7c\xfe\x7b\xfe\x82\xfe\xde\xfe\x00\x00\x00\x00\x87\xff\xdc\xfe\xd7\xfe\xd4\xfe\xdd\xfe\x00\x00\xd0\xfe\xda\xfe\xd8\xfe\xd6\xfe\x7e\xfe\x7f\xfe\x27\xfe\x00\x00\x00\x00\x72\xfe\x00\x00\x2a\xfe\x9c\xfe"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x05\x00\x09\x00\x09\x00\x09\x00\x09\x00\x2d\x00\x0c\x00\x14\x00\x0e\x00\x2d\x00\x0f\x00\x09\x00\x09\x00\x0a\x00\x5d\x00\x00\x00\x5f\x00\x0f\x00\x14\x00\x2d\x00\x09\x00\x13\x00\x14\x00\x52\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x50\x00\x09\x00\x65\x00\x66\x00\x09\x00\x51\x00\x09\x00\x0f\x00\x10\x00\x09\x00\x52\x00\x31\x00\x0f\x00\x10\x00\x50\x00\x0f\x00\x10\x00\x37\x00\x38\x00\x05\x00\x3a\x00\x09\x00\x18\x00\x14\x00\x1d\x00\x1b\x00\x49\x00\x0b\x00\x4b\x00\x65\x00\x23\x00\x4c\x00\x09\x00\x09\x00\x0a\x00\x09\x00\x59\x00\x52\x00\x54\x00\x2c\x00\x55\x00\x0f\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x53\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x65\x00\x66\x00\x23\x00\x24\x00\x25\x00\x00\x00\x09\x00\x6f\x00\x70\x00\x0b\x00\x75\x00\x73\x00\x74\x00\x61\x00\x11\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x09\x00\x8d\x00\x65\x00\x59\x00\x98\x00\x53\x00\x0f\x00\x75\x00\x09\x00\x72\x00\x2d\x00\x96\x00\x72\x00\xa0\x00\x0f\x00\x09\x00\x4d\x00\x4e\x00\x99\x00\x46\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x9e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x71\x00\x09\x00\x52\x00\x65\x00\x4f\x00\x09\x00\x09\x00\x0f\x00\x50\x00\x55\x00\x09\x00\x0f\x00\x2b\x00\x2c\x00\x11\x00\x67\x00\x0f\x00\x37\x00\x38\x00\x39\x00\x50\x00\x65\x00\x61\x00\x62\x00\x09\x00\x65\x00\x05\x00\x23\x00\x24\x00\x25\x00\x4c\x00\x23\x00\x24\x00\x25\x00\x09\x00\x5f\x00\x52\x00\x24\x00\x14\x00\x55\x00\x0f\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x30\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x3d\x00\x3e\x00\x3f\x00\x24\x00\x5c\x00\x2d\x00\x5e\x00\x6f\x00\x70\x00\x9e\x00\x9f\x00\x73\x00\x74\x00\x65\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x09\x00\x07\x00\x8d\x00\x6e\x00\x71\x00\x09\x00\x0f\x00\x69\x00\x71\x00\x09\x00\x09\x00\x52\x00\x6e\x00\xa0\x00\xa1\x00\x0f\x00\x0f\x00\x10\x00\x09\x00\x6e\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x51\x00\x65\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\x26\x00\x27\x00\x28\x00\x29\x00\x4f\x00\x0f\x00\x2c\x00\x09\x00\x64\x00\x50\x00\x65\x00\x67\x00\x2a\x00\x2b\x00\x2c\x00\x11\x00\x37\x00\x38\x00\x39\x00\x4f\x00\x5f\x00\x50\x00\x5d\x00\x62\x00\x5f\x00\x23\x00\x24\x00\x25\x00\x4c\x00\x6e\x00\x49\x00\x4a\x00\x4b\x00\x6e\x00\x52\x00\x09\x00\x5f\x00\x55\x00\x62\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x58\x00\x09\x00\x6b\x00\x6c\x00\x5c\x00\x6e\x00\x5e\x00\x6f\x00\x70\x00\x11\x00\x12\x00\x73\x00\x74\x00\x10\x00\x11\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x09\x00\x07\x00\x54\x00\x8d\x00\x71\x00\x57\x00\x0f\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x09\x00\xa0\x00\x50\x00\x9e\x00\x9f\x00\x0f\x00\x0f\x00\x10\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x5f\x00\x52\x00\x4d\x00\x4e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x51\x00\x09\x00\x27\x00\x28\x00\x29\x00\x56\x00\x5c\x00\x2c\x00\x5e\x00\x65\x00\x5c\x00\x6e\x00\x5e\x00\x4d\x00\x4e\x00\x65\x00\x0b\x00\x37\x00\x38\x00\x65\x00\x3a\x00\x05\x00\x06\x00\x09\x00\x46\x00\x47\x00\x48\x00\x4c\x00\x5c\x00\x09\x00\x5e\x00\x11\x00\x12\x00\x52\x00\x0b\x00\x0f\x00\x55\x00\x65\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x23\x00\x24\x00\x25\x00\x09\x00\x0b\x00\x51\x00\x09\x00\x6f\x00\x70\x00\x0f\x00\x10\x00\x73\x00\x74\x00\x59\x00\x11\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x09\x00\x07\x00\x30\x00\x0b\x00\x09\x00\x8d\x00\x0f\x00\x35\x00\x9b\x00\x9c\x00\x9d\x00\x09\x00\x09\x00\xa0\x00\x0c\x00\x0d\x00\x3e\x00\x3f\x00\x0f\x00\x10\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\x52\x00\x09\x00\x0c\x00\x09\x00\x0e\x00\x71\x00\x58\x00\x4d\x00\x4e\x00\x0f\x00\x5c\x00\x09\x00\x5e\x00\x09\x00\x0c\x00\x15\x00\x0e\x00\x09\x00\x58\x00\x65\x00\x99\x00\x11\x00\x5c\x00\x6e\x00\x5e\x00\x1f\x00\x20\x00\x21\x00\x68\x00\x23\x00\x24\x00\x25\x00\x6e\x00\x51\x00\x46\x00\x47\x00\x48\x00\x4c\x00\x49\x00\x4a\x00\x4b\x00\x6d\x00\x6e\x00\x52\x00\x32\x00\x5d\x00\x55\x00\x5f\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x30\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x3d\x00\x3e\x00\x3f\x00\x6d\x00\x6e\x00\x09\x00\x94\x00\x6f\x00\x70\x00\x54\x00\x16\x00\x73\x00\x74\x00\x11\x00\x12\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x09\x00\x09\x00\x16\x00\x9e\x00\x9f\x00\x09\x00\x0f\x00\x1a\x00\x09\x00\x11\x00\x12\x00\x0f\x00\x09\x00\xa0\x00\x09\x00\x0b\x00\x11\x00\x0c\x00\x0f\x00\x0e\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\x22\x00\x23\x00\x24\x00\x25\x00\x0b\x00\x0f\x00\x1a\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\x09\x00\x16\x00\x0c\x00\x17\x00\x0e\x00\x30\x00\x0f\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x3b\x00\x3c\x00\x16\x00\x3e\x00\x3f\x00\x18\x00\x1f\x00\x20\x00\x21\x00\x4c\x00\x23\x00\x24\x00\x25\x00\x09\x00\x16\x00\x52\x00\x9e\x00\x9f\x00\x55\x00\x0f\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x16\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x16\x00\x4c\x00\x23\x00\x24\x00\x25\x00\x09\x00\x0a\x00\x6f\x00\x70\x00\x16\x00\x55\x00\x73\x00\x74\x00\x09\x00\x0a\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x09\x00\x09\x00\x0a\x00\x16\x00\x09\x00\x58\x00\x0f\x00\x2d\x00\x09\x00\x5c\x00\x09\x00\x5e\x00\x11\x00\xa0\x00\x0f\x00\x10\x00\x0f\x00\x93\x00\x65\x00\x16\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x4d\x00\x4e\x00\x09\x00\x0a\x00\x30\x00\x52\x00\x09\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x58\x00\x9e\x00\x9f\x00\x09\x00\x5c\x00\x3c\x00\x5e\x00\x3e\x00\x3f\x00\x97\x00\x58\x00\x9e\x00\x9f\x00\x65\x00\x5c\x00\x09\x00\x5e\x00\x4c\x00\x0c\x00\x09\x00\x0e\x00\x09\x00\x0c\x00\x52\x00\x0e\x00\x0b\x00\x55\x00\x0f\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x51\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x0b\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\x09\x00\x6f\x00\x70\x00\x0c\x00\x0d\x00\x73\x00\x74\x00\x05\x00\x06\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x1a\x00\x00\x00\x01\x00\x02\x00\x6d\x00\x6e\x00\x05\x00\x09\x00\x07\x00\x08\x00\x0c\x00\x0a\x00\x0e\x00\xa0\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x19\x00\x12\x00\x13\x00\x14\x00\x15\x00\x1a\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\x16\x00\x25\x00\x26\x00\x27\x00\x19\x00\x29\x00\x2a\x00\x2b\x00\x6d\x00\x6e\x00\x18\x00\x09\x00\x4d\x00\x4e\x00\x0c\x00\x1a\x00\x0e\x00\x52\x00\x09\x00\x23\x00\x24\x00\x25\x00\x1a\x00\x58\x00\x1a\x00\x09\x00\x11\x00\x5c\x00\x51\x00\x5e\x00\x6a\x00\x6b\x00\x6c\x00\x11\x00\x6e\x00\x58\x00\x65\x00\x49\x00\x1a\x00\x5c\x00\x4c\x00\x5e\x00\x4e\x00\x05\x00\x06\x00\x1a\x00\x52\x00\x53\x00\x65\x00\x55\x00\x09\x00\x1a\x00\x58\x00\x0c\x00\x5a\x00\x0e\x00\x5c\x00\x30\x00\x5e\x00\x05\x00\x06\x00\x61\x00\x35\x00\x63\x00\x30\x00\x65\x00\x66\x00\x06\x00\x68\x00\x01\x00\x02\x00\x3e\x00\x3f\x00\x05\x00\x1a\x00\x07\x00\x08\x00\x3d\x00\x3e\x00\x3f\x00\x06\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x1a\x00\x12\x00\x13\x00\x14\x00\x15\x00\x1a\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x4d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x9e\x00\x9f\x00\x25\x00\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x9e\x00\x9f\x00\x0f\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x15\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x4e\x00\x4d\x00\x4e\x00\x1f\x00\x20\x00\x21\x00\x52\x00\x23\x00\x24\x00\x25\x00\x09\x00\x0a\x00\x58\x00\x05\x00\x49\x00\x0b\x00\x5c\x00\x4c\x00\x5e\x00\x4e\x00\x09\x00\x0a\x00\x32\x00\x52\x00\x53\x00\x65\x00\x55\x00\x09\x00\x0a\x00\x58\x00\x4e\x00\x5a\x00\x4f\x00\x5c\x00\x50\x00\x5e\x00\x9e\x00\x9f\x00\x61\x00\x09\x00\x63\x00\x9e\x00\x65\x00\x66\x00\x95\x00\x68\x00\x69\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x08\x00\x0a\x00\x9e\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x09\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x9e\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x2f\x00\x30\x00\x25\x00\x26\x00\x27\x00\x9e\x00\x29\x00\x2a\x00\x2b\x00\x09\x00\x09\x00\x0b\x00\x9e\x00\x0c\x00\x0d\x00\x0f\x00\x00\x00\x01\x00\x08\x00\x13\x00\x14\x00\x65\x00\x66\x00\x50\x00\x51\x00\x97\x00\x09\x00\x65\x00\x66\x00\x08\x00\x9e\x00\x1f\x00\x20\x00\x21\x00\x11\x00\x23\x00\x24\x00\x25\x00\x49\x00\x09\x00\x09\x00\x4c\x00\x04\x00\x4e\x00\x9e\x00\x06\x00\x0b\x00\x52\x00\x53\x00\x31\x00\x55\x00\x0b\x00\x50\x00\x58\x00\x4d\x00\x5a\x00\x09\x00\x5c\x00\x9e\x00\x5e\x00\x56\x00\x4f\x00\x02\x00\x01\x00\x63\x00\x30\x00\x65\x00\x66\x00\x03\x00\x68\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x3d\x00\x3e\x00\x3f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x61\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x65\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x14\x00\x65\x00\x25\x00\x26\x00\x27\x00\x59\x00\x29\x00\x2a\x00\x2b\x00\x09\x00\x59\x00\x0b\x00\x65\x00\x28\x00\x60\x00\x0f\x00\x60\x00\x5d\x00\x60\x00\x13\x00\x14\x00\x59\x00\x59\x00\x4f\x00\x65\x00\x5f\x00\x09\x00\x59\x00\x4f\x00\x65\x00\x65\x00\x1f\x00\x20\x00\x21\x00\x11\x00\x23\x00\x24\x00\x25\x00\x49\x00\x64\x00\x64\x00\x4c\x00\x65\x00\x4e\x00\x54\x00\x5f\x00\x54\x00\x52\x00\x53\x00\x31\x00\x55\x00\x54\x00\x54\x00\x58\x00\x2d\x00\x5a\x00\x2d\x00\x5c\x00\x5f\x00\x5e\x00\x2d\x00\x50\x00\x60\x00\x51\x00\x63\x00\x30\x00\x65\x00\x66\x00\x60\x00\x68\x00\x01\x00\x02\x00\x65\x00\x04\x00\x05\x00\x65\x00\x07\x00\x08\x00\x3d\x00\x3e\x00\x3f\x00\x5f\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x60\x00\x12\x00\x13\x00\x14\x00\x15\x00\x51\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x65\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x51\x00\x5d\x00\x25\x00\x26\x00\x27\x00\x5f\x00\x29\x00\x2a\x00\x2b\x00\x64\x00\x4f\x00\x58\x00\x64\x00\x4d\x00\x4e\x00\x64\x00\x64\x00\x64\x00\x52\x00\x09\x00\x54\x00\x64\x00\x64\x00\x52\x00\x58\x00\x64\x00\x09\x00\x11\x00\x5c\x00\x58\x00\x5e\x00\x67\x00\x64\x00\x5c\x00\x11\x00\x5e\x00\x65\x00\x65\x00\x49\x00\x64\x00\x58\x00\x4c\x00\x65\x00\x4e\x00\x58\x00\x5f\x00\x54\x00\x52\x00\x53\x00\x51\x00\x55\x00\x67\x00\x67\x00\x58\x00\x67\x00\x5a\x00\x67\x00\x5c\x00\x30\x00\x5e\x00\x67\x00\x67\x00\x67\x00\x35\x00\x63\x00\x30\x00\x65\x00\x66\x00\x55\x00\x68\x00\x01\x00\x02\x00\x3e\x00\x3f\x00\x05\x00\x64\x00\x07\x00\x08\x00\x3d\x00\x3e\x00\x3f\x00\x67\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x64\x00\x12\x00\x13\x00\x14\x00\x15\x00\x64\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x64\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x64\x00\x67\x00\x25\x00\x26\x00\x27\x00\x09\x00\x29\x00\x2a\x00\x2b\x00\x64\x00\x67\x00\x0f\x00\x64\x00\x50\x00\x64\x00\x51\x00\x2d\x00\x15\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x60\x00\x50\x00\x60\x00\x1f\x00\x20\x00\x21\x00\x59\x00\x23\x00\x24\x00\x25\x00\x09\x00\x5f\x00\x59\x00\x5f\x00\x49\x00\x2d\x00\x2d\x00\x4c\x00\x11\x00\x4e\x00\x65\x00\x51\x00\x32\x00\x52\x00\x53\x00\x51\x00\x55\x00\x65\x00\x64\x00\x58\x00\x67\x00\x5a\x00\x09\x00\x5c\x00\x67\x00\x5e\x00\x67\x00\x67\x00\x0f\x00\x64\x00\x63\x00\x67\x00\x65\x00\x66\x00\x15\x00\x68\x00\x64\x00\x30\x00\x64\x00\x30\x00\x64\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x67\x00\x3d\x00\x3e\x00\x3f\x00\x67\x00\x67\x00\x09\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x08\x00\x32\x00\x64\x00\x11\x00\x67\x00\x09\x00\x67\x00\x09\x00\x67\x00\x54\x00\x12\x00\x6f\x00\x70\x00\x11\x00\x54\x00\x11\x00\x54\x00\x54\x00\x54\x00\x54\x00\x1c\x00\x2e\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x57\x00\x4f\x00\x25\x00\x2e\x00\x27\x00\x65\x00\x29\x00\x30\x00\x51\x00\x5f\x00\x33\x00\x34\x00\x35\x00\x36\x00\x5f\x00\x54\x00\x0b\x00\x30\x00\x0b\x00\x30\x00\x5e\x00\x3e\x00\x3f\x00\x57\x00\x35\x00\x24\x00\x60\x00\x54\x00\x5b\x00\x65\x00\x3d\x00\x3e\x00\x3f\x00\x3e\x00\x3f\x00\x6f\x00\x70\x00\x60\x00\x49\x00\x65\x00\x60\x00\x4c\x00\x4d\x00\x4e\x00\x09\x00\x60\x00\x09\x00\x52\x00\x53\x00\x60\x00\x55\x00\x08\x00\x11\x00\x58\x00\x11\x00\x5a\x00\x68\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x12\x00\x60\x00\x65\x00\x60\x00\x0a\x00\x65\x00\x66\x00\x60\x00\x68\x00\x61\x00\x1c\x00\x60\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x5f\x00\x59\x00\x25\x00\x08\x00\x27\x00\x30\x00\x29\x00\x30\x00\x59\x00\x59\x00\x50\x00\x5f\x00\x35\x00\x12\x00\x50\x00\x69\x00\x5f\x00\x3c\x00\x51\x00\x3e\x00\x3f\x00\x3e\x00\x3f\x00\x1c\x00\x54\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x69\x00\x57\x00\x25\x00\x65\x00\x27\x00\x60\x00\x29\x00\x57\x00\x49\x00\x24\x00\x69\x00\x4c\x00\x4d\x00\x4e\x00\x56\x00\x60\x00\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x49\x00\x68\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x12\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\x59\x00\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x65\x00\x66\x00\x49\x00\x68\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x65\x00\x66\x00\xff\xff\x68\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\x59\x00\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\x4d\x00\x4e\x00\xff\xff\xff\xff\x49\x00\x52\x00\xff\xff\x54\x00\xff\xff\x4e\x00\xff\xff\x58\x00\xff\xff\x52\x00\x53\x00\x5c\x00\x55\x00\x5e\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x65\x00\x5e\x00\x5f\x00\xff\xff\xff\xff\xff\xff\x63\x00\x49\x00\x65\x00\x66\x00\xff\xff\x68\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x08\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x12\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\x49\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\x4e\x00\xff\xff\xff\xff\x52\x00\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\x58\x00\x58\x00\x59\x00\x5a\x00\x5c\x00\x5c\x00\x5e\x00\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x65\x00\x66\x00\x49\x00\x68\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\x5f\x00\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\x59\x00\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x49\x00\x68\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\x5f\x00\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\x4d\x00\x4e\x00\xff\xff\xff\xff\x49\x00\x52\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\x58\x00\xff\xff\x52\x00\x53\x00\x5c\x00\x55\x00\x5e\x00\xff\xff\x58\x00\x59\x00\x5a\x00\xff\xff\x5c\x00\x65\x00\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x65\x00\x66\x00\xff\xff\x68\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\x54\x00\x55\x00\x08\x00\x57\x00\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\x4d\x00\x4e\x00\xff\xff\xff\xff\x49\x00\x52\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\x58\x00\xff\xff\x52\x00\x53\x00\x5c\x00\x55\x00\x5e\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x65\x00\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x65\x00\x66\x00\xff\xff\x68\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\x12\x00\xff\xff\xff\xff\x63\x00\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x08\x00\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\x4d\x00\x4e\x00\xff\xff\xff\xff\x49\x00\x52\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\x58\x00\xff\xff\x52\x00\x53\x00\x5c\x00\x55\x00\x5e\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x65\x00\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x65\x00\x66\x00\xff\xff\x68\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\x5f\x00\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\x49\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\x4e\x00\xff\xff\xff\xff\x52\x00\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\x58\x00\x58\x00\xff\xff\x5a\x00\x5c\x00\x5c\x00\x5e\x00\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x63\x00\x65\x00\x65\x00\x66\x00\x49\x00\x68\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\x08\x00\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x12\x00\x68\x00\xff\xff\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x09\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x0f\x00\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x49\x00\x68\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x08\x00\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\x49\x00\xff\xff\xff\xff\x4c\x00\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x49\x00\x68\x00\xff\xff\xff\xff\x4d\x00\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\x08\x00\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\x12\x00\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\x27\x00\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\x55\x00\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x65\x00\x66\x00\x4e\x00\x68\x00\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x1c\x00\x68\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x65\x00\x66\x00\x4e\x00\x68\x00\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x1c\x00\x68\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x65\x00\x66\x00\x4e\x00\x68\x00\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x1c\x00\x68\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\xff\xff\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4e\x00\xff\xff\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\x49\x00\xff\xff\xff\xff\x65\x00\x66\x00\x4e\x00\x68\x00\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\x58\x00\xff\xff\x5a\x00\xff\xff\x5c\x00\xff\xff\x5e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x65\x00\x66\x00\x1c\x00\x68\x00\x1e\x00\x1f\x00\xff\xff\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x09\x00\xff\xff\xff\xff\x29\x00\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x15\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x4e\x00\x32\x00\xff\xff\xff\xff\x52\x00\x53\x00\xff\xff\xff\xff\xff\xff\x09\x00\x58\x00\x0b\x00\x5a\x00\xff\xff\x5c\x00\x0f\x00\x5e\x00\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x0f\x00\xff\xff\xff\xff\xff\xff\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\xff\xff\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\x2a\x00\x2b\x00\x2c\x00\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x00\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\x0f\x00\x23\x00\x24\x00\x25\x00\x13\x00\x14\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\x1f\x00\x20\x00\x21\x00\xff\xff\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\x0b\x00\xff\xff\xff\xff\xff\xff\x0f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x09\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x2e\x00\x2f\x00\x30\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\xe1\x01\xbc\x01\xf1\x02\xe9\x01\x08\x00\x90\x02\xea\x01\xfb\x02\xeb\x01\x9a\x02\x09\x00\x08\x00\x98\x01\x00\x02\x4b\x00\xe3\x01\x4c\x00\x09\x00\xa5\x01\xaf\x02\x49\x03\x41\x00\x4b\x01\xa9\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x61\x01\x0d\x00\x0e\x00\x62\x01\x10\x00\x11\x00\x12\x00\x91\x02\x2d\x00\x2b\x00\x2c\x00\x5b\x02\x9b\x02\x2d\x00\x2e\x00\xa6\x01\x2d\x00\xd6\x02\x45\x00\x2e\x00\xc7\x02\xb0\x02\x2e\x00\xc7\x02\x63\x01\x64\x01\x4a\x03\x65\x01\x41\x03\x14\x02\xf6\x02\x5c\x02\x15\x02\xf2\x02\x55\x01\x3f\x03\x0d\x02\x5d\x02\x13\x00\x42\x03\x98\x01\x00\x02\x08\x00\xfc\x02\x69\x00\xec\x01\x5e\x02\x6a\x00\x09\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x01\x02\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x2b\x00\x2c\x00\x10\x00\x11\x00\xfb\x01\xe3\x01\xb3\x00\x50\x00\x7b\x00\x48\x03\xbd\x01\x7c\x00\x7d\x00\xe4\x01\x6c\x01\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x08\x00\x66\x01\x2b\x00\xd9\x01\xed\x01\xce\x02\x09\x00\xa7\x01\x08\x00\x15\x03\xb2\x02\x02\x02\xc8\x02\x53\x01\x09\x00\x45\x02\xa0\x02\xa1\x02\x2a\x03\x30\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\xaa\x01\x36\x02\x0d\x00\x0e\x00\x62\x01\x10\x00\x11\x00\x12\x00\x17\x03\x08\x00\xda\x02\x2b\x00\xb8\x01\x08\x00\xb3\x00\x09\x00\xb3\x02\x89\x02\x08\x00\x09\x00\xec\x02\x48\x02\xb4\x00\x31\x02\x09\x00\x62\x02\x63\x02\x64\x02\xd5\x01\x0d\x02\xe4\x01\xb9\x01\x2c\x03\x0d\x02\x2d\x03\x10\x00\x11\x00\xfb\x01\x13\x00\x10\x00\x11\x00\xfb\x01\x08\x00\x69\x02\x69\x00\x9d\x01\x68\x00\x6a\x00\x09\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\xe5\x01\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x98\x02\xe7\x01\xd0\x00\xc7\x00\xa4\x02\x69\x00\xa5\x02\x50\x00\x7b\x00\xb9\x01\x22\x03\x7c\x00\x7d\x00\x2b\x00\x7e\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x08\x00\x37\x03\x66\x01\x30\x03\x97\x02\xf1\x02\x09\x00\xd2\x02\xb6\x02\x08\x00\x56\x01\xc0\x00\xd3\x02\x9b\x00\x9c\x00\x09\x00\x2e\x00\x57\x01\x45\x02\x31\x03\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x9c\x01\x2b\x00\x36\x02\x0d\x00\x0e\x00\x62\x01\x10\x00\x11\x00\x12\x00\x08\x00\x58\x01\x59\x01\x5a\x01\x5b\x01\xb8\x01\x09\x00\x5c\x01\xb3\x00\xde\x02\xd5\x01\x2b\x00\xdf\x02\x46\x02\x47\x02\x48\x02\x70\x01\x62\x02\x63\x02\x65\x02\xb8\x01\x40\x02\xd5\x01\x4b\x00\xb9\x01\x4c\x00\x10\x00\x11\x00\xfb\x01\x13\x00\x33\x03\xf2\x02\xf3\x02\xf4\x02\x34\x03\x69\x00\x3b\x03\x6b\x02\x6a\x00\xb9\x01\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x07\x03\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x6e\x01\xb3\x00\x8c\x02\x07\x02\xc2\x01\x08\x02\xc3\x01\x50\x00\x7b\x00\xf4\x01\x9c\x02\x7c\x00\x7d\x00\xef\x01\xf0\x01\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x08\x00\xf6\x02\x64\x00\x66\x01\xfc\x01\x65\x00\x09\x00\x08\x03\x09\x03\x0a\x03\x0b\x03\x08\x00\x56\x01\x0c\x03\x65\xff\xb9\x01\x23\x03\x09\x00\x2e\x00\x57\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x65\xff\xa9\x01\xf1\x01\xf2\x01\x36\x02\x0d\x00\x0e\x00\x62\x01\x10\x00\x11\x00\x12\x00\x4d\x02\x3c\x03\x5e\x02\x5a\x01\x5b\x01\xdb\x00\xf3\x01\x5c\x01\xf4\x01\x2b\x00\xa7\x02\x06\x03\xa8\x02\xf1\x01\xf2\x01\x2b\x00\x1b\x03\x63\x01\x64\x01\x2b\x00\x37\x02\x2e\x03\x2f\x03\xb3\x00\x40\x03\xf8\x02\xf9\x02\x13\x00\xf3\x01\x08\x00\xf4\x01\xf4\x01\xf5\x01\x69\x00\x1d\x03\x09\x00\x6a\x00\x2b\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x07\x03\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x10\x00\x11\x00\xfb\x01\x2d\x00\xc3\x02\x55\xff\xb3\x00\x50\x00\x7b\x00\x2e\x00\xd7\x01\x7c\x00\x7d\x00\x55\xff\xb4\x00\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x08\x00\xf6\x02\x74\x01\xcb\x02\xf1\x02\x66\x01\x09\x00\xfe\x01\x45\x03\x0a\x03\x0b\x03\xe9\x01\x2d\x00\x46\x03\x9d\x02\xc5\x02\x76\x01\xd0\x00\x2e\x00\xa3\x01\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\xe9\x01\xc0\x00\xa2\x02\xea\x01\x08\x00\xeb\x01\x4b\x02\x6e\x01\x3b\x00\x5e\x00\x09\x00\x6f\x01\xe9\x01\x70\x01\xb3\x00\xea\x01\x4c\x00\x24\x03\xa5\x02\x5f\x00\x2b\x00\xd0\x02\xb4\x00\x60\x00\xd4\x02\x61\x00\x6a\x01\x0d\x00\x0e\x00\xff\x01\x10\x00\x11\x00\x4d\x01\xd8\x02\x55\xff\xf7\x02\xf8\x02\xf9\x02\x13\x00\xf2\x02\xfc\x02\xf4\x02\xff\x02\x00\x03\x69\x00\xc8\x01\x55\xff\x6a\x00\x55\xff\x6b\x00\x6c\x00\x6d\x00\x6e\x00\xe5\x01\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xb0\x02\xe7\x01\xd0\x00\x03\x03\x00\x03\xb3\x00\xdc\x02\x50\x00\x7b\x00\xbd\x02\xe6\x02\x7c\x00\x7d\x00\xf4\x01\xf6\x01\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x08\x00\xb3\x00\xe7\x02\xb9\x01\xb9\x02\x08\x00\x09\x00\x6c\x02\xb3\x00\xf4\x01\xf7\x01\x09\x00\x08\x00\x53\x01\xe9\x01\x67\x02\xb4\x00\xea\x01\x09\x00\x25\x03\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x08\x00\xd7\x00\x10\x00\x11\x00\xc6\x00\x69\x02\x09\x00\x6d\x02\x5f\x01\x10\x00\x11\x00\xc6\x00\xe9\x01\x08\x00\x6e\x02\xea\x01\x73\x02\x26\x03\xcc\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\xcd\x00\xce\x00\x71\x02\xcf\x00\xd0\x00\x81\x02\xd6\x00\x0d\x00\x0e\x00\x13\x00\x10\x00\x11\x00\x4d\x01\x08\x00\x72\x02\x69\x00\xb9\x01\xbb\x02\x6a\x00\x09\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x75\x02\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x76\x02\x13\x00\x10\x00\x11\x00\x44\x01\x98\x01\xbf\x02\x50\x00\x7b\x00\x77\x02\x14\x00\x7c\x00\x7d\x00\x98\x01\xc0\x02\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x08\x00\x98\x01\xc1\x02\x79\x02\xb3\x00\x0a\x02\x09\x00\xbd\x00\x2d\x00\x0b\x02\x08\x00\x0c\x02\xb4\x00\xe4\x01\x2e\x00\x2f\x00\x09\x00\x80\x02\x0d\x02\x7e\x02\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x32\x00\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\xbe\x00\xbf\x00\x98\x01\xc2\x02\xcc\x00\xc0\x00\xa2\x02\x35\x00\x36\x00\x37\x00\x38\x00\xc1\x00\xb9\x01\xc6\x02\xa5\x02\xc2\x00\x4f\x01\xc3\x00\xcf\x00\xd0\x00\xa9\x02\x5a\x00\xb9\x01\xc9\x02\x2b\x00\x5b\x00\xe9\x01\x5c\x00\x13\x00\xea\x01\xe9\x01\x27\x03\x08\x00\xea\x01\x69\x00\x19\x03\xda\x01\x6a\x00\x09\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x39\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\xdd\x01\xc5\x00\x10\x00\x11\x00\xc6\x00\xfa\x01\xe9\x01\x50\x00\x7b\x00\x9d\x02\x9e\x02\x7c\x00\x7d\x00\x6b\x02\x3e\x02\x7f\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x12\x02\xe3\x01\x9e\x00\x9f\x00\x86\x02\x87\x02\xa0\x00\xe9\x01\xa1\x00\x16\x00\xea\x01\x78\xfe\x1a\x03\x53\x01\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x17\x02\x17\x00\xa6\x00\xa7\x00\xa8\x00\x1f\x02\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\x18\x00\x08\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\xae\x00\x09\x00\x19\x02\x1e\x00\xaf\x00\x1f\x00\x1e\x02\x20\x00\xb0\x00\xb1\x00\x89\x02\x8a\x02\x24\x02\xe9\x01\xbe\x00\xbf\x00\xea\x01\x25\x02\xa8\x02\xc0\x00\xb3\x00\x10\x00\x11\x00\x55\x00\x26\x02\x5f\x00\x27\x02\xb3\x00\xb4\x00\xd2\x00\x8e\x02\xd3\x00\x05\x02\x06\x02\x07\x02\xb4\x00\x08\x02\x0a\x02\x2b\x00\x21\x00\x28\x02\x0b\x02\x22\x00\x0c\x02\x23\x00\x91\x02\x92\x02\x29\x02\x24\x00\x25\x00\x0d\x02\x26\x00\xe9\x01\x2a\x02\x27\x00\xea\x01\x28\x00\xad\x02\x29\x00\x74\x01\x2a\x00\xaa\x02\xab\x02\xe4\x01\x34\x02\xb2\x00\xe5\x01\x2b\x00\x2c\x00\x3e\x02\x2d\x00\x9e\x00\x9f\x00\x76\x01\xd0\x00\xa0\x00\x2b\x02\xa1\x00\x16\x00\xb3\x02\xe7\x01\xd0\x00\x40\x02\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x2c\x02\x17\x00\xa6\x00\xa7\x00\xa8\x00\x2d\x02\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\x18\x00\x43\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\xae\x00\xb9\x01\xb4\x02\x1e\x00\xaf\x00\x1f\x00\x08\x00\x20\x00\xb0\x00\xb1\x00\xb9\x01\xb5\x02\x09\x00\xf0\x02\x56\x02\x57\x02\x58\x02\x59\x02\x4c\x00\x29\x03\x55\x02\x56\x02\x57\x02\x58\x02\x59\x02\x42\x02\xbe\x00\xbf\x00\x6a\x01\x0d\x00\x0e\x00\xc0\x00\x10\x00\x11\x00\x4d\x01\x98\x01\x10\x02\x78\x01\x4f\x02\x21\x00\x50\x02\x79\x01\x22\x00\x7a\x01\x23\x00\x98\x01\x99\x01\xc5\x01\x24\x00\x25\x00\x2b\x00\x26\x00\x98\x01\x9a\x01\x27\x00\x46\x01\x28\x00\x60\x01\x29\x00\x4a\x01\x2a\x00\xb9\x01\xba\x01\x19\xfe\x9c\x01\xb2\x00\x9e\x01\x2b\x00\x2c\x00\x9f\x01\x2d\x00\x19\xfe\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x00\x01\x01\x01\x02\x01\x03\x01\x04\x01\x05\x01\x06\x01\x07\x01\x08\x01\x09\x01\x0a\x01\x0b\x01\x0c\x01\x0d\x01\x0e\x01\x0f\x01\x10\x01\x11\x01\x12\x01\x13\x01\x14\x01\x15\x01\x16\x01\x17\x01\x18\x01\x19\x01\x1a\x01\x1b\x01\x1c\x01\x1d\x01\x1e\x01\x1f\x01\x20\x01\x21\x01\x22\x01\x23\x01\x24\x01\x25\x01\x26\x01\x27\x01\x28\x01\x29\x01\x2a\x01\x2b\x01\x2c\x01\x2d\x01\x2e\x01\x2f\x01\x30\x01\x31\x01\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x39\x01\x3a\x01\x3b\x01\x3c\x01\x3d\x01\x3e\x01\x3f\x01\x40\x01\x41\x01\x42\x01\x43\x01\x44\x01\x9e\x00\x9f\x00\x0e\x03\x0f\x03\xa0\x00\x10\x03\xa1\x00\x16\x00\xab\x01\x78\xfe\xa1\x01\x11\x03\xa2\x00\xa3\x00\xa4\x00\x12\x03\xa2\x01\x17\x00\xa6\x00\xa7\x00\xa8\x00\x13\x03\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\x18\x00\xa5\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\xae\x00\x5c\x00\x38\x00\x1e\x00\xaf\x00\x1f\x00\xa9\x01\x20\x00\xb0\x00\xb1\x00\x08\x00\xe9\x01\x32\x02\xaa\x01\x9d\x02\xa1\x02\x09\x00\x40\x00\x07\x00\xad\x01\x4e\x01\x42\x00\x2b\x00\x2c\x00\xd5\x00\xd6\x00\xaf\x01\xb3\x00\x2b\x00\x2c\x00\xae\x01\xb3\x01\x4c\x01\x0d\x00\x0e\x00\xb4\x00\x10\x00\x11\x00\x4d\x01\x21\x00\xb1\x01\xb2\x01\x22\x00\xb4\x01\x23\x00\xc9\x01\xb6\x01\xd0\x01\x24\x00\x25\x00\x49\x00\x26\x00\xd1\x01\x66\x00\x27\x00\xc3\x00\x28\x00\xc9\x00\x29\x00\xca\x00\x2a\x00\xd3\x00\xd8\x00\xdb\x00\x07\x00\xb2\x00\xe5\x01\x2b\x00\x2c\x00\x30\x00\x2d\x00\x9e\x00\x9f\x00\x0e\x03\x0f\x03\xa0\x00\x10\x03\xa1\x00\x16\x00\xe6\x01\xe7\x01\xd0\x00\x11\x03\xa2\x00\xa3\x00\xa4\x00\x12\x03\x4c\x03\x17\x00\xa6\x00\xa7\x00\xa8\x00\x13\x03\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\x18\x00\x2b\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\xae\x00\xfb\x02\x2b\x00\x1e\x00\xaf\x00\x1f\x00\x44\x03\x20\x00\xb0\x00\xb1\x00\x08\x00\x45\x03\x69\x01\x2b\x00\x39\x03\xbc\x01\x09\x00\xd2\x02\x33\x03\x2c\x03\x4e\x01\x42\x00\x37\x03\x3b\x03\x3a\x03\x0d\x02\x36\x03\xb3\x00\x3e\x03\x3f\x03\x0d\x02\x2b\x00\x4c\x01\x0d\x00\x0e\x00\xb4\x00\x10\x00\x11\x00\x4d\x01\x21\x00\xfe\x02\xff\x02\x22\x00\x0d\x02\x23\x00\x02\x03\x1d\x03\x03\x03\x24\x00\x25\x00\x49\x00\x26\x00\x05\x03\x06\x03\x27\x00\x14\x03\x28\x00\x21\x03\x29\x00\x1f\x03\x2a\x00\x22\x03\xbf\x02\xbc\x01\xcb\x02\xb2\x00\xe5\x01\x2b\x00\x2c\x00\xbc\x01\x2d\x00\x9e\x00\x9f\x00\x2b\x00\x48\x03\xa0\x00\x2b\x00\xa1\x00\x16\x00\xe8\x01\xe7\x01\xd0\x00\xc5\x02\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xd2\x02\x17\x00\xa6\x00\xa7\x00\xa8\x00\xd7\x02\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\x18\x00\x0d\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\xae\x00\xdb\x02\xd8\x02\x1e\x00\xaf\x00\x1f\x00\xdc\x02\x20\x00\xb0\x00\xb1\x00\xe0\x02\x60\x02\xee\x02\xe1\x02\xef\xfe\xef\xfe\xe2\x02\xe3\x02\xe4\x02\xef\xfe\xb3\x00\xef\xfe\xe5\x02\xe6\x02\xc0\x00\xef\xfe\xe9\x02\xb3\x00\xb4\x00\xef\xfe\x5a\x00\xef\xfe\x1b\x02\xea\x02\x72\x01\xb4\x00\x73\x01\x2b\x00\xef\xfe\x21\x00\xeb\x02\xef\x02\x22\x00\x2b\x00\x23\x00\xf0\x02\x61\x02\x67\x02\x24\x00\x25\x00\x4d\x02\x26\x00\x14\x02\x1b\x02\x27\x00\x70\x02\x28\x00\x71\x02\x29\x00\x74\x01\x2a\x00\x1b\x02\x75\x02\x1b\x02\x35\x02\xb2\x00\xe5\x01\x2b\x00\x2c\x00\x8c\x02\x2d\x00\x9e\x00\x9f\x00\x76\x01\xd0\x00\xa0\x00\x79\x02\xa1\x00\x16\x00\xf8\x01\xe7\x01\xd0\x00\x1b\x02\xa2\x00\xa3\x00\xa4\x00\xa5\x00\x7b\x02\x17\x00\xa6\x00\xa7\x00\xa8\x00\x7c\x02\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\x18\x00\x7d\x02\x19\x00\x1a\x00\x1b\x00\x1c\x00\xae\x00\x7e\x02\x1b\x02\x1e\x00\xaf\x00\x1f\x00\x08\x00\x20\x00\xb0\x00\xb1\x00\x80\x02\x17\x02\x09\x00\x83\x02\x94\x02\x84\x02\x95\x02\x9c\x02\x4c\x00\x14\x03\x55\x02\x56\x02\x57\x02\x58\x02\x59\x02\xb1\x01\xad\x02\xbc\x01\x6a\x01\x0d\x00\x0e\x00\xda\x01\x10\x00\x11\x00\x4d\x01\xb3\x00\xdc\x01\xdd\x01\xdf\x01\x21\x00\xe0\x01\xe1\x01\x22\x00\xb4\x00\x23\x00\x2b\x00\x0f\x02\x4f\x00\x24\x00\x25\x00\x10\x02\x26\x00\x2b\x00\x12\x02\x27\x00\x14\x02\x28\x00\x08\x00\x29\x00\x17\x02\x2a\x00\x19\x02\x1b\x02\x09\x00\x1c\x02\xb2\x00\x19\x02\x2b\x00\x2c\x00\x4c\x00\x2d\x00\x1d\x02\x80\x01\x1e\x02\xe5\x01\x21\x02\x4d\x00\x33\x00\x0b\x00\x4e\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x14\x02\xf9\x01\xe7\x01\xd0\x00\x22\x02\x23\x02\xb3\x00\x35\x00\x36\x00\x37\x00\x38\x00\x16\x00\x4f\x00\x2f\x02\xb4\x00\x24\x02\xb3\x00\x17\x02\xb3\x00\x14\x02\x0d\xff\x17\x00\x50\x00\x51\x00\xb4\x00\x0e\xff\xb4\x00\x0a\xff\x08\xff\x09\xff\x42\x02\x18\x00\x48\x01\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xc5\x00\x4a\x02\x1e\x00\x48\x01\x1f\x00\x2b\x00\x20\x00\xb5\x00\x4d\x02\x4b\x02\xb6\x00\xb7\x00\xb8\x00\xb9\x00\x52\x02\x51\x01\x55\x01\xe5\x01\x56\x01\x74\x01\x5e\x01\xba\x00\xbb\x00\x5f\x01\x75\x01\xda\x00\x74\x01\x7b\x01\x7e\x01\x2b\x00\x03\x02\xe7\x01\xd0\x00\x76\x01\xd0\x00\x50\x00\x51\x00\xcc\x00\x21\x00\x2b\x00\xa1\x01\x29\x03\x3b\x00\x3c\x00\xb3\x00\xcc\x00\xb3\x00\x24\x00\x25\x00\xcc\x00\x26\x00\x16\x00\xb4\x00\x3d\x00\xb4\x00\x28\x00\xad\x01\x3e\x00\x4b\x00\x3f\x00\x4c\x00\x17\x00\xb1\x01\x2b\x00\xcc\x00\xcc\x01\x2b\x00\x2c\x00\xbc\x01\x2d\x00\xb6\x01\x18\x00\xcc\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xd0\x01\xcb\x01\x1e\x00\x16\x00\x1f\x00\xcc\x00\x20\x00\x74\x01\xcd\x01\xce\x01\xcf\x01\xd3\x01\x7c\x01\x17\x00\xd5\x01\xff\xff\xd4\x01\x52\x01\x66\x00\xcf\x00\xd0\x00\x76\x01\xd0\x00\x18\x00\x62\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xc5\x00\x1e\x00\x2b\x00\x1f\x00\xcc\x00\x20\x00\x65\x00\x21\x00\xda\x00\xff\xff\x96\x02\x3b\x00\x3c\x00\xdb\x00\x32\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x4b\x00\x3f\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x21\x00\x2d\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x4b\x00\x3f\x00\x4c\x00\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x53\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x08\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x09\x00\x00\x00\x1e\x00\x16\x00\x1f\x00\x00\x00\x20\x00\x16\x03\x55\x02\x56\x02\x57\x02\x58\x02\x59\x02\x17\x00\x45\x01\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x3d\x00\x55\x00\x28\x00\x00\x00\x3e\x00\x00\x00\x3f\x00\xb7\x02\x55\x02\x56\x02\x57\x02\x58\x02\x59\x02\x2b\x00\x2c\x00\x21\x00\x2d\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x4b\x00\x3f\x00\x4c\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x16\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x53\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x4b\x00\x2a\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x27\x00\x34\x02\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x16\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x17\x00\x54\x02\x55\x02\x56\x02\x57\x02\x58\x02\x59\x02\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\xbe\x00\xbf\x00\x00\x00\x00\x00\x21\x00\xc0\x00\x00\x00\x0b\xff\x00\x00\x23\x00\x00\x00\x78\x01\x00\x00\x24\x00\x25\x00\x79\x01\x26\x00\x7a\x01\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x2b\x00\x2a\x00\x68\x01\x00\x00\x00\x00\x00\x00\x69\x01\x21\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x4b\x00\x2a\x00\x4c\x00\x16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x53\x00\x00\x00\x00\x00\x00\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x08\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x09\x00\x00\x00\x1e\x00\x16\x00\x1f\x00\x00\x00\x20\x00\x96\x02\x55\x02\x56\x02\x57\x02\x58\x02\x59\x02\x17\x00\x00\x00\x44\x02\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x21\x00\x00\x00\x00\x00\xbe\x00\xbf\x00\x23\x00\x00\x00\x00\x00\xc0\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x5f\x00\x27\x00\x6c\x01\x28\x00\xd2\x00\x29\x00\x05\x02\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2b\x00\x2c\x00\x21\x00\x2d\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x00\x00\x3f\x00\x47\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x08\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x09\x00\x00\x00\x1e\x00\x16\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\xbf\x01\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x3d\x00\x55\x00\x28\x00\x00\x00\x3e\x00\x00\x00\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x21\x00\x2d\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x00\x00\x3f\x00\x47\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x16\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\xbe\x00\xbf\x00\x00\x00\x00\x00\x21\x00\xc0\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x78\x01\x00\x00\x24\x00\x25\x00\x79\x01\x26\x00\x7a\x01\x00\x00\x3d\x00\x55\x00\x28\x00\x00\x00\x3e\x00\x2b\x00\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x47\xff\x26\x00\x16\x00\x47\xff\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x16\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\xbe\x00\xbf\x00\x00\x00\x00\x00\x21\x00\xc0\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x5f\x00\x00\x00\x24\x00\x25\x00\xd2\x00\x26\x00\xd3\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x2b\x00\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x17\x00\x00\x00\x00\x00\x69\x01\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x16\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\xbe\x00\xbf\x00\x00\x00\x00\x00\x21\x00\xc0\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x78\x01\x00\x00\x24\x00\x25\x00\x79\x01\x26\x00\x7a\x01\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x2b\x00\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x32\x02\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x08\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x09\x00\x00\x00\x1e\x00\x16\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\x3c\x02\x0d\x00\x0e\x00\x3d\x02\x10\x00\x11\x00\x12\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x21\x00\x00\x00\x00\x00\xbe\x00\xbf\x00\x23\x00\x00\x00\x00\x00\xc0\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x5f\x00\x27\x00\x00\x00\x28\x00\xd2\x00\x29\x00\xd3\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x69\x01\x2b\x00\x2b\x00\x2c\x00\x21\x00\x2d\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x16\x00\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x53\x00\x2d\x00\x00\x00\x00\x00\x00\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x08\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x09\x00\x00\x00\x1e\x00\x16\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\xd6\x00\x0d\x00\x0e\x00\xd7\x00\x10\x00\x11\x00\x12\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x21\x00\x2d\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x00\x00\x3f\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x16\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x21\x00\x00\x00\x00\x00\x22\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x21\x00\x2d\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x16\x00\x00\x00\x3d\x00\x00\x00\x28\x00\x00\x00\x3e\x00\x00\x00\x3f\x00\x00\x00\x17\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x1f\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x26\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x23\x00\x2d\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x19\x03\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x18\x00\x2d\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x23\x00\x2d\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\xfe\x01\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x18\x00\x2d\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x23\x00\x2d\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\xc9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x18\x00\x2d\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\x00\x00\x00\x28\x00\x00\x00\x58\x00\x00\x00\x59\x00\x00\x00\x00\x00\x00\x00\x21\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x23\x00\x2d\x00\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x00\x00\x00\x28\x00\x00\x00\x29\x00\x00\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x18\x00\x2d\x00\x19\x00\x1a\x00\x00\x00\x1c\x00\x1d\x00\x00\x00\x00\x00\x1e\x00\x08\x00\x00\x00\x00\x00\x20\x00\x00\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x00\x33\x00\x0b\x00\x4e\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x00\x35\x00\x36\x00\x37\x00\x38\x00\x23\x00\xc8\x01\x00\x00\x00\x00\x24\x00\x25\x00\x00\x00\x00\x00\x00\x00\x08\x00\x27\x00\x47\x00\x28\x00\x00\x00\x29\x00\x09\x00\xc9\x00\x00\x00\x00\x00\x41\x00\x42\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x00\x00\x2d\x00\x00\x00\x48\x00\x33\x00\x0b\x00\x44\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\xc7\x01\x08\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x33\x00\x0b\x00\x44\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x35\x00\x36\x00\x37\x00\x38\x00\x49\x00\x09\x00\x00\x00\x00\x00\x00\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x33\x00\x0b\x00\x44\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x35\x00\x36\x00\x37\x00\x38\x00\xc6\x01\x09\x00\x00\x00\x00\x00\x00\x00\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x33\x00\x0b\x00\x44\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x02\x35\x00\x36\x00\x37\x00\x38\x00\x45\x00\x09\x00\x00\x00\x00\x00\x00\x00\x41\x00\x4b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x42\x00\x00\x00\x00\x00\x46\x02\x47\x02\x48\x02\x00\x00\x00\x00\x08\x00\x00\x00\x45\x00\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\xc6\x01\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x4b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\xc7\x01\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x38\x02\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x45\x00\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x39\x02\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\xc3\x01\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x3a\x02\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\xc4\x01\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x3b\x02\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\xc6\x01\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x4b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\xc7\x01\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x4e\x01\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x45\x00\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x49\x00\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x45\x00\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x49\x00\x4c\x01\x0d\x00\x0e\x00\x09\x00\x10\x00\x11\x00\x4d\x01\x41\x00\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x01\x4c\x01\x0d\x00\x0e\x00\x00\x00\x10\x00\x11\x00\x4d\x01\x08\x00\x00\x00\x47\x00\x00\x00\x00\x00\x00\x00\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x00\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x03\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcc\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcd\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xeb\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x53\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x61\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd6\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4e\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x52\x02\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x48\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x49\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x01\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\x00\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x43\x00\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x00\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x00\x35\x00\x36\x00\x37\x00\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x3f\x00\x33\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x34\x00\x10\x00\x11\x00\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x00\x36\x00\x37\x00\x38\x00\x7f\x01\x80\x01\x81\x01\x82\x01\x83\x01\x84\x01\x85\x01\x86\x01\x87\x01\x88\x01\x89\x01\x8a\x01\x8b\x01\x8c\x01\x8d\x01\x8e\x01\x8f\x01\x90\x01\x91\x01\x92\x01\x93\x01\x94\x01\x95\x01\x96\x01\x97\x01\x98\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (6, 487) [
	(6 , happyReduce_6),
	(7 , happyReduce_7),
	(8 , happyReduce_8),
	(9 , happyReduce_9),
	(10 , happyReduce_10),
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256),
	(257 , happyReduce_257),
	(258 , happyReduce_258),
	(259 , happyReduce_259),
	(260 , happyReduce_260),
	(261 , happyReduce_261),
	(262 , happyReduce_262),
	(263 , happyReduce_263),
	(264 , happyReduce_264),
	(265 , happyReduce_265),
	(266 , happyReduce_266),
	(267 , happyReduce_267),
	(268 , happyReduce_268),
	(269 , happyReduce_269),
	(270 , happyReduce_270),
	(271 , happyReduce_271),
	(272 , happyReduce_272),
	(273 , happyReduce_273),
	(274 , happyReduce_274),
	(275 , happyReduce_275),
	(276 , happyReduce_276),
	(277 , happyReduce_277),
	(278 , happyReduce_278),
	(279 , happyReduce_279),
	(280 , happyReduce_280),
	(281 , happyReduce_281),
	(282 , happyReduce_282),
	(283 , happyReduce_283),
	(284 , happyReduce_284),
	(285 , happyReduce_285),
	(286 , happyReduce_286),
	(287 , happyReduce_287),
	(288 , happyReduce_288),
	(289 , happyReduce_289),
	(290 , happyReduce_290),
	(291 , happyReduce_291),
	(292 , happyReduce_292),
	(293 , happyReduce_293),
	(294 , happyReduce_294),
	(295 , happyReduce_295),
	(296 , happyReduce_296),
	(297 , happyReduce_297),
	(298 , happyReduce_298),
	(299 , happyReduce_299),
	(300 , happyReduce_300),
	(301 , happyReduce_301),
	(302 , happyReduce_302),
	(303 , happyReduce_303),
	(304 , happyReduce_304),
	(305 , happyReduce_305),
	(306 , happyReduce_306),
	(307 , happyReduce_307),
	(308 , happyReduce_308),
	(309 , happyReduce_309),
	(310 , happyReduce_310),
	(311 , happyReduce_311),
	(312 , happyReduce_312),
	(313 , happyReduce_313),
	(314 , happyReduce_314),
	(315 , happyReduce_315),
	(316 , happyReduce_316),
	(317 , happyReduce_317),
	(318 , happyReduce_318),
	(319 , happyReduce_319),
	(320 , happyReduce_320),
	(321 , happyReduce_321),
	(322 , happyReduce_322),
	(323 , happyReduce_323),
	(324 , happyReduce_324),
	(325 , happyReduce_325),
	(326 , happyReduce_326),
	(327 , happyReduce_327),
	(328 , happyReduce_328),
	(329 , happyReduce_329),
	(330 , happyReduce_330),
	(331 , happyReduce_331),
	(332 , happyReduce_332),
	(333 , happyReduce_333),
	(334 , happyReduce_334),
	(335 , happyReduce_335),
	(336 , happyReduce_336),
	(337 , happyReduce_337),
	(338 , happyReduce_338),
	(339 , happyReduce_339),
	(340 , happyReduce_340),
	(341 , happyReduce_341),
	(342 , happyReduce_342),
	(343 , happyReduce_343),
	(344 , happyReduce_344),
	(345 , happyReduce_345),
	(346 , happyReduce_346),
	(347 , happyReduce_347),
	(348 , happyReduce_348),
	(349 , happyReduce_349),
	(350 , happyReduce_350),
	(351 , happyReduce_351),
	(352 , happyReduce_352),
	(353 , happyReduce_353),
	(354 , happyReduce_354),
	(355 , happyReduce_355),
	(356 , happyReduce_356),
	(357 , happyReduce_357),
	(358 , happyReduce_358),
	(359 , happyReduce_359),
	(360 , happyReduce_360),
	(361 , happyReduce_361),
	(362 , happyReduce_362),
	(363 , happyReduce_363),
	(364 , happyReduce_364),
	(365 , happyReduce_365),
	(366 , happyReduce_366),
	(367 , happyReduce_367),
	(368 , happyReduce_368),
	(369 , happyReduce_369),
	(370 , happyReduce_370),
	(371 , happyReduce_371),
	(372 , happyReduce_372),
	(373 , happyReduce_373),
	(374 , happyReduce_374),
	(375 , happyReduce_375),
	(376 , happyReduce_376),
	(377 , happyReduce_377),
	(378 , happyReduce_378),
	(379 , happyReduce_379),
	(380 , happyReduce_380),
	(381 , happyReduce_381),
	(382 , happyReduce_382),
	(383 , happyReduce_383),
	(384 , happyReduce_384),
	(385 , happyReduce_385),
	(386 , happyReduce_386),
	(387 , happyReduce_387),
	(388 , happyReduce_388),
	(389 , happyReduce_389),
	(390 , happyReduce_390),
	(391 , happyReduce_391),
	(392 , happyReduce_392),
	(393 , happyReduce_393),
	(394 , happyReduce_394),
	(395 , happyReduce_395),
	(396 , happyReduce_396),
	(397 , happyReduce_397),
	(398 , happyReduce_398),
	(399 , happyReduce_399),
	(400 , happyReduce_400),
	(401 , happyReduce_401),
	(402 , happyReduce_402),
	(403 , happyReduce_403),
	(404 , happyReduce_404),
	(405 , happyReduce_405),
	(406 , happyReduce_406),
	(407 , happyReduce_407),
	(408 , happyReduce_408),
	(409 , happyReduce_409),
	(410 , happyReduce_410),
	(411 , happyReduce_411),
	(412 , happyReduce_412),
	(413 , happyReduce_413),
	(414 , happyReduce_414),
	(415 , happyReduce_415),
	(416 , happyReduce_416),
	(417 , happyReduce_417),
	(418 , happyReduce_418),
	(419 , happyReduce_419),
	(420 , happyReduce_420),
	(421 , happyReduce_421),
	(422 , happyReduce_422),
	(423 , happyReduce_423),
	(424 , happyReduce_424),
	(425 , happyReduce_425),
	(426 , happyReduce_426),
	(427 , happyReduce_427),
	(428 , happyReduce_428),
	(429 , happyReduce_429),
	(430 , happyReduce_430),
	(431 , happyReduce_431),
	(432 , happyReduce_432),
	(433 , happyReduce_433),
	(434 , happyReduce_434),
	(435 , happyReduce_435),
	(436 , happyReduce_436),
	(437 , happyReduce_437),
	(438 , happyReduce_438),
	(439 , happyReduce_439),
	(440 , happyReduce_440),
	(441 , happyReduce_441),
	(442 , happyReduce_442),
	(443 , happyReduce_443),
	(444 , happyReduce_444),
	(445 , happyReduce_445),
	(446 , happyReduce_446),
	(447 , happyReduce_447),
	(448 , happyReduce_448),
	(449 , happyReduce_449),
	(450 , happyReduce_450),
	(451 , happyReduce_451),
	(452 , happyReduce_452),
	(453 , happyReduce_453),
	(454 , happyReduce_454),
	(455 , happyReduce_455),
	(456 , happyReduce_456),
	(457 , happyReduce_457),
	(458 , happyReduce_458),
	(459 , happyReduce_459),
	(460 , happyReduce_460),
	(461 , happyReduce_461),
	(462 , happyReduce_462),
	(463 , happyReduce_463),
	(464 , happyReduce_464),
	(465 , happyReduce_465),
	(466 , happyReduce_466),
	(467 , happyReduce_467),
	(468 , happyReduce_468),
	(469 , happyReduce_469),
	(470 , happyReduce_470),
	(471 , happyReduce_471),
	(472 , happyReduce_472),
	(473 , happyReduce_473),
	(474 , happyReduce_474),
	(475 , happyReduce_475),
	(476 , happyReduce_476),
	(477 , happyReduce_477),
	(478 , happyReduce_478),
	(479 , happyReduce_479),
	(480 , happyReduce_480),
	(481 , happyReduce_481),
	(482 , happyReduce_482),
	(483 , happyReduce_483),
	(484 , happyReduce_484),
	(485 , happyReduce_485),
	(486 , happyReduce_486),
	(487 , happyReduce_487)
	]

happy_n_terms = 106 :: Int
happy_n_nonterms = 162 :: Int

happyReduce_6 = happySpecReduce_1  0# happyReduction_6
happyReduction_6 happy_x_1
	 =  case happyOut10 happy_x_1 of { happy_var_1 -> 
	happyIn9
		 (reverse happy_var_1
	)}

happyReduce_7 = happySpecReduce_2  1# happyReduction_7
happyReduction_7 happy_x_2
	happy_x_1
	 =  case happyOut10 happy_x_1 of { happy_var_1 -> 
	case happyOut11 happy_x_2 of { happy_var_2 -> 
	happyIn10
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_8 = happySpecReduce_0  1# happyReduction_8
happyReduction_8  =  happyIn10
		 ([]
	)

happyReduce_9 = happySpecReduce_1  2# happyReduction_9
happyReduction_9 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	happyIn11
		 (TokKeyword KwAbstract happy_var_1
	)}

happyReduce_10 = happySpecReduce_1  2# happyReduction_10
happyReduction_10 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCoData happy_var_1
	)}

happyReduce_11 = happySpecReduce_1  2# happyReduction_11
happyReduction_11 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCoInductive happy_var_1
	)}

happyReduce_12 = happySpecReduce_1  2# happyReduction_12
happyReduction_12 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwConstructor happy_var_1) -> 
	happyIn11
		 (TokKeyword KwConstructor happy_var_1
	)}

happyReduce_13 = happySpecReduce_1  2# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	happyIn11
		 (TokKeyword KwData happy_var_1
	)}

happyReduce_14 = happySpecReduce_1  2# happyReduction_14
happyReduction_14 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwEta happy_var_1) -> 
	happyIn11
		 (TokKeyword KwEta happy_var_1
	)}

happyReduce_15 = happySpecReduce_1  2# happyReduction_15
happyReduction_15 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwField happy_var_1) -> 
	happyIn11
		 (TokKeyword KwField happy_var_1
	)}

happyReduce_16 = happySpecReduce_1  2# happyReduction_16
happyReduction_16 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwForall happy_var_1) -> 
	happyIn11
		 (TokKeyword KwForall happy_var_1
	)}

happyReduce_17 = happySpecReduce_1  2# happyReduction_17
happyReduction_17 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	happyIn11
		 (TokKeyword KwHiding happy_var_1
	)}

happyReduce_18 = happySpecReduce_1  2# happyReduction_18
happyReduction_18 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwImport happy_var_1) -> 
	happyIn11
		 (TokKeyword KwImport happy_var_1
	)}

happyReduce_19 = happySpecReduce_1  2# happyReduction_19
happyReduction_19 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIn happy_var_1) -> 
	happyIn11
		 (TokKeyword KwIn happy_var_1
	)}

happyReduce_20 = happySpecReduce_1  2# happyReduction_20
happyReduction_20 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn11
		 (TokKeyword KwInductive happy_var_1
	)}

happyReduce_21 = happySpecReduce_1  2# happyReduction_21
happyReduction_21 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	happyIn11
		 (TokKeyword KwInfix happy_var_1
	)}

happyReduce_22 = happySpecReduce_1  2# happyReduction_22
happyReduction_22 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	happyIn11
		 (TokKeyword KwInfixL happy_var_1
	)}

happyReduce_23 = happySpecReduce_1  2# happyReduction_23
happyReduction_23 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	happyIn11
		 (TokKeyword KwInfixR happy_var_1
	)}

happyReduce_24 = happySpecReduce_1  2# happyReduction_24
happyReduction_24 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInstance happy_var_1) -> 
	happyIn11
		 (TokKeyword KwInstance happy_var_1
	)}

happyReduce_25 = happySpecReduce_1  2# happyReduction_25
happyReduction_25 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOverlap happy_var_1) -> 
	happyIn11
		 (TokKeyword KwOverlap happy_var_1
	)}

happyReduce_26 = happySpecReduce_1  2# happyReduction_26
happyReduction_26 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	happyIn11
		 (TokKeyword KwLet happy_var_1
	)}

happyReduce_27 = happySpecReduce_1  2# happyReduction_27
happyReduction_27 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMacro happy_var_1) -> 
	happyIn11
		 (TokKeyword KwMacro happy_var_1
	)}

happyReduce_28 = happySpecReduce_1  2# happyReduction_28
happyReduction_28 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	happyIn11
		 (TokKeyword KwModule happy_var_1
	)}

happyReduce_29 = happySpecReduce_1  2# happyReduction_29
happyReduction_29 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	happyIn11
		 (TokKeyword KwMutual happy_var_1
	)}

happyReduce_30 = happySpecReduce_1  2# happyReduction_30
happyReduction_30 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNoEta happy_var_1) -> 
	happyIn11
		 (TokKeyword KwNoEta happy_var_1
	)}

happyReduce_31 = happySpecReduce_1  2# happyReduction_31
happyReduction_31 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn11
		 (TokKeyword KwOpen happy_var_1
	)}

happyReduce_32 = happySpecReduce_1  2# happyReduction_32
happyReduction_32 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	happyIn11
		 (TokKeyword KwPatternSyn happy_var_1
	)}

happyReduce_33 = happySpecReduce_1  2# happyReduction_33
happyReduction_33 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	happyIn11
		 (TokKeyword KwPostulate happy_var_1
	)}

happyReduce_34 = happySpecReduce_1  2# happyReduction_34
happyReduction_34 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	happyIn11
		 (TokKeyword KwPrimitive happy_var_1
	)}

happyReduce_35 = happySpecReduce_1  2# happyReduction_35
happyReduction_35 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	happyIn11
		 (TokKeyword KwPrivate happy_var_1
	)}

happyReduce_36 = happySpecReduce_1  2# happyReduction_36
happyReduction_36 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn11
		 (TokKeyword KwProp happy_var_1
	)}

happyReduce_37 = happySpecReduce_1  2# happyReduction_37
happyReduction_37 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn11
		 (TokKeyword KwPublic happy_var_1
	)}

happyReduce_38 = happySpecReduce_1  2# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn11
		 (TokKeyword KwQuote happy_var_1
	)}

happyReduce_39 = happySpecReduce_1  2# happyReduction_39
happyReduction_39 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteContext happy_var_1) -> 
	happyIn11
		 (TokKeyword KwQuoteContext happy_var_1
	)}

happyReduce_40 = happySpecReduce_1  2# happyReduction_40
happyReduction_40 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteGoal happy_var_1) -> 
	happyIn11
		 (TokKeyword KwQuoteGoal happy_var_1
	)}

happyReduce_41 = happySpecReduce_1  2# happyReduction_41
happyReduction_41 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn11
		 (TokKeyword KwQuoteTerm happy_var_1
	)}

happyReduce_42 = happySpecReduce_1  2# happyReduction_42
happyReduction_42 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	happyIn11
		 (TokKeyword KwRecord happy_var_1
	)}

happyReduce_43 = happySpecReduce_1  2# happyReduction_43
happyReduction_43 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	happyIn11
		 (TokKeyword KwRenaming happy_var_1
	)}

happyReduce_44 = happySpecReduce_1  2# happyReduction_44
happyReduction_44 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRewrite happy_var_1) -> 
	happyIn11
		 (TokKeyword KwRewrite happy_var_1
	)}

happyReduce_45 = happySpecReduce_1  2# happyReduction_45
happyReduction_45 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn11
		 (TokKeyword KwSet happy_var_1
	)}

happyReduce_46 = happySpecReduce_1  2# happyReduction_46
happyReduction_46 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSyntax happy_var_1) -> 
	happyIn11
		 (TokKeyword KwSyntax happy_var_1
	)}

happyReduce_47 = happySpecReduce_1  2# happyReduction_47
happyReduction_47 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	happyIn11
		 (TokKeyword KwTactic happy_var_1
	)}

happyReduce_48 = happySpecReduce_1  2# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTo happy_var_1) -> 
	happyIn11
		 (TokKeyword KwTo happy_var_1
	)}

happyReduce_49 = happySpecReduce_1  2# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn11
		 (TokKeyword KwUnquote happy_var_1
	)}

happyReduce_50 = happySpecReduce_1  2# happyReduction_50
happyReduction_50 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	happyIn11
		 (TokKeyword KwUnquoteDecl happy_var_1
	)}

happyReduce_51 = happySpecReduce_1  2# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDef happy_var_1) -> 
	happyIn11
		 (TokKeyword KwUnquoteDef happy_var_1
	)}

happyReduce_52 = happySpecReduce_1  2# happyReduction_52
happyReduction_52 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	happyIn11
		 (TokKeyword KwUsing happy_var_1
	)}

happyReduce_53 = happySpecReduce_1  2# happyReduction_53
happyReduction_53 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWhere happy_var_1) -> 
	happyIn11
		 (TokKeyword KwWhere happy_var_1
	)}

happyReduce_54 = happySpecReduce_1  2# happyReduction_54
happyReduction_54 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwWith happy_var_1) -> 
	happyIn11
		 (TokKeyword KwWith happy_var_1
	)}

happyReduce_55 = happySpecReduce_1  2# happyReduction_55
happyReduction_55 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwBUILTIN happy_var_1) -> 
	happyIn11
		 (TokKeyword KwBUILTIN happy_var_1
	)}

happyReduce_56 = happySpecReduce_1  2# happyReduction_56
happyReduction_56 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCATCHALL happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCATCHALL happy_var_1
	)}

happyReduce_57 = happySpecReduce_1  2# happyReduction_57
happyReduction_57 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED happy_var_1
	)}

happyReduce_58 = happySpecReduce_1  2# happyReduction_58
happyReduction_58 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_DATA happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_DATA happy_var_1
	)}

happyReduce_59 = happySpecReduce_1  2# happyReduction_59
happyReduction_59 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_DATA_UHC happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_DATA_UHC happy_var_1
	)}

happyReduce_60 = happySpecReduce_1  2# happyReduction_60
happyReduction_60 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_DECLARE_DATA happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_DECLARE_DATA happy_var_1
	)}

happyReduce_61 = happySpecReduce_1  2# happyReduction_61
happyReduction_61 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_EPIC happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_EPIC happy_var_1
	)}

happyReduce_62 = happySpecReduce_1  2# happyReduction_62
happyReduction_62 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_EXPORT happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_EXPORT happy_var_1
	)}

happyReduce_63 = happySpecReduce_1  2# happyReduction_63
happyReduction_63 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_JS happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_JS happy_var_1
	)}

happyReduce_64 = happySpecReduce_1  2# happyReduction_64
happyReduction_64 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_TYPE happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_TYPE happy_var_1
	)}

happyReduce_65 = happySpecReduce_1  2# happyReduction_65
happyReduction_65 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCOMPILED_UHC happy_var_1) -> 
	happyIn11
		 (TokKeyword KwCOMPILED_UHC happy_var_1
	)}

happyReduce_66 = happySpecReduce_1  2# happyReduction_66
happyReduction_66 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwHASKELL happy_var_1) -> 
	happyIn11
		 (TokKeyword KwHASKELL happy_var_1
	)}

happyReduce_67 = happySpecReduce_1  2# happyReduction_67
happyReduction_67 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwDISPLAY happy_var_1) -> 
	happyIn11
		 (TokKeyword KwDISPLAY happy_var_1
	)}

happyReduce_68 = happySpecReduce_1  2# happyReduction_68
happyReduction_68 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPORT happy_var_1) -> 
	happyIn11
		 (TokKeyword KwIMPORT happy_var_1
	)}

happyReduce_69 = happySpecReduce_1  2# happyReduction_69
happyReduction_69 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPORT_UHC happy_var_1) -> 
	happyIn11
		 (TokKeyword KwIMPORT_UHC happy_var_1
	)}

happyReduce_70 = happySpecReduce_1  2# happyReduction_70
happyReduction_70 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwIMPOSSIBLE happy_var_1) -> 
	happyIn11
		 (TokKeyword KwIMPOSSIBLE happy_var_1
	)}

happyReduce_71 = happySpecReduce_1  2# happyReduction_71
happyReduction_71 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwINLINE happy_var_1) -> 
	happyIn11
		 (TokKeyword KwINLINE happy_var_1
	)}

happyReduce_72 = happySpecReduce_1  2# happyReduction_72
happyReduction_72 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMEASURE happy_var_1) -> 
	happyIn11
		 (TokKeyword KwMEASURE happy_var_1
	)}

happyReduce_73 = happySpecReduce_1  2# happyReduction_73
happyReduction_73 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_1) -> 
	happyIn11
		 (TokKeyword KwNO_TERMINATION_CHECK happy_var_1
	)}

happyReduce_74 = happySpecReduce_1  2# happyReduction_74
happyReduction_74 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNO_POSITIVITY_CHECK happy_var_1) -> 
	happyIn11
		 (TokKeyword KwNO_POSITIVITY_CHECK happy_var_1
	)}

happyReduce_75 = happySpecReduce_1  2# happyReduction_75
happyReduction_75 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNON_TERMINATING happy_var_1) -> 
	happyIn11
		 (TokKeyword KwNON_TERMINATING happy_var_1
	)}

happyReduce_76 = happySpecReduce_1  2# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOPTIONS happy_var_1) -> 
	happyIn11
		 (TokKeyword KwOPTIONS happy_var_1
	)}

happyReduce_77 = happySpecReduce_1  2# happyReduction_77
happyReduction_77 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPOLARITY happy_var_1) -> 
	happyIn11
		 (TokKeyword KwPOLARITY happy_var_1
	)}

happyReduce_78 = happySpecReduce_1  2# happyReduction_78
happyReduction_78 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwREWRITE happy_var_1) -> 
	happyIn11
		 (TokKeyword KwREWRITE happy_var_1
	)}

happyReduce_79 = happySpecReduce_1  2# happyReduction_79
happyReduction_79 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSTATIC happy_var_1) -> 
	happyIn11
		 (TokKeyword KwSTATIC happy_var_1
	)}

happyReduce_80 = happySpecReduce_1  2# happyReduction_80
happyReduction_80 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTERMINATING happy_var_1) -> 
	happyIn11
		 (TokKeyword KwTERMINATING happy_var_1
	)}

happyReduce_81 = happySpecReduce_1  2# happyReduction_81
happyReduction_81 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn11
		 (TokSetN happy_var_1
	)}

happyReduce_82 = happySpecReduce_1  2# happyReduction_82
happyReduction_82 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokTeX happy_var_1) -> 
	happyIn11
		 (TokTeX happy_var_1
	)}

happyReduce_83 = happySpecReduce_1  2# happyReduction_83
happyReduction_83 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokComment happy_var_1) -> 
	happyIn11
		 (TokComment happy_var_1
	)}

happyReduce_84 = happySpecReduce_1  2# happyReduction_84
happyReduction_84 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	happyIn11
		 (TokSymbol SymEllipsis happy_var_1
	)}

happyReduce_85 = happySpecReduce_1  2# happyReduction_85
happyReduction_85 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDotDot happy_var_1) -> 
	happyIn11
		 (TokSymbol SymDotDot happy_var_1
	)}

happyReduce_86 = happySpecReduce_1  2# happyReduction_86
happyReduction_86 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	happyIn11
		 (TokSymbol SymDot happy_var_1
	)}

happyReduce_87 = happySpecReduce_1  2# happyReduction_87
happyReduction_87 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn11
		 (TokSymbol SymSemi happy_var_1
	)}

happyReduce_88 = happySpecReduce_1  2# happyReduction_88
happyReduction_88 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymColon happy_var_1) -> 
	happyIn11
		 (TokSymbol SymColon happy_var_1
	)}

happyReduce_89 = happySpecReduce_1  2# happyReduction_89
happyReduction_89 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymEqual happy_var_1) -> 
	happyIn11
		 (TokSymbol SymEqual happy_var_1
	)}

happyReduce_90 = happySpecReduce_1  2# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn11
		 (TokSymbol SymUnderscore happy_var_1
	)}

happyReduce_91 = happySpecReduce_1  2# happyReduction_91
happyReduction_91 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn11
		 (TokSymbol SymQuestionMark happy_var_1
	)}

happyReduce_92 = happySpecReduce_1  2# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymArrow happy_var_1) -> 
	happyIn11
		 (TokSymbol SymArrow happy_var_1
	)}

happyReduce_93 = happySpecReduce_1  2# happyReduction_93
happyReduction_93 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	happyIn11
		 (TokSymbol SymLambda happy_var_1
	)}

happyReduce_94 = happySpecReduce_1  2# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymAs happy_var_1) -> 
	happyIn11
		 (TokSymbol SymAs happy_var_1
	)}

happyReduce_95 = happySpecReduce_1  2# happyReduction_95
happyReduction_95 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymBar happy_var_1) -> 
	happyIn11
		 (TokSymbol SymBar happy_var_1
	)}

happyReduce_96 = happySpecReduce_1  2# happyReduction_96
happyReduction_96 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	happyIn11
		 (TokSymbol SymOpenParen happy_var_1
	)}

happyReduce_97 = happySpecReduce_1  2# happyReduction_97
happyReduction_97 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseParen happy_var_1) -> 
	happyIn11
		 (TokSymbol SymCloseParen happy_var_1
	)}

happyReduce_98 = happySpecReduce_1  2# happyReduction_98
happyReduction_98 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenIdiomBracket happy_var_1) -> 
	happyIn11
		 (TokSymbol SymOpenIdiomBracket happy_var_1
	)}

happyReduce_99 = happySpecReduce_1  2# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseIdiomBracket happy_var_1) -> 
	happyIn11
		 (TokSymbol SymCloseIdiomBracket happy_var_1
	)}

happyReduce_100 = happySpecReduce_1  2# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	happyIn11
		 (TokSymbol SymDoubleOpenBrace happy_var_1
	)}

happyReduce_101 = happySpecReduce_1  2# happyReduction_101
happyReduction_101 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn11
		 (TokSymbol SymDoubleCloseBrace happy_var_1
	)}

happyReduce_102 = happySpecReduce_1  2# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	happyIn11
		 (TokSymbol SymOpenBrace happy_var_1
	)}

happyReduce_103 = happySpecReduce_1  2# happyReduction_103
happyReduction_103 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	happyIn11
		 (TokSymbol SymCloseBrace happy_var_1
	)}

happyReduce_104 = happySpecReduce_1  2# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenVirtualBrace happy_var_1) -> 
	happyIn11
		 (TokSymbol SymOpenVirtualBrace happy_var_1
	)}

happyReduce_105 = happySpecReduce_1  2# happyReduction_105
happyReduction_105 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymCloseVirtualBrace happy_var_1) -> 
	happyIn11
		 (TokSymbol SymCloseVirtualBrace happy_var_1
	)}

happyReduce_106 = happySpecReduce_1  2# happyReduction_106
happyReduction_106 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn11
		 (TokSymbol SymVirtualSemi happy_var_1
	)}

happyReduce_107 = happySpecReduce_1  2# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	happyIn11
		 (TokSymbol SymOpenPragma happy_var_1
	)}

happyReduce_108 = happySpecReduce_1  2# happyReduction_108
happyReduction_108 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymClosePragma happy_var_1) -> 
	happyIn11
		 (TokSymbol SymClosePragma happy_var_1
	)}

happyReduce_109 = happySpecReduce_1  2# happyReduction_109
happyReduction_109 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn11
		 (TokId happy_var_1
	)}

happyReduce_110 = happySpecReduce_1  2# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	happyIn11
		 (TokQId happy_var_1
	)}

happyReduce_111 = happySpecReduce_1  2# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	happyIn11
		 (TokString happy_var_1
	)}

happyReduce_112 = happySpecReduce_1  2# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn11
		 (TokLiteral happy_var_1
	)}

happyReduce_113 = happySpecReduce_3  3# happyReduction_113
happyReduction_113 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut127 happy_x_2 of { happy_var_2 -> 
	happyIn12
		 (takeOptionsPragmas happy_var_2
	)}

happyReduce_114 = happySpecReduce_0  4# happyReduction_114
happyReduction_114  =  happyIn13
		 (()
	)

happyReduce_115 = happySpecReduce_1  4# happyReduction_115
happyReduction_115 happy_x_1
	 =  happyIn13
		 (()
	)

happyReduce_116 = happySpecReduce_1  5# happyReduction_116
happyReduction_116 happy_x_1
	 =  happyIn14
		 (()
	)

happyReduce_117 = happyMonadReduce 1# 5# happyReduction_117
happyReduction_117 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (( popContext)
	) (\r -> happyReturn (happyIn14 r))

happyReduce_118 = happySpecReduce_1  6# happyReduction_118
happyReduction_118 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymSemi happy_var_1) -> 
	happyIn15
		 (happy_var_1
	)}

happyReduce_119 = happySpecReduce_1  6# happyReduction_119
happyReduction_119 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymVirtualSemi happy_var_1) -> 
	happyIn15
		 (happy_var_1
	)}

happyReduce_120 = happyMonadReduce 0# 7# happyReduction_120
happyReduction_120 (happyRest) tk
	 = happyThen (( pushLexState imp_dir)
	) (\r -> happyReturn (happyIn16 r))

happyReduce_121 = happyMonadReduce 1# 8# happyReduction_121
happyReduction_121 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	( case happy_var_1 of {
                     LitNat _ i -> return i;
                     _          -> fail $ "Expected integer"
                   })}
	) (\r -> happyReturn (happyIn17 r))

happyReduce_122 = happyMonadReduce 1# 9# happyReduction_122
happyReduction_122 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	( mkName happy_var_1)}
	) (\r -> happyReturn (happyIn18 r))

happyReduce_123 = happySpecReduce_2  10# happyReduction_123
happyReduction_123 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	happyIn19
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_124 = happySpecReduce_1  10# happyReduction_124
happyReduction_124 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn19
		 ([happy_var_1]
	)}

happyReduce_125 = happySpecReduce_1  11# happyReduction_125
happyReduction_125 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleCloseBrace happy_var_1) -> 
	happyIn20
		 (getRange happy_var_1
	)}

happyReduce_126 = happyMonadReduce 2# 11# happyReduction_126
happyReduction_126 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymCloseBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	(
      if posPos (fromJust (rEnd' (getRange happy_var_2))) -
         posPos (fromJust (rStart' (getRange happy_var_1))) > 2
      then parseErrorAt (fromJust (rStart' (getRange happy_var_2)))
         "Expecting '}}', found separated '}'s."
      else return $ getRange (happy_var_1, happy_var_2))}}
	) (\r -> happyReturn (happyIn20 r))

happyReduce_127 = happySpecReduce_2  12# happyReduction_127
happyReduction_127 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_2 of { happy_var_2 -> 
	happyIn21
		 (setRelevance NonStrict $ defaultArg happy_var_2
	)}

happyReduce_128 = happySpecReduce_2  12# happyReduction_128
happyReduction_128 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_2 of { happy_var_2 -> 
	happyIn21
		 (setRelevance Irrelevant $ defaultArg happy_var_2
	)}

happyReduce_129 = happySpecReduce_1  12# happyReduction_129
happyReduction_129 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn21
		 (defaultArg happy_var_1
	)}

happyReduce_130 = happySpecReduce_2  13# happyReduction_130
happyReduction_130 happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn22
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_131 = happySpecReduce_1  13# happyReduction_131
happyReduction_131 happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	happyIn22
		 ([happy_var_1]
	)}

happyReduce_132 = happySpecReduce_2  14# happyReduction_132
happyReduction_132 happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	happyIn23
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_133 = happySpecReduce_1  14# happyReduction_133
happyReduction_133 happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	happyIn23
		 ([happy_var_1]
	)}

happyReduce_134 = happyReduce 4# 14# happyReduction_134
happyReduction_134 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_2 of { happy_var_2 -> 
	case happyOut23 happy_x_4 of { happy_var_4 -> 
	happyIn23
		 (map makeInstance happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_135 = happySpecReduce_3  14# happyReduction_135
happyReduction_135 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn23
		 (map makeInstance happy_var_2
	)}

happyReduce_136 = happyReduce 4# 14# happyReduction_136
happyReduction_136 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_2 of { happy_var_2 -> 
	case happyOut23 happy_x_4 of { happy_var_4 -> 
	happyIn23
		 (map hide happy_var_2 ++ happy_var_4
	) `HappyStk` happyRest}}

happyReduce_137 = happySpecReduce_3  14# happyReduction_137
happyReduction_137 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn23
		 (map hide happy_var_2
	)}

happyReduce_138 = happyReduce 5# 14# happyReduction_138
happyReduction_138 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut23 happy_x_5 of { happy_var_5 -> 
	happyIn23
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_139 = happyReduce 4# 14# happyReduction_139
happyReduction_139 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn23
		 (map (hide . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_140 = happyReduce 5# 14# happyReduction_140
happyReduction_140 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut23 happy_x_5 of { happy_var_5 -> 
	happyIn23
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_141 = happyReduce 4# 14# happyReduction_141
happyReduction_141 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn23
		 (map (makeInstance . setRelevance Irrelevant . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_142 = happyReduce 5# 14# happyReduction_142
happyReduction_142 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut23 happy_x_5 of { happy_var_5 -> 
	happyIn23
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_143 = happyReduce 4# 14# happyReduction_143
happyReduction_143 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn23
		 (map (hide . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_144 = happyReduce 5# 14# happyReduction_144
happyReduction_144 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut23 happy_x_5 of { happy_var_5 -> 
	happyIn23
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3 ++ happy_var_5
	) `HappyStk` happyRest}}

happyReduce_145 = happyReduce 4# 14# happyReduction_145
happyReduction_145 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut19 happy_x_3 of { happy_var_3 -> 
	happyIn23
		 (map (makeInstance . setRelevance NonStrict . defaultArg) happy_var_3
	) `HappyStk` happyRest}

happyReduce_146 = happyMonadReduce 1# 15# happyReduction_146
happyReduction_146 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokQId happy_var_1) -> 
	( mkQName happy_var_1)}
	) (\r -> happyReturn (happyIn24 r))

happyReduce_147 = happySpecReduce_1  15# happyReduction_147
happyReduction_147 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn24
		 (QName happy_var_1
	)}

happyReduce_148 = happySpecReduce_1  16# happyReduction_148
happyReduction_148 happy_x_1
	 =  case happyOut24 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 (happy_var_1
	)}

happyReduce_149 = happySpecReduce_1  17# happyReduction_149
happyReduction_149 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (happy_var_1
	)}

happyReduce_150 = happySpecReduce_1  17# happyReduction_150
happyReduction_150 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn26
		 (Name (getRange happy_var_1) [Hole]
	)}

happyReduce_151 = happySpecReduce_2  18# happyReduction_151
happyReduction_151 happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_152 = happySpecReduce_1  18# happyReduction_152
happyReduction_152 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 ([happy_var_1]
	)}

happyReduce_153 = happySpecReduce_1  19# happyReduction_153
happyReduction_153 happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (case happy_var_1 of
      Left ns -> ns
      Right _ -> fail $ "expected sequence of bound identifiers, not absurd pattern"
	)}

happyReduce_154 = happyMonadReduce 1# 20# happyReduction_154
happyReduction_154 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut40 happy_x_1 of { happy_var_1 -> 
	(
    let getName :: Expr -> Maybe Name
        getName (Ident (QName x)) = Just x
        getName (Underscore r _)  = Just (Name r [Hole])
        getName _                 = Nothing

        isAbsurd :: Expr -> Bool
        isAbsurd (Absurd _)                  = True
        isAbsurd (HiddenArg _ (Named _ e))   = isAbsurd e
        isAbsurd (InstanceArg _ (Named _ e)) = isAbsurd e
        isAbsurd (Paren _ expr)              = isAbsurd expr
        isAbsurd (RawApp _ exprs)            = any isAbsurd exprs
        isAbsurd _                           = False
    in
    if any isAbsurd happy_var_1 then return $ Right happy_var_1 else
    case mapM getName happy_var_1 of
        Just good -> return $ Left good
        Nothing   -> fail $ "expected sequence of bound identifiers")}
	) (\r -> happyReturn (happyIn29 r))

happyReduce_155 = happyMonadReduce 1# 21# happyReduction_155
happyReduction_155 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut40 happy_x_1 of { happy_var_1 -> 
	(
    let -- interpret an expression as name
        getName :: Expr -> Maybe Name
        getName (Ident (QName x)) = Just x
        getName (Underscore r _)  = Just (Name r [Hole])
        getName _                 = Nothing

        getNames :: Expr -> Maybe [Name]
        getNames (RawApp _ es) = mapM getName es
        getNames e             = singleton `fmap` getName e

        -- interpret an expression as name or list of hidden names
        getName1 :: Expr -> Maybe [WithHiding Name]
        getName1 (Ident (QName x)) = Just [WithHiding NotHidden x]
        getName1 (Underscore r _)  = Just [WithHiding NotHidden $ Name r [Hole]]
        getName1 (HiddenArg _ (Named Nothing e))
                                   = map (WithHiding Hidden) `fmap` getNames e
        getName1 _                 = Nothing

    in
    case mapM getName1 happy_var_1 of
        Just good -> return $ concat good
        Nothing   -> fail $ "expected sequence of possibly hidden bound identifiers")}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_156 = happySpecReduce_0  22# happyReduction_156
happyReduction_156  =  happyIn31
		 ([]
	)

happyReduce_157 = happySpecReduce_2  22# happyReduction_157
happyReduction_157 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut31 happy_x_2 of { happy_var_2 -> 
	happyIn31
		 (snd happy_var_1 : happy_var_2
	)}}

happyReduce_158 = happySpecReduce_1  23# happyReduction_158
happyReduction_158 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	happyIn32
		 (snd happy_var_1
	)}

happyReduce_159 = happySpecReduce_0  24# happyReduction_159
happyReduction_159  =  happyIn33
		 ([]
	)

happyReduce_160 = happySpecReduce_2  24# happyReduction_160
happyReduction_160 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	happyIn33
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_161 = happyMonadReduce 1# 25# happyReduction_161
happyReduction_161 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( mkName happy_var_1)}
	) (\r -> happyReturn (happyIn34 r))

happyReduce_162 = happyMonadReduce 1# 26# happyReduction_162
happyReduction_162 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( pragmaQName happy_var_1)}
	) (\r -> happyReturn (happyIn35 r))

happyReduce_163 = happyMonadReduce 1# 27# happyReduction_163
happyReduction_163 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	( mapM pragmaQName happy_var_1)}
	) (\r -> happyReturn (happyIn36 r))

happyReduce_164 = happySpecReduce_2  28# happyReduction_164
happyReduction_164 happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	happyIn37
		 (Pi happy_var_1 happy_var_2
	)}}

happyReduce_165 = happySpecReduce_3  28# happyReduction_165
happyReduction_165 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymArrow happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn37
		 (Fun (getRange (happy_var_1,happy_var_2,happy_var_3))
                                              (RawApp (getRange happy_var_1) happy_var_1)
                                              happy_var_3
	)}}}

happyReduce_166 = happySpecReduce_3  28# happyReduction_166
happyReduction_166 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymEqual happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn37
		 (Equal (getRange (happy_var_1, happy_var_2, happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_167 = happySpecReduce_1  28# happyReduction_167
happyReduction_167 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 (happy_var_1
	)}

happyReduce_168 = happyMonadReduce 1# 29# happyReduction_168
happyReduction_168 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut39 happy_x_1 of { happy_var_1 -> 
	( case happy_var_1 of
                      { [e]    -> return e
                      ; e : es -> return $ WithApp (fuseRange e es) e es
                      ; []     -> fail "impossible: empty with expressions"
                      })}
	) (\r -> happyReturn (happyIn38 r))

happyReduce_169 = happySpecReduce_3  30# happyReduction_169
happyReduction_169 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	happyIn39
		 (RawApp (getRange happy_var_1) happy_var_1 :  happy_var_3
	)}}

happyReduce_170 = happySpecReduce_1  30# happyReduction_170
happyReduction_170 happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	happyIn39
		 ([RawApp (getRange happy_var_1) happy_var_1]
	)}

happyReduce_171 = happySpecReduce_1  31# happyReduction_171
happyReduction_171 happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	happyIn40
		 ([happy_var_1]
	)}

happyReduce_172 = happySpecReduce_2  31# happyReduction_172
happyReduction_172 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut40 happy_x_2 of { happy_var_2 -> 
	happyIn40
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_173 = happySpecReduce_3  32# happyReduction_173
happyReduction_173 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut60 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (Lam (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2 happy_var_3
	)}}}

happyReduce_174 = happySpecReduce_1  32# happyReduction_174
happyReduction_174 happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 (happy_var_1
	)}

happyReduce_175 = happySpecReduce_3  32# happyReduction_175
happyReduction_175 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut68 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (forallPi happy_var_2 happy_var_3
	)}}

happyReduce_176 = happyReduce 4# 32# happyReduction_176
happyReduction_176 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwLet happy_var_1) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwIn happy_var_3) -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	happyIn41
		 (Let (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_177 = happySpecReduce_1  32# happyReduction_177
happyReduction_177 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 (happy_var_1
	)}

happyReduce_178 = happyReduce 4# 32# happyReduction_178
happyReduction_178 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwQuoteGoal happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwIn happy_var_3) -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	happyIn41
		 (QuoteGoal (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_179 = happySpecReduce_2  32# happyReduction_179
happyReduction_179 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	case happyOut43 happy_x_2 of { happy_var_2 -> 
	happyIn41
		 (Tactic (getRange (happy_var_1, happy_var_2)) (RawApp (getRange happy_var_2) happy_var_2) []
	)}}

happyReduce_180 = happyReduce 4# 32# happyReduction_180
happyReduction_180 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwTactic happy_var_1) -> 
	case happyOut43 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymBar happy_var_3) -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	happyIn41
		 (Tactic (getRange (happy_var_1, happy_var_2, happy_var_3, happy_var_4)) (RawApp (getRange happy_var_2) happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_181 = happyReduce 4# 33# happyReduction_181
happyReduction_181 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut67 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn42
		 (ExtendedLam (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) (reverse happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_182 = happyReduce 5# 33# happyReduction_182
happyReduction_182 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwWhere happy_var_2) -> 
	case happyOut67 happy_x_4 of { happy_var_4 -> 
	happyIn42
		 (ExtendedLam (getRange (happy_var_1, happy_var_2, happy_var_4)) (reverse happy_var_4)
	) `HappyStk` happyRest}}}

happyReduce_183 = happyMonadReduce 2# 33# happyReduction_183
happyReduction_183 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymLambda happy_var_1) -> 
	case happyOut61 happy_x_2 of { happy_var_2 -> 
	( case happy_var_2 of
                                       Left (bs, h) -> if null bs then return $ AbsurdLam r h else
                                                       return $ Lam r bs (AbsurdLam r h)
                                                         where r = fuseRange happy_var_1 bs
                                       Right es -> do -- it is of the form @\ { p1 ... () }@
                                                     p <- exprToLHS (RawApp (getRange es) es);
                                                     return $ ExtendedLam (fuseRange happy_var_1 es)
                                                                     [(p [] [], AbsurdRHS, NoWhere, False)])}}
	) (\r -> happyReturn (happyIn42 r))

happyReduce_184 = happySpecReduce_1  34# happyReduction_184
happyReduction_184 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 ([happy_var_1]
	)}

happyReduce_185 = happySpecReduce_2  34# happyReduction_185
happyReduction_185 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut43 happy_x_2 of { happy_var_2 -> 
	happyIn43
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_186 = happySpecReduce_3  35# happyReduction_186
happyReduction_186 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn44
		 (HiddenArg (getRange (happy_var_1,happy_var_2,happy_var_3)) (maybeNamed happy_var_2)
	)}}}

happyReduce_187 = happySpecReduce_2  35# happyReduction_187
happyReduction_187 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseBrace happy_var_2) -> 
	happyIn44
		 (let r = fuseRange happy_var_1 happy_var_2 in HiddenArg r $ unnamed $ Absurd r
	)}}

happyReduce_188 = happySpecReduce_1  36# happyReduction_188
happyReduction_188 happy_x_1
	 =  case happyOut24 happy_x_1 of { happy_var_1 -> 
	happyIn45
		 (Ident happy_var_1
	)}

happyReduce_189 = happySpecReduce_1  36# happyReduction_189
happyReduction_189 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokLiteral happy_var_1) -> 
	happyIn45
		 (Lit happy_var_1
	)}

happyReduce_190 = happySpecReduce_1  36# happyReduction_190
happyReduction_190 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymQuestionMark happy_var_1) -> 
	happyIn45
		 (QuestionMark (getRange happy_var_1) Nothing
	)}

happyReduce_191 = happySpecReduce_1  36# happyReduction_191
happyReduction_191 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn45
		 (Underscore (getRange happy_var_1) Nothing
	)}

happyReduce_192 = happySpecReduce_1  36# happyReduction_192
happyReduction_192 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwProp happy_var_1) -> 
	happyIn45
		 (Prop (getRange happy_var_1)
	)}

happyReduce_193 = happySpecReduce_1  36# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwSet happy_var_1) -> 
	happyIn45
		 (Set (getRange happy_var_1)
	)}

happyReduce_194 = happySpecReduce_1  36# happyReduction_194
happyReduction_194 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuote happy_var_1) -> 
	happyIn45
		 (Quote (getRange happy_var_1)
	)}

happyReduce_195 = happySpecReduce_1  36# happyReduction_195
happyReduction_195 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteTerm happy_var_1) -> 
	happyIn45
		 (QuoteTerm (getRange happy_var_1)
	)}

happyReduce_196 = happySpecReduce_1  36# happyReduction_196
happyReduction_196 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwQuoteContext happy_var_1) -> 
	happyIn45
		 (QuoteContext (getRange happy_var_1)
	)}

happyReduce_197 = happySpecReduce_1  36# happyReduction_197
happyReduction_197 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquote happy_var_1) -> 
	happyIn45
		 (Unquote (getRange happy_var_1)
	)}

happyReduce_198 = happySpecReduce_1  36# happyReduction_198
happyReduction_198 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSetN happy_var_1) -> 
	happyIn45
		 (SetN (getRange (fst happy_var_1)) (snd happy_var_1)
	)}

happyReduce_199 = happySpecReduce_3  36# happyReduction_199
happyReduction_199 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn45
		 (InstanceArg (getRange (happy_var_1,happy_var_2,happy_var_3))
                                                          (maybeNamed happy_var_2)
	)}}}

happyReduce_200 = happySpecReduce_3  36# happyReduction_200
happyReduction_200 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn45
		 (Paren (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_201 = happySpecReduce_3  36# happyReduction_201
happyReduction_201 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenIdiomBracket happy_var_1) -> 
	case happyOut37 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseIdiomBracket happy_var_3) -> 
	happyIn45
		 (IdiomBrackets (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_202 = happySpecReduce_2  36# happyReduction_202
happyReduction_202 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymCloseParen happy_var_2) -> 
	happyIn45
		 (Absurd (fuseRange happy_var_1 happy_var_2)
	)}}

happyReduce_203 = happySpecReduce_2  36# happyReduction_203
happyReduction_203 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut20 happy_x_2 of { happy_var_2 -> 
	happyIn45
		 (let r = fuseRange happy_var_1 happy_var_2 in InstanceArg r $ unnamed $ Absurd r
	)}}

happyReduce_204 = happySpecReduce_3  36# happyReduction_204
happyReduction_204 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymAs happy_var_2) -> 
	case happyOut46 happy_x_3 of { happy_var_3 -> 
	happyIn45
		 (As (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_1 happy_var_3
	)}}}

happyReduce_205 = happySpecReduce_2  36# happyReduction_205
happyReduction_205 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDot happy_var_1) -> 
	case happyOut46 happy_x_2 of { happy_var_2 -> 
	happyIn45
		 (Dot (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_206 = happyReduce 4# 36# happyReduction_206
happyReduction_206 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn45
		 (Rec (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_207 = happyReduce 5# 36# happyReduction_207
happyReduction_207 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut45 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymOpenBrace happy_var_3) -> 
	case happyOut51 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymCloseBrace happy_var_5) -> 
	happyIn45
		 (RecUpdate (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_208 = happySpecReduce_1  37# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	happyIn46
		 (happy_var_1
	)}

happyReduce_209 = happySpecReduce_1  37# happyReduction_209
happyReduction_209 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn46
		 (happy_var_1
	)}

happyReduce_210 = happySpecReduce_0  38# happyReduction_210
happyReduction_210  =  happyIn47
		 ([]
	)

happyReduce_211 = happySpecReduce_1  38# happyReduction_211
happyReduction_211 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn47
		 (happy_var_1
	)}

happyReduce_212 = happySpecReduce_1  39# happyReduction_212
happyReduction_212 happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 ([happy_var_1]
	)}

happyReduce_213 = happySpecReduce_3  39# happyReduction_213
happyReduction_213 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	happyIn48
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_214 = happySpecReduce_1  40# happyReduction_214
happyReduction_214 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (Left  happy_var_1
	)}

happyReduce_215 = happySpecReduce_1  40# happyReduction_215
happyReduction_215 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (Right happy_var_1
	)}

happyReduce_216 = happySpecReduce_3  41# happyReduction_216
happyReduction_216 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOut122 happy_x_2 of { happy_var_2 -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	happyIn50
		 (ModuleAssignment happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_217 = happySpecReduce_0  42# happyReduction_217
happyReduction_217  =  happyIn51
		 ([]
	)

happyReduce_218 = happySpecReduce_1  42# happyReduction_218
happyReduction_218 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (happy_var_1
	)}

happyReduce_219 = happySpecReduce_1  43# happyReduction_219
happyReduction_219 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn52
		 ([happy_var_1]
	)}

happyReduce_220 = happySpecReduce_3  43# happyReduction_220
happyReduction_220 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_3 of { happy_var_3 -> 
	happyIn52
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_221 = happySpecReduce_3  44# happyReduction_221
happyReduction_221 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn53
		 (FieldAssignment happy_var_1 happy_var_3
	)}}

happyReduce_222 = happySpecReduce_2  45# happyReduction_222
happyReduction_222 happy_x_2
	happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_223 = happySpecReduce_1  46# happyReduction_223
happyReduction_223 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 ({-TeleBind-} happy_var_1
	)}

happyReduce_224 = happySpecReduce_2  47# happyReduction_224
happyReduction_224 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut56 happy_x_2 of { happy_var_2 -> 
	happyIn56
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_225 = happySpecReduce_1  47# happyReduction_225
happyReduction_225 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn56
		 ([happy_var_1]
	)}

happyReduce_226 = happyReduce 4# 48# happyReduction_226
happyReduction_226 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut59 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn57
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_227 = happyReduce 4# 48# happyReduction_227
happyReduction_227 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn57
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Hidden $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_228 = happyReduce 4# 48# happyReduction_228
happyReduction_228 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn57
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Instance $
                             setRelevance Irrelevant happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_229 = happyReduce 4# 48# happyReduction_229
happyReduction_229 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut59 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn57
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_230 = happyReduce 4# 48# happyReduction_230
happyReduction_230 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymOpenBrace happy_var_2) -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseBrace happy_var_4) -> 
	happyIn57
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Hidden $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_231 = happyReduce 4# 48# happyReduction_231
happyReduction_231 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn57
		 (setRange (getRange (happy_var_2,happy_var_3,happy_var_4)) $
                             setHiding Instance $
                             setRelevance NonStrict happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_232 = happySpecReduce_3  48# happyReduction_232
happyReduction_232 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn57
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) happy_var_2
	)}}}

happyReduce_233 = happySpecReduce_3  48# happyReduction_233
happyReduction_233 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymDoubleOpenBrace happy_var_1) -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	case happyOut20 happy_x_3 of { happy_var_3 -> 
	happyIn57
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             setHiding Instance happy_var_2
	)}}}

happyReduce_234 = happySpecReduce_3  48# happyReduction_234
happyReduction_234 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenBrace happy_var_1) -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseBrace happy_var_3) -> 
	happyIn57
		 (setRange (getRange (happy_var_1,happy_var_2,happy_var_3)) $
                             setHiding Hidden happy_var_2
	)}}}

happyReduce_235 = happySpecReduce_3  48# happyReduction_235
happyReduction_235 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut121 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn57
		 (tLet (getRange (happy_var_1,happy_var_3)) happy_var_2
	)}}}

happyReduce_236 = happyReduce 4# 48# happyReduction_236
happyReduction_236 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenParen happy_var_1) -> 
	case happyOut167 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn57
		 (tLet (getRange (happy_var_1,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}

happyReduce_237 = happySpecReduce_3  49# happyReduction_237
happyReduction_237 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymColon happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn58
		 (let r = getRange (happy_var_1,happy_var_2,happy_var_3) -- the range is approximate only for TypedBindings
    in TypedBindings r $ defaultArg $ TBind r (map (pure . mkBoundName_) happy_var_1) happy_var_3
	)}}}

happyReduce_238 = happySpecReduce_3  50# happyReduction_238
happyReduction_238 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymColon happy_var_2) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 (let r = getRange (happy_var_1,happy_var_2,happy_var_3) -- the range is approximate only for TypedBindings
    in TypedBindings r $ defaultArg $ TBind r (map (fmap mkBoundName_) happy_var_1) happy_var_3
	)}}}

happyReduce_239 = happyMonadReduce 2# 51# happyReduction_239
happyReduction_239 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut62 happy_x_1 of { happy_var_1 -> 
	(
      case reverse happy_var_1 of
        Left _ : _ -> parseError "Absurd lambda cannot have a body."
        _ : _      -> return [ b | Right b <- happy_var_1 ]
        []         -> parsePanic "Empty LamBinds")}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_240 = happyMonadReduce 1# 52# happyReduction_240
happyReduction_240 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut63 happy_x_1 of { happy_var_1 -> 
	(
    case happy_var_1 of
      Left lb -> case reverse lb of
                   Right _ : _ -> parseError "Missing body for lambda"
                   Left h  : _ -> return $ Left ([ b | Right b <- init lb], h)
                   _           -> parseError "Unsupported variant of lambda"
      Right es -> return $ Right es)}
	) (\r -> happyReturn (happyIn61 r))

happyReduce_241 = happySpecReduce_2  53# happyReduction_241
happyReduction_241 happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	happyIn62
		 (map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_242 = happySpecReduce_2  53# happyReduction_242
happyReduction_242 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	happyIn62
		 (Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_243 = happySpecReduce_1  53# happyReduction_243
happyReduction_243 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 (map Right happy_var_1
	)}

happyReduce_244 = happySpecReduce_1  53# happyReduction_244
happyReduction_244 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 ([Right $ DomainFull happy_var_1]
	)}

happyReduce_245 = happySpecReduce_2  53# happyReduction_245
happyReduction_245 happy_x_2
	happy_x_1
	 =  happyIn62
		 ([Left NotHidden]
	)

happyReduce_246 = happySpecReduce_2  53# happyReduction_246
happyReduction_246 happy_x_2
	happy_x_1
	 =  happyIn62
		 ([Left Hidden]
	)

happyReduce_247 = happySpecReduce_2  53# happyReduction_247
happyReduction_247 happy_x_2
	happy_x_1
	 =  happyIn62
		 ([Left Instance]
	)

happyReduce_248 = happySpecReduce_2  54# happyReduction_248
happyReduction_248 happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	happyIn63
		 (Left $ map Right happy_var_1 ++ happy_var_2
	)}}

happyReduce_249 = happySpecReduce_2  54# happyReduction_249
happyReduction_249 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	happyIn63
		 (Left $ Right (DomainFull happy_var_1) : happy_var_2
	)}}

happyReduce_250 = happySpecReduce_1  54# happyReduction_250
happyReduction_250 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn63
		 (case happy_var_1 of
                                    Left lb -> Left $ map Right lb
                                    Right es -> Right es
	)}

happyReduce_251 = happySpecReduce_1  54# happyReduction_251
happyReduction_251 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn63
		 (Left [Right $ DomainFull happy_var_1]
	)}

happyReduce_252 = happySpecReduce_2  54# happyReduction_252
happyReduction_252 happy_x_2
	happy_x_1
	 =  happyIn63
		 (Left [Left NotHidden]
	)

happyReduce_253 = happySpecReduce_2  54# happyReduction_253
happyReduction_253 happy_x_2
	happy_x_1
	 =  happyIn63
		 (Left [Left Hidden]
	)

happyReduce_254 = happySpecReduce_2  54# happyReduction_254
happyReduction_254 happy_x_2
	happy_x_1
	 =  happyIn63
		 (Left [Left Instance]
	)

happyReduce_255 = happyMonadReduce 3# 55# happyReduction_255
happyReduction_255 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1) ;
      return (p [] [], RHS happy_var_3, NoWhere, False))}}
	) (\r -> happyReturn (happyIn64 r))

happyReduce_256 = happyMonadReduce 4# 55# happyReduction_256
happyReduction_256 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut43 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_2) happy_var_2) ;
      return (p [] [], RHS happy_var_4, NoWhere, True))}}
	) (\r -> happyReturn (happyIn64 r))

happyReduce_257 = happyMonadReduce 1# 56# happyReduction_257
happyReduction_257 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut40 happy_x_1 of { happy_var_1 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_1) happy_var_1);
      return (p [] [], AbsurdRHS, NoWhere, False))}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_258 = happyMonadReduce 2# 56# happyReduction_258
happyReduction_258 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut40 happy_x_2 of { happy_var_2 -> 
	( do
      p <- exprToLHS (RawApp (getRange happy_var_2) happy_var_2);
      return (p [] [], AbsurdRHS, NoWhere, True))}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_259 = happySpecReduce_1  57# happyReduction_259
happyReduction_259 happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (happy_var_1
	)}

happyReduce_260 = happySpecReduce_1  57# happyReduction_260
happyReduction_260 happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (happy_var_1
	)}

happyReduce_261 = happySpecReduce_3  58# happyReduction_261
happyReduction_261 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn67
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_262 = happySpecReduce_3  58# happyReduction_262
happyReduction_262 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn67
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_263 = happySpecReduce_1  58# happyReduction_263
happyReduction_263 happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 ([happy_var_1]
	)}

happyReduce_264 = happySpecReduce_2  59# happyReduction_264
happyReduction_264 happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (happy_var_1
	)}

happyReduce_265 = happySpecReduce_2  60# happyReduction_265
happyReduction_265 happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut69 happy_x_2 of { happy_var_2 -> 
	happyIn69
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_266 = happySpecReduce_2  60# happyReduction_266
happyReduction_266 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut69 happy_x_2 of { happy_var_2 -> 
	happyIn69
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_267 = happySpecReduce_1  60# happyReduction_267
happyReduction_267 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn69
		 (happy_var_1
	)}

happyReduce_268 = happySpecReduce_1  60# happyReduction_268
happyReduction_268 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn69
		 ([DomainFull happy_var_1]
	)}

happyReduce_269 = happySpecReduce_2  61# happyReduction_269
happyReduction_269 happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	happyIn70
		 (happy_var_1 ++ happy_var_2
	)}}

happyReduce_270 = happySpecReduce_2  61# happyReduction_270
happyReduction_270 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_2 of { happy_var_2 -> 
	happyIn70
		 (DomainFull happy_var_1 : happy_var_2
	)}}

happyReduce_271 = happySpecReduce_0  61# happyReduction_271
happyReduction_271  =  happyIn70
		 ([]
	)

happyReduce_272 = happySpecReduce_1  62# happyReduction_272
happyReduction_272 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 (case happy_var_1 of
                             Left lbs -> lbs
                             Right _ -> fail "expected sequence of bound identifiers, not absurd pattern"
	)}

happyReduce_273 = happySpecReduce_1  63# happyReduction_273
happyReduction_273 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn72
		 (Left [DomainFree defaultArgInfo $ mkBoundName_ happy_var_1]
	)}

happyReduce_274 = happySpecReduce_2  63# happyReduction_274
happyReduction_274 happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_2 of { happy_var_2 -> 
	happyIn72
		 (Left [DomainFree (setRelevance Irrelevant $ defaultArgInfo) $ mkBoundName_ happy_var_2]
	)}

happyReduce_275 = happySpecReduce_2  63# happyReduction_275
happyReduction_275 happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_2 of { happy_var_2 -> 
	happyIn72
		 (Left [DomainFree (setRelevance NonStrict $ defaultArgInfo) $ mkBoundName_ happy_var_2]
	)}

happyReduce_276 = happySpecReduce_3  63# happyReduction_276
happyReduction_276 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut29 happy_x_2 of { happy_var_2 -> 
	happyIn72
		 (mapLeft (map (DomainFree (setHiding Hidden $ defaultArgInfo) . mkBoundName_)) happy_var_2
	)}

happyReduce_277 = happySpecReduce_3  63# happyReduction_277
happyReduction_277 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_2 of { happy_var_2 -> 
	happyIn72
		 (Left $ map (DomainFree (setHiding Instance $ defaultArgInfo) . mkBoundName_) happy_var_2
	)}

happyReduce_278 = happyReduce 4# 63# happyReduction_278
happyReduction_278 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (Left $ map (DomainFree (setHiding Hidden $ setRelevance Irrelevant $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_279 = happyReduce 4# 63# happyReduction_279
happyReduction_279 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (Left $ map (DomainFree (setHiding Instance $ setRelevance Irrelevant $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_280 = happyReduce 4# 63# happyReduction_280
happyReduction_280 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (Left $ map (DomainFree (setHiding Hidden $ setRelevance NonStrict $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_281 = happyReduce 4# 63# happyReduction_281
happyReduction_281 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut28 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (Left $ map (DomainFree  (setHiding Instance $ setRelevance NonStrict $ defaultArgInfo) . mkBoundName_) happy_var_3
	) `HappyStk` happyRest}

happyReduce_282 = happyMonadReduce 1# 64# happyReduction_282
happyReduction_282 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut74 happy_x_1 of { happy_var_1 -> 
	( mergeImportDirectives happy_var_1)}
	) (\r -> happyReturn (happyIn73 r))

happyReduce_283 = happySpecReduce_2  65# happyReduction_283
happyReduction_283 happy_x_2
	happy_x_1
	 =  case happyOut75 happy_x_1 of { happy_var_1 -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	happyIn74
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_284 = happySpecReduce_0  65# happyReduction_284
happyReduction_284  =  happyIn74
		 ([]
	)

happyReduce_285 = happySpecReduce_1  66# happyReduction_285
happyReduction_285 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPublic happy_var_1) -> 
	happyIn75
		 (defaultImportDir { importDirRange = getRange happy_var_1, publicOpen = True }
	)}

happyReduce_286 = happySpecReduce_1  66# happyReduction_286
happyReduction_286 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (defaultImportDir { importDirRange = snd happy_var_1, using    = fst happy_var_1 }
	)}

happyReduce_287 = happySpecReduce_1  66# happyReduction_287
happyReduction_287 happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (defaultImportDir { importDirRange = snd happy_var_1, hiding   = fst happy_var_1 }
	)}

happyReduce_288 = happySpecReduce_1  66# happyReduction_288
happyReduction_288 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (defaultImportDir { importDirRange = snd happy_var_1, impRenaming = fst happy_var_1 }
	)}

happyReduce_289 = happyReduce 4# 67# happyReduction_289
happyReduction_289 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUsing happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn76
		 ((Using happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_290 = happyReduce 4# 68# happyReduction_290
happyReduction_290 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwHiding happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn77
		 ((happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_291 = happyReduce 4# 69# happyReduction_291
happyReduction_291 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymCloseParen happy_var_4) -> 
	happyIn78
		 ((happy_var_3 , getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4))
	) `HappyStk` happyRest}}}}

happyReduce_292 = happySpecReduce_3  69# happyReduction_292
happyReduction_292 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwRenaming happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymOpenParen happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymCloseParen happy_var_3) -> 
	happyIn78
		 (([] , getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_293 = happySpecReduce_3  70# happyReduction_293
happyReduction_293 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	happyIn79
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_294 = happySpecReduce_1  70# happyReduction_294
happyReduction_294 happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	happyIn79
		 ([happy_var_1]
	)}

happyReduce_295 = happySpecReduce_3  71# happyReduction_295
happyReduction_295 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwTo happy_var_2) -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn80
		 (Renaming happy_var_1 (setImportedName happy_var_1 happy_var_3) (getRange happy_var_2)
	)}}}

happyReduce_296 = happySpecReduce_2  72# happyReduction_296
happyReduction_296 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_2 of { happy_var_2 -> 
	happyIn81
		 (ImportedName happy_var_2
	)}

happyReduce_297 = happySpecReduce_3  72# happyReduction_297
happyReduction_297 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn81
		 (ImportedModule happy_var_3
	)}

happyReduce_298 = happySpecReduce_1  73# happyReduction_298
happyReduction_298 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn82
		 (ImportedName happy_var_1
	)}

happyReduce_299 = happySpecReduce_2  73# happyReduction_299
happyReduction_299 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_2 of { happy_var_2 -> 
	happyIn82
		 (ImportedModule happy_var_2
	)}

happyReduce_300 = happySpecReduce_0  74# happyReduction_300
happyReduction_300  =  happyIn83
		 ([]
	)

happyReduce_301 = happySpecReduce_1  74# happyReduction_301
happyReduction_301 happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	happyIn83
		 (happy_var_1
	)}

happyReduce_302 = happySpecReduce_1  75# happyReduction_302
happyReduction_302 happy_x_1
	 =  case happyOut82 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 ([happy_var_1]
	)}

happyReduce_303 = happySpecReduce_3  75# happyReduction_303
happyReduction_303 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut82 happy_x_1 of { happy_var_1 -> 
	case happyOut84 happy_x_3 of { happy_var_3 -> 
	happyIn84
		 (happy_var_1 : happy_var_3
	)}}

happyReduce_304 = happyMonadReduce 3# 76# happyReduction_304
happyReduction_304 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	case happyOut87 happy_x_3 of { happy_var_3 -> 
	( exprToLHS happy_var_1 >>= \p -> return (p happy_var_2 happy_var_3))}}}
	) (\r -> happyReturn (happyIn85 r))

happyReduce_305 = happyReduce 4# 76# happyReduction_305
happyReduction_305 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymEllipsis happy_var_1) -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	case happyOut88 happy_x_3 of { happy_var_3 -> 
	case happyOut87 happy_x_4 of { happy_var_4 -> 
	happyIn85
		 (Ellipsis (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_2 happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}

happyReduce_306 = happySpecReduce_0  77# happyReduction_306
happyReduction_306  =  happyIn86
		 ([]
	)

happyReduce_307 = happyMonadReduce 3# 77# happyReduction_307
happyReduction_307 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut43 happy_x_2 of { happy_var_2 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	( exprToPattern (RawApp (getRange happy_var_2) happy_var_2) >>= \p ->
                   return (p : happy_var_3))}}
	) (\r -> happyReturn (happyIn86 r))

happyReduce_308 = happySpecReduce_0  78# happyReduction_308
happyReduction_308  =  happyIn87
		 ([]
	)

happyReduce_309 = happySpecReduce_2  78# happyReduction_309
happyReduction_309 happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_2 of { happy_var_2 -> 
	happyIn87
		 (case happy_var_2 of { WithApp _ e es -> e : es; e -> [e] }
	)}

happyReduce_310 = happySpecReduce_0  79# happyReduction_310
happyReduction_310  =  happyIn88
		 ([]
	)

happyReduce_311 = happySpecReduce_2  79# happyReduction_311
happyReduction_311 happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_2 of { happy_var_2 -> 
	happyIn88
		 (case happy_var_2 of { WithApp _ e es -> e : es; e -> [e] }
	)}

happyReduce_312 = happySpecReduce_0  80# happyReduction_312
happyReduction_312  =  happyIn89
		 (NoWhere
	)

happyReduce_313 = happySpecReduce_2  80# happyReduction_313
happyReduction_313 happy_x_2
	happy_x_1
	 =  case happyOut168 happy_x_2 of { happy_var_2 -> 
	happyIn89
		 (AnyWhere happy_var_2
	)}

happyReduce_314 = happyReduce 4# 80# happyReduction_314
happyReduction_314 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut168 happy_x_4 of { happy_var_4 -> 
	happyIn89
		 (SomeWhere happy_var_2 PublicAccess happy_var_4
	) `HappyStk` happyRest}}

happyReduce_315 = happyReduce 4# 80# happyReduction_315
happyReduction_315 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut126 happy_x_2 of { happy_var_2 -> 
	case happyOut168 happy_x_4 of { happy_var_4 -> 
	happyIn89
		 (SomeWhere happy_var_2 PublicAccess happy_var_4
	) `HappyStk` happyRest}}

happyReduce_316 = happySpecReduce_2  81# happyReduction_316
happyReduction_316 happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	case happyOut89 happy_x_2 of { happy_var_2 -> 
	happyIn90
		 (ExprWhere happy_var_1 happy_var_2
	)}}

happyReduce_317 = happySpecReduce_1  82# happyReduction_317
happyReduction_317 happy_x_1
	 =  case happyOut102 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 (happy_var_1
	)}

happyReduce_318 = happySpecReduce_1  82# happyReduction_318
happyReduction_318 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 (happy_var_1
	)}

happyReduce_319 = happySpecReduce_1  82# happyReduction_319
happyReduction_319 happy_x_1
	 =  case happyOut96 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_320 = happySpecReduce_1  82# happyReduction_320
happyReduction_320 happy_x_1
	 =  case happyOut97 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_321 = happySpecReduce_1  82# happyReduction_321
happyReduction_321 happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_322 = happySpecReduce_1  82# happyReduction_322
happyReduction_322 happy_x_1
	 =  case happyOut99 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_323 = happySpecReduce_1  82# happyReduction_323
happyReduction_323 happy_x_1
	 =  case happyOut101 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_324 = happySpecReduce_1  82# happyReduction_324
happyReduction_324 happy_x_1
	 =  case happyOut103 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_325 = happySpecReduce_1  82# happyReduction_325
happyReduction_325 happy_x_1
	 =  case happyOut104 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_326 = happySpecReduce_1  82# happyReduction_326
happyReduction_326 happy_x_1
	 =  case happyOut105 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_327 = happySpecReduce_1  82# happyReduction_327
happyReduction_327 happy_x_1
	 =  case happyOut106 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_328 = happySpecReduce_1  82# happyReduction_328
happyReduction_328 happy_x_1
	 =  case happyOut107 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_329 = happySpecReduce_1  82# happyReduction_329
happyReduction_329 happy_x_1
	 =  case happyOut108 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_330 = happySpecReduce_1  82# happyReduction_330
happyReduction_330 happy_x_1
	 =  case happyOut109 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_331 = happySpecReduce_1  82# happyReduction_331
happyReduction_331 happy_x_1
	 =  case happyOut121 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 (happy_var_1
	)}

happyReduce_332 = happySpecReduce_1  82# happyReduction_332
happyReduction_332 happy_x_1
	 =  case happyOut124 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_333 = happySpecReduce_1  82# happyReduction_333
happyReduction_333 happy_x_1
	 =  case happyOut125 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_334 = happySpecReduce_1  82# happyReduction_334
happyReduction_334 happy_x_1
	 =  case happyOut128 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_335 = happySpecReduce_1  82# happyReduction_335
happyReduction_335 happy_x_1
	 =  case happyOut111 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_336 = happySpecReduce_1  82# happyReduction_336
happyReduction_336 happy_x_1
	 =  case happyOut112 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_337 = happySpecReduce_1  82# happyReduction_337
happyReduction_337 happy_x_1
	 =  case happyOut110 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 ([happy_var_1]
	)}

happyReduce_338 = happySpecReduce_3  83# happyReduction_338
happyReduction_338 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut19 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn92
		 (map (\ x -> TypeSig defaultArgInfo x happy_var_3) happy_var_1
	)}}

happyReduce_339 = happySpecReduce_3  84# happyReduction_339
happyReduction_339 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn93
		 (map (fmap (\ x -> TypeSig defaultArgInfo x happy_var_3)) happy_var_1
	)}}

happyReduce_340 = happyReduce 4# 84# happyReduction_340
happyReduction_340 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut23 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	happyIn93
		 (let setOverlap (Arg i x) = Arg i{ argInfoOverlappable = True } x in
      map (setOverlap . fmap (\ x -> TypeSig defaultArgInfo x happy_var_4)) happy_var_2
	) `HappyStk` happyRest}}

happyReduce_341 = happySpecReduce_2  84# happyReduction_341
happyReduction_341 happy_x_2
	happy_x_1
	 =  case happyOut160 happy_x_2 of { happy_var_2 -> 
	happyIn93
		 (let
      setInstance (TypeSig info x t) = TypeSig (setHiding Instance info) x t
      setInstance _ = __IMPOSSIBLE__ in
    map (fmap setInstance) happy_var_2
	)}

happyReduce_342 = happyMonadReduce 3# 85# happyReduction_342
happyReduction_342 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut85 happy_x_1 of { happy_var_1 -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOut89 happy_x_3 of { happy_var_3 -> 
	( funClauseOrTypeSigs happy_var_1 happy_var_2 happy_var_3)}}}
	) (\r -> happyReturn (happyIn94 r))

happyReduce_343 = happySpecReduce_2  86# happyReduction_343
happyReduction_343 happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_2 of { happy_var_2 -> 
	happyIn95
		 (JustRHS (RHS happy_var_2)
	)}

happyReduce_344 = happySpecReduce_2  86# happyReduction_344
happyReduction_344 happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_2 of { happy_var_2 -> 
	happyIn95
		 (TypeSigsRHS happy_var_2
	)}

happyReduce_345 = happySpecReduce_0  86# happyReduction_345
happyReduction_345  =  happyIn95
		 (JustRHS AbsurdRHS
	)

happyReduce_346 = happyReduce 7# 87# happyReduction_346
happyReduction_346 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut37 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut168 happy_x_7 of { happy_var_7 -> 
	happyIn96
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) Inductive happy_var_2 happy_var_3 (Just happy_var_5) happy_var_7
	) `HappyStk` happyRest}}}}}}}

happyReduce_347 = happyReduce 7# 87# happyReduction_347
happyReduction_347 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut37 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut168 happy_x_7 of { happy_var_7 -> 
	happyIn96
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) CoInductive happy_var_2 happy_var_3 (Just happy_var_5) happy_var_7
	) `HappyStk` happyRest}}}}}}}

happyReduce_348 = happyReduce 5# 87# happyReduction_348
happyReduction_348 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut168 happy_x_5 of { happy_var_5 -> 
	happyIn96
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) Inductive happy_var_2 happy_var_3 Nothing happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_349 = happyReduce 5# 87# happyReduction_349
happyReduction_349 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwCoData happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut168 happy_x_5 of { happy_var_5 -> 
	happyIn96
		 (Data (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) CoInductive happy_var_2 happy_var_3 Nothing happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_350 = happyReduce 5# 88# happyReduction_350
happyReduction_350 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwData happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut37 happy_x_5 of { happy_var_5 -> 
	happyIn97
		 (DataSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) Inductive happy_var_2 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_351 = happyMonadReduce 7# 89# happyReduction_351
happyReduction_351 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut45 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut37 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokKeyword KwWhere happy_var_6) -> 
	case happyOut162 happy_x_7 of { happy_var_7 -> 
	( exprToName happy_var_2 >>= \ n -> let ((x,y,z),ds) = happy_var_7 in return $ Record (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5,happy_var_6,happy_var_7)) n x y z happy_var_3 (Just happy_var_5) ds)}}}}}}}
	) (\r -> happyReturn (happyIn98 r))

happyReduce_352 = happyMonadReduce 5# 89# happyReduction_352
happyReduction_352 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut45 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut162 happy_x_5 of { happy_var_5 -> 
	( exprToName happy_var_2 >>= \ n -> let ((x,y,z),ds) = happy_var_5 in return $ Record (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n x y z happy_var_3 Nothing ds)}}}}}
	) (\r -> happyReturn (happyIn98 r))

happyReduce_353 = happyMonadReduce 5# 90# happyReduction_353
happyReduction_353 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwRecord happy_var_1) -> 
	case happyOut45 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymColon happy_var_4) -> 
	case happyOut37 happy_x_5 of { happy_var_5 -> 
	( exprToName happy_var_2 >>= \ n -> return $ RecordSig (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) n happy_var_3 happy_var_5)}}}}}
	) (\r -> happyReturn (happyIn99 r))

happyReduce_354 = happySpecReduce_2  91# happyReduction_354
happyReduction_354 happy_x_2
	happy_x_1
	 =  case happyOut18 happy_x_2 of { happy_var_2 -> 
	happyIn100
		 ((happy_var_2, NotInstanceDef)
	)}

happyReduce_355 = happyReduce 5# 91# happyReduction_355
happyReduction_355 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut18 happy_x_4 of { happy_var_4 -> 
	happyIn100
		 ((happy_var_4, InstanceDef)
	) `HappyStk` happyRest}

happyReduce_356 = happySpecReduce_3  92# happyReduction_356
happyReduction_356 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfix happy_var_1) -> 
	case happyOut17 happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn101
		 (Infix (Fixity (getRange (happy_var_1,happy_var_3)) (Related happy_var_2) NonAssoc)   happy_var_3
	)}}}

happyReduce_357 = happySpecReduce_3  92# happyReduction_357
happyReduction_357 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixL happy_var_1) -> 
	case happyOut17 happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn101
		 (Infix (Fixity (getRange (happy_var_1,happy_var_3)) (Related happy_var_2) LeftAssoc)  happy_var_3
	)}}}

happyReduce_358 = happySpecReduce_3  92# happyReduction_358
happyReduction_358 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInfixR happy_var_1) -> 
	case happyOut17 happy_x_2 of { happy_var_2 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn101
		 (Infix (Fixity (getRange (happy_var_1,happy_var_3)) (Related happy_var_2) RightAssoc) happy_var_3
	)}}}

happyReduce_359 = happySpecReduce_2  93# happyReduction_359
happyReduction_359 happy_x_2
	happy_x_1
	 =  case happyOut160 happy_x_2 of { happy_var_2 -> 
	happyIn102
		 (let
                inst i | getHiding i == Instance = InstanceDef
                       | otherwise               = NotInstanceDef
                toField (Arg info (TypeSig info' x t)) = Field (inst info') x (Arg info t)
              in map toField happy_var_2
	)}

happyReduce_360 = happySpecReduce_2  94# happyReduction_360
happyReduction_360 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMutual happy_var_1) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	happyIn103
		 (Mutual (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_361 = happySpecReduce_2  95# happyReduction_361
happyReduction_361 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwAbstract happy_var_1) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	happyIn104
		 (Abstract (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_362 = happySpecReduce_2  96# happyReduction_362
happyReduction_362 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrivate happy_var_1) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	happyIn105
		 (Private (fuseRange happy_var_1 happy_var_2) UserWritten happy_var_2
	)}}

happyReduce_363 = happySpecReduce_2  97# happyReduction_363
happyReduction_363 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInstance happy_var_1) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	happyIn106
		 (InstanceB (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_364 = happySpecReduce_2  98# happyReduction_364
happyReduction_364 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwMacro happy_var_1) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	happyIn107
		 (Macro (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_365 = happySpecReduce_2  99# happyReduction_365
happyReduction_365 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPostulate happy_var_1) -> 
	case happyOut167 happy_x_2 of { happy_var_2 -> 
	happyIn108
		 (Postulate (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_366 = happySpecReduce_2  100# happyReduction_366
happyReduction_366 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwPrimitive happy_var_1) -> 
	case happyOut158 happy_x_2 of { happy_var_2 -> 
	happyIn109
		 (Primitive (fuseRange happy_var_1 happy_var_2) happy_var_2
	)}}

happyReduce_367 = happySpecReduce_3  101# happyReduction_367
happyReduction_367 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn110
		 (UnquoteDecl (fuseRange happy_var_1 happy_var_3) [] happy_var_3
	)}}

happyReduce_368 = happyReduce 4# 101# happyReduction_368
happyReduction_368 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDecl happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	happyIn110
		 (UnquoteDecl (fuseRange happy_var_1 happy_var_4) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_369 = happyReduce 4# 101# happyReduction_369
happyReduction_369 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwUnquoteDef happy_var_1) -> 
	case happyOut19 happy_x_2 of { happy_var_2 -> 
	case happyOut37 happy_x_4 of { happy_var_4 -> 
	happyIn110
		 (UnquoteDef (fuseRange happy_var_1 happy_var_4) happy_var_2 happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_370 = happyMonadReduce 5# 102# happyReduction_370
happyReduction_370 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut115 happy_x_3 of { happy_var_3 -> 
	case happyOut114 happy_x_5 of { happy_var_5 -> 
	(
  case happy_var_2 of
    Name _ [_] -> case mkNotation happy_var_3 (map rangedThing happy_var_5) of
      Left err -> parseError $ "Malformed syntax declaration: " ++ err
      Right n -> return $ Syntax happy_var_2 n
    _ -> parseError "Syntax declarations are allowed only for simple names (without holes)")}}}
	) (\r -> happyReturn (happyIn111 r))

happyReduce_371 = happyMonadReduce 5# 103# happyReduction_371
happyReduction_371 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwPatternSyn happy_var_1) -> 
	case happyOut18 happy_x_2 of { happy_var_2 -> 
	case happyOut113 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymEqual happy_var_4) -> 
	case happyOut37 happy_x_5 of { happy_var_5 -> 
	( do
  p <- exprToPattern happy_var_5
  return (PatternSyn (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 happy_var_3 p))}}}}}
	) (\r -> happyReturn (happyIn112 r))

happyReduce_372 = happySpecReduce_0  104# happyReduction_372
happyReduction_372  =  happyIn113
		 ([]
	)

happyReduce_373 = happyMonadReduce 1# 104# happyReduction_373
happyReduction_373 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut62 happy_x_1 of { happy_var_1 -> 
	( patternSynArgs happy_var_1)}
	) (\r -> happyReturn (happyIn113 r))

happyReduce_374 = happySpecReduce_1  105# happyReduction_374
happyReduction_374 happy_x_1
	 =  case happyOut119 happy_x_1 of { happy_var_1 -> 
	happyIn114
		 ([happy_var_1]
	)}

happyReduce_375 = happySpecReduce_2  105# happyReduction_375
happyReduction_375 happy_x_2
	happy_x_1
	 =  case happyOut114 happy_x_1 of { happy_var_1 -> 
	case happyOut119 happy_x_2 of { happy_var_2 -> 
	happyIn114
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_376 = happySpecReduce_1  106# happyReduction_376
happyReduction_376 happy_x_1
	 =  case happyOut116 happy_x_1 of { happy_var_1 -> 
	happyIn115
		 ([happy_var_1]
	)}

happyReduce_377 = happySpecReduce_2  106# happyReduction_377
happyReduction_377 happy_x_2
	happy_x_1
	 =  case happyOut115 happy_x_1 of { happy_var_1 -> 
	case happyOut116 happy_x_2 of { happy_var_2 -> 
	happyIn115
		 (happy_var_1 ++ [happy_var_2]
	)}}

happyReduce_378 = happySpecReduce_1  107# happyReduction_378
happyReduction_378 happy_x_1
	 =  case happyOut117 happy_x_1 of { happy_var_1 -> 
	happyIn116
		 (defaultNamedArg happy_var_1
	)}

happyReduce_379 = happySpecReduce_3  107# happyReduction_379
happyReduction_379 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut118 happy_x_2 of { happy_var_2 -> 
	happyIn116
		 (setHiding Hidden   $ defaultNamedArg happy_var_2
	)}

happyReduce_380 = happySpecReduce_3  107# happyReduction_380
happyReduction_380 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut118 happy_x_2 of { happy_var_2 -> 
	happyIn116
		 (setHiding Instance $ defaultNamedArg happy_var_2
	)}

happyReduce_381 = happyReduce 5# 107# happyReduction_381
happyReduction_381 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut118 happy_x_4 of { happy_var_4 -> 
	happyIn116
		 (setHiding Hidden   $ defaultArg $ named happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_382 = happyReduce 5# 107# happyReduction_382
happyReduction_382 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut118 happy_x_4 of { happy_var_4 -> 
	happyIn116
		 (setHiding Instance $ defaultArg $ named happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_383 = happySpecReduce_1  108# happyReduction_383
happyReduction_383 happy_x_1
	 =  case happyOut119 happy_x_1 of { happy_var_1 -> 
	happyIn117
		 (ExprHole (rangedThing happy_var_1)
	)}

happyReduce_384 = happyReduce 6# 108# happyReduction_384
happyReduction_384 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut119 happy_x_3 of { happy_var_3 -> 
	case happyOut119 happy_x_5 of { happy_var_5 -> 
	happyIn117
		 (LambdaHole (rangedThing happy_var_3) (rangedThing happy_var_5)
	) `HappyStk` happyRest}}

happyReduce_385 = happyReduce 6# 108# happyReduction_385
happyReduction_385 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut119 happy_x_5 of { happy_var_5 -> 
	happyIn117
		 (LambdaHole "_" (rangedThing happy_var_5)
	) `HappyStk` happyRest}

happyReduce_386 = happySpecReduce_1  109# happyReduction_386
happyReduction_386 happy_x_1
	 =  case happyOut119 happy_x_1 of { happy_var_1 -> 
	happyIn118
		 (ExprHole (rangedThing happy_var_1)
	)}

happyReduce_387 = happyReduce 4# 109# happyReduction_387
happyReduction_387 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut119 happy_x_2 of { happy_var_2 -> 
	case happyOut119 happy_x_4 of { happy_var_4 -> 
	happyIn118
		 (LambdaHole (rangedThing happy_var_2) (rangedThing happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_388 = happyReduce 4# 109# happyReduction_388
happyReduction_388 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut119 happy_x_4 of { happy_var_4 -> 
	happyIn118
		 (LambdaHole "_" (rangedThing happy_var_4)
	) `HappyStk` happyRest}

happyReduce_389 = happySpecReduce_1  110# happyReduction_389
happyReduction_389 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokId happy_var_1) -> 
	happyIn119
		 (Ranged (getRange $ fst happy_var_1) (stringToRawName $ snd happy_var_1)
	)}

happyReduce_390 = happySpecReduce_1  111# happyReduction_390
happyReduction_390 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	happyIn120
		 (Just (getRange happy_var_1)
	)}

happyReduce_391 = happySpecReduce_0  111# happyReduction_391
happyReduction_391  =  happyIn120
		 (Nothing
	)

happyReduce_392 = happyMonadReduce 5# 112# happyReduction_392
happyReduction_392 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut120 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwImport happy_var_2) -> 
	case happyOut25 happy_x_3 of { happy_var_3 -> 
	case happyOut122 happy_x_4 of { happy_var_4 -> 
	case happyOut73 happy_x_5 of { happy_var_5 -> 
	(
    let
    { doOpen = maybe DontOpen (const DoOpen) happy_var_1
    ; m   = happy_var_3
    ; es  = happy_var_4
    ; dir = happy_var_5
    ; r   = getRange (m, es, dir)
    ; mr  = getRange m
    ; unique = hashString $ show $ (Nothing :: Maybe ()) <$ r
         -- turn range into unique id, but delete file path
         -- which is absolute and messes up suite of failing tests
         -- (different hashs on different installations)
         -- TODO: Don't use (insecure) hashes in this way.
    ; fresh = Name mr [ Id $ stringToRawName $ ".#" ++ show m ++ "-" ++ show unique ]
    ; impStm asR = Import mr m (Just (AsName fresh asR)) DontOpen defaultImportDir
    ; appStm m' es =
        let r = getRange (m, es) in
        Private r Inserted
          [ ModuleMacro r m'
             (SectionApp (getRange es) []
               (RawApp (getRange es) (Ident (QName fresh) : es)))
             doOpen dir
          ]
    ; (initArgs, last2Args) = splitAt (length es - 2) es
    ; parseAsClause = case last2Args of
      { [ Ident (QName (Name asR [Id x]))
        , Ident (QName m')
        ] | rawNameToString x == "as" -> Just (asR, m')
      ; _ -> Nothing
      }
    } in
    case es of
      { [] -> return [Import mr m Nothing doOpen dir]
      ; _ | Just (asR, m') <- parseAsClause ->
              if null initArgs then return
                 [ Import (getRange (m, asR, m', dir)) m
                     (Just (AsName m' asR)) doOpen dir
                 ]
              else return [ impStm asR, appStm m' initArgs ]
          | DontOpen <- doOpen -> parseErrorAt (fromJust $ rStart' $ getRange happy_var_2) "An import statement with module instantiation does not actually import the module.  This statement achieves nothing.  Either add the `open' keyword or bind the instantiated module with an `as' clause."
          | otherwise -> return
              [ impStm noRange
              , appStm (noName $ beginningOf $ getRange m) es
              ]
      })}}}}}
	) (\r -> happyReturn (happyIn121 r))

happyReduce_393 = happyReduce 4# 112# happyReduction_393
happyReduction_393 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_2 of { happy_var_2 -> 
	case happyOut122 happy_x_3 of { happy_var_3 -> 
	case happyOut73 happy_x_4 of { happy_var_4 -> 
	happyIn121
		 (let
    { m   = happy_var_2
    ; es  = happy_var_3
    ; dir = happy_var_4
    ; r   = getRange (m, es, dir)
    } in
    [ case es of
      { []  -> Open r m dir
      ; _   -> Private r Inserted
                 [ ModuleMacro r (noName $ beginningOf $ getRange m)
                             (SectionApp (getRange (m , es)) [] (RawApp (fuseRange m es) (Ident m : es)))
                             DoOpen dir
                 ]
      }
    ]
	) `HappyStk` happyRest}}}

happyReduce_394 = happyReduce 6# 112# happyReduction_394
happyReduction_394 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_2 of { happy_var_2 -> 
	case happyOut73 happy_x_6 of { happy_var_6 -> 
	happyIn121
		 (let r = getRange happy_var_2 in
    [ Private r Inserted
      [ ModuleMacro r (noName $ beginningOf $ getRange happy_var_2) (RecordModuleIFS r happy_var_2) DoOpen happy_var_6
      ]
    ]
	) `HappyStk` happyRest}}

happyReduce_395 = happySpecReduce_0  113# happyReduction_395
happyReduction_395  =  happyIn122
		 ([]
	)

happyReduce_396 = happySpecReduce_2  113# happyReduction_396
happyReduction_396 happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut122 happy_x_2 of { happy_var_2 -> 
	happyIn122
		 (happy_var_1 : happy_var_2
	)}}

happyReduce_397 = happyReduce 4# 114# happyReduction_397
happyReduction_397 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (TokSymbol SymDoubleOpenBrace happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymEllipsis happy_var_3) -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn123
		 ((\ts ->
                    if null ts then return $ RecordModuleIFS (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_1
                    else parseError "No bindings allowed for record module with non-canonical implicits" )
	) `HappyStk` happyRest}}}}

happyReduce_398 = happySpecReduce_2  114# happyReduction_398
happyReduction_398 happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOut122 happy_x_2 of { happy_var_2 -> 
	happyIn123
		 ((\ts -> return $ SectionApp (getRange (happy_var_1, happy_var_2)) ts (RawApp (fuseRange happy_var_1 happy_var_2) (Ident happy_var_1 : happy_var_2)) )
	)}}

happyReduce_399 = happyMonadReduce 6# 115# happyReduction_399
happyReduction_399 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut25 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOut123 happy_x_5 of { happy_var_5 -> 
	case happyOut73 happy_x_6 of { happy_var_6 -> 
	( do { ma <- happy_var_5 (map addType happy_var_3)
                          ; name <- ensureUnqual happy_var_2
                          ; return $ ModuleMacro (getRange (happy_var_1, happy_var_2, ma, happy_var_6)) name ma DontOpen happy_var_6 })}}}}}
	) (\r -> happyReturn (happyIn124 r))

happyReduce_400 = happyMonadReduce 7# 115# happyReduction_400
happyReduction_400 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokKeyword KwOpen happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwModule happy_var_2) -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	case happyOut70 happy_x_4 of { happy_var_4 -> 
	case happyOut123 happy_x_6 of { happy_var_6 -> 
	case happyOut73 happy_x_7 of { happy_var_7 -> 
	( do {ma <- happy_var_6 (map addType happy_var_4); return $ ModuleMacro (getRange (happy_var_1, happy_var_2, happy_var_3, ma, happy_var_7)) happy_var_3 ma DoOpen happy_var_7 })}}}}}}
	) (\r -> happyReturn (happyIn124 r))

happyReduce_401 = happyReduce 5# 116# happyReduction_401
happyReduction_401 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut25 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut168 happy_x_5 of { happy_var_5 -> 
	happyIn125
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) happy_var_2 (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_402 = happyReduce 5# 116# happyReduction_402
happyReduction_402 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokKeyword KwModule happy_var_1) -> 
	case happyOut126 happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokKeyword KwWhere happy_var_4) -> 
	case happyOut168 happy_x_5 of { happy_var_5 -> 
	happyIn125
		 (Module (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) (QName happy_var_2) (map addType happy_var_3) happy_var_5
	) `HappyStk` happyRest}}}}}

happyReduce_403 = happySpecReduce_1  117# happyReduction_403
happyReduction_403 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymUnderscore happy_var_1) -> 
	happyIn126
		 (noName (getRange happy_var_1)
	)}

happyReduce_404 = happySpecReduce_1  118# happyReduction_404
happyReduction_404 happy_x_1
	 =  case happyOut170 happy_x_1 of { happy_var_1 -> 
	happyIn127
		 (figureOutTopLevelModule happy_var_1
	)}

happyReduce_405 = happySpecReduce_1  119# happyReduction_405
happyReduction_405 happy_x_1
	 =  case happyOut129 happy_x_1 of { happy_var_1 -> 
	happyIn128
		 (Pragma happy_var_1
	)}

happyReduce_406 = happySpecReduce_1  120# happyReduction_406
happyReduction_406 happy_x_1
	 =  case happyOut131 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_407 = happySpecReduce_1  120# happyReduction_407
happyReduction_407 happy_x_1
	 =  case happyOut132 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_408 = happySpecReduce_1  120# happyReduction_408
happyReduction_408 happy_x_1
	 =  case happyOut133 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_409 = happySpecReduce_1  120# happyReduction_409
happyReduction_409 happy_x_1
	 =  case happyOut134 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_410 = happySpecReduce_1  120# happyReduction_410
happyReduction_410 happy_x_1
	 =  case happyOut137 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_411 = happySpecReduce_1  120# happyReduction_411
happyReduction_411 happy_x_1
	 =  case happyOut135 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_412 = happySpecReduce_1  120# happyReduction_412
happyReduction_412 happy_x_1
	 =  case happyOut136 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_413 = happySpecReduce_1  120# happyReduction_413
happyReduction_413 happy_x_1
	 =  case happyOut138 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_414 = happySpecReduce_1  120# happyReduction_414
happyReduction_414 happy_x_1
	 =  case happyOut139 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_415 = happySpecReduce_1  120# happyReduction_415
happyReduction_415 happy_x_1
	 =  case happyOut140 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_416 = happySpecReduce_1  120# happyReduction_416
happyReduction_416 happy_x_1
	 =  case happyOut141 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_417 = happySpecReduce_1  120# happyReduction_417
happyReduction_417 happy_x_1
	 =  case happyOut142 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_418 = happySpecReduce_1  120# happyReduction_418
happyReduction_418 happy_x_1
	 =  case happyOut143 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_419 = happySpecReduce_1  120# happyReduction_419
happyReduction_419 happy_x_1
	 =  case happyOut144 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_420 = happySpecReduce_1  120# happyReduction_420
happyReduction_420 happy_x_1
	 =  case happyOut151 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_421 = happySpecReduce_1  120# happyReduction_421
happyReduction_421 happy_x_1
	 =  case happyOut152 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_422 = happySpecReduce_1  120# happyReduction_422
happyReduction_422 happy_x_1
	 =  case happyOut153 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_423 = happySpecReduce_1  120# happyReduction_423
happyReduction_423 happy_x_1
	 =  case happyOut148 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_424 = happySpecReduce_1  120# happyReduction_424
happyReduction_424 happy_x_1
	 =  case happyOut147 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_425 = happySpecReduce_1  120# happyReduction_425
happyReduction_425 happy_x_1
	 =  case happyOut146 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_426 = happySpecReduce_1  120# happyReduction_426
happyReduction_426 happy_x_1
	 =  case happyOut149 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_427 = happySpecReduce_1  120# happyReduction_427
happyReduction_427 happy_x_1
	 =  case happyOut150 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_428 = happySpecReduce_1  120# happyReduction_428
happyReduction_428 happy_x_1
	 =  case happyOut145 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_429 = happySpecReduce_1  120# happyReduction_429
happyReduction_429 happy_x_1
	 =  case happyOut154 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_430 = happySpecReduce_1  120# happyReduction_430
happyReduction_430 happy_x_1
	 =  case happyOut155 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_431 = happySpecReduce_1  120# happyReduction_431
happyReduction_431 happy_x_1
	 =  case happyOut130 happy_x_1 of { happy_var_1 -> 
	happyIn129
		 (happy_var_1
	)}

happyReduce_432 = happyReduce 4# 121# happyReduction_432
happyReduction_432 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwOPTIONS happy_var_2) -> 
	case happyOut31 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn130
		 (OptionsPragma (getRange (happy_var_1,happy_var_2,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_433 = happyReduce 5# 122# happyReduction_433
happyReduction_433 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwBUILTIN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut35 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn131
		 (BuiltinPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4,happy_var_5)) (snd happy_var_3) (Ident happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_434 = happyReduce 5# 122# happyReduction_434
happyReduction_434 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwBUILTIN happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokKeyword KwREWRITE happy_var_3) -> 
	case happyOut35 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn131
		 (BuiltinPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4,happy_var_5)) "REWRITE" (Ident happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_435 = happyReduce 4# 123# happyReduction_435
happyReduction_435 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwREWRITE happy_var_2) -> 
	case happyOut36 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn132
		 (RewritePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_436 = happyReduce 5# 124# happyReduction_436
happyReduction_436 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn133
		 (CompiledPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_437 = happyReduce 5# 125# happyReduction_437
happyReduction_437 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_EXPORT happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut32 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn134
		 (CompiledExportPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 happy_var_4
	) `HappyStk` happyRest}}}}}

happyReduce_438 = happyReduce 5# 126# happyReduction_438
happyReduction_438 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_DECLARE_DATA happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn135
		 (CompiledDeclareDataPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_439 = happyReduce 5# 127# happyReduction_439
happyReduction_439 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_TYPE happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn136
		 (CompiledTypePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_440 = happyReduce 6# 128# happyReduction_440
happyReduction_440 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_DATA happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokString happy_var_4) -> 
	case happyOut31 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokSymbol SymClosePragma happy_var_6) -> 
	happyIn137
		 (CompiledDataPragma (getRange (happy_var_1,happy_var_2,happy_var_3,fst happy_var_4,happy_var_6)) happy_var_3 (snd happy_var_4) happy_var_5
	) `HappyStk` happyRest}}}}}}

happyReduce_441 = happyReduce 5# 129# happyReduction_441
happyReduction_441 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_EPIC happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn138
		 (CompiledEpicPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_442 = happyReduce 5# 130# happyReduction_442
happyReduction_442 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_JS happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn139
		 (CompiledJSPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_443 = happyReduce 5# 131# happyReduction_443
happyReduction_443 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_UHC happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn140
		 (CompiledUHCPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_5)) happy_var_3 (unwords happy_var_4)
	) `HappyStk` happyRest}}}}}

happyReduce_444 = happyReduce 6# 132# happyReduction_444
happyReduction_444 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCOMPILED_DATA_UHC happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokString happy_var_4) -> 
	case happyOut31 happy_x_5 of { happy_var_5 -> 
	case happyOutTok happy_x_6 of { (TokSymbol SymClosePragma happy_var_6) -> 
	happyIn141
		 (CompiledDataUHCPragma (getRange (happy_var_1,happy_var_2,happy_var_3,fst happy_var_4,happy_var_6)) happy_var_3 (snd happy_var_4) happy_var_5
	) `HappyStk` happyRest}}}}}}

happyReduce_445 = happyReduce 4# 133# happyReduction_445
happyReduction_445 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwHASKELL happy_var_2) -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn142
		 (HaskellCodePragma (getRange (happy_var_1, happy_var_2, happy_var_4)) (recoverLayout happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_446 = happyReduce 4# 134# happyReduction_446
happyReduction_446 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwSTATIC happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn143
		 (StaticPragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_447 = happyReduce 4# 135# happyReduction_447
happyReduction_447 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwINLINE happy_var_2) -> 
	case happyOut35 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn144
		 (InlinePragma (getRange (happy_var_1,happy_var_2,happy_var_3,happy_var_4)) happy_var_3
	) `HappyStk` happyRest}}}}

happyReduce_448 = happyMonadReduce 5# 136# happyReduction_448
happyReduction_448 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOut31 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	(
      let (r, s) = happy_var_3 in
      parseDisplayPragma (fuseRange happy_var_1 happy_var_5) (iStart r) (unwords (s : happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn145 r))

happyReduce_449 = happySpecReduce_3  137# happyReduction_449
happyReduction_449 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_TERMINATION_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn146
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) NoTerminationCheck
	)}}}

happyReduce_450 = happySpecReduce_3  138# happyReduction_450
happyReduction_450 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNON_TERMINATING happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn147
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) NonTerminating
	)}}}

happyReduce_451 = happySpecReduce_3  139# happyReduction_451
happyReduction_451 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwTERMINATING happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn148
		 (TerminationCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3)) Terminating
	)}}}

happyReduce_452 = happyReduce 4# 140# happyReduction_452
happyReduction_452 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwMEASURE happy_var_2) -> 
	case happyOut34 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	happyIn149
		 (let r = getRange (happy_var_1, happy_var_2, happy_var_3, happy_var_4) in
      TerminationCheckPragma r (TerminationMeasure r happy_var_3)
	) `HappyStk` happyRest}}}}

happyReduce_453 = happySpecReduce_3  141# happyReduction_453
happyReduction_453 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwCATCHALL happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn150
		 (CatchallPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_454 = happyMonadReduce 4# 142# happyReduction_454
happyReduction_454 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPORT happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	( let s = snd happy_var_3 in
       if validHaskellModuleName s
       then return $ ImportPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4)) s
       else parseError $ "Malformed module name: " ++ s ++ ".")}}}}
	) (\r -> happyReturn (happyIn151 r))

happyReduce_455 = happyMonadReduce 4# 143# happyReduction_455
happyReduction_455 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPORT_UHC happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokString happy_var_3) -> 
	case happyOutTok happy_x_4 of { (TokSymbol SymClosePragma happy_var_4) -> 
	( let s = snd happy_var_3 in
       if validHaskellModuleName s
       then return $ ImportUHCPragma (getRange (happy_var_1,happy_var_2,fst happy_var_3,happy_var_4)) s
       else parseError $ "Malformed module name: " ++ s ++ ".")}}}}
	) (\r -> happyReturn (happyIn152 r))

happyReduce_456 = happySpecReduce_3  144# happyReduction_456
happyReduction_456 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwIMPOSSIBLE happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn153
		 (ImpossiblePragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_457 = happySpecReduce_3  145# happyReduction_457
happyReduction_457 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwNO_POSITIVITY_CHECK happy_var_2) -> 
	case happyOutTok happy_x_3 of { (TokSymbol SymClosePragma happy_var_3) -> 
	happyIn154
		 (NoPositivityCheckPragma (getRange (happy_var_1,happy_var_2,happy_var_3))
	)}}}

happyReduce_458 = happyReduce 5# 146# happyReduction_458
happyReduction_458 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (TokSymbol SymOpenPragma happy_var_1) -> 
	case happyOutTok happy_x_2 of { (TokKeyword KwPOLARITY happy_var_2) -> 
	case happyOut34 happy_x_3 of { happy_var_3 -> 
	case happyOut156 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (TokSymbol SymClosePragma happy_var_5) -> 
	happyIn155
		 (let (rs, occs) = unzip (reverse happy_var_4) in
      PolarityPragma (getRange (happy_var_1,happy_var_2,happy_var_3,rs,happy_var_5)) happy_var_3 occs
	) `HappyStk` happyRest}}}}}

happyReduce_459 = happySpecReduce_0  147# happyReduction_459
happyReduction_459  =  happyIn156
		 ([]
	)

happyReduce_460 = happySpecReduce_2  147# happyReduction_460
happyReduction_460 happy_x_2
	happy_x_1
	 =  case happyOut156 happy_x_1 of { happy_var_1 -> 
	case happyOut157 happy_x_2 of { happy_var_2 -> 
	happyIn156
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_461 = happyMonadReduce 1# 148# happyReduction_461
happyReduction_461 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (TokString happy_var_1) -> 
	( polarity happy_var_1)}
	) (\r -> happyReturn (happyIn157 r))

happyReduce_462 = happySpecReduce_3  149# happyReduction_462
happyReduction_462 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut159 happy_x_2 of { happy_var_2 -> 
	happyIn158
		 (reverse happy_var_2
	)}

happyReduce_463 = happySpecReduce_3  150# happyReduction_463
happyReduction_463 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut159 happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	happyIn159
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_464 = happySpecReduce_1  150# happyReduction_464
happyReduction_464 happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	happyIn159
		 (reverse happy_var_1
	)}

happyReduce_465 = happySpecReduce_3  151# happyReduction_465
happyReduction_465 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_2 of { happy_var_2 -> 
	happyIn160
		 (reverse happy_var_2
	)}

happyReduce_466 = happySpecReduce_3  152# happyReduction_466
happyReduction_466 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut161 happy_x_1 of { happy_var_1 -> 
	case happyOut93 happy_x_3 of { happy_var_3 -> 
	happyIn161
		 (reverse happy_var_3 ++ happy_var_1
	)}}

happyReduce_467 = happySpecReduce_1  152# happyReduction_467
happyReduction_467 happy_x_1
	 =  case happyOut93 happy_x_1 of { happy_var_1 -> 
	happyIn161
		 (reverse happy_var_1
	)}

happyReduce_468 = happyMonadReduce 3# 153# happyReduction_468
happyReduction_468 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut163 happy_x_2 of { happy_var_2 -> 
	( ((,) `fmap` verifyRecordDirectives happy_var_2 <*> pure []))}
	) (\r -> happyReturn (happyIn162 r))

happyReduce_469 = happyMonadReduce 5# 153# happyReduction_469
happyReduction_469 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut163 happy_x_2 of { happy_var_2 -> 
	case happyOut169 happy_x_4 of { happy_var_4 -> 
	( ((,) `fmap` verifyRecordDirectives happy_var_2 <*> pure happy_var_4))}}
	) (\r -> happyReturn (happyIn162 r))

happyReduce_470 = happyMonadReduce 3# 153# happyReduction_470
happyReduction_470 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut169 happy_x_2 of { happy_var_2 -> 
	( ((,) `fmap` verifyRecordDirectives [] <*> pure happy_var_2))}
	) (\r -> happyReturn (happyIn162 r))

happyReduce_471 = happySpecReduce_0  154# happyReduction_471
happyReduction_471  =  happyIn163
		 ([]
	)

happyReduce_472 = happySpecReduce_3  154# happyReduction_472
happyReduction_472 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut163 happy_x_1 of { happy_var_1 -> 
	case happyOut164 happy_x_3 of { happy_var_3 -> 
	happyIn163
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_473 = happySpecReduce_1  154# happyReduction_473
happyReduction_473 happy_x_1
	 =  case happyOut164 happy_x_1 of { happy_var_1 -> 
	happyIn163
		 ([happy_var_1]
	)}

happyReduce_474 = happySpecReduce_1  155# happyReduction_474
happyReduction_474 happy_x_1
	 =  case happyOut100 happy_x_1 of { happy_var_1 -> 
	happyIn164
		 (Constructor happy_var_1
	)}

happyReduce_475 = happySpecReduce_1  155# happyReduction_475
happyReduction_475 happy_x_1
	 =  case happyOut166 happy_x_1 of { happy_var_1 -> 
	happyIn164
		 (Induction happy_var_1
	)}

happyReduce_476 = happySpecReduce_1  155# happyReduction_476
happyReduction_476 happy_x_1
	 =  case happyOut165 happy_x_1 of { happy_var_1 -> 
	happyIn164
		 (Eta happy_var_1
	)}

happyReduce_477 = happySpecReduce_1  156# happyReduction_477
happyReduction_477 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwEta happy_var_1) -> 
	happyIn165
		 (Ranged (getRange happy_var_1) True
	)}

happyReduce_478 = happySpecReduce_1  156# happyReduction_478
happyReduction_478 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwNoEta happy_var_1) -> 
	happyIn165
		 (Ranged (getRange happy_var_1) False
	)}

happyReduce_479 = happySpecReduce_1  157# happyReduction_479
happyReduction_479 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwInductive happy_var_1) -> 
	happyIn166
		 (Ranged (getRange happy_var_1) Inductive
	)}

happyReduce_480 = happySpecReduce_1  157# happyReduction_480
happyReduction_480 happy_x_1
	 =  case happyOutTok happy_x_1 of { (TokKeyword KwCoInductive happy_var_1) -> 
	happyIn166
		 (Ranged (getRange happy_var_1) CoInductive
	)}

happyReduce_481 = happySpecReduce_3  158# happyReduction_481
happyReduction_481 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut169 happy_x_2 of { happy_var_2 -> 
	happyIn167
		 (happy_var_2
	)}

happyReduce_482 = happySpecReduce_2  159# happyReduction_482
happyReduction_482 happy_x_2
	happy_x_1
	 =  happyIn168
		 ([]
	)

happyReduce_483 = happySpecReduce_1  159# happyReduction_483
happyReduction_483 happy_x_1
	 =  case happyOut167 happy_x_1 of { happy_var_1 -> 
	happyIn168
		 (happy_var_1
	)}

happyReduce_484 = happySpecReduce_3  160# happyReduction_484
happyReduction_484 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut169 happy_x_3 of { happy_var_3 -> 
	happyIn169
		 (happy_var_1 ++ happy_var_3
	)}}

happyReduce_485 = happySpecReduce_1  160# happyReduction_485
happyReduction_485 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn169
		 (happy_var_1
	)}

happyReduce_486 = happySpecReduce_0  161# happyReduction_486
happyReduction_486  =  happyIn170
		 ([]
	)

happyReduce_487 = happySpecReduce_1  161# happyReduction_487
happyReduction_487 happy_x_1
	 =  case happyOut169 happy_x_1 of { happy_var_1 -> 
	happyIn170
		 (happy_var_1
	)}

happyNewToken action sts stk
	= lexer(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	TokEOF -> happyDoAction 105# tk action sts stk;
	TokKeyword KwAbstract happy_dollar_dollar -> cont 1#;
	TokKeyword KwCoData happy_dollar_dollar -> cont 2#;
	TokKeyword KwCoInductive happy_dollar_dollar -> cont 3#;
	TokKeyword KwConstructor happy_dollar_dollar -> cont 4#;
	TokKeyword KwData happy_dollar_dollar -> cont 5#;
	TokKeyword KwEta happy_dollar_dollar -> cont 6#;
	TokKeyword KwField happy_dollar_dollar -> cont 7#;
	TokKeyword KwForall happy_dollar_dollar -> cont 8#;
	TokKeyword KwHiding happy_dollar_dollar -> cont 9#;
	TokKeyword KwImport happy_dollar_dollar -> cont 10#;
	TokKeyword KwIn happy_dollar_dollar -> cont 11#;
	TokKeyword KwInductive happy_dollar_dollar -> cont 12#;
	TokKeyword KwInfix happy_dollar_dollar -> cont 13#;
	TokKeyword KwInfixL happy_dollar_dollar -> cont 14#;
	TokKeyword KwInfixR happy_dollar_dollar -> cont 15#;
	TokKeyword KwInstance happy_dollar_dollar -> cont 16#;
	TokKeyword KwOverlap happy_dollar_dollar -> cont 17#;
	TokKeyword KwLet happy_dollar_dollar -> cont 18#;
	TokKeyword KwMacro happy_dollar_dollar -> cont 19#;
	TokKeyword KwModule happy_dollar_dollar -> cont 20#;
	TokKeyword KwMutual happy_dollar_dollar -> cont 21#;
	TokKeyword KwNoEta happy_dollar_dollar -> cont 22#;
	TokKeyword KwOpen happy_dollar_dollar -> cont 23#;
	TokKeyword KwPatternSyn happy_dollar_dollar -> cont 24#;
	TokKeyword KwPostulate happy_dollar_dollar -> cont 25#;
	TokKeyword KwPrimitive happy_dollar_dollar -> cont 26#;
	TokKeyword KwPrivate happy_dollar_dollar -> cont 27#;
	TokKeyword KwProp happy_dollar_dollar -> cont 28#;
	TokKeyword KwPublic happy_dollar_dollar -> cont 29#;
	TokKeyword KwQuote happy_dollar_dollar -> cont 30#;
	TokKeyword KwQuoteContext happy_dollar_dollar -> cont 31#;
	TokKeyword KwQuoteGoal happy_dollar_dollar -> cont 32#;
	TokKeyword KwQuoteTerm happy_dollar_dollar -> cont 33#;
	TokKeyword KwRecord happy_dollar_dollar -> cont 34#;
	TokKeyword KwRenaming happy_dollar_dollar -> cont 35#;
	TokKeyword KwRewrite happy_dollar_dollar -> cont 36#;
	TokKeyword KwSet happy_dollar_dollar -> cont 37#;
	TokKeyword KwSyntax happy_dollar_dollar -> cont 38#;
	TokKeyword KwTactic happy_dollar_dollar -> cont 39#;
	TokKeyword KwTo happy_dollar_dollar -> cont 40#;
	TokKeyword KwUnquote happy_dollar_dollar -> cont 41#;
	TokKeyword KwUnquoteDecl happy_dollar_dollar -> cont 42#;
	TokKeyword KwUnquoteDef happy_dollar_dollar -> cont 43#;
	TokKeyword KwUsing happy_dollar_dollar -> cont 44#;
	TokKeyword KwWhere happy_dollar_dollar -> cont 45#;
	TokKeyword KwWith happy_dollar_dollar -> cont 46#;
	TokKeyword KwBUILTIN happy_dollar_dollar -> cont 47#;
	TokKeyword KwCATCHALL happy_dollar_dollar -> cont 48#;
	TokKeyword KwCOMPILED happy_dollar_dollar -> cont 49#;
	TokKeyword KwCOMPILED_DATA happy_dollar_dollar -> cont 50#;
	TokKeyword KwCOMPILED_DATA_UHC happy_dollar_dollar -> cont 51#;
	TokKeyword KwCOMPILED_DECLARE_DATA happy_dollar_dollar -> cont 52#;
	TokKeyword KwCOMPILED_EPIC happy_dollar_dollar -> cont 53#;
	TokKeyword KwCOMPILED_EXPORT happy_dollar_dollar -> cont 54#;
	TokKeyword KwCOMPILED_JS happy_dollar_dollar -> cont 55#;
	TokKeyword KwCOMPILED_TYPE happy_dollar_dollar -> cont 56#;
	TokKeyword KwCOMPILED_UHC happy_dollar_dollar -> cont 57#;
	TokKeyword KwHASKELL happy_dollar_dollar -> cont 58#;
	TokKeyword KwDISPLAY happy_dollar_dollar -> cont 59#;
	TokKeyword KwIMPORT happy_dollar_dollar -> cont 60#;
	TokKeyword KwIMPORT_UHC happy_dollar_dollar -> cont 61#;
	TokKeyword KwIMPOSSIBLE happy_dollar_dollar -> cont 62#;
	TokKeyword KwINLINE happy_dollar_dollar -> cont 63#;
	TokKeyword KwMEASURE happy_dollar_dollar -> cont 64#;
	TokKeyword KwNO_TERMINATION_CHECK happy_dollar_dollar -> cont 65#;
	TokKeyword KwNO_POSITIVITY_CHECK happy_dollar_dollar -> cont 66#;
	TokKeyword KwNON_TERMINATING happy_dollar_dollar -> cont 67#;
	TokKeyword KwOPTIONS happy_dollar_dollar -> cont 68#;
	TokKeyword KwPOLARITY happy_dollar_dollar -> cont 69#;
	TokKeyword KwREWRITE happy_dollar_dollar -> cont 70#;
	TokKeyword KwSTATIC happy_dollar_dollar -> cont 71#;
	TokKeyword KwTERMINATING happy_dollar_dollar -> cont 72#;
	TokSetN happy_dollar_dollar -> cont 73#;
	TokTeX happy_dollar_dollar -> cont 74#;
	TokComment happy_dollar_dollar -> cont 75#;
	TokSymbol SymEllipsis happy_dollar_dollar -> cont 76#;
	TokSymbol SymDotDot happy_dollar_dollar -> cont 77#;
	TokSymbol SymDot happy_dollar_dollar -> cont 78#;
	TokSymbol SymSemi happy_dollar_dollar -> cont 79#;
	TokSymbol SymColon happy_dollar_dollar -> cont 80#;
	TokSymbol SymEqual happy_dollar_dollar -> cont 81#;
	TokSymbol SymUnderscore happy_dollar_dollar -> cont 82#;
	TokSymbol SymQuestionMark happy_dollar_dollar -> cont 83#;
	TokSymbol SymArrow happy_dollar_dollar -> cont 84#;
	TokSymbol SymLambda happy_dollar_dollar -> cont 85#;
	TokSymbol SymAs happy_dollar_dollar -> cont 86#;
	TokSymbol SymBar happy_dollar_dollar -> cont 87#;
	TokSymbol SymOpenParen happy_dollar_dollar -> cont 88#;
	TokSymbol SymCloseParen happy_dollar_dollar -> cont 89#;
	TokSymbol SymOpenIdiomBracket happy_dollar_dollar -> cont 90#;
	TokSymbol SymCloseIdiomBracket happy_dollar_dollar -> cont 91#;
	TokSymbol SymDoubleOpenBrace happy_dollar_dollar -> cont 92#;
	TokSymbol SymDoubleCloseBrace happy_dollar_dollar -> cont 93#;
	TokSymbol SymOpenBrace happy_dollar_dollar -> cont 94#;
	TokSymbol SymCloseBrace happy_dollar_dollar -> cont 95#;
	TokSymbol SymOpenVirtualBrace happy_dollar_dollar -> cont 96#;
	TokSymbol SymCloseVirtualBrace happy_dollar_dollar -> cont 97#;
	TokSymbol SymVirtualSemi happy_dollar_dollar -> cont 98#;
	TokSymbol SymOpenPragma happy_dollar_dollar -> cont 99#;
	TokSymbol SymClosePragma happy_dollar_dollar -> cont 100#;
	TokId happy_dollar_dollar -> cont 101#;
	TokQId happy_dollar_dollar -> cont 102#;
	TokString happy_dollar_dollar -> cont 103#;
	TokLiteral happy_dollar_dollar -> cont 104#;
	_ -> happyError' tk
	})

happyError_ 105# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => Parser a -> (a -> Parser b) -> Parser b
happyThen = (>>=)
happyReturn :: () => a -> Parser a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> Parser a
happyReturn1 = happyReturn
happyError' :: () => (Token) -> Parser a
happyError' tk = (\token -> happyError) tk

tokensParser = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut9 x))

exprParser = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut37 x))

exprWhereParser = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut90 x))

moduleParser = happySomeParser where
  happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut12 x))

moduleNameParser = happySomeParser where
  happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut25 x))

funclauseParser = happySomeParser where
  happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut94 x))

happySeq = happyDontSeq


{--------------------------------------------------------------------------
    Parsers
 --------------------------------------------------------------------------}

-- | Parse the token stream. Used by the TeX compiler.
tokensParser :: Parser [Token]

-- | Parse an expression. Could be used in interactions.
exprParser :: Parser Expr

-- | Parse an expression followed by a where clause. Could be used in interactions.
exprWhereParser :: Parser ExprWhere

-- | Parse a module.
moduleParser :: Parser Module


{--------------------------------------------------------------------------
    Happy stuff
 --------------------------------------------------------------------------}

-- | Required by Happy.
happyError :: Parser a
happyError = parseError "Parse error"


{--------------------------------------------------------------------------
    Utility functions
 --------------------------------------------------------------------------}

-- | Grab leading OPTIONS pragmas.
takeOptionsPragmas :: [Declaration] -> ([Pragma], [Declaration])
takeOptionsPragmas = spanJust $ \ d -> case d of
  Pragma p@OptionsPragma{} -> Just p
  _                        -> Nothing

-- | Insert a top-level module if there is none.
--   Also fix-up for the case the declarations in the top-level module
--   are not indented (this is allowed as a special case).
figureOutTopLevelModule :: [Declaration] -> [Declaration]
figureOutTopLevelModule ds =
  case spanAllowedBeforeModule ds of
    -- Andreas 2016-02-01, issue #1388.
    -- We need to distinguish two additional cases.
    -- Case 1: Regular file layout: imports followed by one module. Nothing to do.
    (ds0, [ Module{} ]) -> ds
    -- Case 2: The declarations in the module are not indented.
    -- This is allowed for the top level module, and thus rectified here.
    (ds0, Module r m tel [] : ds2) -> ds0 ++ [Module r m tel ds2]
    -- Case 3: There is a module with indented declarations,
    -- followed by non-indented declarations.  This should be a
    -- parse error and be reported later (see @toAbstract TopLevel{}@),
    -- thus, we do not do anything here.
    (ds0, Module r m tel ds1 : ds2) -> ds  -- Gives parse error in scope checker.
    -- OLD code causing issue 1388:
    -- (ds0, Module r m tel ds1 : ds2) -> ds0 ++ [Module r m tel $ ds1 ++ ds2]
    -- Case 4: a top-level module declaration is missing.
    (ds0, ds1)                      -> ds0 ++ [Module (getRange ds1) (QName noName_) [] ds1]

-- | Create a name from a string.

mkName :: (Interval, String) -> Parser Name
mkName (i, s) = do
    let xs = C.stringNameParts s
    mapM_ isValidId xs
    unless (alternating xs) $ fail $ "a name cannot contain two consecutive underscores"
    return $ Name (getRange i) xs
    where
        isValidId Hole   = return ()
        isValidId (Id y) = do
          let x = rawNameToString y
          case parse defaultParseFlags [0] (lexer return) x of
            ParseOk _ (TokId _) -> return ()
            _                   -> fail $ "in the name " ++ s ++ ", the part " ++ x ++ " is not valid"

        -- we know that there are no two Ids in a row
        alternating (Hole : Hole : _) = False
        alternating (_ : xs)          = alternating xs
        alternating []                = True

-- | Create a qualified name from a list of strings
mkQName :: [(Interval, String)] -> Parser QName
mkQName ss = do
    xs <- mapM mkName ss
    return $ foldr Qual (QName $ last xs) (init xs)

-- | Create a qualified name from a string (used in pragmas).
--   Range of each name component is range of whole string.
--   TODO: precise ranges!

pragmaQName :: (Interval, String) -> Parser QName
pragmaQName (r, s) = do
  let ss = chopWhen (== '.') s
  mkQName $ map (r,) ss

-- | Polarity parser.

polarity :: (Interval, String) -> Parser (Range, Occurrence)
polarity (i, s) =
  case s of
    "_"  -> ret Unused
    "++" -> ret StrictPos
    "+"  -> ret JustPos
    "-"  -> ret JustNeg
    "*"  -> ret Mixed
    _    -> fail $ "Not a valid polarity: " ++ s
  where
  ret x = return (getRange i, x)

recoverLayout :: [(Interval, String)] -> String
recoverLayout [] = ""
recoverLayout xs@((i, _) : _) = go (iStart i) xs
  where
    c0 = posCol (iStart i)

    go cur [] = ""
    go cur ((i, s) : xs) = padding cur (iStart i) ++ s ++ go (iEnd i) xs

    padding Pn{ posLine = l1, posCol = c1 } Pn{ posLine = l2, posCol = c2 }
      | l1 < l2  = genericReplicate (l2 - l1) '\n' ++ genericReplicate (max 0 (c2 - c0)) ' '
      | l1 == l2 = genericReplicate (c2 - c1) ' '

ensureUnqual :: QName -> Parser Name
ensureUnqual (QName x) = return x
ensureUnqual q@Qual{}  = parseError' (rStart' $ getRange q) "Qualified name not allowed here"

-- | Match a particular name.
isName :: String -> (Interval, String) -> Parser ()
isName s (_,s')
    | s == s'   = return ()
    | otherwise = fail $ "expected " ++ s ++ ", found " ++ s'

-- | Build a forall pi (forall x y z -> ...)
forallPi :: [LamBinding] -> Expr -> Expr
forallPi bs e = Pi (map addType bs) e

-- | Build a telescoping let (let Ds)
tLet :: Range -> [Declaration] -> TypedBindings
tLet r = TypedBindings r . Arg defaultArgInfo . TLet r

-- | Converts lambda bindings to typed bindings.
addType :: LamBinding -> TypedBindings
addType (DomainFull b)   = b
addType (DomainFree info x) = TypedBindings r $ Arg info $ TBind r [pure x] $ Underscore r Nothing
  where r = getRange x

mergeImportDirectives :: [ImportDirective] -> Parser ImportDirective
mergeImportDirectives is = do
  i <- foldl merge (return defaultImportDir) is
  verifyImportDirective i
  where
    merge mi i2 = do
      i1 <- mi
      let err = parseError' (rStart' $ getRange i2) "Cannot mix using and hiding module directives"
      return $ ImportDirective
        { importDirRange = fuseRange i1 i2
        , using          = mappend (using i1) (using i2)
        , hiding         = hiding i1 ++ hiding i2
        , impRenaming    = impRenaming i1 ++ impRenaming i2
        , publicOpen     = publicOpen i1 || publicOpen i2 }

-- | Check that an import directive doesn't contain repeated names
verifyImportDirective :: ImportDirective -> Parser ImportDirective
verifyImportDirective i =
    case filter ((>1) . length)
         $ group
         $ sort xs
    of
        []  -> return i
        yss -> let Just pos = rStart' $ getRange $ head $ concat yss in
               parseErrorAt pos $
                "Repeated name" ++ s ++ " in import directive: " ++
                concat (intersperse ", " $ map (show . head) yss)
            where
                s = case yss of
                        [_] -> ""
                        _   -> "s"
    where
        xs = names (using i) ++ hiding i ++ map renFrom (impRenaming i)
        names (Using xs)    = xs
        names UseEverything = []

data RecordDirective
   = Induction (Ranged Induction)
   | Constructor (Name, IsInstance)
   | Eta         (Ranged Bool)
   deriving (Eq,Show)

verifyRecordDirectives :: [RecordDirective] -> Parser (Maybe (Ranged Induction), Maybe Bool, Maybe (Name, IsInstance))
verifyRecordDirectives xs | null rs = return (ltm is, ltm es, ltm cs)
                          | otherwise = let Just pos = rStart' $ (head rs) in
                                          parseErrorAt pos $ "Repeated record directives at: \n" ++ intercalate "\n" (map show rs)

 where
  ltm :: [a] -> Maybe a
  ltm [] = Nothing
  ltm (x:xs) = Just x
  errorFromList [] = []
  errorFromList [x] = []
  errorFromList xs = map getRange xs
  rs = sort (concat ([errorFromList is, errorFromList es', errorFromList cs]))
  is = [ i | Induction i <- xs ]
  es' = [ i | Eta i <- xs ]
  es = map rangedThing es'
  cs = [ i | Constructor i <- xs ]


-- | Breaks up a string into substrings. Returns every maximal
-- subsequence of zero or more characters distinct from @'.'@.
--
-- > splitOnDots ""         == [""]
-- > splitOnDots "foo.bar"  == ["foo", "bar"]
-- > splitOnDots ".foo.bar" == ["", "foo", "bar"]
-- > splitOnDots "foo.bar." == ["foo", "bar", ""]
-- > splitOnDots "foo..bar" == ["foo", "", "bar"]
splitOnDots :: String -> [String]
splitOnDots ""        = [""]
splitOnDots ('.' : s) = [] : splitOnDots s
splitOnDots (c   : s) = case splitOnDots s of
  p : ps -> (c : p) : ps


-- | Returns 'True' iff the name is a valid Haskell (hierarchical)
-- module name.
validHaskellModuleName :: String -> Bool
validHaskellModuleName = all ok . splitOnDots
  where
  -- Checks if a dot-less module name is well-formed.
  ok :: String -> Bool
  ok []      = False
  ok (c : s) =
    isUpper c &&
    all (\c -> isLower c || c == '_' ||
               isUpper c ||
               generalCategory c == DecimalNumber ||
               c == '\'')
        s

{--------------------------------------------------------------------------
    Patterns
 --------------------------------------------------------------------------}

-- | Turn an expression into a left hand side.
exprToLHS :: Expr -> Parser ([Expr] -> [Expr] -> LHS)
exprToLHS e = case e of
  WithApp r e es -> LHS <$> exprToPattern e <*> mapM exprToPattern es
  _              -> LHS <$> exprToPattern e <*> return []

-- | Turn an expression into a pattern. Fails if the expression is not a
--   valid pattern.
exprToPattern :: Expr -> Parser Pattern
exprToPattern e = do
    let Just pos = rStart' $ getRange e
        failure = parseErrorAt pos $ "Not a valid pattern: " ++ show e
    case e of
        Ident x                 -> return $ IdentP x
        App _ e1 e2             -> AppP <$> exprToPattern e1
                                        <*> T.mapM (T.mapM exprToPattern) e2
        Paren r e               -> ParenP r
                                        <$> exprToPattern e
        Underscore r _          -> return $ WildP r
        Absurd r                -> return $ AbsurdP r
        As r x e                -> AsP r x <$> exprToPattern e
        Dot r (HiddenArg _ e)   -> return $ HiddenP r $ fmap (DotP r UserWritten) e
        Dot r e                 -> return $ DotP r UserWritten e
        Lit l                   -> return $ LitP l
        HiddenArg r e           -> HiddenP r <$> T.mapM exprToPattern e
        InstanceArg r e         -> InstanceP r <$> T.mapM exprToPattern e
        RawApp r es             -> RawAppP r <$> mapM exprToPattern es
        Quote r                 -> return $ QuoteP r
        Rec r es | Just fs <- mapM maybeLeft es -> do
          RecP r <$> T.mapM (T.mapM exprToPattern) fs
        _                       -> failure

opAppExprToPattern :: OpApp Expr -> Parser Pattern
opAppExprToPattern (SyntaxBindingLambda _ _ _) = parseError "Syntax binding lambda cannot appear in a pattern"
opAppExprToPattern (Ordinary e) = exprToPattern e

-- | Turn an expression into a name. Fails if the expression is not a
--   valid identifier.
exprToName :: Expr -> Parser Name
exprToName (Ident (QName x)) = return x
exprToName e =
  let Just pos = rStart' $ getRange e in
  parseErrorAt pos $ "Not a valid identifier: " ++ show e

stripSingletonRawApp :: Expr -> Expr
stripSingletonRawApp (RawApp _ [e]) = stripSingletonRawApp e
stripSingletonRawApp e = e

isEqual :: Expr -> Maybe (Expr, Expr)
isEqual e =
  case stripSingletonRawApp e of
    Equal _ a b -> Just (stripSingletonRawApp a, stripSingletonRawApp b)
    _           -> Nothing

maybeNamed :: Expr -> Named_ Expr
maybeNamed e =
  case isEqual e of
    Just (Ident (QName x), b) -> named (Ranged (getRange x) (nameToRawName x)) b
    _                         -> unnamed e

patternSynArgs :: [Either Hiding LamBinding] -> Parser [Arg Name]
patternSynArgs = mapM pSynArg
  where
    pSynArg Left{}                   = parseError "Absurd patterns are not allowed in pattern synonyms"
    pSynArg (Right DomainFull{})     = parseError "Unexpected type signature in pattern synonym argument"
    pSynArg (Right (DomainFree a x))
      | getHiding a `notElem` [Hidden, NotHidden] = parseError $ show (getHiding a) ++ " arguments not allowed to pattern synonyms"
      | getRelevance a /= Relevant                = parseError "Arguments to pattern synonyms must be relevant"
      | otherwise                                 = return $ Arg a (boundName x)

parsePanic s = parseError $ "Internal parser error: " ++ s ++ ". Please report this as a bug."

{- RHS or type signature -}

data RHSOrTypeSigs
 = JustRHS RHS
 | TypeSigsRHS Expr
 deriving Show

patternToNames :: Pattern -> Parser [(ArgInfo, Name)]
patternToNames p =
  case p of
    IdentP (QName i)         -> return [(defaultArgInfo, i)]
    WildP r                  -> return [(defaultArgInfo, C.noName r)]
    DotP _ _ (Ident (QName i)) -> return [(setRelevance Irrelevant defaultArgInfo, i)]
    RawAppP _ ps             -> concat <$> mapM patternToNames ps
    _                        -> parseError $
      "Illegal name in type signature: " ++ prettyShow p

funClauseOrTypeSigs :: LHS -> RHSOrTypeSigs -> WhereClause -> Parser [Declaration]
funClauseOrTypeSigs lhs mrhs wh = do
  -- traceShowM lhs
  case mrhs of
    JustRHS rhs   -> return [FunClause lhs rhs wh False]
    TypeSigsRHS e -> case wh of
      NoWhere -> case lhs of
        Ellipsis{}      -> parseError "The ellipsis ... cannot have a type signature"
        LHS _ _ _ (_:_) -> parseError "Illegal: with in type signature"
        LHS _ _ (_:_) _ -> parseError "Illegal: rewrite in type signature"
        LHS _ (_:_) _ _ -> parseError "Illegal: with patterns in type signature"
        LHS p [] [] []  -> map (\ (x, y) -> TypeSig x y e) <$> patternToNames p
      _ -> parseError "A type signature cannot have a where clause"

parseDisplayPragma :: Range -> Position -> String -> Parser Pragma
parseDisplayPragma r pos s =
  case parsePosString pos defaultParseFlags [normal] funclauseParser s of
    ParseOk s [FunClause (LHS lhs [] [] []) (RHS rhs) NoWhere ca] | null (parseInp s) ->
      return $ DisplayPragma r lhs rhs
    _ -> parseError "Invalid DISPLAY pragma. Should have form {-# DISPLAY LHS = RHS #-}."
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 11 "<command-line>" #-}
{-# LINE 1 "/usr/local/stow/ghc-8.0.2-rc2/lib/ghc-8.0.1.20161213/include/ghcversion.h" #-}


















{-# LINE 11 "<command-line>" #-}
{-# LINE 1 "/tmp/ghc19165_0/ghc_2.h" #-}






































































































































































































































































































































































































































































































































































































{-# LINE 11 "<command-line>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 

{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif
{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList





{-# LINE 67 "templates/GenericTemplate.hs" #-}

{-# LINE 77 "templates/GenericTemplate.hs" #-}

{-# LINE 86 "templates/GenericTemplate.hs" #-}

infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}


          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}

                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}


                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)

{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
