# A.5 What are some examples of "Anarchy in Action"?

Anarchism, more than anything else, is about the efforts of millions of
revolutionaries changing the world in the last two centuries. Here we will
discuss some of the high points of this movement, all of them of a profoundly
anti-capitalist nature.

Anarchism **is** about radically changing the world, not just making the
present system less inhuman by encouraging the anarchistic tendencies within
it to grow and develop. While no purely anarchist revolution has taken place
yet, there have been numerous ones with a highly anarchist character and level
of participation. And while these have **all** been destroyed, in each case it
has been at the hands of outside force brought against them (backed either by
Communists or Capitalists), not because of any internal problems in anarchism
itself. These revolutions, despite their failure to survive in the face of
overwhelming force, have been both an inspiration for anarchists and proof
that anarchism is a viable social theory and can be practised on a large
scale.

What these revolutions share is the fact they are, to use Proudhon's term, a
**_"revolution from below"_** \-- they were examples of _"collective activity,
of popular spontaneity."_ It is only a transformation of society from the
bottom up by the action of the oppressed themselves that can create a free
society. As Proudhon asked, _"[w]hat serious and lasting Revolution was not
made **from below,** by the people?"_ For this reason an anarchist is a
_"revolutionary **from below.**"_ Thus the social revolutions and mass
movements we discuss in this section are examples of popular self-activity and
self-liberation (as Proudhon put it in 1848, _"the proletariat must emancipate
itself"_). [quoted by George Woodcock, **Pierre-Joseph Proudhon: A
Biography**, p. 143 and p. 125] All anarchists echo Proudhon's idea of
revolutionary change from below, the creation of a new society by the actions
of the oppressed themselves. Bakunin, for example, argued that anarchists are
_"foes . . . of all State organisations as such, and believe that the people
can only be happy and free, when, organised from below by means of its own
autonomous and completely free associations, without the supervision of any
guardians, it will create its own life."_ [**Marxism, Freedom and the State**,
p. 63] In [section J.7](secJ7.html) we discuss what anarchists think a social
revolution is and what it involves.

Many of these revolutions and revolutionary movements are relatively unknown
to non-anarchists. Most people will have heard of the Russian revolution but
few will know of the popular movements which were its life-blood before the
Bolsheviks seized power or the role that the anarchists played in it. Few will
have heard of the Paris Commune, the Italian factory occupations or the
Spanish collectives. This is unsurprising for, as Hebert Read notes, history
_"is of two kinds -- a record of events that take place publicly, that make
the headlines in the newspapers and get embodied in official records -- we
might call this overground history"_ but _"taking place at the same time,
preparing for these public events, anticipating them, is another kind of
history, that is not embodied in official records, an invisible underground
history."_ [quoted by William R. McKercher, **Freedom and Authority**, p. 155]
Almost by definition, popular movements and revolts are part of _"underground
history"_, the social history which gets ignored in favour of elite history,
the accounts of the kings, queens, politicians and wealthy whose fame is the
product of the crushing of the many.

This means our examples of "anarchy in action" are part of what the Russian
anarchist Voline called _"The Unknown Revolution."_ Voline used that
expression as the title of his classic account of the Russian revolution he
was an active participant of. He used it to refer to the rarely acknowledged
independent, creative actions of the people themselves. As Voline put it, _"it
is not known how to study a revolution"_ and most historians _"mistrust and
ignore those developments which occur silently in the depths of the revolution
. . . at best, they accord them a few words in passing . . . [Yet] it is
precisely these hidden facts which are important, and which throw a true light
on the events under consideration and on the period."_ [**The Unknown
Revolution**, p. 19] Anarchism, based as it is on revolution from below, has
contributed considerably to both the **_"underground history"_** and the
**_"unknown revolution"_** of the past few centuries and this section of the
FAQ will shed some light on its achievements.

It is important to point out that these examples are of wide-scale social
experiments and do not imply that we ignore the undercurrent of anarchist
practice which exists in everyday life, even under capitalism. Both Peter
Kropotkin (in **Mutual Aid**) and Colin Ward (in **Anarchy in Action**) have
documented the many ways in which ordinary people, usually unaware of
anarchism, have worked together as equals to meet their common interests. As
Colin Ward argues, _"an anarchist society, a society which organises itself
without authority, is always in existence, like a seed beneath the snow,
buried under the weight of the state and its bureaucracy, capitalism and its
waste, privilege and its injustices, nationalism and its suicidal loyalties,
religious differences and their superstitious separatism."_ [**Anarchy in
Action**, p. 14]

Anarchism is not only about a future society, it is also about the social
struggle happening today. It is not a condition but a process, which we create
by our self-activity and self-liberation.

By the 1960's, however, many commentators were writing off the anarchist
movement as a thing of the past. Not only had fascism finished off European
anarchist movements in the years before and during the war, but in the post-
war period these movements were prevented from recovering by the capitalist
West on one hand and the Leninist East on the other. Over the same period of
time, anarchism had been repressed in the US, Latin America, China, Korea
(where a social revolution with anarchist content was put down before the
Korean War), and Japan. Even in the one or two countries that escaped the
worst of the repression, the combination of the Cold War and international
isolation saw libertarian unions like the Swedish SAC become reformist.

But the 60's were a decade of new struggle, and all over the world the 'New
Left' looked to anarchism as well as elsewhere for its ideas. Many of the
prominent figures of the massive explosion of May 1968 in France considered
themselves anarchists. Although these movements themselves degenerated, those
coming out of them kept the idea alive and began to construct new movements.
The death of Franco in 1975 saw a massive rebirth of anarchism in Spain, with
up to 500,000 people attending the CNT's first post-Franco rally. The return
to a limited democracy in some South American countries in the late 70's and
80's saw a growth in anarchism there. Finally, in the late 80's it was
anarchists who struck the first blows against the Leninist USSR, with the
first protest march since 1928 being held in Moscow by anarchists in 1987.

Today the anarchist movement, although still weak, organises tens of thousands
of revolutionaries in many countries. Spain, Sweden and Italy all have
libertarian union movements organising some 250,000 between them. Most other
European countries have several thousand active anarchists. Anarchist groups
have appeared for the first time in other countries, including Nigeria and
Turkey. In South America the movement has recovered massively. A contact sheet
circulated by the Venezuelan anarchist group **Corrio A** lists over 100
organisations in just about every country.

Perhaps the recovery is slowest in North America, but there, too, all the
libertarian organisations seem to be undergoing significant growth. As this
growth accelerates, many more examples of anarchy in action will be created
and more and more people will take part in anarchist organisations and
activities, making this part of the FAQ less and less important.

However, it is essential to highlight mass examples of anarchism working on a
large scale in order to avoid the specious accusation of "utopianism." As
history is written by the winners, these examples of anarchy in action are
often hidden from view in obscure books. Rarely are they mentioned in the
schools and universities (or if mentioned, they are distorted). Needless to
say, the few examples we give are just that, a few.

Anarchism has a long history in many countries, and we cannot attempt to
document every example, just those we consider to be important. We are also
sorry if the examples seem Eurocentric. We have, due to space and time
considerations, had to ignore the syndicalist revolt (1910 to 1914) and the
shop steward movement (1917-21) in Britain, Germany (1919-21), Portugal
(1974), the Mexican revolution, anarchists in the Cuban revolution, the
struggle in Korea against Japanese (then US and Russian) imperialism during
and after the Second World War, Hungary (1956), the "the refusal of work"
revolt in the late 1960's (particularly in "the hot Autumn" in Italy, 1969),
the UK miner's strike (1984-85), the struggle against the Poll Tax in Britain
(1988-92), the strikes in France in 1986 and 1995, the Italian COBAS movement
in the 80's and 90's, the popular assemblies and self-managed occupied
workplaces during the Argentine revolt at the start of the 21st century and
numerous other major struggles that have involved anarchist ideas of self-
management (ideas that usually develop from the movement themselves, without
anarchists necessarily playing a major, or "leading", role).

For anarchists, revolutions and mass struggles are **_"festivals of the
oppressed,"_** when ordinary people start to act for themselves and change
both themselves and the world.

## A.5.1 The Paris Commune

The Paris Commune of 1871 played an important role in the development of both
anarchist ideas and the movement. As Bakunin commented at the time,

> _"revolutionary socialism [i.e. anarchism] has just attempted its first
striking and practical demonstration in the Paris Commune . . . [It] show[ed]
to all enslaved peoples (and are there any masses that are not slaves?) the
only road to emancipation and health; Paris inflict[ed] a mortal blow upon the
political traditions of bourgeois radicalism and [gave] a real basis to
revolutionary socialism."_ [**Bakunin on Anarchism**, pp. 263-4]

The Paris Commune was created after France was defeated by Prussia in the
Franco-Prussian war. The French government tried to send in troops to regain
the Parisian National Guard's cannon to prevent it from falling into the hands
of the population. _"Learning that the Versailles soldiers were trying to
seize the cannon,"_ recounted participant Louise Michel, _"men and women of
Montmartre swarmed up the Butte in surprise manoeuvre. Those people who were
climbing up the Butte believed they would die, but they were prepared to pay
the price."_ The soldiers refused to fire on the jeering crowd and turned
their weapons on their officers. This was March 18th; the Commune had begun
and _"the people wakened . . . The eighteenth of March could have belonged to
the allies of kings, or to foreigners, or to the people. It was the
people's."_ [**Red Virgin: Memoirs of Louise Michel**, p. 64]

In the free elections called by the Parisian National Guard, the citizens of
Paris elected a council made up of a majority of Jacobins and Republicans and
a minority of socialists (mostly Blanquists -- authoritarian socialists -- and
followers of the anarchist Proudhon). This council proclaimed Paris autonomous
and desired to recreate France as a confederation of communes (i.e.
communities). Within the Commune, the elected council people were recallable
and paid an average wage. In addition, they had to report back to the people
who had elected them and were subject to recall by electors if they did not
carry out their mandates.

Why this development caught the imagination of anarchists is clear -- it has
strong similarities with anarchist ideas. In fact, the example of the Paris
Commune was in many ways similar to how Bakunin had predicted that a
revolution would have to occur -- a major city declaring itself autonomous,
organising itself, leading by example, and urging the rest of the planet to
follow it. (See _"Letter to Albert Richards"_ in **Bakunin on Anarchism**).
The Paris Commune began the process of creating a new society, one organised
from the bottom up. It was _"a blow for the decentralisation of political
power."_ [Voltairine de Cleyre, _"The Paris Commune,"_ **Anarchy! An Anthology
of Emma Goldman's Mother Earth**, p. 67]

Many anarchists played a role within the Commune -- for example Louise Michel,
the Reclus brothers, and Eugene Varlin (the latter murdered in the repression
afterwards). As for the reforms initiated by the Commune, such as the re-
opening of workplaces as co-operatives, anarchists can see their ideas of
associated labour beginning to be realised. By May, 43 workplaces were co-
operatively run and the Louvre Museum was a munitions factory run by a
workers' council. Echoing Proudhon, a meeting of the Mechanics Union and the
Association of Metal Workers argued that _"our economic emancipation . . . can
only be obtained through the formation of workers' associations, which alone
can transform our position from that of wage earners to that of associates."_
They instructed their delegates to the Commune's Commission on Labour
Organisation to support the following objectives:

> _ "The abolition of the exploitation of man by man, the last vestige of
slavery;_

> _"The organisation of labour in mutual associations and inalienable
capital."_

In this way, they hoped to ensure that _"equality must not be an empty word"_
in the Commune. [**The Paris Commune of 1871: The View from the Left**, Eugene
Schulkind (ed.), p. 164] The Engineers Union voted at a meeting on 23rd of
April that since the aim of the Commune should be _"economic emancipation"_ it
should _"organise labour through associations in which there would be joint
responsibility"_ in order _"to suppress the exploitation of man by man."_
[quoted by Stewart Edwards, **The Paris Commune 1871**, pp. 263-4]

As well as self-managed workers' associations, the Communards practised direct
democracy in a network popular clubs, popular organisations similar to the
directly democratic neighbourhood assemblies (_"sections"_) of the French
Revolution. _"People, govern yourselves through your public meetings, through
your press"_ proclaimed the newspaper of one Club. The commune was seen as an
expression of the assembled people, for (to quote another Club) _"Communal
power resides in each arrondissement [neighbourhood] wherever men are
assembled who have a horror of the yoke and of servitude."_ Little wonder that
Gustave Courbet, artist friend and follower of Proudhon, proclaimed Paris as
_"a true paradise . . . all social groups have established themselves as
federations and are masters of their own fate."_ [quoted by Martin Phillip
Johnson, **The Paradise of Association**, p. 5 and p. 6]

In addition the Commune's _"Declaration to the French People"_ which echoed
many key anarchist ideas. It saw the _"political unity"_ of society as being
based on _"the voluntary association of all local initiatives, the free and
spontaneous concourse of all individual energies for the common aim, the well-
being, the liberty and the security of all."_ [quoted by Edwards, **Op.
Cit.**, p. 218] The new society envisioned by the communards was one based on
the _"absolute autonomy of the Commune . . . assuring to each its integral
rights and to each Frenchman the full exercise of his aptitudes, as a man, a
citizen and a labourer. The autonomy of the Commune will have for its limits
only the equal autonomy of all other communes adhering to the contract; their
association must ensure the liberty of France."_ [_"Declaration to the French
People"_, quoted by George Woodcock, **Pierre-Joseph Proudhon: A Biography**,
pp. 276-7] With its vision of a confederation of communes, Bakunin was correct
to assert that the Paris Commune was _"a bold, clearly formulated negation of
the State."_ [**Bakunin on Anarchism**, p. 264]

Moreover, the Commune's ideas on federation obviously reflected the influence
of Proudhon on French radical ideas. Indeed, the Commune's vision of a
communal France based on a federation of delegates bound by imperative
mandates issued by their electors and subject to recall at any moment echoes
Proudhon's ideas (Proudhon had argued in favour of the _"implementation of the
binding mandate"_ in 1848 [**No Gods, No Masters**, p. 63] and for federation
of communes in his work **The Principle of Federation**).

Thus both economically and politically the Paris Commune was heavily
influenced by anarchist ideas. Economically, the theory of associated
production expounded by Proudhon and Bakunin became consciously revolutionary
practice. Politically, in the Commune's call for federalism and autonomy,
anarchists see their _"future social organisation. . . [being] carried out
from the bottom up, by the free association or federation of workers, starting
with associations, then going into the communes, the regions, the nations,
and, finally, culminating in a great international and universal federation."_
[Bakunin, **Op. Cit.**, p. 270]

However, for anarchists the Commune did not go far enough. It did not abolish
the state within the Commune, as it had abolished it beyond it. The Communards
organised themselves _"in a Jacobin manner"_ (to use Bakunin's cutting term).
As Peter Kropotkin pointed out, while _"proclaiming the free Commune, the
people of Paris proclaimed an essential anarchist principle . . . they stopped
mid-course"_ and gave _"themselves a Communal Council copied from the old
municipal councils."_ Thus the Paris Commune did not _"break with the
tradition of the State, of representative government, and it did not attempt
to achieve within the Commune that organisation from the simple to the complex
it inaugurated by proclaiming the independence and free federation of the
Communes."_ This lead to disaster as the Commune council became _"immobilised
. . . by red tape"_ and lost _"the sensitivity that comes from continued
contact with the masses . . . Paralysed by their distancing from the
revolutionary centre -- the people -- they themselves paralysed the popular
initiative."_ [**Words of a Rebel**, p. 97, p. 93 and p. 97]

In addition, its attempts at economic reform did not go far enough, making no
attempt to turn all workplaces into co-operatives (i.e. to expropriate
capital) and forming associations of these co-operatives to co-ordinate and
support each other's economic activities. Paris, stressed Voltairine de
Cleyre, _"failed to strike at economic tyranny, and so came of what it could
have achieved"_ which was a _"free community whose economic affairs shall be
arranged by the groups of actual producers and distributors, eliminating the
useless and harmful element now in possession of the world's capital."_ [**Op.
Cit.**, p. 67] As the city was under constant siege by the French army, it is
understandable that the Communards had other things on their minds. However,
for Kropotkin such a position was a disaster:

> _ "They treated the economic question as a secondary one, which would be
attended to later on, **after** the triumph of the Commune . . . But the
crushing defeat which soon followed, and the blood-thirsty revenge taken by
the middle class, proved once more that the triumph of a popular Commune was
materially impossible without a parallel triumph of the people in the economic
field."_ [**Op. Cit.**, p. 74]

Anarchists drew the obvious conclusions, arguing that _"if no central
government was needed to rule the independent Communes, if the national
Government is thrown overboard and national unity is obtained by free
federation, then a central **municipal** Government becomes equally useless
and noxious. The same federative principle would do within the Commune."_
[Kropotkin, **Evolution and Environment**, p. 75] Instead of abolishing the
state within the commune by organising federations of directly democratic mass
assemblies, like the Parisian "sections" of the revolution of 1789-93 (see
Kropotkin's **Great French Revolution** for more on these), the Paris Commune
kept representative government and suffered for it. _"Instead of acting for
themselves . . . the people, confiding in their governors, entrusted them the
charge of taking the initiative. This was the first consequence of the
inevitable result of elections."_ The council soon became _"the greatest
obstacle to the revolution"_ thus proving the _"political axiom that a
government cannot be revolutionary."_ [**Anarchism**, p. 240, p. 241 and p.
249]

The council become more and more isolated from the people who elected it, and
thus more and more irrelevant. And as its irrelevance grew, so did its
authoritarian tendencies, with the Jacobin majority creating a _"Committee of
Public Safety" _to_ "defend"_ (by terror) the "revolution." The Committee was
opposed by the libertarian socialist minority and was, fortunately, ignored in
practice by the people of Paris as they defended their freedom against the
French army, which was attacking them in the name of capitalist civilisation
and "liberty." On May 21st, government troops entered the city, followed by
seven days of bitter street fighting. Squads of soldiers and armed members of
the bourgeoisie roamed the streets, killing and maiming at will. Over 25,000
people were killed in the street fighting, many murdered after they had
surrendered, and their bodies dumped in mass graves. As a final insult,
**Sacré Coeur** was built by the bourgeoisie on the birth place of the
Commune, the Butte of Montmartre, to atone for the radical and atheist revolt
which had so terrified them.

For anarchists, the lessons of the Paris Commune were threefold. Firstly, a
decentralised confederation of communities is the necessary political form of
a free society (_"**This was the form that the social revolution must take**
\-- the independent commune."_ [Kropotkin, **Op. Cit.**, p. 163]). Secondly,
_"there is no more reason for a government inside a Commune than for
government above the Commune."_ This means that an anarchist community will be
based on a confederation of neighbourhood and workplace assemblies freely co-
operating together. Thirdly, it is critically important to unify political and
economic revolutions into a **social** revolution. _"They tried to consolidate
the Commune first and put off the social revolution until later, whereas the
only way to proceed was **to consolidate the Commune by means of the social
revolution!**"_ [Peter Kropotkin, **Words of a Rebel **, p. 97]

For more anarchist perspectives on the Paris Commune see Kropotkin's essay
_"The Paris Commune"_ in **Words of a Rebel** (and **The Anarchist Reader**)
and Bakunin's _"The Paris Commune and the Idea of the State"_ in **Bakunin on
Anarchism**.

## A.5.2 The Haymarket Martyrs

May 1st is a day of special significance for the labour movement. While it has
been hijacked in the past by the Stalinist bureaucracy in the Soviet Union and
elsewhere, the labour movement festival of May Day is a day of world-wide
solidarity. A time to remember past struggles and demonstrate our hope for a
better future. A day to remember that an injury to one is an injury to all.

The history of Mayday is closely linked with the anarchist movement and the
struggles of working people for a better world. Indeed, it originated with the
execution of four anarchists in Chicago in 1886 for organising workers in the
fight for the eight-hour day. Thus May Day is a product of **_"anarchy in
action"_** \-- of the struggle of working people using direct action in labour
unions to change the world.

It began in the 1880s in the USA. In 1884, the **Federation of Organised
Trades and Labor Unions of the United States and Canada** (created in 1881, it
changed its name in 1886 to the **American Federation of Labor**) passed a
resolution which asserted that _"eight hours shall constitute a legal day's
work from and after May 1, 1886, and that we recommend to labour organisations
throughout this district that they so direct their laws as to conform to this
resolution."_ A call for strikes on May 1st, 1886 was made in support of this
demand.

In Chicago the anarchists were the main force in the union movement, and
partially as a result of their presence, the unions translated this call into
strikes on May 1st. The anarchists thought that the eight hour day could only
be won through direct action and solidarity. They considered that struggles
for reforms, like the eight hour day, were not enough in themselves. They
viewed them as only one battle in an ongoing class war that would only end by
social revolution and the creation of a free society. It was with these ideas
that they organised and fought.

In Chicago alone, 400 000 workers went out and the threat of strike action
ensured that more than 45 000 were granted a shorter working day without
striking. On May 3, 1886, police fired into a crowd of pickets at the
McCormick Harvester Machine Company, killing at least one striker, seriously
wounding five or six others, and injuring an undetermined number. Anarchists
called for a mass meeting the next day in Haymarket Square to protest the
brutality. According to the Mayor, _"nothing had occurred yet, or looked
likely to occur to require interference."_ However, as the meeting was
breaking up a column of 180 police arrived and ordered the meeting to end. At
this moment a bomb was thrown into the police ranks, who opened fire on the
crowd. How many civilians were wounded or killed by the police was never
exactly ascertained, but 7 policemen eventually died (ironically, only one was
the victim of the bomb, the rest were a result of the bullets fired by the
police [Paul Avrich, **The Haymarket Tragedy**, p. 208]).

A _"reign of terror"_ swept over Chicago, and the _"organised banditti and
conscienceless brigands of capital suspended the only papers which would give
the side of those whom they crammed into prison cells. They have invaded the
homes of everyone who has ever known to have raised a voice or sympathised
with those who have aught to say against the present system of robbery and
oppression . . . they have invaded their homes and subjected them and their
families to indignities that must be seen to be believed."_ [Lucy Parsons,
**Liberty, Equality &amp; Solidarity**, p. 53] Meeting halls, union offices,
printing shops and private homes were raided (usually without warrants). Such
raids into working-class areas allowed the police to round up all known
anarchists and other socialists. Many suspects were beaten up and some bribed.
_"Make the raids first and look up the law afterwards"_ was the public
statement of J. Grinnell, the States Attorney, when a question was raised
about search warrants. [_"Editor's Introduction"_, **The Autobiographies of
the Haymarket Martyrs**, p. 7]

Eight anarchists were put on trial for accessory to murder. No pretence was
made that any of the accused had carried out or even planned the bomb. The
judge ruled that it was not necessary for the state to identify the actual
perpetrator or prove that he had acted under the influence of the accused. The
state did not try to establish that the defendants had in any way approved or
abetted the act. In fact, only three were present at the meeting when the bomb
exploded and one of those, Albert Parsons, was accompanied by his wife and
fellow anarchist Lucy and their two small children to the event.

The reason why these eight were picked was because of their anarchism and
union organising, as made clear by that State's Attorney when he told the jury
that _"Law is on trial. Anarchy is on trial. These men have been selected,
picked out by the Grand Jury, and indicted because they were leaders. They are
no more guilty than the thousands who follow them. Gentlemen of the jury;
convict these men, make examples of them, hang them and you save our
institutions, our society."_ The jury was selected by a special bailiff,
nominated by the State's Attorney and was explicitly chosen to compose of
businessmen and a relative of one of the cops killed. The defence was not
allowed to present evidence that the special bailiff had publicly claimed _"I
am managing this case and I know what I am about. These fellows are going to
be hanged as certain as death."_ [**Op. Cit.**, p. 8] Not surprisingly, the
accused were convicted. Seven were sentenced to death, one to 15 years'
imprisonment.

An international campaign resulted in two of the death sentences being
commuted to life, but the world wide protest did not stop the US state. Of the
remaining five, one (Louis Lingg) cheated the executioner and killed himself
on the eve of the execution. The remaining four (Albert Parsons, August Spies,
George Engel and Adolph Fischer) were hanged on November 11th 1887. They are
known in Labour history as the Haymarket Martyrs. Between 150,000 and 500,000
lined the route taken by the funeral cortege and between 10,000 to 25,000 were
estimated to have watched the burial.

In 1889, the American delegation attending the International Socialist
congress in Paris proposed that May 1st be adopted as a workers' holiday. This
was to commemorate working class struggle and the _"Martyrdom of the Chicago
Eight"_. Since then Mayday has became a day for international solidarity. In
1893, the new Governor of Illinois made official what the working class in
Chicago and across the world knew all along and pardoned the Martyrs because
of their obvious innocence and because _"the trial was not fair."_ To this
day, no one knows who threw the bomb -- the only definite fact is that it was
not any of those who were tried for the act: _"Our comrades were not murdered
by the state because they had any connection with the bomb-throwing, but
because they had been active in organising the wage-slaves of America."_ [Lucy
Parsons, **Op. Cit.**, p. 142]

The authorities had believed at the time of the trial that such persecution
would break the back of the labour movement. As Lucy Parsons, a participant of
the events, noted 20 years later, the Haymarket trial _"was a class trial --
relentless, vindictive, savage and bloody. By that prosecution the capitalists
sought to break the great strike for the eight-hour day which as being
successfully inaugurated in Chicago, this city being the stormcentre of that
great movement; and they also intended, by the savage manner in which they
conducted the trial of these men, to frighten the working class back to their
long hours of toil and low wages from which they were attempting to emerge.
The capitalistic class imagined they could carry out their hellish plot by
putting to an ignominious death the most progressive leaders among the working
class of that day. In executing their bloody deed of judicial murder they
succeeded, but in arresting the mighty onward movement of the class struggle
they utterly failed."_ [Lucy Parsons, **Op. Cit.**, p. 128] In the words of
August Spies when he addressed the court after he had been sentenced to die:

> _ "If you think that by hanging us you can stamp out the labour movement . .
. the movement from which the downtrodden millions, the millions who toil in
misery and want, expect salvation -- if this is your opinion, then hang us!
Here you will tread on a spark, but there and there, behind you -- and in
front of you, and everywhere, flames blaze up. It is a subterranean fire. You
cannot put it out."_ [quoted by Paul Avrich, **Op. Cit.**, p. 287]

At the time and in the years to come, this defiance of the state and
capitalism was to win thousands to anarchism, particularly in the US itself.
Since the Haymarket event, anarchists have celebrated May Day (on the 1st of
May -- the reformist unions and labour parties moved its marches to the first
Sunday of the month). We do so to show our solidarity with other working class
people across the world, to celebrate past and present struggles, to show our
power and remind the ruling class of their vulnerability. As Nestor Makhno put
it:

> _"That day those American workers attempted, by organising themselves, to
give expression to their protest against the iniquitous order of the State and
Capital of the propertied . . . _

> "The workers of Chicago . . . had gathered to resolve, in common, the
problems of their lives and their struggles. . .

> "Today too . . . the toilers . . . regard the first of May as the occasion
of a get-together when they will concern themselves with their own affairs and
consider the matter of their emancipation." [**The Struggle Against the State
and Other Essays**, pp. 59-60]

Anarchists stay true to the origins of May Day and celebrate its birth in the
direct action of the oppressed. It is a classic example of anarchist
principles of direct action and solidarity, _"an historic event of great
importance, inasmuch as it was, in the first place, the first time that
workers themselves had attempted to get a shorter work day by united,
simultaneous action . . . this strike was the first in the nature of Direct
Action on a large scale, the first in America."_ [Lucy Parsons, **Op. Cit.**,
pp. 139-40] Oppression and exploitation breed resistance and, for anarchists,
May Day is an international symbol of that resistance and power -- a power
expressed in the last words of August Spies, chiselled in stone on the
monument to the Haymarket martyrs in Waldheim Cemetery in Chicago:

> _"The day will come when our silence will be more powerful than the voices
you are throttling today."_

To understand why the state and business class were so determined to hang the
Chicago Anarchists, it is necessary to realise they were considered the
leaders of a massive radical union movement. In 1884, the Chicago Anarchists
produced the world's first daily anarchist newspaper, the **Chicagoer
Arbeiter-Zeiting**. This was written, read, owned and published by the German
immigrant working class movement. The combined circulation of this daily plus
a weekly (**Vorbote**) and a Sunday edition (**Fackel**) more than doubled,
from 13,000 per issues in 1880 to 26,980 in 1886. Anarchist weekly papers
existed for other ethnic groups as well (one English, one Bohemian and one
Scandinavian).

Anarchists were very active in the Central Labour Union (which included the
eleven largest unions in the city) and aimed to make it, in the words of
Albert Parsons (one of the Martyrs), _"the embryonic group of the future 'free
society.'"_ The anarchists were also part of the **International Working
People's Association** (also called the **_"Black International"_**) which had
representatives from 26 cities at its founding convention. The I.W.P.A. soon
_"made headway among trade unions, especially in the mid-west"_ and its ideas
of _"direct action of the rank and file"_ and of trade unions _"serv[ing] as
the instrument of the working class for the complete destruction of capitalism
and the nucleus for the formation of a new society"_ became known as the
**_"Chicago Idea"_** (an idea which later inspired the **Industrial Workers of
the World** which was founded in Chicago in 1905). [_"Editor's Introduction,"_
**The Autobiographies of the Haymarket Martyrs**, p. 4]

This idea was expressed in the manifesto issued at the I.W.P.A.'s Pittsburgh
Congress of 1883:

> _ "First -- Destruction of the existing class rule, by all means, i.e. by
energetic, relentless, revolutionary and international action._

> _ "Second -- Establishment of a free society based upon co-operative
organisation of production._

> _ "Third -- Free exchange of equivalent products by and between the
productive organisations without commerce and profit-mongery._

> _ "Fourth -- Organisation of education on a secular, scientific and equal
basis for both sexes._

> _ "Fifth -- Equal rights for all without distinction to sex or race._

> _ "Sixth -- Regulation of all public affairs by free contracts between
autonomous (independent) communes and associations, resting on a federalistic
basis."_ [**Op. Cit.**, p. 42]

In addition to their union organising, the Chicago anarchist movement also
organised social societies, picnics, lectures, dances, libraries and a host of
other activities. These all helped to forge a distinctly working-class
revolutionary culture in the heart of the _"American Dream."_ The threat to
the ruling class and their system was too great to allow it to continue
(particularly with memories of the vast uprising of labour in 1877 still
fresh. As in 1886, that revolt was also meet by state violence -- see
**Strike!** by J. Brecher for details of this strike movement as well as the
Haymarket events). Hence the repression, kangaroo court, and the state murder
of those the state and capitalist class considered "leaders" of the movement.

For more on the Haymarket Martyrs, their lives and their ideas, **The
Autobiographies of the Haymarket Martyrs** is essential reading. Albert
Parsons, the only American born Martyr, produced a book which explained what
they stood for called **Anarchism: Its Philosophy and Scientific Basis**.
Historian Paul Avrich's **The Haymarket Tragedy** is a useful in depth account
of the events.

## A.5.3 Building the Syndicalist Unions

Just before the turn of the century in Europe, the anarchist movement began to
create one of the most successful attempts to apply anarchist organisational
ideas in everyday life. This was the building of mass revolutionary unions
(also known as syndicalism or anarcho-syndicalism). The syndicalist movement,
in the words of a leading French syndicalist militant, was _"a practical
schooling in anarchism"_ for it was _"a laboratory of economic struggles"_ and
organised _"along anarchic lines."_ By organising workers into _"libertarian
organisations,"_ the syndicalist unions were creating the _"free associations
of free producers"_ within capitalism to combat it and, ultimately, replace
it. [Fernand Pelloutier, **No Gods, No Masters**, vol. 2, p. 57, p. 55 and p.
56]

While the details of syndicalist organisation varied from country to country,
the main lines were the same. Workers should form themselves into unions (or
**_syndicates_**, the French for union). While organisation by industry was
generally the preferred form, craft and trade organisations were also used.
These unions were directly controlled by their members and would federate
together on an industrial and geographical basis. Thus a given union would be
federated with all the local unions in a given town, region and country as
well as with all the unions within its industry into a national union (of,
say, miners or metal workers). Each union was autonomous and all officials
were part-time (and paid their normal wages if they missed work on union
business). The tactics of syndicalism were direct action and solidarity and
its aim was to replace capitalism by the unions providing the basic framework
of the new, free, society.

Thus, for anarcho-syndicalism, _"the trade union is by no means a mere
transitory phenomenon bound up with the duration of capitalist society, it is
the germ of the Socialist economy of the future, the elementary school of
Socialism in general."_ The _"economic fighting organisation of the workers"_
gives their members _"every opportunity for direct action in their struggles
for daily bread, it also provides them with the necessary preliminaries for
carrying through the reorganisation of social life on a [libertarian]
Socialist plan by them own strength."_ [Rudolf Rocker, **Anarcho-
Syndicalism**, p. 59 and p. 62] Anarcho-syndicalism, to use the expression of
the I.W.W., aims to build the new world in the shell of the old.

In the period from the 1890's to the outbreak of World War I, anarchists built
revolutionary unions in most European countries (particularly in Spain, Italy
and France). In addition, anarchists in South and North America were also
successful in organising syndicalist unions (particularly Cuba, Argentina,
Mexico and Brazil). Almost all industrialised countries had some syndicalist
movement, although Europe and South America had the biggest and strongest
ones. These unions were organised in a confederal manner, from the bottom up,
along anarchist lines. They fought with capitalists on a day-to-day basis
around the issue of better wages and working conditions and the state for
social reforms, but they also sought to overthrow capitalism through the
revolutionary general strike.

Thus hundreds of thousands of workers around the world were applying anarchist
ideas in everyday life, proving that anarchy was no utopian dream but a
practical method of organising on a wide scale. That anarchist organisational
techniques encouraged member participation, empowerment and militancy, and
that they also successfully fought for reforms and promoted class
consciousness, can be seen in the growth of anarcho-syndicalist unions and
their impact on the labour movement. The Industrial Workers of the World, for
example, still inspires union activists and has, throughout its long history,
provided many union songs and slogans.

However, as a mass movement, syndicalism effectively ended by the 1930s. This
was due to two factors. Firstly, most of the syndicalist unions were severely
repressed just after World War I. In the immediate post-war years they reached
their height. This wave of militancy was known as the "red years" in Italy,
where it attained its high point with factory occupations (see [section
A.5.5](secA5.html#seca55)). But these years also saw the destruction of these
unions in country after county. In the USA, for example, the I.W.W. was
crushed by a wave of repression backed whole-heartedly by the media, the
state, and the capitalist class. Europe saw capitalism go on the offensive
with a new weapon -- fascism. Fascism arose (first in Italy and, most
infamously, in Germany) as an attempt by capitalism to physically smash the
organisations the working class had built. This was due to radicalism that had
spread across Europe in the wake of the war ending, inspired by the example of
Russia. Numerous near revolutions had terrified the bourgeoisie, who turned to
fascism to save their system.

In country after country, anarchists were forced to flee into exile, vanish
from sight, or became victims of assassins or concentration camps after their
(often heroic) attempts at fighting fascism failed. In Portugal, for example,
the 100,000 strong anarcho-syndicalist CGT union launched numerous revolts in
the late 1920s and early 1930s against fascism. In January 1934, the CGT
called for a revolutionary general strike which developed into a five day
insurrection. A state of siege was declared by the state, which used extensive
force to crush the rebellion. The CGT, whose militants had played a prominent
and courageous role in the insurrection, was completely smashed and Portugal
remained a fascist state for the next 40 years. [Phil Mailer, **Portugal: The
Impossible Revolution**, pp. 72-3] In Spain, the CNT (the most famous anarcho-
syndicalist union) fought a similar battle. By 1936, it claimed one and a half
million members. As in Italy and Portugal, the capitalist class embraced
fascism to save their power from the dispossessed, who were becoming confident
of their power and their right to manage their own lives (see [section
A.5.6](secA5.html#seca56)).

As well as fascism, syndicalism also faced the negative influence of Leninism.
The apparent success of the Russian revolution led many activists to turn to
authoritarian politics, particularly in English speaking countries and, to a
lesser extent, France. Such notable syndicalist activists as Tom Mann in
England, William Gallacher in Scotland and William Foster in the USA became
Communists (the last two, it should be noted, became Stalinist). Moreover,
Communist parties deliberately undermined the libertarian unions, encouraging
fights and splits (as, for example, in the I.W.W.). After the end of the
Second World War, the Stalinists finished off what fascism had started in
Eastern Europe and destroyed the anarchist and syndicalist movements in such
places as Bulgaria and Poland. In Cuba, Castro also followed Lenin's example
and did what the Batista and Machado dictatorship's could not, namely smash
the influential anarchist and syndicalist movements (see Frank Fernandez's
**Cuban Anarchism** for a history of this movement from its origins in the
1860s to the 21st century).

So by the start of the second world war, the large and powerful anarchist
movements of Italy, Spain, Poland, Bulgaria and Portugal had been crushed by
fascism (but not, we must stress, without a fight). When necessary, the
capitalists supported authoritarian states in order to crush the labour
movement and make their countries safe for capitalism. Only Sweden escaped
this trend, where the syndicalist union the SAC is still organising workers.
It is, in fact, like many other syndicalist unions active today, growing as
workers turn away from bureaucratic unions whose leaders seem more interested
in protecting their privileges and cutting deals with management than
defending their members. In France, Spain and Italy and elsewhere, syndicalist
unions are again on the rise, showing that anarchist ideas are applicable in
everyday life.

Finally, it must be stressed that syndicalism has its roots in the ideas of
the earliest anarchists and, consequently, was not invented in the 1890s. It
is true that development of syndicalism came about, in part, as a reaction to
the disastrous "propaganda by deed" period, in which individual anarchists
assassinated government leaders in attempts to provoke a popular uprising and
in revenge for the mass murders of the Communards and other rebels (see
[section A.2.18](secA2.html#seca218) for details). But in response to this
failed and counterproductive campaign, anarchists went back to their roots and
to the ideas of Bakunin. Thus, as recognised by the likes of Kropotkin and
Malatesta, syndicalism was simply a return to the ideas current in the
libertarian wing of the First International.

Thus we find Bakunin arguing that _"it is necessary to organise the power of
the proletariat. But this organisation must be the work of the proletariat
itself . . . Organise, constantly organise the international militant
solidarity of the workers, in every trade and country, and remember that
however weak you are as isolated individuals or districts, you will constitute
a tremendous, invincible power by means of universal co-operation."_ As one
American activist commented, this is _"the same militant spirit that breathes
now in the best expressions of the Syndicalist and I.W.W. movements"_ both of
which express _"a strong world wide revival of the ideas for which Bakunin
laboured throughout his life."_ [Max Baginski, **Anarchy! An Anthology of Emma
Goldman's Mother Earth**, p. 71] As with the syndicalists, Bakunin stressed
the _"organisation of trade sections, their federation . . . bear in
themselves the living germs of **the new social order,** which is to replace
the bourgeois world. They are creating not only the ideas but also the facts
of the future itself."_ [quoted by Rudolf Rocker, **Op. Cit.**, p. 50]

Such ideas were repeated by other libertarians. Eugene Varlin, whose role in
the Paris Commune ensured his death, advocated a socialism of associations,
arguing in 1870 that syndicates were the _"natural elements"_ for the
rebuilding of society: _"it is they that can easily be transformed into
producer associations; it is they that can put into practice the retooling of
society and the organisation of production."_ [quoted by Martin Phillip
Johnson, **The Paradise of Association**, p. 139] As we discussed in [section
A.5.2](secA5.html#seca52), the Chicago Anarchists held similar views, seeing
the labour movement as both the means of achieving anarchy and the framework
of the free society. As Lucy Parsons (the wife of Albert) put it _"we hold
that the granges, trade-unions, Knights of Labour assemblies, etc., are the
embryonic groups of the ideal anarchistic society . . ."_ [contained in Albert
R. Parsons, **Anarchism: Its Philosophy and Scientific Basis**, p. 110] These
ideas fed into the revolutionary unionism of the I.W.W. As one historian
notes, the _"proceedings of the I.W.W.'s inaugural convention indicate that
the participants were not only aware of the 'Chicago Idea' but were conscious
of a continuity between their efforts and the struggles of the Chicago
anarchists to initiate industrial unionism."_ The Chicago idea represented
_"the earliest American expression of syndicalism."_ [Salvatore Salerno, **Red
November, Black November**, p. 71]

Thus, syndicalism and anarchism are not differing theories but, rather,
different interpretations of the same ideas (see for a fuller discussion
[section H.2.8](secH2.html#sech28)). While not all syndicalists are anarchists
(some Marxists have proclaimed support for syndicalism) and not all anarchists
are syndicalists (see [section J.3.9](secJ3.html#secj39) for a discussion
why), all social anarchists see the need for taking part in the labour and
other popular movements and encouraging libertarian forms of organisation and
struggle within them. By doing this, inside and outside of syndicalist unions,
anarchists are showing the validity of our ideas. For, as Kropotkin stressed,
the _"next revolution must from its inception bring about the seizure of the
entire social wealth by the workers in order to transform it into common
property. This revolution can succeed only through the workers, only if the
urban and rural workers everywhere carry out this objective themselves. To
that end, they must initiate their own action in the period **before the
revolution**; this can happen only if there is a strong **workers'
organisation.**"_ [**Selected Writings on Anarchism and Revolution**, p. 20]
Such popular self-managed organisations cannot be anything but **_"anarchy in
action."_**

## A.5.4 Anarchists in the Russian Revolution

The Russian revolution of 1917 saw a huge growth in anarchism in that country
and many experiments in anarchist ideas. However, in popular culture the
Russian Revolution is seen not as a mass movement by ordinary people
struggling towards freedom but as the means by which Lenin imposed his
dictatorship on Russia. The truth is radically different. The Russian
Revolution was a mass movement from below in which many different currents of
ideas existed and in which millions of working people (workers in the cities
and towns as well as peasants) tried to transform their world into a better
place. Sadly, those hopes and dreams were crushed under the dictatorship of
the Bolshevik party -- first under Lenin, later under Stalin.

The Russian Revolution, like most history, is a good example of the maxim
"history is written by those who win." Most capitalist histories of the period
between 1917 and 1921 ignore what the anarchist Voline called **_"the unknown
revolution"_** \-- the revolution called forth from below by the actions of
ordinary people. Leninist accounts, at best, praise this autonomous activity
of workers so long as it coincides with their own party line but radically
condemn it (and attribute it with the basest motives) as soon as it strays
from that line. Thus Leninist accounts will praise the workers when they move
ahead of the Bolsheviks (as in the spring and summer of 1917) but will condemn
them when they oppose Bolshevik policy once the Bolsheviks are in power. At
worse, Leninist accounts portray the movement and struggles of the masses as
little more than a backdrop to the activities of the vanguard party.

For anarchists, however, the Russian Revolution is seen as a classic example
of a social revolution in which the self-activity of working people played a
key role. In their soviets, factory committees and other class organisations,
the Russian masses were trying to transform society from a class-ridden,
hierarchical statist regime into one based on liberty, equality and
solidarity. As such, the initial months of the Revolution seemed to confirm
Bakunin's prediction that the _"future social organisation must be made solely
from the bottom upwards, by the free associations or federations of workers,
firstly in their unions, then in the communes, regions, nations and finally in
a great federation, international and universal."_ [**Michael Bakunin:
Selected Writings**, p. 206] The soviets and factory committees expressed
concretely Bakunin's ideas and Anarchists played an important role in the
struggle.

The initial overthrow of the Tsar came from the direct action of the masses.
In February 1917, the women of Petrograd erupted in bread riots. On February
18th, the workers of the Putilov Works in Petrograd went on strike. By
February 22nd, the strike had spread to other factories. Two days later, 200
000 workers were on strike and by February 25th the strike was virtually
general. The same day also saw the first bloody clashes between protestors and
the army. The turning point came on the 27th, when some troops went over to
the revolutionary masses, sweeping along other units. This left the government
without its means of coercion, the Tsar abdicated and a provisional government
was formed.

So spontaneous was this movement that all the political parties were left
behind. This included the Bolsheviks, with the _"Petrograd organisation of the
Bolsheviks oppos[ing] the calling of strikes precisely on the eve of the
revolution destined to overthrow the Tsar. Fortunately, the workers ignored
the Bolshevik 'directives' and went on strike anyway . . . Had the workers
followed its guidance, it is doubtful that the revolution would have occurred
when it did."_ [Murray Bookchin, **Post-Scarcity Anarchism**, p. 123]

The revolution carried on in this vein of direct action from below until the
new, "socialist" state was powerful enough to stop it.

For the Left, the end of Tsarism was the culmination of years of effort by
socialists and anarchists everywhere. It represented the progressive wing of
human thought overcoming traditional oppression, and as such was duly praised
by leftists around the world. However, **in** Russia things were progressing.
In the workplaces and streets and on the land, more and more people became
convinced that abolishing feudalism politically was **not** enough. The
overthrow of the Tsar made little real difference if feudal exploitation still
existed in the economy, so workers started to seize their workplaces and
peasants, the land. All across Russia, ordinary people started to build their
own organisations, unions, co-operatives, factory committees and councils (or
"soviets" in Russian). These organisations were initially organised in
anarchist fashion, with recallable delegates and being federated with each
other.

Needless to say, all the political parties and organisations played a role in
this process. The two wings of the Marxist social-democrats were active (the
Mensheviks and the Bolsheviks), as were the Social Revolutionaries (a populist
peasant based party) and the anarchists. The anarchists participated in this
movement, encouraging all tendencies to self-management and urging the
overthrow of the provisional government. They argued that it was necessary to
transform the revolution from a purely political one into an economic/social
one. Until the return of Lenin from exile, they were the only political
tendency who thought along those lines.

Lenin convinced his party to adopt the slogan _"All Power to the Soviets"_ and
push the revolution forward. This meant a sharp break with previous Marxist
positions, leading one ex-Bolshevik turned Menshevik to comment that Lenin had
_"made himself a candidate for one European throne that has been vacant for
thirty years -- the throne of Bakunin!"_ [quoted by Alexander Rabinowitch,
**Prelude to Revolution**, p. 40] The Bolsheviks now turned to winning mass
support, championing direct action and supporting the radical actions of the
masses, policies in the past associated with anarchism (_"the Bolsheviks
launched . . . slogans which until then had been particularly and insistently
been voiced by the Anarchists."_ [Voline, **The Unknown Revolution**, p.
210]). Soon they were winning more and more votes in the soviet and factory
committee elections. As Alexander Berkman argues, the _"Anarchist mottoes
proclaimed by the Bolsheviks did not fail to bring results. The masses relied
to their flag."_ [**What is Anarchism?**, p. 120]

The anarchists were also influential at this time. Anarchists were
particularly active in the movement for workers self-management of production
which existed around the factory committees (see M. Brinton, **The Bolsheviks
and Workers Control** for details). They were arguing for workers and peasants
to expropriate the owning class, abolish all forms of government and re-
organise society from the bottom up using their own class organisations -- the
soviets, the factory committees, co-operatives and so on. They could also
influence the direction of struggle. As Alexander Rabinowitch (in his study of
the July uprising of 1917) notes:

> _ "At the rank-and-file level, particularly within the [Petrograd] garrison
and at the Kronstadt naval base, there was in fact very little to distinguish
Bolshevik from Anarchist. . . The Anarchist-Communists and the Bolsheviks
competed for the support of the same uneducated, depressed, and dissatisfied
elements of the population, and the fact is that in the summer of 1917, the
Anarchist-Communists, with the support they enjoyed in a few important
factories and regiments, possessed an undeniable capacity to influence the
course of events. Indeed, the Anarchist appeal was great enough in some
factories and military units to influence the actions of the Bolsheviks
themselves."_ [**Op. Cit.**, p. 64]

Indeed, one leading Bolshevik stated in June, 1917 (in response to a rise in
anarchist influence), _"[b]y fencing ourselves off from the Anarchists, we may
fence ourselves off from the masses."_ [quoted by Alexander Rabinowitch, **Op.
Cit.**, p. 102]

The anarchists operated with the Bolsheviks during the October Revolution
which overthrew the provisional government. But things changed once the
authoritarian socialists of the Bolshevik party had seized power. While both
anarchists and Bolsheviks used many of the same slogans, there were important
differences between the two. As Voline argued, _"[f]rom the lips and pens of
the Anarchists, those slogans were sincere and concrete, for they corresponded
to their principles and called for action entirely in conformity with such
principles. But with the Bolsheviks, the same slogans meant practical
solutions totally different from those of the libertarians and did not tally
with the ideas which the slogans appeared to express."_ [**The Unknown
Revolution**, p. 210]

Take, for example, the slogan _"All power to the Soviets."_ For anarchists it
meant exactly that -- organs for the working class to run society directly,
based on mandated, recallable delegates. For the Bolsheviks, that slogan was
simply the means for a Bolshevik government to be formed over and above the
soviets. The difference is important, _"for the Anarchists declared, if
'power' really should belong to the soviets, it could not belong to the
Bolshevik party, and if it should belong to that Party, as the Bolsheviks
envisaged, it could not belong to the soviets."_ [Voline, **Op. Cit.**, p.
213] Reducing the soviets to simply executing the decrees of the central
(Bolshevik) government and having their All-Russian Congress be able to recall
the government (i.e. those with **real** power) does not equal "all power,"
quite the reverse.

Similarly with the term _"workers' control of production."_ Before the October
Revolution Lenin saw _"workers' control"_ purely in terms of the _"universal,
all-embracing workers' control over the capitalists."_ [**Will the Bolsheviks
Maintain Power?**, p. 52] He did not see it in terms of workers' management of
production itself (i.e. the abolition of wage labour) via federations of
factory committees. Anarchists and the workers' factory committees did. As
S.A. Smith correctly notes, Lenin used _"the term ['workers' control'] in a
very different sense from that of the factory committees."_ In fact Lenin's
_"proposals . . . [were] thoroughly statist and centralist in character,
whereas the practice of the factory committees was essentially local and
autonomous."_ [**Red Petrograd**, p. 154] For anarchists, _"if the workers'
organisations were capable of exercising effective control [over their
bosses], then they also were capable of guaranteeing all production. In such
an event, private industry could be eliminated quickly but progressively, and
replaced by collective industry. Consequently, the Anarchists rejected the
vague nebulous slogan of 'control of production.' They advocated
**expropriation -- progressive, but immediate -- of private industry by the
organisations of collective production.**"_ [Voline, **Op. Cit.**, p. 221]

Once in power, the Bolsheviks systematically undermined the popular meaning of
workers' control and replaced it with their own, statist conception. _"On
three occasions,"_ one historian notes, _"in the first months of Soviet power,
the [factory] committee leaders sought to bring their model into being. At
each point the party leadership overruled them. The result was to vest both
managerial **and** control powers in organs of the state which were
subordinate to the central authorities, and formed by them."_ [Thomas F.
Remington, **Building Socialism in Bolshevik Russia**, p. 38] This process
ultimately resulted in Lenin arguing for, and introducing, _"one-man
management"_ armed with _"dictatorial"_ power (with the manager appointed from
above by the state) in April 1918. This process is documented in Maurice
Brinton's **The Bolsheviks and Workers' Control**, which also indicates the
clear links between Bolshevik practice and Bolshevik ideology as well as how
both differed from popular activity and ideas.

Hence the comments by Russian Anarchist Peter Arshinov:

> _ "Another no less important peculiarity is that [the] October [revolution
of 1917] has two meanings -- that which the working' masses who participated
in the social revolution gave it, and with them the Anarchist-Communists, and
that which was given it by the political party [the Marxist-Communists] that
captured power from this aspiration to social revolution, and which betrayed
and stifled all further development. An enormous gulf exists between these two
interpretations of October. The October of the workers and peasants is the
suppression of the power of the parasite classes in the name of equality and
self-management. The Bolshevik October is the conquest of power by the party
of the revolutionary intelligentsia, the installation of its 'State Socialism'
and of its 'socialist' methods of governing the masses."_ [**The Two
Octobers**]

Initially, anarchists had supported the Bolsheviks, since the Bolshevik
leaders had hidden their state-building ideology behind support for the
soviets (as socialist historian Samuel Farber notes, the anarchists _"had
actually been an unnamed coalition partner of the Bolsheviks in the October
Revolution."_ [**Before Stalinism**, p. 126]). However, this support quickly
"withered away" as the Bolsheviks showed that they were, in fact, not seeking
true socialism but were instead securing power for themselves and pushing not
for collective ownership of land and productive resources but for government
ownership. The Bolsheviks, as noted, systematically undermined the workers'
control/self-management movement in favour of capitalist-like forms of
workplace management based around _"one-man management"_ armed with
_"dictatorial powers."_

As regards the soviets, the Bolsheviks systematically undermining what limited
independence and democracy they had. In response to the _"great Bolshevik
losses in the soviet elections"_ during the spring and summer of 1918
_"Bolshevik armed force usually overthrew the results of these provincial
elections."_ Also, the _"government continually postponed the new general
elections to the Petrograd Soviet, the term of which had ended in March 1918.
Apparently, the government feared that the opposition parties would show
gains."_ [Samuel Farber, **Op. Cit.**, p. 24 and p. 22] In the Petrograd
elections, the Bolsheviks _"lost the absolute majority in the soviet they had
previously enjoyed"_ but remained the largest party. However, the results of
the Petrograd soviet elections were irrelevant as a _"Bolshevik victory was
assured by the numerically quite significant representation now given to trade
unions, district soviets, factory-shop committees, district workers
conferences, and Red Army and naval units, in which the Bolsheviks had
overwhelming strength."_ [Alexander Rabinowitch, _"The Evolution of Local
Soviets in Petrograd"_, pp. 20-37, **Slavic Review**, Vol. 36, No. 1, p. 36f]
In other words, the Bolsheviks had undermined the democratic nature of the
soviet by swamping it by their own delegates. Faced with rejection in the
soviets, the Bolsheviks showed that for them "soviet power" equalled party
power. To stay in power, the Bolsheviks had to destroy the soviets, which they
did. The soviet system remained "soviet" in name only. Indeed, from 1919
onwards Lenin, Trotsky and other leading Bolsheviks were admitting that they
had created a party dictatorship and, moreover, that such a dictatorship was
essential for any revolution (Trotsky supported party dictatorship even after
the rise of Stalinism).

The Red Army, moreover, no longer was a democratic organisation. In March of
1918 Trotsky had abolished the election of officers and soldier committees:

> _ "the principle of election is politically purposeless and technically
inexpedient, and it has been, in practice, abolished by decree."_ [**Work,
Discipline, Order**]

As Maurice Brinton correctly summarises:

> _ "Trotsky, appointed Commissar of Military Affairs after Brest-Litovsk, had
rapidly been reorganising the Red Army. The death penalty for disobedience
under fire had been restored. So, more gradually, had saluting, special forms
of address, separate living quarters and other privileges for officers.
Democratic forms of organisation, including the election of officers, had been
quickly dispensed with."_ [_"The Bolsheviks and Workers' Control"_, **For
Workers' Power**, pp. 336-7]

Unsurprisingly, Samuel Farber notes that _"there is no evidence indicating
that Lenin or any of the mainstream Bolshevik leaders lamented the loss of
workers' control or of democracy in the soviets, or at least referred to these
losses as a retreat, as Lenin declared with the replacement of War Communism
by NEP in 1921."_ [**Before Stalinism**, p. 44]

Thus after the October Revolution, anarchists started to denounce the
Bolshevik regime and call for a **_"Third Revolution"_** which would finally
free the masses from all bosses (capitalist or socialist). They exposed the
fundamental difference between the rhetoric of Bolshevism (as expressed, for
example, in Lenin's **State and Revolution**) with its reality. Bolshevism in
power had proved Bakunin's prediction that the _"dictatorship of the
proletariat"_ would become the _"dictatorship **over** the proletariat"_ by
the leaders of the Communist Party.

The influence of the anarchists started to grow. As Jacques Sadoul (a French
officer) noted in early 1918:

> _ "The anarchist party is the most active, the most militant of the
opposition groups and probably the most popular . . . The Bolsheviks are
anxious."_ [quoted by Daniel Guerin, **Anarchism**, pp. 95-6]

By April 1918, the Bolsheviks began the physical suppression of their
anarchist rivals. On April 12th, 1918, the Cheka (the secret police formed by
Lenin in December, 1917) attacked anarchist centres in Moscow. Those in other
cities were attacked soon after. As well as repressing their most vocal
opponents on the left, the Bolsheviks were restricting the freedom of the
masses they claimed to be protecting. Democratic soviets, free speech,
opposition political parties and groups, self-management in the workplace and
on the land -- all were destroyed in the name of "socialism." All this
happened, we must stress, **before** the start of the Civil War in late May,
1918, which most supporters of Leninism blame for the Bolsheviks'
authoritarianism. During the civil war, this process accelerated, with the
Bolsheviks' systematically repressing opposition from all quarters --
including the strikes and protests of the very class who they claimed was
exercising its "dictatorship" while they were in power!

It is important to stress that this process had started well **before** the
start of the civil war, confirming anarchist theory that a "workers' state" is
a contraction in terms. For anarchists, the Bolshevik substitution of party
power for workers power (and the conflict between the two) did not come as a
surprise. The state is the delegation of **power** \-- as such, it means that
the idea of a "workers' state" expressing "workers' power" is a logical
impossibility. If workers **are** running society then power rests in their
hands. If a state exists then power rests in the hands of the handful of
people at the top, **not** in the hands of all. The state was designed for
minority rule. No state can be an organ of working class (i.e. majority) self-
management due to its basic nature, structure and design. For this reason
anarchists have argued for a bottom-up federation of workers' councils as the
agent of revolution and the means of managing society after capitalism and the
state have been abolished.

As we discuss in [section H](secHcon.html), the degeneration of the Bolsheviks
from a popular working class party into dictators over the working class did
not occur by accident. A combination of political ideas and the realities of
state power (and the social relationships it generates) could not help but
result in such a degeneration. The political ideas of Bolshevism, with its
vanguardism, fear of spontaneity and identification of party power with
working class power inevitably meant that the party would clash with those
whom it claimed to represent. After all, if the party is the vanguard then,
automatically, everyone else is a "backward" element. This meant that if the
working class resisted Bolshevik policies or rejected them in soviet
elections, then the working class was "wavering" and being influenced by
"petty-bourgeois" and "backward" elements. Vanguardism breeds elitism and,
when combined with state power, dictatorship.

State power, as anarchists have always stressed, means the delegation of power
into the hands of a few. This automatically produces a class division in
society -- those with power and those without. As such, once in power the
Bolsheviks were isolated from the working class. The Russian Revolution
confirmed Malatesta's argument that a _"government, that is a group of people
entrusted with making laws and empowered to use the collective power to oblige
each individual to obey them, is already a privileged class and cut off from
the people. As any constituted body would do, it will instinctively seek to
extend its powers, to be beyond public control, to impose its own policies and
to give priority to its special interests. Having been put in a privileged
position, the government is already at odds with the people whose strength it
disposes of."_ [**Anarchy**, p. 34] A highly centralised state such as the
Bolsheviks built would reduce accountability to a minimum while at the same
time accelerating the isolation of the rulers from the ruled. The masses were
no longer a source of inspiration and power, but rather an alien group whose
lack of "discipline" (i.e. ability to follow orders) placed the revolution in
danger. As one Russian Anarchist argued:

> _ "The proletariat is being gradually enserfed by the state. The people are
being transformed into servants over whom there has arisen a new class of
administrators -- a new class born mainly form the womb of the so-called
intelligentsia . . . We do not mean to say . . . that the Bolshevik party set
out to create a new class system. But we do say that even the best intentions
and aspirations must inevitably be smashed against the evils inherent in any
system of centralised power. The separation of management from labour, the
division between administrators and workers flows logically from
centralisation. It cannot be otherwise."_ [**The Anarchists in the Russian
Revolution**, pp. 123-4]

For this reason anarchists, while agreeing that there is an uneven development
of political ideas within the working class, reject the idea that
"revolutionaries" should take power on behalf of working people. Only when
working people actually run society themselves will a revolution be
successful. For anarchists, this meant that _"[e]ffective emancipation can be
achieved only by the **direct, widespread, and independent action . . . of the
workers themselves,** grouped . . . in their own class organisations . . . on
the basis of concrete action and self-government, **helped but not governed,**
by revolutionaries working in the very midst of, and not above the mass and
the professional, technical, defence and other branches."_ [Voline, **Op.
Cit.**, p. 197] By substituting party power for workers power, the Russian
Revolution had made its first fatal step. Little wonder that the following
prediction (from November 1917) made by anarchists in Russia came true:

> _ "Once their power is consolidated and 'legalised', the Bolsheviks who are
. . . men of centralist and authoritarian action will begin to rearrange the
life of the country and of the people by governmental and dictatorial methods,
imposed by the centre. The[y] . . . will dictate the will of the party to all
Russia, and command the whole nation. **Your Soviets and your other local
organisations will become little by little, simply executive organs of the
will of the central government.** In the place of healthy, constructive work
by the labouring masses, in place of free unification from the bottom, we will
see the installation of an authoritarian and statist apparatus which would act
from above and set about wiping out everything that stood in its way with an
iron hand."_ [quoted by Voline, **Op. Cit.**, p. 235]

The so-called "workers' state" could not be participatory or empowering for
working class people (as the Marxists claimed) simply because state structures
are not designed for that. Created as instruments of minority rule, they
cannot be transformed into (nor "new" ones created which are) a means of
liberation for the working classes. As Kropotkin put it, Anarchists _"maintain
that the State organisation, having been the force to which minorities
resorted for establishing and organising their power over the masses, cannot
be the force which will serve to destroy these privileges."_ [**Anarchism**,
p. 170] In the words of an anarchist pamphlet written in 1918:

> _ "Bolshevism, day by day and step by step, proves that state power
possesses inalienable characteristics; it can change its label, its 'theory',
and its servitors, but in essence it merely remains power and despotism in new
forms."_ [quoted by Paul Avrich, _"The Anarchists in the Russian Revolution,"_
pp. 341-350, **Russian Review**, vol. 26, issue no. 4, p. 347]

For insiders, the Revolution had died a few months after the Bolsheviks took
over. To the outside world, the Bolsheviks and the USSR came to represent
"socialism" even as they systematically destroyed the basis of real socialism.
By transforming the soviets into state bodies, substituting party power for
soviet power, undermining the factory committees, eliminating democracy in the
armed forces and workplaces, repressing the political opposition and workers'
protests, the Bolsheviks effectively marginalised the working class from its
own revolution. Bolshevik ideology and practice were themselves important and
sometimes decisive factors in the degeneration of the revolution and the
ultimate rise of Stalinism.

As anarchists had predicted for decades previously, in the space of a few
months, and before the start of the Civil War, the Bolshevik's "workers'
state" had become, like any state, an alien power **over** the working class
and an instrument of minority rule (in this case, the rule of the party). The
Civil War accelerated this process and soon party dictatorship was introduced
(indeed, leading Bolsheviks began arguing that it was essential in any
revolution). The Bolsheviks put down the libertarian socialist elements within
their country, with the crushing of the uprising at Kronstadt and the
Makhnovist movement in the Ukraine being the final nails in the coffin of
socialism and the subjugation of the soviets.

The Kronstadt uprising of February, 1921, was, for anarchists, of immense
importance (see the appendix ["What was the Kronstadt
Rebellion?"](append42.html) for a full discussion of this uprising). The
uprising started when the sailors of Kronstadt supported the striking workers
of Petrograd in February, 1921. They raised a 15 point resolution, the first
point of which was a call for soviet democracy. The Bolsheviks slandered the
Kronstadt rebels as counter-revolutionaries and crushed the revolt. For
anarchists, this was significant as the repression could not be justified in
terms of the Civil War (which had ended months before) and because it was a
major uprising of ordinary people for **_real_** socialism. As Voline puts it:

> _ "Kronstadt was the first entirely independent attempt of the people to
liberate themselves of all yokes and carry out the Social Revolution: this
attempt was made directly . . . by the working masses themselves, without
political shepherds, without leaders or tutors. It was the first step towards
the third and social revolution."_ [Voline, **Op. Cit.**, pp. 537-8]

In the Ukraine, anarchist ideas were most successfully applied. In areas under
the protection of the Makhnovist movement, working class people organised
their own lives directly, based on their own ideas and needs -- true social
self-determination. Under the leadership of Nestor Makhno, a self-educated
peasant, the movement not only fought against both Red and White dictatorships
but also resisted the Ukrainian nationalists. In opposition to the call for
"national self-determination," i.e. a new Ukrainian state, Makhno called
instead for working class self-determination in the Ukraine and across the
world. Makhno inspired his fellow peasants and workers to fight for real
freedom:

> _ "Conquer or die -- such is the dilemma that faces the Ukrainian peasants
and workers at this historic moment . . . But we will not conquer in order to
repeat the errors of the past years, the error of putting our fate into the
hands of new masters; we will conquer in order to take our destinies into our
own hands, to conduct our lives according to our own will and our own
conception of the truth."_ [quoted by Peter Arshinov, **History of the
Makhnovist Movement**, p. 58]

To ensure this end, the Makhnovists refused to set up governments in the towns
and cities they liberated, instead urging the creation of free soviets so that
the working people could govern themselves. Taking the example of
Aleksandrovsk, once they had liberated the city the Makhnovists _"immediately
invited the working population to participate in a general conference . . . it
was proposed that the workers organise the life of the city and the
functioning of the factories with their own forces and their own organisations
. . . The first conference was followed by a second. The problems of
organising life according to principles of self-management by workers were
examined and discussed with animation by the masses of workers, who all
welcomed this ideas with the greatest enthusiasm . . . Railroad workers took
the first step . . . They formed a committee charged with organising the
railway network of the region . . . From this point, the proletariat of
Aleksandrovsk began to turn systematically to the problem of creating organs
of self-management."_ [**Op. Cit.**, p. 149]

The Makhnovists argued that the _"freedom of the workers and peasants is their
own, and not subject to any restriction. It is up to the workers and peasants
themselves to act, to organise themselves, to agree among themselves in all
aspects of their lives, as they see fit and desire . . . The Makhnovists can
do no more than give aid and counsel . . . In no circumstances can they, nor
do they wish to, govern."_ [Peter Arshinov, quoted by Guerin, **Op. Cit.**, p.
99] In Alexandrovsk, the Bolsheviks proposed to the Makhnovists spheres of
action - their Revkom (Revolutionary Committee) would handle political affairs
and the Makhnovists military ones. Makhno advised them _"to go and take up
some honest trade instead of seeking to impose their will on the workers."_
[Peter Arshinov in **The Anarchist Reader**, p. 141]

They also organised free agricultural communes which _"[a]dmittedly . . . were
not numerous, and included only a minority of the population . . . But what
was most precious was that these communes were formed by the poor peasants
themselves. The Makhnovists never exerted any pressure on the peasants,
confining themselves to propagating the idea of free communes."_ [Arshinov,
**History of the Makhnovist Movement**, p. 87] Makhno played an important role
in abolishing the holdings of the landed gentry. The local soviet and their
district and regional congresses equalised the use of the land between all
sections of the peasant community. [**Op. Cit.**, pp. 53-4]

Moreover, the Makhnovists took the time and energy to involve the whole
population in discussing the development of the revolution, the activities of
the army and social policy. They organised numerous conferences of workers',
soldiers' and peasants' delegates to discuss political and social issues as
well as free soviets, unions and communes. They organised a regional congress
of peasants and workers when they had liberated Aleksandrovsk. When the
Makhnovists tried to convene the third regional congress of peasants, workers
and insurgents in April 1919 and an extraordinary congress of several regions
in June 1919 the Bolsheviks viewed them as counter-revolutionary, tried to ban
them and declared their organisers and delegates outside the law.

The Makhnovists replied by holding the conferences anyway and asking _"[c]an
there exist laws made by a few people who call themselves revolutionaries,
which permit them to outlaw a whole people who are more revolutionary than
they are themselves?"_ and _"[w]hose interests should the revolution defend:
those of the Party or those of the people who set the revolution in motion
with their blood?"_ Makhno himself stated that he _"consider[ed] it an
inviolable right of the workers and peasants, a right won by the revolution,
to call conferences on their own account, to discuss their affairs."_ [**Op.
Cit.**, p. 103 and p. 129]

In addition, the Makhnovists _"fully applied the revolutionary principles of
freedom of speech, of thought, of the press, and of political association. In
all cities and towns occupied by the Makhnovists, they began by lifting all
the prohibitions and repealing all the restrictions imposed on the press and
on political organisations by one or another power."_ Indeed, the _"only
restriction that the Makhnovists considered necessary to impose on the
Bolsheviks, the left Socialist-Revolutionaries and other statists was a
prohibition on the formation of those 'revolutionary committees' which sought
to impose a dictatorship over the people."_ [**Op. Cit.**, p. 153 and p. 154]

The Makhnovists rejected the Bolshevik corruption of the soviets and instead
proposed _"the free and completely independent soviet system of working people
without authorities and their arbitrary laws."_ Their proclamations stated
that the _"working people themselves must freely choose their own soviets,
which carry out the will and desires of the working people themselves, that is
to say. ADMINISTRATIVE, not ruling soviets."_ Economically, capitalism would
be abolished along with the state - the land and workshops _"must belong to
the working people themselves, to those who work in them, that is to say, they
must be socialised."_ [**Op. Cit.**, p. 271 and p. 273]

The army itself, in stark contrast to the Red Army, was fundamentally
democratic (although, of course, the horrific nature of the civil war did
result in a few deviations from the ideal -- however, compared to the regime
imposed on the Red Army by Trotsky, the Makhnovists were much more democratic
movement).

The anarchist experiment of self-management in the Ukraine came to a bloody
end when the Bolsheviks turned on the Makhnovists (their former allies against
the "Whites," or pro-Tsarists) when they were no longer needed. This important
movement is fully discussed in the appendix ["Why does the Makhnovist movement
show there is an alternative to Bolshevism?"](append46.html) of our FAQ.
However, we must stress here the one obvious lesson of the Makhnovist
movement, namely that the dictatorial policies pursued by the Bolsheviks were
not imposed on them by objective circumstances. Rather, the political ideas of
Bolshevism had a clear influence in the decisions they made. After all, the
Makhnovists were active in the same Civil War and yet did not pursue the same
policies of party power as the Bolsheviks did. Rather, they successfully
encouraged working class freedom, democracy and power in extremely difficult
circumstances (and in the face of strong Bolshevik opposition to those
policies). The received wisdom on the left is that there was no alternative
open to the Bolsheviks. The experience of the Makhnovists disproves this. What
the masses of people, as well as those in power, do and think politically is
as much part of the process determining the outcome of history as are the
objective obstacles that limit the choices available. Clearly, ideas do matter
and, as such, the Makhnovists show that there was (and is) a practical
alternative to Bolshevism -- anarchism.

The last anarchist march in Moscow until 1987 took place at the funeral of
Kropotkin in 1921, when over 10,000 marched behind his coffin. They carried
black banners declaring _"Where there is authority, there is no freedom"_ and
_"The Liberation of the working class is the task of the workers themselves."_
As the procession passed the Butyrki prison, the inmates sang anarchist songs
and shook the bars of their cells.

Anarchist opposition within Russia to the Bolshevik regime started in 1918.
They were the first left-wing group to be repressed by the new "revolutionary"
regime. Outside of Russia, anarchists continued to support the Bolsheviks
until news came from anarchist sources about the repressive nature of the
Bolshevik regime (until then, many had discounted negative reports as being
from pro-capitalist sources). Once these reliable reports came in, anarchists
across the globe rejected Bolshevism and its system of party power and
repression. The experience of Bolshevism confirmed Bakunin's prediction that
Marxism meant _"the highly despotic government of the masses by a new and very
small aristocracy of real or pretended scholars. The people are not learned,
so they will be liberated from the cares of government and included in
entirety in the governed herd."_ [**Statism and Anarchy**, pp. 178-9]

From about 1921 on, anarchists outside of Russia started describing the USSR
as _"state-capitalist"_ to indicate that although individual bosses might have
been eliminated, the Soviet state bureaucracy played the same role as
individual bosses do in the West (anarchists **within** Russia had been
calling it that since 1918). For anarchists, _"the Russian revolution . . . is
trying to reach . . . economic equality . . . this effort has been made in
Russia under a strongly centralised party dictatorship . . . this effort to
build a communist republic on the basis of a strongly centralised state
communism under the iron law of a party dictatorship is bound to end in
failure. We are learning to know in Russia how **not** to introduce
communism."_ [**Anarchism**, p. 254]

This meant exposing that Berkman called **"The Bolshevik Myth,"** the idea
that the Russian Revolution was a success and should be copied by
revolutionaries in other countries: _"It is imperative to unmask the great
delusion, which otherwise might lead the Western workers to the same abyss as
their brothers [and sisters] in Russia. It is incumbent upon those who have
seen through the myth to expose its true nature."_ [_"The Anti-Climax'"_,
**The Bolshevik Myth**, p. 342] Moreover, anarchists felt that it was their
revolutionary duty not only present and learn from the facts of the revolution
but also show solidarity with those subject to Bolshevik dictatorship. As Emma
Goldman argued, she had not _"come to Russia expecting to find Anarchism
realised."_ Such idealism was alien to her (although that has not stopped
Leninists saying the opposite). Rather, she expected to see _"the beginnings
of the social changes for which the Revolution had been fought."_ She was
aware that revolutions were difficult, involving _"destruction"_ and
_"violence."_ That Russia was not perfect was not the source of her vocal
opposition to Bolshevism. Rather, it was the fact that _"the Russian people
have been **locked out**"_ of their own revolution by the Bolshevik state
which used _"the sword and the gun to keep the people out."_ As a
revolutionary she refused _"to side with the master class, which in Russia is
called the Communist Party."_ [**My Disillusionment in Russia**, p. xlvii and
p. xliv]

For more information on the Russian Revolution and the role played by
anarchists, see the appendix on [ "The Russian Revolution"](append4.html) of
the FAQ. As well as covering the Kronstadt uprising and the Makhnovists, it
discusses why the revolution failed, the role of Bolshevik ideology played in
that failure and whether there were any alternatives to Bolshevism.

The following books are also recommended: **The Unknown Revolution** by
Voline; **The Guillotine at Work** by G.P. Maximov; **The Bolshevik Myth** and
**The Russian Tragedy**, both by Alexander Berkman; **The Bolsheviks and
Workers Control** by M. Brinton; **The Kronstadt Uprising** by Ida Mett; **The
History of the Makhnovist Movement** by Peter Arshinov; **My Disillusionment
in Russia** and **Living My Life** by Emma Goldman; **Nestor Makhno Anarchy's
Cossack: The struggle for free soviets in the Ukraine 1917-1921** by Alexandre
Skirda.

Many of these books were written by anarchists active during the revolution,
many imprisoned by the Bolsheviks and deported to the West due to
international pressure exerted by anarcho-syndicalist delegates to Moscow who
the Bolsheviks were trying to win over to Leninism. The majority of such
delegates stayed true to their libertarian politics and convinced their unions
to reject Bolshevism and break with Moscow. By the early 1920's all the
anarcho-syndicalist union confederations had joined with the anarchists in
rejecting the "socialism" in Russia as state capitalism and party
dictatorship.

## A.5.5 Anarchists in the Italian Factory Occupations

After the end of the First World War there was a massive radicalisation across
Europe and the world. Union membership exploded, with strikes, demonstrations
and agitation reaching massive levels. This was partly due to the war, partly
to the apparent success of the Russian Revolution. This enthusiasm for the
Russian Revolution even reached Individualist Anarchists like Joseph Labadie,
who like many other anti-capitalists, saw _"the red in the east [giving] hope
of a brighter day"_ and the Bolsheviks as making _"laudable efforts to at
least try some way out of the hell of industrial slavery."_ [quoted by
Carlotta R. Anderson, **All-American Anarchist** p. 225 and p. 241]

Across Europe, anarchist ideas became more popular and anarcho-syndicalist
unions grew in size. For example, in Britain, the ferment produced the shop
stewards' movement and the strikes on Clydeside; Germany saw the rise of IWW
inspired industrial unionism and a libertarian form of Marxism called "Council
Communism"; Spain saw a massive growth in the anarcho-syndicalist CNT. In
addition, it also, unfortunately, saw the rise and growth of both social
democratic and communist parties. Italy was no exception.

In Turin, a new rank-and-file movement was developing. This movement was based
around the _"internal commissions"_ (elected ad hoc grievance committees).
These new organisations were based directly on the group of people who worked
together in a particular work shop, with a mandated and recallable shop
steward elected for each group of 15 to 20 or so workers. The assembly of all
the shop stewards in a given plant then elected the "internal commission" for
that facility, which was directly and constantly responsible to the body of
shop stewards, which was called the _"factory council."_

Between November 1918 and March 1919, the internal commissions had become a
national issue within the trade union movement. On February 20, 1919, the
Italian Federation of Metal Workers (FIOM) won a contract providing for the
election of "internal commissions" in the factories. The workers subsequently
tried to transform these organs of workers' representation into factory
councils with a managerial function. By May Day 1919, the internal commissions
_"were becoming the dominant force within the metalworking industry and the
unions were in danger of becoming marginal administrative units. Behind these
alarming developments, in the eyes of reformists, lay the libertarians."_
[Carl Levy, **Gramsci and the Anarchists**, p. 135] By November 1919 the
internal commissions of Turin were transformed into factory councils.

The movement in Turin is usually associated with the weekly **L'Ordine Nuovo**
(The New Order), which first appeared on May 1, 1919. As Daniel Guerin
summarises, it was _"edited by a left socialist, Antonio Gramsci, assisted by
a professor of philosophy at Turin University with anarchist ideas, writing
under the pseudonym of Carlo Petri, and also of a whole nucleus of Turin
libertarians. In the factories, the Ordine Nuovo group was supported by a
number of people, especially the anarcho-syndicalist militants of the metal
trades, Pietro Ferrero and Maurizio Garino. The manifesto of **Ordine Nuovo**
was signed by socialists and libertarians together, agreeing to regard the
factory councils as 'organs suited to future communist management of both the
individual factory and the whole society.'"_ [**Anarchism**, p. 109]

The developments in Turin should not be taken in isolation. All across Italy,
workers and peasants were taking action. In late February 1920, a rash of
factory occupations broke out in Liguria, Piedmont and Naples. In Liguria, the
workers occupied the metal and shipbuilding plants in Sestri Ponente,
Cornigliano and Campi after a breakdown of pay talks. For up to four days,
under syndicalist leadership, they ran the plants through factory councils.

During this period the Italian Syndicalist Union (USI) grew in size to around
800 000 members and the influence of the Italian Anarchist Union (UAI) with
its 20 000 members and daily paper (**Umanita Nova**) grew correspondingly. As
the Welsh Marxist historian Gwyn A. Williams points out _"Anarchists and
revolutionary syndicalists were the most consistently and totally
revolutionary group on the left . . . the most obvious feature of the history
of syndicalism and anarchism in 1919-20: rapid and virtually continuous growth
. . . The syndicalists above all captured militant working-class opinion which
the socialist movement was utterly failing to capture."_ [**Proletarian
Order**, pp. 194-195] In Turin, libertarians _"worked within FIOM"_ and had
been _"heavily involved in the **Ordine Nuovo** campaign from the beginning."_
[**Op. Cit.**, p. 195] Unsurprisingly, **Ordone Nuovo** was denounced as
"syndicalist" by other socialists.

It was the anarchists and syndicalists who first raised the idea of occupying
workplaces. Malatesta was discussing this idea in **Umanita Nova** in March,
1920. In his words, _"General strikes of protest no longer upset anyone . . .
One must seek something else. We put forward an idea: take-over of factories.
. . the method certainly has a future, because it corresponds to the ultimate
ends of the workers' movement and constitutes an exercise preparing one for
the ultimate act of expropriation."_ [**Errico Malatesta: His Life and
Ideas**, p. 134] In the same month, during _"a strong syndicalist campaign to
establish councils in Mila, Armando Borghi [anarchist secretary of the USI]
called for mass factory occupations. In Turin, the re-election of workshop
commissars was just ending in a two-week orgy of passionate discussion and
workers caught the fever. [Factory Council] Commissars began to call for
occupations."_ Indeed, _"the council movement outside Turin was essentially
anarcho-syndicalist."_ Unsurprisingly, the secretary of the syndicalist metal-
workers _"urged support for the Turin councils because they represented anti-
bureaucratic direct action, aimed at control of the factory and could be the
first cells of syndicalist industrial unions . . . The syndicalist congress
voted to support the councils. . . . Malatesta . . . supported them as a form
of direct action guaranteed to generate rebelliousness . . . **Umanita Nova**
and **Guerra di Classe** [paper of the USI] became almost as committed to the
councils as **L'Ordine Nuovo** and the Turin edition of **Avanti.**"_
[Williams, **Op. Cit.**, p. 200, p. 193 and p. 196]

The upsurge in militancy soon provoked an employer counter-offensive. The
bosses organisation denounced the factory councils and called for a
mobilisation against them. Workers were rebelling and refusing to follow the
bosses orders -- "indiscipline" was rising in the factories. They won state
support for the enforcement of the existing industrial regulations. The
national contract won by the FIOM in 1919 had provided that the internal
commissions were banned from the shop floor and restricted to non-working
hours. This meant that the activities of the shop stewards' movement in Turin
-- such as stopping work to hold shop steward elections -- were in violation
of the contract. The movement was essentially being maintained through mass
insubordination. The bosses used this infringement of the agreed contract as
the means combating the factory councils in Turin.

The showdown with the employers arrived in April, when a general assembly of
shop stewards at Fiat called for sit-in strikes to protest the dismissal of
several shop stewards. In response the employers declared a general lockout.
The government supported the lockout with a mass show of force and troops
occupied the factories and mounted machine guns posts at them. When the shop
stewards movement decided to surrender on the immediate issues in dispute
after two weeks on strike, the employers responded with demands that the shop
stewards councils be limited to non-working hours, in accordance with the FIOM
national contract, and that managerial control be re-imposed.

These demands were aimed at the heart of the factory council system and Turin
labour movement responded with a massive general strike in defence of it. In
Turin, the strike was total and it soon spread throughout the region of
Piedmont and involved 500 000 workers at its height. The Turin strikers called
for the strike to be extended nationally and, being mostly led by socialists,
they turned to the CGL trade union and Socialist Party leaders, who rejected
their call.

The only support for the Turin general strike came from unions that were
mainly under anarcho-syndicalist influence, such as the independent railway
and the maritime workers unions (_"The syndicalists were the only ones to
move."_). The railway workers in Pisa and Florence refused to transport troops
who were being sent to Turin. There were strikes all around Genoa, among dock
workers and in workplaces where the USI was a major influence. So in spite of
being _"betrayed and abandoned by the whole socialist movement,"_ the April
movement _"still found popular support"_ with _"actions . . . either directly
led or indirectly inspired by anarcho-syndicalists."_ In Turin itself, the
anarchists and syndicalists were _"threatening to cut the council movement out
from under"_ Gramsci and the **Ordine Nuovo** group. [Williams, **Op. Cit.**,
p. 207, p. 193 and p. 194]

Eventually the CGL leadership settled the strike on terms that accepted the
employers' main demand for limiting the shop stewards' councils to non-working
hours. Though the councils were now much reduced in activity and shop floor
presence, they would yet see a resurgence of their position during the
September factory occupations.

The anarchists _"accused the socialists of betrayal. They criticised what they
believed was a false sense of discipline that had bound socialists to their
own cowardly leadership. They contrasted the discipline that placed every
movement under the 'calculations, fears, mistakes and possible betrayals of
the leaders' to the other discipline of the workers of Sestri Ponente who
struck in solidarity with Turin, the discipline of the railway workers who
refused to transport security forces to Turin and the anarchists and members
of the Unione Sindacale who forgot considerations of party and sect to put
themselves at the disposition of the Torinesi."_ [Carl Levy, **Op. Cit.**, p.
161] Sadly, this top-down "discipline" of the socialists and their unions
would be repeated during the factory occupations, with terrible results.

In September, 1920, there were large-scale stay-in strikes in Italy in
response to an owner wage cut and lockout. _"Central to the climate of the
crisis was the rise of the syndicalists."_ In mid-August, the USI metal-
workers _"called for both unions to occupy the factories"_ and called for _"a
preventive occupation"_ against lock-outs. The USI saw this as the
_"expropriation of the factories by the metal-workers"_ (which must _"be
defended by all necessary measures"_) and saw the need _"to call the workers
of other industries into battle."_ [Williams, **Op. Cit.**, p. 236, pp. 238-9]
Indeed, _"[i]f the FIOM had not embraced the syndicalist idea of an occupation
of factories to counter an employer's lockout, the USI may well have won
significant support from the politically active working class of Turin."_
[Carl Levy, **Op. Cit.**, p. 129] These strikes began in the engineering
factories and soon spread to railways, road transport, and other industries,
with peasants seizing land. The strikers, however, did more than just occupy
their workplaces, they placed them under workers' self-management. Soon over
500 000 "strikers" were at work, producing for themselves. Errico Malatesta,
who took part in these events, writes:

> _ "The metal workers started the movement over wage rates. It was a strike
of a new kind. Instead of abandoning the factories, the idea was to remain
inside without working . . . Throughout Italy there was a revolutionary
fervour among the workers and soon the demands changed their characters.
Workers thought that the moment was ripe to take possession once [and] for all
the means of production. They armed for defence . . . and began to organise
production on their own . . . It was the right of property abolished in fact .
. .; it was a new regime, a new form of social life that was being ushered in.
And the government stood by because it felt impotent to offer opposition."_
[**Errico Malatesta: His Life and Ideas**, p. 134]

Daniel Guerin provides a good summary of the extent of the movement:

> _ "The management of the factories . . . [was] conducted by technical and
administrative workers' committees. Self-management went quite a long way: in
the early period assistance was obtained from the banks, but when it was
withdrawn the self-management system issued its own money to pay the workers'
wages. Very strict self-discipline was required, the use of alcoholic
beverages forbidden, and armed patrols were organised for self-defence. Very
close solidarity was established between the factories under self-management.
Ores and coal were put into a common pool, and shared out equitably."_
[**Anarchism**, p. 109]

Italy was _"paralysed, with half a million workers occupying their factories
and raising red and black flags over them."_ The movement spread throughout
Italy, not only in the industrial heartland around Milan, Turin and Genoa, but
also in Rome, Florence, Naples and Palermo. The _"militants of the USI were
certainly in the forefront of the movement,"_ while **Umanita Nova** argued
that _"the movement is very serious and we must do everything we can to
channel it towards a massive extension."_ The persistent call of the USI was
for _"an extension of the movement to the whole of industry to institute their
'expropriating general strike.'"_ [Williams, **Op. Cit.**, p. 236 and pp.
243-4] Railway workers, influenced by the libertarians, refused to transport
troops, workers went on strike against the orders of the reformist unions and
peasants occupied the land. The anarchists whole-heartedly supported the
movement, unsurprisingly as the _"occupation of the factories and the land
suited perfectly our programme of action."_ [Malatesta, **Op. Cit.**, p. 135]
Luigi Fabbri described the occupations as having _"revealed a power in the
proletariat of which it had been unaware hitherto."_ [quoted by Paolo Sprinao,
**The Occupation of the Factories**, p. 134]

However, after four weeks of occupation, the workers decided to leave the
factories. This was because of the actions of the socialist party and the
reformist trade unions. They opposed the movement and negotiated with the
state for a return to "normality" in exchange for a promise to extend workers'
control legally, in association with the bosses. The question of revolution
was decided by a vote of the CGL national council in Milan on April 10-11th,
without consulting the syndicalist unions, after the Socialist Party
leadership refused to decide one way or the other.

Needless to say, this promise of "workers' control" was not kept. The lack of
independent inter-factory organisation made workers dependent on trade union
bureaucrats for information on what was going on in other cities, and they
used that power to isolate factories, cities, and factories from each other.
This lead to a return to work, _"in spite of the opposition of individual
anarchists dispersed among the factories."_ [Malatesta, **Op. Cit.**, p. 136]
The local syndicalist union confederations could not provide the necessary
framework for a fully co-ordinated occupation movement as the reformist unions
refused to work with them; and although the anarchists were a large minority,
they were still a minority:

> _ "At the 'interproletarian' convention held on 12 September (in which the
Unione Anarchia, the railwaymen's and maritime workers union participated) the
syndicalist union decided that 'we cannot do it ourselves' without the
socialist party and the CGL, protested against the 'counter-revolutionary
vote' of Milan, declared it minoritarian, arbitrary and null, and ended by
launching new, vague, but ardent calls to action."_ [Paolo Spriano, **Op.
Cit.**, p. 94]

Malatesta addressed the workers of one of the factories at Milan. He argued
that _"[t]hose who celebrate the agreement signed at Rome [between the
Confederazione and the capitalists] as a great victory of yours are deceiving
you. The victory in reality belongs to Giolitti, to the government and the
bourgeoisie who are saved from the precipice over which they were hanging."_
During the occupation the _"bourgeoisie trembled, the government was powerless
to face the situation."_ Therefore:

> _ "To speak of victory when the Roman agreement throws you back under
bourgeois exploitation which you could have got rid of is a lie. If you give
up the factories, do this with the conviction [of] hav[ing] lost a great
battle and with the firm intention to resume the struggle on the first
occasion and to carry it on in a thorough way. . . Nothing is lost if you have
no illusion [about] the deceiving character of the victory. The famous decree
on the control of factories is a mockery . . . because it tends to harmonise
your interests and those of the bourgeois which is like harmonising the
interests of the wolf and the sheep. Don't believe those of your leaders who
make fools of you by adjourning the revolution from day to day. You yourselves
must make the revolution when an occasion will offer itself, without waiting
for orders which never come, or which come only to enjoin you to abandon
action. Have confidence in yourselves, have faith in your future and you will
win."_ [quoted by Max Nettlau, **Errico Malatesta: The Biography of an
Anarchist**]

Malatesta was proven correct. With the end of the occupations, the only
victors were the bourgeoisie and the government. Soon the workers would face
Fascism, but first, in October 1920, _"after the factories were evacuated,"_
the government (obviously knowing who the real threat was) _"arrested the
entire leadership of the USI and UAI. The socialists did not respond"_ and _
"more-or-less ignored the persecution of the libertarians until the spring of
1921 when the aged Malatesta and other imprisoned anarchists mounted a hunger
strike from their cells in Milan."_ [Carl Levy, **Op. Cit.**, pp. 221-2] They
were acquitted after a four day trial.

The events of 1920 show four things. Firstly, that workers can manage their
own workplaces successfully by themselves, without bosses. Secondly, on the
need for anarchists to be involved in the labour movement. Without the support
of the USI, the Turin movement would have been even more isolated than it was.
Thirdly, anarchists need to be organised to influence the class struggle. The
growth of the UAI and USI in terms of both influence and size indicates the
importance of this. Without the anarchists and syndicalists raising the idea
of factory occupations and supporting the movement, it is doubtful that it
would have been as successful and widespread as it was. Lastly, that socialist
organisations, structured in a hierarchical fashion, do not produce a
revolutionary membership. By continually looking to leaders, the movement was
crippled and could not develop to its full potential.

This period of Italian history explains the growth of Fascism in Italy. As
Tobias Abse points out, _"the rise of fascism in Italy cannot be detached from
the events of the **biennio rosso**, the two red years of 1919 and 1920, that
preceded it. Fascism was a preventive counter-revolution . . . launched as a
result of the failed revolution"_ [_"The Rise of Fascism in an Industrial
City"_, pp. 52-81, **Rethinking Italian Fascism**, David Forgacs (ed.), p. 54]
The term _"preventive counter-revolution"_ was originally coined by the
leading anarchist Luigi Fabbri, who correctly described fascism as _"the
organisation and agent of the violent armed defence of the ruling class
against the proletariat, which, to their mind, has become unduly demanding,
united and intrusive."_ [_"Fascism: The Preventive Counter-Revolution"_, pp.
408-416, **Anarchism**, Robert Graham (ed.), p. 410 and p. 409]

The rise of fascism confirmed Malatesta's warning at the time of the factory
occupations: _"If we do not carry on to the end, we will pay with tears of
blood for the fear we now instil in the bourgeoisie."_ [quoted by Tobias Abse,
**Op. Cit.**, p. 66] The capitalists and rich landowners backed the fascists
in order to teach the working class their place, aided by the state. They
ensured _"that it was given every assistance in terms of funding and arms,
turning a blind eye to its breaches of the law and, where necessary, covering
its back through intervention by armed forces which, on the pretext of
restoring order, would rush to the aid of the fascists wherever the latter
were beginning to take a beating instead of doling one out."_ [Fabbri, **Op.
Cit.**, p. 411] To quote Tobias Abse:

> _"The aims of the Fascists and their backers amongst the industrialists and
agrarians in 1921-22 were simple: to break the power of the organised workers
and peasants as completely as possible, to wipe out, with the bullet and the
club, not only the gains of the **biennio rosso**, but everything that the
lower classes had gained . . . between the turn of the century and the
outbreak of the First World War."_ [**Op. Cit.**, p. 54]

The fascist squads attacked and destroyed anarchist and socialist meeting
places, social centres, radical presses and Camera del Lavoro (local trade
union councils). However, even in the dark days of fascist terror, the
anarchists resisted the forces of totalitarianism. _"It is no coincidence that
the strongest working-class resistance to Fascism was in . . . towns or cities
in which there was quite a strong anarchist, syndicalist or anarcho-
syndicalist tradition."_ [Tobias Abse, **Op. Cit.**, p. 56]

The anarchists participated in, and often organised sections of, the **Arditi
del Popolo**, a working-class organisation devoted to the self-defence of
workers' interests. The Arditi del Popolo organised and encouraged working-
class resistance to fascist squads, often defeating larger fascist forces (for
example, _"the total humiliation of thousands of Italo Balbo's squadristi by a
couple of hundred Arditi del Popolo backed by the inhabitants of the working
class districts"_ in the anarchist stronghold of Parma in August 1922 [Tobias
Abse, **Op. Cit.**, p. 56]).

The Arditi del Popolo was the closest Italy got to the idea of a united,
revolutionary working-class front against fascism, as had been suggested by
Malatesta and the UAI. This movement _"developed along anti-bourgeois and
anti-fascist lines, and was marked by the independence of its local
sections."_ [**Red Years, Black Years: Anarchist Resistance to Fascism in
Italy**, p. 2] Rather than being just an "anti-fascist" organisation, the
Arditi _"were not a movement in defence of 'democracy' in the abstract, but an
essentially working-class organisation devoted to the defence of the interests
of industrial workers, the dockers and large numbers of artisans and
craftsmen."_ [Tobias Abse, **Op. Cit.**, p. 75] Unsurprisingly, the **Arditi
del Popolo** _"appear to have been strongest and most successful in areas
where traditional working-class political culture was less exclusively
socialist and had strong anarchist or syndicalist traditions, for example,
Bari, Livorno, Parma and Rome."_ [Antonio Sonnessa, _"Working Class Defence
Organisation, Anti-Fascist Resistance and the **Arditi del Popolo** in Turin,
1919-22,"_ pp. 183-218, **European History Quarterly**, vol. 33, no. 2, p.
184]

However, both the socialist and communist parties withdrew from the
organisation. The socialists signed a "Pact of Pacification" with the Fascists
in August 1921. The communists _"preferred to withdraw their members from the
Arditi del Popolo rather than let them work with the anarchists."_ [**Red
Years, Black Years**, p. 17] Indeed, _"[o]n the same day as the Pact was
signed, **Ordine Nuovo** published a PCd'I [Communist Party of Italy]
communication warning communists against involvement"_ in the Arditi del
Popolo. Four days later, the Communist leadership _"officially abandoned the
movement. Severe disciplinary measures were threatened against those
communists who continued to participate in, or liase with,"_ the organisation.
Thus by _"the end of the first week of August 1921 the PSI, CGL and the PCd'I
had officially denounced"_ the organisation. _"Only the anarchist leaders, if
not always sympathetic to the programme of the [Arditi del Popolo], did not
abandon the movement."_ Indeed, **Umanita Nova** _"strongly supported"_ it
_"on the grounds it represented a popular expression of anti-fascist
resistance and in defence of freedom to organise."_ [Antonio Sonnessa, **Op.
Cit.**, p. 195 and p. 194]

However, in spite of the decisions by their leaders, many rank and file
socialists and communists took part in the movement. The latter took part in
open _"defiance of the PCd'I leadership's growing abandonment"_ of it. In
Turin, for example, communists who took part in the **Arditi del Polopo** did
so _"less as communists and more as part of a wider, working-class self-
identification . . . This dynamic was re-enforced by an important socialist
and anarchist presence"_ there. The failure of the Communist leadership to
support the movement shows the bankruptcy of Bolshevik organisational forms
which were unresponsive to the needs of the popular movement. Indeed, these
events show the _"libertarian custom of autonomy from, and resistance to,
authority was also operated against the leaders of the workers' movement,
particularly when they were held to have misunderstood the situation at grass
roots level."_ [Sonnessa, **Op. Cit.**, p. 200, p. 198 and p. 193]

Thus the Communist Party failed to support the popular resistance to fascism.
The Communist leader Antonio Gramsci explained why, arguing that _"the party
leadership's attitude on the question of the Arditi del Popolo . . .
corresponded to a need to prevent the party members from being controlled by a
leadership that was not the party's leadership."_ Gramsci added that this
policy _"served to disqualify a mass movement which had started from below and
which could instead have been exploited by us politically."_ [**Selections
from Political Writings (1921-1926)**, p. 333] While being less sectarian
towards the Arditi del Popolo than other Communist leaders, _"[i]n common with
all communist leaders, Gramsci awaited the formation of the PCd'I-led military
squads."_ [Sonnessa, **Op. Cit.**, p. 196] In other words, the struggle
against fascism was seen by the Communist leadership as a means of gaining
more members and, when the opposite was a possibility, they preferred defeat
and fascism rather than risk their followers becoming influenced by anarchism.

As Abse notes, _"it was the withdrawal of support by the Socialist and
Communist parties at the national level that crippled"_ the Arditi. [**Op.
Cit.**, p. 74] Thus _"social reformist defeatism and communist sectarianism
made impossible an armed opposition that was widespread and therefore
effective; and the isolated instances of popular resistance were unable to
unite in a successful strategy."_ And fascism could have been defeated:
_"Insurrections at Sarzanna, in July 1921, and at Parma, in August 1922, are
examples of the correctness of the policies which the anarchists urged in
action and propaganda."_ [**Red Years, Black Years**, p. 3 and p. 2] Historian
Tobias Abse confirms this analysis, arguing that _"[w]hat happened in Parma in
August 1922 . . . could have happened elsewhere, if only the leadership of the
Socialist and Communist parties thrown their weight behind the call of the
anarchist Malatesta for a united revolutionary front against Fascism."_ [**Op.
Cit.**, p. 56]

In the end, fascist violence was successful and capitalist power maintained:

> _ "The anarchists' will and courage were not enough to counter the fascist
gangs, powerfully aided with material and arms, backed by the repressive
organs of the state. Anarchists and anarcho-syndicalists were decisive in some
areas and in some industries, but only a similar choice of direct action on
the parts of the Socialist Party and the General Confederation of Labour [the
reformist trade union] could have halted fascism."_ [**Red Years, Black
Years**, pp. 1-2]

After helping to defeat the revolution, the Marxists helped ensure the victory
of fascism.

Even after the fascist state was created, anarchists resisted both inside and
outside Italy. In America, for example, Italian anarchists played a major role
in fighting fascist influence in their communities, none more so that Carlo
Tresca, most famous for his role in the 1912 IWW Lawrence strike, who _"in the
1920s had no peer among anti-Fascist leaders, a distinction recognised by
Mussolini's political police in Rome."_ [Nunzio Pernicone, **Carlo Tresca:
Portrait of a Rebel**, p. 4] Many Italians, both anarchist and non-anarchist,
travelled to Spain to resist Franco in 1936 (see Umberto Marzochhi's
**Remembering Spain: Italian Anarchist Volunteers in the Spanish Civil War**
for details). During the Second World War, anarchists played a major part in
the Italian Partisan movement. It was the fact that the anti-fascist movement
was dominated by anti-capitalist elements that led the USA and the UK to place
known fascists in governmental positions in the places they "liberated" (often
where the town had already been taken by the Partisans, resulting in the
Allied troops "liberating" the town from its own inhabitants!).

Given this history of resisting fascism in Italy, it is surprising that some
claim Italian fascism was a product or form of syndicalism. This is even
claimed by some anarchists. According to Bob Black the _"Italian syndicalists
mostly went over to Fascism"_ and references David D. Roberts 1979 study **The
Syndicalist Tradition and Italian Fascism** to support his claim. [**Anarchy
after Leftism**, p. 64] Peter Sabatini in a review in **Social Anarchism**
makes a similar statement, saying that syndicalism's _"ultimate failure"_ was
_"its transformation into a vehicle of fascism."_ [**Social Anarchism**, no.
23, p. 99] What is the truth behind these claims?

Looking at Black's reference we discover that, in fact, most of the Italian
syndicalists did not go over to fascism, if by syndicalists we mean members of
the USI (the Italian Syndicalist Union). Roberts states that:

> _ "The vast majority of the organised workers failed to respond to the
syndicalists' appeals and continued to oppose [Italian] intervention [in the
First World War], shunning what seemed to be a futile capitalist war. The
syndicalists failed to convince even a majority within the USI . . . the
majority opted for the neutralism of Armando Borghi, leader of the anarchists
within the USI. Schism followed as De Ambris led the interventionist minority
out of the confederation."_ [**The Syndicalist Tradition and Italian
Fascism**, p. 113]

However, if we take "syndicalist" to mean some of the intellectuals and
"leaders" of the pre-war movement, it was a case that the _"leading
syndicalists came out for intervention quickly and almost unanimously"_
[Roberts, **Op. Cit.**, p. 106] after the First World War started. Many of
these pro-war "leading syndicalists" did become fascists. However, to
concentrate on a handful of "leaders" (which the majority did not even
follow!) and state that this shows that the _"Italian syndicalists mostly went
over to Fascism"_ staggers belief. What is even worse, as seen above, the
Italian anarchists and syndicalists were the most dedicated and successful
fighters against fascism. In effect, Black and Sabatini have slandered a whole
movement.

What is also interesting is that these "leading syndicalists" were not
anarchists and so not anarcho-syndicalists. As Roberts notes _"[i]n Italy, the
syndicalist doctrine was more clearly the product of a group of intellectuals,
operating within the Socialist party and seeking an alternative to
reformism."_ They _"explicitly denounced anarchism"_ and _"insisted on a
variety of Marxist orthodoxy."_ The _"syndicalists genuinely desired -- and
tried -- to work within the Marxist tradition."_ [**Op. Cit.**, p. 66, p. 72,
p. 57 and p. 79] According to Carl Levy, in his account of Italian anarchism,
_"[u]nlike other syndicalist movements, the Italian variation coalesced inside
a Second International party. Supporter were partially drawn from socialist
intransigents . . . the southern syndicalist intellectuals pronounced
republicanism . . . Another component . . . was the remnant of the Partito
Operaio."_ [_"Italian Anarchism: 1870-1926"_ in **For Anarchism: History,
Theory, and Practice**, David Goodway (Ed.), p. 51]

In other words, the Italian syndicalists who turned to fascism were, firstly,
a small minority of intellectuals who could not convince the majority within
the syndicalist union to follow them, and, secondly, Marxists and republicans
rather than anarchists, anarcho-syndicalists or even revolutionary
syndicalists.

According to Carl Levy, Roberts' book _"concentrates on the syndicalist
intelligentsia"_ and that _"some syndicalist intellectuals . . . helped
generate, or sympathetically endorsed, the new Nationalist movement . . .
which bore similarities to the populist and republican rhetoric of the
southern syndicalist intellectuals."_ He argues that there _"has been far too
much emphasis on syndicalist intellectuals and national organisers"_ and that
syndicalism _"relied little on its national leadership for its long-term
vitality."_ [**Op. Cit.**, p. 77, p. 53 and p. 51] If we do look at the
membership of the USI, rather than finding a group which _"mostly went over to
fascism,"_ we discover a group of people who fought fascism tooth and nail and
were subject to extensive fascist violence.

To summarise, Italian Fascism had nothing to do with syndicalism and, as seen
above, the USI fought the Fascists and was destroyed by them along with the
UAI, Socialist Party and other radicals. That a handful of pre-war Marxist-
syndicalists later became Fascists and called for a "National-Syndicalism"
does not mean that syndicalism and fascism are related (any more than some
anarchists later becoming Marxists makes anarchism "a vehicle" for Marxism!).

It is hardly surprising that anarchists were the most consistent and
successful opponents of Fascism. The two movements could not be further apart,
one standing for total statism in the service of capitalism while the other
for a free, non-capitalist society. Neither is it surprising that when their
privileges and power were in danger, the capitalists and the landowners turned
to fascism to save them. This process is a common feature in history (to list
just four examples, Italy, Germany, Spain and Chile).

## A.5.6 Anarchism and the Spanish Revolution

As Noam Chomsky notes, _"a good example of a really large-scale anarchist
revolution -- in fact the best example to my knowledge -- is the Spanish
revolution in 1936, in which over most of Republican Spain there was a quite
inspiring anarchist revolution that involved both industry and agriculture
over substantial areas . . . And that again was, by both human measures and
indeed anyone's economic measures, quite successful. That is, production
continued effectively; workers in farms and factories proved quite capable of
managing their affairs without coercion from above, contrary to what lots of
socialists, communists, liberals and other wanted to believe."_ The revolution
of 1936 was _"based on three generations of experiment and thought and work
which extended anarchist ideas to very large parts of the population."_
[**Radical Priorities**, p. 212]

Due to this anarchist organising and agitation, Spain in the 1930's had the
largest anarchist movement in the world. At the start of the Spanish "Civil"
war, over one and one half million workers and peasants were members of the
CNT (the **_National Confederation of Labour_**), an anarcho-syndicalist union
federation, and 30,000 were members of the FAI (the **_Anarchist Federation of
Iberia_**). The total population of Spain at this time was 24 million.

The social revolution which met the Fascist coup on July 18th, 1936, is the
greatest experiment in libertarian socialism to date. Here the last mass
syndicalist union, the CNT, not only held off the fascist rising but
encouraged the widespread take-over of land and factories. Over seven million
people, including about two million CNT members, put self-management into
practise in the most difficult of circumstances and actually improved both
working conditions and output.

In the heady days after the 19th of July, the initiative and power truly
rested in the hands of the rank-and-file members of the CNT and FAI. It was
ordinary people, undoubtedly under the influence of Faistas (members of the
FAI) and CNT militants, who, after defeating the fascist uprising, got
production, distribution and consumption started again (under more egalitarian
arrangements, of course), as well as organising and volunteering (in their
tens of thousands) to join the militias, which were to be sent to free those
parts of Spain that were under Franco. In every possible way the working class
of Spain were creating by their own actions a new world based on their own
ideas of social justice and freedom -- ideas inspired, of course, by anarchism
and anarchosyndicalism.

George Orwell's eye-witness account of revolutionary Barcelona in late
December, 1936, gives a vivid picture of the social transformation that had
begun:

> _"The Anarchists were still in virtual control of Catalonia and the
revolution was still in full swing. To anyone who had been there since the
beginning it probably seemed even in December or January that the
revolutionary period was ending; but when one came straight from England the
aspect of Barcelona was something startling and overwhelming. It was the first
time that I had ever been in a town where the working class was in the saddle.
Practically every building of any size had been seized by the workers and was
draped with red flags or with the red and black flag of the Anarchists; every
wall was scrawled with the hammer and sickle and with the initials of the
revolutionary parties; almost every church had been gutted and its images
burnt. Churches here and there were being systematically demolished by gangs
of workman. Every shop and cafe had an inscription saying that it had been
collectivised; even the bootblacks had been collectivised and their boxes
painted red and black. Waiters and shop-walkers looked you in the face and
treated you as an equal. Servile and even ceremonial forms of speech had
temporarily disappeared. Nobody said 'Señor' or 'Don' or even 'Usted';
everyone called everyone else 'Comrade' or 'Thou', and said 'Salud!' instead
of 'Buenos dias'. . . Above all, there was a belief in the revolution and the
future, a feeling of having suddenly emerged into an era of equality and
freedom. Human beings were trying to behave as human beings and not as cogs in
the capitalist machine."_ [**Homage to Catalonia**, pp. 2-3]

The full extent of this historic revolution cannot be covered here. It will be
discussed in more detail in [Section I.8](secI8.html) of the FAQ. All that can
be done is to highlight a few points of special interest in the hope that
these will give some indication of the importance of these events and
encourage people to find out more about it.

All industry in Catalonia was placed either under workers' self-management
**or** workers' control (that is, either totally taking over **all** aspects
of management, in the first case, or, in the second, controlling the old
management). In some cases, whole town and regional economies were transformed
into federations of collectives. The example of the Railway Federation (which
was set up to manage the railway lines in Catalonia, Aragon and Valencia) can
be given as a typical example. The base of the federation was the local
assemblies:

> _"All the workers of each locality would meet twice a week to examine all
that pertained to the work to be done... The local general assembly named a
committee to manage the general activity in each station and its annexes. At
[these] meetings, the decisions (direccion) of this committee, whose members
continued to work [at their previous jobs], would be subjected to the approval
or disapproval of the workers, after giving reports and answering questions."
_

The delegates on the committee could be removed by an assembly at any time and
the highest co-ordinating body of the Railway Federation was the
**_"Revolutionary Committee,"_** whose members were elected by union
assemblies in the various divisions. The control over the rail lines,
according to Gaston Leval, _"did not operate from above downwards, as in a
statist and centralised system. The Revolutionary Committee had no such
powers. . . The members of the. . . committee being content to supervise the
general activity and to co-ordinate that of the different routes that made up
the network."_ [Gaston Leval, **Collectives in the Spanish Revolution**, p.
255]

On the land, tens of thousands of peasants and rural day workers created
voluntary, self-managed collectives. The quality of life improved as co-
operation allowed the introduction of health care, education, machinery and
investment in the social infrastructure. As well as increasing production, the
collectives increased freedom. As one member puts it, _"it was marvellous . .
. to live in a collective, a free society where one could say what one
thought, where if the village committee seemed unsatisfactory one could say.
The committee took no big decisions without calling the whole village together
in a general assembly. All this was wonderful."_ [Ronald Fraser, **Blood of
Spain**, p. 360]

We discuss the revolution in more detail in [section I.8](secI8.html). For
example, sections [I.8.3](secI8.html#seci83) and [I.8.4](secI8.html#seci84)
discuss in more depth how the industrial collectives. The rural collectives
are discussed in sections [I.8.5](secI8.html#seci85) and
[I.8.6](secI8.html#seci86). We must stress that these sections are summaries
of a vast social movement, and more information can be gathered from such
works as Gaston Leval's **Collectives in the Spanish Revolution**, Sam
Dolfgoff's **The Anarchist Collectives**, Jose Peirats' **The CNT in the
Spanish Revolution** and a host of other anarchist accounts of the revolution.

On the social front, anarchist organisations created rational schools, a
libertarian health service, social centres, and so on. The **_Mujeres
Libres_** (free women) combated the traditional role of women in Spanish
society, empowering thousands both inside and outside the anarchist movement
(see **The Free Women of Spain** by Martha A. Ackelsberg for more information
on this very important organisation). This activity on the social front only
built on the work started long before the outbreak of the war; for example,
the unions often funded rational schools, workers centres, and so on.

The voluntary militias that went to free the rest of Spain from Franco were
organised on anarchist principles and included both men and women. There was
no rank, no saluting and no officer class. Everybody was equal. George Orwell,
a member of the POUM militia (the POUM was a dissident Marxist party,
influenced by Leninism but not, as the Communists asserted, Trotskyist) makes
this clear:

> _"The essential point of the [militia] system was the social equality
between officers and men. Everyone from general to private drew the same pay,
ate the same food, wore the same clothes, and mingled on terms of complete
equality. If you wanted to slap the general commanding the division on the
back and ask him for a cigarette, you could do so, and no one thought it
curious. In theory at any rate each militia was a democracy and not a
hierarchy. It was understood that orders had to be obeyed, but it was also
understood that when you gave an order you gave it as comrade to comrade and
not as superior to inferior. There were officers and N.C.O.s, but there was no
military rank in the ordinary sense; no titles, no badges, no heel-clicking
and saluting. They had attempted to produce within the militias a sort of
temporary working model of the classless society. Of course there was not
perfect equality, but there was a nearer approach to it than I had ever seen
or that I would have though conceivable in time of war. . . "_ [**Op. Cit.**,
p. 26]

In Spain, however, as elsewhere, the anarchist movement was smashed between
Stalinism (the Communist Party) on the one hand and Capitalism (Franco) on the
other. Unfortunately, the anarchists placed anti-fascist unity before the
revolution, thus helping their enemies to defeat both them and the revolution.
Whether they were forced by circumstances into this position or could have
avoided it is still being debated (see [section I.8.10](secI8.html#seci810)
for a discussion of why the CNT-FAI collaborated and [section
I.8.11](secI8.html#seci811) on why this decision was **not** a product of
anarchist theory).

Orwell's account of his experiences in the militia's indicates why the Spanish
Revolution is so important to anarchists:

> _"I had dropped more or less by chance into the only community of any size
in Western Europe where political consciousness and disbelief in capitalism
were more normal than their opposites. Up here in Aragon one was among tens of
thousands of people, mainly though not entirely of working-class origin, all
living at the same level and mingling on terms of equality. In theory it was
perfect equality, and even in practice it was not far from it. There is a
sense in which it would be true to say that one was experiencing a foretaste
of Socialism, by which I mean that the prevailing mental atmosphere was that
of Socialism. Many of the normal motives of civilised life -- snobbishness,
money-grubbing, fear of the boss, etc. -- had simply ceased to exist. The
ordinary class- division of society had disappeared to an extent that is
almost unthinkable in the money-tainted air of England; there was no one there
except the peasants and ourselves, and no one owned anyone else as his master.
. . One had been in a community where hope was more normal than apathy or
cynicism, where the word 'comrade' stood for comradeship and not, as in most
countries, for humbug. One had breathed the air of equality. I am well aware
that it is now the fashion to deny that Socialism has anything to do with
equality. In every country in the world a huge tribe of party-hacks and sleek
little professors are busy 'proving' that Socialism means no more than a
planned state-capitalism with the grab-motive left intact. But fortunately
there also exists a vision of Socialism quite different from this. The thing
that attracts ordinary men to Socialism and makes them willing to risk their
skins for it, the 'mystique' of Socialism, is the idea of equality; to the
vast majority of people Socialism means a classless society, or it means
nothing at all . . . In that community where no one was on the make, where
there was a shortage of everything but no boot-licking, one got, perhaps, a
crude forecast of what the opening stages of Socialism might be like. And,
after all, instead of disillusioning me it deeply attracted me. . ."_ [**Op.
Cit.**, pp. 83-84]

For more information on the Spanish Revolution, the following books are
recommended: **Lessons of the Spanish Revolution** by Vernon Richards;
**Anarchists in the Spanish Revolution** and **The CNT in the Spanish
Revolution** by Jose Peirats; **Free Women of Spain** by Martha A. Ackelsberg;
**The Anarchist Collectives** edited by Sam Dolgoff; _"Objectivity and Liberal
Scholarship"_ by Noam Chomsky (in **The Chomsky Reader**); **The Anarchists of
Casas Viejas** by Jerome R. Mintz; and **Homage to Catalonia** by George
Orwell.

## A.5.7 The May-June Revolt in France, 1968

The May-June events in France placed anarchism back on the radical landscape
after a period in which many people had written the movement off as dead. This
revolt of ten million people grew from humble beginnings. Expelled by the
university authorities of Nanterre in Paris for anti-Vietnam War activity, a
group of anarchists (including Daniel Cohn-Bendit) promptly called a protest
demonstration. The arrival of 80 police enraged many students, who quit their
studies to join the battle and drive the police from the university.

Inspired by this support, the anarchists seized the administration building
and held a mass debate. The occupation spread, Nanterre was surrounded by
police, and the authorities closed the university down. The next day, the
Nanterre students gathered at the Sorbonne University in the centre of Paris.
Continual police pressure and the arrest of over 500 people caused anger to
erupt into five hours of street fighting. The police even attacked passers-by
with clubs and tear gas.

A total ban on demonstrations and the closure of the Sorbonne brought
thousands of students out onto the streets. Increasing police violence
provoked the building of the first barricades. Jean Jacques Lebel, a reporter,
wrote that by 1 a.m., _"[l]iterally thousands helped build barricades. . .
women, workers, bystanders, people in pyjamas, human chains to carry rocks,
wood, iron."_ An entire night of fighting left 350 police injured. On May 7th,
a 50,000-strong protest march against the police was transformed into a day-
long battle through the narrow streets of the Latin Quarter. Police tear gas
was answered by molotov cocktails and the chant _"Long Live the Paris
Commune!"_

By May 10th, continuing massive demonstrations forced the Education Minister
to start negotiations. But in the streets, 60 barricades had appeared and
young workers were joining the students. The trade unions condemned the police
violence. Huge demonstrations throughout France culminated on May 13th with
one million people on the streets of Paris.

Faced with this massive protest, the police left the Latin Quarter. Students
seized the Sorbonne and created a mass assembly to spread the struggle.
Occupations soon spread to every French University. From the Sorbonne came a
flood of propaganda, leaflets, proclamations, telegrams, and posters. Slogans
such as "**_Everything is Possible,"_** **_"Be Realistic, Demand the
Impossible,"_** **_"Life without Dead Times,"_** and **_"It is Forbidden to
Forbid"_** plastered the walls. **_"All Power to the Imagination"_** was on
everyone's lips. As Murray Bookchin pointed out, _"the motive forces of
revolution today. . . are not simply scarcity and material need, but also
**quality of everyday life . . . the attempt to gain control of one's own
destiny**." _[**Post-Scarcity Anarchism**, p. 166]

Many of the most famous slogans of those days originated from the
Situationists. The **Situationist International** had been formed in 1957 by a
small group of dissident radicals and artists. They had developed a highly
sophisticated (if jargon riddled) and coherent analysis of modern capitalist
society and how to supersede it with a new, freer one. Modern life, they
argued, was mere survival rather than living, dominated by the economy of
consumption in which everyone, everything, every emotion and relationship
becomes a commodity. People were no longer simply alienated producers, they
were also alienated consumers. They defined this kind of society as the
**_"Spectacle."_** Life itself had been stolen and so revolution meant
recreating life. The area of revolutionary change was no longer just the
workplace, but in everyday existence:

> _ "People who talk about revolution and class struggle without referring
explicitly to everyday life, without understanding what is subversive about
love and what is positive in the refusal of constraints, such people have a
corpse in their mouth."_ [quoted by Clifford Harper, **Anarchy: A Graphic
Guide**, p. 153]

Like many other groups whose politics influenced the Paris events, the
situationists argued that _"the workers' councils are the only answer. Every
other form of revolutionary struggle has ended up with the very opposite of
what it was originally looking for."_ [quoted by Clifford Harper, **Op.
Cit.**, p. 149] These councils would be self-managed and not be the means by
which a "revolutionary" party would take power. Like the anarchists of **Noire
et Rouge** and the libertarian socialists of **Socialisme ou Barbarie**, their
support for a self-managed revolution from below had a massive influence in
the May events and the ideas that inspired it.

On May 14th, the Sud-Aviation workers locked the management in its offices and
occupied their factory. They were followed by the Cleon-Renault, Lockhead-
Beauvais and Mucel-Orleans factories the next day. That night the National
Theatre in Paris was seized to become a permanent assembly for mass debate.
Next, France's largest factory, Renault-Billancourt, was occupied. Often the
decision to go on indefinite strike was taken by the workers without
consulting union officials. By May 17th, a hundred Paris Factories were in the
hands of their workers. The weekend of the 19th of May saw 122 factories
occupied. By May 20th, the strike and occupations were general and involved
six million people. Print workers said they did not wish to leave a monopoly
of media coverage to TV and radio, and agreed to print newspapers as long as
the press _"carries out with objectivity the role of providing information
which is its duty."_ In some cases print-workers insisted on changes in
headlines or articles before they would print the paper. This happened mostly
with the right-wing papers such as **_'Le Figaro'_** or **_'La Nation'_**.

With the Renault occupation, the Sorbonne occupiers immediately prepared to
join the Renault strikers, and led by anarchist black and red banners, 4,000
students headed for the occupied factory. The state, bosses, unions and
Communist Party were now faced with their greatest nightmare -- a worker-
student alliance. Ten thousand police reservists were called up and frantic
union officials locked the factory gates. The Communist Party urged their
members to crush the revolt. They united with the government and bosses to
craft a series of reforms, but once they turned to the factories they were
jeered out of them by the workers.

The struggle itself and the activity to spread it was organised by self-
governing mass assemblies and co-ordinated by action committees. The strikes
were often run by assemblies as well. As Murray Bookchin argues, the _"hope
[of the revolt] lay in the extension of self-management in all its forms --
the general assemblies and their administrative forms, the action committees,
the factory strike committees -- to all areas of the economy, indeed to all
areas of life itself."_ Within the assemblies, _"a fever of life gripped
millions, a rewaking of senses that people never thought they possessed."_
[**Op. Cit.**, p. 168 and p. 167] It was not a workers' strike or a student
strike. It was a **peoples'** strike that cut across almost all class lines.

On May 24th, anarchists organised a demonstration. Thirty thousand marched
towards the Palace de la Bastille. The police had the Ministries protected,
using the usual devices of tear gas and batons, but the Bourse (Stock
Exchange) was left unprotected and a number of demonstrators set fire to it.

It was at this stage that some left-wing groups lost their nerve. The
Trotskyist JCR turned people back into the Latin Quarter. Other groups such as
UNEF and Parti Socialiste Unife (United Socialist Party) blocked the taking of
the Ministries of Finance and Justice. Cohn-Bendit said of this incident _"As
for us, we failed to realise how easy it would have been to sweep all these
nobodies away. . . .It is now clear that if, on 25 May, Paris had woken to
find the most important Ministries occupied, Gaullism would have caved in at
once. . . . "_ Cohn-Bendit was forced into exile later that very night.

As the street demonstrations grew and occupations continued, the state
prepared to use overwhelming means to stop the revolt. Secretly, top generals
readied 20,000 loyal troops for use on Paris. Police occupied communications
centres like TV stations and Post Offices. By Monday, May 27th, the Government
had guaranteed an increase of 35% in the industrial minimum wage and an all
round-wage increase of 10%. The leaders of the CGT organised a march of
500,000 workers through the streets of Paris two days later. Paris was covered
in posters calling for a _"Government of the People."_ Unfortunately the
majority still thought in terms of changing their rulers rather than taking
control for themselves.

By June 5th most of the strikes were over and an air of what passes for
normality within capitalism had rolled back over France. Any strikes which
continued after this date were crushed in a military-style operation using
armoured vehicles and guns. On June 7th, they made an assault on the Flins
steelworks which started a four-day running battle which left one worker dead.
Three days later, Renault strikers were gunned down by police, killing two. In
isolation, those pockets of militancy stood no chance. On June 12th,
demonstrations were banned, radical groups outlawed, and their members
arrested. Under attack from all sides, with escalating state violence and
trade union sell-outs, the General Strike and occupations crumbled.

So why did this revolt fail? Certainly not because "vanguard" Bolshevik
parties were missing. It was infested with them. Fortunately, the traditional
authoritarian left sects were isolated and outraged. Those involved in the
revolt did not require a vanguard to tell them what to do, and the "workers'
vanguards" frantically ran after the movement trying to catch up with it and
control it.

No, it was the lack of independent, self-managed confederal organisations to
co-ordinate struggle which resulted in occupations being isolated from each
other. So divided, they fell. In addition, Murray Bookchin argues that _"an
awareness among the workers that the factories had to be **worked**, not
merely occupied or struck,"_ was missing. [**Op. Cit.**, p. 182]

This awareness would have been encouraged by the existence of a strong
anarchist movement before the revolt. The anti-authoritarian left, though very
active, was too weak among striking workers, and so the idea of self-managed
organisations and workers self-management was not widespread. However, the
May-June revolt shows that events can change very rapidly. _"Under the
influence of the students,"_ noted libertarian socialist Maurice Brinton,
_"thousands began to query the whole principle of hierarchy . . . Within a
matter of days the tremendous creative potentialities of the people suddenly
erupted. The boldest and realistic ideas -- and they are usually the same --
were advocated, argued, applied. Language, rendered stale by decades of
bureaucratic mumbo-jumbo, eviscerated by those who manipulate it for
advertising purposes, reappeared as something new and fresh. People re-
appropriated it in all its fullness. Magnificently apposite and poetic slogans
emerged from the anonymous crowd."_ [_"Paris: May 1968"_, **For Workers'
Power**, p. 253] The working class, fused by the energy and bravado of the
students, raised demands that could not be catered for within the confines of
the existing system. The General Strike displays with beautiful clarity the
potential power that lies in the hands of the working class. The mass
assemblies and occupations give an excellent, if short-lived, example of
anarchy in action and how anarchist ideas can quickly spread and be applied in
practice.

For more details of these events, see participants Daniel and Gabriel Cohn-
Bendit's **Obsolete Communism: The Left-Wing Alternative** or Maurice
Brinton's eye-witness account _"Paris: may 1968"_ (in his **For Workers'
Power**). **Beneath the Paving Stones** by edited Dark Star is a good
anthology of situationist works relating to Paris 68 (it also contains
Brinton's essay).

[‹ A.4 Who are the major anarchist thinkers?](/afaq/secA4.html "Go to previous
page" ) [up](/afaq/secAcon.html "Go to parent page" ) [Section B - Why do
anarchists oppose the current system? ›](/afaq/secBcon.html "Go to next page"
)

