# 6 Is "anarcho"-capitalism against the state?

No. Due to its basis in private property, "anarcho"-capitalism implies a class
division of society into bosses and workers. Any such division will require a
state to maintain it. However, it need not be the same state as exists now.
Regarding this point, "anarcho"-capitalism plainly advocates "defence
associations" to protect property. For the "anarcho"-capitalist, however,
these private companies are not states. For anarchists, they most definitely
are.

According to Murray Rothbard [_"Society Without A State"_, in **Nomos XIX**,
Pennock and Chapman, eds., p. 192.], a state must have one or both of the
following characteristics:

           1) The ability to tax those who live within it.

          2) It asserts and usually obtains a coerced monopoly of the
provision of defence over a given area.

He makes the same point in **The Ethics of Liberty** [p. 171].

Instead of this, the "anarcho"-capitalist thinks that people should be able to
select their own "defence companies" (which would provide the needed police)
and courts from the free market in "defence" which would spring up after the
state monopoly has been eliminated. These companies _"all. . . would have to
abide by the basic law code"_ [_"Society Without A State"_, p. 206]. Thus a
_"general libertarian law code"_ would govern the actions of these companies.
This "law code" would prohibit coercive aggression at the very least, although
to do so it would have to specify what counted as legitimate property, how
said can be owned and what actually constitutes aggression. Thus the law code
would be quite extensive.

How is this law code to be actually specified? Would these laws be
democratically decided? Would they reflect common usage (i.e. custom)? "supply
and demand"? "Natural law"? Given the strong dislike of democracy shown by
"anarcho"-capitalists, we think we can safely say that some combination of the
last two options would be used. Murray Rothbard, as noted in [section
1.4](append131.html#secf11), opposed the individualist anarchist principle
that juries would judge both the facts and the law, suggesting instead that
_"Libertarian lawyers and jurists"_ would determine a _"rational and objective
code of libertarian legal principles and procedures."_ The judges in his
system would _"not [be] making the law but finding it on the basis of agreed-
upon principles derived either from custom or reason."_ [_"Society without a
State"_, **Op. Cit.**, p. 206] David Friedman, on the other hand, argues that
different defence firms would sell their own laws. [**The Machinery of
Freedom**, p. 116] It is sometimes acknowledged that non-libertarian laws may
be demanded (and supplied) in such a market.

Around this system of "defence companies" is a free market in "arbitrators"
and "appeal judges" to administer justice and the "basic law code." Rothbard
believes that such a system would see _"arbitrators with the best reputation
for efficiency and probity. . .[being] chosen by the various parties in the
market. . .[and] will come to be given an increasing amount of business."_
[Rothbard, **Op. Cit.**, p.199] Judges _"will prosper on the market in
proportion to their reputation for efficiency and impartiality."_ [**Op.
Cit.**, p. 204]

Therefore, like any other company, arbitrators would strive for profits and
wealth, with the most successful ones becoming _"prosperous."_ Of course, such
wealth would have no impact on the decisions of the judges, and if it did, the
population (in theory) are free to select any other judge (although, of
course, they would also _"strive for profits and wealth"_ \-- which means the
choice of character may be somewhat limited! -- and the laws which they were
using to guide their judgements would be enforcing capitalist rights).

Whether or not this system would work as desired is discussed in the following
sections. We think that it will not. Moreover, we will argue that
"anarcho"-capitalist "defence companies" meet not only the criteria of
statehood we outlined in section [B.2](secB2.html), but also Rothbard's own
criteria for the state, quoted above.

As regards the anarchist criterion, it is clear that "defence companies" exist
to defend private property; that they are hierarchical (in that they are
capitalist companies which defend the power of those who employ them); that
they are professional coercive bodies; and that they exercise a monopoly of
force over a given area (the area, initially, being the property of the person
or company who is employing the "association"). If, as Ayn Rand noted (using a
Weberian definition of the state) a government is an institution _"that holds
the exclusive power to **enforce** certain rules of conduct in a given
geographical area"_ [**Capitalism: The Unknown Ideal**, p. 239] then these
"defence companies" are the means by which the property owner (who exercises a
monopoly to determine the rules governing their property) enforce their rules.

For this (and other reasons), we should call the "anarcho"-capitalist defence
firms "private states" -- that is what they are -- and "anarcho"-capitalism
"private state" capitalism.

Before discussing these points further, it is necessary to point out a
relatively common fallacy of "anarcho"-capitalists. This is the idea that
"defence" under the system they advocate means defending people, not
territorial areas. This, for some, means that defence companies are not
"states." However, as people and their property and possessions do not exist
merely in thought but on the Earth, it is obvious that these companies will be
administering "justice" over a given area of the planet. It is also obvious,
therefore, that these "defence associations" will operate over a (property-
owner defined) area of land and enforce the property-owner's laws, rules and
regulations. The deeply anti-libertarian, indeed fascistic, aspects of this
"arrangement" will be examined in the following sections.

## 6.1 What's wrong with this "free market" justice?

It does not take much imagination to figure out whose interests _"prosperous"_
arbitrators, judges and defence companies would defend: their own, as well as
those who pay their wages -- which is to say, other members of the rich elite.
As the law exists to defend property, then it (by definition) exists to defend
the power of capitalists against their workers.

Rothbard argues that the _"judges"_ would _"not [be] making the law but
finding it on the basis of agreed-upon principles derived either from custom
or reason"_ [Rothbard, **Op. Cit.**, p. 206]. However, this begs the question:
**whose** reason? **whose** customs? Do individuals in different classes share
the same customs? The same ideas of right and wrong? Would rich and poor
desire the same from a _"basic law code"_? Obviously not. The rich would only
support a code which defended their power over the poor.

Although only _"finding"_ the law, the arbitrators and judges still exert an
influence in the "justice" process, an influence not impartial or neutral. As
the arbitrators themselves would be part of a profession, with specific
companies developing within the market, it does not take a genius to realise
that when "interpreting" the "basic law code," such companies would hardly act
against their own interests as companies. In addition, if the "justice" system
was based on "one dollar, one vote," the "law" would best defend those with
the most "votes" (the question of market forces will be discussed in section
[6.3](append136.html#secf63)). Moreover, even if "market forces" would ensure
that "impartial" judges were dominant, all judges would be enforcing a
**very** partial law code (namely one that defended **capitalist** property
rights). Impartiality when enforcing partial laws hardly makes judgements less
unfair.

Thus, due to these three pressures -- the interests of arbitrators/judges, the
influence of money and the nature of the law -- the terms of "free agreements"
under such a law system would be tilted in favour of lenders over debtors,
landlords over tenants, employers over employees, and in general, the rich
over the poor, just as we have today. This is what one would expect in a
system based on "unrestricted" property rights and a (capitalist) free market.
A similar tendency towards the standardisation of output in an industry in
response to influences of wealth can be seen from the current media system
(see section D.3 -- [How does wealth influence the mass media?](secD3.html))

Some "anarcho"-capitalists, however, claim that just as cheaper cars were
developed to meet demand, so cheaper defence associations and "people's
arbitrators" would develop on the market for the working class. In this way
impartiality will be ensured. This argument overlooks a few key points:

Firstly, the general "libertarian" law code would be applicable to **all**
associations, so they would have to operate within a system determined by the
power of money and of capital. The law code would reflect, therefore, property
**not** labour and so "socialistic" law codes would be classed as "outlaw"
ones. The options then facing working people is to select a firm which best
enforced the **capitalist** law in their favour. And as noted above, the
impartial enforcement of a biased law code will hardly ensure freedom or
justice for all.

Secondly, in a race between a Jaguar and a Volkswagen Beetle, who is more
likely to win? The rich would have "the best justice money can buy," as they
do now. Members of the capitalist class would be able to select the firms with
the best lawyers, best private cops and most resources. Those without the
financial clout to purchase quality "justice" would simply be out of luck -
such is the "magic" of the marketplace.

Thirdly, because of the tendency toward concentration, centralisation, and
oligopoly under capitalism (due to increasing capital costs for new firms
entering the market, as discussed in section [C.4](secC4.html)), a few
companies would soon dominate the market -- with obvious implications for
"justice."

Different firms will have different resources. In other words, in a conflict
between a small firm and a larger one, the smaller one is at a disadvantage in
terms of resources. They may not be in a position to fight the larger company
if it rejects arbitration and so may give in simply because, as the
"anarcho"-capitalists so rightly point out, conflict and violence will push up
a company's costs and so they would have to be avoided by smaller companies.
It is ironic that the "anarcho"-capitalist implicitly assumes that every
"defence company" is approximately of the same size, with the same resources
behind it. In real life, this would clearly **not** the case.

Fourthly, it is **very** likely that many companies would make subscription to
a specific "defence" firm or court a requirement of employment. Just as today
many (most?) workers have to sign no-union contracts (and face being fired if
they change their minds), it does not take much imagination to see that the
same could apply to "defence" firms and courts. This was/is the case in
company towns (indeed, you can consider unions as a form of "defence" firm and
these companies refused to recognise them). As the labour market is almost
always a buyer's market, it is not enough to argue that workers can find a new
job without this condition. They may not and so have to put up with this
situation. And if (as seems likely) the laws and rules of the property-owner
will take precedence in any conflict, then workers and tenants will be at a
disadvantage no matter how "impartial" the judges.

Ironically, some "anarcho"-capitalists point to current day company/union
negotiations as an example of how different defence firms would work out their
differences peacefully. Sadly for this argument, union rights under "actually
existing capitalism" were created and enforced by the state in direct
opposition to capitalist "freedom of contract." Before the law was changed,
unions were often crushed by force -- the companies were better armed, had
more resources and had the law on their side. Today, with the "downsizing" of
companies we can see what happens to "peaceful negotiation" and "co-operation"
between unions and companies when it is no longer required (i.e. when the
resources of both sides are unequal). The market power of companies far
exceeds those of the unions and the law, by definition, favours the companies.
As an example of how competing "protection agencies" will work in an
"anarcho"-capitalist society, it is far more insightful than originally
intended!

Now let us consider the _"basic law code"_ itself. How the laws in the
_"general libertarian law code"_ would actually be selected is anyone's guess,
although many "anarcho"-capitalists support the myth of "natural law," and
this would suggest an unchangeable law code selected by those considered as
"the voice of nature" (see [section 11](append1311.html). for a discussion of
its authoritarian implications). David Friedman argues that as well as a
market in defence companies, there will also be a market in laws and rights.
However, there will be extensive market pressure to unify these differing law
codes into one standard one (imagine what would happen if ever CD manufacturer
created a unique CD player, or every computer manufacturer different sized
floppy-disk drivers -- little wonder, then, that over time companies
standardise their products). Friedman himself acknowledges that this process
is likely (and uses the example of standard paper sizes to indicate such a
process).

In any event, the laws would not be decided on the basis of "one person, one
vote"; hence, as market forces worked their magic, the "general" law code
would reflect vested interests and so be very hard to change. As rights and
laws would be a commodity like everything else in capitalism, they would soon
reflect the interests of the rich -- particularly if those interpreting the
law are wealthy professionals and companies with vested interests of their
own. Little wonder that the individualist anarchists proposed "trial by jury"
as the only basis for real justice in a free society. For, unlike professional
"arbitrators," juries are ad hoc, made up of ordinary people and do not
reflect power, authority, or the influence of wealth. And by being able to
judge the law as well as a conflict, they can ensure a populist revision of
laws as society progresses.

Thus a system of "defence" on the market will continue to reflect the
influence and power of property owners and wealth and not be subject to
popular control beyond choosing between companies to enforce the capitalist
laws

.

## 6.2 What are the social consequences of such a system?

The "anarcho" capitalist imagines that there will be police agencies, "defence
associations," courts, and appeals courts all organised on a free-market basis
and available for hire. As David Weick points out, however, the major problem
with such a system would not be the corruption of "private" courts and police
forces (although, as suggested above, this could indeed be a problem):

> _"There is something more serious than the 'Mafia danger', and this other
problem concerns the role of such 'defence' institutions in a given social and
economic context. _

>

> _"[The] context. . . is one of a free-market economy with no restraints upon
accumulation of property. Now, we had an American experience, roughly from the
end of the Civil War to the 1930's, in what were in effect private courts,
private police, indeed private governments. We had the experience of the
(private) Pinkerton police which, by its spies, by its **agents
provocateurs,** and by methods that included violence and kidnapping, was one
of the most powerful tools of large corporations and an instrument of
oppression of working people. We had the experience as well of the police
forces established to the same end, within corporations, by numerous
companies. . . . (The automobile companies drew upon additional covert
instruments of a private nature, usually termed vigilante, such as the Black
Legion). These were, in effect, private armies, and were sometimes described
as such. The territories owned by coal companies, which frequently included
entire towns and their environs, the stores the miners were obliged by
economic coercion to patronise, the houses they lived in, were commonly
policed by the private police of the United States Steel Corporation or
whatever company owned the properties. The chief practical function of these
police was, of course, to prevent labour organisation and preserve a certain
balance of 'bargaining.' _

>

> _"These complexes were a law unto themselves, powerful enough to ignore,
when they did not purchase, the governments of various jurisdictions of the
American federal system. This industrial system was, at the time, often
characterised as feudalism. . . ."_ [_"Anarchist Justice"_, **Op. Cit.**, pp.
223-224]

For a description of the weaponry and activities of these private armies, the
economic historian Maurice Dobbs presents an excellent summary in **Studies in
Capitalist Development** [pp. 353-357]. According to a report on _"Private
Police Systems"_ cited by Dobbs, in a town dominated by Republican Steel, the
_"civil liberties and the rights of labour were suppressed by company police.
Union organisers were driven out of town."_ Company towns had their own
(company-run) money, stores, houses and jails and many corporations had
machine-guns and tear-gas along with the usual shot-guns, rifles and
revolvers. The _"usurpation of police powers by privately paid 'guards and
'deputies', often hired from detective agencies, many with criminal records"_
was _"a general practice in many parts of the country."_

The local (state-run) law enforcement agencies turned a blind-eye to what was
going on (after all, the workers **had** broken their contracts and so were
"criminal aggressors" against the companies) even when union members and
strikers were beaten and killed. The workers own defence organisations were
the only ones willing to help them, and if the workers seemed to be winning
then troops were called in to "restore the peace" (as happened in the Ludlow
strike, when strikers originally cheered the troops as they thought they would
defend their civil rights; needless to say, they were wrong).

Here we have a society which is claimed by many "anarcho"-capitalists as one
of the closest examples to their "ideal," with limited state intervention,
free reign for property owners, etc. What happened? The rich reduced the
working class to a serf-like existence, capitalist production undermined
independent producers (much to the annoyance of individualist anarchists at
the time), and the result was the emergence of the corporate America that
"anarcho"-capitalists say they oppose.

Are we to expect that "anarcho"-capitalism will be different? That, unlike
before, "defence" firms will intervene on behalf of strikers? Given that the
"general libertarian law code" will be enforcing capitalist property rights,
workers will be in exactly the same situation as they were then. Support of
strikers violating property rights would be a violation of the "general
libertarian law code" and be costly for profit making firms to do (if not
dangerous as they could be "outlawed" by the rest). Thus "anarcho"-capitalism
will extend extensive rights and powers to bosses, but few if any rights to
rebellious workers. And this difference in power is enshrined within the
fundamental institutions of the system.

In evaluating "anarcho"-capitalism's claim to be a form of anarchism, Peter
Marshall notes that _"private protection agencies would merely serve the
interests of their paymasters."_ [**Demanding the Impossible**, p. 653] With
the increase of private "defence associations" under "really existing
capitalism" today (associations that many "anarcho"-capitalists point to as
examples of their ideas), we see a vindication of Marshall's claim. There have
been many documented experiences of protesters being badly beaten by private
security guards. As far as market theory goes, the companies are only
supplying what the buyer is demanding. The rights of others are **not a
factor** (yet more "externalities," obviously). Even if the victims
successfully sue the company, the message is clear -- social activism can
seriously damage your health. With a reversion to "a general libertarian law
code" enforced by private companies, this form of "defence" of "absolute"
property rights can only increase, perhaps to the levels previously attained
in the heyday of US capitalism, as described above by Weick.

## 6.3 But surely market forces will stop abuses by the rich?

Unlikely. The rise of corporations within America indicates exactly how a
"general libertarian law code" would reflect the interests of the rich and
powerful. The laws recognising corporations as "legal persons" were **not**
primarily a product of "the state" but of private lawyers hired by the rich --
a result with which Rothbard would have no problem. As Howard Zinn notes:

> _"the American Bar Association, organised by lawyers accustomed to serving
the wealthy, began a national campaign of education to reverse the [Supreme]
Court decision [that companies could not be considered as a person]. . . . By
1886. . . the Supreme Court had accepted the argument that corporations were
'persons' and their money was property protected by the process clause of the
Fourteenth Amendment. . . . The justices of the Supreme Court were not simply
interpreters of the Constitution. They were men of certain backgrounds, of
certain [class] interests."_ [**A People's History of the United States**, p.
255]

Of course it will be argued that the Supreme Court is a monopoly and so our
analysis is flawed. In "anarcho"-capitalism there is no monopoly. But the
corporate laws came about because there was a demand for them. That demand
would still have existed in "anarcho"-capitalism. Now, while there may be no
Supreme Court, Rothbard does maintain that _"the basic Law Code . . .would
have to be agreed upon by all the judicial agencies"_ but he maintains that
this _"would imply no unified legal system"_! Even though _"[a]ny agencies
that transgressed the basic libertarian law code would be open outlaws"_ and
soon crushed this is **not**, apparently, a monopoly. [**The Ethics of
Liberty**, p. 234] So, you either agree to the law code or you go out of
business. And that is **not** a monopoly! Therefore, we think, our comments on
the Supreme Court decision are valid.

If all the available defence firms enforce the same laws, then it can hardly
be called "competitive"! And if this is the case (and it is) _"when private
wealth is uncontrolled, then a police-judicial complex enjoying a clientele of
wealthy corporations whose motto is self-interest is hardly an innocuous
social force controllable by the possibility of forming or affiliating with
competing 'companies.'"_ [Weick, **Op. Cit.**, p. 225]

This is particularly true if these companies are themselves Big Business and
so have a large impact on the laws they are enforcing. If the law code
recognises and protects capitalist power, property and wealth as fundamental
**any** attempt to change this is "initiation of force" and so the power of
the rich is written into the system from the start!

(And, we must add, if there is a general libertarian law code to which all
must subscribe, where does that put customer demand? If people demand a non-
libertarian law code, will defence firms refuse to supply it? If so, will not
new firms, looking for profit, spring up that will supply what is being
demanded? And will that not put them in direct conflict with the existing,
pro-general law code ones? And will a market in law codes not just reflect
economic power and wealth? David Friedman, who is for a market in law codes,
argues that _"[i]f almost everyone believes strongly that heroin addiction is
so horrible that it should not be permitted anywhere under any circumstances
anarcho-capitalist institutions will produce laws against heroin. Laws are
being produced on the market, and that is what the market wants."_ And he adds
that _"market demands are in dollars, not votes. The legality of heroin will
be determined, not by how many are for or against but how high a cost each
side is willing to bear in order to get its way."_ [**The Machinery of
Freedom**, p. 127] And, as the market is less than equal in terms of income
and wealth, such a position will mean that the capitalist class will have a
higher effective demand than the working class, and more resources to pay for
any conflicts that arise. Thus any law codes that develop will tend to reflect
the interests of the wealthy.)

Which brings us nicely on to the next problem regarding market forces.

As well as the obvious influence of economic interests and differences in
wealth, another problem faces the "free market" justice of
"anarcho"-capitalism. This is the _"general libertarian law code"_ itself.
Even if we assume that the system actually works like it should in theory, the
simple fact remains that these "defence companies" are enforcing laws which
explicitly defend capitalist property (and so social relations). Capitalists
own the means of production upon which they hire wage-labourers to work and
this is an inequality established **prior** to any specific transaction in the
labour market. This inequality reflects itself in terms of differences in
power within (and outside) the company and in the "law code" of
"anarcho"-capitalism which protects that power against the dispossessed.

In other words, the law code within which the defence companies work assumes
that capitalist property is legitimate and that force can legitimately be used
to defend it. This means that, in effect, "anarcho"-capitalism is based on a
monopoly of law, a monopoly which explicitly exists to defend the power and
capital of the wealthy. The major difference is that the agencies used to
protect that wealth will be in a weaker position to act independently of their
pay-masters. Unlike the state, the "defence" firm is not remotely accountable
to the general population and cannot be used to equalise even slightly the
power relationships between worker and capitalist.

And, needless to say, it is very likely that the private police forces
**will** give preferential treatment to their wealthier customers (what
business does not?) and that the law code will reflect the interests of the
wealthier sectors of society (particularly if _"prosperous"_ judges administer
that code) in reality, even if not in theory. Since, in capitalist practice,
"the customer is always right," the best-paying customers will get their way
in "anarcho"-capitalist society.

For example, in chapter 29 of **The Machinery of Freedom**, David Friedman
presents an example of how a clash of different law codes could be resolved by
a bargaining process (the law in question is the death penalty). This process
would involve one defence firm giving a sum of money to the other for them
accepting the appropriate (anti/pro capital punishment) court. Friedman claims
that _"[a]s in any good trade, everyone gains"_ but this is obviously not
true. Assuming the anti-capital punishment defence firm pays the pro one to
accept an anti-capital punishment court, then, yes, both defence firms have
made money and so are happy, so are the anti-capital punishment consumers but
the pro-death penalty customers have only (perhaps) received a cut in their
bills. Their desire to see criminals hanged (for whatever reason) has been
ignored (if they were not in favour of the death penalty, they would not have
subscribed to that company). Friedman claims that the deal, by allowing the
anti-death penalty firm to cut its costs, will ensure that it _"keep its
customers and even get more"_ but this is just an assumption. It is just as
likely to loose customers to a defence firm that refuses to compromise (and
has the resources to back it up). Friedman's assumption that lower costs will
automatically win over people's passions is unfounded. As is the assumption
that both firms have equal resources and bargaining power. If the pro-capital
punishment firm demands more than the anti can provide and has larger weaponry
and troops, then the anti defence firm may have to agree to let the pro one
have its way.

So, all in all, it is **not** clear that _"everyone gains"_ \-- there may be a
sizeable percentage of those involved who do not "gain" as their desire for
capital punishment is traded away by those who claimed they would enforce it.

In other words, a system of competing law codes and privatised rights does not
ensure that **all** consumers interests are meet. Given unequal resources
within society, it is also clear that the "effective demand" of the parties
involved to see their law codes enforced is drastically different. The wealthy
head of a transnational corporation will have far more resources available to
him to pay for **his** laws to be enforced than one of his employees on the
assembly line. Moreover, as we argue in sections [3.1](append133.html#secf31)
and [10.2](append1310.html#secf102), the labour market is usually skewed in
favour of capitalists. This means that workers have to compromise to get work
and such compromises may involve agreeing to join a specific "defence" firm or
not join one at all (just as workers are often forced to sign non-union
contracts today in order to get work). In other words, a privatised law system
is very likely to skew the enforcement of laws in line with the skewing of
income and wealth in society. At the very least, unlike every other market,
the customer is **not** guaranteed to get exactly what they demand simply
because the product they "consume" is dependent on other within the same
market to ensure its supply. The unique workings of the law/defence market are
such as to deny customer choice (we will discuss other aspects of this unique
market shortly).

Weick sums up by saying _"any judicial system is going to exist in the context
of economic institutions. If there are gross inequalities of power in the
economic and social domains, one has to imagine society as strangely
compartmentalised in order to believe that those inequalities will fail to
reflect themselves in the judicial and legal domain, and that the economically
powerful will be unable to manipulate the legal and judicial system to their
advantage. To abstract from such influences of context, and then consider the
merits of an abstract judicial system. . . is to follow a method that is not
likely to take us far. This, by the way, is a criticism that applies. . .to
any theory that relies on a rule of law to override the tendencies inherent in
a given social and economic system"_ [Weick, **Op. Cit.**, p. 225] (For a
discussion of this problem as it would surface in attempts to protect the
environment under "anarcho"-capitalism, see sections [E.2](secE2.html) and
[E.3](secE3.html)).

There is another reason why "market forces" will not stop abuse by the rich,
or indeed stop the system from turning from private to public statism. This is
due to the nature of the "defence" market (for a similar analysis of the
"defence" market see Tyler Cowen's _"Law as a Public Good: The Economics of
Anarchy"_ in **Economics and Philosophy**, no. 8 (1992), pp. 249-267 and
_"Rejoinder to David Friedman on the Economics of Anarchy"_ in **Economics and
Philosophy**, no. 10 (1994), pp. 329-332). In "anarcho"-capitalist theory it
is assumed that the competing "defence companies" have a vested interest in
peacefully settling differences between themselves by means of arbitration. In
order to be competitive on the market, companies will have to co-operate via
contractual relations otherwise the higher price associated with conflict will
make the company uncompetitive and it will go under. Those companies that
ignore decisions made in arbitration would be outlawed by others, ostracised
and their rulings ignored. By this process, it is argued, a system of
competing "defence" companies will be stable and not turn into a civil war
between agencies with each enforcing the interests of their clients against
others by force.

However, there is a catch. Unlike every other market, the businesses in
competition in the "defence" industry **must** co-operate with its fellows in
order to provide its services for its customers. They need to be able to agree
to courts and judges, agree to abide by decisions and law codes and so forth.
In economics there are other, more accurate, terms to describe co-operative
activity between companies: collusion and cartels. Collusion and cartels is
where companies in a specific market agree to work together to restrict
competition and reap the benefits of monopoly power by working to achieve the
same ends in partnership with each other. In other words this means that
collusion is built into the system, with the necessary contractual relations
between agencies in the "protection" market requiring that firms co-operate
and, by so doing, to behave (effectively) as one large firm (and so,
effectively, resemble the state even more than they already do). Quoting Adam
Smith seems appropriate here: _"People of the same trade seldom meet together,
even for merriment and diversion, but the conversation ends in a conspiracy
against the public, or in some contrivance to raise prices."_ [**The Wealth of
Nations**, p. 117]

For example, when buying food it does not matter whether the supermarkets I
visit have good relations with each other. The goods I buy are independent of
the relationships that exist between competing companies. However, in the case
of private states, this is **not** the case. If a specific "defence" company
has bad relationships with other companies in the market then it is against my
self-interest to subscribe to it. Why join a private state if its judgements
are ignored by the others and it has to resort to violence to be heard? This,
as well as being potentially dangerous, will also push up the prices I have to
pay. Arbitration is one of the most important services a defence firm can
offer its customers and its market share is based upon being able to settle
interagency disputes without risk of war or uncertainty that the final outcome
will not be accepted by all parties.

Therefore, the market set-up within the "anarcho"-capitalist "defence" market
is such that private states **have to co-operate** with the others (or go out
of business fast) and this means collusion can take place. In other words, a
system of private states will have to agree to work together in order to
provide the service of "law enforcement" to their customers and the result of
such co-operation is to create a cartel. However, unlike cartels in other
industries, the "defence" cartel will be a stable body simply because its
members **have** to work with their competitors in order to survive.

Let us look at what would happen after such a cartel is formed in a specific
area and a new "defence company" desired to enter the market. This new company
will have to work with the members of the cartel in order to provide its
services to its customers (note that "anarcho"-capitalists already assume that
they _"will have to"_ subscribe to the same law code). If the new defence firm
tries to under-cut the cartel's monopoly prices, the other companies would
refuse to work with it. Having to face constant conflict or the possibility of
conflict, seeing its decisions being ignored by other agencies and being
uncertain what the results of a dispute would be, few would patronise the new
"defence company." The new company's prices would go up and so face either
folding or joining the cartel. Unlike every other market, if a "defence
company" does not have friendly, co-operative relations with other firms in
the same industry then it will go out of business.

This means that the firms that are co-operating have but to agree not to deal
with new firms which are attempting to undermine the cartel in order for them
to fail. A "cartel busting" firm goes out of business in the same way an
outlaw one does - the higher costs associated with having to solve all its
conflicts by force, not arbitration, increases its production costs much
higher than the competitors and the firm faces insurmountable difficulties
selling its products at a profit (ignoring any drop of demand due to fears of
conflict by actual and potential customers). Even if we assume that many
people will happily join the new firm in spite of the dangers to protect
themselves against the cartel and its taxation (i.e. monopoly profits), enough
will remain members of the cartel (perhaps they will be fired if they change,
perhaps they dislike change and think the extra money is worth peace, perhaps
they fear that by joining the new company their peace will be disrupted or the
outcomes of their problems with others too unsure to be worth it, perhaps they
are shareholders and want to maintain their income) so that co-operation will
still be needed and conflict unprofitable and dangerous (and as the cartel
will have more resources than the new firm, it could usually hold out longer
than the new firm could). In effect, breaking the cartel may take the form of
an armed revolution -- as it would with any state.

The forces that break up cartels and monopolies in other industries (such as
free entry -- although, of course the "defence" market will be subject to
oligopolistic tendencies as any other and this will create barriers to entry,
see section [C.4](secC4.html)) do not work here and so new firms have to co-
operate or loose market share and/or profits. This means that "defence
companies" will reap monopoly profits and, more importantly, have a monopoly
of force over a given area.

Hence a monopoly of private states will develop in addition to the existing
monopoly of law and this is a de facto monopoly of force over a given area
(i.e. some kind of public state run by share holders). New companies
attempting to enter the "defence" industry will have to work with the existing
cartel in order to provide the services it offers to its customers. The cartel
is in a dominant position and new entries into the market either become part
of it or fail. This is exactly the position with the state, with "private
agencies" free to operate as long as they work to the state's guidelines. As
with the monopolist "general libertarian law code", if you do not toe the
line, you go out of business fast.

It is also likely that a multitude of cartels would develop, with a given
cartel operating in a given locality. This is because law enforcement would be
localised in given areas as most crime occurs where the criminal lives. Few
criminals would live in New York and commit crimes in Portland. However, as
defence companies have to co-operate to provide their services, so would the
cartels. Few people live all their lives in one area and so firms from
different cartels would come into contact, so forming a cartel of cartels.

A cartel of cartels may (perhaps) be less powerful than a local cartel, but it
would still be required and for exactly the same reasons a local one is.
Therefore "anarcho"-capitalism would, like "actually existing capitalism," be
marked by a series of public states covering given areas, co-ordinated by
larger states at higher levels. Such a set up would parallel the United States
in many ways except it would be run directly by wealthy shareholders without
the sham of "democratic" elections. Moreover, as in the USA and other states
there will still be a monopoly of rules and laws (the "general libertarian law
code").

Some "anarcho"-capitalists claim that this will not occur, but that the co-
operation needed to provide the service of law enforcement will somehow
**not** turn into collusion between companies. However, they are quick to
argue that renegade "agencies" (for example, the so-called "Mafia problem" or
those who reject judgements) will go out of business because of the higher
costs associated with conflict and not arbitration. However, these higher
costs are ensured because the firms in question do not co-operate with others.
If other agencies boycott a firm but co-operate with all the others, then the
boycotted firm will be at the same disadvantage -- regardless of whether it is
a cartel buster or a renegade.

The "anarcho"-capitalist is trying to have it both ways. If the punishment of
non-conforming firms cannot occur, then "anarcho"-capitalism will turn into a
war of all against all or, at the very least, the service of social peace and
law enforcement cannot be provided. If firms cannot deter others from
disrupting the social peace (one service the firm provides) then
"anarcho"-capitalism is not stable and will not remain orderly as agencies
develop which favour the interests of their own customers and enforce their
own law codes at the expense of others. If collusion cannot occur (or is too
costly) then neither can the punishment of non-conforming firms and
"anarcho"-capitalism will prove to be unstable.

So, to sum up, the "defence" market of private states has powerful forces
within it to turn it into a monopoly of force over a given area. From a
privately chosen monopoly of force over a specific (privately owned) area, the
market of private states will turn into a monopoly of force over a general
area. This is due to the need for peaceful relations between companies,
relations which are required for a firm to secure market share. The unique
market forces that exist within this market ensure collusion and monopoly.

In other words, the system of private states will become a cartel and so a
public state - unaccountable to all but its shareholders, a state of the
wealthy, by the wealthy, for the wealthy. In other words, fascism.

## 6.4 Why are these "defence associations" states?

It is clear that "anarcho"-capitalist defence associations meet the criteria
of statehood outlined in section B.2 (["Why are anarchists against the
state"](secB2.html)). They defend property and preserve authority
relationships, they practice coercion, and are hierarchical institutions which
govern those under them on behalf of a "ruling elite," i.e. those who employ
both the governing forces and those they govern. Thus, from an anarchist
perspective, these "defence associations" as most definitely states.

What is interesting, however, is that by their own definitions a very good
case can be made that these "defence associations" as states in the
"anarcho"-capitalist sense too. Capitalist apologists usually define a
"government" (or state) as those who have a monopoly of force and coercion
within a given area. Relative to the rest of the society, these defence
associations would have a monopoly of force and coercion of a given piece of
property; thus, by the "anarcho"-capitalists' **own definition** of statehood,
these associations would qualify!

If we look at Rothbard's definition of statehood, which requires (a) the power
to tax and/or (b) a _"coerced monopoly of the provision of defence over a
given area"_, "anarcho"-capitalism runs into trouble.

In the first place, the costs of hiring defence associations will be deducted
from the wealth created by those who use, but do not own, the property of
capitalists and landlords. Let not forget that a capitalist will only employ a
worker or rent out land and housing if they make a profit from so doing.
Without the labour of the worker, there would be nothing to sell and no wages
to pay for rent. Thus a company's or landlord's "defence" firm will be paid
from the revenue gathered from the capitalists power to extract a tribute from
those who use, but do not own, a property. In other words, workers would pay
for the agencies that enforce their employers' authority over them via the
wage system and rent -- taxation in a more insidious form.

In the second, under capitalism most people spend a large part of their day on
other people's property -- that is, they work for capitalists and/or live in
rented accommodation. Hence if property owners select a "defence association"
to protect their factories, farms, rental housing, etc., their employees and
tenants will view it as a _"coerced monopoly of the provision of defence over
a given area."_ For certainly the employees and tenants will not be able to
hire their own defence companies to expropriate the capitalists and landlords.
So, from the standpoint of the employees and tenants, the owners do have a
monopoly of "defence" over the areas in question. Of course, the
"anarcho"-capitalist will argue that the tenants and workers "consent" to
**all** the rules and conditions of a contract when they sign it and so the
property owner's monopoly is not "coerced." However, the "consent" argument is
so weak in conditions of inequality as to be useless (see sections
[2.4](append132.html#secf24) and [3.1](append133.html#secf31), for example)
and, moreover, it can and has been used to justify the state. In other words,
"consent" in and of itself does not ensure that a given regime is not statist
(see section [2.3](append132.html#secf23) for more on this). So an argument
along these lines is deeply flawed and can be used to justify regimes which
are little better than "industrial feudalism" (such as, as indicated in
[section B.4](secB4.html), company towns, for example -- an institution which
right-libertarianism has no problem with). Even the _"general libertarian law
code,"_ could be considered a "monopoly of government over a particular area,"
particularly if ordinary people have no real means of affecting the law code,
either because it is market-driven and so is money-determined, or because it
will be "natural" law and so unchangeable by mere mortals.

In other words, **if** the state _"arrogates to itself a monopoly of force, of
ultimate decision-making power, over a given area territorial area"_
[Rothbard, **The Ethics of Liberty**, p. 170] then its pretty clear that the
property owner shares this power. The owner is, after all, the _"ultimate
decision-making power"_ in their workplace or on their land. If the boss takes
a dislike to you (for example, you do not follow their orders) then you get
fired. If you cannot get a job or rent the land without agreeing to certain
conditions (such as not joining a union or subscribing to the "defence firm"
approved by your employer) then you either sign the contract or look for
something else. Of course Rothbard fails to note that bosses have this
monopoly of power and is instead referring to _"prohibiting the voluntary
purchase and sale of defence and judicial services."_ [**Op. Cit.**, p. 171]
But just as surely as the law of contract allows the banning of unions from a
property, it can just as surely ban the sale and purchase of defence and
judicial services (it could be argued that market forces will stop this
happening, but this is unlikely as bosses usually have the advantage on the
labour market and workers have to compromise to get a job -- see section
[10.2](append1310.html#secf102) on why this is the case). After all, in the
company towns, only company money was legal tender and company police the only
law enforcers.

Therefore, it is obvious that the "anarcho"-capitalist system meets the
Weberian criteria of a monopoly to enforce certain rules in a given area of
land. The _"general libertarian law code"_ is a monopoly and property owners
determine the rules that apply to their property. Moreover, if the rules that
property owners enforce are subject to rules contained in the monopolistic
_"general libertarian law code"_ (for example, that they cannot ban the sale
and purchase of certain products -- such as defence -- on their own territory)
then "anarcho"-capitalism **definitely** meets the Weberian definition of the
state (as described by Ayn Rand as an institution _"that holds the exclusive
power to **enforce** certain rules of conduct in a given geographical area"_
[**Capitalism: The Unknown Ideal**, p. 239]) as its "law code" overrides the
desires of property owners to do what they like on their own property.

Therefore, no matter how you look at it, "anarcho"-capitalism and its
"defence" market promotes a _"monopoly of ultimate decision making power"_
over a _"given territorial area"_. It is obvious that for anarchists, the
"anarcho"-capitalist system is a state system. As, as we note, a reasonable
case can be made for it also being a state in "anarcho"-capitalist theory as
well.

So, in effect, "anarcho"-capitalism has a **different** sort of state, one in
which bosses hire and fire the policeman. As Peter Sabatini notes [in
**Libertarianism: Bogus Anarchy**], _"[w]ithin Libertarianism, Rothbard
represents a minority perspective that actually argues for the total
elimination of the state. However Rothbard's claim as an anarchist is quickly
voided when it is shown that he only wants an end to the public state. In its
place he allows countless private states, with each person supplying their own
police force, army, and law, or else purchasing these services from capitalist
vendors. . . Rothbard sees nothing at all wrong with the amassing of wealth,
therefore those with more capital will inevitably have greater coercive force
at their disposal, just as they do now."_

Far from wanting to abolish the state, then, "anarcho"-capitalists only desire
to privatise it - to make it solely accountable to capitalist wealth. Their
"companies" perform the same services as the state, for the same people, in
the same manner. However, there is one slight difference. Property owners
would be able to select between competing companies for their "services."
Because such "companies" are employed by the boss, they would be used to
reinforce the totalitarian nature of capitalist firms by ensuring that the
police and the law they enforce are not even slightly accountable to ordinary
people.

Looking beyond the "defence association" to the defence market itself (as we
argued in the [last section](append136.html#secf63)), this will become a
cartel and so become some kind of public state. The very nature of the private
state, its need to co-operate with others in the same industry, push it
towards a monopoly network of firms and so a monopoly of force over a given
area. Given the assumptions used to defend "anarcho"-capitalism, its system of
private statism will develop into public statism - a state run by managers
accountable only to the share-holding elite.

To quote Peter Marshall again, the "anarcho"-capitalists _"claim that all
would benefit from a free exchange on the market, it is by no means certain;
any unfettered market system would most likely sponsor a reversion to an
unequal society with defence associations perpetuating exploitation and
privilege."_ [**Demanding the Impossible**, p. 565] History, and current
practice, prove this point.

In short, "anarcho"-capitalists are not anarchists at all, they are just
capitalists who desire to see private states develop -- states which are
strictly accountable to their paymasters without even the sham of democracy we
have today. Hence a far better name for "anarcho"-capitalism would be
"private-state" capitalism. At least that way we get a fairer idea of what
they are trying to sell us. As Bob Black writes in **The Libertarian as
Conservative**, _"To my mind a right-wing anarchist is just a minarchist who'd
abolish the state to his own satisfaction by calling it something else. . . .
They don't denounce what the state does, they just object to who's doing it."_

## 6.5 What other effects would "free market" justice have?

Such a system would be dangerous simply because of the power it places in the
hands of companies. As Michael Taylor notes, _"whether the [protection] market
is competitive or not, it must be remembered that the product is a peculiar
one: when we buy cars or shoes or telephone services we do not give the firm
power based on force, but armed protection agencies, like the state, make
customers (their own and others') vulnerable, and having given them power we
cannot be sure that they will use it only for our protection."_ [**Community,
Anarchy and Liberty**, p. 65]

As we argued above, there are many reasons to believe that a "protection"
market will place most of society (bar the wealthy elite) in a "vulnerable"
position. One such reason is the assumptions of the "anarcho"-capitalists
themselves. As they note, capitalism is marked by an extreme division of
labour. Instead of everyone having all the skills they need, these skills are
distributed throughout society and all (so it is claimed) benefit.

This applies equally to the "defence" market. People subscribe to a "defence
firm" because they either cannot or do not want the labour of having to
protect their own property and person. The skills of defence, therefore, are
concentrated in these companies and so these firms will have an advantage in
terms of experience and mental state (they are trained to fight) as well as,
as seems likely, weaponry. This means that most normal people will be somewhat
at a disadvantage if a cartel of defence firms decides to act coercively. The
division of labour society will discourage the spread of skills required for
sustained warfare throughout society and so, perhaps, ensure that customers
remain "vulnerable." The price of liberty may be eternal vigilance, but are
most people willing to include eternal preparation of war as well? For modern
society, the answer seems to be no, they prefer to let others do that (namely
the state and its armed forces). And, we should note, an armed society may be
a polite one, but its politeness comes from fear, **not** mutual respect and
so totally phoney and soul destroying.

If we look at inequality within society, this may produce a ghettoisation
effect within "anarcho"-capitalism. As David Friedman notes, conflict between
defence firms is bad for business. Conflict costs money both in terms of
weaponry used and increased ("danger money") wages. For this reason he thinks
that peaceful co-operation will exist between firms. However, if we look at
poor areas with high crime rates then its clear that such an area will be a
dangerous place. In other words, it is very likely to be high in conflict. But
conflict increases costs, and so prices. Does this mean that those areas which
need police most will also have the highest prices for law enforcement? That
is the case with insurance now, so perhaps we will see whole areas turning
into Hobbesian anarchy simply because the high costs associated with dangerous
areas will make the effective demand for their services approach zero.

In a system based on "private statism," police and justice would be determined
by "free market" forces. As indicated in section [B.4.1](secB4.html#secb41),
right-libertarians maintain that one would have few rights on other peoples'
property, and so the owner's will would be the law (possibly restricted
somewhat by a "general libertarian law code", perhaps not -- see [last
section](append136.html#secf64)). In this situation, those who could not
afford police protection would become victims of roving bandits and rampant
crime, resulting in a society where the wealthy are securely protected in
their bastions by their own armed forces, with a bunch of poor crowded around
them for protection. This would be very similar to feudal Europe.

The competing police forces would also be attempting to execute the laws of
their sponsors in areas that may not be theirs to begin with, which would lead
to conflicts unless everyone agreed to follow a "general libertarian law code"
(as Rothbard, for one, wants). If there were competing law codes, the problem
of whose "laws" to select and enforce would arise, with each of the wealthy
security sponsors desiring that their law control all of the land. And, as
noted earlier, if there were **one** "libertarian law code," this would be a
_"monopoly of government"_ over a given area, and therefore statist.

In addition, it should be noted that the right-libertarian claim that under
their system anarchistic associations would be allowed as long as they are
formed voluntarily just reflects their usual vacuous concept of freedom. This
is because such associations would exist within and be subject to the "general
libertarian law code" of "anarcho"-capitalist society. These laws would
reflect and protect the interests and power of those with capitalist property,
meaning that unless these owners agree, trying to live an anarchist life would
be nearly impossible (its all fine and well to say that those with property
can do what they like, if you do not have property then experimentation could
prove difficult -- not to mention, of course, few areas are completely self-
sufficient meaning that anarchistic associations will be subject to market
forces, market forces which stress and reward the opposite of the values these
communes were set up to create). Thus we must **buy** the right to be free!

If, as anarchists desire, most people refuse to recognise or defend the rights
of private property and freely associate accordingly to organise their own
lives and ignore their bosses, this would still be classed as "initiation of
force" under "anarcho"-capitalism, and thus repressed. In other words, like
any authoritarian system, the "rules" within "anarcho"-capitalism do not
evolve with society and its changing concepts (this can be seen from the
popularity of "natural law" with right-libertarians, the authoritarian nature
of which is discussed in [section 11](append1311.html)).

Therefore, in "anarcho"-capitalism you are free to follow the (capitalist)
laws and to act within the limits of these laws. It is only within this
context that you can experiment (if you can afford to). If you act outside
these laws, then you will be subject to coercion. The amount of coercion
required to prevent such actions depends on how willing people are to respect
the laws. Hence it is not the case that an "anarcho"-capitalist society is
particularly conducive to social experimentation and free evolution, as its
advocates like to claim. Indeed, the opposite may be the case, as any
capitalist system will have vast differences of wealth and power within it,
thus ensuring that the ability to experiment is limited to those who can
afford it. As Jonathan Wolff points out, the _"image of people freely moving
from one utopia to another until they find their heaven, ignores the thought
that certain choices may be irreversible. . . This thought may lead to
speculation about whether a law of evolution would apply to the plural
utopias. Perhaps, in the long run, we may find the framework regulated by the
law of survival of the economically most fit, and so we would expect to see a
development not of diversity but of homogeneity. Those communities with great
market power would eventually soak up all but the most resistant of those
communities around them."_ [**Robert Nozick: Property, Justice and the Minimal
State**, p. 135]

And if the initial distribution of resources is similar to that already
existing then the _"economically most fit"_ will be capitalistic (as argued in
section [J.5.12](secJ5.html#secj512), the capitalist market actively selects
against co-operatives even though they are more productive). Given the head
start provided by statism, it seems likely that explicitly capitalist utopia's
would remain the dominant type (particularly as the rights framework is such
as to protect capitalist property rights). Moreover, we doubt that most
"anarcho"-capitalists would embrace the ideology if it was more than likely
that non-capitalist utopias would overcome the capitalist ones (after all,
they **are** self-proclaimed capitalists).

So, given that "anarcho"-capitalists who follow Murray Rothbard's ideas and
minimal-statist right-libertarians agree that **all** must follow the basic
_"general libertarian law code"_ which defends capitalist property rights, we
can safely say that the economically _"most fit"_ would be capitalist ones.
Hardly surprising if the law code reflects capitalist ideas of right and
wrong. In addition, as George Reitzer has argued (see **The McDonaldization of
Society**), capitalism is driven towards standardisation and conformity by its
own logic. This suggests that plurality of communities would soon be replaced
by a series of "communities" which share the same features of hierarchy and
ruling elites. ("Anarcho"-capitalists who follow David Friedman's ideas
consider it possible, perhaps likely, that a free market in laws will result
in one standard law code and so this also applies to that school as well)

So, in the end, the "anarcho" capitalists argue that in their system you are
free to follow the (capitalist) law and work in the (capitalist) economy, and
if you are lucky, take part in a "commune" as a collective capitalist. How
**very** generous of them! Of course, any attempt to change said rules or
economy are illegal and would be stopped by private states.

As well as indicating the falsity of "anarcho"-capitalist claims to support
"experimentation," this discussion has also indicated that coercion would not
be absent from "anarcho"-capitalism. This would be the case only if everyone
voluntarily respected private property rights and abided by the law (i.e.
acted in a capitalist-approved way). As long as you follow the law, you will
be fine -- which is exactly the same as under public statism. Moreover, if the
citizens of a society do not want a capitalist order, it may require a lot of
coercion to impose it. This can be seen from the experiences of the Italian
factory occupations in 1920 (see section [A.5.5](secA5.html#seca55)), in which
workers refused to accept capitalist property or authority as valid and
ignored it. In response to this change of thought within a large part of
society, the capitalists backed fascism in order to stop the evolutionary
process within society.

The socialist economic historian Maurice Dobbs, after reviewing the private
armies in 1920s and 1930s America made much the same point:

> _"When business policy takes the step of financing and arming a mass
political movement to capture the machinery of government, to outlaw opposing
forms of organisation and suppress hostile opinions we have merely a further
and more logical stage beyond [private armies]"_ [**Op, Cit.**, p. 357]

(Noted Austrian Economist Ludwig von Mises whose extreme free market liberal
political and economic ideas inspired right-libertarianism in many ways had
this to say about fascism: _"It cannot be denied that Fascism and similar
movements aiming at the establishment of dictatorships are full of the best
intentions and that their intervention has, for the moment, saved European
civilisation. The merit that Fascism has thereby won for itself will live
eternally in history."_ [**Liberalism**, p. 51])

This example illustrates the fact that capitalism **per se** is essentially
authoritarian, because it is necessarily based on coercion and hierarchy,
which explains why capitalists have resorted to the most extreme forms of
authoritarianism -- including totalitarian dictatorship -- during crises that
threatened the fundamental rules of the system itself. There is no reason to
think that "anarcho"-capitalism would be any different.

Since "anarcho"-capitalism, with its private states, does not actually want to
get rid of hierarchical forms of authority, the need for one government to
unify the enforcement activities of the various defence companies becomes
apparent. In the end, that is what "anarcho"-capitalism recognises with its
"general libertarian law code" (based either on market forces or "natural
law"). Thus it appears that one government/hierarchy over a given territory is
inevitable under any form of capitalism. That being the case, it is obvious
that a democratic form of statism, with its checks and balances, is preferable
to a dictatorship that imposes "absolute" property rights and so "absolute"
power.

Of course, we do have another option than either private or public statism.
This is anarchism, the end of hierarchical authority and its replacement by
the "natural" authority of communal and workplace self-management.

[‹ 5 Will privatising "the commons" increase liberty?](/afaq/append135.html
"Go to previous page" ) [up](/afaq/append13.html "Go to parent page" ) [7 How
does the history of "anarcho"-capitalism show that it is not anarchist?
›](/afaq/append137.html "Go to next page" )

