# B.7 What classes exist within modern society?

For anarchists, class analysis is an important means of understanding the
world and what is going on in it. While recognition of the fact that classes
actually exist is less prevalent now than it once was, this does not mean that
classes have ceased to exist. Quite the contrary. As we'll see, it means only
that the ruling class has been more successful than before in obscuring the
existence of class.

Class can be objectively defined: the relationship between an individual and
the sources of power within society determines his or her class. We live in a
class society in which a few people possess far more political and economic
power than the majority, who usually work for the minority that controls them
and the decisions that affect them. This means that class is based both on
exploitation **and** oppression, with some controlling the labour of others
for their own gain. The means of oppression have been indicated in earlier
parts of [section B](secBcon.html), while section C ([What are the myths of
capitalist economics?](secCcon.html)) indicates exactly how exploitation
occurs within a society apparently based on free and equal exchange. In
addition, it also highlights the effects on the economic system itself of this
exploitation. The social and political impact of the system and the classes
and hierarchies it creates is discussed in depth in section D ([How do statism
and capitalism affect society?](secDcon.html)).

We must emphasise at the outset that the idea of the "working class" as
composed of nothing but industrial workers is simply false. It is **not**
applicable today, if it ever was. Power, in terms of hire/fire and investment
decisions, is the important thing. Ownership of capital as a means of
determining a person's class, while still important, does not tell the whole
story. An obvious example is that of the higher layers of management within
corporations. They have massive power within the company, basically taking
over the role held by the actual capitalist in smaller firms. While they may
technically be "salary slaves" their power and position in the social
hierarchy indicate that they are members of the ruling class in practice (and,
consequently, their income is best thought of as a share of profits rather
than a wage). Much the same can be said of politicians and state bureaucrats
whose power and influence does not derive from the ownership of the means of
production but rather then control over the means of coercion. Moreover, many
large companies are owned by other large companies, through pension funds,
multinationals, etc. (in 1945, 93% of shares were owned by individuals; by
1997, this had fallen to 43%). Needless to say, if working-class people own
shares that does not make them capitalists as the dividends are **not** enough
to live on nor do they give them any say in how a company is run).

For most anarchists, there are two main classes:

(1) _**Working class**_ \-- those who have to work for a living but have no
real control over that work or other major decisions that affect them, i.e.
order-takers. This class also includes the unemployed, pensioners, etc., who
have to survive on handouts from the state. They have little wealth and little
(official) power. This class includes the growing service worker sector, most
(if not the vast majority) of "white collar" workers as well as traditional
"blue collar" workers. Most self-employed people would be included in this
class, as would the bulk of peasants and artisans (where applicable). In a
nutshell, the producing classes and those who either were producers or will be
producers. This group makes up the vast majority of the population.

(2) _**Ruling class**_ \-- those who control investment decisions, determine
high level policy, set the agenda for capital and state. This is the elite at
the top, owners or top managers of large companies, multinationals and banks
(i.e., the capitalists), owners of large amounts of land (i.e. landlords or
the aristocracy, if applicable), top-level state officials, politicians, and
so forth. They have real power within the economy and/or state, and so control
society. In a nutshell, the owners of power (whether political, social or
economic) or the master class. This group consists of around the top 5-15% of
the population.

Obviously there are "grey" areas in any society, individuals and groups who do
not fit exactly into either the working or ruling class. Such people include
those who work but have some control over other people, e.g. power of
hire/fire. These are the people who make the minor, day-to-day decisions
concerning the running of capital or state. This area includes lower to middle
management, professionals, and small capitalists.

There is some argument within the anarchist movement whether this "grey" area
constitutes another ("middle") class or not. Most anarchists say no, most of
this "grey" area are working class, others (such as the British **Class War
Federation**) argue it is a different class. One thing is sure, all anarchists
agree that most people in this "grey" area have an interest in getting rid of
the current system just as much as the working class (we should point out here
that what is usually called "middle class" in the USA and elsewhere is nothing
of the kind, and usually refers to working class people with decent jobs,
homes, etc. As class is considered a rude word in polite society in the USA,
such mystification is to be expected).

So, there will be exceptions to this classification scheme. However, most of
society share common interests, as they face the economic uncertainties and
hierarchical nature of capitalism.

We do not aim to fit all of reality into this class scheme, but only to
develop it as reality indicates, based on our own experiences of the changing
patterns of modern society. Nor is this scheme intended to suggest that all
members of a class have identical interests or that competition does not exist
between members of the same class, as it does between the classes. Capitalism,
by its very nature, is a competitive system. As Malatesta pointed out, _"one
must bear in mind that on the one hand the bourgeoisie (the property owners)
are always at war amongst themselves. . . and that on the other hand the
government, though springing from the bourgeoisie and its servant and
protector, tends, as every servant and every protector, to achieve its own
emancipation and to dominate whoever it protects. Thus the game of the swings,
the manoeuvres, the concessions and the withdrawals, the attempts to find
allies among the people and against the conservatives, and among conservatives
against the people, which is the science of the governors, and which blinds
the ingenuous and phlegmatic who always wait for salvation to come down to
them from above."_ [**Anarchy**, p. 25]

However, no matter how much inter-elite rivalry goes on, at the slightest
threat to the system from which they benefit, the ruling class will unite to
defend their common interests. Once the threat passes, they will return to
competing among themselves for power, market share and wealth. Unfortunately,
the working class rarely unites as a class, mainly due to its chronic economic
and social position. At best, certain sections unite and experience the
benefits and pleasure of co-operation. Anarchists, by their ideas and action
try to change this situation and encourage solidarity within the working class
in order to resist, and ultimately get rid of, capitalism. However, their
activity is helped by the fact that those in struggle often realise that
_"solidarity is strength"_ and so start to work together and unite their
struggles against their common enemy. Indeed, history is full of such
developments.

## B.7.1 But do classes actually exist?

So do classes actually exist, or are anarchists making them up? The fact that
we even need to consider this question points to the pervasive propaganda
efforts by the ruling class to suppress class consciousness, which will be
discussed further on. First, however, let's examine some statistics, taking
the USA as an example. We have done so because the state has the reputation of
being a land of opportunity and capitalism. Moreover, class is seldom talked
about there (although its business class is **very** class conscious).
Moreover, when countries have followed the US model of freer capitalism (for
example, the UK), a similar explosion of inequality develops along side
increased poverty rates and concentration of wealth into fewer and fewer
hands.

There are two ways of looking into class, by income and by wealth. Of the two,
the distribution of wealth is the most important to understanding the class
structure as this represents your assets, what you own rather than what you
earn in a year. Given that wealth is the source of income, this represents the
impact and power of private property and the class system it represents. After
all, while all employed workers have an income (i.e. a wage), their actual
wealth usually amounts to their personal items and their house (if they are
lucky). As such, their wealth generates little or no income, unlike the owners
of resources like companies, land and patents. Unsurprisingly, wealth
insulates its holders from personal economic crises, like unemployment and
sickness, as well as gives its holders social and political power. It, and its
perks, can also be passed down the generations. Equally unsurprisingly, the
distribution of wealth is much more unequal than the distribution of income.

At the start of the 1990s, the share of total US income was as follows: one
third went to the top 10% of the population, the next 30% gets another third
and the bottom 60% gets the last third. Dividing the wealth into thirds, we
find that the top 1% owns a third, the next 9% owns a third, and bottom 90%
owns the rest. [David Schweickart, **After Capitalism**, p. 92] Over the
1990s, the inequalities in US society have continued to increase. In 1980, the
richest fifth of Americans had incomes about ten times those of the poorest
fifth. A decade later, they has twelve times. By 2001, they had incomes over
fourteen times greater. [Doug Henwood, **After the New Economy**, p. 79]
Looking at the figures for private family wealth, we find that in 1976 the
wealthiest one percent of Americans owned 19% of it, the next 9% owned 30% and
the bottom 90% of the population owned 51%. By 1995 the top 1% owned 40%, more
than owned by the bottom 92% of the US population combined -- the next 9% had
31% while the bottom 90% had only 29% of total (see Edward N. Wolff, **Top
Heavy: A Study of Increasing Inequality in America** for details).

So in terms of wealth ownership, we see a system in which a very small
minority own the means of life. In 1992 the richest 1% of households -- about
2 million adults -- owned 39% of the stock owned by individuals. The top 10%,
owned over 81%. In other words, the bottom 90% of the population had a smaller
share (23%) of investable capital of all kinds than the richest 1/2% (29%).
Stock ownership was even more densely concentrated, with the richest 5%
holding 95% of all shares. [Doug Henwood, **Wall Street: Class racket**] Three
years later, _"the richest 1% of households . . . owned 42% of the stock owned
by individuals, and 56% of the bonds . . . the top 10% together owned nearly
90% of both."_ Given that around 50% of all corporate stock is owned by
households, this means that 1% of the population _"owns a quarter of the
productive capital and future profits of corporate America; the top 10% nearly
half."_ [Doug Henwood, **Wall Street**, pp. 66-7] Unsurprisingly, the
Congressional Budget Office estimates that more than half of corporate profits
ultimately accrue to the wealthiest 1 percent of taxpayers, while only about 8
percent go to the bottom 60 percent.

Henwood summarises the situation by noting that _"the richest tenth of the
population has a bit over three-quarters of all the wealth in this society,
and the bottom half has almost none -- but it has lots of debt."_ Most middle-
income people have most of their (limited) wealth in their homes and if we
look at non-residential wealth we find a _"very, very concentrated"_
situation. The _"bottom half of the population claimed about 20% of all income
in 2001 -- but only 2% of non-residential wealth. The richest 5% of the
population claimed about 23% of income, a bit more than the entire bottom
half. But it owned almost two-thirds -- 65% -- of the wealth."_ [**After the
New Economy**, p. 122]

In terms of income, the period since 1970 has also been marked by increasing
inequalities and concentration:

> _ "According to estimates by the economists Thomas Piketty and Emmanuel Saez
-- confirmed by data from the Congressional Budget Office -- between 1973 and
2000 the average real income of the bottom 90 percent of American taxpayers
actually fell by 7 percent. Meanwhile, the income of the top 1 percent rose by
148 percent, the income of the top 0.1 percent rose by 343 percent and the
income of the top 0.01 percent rose 599 percent."_ [Paul Krugman, _"The Death
of Horatio Alger"_, **The Nation**, January 5, 2004]

Doug Henwood provides some more details on income [**Op. Cit.**, p. 90]:

**Changes in income, 1977-1999**   | real income growth   
1977-99 | Share of total income  
---|---|---  
  | 1977 | 1999 | Change  
poorest 20% | -9% | 5.7% | 4.2% | -1.5%  
second 20% | +1 | 11.5 | 9.7 | -1.8  
middle 20% | +8 | 16.4 | 14.7 | -1.7  
fourth 20% | +14 | 22.8 | 21.3 | -1.5  
top 20% | +43 | 44.2 | 50.4 | +6.2  
top 1% | +115 | 7.3 | 12.9 | +5.6  
  
By far the biggest gainers from the wealth concentration since the 1980s have
been the super-rich. The closer you get to the top, the bigger the gains. In
other words, it is not simply that the top 20 percent of families have had
bigger percentage gains than the rest. Rather, the top 5 percent have done
better than the next 15, the top 1 percent better than the next 4 per cent,
and so on.

As such, if someone argues that while the share of national income going to
the top 10 percent of earners has increased that it does not matter because
anyone with an income over $81,000 is in that top 10 percent they are missing
the point. The lower end of the top ten per cent were not the big winners over
the last 30 years. Most of the gains in the share in that top ten percent went
to the top 1 percent (who earn at least $230,000). Of these gains, 60 percent
went to the top 0.1 percent (who earn more than $790,000). And of these gains,
almost half went to the top 0.01 percent (a mere 13,000 people who had an
income of at least $3.6 million and an average income of $17 million). [Paul
Krugman, _"For Richer"_, **New York Times**, 20/10/02]

All this proves that classes do in fact exist, with wealth and power
concentrating at the top of society, in the hands of the few.

To put this inequality of income into some perspective, the average full-time
Wal-Mart employee was paid only about $17,000 a year in 2004. Benefits are
few, with less than half the company's workers covered by its health care
plan. In the same year Wal-Mart's chief executive, Scott Lee Jr., was paid
$17.5 million. In other words, every two weeks he was paid about as much as
his average employee would earn after a lifetime working for him.

Since the 1970s, most Americans have had only modest salary increases (if
that). The average annual salary in America, expressed in 1998 dollars (i.e.,
adjusted for inflation) went from $32,522 in 1970 to $35,864 in 1999. That is
a mere 10 percent increase over nearly 30 years. Over the same period,
however, according to Fortune magazine, the average real annual compensation
of the top 100 C.E.O.'s went from $1.3 million -- 39 times the pay of an
average worker -- to $37.5 million, more than 1,000 times the pay of ordinary
workers.

Yet even here, we are likely to miss the real picture. The average salary is
misleading as this does not reflect the distribution of wealth. For example,
in the UK in the early 1990s, two-thirds of workers earned the average wage or
below and only a third above. To talk about the "average" income, therefore,
is to disguise remarkable variation. In the US, adjusting for inflation,
average family income -- total income divided by the number of families --
grew 28% between 1979 and 1997. The median family income -- the income of a
family in the middle (i.e. the income where half of families earn more and
half less) grew by only 10%. The median is a better indicator of how typical
American families are doing as the distribution of income is so top heavy in
the USA (i.e. the average income is considerably higher than the median). It
should also be noted that the incomes of the bottom fifth of families actually
fell slightly. In other words, the benefits of economic growth over nearly two
decades have **not** trickled down to ordinary families. Median family income
has risen only about 0.5% per year. Even worse, _"just about all of that
increase was due to wives working longer hours, with little or no gain in real
wages."_ [Paul Krugman, _"For Richer"_, **Op. Cit.**]

So if America does have higher average or per capita income than other
advanced countries, it is simply because the rich are richer. This means that
a high average income level can be misleading if a large amount of national
income is concentrated in relatively few hands. This means that large numbers
of Americans are worse off economically than their counterparts in other
advanced countries. Thus Europeans have, in general, shorter working weeks and
longer holidays than Americans. They may have a lower average income than the
United States but they do not have the same inequalities. This means that the
median European family has a standard of living roughly comparable with that
of the median U.S. family -- wages may even be higher.

As Doug Henwood notes, _"[i]nternational measures put the United States in a
disgraceful light. . . The soundbite version of the LIS [Luxembourg Income
Study] data is this: for a country th[at] rich, [it] ha[s] a lot of poor
people."_ Henwood looked at both relative and absolute measures of income and
poverty using the cross-border comparisons of income distribution provided by
the LIS and discovered that _"[f]or a country that thinks itself universally
middle class [i.e. middle income], the United States has the second-smallest
middle class of the nineteen countries for which good LIS data exists."_ Only
Russia, a country in near-total collapse was worse (40.9% of the population
were middle income compared to 46.2% in the USA. Households were classed as
poor if their incomes were under 50 percent of the national medium; near-poor,
between 50 and 62.5 percent; middle, between 62.5 and 150 percent; and well-
to-do, over 150 percent. The USA rates for poor (19.1%), near-poor (8.1%) and
middle (46.2%) were worse than European countries like Germany (11.1%, 6.5%
and 64%), France (13%, 7.2% and 60.4%) and Belgium (5.5%, 8.0% and 72.4%) as
well as Canada (11.6%, 8.2% and 60%) and Australia (14.8%, 10% and 52.5%).

The reasons for this? Henwood states that the _"reasons are clear -- weak
unions and a weak welfare state. The social-democratic states -- the ones that
interfere most with market incomes -- have the largest [middles classes]. The
US poverty rate is nearly twice the average of the other eighteen."_ Needless
to say, "middle class" as defined by income is a very blunt term (as Henwood
states). It says nothing about property ownership or social power, for
example, but income is often taken in the capitalist press as the defining
aspect of "class" and so is useful to analyse in order to refute the claims
that the free-market promotes general well-being (i.e. a larger "middle
class"). That the most free-market nation has the worse poverty rates **and**
the smallest "middle class" indicates well the anarchist claim that
capitalism, left to its own devices, will benefit the strong (the ruling
class) over the weak (the working class) via "free exchanges" on the "free"
market (as we argue in [section C.7](secC7.html), only during periods of full
employment -- and/or wide scale working class solidarity and militancy -- does
the balance of forces change in favour of working class people. Little wonder,
then, that periods of full employment also see falling inequality -- see James
K. Galbraith's **Created Unequal** for more details on the correlation of
unemployment and inequality).

Of course, it could be objected that this relative measure of poverty and
income ignores the fact that US incomes are among the highest in the world,
meaning that the US poor may be pretty well off by foreign standards. Henwood
refutes this claim, noting that _"even on absolute measures, the US
performance is embarrassing. LIS researcher Lane Kenworthy estimated poverty
rates for fifteen countries using the US poverty line as the benchmark. . .
Though the United States has the highest average income, it's far from having
the lowest poverty rate."_ Only Italy, Britain and Australia had higher levels
of absolute poverty (and Australia exceeded the US value by 0.2%, 11.9%
compared to 11.7%). Thus, in both absolute **and** relative terms, the USA
compares badly with European countries. [Doug Henwood, _"Booming, Borrowing,
and Consuming: The US Economy in 1999"_, pp.120-33, **Monthly Review**, vol.
51, no. 3, pp. 129-31]

In summary, therefore, taking the USA as being the most capitalist nation in
the developed world, we discover a class system in which a very small minority
own the bulk of the means of life and get most of the income. Compared to
other Western countries, the class inequalities are greater and the society is
more polarised. Moreover, over the last 20-30 years those inequalities have
increased spectacularly. The ruling elite have become richer and wealth has
flooded upwards rather than trickled down.

The cause of the increase in wealth and income polarisation is not hard to
find. It is due to the increased economic and political power of the
capitalist class and the weakened position of working class people. As
anarchists have long argued, any "free contract" between the powerful and the
powerless will benefit the former far more than the latter. This means that if
the working class's economic and social power is weakened then we will be in a
bad position to retain a given share of the wealth we produce but is owned by
our bosses and accumulates in the hands of the few.

Unsurprisingly, therefore, there has been an increase in the share of total
income going to capital (i.e., interest, dividends, and rent) and a decrease
in the amount going to labour (wages, salaries, and benefits). Moreover, an
increasing part of the share to labour is accruing to high-level management
(in electronics, for example, top executives used to paid themselves 42 times
the average worker in 1991, a mere 5 years later it was 220 times as much).

Since the start of the 1980s, unemployment and globalisation has weakened the
economic and social power of the working class. Due to the decline in the
unions and general labour militancy, wages at the bottom have stagnated (real
pay for most US workers is lower in 2005 than it was in 1973!). This, combined
with "trickle-down" economic policies of tax cuts for the wealthy, tax raises
for the working classes, the maintaining of a "natural" law of unemployment
(which weakens unions and workers power) and cutbacks in social programs, has
seriously eroded living standards for all but the upper strata -- a process
that is clearly leading toward social breakdown, with effects that will be
discussed later (see [section D.9](secD9.html)).

Little wonder Proudhon argued that the law of supply and demand was a
_"deceitful law . . . suitable only for assuring the victory of the strong
over the weak, of those who own property over those who own nothing."_ [quoted
by Alan Ritter, **The Political Thought of Pierre-Joseph Proudhon**, p. 121]

## B.7.2 Does social mobility make up for class inequality?

Faced with the massive differences between classes under capitalism we
highlighted in the [last section](secB7.html#secb71), many supporters of
capitalism still deny the obvious. They do so by confusing a **caste** system
with a **class** system. In a caste system, those born into it stay in it all
their lives. In a class system, the membership of classes can and does change
over time.

Therefore, it is claimed, what is important is not the existence of classes
but of social mobility (usually reflected in income mobility). According to
this argument, if there is a high level of social/income mobility then the
degree of inequality in any given year is unimportant. This is because the
redistribution of income over a person's life time would be very even. Thus
the inequalities of income and wealth of capitalism does not matter as
capitalism has high social mobility.

Milton Friedman puts the argument in this way:

> _"Consider two societies that have the same distribution of annual income.
In one there is a great mobility and change so that the position of particular
families in the income hierarchy varies widely from year to year. In the
other, there is great rigidity so that each family stays in the same position.
Clearly, in any meaningful sense, the second would be the more unequal
society. The one kind of inequality is a sign of dynamic change, social
mobility, equality of opportunity; the other of a status society. The
confusion behind these two kinds of inequality is particularly important,
precisely because competitive free-enterprise capitalism tends to substitute
the one for the other."_ [**Capitalism and Freedom**, p. 171]

As with so many things, Friedman is wrong in his assertion (and that is all it
is, no evidence is provided). The more free market capitalist regimes have
**less** social mobility than those, like Western Europe, which have extensive
social intervention in the economy. As an added irony, the facts suggest that
implementing Friedman's suggested policies in favour of his beloved
"competitive free-enterprise capitalism" has made social mobility less, not
greater. In effect, as with so many things, Friedman ensured the refutation of
his own dogmas.

Taking the USA as an example (usually considered one of the most capitalist
countries in the world) there is income mobility, but not enough to make
income inequality irrelevant. Census data show that 81.6 percent of those
families who were in the bottom quintile of the income distribution in 1985
were still there in the next year; for the top quintile, it was 76.3 percent.

Over longer time periods, there is more mixing but still not that much and
those who do slip into different quintiles are typically at the borders of
their category (e.g. those dropping out of the top quintile are typically at
the bottom of that group). Only around 5% of families rise from bottom to top,
or fall from top to bottom. In other words, the class structure of a modern
capitalist society is pretty solid and _"much of the movement up and down
represents fluctuations around a fairly fixed long term distribution."_ [Paul
Krugman, **Peddling Prosperity**, p. 143]

Perhaps under a "pure" capitalist system things would be different? Ronald
Reagan helped make capitalism more "free market" in the 1980s, but there is no
indication that income mobility increased significantly during that time. In
fact, according to one study by Greg Duncan of the University of Michigan, the
middle class shrank during the 1980s, with fewer poor families moving up or
rich families moving down. Duncan compared two periods. During the first
period (1975 to 1980) incomes were more equal than they are today. In the
second (1981 to 1985) income inequality began soaring. In this period there
was a reduction in income mobility upward from low to medium incomes of over
10%.

Here are the exact figures [cited by Paul Krugman, _"The Rich, the Right, and
the Facts,"_ **The American Prospect** no. 11, Fall 1992, pp. 19-31]:

** Percentages of families making transitions to and from middle class (5-year period before and after 1980) **

Transition | Before 1980 | After 1980  
---|---|---  
Middle income to low income | 8.5 | 9.8  
Middle income to high income | 5.8 | 6.8  
Low income to middle income | 35.1 | 24.6  
High income to middle income | 30.8 | 27.6  
  
Writing in 2004, Krugman returned to this subject. The intervening twelve
years had made things worse. America, he notes, is _"more of a caste society
than we like to think. And the caste lines have lately become a lot more
rigid."_ Before the rise of neo-liberalism in the 1980s, America had more
intergenerational mobility. _"A classic 1978 survey found that among adult men
whose fathers were in the bottom 25 percent of the population as ranked by
social and economic status, 23 percent had made it into the top 25 percent. In
other words, during the first thirty years or so after World War II, the
American dream of upward mobility was a real experience for many people."_
However, a new survey of today's adult men _"finds that this number has
dropped to only 10 percent. That is, over the past generation upward mobility
has fallen drastically. Very few children of the lower class are making their
way to even moderate affluence. This goes along with other studies indicating
that rags-to-riches stories have become vanishingly rare, and that the
correlation between fathers' and sons' incomes has risen in recent decades. In
modern America, it seems, you're quite likely to stay in the social and
economic class into which you were born."_ [Paul Krugman, _"The Death of
Horatio Alger"_, **The Nation**, January 5, 2004]

British Keynesian economist Will Hutton quotes US data from 2000-1 which
_"compare[s] the mobility of workers in America with the four biggest European
economies and three Nordic economies."_ The US _"has the lowest share of
workers moving from the bottom fifth of workers into the second fifth, the
lowest share moving into the top 60 per cent and the highest share unable to
sustain full-time employment."_ He cites an OECD study which _"confirms the
poor rates of relative upward mobility for very low-paid American workers; it
also found that full-time workers in Britain, Italy and Germany enjoy much
more rapid growth in their earnings than those in the US . . . However,
downward mobility was more marked in the US; American workers are more likely
to suffer a reduction in their real earnings than workers in Europe."_ Thus
even the OECD (the _"high priest of deregulation"_) was _"forced to conclude
that countries with more deregulated labour and product markets (pre-eminently
the US) do not appear to have higher relative mobility, nor do low-paid
workers in these economies experience more upward mobility. The OECD is
pulling its punches. The US experience is worse than Europe's."_ Numerous
studies have shown that _"either there is no difference"_ in income mobility
between the USA and Europe _"or that there is less mobility in the US."_
[**The World We're In**, pp. 166-7]

Little wonder, then, that Doug Henwood argues that _"the final appeal of
apologists of the American way is an appeal to our legendary mobility"_ fails.
In fact, _"people generally don't move far from the income class they are born
into, and there is little difference between US and European mobility
patterns. In fact, the United States has the largest share of what the OECD
called 'low-wage' workers, and the poorest performance on the emergence from
the wage cellar of any country it studied." _[**Op. Cit.**, p. 130]

Indeed, _"both the US and British poor were more likely to stay poor for a
long period of time: almost half of all people who were poor for one year
stayed poor for five or more years, compared with 30% in Canada and 36% in
Germany. And, despite claims of great upward mobility in the US, 45% of the
poor rose out of poverty in a given year, compared with 45% in the UK, 53% in
Germany, and 56% in Canada. And of those who did exit poverty, 15% of
Americans were likely to make a round trip back under the poverty line,
compared with 16% in Germany, 10% in the UK, and 7% in Canada."_ [Doug
Henwood, **After the New Economy**, pp. 136-7]

A 2005 study of income mobility by researchers at the London School of
Economics (on behalf of the educational charity the Sutton Trust) confirms
that the more free market a country, the worse is its levels of social
mobility. [Jo Blanden, Paul Gregg and Stephen Machin, **Intergenerational
Mobility in Europe and North America**, April, 2005] They found that Britain
has one of the worst records for social mobility in the developed world,
beaten only by the USA out of eight European and North American countries.
Norway was the best followed by Denmark, Sweden, Finland, Germany and Canada.

This means that children born to poor families in Britain and the USA are less
likely to fulfil their full potential than in other countries and are less
likely to break free of their backgrounds than in the past. In other words, we
find it harder to earn more money and get better jobs than our parents.
Moreover, not only is social mobility in Britain much lower than in other
advanced countries, it is actually declining and has fallen markedly over
time. The findings were based on studies of two groups of children, one set
born in the 1950s and the other in the 1970s. In the UK, while 17 per cent of
the former made it from the bottom quarter income group to the top, only 11
per cent of the latter did so. Mobility in the Nordic countries was twice that
of the UK. While only the US did worse than the UK in social mobility

The puzzle of why, given that there is no evidence of American exceptionalism
or higher social mobility, the myth persists has an easy solution. It has
utility for the ruling class in maintaining the system. By promoting the myth
that people can find the path to the top easy then the institutions of power
will not be questioned, just the moral character of the many who do not.

Needless to say, income mobility does not tell the whole story. Increases in
income do not automatically reflect changes in class, far from it. A better
paid worker is still working class and, consequently, still subject to
oppression and exploitation during working hours. As such, income mobility,
while important, does not address inequalities in power. Similarly, income
mobility does not make up for a class system and its resulting authoritarian
social relationships and inequalities in terms of liberty, health and social
influence. And the facts suggest that the capitalist dogma of "meritocracy"
that attempts to justify this system has little basis in reality. Capitalism
is a class ridden system and while there is some changes in the make-up of
each class they are remarkably fixed, particularly once you get to the top
5-10% of the population (i.e. the ruling class).

Logically, this is not surprising. There is no reason to think that more
unequal societies should be more mobile. The greater the inequality, the more
economic power those at the top will have and, consequently, the harder it
will be those at the bottom to climb upwards. To suggest otherwise is to argue
that it is easier to climb a mountain than a hill! Unsurprisingly the facts
support the common sense analysis that the higher the inequality of incomes
and wealth, the lower the equality of opportunity and, consequently, the lower
the social mobility.

Finally, we should point out even if income mobility was higher it does not
cancel out the fact that a class system is marked by differences in **power**
which accompany the differences in income. In other words, because it is
possible (in theory) for everyone to become a boss this does not make the
power and authority that bosses have over their workers (or the impact of
their wealth on society) any more legitimate (just because everyone -- in
theory -- can become a member of the government does not make government any
less authoritarian). Because the membership of the boss class can change does
not negate the fact that such a class exists.

Ultimately, using (usually highly inflated) notions of social mobility to
defend a class system is unconvincing. After all, in most slave societies
slaves could buy their freedom and free people could sell themselves into
slavery (to pay off debts). If someone tried to defend slavery with the
reference to this fact of social mobility they would be dismissed as mad. The
evil of slavery is not mitigated by the fact that a few slaves could stop
being slaves if they worked hard enough.



## B.7.3 Why is the existence of classes denied?

It is clear, then, that classes do exist, and equally clear that individuals
can rise and fall within the class structure -- though, of course, it's easier
to become rich if you're born in a rich family than a poor one. Thus James W.
Loewen reports that _"ninety-five percent of the executives and financiers in
America around the turn of the century came from upper-class or upper-middle-
class backgrounds. Fewer than 3 percent started as poor immigrants or farm
children. Throughout the nineteenth century, just 2 percent of American
industrialists came from working-class origins"_ [in _"Lies My Teacher Told
Me"_ citing William Miller, _"American Historians and the Business Elite,"_ in
**Men in Business**, pp. 326-28; cf. David Montgomery, **Beyond Equality**,
pg. 15] And this was at the height of USA "free market" capitalism. According
to a survey done by C. Wright Mills and reported in his book **The Power
Elite**, about 65% of the highest-earning CEOs in American corporations come
from wealthy families. Meritocracy, after all, does not imply a "classless"
society, only that some mobility exists between classes. Yet we continually
hear that class is an outmoded concept; that classes don't exist any more,
just atomised individuals who all enjoy "equal opportunity," "equality before
the law," and so forth. So what's going on?

The fact that the capitalist media are the biggest promoters of the "end-of-
class" idea should make us wonder exactly **why** they do it. Whose interest
is being served by denying the existence of classes? Clearly it is those who
run the class system, who gain the most from it, who want everyone to think we
are all "equal." Those who control the major media don't want the idea of
class to spread because they themselves are members of the ruling class, with
all the privileges that implies. Hence they use the media as propaganda organs
to mould public opinion and distract the middle and working classes from the
crucial issue, i.e., their own subordinate status. This is why the mainstream
news sources give us nothing but superficial analyses, biased and selective
reporting, outright lies, and an endless barrage of yellow journalism,
titillation, and "entertainment," rather than talking about the class nature
of capitalist society (see section D.3 -- ["How does wealth influence the mass
media?"](secD3.html))

The universities, think tanks, and private research foundations are also
important propaganda tools of the ruling class. This is why it is virtually
taboo in mainstream academic circles to suggest that anything like a ruling
class even exists in the United States. Students are instead indoctrinated
with the myth of a "pluralist" and "democratic" society -- a Never-Never Land
where all laws and public policies supposedly get determined only by the
amount of "public support" they have -- certainly not by any small faction
wielding power in disproportion to its size.

To deny the existence of class is a powerful tool in the hands of the
powerful. As Alexander Berkman points out, _"[o]ur social institutions are
founded on certain ideas; so long as the latter are generally believed, the
institutions built on them are safe. Government remains strong because people
think political authority and legal compulsion necessary. Capitalism will
continue as long as such an economic system is considered adequate and just.
The weakening of the ideas which support the evil and oppressive present day
conditions means the ultimate breakdown of government and capitalism."_
[_"Author's Foreword,"_ **What is Anarchism?**, p. xii]

Unsurprisingly, to deny the existence of classes is an important means of
bolstering capitalism, to undercut social criticism of inequality and
oppression. It presents a picture of a system in which only individuals exist,
ignoring the differences between one set of people (the ruling class) and the
others (the working class) in terms of social position, power and interests.
This obviously helps those in power maintain it by focusing analysis away from
that power and its sources (wealth, hierarchy, etc.).

It also helps maintain the class system by undermining collective struggle. To
admit class exists means to admit that working people share common interests
due to their common position in the social hierarchy. And common interests can
lead to common action to change that position. Isolated consumers, however,
are in no position to act for themselves. One individual standing alone is
easily defeated, whereas a **_union_** of individuals supporting each other is
not. Throughout the history of capitalism there have been attempts by the
ruling class -- often successful -- to destroy working class organisations.
Why? Because in union there is power -- power which can destroy the class
system as well as the state and create a new world.

That's why the very existence of class is denied by the elite. It's part of
their strategy for winning the battle of ideas and ensuring that people remain
as atomised individuals. By _"manufacturing consent"_ (to use Walter Lipman's
expression for the function of the media), force need not be used. By limiting
the public's sources of information to propaganda organs controlled by state
and corporate elites, all debate can be confined within a narrow conceptual
framework of capitalist terminology and assumptions, and anything premised on
a different conceptual framework can be marginalised. Thus the average person
is brought to accept current society as "fair" and "just," or at least as "the
best available," because no alternatives are ever allowed to be discussed.

## B.7.4 What do anarchists mean by _"class consciousness"_?

Given that the existence of classes is often ignored or considered unimportant
("boss and worker have common interests") in mainstream culture, its important
to continually point out the facts of the situation: that a wealthy elite run
the world and the vast majority are subjected to hierarchy and work to enrich
this elite. To be class conscious means that we are aware of the objective
facts and act appropriately to change them.

This is why anarchists stress the need for _**"class consciousness,"**_ for
recognising that classes exist and that their interests are in **conflict.**
The reason why this is the case is obvious enough. As Alexander Berkman
argues, _"the interests of capital and labour are not the same. No greater lie
was ever invented than the so-called 'identity of interests' [between capital
and labour] . . . labour produces all the wealth of the world . . . [and]
capital is owned by the masters is stolen property, stolen products of labour.
Capitalist industry is the process of continuing to appropriate the products
of labour for the benefit of the master class . . . It is clear that your
interests as a worker are **different** from the interests of your
capitalistic masters. More than different: they are entirely opposite; in
fact, contrary, antagonistic to each other. The better wages the boss pays
you, the less profit he makes out of you. It does not require great philosophy
to understand that."_ [**What is Anarchism?**, pp. 75-6]

That classes are in conflict can be seen from the post-war period in most
developed countries. Taking the example of the USA, the immediate post-war
period (the 1950s to the 1970s) were marked by social conflict, strikes and so
forth. From the 1980s onwards, there was a period of relative social peace
because the bosses managed to inflict a series of defeats on the working
class. Workers became less militant, the trade unions went into a period of
decline and the success of capitalism proclaimed. If the interests of both
classes were the same we would expect that all sections of society would have
benefited more in the 1980s onwards than between the 1950s to 1970s. This is
**not** the case. While income grew steadily across the board between 1950 and
1980s, since then wealth has flooded up to the top while those at the bottom
found it harder to make ends meet.

A similar process occurred in the 1920s when Alexander Berkman stated the
obvious:

> _ "The masters have found a very effective way to paralyse the strength of
organised labour. They have persuaded the workers that they have the same
interests as the employers . . . that what is good for the employer is good
for his employees . . . [that] the workers will not think of fighting their
masters for better conditions, but they will be patient and wait till the
employer can 'share his prosperity' with them. They will also consider the
interests of 'their' country and they will not 'disturb industry' and the
'orderly life of the community' by strikes and stoppage of work. If you listen
to your exploiters and their mouthpieces you will be 'good' and consider only
the interests of your masters, of your city and country -- but no one cares
about **your** interests and those of your family, the interests of your union
and of your fellow workers of the labouring class. 'Don't be selfish,' they
admonish you, while the boss is getting rich by your being good and unselfish.
And they laugh in their sleeves and thank the Lord that you are such an
idiot."_ [**Op. Cit.**, pp. 74-5]

So, in a nutshell, class consciousness is to look after your own interest as a
member of the working class. To be aware that there is inequality in society
and that you cannot expect the wealthy and powerful to be concerned about
anyone's interest except their own. That only by struggle can you gain respect
and an increased slice of the wealth you produce but do not own. And that
there is _"an irreconcilable antagonism"_ between the ruling class and working
class _"which results inevitably from their respective stations in life."_ The
riches of the former are _"based on the exploitation and subjugation of the
latter's labour"_ which means _"war between"_ the two _"is unavoidable."_ For
the working class desires _"only equality"_ while the ruling elite _"exist[s]
only through inequality."_ For the latter, _"as a separate class, equality is
death"_ while for the former _"the least inequality is slavery."_ [Bakunin,
**The Basic Bakunin**, p. 97 and pp. 91-2]

Although class analysis may at first appear to be a novel idea, the
conflicting interests of the classes is **well** recognised on the other side
of the class divide. For example, James Madison in the **Federalist Paper**
#10 states that _"those who hold and those who are without have ever formed
distinct interests in society."_ For anarchists, class consciousness means to
recognise what the bosses already know: the importance of solidarity with
others in the same class position as oneself and of acting together as equals
to attain common goals. The difference is that the ruling class wants to keep
the class system going while anarchists seek to end it once and for all.

It could therefore be argued that anarchists actually want an _**"anti-
class"**_ consciousness to develop -- that is, for people to recognise that
classes exist, to understand **why** they exist, and act to abolish the root
causes for their continued existence (_"class consciousness,"_ argues Vernon
Richards, _"but not in the sense of wanting to perpetuate classes, but the
consciousness of their existence, an understanding of why they exist, and a
determination, informed by knowledge and militancy, to abolish them."_ [**The
Impossibilities of Social Democracy**, p. 133]). In short, anarchists want to
eliminate classes, not universalise the class of "wage worker" (which would
presuppose the continued existence of capitalism).

More importantly, class consciousness does not involve "worker worship." To
the contrary, as Murray Bookchin points out, _"[t]he worker begins to become a
revolutionary when he undoes his [or her] 'workerness', when he [or she] comes
to detest his class status here and now, when he begins to shed. . . his work
ethic, his character-structure derived from industrial discipline, his respect
for hierarchy, his obedience to leaders, his consumerism, his vestiges of
puritanism."_ [**Post-Scarcity Anarchism**, p. 119] For, in the end,
anarchists _"cannot build until the working class gets rid of its illusions,
its acceptance of bosses and faith in leaders."_ [Marie-Louise Berneri,
**Neither East Nor West**, p. 19]

It may be objected that there are only individuals and anarchists are trying
to throw a lot of people in a box and put a label like "working class" on
them. In reply, anarchists agree, yes, there are "only" individuals but some
of them are bosses, most of them are working class. This is an objective
division within society which the ruling class does its best to hide but which
comes out during social struggle. And such struggle is part of the process by
which more and more oppressed people subjectivity recognise the objective
facts. And by more and more people recognising the facts of capitalist
reality, more and more people will want to change them.

Currently there are working class people who want an anarchist society and
there are others who just want to climb up the hierarchy to get to a position
where they can impose their will to others. But that does not change the fact
that their current position is that they are subjected to the authority of
hierarchy and so can come into conflict with it. And by so doing, they must
practise self-activity and this struggle can change their minds, what they
think, and so they become radicalised. This, the radicalising effects of self-
activity and social struggle, is a key factor in why anarchists are involved
in it. It is an important means of creating more anarchists and getting more
and more people aware of anarchism as a viable alternative to capitalism.

Ultimately, it does not matter what class you are, it's what you **believe
in** that matters. And what you **do.** Hence we see anarchists like Bakunin
and Kropotkin, former members of the Russian ruling class, or like Malatesta,
born into an Italian middle class family, rejecting their backgrounds and its
privileges and becoming supporters of working class self-liberation. But
anarchists base their activity primarily on the working class (including
peasants, self-employed artisans and so on) because the working class is
subject to hierarchy and so have a real need to resist to exist. This process
of resisting the powers that be can and does have a radicalising effect on
those involved and so what they believe in and what they do **changes.** Being
subject to hierarchy, oppression and exploitation means that it is in the
working class people's _"own interest to abolish them. It has been truly said
that 'the emancipation of the workers must be accomplished by the workers
themselves,' for no social class will do it for them . . . It is . . . **the
interest** of the proletariat to emancipate itself from bondage . . . It is
only be growing to a true realisation of their present position, by
visualising their possibilities and powers, by learning unity and co-
operation, and practising them, that the masses can attain freedom."_
[Alexander Berkman, **Op. Cit.**, pp. 187-8]

We recognise, therefore, that only those at the bottom of society have a
**self**-interest in freeing themselves from the burden of those at the top,
and so we see the importance of class consciousness in the struggle of
oppressed people for self-liberation. Thus, _"[f]ar from believing in the
messianic role of the working class, the anarchists' aim is to **abolish** the
working class in so far as this term refers to the underprivileged majority in
all existing societies. . . What we do say is that no revolution can succeed
without the active participation of the working, producing, section of the
population. . . The power of the State, the values of authoritarian society
can only be challenged and destroyed by a greater power and new values."_
[Vernon Richards, **The Raven**, no. 14, pp. 183-4] Anarchists also argue that
one of the effects of direct action to resist oppression and exploitation of
working class people would be the **creation** of such a power and new values,
values based on respect for individual freedom and solidarity (see sections
[J.2](secJ2.html) and [J.4](secJ4.html) on direct action and its liberating
potential).

As such, class consciousness also means recognising that working class people
not only have an interest in ending its oppression but that we also have the
power to do so. _"This power, the people's power,"_ notes Berkman, _"is
**actual**: it cannot be taken away, as the power of the ruler, of the
politician, or of the capitalist can be. It cannot be taken away because it
does not consist of possessions but in ability. It is the ability to create,
to produce; the power that feeds and clothes the world, that gives us life,
health and comfort, joy and pleasure."_ The power of government and capital
_"disappear when the people refuse to acknowledge them as masters, refuse to
let them lord it over them."_ This is _"the all-important **economic power**"_
of the working class. [**Op. Cit.**, p. 87, p. 86 and p. 88]

This potential power of the oppressed, anarchist argue, shows that not only
are classes wasteful and harmful, but that they can be ended once those at the
bottom seek to do so and reorganise society appropriately. This means that we
have the power to transform the economic system into a non-exploitative and
classless one as _"only a productive class may be libertarian in nature,
because it does not need to exploit."_ [Albert Meltzer, **Anarchism: Arguments
For and Against**, p. 23]

Finally, it is important to stress that anarchists think that class
consciousness **must** also mean to be aware of **all** forms of hierarchical
power, not just economic oppression. As such, class consciousness and class
conflict is not simply about inequalities of wealth or income but rather
questioning all forms of domination, oppression and exploitation.

For anarchists, _"[t]he class struggle does not centre around material
exploitation alone but also around spiritual exploitation, . . . [as well as]
psychological and environmental oppression."_ [Bookchin, **Op. Cit.**, p. 151]
This means that we do not consider economic oppression to be the only
important thing, ignoring struggles and forms of oppression outside the
workplace. To the contrary, workers are human beings, not the economically
driven robots of capitalist and Leninist mythology. They are concerned about
everything that affects them -- their parents, their children, their friends,
their neighbours, their planet and, very often, total strangers.

[‹ B.6 But won't decisions made by individuals with their own money be the
best? ](/afaq/secB6.html "Go to previous page" ) [up](/afaq/secBcon.html "Go
to parent page" ) [Section C - What are the myths of capitalist economics?
›](/afaq/secCcon.html "Go to next page" )

