# C.9 Would laissez-faire capitalism reduce unemployment?

In order to answer this question, we must first have to point out that
"actually existing capitalism" tries to manage unemployment to ensure a
compliant and servile working class. This is done under the name of fighting
"inflation" but, in reality, it about controlling wages and maintaining high
profit rates for the capitalist class. Market discipline for the working
class, state protection for the ruling class, in other words. As Edward Herman
points out:

> _"Conservative economists have even developed a concept of a 'natural rate
of unemployment,' a metaphysical notion and throwback to an eighteenth century
vision of a 'natural order,' but with a modern apologetic twist. The natural
rate is defined as the minimum unemployment level consistent with price level
stability, but, as it is based on a highly abstract model that is not directly
testable, the natural rate can only be inferred from the price level itself.
That is, if prices are going up, unemployment is below the 'natural rate' and
too low, whether the actual rate is 4, 8, or 10 percent. In this world of
conservative economics, anybody is 'voluntarily' unemployed. Unemployment is a
matter of rational choice: some people prefer 'leisure' over the real wage
available at going (or still lower) wage rates . . .  
>  _

>

> _"Apart from the grossness of this kind of metaphysical legerdemain, the
very concept of a natural rate of unemployment has a huge built-in bias. It
takes as granted all the other institutional factors that influence the price
level-unemployment trade-off (market structures and independent pricing power,
business investment policies at home and abroad, the distribution of income,
the fiscal and monetary mix, etc.) and focuses solely on the tightness of the
labour market as the controllable variable. Inflation is the main threat, the
labour market (i.e. wage rates and unemployment levels) is the locus of the
solution to the problem."_ [**Beyond Hypocrisy**, p. 94]

Unsurprisingly, Herman defines this "natural" rate as _"the rate of
unemployment preferred by the propertied classes."_ [**Op. Cit.**, p. 156] The
theory behind this is usually called the _**"Non-Accelerating Inflation Rate
of Unemployment"**_ (or NAIRU). Like many of the worse aspects of modern
economics, the concept was raised Milton Friedman in the late 1960s. At around
the same time, Edmund Phelps independently developed the theory (and gained
the so-called "Nobel Prize" in economics for so doing in 2006). Both are
similar and both simply repeat, in neo-classical jargon, the insight which
critics of capitalism had argued for over a century: unemployment is a
necessary aspect of capitalism for it is essential to maintaining the power of
the boss over the worker. Ironically, therefore, modern neo-classical
economics is based on a notion which it denied for over a century (this change
may be, in part, because the ruling elite thinks it has won the class war and
has, currently, no major political and social movements it has to refute by
presenting a rosy picture of the system).

Friedman raised his notion of a _"Natural Rate of Unemployment"_ in 1968. He
rooted it in the neo-classical perspective of individual expectations rather
than, say, the more realistic notion of class conflict. His argument was
simple. There exists in the economy some _"natural"_ rate associated with the
real wage an ideal economy would produce (this is _"the level that would be
ground out by the Walrasian system of general equilibrium equations,"_ to
quote him). Attempts by the government to reduce actual unemployment below
this level would result in rising inflation. This is because there would be
divergence between the actual rate of inflation and its expected rate. By
lowering unemployment, bosses have to raise wages and this draws unemployed
people into work (note the assumption that unemployment is voluntary).
However, rising wages were passed on by bosses in rising prices and so the
**real** wage remains the same. This eventually leads to people leaving the
workforce as the real wage has fallen back to the previous, undesired, levels.
However, while the unemployment level rises back to its _"natural"_ level,
inflation does not. This is because workers are interested in real wages and,
so if inflation is at, say, 2% then they will demand wage increases that take
this into account. If they expect inflation to increase again then workers
will demand **more** wages to make up for it, which in turn will cause prices
to rise (although Friedman downplayed that this was because **bosses** were
increasing their prices to maintain profit levels). This will lead to rising
inflation **and** rising unemployment. Thus the expectations of individuals
are the key.

For many economists, this process predicted the rise of stagflation in the
1970s and gave Friedman's Monetarist dogmas credence. However, this was
because the _"Bastard Keynesianism"_ of the post-war period was rooted in the
same neo-classical assumptions used by Friedman. Moreover, they had forgotten
the warnings of left-wing Keynesians in the 1940s that full unemployment would
cause inflation as bosses would pass on wage rises onto consumers. This class
based analysis, obviously, did not fit in well with the panglossian
assumptions of neo-classical economics. Yet basing an analysis on individual
expectations does not answer the question whether these expectations are meet.
With strong organisation and a willingness to act, workers can increase their
wages to counteract inflation. This means that there are two main options
within capitalism. The first option is to use price controls to stop
capitalists increasing their prices. However, this contradicts the scared laws
of supply and demand and violates private property. Which brings us to the
second option, namely to break unions and raise unemployment to such levels
that workers think twice about standing up for themselves. In this case,
workers cannot increase their money wages and so their real wages drop.

Guess which option the capitalist state went for? As Friedman made clear when
he introduced the concept there was really nothing _"natural"_ about the
natural rate theory as it was determined by state policy:

> _"I do not mean to suggest that it is immutable and unchangeable. On the
contrary, many of the market characteristics that determine its level are man-
made and policy-made. In the United States, for example, legal minimum wage
rates . . . and the strength of labour unions all make the natural rate of
unemployment higher than it would otherwise be."_ [_"The Role of Monetary
Policy,"_ pp. 1-17, **American Economic Review**, Vol. 68, No. 1, p. 9]

Thus the "natural" rate is really a social and political phenomenon which, in
effect, measures the bargaining strength of working people. This suggests that
inflation will fall when working class people are in no position to recoup
rising prices in the form of rising wages. The "Natural Rate" is, in other
words, about class conflict.

This can be seen when the other (independent) inventor of the "natural" rate
theory won the so-called Nobel prize in 2006. Unsurprisingly, the
**Economist** magazine was cock-a-hoop. [_"A natural choice: Edmund Phelps
earns the economics profession's highest accolade"_, Oct 12th 2006] The
reasons why became clear. According to the magazine, _"Phelps won his laurels
in part for kicking the feet from under his intellectual forerunners"_ by
presenting a (neo-classical) explanation for the breakdown of the so-called
_"Phillips curve."_ This presented a statistical trade-off between inflation
and unemployment (_"unemployment was low in Britain when wage inflation was
high, and high when inflation was low"_). The problem was that economists
_"were quick -- too quick -- to conclude that policymakers therefore faced a
grand, macroeconomic trade-off"_ in which, due to _"such a tight labour
market, companies appease workers by offering higher wages. They then pass on
the cost in the form of dearer prices, cheating workers of a higher real wage.
Thus policy makers can engineer lower unemployment only through deception."_
Phelps innovation was to argue that _"[e]ventually workers will cotton on,
demanding still higher wages to offset the rising cost of living. They can be
duped for as long as inflation stays one step ahead of their rising
expectations of what it will be."_ The similarities with Friedman's idea are
obvious. This meant that the _"stable trade-off depicted by the Phillips curve
is thus a dangerous mirage"_ which broke down in the 1970s with the rise of
stagflation.

Phelps argued that there was a _"natural"_ rate of unemployment, where
_"workers' expectations are fulfilled, prices turn out as anticipated, and
they no longer sell their labour under false pretences."_ This _"equilibrium
does not, sadly, imply full employment"_ and so capitalism required _"leaving
some workers mouldering on the shelf. Given economists' almost theological
commitment to the notion that markets clear, the presence of unemployment in
the world requires a theodicy to explain it."_ The religious metaphor does
seem appropriate as most economists (and **The Economist**) do treat the
market like a god (a theodicy is a specific branch of theology and philosophy
that attempts to reconcile the existence of evil in the world with the
assumption of a benevolent God). And, as with all gods, sacrifices are
required and Phelps’ theory is the means by which this is achieved. As the
magazine noted: _"in much of his work he contends that unemployment is
necessary to cow workers, ensuring their loyalty to the company and their
diligence on the job, at a wage the company can afford to pay"_ (i.e., one
which would ensure a profit).

It is this theory which has governed state policy since the 1980s. In other
words, government's around the world have been trying to _"cow workers"_ in
order to ensure their obedience (_"loyalty to the company"_). Unsurprisingly,
attempts to lower the _"natural rate"_ have all involved using the state to
break the economic power of working class people (attacking unions, increasing
interest rates to increase unemployment in order to temporarily _"cow"_
workers and so on). All so that profits can be keep high in the face of the
rising wages caused by the natural actions of the market!

Yet it must be stressed that Friedman's and Phelps' conclusions are hardly
new. Anarchists and other socialists had been arguing since the 1840s that
capitalism had no tendency to full employment either in theory or in practice.
They have also noted how periods of full employment bolstered working class
power and harmed profits. It is, as we stressed in [section
C.1.5](secC1.md#secc15), the fundamental disciplinary mechanism of the
system. Somewhat ironically, then, Phelps got bourgeois economics highest
prize for restating, in neo-classical jargon, the model of the labour market
expounded by, say, Marx:

> _"If [capital’s] accumulation on the one hand increases the demand for
labour, it increases on the other the supply of workers by 'setting them
free', while at the same time the pressure of the unemployed compels those
that are employed to furnish more labour, and therefore makes the supply of
labour to a certain extent independent of the supply of labourers. The
movement of the law of supply and demand of labour on this basis completes the
despotism of capital. Thus as soon as the workers learn the secret of why it
happens that the more they work, the more alien wealth they produce . . . as
soon as, by setting up trade unions, etc., they try to organise a planned co-
operation between employed and unemployed in order to obviate or to weaken the
ruinous effects of this natural law of capitalistic production on their class,
so soon capital and its sycophant, political economy, cry out at the
infringement of the 'eternal' and so to speak 'sacred' law of supply and
demand. Every combination of employed and unemployed disturbs the 'pure'
action of this law. But on the other hand, as soon as . . . adverse
circumstances prevent the creation of an industrial reserve army and, with it,
the absolute dependence of the working-class upon the capitalist class,
capital, along with its platitudinous Sancho Panza, rebels against the
'sacred' law of supply and demand, and tries to check its inadequacies by
forcible means."_ [**Capital**, Vol. 1, pp. 793-4]

That the **Economist** and Phelps are simply echoing, and confirming, Marx is
obvious. Modern economics, while disparaging Marx, has integrated this idea
into its macro-economic policy recommendations by urging the state to
manipulate the economy to ensure that "inflation" (i.e. wage rises) are under
control. Economics has played its role of platitudinous sycophant well while
Phelps' theory has informed state interference (_"forcible means"_) in the
economy since the 1980s, with the expected result that wages have failed to
keep up with rising productivity and so capital as enriched itself at the
expense of labour (see [section C.3](secC3.md) for details). The use of
Phelps' theory by capital in the class war is equally obvious -- as was so
blatantly stated by **The Economist** and the head of the American Federal
Reserve during this period:

> _"there's supporting testimony from Alan Greenspan. Several times during the
late 1990s, Greenspan worried publicly that, as unemployment drifted steadily
lower the 'pool of available workers' was running dry. The dryer it ran, the
greater risk of 'wage inflation,' meaning anything more than minimal
increases. Productivity gains took some of the edge of this potentially dire
threat, said Greenspan, and so did 'residual fear of job skill obsolescence,
which has induced a preference for job security over wage gains' . . . Workers
were nervous and acting as if the unemployment rate were higher than the 4% it
reached in the boom. Still, Greenspan was a bit worried, because . . . if the
pool stayed dry, 'Significant increases in wages, in excess of productivity
growth, [would] inevitably emerge, absent the unlikely repeal of the law of
supply and demand.' Which is why Greenspan &amp; Co. raised short-term
interest rates by about two points during 1999 and the first half of 2000.
There was no threat of inflation . . . nor were there any signs of rising
worker militancy. But wages were creeping higher, and the threat of the sack
was losing some of its bite."_ [Doug Henwood, **After the New Economy**, pp.
206-7]

Which is quite ironic, given that Greenspan's role in the economy was,
precisely, to _"repeal"_ the _"law of supply and demand."_ As one left-wing
economist puts it (in a chapter correctly entitled _"The Workers Are Getting
Uppity: Call In the Fed!"_), the Federal Reverse (like all Central Banks since
the 1980s) _"worries that if too many people have jobs, or if it is too easy
for workers to find jobs, there will be upward pressure on wages. More rapid
wage growth can get translated into more rapidly rising prices -- in other
words, inflation. So the Fed often decides to raise interest rates to slow the
economy and keep people out of work in order to keep inflation from increasing
and eventually getting out of control."_ However, _"[m]ost people probably do
not realise that the Federal Reserve Board, an agency of the government,
intervenes in the economy to prevent it from creating too many jobs. But there
is even more to the story. When the Fed hits the brakes to slow job growth, it
is not doctors, lawyers, and CEOs who end up without jobs. The people who lose
are those in the middle and the bottom -- sales clerks, factory workers,
custodians, and dishwashers. These are the workers who don’t get hired or get
laid off when the economy slows or goes into a recession."_ [**The
Conservative Nanny State**, p. 31] Thus the state pushes up unemployment rates
to slow wage growth, and thereby relieve inflationary pressure. The reason
should be obvious:

> _"In periods of low unemployment, workers don't only gain from higher wages.
Employers must make efforts to accommodate workers' various needs, such as
child care or flexible work schedules, because they know that workers have
other employment options. The Fed is well aware of the difficulties that
employers face in periods of low unemployment. It compiles a regular survey,
called the 'Beige Book,' of attitudes from around the country about the state
of the economy. Most of the people interviewed for the Beige Book are
employers.  
>  _

>

> _"From 1997 to 2000, when the unemployment rate was at its lowest levels in
30 years, the Beige Book was filled with complaints that some companies were
pulling workers from other companies with offers of higher wages and better
benefits. Some Beige Books reported that firms had to offer such non-wage
benefits as flexible work hours, child care, or training in order to retain
workers. The Beige Books give accounts of firms having to send buses into
inner cities to bring workers out to the suburbs to work in hotels and
restaurants. It even reported that some employers were forced to hire workers
with handicaps in order to meet their needs for labour. _

>

> _"From the standpoint of employers, life is much easier when the workers are
lined up at the door clamouring for jobs than when workers have the option to
shop around for better opportunities. Employers can count on a sympathetic ear
from the Fed. When the Fed perceives too much upward wage pressure, it slams
on the brakes and brings the party to an end. The Fed justifies limiting job
growth and raising the unemployment rate because of its concern that inflation
may get out of control, but this does not change the fact that it is
preventing workers, and specifically less-skilled workers, from getting jobs,
and clamping down on their wage growth."_ [**Op. Cit.**, pp. 32-3]

This has not happened by accident. Lobbying by business, as another left-wing
economist stresses, _"is directed toward increasing their economic power"_ and
business _"has been a supporter of macroeconomic policies that have operated
the economy with higher rates of unemployment. The stated justification is
that this lowers inflation, but it also weakens workers' bargaining power."_
Unsurprisingly, _"the economic consequence of the shift in the balance of
power in favour of business . . . has served to redistribute income towards
profits at the expense of wages, thereby lowering demand and raising
unemployment."_ In effect, the Federal Reserve _"has been using monetary
policy as a form of surrogate incomes policy, and this surrogate policy has
been tilted against wages in favour of profits"_ and so is regulating the
economy _"in a manner favourable to business."_ [Thomas I. Palley, **Plenty of
Nothing**, p. 77, p. 111 and pp. 112-3] That this is done under the name of
fighting inflation should not fool us:

> _ "Mild inflation is often an indication that workers have some bargaining
strength and may even have the upper hand. Yet, it is at exactly this stage
that the Fed now intervenes owning to its anti-inflation commitment, and this
intervention raises interest rates and unemployment. Thus, far from being
neutral, the Fed's anti-inflation policy implies siding with business in the
ever-present conflict between labour and capital over distribution of the
fruits of economic activity . . . natural-rate theory serves as the perfect
cloak for a pro-business policy stance."_ [**Op. Cit.**, p. 110]

In a sense, it is understandable that the ruling class within capitalism
desires to manipulate unemployment in this way and deflect questions about
their profit, property and power onto the state of the labour market. High
prices can, therefore, be blamed on high wages rather than high profits, rents
and interest while, at the same time, workers will put up with lower hours and
work harder and be too busy surviving to find the time or the energy to
question the boss's authority either in theory or in practice. So managing the
economy by manipulating interest rates to increase unemployment levels when
required allows greater profits to be extracted from workers as management
hierarchy is more secure. People will put up with a lot in the face of job
insecurity. As left-wing economist Thomas Balogh put it, full employment
_"generally removes the need for servility, and thus alters the way of life,
the relationship between classes . . . weakening the dominance of men over
men, dissolving the master-servant relation. It is the greatest engine for the
attainment by all of human dignity and greater equality."_ [**The Irrelevance
of Conventional Economics**, p. 47]

Which explains, in part, why the 1960s and 1970s were marked by mass social
protest against authority rather than von Hayek's _"Road to Serfdom."_ It also
explains why the NAIRU was so enthusiastically embraced and applied by the
ruling class. When times are hard, workers with jobs think twice before
standing up to their bosses and so work harder, for longer and in worse
conditions. This ensures that surplus value is increased relative to wages
(indeed, in the USA, real wages have stagnated since 1973 while profits have
grown massively). In addition, such a policy ensures that political discussion
about investment, profits, power and so on (_"the other institutional
factors"_) are reduced and diverted because working class people are too busy
trying to make ends meet. Thus the state intervenes in the economy to **stop**
full employment developing to combat inflation and instability on behalf of
the capitalist class.

That this state manipulation is considered consistent with the "free market"
says a lot about the bankruptcy of the capitalist system and its defenders.
But, then, for most defenders of the system state intervention on behalf of
capital is part of the natural order, unlike state intervention (at least in
rhetoric) on behalf of the working class (and shows that Kropotkin was right
to stress that the state **never** practices "laissez-faire" with regard to
the working class -- see [section D.1](secD1.md)). Thus neo-liberal
capitalism is based on monetary policy that explicitly tries to weaken working
class resistance by means of unemployment. If "inflation" (i.e. labour income)
starts to increase, interest rates are raised so causing unemployment and, it
is hoped, putting the plebes back in their place. In other words, the road to
private serfdom has been cleared of any barriers imposed on it by the rise of
the working class movement and the policies of social democracy implemented
after the Second World War to stop social revolution. This is the agenda
pursued so strongly in America and Britain, imposed on the developing nations
and urged upon Continental Europe.

Although the aims and results of the NAIRU should be enough to condemn it out
of hand, it can be dismissed for other reasons. First and foremost, this
"natural" rate is both invisible and can move. This means trying to find it is
impossible (although it does not stop economists trying, and then trying again
when rate inflation and unemployment rates refute the first attempt, and then
trying again and again). In addition, it is a fundamentally a meaningless
concept -- you can prove anything with an invisible, mobile value -- it is an
non-refutable concept and so, fundamentally, non-scientific. Close inspection
reveals natural rate theory to be akin to a religious doctrine. This is
because it is not possible to conceive of a test that could possibly falsify
the theory. When predictions of the natural rate turn out wrong (as they
repeatedly have), proponents can simply assert that the natural rate has
changed. That has led to the most recent incarnation of the theory in which
the natural rate is basically the trend rate of unemployment. Whatever trend
is observed is natural -- case closed.

Since natural rate theory cannot be tested, a sensible thing would be to
examine its assumptions for plausibility and reasonableness. However, Milton
Friedman’s early work on economic methodology blocks this route as he asserted
that realism and plausibility of assumptions have no place in economics. With
most economists blindly accepting this position, the result is a church in
which entry is conditional on accepting particular assumptions about the
working of markets. The net effect is to produce an ideology, an ideology
which survives due to its utility to certain sections of society.

If this is the case, and it is, then any attempts to maintain the "natural"
rate are also meaningless as the only way to discover it is to watch
**actual** inflation levels and raising interest rates appropriately. Which
means that people are being made unemployed on the off-chance that the
unemployment level will drop below the (invisible and mobile) "natural" rate
and harm the interests of the ruling class (high inflation rates harms
interest incomes and full employment squeezes profits by increasing workers'
power). This does not seem to bother most economists, for whom empirical
evidence at the best of times is of little consequence. This is doubly true
with the NAIRU, for with an invisible, mobile value, the theory is always true
after the fact -- if inflation rises as unemployment rises, then the natural
rate has increased; if inflation falls as unemployment rises, it has fallen!
As post-Keynesian economist James K. Galbraith noted in his useful critique of
the NAIRU, _"as the real unemployment rate moves, the apparent NAIRU moves in
its shadow"_ and its _"estimates and re-estimates seem largely a response to
predictive failure. We still have no theory, and no external evidence,
governing the fall of the estimated NAIRU. The literature simply observes that
inflation hasn't occurred and so the previous estimate must have been too
high."_ He stresses, economists have held _"to a concept in the face of twenty
years of unexplained variation, predictive failure, and failure of the
profession to coalesce on procedural issues."_ [**Created Unequal**, p. 180]
Given that most mainstream economists subscribe to this fallacy, it just shows
how the "science" accommodates itself to the needs of the powerful and how the
powerful will turn to any old nonsense if it suits their purpose. A better
example of supply and demand for ideology could not be found.

So, supporters of "free market" capitalism do have a point, "actually existing
capitalism" has created high levels of unemployment. What **is** significant
is that most supporters of capitalism consider that this is a laissez-faire
policy! Sadly, the ideological supporters of pure capitalism rarely mention
this state intervention on behalf of the capitalist class, preferring to
attack trade unions, minimum wages, welfare and numerous other "imperfections"
of the labour market which, strangely, are designed (at least in rhetoric) to
benefit working class people. Ignoring that issue, however, the question now
arises, would a "purer" capitalism create full employment?

First, we should point out that some supporters of "free market" capitalism
(most notably, the "Austrian" school) claim that real markets are not in
equilibrium at all, i.e. that the nature state of the economy is one of
disequilibrium. As we noted in [section C.1.6](secC1.md#secc16), this means
full employment is impossible as this is an equilibrium position but few
explicitly state this obvious conclusion of their own theories and claim
against logic that full employment can occur (full employment, it should be
stressed, has never meant 100% employment as they will always be some people
looking for a job and so by that term we mean close to 100% employment).
Anarchists agree: full employment can occur in "free market" capitalism but
not for ever nor even for long periods. As the Polish socialist economist
Michal Kalecki pointed out in regards to pre-Keynesian capitalism, _"[n]ot
only is there mass unemployment in the slump, but average employment
throughout the cycle is considerably below the peak reached in the boom. The
reserve of capital equipment and the reserve army of unemployed are typical
features of capitalist economy at least throughout a considerable part of the
[business] cycle."_ [quoted by Malcolm C. Sawyer, **The Economics of Michal
Kalecki**, pp. 115-6]

It is doubtful that "pure" capitalism will be any different. This is due to
the nature of the system. What is missing from the orthodox analysis is an
explicit discussion of class and class struggle (implicitly, they are there
and almost always favour the bosses). Once this is included, the functional
reason for unemployment becomes clear. It serves to discipline the workforce,
who will tolerate being bossed about much more with the fear that unemployment
brings. This holds down wages as the threat of unemployment decreases the
bargaining power of workers. This means that unemployment is not only a
natural product of capitalism, it is an essential part of it.

So cycles of short periods approaching full employment and followed by longer
periods of high unemployment are actually a more likely outcome of pure
capitalism than continued full employment. As we argued in sections
[C.1.5](secC1.md#secc15) and [C.7.1](secC7.md#secc71) capitalism needs
unemployment to function successfully and so "free market" capitalism will
experience periods of boom and slump, with unemployment increasing and
decreasing over time (as can be seen from 19th century capitalism). So as
Juliet Schor, a labour economist, put it, usually _"employers have a
structural advantage in the labour market, because there are typically more
candidates ready and willing to endure this work marathon [of long hours] than
jobs for them to fill."_ Under conditions of full-employment _"employers are
in danger of losing the upper hand"_ and hiring new workers _"suddenly becomes
much more difficult. They are harder to find, cost more, and are less
experienced."_ These considerations _"help explain why full employment has
been rare."_ Thus competition in the labour market is _"typically skewed in
favour of employers: it is a buyers market. And in a buyer's market, it is the
sellers who compromise."_ In the end, workers adapt to this inequality of
power and instead of getting what they want, they want what they get (to use
Schor's expression). Under full employment this changes. In such a situation
it is the bosses who have to start compromising. And they do not like it. As
Schor notes, America _"has never experienced a sustained period of full
employment. The closest we have gotten is the late 1960s, when the overall
unemployment rate was under 4 percent for four years. But that experience does
more to prove the point than any other example. The trauma caused to business
by those years of a tight labour market was considerable. Since then, there
has been a powerful consensus that the nation cannot withstand such a low rate
of unemployment."_ Hence the support for the NAIRU to ensure that _"forced
idleness of some helps perpetuate the forced overwork of others."_ [**The
Overworked American**, p. 71, p. 75, p. 129, pp. 75-76 and p. 76]

So, full employment under capitalism is unlikely to last long (nor would full
employment booms fill a major part of the business cycle). In addition, it
should be stressed that the notion that capitalism naturally stays at
equilibrium or that unemployment is temporary adjustments is false, even given
the logic of capitalist economics. As Proudhon argued:

> _"The economists admit it [that machinery causes unemployment]: but here
they repeat their eternal refrain that, after a lapse of time, the demand for
the product having increased in proportion to the reduction in price [caused
by the investment], labour in turn will come finally to be in greater demand
than ever. Undoubtedly, **with time,** the equilibrium will be restored; but I
must add again, the equilibrium will be no sooner restored at this point than
it will be disturbed at another, because the spirit of invention never
stops."_ [**System of Economical Contradictions**, pp. 200-1]

That capitalism creates permanent unemployment and, indeed, needs it to
function is a conclusion that few, if any, pro-"free market" capitalists
subscribe to. Faced with the empirical evidence that full employment is rare
in capitalism, they argue that reality is not close enough to their theories
and must be changed (usually by weakening the power of labour by welfare
"reform" and reducing "union power"). Thus reality is at fault, not the theory
(to re-quote Proudhon, _"Political economy -- that is, proprietary despotism
-- can never be in the wrong: it must be the proletariat."_ [**Op. Cit.** p.
187]) So if unemployment exists, then its because real wages are too high, not
because capitalists need unemployment to discipline labour (see [section
C.9.2](secC9.md#secc92) for evidence that this argument is false). Or if
real wages are falling as unemployment is rising, it can only mean that the
real wage is not falling fast enough -- empirical evidence is never enough to
falsify logical deductions from assumptions!

(As an aside, it is one of amazing aspects of the "science" of economics that
empirical evidence is never enough to refute its claims. As the Post-Keynesian
economist Nicholas Kaldor once pointed out, _"[b]ut unlike any scientific
theory, where the basic assumptions are chosen on the basis of direct
observation of the phenomena the behaviour of which forms the subject-matter
of the theory, the basic assumptions of economic theory are either of a kind
that are unverifiable. . . or of a kind which are directly contradicted by
observation."_ [**Further Essays on Applied Economics**, pp. 177-8])

Of course, reality often has the last laugh on any ideology. For example,
since the late 1970s and early 1980s right-wing capitalist parties have taken
power in many countries across the world. These regimes made many pro-free
market reforms, arguing that a dose of market forces would lower unemployment,
increase growth and so on. The reality proved somewhat different. For example,
in the UK, by the time the Labour Party under Tony Blair come back to office
in 1997, unemployment (while falling) was still higher than it had been when
the last Labour government left office in 1979 (this in spite of repeated
redefinitions of unemployment by the Tories in the 1980s to artifically reduce
the figures). 18 years of labour market reform had **not** reduced
unemployment even under the new definitions. This outcome was identical to New
Zealand's neo-liberal experiment, were its overall effect was unimpressive, to
say the least: lower growth, lower productivity and feeble real wage increases
combined with rising inequality and unemployment. Like the UK, unemployment
was still higher in 1997 than it had been in 1979. Over a decade of "flexible"
labour markets had increased unemployment (more than doubling it, in fact, at
one point as in the UK under Thatcher). It is no understatement to argue, in
the words of two critics of neo-liberalism, that the _"performance of the
world economy since capital was liberalised has been worse than when it was
tightly controlled"_ and that _"[t]hus far, [the] actual performance [of
liberalised capitalism] has not lived up to the propaganda."_ [Larry Elliot
and Dan Atkinson, **The Age of Insecurity**, p. 274 and p. 223] In fact, as
Palley notes, _"wage and income growth that would have been deemed totally
unsatisfactory a decade ago are now embraced as outstanding economic
performance."_ [**Op. Cit.**, p. 202]

Lastly, it is apparent merely from a glance at the history of capitalism
during its laissez-faire heyday in the 19th century that "free" competition
among workers for jobs does not lead to full employment. Between 1870 and
1913, unemployment was at an average of 5.7% in the 16 more advanced
capitalist countries. This compares to an average of 7.3% in 1913-50 and 3.1%
in 1950-70. [Takis Fotopoulos, _"The Nation-State and the Market"_, pp. 37-80,
**Society and Nature**, Vol. 2, No. 2, p. 61] If laissez-faire did lead to
full employment, these figures would, surely, be reversed.

As discussed above, full employment **cannot** be a fixed feature of
capitalism due to its authoritarian nature and the requirements of production
for profit. To summarise, unemployment has more to do with private property
than the wages of our fellow workers or any social safety nets working class
movements have managed to pressure the ruling class to accept. However, it is
worthwhile to discuss why the "free market" capitalist is wrong to claim that
unemployment within their system will not exist for long periods of time. In
addition, to do so will also indicate the poverty of their theory of, and
"solution" to, unemployment and the human misery they would cause. We do this
in the [next section](secC9.md#secc91).

## C.9.1 Would cutting wages reduce unemployment?

The "free market" capitalist (i.e., neo-classical, neo-liberal or "Austrian")
argument is that unemployment is caused by the real wage of labour being
higher than the market clearing level. The basic argument is that the market
for labour is like any other market and as the price of a commodity increases,
the demand for it falls. In terms of labour, high prices (wages) causes lower
demand (unemployment). Workers, it is claimed, are more interested in money
wages than real wages (which is the amount of goods they can buy with their
money wages). This leads them to resist wage cuts even when prices are
falling, leading to a rise in their real wages and so they price themselves
out of work without realising it. From this analysis comes the argument that
if workers were allowed to compete 'freely' among themselves for jobs, real
wages would decrease and so unemployment would fall. State intervention (e.g.
unemployment benefit, social welfare programmes, legal rights to organise,
minimum wage laws, etc.) and labour union activity are, according to this
theory, the cause of unemployment, as such intervention and activity forces
wages above their market level and so force employers to "let people go." The
key to ending unemployment is simple: cut wages.

This position was brazenly put by "Austrian" economist Murray Rothbard. He
opposed any suggestion that wages should **not** be cut as the notion that
_"the first shock of the depression must fall on profits and not on wages."_
This was _"precisely the reverse of sound policy since profits provide the
motive power for business activity."_ [**America's Great Depression**, p. 188]
Rothbard's analysis of the Great Depression is so extreme it almost reads like
a satirical attack on the laissez-faire position as his hysterical anti-
unionism makes him blame unions for the depression for, apparently, merely
existing (even in an extremely weakened state) for their influence was such as
to lead economists and the President to recommend to numerous leading
corporate business men **not** to cut wages to end the depression (wages were
cut, but not sufficiently as prices also dropped as we will discuss in the
[next section](secC2.md#secc92)). It should be noted that Rothbard takes his
position on wage cutting despite of an account of the business cycle rooted in
bankers lowering interest rates and bosses over-investing as a result (see
[section C.8](secC8.md)). So despite not setting interest rates nor making
investment decisions, he expected working class people to pay for the actions
of bankers and capitalists by accepting lower wages! Thus working class people
must pay the price of the profit seeking activities of their economic masters
who not only profited in good times, but can expect others to pay the price in
bad ones. Clearly, Rothbard took the first rule of economics to heart: the
boss is always right.

The chain of logic in this explanation for unemployment is rooted in many of
the key assumptions of neo-classical and other marginalist economics. A firm's
demand for labour (in this schema) is the marginal physical product of labour
multiplied by the price of the output and so it is dependent on marginal
productivity theory. It is assumed that there are diminishing returns and
marginal productivity as only this produces a downward-sloping labour demand
curve. For labour, it is assumed that its supply curve is upwards slopping. So
it must be stressed that marginal productivity theory lies at the core of
"free market" capitalist theories of output and distribution and so
unemployment as the marginal product of labour is interpreted as the labour
demand curve. This enforces the viewpoint that unemployment is caused by wages
being too high as firms adjust production to bring the marginal cost of their
products (the cost of producing one more item) into equality with the
product's market-determined price. So a drop in labour costs theoretically
leads to an expansion in production, producing jobs for the "temporarily"
unemployed and moving the economy toward full-employment. So, in this theory,
unemployment can only be reduced by lowering the real wages of workers
currently employed. Thus the unfettered free market would ensure that all
those who want to work at the equilibrium real wage will do so. By definition,
any people who were idle in such a pure capitalism would be voluntarily
enjoying leisure and **not** unemployed. At worse, mass unemployment would be
a transitory disturbance which will quickly disappear if the market is
flexible enough and there are no imperfections in it (such as trade unions,
workers' rights, minimum wages, and so on).

Sadly for these arguments, the assumptions required to reach it are absurd as
the conclusions (namely, that there is no involuntary unemployment as markets
are fully efficient). More perniciously, when confronted with the reality of
unemployment, most supporters of this view argue that it arises only because
of government-imposed rigidities and trade unions. In their "ideal" world
without either, there would, they claim, be no unemployment. Of course, it is
much easier to demand that nothing should be done to alleviate unemployment
and that workers' real wages be reduced when you are sitting in a tenured post
in academia save from the labour market forces you wish others to be subjected
to (in their own interests).

This perspective suffered during the Great Depression and the threat of
revolution produced by persistent mass unemployment meant that dissident
economists had space to question the orthodoxy. At the head of this re-
evaluation was Keynes who presented an alternative analysis and solution to
the problem of unemployment in his 1936 book **The General Theory of
Employment, Interest and Money** (it should be noted that the Polish socialist
economist Michal Kalecki independently developed a similar theory a few years
before Keynes but without the neo-classical baggage Keynes brought into his
work).

Somewhat ironically, given the abuse he has suffered at the hands of the right
(and some of his self-proclaimed followers), Keynes took the assumptions of
neo-classical economics on the labour market as the starting point of his
analysis. As such, critics of Keynes's analysis generally misrepresent it. For
example, right-liberal von Hayek asserted that Keynes _"started from the
correct insight that the regular cause of extensive unemployment is real wages
that are too high. The next step consisted in the proposition that a direct
lowering of money wages could be brought about only by a struggle so painful
and prolonged that it could not be contemplated. Hence he concluded that real
wages must be lowered by the process of lowering the value of money,"_ i.e. by
inflation. Thus _"the supply of money must be so increased as to raise prices
to a level where the real value of the prevailing money wage is no longer
greater than the productivity of the workers seeking employment."_ [**The
Constitution of Liberty**, p. 280] This is echoed by libertarian Marxist Paul
Mattick who presented an identical argument, stressing that for Keynes _"wages
were less flexible than had been generally assumed"_ and lowering real wages
by inflation _"allowed for more subtle ways of wage-cutting than those
traditionally employed."_ [**Marx and Keynes**, p. 7]

Both are wrong. These arguments are a serious distortion of Keynes's argument.
While he did start by assuming the neo-classical position that unemployment
was caused by wages being too high, he was at pains to stress that even with
ideally flexible labour markets cutting real wages would **not** reduce
unemployment. As such, Keynes argued that unemployment was **not** caused by
labour resisting wage cuts or by "sticky" wages. Indeed, any "Keynesian"
economist who does argue that "sticky" wages are responsible for unemployment
shows that he or she has not read Keynes -- Chapter two of the **General
Theory** critiques precisely this argument. Taking neo-classical economists at
its word, Keynes analyses what would happen **if** the labour market were
perfect and so he assumes the same model as his neo-classical opponents,
namely that unemployment is caused by wages being too high and there is
flexibility in both commodity and labour markets. As he stressed, his
_"criticism of the accepted [neo-]classical theory of economics has consisted
not so much in finding logical flaws in its analysis as in pointing out that
its tacit assumptions are seldom or never satisfied, with the result that it
cannot solve the economic problems of the actual world."_ [**The General
Theory**, p. 378]

What Keynes did was to consider the **overall** effect of cutting wages on the
economy as a whole. Given that wages make up a significant part of the costs
of a commodity, _"if money-wages change, one would have expected the
[neo-]classical school to argue that prices would change in almost the same
proportion, leaving the real wage and the level of unemployment practically
the same as before."_ However, this was not the case, causing Keynes to point
out that they _"do not seem to have realised that . . . their supply curve for
labour will shift bodily with every movement of prices."_ This was because
labour cannot determine its own real wage as prices are controlled by bosses.
Once this is recognised, it becomes obvious that workers do not control the
cost of living (i.e., the real wage). Therefore trade unions _"do not raise
the obstacle to any increase in aggregate employment which is attributed to
them by the [neo-]classical school."_ So while workers could, in theory,
control their wages by asking for less pay (or, more realistically, accepting
any wage cuts imposed by their bosses as the alternative is unemployment) they
do not have any control over the prices of the goods they produce. This means
that they have **no** control over their real wages and so **cannot** reduce
unemployment by pricing themselves into work by accepting lower wages. Given
these obvious facts, Keynes concluded that there was _"no ground for the
belief that a flexible wage policy is capable of continuous full employment .
. . The economic system cannot be made self-adjusting along these lines."_
[**Op. Cit.**, p. 12, pp. 8-9, p. 15 and p. 267] As he summarised:

> _"the contention that the unemployment which characterises a depression is
due to a refusal by labour to accept a reduction of money-wages is not clearly
supported by the facts. It is not very plausible to assert that unemployment
in the United States in 1932 was due either to labour obstinately refusing to
accept a reduction of money-wages or to its demanding a real wage beyond what
the productivity of the economic machine was capable of furnishing . . .
Labour is not more truculent in the depression than in the boom -- far from
it. Nor is its physical productivity less. These facts from experience are a
**prima facie** ground for questioning the adequacy of the [neo-]classical
analysis."_ [**Op. Cit.**, p. 9]

This means that the standard neo-classical argument was flawed. While cutting
wages may make sense for one firm, it would not have this effect throughout
the economy as is required to reduce unemployment as a whole. This is another
example of the fallacy of composition. What may work with an individual worker
or firm will not have the same effect on the economy as a whole for cutting
wages for all workers would have a massive effect on the aggregate demand for
their firms products.

For Keynes and Kalecki, there were two possibilities if wages were cut. One
possibility, which Keynes considered the most likely, would be that a cut in
money wages across the whole economy would see a similar cut in prices. The
net effect of this would be to leave real wages unchanged. The other assumes
that as wages are cut, prices remain prices remained unchanged or only fell by
a small amount (i.e. if wealth was redistributed from workers to their
employers). This is the underlying assumption of "free market" argument that
cutting wages would end the slump. In this theory, cutting real wages would
increase profits and investment and this would make up for any decline in
working class consumption and so its supporters reject the claim that cutting
real wages would merely decrease the demand for consumer goods without
automatically increasing investment sufficiently to compensate for this.

However, in order make this claim, the theory depends on three critical
assumptions, namely that firms can expand production, that they will expand
production, and that, if they do, they can sell their expanded production.
This theory and its assumptions can be questioned. To do so we will draw upon
David Schweickart's excellent summary. [**Against Capitalism**, pp. 105-7]

The first assumption states that it is always possible for a company to take
on new workers. Yet increasing production requires more than just labour.
Tools, raw materials and work space are all required in addition to new
workers. If production goods and facilities are not available, employment will
not be increased. Therefore the assumption that labour can always be added to
the existing stock to increase output is plainly unrealistic, particularly if
we assume with neo-classical economics that all resources are fully utilised
(for an economy operating at less than full capacity, the assumption is
somewhat less inappropriate).

Next, will firms expand production when labour costs decline? Hardly.
Increasing production will increase supply and eat into the excess profits
resulting from the fall in wages (assuming, of course, that demand holds up in
the face of falling wages). If unemployment did result in a lowering of the
general market wage, companies might use the opportunity to replace their
current workers or force them to take a pay cut. If this happened, neither
production nor employment would increase. However, it could be argued that the
excess profits would increase capital investment in the economy (a key
assumption of neo-liberalism). The reply is obvious: perhaps, perhaps not. A
slumping economy might well induce financial caution and so capitalists could
stall investment until they are convinced of the sustained higher
profitability will last.

This feeds directly into the last assumption, namely that the produced goods
will be sold. Assuming that money wages are cut, but prices remain the same
then this would be a cut in real wages. But when wages decline, so does worker
purchasing power, and if this is not offset by an increase in spending
elsewhere, then total demand will decline. However, it can be argued that not
everyone's real income would fall: incomes from profits would increase. But
redistributing income from workers to capitalists, a group who tend to spend a
smaller portion of their income on consumption than do workers, could reduce
effective demand and increase unemployment. Moreover, business does not
(cannot) instantaneously make use of the enlarged funds resulting from the
shift of wages to profit for investment (either because of financial caution
or lack of existing facilities). In addition, which sane company would
increase investment in the face of falling demand for its products? So when
wages decline, so does workers' purchasing power and this is unlikely to be
offset by an increase in spending elsewhere. This will lead to a reduction in
aggregate demand as profits are accumulated but unused, so leading to stocks
of unsold goods and renewed price reductions. This means that the cut in real
wages will be cancelled out by price cuts to sell unsold stock and
unemployment remains. In other words, contrary to neo-classical economics, a
fall in wages may result in the same or even more unemployment as aggregate
demand drops and companies cannot find a market for their goods. And so,
_"[i]f prices do not fall, it is still worse, for then real wages are reduced
and unemployment is increased directly by the fall in the purchase of
consumption goods."_ [Joan Robinson, **Further Contributions to Economics**,
p. 34]

The "Pigou" (or _"real balance"_) effect is another neo-classical argument
that aims to prove that (in the end) capitalism will pass from slump to boom
quickly. This theory argues that when unemployment is sufficiently high, it
will lead to the price level falling which would lead to a rise in the real
value of the money supply and so increase the real value of savings. People
with such assets will have become richer and this increase in wealth will
enable people to buy more goods and so investment will begin again. In this
way, slump passes to boom naturally.

However, this argument is flawed in many ways. In reply, Michal Kalecki argued
that, firstly, Pigou had _"assumed that the banking system would maintain the
stock of money constant in the face of declining incomes, although there was
no particular reason why they should."_ If the money stock changes, the value
of money will also change. Secondly, that _"the gain in money holders when
prices fall is exactly offset by the loss to money providers. Thus, whilst the
real value of a deposit in bank account rises for the depositor when prices
fell, the liability represented by that deposit for the bank also rises in
size."_ And, thirdly, _"that falling prices and wages would mean that the real
value of outstanding debts would be increased, which borrowers would find it
increasingly difficult to repay as their real income fails to keep pace with
the rising real value of debt. Indeed, when the falling prices and wages are
generated by low levels of demand, the aggregate real income will be low.
Bankruptcies follow, debts cannot be repaid, and a confidence crisis was
likely to follow."_ In other words, debtors may cut back on spending more than
creditors would increase it and so the depression would continue as demand did
not rise. [Malcolm C. Sawyer, **The Economics of Michal Kalecki**, p. 90]

So, the traditional neo-classical reply that investment spending will increase
because lower costs will mean greater profits, leading to greater savings, and
ultimately, to greater investment is weak. Lower costs will mean greater
profits only if the products are sold, which they might not be if demand is
adversely affected. In other words, a higher profit margins do not result in
higher profits due to fall in consumption caused by the reduction of workers
purchasing power. And, as Michal Kalecki argued, wage cuts in combating a
slump may be ineffective because gains in profits are not applied immediately
to increase investment and the reduced purchasing power caused by the wage
cuts causes a fall in sales, meaning that higher profit margins do not result
in higher profits. Moreover, as Keynes pointed out long ago, the forces and
motivations governing saving are quite distinct from those governing
investment. Hence there is no necessity for the two quantities always to
coincide. So firms that have reduced wages may not be able to sell as much as
before, let alone more. In that case they will cut production, add to
unemployment and further reduce demand. This can set off a vicious downward
spiral of falling demand and plummeting production leading to depression, a
process described by Kropotkin (nearly 40 years before Keynes made the same
point in **The General Theory**):

> _"Profits being the basis of capitalist industry, low profits explain all
ulterior consequences.  
>  _

>

> _"Low profits induce the employers to reduce the wages, or the number of
workers, or the number of days of employment during the week. . . As Adam
Smith said, low profits ultimately mean a reduction of wages, and low wages
mean a reduced consumption by the worker. Low profits mean also a somewhat
reduced consumption by the employer; and both together mean lower profits and
reduced consumption with that immense class of middlemen which has grown up in
manufacturing countries, and that, again, means a further reduction of profits
for the employers."_ [**Fields, Factories and Workshops Tomorrow**, p. 33]

So, as is often the case, Keynes was simply including into mainstream
economics perspectives which had long been held by critics of capitalism and
dismissed by the orthodoxy. Keynes' critique of Say's Law essentially repeated
Marx's while Proudhon pointed out in 1846 that _"if the producer earns less,
he will buy less"_ and this will _"engender . . . over-production and
destitution."_ This was because _"though the workmen cost [the capitalist]
something, they are [his] customers: what will you do with your products, when
driven away by [him], they shall consume no longer?"_ This means that cutting
wages and employment would not work for they are _"not slow in dealing
employers a counter-blow; for if production excludes consumption, it is soon
obliged to stop itself."_ [**System of Economical Contradictions**, p. 204 and
p. 190] Significantly, Keynes praised Proudhon's follower Silvio Gesell for
getting part of the answer and for producing _"an anti-Marxian socialism"_
which the _"future will learn more from"_ than Marx. [**Op. Cit.**, p. 355]

So far our critique of the "free market" position has, like Keynes's, been
within the assumptions of that theory itself. More has to be said, though, as
its assumptions are deeply flawed and unrealistic. It should be stressed that
while Keynes's acceptance of much of the orthodoxy ensured that at least some
of his ideas become part of the mainstream, Post-Keynesians like Joan Robinson
would latter bemoan the fact that he sought a compromise rather than clean
break with the orthodoxy. This lead to the rise of the post-war neo-classical
synthesis, the so-called "Keynesian" argument that unemployment was caused by
wages being "sticky" and the means by which the right could undermine social
Keynesianism and ensure a return to neo-classical orthodoxy.

Given the absurd assumptions underlying the "free market" argument, a wider
critique is possible as it reflects reality no more than any other part of the
pro-capitalist ideology which passes for mainstream economics.

As noted above, the argument that unemployment is caused by wages being too
high is part of the wider marginalist perspective. Flaws in that will mean
that its explanation of unemployment is equally flawed. So it must be stressed
that the marginalist theory of distribution lies at the core of its theories
of both output and unemployment. In that theory, the marginal product of
labour is interpreted as the labour demand curve as the firm's demand for
labour is the marginal physical product of labour multiplied by the price of
the output and this produces the viewpoint that unemployment is caused by
wages being too high. So given the central role which marginal productivity
theory plays in the mainstream argument, it is useful to start our deeper
critique by re-iterating that, as indicated in [section C.2](secC2.md), Joan
Robinson and Piero Sraffa had successfully debunked this theory in the 1950s.
_"Yet for psychological and political reasons,"_ notes James K. Galbraith,
_"rather than for logical and mathematical ones, the capital critique has not
penetrated mainstream economics. It likely never will. Today only a handful of
economists seem aware of it."_ [_"The distribution of income"_, pp. 32-41,
Richard P. F. Holt and Steven Pressman (eds.), **A New Guide to Post Keynesian
Economics**, p. 34] Given that this underlies the argument that high wages
cause high unemployment, it means that the mainstream argument for cutting
wages has no firm theoretical basis.

It should also be noted that the assumption that adding more labour to capital
is always possible flows from the assumption of marginal productivity theory
which treats "capital" like an ectoplasm and can be moulded into whatever form
is required by the labour available (see [section C.2.5](secC2.md#secc25)
for more discussion). Hence Joan Robinson's dismissal of this assumption, for
_"the difference between the future and the past is eliminated by making
capital 'malleable' so that mistakes can always be undone and equilibrium is
always guaranteed. . . with 'malleable' capital the demand for labour depends
on the level of wages."_ [**Contributions to Modern Economics**, p. 6]
Moreover, _"labour and capital are not often as smoothly substitutable for
each other as the [neo-classical] model requires . . . You can't use one
without the other. You can't measure the marginal productivity of one without
the other."_ Demand for capital and labour is, sometimes, a **joint** demand
and so it is often to adjust wages to a worker's marginal productivity
independent of the cost of capital. [Hugh Stretton, **Economics: A New
Introduction**, p. 401]

Then there is the role of diminishing returns. The assumption that the demand
curve for labour is always downward sloping with respect to aggregate
employment is rooted in the notion that industry operates, at least in the
short run, under conditions of diminishing returns. However, diminishing
returns are **not** a feature of industries in the real world. Thus the
assumption that the downward slopping marginal product of labour curve is
identical to the aggregate demand curve for labour is not true as it is
inconsistent with empirical evidence. _"In a system at increasing returns,"_
noted one economist, _"the direct relation between real wages and employment
tends to render the ordinary mechanism of wage adjustment ineffective and
unstable."_ [Ferdinando Targetti, **Nicholas Kaldor**, p. 344] In fact, as
discussed in [section C.1.2](secC1.md#secc12), without this assumption
mainstream economics cannot show that unemployment is, in fact, caused by real
wages being too high (along with many other things).

Thus, if we accept reality, we must end up _"denying the inevitability of a
negative relationship between real wages and employment."_ Post-Keynesian
economists have not found any empirical links between the growth of
unemployment since the early in 1970s and changes in the relationship between
productivity and wages and so there is _"no theoretical reason to expect a
negative relationship between employment and the real wage, even at the level
of the individual firm."_ Even the beloved marginal analysis cannot be used in
the labour market, as _"[m]ost jobs are offered on a take-it-or-leave-it
basis. Workers have little or no scope to vary hours of work, thereby making
marginal trade-offs between income and leisure. There is thus no worker
sovereignty corresponding to the (very controversial) notion of consumer
sovereignty."_ Over all, _"if a relationship exists between aggregate
employment and the real wage, it is employment that determines wages.
Employment and unemployment are product market variables, not labour market
variables. Thus attempts to restore full employment by cutting wages are
fundamentally misguided."_ [John E. King, _"Labor and Unemployment,"_ pp.
65-78, Holt and Pressman (eds.), **Op. Cit.**, p. 68, pp. 67-8, p. 72, p. 68
and p. 72] In addition:

> _"Neo-classical theorists themselves have conceded that a negative
relationship between the real wage and the level of employment can be
established only in a one-commodity model; in a multi-commodity framework no
such generalisation is possible. This confines neo-classical theory to an
economy without money and makes it inapplicable to a capitalist or
entrepreneurial economy."_ [**Op. Cit.**, p. 71]

And, of course, the whole analysis is rooted in the notion of perfect
competition. As Nicholas Kaldor mildly put it:

> _"If economics had been a 'science' in the strict sense of the word, the
empirical observation that most firms operate in imperfect markets would have
forced economists to scrap their existing theories and to start thinking on
entirely new lines . . . unfortunately economists do not feel under the same
compulsion to maintain a close correspondence between theoretical hypotheses
and the facts of experience."_ [**Further Essays on Economic Theory ad
Policy**, p. 19]

Any real economy is significantly different from the impossible notion of
perfect competition and _"if there exists even one monopoly anywhere in the
system . . . it follows that others must be averaging less than the marginal
value of their output. So to concede the existence of monopoly requires that
one either drop the competitive model entirely or construct an elaborate new
theory . . . that divides the world into monopolistic, competitive, and
subcompetitive ('exploited') sectors."_ [James K. Galbraith, **Created
Unequal**, p. 52] As noted in [section C.4.3](secC4.md#secc43), mainstream
economists have admitted that monopolistic competition (i.e., oligopoly) is
the dominant market form but they cannot model it due to the limitations of
the individualistic assumptions of bourgeois economics. Meanwhile, while
thundering against unions the mainstream economics profession remains
strangely silent on the impact of big business and pro-capitalist monopolies
like patents and copyrights on distribution and so the impact of real wages on
unemployment.

All this means that _"neither the demand for labour nor the supply of labour
depends on the real wage. It follows from this that the labour market is not a
true market, for the price associated with it, the wage rate, is incapable of
performing any market-clearing function, and thus variations in the wage rate
cannot eliminate unemployment."_ [King, **Op. Cit.**, p. 65] As such, the
_"conventional economic analysis of markets . . . is unlikely to apply"_ to
the labour market and as a result _"wages are highly unlikely to reflect
workers' contributions to production."_ This is because economists treat
labour as no different from other commodities yet _"economic theory supports
no such conclusion."_ At its most basic, labour is **not** produced for profit
and the _"supply curve for labour can 'slope backward' -- so that a fall in
wages can cause an increase in the supply of workers."_ In fact, the idea of a
backward sloping supply curve for labour is just as easy to derive from the
assumptions used by economists to derive their standard one. This is because
workers may prefer to work less as the wage rate rises as they will be better
off even if they do not work more. Conversely, very low wage rates are likely
to produce a very high supply of labour as workers need to work more to meet
their basic needs. In addition, as noted at the end of [section
C.1.4](secC1.md#secc14), economic theory itself shows that workers will not
get a fair wage when they face very powerful employers unless they organise
unions. [Steve Keen, **Debunking Economics**, pp. 111-2 and pp. 119-23]

Strong evidence that this model of the labour market can be found from the
history of capitalism. Continually we see capitalists turn to the state to
ensure low wages in order to ensure a steady supply of labour (this was a key
aim of state intervention during the rise of capitalism, incidentally). For
example, in central and southern Africa mining companies tried to get locals
to labour. They had little need for money, so they worked a day or two then
disappeared for the rest of the week. To avoid simply introducing slavery,
some colonial administrators introduced and enforced a poll-tax. To earn
enough to pay it, workers had to work a full week. [Hugh Stretton, **Op.
Cit.**, p. 403] Much the same was imposed on British workers at the dawn of
capitalism. As Stephen Marglin points out, the _"indiscipline of the labouring
classes, or more bluntly, their laziness, was widely noted by eighteenth
century observers."_ By laziness or indiscipline, these members of the ruling
class meant the situation where _"as wages rose, workers chose to work less."_
In economic terms, _"a backward bending labour supply curve is a most natural
phenomenon as long as the individual worker controls the supply of labour."_
However, _"the fact that higher wages led workers to choose more leisure . . .
was disastrous"_ for the capitalists. Unsurprisingly, the bosses did not
meekly accept the workings of the invisible hand. Their _"first recourse was
to the law"_ and they _"utilised the legislative, police and judicial powers
of the state"_ to ensure that working class people had to supply as many hours
as the bosses demanded. [_"What do Bosses do?"_, pp. 60-112, **Review of
Radical Political Economy**, Vol. 6, No. 2, pp. 91-4]

This means that the market supply curve _"could have any shape at all"_ and so
economic theory _"fails to prove that employment is determined by supply and
demand, and reinforces the real world observation that involuntary
unemployment can exist"_ as reducing the wage need not bring the demand and
supply of labour into alignment. While the possibility of backward-bending
labour supply curves is sometimes pointed out in textbooks, the assumption of
an upward sloping supply curve is taken as the normal situation but _"there is
no theoretical -- or empirical -- justification for this."_ Sadly for the
world, this assumption is used to draw very strong conclusions by economists.
The standard arguments against minimum wage legislation, trade unions and
demand management by government are all based on it. Yet, as Keen notes, such
important policy positions _"should be based upon robust intellectual or
empirical foundations, rather than the flimsy substrate of mere fancy.
Economists are quite prone to dismiss alternative perspectives on labour
market policy on this very basis -- that they lack any theoretical or
empirical foundations. Yet their own policy positions are based as much on
wishful thinking as on wisdom."_ [**Op. Cit.**, pp. 121-2 and p. 123]

Within a capitalist economy the opposite assumption to that taken by economics
is far more likely, namely that there **is** a backward sloping labour supply
curve. This is because the decision to work is **not** one based on the choice
between wages and leisure made by the individual worker. Most workers do
**not** choose whether they work or not, and the hours spent working, by
comparing their (given) preferences and the level of real wages. They do
**not** practice voluntary leisure waiting for the real wage to exceed their
so-called _"reservation"_ wage (i.e. the wage which will tempt them to forsake
a life of leisure for the disutility of work). Rather, most workers have to
take a job because they do not have a choice as the alternative is poverty (at
best) or starvation and homelessness (at worse). The real wage influences the
decision on how much labour to supply rather than the decision to work or not.
This is because as workers and their families have a certain basic living
standard to maintain and essential bills which need to be paid. As earnings
increase, basic costs are covered and so people are more able to work less and
so the supply of labour tends to fall. Conversely, if real earnings fall
because the real wage is less then the supply of labour may **increase** as
people work more hours and/or more family members start working to make enough
to cover the bills (this is because, once in work, most people are obliged to
accept the hours set by their bosses). This is the opposite of what happens in
"normal" markets, where lower prices are meant to produce a **decrease** in
the amount of the commodity supplied. In other words, the labour market is not
a market, i.e. it reacts in different ways than other markets (Stretton
provides a good summary of this argument [**Op. Cit.**, pp. 403-4 and p.
491]).

So, as radical economists have correctly observe, such considerations undercut
the "free market" capitalist contention that labour unions and state
intervention are responsible for unemployment (or that depressions will easily
or naturally end by the workings of the market). To the contrary, insofar as
labour unions and various welfare provisions prevent demand from falling as
low as it might otherwise go during a slump, they apply a brake to the
downward spiral. Far from being responsible for unemployment, they actually
mitigate it. For example, unions, by putting purchasing power in the hands of
workers, stimulates demand and keeps employment higher than the level it would
have been. Moreover, wages are generally spent immediately and completely
whilst profits are not. A shift from profits to wages may stimulate the
economy since more money is spent but there will be a delayed cut in
consumption out of profits. [Malcolm Sawyer, **The Economics of Michal
Kalecki**, p. 118] All this should be obvious, as wages (and benefits) may be
costs for some firms but they are revenue for even more and labour is not like
other commodities and reacts in changes in price in different ways.

Given the dynamics of the labour "market" (if such a term makes much sense
given its atypical nature), any policies based on applying "economics 101" to
it will be doomed to failure. As such, any book entitled **Economics in One
Lesson** must be viewed with suspicion unless it admits that what it expounds
has little or no bearing to reality and urges the reader to take at least the
second lesson. Of course, a few people actually do accept the simplistic
arguments that reside in such basic economics texts and think that they
explain the world (these people usually become right-"libertarians" and spend
the rest of their lives ignoring their own experience and reality in favour of
a few simple axioms). The wage-cutting argument (like most of economics)
asserts that any problems are due to people not listening to economists and
that there is no economic power, there are no "special interests" -- it is
just that people are stupid. Of course, it is irrelevant that it is much
easier to demand that workers' real wages be reduced when you are sitting in a
tenured post in academia. True to their ideals and "science", it is refreshing
to see how many of these "free market" economists renounce tenure so that
their wages can adjust automatically as the market demand for their
ideologically charged comments changes.

So when economic theories extol suffering for future benefits, it is always
worth asking who suffers, and who benefits. Needless to say, the labour market
flexibility agenda is anti-union, anti-minimum wage, and anti-worker
protection. This agenda emerges from theoretical claims that price flexibility
can restore full employment, and it rests dubious logic, absurd assumptions
and on a false analogy comparing the labour market with the market for
peanuts. Which, ironically, is appropriate as the logic of the model is that
workers will end up working for peanuts! As such, the "labour market" model
has a certain utility as it removes the problem of institutions and, above
all, power from the perspective of the economist. In fact, institutions such
as unions can only be considered as a problem in this model rather than a
natural response to the unique nature of the labour "market" which, despite
the obvious differences, most economists treat like any other.

To conclude, a cut in wages may deepen any slump, making it deeper and longer
than it otherwise would be. Rather than being the solution to unemployment,
cutting wages will make it worse (we will address the question of whether
wages being too high actually causes unemployment in the first place, in the
[next section](secC9.md#secc92)). Given that, as we argued in [section
C.8.2](secC8.md#secc82), inflation is caused by insufficient profits for
capitalists (they try to maintain their profit margins by price increases)
this spiralling effect of cutting wages helps to explain what economists term
_"stagflation"_ \-- rising unemployment combined with rising inflation (as
seen in the 1970s). As workers are made unemployed, aggregate demand falls,
cutting profit margins even more and in response capitalists raise prices in
an attempt to recoup their losses. Only a very deep recession can break this
cycle (along with labour militancy and more than a few workers and their
families).

Thus the capitalist solution to crisis is based on working class people paying
for capitalism's contradictions. For, according to the mainstream theory, when
the production capacity of a good exceeds any reasonable demand for it, the
workers must be laid off and/or have their wages cut to make the company
profitable again. Meanwhile the company executives -- the people responsible
for the bad decisions to build lots of factories -- continue to collect their
fat salaries, bonuses and pensions, and get to stay on to help manage the
company through its problems. For, after all, who better, to return a company
to profitability than those who in their wisdom ran it into bankruptcy?
Strange, though, no matter how high their salaries and bonuses get, managers
and executives **never** price **themselves** out of work.

All this means that working class people have two options in a slump -- accept
a deeper depression in order to start the boom-bust cycle again or get rid of
capitalism and with it the contradictory nature of capitalist production which
produces the business cycle in the first place (not to mention other blights
such as hierarchy and inequality). In the end, the only solution to
unemployment is to get rid of the system which created it by workers seizing
their means of production and abolishing the state. When this happens, then
production for the profit of the few will be ended and so, too, the
contradictions this generates.

## C.9.2 Is unemployment caused by wages being too high?

As we noted in the [last section](secC9.md#secc91), most capitalist economic
theories argue that unemployment is caused by wages being too high. Any
economics student will tell you that labour is like any other commodity and so
if its price is too high then there will be less demand for it, so producing
an excess supply of it on the market. Thus high wages will reduce the quantity
of labour demanded and so create unemployment -- a simple case of "supply and
demand."

From this theory we would expect that areas and periods with high wages will
also have high levels of unemployment. Unfortunately for the theory, this does
not seem to be the case. Even worse for it, high wages are generally
associated with booms rather than slumps and this has been known to mainstream
economics since at least 1939 when in March of that year **The Economic
Journal** printed an article by Keynes about the movement of real wages during
a boom in which he evaluated the empirical analysis of two labour economists
(entitled _"Relative Movements of Real Wages and Output"_ this is contained as
an Appendix of most modern editions of **The General Theory**).

These studies showed that _"when money wages are rising, real wages have
usually risen too; whilst, when money wages are falling, real wages are no
more likely to rise than to fall."_ Keynes admitted that in **The General
Theory** he was _"accepting, without taking care to check the facts"_, a
_"widely held"_ belief. He discussed where this belief came from, namely
leading 19th century British economist Alfred Marshall who had produced a
_"generalisation"_ from a six year period between 1880-86 which was not true
for the subsequent business cycles of 1886 to 1914. He also quotes another
leading economist, Arthur Pigou, from 1927 on how _"the upper halves of trade
cycles have, on the whole, been associated with higher rates of real wages
than the lower halves"_ and indicates that he provided evidence on this from
1850 to 1910 (although this did not stop Pigou reverting to the _"Marshallian
tradition"_ during the Great Depression and blaming high unemployment on high
wages). [**The General Theory**, p. 394, p. 398 and p. 399] Keynes conceded
the point, arguing that he had tried to minimise differences between his
analysis and the standard perspective. He stressed that while he assumed
countercyclical real wages his argument did not depend on it and given the
empirical evidence provided by labour economists he accepted that real wages
were pro-cyclical in nature.

The reason why this is the case is obvious given the analysis in the [last
section](secC9.md#secc91). Labour does not control prices and so cannot
control its own real wage. Looking at the Great Depression, it seems difficult
to blame it on workers refusing to take pay cuts when by 1933 _"wages and
salaries in U.S. manufacturing were less than half their 1929 levels and, in
automobiles and steel, were under 40 percent of the 1929 levels."_ In Detroit,
there had been 475,000 auto-workers. By 1931 _"almost half has been laid
off."_ [William Lazonick, **Competitive Advantage on the Shop Floor**, p. 271]
The notion of all powerful unions or workers' resistance to wage cuts causing
high unemployment hardly fits these facts. Peter Temin provides information on
real wages in manufacturing during the depression years. Using 1929 as the
base year, weekly average real wages (i.e., earnings divided by the consumer
price index) fell each year to reach a low of 85.5% by 1932. Hourly real wages
remained approximately constant (rising to 100.1% in 1930 and then 102.6% in
1931 before falling to 99% in 1932). The larger fall in weekly wages was due
to workers having a shorter working week. The _"effect of shorter hours and
lower wages was to decrease the income of employed workers."_ Thus the notion
that lowering wages will increase employment seems as hard to support as the
notion that wages being too high caused the depression in the first place.
Temin argues, _"no part of the [neo-]classical story is accurate."_ [**Did
Monetary Forces Cause the Great Depression?**, pp. 139-40] It should be noted
that the consensus of economists is that during this period the evidence seems
to suggest that real wages **did** rise overall. This was because the prices
of commodities fell faster than did the wages paid to workers. Which confirms
Keynes, as he had argued that workers cannot price themselves into work as
they have no control over prices. However, there is no reason to think that
high real wages caused the high unemployment as the slump itself forced
producers to cut prices (not to mention wages). Rather, the slump caused the
increase in real wages.

Since then, economists have generally confirmed that real wage are
procyclical. In fact, _"a great deal of empirical research has been conducted
in this area -- research which mostly contradicts the neo-classical assumption
of an inverse relation between real wages and employment."_ [Ferdinando
Targetti, **Nicholas Kaldor**, p. 50] Nicholas Kaldor, one of the first
Keynesians, also stressed that the notion that there is an inverse
relationship between real wages and employment is _"contradicted by numerous
empirical studies which show that, in the short period, changes in real wages
are positively correlated with changes in employment and not negatively."_
[**Further Essays on Economic Theory and Policy**, p. 114fn] As Hugh Stretton
summarises in his excellent introductory text on economics:

> _"In defiance of market theory, the demand for labour tends strongly to vary
**with** its price, not inversely to it. Wages are high when there is full
employment. Wages -- especially for the least-skilled and lowest paid -- are
lowest when there is least employment. The causes chiefly run from the
employment to the wages, rather than the other way. Unemployment weakens the
bargaining power, worsens the job security and working conditions, and lowers
the pay of those still in jobs.  
>  _

>

> _"The lower wages do not induce employers to create more jobs . . . most
business firms have no reason to take on more hands if wages decline. Only
empty warehouses, or the prospect of more sales can get them to do that, and
these conditions rarely coincide with falling employment and wages. The causes
tend to work the other way: unemployment lowers wages, and the lower wages do
not restore the lost employment."_ [**Economics: A New Introduction**, pp.
401-2]

Will Hutton, the British neo-Keynesian economist, summarises research by two
other economists that suggests high wages do not cause unemployment:

> _"the British economists David Blanchflower and Andrew Oswald [examined] . .
. the data in twelve countries about the actual relation between wages and
unemployment -- and what they have discovered is another major challenge to
the free market account of the labour market. Free market theory would predict
that low wages would be correlated with low local unemployment; and high wages
with high local unemployment.  
>  _

>

> _"Blanchflower and Oswald have found precisely the opposite relationship.
The higher the wages, the lower the local unemployment -- and the lower the
wages, the higher the local unemployment. As they say, this is not a
conclusion that can be squared with free market text-book theories of how a
competitive labour market should work."_ [**The State We're In**, p. 102]

Unemployment was highest where real wages were lowest and nowhere had falling
wages being followed by rising employment or falling unemployment.
Blanchflower and Oswald stated that their conclusion is that employees _"who
work in areas of high unemployment earn less, other things constant, than
those who are surrounded by low unemployment."_ [**The Wage Curve**, p. 360]
This relationship, the exact opposite of that predicted by "free market"
capitalist economics, was found in many different countries and time periods,
with the curve being similar for different countries. Thus, the evidence
suggests that high unemployment is associated with low earnings, not high, and
vice versa.

Looking at less extensive evidence, if minimum wages and unions cause
unemployment, why did the South-eastern states of the USA (with a **lower**
minimum wage and weaker unions) have a **higher** unemployment rate than
North-western states during the 1960s and 1970s? Or why, when the (relative)
minimum wage declined under Reagan and Bush in the 1980s, did chronic
unemployment accompany it? [Allan Engler, **The Apostles of Greed**, p. 107]
Or the **Low Pay Network** report _"Priced Into Poverty"_ which discovered
that in the 18 months before they were abolished, the British Wages Councils
(which set minimum wages for various industries) saw a rise of 18,200 in full-
time equivalent jobs compared to a net loss of 39,300 full-time equivalent
jobs in the 18 months afterwards. Given that nearly half the vacancies in
former Wages Council sectors paid less than the rate which it is estimated
Wages Councils would now pay, and nearly 15% paid less than the rate at
abolition, there should (by the "free market" argument) have been rises in
employment in these sectors as pay fell. The opposite happened. This research
shows that the falls in pay associated with Wages Council abolition had not
created more employment. Indeed, employment growth was more buoyant prior to
abolition than subsequently. So whilst Wages Council abolition did not result
in more employment, the erosion of pay rates caused by their abolition
resulted in more families having to endure poverty pay. Significantly, the
introduction of a national minimum wage by the first New Labour government did
not have the dire impact "free market" capitalist economists and politicians
predicted.

It should also be noted that an extensive analysis of the impact of minimum
wage increases at the state level in America by economists David Card and Alan
Kreuger found the facts contradicted the standard theory, with rises in the
minimum wage having a small positive impact on both employment and wages for
all workers. [**Myth and Measurement: The New Economics of the Minimum Wage**]
While their work was attacked by business leaders and economists from think-
tanks funded by them, Card and Kreuger's findings that raising the lowest
wages had no effect on unemployment or decreased it proved to be robust. In
particular, when replying to criticism of their work by other economists who
based their work, in part, on data supplied by a business funded think-tank
Card and Krueger discovered that not only was that work consistent with their
original findings but that the _"only data set that indicates a significant
decline in employment"_ was by some amazing coincidence _"the small set of
restaurants collected by"_ the think tank. [_"Minimum Wages and Employment: A
Case Study of the Fast-Food Industry in New Jersey and Pennsylvania: Reply"_,
pp. 1397-1420, **The American Economic Review**, Vol. 90, No. 5, p. 1419] For
a good overview of _"how the fast food industry and its conservative allies
sought to discredit two distinguished economists, and how the attack
backfired"_ when _"the two experts used by the fast food industry to impeach
Card and Krueger, effectively ratified them"_ see John Schmitt's _"Behind the
Numbers: Cooked to Order."_ [**The American Prospect**, May-June 1996, pp.
82-85]

(This does not mean that anarchists support the imposition of a legal minimum
wage. Most anarchists do not because it takes the responsibility for wages
from unions and other working class organisations, where it belongs, and
places it in the hands of the state. We mention these examples in order to
highlight that the "free market" capitalist argument has serious flaws with
it.)

Empirical evidence does not support the argument the "free market" capitalist
argument that unemployment is caused by real wages being too high. The
phenomenon that real wages tend to increase during the upward swing of the
business cycle (as unemployment falls) and fall during recessions (when
unemployment increases) renders the standard interpretation that real wages
govern employment difficult to maintain (real wages are _"pro-cyclical,"_ to
use economic terminology). This evidence makes it harder for economists to
justify policies based on a direct attack on real wages as the means to cure
unemployment.

While this evidence may come as a shock to those who subscribe to the
arguments put forward by those who think capitalist economics reflect the
reality of that system, it fits well with the anarchist and other socialist
analysis. For anarchists, unemployment is a means of disciplining labour and
maintaining a suitable rate of profit (i.e. unemployment is a key means of
ensuring that workers are exploited). As full employment is approached,
labour's power increases, so reducing the rate of exploitation and so
increasing labour's share of the value it produces (and so higher wages).
Thus, from an anarchist point of view, the fact that wages are higher in areas
of low unemployment is not a surprise, nor is the phenomenon of pro-cyclical
real wages. After all, as we noted in [section C.3](secC3.md), the ratio
between wages and profits are, to a large degree, a product of bargaining
power and so we would expect real wages to grow in the upswing of the business
cycle, fall in the slump and be high in areas of low unemployment.

The evidence therefore suggests that the "free market" capitalist claim that
unemployment is caused by unions, "too high" wages, and so on, is false.
Indeed, by stopping capitalists appropriating more of the income created by
workers, high wages maintain aggregate demand and contribute to higher
employment (although, of course, high employment cannot be maintained
indefinitely under wage slavery due to the rise in workers' power this
implies). Rather, unemployment is a key aspect of the capitalist system and
cannot be got rid off within it. The "free market" capitalist "blame the
workers" approach fails to understand the nature and dynamic of the system
(given its ideological role, this is unsurprising). So high real wages for
workers increases aggregate demand and reduces unemployment from the level it
would be if the wage rate was cut. This is supported by most of the research
into wage dynamics during the business cycle and by the _"wage curve"_ of
numerous countries. This suggests that the demand for labour is independent of
the real wages and so the price of labour (wages) is incapable of performing
any market clearing function. The supply and demand for labour are determined
by two different sets of factors. The relationship between wages and
unemployment flows from the latter to the former rather than the reverse: the
wage is influenced by the level of unemployment. Thus wages are not the
product of a labour market which does not really exist but rather is the
product of _"institutions, customs, privilege, social relations, history, law,
and above all power, with an admixture of ingenuity and luck. But of course
power, and particularly market or monopoly power, changes with the general of
demand, the rate of growth, and the rate of unemployment. In periods of high
employment, the weak gain on the strong; in periods of high unemployment, the
strong gain on the weak."_ [Galbraith, **Created Unequal**, p. 266]

This should be obvious enough. It is difficult for workers to resist wage cuts
and speeds-up when faced with the fear of mass unemployment. As such, higher
rates of unemployment _"reduce labour's bargaining power vis-a-vis business,
and this helps explain why wages have declined and workers have not received
their share of productivity growth"_ (between 1970 and 1993, only the top 20%
of the US population increased its share of national income). [Thomas I.
Palley, **Plenty of Nothing**, p. 55 and p. 58] Strangely, though, this
obvious fact seems lost on most economists. In fact, if you took their
arguments seriously then you would have to conclude that depressions and
recessions are the periods during which working class people do the best! This
is on two levels. First, in neo-classical economics work is considered a
disutility and workers decide not to work at the market-clearing real wage
because they prefer leisure to working. Leisure is assumed to be intrinsically
good and the wage the means by which workers are encouraged to sacrifice it.
Thus high unemployment must be a good thing as it gives many more people
leisure time. Second, for those in work their real wages are higher than
before, so their income has risen. Alfred Marshall, for example, argued that
in depressions money wages fell but not as fast as prices. A _"powerful
friction"_ stopped this, which _"establish[ed] a higher standard of living
among the working classes"_ and a _"diminish[ing of] the inequalities of
wealth."_ When asked whether during a period of depression the employed
working classes got more than they did before, he replied _"[m]ore than they
did before, on the average."_ [quoted by Keynes, **Op. Cit.**, p. 396]

Thus, apparently, working class people do worse in booms than in slumps and,
moreover, they can resist wage cuts more in the face of mass unemployment than
in periods approaching full employment. That the theory which produced these
conclusions could be taken remotely seriously shows the dangers of deducing an
economic ideology from a few simple axioms rather than trusting in empirical
evidence and common sense derived from experience. Nor should it come as too
great a surprise, as "free market" capitalist economics tends to ignore (or
dismiss) the importance of economic power and the social context within which
individuals make their choices. As Bob Black acidly put it with regards to the
1980s, it _"wasn't the **workers** who took these gains [of increased
productivity], not in higher wages, not in safer working conditions, and not
in shorter hours -- hours of work have **increased** . . . It must be, then,
that in the 80s and after workers have 'chosen' lower wages, longer hours
**and** greater danger on the job. Yeah, sure."_ [_"Smokestack Lightning,"_
pp. 43-62, **Friendly Fire**, p. 61]

In the real world, workers have little choice but to accept a job as they have
no independent means to exist in a pure capitalist system and so no wages
means no money for buying such trivialities as food and shelter. The decision
to take a job is, for most workers, a non-decision -- paid work is undertaken
out of economic necessity and so we are not in a position to refuse work
because real wages are too low to be worth the effort (the welfare state
reduces this pressure, which is why the right and bosses are trying to destroy
it). With high unemployment, pay and conditions will worsen while hours and
intensity of labour will increase as the fear of the sack will result in
increased job insecurity and so workers will be more willing to placate their
bosses by obeying and not complaining. Needless to say, empirical evidence
shows that _"when unemployment is high, inequality rises. And when
unemployment is low, inequality tends to fall."_ [James K. Galbraith, **Op.
Cit.**, p. 148] This is unsurprising as the _"wage curve"_ suggests that it is
unemployment which drives wage levels, not the other way round. This is
important as higher unemployment would therefore create higher inequality as
workers are in no position to claim back productivity increases and so wealth
would flood upwards.

Then there is the issue of the backward-bending supply curve of labour we
discussed at the end of the [last section](secC9.md#secc91). As the "labour
market" is not really a market, cutting real wages will have the opposite
effect on the supply of labour than its supporters claim. It is commonly found
that as real wages fall, hours at work become longer and the number of workers
in a family increases. This is because the labour supply curve is negatively
slopped as families need to work more (i.e., provide more labour) to make ends
meet. This means that a fall in real wages may **increase** the supply of
labour as workers are forced to work longer hours or take second jobs simply
to survive. The net effect of increasing supply would be to **decrease** real
wages even more and so, potentially, start a vicious circle and make the
recession deeper. Looking at the US, we find evidence that supports this
analysis. As the wages for the bottom 80% of the population fell in real terms
under Reagan and Bush in the 1980s, the number of people with multiple jobs
increased as did the number of mothers who entered the labour market. In fact,
_"the only reason that family income was maintained is the massive increase in
labour force participation of married women . . . Put simply, jobs paying
family wages have been disappearing, and sustaining a family now requires that
both adults work . . . The result has been a squeeze on the amount of time
that people have for themselves . . . there is a loss of life quality
associated with the decline in time for family . . . they have also been
forced to work longer . . . Americans are working longer just to maintain
their current position, and the quality of family life is likely declining. A
time squeeze has therefore accompanied the wage squeeze."_ [Palley, **Op.
Cit.**, pp. 63-4] That is, the supply of labour **increased** as its price
fell (Reagan's turn to military Keynesianism and incomplete nature of the
"reforms" ensured that a deep spiral was avoided).

To understand why this is the case, it is necessary to think about how the
impact of eliminating the minimum wage and trade unions would actually have.
First, of course, there would be a drop in the wages of the poorest workers as
the assertion is that the minimum wage increases unemployment by forcing wages
up. The assertion is that the bosses would then employ more workers as a
result. However, this assumes that extra workers could easily be added to the
existing capital stock which may not be the case. Assuming this is the case
(and it **is** a big assumption), what happens to the workers who have had
their pay cut? Obviously, they still need to pay their bills which means they
either cut back on consumption and/or seek more work (assuming that prices
have not fallen, as this would leave the real wage unchanged). If the former
happens, then firms may find that they face reduced demand for their products
and, consequently, have no need for the extra employees predicted by the
theory. If the latter happens, then the ranks of those seeking work will
increase as people look for extra jobs or people outside the labour market
(like mothers and children) are forced into the job market. As the supply of
workers increase, wages **must** drop according to the logic of the "free
market" position. This does not mean that a recovery is impossible, just that
in the short and medium terms cutting wages will make a recession worse and be
unlikely to **reduce** unemployment for some time.

This suggests that a "free market" capitalism, marked by a fully competitive
labour market, no welfare programmes nor unemployment benefits, and extensive
business power to break unions and strikes would see aggregate demand
constantly rise and fall, in line with the business cycle, and unemployment
and inequality would follow suit. Moreover, unemployment would be higher over
most of the business cycle (and particularly at the bottom of the slump) than
under a capitalism with social programmes, militant unions and legal rights to
organise because the real wage would not be able to stay at levels that could
support aggregate demand nor could the unemployed use their benefits to
stimulate the production of consumer goods. This suggests that a fully
competitive labour market, as in the 19th century, would increase the
instability of the system -- an analysis which was confirmed in during the
1980s (_"the relationship between measured inequality and economic stability .
. . was weak but if anything it suggests that the more egalitarian countries
showed a more stable pattern of growth after 1979."_ [Dan Corry and Andrew
Glyn, _"The Macroeconomics of equality, stability and growth"_, **Paying for
Inequality**, Andrew Glyn and David Miliband (eds.) pp. 212-213]).

So, in summary, the available evidence suggests that **high** wages are
associated with **low** levels of unemployment. While this should be the
expected result from any realistic analysis of the economic power which marks
capitalist economies, it does not provide much support for claims that only by
cutting real wages can unemployment be reduced. The "free market" capitalist
position and one based on reality have radically different conclusions as well
as political implications. Ultimately, most laissez-faire economic analysis is
unpersuasive both in terms of the facts and their logic. While economics may
be marked by axiomatic reasoning which renders everything the markets does as
optimal, the problem is precisely that it is pure axiomatic reasoning with
little or no regard for the real world. Moreover, by some strange coincidence,
they usually involve policy implications which generally make the rich richer
by weakening the working class. Unsurprisingly, decades of empirical evidence
have not shifted the faith of those who think that the simple axioms of
economics take precedence over the real world nor has this faith lost its
utility to the economically powerful.

## C.9.3 Are "flexible" labour markets the answer to unemployment?

The usual "free market" capitalist (or neo-liberal) argument is that labour
markets must become more "flexible" to solve the problem of unemployment. This
is done by weakening unions, reducing (or abolishing) the welfare state, and
so on. In defence of these policies, their proponents point to the low
unemployment rates of the USA and UK and contrast them to the claimed economic
woes of Europe (particularly France and Germany). As we will indicate in this
section, this stance has more to do a touching faith that deregulating the
labour market brings the economy as a whole closer to the ideal of "perfect
competition" than a balanced analysis and assessment of the available
evidence. Moreover, it is always important to remember, as tenured economists
(talking of protective labour market institutions!) seem to forget, that
deregulation can and does have high economic (and not to mention individual
and social) costs too.

The underlying argument for flexible labour markets is the notion that
unemployment is cased by wages being too high and due to market imperfections
wages are sticky downwards. While both claims, as we have seen above, are
dubious both factually and logically this has not stopped this position
becoming the reigning orthodoxy in elite circles. By market imperfections it
is meant trade unions, laws which protect labour, unemployment benefit and
other forms of social welfare provision (and definitely **not** big business,
patent and copyright laws, or any other pro-business state interventions). All
these ensure that wages for those employed are inflexible downwards and the
living standards of those unemployed are too high to induce them to seek work.
This means that orthodox economics is based on (to use John Kenneth
Galbraith's justly famous quip) the assumption that the rich do not work
because they are paid too little, while the poor do not work because they are
paid too much.

We should first point out that attacks on social welfare have a long pedigree
and have been conducted with much the same rationale -- it made people lazy
and gave them flexibility when seeking work. For example, the British **Poor
Law Report** of the 1830s _"built its case against relief on the damage done
by poor relief to personal morality and labour discipline (much the same thing
in the eyes of the commissioners)."_ [David McNally, **Against the Market**,
p. 101] The report itself stated that _"the greatest evil"_ of the system was
_"the spirit of laziness and insubordination that it creates."_ [quoted by
McNally, **Op. Cit.**, p. 101]

While the rhetoric used to justify attacks on welfare has changed somewhat
since then, the logic and rationale have not. They have as their root the need
to eliminate anything which provided working class people any means for
independence from the labour market. It has always aimed to ensure that the
fear of the sack remains a powerful tool in the bosses arsenal and to ensure
that their authority is not undermined. Ironically, therefore, its underlying
aims are to **decrease** the options available to working class people, i.e.
to reduce **our** flexibility within the labour market by limiting our options
to finding a job fast or face dire poverty (or worse).

Secondly, there is a unspoken paradox to this whole process. If we look at the
stated, public, rationale behind "flexibility" we find a strange fact. While
the labour market is to be made more "flexible" and in line with ideal of
"perfect competition", on the capitalist side no attempt is being made to
bring **it** into line with that model. Let us not forget that perfect
competition (the theoretical condition in which all resources, including
labour, will be efficiently utilised) states that there must be a large number
of buyers and sellers. This is the case on the sellers side of the "flexible"
labour market, but this is **not** the case on the buyers (where, as indicated
in [section C.4](secC4.md), oligopoly reigns). Most who favour labour market
"flexibility" are also those most against the breaking up of big business and
oligopolistic markets or are against attempts to stop mergers between dominant
companies in and across markets. Yet the model requires **both** sides to be
made up of numerous small firms without market influence or power. So why
expect making one side more "flexible" will have a positive effect on the
whole?

There is no logical reason for this to be the case and as we noted in [section
C.1.4](secC1.md#secc14), neo-classical economics agrees -- in an economy
with both unions and big business, removing the former while retaining the
latter will **not** bring it closer to the ideal of perfect competition. With
the resulting shift in power on the labour market things will get worse as
income is distributed from labour to capital. Which is, we must stress,
precisely what **has** happened since the 1980s and the much lauded "reforms"
of the labour market. It is a bit like expecting peace to occur between two
warring factions by disarming one side and arguing that because the number of
guns have been halved peacefulness has doubled! Of course, the only "peace"
that would result would be the peace of the graveyard or a conquered people --
subservience can pass for peace, if you do not look too close. In the end,
calls for the "flexibility" of labour indicate the truism that, under
capitalism, labour exists to meet the requirements of capital (or living
labour exists to meet the needs of dead labour, a truly insane way to organise
a society).

Then there is the key question of comparing reality with the rhetoric. As
economist Andrew Glyn points out, the neo-liberal orthodoxy on this issue
_"has been strenuously promoted despite weak evidence for the magnitude of its
benefits and in almost total neglect of its costs."_ In fact, _"there is no
evidence that the countries which carried out more reforms secured significant
falls in unemployment."_ This is perhaps unsurprising as _"there is plenty of
support for such deregulation from business even without strong evidence that
unemployment would be reduced."_ As far as welfare goes, the relationship
between unemployment and benefits is, if anything, in the 'wrong' direction
(higher benefits do along with lower unemployment). Of course there are a host
of other influences on unemployment but _"if benefits were very important we
might expect **some** degree of correlation in the 'right' (positive)
direction . . . such a lack of simple relation with unemployment applies to
other likely suspects such as employment protection and union membership."_
[**Capitalism Unleashed**, p. 48, p. 121, p. 48 and p. 47]

Nor is it mentioned that the history of labour market flexibility is somewhat
at odds with the theory. It is useful to remember that American unemployment
was far worse than Europe's during the 1950s, 60s and 70s. In fact, it did not
get better than the European average until the second half of the 1980s.
[David R. Howell, _"Introduction"_, pp. 3-34, **Fighting Unemployment**, David
R. Howell (ed.), pp. 10-11] To summarise:

> _"it appears to be only relatively recently that the maintained greater
flexibility of US labour markets has apparently led to a superior performance
in terms of lower unemployment, despite the fact this flexibility is no new
phenomenon. Comparing, for example, the United States with the United Kingdom,
in the 1960s the United States averaged 4.8 per cent, with the United Kingdom
at 1.9 per cent; in the 1970s the United States rate rose to 6.1 per cent,
with the United Kingdom rising to 4.3 per cent, and it was only in the 1980s
that the ranking was reversed with the United States at 7.2 per cent and the
United Kingdom at 10 per cent. . . Notice that this reversal of rankings in
the 1980s took place despite all the best efforts of Mrs Thatcher to create
labour market flexibility. . . [I]f labour market flexibility is important in
explaining the level of unemployment. . . why does the level of unemployment
remain so persistently high in a country, Britain, where active measures have
been taken to create flexibility?"_ [Keith Cowling and Roger Sugden, **Beyond
Capitalism**, p. 9]

If we look at the fraction of the labour force without a job in America, we
find that in 1969 it was 3.4% (7.3% including the underemployed) and **rose**
to 6.1% in 1987 (16.8% including the underemployed). Using more recent data,
we find that, on average, the unemployment rate was 6.2% in 1990-97 compared
to 5.0% in the period 1950-65. In other words, labour market "flexibility" has
not reduced unemployment levels, in fact "flexible" labour markets have been
associated with higher levels of unemployment. Of course, we are comparing
different time periods. A lot changed between the 1960s and the 1990s and so
comparing these periods cannot be the whole answer. However, it does seem
strange that the period with stronger unions, higher minimum wages and more
generous welfare state should be associated with **lower** unemployment than
the subsequent "flexible" period. It is possible that the rise in flexibility
and the increase in unemployment may be unrelated. If we look at different
countries over the same time period we can see if "flexibility" actually
reduces unemployment. As one British economist notes, this may not be the
case:

> _"Open unemployment is, of course, lower in the US. But once we allow for
all forms of non-employment [such as underemployment, jobless workers who are
not officially registered as such and so on], there is little difference
between Europe and the US: between 1988 and 1994, 11 per cent of men aged
25-55 were not in work in France, compared with 13 per cent in the UK, 14 per
cent in the US and 15 per cent in Germany."_ [Richard Layard, quoted by John
Gray, **False Dawn**, p. 113]

Also when evaluating the unemployment records of a country, other factors than
the "official" rate given by the government must taken into account. Firstly,
different governments have different definitions of what counts as
unemployment. As an example, the USA has a more restrictive definition of who
is unemployed than Germany. For example, in 2005 Germany's unemployment rate
was officially 11.2%. However, using the US definition it was only around 9%
(7% in what was formerly West Germany). The offical figure was higher as it
included people, such as those involuntarily working part-time, as being
unemployed who are counted as being employed in the USA. America, in the same
year, had an unemployment rate of around 5%. So comparing unadjusted
unemployment figures will give a radically different picture of the problem
than using standardised ones. Sadly far too often business reporting in
newspapers fail to do this.

In addition, all estimates of America's unemployment record must take into
account its incarceration rates. The prison population is not counted as part
of the labour force and so is excluded when calculating unemployment figures.
This is particularly significant as those in prison are disproportionately
from demographic groups with very high unemployment rates and so it is likely
that a substantial portion of these people would be unemployed if they were
not in jail. If America and the UK did not have the huge surge in prison
population since the 1980s neo-liberal reforms, the unemployment rate in both
countries would be significantly higher. In the late 1990s, for example, more
than a million extra people would be seeking work if the US penal policies
resembled those of any other Western nation. [John Gray, **Op. Cit.**, p. 113]
England and Wales, unsurprisingly, tops the prison league table for Western
Europe. In 2005, 145 per 100,000 of their population was incarcerated. In
comparison, France had a rate of 88 while Germany had one of 97. This would,
obviously, reduce the numbers of those seeking work on the labour market and,
consequently, reduce the unemployment statistics.

While the UK is praised for its "flexible" labour market in the 2000s, many
forget the price which was paid to achieve it and even more fail to realise
that the figures hide a somewhat different reality. It is therefore essential
to remember Britain's actual economic performance during Thatcher's rule
rather than the "economically correct" narrative we have inherited from the
media and economic "experts." When Thatcher came to office in 1979 she did so
promising to end the mass unemployment experienced under Labour (which had
doubled between 1974 and 1979). Unemployment then tripled in her first term,
rising to over 3 million in 1982 (for the first time since the 1930s,
representing 1 in 8 people). This was due in large part to the application of
Monetarist dogma making the recession far worse than it had to be.
Unemployment remained at record levels throughout the 1980s, only dropping to
below its 1979 level in 1997 when New Labour took office. It gets worse. Faced
with unemployment rising to well over 10%, Thatcher's regime did what any
respectable government would -- it cooked the books. It changed how
unemployment was recorded in order to artificially lower the official
unemployment records. It also should be stressed that the UK unemployment
figures do not take into account the Thatcherite policy of shunting as many
people as possible off the unemployment roles and onto sickness and incapacity
benefits during the 1980s and 1990s (_"In some countries, like the UK and the
Netherlands, many [of the unemployed] found their way onto sickness benefit .
. . Across the UK, for example, there was a strong positive correlation
between numbers on sickness benefits and the local unemployment rate."_ [Glyn,
**Op. Cit.**, p. 107]). Once these "hidden" people are included the
unemployment figures of Britain are similar to those countries, such as France
and Germany, who are more honest in recording who is and is not unemployed.

Eighteen years of high unemployment and a massive explosion in those on
incapacity benefits is hardly an advert for the benefits of "flexible" labour
market. However, a very deep recession, double-figure unemployment for most of
the decade, defeats for key strikes and unions plus continued high
unemployment for nearly two decades had an impact on the labour movement. It
made people willing to put up with anything in order to remain in work. Hence
Thatcher's "economic miracle" -- the working class finally knew its place in
the social hierarchy.

Thus, if a politician is elected who is hailed by the right as a "new
Thatcher", i.e., seeking to "reform" the economy (which is "economically
correct" speak for using the state to break working class militancy) then
there are some preconditions required before they force their populations down
the road to (private) serfdom. They will have to triple unemployment in under
three years and have such record levels last over a decade, provoke the
deepest recession since the 1930s, oversee the destruction of the
manufacturing sector and use the powers of the state to break the mass
protests and strikes their policies will provoke. Whether they are successful
depends on the willingness of working class people to stand up for their
liberties and rights and so impose, from the streets, the changes that really
needed -- changes that politicians will not, indeed cannot, achieve.

Nor should it be forgotten that here are many European countries with around
the same, or lower, official unemployment rates as the UK with much less
"flexible" labour markets. Taking the period 1983 to 1995, we find that around
30 per cent of the population of OECD Europe lived in countries with average
unemployment rates lower than the USA and around 70 per cent in countries with
lower unemployment than Canada (whose wages are only slightly less flexible
than the USA). Furthermore, the European countries with the lowest
unemployment rates were not noted for their labour market flexibility (Austria
3.7%, Norway 4.1%, Portugal 6.4%, Sweden 3.9% and Switzerland 1.7%). Britain,
which probably had the most flexible labour market had an average unemployment
rate higher than half of Europe. And the unemployment rate of Germany is
heavily influenced by areas which were formally in East Germany. Looking at
the former West German regions only, unemployment between 1983 and 1995 was
6.3%, compared to 6.6% in the USA (and 9.8% in the UK). This did not change
subsequently. There are many regulated European countries with lower
unemployment than the USA (in 2002, 10 of 18 European countries had lower
unemployment rates). Thus:

> _"Often overlooked in the 1990s in the rush to embrace market fundamentalism
and to applaud the American model was the fact that several European countries
with strong welfare states consistently reported unemployment rates well below
that of the United States . . . At the same time, other European welfare
sates, characterised by some of the lowest levels of wage inequality and the
highest levels of social protection in the developed world, experienced
substantial declines in unemployment over the 1990s, reaching levels that are
now below that of the United States."_ [David R. Howell, _"Conclusion"_, pp.
310-43, **Op. Cit.**, p. 310]

As such, it is important to remember that _"the empirical basis"_ of the neo-
liberal OECD-IMF orthodoxy is _"limited."_ [Howell, **Op. Cit.**, p. 337] In
fact, the whole "Europe is in a state of decline" narrative which is used to
justify the imposition of neo-liberal reforms there is better understood as
the corporate media's clever ploy to push Europe into the hands of the self-
destructing neo-liberalism that is slowly taking its toll on Britain and
America rather than a serious analysis of the real situation there.

Take, for example, the issue of high youth unemployment in many European
countries which reached international awareness during the French anti-CPE
protests in 2006. In fact, the percentage of prime-age workers (25-54) in
employment is pretty similar in "regulated" France, Germany and Sweden as in
"flexible" America and Britain (it is much higher for women in Sweden).
However, there are significant differences in youth employment rates and this
suggests where the apparent unemployment problem lies in Europe. This problem
is due to the statistical method used to determine the unemployment figures.
The standard measure of unemployment divides the number unemployed by the
numbers unemployed plus employed. The flaw in this should be obvious. For
example, assume that 90% of French youths are in education and of the
remaining 10%, 5% are in work and 5% are unemployed. This last 10% are the
"labour force" and so we would get a massive 50% unemployment rate but this is
due to the low (5%) employment rate. Looking at the youth population as a
whole, only 5% are actually unemployed. [David R. Howell, _"Introduction"_,
pp. 3-34, **Op. Cit.**, pp. 13-14] By the standard measure, French males age
15-24 had an unemployment rate of 20.8% in 2007, as compared to 11.8% in
America. Yet this difference is mainly because, in France (as in the rest of
Europe), there are many more young males not in the labour force (more are in
school and fewer work part time while studying). As those who are not in the
labour market are not counted in the standard measure, this gives an inflated
value for youth unemployment. A far better comparison would be to compare the
number of unemployed divided by the population of those in the same age group.
This results in the USA having a rate of 8.3% and France 8.6%.

Another source of the "decline" of Europe is usually linked to lower GDP
growth over the past few years compared to countries like Britain and the USA.
Yet this perspective fails to take into account internal income distribution.
Both the USA and UK are marked by large (and increasing) inequality and that
GDP growth is just as unequally distributed. In America, for example, most of
GDP growth since the 1980s has been captured by the top 5% of the population
while median wages have been (at best) flat. Ignoring the enrichment of the
elite in the USA and UK would mean that GDP growth would be, at least for the
bulk of the population, better in Europe. This means that while Europe may
have grown more slowly, it benefits more than just the ruling class. Then
there are such factors as poverty and social mobility. Rates of poverty are
much worse in the neo-liberal countries, while social mobility has fallen in
the US and UK since the 1980s. There are less poor people in Europe and they
stay in poverty for shorter periods of time compared to America and Britain.

Moreover, comparing Europe's income or GDP per person to the U.S. fails to
take into account the fact that Europeans work far less than Americans or
British people. So while France may have lagged America in per capita income
in 2007 ($30,693 to $43,144), it cannot be said that working class people are
automatically worse off as French workers have a significantly shorter working
week and substantially more holidays. Less hours at work and longer holidays
may impact negatively on GDP but only an idiot would say that this means the
economy is worse, never mind the quality of life. Economists, it should be
remembered, cannot say that one person is worse off than another if she has
less income due to working fewer hours. So GDP per capita may be higher in the
US, but only because American workers work more hours and **not** because they
are more productive. Like other Europeans, the French have decided to work
less and enjoy it more. So it is important to remember that GDP is not
synonymous with well-being and that inequality can produce misleading per
capita income comparisons.

A far better indicator of economic welfare is productivity. It is
understandable that this is not used as a measure when comparing America to
Europe as it is as high, or higher, in France and other Western European
countries as it is in the US (and much higher than in the UK where low wages
and long hours boost the figure). And it should be remembered that rising
productivity in the US has not been reflecting in rising wages since 1980. The
gains of productivity, in other words, have been accumulated by the boss class
and not by the hard working American people (whose working week has steadily
increased during that period). Moreover, France created more private sector
jobs (+10% between 1996 and 2002, according to the OECD) than the UK (+6%) or
the US (+5%). Ironically, given the praise it receives for being a neo-liberal
model, the UK economy barely created any net employment in the private sector
between 2002 and 2007 (unemployment **had** dropped, but that was due to
increased state spending which led to a large rise in public sector jobs).

Then there is the fact that some European countries **have** listened to the
neo-liberal orthodoxy and reformed their markets but to little success. So it
should be noted that _"there has in fact already been a very considerable
liberalisation and reform in Europe,"_ both in product and labour markets. In
fact, during the 1990s Germany and Italy reformed their labour markets
_"roughly ten times"_ as much as the USA. The _"point is that reforms should
have boosted productivity growth in Europe,"_ but they did not. If regulation
_"was the fundamental problem, some positive impact on labour productivity
growth should have come already from the very substantial deregulation already
undertaken. Deregulation should have contributed to an acceleration in
productivity growth in Europe whereas actually productivity growth declines.
It is hard to see how regulation, which was declining, could be the source of
Europe's slowdown."_ [Glyn, **Op. Cit.**, p. 144]

So, perhaps, "flexibility" is not the solution to unemployment some claim it
is (after all, the lack of a welfare state in the 19th century did not stop
mass unemployment nor long depressions occurring). Indeed, a strong case can
be made (and has been by left-wing economists) that the higher open
unemployment in Europe has a lot less to do with "rigid" structures and
"pampered" citizens than it does with the fiscal and monetary austerity
produced by the excessively tight monetary policies of the European Central
Bank plus the requirements of the Maastricht Treaty and the _"Growth and
Stability pact"_ which aims to reduce demand expansion (i.e. wage rises) under
the name of price stability (i.e., the usual mantra of fighting inflation by
lowering wage increases). So, _"[i]n the face of tight monetary policy imposed
first by the [German] Bundesbank and then by the European Central Bank . . .
it has been essential to keep wages moderate and budget deficits limited. With
domestic demand severely constrained, many European countries experiences
particularly poor employment growth in the mid-1990s."_ [David R. Howell,
_"Conclusion"_, **Op. Cit.**, p. 337] This has been essentially imposed by the
EU bureaucrats onto the European population and as these policies, like the EU
itself, has the support of most of Europe's ruling class such an explanation
is off the political agenda.

So if "flexibility" does not result in lower unemployment, just what is it
good for? The net results of American labour market "flexibility" were
summarised by head the US Federal Reserve Alan Greenspan in 1997. He was
discussing the late 1990s boom (which was, in fact, the product of the dot.com
bubble rather than the dawn of a new era so many claimed at the time). He
explained why unemployment managed to fall below the standard NAIRU rate
without inflation increasing. In his words:

> _"Increases in hourly compensation . . . have continued to fall far short of
what they would have been had historical relationships between compensation
gains and the degree of labour market tightness held . . . As I see it,
heightened job insecurity explains a significant part of the restraint on
compensation and the consequent muted price inflation . . . The continued
reluctance of workers to leave their jobs to seek other employment as the
labour market has tightened provides further evidence of such concern, as does
the tendency toward longer labour union contracts . . . The low level of work
stoppages of recent years also attests to concern about job security . . . The
continued decline in the share of the private workforce in labour unions has
likely made wages more responsive to market forces . . . Owing in part to the
subdued behaviour of wages, profits and rates of return on capital have risen
to high levels."_ [quoted by Jim Stanford, _"Testing the Flexibility Paradigm:
Canadian Labor Market Performance in International Context,"_ pp. 119-155,
**Fighting Unemployment**, David R. Howell (ed.), pp. 139-40]

Under such circumstances, it is obvious why unemployment could drop and
inflation remain steady. Yet there is a massive contradiction in Greenspan's
account. As well as showing how keen the Federal Reserve investigates the
state of the class struggle, ready to intervene when the workers may be
winning, it also suggests that flexibility works just one way:

> _"Some of the features highlighted by Greenspan reflect precisely a **lack**
of flexibility in the labour market: a lack of response of compensation to
tight labour markets, a reluctance of workers to leave their jobs, and the
prevalence of long-term contracts that lock employment arrangements for six or
more years at a time. And so Greenspan's portrayal of the unique features of
the US model suggests that something more than flexibility is the key
ingredient at work -- or at least that 'flexibility' is being interpreted once
again from an unbalanced and one-sided perspective. It is, rather, a high
degree of labour market **discipline** that seems to be the operative force.
US workers remain insecure despite a relatively low unemployment rate, and
hence compensation gains . . . were muted. This implies a consequent
redistribution of income from labour to capital . . . Greenspan's story is
more about **fear** than it is about flexibility -- and hence this famous
testimony has come to be known as Greenspan's 'fear factor' hypothesis, in
which he concisely described the importance of labour market discipline for
his conduct of monetary policy."_ [Jim Stanford, **Op. Cit.**, p. 140]

So while this attack on the wages, working conditions and social welfare is
conducted under the pre-Keynesian notion of wages being _"sticky"_ downwards,
the underlying desire is to impose a "flexibility" which ensures that wages
are _"sticky"_ **upwards.** This suggests a certain one-sidedness to the
"flexibility" of modern labour markets: employers enjoy the ability to
practice flexpoilation but the flexibility of workers to resist is reduced.

Rather than lack of "flexibility," the key factor in explaining high
unemployment in Europe is the anti-inflationary policies of its central banks,
which pursue high interest rates in order to "control" inflation (i.e. wages).
In contrast, America has more flexibility simply due to the state of the
working class there. With labour so effectively crushed in America, with so
many workers feeling they cannot change things or buying into the
individualistic premises of capitalism thanks to constant propaganda by
business funded think-tanks, the US central bank can rely on job insecurity
and ideology to keep workers in their place in spite of relatively lower
official unemployment. Meanwhile, as the rich get richer many working class
people spend their time making ends meet and blaming everyone and everything
but their ruling class for their situation (_"US families must work even more
hours to achieve the standard of living their predecessors achieved 30 years
ago."_ [David R. Howell, _"Conclusion"_, **Op. Cit.**, p. 338]).

All this is unsurprising for anarchists as we recognise that "flexibility"
just means weakening the bargaining power of labour in order to increase the
power and profits of the rich (hence the expression _**"flexploitation"**_!).
Increased "flexibility" has been associated with **higher,** not lower
unemployment. This, again, is unsurprising, as a "flexible" labour market
basically means one in which workers are glad to have any job and face
increased insecurity at work (actually, _**"insecurity"**_ would be a more
honest word to use to describe the ideal of a competitive labour market rather
than _"flexibility"_ but such honesty would let the cat out of the bag). In
such an environment, workers' power is reduced meaning that capital gets a
larger share of the national income than labour and workers are less inclined
to stand up for their rights. This contributes to a fall in aggregate demand,
so increasing unemployment. In addition, we should note that "flexibility" may
have little effect on unemployment (although not on profits) as a reduction of
labour's bargaining power may result in **more** rather than less
unemployment. This is because firms can fire "excess" workers at will,
increase the hours of those who remain and stagnating or falling wages reduces
aggregate demand. Thus the paradox of increased "flexibility" resulting in
higher unemployment is only a paradox in the neo-classical framework. From an
anarchist perspective, it is just the way the system works as is the paradox
of overwork and unemployment occurring at the same time.

So while "free market" economics protrays unions as a form of market failure,
an interference with the natural workings of the market system and recommend
that the state should eliminate them or ensure that they are basically
powerless to act, this simply does not reflect the real world. Any real
economy is marked by the economic power of big business (in itself, according
to neo-classical economics, a distortion of the market). Unless workers
organise then they are in a weak position and will be even more exploited by
their economic masters. Left-wing economist Thomas I. Palley presents the
correct analysis of working class organisation when he wrote:

> _ "The reality is that unions are a correction of market failure, namely the
massive imbalance of power that exists between individual workers and
corporate capital. The importance of labour market bargaining power for the
distribution of income, means that unions are a fundamental prop for
widespread prosperity. Weakening unions does not create a 'natural' market: it
just creates a market in which business has the power to dominate labour.  
>  _

>

> _"The notion of perfect natural markets is built on the assumption that
market participants have no power. In reality, the process of labour exchange
is characterised not only by the presence of power, but also by gross
inequality of power. An individual worker is at a great disadvantage in
dealing with large corporations that have access to massive pools of capital
and can organise in a fashion that renders every individual dispensible . . .
Unions help rectify the imbalance of power in labour markets, and they
therefore correct market failure rather than causing it."_ [**Op. Cit.**, pp.
36-7]

The welfare state also increases the bargaining power of workers against their
firms and limits the ability of firms to replace striking workers with scabs.
Given this, it is understandable why bosses hate unions and any state aid
which undermines their economic power. Thus the _"hallmark"_ of the neo-
liberal age _"is an economic environment that pits citizen against citizen for
the benefit of those who own and manage"_ a country. [**Op. Cit**, p. 203]

And we must add that whenever governments have attempted to make the labour
market _"fully competitive"_ it has either been the product of dictatorship
(e.g. Chile under Pinochet) or occurred at the same time as increased
centralisation of state power and increased powers for the police and
employers (e.g. Britain under Thatcher, Reagan in the USA). This is the agenda
which is proscribed for Western Europe. In 2006, when successful street
protests stopped a proposed labour market reform in France (the CPE), one
American journalist, Elaine Sciolino, complained that _"the government seems
to fear its people; the people seem to fear change."_ [**New York Times**,
March 17 2006] Such are the contradictions of neo-liberalism. While
proclaiming the need to reduce state intervention, it requires increased state
power to impose its agenda. It needs to make people fear their government and
fear for their jobs. Once that has been achieved, then people who accept
"change" (i.e. the decisions of their economic, social and political bosses)
without question. That the French people do not want a British or American
style labour market, full of low-wage toilers who serve at the boss's pleasure
should not come as a surprise. Nor should the notion that elected officials in
a supposed democracy are meant to reflect the feelings of the sovereign people
be considered as unusual or irrational.

The anti-democratic nature of capitalist "flexiblity" applies across the
world. Latin American Presidents trying to introduce neo-liberalism into their
countries have had to follow suit and _"ride roughshod over democratic
institutions, using the tradition Latin American technique of governing by
decree in order to bypass congressional opposition. . . Civil rights have also
taken a battering. In Bolivia, the government attempted to defuse union
opposition . . . by declaring a state of siege and imprisoning 143 strike
leaders. . . In Colombia, the government used anti-terrorist legislation in
1993 to try 15 trade union leaders opposing the privatisation of the state
telecommunications company. In the most extreme example, Peru's Alberto
Fujimori dealt with a troublesome Congress by simply dissolving it . . . and
seizing emergency powers."_ [Duncan Green, **The Silent Revolution**, p. 157]

This is unsurprising. People, when left alone, will create communities,
organise together to collectively pursue their own happiness, protect their
communities and environment. In other words, they will form groups,
associations and unions to control and influence the decisions that affect
them. In order to create a "fully competitive" labour market, individuals must
be atomised and unions, communities and associations weakened, if not
destroyed, in order to fully privatise life. State power must be used to
disempower the mass of the population, restrict their liberty, control popular
organisations and social protest and so ensure that the free market can
function without opposition to the human suffering, misery and pain it would
cause. People, to use Rousseau's evil term, _"must be forced to be free."_
And, unfortunately for neo-liberalism, the countries that tried to reform
their labour market still suffered from high unemployment, plus increased
social inequality and poverty and where still subject to the booms and slumps
of the business cycle.

Of course, bosses and the elite are hardly going to present their desire for
higher profits and more power in those terms. Hence the need to appear
concerned about the fate of the unemployed. As such, it is significant, of
course, that right-wing economists only seem to become concerned over
unemployment when trade unions are organising or politicians are thinking of
introducing or raising the minimum wage. Then they will talk about how these
will raise unemployment and harm workers, particularly those from ethnic
minorities. Given that bosses always oppose such policies, we must conclude
that they are, in fact, seeking a situation where there is full employment and
finding willing workers is hard to do. This seems, to say the least, an
unlikely situation. If bosses were convinced that, for example, raising the
minimum wage would increase unemployment rather than their wages bill they
would be supporting it wholeheartedly as it would allow them to pressurise
their workers into labouring longer and harder to remain in employment.
Suffice to say, bosses are in no hurry to see their pool of wage slaves
drained and so their opposition to trade unions and minimum wages are the
product of need for profits rather than some concern for the unemployed.

This applies to family issues as well. In its support for "free markets" you
can get a taste of the schizophrenic nature of the conservative right's
approach to family values. On the one hand, they complain that families do not
spend enough time together as they are under financial pressure and this
results both parents going out to work and working longer hours. Families will
also suffer because businesses do not have to offer paid maternity leave, paid
time off, flexitime, paid holidays, or other things that benefit them.
However, the right cannot bring themselves to advocate unions and strike
action by workers (or state intervention) to achieve this. Ironically, their
support for "free market" capitalism and "individualism" undermines their
support for "family values." Ultimately, that is because profits will always
come before parents.

All this is unsurprising as, ultimately, the only real solution to
unemployment and overwork is to end wage labour and the liberation of humanity
from the needs of capital. Anarchists argue that an economy should exist to
serve people rather than people existing to serve the economy as under
capitalism. This explains why capitalism has always been marked by a focus on
"what the economy wants" or "what is best for the economy" as having a
capitalist economy always results in profit being placed over people. Thus we
have the paradoxical situation, as under neo-liberalism, where an economy is
doing well while the bulk of the population are not.

Finally, we must clarify the anarchist position on state welfare (we support
working class organisations, although we are critical of unions with
bureaucratic and top-down structures). As far as state welfare goes,
anarchists do not place it high on the list of things we are struggling
against (once the welfare state for the rich has been abolished, then,
perhaps, we will reconsider that). As we will discuss in [section
D.1.5](secD1.md#secd15), anarchists are well aware that the current neo-
liberal rhetoric of "minimising" the state is self-serving and hides an attack
on the living standards of working class people. As such, we do not join in
such attacks regardless of how critical we may be of aspects of the welfare
state for we seek genuine reform from below by those who use it rather than
"reform" from above by politicians and bureaucrats in the interests of state
and capital. We also seek to promote alternative social institutions which,
unlike the welfare state, are under working class control and so cannot be cut
by decree from above. For further discussion, see sections
[J.5.15](secJ5.md#secj515) and [ J.5.16](secJ5.md#secj516).

## C.9.4 Is unemployment voluntary?

Here we point out another aspect of the free market capitalist "blame the
workers" argument, of which the diatribes against unions and workers' rights
highlighted above is only a part. This is the assumption that unemployment is
not involuntary but is freely chosen by workers. As Nicholas Kaldor put it,
for "free market" economists involuntary employment _"cannot exist because it
is excluded by the assumptions."_ [**Further Essays on Applied Economics**, p.
x] Many neo-classical economists claim that unemployed workers calculate that
their time is better spent searching for more highly paid employment (or
living on welfare than working) and so desire to be jobless. That this
argument is taken seriously says a lot about the state of modern capitalist
economic theory, but as it is popular in many right-wing circles, we should
discuss it.

David Schweickart notes, these kinds of arguments ignore _"two well-
established facts: First, when unemployment rises, it is layoffs, not
[voluntary] quits, that are rising. Second, unemployed workers normally accept
their first job offer. Neither of these facts fits well with the hypothesis
that most unemployment is a free choice of leisure."_ [**Against Capitalism**,
p. 108] When a company fires a number of its workers, it can hardly be said
that the sacked workers have calculated that their time is better spent
looking for a new job. They have no option. Of course, there are numerous jobs
advertised in the media. Does this not prove that capitalism always provides
jobs for those who want them? Hardly, as the number of jobs advertised must
have some correspondence to the number of unemployed and the required skills
and those available. If 100 jobs are advertised in an areas reporting 1,000
unemployed, it can scarcely be claimed that capitalism tends to full
employment. This hardly gives much support to the right-wing claim that
unemployment is "voluntary" and gives an obvious answer to right-wing
economist Robert Lucas's quest _"to explain why people allocate time to . . .
unemployment, we need to know why they prefer it to all other activities."_
[quoted by Schweickart, **Op. Cit.**, p. 108] A puzzle indeed! Perhaps this
unworldly perspective explains why there has been no real effort to verify the
assertion that unemployment is "voluntary leisure."

Somewhat ironically, given the desire for many on the right to deny the
possibility of involuntary unemployment this perspective became increasingly
influential at precisely the same time as the various theories of the so-
called "natural rate" of unemployment did (see [section C.9](secC9.md)).
Thus, at the same time as unemployment was proclaimed as being a "voluntary"
choice economics was also implicitly arguing that this was nonsense, that
unemployment **is** an essential disciplinary tool within capitalism to keep
workers in their place (sorry, to fight inflation).

In addition, it is worthwhile to note that the right-wing assumption that
higher unemployment benefits and a healthy welfare state promote unemployment
is not supported by the evidence. As a moderate member of the British
Conservative Party notes, the _"OECD studied seventeen industrial countries
and found no connect between a country's unemployment rate and the level of
its social-security payments."_ [**Dancing with Dogma**, p. 118] Moreover, the
economists David Blanchflower and Andrew Oswald _"Wage Curve"_ for many
different countries is approximately the same for each of the fifteen
countries they looked at. This also suggests that labour market unemployment
is independent of social-security conditions as their "wage curve" can be
considered as a measure of wage flexibility. Both of these facts suggest that
unemployment is involuntary in nature and cutting social-security will **not**
affect unemployment.

Another factor in considering the nature of unemployment is the effect of
decades of "reform" of the welfare state conducted in both the USA and UK
since 1980. During the 1960s the welfare state was far more generous than it
was in the 1990s and unemployment was lower. If unemployment was "voluntary"
and due to social-security being high, we would expect a decrease in
unemployment as welfare was cut (this was, after all, the rationale for
cutting it in the first place). In fact, the reverse occurred, with
unemployment rising as the welfare state was cut. Lower social-security
payments did not lead to lower unemployment, quite the reverse in fact.

Faced with these facts, some may conclude that as unemployment is independent
of social security payments then the welfare state can be cut. However, this
is not the case as the size of the welfare state does affect the poverty rates
and how long people remain in poverty. In the USA, the poverty rate was 11.7%
in 1979 and rose to 13% in 1988, and continued to rise to 15.1% in 1993. The
net effect of cutting the welfare state was to help **increase** poverty.
Similarly, in the UK during the same period, to quote the ex-Thatcherite John
Gray, there _"was the growth of an underclass. The percentage of British (non-
pensioner) households that are wholly workless -- that is, none of whose
members is active in the productive economy -- increased from 6.5 per cent in
1975 to 16.4 per cent in 1985 and 19.1 per cent in 1994. . . Between 1992 and
1997 there was a 15 per cent increase in unemployed lone parents. . . This
dramatic growth of an underclass occurred as a direct consequence of neo-
liberal welfare reforms, particularly as they affected housing."_ [**False
Dawn**, p. 30] This is the opposite of the predictions of right-wing theories
and rhetoric.

As Gray correctly argues, the _"message of the American [and other] New Right
has always been that poverty and the under class are products of the
disincentive effects of welfare, not the free market."_ He goes on to note
that it _"has never squared with the experience of the countries of
continental Europe where levels of welfare provision are far more
comprehensive than those of the United States have long co-existed with the
absence of anything resembling an American-style underclass. It does not touch
at virtually any point the experience of other Anglo-Saxon countries."_ He
points to the example of New Zealand where _"the theories of the American New
Right achieved a rare and curious feat -- self-refutation by their practical
application. Contrary to the New Right's claims, the abolition of nearly all
universal social services and the stratification of income groups for the
purpose of targeting welfare benefits selectively created a neo-liberal
poverty trap."_ [**Op. Cit.**, p. 42]

So while the level of unemployment benefits and the welfare state may have
little impact on the level of unemployment (which is to be expected if the
nature of unemployment is essentially involuntary), it **does** have an effect
on the nature, length and persistency of poverty. Cutting the welfare state
increases poverty and the time spent in poverty (and by cutting
redistribution, it also increases inequality).

If we look at the relative size of a nation's social security transfers as a
percentage of Gross Domestic Product and its relative poverty rate we find a
correlation. Those nations with a high level of spending have lower rates of
poverty. In addition, there is a correlation between the spending level and
the number of persistent poor. Those nations with high spending levels have
more of their citizens escape poverty. For example, Sweden has a single-year
poverty rate of 3% and a poverty escape rate of 45% and Germany has figures of
8% and 24% (and a persistent poverty rate of 2%). In contrast, the USA has
figures of 20% and 15% (and a persistent poverty rate of 42%).

Given that a strong welfare state acts as a kind of floor under the wage and
working conditions of labour, it is easy to see why capitalists and the
supporters of "free market" capitalism seek to undermine it. By undermining
the welfare state, by making labour "flexible," profits and power can be
protected from working people standing up for their rights and interests.
Little wonder the claimed benefits of "flexibility" have proved to be so
elusive for the vast majority while inequality has exploded. The welfare
state, in other words, reduces the attempts of the capitalist system to
commodify labour and increases the options available to working class people.
While it did not reduce the need to get a job, the welfare state did undermine
dependence on any particular employee and so increased workers' independence
and power. It is no coincidence that the attacks on unions and the welfare
state was and is framed in the rhetoric of protecting the _"right of
management to manage"_ and of driving people back into wage slavery. In other
words, an attempt to increase the commodification of labour by making work so
insecure that workers will not stand up for their rights.

Unemployment has tremendous social costs, with the unemployed facing financial
insecurity and the possibility of indebtedness and poverty. Many studies have
found that unemployment results in family distribution, ill health (both
physical and mental), suicide, drug addition, homelessness, malnutrition,
racial tensions and a host of other, negative, impacts. Given all this, given
the dire impact of joblessness, it strains belief that people would **choose**
to put themselves through it. The human costs of unemployment are well
documented. There is a stable correlation between rates of unemployment and
the rates of mental-hospital admissions. There is a connection between
unemployment and juvenile and young-adult crime. The effects on an
individual's self-respect and the wider implications for their community and
society are massive. As David Schweickart concludes the _"costs of
unemployment, whether measured in terms of the cold cash of lost production
and lost taxes or in the hotter units of alienation, violence, and despair,
are likely to be large under Laissez Faire."_ [**Op. Cit.**, p. 109]

Of course, it could be argued that the unemployed should look for work and
leave their families, home towns, and communities in order to find it.
However, this argument merely states that people should change their whole
lives as required by "market forces" (and the wishes -- _"animal spirits,"_ to
use Keynes' term -- of those who own capital). In other words, it just
acknowledges that capitalism results in people losing their ability to plan
ahead and organise their lives (and that, in addition, it can deprive them of
their sense of identity, dignity and self-respect as well), portraying this as
somehow a requirement of life (or even, in some cases, noble).

It seems that capitalism is logically committed to viciously contravening the
very values upon which it claims it be built, namely the respect for the
innate worth and separateness of individuals. This is hardly surprising, as
capitalism is based on reducing individuals to the level of another commodity
(called "labour"). To requote Karl Polanyi:

> _"In human terms such a postulate [of a labour market] implied for the
worker extreme instability of earnings, utter absence of professional
standards, abject readiness to be shoved and pushed about indiscriminately,
complete dependence on the whims of the market. [Ludwig Von] Mises justly
argued that if workers 'did not act as trade unionists, but reduced their
demands and changed their locations and occupations according to the labour
market, they would eventually find work.' This sums up the position under a
system based on the postulate of the commodity character of labour. It is not
for the commodity to decide where it should be offered for sale, to what
purpose it should be used, at what price it should be allowed to change hands,
and in what manner it should be consumed or destroyed."_ [**The Great
Transformation**, p. 176]

However, people are **not** commodities but living, thinking, feeling
individuals. The "labour market" is more a social institution than an economic
one and people and work more than mere commodities. If we reject the neo-
liberals' assumptions for the nonsense they are, their case fails. Capitalism,
ultimately, cannot provide full employment simply because labour is **not** a
commodity (and as we discussed in [section C.7](secC7.md), this revolt
against commodification is a key part of understanding the business cycle and
so unemployment).

[‹ C.8 Is state control of credit the cause of the business cycle?](secC8.md
"Go to previous page" ) [up](secCcon.md "Go to parent page" ) [C.10 Is "free
market" capitalism the best way to reduce poverty? ›](secC10.md "Go to next
page" )

