# An Anarchist FAQ: Introduction to Volume 2

> _“Conquer or die – such is the dilemma that faces the . . . peasants and
workers at this historic moment . . . But we will not conquer in order to
repeat the errors of the past years, the error of putting our fate into the
hands of new masters; we will conquer in order to take our destinies into our
own hands, to conduct our lives according to our own will and our own
conception of the truth.”_

> Nestor Makhno[1]

Welcome to volume 2 of **An Anarchist FAQ** (**AFAQ**)!

If the core of volume 1 was based on outlining anarchist ideas and history as
well as presenting the anarchist critique of authority, capitalism and
statism, then this volume is focused around two threads. The first is the
critique of Marxism, historically anarchism’s main alternative within the
socialist movement. The second is what anarchists aim for and how we get
there.

Needless to say, the second theme is by far the more important as anarchism is
more than just analysing what is wrong with the world, it also aims to change
it.

First, though, we start with an account of individualist anarchism ([section
G](secGcon.md)). It is fair to say that individualist anarchism has
generally been on the margin of accounts of anarchism. This, undoubtedly,
reflects the fact it has been predominantly a North American movement and was
always a small minority within the global anarchist movement. Even in the USA,
it was eclipsed by social anarchism.

As such, it has been somewhat overlooked in accounts of anarchism and **AFAQ**
seeks to correct that. Unfortunately, it has also to address claims that
“anarcho”-capitalism is a form of individualist anarchism and so it spends
some time refuting such assertions. We do so with a heavy heart, as this will
tend to exaggerate the importance of that ideology and its influence but it
needs to be done simply in order to counteract those ideologues and academics
who seek to confuse the two either out of ignorance (for the latter) or self-
interest (for the former). In addition, section G is shaped by the history of
**AFAQ**, when it started as an anti-“anarcho”-capitalist FAQ rather than a
pro-anarchist one. If it had been started as the pro-anarchist FAQ it has now
become, that section would have been substantially different (most obviously,
the material on “anarcho”-capitalism being placed in an appendix where it
belongs).

This means that in some regards, section G can be considered as a continuation
of [section F](secFcon.md) (which is on why “anarcho”-capitalism is not a
form of anarchism). Individualist anarchism **_is_** the form of anarchism
closest to liberalism and, as a consequence, to “anarcho”-capitalism. However,
similarities do not equate to the former being a (flawed, from an
“anarcho”-capitalist perspective) forerunner of the latter. If this were the
case then some would assert that social anarchism is a form of Marxism. There
are overlaps, of course, but then again there are overlaps between
individualist anarchism, Marxism and social anarchism. Yet, for all its
differences with social anarchism, individualist anarchism shared a critique
of capitalism and the state which has significant commonality.

Individualist anarchism is a unique political theory and it does it a
disservice to reduce it to simply a flawed precursor of an ideology whose
origins and aims are radically at odds with it. It is no coincidence that
individualist anarchism found its home in the broader labour and socialist
movements while propertarianism views these with disdain. Nor is it a
coincidence that the main influences on individualist anarchism were labour,
monetary and land reform movements plus the economics of Proudhon and other
socialists while, for “anarcho”-capitalism, it is “Austrian” economics which
developed, in part, precisely to combat such popular movements. This leads to
fundamentally different analyses, strategies and aims that show beyond doubt
that the two cannot be confused. The individualist anarchists cannot be
considered as forerunners of propertarianism in any more than the most
superficial terms. So it is a shame this needs to be discussed at all, but it
has.

Ironically, a sadly unpublished article from the 1950s by the founder of that
ideology, Murray Rothbard, has come to light which came to the same conclusion
(inaccurately entitled, given the history of anarchist use of libertarian,
**Are Libertarians ‘Anarchists’?**). Ignoring the errors, distortions and
inventions about anarchism Rothbard inflicts on the reader, this essay came to
the following (correct!) conclusion: _“We must therefore conclude that we are
_**not**_ anarchists, and that those who call us anarchists are not on firm
etymological ground, and are being completely unhistorical.”_ This was
applicable to both the _“dominant anarchist doctrine . . .  of ‘anarchist
communism’” (“which has also been called ‘collectivist anarchism,’ ‘anarcho-
syndicalism,’ and ‘libertarian communism’_) as well as individualist
anarchists, considered by Rothbard _“the best of them”,_ as **both** had
_“socialistic elements in their doctrines_._” _He suggested that there were
thinkers _“in that Golden Age of liberalism”_ who had ideas _“similar” _to his
ideology but these _“never referred to themselves as anarchists”_ while _“all
the anarchist groups . . . possessed socialistic _**economic**_ doctrines in
common.”_ If only he had kept to that analysis and called his ideology
something more accurate then this FAQ would have been much shorter!

Also significant is Rothbard’s use of the term “libertarian communism” which
indicates he was well aware of the traditional use of libertarian as an
alternative to anarchist. Interestingly, while reminiscing about the origins
of the so-called “libertarian” right in America Rothbard publicly acknowledged
their stealing of the word libertarian from genuine anarchists:

> _“One gratifying aspect of our rise to some prominence is that, for the
first time in my memory, we, ‘our side,’ had captured a crucial word from the
enemy . . . ‘Libertarians’ . . . had long been simply a polite word for left-
wing [sic!] anarchists, that is for anti-private property anarchists, either
of the communist or syndicalist variety. But now we had taken it over . .
.”_[2]

Today, of course, propertarians shrilly denounce anarchists using the term
libertarian in its original and correct meaning as attempting to appropriate
_their_ name and associate it with socialism! Oh, the irony…

Unlike the propertarians who are so busy degrading the good name “libertarian”
and the memories of individualist anarchism, adherents of both schools of
anarchism considered themselves socialists. Of course there _are_ real
differences between individualist and social anarchism, and we explore these.
We show that attempts by some members of each school to excommunicate the
others are, ultimately, pointless (in general, the individualists seemed
keener to do that than the social anarchists but both sides had their
intolerant ones). There is significant overlap between both sections of the
movement and so it is perfectly possible for each to coexist happily in a free
society as well as, on certain issues and tactics, to work fruitfully together
in resisting capitalism and the state.[3]

We then turn to discuss Marxism and its flaws ([section H](secHcon.md)). To
be honest, it is staggering that this section even needs to be written given
that the anarchist critique of Marxism has been validated time and time again.
It is like writing a book on evolution and spending a significant time
refuting the claims of Lamarckian theory. Sadly, though, many radicals seem
unable to grasp the facts of history, namely that the predictions made by
anarchism as regards Marxism have come to pass. Bakunin was right: social
democracy did become reformist and the dictatorship of the proletariat became
the dictatorship **_over_** the proletariat.

This critique is not to suggest that anarchists should reject everything Marx
argued.[4] In terms of his critique of capitalism, there is much that
libertarians can agree with (undoubtedly because much of it was built on
Proudhon’s analysis!). In part, it is this analysis which ensures that Marxism
remains alive as a distinct ideology in the radical movement rather than
Marx’s positive contributions being integrated along with others (such as
Proudhon and Bakunin) into libertarian socialism. It is a powerful and, in
large parts, a correct analysis of that system but in terms of constructive
ideas on what socialism would be and how to achieve it, Marxism comes up as
deeply flawed. So, as with anarchist thinkers, we should recognise the
important and valid parts of Marx’s contribution to the socialist movement
while rejecting its negative aspects – particularly as many so-called
“Marxist” positions were first expounded by anarchists!

In part, because as well as his critique of capitalism the other main reason
for Marxism’s continued existence is, undoubtedly, its apparent success.
Needless to say, most Marxists are keen to forget that the first apparently
successful Marxist movement was social democracy. Engels lavish praise for it
is rarely mentioned these days, given social democracy’s quick descent into
reformism and, worse, explicit counter-revolution during the German
revolution. Rather, it is the apparent success of Leninism[5] during the
Russian Revolution that accounts for why so many radicals are attracted to it.
As such, what Alexander Berkman termed **The Bolshevik Myth** is alive and
well – and needs to be combated.

Suffice to say, the promises of Lenin’s **State and Revolution** did not last
the night and within six months there was a _de facto_ party dictatorship
presiding over a state capitalist economy (by early 1919, the need for party
dictatorship in a revolution was considered a truism by all the leaders of the
party). If that counts as a success, what would failure be? Luckily, unlike
Berkman’s generation, the numbers blinded by wishful thinking about
“socialism” in Russia are fewer although we do have those who, while
denouncing Stalin, seem incapable of seeing the obvious links with Lenin’s
regime and its ideological conceptions (most notably, but not limited to, its
vanguardism). As we show in section H.6, the standard modern-day Leninist
excuses for Bolshevik tyranny have nothing to recommend them – both in terms
of theory and empirical evidence. So as well as presenting a theoretical
critique of Marxism, we seek to root it in the experiences of Marxism in
practice. This involves, in the main, focusing on the Social-Democratic
movement, Bolshevism and the Russian Revolution.

We also spend some time refuting numerous Marxist distortions of anarchist
ideas. I’ve lost count of the times I have seen blatantly false claims about
anarchism raised by Marxists. I’m not that surprised, as few Marxists actually
bother to read the likes of Proudhon, Bakunin and Kropotkin. Instead, they
simply repeat what other Marxists have claimed about anarchism (starting, of
course, with Marx and Engels). This explains why [section H.2](secH2.md) has
so many quotes in it, simply to drive home what would be obvious to anyone
familiar with anarchist theory and practice. A few quotes could be dismissed
as selective, a multitude cannot. I’m sorry that has to be done, but the
regularity of abysmally bad Marxist diatribes against anarchism means that it
had to be done in such detail. Sadly, I’m sure that refuting these habitual
false assertions in **AFAQ** it will not stop Marxists repeating them.

Marxist myths on anarchism also feeds into section G, given that many Marxists
have been at pains to portray anarchism as being simply “anti-state” (in this,
they share common-ground with the propertarians). Yet even a cursory glance of
anarchist theory and history shows that it has _never_ limited itself to just
a critique of the state. As long as anarchism has been a named socio-economic
theory we have directed our fire at both state **_and_** property. [_Property
writings, shows how interlinked the anarchist opposition to the state and
capitalism has been from the start. Thus we find Proudhon arguing that _“the
capitalist principle” _and the _“governmental principle are one and the same
principle” _and so_ “the abolition of the exploitation of man by man and the
abolition of government of man by man are one and the same formula.”
_Moreover, it is _“to protect this exploitation of man by man that the State
exists” _Unsurprisingly, then, anarchists are _“simultaneously striving for
the abolition of capital and of the State”_ and _“if you do away with the
former, you still have to do away with the latter, and **vice versa**.”_[6]_ _

So the notion of an anarchism which is simply anti-state is completely alien
to our tradition. However, falsely limiting anarchism to purely opposition to
the state does allow Marxists to portray their tradition as the only form of
socialism and so exclude anarchism, by definition, from anti-capitalism.

After Marxism, we move onto more constructive and fruitful subjects, namely
anarchist ideas of what a free society could be like ([section
I](secIcon.md)) and what we do in the here and now to bring it closer and to
make our lives better ([section J](secJcon.md)).

[Section I](secIcon.md) is important, simply because it presents a rough
outline of what anarchists have suggested would characterise a free society.
So we discuss workers self-management, community self-government, economic and
social federalism, anti-social behaviour in a free society, and a host of
other issues. While many people, particularly Marxists, question the wisdom of
discussing the future society (Marx’s comment on “writing the cookbooks of the
future” springs to mind[7]), anarchists have been more willing to sketch out a
rough vision of what a free society could be like. This may come as a surprise
for some (infatuated with Bakunin’s pre-anarchist comment that _“the urge to
destroy is a creative urge”_) but in reality anarchism has always been a
constructive socio-economic theory and anarchist thinkers have always been
more than willing to sketch what a free society _could_ be.

And that is the key, this is what anarchy _could_ be like. As we are at pains
to stress, we are not presenting a blueprint: it is a series of suggestions
based on our critique of capitalism, anarchist principles and the experiences
of the struggle against oppression as well as social revolutions that have
taken place. This is important, as anarchists have never abstractly postulated
ideal social organisations to the oppression of hierarchy but, rather,
developed our ideas of what a free society could look like by critically
analysing the current exploitative and oppression one as well as the self-
activity and self-organisation of those resisting it. Anarchy will be created
from below, by the people themselves, for, as Kropotkin put it, the _“work of
demolition can only be accomplished by the direct participation of the whole
of the people. And they will only act in the name of their immediate and
popular needs. The land to the peasant; the factory, the workshop, the railway
and the rest to the worker.”_[8]

This anti-utopian perspective has been a significant aspect of anarchism since
Proudhon who (especially his **System of Economic Contradictions**) attacked
utopian socialists like Fourier and Saint-Simon for presenting fantastical
visions (and appealing for rich benefactors!) rather than studying tendencies
within capitalism which could transcend it (particularly working class self-
activity). Thus social transformation _“__must not emanate from the powers
that be; it ought to be SPONTANEOUS.”_ It must come _“from below”_ as only
this ensured change _“by the concerted action of the citizens, by the
experience of the workers, by the progress and diffusion of enlightenment,
revolution by the means of liberty.”_[9] Echoing Proudhon, Kropotkin argued
that _“the method followed by the anarchist thinker”_ is _“entirely different
from that followed by the utopists . . . He studies human society as it is now
and was in the past . . . tries to discover its tendencies, past and present,
its growing needs, intellectual and economic, and in his ideal he merely
points out in which direction evolution goes.”_[10] A key aspect of this is
looking at the self-organisation and struggles of working class people, these
being the means by which anarchists link the current to the future.

So we discuss in **AFAQ** the perennial issues of both transition and how the
new world gestates within the old. As section I.2.3 shows in detail,
anarchists have always stressed that the new world is created in our struggles
against the old. The fight for freedom transforms those who take part as well
as creating the organisations (such as community assemblies, workers’
councils, factory committees and their federations) which will be the
framework of a free society. So the IWW slogan of _“building a new world in
the shell of the old”_ has been a key aspect of anarchism for some time, with
Proudhon proclaiming during the 1848 Revolution that _“a new society be
founded in the heart of the old society” _based on _“__a body representative
of the proletariat be[ing] formed . . . in opposition to the bourgeoisie’s
representation.”_[11]

Which brings us nicely to the last section, on what do anarchists do? In
[section J](secJcon.md) we summarise how anarchists see social change
happening. There are substantial discussions on alternative forms of social
organisation we advocate and how they are the embryonic forms of a free
society we create while resisting the current oppressive one. Thus, for
example, we discuss how the federations of workplace assemblies we urge to
fight the bosses become the means by which co-operative production is
organised in a free society while the neighbourhood assemblies created as a
counter-power to the state become the means by which free individuals manage
their communities. As will soon become clear, Marxist myths not withstanding,
anarchists stress the importance of working class struggle in changing the
world. Kropotkin summarised the libertarian perspective well in 1907:

> _“Workmen’s organisations are the real force capable of accomplishing the
social revolution – after the awakening of the proletariat has been
accomplished, first by individual action, then by collective action, by
strikes and revolts extending more and more; and where workmen’s organisations
have not allowed themselves to be dominated by the gentlemen who advocate ‘the
conquest of political power’, but have continued to walk hand in hand with
anarchists – as they have done in Spain – they have obtained, on the one hand,
immediate results (an eight-hour day in certain trades in Catalonia), and on
the other have made good propaganda for the social revolution – the one to
come, not from the efforts of those highly-placed gentlemen, but from below,
from workmen’s organisations.”_[12]

We also outline why anarchists support direct action and reject voting
(“political action”) as the means of social change as well as the role of
libertarians in social struggle and revolution as well as how we organise to
influence both. As well as summarising our ideas on the important issues of
how we organise and how we change the world, we take the time to refute some
of the more common false claims against abstentionism and whether we are
“a-political” or not. Suffice to say, the anarchist critique of electioneering
has been validated (as can be seen by the numbers of ex-radical politicians
and ex-socialist parties in the world). Our arguments on the transforming
power of direct action, solidarity and working class self-organisation from
below have, likewise, been vindicated time and time again.

Few, if any, anarchists place all their hopes in spontaneity (if that were all
that was required we would be in an anarchist society by now!). So we organise
_as anarchists_ and participate in the class struggle to push it in
libertarian directions. Kropotkin words are extremely relevant here:

> _“The syndicate[union] is absolutely necessary. It is the only form of
working-men’s group that permits of maintaining the direct struggle against
capital, without falling into parliamentarianism. But evidently it does not
take that trend mechanically, since we have in Germany, France and England
syndicates rallying to parliamentarianism . . . The **other** element is
necessary, the element of which Malatesta speaks and which Bakunin has always
practised.”_[13]

So section J also addresses the issue of how anarchists organise, the kinds of
associations we create and how we seek to influence social movements and the
class struggle. Suffice to say, while we reject Leninism and its vanguardism
we do not reject organising anarchist groups and federations to explain our
ideas in order to see them gain predominance in popular organisations and
social conflicts.

It must also be noted that the sections within this volume have been slightly
edited to ensure that it approximates volume 1 in size. This has involved
trimming around a tenth of the material. I have tried to cut non-essential
paragraphs and sub-sections to ensure that the core of the arguments remain
intact. This means that, for example, [section H.2](secH2.md) (which debunks
various Marxist myths about anarchism) ends on section H.2.11 in print but
goes to section H.2.14 on-line. This was done with a heavy heart.

Since volume 1 has been published, significant changes have occurred in the
world. Neo-liberalism has taken a battering as the inevitable consequences of
its policies resolved themselves in economic crisis. While reality has struck
a blow to that ideology, it is fair to say that it will survive – after all,
the ideology is so unrealistic already why should mere reality impact on its
beauty for the true believer? Not to mention, of course, the significant class
interests expressed in it. One thing is true, unless working class people
organise and resist then governments, political discourse, economies and
economic ideology will simply continue on as before – and those who will pay
the costs of the crisis will not be the ruling class that created it.

On a more positive note, [section B.1](secB1.md) of **AFAQ** indicated how
hierarchies of wealth and power adversely affect those subject to them. **The
Spirit Level: Why More Equal Societies Almost Always Do Better** by Richard
Wilkinson and Kate Pickett presents more evidence on this subject, noting that
on almost every index of quality of life or wellness there is a strong
correlation between a country's level of economic inequality and its social
outcomes. Significantly, it is not just the poor that are adversely affected
by inequality, but society as a whole. So more equal societies have less crime
and smaller prison populations as well as consistently delivering other
advantages such as better physical and mental health, lower rates of teenage
pregnancy and obesity, and higher rates of literacy and social trust. All of
which confirm the anarchist analysis of the harmful effects of inequality in
wealth and power.


Finally, on a personal note, I dedicate this volume, like the first, to my
family. I hope that this work will help, however slightly, to make the world a
better place for them and that my children will grow up in a freer, more
sustainable, world. Whether they do or not really is up to us, the current
generation. Are we up for the challenge? Are we ready to fight for freedom and
equality? The answer to that lies in your hands.

Either you can read **AFAQ** and leave it at that or you can join in the
struggle for freedom and equality. The anarchist movement is not perfect, nor
does it have all the answers. However, it remains for all that our best chance
of making the world a fit place for unique individuals to live and flourish
in. The question is whether we will remain happy to keep surviving within
capitalism or whether we will seek to transform ourselves and our world for
the better. We may fail. We may not stop the slide towards increased
authoritarianism and atomisation. One thing is sure, if we do not resist then
that slide will accelerate.

And if we do resist? Well, we may well change the world…

Iain McKay


* * *

[1] quoted by Peter Arshinov, **The History of the Makhnovist Movement**, p.
58

[2] **The Betrayal of the American Right**, Ludwig von Mises Institute, p. 83

[3] I would also like to take the opportunity to thank individualist anarchist
Shawn Wilbur for his valued input into [section G](secGcon.md) and the
suggestions he made after reading the first drafts sent to him. Without this
help, and the numerous works of nineteenth century anarchism he has placed on-
line, this section would not be as comprehensive as it has become.

[4] Nor, for that matter, that there are no libertarian Marxists. There are,
as we indicated in [section A.4.4](secA4.md#seca44) of volume 1 of **AFAQ**.
Why they continue to call themselves Marxists while rejecting Marx’s ideas on
numerous key issues (and implicitly agreeing with Bakunin in the process) is a
mystery.

[5] We are aware that many Marxists reject the suggestion that Leninism is
actually Marxist – a position we show has some validity. We argue that it was
not only anarchism which Lenin distorted in **State and Revolution** but also
important aspects of the ideas of Marx and Engels on such key issues as the
state (see [section H.3.10](secH3.md#sech310), for example).

535, p. 503 and p. 506

[7] If Marx had been a bit more forthcoming then the likes of Stalin would
have found it harder to label their nightmare regimes “socialist.”

[8] quoted by G. Woodcock and I. Avakumovic, **The Anarchist Prince**, p. 369.

[9] Proudhon,** Op. Cit.**, p. 325 and p. 398

[10] **Anarchism**, p. 47

[11] **Op. Cit.**, p. 321. Proudhon had made a similar call in 1846, arguing
that _“__an agricultural and industrial combination must be found by means of
which power, today the ruler of society, shall become its slave”_ as the state
is _“inevitably enchained to capital and directed against the proletariat.”_
(pp. 225-6)

[12] quoted by Woodcock and Avakumovic, **Op. Cit.**, pp. 294-5. As noted in
the introduction to volume 1, the words used by previous generations of
anarchists are dated and would appear sexist if uttered today. Suffice to say,
Kropotkin was in favour of working women unionising. As discussed in [section
A.3.5](secA3.md#seca35), with the notable exception of Proudhon, anarchists
are for equality between the sexes – even if they unthinkingly used the sexist
terminology of their time (Emma Goldman, for example, used “man” to describe
all humanity).

[13] quoted by Woodcock and Avakumovic, **Op. Cit.**, p. 295



[‹ An Anarchist FAQ: Introduction to Volume 1](vol1intro.md "Go to previous
page" ) [up](intro.md "Go to parent page" ) [What Anarchists Say about An
Anarchist FAQ ›](quotes.md "Go to next page" )

