#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is a part of Androguard.
#
# This file is generated automatically from the data
# provided by PScout tool [http://pscout.csl.toronto.edu/]
# using script: extract_api_permission_mappings.py
#
# Author: Yury Zhauniarovich
#
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License"

#################################################
### API version: 19 
#################################################


AOSP_PERMISSIONS_BY_METHODS = {
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handlePinMmi-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/date/DatePickerDialog;-updateDisplay-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardEntry$BirthdayData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/base/GLTextureTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UrlInputView;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageAttachmentBar;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasSync;-makeRequest-()Lorg/apache/http/client/methods/HttpUriRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/ui/GLRootView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt;-registerClient-(Landroid/os/ParcelUuid; Landroid/bluetooth/IBluetoothGattCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserWebView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/DialogActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onPressKey-(I I Z)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/email/provider/EmailProvider;-restartPushForMailbox-(Landroid/content/Context; Landroid/database/sqlite/SQLiteDatabase; Landroid/content/ContentValues; Ljava/lang/String;)Z' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/exchange/eas/EasSettings;-getRequestUri-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/agenda/AgendaFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/support/v4/widget/ContentLoadingProgressBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$AudioOn;-processConnectionEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$10300-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/SearchView$SearchAutoComplete;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/VpnService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/RecentApplicationsBackground;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/GoogleCalendarUriIntentFilter;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/soundrecorder/Recorder;-delete-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager$WifiLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowDataAdapter$SlideshowSource;-findItemIndex-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager;-getMobileProvisioningUrl-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-addWindow-(Lcom/android/server/wm/Session; Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment$3;-run-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-clearServices-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRawPdu-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/PolicyService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/AccountService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/AbstractSettingPopup;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-moveQueueItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/browser/SuggestionsAdapter$SlowFilterTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/RestrictionsPinActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-moveStackWindowsLocked-(Lcom/android/server/wm/DisplayContent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/googlecode/mp4parser/authoring/builder/Mp4Builder;-build-(Lcom/googlecode/mp4parser/authoring/Movie;)Lcom/coremedia/iso/IsoFile;' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/CropFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/provider/FolderPickerActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiController$FullHighPerfLockHeldState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageDraw;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-setBluetoothScoOn-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/magicsmoke/MagicSmokeSelector;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/MailLogService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IIccPhoneBook;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/camera/ui/FaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/SelectedConversationsActionMenu;-updateSelection-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/view/SurfaceView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarViewAdapter;-<init>-(Landroid/content/Context; I Z)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothMap$Stub$Proxy;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/ImapAuthenticatorService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/picasasource/PicasaSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/ui/RotatableLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/statusbar/IStatusBarService;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/server/BackupManagerService;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/speech/tts/ITextToSpeechService$Stub$Proxy;-speak-(Landroid/os/IBinder; Ljava/lang/String; I Landroid/os/Bundle;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/fall/Fall;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneProxy;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/FilmstripPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/ConnectivityService;-access$1600-(Lcom/android/server/ConnectivityService; Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-query-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/support/v13/app/FragmentTabHost;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageInviteView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-addAppWidget-(I I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaRecorder;-setVideoSource-(I)V' : ['android.permission.CAMERA'],
	'Landroid/filterpacks/base/GLTextureSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/timezonepicker/TimeZonePickerView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/DownloadHandler;-onDownloadStart-(Landroid/app/Activity; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Z)V' : ['android.permission.INTERNET'],
	'Lcom/android/camera/ProxyLauncher;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/emailcommon/service/IPolicyService$Stub$Proxy;-setAccountPolicy-(J Lcom/android/emailcommon/provider/Policy; Ljava/lang/String;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mail/compose/AutoSendActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/ConversationsInOutboxTipView;-goToOutbox-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableUsbRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/Development;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processVolumeEvent-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/TrackBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/telephony/TelephonyManager;-getDeviceSoftwareVersion-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/print/IPrintManager;-stopPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-hasMultipleEnabledSubtypesInThisIme-(Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/Session;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/media/AudioService;-adjustStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/AccountService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-reRegisterNetwork-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt;-beginReliableWrite-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/grass/Grass;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/dreams/phototable/FlipperDream;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/AlertActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/UsimFileHandler;-loadEFLinearFixed-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasSearch;-performOperation-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/content/MutableContextWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/colorpicker/ColorPickerPalette;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/util/ReverseGeocoder;-computeAddress-(Lcom/android/gallery3d/util/ReverseGeocoder$SetLatLong;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/service/EmailSyncAdapterService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phasebeam/PhaseBeamView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/EasService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/PopupWindow$PopupViewContainer;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/GridView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/SupplicantStateTracker$DormantState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-doNotifyDataConnection-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getCLIR-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiService;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/mail/ui/FolderSelectionActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/view/PagerTitleStrip;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/ColorButton;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/UiModeManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountAuthenticatorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IActivityManager;-unbroadcastIntent-(Landroid/app/IApplicationThread; Landroid/content/Intent; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ActionBarContainer;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/OverlayTitleTemplatePicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractActivityController;-confirmAndDelete-(I Ljava/util/Collection; Z I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/effect/FilterGraphEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IContentService$Stub$Proxy;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/app/TrimTimeBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/menu/ListMenuItemView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/OnePaneController;-updateConversation-(Ljava/util/Collection; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/hardware/location/GeofenceHardware;-pauseGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-stopScan-(I Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/provider/VoicemailContract$Status;-buildSourceUri-(Ljava/lang/String;)Landroid/net/Uri;' : ['com.android.voicemail.permission.ADD_VOICEMAIL'],
	'Lcom/android/browser/TabScrollView$TabLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/NativeActivity$NativeContentView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/ModuleSwitcher;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-agentErrorCleanup-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/noisefield/NoiseFieldWallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calculator2/ColorButton;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/InitAlarmsService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/packageinstaller/GrantActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-reportGeofenceResumeStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/nexus/NexusWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/view/RotationPolicy;-isRotationLockToggleVisible-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth;-setScanMode-(I I)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/OnePaneController;-updateAccounts-(Lcom/android/mail/content/ObjectCursor;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/contacts/ContactsListActivity;-getUriToQuery-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothHealth;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/EasOutboxService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/AccountController;-changeAccount-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterApp;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupStepIndicatorView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasOperation;-expandedAddDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer; Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager;)V' : ['android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/photos/views/HeaderGridView$FullWidthFixedViewLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/ProfileService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/MailWebView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/provider/EmailProvider;-startSync-(Lcom/android/emailcommon/provider/Mailbox; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/email/service/LegacyImapAuthenticatorService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ShutdownActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/TextureView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-startPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/ConversationListFragment;-onConversationListStatusUpdated-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/MinTimeProgressView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/UsimDataDownloadHandler;-sendSmsAckForEnvelopeResponse-(Lcom/android/internal/telephony/uicc/IccIoResult; I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasSyncService;-canProvision-(Lcom/android/exchange/EasSyncService;)Lcom/android/exchange/adapter/ProvisionParser;' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/CompoundButton;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/VideoEditorActivity$23;-onStop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Telephony$Sms$Sent;-addMessage-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/Long;)Landroid/net/Uri;' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/power/PowerManagerService$1;-onProximityPositive-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendTouchExplorationGestureStartAndHoverEnterIfNeeded-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapUtils;-isProfileSet-(Landroid/content/Context;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/EventViewer;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/AbstractActivityController;-showConversation-(Lcom/android/mail/providers/Conversation;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/providers/AccountObserver;-onChanged-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Landroid/content/IContentService;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/widget/ExpandableListView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/polarclock/PolarClockWallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/AllInOneActivity;-configureActionBar-(I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/development/PackageSummary;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/RunningProcesses;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String; I)Landroid/content/Intent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/exchange/eas/EasOptions;-addDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/data/ComboAlbum;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-enableGsmBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/view/VolumePanel;-onRemoteVolumeChanged-(I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService;-setMode-(I Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/ISms$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/widget/ZoomButtonsController$Container;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/service/dreams/Sandman;-startDreamWhenDockedIfAppropriate-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/ConnectivityService;-setLockdownTracker-(Lcom/android/server/net/LockdownVpnTracker;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/LocalePicker;-updateLocale-(Ljava/util/Locale;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationListFragment;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/widget/WidgetService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine;-access$1100-(Lcom/android/bluetooth/a2dp/A2dpStateMachine; Landroid/bluetooth/BluetoothDevice; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wm/WindowManagerService;-requestTraversalLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/test/SimulatedCommands;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-removeDeletion-(Lcom/android/gallery3d/data/Path;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/RadioButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/AccountsTester;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/bmgr/Bmgr;-doListRestoreSets-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/compose/ComposeActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/view/StopProgressView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-reassociate-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/keychain/KeyChainActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/LegacyImapAuthenticatorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/ConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/LocationManagerService;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/support/v4/app/FragmentActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/SecureConversationViewController;-renderMessage-(Lcom/android/mail/browse/ConversationMessage;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/MoviePlayer;-access$800-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UrlInputView;-onSelect-(Ljava/lang/String; I Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/VibratorService;-onInputDeviceRemoved-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/ui/FramedTextButton;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/Pop3Service$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/DataManager;-delete-(Lcom/android/gallery3d/data/Path;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/AbstractActivityController;-destroyPending-(Lcom/android/mail/ui/DestructiveAction;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine;-access$2200-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ActivityManagerNative;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-setUpAdapter-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mail/compose/FromAddressSpinner;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BatteryService$BatteryListener;-batteryPropertiesChanged-(Landroid/os/BatteryProperties;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/uicc/UiccCard;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/uicc/IccCardStatus;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-updatePhoneObject-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-getInstalledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/AbstractSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-acceptCall-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/WaveView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/widget/EllipsizeLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/ButtonSwitcher;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/support/v7/widget/GridLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleNonSpecialCharacter-(I I I I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/PackageManagerBackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/browser/PageDialogsHandler$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/ExtractEditText;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/SearchActivity;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mail/ui/TwoPaneController;-access$300-(Lcom/android/mail/ui/AbstractActivityController; Lcom/android/mail/providers/Conversation; Ljava/util/Set; [B)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/speech/tts/ITextToSpeechService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-handleOnRotationChanged-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/view/CertificateSelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/view/CertificateSelector;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/GoogleAccountLogin;-invalidateTokens-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/service/wallpaper/WallpaperService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/EmojiCategoryPageIndicatorView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/service/PingTask;-onCancelled-(Ljava/lang/Void;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cat/RilMessageDecoder$StateStart;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/wifi/WifiStateMachine;-handlePostDhcpSetup-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/AccountServiceProxy$6;-run-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/ui/ConversationViewFragment$MailJsBridge$1;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/INetworkPolicyManager$Stub;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/WakeLockHoldingProgressListener;-onProgressStart-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/Phone;-getCellLocation-()Landroid/telephony/CellLocation;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/AlertService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupConnection-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/NotificationManagerService;-rebindListenerServices-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/AudioPreview;-playPauseClicked-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ingest/ui/IngestGridView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/util/Log$1;-onTerribleFailure-(Ljava/lang/String; Landroid/util/Log$TerribleFailure;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager;-createPrinterDiscoverySession-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/StatusBarManager;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/browser/TabControl;-setCurrentTab-(Lcom/android/browser/Tab; Z)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/text/StringSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationPager;-pageRight-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/NativeActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/print/PrintManagerService;-access$200-(Lcom/android/server/print/PrintManagerService; I)Lcom/android/server/print/UserState;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AsyncPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/Wallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorValueView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/printspooler/SelectPrinterActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/MediaSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/OnePaneController;-showNextConversation-(Ljava/util/Collection;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/photos/FullscreenViewer;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarEventModel;-<init>-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/AbstractActivityController$8;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/DigitalClock;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/AlertActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AllInOneActivity;-onBackPressed-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/CaptivePortalTracker;-<init>-(Landroid/content/Context; Landroid/net/IConnectivityManager;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/development/CacheAbuser;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-dispose-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/backup/LocalTransportService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/DatePicker;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/browse/ConversationCursor$3;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationViewFragment;-onConversationSeen-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/ui/ShortcutNameActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/SnailSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/ConnectivityService;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/WeekSelector;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEventInternal-(I I J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/CalendarView;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RotateFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/documentsui/DocumentsApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/PackageBrowser;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ViewMode;-enterSearchResultsConversationMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-setAlphabetKeyboard-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/RingtoneManager;-getActualDefaultRingtoneUri-(Landroid/content/Context; I)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/photo/PhotoViewActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/map/BluetoothMapObexServer;-onPut-(Ljavax/obex/Operation;)I' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/server/input/InputManagerService;-start-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calculator2/Calculator;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/ui/TwoPaneController;-onAnimationEnd-(Lcom/android/mail/ui/AnimatedAdapter;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/view/PieListView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPattern-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/os/RuntimeInit$UncaughtHandler;-uncaughtException-(Ljava/lang/Thread; Ljava/lang/Throwable;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/documentsui/TestActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/compose/QuotedTextView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/CheckedTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/widget/SearchViewCompatIcs$MySearchView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/Phone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/GalleryAppImpl;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/input/InputManagerService$WindowManagerCallbacks;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-rejectCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPickerActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcDisconnectionErrorCreatingConnection;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-publishUpdateWordListCompleted-(Landroid/content/Context; Z J Landroid/database/sqlite/SQLiteDatabase; Landroid/content/ContentValues; Ljava/lang/String;)V' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetooth$Stub;-getAdapterConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView$Listener;-pickSuggestionManually-(I Lcom/android/inputmethod/latin/SuggestedWords$SuggestedWordInfo;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/support/v7/widget/GridLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/AppHwPref;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/DayView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/mail/photomanager/ContactPhotoManager$ContactPhotoLoaderThread;-loadPhotosInBackground-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/LocationManagerService;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/mail/compose/FromAddressSpinner;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/LogViewer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/NetInitiatedActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextClock$1;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onKeyRepeat-(I I)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/server/WallpaperManagerService$MyPackageMonitor;-onPackageAppeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-matchRecipientSms-(Landroid/database/Cursor; Lcom/android/bluetooth/map/BluetoothMapContent$FilterInfo; Ljava/lang/String;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-doRecovery-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothHeadset;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/packageinstaller/TabsAdapter;-setPrimaryItem-(Landroid/view/ViewGroup; I Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosrc/MediaSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/service/LegacyEasAuthenticatorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/sip/SipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsByTypeForPackage-(Ljava/lang/String; Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-handleVolumeKey-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/BatchService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/ViewStub;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/View$AttachInfo$Callbacks;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavTabView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/widget/NumberPicker$CustomEditText;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/AccountsChangedReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/hdp/HealthService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/VideoModule;-initializeRecorder-()V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/ingest/IngestService;-setDevice-(Landroid/mtp/MtpDevice;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-access$200-(Lcom/android/server/am/ActivityManagerService; Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-markAsDeleted-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I I)V' : ['android.permission.INTERNET'],
	'Lcom/android/development/Details;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/CompatModeDialog$1;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/dreams/phototable/PhotoTableDream;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/gallery3d/ui/TileImageView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/ConversationsInOutboxTipView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/AddBookmarkPage;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/PolicyService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-stopDtmf-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/NonDistinctMultitouchHelper;-injectMotionEvent-(I F F J J Lcom/android/inputmethod/keyboard/PointerTracker; Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/documentsui/DirectoryFragment;-access$1700-(Landroid/content/Context; J)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/fall/FallWallpaper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/provider/EmailProvider;-uiSaveDraftMessage-(J Landroid/os/Bundle;)Landroid/net/Uri;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/ConsumerIrService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.TRANSMIT_IR'],
	'Lcom/android/emailcommon/Device;-getDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$FullImageJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/RecognitionService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/location/LocationBlacklist;-getStringArrayLocked-(Ljava/lang/String;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-access$200-()Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiStateMachine;-access$8000-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setInitialAttachApn-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/commands/svc/PowerCommand;-run-([Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/Exchange;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/ex/photo/PhotoViewPager;-dataSetChanged-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IBatteryPropertiesListener$Stub;-batteryPropertiesChanged-(Landroid/os/BatteryProperties;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/CalendarView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/VerticalTextSpinner;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-msgListingSize-(Ljava/lang/String; Lcom/android/bluetooth/map/BluetoothMapAppParams;)I' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/mail/browse/ScrollIndicatorsView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/research/FeedbackActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/RIL;-setLocationUpdates-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/CameraRootView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/deskclock/timer/TimerView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/photo/fragments/PhotoViewFragment;-onResume-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/recurrencepicker/LinearLayoutWithMaxWidth;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onReleaseShift-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/DigitalClock;-access$300-(Landroid/widget/DigitalClock;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/app/ChooserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/FilterGraphEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/os/IVibratorService$Stub$Proxy;-cancelVibrate-(Landroid/os/IBinder;)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/BluetoothDevice;-createInsecureRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/dreams/phototable/FlipperDream;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/keyboard/internal/PreviewPlacerView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/Screensaver;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/app/NoSaveStateFrameLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/RadialSelectorView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/ContactStatusLoader;-getContactInfo-(Landroid/content/Context; Ljava/lang/String;)Lcom/android/email/activity/ContactStatusLoader$Result;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/alerts/InitAlarmsService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accounts/AccountManagerService$6;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/TrimVideo;-access$100-(Lcom/android/gallery3d/app/TrimVideo;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getDeviceSvn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/grass/GrassWallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/EventInfoFragment;-access$1700-(Lcom/android/calendar/EventInfoFragment; Landroid/view/View;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/Browser;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/eas/EasPing;-getRequestEntity-()Lorg/apache/http/HttpEntity;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/packageinstaller/UninstallerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/ConversationListFragment;-showSyncStatusBar-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/Controller;-onProgressChanged-(Lcom/android/browser/Tab;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/tts/compat/CompatTtsService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-sendConnectionStateChange-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email2/ui/CreateShortcutActivityEmail;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/timer/TimerView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ResolverActivity$1;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/AnimatedAdapter;-access$400-(Lcom/android/mail/ui/AnimatedAdapter; Ljava/lang/Object; Ljava/util/HashSet;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$5;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/AttachmentDownloadService;-canPrefetchForAccount-(Lcom/android/emailcommon/provider/Account; Ljava/io/File;)Z' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/Notifier$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/app/PickerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/OnePaneController;-onRefreshReady-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/eas/EasSettings;-sendMessage-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/EmailContent$Message;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/app/ExternalMediaFormatActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/view/ScrollerView;-onLayout-(Z I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mail/utils/NotificationUtils;-findContacts-(Landroid/content/Context; Ljava/util/Collection;)Ljava/util/ArrayList;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ListView;-commonKey-(I I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-onFinishSlidingInput-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/OnePaneController;-disableCabMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/AnalogClock;-onTimeChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/service/ApiService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/FaceView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/ImapService;-loadUnsyncedMessages-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/mail/Folder; Ljava/util/ArrayList; Lcom/android/emailcommon/provider/Mailbox;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/app/IBatteryStats;-getStatistics-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPuk2ForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-queryPin1State-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/NetInitiatedActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService$1;-searchMessages-(J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/view/View;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/EventInfoFragment;-showContactInfo-(Lcom/android/calendar/CalendarEventModel$Attendee; Landroid/graphics/Rect;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ui/PhotoView$1;-onClick-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/lang/String;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/inputmethodservice/KeyboardView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventView;-setDate-(Landroid/widget/TextView; J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationViewFragment;-processNewOutgoingMessage-(Lcom/android/mail/browse/ConversationMessage;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/media/effect/effects/GrayscaleEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$IndicatorView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/OnePaneController;-handleDragFromStarred-(Lcom/android/mail/providers/Folder;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/Wallpaper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/FolderSelectionActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/WifiStateMachine$CaptivePortalCheckState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofencePauseStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/documentsui/TestActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/LocalSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/OnePaneController;-onBackPressed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/XLargeUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mail/ui/AnimatedAdapter;-setFooterVisibility-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/TwoPaneController;-showConversation-(Lcom/android/mail/providers/Conversation; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-confirmCredentialsAsUser-(Landroid/accounts/Account; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler; Landroid/os/UserHandle;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mail/ui/TwoPaneController;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/ui/ConversationSelectionSet;-clear-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/hardware/location/GeofenceHardware;-addGeofence-(I I Landroid/hardware/location/GeofenceHardwareRequest; Landroid/hardware/location/GeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/PackageBrowser;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/soundrecorder/SoundRecorder;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO'],
	'Landroid/content/IContentService$Stub;-sync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyPuk2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/photos/FullscreenViewer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-executeNextState-(Lcom/android/server/BackupManagerService$BackupState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/camera/ui/RenderOverlay$RenderView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-doFinish-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/widget/BookmarkWidgetConfigure;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService$WakeLock;-binderDied-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/CreatePlaylist;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/PhoneNumberUtils;-isVoiceMailNumber-(Ljava/lang/String;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/Phone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/RenamePlaylist;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine;-stopTethering-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/dreams/phototable/PhotoCarousel;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/widget/FaceUnlockView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneController;-onCreate-(Landroid/os/Bundle;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/ActionModeHandler$2;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/mail/ui/FolderItemView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/ActivityState;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/GeolocationPermissionsPrompt;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/DeskClock;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/widgets/HandleView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/UserManagerService$5;-onPackageAppeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onReleaseKey-(I Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-addSecureAlbumItem-(Z I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccProvider;-loadFromEf-(I)Landroid/database/MatrixCursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/browser/view/SnapshotGridView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Presentation$1;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/notification/NotificationListenerService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SizeAdaptiveLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/galaxy4/GalaxyView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$System;-getShowGTalkServiceStatusForUser-(Landroid/content/ContentResolver; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-setInitialAttachApn-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameStore;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/location/LocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/filtershow/CenteredLinearLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/PageProgressView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-addOnAccountsUpdatedListener-(Landroid/accounts/OnAccountsUpdateListener; Landroid/os/Handler; Z)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/map/BluetoothMapService$BluetoothMapBinder;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TitleBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$2;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/timer/TimerAlertFullScreen;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/AlbumSlidingWindow;-onContentChanged-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/IAudioService$Stub;-reloadAudioSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-configHciSnoopLog-(Z)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/utils/NotificationUtils;-configureLatestEventInfoFromConversation-(Landroid/content/Context; Lcom/android/mail/providers/Account; Lcom/android/mail/preferences/FolderPreferences; Landroid/support/v4/app/NotificationCompat$Builder; Landroid/database/Cursor; Landroid/app/PendingIntent; Landroid/content/Intent; I I Lcom/android/mail/providers/Folder; J)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/effect/effects/TintEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage$7;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/effect/effects/SepiaEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/speech/RecognitionService$RecognitionServiceBinder;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/CommandsInterface;-deleteSmsOnSim-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/view/BookmarkContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/inputmethodservice/KeyboardView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/MailboxSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/FolderSpanTextView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/CalculatorViewPager;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothHeadset;-getAudioState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/SecureConversationViewFragment;-renderMessage-(Lcom/android/mail/browse/MessageCursor;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPlaybackActivity;-access$600-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-setFacilityLockForApp-(Ljava/lang/String; Z Ljava/lang/String; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasSyncService;-validateAccount-(Lcom/android/emailcommon/provider/HostAuth; Landroid/content/Context;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/ProfileService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-onKey-(I [I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-clearPendingBroadcastsLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/TimelineRelativeLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/Spinner;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeech;-getDefaultEngine-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Service;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/widget/TextTime;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UI;-onBackKey-()Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/WifiManager;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/PlaylistBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/alarmclock/DigitalWidgetViewsFactory;-getViewAt-(I)Landroid/widget/RemoteViews;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/AttendeesView;-constructAttendeeView-(Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiStateMachine;-access$23400-(Landroid/net/wifi/WifiStateMachine; Ljava/util/ArrayList;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/sip/SipAudioCall;-transferToNewSession-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE'],
	'Landroid/bluetooth/BluetoothA2dp;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/NullFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/sip/ISipService;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/coremedia/iso/IsoFile;-<init>-(Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/hid/HidService;-getReport-(Landroid/bluetooth/BluetoothDevice; B B I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/TouchInterceptor$RemoveListener;-remove-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/PlaylistBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothMap$Stub;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/exchange/EasCertificateRequestor;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/FragmentBreadCrumbs;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/research/ReplayerService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/print/IPrintManager$Stub;-getPrintJobInfos-(I I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/UriSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CellBroadcastHandler;-handleSmsMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-fetchRemoteUuids-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/ResolverActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email2/ui/MailActivityEmail;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/ui/ViewMode;-enterConversationListMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hid/HidService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/widget/LockPatternUtils;-usingBiometricWeak-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardEntry$PhotoData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImagePoint;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-doVisibilityChanged-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/PhoneProxy;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-getRemoteType-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/content/SyncManager;-scheduleLocalSync-(Landroid/accounts/Account; I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/ConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/printservice/PrintService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-addTestProvider-(Ljava/lang/String; Lcom/android/internal/location/ProviderProperties;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/deskclock/timer/CountingTimerView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/SelectedConversationsActionMenu;-destroy-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-downloadFinished-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.INTERNET'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-writeCharacteristic-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/google/common/io/MultiReader;-advance-()V' : ['android.permission.INTERNET'],
	'Landroid/media/IAudioService;-adjustStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/TextureView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/NotificationController;-access$1000-(Landroid/content/Context; J)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mail/ui/ConversationListView$HintText;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/OnePaneController;-switchToDefaultInboxOrChangeAccount-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getLastTetherError-(Ljava/lang/String;)I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/SyncAdapterDriver;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/VolumePanel;-setStreamVolume-(I I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/SmsApplication$SmsPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue;-releaseAllPointers-(J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/wifi/WifiController$StaEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/widget/AnalogClock;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartedState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothMap;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/videoeditor/widgets/EditorRelativeLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WiredAccessoryManager;-notifyWiredAccessoryChanged-(J I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/RIL;-sendUSSD-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractButton;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IBackupAgent$Stub;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/widget/WaveView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/LocationFudger$1;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/ProcessInfo;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-make-(Lcom/android/internal/telephony/cat/BerTlv;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/browse/ConversationItemView;-toggleSelectedState-(Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setProfileAutoConnectionPriority-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/CheckedTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Landroid/support/v4/content/AsyncTaskLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/mail/ui/AbstractConversationViewFragment;-onMessageCursorLoadFinished-(Landroid/content/Loader; Lcom/android/mail/browse/MessageCursor; Lcom/android/mail/browse/MessageCursor;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email2/ui/MailboxSelectionActivityEmail;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/AccountItemView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasSyncService;-postAutodiscover-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-getIMSI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email2/ui/MailActivityEmail;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/widgets/HandleView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-addWordToUserDictionary-(Ljava/lang/String;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/AddBookmarkPage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/setup/MailboxSettings$LoadMailboxTask;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/latin/settings/SettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TtsEngines;-getV1Locale-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageGrad;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmTimelineView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-cancelPostDial-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-open-([J I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothInputDevice;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/AppSecurityPermissions$PermissionItemView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/eas/EasPing;-requestNoOpSync-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/support/v4/view/ViewPager;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothGattCallback$Stub$Proxy;-onDescriptorRead-(Ljava/lang/String; I I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/providers/AccountObserver;-onChanged-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/accounts/AccountManagerService;-checkReadAccountsPermission-()V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/media/SubtitleTrack;-hide-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/content/Context;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt;-refreshDevice-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-changeIccPin2-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationListView$HintText;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/provider/Settings$System;-getInt-(Landroid/content/ContentResolver; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/ProfileService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/photo/adapters/BaseCursorPagerAdapter;-setPrimaryItem-(Landroid/view/ViewGroup; I Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/os/IPowerManager;-releaseWakeLock-(Landroid/os/IBinder; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-bluetoothStateChangeHandler-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/common/contacts/BaseEmailAddressAdapter$DirectoryPartitionFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/worldclock/CitiesActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IPowerManager$Stub$Proxy;-acquireWakeLockWithUid-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ChooserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine$ConnectModeState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupIncoming;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackActivity;-startPlayback-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/IWifiManager$Stub;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/app/MovieActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/FilmstripPage;-showDetails-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/vcard/VCardEntry;-iterateAllData-(Lcom/android/vcard/VCardEntry$EntryElementIterator;)V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onActionBarWanted-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/google/android/mms/util/AbstractCache;-put-(Ljava/lang/Object; Ljava/lang/Object;)Z' : ['android.permission.WRITE_SMS', 'android.permission.READ_SMS'],
	'Landroid/widget/RatingBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingMenu;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/ui/CountdownTimerPopup;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/PhotoTable;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterApp;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/SyncActivityTooManyDeletes;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-loadEfFilesFromUsim-()Ljava/util/ArrayList;' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-getStringForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/FolderItemView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/MailboxSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/filtershow/category/CategoryTrack;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask;-restoreOneFile-(Ljava/io/InputStream; [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/browse/ConversationPager;-onInterceptTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/CompoundButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationSyncDisabledTipView;-getShouldDisplayInList-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageRedEye;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/soundrecorder/Recorder;-signalStateChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/media/WebVttRenderingWidget$SpanLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/TimerRingService;-play-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/MediaItemView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/AlertActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/SuperCollapsedBlock;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/AppHwPref;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/PageDialogsHandler;-access$700-(Lcom/android/browser/PageDialogsHandler; Lcom/android/browser/Tab;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PickerActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/app/CameraApp;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/service/EasAutoDiscover;-sendHttpClientPost-(Ljava/lang/String; [B J)Lcom/android/exchange/EasResponse;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/InputMethodManagerService$InputMethodAndSubtypeListManager;-getSortedInputMethodAndSubtypeList-(Z Z Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/monkey/Monkey;-run-([Ljava/lang/String;)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/LocationManagerService;-handleLocationChanged-(Landroid/location/Location; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/UninstallerActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calculator2/CalculatorViewPager;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/providers/telephony/SmsProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/email/service/AuthenticatorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractActivityController;-getFolderChange-(Ljava/util/Collection; Ljava/util/Collection; Z Z Z Z Lcom/android/mail/providers/Folder;)Lcom/android/mail/ui/DestructiveAction;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-disconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/music/IMediaPlaybackService;-removeTrack-(J)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AbstractCalendarActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/nfc/cardemulation/HostApduService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-handleUp-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/AliasActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/ConfigurationViewer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageCrop;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-stopPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ActionBarView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mail/ui/ConversationsInOutboxTipView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/MediaSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Browser;-getVisitedHistory-(Landroid/content/ContentResolver;)[Ljava/lang/String;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/AllInOneActivity$2;-run-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/EasSyncService;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingCheckBox;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/provider/EmailProvider;-restartPush-(Landroid/content/Context; Landroid/database/sqlite/SQLiteDatabase; Ljava/lang/String;)Z' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/wm/WindowManagerService;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/bluetooth/IBluetoothGatt;-startScan-(I Z)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/app/CameraApp;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$AudioOn;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mail/browse/ConversationPager;-executeKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiManager$WifiLock;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/alarms/AlarmKlaxon;-startAlarm-(Landroid/content/Context; Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/MoreSettingPopup;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/AbstractActivityController;-onAnimationEnd-(Lcom/android/mail/ui/AnimatedAdapter;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/RadioGroup;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothPan;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/CalendarSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/ViewFlipper;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/research/Uploader;-hasWifiConnection-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/DigitalClock;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-getKeyDescription-(Lcom/android/inputmethod/keyboard/Key;)Ljava/lang/String;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TabWidget;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/BadBehaviorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onTextInput-(Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/pan/PanService;-enableTethering-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/NsdService$NsdStateMachine;-<init>-(Lcom/android/server/NsdService; Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/app/NativeActivity$NativeContentView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/noisefield/NoiseFieldWallpaper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/SkbContainer;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/AddBookmarkPage$CustomListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasAccountService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/RuimFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/editors/SwapButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/ImapAuthenticatorService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/ConnectivityManager;-tether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/BadBehaviorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calculator2/ColorButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneController;-showNextConversation-(Ljava/util/Collection;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/InboundSmsHandler$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PieController$1;-onClick-(Lcom/android/camera/ui/PieItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/DayFragment;-handleEvent-(Lcom/android/calendar/CalendarController$EventInfo;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/datetimepicker/time/AmPmCirclesView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextView;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/alarms/AlarmService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BackupManagerService$RunBackupReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/wm/Wm;-run-([Ljava/lang/String;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.RESTART_PACKAGES'],
	'Lcom/android/development/ShowActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/utils/NotificationUtils;-getContactIcon-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; Lcom/android/mail/providers/Folder;)Landroid/graphics/Bitmap;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/PlaylistBrowserActivity;-playPodcasts-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/ViewOverlay$OverlayViewGroup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/RIL;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/MediaSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/GLView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession$ClientThread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoPage;-notifyScreenNailChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/tts/TextToSpeechService;-access$400-(Landroid/speech/tts/TextToSpeechService;)[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-scanPackageLI-(Landroid/content/pm/PackageParser$Package; I I J Landroid/os/UserHandle;)Landroid/content/pm/PackageParser$Package;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getRemoteName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/utility/CalendarUtilities;-createCalendar-(Landroid/content/Context; Landroid/content/ContentResolver; Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/Mailbox;)J' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/UiModeManagerService;-access$100-(Lcom/android/server/UiModeManagerService; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/musicvis/vis5/Visualization5;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-handleAccessPermissionResult-(Landroid/content/Intent;)V' : ['android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/location/LocationBlacklist;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$Listener;-onFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/os/BatteryStatsImpl;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/SubtitleView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAccountsByTypeForPackage-(Ljava/lang/String; Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-hangup-(Lcom/android/internal/telephony/cdma/CdmaCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/widget/SearchViewCompatIcs$MySearchView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ControllableActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/documentsui/SettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/SnailAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/ILockSettings;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/EmojiPalettesView;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-handleCdmaSubscriptionSource-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/IWifiManager;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub;-getCurrentSpellCheckerSubtype-(Ljava/lang/String; Z)Landroid/view/textservice/SpellCheckerSubtype;' : ['android.permission.READ_PROFILE'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorage-(J Landroid/content/IntentSender;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity$1;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/browser/PieControl;-buildTabs-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/bluetooth/BluetoothA2dp;-isAvrcpAbsoluteVolumeSupported-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/TrackBrowserActivity$TrackListAdapter;-runQueryOnBackgroundThread-(Ljava/lang/CharSequence;)Landroid/database/Cursor;' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/timer/TimerListItem;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/bluetooth/IBluetooth;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/BluetoothA2dp;-adjustAvrcpAbsoluteVolume-(I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/accounts/ChooseAccountTypeActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/base/RetargetFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/PhoneUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/search/SearchManagerService$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/UninstallerActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/CalendarSyncParser;-responsesParser-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/eas/EasFolderSync;-performOperation-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/UsageStatsService$2;-onPackageAppeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-stopPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-access$200-(Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;)V' : ['android.permission.CAMERA'],
	'Lcom/android/mail/browse/EmlTempFileDeletionService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasLoadAttachment;-performOperation-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/backup/LocalTransportService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService;-clearAllScoClients-(I Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothHeadset;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onUpEvent-(I I J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/InboundSmsHandler$StartupState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/app/IBatteryStats$Stub;-getStatistics-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/ManageCachePage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-onCreateOptionsMenu-(Landroid/view/Menu; Landroid/view/MenuInflater;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Controller;-openTabToHomePage-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipWakeLock;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calculator2/CalculatorViewPager;-setCurrentItemInternal-(I Z Z I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/ChooseAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/EmailServiceUtils;-setRemoteServicesLogging-(Landroid/content/Context; I)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/BluetoothAdapter;-getScanMode-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/WakeLockStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/wifi/WifiController$FullHighPerfLockHeldState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/view/IWindowManager$Stub;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/accounts/IAccountManager;-confirmCredentialsAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/development/ConfigurationViewer;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/worldclock/CitiesActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailsync/SyncManager;-sendMessageRequest-(Lcom/android/emailsync/Request;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FilterGraph;-tearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/widget/TextClock;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TelephonyRegistry;-broadcastSignalStrengthChanged-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/musicvis/vis4/Visualization4;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AlarmTimelineView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/SmsBroadcastUndelivered;-scanRawTable-()V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/exchange/ExchangeService;-reconcileAccounts-(Landroid/content/Context;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/service/AuthenticatorService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/TabScrollView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/IInputMethodManager$Stub$Proxy;-setCurrentInputMethodSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/date/AccessibleDateAnimator;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-showAndStartWelcomeVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/textservice/SpellCheckerService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-requestRouteToHost-(I I Ljava/lang/String;)Z' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasAccountService;-runPingLoop-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-onUserContextChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/crop/CropView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/ComboViewActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/SearchActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calculator2/PanelSwitcher;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-updateAdnRecordsInEfBySearch-(I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/printspooler/PrintJobConfigActivity$CustomEditText;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/EventViewer;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$P2pEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiService;-setWifiApConfiguration-(Landroid/net/wifi/WifiConfiguration;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/nfc/cardemulation/OffHostApduService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-loadAttachmentStatus-(J J I I)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/BluetoothHealth;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/SmsApplication$SmsPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/DataManager$NotifyBroker;-onChange-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Browser;-truncateHistory-(Landroid/content/ContentResolver;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getEnabledInputMethodList-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/UrlInputView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DockObserver;-access$000-(Lcom/android/server/DockObserver;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/app/Service;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/MediaSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onBackPressed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/CheckedLinearLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/MenuExecutor$MediaOperation;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothHealth;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/service/EasService$1;-updateFolderList-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/DataList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/WallpaperManagerService;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/server/pm/PackageManagerService$7;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/email/service/EmailServiceStub;-loadAttachment-(Lcom/android/emailcommon/service/IEmailServiceCallback; J J Z)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.INTERNET', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/NsdService$NsdStateMachine$DisabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/ExpandableTextView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/view/PieStackView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/CaffeinatedScrollView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/ui/OnePaneController;-refreshConversationList-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/content/IContentService;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/telephony/ISms$Stub;-sendData-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.SEND_SMS'],
	'Landroid/widget/DialerFilter;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/CaptivePortalTracker;-sendNetworkConditionsBroadcast-(Z Z J J)V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getNeighboringCids-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoTable$LoadNaturalSiblingTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/PlaylistBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/EventViewer;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Landroid/view/IWindowSession;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/development/DataList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/support/v7/widget/GridLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaListView;-initView-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/agenda/AgendaListView$3;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Landroid/telephony/TelephonyManager;-getLine1AlphaTag-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/print/IPrintManager;-startPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/EffectContext;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$ErrorState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ServiceWatcher$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-forceStopUserLocked-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/ISyncAdapter$Stub;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/email/provider/RefreshStatusMonitor;-access$300-(Lcom/android/email/provider/RefreshStatusMonitor;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/DayView;-access$4600-(Lcom/android/calendar/DayView; Landroid/view/MotionEvent;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onRecordsLoaded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/FilmstripPage;-access$2400-(Lcom/android/gallery3d/app/PhotoPage; Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/ScreensaverActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/datetimepicker/date/DatePickerController;-onYearSelected-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/OverlayTitleEditor;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DeleteEventHelper$5;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/email/activity/setup/AccountSetupNames$3;-doInBackground-([Ljava/lang/Void;)Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/svox/pico/Pico;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-updateSpnDisplay-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/WapPushOverSms;-dispatchWapPdu-([B Landroid/content/BroadcastReceiver; Lcom/android/internal/telephony/InboundSmsHandler;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager$CellBroadcastRangeManager;-updateRanges-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UI;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/ISyncAdapter$Stub$Proxy;-startSync-(Landroid/content/ISyncContext; Ljava/lang/String; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getActiveNetworkInfoUnfiltered-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/uicc/AdnRecordCache;-updateAdnByIndex-(I Lcom/android/internal/telephony/uicc/AdnRecord; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/CantAddAccountActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPickerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/view/IInputMethodManager$Stub$Proxy;-getEnabledInputMethodSubtypeList-(Ljava/lang/String; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-shutdown-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-setRecipientName-(Lcom/android/bluetooth/map/BluetoothMapMessageListingElement; Landroid/database/Cursor; Lcom/android/bluetooth/map/BluetoothMapContent$FilterInfo; Lcom/android/bluetooth/map/BluetoothMapAppParams;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mail/compose/AutoSendActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/editstyledtext/EditStyledText;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DigitalClock;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCustomRequest-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/Controller;-onDownloadStart-(Lcom/android/browser/Tab; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.INTERNET', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/location/LocationBasedCountryDetector$1;-onLocationChanged-(Landroid/location/Location;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Landroid/accounts/AccountManager$3;-startTask-()V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mail/ui/AbstractActivityController;-assignFolder-(Ljava/util/Collection; Ljava/util/Collection; Z Z Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/GalleryActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phasebeam/PhaseBeam;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/compose/AttachmentComposeView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt;-endReliableWrite-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/InstrumentationList;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarUtils$TimeZoneUtils;-getTimeZone-(Landroid/content/Context; Ljava/lang/Runnable;)Ljava/lang/String;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mail/ui/TwoPaneController;-handleDropInStarred-(Lcom/android/mail/providers/Folder;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView; Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/view/ScrollerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/ObjectSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$LabelView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/state/StatePanelTrack;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IIntentReceiver$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompatKitKat$AccessibilityNodeInfoBridge;-createAccessibilityNodeInfo-(I)Ljava/lang/Object;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/music/VideoBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherMasterUtilState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/AlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/ActionBarContextView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/UninstallerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/alarmclock/DigitalAppWidgetService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-makeNowPlayingCursor-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/RestrictionsPinActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Presentation$1;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AsyncPlayer$Thread;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readTouchExplorationEnabledSettingLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-access$600-(Lcom/android/bluetooth/map/BluetoothMapService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/LockSettingsService$DatabaseHelper;-onUpgrade-(Landroid/database/sqlite/SQLiteDatabase; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-assignContactFromEmail-(Ljava/lang/String; Z)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mail/browse/ConversationWebView;-onScrollChanged-(I I I I)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/InputMethodManagerService$3;-onUserSwitching-(I Landroid/os/IRemoteCallback;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processUnknownAt-(Ljava/lang/String;)V' : ['android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppLiveFolder;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/AddBookmarkPage$CustomListView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/FillLightEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/SyncStorageEngine;-<init>-(Landroid/content/Context; Ljava/io/File;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallbackProxy$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothAdapter$GattCallbackWrapper;-stopLeScan-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/StateManager;-finishState-(Lcom/android/gallery3d/app/ActivityState; Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onDraw-(Landroid/graphics/Canvas;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/IBluetoothMap$Stub;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/CropFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/SwipeableListView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-bringDownServiceLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/vcard/VCardComposer;-init-()Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/music/ScanningProgress;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-matchOriginatorSms-(Landroid/database/Cursor; Lcom/android/bluetooth/map/BluetoothMapContent$FilterInfo; Ljava/lang/String;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasSyncService;-acknowledgeProvision-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IntentSender$FinishedDispatcher;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/RIL;-queryCdmaRoamingPreference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-handleRuimRefresh-(Lcom/android/internal/telephony/uicc/IccRefreshResponse;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/ScreensaverActivity$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler;-handleServiceCategoryProgramData-(Lcom/android/internal/telephony/cdma/SmsMessage;)Z' : ['android.permission.RECEIVE_SMS'],
	'Landroid/bluetooth/BluetoothInputDevice;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/text/ToUpperCase;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/SpamWarningView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventHelper;-saveEvent-(Lcom/android/calendar/CalendarEventModel; Lcom/android/calendar/CalendarEventModel; I)Z' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/filtershow/pipeline/ProcessingService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/eas/EasMoveItems;-performOperation-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-init-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/hdp/HealthService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/SeekBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/CaptivePortalTracker;-isActiveNetwork-(Landroid/net/NetworkInfo;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/RotateFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/AsyncService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/datetimepicker/date/TextViewWithCircularIndicator;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/editstyledtext/EditStyledText;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/EmailIntentService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/Screensaver;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/os/PowerManager$WakeLock$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/research/ReplayerService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/ViewSwitcher;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/service/AbstractSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/AppHwConfigList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/filtershow/crop/CropActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/map/BluetoothMapContentObserver;-sendMmsMessage-(Ljava/lang/String; Ljava/lang/String; Lcom/android/bluetooth/map/BluetoothMapbMessageMmsEmail;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commit-()V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetoothInputDevice;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/support/v7/widget/GridLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/StackView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/alarmclock/DigitalAppWidgetService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/browse/ConversationPager;-setCurrentItemInternal-(I Z Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/view/IWindowSession$Stub$Proxy;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-changeIccFdnPassword-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationContainer;-onGeometryChange-([Lcom/android/mail/browse/ConversationContainer$OverlayPosition;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/am/ActivityStackSupervisor;-pauseBackStacks-(Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/content/pm/IPackageManager$Stub$Proxy;-freeStorageAndNotify-(J Landroid/content/pm/IPackageDataObserver;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Lcom/android/browser/WallpaperHandler;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/mail/ui/TwoPaneLayout;-onTransitionComplete-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/development/Development;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/eas/EasOptions;-requestSyncForMailboxes-(Landroid/accounts/Account; Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri;)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-performTransitions-(Lcom/android/internal/util/State; Landroid/os/Message;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-<init>-(Lcom/android/music/TrackBrowserActivity; Lcom/android/music/IMediaPlaybackService; [Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MusicUtils;-togglePartyShuffle-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Browser;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-attachApplicationLocked-(Landroid/app/IApplicationThread; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/IAudioService$Stub;-adjustStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/provider/Settings$System;-getConfiguration-(Landroid/content/ContentResolver; Landroid/content/res/Configuration;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/WidgetConfigure;-setChoosenAlbum-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/RecognitionManagerService;-access$000-(Lcom/android/server/RecognitionManagerService; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/LegacyEmailAuthenticatorService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/BluetoothManagerService;-handleDisable-()V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/Pop3AuthenticatorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/AbsSpinner;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowSession$Stub$Proxy;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/ScrollView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageStraighten;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/fall/FallView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-getSubscriptionInfoAndStartPollingThreads-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-access$2900-(Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/DataManager;-getMediaSetsFromString-(Ljava/lang/String;)[Lcom/android/gallery3d/data/MediaSet;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/pinyin/SettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/ComboAlbum;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/NumberPicker;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/AbsActionBarView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/musicvis/vis4/Visualization4;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mail/ui/TwoPaneLayout;-dispatchConversationListVisibilityChange-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/ui/RotateLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmTimelineView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/monkey/Monkey;-main-([Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getConnectionInfo-()Landroid/net/wifi/WifiInfo;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavScreen;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/SharpenEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/musicvis/vis1/Visualization1;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/RemoteViewsService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodAndSubtypeHashCodeListLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getVoiceMailNumber-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/widget/Button;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/LocalSource;-naturalPrevious-(Landroid/graphics/Bitmap; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/CalendarApplication;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/CompoundButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SmsApplication;-getApplication-(Landroid/content/Context; Z)Lcom/android/internal/telephony/SmsApplication$SmsApplicationData;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/RedEyeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/location/FlpHardwareProvider;-onGeofencePause-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/TimePicker;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/GrantActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine$DriverStartedState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/ZoomControl;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/net/ConnectivityManagerCompat$ConnectivityManagerCompatImpl;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/videoeditor/widgets/HandleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/PackageManagerBackupAgent;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/ConversationUpdater;-updateConversation-(Ljava/util/Collection; Landroid/content/ContentValues;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/Button;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarController$EventHandler;-eventsChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mail/ui/FolderSelectionActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/WebVttRenderingWidget;-manageChangeListener-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-onCreate-(Landroid/view/SurfaceHolder;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/inputmethod/latin/settings/SeekBarDialogPreference$ValueProxy;-feedbackValue-(I)V' : ['android.permission.VIBRATE'],
	'Landroid/speech/tts/ITextToSpeechService$Stub;-getClientDefaultLanguage-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/DismissAlarmsService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/RingtoneManager;-getRingtone-(Landroid/content/Context; Landroid/net/Uri; I)Landroid/media/Ringtone;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/MessageHeaderView;-refresh-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ingest/ui/IngestGridView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/homepages/HomeProvider;-openFile-(Landroid/net/Uri; Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/widget/DateTimeView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/SystemServer;-main-([Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.VIBRATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.CLEAR_APP_CACHE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/widget/RadioButton;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/ime/Ime;-runList-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterApp;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/RotateLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/printspooler/PrintDialogFrame;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/ui/InLineSettingCheckBox;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/PointerLocation;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/MoreSettingPopup;-onSettingChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/support/v13/app/FragmentTabHost;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/documentsui/DocumentsApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/AbsActionBarView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasSettings;-performOperation-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/mail/ui/ConversationLongPressTipView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/GeneralPreferences;-onTimeZoneSet-(Lcom/android/timezonepicker/TimeZoneInfo;)V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/alarmclock/DigitalAppWidgetService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/PointerTracker$TimerProxy;-startUpdateBatchInputTimer-(Lcom/android/inputmethod/keyboard/PointerTracker;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/calendar/DayView;-handleOnResume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/widget/WidgetService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/FullBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/datetimepicker/date/DayPickerView;-arrowScroll-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onError-(Lcom/android/internal/telephony/Connection$DisconnectCause;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/musicvis/vis5/Visualization5;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/TrimVideo;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ContextThemeWrapper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/svox/pico/GetSampleText;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-closeCurrentTab-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/os/PowerManager$WakeLock;-release-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Tab;-setController-(Lcom/android/browser/WebViewController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/IAudioService$Stub;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/widget/DatePicker;-init-(I I I Landroid/widget/DatePicker$OnDateChangedListener;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/MediaFocusControl;-restoreMediaButtonReceiver-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/MultiAutoCompleteTextView;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterState$OnState;-enter-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/keyboard/internal/ScrollKeyboardView;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Landroid/print/PrintJob;-restart-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ProxyLauncher;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageAppeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/info/HistogramView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/FaceUnlockView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView$OnTriggerListener;-onTrigger-(Landroid/view/View; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/email2/ui/MailActivityEmail;-onRestoreInstanceState-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/musicvis/vis1/Visualization1;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/NoSearchActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/suggestions/MoreSuggestionsView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/PassiveProvider;-updateLocation-(Landroid/location/Location;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/widget/BookmarkWidgetConfigure;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/activity/EventViewer;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/ShowActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-showBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/AbstractActivityController;-changeFolder-(Lcom/android/mail/providers/Folder; Ljava/lang/String; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/svox/pico/GetSampleText;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/PackageBrowser;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertService;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Lcom/android/calendar/alerts/AlarmManagerInterface;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/music/AlbumBrowserActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/TabScrollView$TabLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkStatsService$Stub$Proxy;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/TimePicker;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email2/ui/MailActivityEmail;-updateLoggingFlags-(Landroid/content/Context;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/view/IWindowManager$Stub;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/exchange/eas/EasOperation;-requestSyncForMailbox-(Landroid/accounts/Account; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService$12;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/wallpaper/polarclock/PolarClockWallpaper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PackagesMonitor$AsyncService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/FolderItemView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/map/BluetoothMapObexServer;-sendMessageListingRsp-(Ljavax/obex/Operation; Lcom/android/bluetooth/map/BluetoothMapAppParams; Ljava/lang/String;)I' : ['android.permission.READ_CONTACTS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/Editor$SelectionEndHandleView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-exitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-addAccount-(Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/wallpaper/fall/FallWallpaper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/GalleryActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/AndroidClockTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/UserManagerService$5;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/widget/ViewSwitcher;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/FolderItemView;-onDragEvent-(Landroid/view/DragEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkPolicyManagerService$8;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/svox/pico/DownloadVoiceData;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/grass/GrassView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService$CheckMp;-doInBackground-([Lcom/android/server/ConnectivityService$CheckMp$Params;)Ljava/lang/Integer;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/PhotoPage;-requestDeferredUpdate-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hfp/AtPhonebook;-processCpbrCommand-()I' : ['android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ingest/ui/MtpFullscreenView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageInviteView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/CantAddAccountActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/onetimeinitializer/GalleryWidgetMigrator;-migrateGalleryWidgets-(Landroid/content/Context;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/AccountManager;-updateCredentials-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-updateUIForCurrentPhoto-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/RIL;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/time/AmPmCirclesView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MediaPickerActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService;-canAutoSync-(Lcom/android/emailcommon/provider/Account;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$AccessibilityContentObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/SyncAdapterDriver;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/printspooler/SelectPrinterActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AddBookmarkPage;-completeOrCancelFolderNaming-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/service/LegacyEmailAuthenticatorService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/PhotoPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ISms$Stub;-enableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/base/InputStreamSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub$Proxy;-loadAttachmentStatus-(J J I I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipAudioCallAdapter;-onCallEnded-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaScanner$MyMediaScannerClient;-endFile-(Landroid/media/MediaScanner$FileEntry; Z Z Z Z Z)Landroid/net/Uri;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothInputDevice;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/InputMethodManagerService;-resetSelectedInputMethodAndSubtypeLocked-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService$BootCompletedReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/documentsui/DirectoryContainerView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ScrollView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/EmlTempFileDeletionService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/SearchView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/TimeIntervalPopup$Listener;-onListPrefChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/ui/PhotoView;-snapToNeighborImage-()Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery;-startQuery-(I Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/CallerInfoAsyncQuery$OnQueryCompleteListener; Ljava/lang/Object;)Lcom/android/internal/telephony/CallerInfoAsyncQuery;' : ['android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/os/Vibrator;-vibrate-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE'],
	'Landroid/provider/ContactsContract$Groups$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calendar/month/MonthByWeekFragment$3;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterfw/core/Filter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/WiredAccessoryManager$WiredAccessoryObserver;-updateStateLocked-(Ljava/lang/String; Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewRootImpl$EarlyPostImeInputStage;-processKeyEvent-(Landroid/view/ViewRootImpl$QueuedInputEvent;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/EmptyConversationListView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/SlideshowPage$SequentialSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/PhotoPage$9;-onConfirmDialogDismissed-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-shutdown-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/power/ShutdownThread$5;-run-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-hangupWaitingOrBackground-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-access$700-(Lcom/android/calendar/AllInOneActivity; J)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-setCdmaBroadcastConfig-([Lcom/android/internal/telephony/cdma/CdmaSmsBroadcastConfigInfo;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-requestBatchedScan-(Landroid/net/wifi/BatchedScanSettings; Landroid/os/IBinder; Landroid/os/WorkSource;)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/IBluetoothGattCallback$Stub$Proxy;-onClientRegistered-(I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-restartRadio-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/widget/DialerFilter;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$UntetheringState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/DataController$DataControllerHandler;-doUpdateVisitedHistory-(Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperPreview;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/SmsApplication;-getDefaultSmsApplication-(Landroid/content/Context; Z)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cat/IconLoader;-readClut-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/DataManager;-getContentUri-(Lcom/android/gallery3d/data/Path;)Landroid/net/Uri;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub$Proxy;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/FolderSpanTextView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-addSubtypeToHistory-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/Wallpaper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/documentsui/DirectoryContainerView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/CandidatesContainer;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/view/PieMenu;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE', 'com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-getRemoteName-(Landroid/bluetooth/BluetoothDevice;)Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/provider/Browser;-deleteFromHistory-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/IContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/Application;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-processKeyPressed-()V' : ['android.permission.READ_CALL_LOG'],
	'Lcom/android/gallery3d/app/AlbumPage;-onUpPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/tts/TextToSpeech$2;-run-(Landroid/speech/tts/ITextToSpeechService;)Ljava/lang/Integer;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/view/PieMenu;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipAudioCall$1;-onCallBusy-(Landroid/net/sip/SipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/AlertController$RecycleListView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/AllInOneActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/provider/CalendarContract$EventsEntity$EntityIteratorImpl;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/wifi/WifiService;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/support/v4/view/PagerTitleStrip;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pPersistentGroupsChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/service/AbstractSyncAdapterService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-checkIfSubtypeBelongsToImeAndEnabled-(Landroid/view/inputmethod/InputMethodInfo; Landroid/view/inputmethod/InputMethodSubtype;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/CameraPreference$OnPreferenceChangedListener;-onSharedPreferenceChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-<init>-(Ljava/lang/String; Landroid/content/Context; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/CellBroadcastHandler;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/AnimatedAdapter;-fadeOutSpecificLeaveBehindItem-(J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-albumShouldOpenInFilmstrip-(Lcom/android/gallery3d/data/MediaSet;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/media/AsyncPlayer;-play-(Landroid/content/Context; Landroid/net/Uri; Z I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/settings/DebugSettingsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Tab$3;-onRequestFocus-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/provider/Settings$System;-getIntForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$5;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapObexServer;-<init>-(Landroid/os/Handler; Landroid/content/Context;)V' : ['android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/CacheAbuser;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine;-access$7900-(Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/documentsui/TestActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/OnePaneController;-transitionToInbox-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityManagerService;-inputDispatchingTimedOut-(I Z Ljava/lang/String;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/AbstractActivityController;-updateAccounts-(Lcom/android/mail/content/ObjectCursor;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/Chronometer;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onCallEnded-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/TrimVideo$2;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/SpeechRecognizer;-access$000-(Landroid/speech/SpeechRecognizer; Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/mail/ui/ConversationsInOutboxTipView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/ContactsContract$SyncState;-newSetOperation-(Landroid/accounts/Account; [B)Landroid/content/ContentProviderOperation;' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/EventInfoFragment;-saveReminders-()Z' : ['android.permission.WRITE_CALENDAR'],
	'Landroid/net/wifi/IWifiManager;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/app/ExpandableListActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/fall/FallWallpaper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/ConversationContainer;-onLayout-(Z I I I I)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onActionBarWanted-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/util/StateMachine$SmHandler$QuittingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothInputDevice;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/camera/ui/TwoStateImageView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IMagnificationCallbacks$Stub$Proxy;-onUserContextChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/nexus/NexusWallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/preference/PreferenceActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/ActionBarView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LockSettingsService;-setLockPassword-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-registerServer-(Landroid/os/ParcelUuid; Landroid/bluetooth/IBluetoothGattServerCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/photo/MailPhotoViewActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextClock;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationPager;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasAccountService;-sync-(Lcom/android/exchange/adapter/AbstractSyncAdapter;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/power/PowerManagerService;-handleBatteryStateChangedLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/CalculatorEditText;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calculator2/CalculatorViewPager;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-requestSingleUpdate-(Ljava/lang/String; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/datetimepicker/time/TimePickerDialog$2;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/mail/ui/OnePaneController;-access$2600-(Lcom/android/mail/ui/AbstractActivityController; Lcom/android/mail/providers/Conversation;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/internal/ScrollKeyboardView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/ActivityManagerNative;-getTasks-(I I Landroid/app/IThumbnailReceiver;)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-switchUser-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/RetargetFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/ObjectSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavScreen;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperChange;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/GlobalActions$SinglePressAction;-onLongPress-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TwilightService;-systemReady-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/musicvis/vis2/Visualization2;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameFetch;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ToRGBAFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/ComboViewActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/NavigationBarPhone;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/ContextThemeWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractActivityController;-onConversationVisibilityChanged-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/InputView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageAttachmentTile;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/StickyHeaderListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/IBackupManager$Stub;-opComplete-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/PowerManager$WakeLock;-acquire-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractEditLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/UninstallerActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-initiateInstall-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/HorizontalScrollView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/Device;-getConsistentDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/backup/FullBackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/PointerLocation;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/ui/SearchActivityViewSinglePane;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHeadset;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/location/GpsLocationProvider;-disable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/TransitionsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothMap;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/Browser;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowManager;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/gallery3d/app/GalleryActivity;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertActivity$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mail/ui/OnePaneController;-assignFolder-(Ljava/util/Collection; Ljava/util/Collection; Z Z Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager;-getAccounts-()[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/support/v4/content/CursorLoader;-onLoadInBackground-()Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Landroid/content/IContentService$Stub;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/ConversationViewHeader;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/SecureCameraActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/agenda/AgendaAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/accessibilityservice/AccessibilityService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/musicvis/vis1/Visualization1;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/view/ViewPager;-populate-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/support/v4/app/FragmentTabHost;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-editProperties-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Z)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/browser/Preloader;-cancelSearchBoxPreload-(Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/ui/SurfaceRenderFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/preference/PreferenceActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/dreams/phototable/FlipperDreamSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-updatePersistentNetworks-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/DuotoneEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/provider/Contacts$People;-markAsContacted-(Landroid/content/ContentResolver; J)V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/ex/photo/PhotoViewPager;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/dreams/phototable/PhotoSource;-naturalPrevious-(Landroid/graphics/Bitmap; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/eas/EasFolderSync;-makeRequest-()Lorg/apache/http/client/methods/HttpUriRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/pinyin/SoftKeyboardView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/Controller;-closeCurrentTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/sip/SipManager;-register-(Landroid/net/sip/SipProfile; I Landroid/net/sip/SipRegistrationListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/mail/SenderInfoLoader;-loadInBackground-()Lcom/google/common/collect/ImmutableMap;' : ['android.permission.READ_CONTACTS'],
	'Landroid/widget/CheckedTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/MultiStateButton;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeManual-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/pm/IPackageManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MusicUtils;-addToCurrentPlaylist-(Landroid/content/Context; [J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorSaturationView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/BaseSuggestionView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationListFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-closeService-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TextToSpeech;-runAction-(Landroid/speech/tts/TextToSpeech$Action; Ljava/lang/Object; Ljava/lang/String; Z Z)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/UrlInputView$UrlInputListener;-onAction-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserActivity;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email2/ui/MailboxSelectionActivityEmail;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/DontPressWithParentLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService$MyExecutor;-executeInternal-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/BondStateMachine;-createBond-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/photos/GalleryActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-updatePhoneObject-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-applyNewState-(Lcom/android/internal/telephony/dataconnection/ApnContext; Z Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/SearchActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/DeleteItems;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifyServiceState-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/Ringtone;-play-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/research/FeedbackActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/hardware/location/IGeofenceHardware$Stub$Proxy;-addCircularFence-(I I D D D I I I I Landroid/hardware/location/IGeofenceHardwareCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/LeaveBehindItem;-dismiss-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/view/IInputMethodManager$Stub;-getShortcutInputMethodsAndSubtypes-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasProvision;-sendMessage-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/EmailContent$Message;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/alarmclock/DigitalWidgetViewsFactory$RemoteWorldClockAdapter;-updateView-(Landroid/view/View; Lcom/android/deskclock/worldclock/CityObj;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/AdnRecordLoader;-loadAllFromEF-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/widget/EllipsizeLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/PrintJob;-isCancelled-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/RestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/RestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/hardware/IConsumerIrService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.TRANSMIT_IR'],
	'Landroid/filterpacks/base/OutputStreamTarget;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/development/BadBehaviorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/VerticalTextSpinner;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/recurrencepicker/LinearLayoutWithMaxWidth;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-supplyIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDevice;-cancelBondProcess-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/magicsmoke/MagicSmoke;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/StackView;-performItemClick-(Landroid/view/View; I J)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/AlertAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/widget/NumberPicker;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/BackupAgent;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-writeDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-dispatchPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/Clustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/AppHwConfigList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/ObjectSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/NumberPicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncAdapter;-<init>-(Landroid/content/Context; Landroid/database/Cursor; Landroid/app/FragmentManager;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-startLongPressTimer-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/mail/ui/TwoPaneController;-onConversationVisibilityChanged-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/power/ShutdownThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/ActivityManagerService;-backgroundServicesFinishedLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/event/EditEventActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/Pop3AuthenticatorService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/spellcheck/SpellCheckerSettingsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/PreloadRequestReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendPhonebookOneVcard-(Ljavax/obex/Operation; I Z Ljava/lang/String; I)I' : ['android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/videoeditor/VideoEditorActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/providers/telephony/SmsProvider;-insertInner-(Landroid/net/Uri; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/SpellChecker;-resetSession-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/InitAlarmsService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/widget/TextTime;-setFormat12Hour-(Ljava/lang/CharSequence;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/polarclock/PolarClockSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/dreams/phototable/LocalSource;-next-(Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestCursor;-runQuery-(Ljava/lang/CharSequence;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/EventLoader;-startBackgroundThread-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-access$1500-(Lcom/android/gallery3d/ingest/IngestActivity;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/DayView;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/inputmethod/latin/BackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/BatteryStatsImpl;-writeToParcelWithoutUids-(Landroid/os/Parcel; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/MovieControllerOverlay;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/LegacyImapSyncAdapterService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/CheckedLinearLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/gsm/SmsManager;-copyMessageToSim-([B [B I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-addToBlacklist-(Ljava/lang/String;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/app/ResolverActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/updates/IntentFirewallInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/ColorButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/EmailSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityStackSupervisor;-scheduleSleepTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/TestActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/ConversationViewFragment$MailJsBridge$1;-go-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/UiModeManagerService;-access$500-(Lcom/android/server/UiModeManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/ColorTemperatureEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager$CdmaBroadcastRangeManager;-updateRanges-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/TextureView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accounts/AccountManagerService;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/gatt/GattService;-unregisterClient-(I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-access$400-(Lcom/android/gallery3d/data/LocalAlbumSet; Lcom/android/gallery3d/data/DataManager; I Lcom/android/gallery3d/data/Path; I Ljava/lang/String;)Lcom/android/gallery3d/data/MediaSet;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/GpsLocationProvider;-updateNetworkState-(I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/EmlViewerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/emailcommon/provider/Mailbox;-resyncMailbox-(Landroid/content/ContentResolver; Landroid/accounts/Account; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/media/effect/effects/SepiaEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/setup/SetupActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-access$1800-(Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/AlbumBrowserActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BrowserSettings;-onSharedPreferenceChanged-(Landroid/content/SharedPreferences; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/TintFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService$5;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.REORDER_TASKS', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.BROADCAST_STICKY', 'android.permission.GET_TASKS', 'android.permission.WRITE_SETTINGS', 'android.permission.RESTART_PACKAGES', 'android.permission.READ_PROFILE'],
	'Landroid/media/effect/effects/DuotoneEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder;-access$100-(Lcom/android/soundrecorder/SoundRecorder;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EasAuthenticatorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/GeolocationPermissionsPrompt;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/UploaderService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/IntentService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/search/SearchManagerService$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationListFragment;-commitDestructiveActions-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-getWifiStateMachineMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/widget/AutoScrollHelper;-cancelTargetTouch-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/Calculator;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/AbsActionBarView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calculator2/ColorButton;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/TintFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/contacts/ContactsListActivity;-getContactUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-setKeyboard-(Lcom/android/inputmethod/keyboard/Keyboard;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-removeService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ui/CameraRootView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/CalendarContract$EventDays;-query-(Landroid/content/ContentResolver; I I [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/InputMethodManagerService;-resetStateIfCurrentLocaleChangedLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService;-doStop-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/browser/DataController;-getInstance-(Landroid/content/Context;)Lcom/android/browser/DataController;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mail/providers/DrawerClosedObserver;-onDrawerClosed-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-onRefresh-(Z [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/DeleteEventHelper;-access$900-(Lcom/android/calendar/DeleteEventHelper;)V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/text/format/DateUtils;-getRelativeDateTimeString-(Landroid/content/Context; J J J I)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-upgradeLegacyBackgroundData-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-requestUpdatingShiftState-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/alerts/DismissAlarmsService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupAgentHelper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onDataSetupCompleteError-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/polarclock/PolarClockWallpaper$ClockEngine;-doVisibilityChanged-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/gallery3d/filtershow/category/CategorySelected;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/provider/EmailProvider;-restartPushForAccount-(Landroid/content/Context; Landroid/database/sqlite/SQLiteDatabase; Landroid/content/ContentValues; Ljava/lang/String;)Z' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-access$000-(Lcom/android/internal/telephony/RIL; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/content/SyncManager;-doDatabaseCleanup-()V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-access$100-(Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-onFinishInput-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-setPostDialState-(Lcom/android/internal/telephony/Connection$PostDialState;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ContactsBinaryDictionary;-loadDictionaryAsyncForUri-(Landroid/net/Uri;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/policy/impl/PhoneWindow$DecorView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/DownloadCache$DownloadTask;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/imageproc/GrainFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$GroupCreatedState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/ConversationPager;-onMeasure-(I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/Invert;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationSyncDisabledTipView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/CertBlacklister$BlacklistObserver;-getValue-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/widgets/OverlayView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Application;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/InputMethodManagerService;-getShortcutInputMethodsAndSubtypes-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/TrimControllerOverlay;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/galaxy/GalaxyWallpaper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractActivityController;-markConversationsRead-(Ljava/util/Collection; Z Z Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateShare-(Landroid/database/Cursor; I Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Landroid/speech/RecognitionService;-access$700-(Landroid/speech/RecognitionService; Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Landroid/support/v4/app/NoSaveStateFrameLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ShortcutNameActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/photos/views/HeaderGridView$FullWidthFixedViewLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-isAllowedByCurrentUserSettingsLocked-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationListView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-onSubtypeChanged-(Landroid/view/inputmethod/InputMethodSubtype;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/google/GoogleSearch;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/view/CertificateSelector;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth$Stub;-connectSocket-(Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/SettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/QueryBrowserActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService$1;-onProximityNegative-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/widget/CompoundButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BaseUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream; Lcom/android/vcard/VCardInterpreter;)V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/magicsmoke/MagicSmoke;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasAccountService;-acknowledgeProvisionImpl-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoPage;-showBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-stopObexServerSession-()V' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/BlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Application;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine;-handleSupplicantConnectionLoss-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetConfigure;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-setNetworkPreference-(I)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getProvisioningOrActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wifi/WifiService;-addOrUpdateNetwork-(Landroid/net/wifi/WifiConfiguration;)I' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mail/browse/MailWebView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/editstyledtext/EditStyledText;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/CalculatorViewPager;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/data/TagClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$20;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/photos/GalleryActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/CheckBox;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/printspooler/SelectPrinterFragment;-updateAddPrintersAdapter-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/PolicyServiceProxy;-setAccountHoldFlag-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/SearchActivity$1;-onChange-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/photos/AlbumFragment;-deleteItemWithPath-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/TabControl;-removeTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/deskclock/widget/EllipsizeLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationPager;-dataSetChanged-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompat;-performAction-(I I Landroid/os/Bundle;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/widget/VideoView;-setVideoURI-(Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/RecognitionService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/MediaSource;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/ActionableToastBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CommandsInterface;-getPreferredVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/IccRecords;-setMsisdnNumber-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/NotificationActionIntentService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/SyncRunner;-performStep-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/widget/FaceUnlockView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/Controller;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/accounts/IAccountManager$Stub;-updateCredentials-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/server/power/Notifier;-onGoToSleepFinished-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/commands/bmgr/Bmgr;-doWipe-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-hangupAndPowerOff-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperChange;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/TestActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/accessibility/TouchExplorer;-handleMotionEventStateDragging-(Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Switch;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/PolicyServiceProxy;-<init>-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/uicc/AdnRecordLoader;-loadFromEF-(I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/mail/store/ServiceStore;-autoDiscover-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/videoeditor/widgets/HorizontalScrollView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/pacprocessor/PacService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/print/UserState;-readConfigurationLocked-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/FieldPort;-setFieldFrame-(Landroid/filterfw/core/Frame; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/widget/BookmarkWidgetConfigure;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/VideoMenu;-onSettingChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowManager$Stub$Proxy;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/filterpacks/base/CallbackFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler$DefaultState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/soundrecorder/Recorder;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/IIntentReceiver;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/ConnectivityService$CheckMp;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/NavTabScroller$ContentLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/CreateShortcutActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/ConversationItemView;-beginDragMode-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/dreams/phototable/PicasaSource;-naturalPrevious-(Landroid/graphics/Bitmap; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/eas/EasPing;-requestSyncForSyncList-(Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/development/UnderdevelopedSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/photos/views/SquareImageView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/NullFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/CameraSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/bluetooth/IBluetooth$Stub;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/TwoPaneController;-markConversationsRead-(Ljava/util/Collection; Z Z Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/service/CalendarSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Landroid/net/wifi/WifiManager;-isWifiApEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/CalendarViewAdapter;-buildWeekDate-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/LocationBlacklist;-reloadBlacklistLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-installSystemProviders-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/ImapService;-processUploadMessage-(Landroid/content/Context; Lcom/android/email/mail/Store; Lcom/android/emailcommon/provider/Mailbox; J)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager;-getLinkQualityInfo-(I)Landroid/net/LinkQualityInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/PackageBrowser;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextSwitcher;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/PhotoPage;-setCurrentPhotoByIntent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowManager;-reenableKeyguard-(Landroid/os/IBinder;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/exchange/ExchangeService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/PhotoPage;-toggleBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/ListMenuItemView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$3200-(Lcom/android/gallery3d/ui/PhotoView; I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub;-getNetworkPreference-()I' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/content/SyncActivityTooManyDeletes;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/LegacyEmailAuthenticatorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/SearchMailActionBarView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/research/Uploader;-uploadFile-(Ljava/io/File;)V' : ['android.permission.INTERNET'],
	'Lcom/android/exchange/eas/EasPing;-addDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/alerts/AlarmScheduler;-queryNextReminderAndSchedule-(Landroid/database/Cursor; Landroid/content/Context; Landroid/content/ContentResolver; Lcom/android/calendar/alerts/AlarmManagerInterface; I J)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/provider/Telephony$Sms;-getDefaultSmsPackage-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/QuickContactBadge;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/MediaItemView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/alarms/AlarmActivity$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/BalloonHint$BalloonView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/internal/ScrollKeyboardView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavigationBarTablet;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventFragment;-onDestroy-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/deskclock/alarms/AlarmActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine$DriverStoppedState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/deskclock/timer/TimerFragment;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/time/RadialTextsView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/CaptivePortalTracker;-lookupHost-(Ljava/lang/String;)Ljava/net/InetAddress;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/LinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-removeItem-(I)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/mail/ui/ConversationViewFragment;-markUnread-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/location/GeofenceManager;-sendIntent-(Landroid/app/PendingIntent; Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-onDownEventInternal-(I I J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/ex/photo/PhotoViewPager;-endFakeDrag-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/spellcheck/AndroidSpellCheckerService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService$DragInputEventReceiver;-onInputEvent-(Landroid/view/InputEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/SpeechRecognizer;-handleStartListening-(Landroid/content/Intent;)V' : ['android.permission.RECORD_AUDIO'],
	'Landroid/net/INetworkStatsService$Stub;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/VideoModule;-onResumeAfterSuper-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-initSocket-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/StateManager;-restoreFromState-(Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/LatinIME;-handleSeparator-(I I I I)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/preference/VolumePreference$SeekBarVolumizer;-<init>-(Landroid/preference/VolumePreference; Landroid/content/Context; Landroid/widget/SeekBar; I Landroid/net/Uri;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/view/ViewRootImpl$ViewPostImeInputStage;-processKeyEvent-(Landroid/view/ViewRootImpl$QueuedInputEvent;)I' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Landroid/widget/AbsSpinner;-performItemClick-(Landroid/view/View; I J)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/ime/Ime;-run-([Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/pan/PanService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/PointerLocationView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/UiModeManagerService;-updateLocked-(I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmCellBroadcastHandler;-<init>-(Ljava/lang/String; Landroid/content/Context; Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/documentsui/SettingsActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/OverlayTitleEditor;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertService;-generateAlerts-(Landroid/content/Context; Lcom/android/calendar/alerts/NotificationMgr; Lcom/android/calendar/alerts/AlarmManagerInterface; Landroid/content/SharedPreferences; Landroid/database/Cursor; J I)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-serverDisconnect-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/NavigationBarPhone;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/AccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Z Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/app/ActivityManager;-getRecentTasksForUser-(I I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/os/IPowerManager;-updateWakeLockWorkSource-(Landroid/os/IBinder; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllNetworkState-()[Landroid/net/NetworkState;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-doStart-(Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/service/EasService$1;-pushModify-(J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/pinyin/ComposingView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/Notifier$1;-onScreenOn-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/widget/CheckBox;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/EasAutoDiscover;-makeUriString-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/documentsui/DirectoryView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/AccountCheckSettingsFragment$AccountCheckTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/server/LockSettingsService;-checkPassword-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForWatchdogToggle-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ActivityManagerNative;-setProcessLimit-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/ILocationManager$Stub$Proxy;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/view/menu/ListMenuItemView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/tts/compat/CompatTtsService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/AlertService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/ex/photo/views/PhotoView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/LogViewer;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSecurity$SecurityNeededDialog;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/research/Uploader;-doUpload-()V' : ['android.permission.INTERNET'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendThisDeviceChangedBroadcast-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/DeskClock;-registerPageChangedListener-(Lcom/android/deskclock/DeskClockFragment;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioManager;-startBluetoothSco-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/performance/ThroughputFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncFragment;-onPause-()V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readPbrFileAndWait-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$4;-onItemLongClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mail/browse/SelectedConversationsActionMenu;-onDestroyActionMode-(Landroid/view/ActionMode;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/http/RequestQueue$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/KeyguardManager;-exitKeyguardSecurely-(Landroid/app/KeyguardManager$OnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Lcom/android/internal/telephony/PhoneNotifier; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/internal/telephony/RIL;-changeIccPin-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-readRemoteRssi-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/view/StopProgressView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ILockSettings;-getString-(Ljava/lang/String; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCellInfoListRate-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/wm/WindowManagerService;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/net/wifi/IWifiManager$Stub;-getWifiApConfiguration-()Landroid/net/wifi/WifiConfiguration;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/widget/RemoteViewsAdapter$RemoteViewsFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPairingConfirmation-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/providers/downloads/ui/DownloadItem;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/provision/DefaultActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/Wallpaper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActiveServices;-realStartServiceLocked-(Lcom/android/server/am/ServiceRecord; Lcom/android/server/am/ProcessRecord; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onHandleForceStop-(Landroid/content/Intent; [Ljava/lang/String; I Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/camera/ui/TwoStateImageView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ActivityGroup;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaCall;-hangupIfAlive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/InputMethodManagerService$InputMethodAndSubtypeListManager;-getNextInputMethod-(Z Landroid/view/inputmethod/InputMethodInfo; Landroid/view/inputmethod/InputMethodSubtype;)Lcom/android/server/InputMethodManagerService$ImeSubtypeListItem;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/SwipeableListView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-addCharacteristic-(I Landroid/os/ParcelUuid; I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/eas/EasLoadAttachment;-getRequestUri-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/content/IContentService$Stub;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StartTetheringErrorState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mail/browse/FolderSpanTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/svox/pico/EngineSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/PhotoPage;-switchToGrid-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/ReceiverRestrictedContext;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/view/StopProgressView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/AccountSecurity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/AuthenticatorService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$4800-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/view/BookmarkContainer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary$12;-run-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/LegacyImapSyncAdapterService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-matchRecipientMms-(Landroid/database/Cursor; Lcom/android/bluetooth/map/BluetoothMapContent$FilterInfo; Ljava/lang/String;)Z' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-markMessagesAsRead-(Ljava/util/ArrayList;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calculator2/CalculatorViewPager;-dataSetChanged-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/SlideshowPage$ShuffleSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/compose/ComposeActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/chips/RecipientEditTextView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/IWindowSession$Stub$Proxy;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/content/ContentService;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationUpdater;-starMessage-(Lcom/android/mail/browse/ConversationMessage; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/wallpaper/grass/GrassWallpaper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/BummerView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/service/EmailSyncAdapterService$SyncAdapterImpl;-syncMailbox-(Landroid/content/Context; Landroid/content/ContentResolver; Landroid/accounts/Account; Lcom/android/emailcommon/provider/Account; J Landroid/os/Bundle; Landroid/content/SyncResult; Ljava/util/HashSet; Z)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/InputMethodService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/NavScreen;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService$MyExecutor;-execute-(Ljava/lang/Runnable;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/RenderScriptScene;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calculator2/CalculatorDisplay;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getNetworkInfo-(I)Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mail/browse/ConversationViewHeader;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/VignetteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorBrightnessView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasAccountService;-sync-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-getPersistedDeviceName-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/ui/SearchActivityView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothPbap;-disconnect-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/ShutdownActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/PreparePageFadeoutTexture;-onGLIdle-(Lcom/android/gallery3d/glrenderer/GLCanvas; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/alerts/AlertActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/input/InputManagerService;-registerPointerSpeedSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/AdnRecordCache;-updateAdnBySearch-(I Lcom/android/internal/telephony/uicc/AdnRecord; Lcom/android/internal/telephony/uicc/AdnRecord; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/EasMeetingResponder;-makeUriString-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/updates/ConfigUpdateInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/SimpleWeeksAdapter;-updateParams-(Ljava/util/HashMap;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mail/MailIntentService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/ConfigurationViewer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/month/MonthListView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mail/ui/SwipeHelper$Callback;-onScroll-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/development/CacheAbuser;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumPage;-onCreate-(Landroid/os/Bundle; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/OnePaneController;-access$300-(Lcom/android/mail/ui/AbstractActivityController; Lcom/android/mail/providers/Conversation; Ljava/util/Set; [B)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/ExchangeService;-startManualSync-(J I Lcom/android/emailsync/Request;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipManager;-makeAudioCall-(Ljava/lang/String; Ljava/lang/String; Landroid/net/sip/SipAudioCall$Listener; I)Landroid/net/sip/SipAudioCall;' : ['android.permission.USE_SIP'],
	'Landroid/widget/TextClock;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/SearchView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/HandleApiCalls;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/IMediaPlaybackService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/RecentApplicationsBackground;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/DayView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/mail/ui/AbstractActivityController$5;-onLoadFinished-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/UrlInputView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-addAccount-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/VideoView;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/SimpleWeekView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/VibratorService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/printspooler/PrintDialogFrame;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipManager;-createSipSession-(Landroid/net/sip/SipProfile; Landroid/net/sip/SipSession$Listener;)Landroid/net/sip/SipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/policy/impl/RecentApplicationsDialog;-reloadButtons-()V' : ['android.permission.GET_TASKS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneFallbackEventHandler;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/LocationManagerService;-access$700-(Lcom/android/server/LocationManagerService; Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/support/v4/net/ConnectivityManagerCompatHoneycombMR2;-isActiveNetworkMetered-(Landroid/net/ConnectivityManager;)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-toggleBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/map/BluetoothMapService$BluetoothMapBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/videoeditor/widgets/PlayheadView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub;-setNetworkPolicies-([Landroid/net/NetworkPolicy;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/ui/CountDownView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/VpnService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/telephony/SmsManager;-getAllMessagesFromIcc-()Ljava/util/ArrayList;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/content/ISyncAdapter$Stub;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothManager;-disable-(Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/content/IContentService$Stub$Proxy;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/SelectedConversationsActionMenu$1;-onChanged-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/documentsui/SettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/event/AttendeesView$PresenceQueryHandler$1;-run-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/StatusBarManagerService;-expandSettingsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/data/SecureSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-performActionForKey-(Lcom/android/inputmethod/keyboard/Key; I Landroid/os/Bundle;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/telephony/TelephonyManager;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/preference/YesNoPreference;-onDialogClosed-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/datetimepicker/time/RadialSelectorView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AbstractCalendarActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email2/ui/CreateShortcutActivityEmail;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-access$200-(Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/Exchange;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/display/WifiDisplayController;-<init>-(Landroid/content/Context; Landroid/os/Handler; Lcom/android/server/display/WifiDisplayController$Listener;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoingFragment;-setCallback-(Lcom/android/email/activity/setup/AccountServerBaseFragment$Callback;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TtsEngines;-updateLocalePrefForEngine-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/internal/PointerTrackerQueue$Element;-onPhantomUpEvent-(J)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/inputmethodservice/InputMethodService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IContentService$Stub$Proxy;-sync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager$Stub;-getMobileProvisioningUrl-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-pollBatchedScan-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/SuggestionsAdapter;-onClick-(Landroid/view/View;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/media/WebVttRenderingWidget$CueLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/ui/SearchActivityView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine;-startBatchedScan-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/AuthenticatorService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/printservice/PrintService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/ITextToSpeechService;-synthesizeToFileDescriptor-(Landroid/os/IBinder; Ljava/lang/String; Landroid/os/ParcelFileDescriptor; Landroid/os/Bundle;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/AbstractActivityController;-perhapsEnterWaitMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/googlecode/mp4parser/authoring/adaptivestreaming/FlatPackageWriterImpl;-write-(Lcom/googlecode/mp4parser/authoring/Movie;)V' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/ui/DetailsHelper$DetailsViewContainer;-show-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-processMotionEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/exchange/adapter/CalendarSyncParser$CalendarOperations;-updatedExtendedProperty-(Ljava/lang/String; Ljava/lang/String; J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/FilmstripPage;-toggleBars-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/OnePaneController;-handleBackPress-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/widgets/EditorRelativeLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Ljava/net/Socket;-<init>-(I)V' : ['android.permission.INTERNET'],
	'Lcom/android/emailsync/SyncManager;-stopServiceThreads-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/SupplicantStateTracker;-access$200-(Landroid/net/wifi/SupplicantStateTracker; Landroid/net/wifi/SupplicantState; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/agenda/AgendaListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/galaxy/GalaxyWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/SpeechRecognizer;-cancel-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/calendar/alerts/GlobalDismissManager;-dismissGlobally-(Landroid/content/Context; Ljava/util/List;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/email/EmailIntentService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperChange;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/pinyin/CandidatesContainer;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/AccessibleLinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ContentListener;-onContentDirty-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/worldclock/CitiesActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-startRefresh-()V' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/data/SecureAlbum;-getMediaItem-(I I)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/ConversationPhotoTeaserView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/widgets/TimelineRelativeLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/EasTestAuthenticatorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine$Pending;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/search/SearchManagerService$MyPackageMonitor;-onPackageAppeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasAccountService;-executePostWithTimeout-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; I Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/SearchActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-access$300-(Lcom/android/internal/widget/multiwaveview/GlowPadView; I F F)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AlarmTimelineView;-init-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/DebugFragment;-onCheckedChanged-(Landroid/widget/CompoundButton; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/provider/CalendarContract$Instances;-query-(Landroid/content/ContentResolver; [Ljava/lang/String; J J)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Landroid/app/ListActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/TextureView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/IccFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getDisabledSystemInputMethods-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/RelativeLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/GrantActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService$SettingsObserver;-<init>-(Landroid/media/AudioService;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/mail/browse/ConversationViewAdapter$MessageHeaderItem;-bindView-(Landroid/view/View; Z)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/development/AppHwConfigList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-validate-(Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/widget/Switch;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/alarms/AlarmKlaxon$1;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-beginLayoutLw-(Z I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/menu/IconMenuView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/IConnectivityManager;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterfw/core/Filter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationViewFragment;-onSuperCollapsedClick-(Lcom/android/mail/browse/ConversationViewAdapter$SuperCollapsedBlockItem;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-handleTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/IntRangeManager;-enableRange-(I I Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothPan;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-access$2400-(Lcom/android/gallery3d/app/PhotoPage; Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-hasFeatures-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; [Ljava/lang/String;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/videoeditor/KenBurnsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/widget/Button;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/ImapService$1;-loadAttachment-(Lcom/android/emailcommon/service/IEmailServiceCallback; J J Z)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.INTERNET', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/printspooler/FusedPrintersProvider;-onStopLoading-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/SuggestionsAdapter$SuggestFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.ACCESS_NETWORK_STATE', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/widget/LockPatternUtils;-saveLockPassword-(Ljava/lang/String; I Z I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/google/SearchBaseUrlHelper$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/MovieActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/PowerManager$WakeLock;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/OnePaneController;-onFolderSelected-(Lcom/android/mail/providers/Folder;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/Phone;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-switchToState-(I F F)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-onBootCompleted-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_CALENDAR', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/telephony/CommandsInterface;-getMute-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hid/HidService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/AnimatedListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.INTERNET'],
	'Landroid/net/CaptivePortalTracker;-isCaptivePortal-(Ljava/net/InetAddress;)Z' : ['android.permission.INTERNET', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onProgressComplete-(I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/ConnectivityManager;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/google/common/io/Resources;-toString-(Ljava/net/URL; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AutologinBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/EmojiPalettesView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/basic/Colors;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-getDataRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/server/BluetoothA2dpService;-onBluetoothEnable-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mail/ui/ViewMode;-enterConversationMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-<init>-(Lcom/android/music/MediaPlaybackService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/TimerSetupView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/SyncAdapterDriver;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/GLView$OnClickListener;-onClick-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-setupDataOnConnectableApns-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService$2;-disconnect-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/service/EasService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/WebViewController;-onProgressChanged-(Lcom/android/browser/Tab;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-setViewStates-(I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/data/ChangeNotifier;-onChange-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onResume-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/service/EasService$1;-searchMessages-(J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/MediaSet;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/mail/browse/BorderView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/ExchangeService;-runAccountReconcilerSync-(Landroid/content/Context;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/ui/ConversationLongPressTipView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/grass/GrassWallpaper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoPage;-transitionFromAlbumPageIfNeeded-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/text/StringSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-update-(Lcom/android/internal/telephony/DriverCall;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/HistoryItem;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothDevice;-getAliasName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readIapFileAndWait-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/setup/LauncherIconVisibilityManager;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/server/content/SyncManager$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/location/LocationManager;-getLastLocation-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/ScreensaverActivity;-onConfigurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/BaseSuggestionView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/TrackBrowserActivity$5;-remove-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-setAlphabetAutomaticShiftedKeyboard-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-processResponse-(Landroid/os/Parcel;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/OnePaneController;-onConversationVisibilityChanged-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/service/EasAutoDiscover;-sendHttpClientPost-(Ljava/lang/String; [B)Lcom/android/exchange/EasResponse;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLRootView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Disconnected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/FilterTypeSet;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/AccountsTester$ButtonClickListener;-onClick-(Landroid/view/View;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mail/ui/AbstractActivityController$7;-onLoadFinished-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/TwoLineListItem;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/timer/TimerAlertFullScreen;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-restartRadio-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/polarclock/PolarClockSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ingest/ui/MtpThumbnailTileView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BreadCrumbView;-pop-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/videoeditor/OverlayTitleTemplatePicker;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/GridLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/Connectivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-getCurrentInputMethodSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)Landroid/view/inputmethod/InputMethodSubtype;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$4200-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-queryExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mail/ui/AttachmentBitmapHolder;-thumbnailLoadFailed-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/ActivityStackSupervisor;-scheduleIdleTimeoutLocked-(Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/ActivityStackSupervisor$ActivityStackSupervisorHandler;-activityIdleInternal-(Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-disconnectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/DialogTitle;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/SecureCameraActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/ex/photo/PhotoViewPager;-addNewItem-(I I)Landroid/support/v4/view/ViewPager$ItemInfo;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/WebVttRenderingWidget$CueLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/map/BluetoothMnsObexClient;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothDevice; Landroid/os/Handler;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/widget/CalendarAppWidgetModel;-buildFromCursor-(Landroid/database/Cursor; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/ChooseAccountTypeActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/Details;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/AdnRecordCache;-requestLoadAllAdnLike-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHeadset;-isDisabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothDevice;-getBondState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hdp/HealthService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/Exchange;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/google/common/io/Files;-toString-(Ljava/io/File; Ljava/nio/charset/Charset;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/camera/ui/RotateImageView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/CantAddAccountActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/IBackupManager;-clearBackupData-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/LockPatternUtils;-checkPasswordHistory-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/MediaSetSource$CheckedMediaSetSource;-onContentDirty-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory$2;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/LocationManagerService;-systemRunning-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-restorePmMetadata-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/am/BroadcastQueue;-broadcastTimeoutLocked-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/music/VerticalTextSpinner;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/RemoteViewsAdapter$RemoteViewsFrameLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/IRecognitionService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/camera/ui/TimeIntervalPopup$2;-onClick-(Landroid/view/View;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/google/AbstractGoogleSource;-queryInternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/timer/TimerView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/ComposingView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/musicvis/vis5/Visualization5;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-changeIccPinForApp-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity$3;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-conference-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onFilmModeChanged-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/accounts/ChooseAccountTypeActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmClockFragment$9;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/OnePaneController;-setAccount-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordFragment;-onResume-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/Controller;-start-(Landroid/content/Intent;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/CommandsInterface;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/SizeChangeEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothManager$Stub$Proxy;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/base/CallbackFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendMotionEvent-(Landroid/view/MotionEvent; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-killAppAtUsersRequest-(Lcom/android/server/am/ProcessRecord; Landroid/app/Dialog;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/provider/Settings$System;-getIntForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I I)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/BluetoothManagerService;-canUnbindBluetoothService-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/btservice/RemoteDevices;-pinRequestCallback-([B [B I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/month/MonthListView;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getBondedDevices-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/INetworkPolicyManager;-getNetworkQuotaInfo-(Landroid/net/NetworkState;)Landroid/net/NetworkQuotaInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/ui/InLineSettingCheckBox;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/GLRoot;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/DeskClock;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/browse/MessageHeaderView;-showExpandedDetails-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/AnimatedAdapter;-changeCursor-(Landroid/database/Cursor;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine;-handleScreenStateChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/category/CategoryView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationViewFragment$4;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/media/MediaFocusControl;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/documentsui/DocumentsApplication;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/widgets/PlayheadView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/eas/EasOperation;-addDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiStateMachine;-startTethering-(Ljava/util/ArrayList;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/provider/BrowserProvider2;-updateBookmarksInTransaction-(Landroid/content/ContentValues; Ljava/lang/String; [Ljava/lang/String; Z)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/SearchActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkPolicyManagerService$12;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/calendar/event/EditEventActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/RepeatingImageButton;-access$000-(Lcom/android/music/RepeatingImageButton; Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-makeInboundSmsHandler-(Landroid/content/Context; Lcom/android/internal/telephony/SmsStorageMonitor; Lcom/android/internal/telephony/PhoneBase;)Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSettingsFragment$LoadAccountTask;-onPostExecute-(Ljava/util/Map;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/widgets/MediaLinearLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageCrop;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasSyncCalendar;-cleanup-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/BackupAgent;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/VideoBrowserActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/AtPhonebook;-checkAccessPermission-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkState-()[Landroid/net/NetworkState;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothGatt;-removeService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipService;-unregisterReceivers-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hid/HidService;-broadcastConnectionState-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageWebView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/TimeIntervalPopup;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BookmarkSearch;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/util/StateMachine$SmHandler$HaltingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/CommandsInterface;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationOverlayItem;-bindView-(Landroid/view/View; Z)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mail/ui/TwoPaneController;-access$1100-(Lcom/android/mail/ui/AbstractActivityController; Lcom/android/mail/ui/DestructiveAction;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/EasSyncService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothHeadset;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiManager;-getConfiguredNetworks-()Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/exchange/EasSyncService;-tryProvision-(Lcom/android/exchange/EasSyncService;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/agenda/AgendaFragment;-onAttach-(Landroid/app/Activity;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/view/SurfaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-enableLocationUpdates-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/ContactsSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/TrimVideo;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoSource;-naturalNext-(Landroid/graphics/Bitmap; Landroid/graphics/BitmapFactory$Options; I I)Landroid/graphics/Bitmap;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/inputmethodservice/ExtractButton;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/MediaSaveService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub;-startLegacyVpn-(Lcom/android/internal/net/VpnProfile;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/location/SettingInjectorService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressSymbol-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/DisplayPowerController$Callbacks;-onProximityPositive-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/EventViewer;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-queueNextSignalStrengthPoll-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/EventInfoFragment;-updateEvent-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IBackupManager$Stub$Proxy;-clearBackupData-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/CalendarSyncAdapterService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/alerts/DismissAlarmsService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-access$1000-(Lcom/android/music/MediaPlaybackActivity; I J)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calculator2/CalculatorViewPager;-pageLeft-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/SlideshowView;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/CellBroadcastHandler;-makeCellBroadcastHandler-(Landroid/content/Context;)Lcom/android/internal/telephony/CellBroadcastHandler;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setOutgoingCallerIdDisplay-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/magicsmoke/MagicSmoke;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/grass/Grass;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-handleRadioNotAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/ExchangeService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasAccountService;-parsePingResult-(Ljava/io/InputStream; Landroid/content/ContentResolver; Ljava/util/HashMap;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/AbstractActivityController$MailDrawerListener;-onDrawerSlide-(Landroid/view/View; F)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/base/GLTextureSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Lcom/google/common/io/OutputSupplier;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/policy/impl/PhoneWindow$DecorView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/EasServerConnection;-makeUserString-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/IAudioService;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/browser/preferences/WebsiteSettingsFragment$SiteAdapter$UpdateFromBookmarksDbTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/sip/SipService;-restartPortMappingLifetimeMeasurement-(Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterAlbumSet;-updateClustersContents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/DayFragment;-onResume-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getCallHistorySize-(I)I' : ['android.permission.READ_CALL_LOG'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorCompareView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/Service;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/service/EmailSyncAdapterService;-access$000-(Landroid/accounts/Account;)Ljava/util/HashSet;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/TwoPaneController;-perhapsShowFirstSearchResult-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/development/AppHwConfigList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-setHoldScreenLocked-(Lcom/android/server/wm/Session;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-buildAppWidgetModel-(Landroid/content/Context; Landroid/database/Cursor; Ljava/lang/String;)Lcom/android/calendar/widget/CalendarAppWidgetModel;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/inputmethodservice/KeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/CreateShortcutActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calculator2/Calculator$PageAdapter;-setPrimaryItem-(Landroid/view/ViewGroup; I Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothAdapter;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/AbstractActivityController;-access$1600-(Lcom/android/mail/ui/AbstractActivityController;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiEnabled-(Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/LatinIME;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-connectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosrc/MediaSource;-pauseVideo-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/dreams/phototable/PhotoTableDream;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/uicc/RuimRecords;-setLocaleFromCsim-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/magicsmoke/MagicSmoke;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowSession$Stub;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStack;-moveTaskToBackLocked-(I Lcom/android/server/am/ActivityRecord;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Service;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/videoeditor/ProjectsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/mock/MockApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MusicPicker;-setSelected-(Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailsync/SyncManager;-stopAccountSyncs-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getWidgetsEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-observe-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService$AudioHandler;-onPlaySoundEffect-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/InputMethodManagerService;-showInputMethodSubtypeMenu-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/util/SingleThreadNamedTaskExecutor$Worker;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/TextClock;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-hideWarningView-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/datetimepicker/time/RadialTextsView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/OnePaneController;-starMessage-(Lcom/android/mail/browse/ConversationMessage; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/ProgressBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PicasaSource;-findImages-(I)Ljava/util/Collection;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/accounts/ChooseAccountActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL$RILReceiver;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/alarms/AlarmStateManager;-setAlarmState-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-isSyncPending-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Landroid/widget/GridView;-commonKey-(I I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/StitchingChangeListener;-onStitchingResult-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/IWindowSession$Stub;-add-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/widget/ActionBarContextView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompatJellyBean$1;-createAccessibilityNodeInfo-(I)Landroid/view/accessibility/AccessibilityNodeInfo;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleCallDeflectionIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/Connectivity;-access$2300-(Lcom/android/development/Connectivity;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationsInOutboxTipView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ViewAnimator;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BluetoothManagerService;-disable-(Z)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/NavScreen;-onClick-(Landroid/view/View;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/exchange/service/EasService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Landroid/widget/DateTimeView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IBackupAgent;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/deskclock/AlarmTimelineView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Ljava/net/URLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/email/service/EasAuthenticatorService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioService;-adjustVolume-(I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/fall/FallWallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/datetimepicker/date/DatePickerController;-onDayOfMonthSelected-(I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothMap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/service/notification/NotificationListenerService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindow;-onKeyDown-(I I Landroid/view/KeyEvent;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/CalendarView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager$Stub$Proxy;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService;-prev-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/keychain/KeyChainActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/provider/BrowserProvider2$DatabaseHelper;-onCreate-(Landroid/database/sqlite/SQLiteDatabase;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/deskclock/CircleTimerView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/alarmclock/DigitalAppWidgetService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmClockFragment$9;-doInBackground-([Ljava/lang/Void;)Lcom/android/deskclock/provider/AlarmInstance;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/support/v4/view/AccessibilityDelegateCompatJellyBean$1;-performAccessibilityAction-(Landroid/view/View; I Landroid/os/Bundle;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onReleaseSymbol-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$900-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothMap;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/dreams/phototable/FlipperDreamSettings;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/keychain/KeyChainActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorValueView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$AccessibilityContentObserver;-<init>-(Lcom/android/server/accessibility/AccessibilityManagerService; Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wifi/WifiService;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/documentsui/DirectoryView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasSettings;-sendDeviceInformation-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/TabScrollView$TabLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/DockObserver;-handleDockStateChange-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/GeolocationPermissionsPrompt;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/FrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email2/ui/MailActivityEmail;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onSingleTapUp-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/GalleryActionBar$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/pm/PackageManagerService;-scanPackageLI-(Ljava/io/File; I I J Landroid/os/UserHandle;)Landroid/content/pm/PackageParser$Package;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/packageinstaller/TabsAdapter;-restoreState-(Landroid/os/Parcelable; Ljava/lang/ClassLoader;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-getIMEISV-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-processMessagePart-(Lcom/android/internal/telephony/InboundSmsTracker;)Z' : ['android.permission.READ_PROFILE', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/Controller;-onConfgurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-setPackageScreenCompatMode-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/ui/ThumbnailLoadTask;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothHeadset;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/renderscript/RSTextureView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/Connectivity;-onRoutedSocketRequest-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/provider/Telephony$Mms;-query-(Landroid/content/ContentResolver; [Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_SMS'],
	'Landroid/media/IAudioService$Stub$Proxy;-stopBluetoothSco-(Landroid/os/IBinder;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-vibrate-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/inputmethod/keyboard/EmojiPalettesView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/DataManager;-getSupportedOperations-(Lcom/android/gallery3d/data/Path;)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService;-broadcastStickyIntent-(Landroid/content/Intent; Ljava/lang/String; I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/GLTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AlbumBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AllInOneActivity;-updateSecondaryTitleFields-(J)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/mail/ui/AccountItemView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameFetch;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/AccessibleTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/nsd/INsdManager;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.INTERNET'],
	'Landroid/inputmethodservice/KeyboardView;-openPopupIfRequired-(Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-queryFacilityLockForApp-(Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-access$000-(Lcom/android/internal/telephony/gsm/GsmConnection;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mail/ui/LeaveBehindItem;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BatteryService;-access$600-(Lcom/android/server/BatteryService; Landroid/os/BatteryProperties;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/printspooler/FusedPrintersProvider;-access$1000-(Lcom/android/printspooler/FusedPrintersProvider;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationViewHeader$ConversationViewHeaderCallbacks;-onFoldersClicked-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/alerts/AlertService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/connectivity/Tethering$TetherInterfaceSM$StartingState;-enter-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActiveServices;-performServiceRestartLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressShift-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/MovieActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-process-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/VideoBrowserActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/UnderdevelopedSettings;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-sendAccessibilityEventForKey-(Lcom/android/inputmethod/keyboard/Key; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/google/android/mms/pdu/PduPersister;-updateHeaders-(Landroid/net/Uri; Lcom/google/android/mms/pdu/SendReq;)V' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/view/IInputMethodManager$Stub$Proxy;-shouldOfferSwitchingToNextInputMethod-(Landroid/os/IBinder;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageAttachmentBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hid/HidService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/SecureConversationViewFragment;-onFoldersClicked-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/ui/ButteryProgressBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-setUniverseTransformLocked-(Lcom/android/server/wm/WindowState; F F F F F F F)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider;-requestSetID-(I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/homepages/RequestHandler;-run-()V' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/speech/SpeechRecognizer;-startListening-(Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.RECORD_AUDIO'],
	'Lcom/android/bluetooth/pan/PanService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/SupplicantStateTracker$CompletedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/EasAuthenticatorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-onMotionEvent-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/printspooler/FusedPrintersProvider;-cancelInternal-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onPictureCenter-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/AllInOneActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/musicvis/vis3/Visualization3;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-onBackPressed-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-clientConnect-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/utility/CalendarUtilities;-createMessageForEventId-(Landroid/content/Context; J I Ljava/lang/String; Lcom/android/emailcommon/provider/Account; Ljava/lang/String;)Lcom/android/emailcommon/provider/EmailContent$Message;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterfw/core/Filter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-sendExtraCommand-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wifi/WifiController$DeviceActiveState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/videoeditor/OverlayTitleTemplatePicker;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailsync/SyncManager$AccountObserver$2;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/TintFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/commands/pm/Pm;-run-([Ljava/lang/String;)V' : ['android.permission.CLEAR_APP_CACHE'],
	'Landroid/net/sip/SipAudioCall;-releaseWifiHighPerfLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage;-getUriForFolder-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-setSymbolsShiftedKeyboard-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/provider/EmailProvider;-call-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/am/CoreSettingsObserver;-beginObserveCoreSettings-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/WebVttRenderingWidget;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/StateManager;-notifyActivityResult-(I I Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-setState-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/am/BroadcastQueue;-skipPendingBroadcastLocked-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/InputMethodManagerService$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothInputDevice;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-scanInternalSubtitleTracks-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getCallWaiting-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/soundrecorder/Recorder;-setState-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/EmlTempFileDeletionService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onVoiceCallEnded-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Landroid/app/ActivityManagerNative;-startRunning-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStack;-ensureActivitiesVisibleLocked-(Lcom/android/server/am/ActivityRecord; Lcom/android/server/am/ActivityRecord; Ljava/lang/String; I Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/browse/ConversationCursor;-notifyRefreshReady-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/Gallery;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pManager;-initialize-(Landroid/content/Context; Landroid/os/Looper; Landroid/net/wifi/p2p/WifiP2pManager$ChannelListener;)Landroid/net/wifi/p2p/WifiP2pManager$Channel;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/event/EventLocationAdapter$LocationFilter;-performFiltering-(Ljava/lang/CharSequence;)Landroid/widget/Filter$FilterResults;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/dreams/basic/Colors;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/CalendarView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterfw/core/FilterFunction;-executeWithArgList-([Ljava/lang/Object;)Landroid/filterfw/core/Frame;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/ChooseTypeAndAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calculator2/CalculatorViewPager;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/musicvis/vis4/Visualization4;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneBase;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/widget/ActivityChooserModel$DataModelPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/CantAddAccountActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperChange;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IActivityManager;-registerReceiver-(Landroid/app/IApplicationThread; Ljava/lang/String; Landroid/content/IIntentReceiver; Landroid/content/IntentFilter; Ljava/lang/String; I)Landroid/content/Intent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/os/IPowerManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/SmsApplication;-getDefaultRespondViaMessageApplication-(Landroid/content/Context; Z)Landroid/content/ComponentName;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/compose/EmptyService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/inputmethodservice/ExtractEditText;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-getWidgetsEnabled-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleMultipartyIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/CoreSettingsObserver;-sendCoreSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper;-startCamera-()V' : ['android.permission.CAMERA'],
	'Lcom/android/music/MediaPlaybackActivity$10;-onRepeat-(Landroid/view/View; J I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/ConnectivityService;-enforceChangePermission-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handlePollCalls-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/AllInOneActivity$4;-onChange-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/app/AlertActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/print/IPrintManager;-getPrintJobInfo-(Landroid/print/PrintJobId; I I)Landroid/print/PrintJobInfo;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/TabScrollView$TabLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/widget/FaceUnlockView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/EmailServiceStub;-deleteAccountPIMData-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/effect/effects/SaturateEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/app/FragmentTabHost;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-untether-(Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/am/ActivityManagerService$8;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsUsageMonitor; Lcom/android/internal/telephony/ImsSMSDispatcher; Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/dreams/phototable/PhotoTable;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-reportGeofenceMonitorStatus-(I I Landroid/location/Location; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/ProjectsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/emailsync/SyncManager;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/webkit/WebView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyDataConnectionFailed-(Lcom/android/internal/telephony/Phone; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/PowerManagerService;-access$2000-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavTabView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DialerFilter;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/AccountsChangedReceiver$DeleteRemovedAccounts;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-isOpened-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/widget/LockPatternUtils;-getAppWidgets-()[I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavScreen;-access$000-(Lcom/android/browser/NavScreen; Lcom/android/browser/Tab;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameBranch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/CountdownTimerPopup;-access$000-(Lcom/android/camera/ui/CountdownTimerPopup;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/Invert;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/RIL;-sendTerminalResponse-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DisconnectingState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/browser/PageDialogsHandler;-createSslCertificateDialog-(Landroid/net/http/SslCertificate; Landroid/net/http/SslError;)Landroid/app/AlertDialog$Builder;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/ISipService;-open-(Landroid/net/sip/SipProfile;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/music/AudioPreview;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/util/State;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothGatt;-readRemoteRssi-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/gatt/GattService;-readRemoteRssi-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/service/IEmailService;-pushModify-(J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/datetimepicker/time/RadialPickerLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-handleDreamFinishedLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-disable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollStateDone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/MessageFooterView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AsyncQueryService;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-conference-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothHealth;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsImpl;-updateSubtypeEnabler-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-writeDescriptor-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/activity/ComposeActivityEmail;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IPowerManager$Stub$Proxy;-updateWakeLockUids-(Landroid/os/IBinder; [I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/dreams/DreamManagerService;-startDream-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/support/v4/view/ViewPager;-setCurrentItemInternal-(I Z Z I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/development/AppHwPref;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/ExpandableListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/AnimatedAdapter;-performAndSetNextAction-(Lcom/android/mail/ui/SwipeableListView$ListItemsRemovedListener;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/FragmentBreadCrumbs;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LinearLayoutWithDefaultTouchRecepient;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/QuickResponseActivity$QueryThread;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-showWarningView-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterfw/core/Filter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LightsService$1;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/calendar/alerts/AlarmScheduler;-scheduleNextAlarm-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/ExchangeService;-serviceRequest-(J I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/Editor$SelectionEndHandleView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/OverlayTitleTemplatePicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-showGlobalActionsDialog-()V' : ['android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccCard;-setIccLockEnabled-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/provider/EmailProvider;-pickTrashFolder-(Landroid/net/Uri;)I' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/ConversationItemView;-bindAd-(Lcom/android/mail/browse/ConversationItemViewModel; Lcom/android/mail/ui/ControllableActivity; Lcom/android/mail/ui/AnimatedAdapter$ConversationListListener; Lcom/android/mail/browse/ConversationItemView$ConversationItemAreaClickListener; Lcom/android/mail/providers/Folder; I Lcom/android/mail/ui/AnimatedAdapter; I Landroid/graphics/Bitmap;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MediaPickerActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/CalendarSyncParser;-commandsParser-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/CalendarColorPickerDialog$QueryService;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/gadget/MediaSetSource;-monitorRootPath-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/PhoneUi;-<init>-(Landroid/app/Activity; Lcom/android/browser/UiController;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/videoeditor/widgets/PlayheadView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/photo/util/ImageUtils$HttpInputStreamFactory;-downloadBytes-()[B' : ['android.permission.INTERNET'],
	'Lcom/svox/pico/PicoService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TextSwitcher;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/pan/PanService;-doStop-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/music/QueryBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService;-adjustSuggestedStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-removeProcessLocked-(Lcom/android/server/am/ProcessRecord; Z Z Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/bluetooth/BluetoothAdapter;-cancelDiscovery-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine;-handleBatchedScanPollRequest-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/util/JobLimiter$JobWrapper;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothSocket;-bindListen-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/QuickResponseActivity;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/TelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-finalize-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ViewAnimator;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService;-onDestroy-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/datetimepicker/time/TimePickerDialog$4;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetoothMap;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/provider/Browser;-addSearchUrl-(Landroid/content/ContentResolver; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-searchMessages-(J Lcom/android/emailcommon/service/SearchParams; J)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/soundrecorder/SoundRecorder;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/StatusBarManagerService;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-requestIsimAuthentication-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/internal/NonDistinctMultitouchHelper;-processMotionEvent-(Landroid/view/MotionEvent; Lcom/android/inputmethod/keyboard/PointerTracker$KeyEventHandler;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Landroid/filterpacks/base/GLTextureTarget;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ActionBarContextView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/DatePickerDialog;-<init>-(Landroid/content/Context; I Landroid/app/DatePickerDialog$OnDateSetListener; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-access$2500-(Lcom/android/server/location/GpsLocationProvider; I Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-beginServiceDeclaration-(I I I I Landroid/os/ParcelUuid; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserPreferencesPage;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/SubtitleController;-getDefaultTrack-()Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setPin-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/opp/BluetoothOppManager;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email2/ui/MailActivityEmail;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ILockSettings$Stub$Proxy;-checkPassword-(Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MusicPicker;-onCompletion-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyLocationChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-loadEFTransparent-(I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StateManager;-startStateForResult-(Ljava/lang/Class; I Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothManager;-getConnectionState-(Landroid/bluetooth/BluetoothDevice; I)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-removeBatch-(Lcom/android/bluetooth/opp/BluetoothOppBatch;)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioService;-access$1100-(Landroid/media/AudioService; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/dataconnection/DcController;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/category/CategorySelected;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/UiModeManagerService;-access$000-(Lcom/android/server/UiModeManagerService; Ljava/lang/String; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; I)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-postEventFromNative-(Ljava/lang/Object; I I I Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupOutgoing;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/FlipFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AnalogClock;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailsync/SyncManager;-serviceRequest-(J J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/TwoPaneController;-onUpPressed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/SupplicantStateTracker$ScanState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/CandidatesContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary;-writeBinaryDictionary-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageVignette;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/photo/MailPhotoViewActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowManager$Stub;-disableKeyguard-(Landroid/os/IBinder; Ljava/lang/String;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorSVRectView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/TimerRingService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/browser/TabControl;-createNewTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/provision/DefaultActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/CheckedLinearLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/browse/MessageInviteView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/CalendarView;-access$900-(Landroid/widget/CalendarView; Landroid/widget/AbsListView; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/alarms/AlarmStateManager;-setHideNotificationState-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/TabControl;-removeParentChildRelationShips-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/print/IPrintManager$Stub;-removePrintJobStateChangeListener-(Landroid/print/IPrintJobStateChangeListener; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/internal/ScrollKeyboardView$OnKeyClickListener;-onKeyClick-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/email/service/AuthenticatorService$Authenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/quicksearchbox/google/GoogleSearch;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/crop/CropActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasOutboxService;-tryAutodiscover-(Landroid/content/Context; Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/DontPressWithParentLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-focusChangedLw-(Landroid/view/WindowManagerPolicy$WindowState; Landroid/view/WindowManagerPolicy$WindowState;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-access$100-(Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/NumberPicker;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/crop/CropActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/compose/ComposeActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/RotateFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/gsm/SmsManager;-getAllMessagesFromSim-()Ljava/util/ArrayList;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/ConversationUpdater;-delete-(I Ljava/util/Collection; Lcom/android/mail/ui/DestructiveAction; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/SmsApplication$SmsPackageMonitor;-onPackageChanged-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityRecord$Token;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/camera/tinyplanet/TinyPlanetPreview;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/AbstractMailActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ingest/IngestService;-onCreate-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/alerts/AlertActivity;-access$400-(Lcom/android/calendar/alerts/AlertActivity; J J J)V' : ['android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/base/NullFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewGroup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationPager;-addNewItem-(I I)Landroid/support/v4/view/ViewPager$ItemInfo;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-gotoIdleAndNotifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityRecord;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/print/IPrintManager$Stub;-cancelPrintJob-(Landroid/print/PrintJobId; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-processNextPostDialChar-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-dialThreeWay-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorHueView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/FolderSelectionActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/SeekBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/musicvis/vis3/Visualization3;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMAPhone; Landroid/telephony/CellInfo;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/google/common/io/ByteStreams;-getChecksum-(Lcom/google/common/io/InputSupplier; Ljava/util/zip/Checksum;)J' : ['android.permission.INTERNET'],
	'Lcom/android/emailsync/SyncManager;-startManualSync-(J I Lcom/android/emailsync/Request;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME$UIHandler;-onStartInputView-(Landroid/view/inputmethod/EditorInfo; Z)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/EmptyConversationListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppLiveFolder;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-powerOffRadioSafely-(Lcom/android/internal/telephony/dataconnection/DcTrackerBase;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-handleLocationChangedLocked-(Landroid/location/Location; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-getEnabledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/AccountController;-switchToDefaultInboxOrChangeAccount-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/notification/NotificationScorer;-getScore-(Landroid/app/Notification; I)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/InboundSmsHandler$SmsBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/browser/BrowserPreferencesPage;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/compose/AttachmentComposeView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/ISipService$Stub;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/calendar/event/AttendeesView;-addAttendees-(Ljava/util/ArrayList;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mail/ui/TwoPaneController;-onFolderChanged-(Lcom/android/mail/providers/Folder; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/MediaPlayer;-setWakeMode-(Landroid/content/Context; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onFling-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; F F)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getPhonebookNameList-(I)Ljava/util/ArrayList;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-rescheduleMissedAlarms-(Landroid/content/ContentResolver; Landroid/content/Context; Landroid/app/AlarmManager;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/bluetooth/BluetoothInputDevice;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/ActionModeHandler$2;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Void;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hdp/HealthService;-getMainChannelFd-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothHeadset;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/eas/EasSyncBase;-handleProvisionError-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/net/ConnectivityManager;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmCellBroadcastHandler;-handleSmsMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ViewFlipper;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/date/SimpleMonthView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabBar;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailsync/SyncManager$CalendarObserver;-<init>-(Lcom/android/emailsync/SyncManager; Landroid/os/Handler; Lcom/android/emailcommon/provider/Account;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/print/IPrintManager$Stub;-startPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/PrintManagerService$3;-onPackageAppeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/PrinterDiscoverySession;-finalize-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-deleteFromRawTable-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/filterpacks/imageproc/BlackWhiteFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationContainer;-onOverlayModelUpdate-(Ljava/util/List;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mail/ui/ConversationSyncDisabledTipView$4;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-startRecording-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-access$400-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/EmojiPalettesView$DeleteKeyOnTouchListener;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/ingest/ui/MtpThumbnailTileView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/gallery3d/data/SnailAlbum;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/timezonepicker/TimeZonePickerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/net/NetworkStatsService;-access$700-(Lcom/android/server/net/NetworkStatsService; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/ChooseAccountActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-updateWarningView-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-handleNewSms-(Landroid/os/AsyncResult;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mail/browse/ScrollIndicatorsView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BrowserActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothMap$Stub;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/AlertReceiver;-getEventCursor-(Landroid/content/Context; J)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Landroid/nfc/cardemulation/OffHostApduService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/crop/CropActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/eas/EasOperation;-requestSyncForMailboxes-(Landroid/accounts/Account; Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-addTrackerToRawTableAndSendMessage-(Lcom/android/internal/telephony/InboundSmsTracker;)I' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyCellInfo-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$InitialState;-enter-()V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothA2dp$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/category/CategoryTrack;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/printspooler/PrintSpoolerService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService$UpdateThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/mail/browse/ConversationContainer;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/FlipperDreamSettings;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasSyncService;-sendSettings-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession;-getAvailableRestoreSets-(Landroid/app/backup/IRestoreObserver;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-queueQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/AdapterView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/NumberPicker$CustomEditText;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneController;-confirmAndDelete-(I Ljava/util/Collection; Z I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-switchWaitingOrHoldingAndActive-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-setFilterInfo-(Lcom/android/bluetooth/map/BluetoothMapContent$FilterInfo;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-dial-(Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/EmptyAlbumImage;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/photos/AlbumSetFragment;-deleteItemWithPath-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/musicvis/vis1/Visualization1;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/net/IConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone;-queryAvailableBandMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage$CustomListView;-arrowScroll-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/MultiStateButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateFormat;-getTimeFormat-(Landroid/content/Context;)Ljava/text/DateFormat;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardParserImpl_V30;-handleNest-()V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/calendar/event/EditEventView;-updateView-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/mail/browse/ConversationPager;-smoothScrollTo-(I I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager$GetAuthTokenByTypeAndFeaturesTask;-run-(Landroid/accounts/AccountManagerFuture;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodSubtypeListLocked-(Landroid/view/inputmethod/InputMethodInfo;)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/MediaSet$ItemConsumer;-consume-(I Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/crop/CropActivity$BitmapIOTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/alarms/AlarmActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-selectNetworkManually-(Lcom/android/internal/telephony/OperatorInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/EmailSyncAdapterService$1;-sendMeetingResponse-(J I)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/research/Replayer;-replay-(Lcom/android/inputmethod/research/MotionEventReader$ReplayData; Ljava/lang/Runnable;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/mail/ui/AbstractActivityController$4;-onPostExecute-(Lcom/android/mail/providers/Folder;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-responsesParser-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/calculator2/Calculator;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralView;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/Application;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/GeneralPreferences;-access$000-(Lcom/android/calendar/GeneralPreferences;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getSelectedInputMethod-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/media/WebVttRenderingWidget$CueLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UiController;-openIncognitoTab-()Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calendar/Utils;-getDayOfWeekString-(I I J Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/support/v4/widget/DrawerLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService$Receiver;-updateMonitoring-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/Connectivity$WifiScanReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/server/wifi/WifiService;-getFrequencyBand-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/app/ExpandableListActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/text/method/TextKeyListener;-getPrefs-(Landroid/content/Context;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/CandidateView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-stopServiceLocked-(Lcom/android/server/am/ServiceRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/widget/CompoundButton;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-notifyCellInfo-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/TimePickerDialog;-onResume-()V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Landroid/support/v13/app/FragmentTabHost;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthBinder;-getConnectedHealthDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/timezonepicker/TimeZonePickerView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5400-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Landroid/app/ExpandableListActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/certinstaller/CertInstaller;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/alarms/AlarmActivity;-dismiss-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-access$900-(Lcom/android/gallery3d/ui/MenuExecutor; I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/backup/BackupAgentHelper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/ClockFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterState$PendingCommandState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getAllLinkQualityInfo-()[Landroid/net/LinkQualityInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/EmailConnectivityManager;-isAutoSyncAllowed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/SepiaFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/development/LogViewer;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/Switch;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub;-addPrintJobStateChangeListener-(Landroid/print/IPrintJobStateChangeListener; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-removePeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-onCreate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-<init>-(Lcom/android/internal/telephony/PhoneBase; Lcom/android/internal/telephony/SmsUsageMonitor; Lcom/android/internal/telephony/ImsSMSDispatcher;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onActionBarWanted-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/view/ViewRootImpl$EarlyPostImeInputStage;-onProcess-(Landroid/view/ViewRootImpl$QueuedInputEvent;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/SlideshowPage;-showPendingBitmap-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/Editor$SelectionStartHandleView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/WidgetService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/support/v4/widget/ContentLoadingProgressBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$1;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoPage;-updateUIForCurrentPhoto-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothPan$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/media/effect/effects/FisheyeEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationPager;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-attach-(Landroid/service/wallpaper/WallpaperService$IWallpaperEngineWrapper;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/wallpaper/fall/FallView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/videoeditor/OverlayTitleEditor;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/ConnectivityService;-getAllLinkQualityInfo-()[Landroid/net/LinkQualityInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/DontPressWithParentLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ActionableToastBar$ActionClickedListener;-onActionClicked-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/latin/LatinIME;-onFinishSlidingInput-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/dreams/phototable/CursorPhotoSource;-<init>-(Landroid/content/Context; Landroid/content/SharedPreferences;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/videoeditor/VideoEditorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/PointerLocationView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-access$1800-(Lcom/android/bluetooth/opp/BluetoothOppService; Landroid/database/Cursor; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/test/mock/MockContentResolver;-requestSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-getSelectedSpellChecker-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/PinyinIME;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryDownloadProgressBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/TouchExplorer;-onMotionEvent-(Landroid/view/MotionEvent; Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/CalendarView$WeekView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/SupplicantStateTracker$CompletedState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/gallery3d/ui/DownUpDetector;-setState-(Z Landroid/view/MotionEvent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/accessibility/TouchExplorer$PerformLongPressDelayed;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationContainer;-positionSnapHeader-(I)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/magicsmoke/MagicSmokeSelector;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/IWindowManager$Stub;-prepareAppTransition-(I Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/EasAutoDiscover;-sendHttpClientPost-(Ljava/lang/String; Lorg/apache/http/HttpEntity; J)Lcom/android/exchange/EasResponse;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/EventLoader$LoadEventsRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/speech/tts/TtsEngines;-getLocalePrefForEngine-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/text/format/DateFormat;-getDateFormatString-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-rightButtonAction-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationListFooterView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/EmailServiceUtils;-getServiceForAccount-(Landroid/content/Context; J)Lcom/android/emailcommon/service/EmailServiceProxy;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManagerProxy;-getAdnRecordsSize-(I)[I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailsync/SyncManager;-isMailboxSyncable-(Lcom/android/emailcommon/provider/Account; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/AlarmManagerService;-setWakelockWorkSource-(Landroid/app/PendingIntent; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/picasasource/PicasaSource$EmptyAlbumSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-startRfcommSocketListener-()V' : ['android.permission.READ_PHONE_STATE', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/FlipFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/widget/AdapterViewFlipper;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-getCellLocation-()Landroid/telephony/CellLocation;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService;-openFile-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/widget/AutoScrollHelper;-cancelTargetTouch-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventView$TimeClickListener;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/WaveView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/service/PolicyService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/DeskClock$TabsAdapter;-onPageSelected-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/ActivityController;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/print/PrintManager;-restartPrintJob-(Landroid/print/PrintJobId;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/coremedia/iso/IsoFile;-<init>-(Ljava/nio/channels/ReadableByteChannel;)V' : ['android.permission.INTERNET'],
	'Lcom/android/documentsui/SettingsActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/photos/shims/MediaSetLoader;-loadInBackground-()Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/FeedbackLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/soundrecorder/SoundRecorder$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationViewAdapter$ConversationHeaderItem;-rebindView-(Landroid/view/View;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/videoeditor/VideoEditorBaseActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/TestActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-dial-(Ljava/lang/String; I Lcom/android/internal/telephony/UUSInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/uicc/CsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/alarms/AlarmStateManager$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt;-sendResponse-(I Ljava/lang/String; I I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/DontPressWithParentLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/renderscript/RSSurfaceView;-surfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserWebView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/DatePickerDialog;-onDateChanged-(Landroid/widget/DatePicker; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/FilterShowActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractConversationViewFragment;-onAccountChanged-(Lcom/android/mail/providers/Account; Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/BrightnessFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothGatt;-sendNotification-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Z [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountAdapter;-getChildrenCursor-(Landroid/database/Cursor;)Landroid/database/Cursor;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/AlbumSetPage$MyDetailsSource;-setIndex-()I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/SearchActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/music/TouchInterceptor;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/ConversationSelectionSet;-toggle-(Lcom/android/mail/providers/Conversation;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcActivatingState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/TintFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavScreen$2;-onLayout-(I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/location/ILocationManager$Stub;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/printspooler/SelectPrinterActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-unregisterServer-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ISms;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/emailcommon/mail/Folder;-fetch-([Lcom/android/emailcommon/mail/Message; Lcom/android/emailcommon/mail/FetchProfile; Lcom/android/emailcommon/mail/Folder$MessageRetrievalListener;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/camera/CameraBackupAgent;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AddBookmarkPage$UpdateBookmarkTask;-doInBackground-([Landroid/content/ContentValues;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$ProvisionDiscoveryState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-setCdmaBroadcastActivation-(Z)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/IState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/mail/browse/MessageAttachmentTile;-thumbnailLoadFailed-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-notifyContentChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/videoeditor/widgets/HandleView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/TrackBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/photos/views/GalleryThumbnailView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-processStartTimedOutLocked-(Lcom/android/server/am/ProcessRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/music/TrackBrowserActivity$NowPlayingCursor;-moveItem-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/fall/FallView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/PieItem;-performClick-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/AccountsTester$2;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/imageproc/CropFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/CantAddAccountActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/info/HistogramView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-processConnectOtherProfiles-(Landroid/bluetooth/BluetoothDevice; I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth;-connectSocket-(Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/ISyncAdapter;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/InputMethodManagerService;-access$200-(Lcom/android/server/InputMethodManagerService; Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioManager;-preDispatchKeyEvent-(Landroid/view/KeyEvent; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/WindowManagerService$3;-run-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-access$1800-(Lcom/android/gallery3d/app/AlbumDataLoader; Ljava/util/concurrent/Callable;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-access$1000-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/GLTextureTarget;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/format/DateUtils;-formatDateTime-(Landroid/content/Context; J I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setLine1Number-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-acquireWakeLock-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onLongPress-()Z' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-init-(Landroid/content/Context;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothGattServer;-clearServices-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/TabBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavTabView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumSetPage;-access$1700-(Lcom/android/gallery3d/app/AlbumSetPage; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/internal/ScrollViewWithNotifier;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/IWifiManager;-getBatchedScanResults-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/alerts/GlobalDismissManager;-syncReceiverDismissCache-(Landroid/content/Context;)V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/app/TimeBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/crop/CropActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/map/BluetoothMapService$BluetoothMapBinder;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/browse/BorderView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/WaveView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-dispose-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-access$4600-(Lcom/android/server/pm/PackageManagerService; Z Z Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getRemoteType-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-requestNetworkTransitionWakelock-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Landroid/media/MediaPlayer;-access$900-(Landroid/media/MediaPlayer; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/SystemBackupAgent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/ComprehensiveCountryDetector;-startLocationBasedDetector-(Landroid/location/CountryListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/print/PrintJob;-isStarted-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/RunningProcesses;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/print/IPrintManager$Stub;-getPrintJobInfo-(Landroid/print/PrintJobId; I I)Landroid/print/PrintJobInfo;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationPager;-populate-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/MediaSaveService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/RecognitionManagerService;-systemReady-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/LockdownVpnTracker;-onVpnStateChanged-(Landroid/net/NetworkInfo;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-acknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/FolderSpanTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/GLView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-<init>-(Lcom/android/internal/telephony/cdma/CDMALTEPhone;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/data/LocationClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/TimerRingService;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/printspooler/SelectPrinterActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-dispatchHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.VIBRATE'],
	'Landroid/bluetooth/IBluetooth$Stub;-setRemoteAlias-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/RIL;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-hideAndStopWelcomeVideo-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/LogTextBox;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/provider/Settings$Bookmarks;-add-(Landroid/content/ContentResolver; Landroid/content/Intent; Ljava/lang/String; Ljava/lang/String; C I)Landroid/net/Uri;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageGrad;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ActionBarView$HomeView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-revertToNitzTimeZone-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/PhotoPage;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/noisefield/NoiseFieldWallpaper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/DhcpStateMachine$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/UiController;-closeCurrentTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/deskclock/stopwatch/StopwatchFragment;-releaseWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationSetObserver;-onSetEmpty-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/VideoEditorBaseActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/musicvis/vis2/Visualization2;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/Controller;-openTab-(Ljava/lang/String; Lcom/android/browser/Tab; Z Z)Lcom/android/browser/Tab;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/DialogActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/GeneralPreferences;-onPreferenceChange-(Landroid/preference/Preference; Ljava/lang/Object;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/view/BookmarkContainer;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/widgets/TimelineHorizontalScrollView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/RotationPolicy;-registerRotationPolicyListener-(Landroid/content/Context; Lcom/android/internal/view/RotationPolicy$RotationPolicyListener; I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/MediaController;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/ExchangeService;-serviceRequest-(J J I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-access$300-(Lcom/android/server/LocationManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/crop/CropActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/content/ContentResolver;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/Chronometer;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/MultiStateButton;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/MediaSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/nsd/NsdManager;-init-()V' : ['android.permission.INTERNET'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mail/compose/QuotedTextView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/category/IconView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getBoolean-(Ljava/lang/String; Z)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/SupplicantStateTracker$UninitializedState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/content/SyncManager;-access$1400-(Lcom/android/server/content/SyncManager; Lcom/android/server/content/SyncManager$ActiveSyncContext; Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/EventInfoActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarApplication;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoModule;-onResumeTasks-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/location/ILocationManager$Stub;-clearTestProviderStatus-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/videoeditor/widgets/PreviewSurfaceView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/RotarySelector;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/AlarmClockFragment$AlarmItemAdapter;-access$2600-(Lcom/android/deskclock/AlarmClockFragment$AlarmItemAdapter; Lcom/android/deskclock/AlarmClockFragment$AlarmItemAdapter$ItemHolder; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothHeadset;-getConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/providers/downloads/ui/DownloadList;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/eas/EasOperation;-handleProvisionError-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calendar/selectcalendars/SelectVisibleCalendarsFragment;-onResume-()V' : ['android.permission.READ_CALENDAR'],
	'Landroid/print/IPrintManager$Stub;-getInstalledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasProvision;-provision-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/text/StringLogger;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/PlaybackQueueItem;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/phasebeam/PhaseBeam;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-sendEnvelopeWithStatus-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/QuickContactBadge;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GeofenceManager;-addFence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; I I Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-startAction-(I I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MediaPlaybackService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/am/Am;-main-([Ljava/lang/String;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.KILL_BACKGROUND_PROCESSES', 'android.permission.RESTART_PACKAGES'],
	'Lcom/android/server/SystemBackupAgent;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/exchange/EasSyncService;-sendMeetingResponse-(Lcom/android/exchange/MeetingResponseRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/MailActivity;-onRestoreInstanceState-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/Tab;-removeFromTree-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/widget/SizeAdaptiveLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/CrossProcessFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/ui/WebSearchSuggestionView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/agenda/AgendaFragment$2;-run-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/documentsui/DirectoryFragment;-formatTime-(Landroid/content/Context; J)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/date/YearPickerView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/ActionBatch$StartDownloadAction;-execute-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Lcom/android/inputmethod/keyboard/internal/PreviewPlacerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/ProjectsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/RotateLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/content/IContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/printspooler/FusedPrintersProvider;-onForceLoad-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageAttachmentTile;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/EventLoader$LoadEventDaysRequest;-processRequest-(Lcom/android/calendar/EventLoader;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/camera/ui/InLineSettingItem;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/ActionMenuPresenter$OverflowMenuButton;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/IconLoader;-loadIcon-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationViewFragment;-access$400-(Lcom/android/mail/ui/ConversationViewFragment;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/media/effect/effects/CropEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/WallpaperManager;-setStream-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/QueryBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/AutoCompleteTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/compose/ComposeActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/compat/UserDictionaryCompatUtils;-addWord-(Landroid/content/Context; Ljava/lang/String; I Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyLocationChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasOutboxSync;-addDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ActivityGroup;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioService$VolumeStreamState;-<init>-(Landroid/media/AudioService; Ljava/lang/String; I Landroid/media/AudioService$1;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub;-getMobileDataEnabled-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/hardware/location/GeofenceHardwareService;-access$200-(Landroid/hardware/location/GeofenceHardwareService; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mail/ui/ConversationViewFragment$3;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/TrimVideo;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-loadEFTransparent-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/ComboViewActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TableRow;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/photo/adapters/PhotoPagerAdapter;-setPrimaryItem-(Landroid/view/ViewGroup; I Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/widgets/AudioTrackLinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/CalendarContract$CalendarEntity$EntityIteratorImpl;-next-()Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/emailcommon/service/PolicyServiceProxy;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/policy/impl/GlobalActions$2;-onPress-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/camera/ShutterButton;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/TouchInterceptor;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/DayView;-switchViews-(Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/IAlarmManager$Stub;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/calendar/agenda/AgendaListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RotateFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/noisefield/NoiseFieldWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/deskclock/timer/TimerListItem;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getActiveLinkQualityInfo-()Landroid/net/LinkQualityInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/photos/views/SquareImageView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/BaseUi;-showWeb-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/content/ContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityStack;-updateTransitLocked-(I Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wm/Session;-addToDisplay-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect; Landroid/view/InputChannel;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/deskclock/widget/ActionableToastBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/SpeechRecognizer;-stopListening-()V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/wallpaper/fall/FallView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ingest/ui/MtpImageView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub$Proxy;-setRestrictBackground-(Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/dictionarypack/ButtonSwitcher;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/provider/BrowserProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/calculator2/Calculator;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-update-(Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/videosrc/CameraSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IHardwareService$Stub$Proxy;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Landroid/service/textservice/SpellCheckerService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/SlideshowPage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/provider/EmailProvider;-uiDeleteAccountData-(Landroid/net/Uri;)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/calendar/event/EditEventView$DateListener;-onDateSet-(Lcom/android/datetimepicker/date/DatePickerDialog; I I I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIO-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/SnailAlbum;-notifyChange-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/pacprocessor/PacService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-updateFromProvider-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/ISms;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/net/ConnectivityManager;-isActiveNetworkMetered-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/BrowserBackupAgent;-addBookmark-(Lcom/android/browser/BrowserBackupAgent$Bookmark;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/Tab;-<init>-(Lcom/android/browser/WebViewController; Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/ui/PhotoView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/AbstractActivityController;-onUpPressed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/agenda/AgendaByDayAdapter;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/mail/browse/ConversationPager;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/GridView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasProvision;-performOperation-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/exchange/eas/EasFolderSync;-doFolderSync-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager;-pollBatchedScan-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/app/IActivityManager;-wakingUp-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/AliasActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/FilterSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/map/BluetoothMnsObexClient;-handleRegistration-(I I)V' : ['android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Landroid/widget/GridLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-play-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-finishBooting-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/app/MovieActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/LatinIME;-onEndBatchInputAsyncInternal-(Lcom/android/inputmethod/latin/SuggestedWords;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-access$000-(Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/MovieActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IAccountService$Stub$Proxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/IWifiManager$Stub;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/exchange/eas/EasLoadAttachment;-requestSyncForMailbox-(Landroid/accounts/Account; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-updateUri-()Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/LauncherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/usb/UsbSettingsManager$MyPackageMonitor;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-notifyAndAcknowledgeLastIncomingSms-(Z I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiController;-registerForWifiIdleTimeChange-(Landroid/os/Handler;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/DeskClock$TabsAdapter;-<init>-(Lcom/android/deskclock/DeskClock; Landroid/app/Activity; Landroid/support/v4/view/ViewPager;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/AdapterView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/RecognitionManagerService$MyPackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/WidgetConfigure;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/NotificationManagerService$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-assignContactFromPhone-(Ljava/lang/String; Z)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/UiModeManagerService;-updateAfterBroadcastLocked-(Ljava/lang/String; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/DriverCall; Lcom/android/internal/telephony/gsm/GsmCallTracker; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/ServiceWatcher$2;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/stopwatch/StopwatchService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/compose/AttachmentsView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-dial-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hid/HidService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TabHost;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/AccountSetupIncomingFragment;-access$000-(Lcom/android/email/activity/setup/AccountSetupIncomingFragment;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-access$200-(Lcom/android/bluetooth/pbap/BluetoothPbapService;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-serverConnect-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/SMSDispatcher;-handleSendComplete-(Landroid/os/AsyncResult;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/SlideshowPage;-resume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/LinearLayoutWithDefaultTouchRecepient;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-invokeNextAgent-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/preference/PreferenceActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-scanForward-(I J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/emailcommon/service/IEmailService;-autoDiscover-(Ljava/lang/String; Ljava/lang/String;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/research/ReplayerService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/Tab$3;-onCloseWindow-(Landroid/webkit/WebView;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/LocationManagerService;-getReceiverLocked-(Landroid/app/PendingIntent; I I Ljava/lang/String; Landroid/os/WorkSource; Z)Lcom/android/server/LocationManagerService$Receiver;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/WeekSelector;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IPhoneSubInfo;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/deskclock/alarms/AlarmService;-startAlarm-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/tts/compat/CompatTtsService;-access$600-(Landroid/speech/tts/TextToSpeechService;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/wifi/WifiStateMachine$L2ConnectedState;-exit-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractMailActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/ConversationPager;-setCurrentItem-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/text/format/DateUtils;-formatDateRange-(Landroid/content/Context; J J I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-addAppLocked-(Landroid/content/pm/ApplicationInfo; Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/browse/ConversationViewAdapter$MessageHeaderItem;-getTimestampShort-()Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt;-registerForNotification-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothTetheringDataTracker;-teardown-()Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/FilmstripPage;-switchWithCaptureAnimation-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/RunningProcesses;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/accessibility/CaptioningManager;-getUserStyle-()Landroid/view/accessibility/CaptioningManager$CaptionStyle;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/RedEyeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/TrackBrowserActivity;-onListItemClick-(Landroid/widget/ListView; Landroid/view/View; I J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/smspush/WapPushManager;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/content/ModernAsyncTask$2;-call-()Ljava/lang/Object;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendSms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/TimerSetupView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IIccPhoneBook$Stub;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/vcard/VCardEntry$EntryElement;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/RIL;-sendImsGsmSms-(Ljava/lang/String; Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothAdapter;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/content/AbstractThreadedSyncAdapter$ISyncAdapterImpl;-initialize-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth$Stub;-setPairingConfirmation-(Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/wallpaper/galaxy/Galaxy;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/compose/CcBccView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/util/AsyncService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment$2;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EventColorPickerDialog;-onColorSelected-(I)V' : ['android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setName-(Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/app/AliasActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getRemoteType-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/addbookmark/FolderSpinner;-performItemClick-(Landroid/view/View; I J)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageRedEye;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FlipFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processDisplayText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-onPopupItemClick-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/FlipFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/updates/SELinuxPolicyInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/EmlViewerActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accounts/AccountManagerService;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/wallpaper/galaxy/GalaxyRS;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/app/AlertActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-requestSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/tinyplanet/TinyPlanetPreview;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-markAsUsed-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String; I I Z)V' : ['android.permission.INTERNET'],
	'Landroid/widget/TextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/EllipsizedMultilineTextView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/EllipsizedMultilineTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/tts/compat/CompatTtsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/SlideshowPage;-findMediaItem-(Lcom/android/gallery3d/data/MediaSet; I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/ContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/test/mock/MockContentResolver;-requestSync-(Landroid/content/SyncRequest;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ui/EdgeView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onLoadKeyboard-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/NumberPicker$CustomEditText;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/MultiAutoCompleteTextView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lorg/apache/http/impl/client/DefaultHttpClient;-execute-(Lorg/apache/http/client/methods/HttpUriRequest;)Lorg/apache/http/HttpResponse;' : ['android.permission.INTERNET'],
	'Landroid/app/backup/BackupAgent;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-disableNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/view/VolumePanel;-onProgressChanged-(Landroid/widget/SeekBar; I Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/view/accessibility/CaptioningManager$2;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setHdmiPlugged-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-main-(Landroid/content/Context; Lcom/android/server/pm/Installer; Z Z)Landroid/content/pm/IPackageManager;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/app/IWallpaperManager$Stub$Proxy;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/CacheAbuser;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onActionBarAllowed-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/activity/setup/MailboxSettings$2;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingInsecureRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogEnabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/calendar/EventInfoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/BackupManagerService$PerformRestoreTask;-execute-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/hdp/HealthService;-unregisterAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/TwoPaneController;-onDataSetChanged-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityStackSupervisor;-moveTaskToStack-(I I Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderLocation-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/deskclock/alarms/AlarmStateManager;-setHighNotificationState-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-handleInjectNtpTime-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Controller;-switchToTab-(Lcom/android/browser/Tab;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$IndicatorView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ILockSettings$Stub$Proxy;-getLong-(Ljava/lang/String; J I)J' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-killAllBackgroundProcesses-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/calendar/alerts/AlertReceiver;-finishStartingService-(Landroid/app/Service; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/date/DatePickerDialog;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/ConnectivityManager;-setRadios-(Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-getHealthDeviceConnectionState-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/AlertActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-access$1100-(Lcom/android/music/MediaPlaybackActivity;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/svox/pico/PicoService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/content/SyncManager$ActiveSyncContext;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/SettingsRedirector;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/LogTextBox;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/NativeActivity$NativeContentView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-getViewAt-(I)Landroid/widget/RemoteViews;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/ListPrefSettingPopup;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipAudioCall;-setSpeakerMode-(Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/mail/ui/AbstractActivityController$DroppedInStarredAction;-performAction-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/BluetoothDevice;-createRfcommSocketToServiceRecord-(Ljava/util/UUID;)Landroid/bluetooth/BluetoothSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/AnimatedAdapter;-startFadeOutLeaveBehindItemsAnimations-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calculator2/Calculator;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/app/LauncherActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setScanMode-(I I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/TrimVideo;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-handleLongPressOnHome-()V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/MultiAutoCompleteTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/AdapterView;-performItemClick-(Landroid/view/View; I J)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/keychain/KeyChainActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/alarms/AlarmNotifications;-broadcastNextAlarm-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-handlePollStateResult-(I Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/widget/FrameLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/documentsui/DocumentsApplication;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/ui/WebSearchSuggestionView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onSingleTapUp-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$People;-createPersonInMyContactsGroup-(Landroid/content/ContentResolver; Landroid/content/ContentValues;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/io/OutputStream;)V' : ['android.permission.INTERNET'],
	'Lcom/android/mail/ui/AbstractActivityController;-starMessage-(Lcom/android/mail/browse/ConversationMessage; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset;-disconnectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/widget/DatePicker;-updateDate-(I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/provider/EmailProvider$5;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/speechrecorder/SpeechRecorderActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/widgets/HorizontalScrollView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/PanoProgressBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-switchToNextInputSubtypeInThisIme-(Landroid/os/IBinder; Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-switchUser-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/Session;-performDrag-(Landroid/view/IWindow; Landroid/os/IBinder; F F F F Landroid/content/ClipData;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/LatinIME;-onCreate-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/printspooler/PrintJobConfigActivity$CustomEditText;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompatKitKat$1;-createAccessibilityNodeInfo-(I)Landroid/view/accessibility/AccessibilityNodeInfo;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/SipAudioCall;-endCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/LegacyImapAuthenticatorService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/RatingBar;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneLayout;-dispatchConversationVisibilityChanged-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/EasOutboxService;-hasConnectivity-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/Bookmarks$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/widget/ListView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/FrameSource;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/imageproc/TintFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/development/DataList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/dreams/phototable/PhotoCarousel;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/WakeLockStateMachine$WaitingState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/bluetooth/IBluetoothGattCallback$Stub$Proxy;-onAdvertiseStateChange-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-setAndPersistDeviceName-(Ljava/lang/String;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothPan$Stub$Proxy;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackActivity;-access$900-(Lcom/android/music/MediaPlaybackActivity; I J)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/LocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/browser/PieControl;-access$000-(Lcom/android/browser/PieControl;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onPause-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/MoreSettingPopup;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneController;-onConversationSelected-(Lcom/android/mail/providers/Conversation; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/AlbumPage;-access$1200-(Lcom/android/gallery3d/app/AlbumPage; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/AdapterApp;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt;-beginServiceDeclaration-(I I I I Landroid/os/ParcelUuid; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/eas/EasSync;-handleProvisionError-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/browser/PhoneUi;-showNavScreen-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins;-start-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/email/service/AuthenticatorService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompatKitKat$1;-performAction-(I I Landroid/os/Bundle;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/deskclock/worldclock/CitiesActivity$CityAdapter;-set24HoursMode-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/NavigationBarBase;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AbsoluteLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cat/CatService;-handleRilMsg-(Lcom/android/internal/telephony/cat/RilMessage;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/SyncAdapterDriver;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/FragmentBreadCrumbs;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setPassword-(Landroid/accounts/Account; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine$Disconnected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/CreatePlaylist;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/CalendarView$WeekView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accessibility/TouchExplorer;-access$2800-(Lcom/android/server/accessibility/TouchExplorer; Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-onClick-(Landroid/view/View;)V' : ['android.permission.WRITE_CALENDAR'],
	'Landroid/filterfw/core/Filter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-addIncludedService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/PieController;-onSettingChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/RotarySelector;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/Switch;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getSuggestionsExternal-(Ljava/lang/String;)Lcom/android/quicksearchbox/SourceResult;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-loadCallHistoryList-(I)Ljava/util/ArrayList;' : ['android.permission.READ_CALL_LOG'],
	'Lcom/android/mail/MailIntentService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccCard;-supplyPin2-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager$Stub;-stopUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onRegistrationFailed-(Landroid/net/sip/ISipSession; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onPictureCenter-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/hfp/HeadsetService$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Landroid/view/LayoutInflater$BlinkLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller$Download;-saveDataUri-()V' : ['android.permission.INTERNET'],
	'Landroid/inputmethodservice/ExtractEditLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/widgets/OverlayView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-setSafeMode-(Z)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/connectivity/PacManager;-access$200-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processSetupCall-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/Tab$2;-shouldOverrideUrlLoading-(Landroid/webkit/WebView; Ljava/lang/String;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/videoeditor/widgets/TimelineHorizontalScrollView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-getSyncManager-()Lcom/android/server/content/SyncManager;' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/widget/CalendarView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readConfigurationForUserStateLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager;-startPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/SelectionManager;-getSelected-(Z)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/print/PrintJob;-isBlocked-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-getAvailableNetworks-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onVoiceCallStarted-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/CameraRootView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/MultiStateButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/compose/AttachmentsView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserStop-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/inputmethodservice/KeyboardView;-sendAccessibilityEventForUnicodeCharacter-(I I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/print/IPrintManager;-getPrintJobInfos-(I I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestClient;-getActiveNetworkInfo-()Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/ConnectivityService;-<init>-(Landroid/content/Context; Landroid/os/INetworkManagementService; Landroid/net/INetworkStatsService; Landroid/net/INetworkPolicyManager; Lcom/android/server/ConnectivityService$NetworkFactory;)V' : ['android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setRadioPower-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/EasOutboxService;-tryProvision-(Lcom/android/exchange/EasSyncService;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/view/EventRedirectingFrameLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneController;-access$1600-(Lcom/android/mail/ui/AbstractActivityController;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt;-registerServer-(Landroid/os/ParcelUuid; Landroid/bluetooth/IBluetoothGattServerCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/widget/WidgetService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/mock/MockContentResolver;-addPeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoPage;-onAlbumModeSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToSim-(I Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/ui/SurfaceTargetFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/map/BluetoothMapService$SocketAcceptThread;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/ErrorConsoleView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setAndBroadcastNetworkSetTimeZone-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Landroid/content/Context;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiController$NoLockHeldState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/bluetooth/gatt/GattService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/Telephony$Threads;-getOrCreateThreadId-(Landroid/content/Context; Ljava/util/Set;)J' : ['android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneFactory;-makeDefaultPhones-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BROADCAST_STICKY', 'android.permission.WRITE_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/photos/shims/MediaItemsLoader;-loadInBackground-()Landroid/database/Cursor;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/videoeditor/widgets/OverlayLinearLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationListView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/content/IContentService;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/event/EditEventActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/RepeatingImageButton$RepeatListener;-onRepeat-(Landroid/view/View; J I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/FrameFetch;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/ConfigurationViewer;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/accessibility/AccessibilityInputFilter;-processBatchedEvents-(J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ZoomControls;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/ImmersiveModeConfirmation;-loadSetting-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/base/GLTextureSource;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/IRestoreSession$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IntentService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager$Stub;-confirmCredentialsAsUser-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Landroid/os/Bundle; Z I)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/grass/GrassWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorOpacityView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/timezonepicker/TimeZoneInfo;-getGmtDisplayName-(Landroid/content/Context;)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/ScreensaverActivity;-layoutClockSaver-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/ProfileService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/ActionBarView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/ComboViewActivity$TabsAdapter;-<init>-(Landroid/app/Activity; Landroid/support/v4/view/ViewPager;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/TouchExplorer;-access$2600-(Lcom/android/server/accessibility/TouchExplorer; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/svox/pico/PicoService;-getSettingsLocale-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/TwoStateImageView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/AccessibleTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager$Stub;-getAccountsAsUser-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/eas/EasOutboxSync;-requestSyncForMailbox-(Landroid/accounts/Account; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService;-enforceAccessPermission-()V' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/printspooler/PrintJobConfigActivity$CustomEditText;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-startProcessLocked-(Ljava/lang/String; Landroid/content/pm/ApplicationInfo; Z I Ljava/lang/String; Landroid/content/ComponentName; Z Z Z)Lcom/android/server/am/ProcessRecord;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/ui/ConversationUpdater;-markConversationsRead-(Ljava/util/Collection; Z Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/wifi/WifiService;-releaseWifiLock-(Landroid/os/IBinder;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CallerInfo;-markAsVoiceMail-()Lcom/android/internal/telephony/CallerInfo;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/calendar/event/EditEventFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/internal/widget/WeightedLinearLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/telephony/TelephonyManager;-getLine1Number-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/compose/EnterSubject;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/SIMRecords;-handleFileUpdate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/view/PagerTabStrip;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/OnePaneController;-onFolderChanged-(Lcom/android/mail/providers/Folder; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/SettingsRedirector;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/CalendarBackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothGattServer;-removeService-(Landroid/bluetooth/BluetoothGattService;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler;-onQueryComplete-(I Ljava/lang/Object; Landroid/database/Cursor;)V' : ['android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/camera/ui/ListPrefSettingPopup;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/Pop3Service;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupAgent;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SlidingTab;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/print/PrintManagerService;-registerContentObservers-()V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/bluetooth/IBluetoothPan;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-setCellBroadcastActivation-(Z)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/TwoPaneController;-access$2600-(Lcom/android/mail/ui/AbstractActivityController; Lcom/android/mail/providers/Conversation;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/gadget/WidgetService$PhotoRVFactory;-onDataSetChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/ConversationListView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/VolumePanel;-onShowVolumeChanged-(I I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipCommandInterface;-onRadioAvailable-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/input/InputManagerService$7;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-makeWifiWatchdogStateMachine-(Landroid/content/Context;)Landroid/net/wifi/WifiWatchdogStateMachine;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.WRITE_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/gallery3d/app/PhotoPage$4;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/power/Notifier;-onWakeUpStarted-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/app/MovieActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-setKeyboardMode-(I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/app/ActivityManagerNative;-killApplicationWithAppId-(Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/accessibilityservice/AccessibilityService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/google/common/io/Files;-copy-(Lcom/google/common/io/InputSupplier; Ljava/io/File; Ljava/nio/charset/Charset;)V' : ['android.permission.INTERNET'],
	'Lcom/android/server/content/SyncManager;-access$1000-(Lcom/android/server/content/SyncManager; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Disconnected;-processConnectionEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/support/v4/view/ViewPager;-pageLeft-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/month/MonthByWeekAdapter$2;-run-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/location/ILocationManager$Stub$Proxy;-addGpsStatusListener-(Landroid/location/IGpsStatusListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/ShortcutActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mail/browse/SelectedConversationsActionMenu;-starConversations-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/noisefield/NoiseFieldView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-renderChild-(Lcom/android/gallery3d/glrenderer/GLCanvas; Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/StateManager;-switchState-(Lcom/android/gallery3d/app/ActivityState; Ljava/lang/Class; Landroid/os/Bundle;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email2/ui/CreateShortcutActivityEmail;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/agenda/AgendaListView;-goTo-(Landroid/text/format/Time; J Ljava/lang/String; Z Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-doQuery-(Lcom/android/calendar/agenda/AgendaWindowAdapter$QuerySpec;)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/mail/ui/OnePaneController;-showConversation-(Lcom/android/mail/providers/Conversation;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/print/PrintManager;-removePrintJobStateChangeListener-(Landroid/print/PrintManager$PrintJobStateChangeListener;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-processMsg-(Landroid/os/Message;)Lcom/android/internal/util/State;' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-rebootSafeMode-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/AudioManager;-adjustVolume-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/RecognitionManagerService$MyPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/RotarySelector;-dispatchTriggerEvent-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/location/IGeofenceHardware$Stub;-pauseGeofence-(I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/browse/EmlViewerActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/PolicyService$1;-setAccountPolicy-(J Lcom/android/emailcommon/provider/Policy; Ljava/lang/String;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/media/WebVttRenderingWidget;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/ComposeActivityEmail;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TextToSpeechService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getAdapterConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateCurrentCarrierInProvider-(Ljava/lang/String;)Z' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/camera/crop/CropActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActiveServices;-removeConnectionLocked-(Lcom/android/server/am/ConnectionRecord; Lcom/android/server/am/ProcessRecord; Lcom/android/server/am/ActivityRecord;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/IAudioService$Stub;-adjustSuggestedStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/RenderScriptWallpaper$RenderScriptEngine;-onSurfaceChanged-(Landroid/view/SurfaceHolder; I I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/ActivityManagerService$26;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/widget/TableLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/BaseSuggestionView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/LocalSource;-fillQueue-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-processCdmaWapPdu-([B I Ljava/lang/String; J)I' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/setup/SetupWizardActivity;-onWindowFocusChanged-(Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService$8;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$ObtainingIpState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-setSymbolsShiftedKeyboard-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/music/TrackBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/ExpandableTextView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$LabelView;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/emailcommon/service/EmailServiceProxy;-<init>-(Landroid/content/Context; Ljava/lang/Class;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/development/MediaScannerActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/service/ApiService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/provider/EmailProvider;-notifyUIConversationMailbox-(J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/DateTimeView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/widget/Switch;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/ConnectivityManager;-getTetheredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/google/common/io/Files;-copy-(Ljava/io/File; Ljava/nio/charset/Charset; Ljava/lang/Appendable;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-loadInputMethodAndSubtypeHistoryLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ViewOverlay$OverlayViewGroup;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/compose/EnterSubject;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageMirror;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/CalendarSyncAdapterService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onCreate-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/eas/EasLoadAttachment;-makeRequest-()Lorg/apache/http/client/methods/HttpUriRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/browse/SwipeableConversationItemView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/ActionMenuView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity;-scanBackward-(I J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Landroid/app/NativeActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/PinyinIME;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/AutologinBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-beginReliableWrite-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/inputmethod/InputMethodManager;-getEnabledInputMethodList-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/PhotoSource;-findImages-(I)Ljava/util/Collection;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/DialogActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-registerForNotification-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/MediaPlaybackService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z)J' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/filtershow/category/CategoryTrack;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/gatt/GattService;-endReliableWrite-(I Ljava/lang/String; Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorBrightnessView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/widgets/MediaLinearLayout$1;-onLongPress-(Landroid/view/View; Landroid/view/MotionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performHapticFeedbackLw-(Landroid/view/WindowManagerPolicy$WindowState; I Z)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/wm/WindowManagerService;-exitKeyguardSecurely-(Landroid/view/IOnKeyguardExitResult;)V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/mail/ui/FolderListFragment$4;-onDrawerClosed-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetoothHeadset;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/SystemBackupAgent;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/btservice/AdapterService;-adjustOtherHeadsetPriorities-(Lcom/android/bluetooth/hfp/HeadsetService; Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/SystemVibrator;-vibrate-(I Ljava/lang/String; J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/development/ShowActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/LatinIME;-maybeDoubleSpacePeriod-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/eas/EasPing;-requestFolderSync-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/calendar/EventInfoFragment;-updateAttendees-(Landroid/view/View;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/music/MediaPickerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/app/CameraApp;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/documentsui/DirectoryView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceResumeStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AutologinBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/VideoView;-getAudioSessionId-()I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/Parser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/development/Connectivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/hdp/HealthService$BluetoothHealthDeathRecipient;-binderDied-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/accounts/AccountManagerService$TestFeaturesSession;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/mail/ui/OnePaneController;-transitionBackToConversationListMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiManager;-getConfigFile-()Ljava/lang/String;' : ['android.permission.ACCESS_WIFI_STATE'],
	'Landroid/media/AudioService$2;-onServiceConnected-(I Landroid/bluetooth/BluetoothProfile;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/exchange/eas/EasOutboxSync;-performOperation-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/IWifiManager$Stub;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/net/MobileDataStateTracker;-startMonitoring-(Landroid/content/Context; Landroid/os/Handler;)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/GeofenceManager;-getFreshLocationLocked-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/deskclock/AlarmClockFragment$AlarmItemAdapter;-bindView-(Landroid/view/View; Landroid/content/Context; Landroid/database/Cursor;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeech;-isLanguageAvailable-(Ljava/util/Locale;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService;-getMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/wifi/WifiService;-reconnect-()V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/provider/Contacts$Settings;-getSetting-(Landroid/content/ContentResolver; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_CONTACTS'],
	'Landroid/view/IWindowSession;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onSetInternalDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/CameraRootView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPicker;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/UnderdevelopedSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-getSmsMessage-(J I)[B' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/exchange/eas/EasOptions;-makeRequest-()Lorg/apache/http/client/methods/HttpUriRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/ui/ConversationViewFragment;-onMessageCursorLoadFinished-(Landroid/content/Loader; Lcom/android/mail/browse/MessageCursor; Lcom/android/mail/browse/MessageCursor;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/datetimepicker/time/CircleView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/MediaScannerActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SlidingTab;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailsync/SyncManager;-releaseMailbox-(J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-performAuditoryFeedbackForAccessibilityIfNeed-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/EmojiPalettesView;-onKeyClick-(Lcom/android/inputmethod/keyboard/Key;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/Screensaver;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/FallbackEventHandler;-preDispatchKeyEvent-(Landroid/view/KeyEvent;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/tts/TextToSpeechService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BreadCrumbView$Controller;-onTop-(Lcom/android/browser/BreadCrumbView; I Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mail/ui/ConversationListCopy;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/CalendarView;-goTo-(Ljava/util/Calendar; Z Z Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/ImageView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/media/AudioManager;-adjustLocalOrRemoteStreamVolume-(I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-sync-(Landroid/content/Context; J Landroid/os/Bundle; Landroid/content/SyncResult; Z I)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-handleStatusReport-(Landroid/os/AsyncResult;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlideshowView;-onTouch-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-executeAndWait-(Ljava/util/concurrent/Callable;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/documentsui/DocumentsApplication;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/BrowserBackupAgent;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/svox/pico/CheckVoiceData;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/RuimPhoneBookInterfaceManager;-updateAdnRecordsInEfByIndex-(I Ljava/lang/String; Ljava/lang/String; I Ljava/lang/String;)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WAKE_LOCK'],
	'Lcom/android/providers/downloads/ui/DownloadList;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager;-getAuthTokenLabel-(Ljava/lang/String; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/ActionBarOverlayLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/polarclock/PolarClockWallpaper$ClockEngine;-reportVisibility-()V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/internal/telephony/CommandsInterface;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/fall/Fall;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/location/ILocationManager$Stub$Proxy;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/mail/ui/ConversationSyncDisabledTipView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/LocationManager;-recordLocation-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/ui/SearchActivityView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/IAudioService;-adjustLocalOrRemoteStreamVolume-(I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/app/ActivityManagerNative;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-setInitialAttachApn-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageStraighten;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/PhotoView;-access$800-(Lcom/android/gallery3d/ui/PhotoView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/UploaderService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/ui/SuggestionsView;-arrowScroll-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-acceptCall-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageVignette;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readDisplayMagnificationEnabledSettingLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/DestructiveAction;-performAction-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/eas/EasPing;-handleOneMailbox-(Lcom/android/exchange/adapter/Serializer; Lcom/android/emailcommon/provider/Mailbox;)Lcom/android/exchange/adapter/Serializer;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PackagesMonitor$AsyncService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pan/PanService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/service/wallpaper/WallpaperSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/VibratorService;-onInputDeviceChanged-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/AccountSetupActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/LatinIME$UIHandler;-executePendingImsCallback-(Lcom/android/inputmethod/latin/LatinIME; Landroid/view/inputmethod/EditorInfo; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/UrlInputView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/BalloonHint$BalloonView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/grass/GrassWallpaper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothAdapter;-getConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/app/PlatLogoActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/personalization/UserHistoryDictionary;-writeBinaryDictionary-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/SecureAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/CameraActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/UsageStatsService$2;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/ClusterSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/WebVttRenderingWidget$CueLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/SlotView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Browser;-getVisitedLike-(Landroid/content/ContentResolver; Ljava/lang/String;)Landroid/database/Cursor;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/base/RetargetFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PageProgressView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/InputView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/GalleryAppImpl;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/recurrencepicker/LinearLayoutWithMaxWidth;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/InLineSettingCheckBox;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-requestLocationUpdatesLocked-(Landroid/location/LocationRequest; Lcom/android/server/LocationManagerService$Receiver; I I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/updates/IntentFirewallInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/TabBar;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ISms$Stub$Proxy;-disableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/music/WeekSelector;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothMap$Stub;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/research/Uploader;-isConvenientToUpload-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/photos/shims/MediaItemsLoader;-deleteItemWithPath-(Ljava/lang/Object;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/TitleBar;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/WallpaperManagerService$MyPackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/printspooler/PrintJobConfigActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-dispose-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$Connected;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.READ_CONTACTS', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/TabWidget;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/mock/MockContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-writeBinaryDictionary-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/media/IAudioService$Stub$Proxy;-setStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/ex/photo/views/PhotoView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothGatt;-clearServices-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/OnePaneController;-perhapsEnterWaitMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-notifyServiceStateChangedP-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/Pop3Service;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/ISms;-sendMultipartText-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Ljava/util/List; Ljava/util/List; Ljava/util/List;)V' : ['android.permission.SEND_SMS'],
	'Lcom/android/mail/compose/EmptyService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/widget/DrawerLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/research/ReplayerService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/AlbumSetDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/eas/EasOutboxSync;-makeRequest-()Lorg/apache/http/client/methods/HttpUriRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/pm/UserManagerService$5;-onSomePackagesChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-getAllCellInfo-()Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipManager;-getListOfProfiles-()[Landroid/net/sip/SipProfile;' : ['android.permission.USE_SIP'],
	'Landroid/widget/DateTimeView;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/BondStateMachine$StableState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService$ServiceStub;-setQueuePosition-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService;-connectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/Vibrator;-vibrate-(I Ljava/lang/String; [J I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/am/UsageStatsService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-pickSuggestionManually-(I Lcom/android/inputmethod/latin/SuggestedWords$SuggestedWordInfo;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyServiceStateChanged-(Landroid/telephony/ServiceState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/utility/EmailAsyncTask$1;-callDoInBackgroundForTest-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/AlarmTimelineView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hid/HidService$BluetoothInputDeviceBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/browser/view/BookmarkContainer;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-addPrintJobStateChangeListener-(Landroid/print/IPrintJobStateChangeListener; I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/provider/RefreshStatusMonitor$RemoveRefreshStatusRunnable;-run-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/widget/TextTime;-access$000-(Lcom/android/deskclock/widget/TextTime;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/PrintManagerService;-getEnabledPrintServices-(I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/alarms/AlarmNotifications;-showHighPriorityNotification-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/appwidget/AppWidgetHostView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothPbap;-isConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/emailcommon/provider/Account;-isAutomaticSyncDisabledByRoaming-(Landroid/content/Context; J)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/emailsync/SyncManager;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/NavTabScroller$ContentLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/printspooler/PrintSpoolerService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accessibility/AccessibilityManagerService$1;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-updateProvidersLocked-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-deleteSystemPackageLI-(Lcom/android/server/pm/PackageSetting; [I [Z I Lcom/android/server/pm/PackageManagerService$PackageRemovedInfo; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsActivity;-onResume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/polarclock/PolarClockSettings;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/updates/TZInfoInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-dismissKeyguard-()V' : ['android.permission.DISABLE_KEYGUARD'],
	'Lcom/android/bluetooth/btservice/AdapterApp;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/svox/pico/PicoService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.CLEAR_APP_CACHE', 'android.permission.GET_PACKAGE_SIZE'],
	'Lcom/android/email/service/PolicyService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/ViewMode;-enterSearchResultsListMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/content/SyncActivityTooManyDeletes;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/RotarySelector;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/DragState;-endDragLw-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Presentation$1;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/updates/ConfigUpdateInstallReceiver$1;-run-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/AccountService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/text/StringLogger;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionCallReceiverImpl;-access$1600-(Lcom/android/server/sip/SipSessionGroup$SipSessionImpl; Ljava/util/EventObject;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/SipAudioCall;-onError-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videosrc/MediaSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/AlertService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/alarmclock/DigitalAppWidgetService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pDiscoveryChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/NavigationBarPhone;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/vcard/VCardParserImpl_V21;-handleNest-()V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/SMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ingest/IngestService;-deviceAdded-(Landroid/mtp/MtpDevice;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/eas/EasProvision;-performInitialRequest-()I' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothManager;-enable-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/music/MediaPlaybackService;-notifyChange-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothHealth$Stub$Proxy;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-onConnect-(Lcom/android/internal/telephony/dataconnection/DataConnection$ConnectionParams;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaFocusControl;-filterMediaKeyEvent-(Landroid/view/KeyEvent; Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/IAudioService;-startBluetoothSco-(Landroid/os/IBinder; I)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/email/provider/EmailProvider;-uiDeleteMessage-(Landroid/net/Uri;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-setMute-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/alarms/AlarmStateManager;-deleteAllInstances-(Landroid/content/Context; J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/media/AudioService;-adjustLocalOrRemoteStreamVolume-(I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/contacts/ContactsListActivity;-getSelectedUri-(I)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/provider/Contacts$People;-tryGetMyContactsGroupId-(Landroid/content/ContentResolver;)J' : ['android.permission.READ_CONTACTS'],
	'Lcom/svox/pico/CheckVoiceData;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneBase;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/test/RenamingDelegatingContext;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/datetimepicker/AccessibleLinearLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/Pop3Service$1;-loadAttachment-(Lcom/android/emailcommon/service/IEmailServiceCallback; J J Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/app/backup/FullBackupAgent;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/DhcpStateMachine$RunningState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/soundrecorder/SoundRecorder;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/test/IsolatedContext$MockAccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Landroid/location/SettingInjectorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/LockSettingsService;-checkReadPermission-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getBondedDevices-()[Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/DialogActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/sip/SipPhone;-setPreferredNetworkType-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/FrameLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/SupplicantStateTracker$InactiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/server/power/PowerManagerService;-updateDreamLocked-(I)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/widget/BookmarkThumbnailWidgetService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/EasCertificateRequestor;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawOverlayFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mail/compose/EmptyService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/gatt/GattService;-sendResponse-(I Ljava/lang/String; I I I [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-assignContactFromPhone-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/AlarmClockFragment$8;-doInBackground-([Ljava/lang/Void;)Lcom/android/deskclock/provider/AlarmInstance;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-clientDisconnect-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ConfirmDialogListener;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/eas/EasSync;-sendMessage-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/EmailContent$Message;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-getEFLinearRecordSize-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/ComboViewActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/am/CompatModePackages;-setPackageScreenCompatModeLocked-(Landroid/content/pm/ApplicationInfo; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/SmsStorageMonitor$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SimpleImageFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/deskclock/alarms/AlarmStateManager;-setDismissState-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/KeyboardView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/Service;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/documentsui/DocumentsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/Gallery;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaPlayer;-pause-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-killUid-(I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/BaseNetworkStateTracker;-startMonitoring-(Landroid/content/Context; Landroid/os/Handler;)V' : ['android.permission.BLUETOOTH', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/service/EmailServiceUtils;-getService-(Landroid/content/Context; Ljava/lang/String;)Lcom/android/emailcommon/service/EmailServiceProxy;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/compose/AutoSendActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-addAccount-(Landroid/accounts/IAccountManagerResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/mail/ui/OnePaneController;-stopDragMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calculator2/CalculatorDisplay;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$StopTetheringErrorState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/bluetooth/opp/BluetoothOppLiveFolder;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/photo/MailPhotoViewActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/FilterSource;-getDefaultSetOf-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/Path;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-setCurrentPhotoByIntent-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-isAudioOn-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/CommandsInterface;-writeSmsToRuim-(I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/ToggleButton;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/InLineSettingMenu;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-enqueue-([J I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onEnableApn-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/widget/TextTime;-chooseFormat-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService;-getShowTouchesSetting-(I)I' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TtsEngines;-getDefaultEngine-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/BlendFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/display/DisplayManagerService$WindowManagerFuncs;-requestTraversal-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/RichInputMethodManager;-hasMultipleEnabledIMEsOrSubtypes-(Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/email/service/Pop3Service$1;-deleteAccountPIMData-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/AdapterViewAnimator;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipSessionGroup$SipSessionImpl;-access$1600-(Lcom/android/server/sip/SipSessionGroup$SipSessionImpl; Ljava/util/EventObject;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/Pop3AuthenticatorService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/VideoUtils;-writeMovieIntoFile-(Ljava/io/File; Lcom/googlecode/mp4parser/authoring/Movie;)V' : ['android.permission.INTERNET'],
	'Lcom/android/server/am/ActivityManagerService;-finishUserSwitch-(Lcom/android/server/am/UserStartedState;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/ui/ConversationsInOutboxTipView;-access$000-(Lcom/android/mail/ui/ConversationsInOutboxTipView;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$UpdateContent;-call-()Ljava/lang/Void;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/ConversationListView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/MessageWebView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/WebSearchSuggestionView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BrowserActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/DigitalClock;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/input/InputManagerService;-registerShowTouchesSettingObserver-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmConnection;-<init>-(Landroid/content/Context; Ljava/lang/String; Lcom/android/internal/telephony/gsm/GsmCallTracker; Lcom/android/internal/telephony/gsm/GsmCall;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/SynchronouslyLoadedContactsBinaryDictionary;-loadDictionaryAsync-()V' : ['android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/net/ConnectivityManager;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onRadioAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email2/ui/MailActivityEmail;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/category/CategorySelected;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/DeleteItems;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryProvider;-getDictionaryWordListsForLocale-(Ljava/lang/String; Ljava/lang/String; Z)Ljava/util/Collection;' : ['android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/AddBookmarkPage$SaveBookmarkRunnable;-run-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/InputMethodManagerService;-access$1100-(Lcom/android/server/InputMethodManagerService;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationCursor;-notifyDataChanged-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/media/IAudioService$Stub$Proxy;-adjustStreamVolume-(I I I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/noisefield/NoiseField;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/datetimepicker/time/TimePickerDialog$OnTimeSetListener;-onTimeSet-(Lcom/android/datetimepicker/time/RadialPickerLayout; I I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/development/RunningProcesses;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiNotificationController;-<init>-(Landroid/content/Context; Landroid/net/wifi/WifiStateMachine;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-wipe-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/browser/Tab;-postCapture-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/accounts/AccountManager$6;-doWork-()V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/gallery3d/app/PhotoPage$7;-onSystemUiVisibilityChange-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/BluetoothGatt;-registerApp-(Landroid/bluetooth/BluetoothGattCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/updates/TZInfoInstallReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/IPolicyService$Stub;-setAccountPolicy-(J Lcom/android/emailcommon/provider/Policy; Ljava/lang/String;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/sip/SipService$SipAutoReg;-onRegistering-(Landroid/net/sip/ISipSession;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email2/ui/MailboxSelectionActivityEmail;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-changeBarringPassword-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothA2dp;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/suggestions/MoreSuggestionsView;-onCodeInput-(I I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/SlideshowPage;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneProxy;-getSmscAddress-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/SoundRecorder;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-addDescriptor-(I Landroid/os/ParcelUuid; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/ColorChipView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/UsimPhoneBookManager;-readAdnFileAndWait-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-switchToState-(I F F)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/view/LayoutInflater$BlinkLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/certinstaller/CertInstallerMain;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$5;-run-()V' : ['android.permission.REORDER_TASKS'],
	'Landroid/media/AudioService;-readPersistedSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/FilmStripView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/print/UserState;-updateIfNeededLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/DismissAlarmsService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/vcard/VCardParser_V30;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/view/IWindowSession$Stub;-addToDisplayWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/quicksearchbox/ui/WebSearchSuggestionView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/provider/DBHelper;-migrateLegacyAccounts-(Landroid/database/sqlite/SQLiteDatabase; Landroid/content/Context;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/content/ContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexServerSession;-onPut-(Ljavax/obex/Operation;)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/telephony/SmsManager;-enableCellBroadcastRange-(I I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/alarms/AlarmService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/compose/QuotedTextView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection$DcActiveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/accounts/AccountManagerService;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/mail/ui/TwoPaneController;-onFolderSelected-(Lcom/android/mail/providers/Folder;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/widgets/MediaItemView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/PingSyncSynchronizer;-pingEnd-(J Landroid/accounts/Account;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/inputmethodservice/ExtractEditText;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/settings/SettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/ViewAnimator;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaCallTracker;-handleCallWaitingInfo-(Lcom/android/internal/telephony/cdma/CdmaCallWaitingNotification;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/AudioTrackView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email2/ui/MailActivityEmail;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothPan;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/AlbumDataLoader$ReloadTask;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/DeviceStorageMonitorService;-access$000-(Lcom/android/server/DeviceStorageMonitorService; Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.CLEAR_APP_CACHE'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-stopScan-(I Z)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/ui/TwoPaneController;-updateConversation-(Ljava/util/Collection; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-start-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-notifySignalStrength-()Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/StateManager;-itemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/commands/bmgr/Bmgr;-doList-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/dreams/DreamService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/Pop3AuthenticatorService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/SlideshowDataAdapter$SlideshowSource;-getMediaItem-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/speech/tts/TextToSpeech;-synthesizeToFile-(Ljava/lang/String; Ljava/util/HashMap; Ljava/lang/String;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasSettings;-requestSyncForMailbox-(Landroid/accounts/Account; J)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/printspooler/SelectPrinterActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/NoSearchActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/ErrorConsoleView$ErrorConsoleListView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/mail/ui/AbstractActivityController;-stopDragMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Ljava/net/HttpURLConnection;-connect-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/DefaultPhoneNotifier;-notifyServiceState-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/alarmclock/DigitalAppWidgetProvider;-onUpdate-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; [I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/BitmapSource;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/RunningProcesses;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/AsyncQueryServiceHelper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/coremedia/iso/IsoFile;-createBoxParser-()Lcom/coremedia/iso/BoxParser;' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/deskclock/timer/TimerAlertFullScreen;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/text/ToUpperCase;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/app/DisableCarModeActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/SubtitleView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/NestedFolderTeaserView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/HandleApiCalls;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DatePicker;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-cancelBondProcess-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/AllInOneActivity;-onUserLeaveHint-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/server/BluetoothManagerService;-sendDisableMsg-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/email/service/LegacyImapAuthenticatorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-startDtmf-(C)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/TransitionsActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/crop/CropActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/renderscript/RSTextureView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BrowserPreferencesPage;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Controller$10;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/ingest/ui/MtpThumbnailTileView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/view/inputmethod/InputMethodManager;-getEnabledInputMethodSubtypeList-(Landroid/view/inputmethod/InputMethodInfo; Z)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/musicvis/vis5/Visualization5;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/BatteryService;-processValuesLocked-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorRectView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/utils/NotificationUtils;-setNewEmailIndicator-(Landroid/content/Context; I I Lcom/android/mail/providers/Account; Lcom/android/mail/providers/Folder; Z)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-processSlidingKeyInput-(Lcom/android/inputmethod/keyboard/Key; I I J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/app/MovieControllerOverlay;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-disableSingleLocationUpdate-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/NotificationController$AccountContentObserver;-onChange-(Z)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/documentsui/SettingsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/provider/EmailProvider;-uiSendDraftMessage-(J Landroid/os/Bundle;)Landroid/net/Uri;' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/print/PrintManagerService;-stopPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationViewFragment;-renderBorder-(Z Z Z Z)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/app/AlertActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/wallpaper/grass/GrassWallpaper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/wallpaper/fall/Fall;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/crop/CropActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/photos/GalleryActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/UrlHandler$RLZTask;-onPostExecute-(Ljava/lang/Object;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/Phone;-enableEnhancedVoicePrivacy-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/ui/QueryTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getEnabledProviders-()Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-startAction-(I I Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener; Z Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/performance/ThroughputFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/service/dreams/DreamService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onAlbumModeSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/data/SingleItemAlbum;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/ui/CorpusView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/PlaylistBrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-deleteFromRawTable-(Ljava/lang/String; [Ljava/lang/String;)V' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/development/MediaScannerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/AccountManager$2;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/EasAccountService;-postAutodiscover-(Lorg/apache/http/client/HttpClient; Lorg/apache/http/client/methods/HttpPost; Z)Lcom/android/exchange/EasResponse;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/editors/SwapButton;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/PlatLogoActivity$3;-onLongClick-(Landroid/view/View;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-supplyIccPin2ForApp-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/datetimepicker/date/TextViewWithCircularIndicator;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipSessionGroup;-processIOException-(Ljavax/sip/IOExceptionEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/adapter/EmailSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/ClockFragment;-onPageChanged-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/EasService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/MtpClient$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/MediaPlaybackService$CompatMediaPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/IWindowManager$Stub$Proxy;-startFreezingScreen-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/ModuleSwitcher;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/PowerManagerService;-updateSettingsLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub$Proxy;-expandNotificationsPanel-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Lcom/android/internal/telephony/SmsApplication$SmsPackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/HandleApiCalls;-handleSetAlarm-(Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/view/accessibility/CaptioningManager;-registerObserver-(Ljava/lang/String;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/uicc/UiccCardApplication;-supplyPin-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RadioButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/ConnectivityManager;-updateLockdownVpn-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/ToPackedGrayFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasSyncBase;-getRequestEntity-()Lorg/apache/http/HttpEntity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/AbstractActivityController;-access$2800-(Lcom/android/mail/ui/AbstractActivityController; Lcom/android/mail/content/ObjectCursor;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/TwoLineListItem;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothA2dp;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/suggestions/MoreSuggestionsView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-retrieveSettings-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-setState-(I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/quicksearchbox/google/GoogleSuggestionProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/app/Activity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/ActivityState;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setBandMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/BadBehaviorActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/browse/FolderSpanTextView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/ExpandedGridView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IAlarmManager;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/ui/ActionModeHandler;-access$700-(Lcom/android/gallery3d/ui/ActionModeHandler; Lcom/android/gallery3d/util/ThreadPool$JobContext; I)Landroid/content/Intent;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-clearClearableFlagsLw-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSetupNames;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/UninstallerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$ScreenNailJob;-run-(Lcom/android/gallery3d/util/ThreadPool$JobContext;)Ljava/lang/Object;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.INTERNET', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/FeedbackActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/magicsmoke/MagicSmokeSelector;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/packageinstaller/UninstallAppProgress;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/pacprocessor/PacService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/UnderdevelopedSettings;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/text/StringLogger;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/filterpacks/base/InputStreamSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState$SwitchActions;-setAlphabetShiftLockedKeyboard-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/PhoneBase;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/view/ViewPager;-setCurrentItem-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/widget/sgv/StaggeredGridView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-createSocketChannel-(I Ljava/lang/String; Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-sendVendorSpecificResultCode-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/FaceClustering;-run-(Lcom/android/gallery3d/data/MediaSet;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateUsbState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/timezonepicker/TimeZonePickerView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/RuimFileHandler;-updateEFLinearFixed-(I I [B Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorHueView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-notifyScreenNailChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub$Proxy;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/packageinstaller/GrantActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/TelephonyRegistry;-broadcastDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/TrimVideo;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/ViewStub;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter$DayAdapterInfo;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterfw/core/FilterGraph;-closeFilters-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/picasasource/PicasaSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/alerts/GlobalDismissManager$1;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ReceiverRestrictedContext;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/ConversationCursor;-access$2000-(Lcom/android/mail/browse/ConversationCursor;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-getTetheringErroredIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-setProcessLimit-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/activity/setup/AccountSecurity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-handleCancel-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/development/PointerLocation;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/map/BluetoothMapService$BluetoothMapBinder;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/GalleryActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-fixPeriodicSyncs-(Ljava/lang/String; Ljava/util/Map;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/speech/tts/TextToSpeechService;-getSettingsLocale-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine;-sendP2pStateChangedBroadcast-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/photos/GalleryActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calculator2/ColorButton;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AdapterViewAnimator;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-installNewPackageLI-(Landroid/content/pm/PackageParser$Package; I I Landroid/os/UserHandle; Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/wm/WindowManagerService;-performLayoutAndPlaceSurfacesLocked-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService$13$1;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-getLastPdpFailCause-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/LocationFudger;-loadCoarseAccuracy-()F' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/FlipEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-insertShare-(Landroid/database/Cursor; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH'],
	'Lcom/android/server/power/DisplayPowerController$4;-run-()V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-setNetworkSelectionModeAutomatic-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/nfc/cardemulation/OffHostApduService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/widget/RemoteViewsAdapter$RemoteViewsFrameLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/settings/GallerySettings;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/Pop3Service;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pan/PanService$BluetoothPanBinder;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/Phone;-exitEmergencyCallbackMode-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/Controller;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/speech/tts/TextToSpeechService;-access$600-(Landroid/speech/tts/TextToSpeechService;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/Phone;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/Activity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/SoftKeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/CountryDetectorService$2;-run-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BreadCrumbView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/CalculatorEditText;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/FilterShowActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/quicksearchbox/util/HttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/app/TrimVideo;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/util/StateMachine$SmHandler;-invokeExitMethods-(Lcom/android/internal/util/StateMachine$SmHandler$StateInfo;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/provider/Contacts$People;-addToGroup-(Landroid/content/ContentResolver; J Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-doStop-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/CertBlacklister;-registerObservers-(Landroid/content/ContentResolver;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getEnhancedVoicePrivacy-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/AbstractMailActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/provider/UserDictionary$Words;-addWord-(Landroid/content/Context; Ljava/lang/String; I Ljava/lang/String; Ljava/util/Locale;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/calendar/DayFragment;-goTo-(Landroid/text/format/Time; Z Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/development/AppHwConfigList;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/view/SnapshotGridView;-arrowScroll-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncManager$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/eas/EasLoadAttachment;-requestSyncForMailboxes-(Landroid/accounts/Account; Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/IConnectivityManager;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/telephony/TelephonyManager;-getSubscriberId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralTestActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/RepeatingImageButton;-doRepeat-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/KenBurnsActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/editstyledtext/EditStyledText;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/AppHwPref;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/EasAuthenticatorServiceAlternate;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-setGrabbedState-(I)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/BluetoothManagerService;-registerStateChangeCallback-(Landroid/bluetooth/IBluetoothStateChangeCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/HttpAuthenticationDialog$1;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/musicvis/RenderScriptWallpaper;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/ActivityController;-onConfgurationChanged-(Landroid/content/res/Configuration;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-getLastKnownLocation-()Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceAddStatus-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EmailServiceStub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.INTERNET', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothGatt;-discoverServices-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/Tab$2;-onReceivedLoginRequest-(Landroid/webkit/WebView; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/media/effect/effects/BlackWhiteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub$Proxy;-getCurrentSpellChecker-(Ljava/lang/String;)Landroid/view/textservice/SpellCheckerInfo;' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService;-access$2600-(Landroid/media/AudioService;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/PhoneNotifier;-notifySignalStrength-(Lcom/android/internal/telephony/Phone;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/browse/SpamWarningView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/EdgeView;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/ConversationViewFragment;-showUntransformedConversation-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/mail/ui/ConversationListCopy;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getUserData-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/deskclock/widget/sgv/StaggeredGridView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/RelativeLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/LegacyEasAuthenticatorService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/ExpandableTextView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothHeadset;-isAudioConnected-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/TouchInterceptor;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/view/CustomScreenLinearLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/music/MediaPlaybackService$MultiPlayer;-setDataSource-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/state/StateView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/ExchangeService;-getDeviceId-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/deskclock/TimerRingService;-onCreate-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/FisheyeFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationContainer;-positionOverlays-(I I)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/BluetoothPan;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mail/ui/TwoPaneLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$OngoingGroupRemovalState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/mail/ui/MailActivity;-handleDrop-(Landroid/view/DragEvent; Lcom/android/mail/providers/Folder;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-addTrackerToRawTable-(Lcom/android/internal/telephony/InboundSmsTracker;)I' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/widget/CheckedTextView;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AbsListView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/CandidateView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Switch;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/view/ViewGroup;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onResume-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/ime/Ime;-main-([Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPage;-pickPhoto-(I Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/RotarySelector;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/os/IPowerManager;-acquireWakeLock-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/alarms/AlarmStateManager;-setSnoozeState-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterfw/core/FilterSurfaceView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GpsLocationProvider;-reportGeofenceTransition-(I I D D D F F F J I J)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/development/DataList;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/CursorEntityIterator;-getEntityAndIncrementCursor-(Landroid/database/Cursor;)Landroid/content/Entity;' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$InitialState;-chooseUpstreamType-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/music/MediaPlaybackService;-pause-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PickerActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-composeAndSendCallLogVcards-(I Ljavax/obex/Operation; I I Z)I' : ['android.permission.READ_CALL_LOG', 'android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/CommonControllerOverlay;-onScrubbingEnd-(I I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/AbstractActivityController;-exitCabMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/videoeditor/NoSearchActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/view/menu/ActionMenuItemView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/magicsmoke/RenderScriptWallpaper$RenderScriptEngine;-reportVisibility-()V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/location/GpsLocationProvider;-access$2800-(Lcom/android/server/location/GpsLocationProvider;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onSetUserDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/NullFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/exchange/eas/EasMoveItems;-init-(Z)Z' : ['android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/keyboard/PointerTracker;-callListenerOnRelease-(Lcom/android/inputmethod/keyboard/Key; I Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/provider/BrowserContract$Bookmarks;-buildFolderUri-(J)Landroid/net/Uri;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/BroadcastQueue;-deliverToRegisteredReceiverLocked-(Lcom/android/server/am/BroadcastRecord; Lcom/android/server/am/BroadcastFilter; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/gadget/WidgetService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/MoreSettingPopup;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ingest/IngestService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/RenderOverlay;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-setIsSyncable-(Landroid/accounts/Account; Ljava/lang/String; I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onUpdateShiftState-(I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/music/AudioPreview;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/provider/Settings$Secure;-isLocationProviderEnabledForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-sendRequest-(I Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/ActivityManager;-getRecentTasks-(I I)Ljava/util/List;' : ['android.permission.GET_TASKS'],
	'Landroid/content/ISyncContext$Stub$Proxy;-onFinished-(Landroid/content/SyncResult;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/browser/BrowserBookmarksPage$OpenAllInTabsTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/net/sip/ISipService$Stub;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-updateCarrierMccMncConfiguration-(Ljava/lang/String; Ljava/lang/String; Landroid/content/Context;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/server/wm/WindowManagerService;-handleAppTransitionReadyLocked-(Lcom/android/server/wm/WindowList;)I' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CdmaInboundSmsHandler;-dispatchMessageRadioSpecific-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/textservice/ITextServicesManager$Stub;-setCurrentSpellCheckerSubtype-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/DigitalClock;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/IRecognitionService$Stub;-cancel-(Landroid/speech/IRecognitionListener;)V' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/mail/ui/ConversationListFragment;-onCursorUpdated-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/Utils;-trySyncAndDisableUpgradeReceiver-(Landroid/content/Context;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/ConversationListFooterView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/PhotoPage;-access$1500-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/view/CustomScreenLinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager$Stub;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/widget/CalendarView;-setDate-(J Z Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/sip/SipSessionGroup$KeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothInputDevice;-<init>-(Landroid/content/Context; Landroid/bluetooth/BluetoothProfile$ServiceListener;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/ImapService$1;-requestSync-(J Z I)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mail/ui/ConversationViewFragment$MailJsBridge$2;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Landroid/bluetooth/IBluetoothGatt;-serverDisconnect-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/PhotoView$Listener;-onActionBarAllowed-(Z)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I J Ljava/lang/String; Landroid/content/ComponentName;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub;-disconnectAudio-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/timezonepicker/TimeZonePickerDialog$OnTimeZoneSetListener;-onTimeZoneSet-(Lcom/android/timezonepicker/TimeZoneInfo;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/photos/views/SquareImageView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarApplication;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/exchange/service/PingTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/calculator2/Calculator$PageAdapter;-instantiateItem-(Landroid/view/ViewGroup; I)Ljava/lang/Object;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/view/EventRedirectingFrameLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/googlecode/mp4parser/authoring/container/mp4/MovieCreator;-build-(Ljava/nio/channels/ReadableByteChannel;)Lcom/googlecode/mp4parser/authoring/Movie;' : ['android.permission.INTERNET'],
	'Landroid/view/ViewOverlay$OverlayViewGroup;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/AccessibilityManagerService;-readTouchExplorationGrantedAccessibilityServicesLocked-(Lcom/android/server/accessibility/AccessibilityManagerService$UserState;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorRectView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationCursor$ConversationProvider;-apply-(Ljava/util/Collection; Lcom/android/mail/browse/ConversationCursor;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiStateMachine;-access$23000-(Landroid/net/wifi/WifiStateMachine; Ljava/util/ArrayList;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/deskclock/timer/TimerView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActiveServices;-startServiceInnerLocked-(Lcom/android/server/am/ActiveServices$ServiceMap; Landroid/content/Intent; Lcom/android/server/am/ServiceRecord; Z Z)Landroid/content/ComponentName;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/browse/SelectedConversationsActionMenu$2;-onPostExecute-(Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/musicvis/vis5/Visualization5;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/view/BasePieView;-layout-(I I Z F I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureTarget;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-open3-(Landroid/net/sip/SipProfile; Landroid/app/PendingIntent; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Lcom/android/server/LocationManagerService;-removeTestProvider-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/cdma/CdmaConnection;-update-(Lcom/android/internal/telephony/DriverCall;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/browser/view/CustomScreenLinearLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-updateNowIfNotUpdatedInAVeryLongTime-(Landroid/content/Context;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/service/ImapService;-processPendingAppend-(Landroid/content/Context; Lcom/android/email/mail/Store; Lcom/android/emailcommon/provider/Mailbox; Lcom/android/emailcommon/provider/EmailContent$Message;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/activity/setup/AccountSecurity;-access$100-(Lcom/android/email/activity/setup/AccountSecurity; Lcom/android/emailcommon/provider/Account;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/filterfw/core/FilterFunction;-close-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoCarousel$PhotoLoadTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/DataList;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/LockPatternUtils;-getBoolean-(Ljava/lang/String; Z I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothA2dp;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmCallTracker;-dial-(Ljava/lang/String; Lcom/android/internal/telephony/UUSInfo;)Lcom/android/internal/telephony/Connection;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getLong-(Ljava/lang/String; J)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifySignalStrength-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccProvider;-query-(Landroid/net/Uri; [Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Ljava/lang/String;)Landroid/database/Cursor;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-getPersistedScale-()F' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/TransitionsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/Utils;-formatMonthYear-(Landroid/content/Context; Landroid/text/format/Time;)Ljava/lang/String;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/widget/DatePicker;-onRestoreInstanceState-(Landroid/os/Parcelable;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmSMSDispatcher;-sendData-(Ljava/lang/String; Ljava/lang/String; I [B Landroid/app/PendingIntent; Landroid/app/PendingIntent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/IActivityManager;-killBackgroundProcesses-(Ljava/lang/String; I)V' : ['android.permission.RESTART_PACKAGES', 'android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/browser/TabControl;-restoreState-(Landroid/os/Bundle; J Z Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/gallery3d/filtershow/pipeline/ProcessingService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/print/IPrintManager$Stub$Proxy;-restartPrintJob-(Landroid/print/PrintJobId; I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TextClock;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/PhotoView$Model;-moveTo-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/datetimepicker/time/CircleView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransfer;-access$400-(Lcom/android/bluetooth/opp/BluetoothOppTransfer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationViewFragment;-renderSuperCollapsedBlock-(I I)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryDownloadProgressBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/text/format/DateUtils;-formatDateRange-(Landroid/content/Context; Ljava/util/Formatter; J J I)Ljava/util/Formatter;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/agenda/AgendaWindowAdapter;-buildQueryUri-(I I Ljava/lang/String;)Landroid/net/Uri;' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/app/ExpandableListActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Ljava/net/URLConnection;-getInputStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Lcom/android/email/service/Pop3SyncAdapterService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumPage$2;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarColorPickerDialog;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_CALENDAR'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/LocationManagerService$Receiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/TransitionsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/text/ToUpperCase;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/AlarmManagerService$ResultReceiver;-onSendFinished-(Landroid/app/PendingIntent; Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/TextView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/ProfileService;-notifyProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(Landroid/location/LocationRequest; Landroid/location/LocationListener; Landroid/os/Looper; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/OnePaneController;-changeAccount-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$InactiveState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/wifi/WifiStateMachine$TetheredState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowManagerService;-removeStack-(I)I' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/photos/views/HeaderGridView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/NotificationActionIntentService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/NavTabScroller$ContentLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/gadget/WidgetConfigure;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-getWifiServiceMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/google/common/io/MultiReader;-skip-(J)J' : ['android.permission.INTERNET'],
	'Landroid/telephony/TelephonyManager;-listen-(Landroid/telephony/PhoneStateListener; I)V' : ['android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarViewAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/eas/EasSearch;-requestSyncForMailboxes-(Landroid/accounts/Account; Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/ScrollingTabContainerView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/EventInfoActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AsyncPlayer;-acquireWakeLock-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/development/PackageSummary;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/MediaSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/ActionBarView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TableLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasSettings;-expandedAddDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer; Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/app/IBackupAgent$Stub;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/gsm/SimPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/gatt/GattService;-startScanWithUuids-(I Z [Ljava/util/UUID;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/view/IWindowManager$Stub$Proxy;-isRotationFrozen-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$1;-onDeleteGroup-(I)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/LocationClustering;-generateName-(Ljava/util/ArrayList; Lcom/android/gallery3d/util/ReverseGeocoder;)Ljava/lang/String;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/music/TrackBrowserActivity$4;-drop-(I I)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/gesture/GestureOverlayView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/quicksearchbox/ui/WebSearchSuggestionView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumDataLoader;-get-(I)Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/print/PrintManagerService$3;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/ColorButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/widget/BookmarkThumbnailWidgetService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorRectView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothGatt;-disconnect-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/support/v4/view/ViewPager;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/ConnectivityManager;-getTetherableIfaces-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/browser/AddNewBookmark;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/settings/DebugSettingsActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/pm/PackageManagerService;-killApplication-(Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/EasCertificateRequestor;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/MoreKeysKeyboardView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email2/ui/MailboxSelectionActivityEmail;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/OverlayTitleTemplatePicker;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth$Stub;-fetchRemoteUuids-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/ex/photo/PhotoViewPager;-pageLeft-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/datetimepicker/date/SimpleMonthView;-access$000-(Lcom/android/datetimepicker/date/SimpleMonthView; I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/telephony/RIL;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/StitchingChangeListener;-onStitchingQueued-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/AdapterView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getImsRegistrationState-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MusicBrowserActivity$1;-onServiceConnected-(Landroid/content/ComponentName; Landroid/os/IBinder;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/development/MediaScannerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/support/v4/widget/SearchViewCompatIcs$MySearchView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/opengl/GLSurfaceView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/keychain/KeyChainActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/commands/am/Am$IntentReceiver;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/widget/CheckBox;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-onDestroy-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/view/menu/ExpandedMenuView;-arrowScroll-(I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager$Stub;-requestGeofence-(Landroid/location/LocationRequest; Landroid/location/Geofence; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/BatteryStatsService;-getStatistics-()[B' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/VideoBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager;-getActiveLinkProperties-()Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothHeadset;-getBatteryUsageHint-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ui/PieMenuButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/location/GpsLocationProvider$4;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView$FullPicture;-draw-(Lcom/android/gallery3d/glrenderer/GLCanvas; Landroid/graphics/Rect;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Contacts$People;-addToMyContactsGroup-(Landroid/content/ContentResolver; J)Landroid/net/Uri;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/timezonepicker/TimeZonePickerDialog;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DockObserver;-onUEvent-(Landroid/os/UEventObserver$UEvent;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/inputmethod/InputMethodUtils$InputMethodSettings;-getEnabledInputMethodListLocked-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-getActiveLinkQualityInfo-()Landroid/net/LinkQualityInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/InputMethodManagerService;-setCurrentInputMethodSubtype-(Landroid/view/inputmethod/InputMethodSubtype;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/MovieActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ColorTemperatureFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v4/view/ViewPager;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/print/IPrintManager$Stub;-destroyPrinterDiscoverySession-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-sendVendorSpecificResultCode-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-updateServiceLocation-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/mock/MockApplication;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-setCallForward-(I I I Ljava/lang/String; I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothPbap;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/browse/ConversationPagerAdapter;-restoreState-(Landroid/os/Parcelable; Ljava/lang/ClassLoader;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/view/ViewGroup;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/selectcalendars/SelectCalendarsSyncFragment;-onLoadFinished-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/deskclock/Screensaver;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/IWindowSession$Stub;-addWithoutInputChannel-(Landroid/view/IWindow; I Landroid/view/WindowManager$LayoutParams; I Landroid/graphics/Rect;)I' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/widget/ActivityChooserView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/speech/tts/TextToSpeechService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/print/PrintManager;-getEnabledPrintServices-()Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/PickerActivity;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserActivity;-onSaveInstanceState-(Landroid/os/Bundle;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/datetimepicker/AccessibleTextView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/PhotoTableDream;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothMap;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/wm/WindowManagerService;-setForcedDisplaySizeLocked-(Lcom/android/server/wm/DisplayContent; I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/ExchangeService;-sendRequest-(J Lcom/android/emailsync/Request;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/BadBehaviorActivity$BadService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiService;-setWifiApEnabled-(Landroid/net/wifi/WifiConfiguration; Z)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/internal/widget/SizeAdaptiveLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/AddBookmarkPage;-setupTopCrumb-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/print/PrintManagerService$4;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/test/IsolatedContext$MockAccountManager;-getAuthTokenLabel-(Ljava/lang/String; Ljava/lang/String; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/exchange/service/EmailSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/TwoPaneLayout;-access$000-(Lcom/android/mail/ui/TwoPaneLayout;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/content/Context;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/month/SimpleWeekView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/RadialTextsView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/BookmarkSearch;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/text/format/DateFormat;-getDateFormat-(Landroid/content/Context;)Ljava/text/DateFormat;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/Calculator;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/musicvis/vis2/Visualization2;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothMap$Stub$Proxy;-getPriority-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnablingActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/provider/EmailProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/VideoUtils;-startMuteUsingMp4Parser-(Ljava/lang/String; Lcom/android/gallery3d/util/SaveVideoFileInfo;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/util/IState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/ex/photo/PhotoViewPager;-setCurrentItemInternal-(I Z Z I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/ConnectivityService;-handleConnect-(Landroid/net/NetworkInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/EmailSyncAdapter$EasEmailSyncParser;-parse-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Landroid/location/ILocationManager$Stub$Proxy;-getLastLocation-(Landroid/location/LocationRequest; Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/alarmclock/DigitalAppWidgetProvider;-onAppWidgetOptionsChanged-(Landroid/content/Context; Landroid/appwidget/AppWidgetManager; I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/EasTestAuthenticatorService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneSubInfoProxy;-getDeviceId-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/deskclock/AlarmClockFragment;-access$4600-(Landroid/content/Context; Lcom/android/deskclock/provider/Alarm;)Lcom/android/deskclock/provider/AlarmInstance;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiManager;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/email/EmailApplication;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/map/BluetoothMapService$MapBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-access$100-(Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/development/Connectivity;-onRoutedHttpRequest-()V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/internal/widget/ScrollingTabContainerView$TabView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/polarclock/PolarClockSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processPlayTone-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/ZoomControl;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/ex/photo/util/ImageUtils;-decodeStream-(Lcom/android/ex/photo/util/ImageUtils$InputStreamFactory; Landroid/graphics/Rect; Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;' : ['android.permission.INTERNET'],
	'Landroid/filterfw/core/FilterSurfaceView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$SoftApStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/printspooler/NotificationController$NotificationBroadcastReceiver;-handleRestartPrintJob-(Landroid/content/Context; Landroid/print/PrintJobId;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/GrainEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/IConnectivityManager;-setMobileDataEnabled-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/wifi/WifiWatchdogStateMachine;-registerForSettingsChanges-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/ScreenMagnifier;-access$200-(Lcom/android/server/accessibility/ScreenMagnifier;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/AbstractActivityController;-delete-(I Ljava/util/Collection; Lcom/android/mail/ui/DestructiveAction; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/ConversationViewAdapter;-getView-(Lcom/android/mail/browse/ConversationOverlayItem; Landroid/view/View; Landroid/view/ViewGroup; Z)Landroid/view/View;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView$2;-onAnimationEnd-(Landroid/animation/Animator;)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/widget/StackView$StackFrame;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BackupManagerService$ActiveRestoreSession;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/CertBlacklister;-<init>-(Landroid/content/Context;)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/media/MediaPlayer;-reset-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/GridView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/galaxy/GalaxyWallpaper;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/IConnectivityManager$Stub;-getTetherableWifiRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/media/effect/effects/VignetteEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/LocalMergeAlbum;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-getWifiState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/wallpaper/galaxy/GalaxyView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationViewFragment;-measureOverlayHeight-(Lcom/android/mail/browse/ConversationOverlayItem;)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-fakeChange-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/VideoView;-stopPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/PhoneUi;-setUseQuickControls-(Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/keyboard/MainKeyboardView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/musicvis/vis1/Visualization1;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/widget/ContentLoadingProgressBar;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/research/FeedbackActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/content/ContentResolver;-removePeriodicSync-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/music/AudioPreview;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/phasebeam/PhaseBeam;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/WiredAccessoryManager;-bootCompleted-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/AudioService$AudioHandler$2;-onError-(Landroid/media/MediaPlayer; I I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/videoproc/BackDropperFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/AllInOneActivity;-eventsChanged-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/calendar/selectcalendars/SelectSyncedCalendarsMultiAccountActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothGatt;-unregisterClient-(I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserPreferencesPage;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-explicitCallTransfer-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/ILocationManager$Stub;-getProviderProperties-(Ljava/lang/String;)Lcom/android/internal/location/ProviderProperties;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/hardware/IConsumerIrService;-getCarrierFrequencies-()[I' : ['android.permission.TRANSMIT_IR'],
	'Lcom/android/internal/app/PlatLogoActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/smspush/WapPushManager;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Landroid/speech/tts/TextToSpeech;-access$1700-(Landroid/speech/tts/TextToSpeech;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$DefaultState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasAccountService;-acknowledgeProvision-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-getSyncAutomatically-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/compose/ComposeAttachmentTile;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeComponent-(Lcom/android/gallery3d/ui/GLView;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/BrowserSettings;-clearHistory-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/app/Presentation$1;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothAdapter;-listenUsingRfcommWithServiceRecord-(Ljava/lang/String; Ljava/util/UUID;)Landroid/bluetooth/BluetoothServerSocket;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/CacheAbuser;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/browse/SuperCollapsedBlock;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-getIMSIForApp-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothMap;-setPriority-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/emailcommon/service/IEmailService;-sendMeetingResponse-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/net/wifi/WifiStateMachine$DisconnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/WebViewController;-showSslCertificateOnError-(Landroid/webkit/WebView; Landroid/webkit/SslErrorHandler; Landroid/net/http/SslError;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/CalendarSyncAdapterService;-performSync-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle;)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Landroid/provider/Settings$Secure;-getLong-(Landroid/content/ContentResolver; Ljava/lang/String;)J' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStartingState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/widget/AbsSpinner;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/MultiStateButton;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-getLinkQualityInfo-(I)Landroid/net/LinkQualityInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/development/LogTextBox;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/svox/pico/Pico;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/view/ViewPager;-smoothScrollTo-(I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/speech/tts/TextToSpeech;-setLanguage-(Ljava/util/Locale;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DuotoneFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasProvision;-addDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/calculator2/CalculatorEditText;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/google/common/io/CharStreams$2;-getInput-()Ljava/io/InputStreamReader;' : ['android.permission.INTERNET'],
	'Landroid/accounts/CantAddAccountActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/IIntentReceiver$Stub$Proxy;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/PhoneBase;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EasTestAuthenticatorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapVcardManager;-getContactNamesByNumber-(Ljava/lang/String;)Ljava/util/ArrayList;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/deskclock/Screensaver;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/datetimepicker/date/DayPickerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/MessageAttachmentTile;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/filtershow/ui/FramedTextButton;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/AndroidClockTextView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/IEmailServiceCallback$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/videoeditor/VideoEditorBaseActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/eas/EasOptions;-expandedAddDeviceInformationToSerializer-(Lcom/android/exchange/adapter/Serializer; Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/eas/EasSync;-getRequestUri-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/gadget/MediaSetSource;-<init>-(Lcom/android/gallery3d/data/DataManager; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-updateFolderList-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/widget/LockPatternUtils;-isPatternEverChosen-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/EmojiCategoryPageIndicatorView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ConversationsInOutboxTipView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/alerts/DismissAlarmsService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/TitleBar;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/DataManager;-onStitchingResult-(Landroid/net/Uri;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/PhoneBase;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/AlarmInitReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/SettingsRedirector;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/quicksearchbox/ui/ContactBadge;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FlipFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/filterpacks/base/OutputStreamTarget;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPickerActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/content/SyncActivityTooManyDeletes;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-updateProgressbar-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/map/BluetoothMapContentObserver$1;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_SMS'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageRemoved-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/Calculator;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-setGsmBroadcastConfig-([Lcom/android/internal/telephony/gsm/SmsBroadcastConfigInfo; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/BluetoothMap;-close-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiStateMachine;-retrieveBatchedScanData-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/SearchActivity$2;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/app/ManageCachePage;-onProgressComplete-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/pinyin/SoftKeyboardView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IBackupAgent$Stub$Proxy;-doBackup-(Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/latin/BackupAgent;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/SupplicantStateTracker$DisconnectedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/development/Connectivity;-access$3800-(Lcom/android/development/Connectivity;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/wm/WindowManagerService;-removeWindowInnerLocked-(Lcom/android/server/wm/Session; Lcom/android/server/wm/WindowState;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-systemReady-()V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/eas/EasSearch;-handleProvisionError-()Z' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/media/AudioManager;-querySoundEffectsEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/provider/RefreshStatusMonitor;-isConnected-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/Phone;-queryTTYMode-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/KenBurnsActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/View;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/date/DatePickerDialog;-setCurrentView-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BluetoothManagerService;-waitForOnOff-(Z Z)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/printspooler/PrintSpoolerService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/accessibility/AccessibilityEntityProvider;-createAccessibilityNodeInfo-(I)Landroid/support/v4/view/accessibility/AccessibilityNodeInfoCompat;' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Landroid/widget/ToggleButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/noisefield/NoiseFieldWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/RadioButton;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/NegativeFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/LocationManagerService;-removeUpdates-(Landroid/location/ILocationListener; Landroid/app/PendingIntent; Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/galaxy4/Galaxy4Wallpaper$RenderScriptEngine;-setOffsetNotificationsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/mail/ui/MailActivity;-onBackPressed-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/EmailApplication;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/EventViewer;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/BlendFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/exchange/eas/EasMoveItems;-sendMessage-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/EmailContent$Message;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/ConversationContainer;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/LegacyEasAuthenticatorService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onDeleteImage-(Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/videoeditor/widgets/PlayheadView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/gesture/GestureOverlayView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/ContentService;-getIsSyncable-(Landroid/accounts/Account; Ljava/lang/String;)I' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/EmailApplication;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/Preloader;-handlePreloadRequest-(Ljava/lang/String; Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/email/service/EmailBroadcastProcessorService;-onHandleIntent-(Landroid/content/Intent;)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.MANAGE_ACCOUNTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.USE_CREDENTIALS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_CALENDAR', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/inputmethod/latin/setup/SetupActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;-onProgressStart-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/QuickContactBadge;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/VideoEditorBaseActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetooth;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/SnoozeAlarmsService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/CommandsInterface;-getSignalStrength-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/accessibility/AccessibilityUtils;-onStartInputViewInternal-(Landroid/view/View; Landroid/view/inputmethod/EditorInfo; Z)V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/QuickResponseActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/RecognitionService;-checkPermissions-(Landroid/speech/IRecognitionListener;)Z' : ['android.permission.RECORD_AUDIO'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onRadioOffOrNotAvailable-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractActivityController;-changeAccount-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/accounts/AccountManager;-addAccountExplicitly-(Landroid/accounts/Account; Ljava/lang/String; Landroid/os/Bundle;)Z' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/widget/ActionBarView$HomeView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-<init>-(Ljava/lang/String; Lcom/android/internal/telephony/PhoneNotifier; Landroid/content/Context; Lcom/android/internal/telephony/CommandsInterface; Z)V' : ['android.permission.WRITE_SETTINGS'],
	'Landroid/content/ContextWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-trySwitchToFirstTouchState-(F F)Z' : ['android.permission.VIBRATE'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/Pop3SyncAdapterService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/commands/monkey/MonkeyNetworkMonitor;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/ui/OnePaneController;-commitDestructiveActions-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/CalendarSettingsActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/AbstractSettingPopup;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/support/v4/view/ViewPager;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/AddBookmarkPage;-onRootFolderFound-(J)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Ljava/net/URL;-openStream-()Ljava/io/InputStream;' : ['android.permission.INTERNET'],
	'Landroid/widget/RatingBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothPan;-close-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/sip/ISipService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/bluetooth/IBluetoothPan;-setBluetoothTethering-(Z)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-acknowledgeIncomingGsmSmsWithPdu-(Z Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setAndBroadcastNetworkSetTime-(J)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/view/SnapshotGridView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/magicsmoke/MagicSmokeSelector;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/vcard/VCardEntry;-isIgnorable-()Z' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/inputmethod/latin/ExpandableBinaryDictionary$13;-run-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_CONTACTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/app/AlbumSetPage$1;-render-(Lcom/android/gallery3d/glrenderer/GLCanvas;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordContents;-delete-(Landroid/content/Context;)V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/vcard/VCardEntry$EmailData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/accounts/AccountManager;-getAccountsForPackage-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/calendar/event/EditEventHelper;-saveRemindersWithBackRef-(Ljava/util/ArrayList; I Ljava/util/ArrayList; Ljava/util/ArrayList; Z)Z' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/app/AlbumPage;-doCluster-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/app/CommonControllerOverlay;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventFragment;-access$800-(Lcom/android/calendar/event/EditEventFragment; I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/videoeditor/widgets/MediaItemView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/effect/effects/StraightenEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onSetInternalDataEnabled-(Z)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/TabsAdapter;-<init>-(Landroid/app/Activity; Landroid/widget/TabHost; Landroid/support/v4/view/ViewPager;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/accessibility/TouchExplorer$SendHoverEnterAndMoveDelayed;-forceSendAndRemove-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/ShowActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AddBookmarkPage;-onEditorAction-(Landroid/widget/TextView; I Landroid/view/KeyEvent;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/musicvis/vis2/Visualization2;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/TrackBrowserActivity;-dispatchKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStoppingState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parse-(Ljava/io/InputStream;)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/widget/AbsSpinner;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/MenuExecutor;-onMenuClicked-(Landroid/view/MenuItem; Ljava/lang/String; Lcom/android/gallery3d/ui/MenuExecutor$ProgressListener;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-msgListing-(Ljava/lang/String; Lcom/android/bluetooth/map/BluetoothMapAppParams;)Lcom/android/bluetooth/map/BluetoothMapMessageListing;' : ['android.permission.READ_CONTACTS', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/effects/NegativeEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/OtherPreferences;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-getPrintJobInfos-(I I)Ljava/util/List;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetooth;-getAdapterConnectionState-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-makeAppNotRespondingLocked-(Lcom/android/server/am/ProcessRecord; Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/media/MediaFocusControl;-startVoiceBasedInteractions-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-addNmeaListener-(Landroid/location/GpsStatus$NmeaListener;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/os/IHardwareService;-setFlashlightEnabled-(Z)V' : ['android.permission.FLASHLIGHT'],
	'Lcom/android/calendar/CalendarApplication;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ITelephonyRegistry;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IWallpaperManager$Stub;-setDimensionHints-(I I)V' : ['android.permission.SET_WALLPAPER_HINTS'],
	'Lcom/android/calendar/widget/CalendarAppWidgetService$CalendarFactory;-onLoadComplete-(Landroid/content/Loader; Landroid/database/Cursor;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/mail/browse/SpamWarningView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/FilmstripPage;-access$400-(Lcom/android/gallery3d/app/PhotoPage;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/compose/AutoSendActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/MultiAutoCompleteTextView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ImsSMSDispatcher;-sendRetrySms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtEnableActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiManager;-isMulticastEnabled-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/camera/ShutterButton;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/am/Am;-runKillAll-()V' : ['android.permission.KILL_BACKGROUND_PROCESSES'],
	'Lcom/android/email/service/ImapService;-synchronizeMailboxSynchronous-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/Mailbox; Z Z)I' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/ui/FolderSelectionActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/effect/effects/BrightnessEffect;-release-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/view/RotationPolicy;-isRotationLocked-(Landroid/content/Context;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/provider/EmailProvider;-uiUpdateFolder-(Landroid/content/Context; Landroid/net/Uri; Landroid/content/ContentValues;)I' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/exchange/service/EasServerConnection;-makeUriString-(Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/server/wm/InputMonitor;-dispatchUnhandledKey-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)Landroid/view/KeyEvent;' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH'],
	'Lcom/android/bluetooth/hid/HidService;-setReport-(Landroid/bluetooth/BluetoothDevice; B Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/display/DisplayManagerService;-setWindowManager-(Lcom/android/server/display/DisplayManagerService$WindowManagerFuncs;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/QsbApplicationWrapper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-<init>-(Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS'],
	'Landroid/widget/CheckedTextView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupStepIndicatorView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-onStartCommand-(Landroid/content/Intent; I I)I' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/internal/telephony/PhoneProxy;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothPbap$Stub$Proxy;-getState-()I' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$WatchdogDisabledState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/email2/ui/MailActivityEmail;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-switchWaitingOrHoldingAndActive-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BrowserBookmarksPage;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/ConnectivityManager;-startUsingNetworkFeature-(I Ljava/lang/String;)I' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/ContrastFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/camera/crop/CropActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-getIMEI-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasOutboxSync;-requestSyncForMailboxes-(Landroid/accounts/Account; Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/am/ActivityStackSupervisor;-ensureActivitiesVisibleLocked-(Lcom/android/server/am/ActivityRecord; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/bluetooth/gatt/GattService;-sendNotification-(I Ljava/lang/String; I I Ljava/util/UUID; I Ljava/util/UUID; Z [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/location/GeofenceManager;-updateFences-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/GLRootView;-setContentPane-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/support/v7/widget/Space;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmInboundSmsHandler;-dispatchNormalMessage-(Lcom/android/internal/telephony/SmsMessageBase;)I' : ['android.permission.SEND_SMS', 'android.permission.WRITE_SMS', 'android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS', 'android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Landroid/content/SyncActivityTooManyDeletes;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/RotateImageView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/NetInitiatedActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/map/BluetoothMapContentObserver;-handleMsgListChangesMms-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/inputmethod/latin/LatinIME;-onFinishInputView-(Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/service/ImapService;-synchronizeMailboxGeneric-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/Mailbox; Z Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/media/WebVttRenderingWidget$SpanLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/CoreSettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/data/FilterTypeSet;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/VerticalTextSpinner;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardEntry$PostalData;-constructInsertOperation-(Ljava/util/List; I)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/nexus/NexusRS;-start-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-initialize-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/quicksearchbox/SuggestionCursorProvider;-getSuggestions-(Ljava/lang/String; I)Lcom/android/quicksearchbox/SuggestionCursor;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/sip/SipPhone$SipConnection$1;-onChanged-(Landroid/net/sip/SipAudioCall;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/text/method/QwertyKeyListener;-onKeyDown-(Landroid/view/View; Landroid/text/Editable; I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/location/ILocationManager;-setTestProviderStatus-(Ljava/lang/String; I Landroid/os/Bundle; J)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/app/PickerActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/CameraActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/UiAutomationConnection;-connect-(Landroid/accessibilityservice/IAccessibilityServiceClient;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/location/ILocationManager$Stub;-addGpsStatusListener-(Landroid/location/IGpsStatusListener; Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MusicBrowserActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/net/CaptivePortalTracker$NoActiveNetworkState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/content/MutableContextWrapper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/SyncRunner;-step-()I' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/deskclock/AlarmClockFragment$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/alerts/AlertService;-postNotification-(Lcom/android/calendar/alerts/AlertService$NotificationInfo; Ljava/lang/String; Landroid/content/Context; Z Lcom/android/calendar/alerts/AlertService$NotificationPrefs; Lcom/android/calendar/alerts/NotificationMgr; I)V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/research/FeedbackLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/magicsmoke/MagicSmokeSelector;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/os/BatteryStatsImpl;-getBluetoothPingCount-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/app/ManageCachePage$1;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/support/v4/widget/SlidingPaneLayout$AccessibilityDelegate;-performAccessibilityAction-(Landroid/view/View; I Landroid/os/Bundle;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/inputmethod/pinyin/ComposingView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/IsimFileHandler;-loadEFImgTransparent-(I I I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/eas/EasLoadAttachment;-handleResponse-(Lcom/android/exchange/EasResponse;)I' : ['android.permission.INTERNET', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/widget/SubtitleView;-setStyle-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/state/StatePanelTrack;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupStepIndicatorView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/view/ScrollerView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accounts/AccountManagerService;-checkManageAccountsPermission-()V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-onCleanUpAllConnections-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/DrawRectFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/event/EditEventView;-onRecurrenceSet-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub;-setRadio-(I Z)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/colorpicker/ColorPickerSwatch;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager;-getTetherableBluetoothRegexs-()[Ljava/lang/String;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/BackupManagerService;-prepareOperationTimeout-(I J Lcom/android/server/BackupManagerService$BackupRestoreTask;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/widget/SlidingDrawer;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccPhoneBookInterfaceManager;-getAdnRecordsInEf-(I)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_CONTACTS'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItem-()Z' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/app/Presentation$1;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/ContextThemeWrapper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/content/ContentService;-getPeriodicSyncs-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/util/List;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/widget/DigitalClock;-initClock-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/TrafficStats;-getDataLayerSnapshotForUid-(Landroid/content/Context;)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/ui/Switch;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService$SettingsObserver;-onChange-(Z Landroid/net/Uri;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/WideAnglePanoramaModule$7;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/TabScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/widget/RatingBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/Tab$3;-access$1700-(Lcom/android/browser/Tab$3; Z Landroid/os/Message;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/inputmethod/dictionarypack/DownloadOverMeteredDialog;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/ex/photo/PhotoViewActivity;-onLoadFinished-(Landroid/support/v4/content/Loader; Ljava/lang/Object;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/camera/PhotoModule;-onResumeAfterSuper-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/AsyncQueryServiceHelper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothHealth$Stub;-registerAppConfiguration-(Landroid/bluetooth/BluetoothHealthAppConfiguration; Landroid/bluetooth/IBluetoothHealthCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/LogTextBox;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothHealth;-disconnectChannel-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorSaturationView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onResume-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.READ_PROFILE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-sendEmergencyCallbackModeChange-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accessibilityservice/AccessibilityService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-access$800-(Lcom/android/server/net/NetworkPolicyManagerService;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/ex/photo/PhotoViewActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/TabActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/widget/sgv/StaggeredGridView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/FlipperDream;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/keyboard/EmojiPalettesView$DeleteKeyOnTouchListener$DummyRepeatKeyRepeatTimer;-run-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.VIBRATE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImagePoint;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/LeaveBehindItem;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-systemReady-()V' : ['android.permission.READ_PROFILE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/printspooler/NotificationController$NotificationBroadcastReceiver$1;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordFragment;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.WRITE_USER_DICTIONARY'],
	'Lcom/android/internal/widget/ActionBarContextView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/NavTabScroller;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/adapter/ItemOperationsParser;-parseFetch-()V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/internal/widget/multiwaveview/MultiWaveView;-onHoverEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/CountdownTimerPopup;-updateInputState-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/filtershow/crop/CropView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-connectSocket-(Landroid/bluetooth/BluetoothDevice; I Landroid/os/ParcelUuid; I I)Landroid/os/ParcelFileDescriptor;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/research/UploaderService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IActivityManager;-handleApplicationWtf-(Landroid/os/IBinder; Ljava/lang/String; Landroid/app/ApplicationErrorReport$CrashInfo;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/KeyboardView;-access$400-(Landroid/inputmethodservice/KeyboardView; Landroid/view/MotionEvent;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-getMmsMessage-(J Lcom/android/bluetooth/map/BluetoothMapAppParams;)[B' : ['android.permission.READ_CONTACTS', 'android.permission.READ_SMS'],
	'Lcom/android/mail/ui/SwipeableListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/EmailServiceUtils;-setupAccountManagerAccount-(Landroid/content/Context; Lcom/android/emailcommon/provider/Account; Z Z Z Landroid/accounts/AccountManagerCallback;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Landroid/filterpacks/base/InputStreamSource;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/app/DownloadManager;-addCompletedDownload-(Ljava/lang/String; Ljava/lang/String; Z Ljava/lang/String; Ljava/lang/String; J Z Z)J' : ['android.permission.INTERNET'],
	'Landroid/filterpacks/performance/ThroughputFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage;-onItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MusicBrowserActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/btservice/AdapterService;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/ComboAlbum;-reload-()J' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/btservice/ProfileService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/ClusterAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/dreams/phototable/PhotoTableDreamSettings;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/datetimepicker/date/YearPickerView;-onItemClick-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasFolderSync;-requestSyncForMailboxes-(Landroid/accounts/Account; Ljava/util/ArrayList;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordFragment;-updateSpinner-()V' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_PROFILE'],
	'Landroid/view/IApplicationToken$Stub;-windowsVisible-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/CommandsInterface;-getCdmaBroadcastConfig-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/BondStateMachine;-access$400-(Lcom/android/bluetooth/btservice/BondStateMachine; Landroid/bluetooth/BluetoothDevice; Z)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/quicksearchbox/ui/ClusteredSuggestionsView;-arrowScroll-(I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/TabActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/widget/CalendarAppWidgetModel;-populateDayInfo-(I Landroid/text/format/Time;)Lcom/android/calendar/widget/CalendarAppWidgetModel$DayInfo;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-dumpMmsTable-()V' : ['android.permission.READ_SMS'],
	'Lcom/android/mail/ui/AbstractActivityController;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/adapter/ItemOperationsParser;-parseResponse-()V' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/location/ILocationManager;-clearTestProviderEnabled-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE', 'android.permission.ACCESS_MOCK_LOCATION'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/research/FeedbackLayout;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-pushModify-(J)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/view/IWindowSession$Stub$Proxy;-prepareDrag-(Landroid/view/IWindow; I I I Landroid/view/Surface;)Landroid/os/IBinder;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-notifyDataConnectionFailed-(Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/BackupManagerService$BackupRestoreTask;-handleTimeout-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/support/v4/app/NoSaveStateFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/FilmstripPage;-onAlbumModeSelected-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/wifi/WifiService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.CHANGE_WIFI_MULTICAST_STATE', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/browser/BrowserBackupAgent;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/BitmapSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/preferences/BandwidthPreferencesFragment;-onResume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onSingleTapUp-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/adapter/AbstractSyncParser;-commandsParser-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Landroid/print/IPrintManager$Stub$Proxy;-stopPrinterDiscovery-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/activity/setup/MailboxSettings;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/TextServicesManagerService;-setCurrentSpellCheckerLocked-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/connectivity/Tethering$TetherMasterSM$TetherModeAliveState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/telephony/CommandsInterface;-explicitCallTransfer-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/TextServicesManagerService$TextServicesSettings;-getSelectedSpellCheckerSubtype-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothInputDevice;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/am/ActivityManagerService;-main-(I)Landroid/content/Context;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/RotateImageView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/crop/CropActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/FilmStripView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityStackSupervisor;-attachApplicationLocked-(Lcom/android/server/am/ProcessRecord; Z)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/month/SimpleDayPickerFragment;-updateMonthHighlight-(Landroid/widget/AbsListView;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/exchange/eas/EasOperation;-getRequestEntity-()Lorg/apache/http/HttpEntity;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryService;-dispatchBroadcast-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceCategoryProgramHandler;-handleSmsMessage-(Landroid/os/Message;)Z' : ['android.permission.RECEIVE_SMS'],
	'Lcom/android/mail/ui/SwipeableListView;-dismissChild-(Lcom/android/mail/browse/ConversationItemView;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/speech/tts/TextToSpeechService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/AudioService$AudioHandler;-cleanupPlayer-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-handleUp-(Landroid/view/MotionEvent;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/wallpaper/fall/FallWallpaper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/AlbumDataLoader$UpdateContent;-call-()Ljava/lang/Void;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/VibratorService;-doVibratorOff-()V' : ['android.permission.VIBRATE'],
	'Lcom/android/noisefield/NoiseField;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/ui/RenderOverlay$RenderView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AbsSpinner;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setSmscAddress-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/view/EventRedirectingFrameLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaSMSDispatcher;-sendRetrySms-(Lcom/android/internal/telephony/SMSDispatcher$SmsTracker;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/FilterEmptyPromptSet;-getCoverMediaItem-()Lcom/android/gallery3d/data/MediaItem;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-handleExitEmergencyCallbackMode-(Landroid/os/Message;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IActivityManager;-moveTaskToFront-(I I Landroid/os/Bundle;)V' : ['android.permission.REORDER_TASKS'],
	'Lcom/android/internal/telephony/RIL;-explicitCallTransfer-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/statusbar/IStatusBarService$Stub;-collapsePanels-()V' : ['android.permission.EXPAND_STATUS_BAR'],
	'Landroid/widget/PopupWindow$PopupViewContainer;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageCombineFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/InputStreamSource;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-doStop-(Landroid/content/Intent;)V' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/camera/ui/CountdownTimerPopup;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-setMasterSyncAutomatically-(Z)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/widget/TableLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/DeviceStorageMonitorService;-sendNotification-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageCrop;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-setDiscoverableTimeout-(I)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/SharpenFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/location/LocationManager;-isProviderEnabled-(Ljava/lang/String;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarController;-refreshCalendars-()V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/calculator2/ColorButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onTrySetupData-(Lcom/android/internal/telephony/dataconnection/ApnContext;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/content/SyncManager;-onUserStarting-(I)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-setUserData-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/TextServicesManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/magicsmoke/MagicSmoke;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/keychain/KeyChainActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/DatePicker;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/photos/views/HeaderGridView$FullWidthFixedViewLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/ITelephonyRegistry$Stub$Proxy;-notifySignalStrength-(Landroid/telephony/SignalStrength;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/service/Pop3AuthenticatorService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothAdapter;-startLeScan-(Landroid/bluetooth/BluetoothAdapter$LeScanCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/calendar/DayFragment;-onCreateView-(Landroid/view/LayoutInflater; Landroid/view/ViewGroup; Landroid/os/Bundle;)Landroid/view/View;' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/music/MediaPlaybackActivity$5;-onClick-(Landroid/view/View;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/photo/MailPhotoViewActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-getProtocolMode-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/inputmethod/latin/userdictionary/UserDictionaryAddWordContents;-getLocalesList-(Landroid/app/Activity;)Ljava/util/ArrayList;' : ['android.permission.READ_USER_DICTIONARY', 'android.permission.READ_PROFILE'],
	'Landroid/accounts/ChooseAccountActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-access$200-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppObexClientSession;-start-(Landroid/os/Handler; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/ui/DefaultSuggestionView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/Editor$InsertionHandleView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/CalendarSyncAdapterService$SyncAdapterImpl;-onPerformSync-(Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_CALENDAR'],
	'Landroid/preference/PreferenceFrameLayout;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ContextImpl$ApplicationContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/server/LocationManagerService$Receiver;-callStatusChangedLocked-(Ljava/lang/String; I Landroid/os/Bundle;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/CommandsInterface;-queryCallForwardStatus-(I I Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailsync/SyncManager;-canAutoSync-(Lcom/android/emailcommon/provider/Account;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/filterpacks/imageproc/LomoishFilter;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/location/GeofenceManager;-removeFence-(Ljava/lang/String;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DataConnection;-tearDownData-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/photos/views/HeaderGridView;-sequenceScroll-(I)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/PieController$2;-onClick-(Lcom/android/camera/ui/PieItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/music/MusicPicker;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/AbstractActivityController;-onRestoreInstanceState-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/compose/CcBccView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/CreatePlaylist;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/camera/ui/CheckedLinearLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/backup/LocalTransportService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/Contacts$ContactMethods;-addPostalLocation-(Landroid/content/Context; J D D)V' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/filterpacks/videosrc/SurfaceTextureSource;-performClose-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/browser/BaseUi$FullscreenHolder;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/TestActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/WifiStateMachine$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/QuickContactBadge;-assignContactFromEmail-(Ljava/lang/String; Z Landroid/os/Bundle;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/media/WebVttRenderer;-createTrack-(Landroid/media/MediaFormat;)Landroid/media/SubtitleTrack;' : ['android.permission.READ_PROFILE'],
	'Landroid/support/v4/view/PagerTabStrip$1;-onClick-(Landroid/view/View;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/photos/PhotoSetFragment;-onCreateLoader-(I Landroid/os/Bundle;)Landroid/content/Loader;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub$Proxy;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/base/OutputStreamTarget;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/os/storage/ExternalStorageFormatter;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IBackupAgent;-doFullBackup-(Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/app/Presentation$1;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/provider/CallLog$Calls;-getLastOutgoingCall-(Landroid/content/Context;)Ljava/lang/String;' : ['android.permission.READ_CALL_LOG'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/ui/EdgeView;-removeAllComponents-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestore-(Landroid/os/ParcelFileDescriptor; I Landroid/os/ParcelFileDescriptor; I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/datetimepicker/date/DatePickerDialog;-onYearSelected-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/NsdService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.INTERNET'],
	'Lcom/android/server/LockSettingsService;-getBoolean-(Ljava/lang/String; Z I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/service/wallpaper/WallpaperService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/IBatteryStats;-noteBluetoothOn-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/view/BasePieView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/net/NetworkPolicyManagerService;-updateNetworkRulesLocked-()V' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mail/ui/TwoPaneController;-registerDestructiveAction-(Lcom/android/mail/ui/DestructiveAction;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/sip/ISipService$Stub$Proxy;-setRegistrationListener-(Ljava/lang/String; Landroid/net/sip/ISipSessionListener;)V' : ['android.permission.USE_SIP'],
	'Lcom/android/internal/telephony/sip/SipPhone;-getPreferredNetworkType-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityStack;-activityPausedLocked-(Landroid/os/IBinder; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/calendar/CalendarController;-sendEventRelatedEvent-(Ljava/lang/Object; J J J J I I J)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorOpacityView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/FlipperDream;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/a2dp/A2dpService$BluetoothA2dpBinder;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothMap$Stub$Proxy;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/keyboard/KeyboardActionListener;-onCodeInput-(I I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/p2p/WifiP2pService$P2pStateMachine$DefaultState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/test/ActivityUnitTestCase$MockParent;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/fall/FallWallpaper;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/browser/AddNewBookmark;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/widget/TextTime;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/CheckBox;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/cat/CommandParamsFactory;-processSetUpIdleModeText-(Lcom/android/internal/telephony/cat/CommandDetails; Ljava/util/List;)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/accessibility/CaptioningManager;-getLocale-()Ljava/util/Locale;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/eas/EasSyncBase;-getRequestUri-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/inputmethod/latin/SubtypeSwitcher;-isShortcutImeEnabled-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/DictionarySettingsFragment;-onActivityCreated-(Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardComposer;-init-(Ljava/lang/String; [Ljava/lang/String;)Z' : ['android.permission.READ_CONTACTS'],
	'Landroid/filterpacks/imageproc/PosterizeFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/settings/DebugSettingsActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/Development;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-pollState-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/widget/RadioButton;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-invokeOemRilRequestRaw-([B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/os/IPowerManager$Stub$Proxy;-acquireWakeLock-(Landroid/os/IBinder; I Ljava/lang/String; Ljava/lang/String; Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/browse/ConversationWebView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/printspooler/PrintJobConfigActivity$CustomEditText;-shouldSpeakPasswordsForAccessibility-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-disableCellBroadcast-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Lcom/android/server/input/InputManagerService;-interceptKeyBeforeDispatching-(Lcom/android/server/input/InputWindowHandle; Landroid/view/KeyEvent; I)J' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Landroid/content/IContentService$Stub$Proxy;-getSyncStatus-(Landroid/accounts/Account; Ljava/lang/String;)Landroid/content/SyncStatusInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/phasebeam/PhaseBeamWallpaper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/LatinIME;-onStartInput-(Landroid/view/inputmethod/EditorInfo; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/datetimepicker/date/TextViewWithCircularIndicator;-access$800-(Landroid/widget/TextView;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/policy/impl/GlobalActions$GlobalActionsDialog;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/BookmarkSearch;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetooth;-enableNoAutoConnect-()Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/accounts/AccountManager;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryProvider;-deleteDataFile-(Landroid/net/Uri;)I' : ['android.permission.INTERNET'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageShow;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPicker;-onBackPressed-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/alarmclock/DigitalWidgetViewsFactory$RemoteWorldClockAdapter;-getView-(I Landroid/view/View; Landroid/view/ViewGroup;)Landroid/view/View;' : ['android.permission.READ_PROFILE'],
	'Landroid/app/backup/IBackupManager;-restoreAtInstall-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/MediaLinearLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/hdp/HealthService;-connectChannelToSink-(Landroid/bluetooth/BluetoothDevice; Landroid/bluetooth/BluetoothHealthAppConfiguration; I)Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/filterpacks/imageproc/AlphaBlendFilter;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/ColorChipView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/support/v4/view/ViewPager;-setPageTransformer-(Z Landroid/support/v4/view/ViewPager$PageTransformer;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/MessageScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/GridLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ActionableToastBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService$10;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/ui/AnimatedAdapter$4;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calculator2/CalculatorDisplay;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine$AudioOn;-processAudioEvent-(I Landroid/bluetooth/BluetoothDevice;)V' : ['android.permission.MODIFY_AUDIO_SETTINGS'],
	'Lcom/android/server/BatteryService$BatteryListener;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/deskclock/timer/TimerView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine;-<init>-(Landroid/content/Context; Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavigationBarTablet;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/time/TimePickerDialog$1;-onClick-(Landroid/view/View;)V' : ['android.permission.VIBRATE'],
	'Lcom/android/htmlviewer/HTMLViewerActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/sip/SipService$ConnectivityReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/MovieActivity$1;-access$800-(Lcom/android/gallery3d/app/MoviePlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/RotateFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/data/SecureAlbum;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/widget/TextClock;-access$000-(Landroid/widget/TextClock;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-requestLocationUpdates-(J F Landroid/location/Criteria; Landroid/location/LocationListener; Landroid/os/Looper;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/filterpacks/numeric/SinWaveFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothA2dp;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/policy/impl/ImmersiveModeConfirmation$ClingWindowView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/dreams/phototable/PhotoTableDream;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/CalendarController$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/ex/photo/PhotoViewPager;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/location/LocationBasedCountryDetector;-stop-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/content/SyncStorageEngine;-requestSync-(Landroid/accounts/Account; I I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/os/BatteryStatsImpl;-getCurrentBluetoothPingCount-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/camera/ui/CountdownTimerPopup$Listener;-onListPrefChanged-(Lcom/android/camera/ListPreference;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/BrowserBackupAgent;-onRestore-(Landroid/app/backup/BackupDataInput; I Landroid/os/ParcelFileDescriptor;)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/imageproc/ImageStitcher;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/notification/DemoContactNotificationScorer;-getScore-(Landroid/app/Notification; I)I' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/gallery3d/app/SinglePhotoPage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email/service/AttachmentDownloadService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppService;-createServerSession-(Ljavax/obex/ObexTransport;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCellInfoListRate-(I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/IMediaPlaybackService$Stub$Proxy;-setShuffleMode-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/SlotView$Listener;-onLongTap-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/camera/SecureCameraActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/photos/FullscreenViewer;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/widget/Editor$SelectionEndHandleView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageModified-(Ljava/lang/String;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/IActivityManager;-inputDispatchingTimedOut-(I Z Ljava/lang/String;)J' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/printspooler/FusedPrintersProvider;-setTrackedPrinter-(Landroid/print/PrinterId;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BackupManagerService$PerformFullBackupTask;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/ui/FolderSelectionDialog;-onListItemClick-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/BackupManagerService$PerformFullRestoreTask$RestoreFileRunnable;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/accounts/IAccountManager;-getPassword-(Landroid/accounts/Account;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/server/connectivity/PacManager$1;-run-()V' : ['android.permission.INTERNET'],
	'Lcom/android/internal/widget/DialogTitle;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/TabHost;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/AllInOneActivity;-initFragments-(J I Landroid/os/Bundle;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/bluetooth/opp/BluetoothOppLiveFolder;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-getCurrentDeviceName-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/development/AppHwPref;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/videoeditor/OverlayTitleEditor;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/event/AttendeesView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavTabScroller;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/widget/TextTime;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothA2dp;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/gatt/GattService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/ImageView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/InLineSettingItem;-changeIndex-(I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/service/EasService$RestartPingsTask;-doInBackground-([Ljava/lang/Void;)Ljava/lang/Void;' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-saveConfiguration-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/vcard/VCardEntry;-toString-()Ljava/lang/String;' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/media/AudioService;-restoreMasterVolume-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/app/ResolverActivity;-onCreate-(Landroid/os/Bundle; Landroid/content/Intent; Ljava/lang/CharSequence; [Landroid/content/Intent; Ljava/util/List; Z)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-beginReliableWrite-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/browse/MessageHeaderView;-onMenuItemClick-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/bluetooth/IBluetooth;-isDiscovering-()Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/alerts/AlertActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-configHciSnoopLog-(Z)Z' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/base/FrameFetch;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/sip/SipPhone;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneNotifier; Landroid/net/sip/SipProfile;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/wifi/WifiService;-getWifiServiceMessenger-()Landroid/os/Messenger;' : ['android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/email/service/LegacyEasAuthenticatorService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/MediaPlaybackActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PickerActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-setAlphabetShiftLockShiftedKeyboard-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationCursor$2;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/browse/MailWebView;-onScrollChanged-(I I I I)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/test/IsolatedContext$MockAccountManager;-setAuthToken-(Landroid/accounts/Account; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/content/PackageMonitor;-onPackageChanged-(Ljava/lang/String; I [Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/ContactsSyncAdapterService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-addIncludedService-(I I I Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH'],
	'Landroid/net/wifi/SupplicantStateTracker$DefaultState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Lcom/android/server/am/ActiveServices;-killServicesLocked-(Lcom/android/server/am/ProcessRecord; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/browse/SelectedConversationsActionMenu;-onSetEmpty-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/exchange/EasCertificateRequestor;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DayView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/server/BluetoothManagerService$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/net/DhcpStateMachine$WaitBeforeRenewalState;-exit-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/view/CertificateSelector;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-loadAttachment-(Lcom/android/emailcommon/service/IEmailServiceCallback; J J Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Landroid/view/ViewStub;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothHeadset;-startVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/net/NetworkStatsService;-getDataLayerSnapshotForUid-(I)Landroid/net/NetworkStats;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralWallpaper$RenderScriptEngine;-updateSurface-(Z Z Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/server/am/ActivityManagerService;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/EditEventView;-access$500-(Lcom/android/calendar/event/EditEventView;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/inputmethod/keyboard/KeyboardSwitcher;-onReleaseKey-(I Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/sip/SipPhone;-dialInternal-(Ljava/lang/String;)Lcom/android/internal/telephony/Connection;' : ['android.permission.USE_SIP'],
	'Lcom/android/browser/NavScreen$1;-onRemovePosition-(I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mail/ui/RecentFolderList$1;-onChanged-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-setPasskey-(Landroid/bluetooth/BluetoothDevice; Z I [B)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/pinyin/PinyinDecoderService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/DayView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/service/AttachmentDownloadService;-watchdogAlarm-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.GET_ACCOUNTS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mail/ui/AbstractActivityController;-onViewModeChanged-(I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/email/activity/setup/AccountSetupBasics;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/adapter/ContactsSyncParser;-changeParser-(Lcom/android/exchange/adapter/ContactsSyncParser$ContactOperations;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/widget/Editor$SelectionStartHandleView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wm/WindowAnimator$1;-run-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MusicPicker;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isTetheringSupported-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/mail/ui/ActivityController;-onAnimationEnd-(Lcom/android/mail/ui/AnimatedAdapter;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/dataconnection/DcTrackerBase;-notifyOffApnsOfAvailability-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/content/SyncManager;-maybeRescheduleSync-(Landroid/content/SyncResult; Lcom/android/server/content/SyncOperation;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-onCancelled-(Ljava/lang/Object;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/dreams/phototable/PhotoTableDream;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/IAudioService$Stub$Proxy;-reloadAudioSettings-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$IndicatorView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/SwipeableListView;-performItemClick-(Landroid/view/View; I J)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/accessibility/TouchExplorer;-clear-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/camera/ui/InLineSettingMenu;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/app/Activity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email/service/AccountService;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/service/EasAutoDiscover;-sendMessage-(Lcom/android/emailcommon/provider/Account; Lcom/android/emailcommon/provider/EmailContent$Message;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-processPendingRadioPowerOffAfterDataOff-()Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetoothMap$Stub;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Landroid/speech/tts/TextToSpeech$Connection$SetupConnectionAsyncTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.READ_PROFILE'],
	'Lcom/google/common/io/CharStreams;-readFirstLine-(Lcom/google/common/io/InputSupplier;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/server/location/GpsLocationProvider$2;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/camera/ui/CameraControls;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/media/MediaScannerClient;-scanFile-(Ljava/lang/String; J J Z Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/CreatePlaylist;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/packageinstaller/PackageInstallerActivity;-onCreate-(Landroid/os/Bundle;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageRotate;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/IccProvider;-delete-(Landroid/net/Uri; Ljava/lang/String; [Ljava/lang/String;)I' : ['android.permission.WRITE_CONTACTS'],
	'Landroid/bluetooth/IBluetoothGatt$Stub$Proxy;-sendNotification-(I Ljava/lang/String; I I Landroid/os/ParcelUuid; I Landroid/os/ParcelUuid; Z [B)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/email/service/AccountService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/accounts/IAccountManager;-removeAccount-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/datetimepicker/date/DayPickerView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/EmptyConversationListView;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/info/HistogramView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/SystemAllowGeolocationOrigins;-getSystemSetting-()Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/DeleteItems;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/inputmethod/dictionarypack/WordListPreference;-disableDict-()V' : ['android.permission.INTERNET'],
	'Lcom/android/browser/TabBar$TabView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hdp/HealthService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/mail/ui/ConversationSyncDisabledTipView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/AlbumPicker;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/MediaSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/CalendarSettingsActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/AutoFixFilter;-open-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccounts-(Ljava/lang/String;)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Lcom/android/development/LogViewer;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ImageSlicer;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/exchange/eas/EasPing;-makeRequest-()Lorg/apache/http/client/methods/HttpUriRequest;' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_CONTACTS', 'android.permission.READ_PHONE_STATE'],
	'Landroid/widget/RelativeLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/a2dp/A2dpStateMachine;-getDevicesMatchingConnectionStates-([I)Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/power/PowerManagerService;-applyWakeLockFlagsOnAcquireLocked-(Lcom/android/server/power/PowerManagerService$WakeLock;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onResetDone-(Landroid/os/AsyncResult;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/latin/suggestions/SuggestionStripView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/ui/AbstractActivityController;-requestFolderRefresh-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-onContentDirty-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/content/IContentService$Stub;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/music/MediaPlaybackService;-removeTracksInternal-(I I)I' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/providers/downloads/ui/TrampolineActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/effect/effects/AutoFixEffect;-apply-(I I I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/service/Pop3AuthenticatorService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperPreview;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/music/CreatePlaylist;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/app/ResolverActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/browse/SwipeableConversationItemView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/WallpaperManagerService$MyPackageMonitor;-onPackageDisappeared-(Ljava/lang/String; I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GsmMmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/videoeditor/widgets/TimelineRelativeLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/content/SyncStorageEngine;-clearAndReadState-()V' : ['android.permission.WAKE_LOCK', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Landroid/bluetooth/BluetoothAdapter;-startAdvertising-(Landroid/bluetooth/BluetoothAdapter$AdvertiseCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/timezonepicker/TimeZoneData;-<init>-(Landroid/content/Context; Ljava/lang/String; J)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/IConnectivityManager$Stub;-getAllNetworkInfo-()[Landroid/net/NetworkInfo;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/server/TextServicesManagerService$TextServicesMonitor;-onSomePackagesChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/vcard/VCardParserImpl_V21;-parseItems-()V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/mail/ui/AbstractConversationViewFragment$MessageLoaderCallbacks;-onLoadFinished-(Landroid/content/Loader; Lcom/android/mail/content/ObjectCursor;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/content/IContentService$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_SYNC_STATS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/browser/DeviceAccountLogin;-handleLogin-(Ljava/lang/String; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/mail/ui/OnePaneController;-access$2800-(Lcom/android/mail/ui/AbstractActivityController; Lcom/android/mail/content/ObjectCursor;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-onProfileConnectionStateChanged-(Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/mail/ui/AbstractActivityController;-switchToDefaultInboxOrChangeAccount-(Lcom/android/mail/providers/Account;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager;-enableNetwork-(I Z)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/inputmethodservice/ExtractEditLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/event/AttendeesView;-access$100-(Lcom/android/calendar/event/AttendeesView; Lcom/android/calendar/event/EditEventHelper$AttendeeItem;)Landroid/view/View;' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/email/EmailApplication;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/media/WebVttRenderingWidget$CueLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/TwoPaneController;-loadAccountInbox-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/svox/pico/DownloadVoiceData;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/SecureCameraActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker$2;-onChange-(Z)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/data/ClusterAlbum$2;-consume-(I Lcom/android/gallery3d/data/MediaItem;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/view/menu/ActionMenuPresenter$OverflowMenuButton;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/BatteryStatsService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/browser/AddBookmarkPage$EditBookmarkInfoLoader;-loadInBackground-()Ljava/lang/Object;' : ['com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/BluetoothManagerService;-access$1800-(Lcom/android/server/BluetoothManagerService; Z)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/display/DisplayManagerService;-setInputManager-(Lcom/android/server/display/DisplayManagerService$InputManagerFuncs;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EventColorPickerDialog;-onCreateDialog-(Landroid/os/Bundle;)Landroid/app/Dialog;' : ['android.permission.READ_CALENDAR'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendActionDownAndUp-(Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/btservice/AdapterService;-access$100-(Lcom/android/bluetooth/btservice/AdapterService; Landroid/bluetooth/BluetoothDevice; I I I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/data/SnailSource;-createMediaObject-(Lcom/android/gallery3d/data/Path;)Lcom/android/gallery3d/data/MediaObject;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/TabBar;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/app/ReceiverRestrictedContext;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/EasSyncService;-messageMoveRequest-(Lcom/android/exchange/MessageMoveRequest;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiStateMachine$DriverStartingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-setTTYMode-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/grass/GrassWallpaper;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/ToRGBFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GsmCellBroadcastHandler;-<init>-(Landroid/content/Context; Lcom/android/internal/telephony/PhoneBase;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/pinyin/CandidateView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/MailLogService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/gatt/GattService;-readDescriptor-(I Ljava/lang/String; I I Ljava/util/UUID; I Ljava/util/UUID; I Ljava/util/UUID; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/latin/settings/SettingsActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/wifi/WifiController;-initializeAndRegisterForSettingsChange-(Landroid/os/Looper;)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/browser/NavScreen;-openNewTab-()V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/musicvis/vis3/Visualization3;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/email2/ui/MailActivityEmail;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/photo/PhotoViewActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/UiModeManagerService;-sendConfigurationAndStartDreamOrDockAppLocked-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-handleEctIncallSupplementaryService-(Ljava/lang/String;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-setSenderName-(Lcom/android/bluetooth/map/BluetoothMapMessageListingElement; Landroid/database/Cursor; Lcom/android/bluetooth/map/BluetoothMapContent$FilterInfo; Lcom/android/bluetooth/map/BluetoothMapAppParams;)V' : ['android.permission.READ_CONTACTS'],
	'Landroid/net/wifi/WifiStateMachine$DisconnectingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/btservice/AdapterService;-autoConnectA2dp-()V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-onSignalStrengthResult-(Landroid/os/AsyncResult; Z)Z' : ['android.permission.BROADCAST_STICKY', 'android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/ui/SlotView$MyGestureListener;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/settings/GallerySettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String; Ljava/lang/String; Lcom/android/internal/telephony/PhoneConstants$DataState;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/datetimepicker/time/RadialTextsView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/CreateShortcutActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/ex/chips/RecipientEditTextView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-<init>-(J Z)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/camera/PanoProgressBar;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/datetimepicker/date/DayPickerView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/emailcommon/service/IEmailService;-deleteAccountPIMData-(Ljava/lang/String;)V' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/internal/widget/multiwaveview/GlowPadView;-trySwitchToFirstTouchState-(F F)Z' : ['android.permission.VIBRATE', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/LockPatternUtils;-clearLock-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/CalendarController;-sendEventRelatedEventWithExtraWithTitleWithCalendarId-(Ljava/lang/Object; J J J J I I J J Ljava/lang/String; J)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/location/LocationManager;-getLastKnownLocation-(Ljava/lang/String;)Landroid/location/Location;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-releaseMulticastLock-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Landroid/app/IWallpaperManager;-setWallpaper-(Ljava/lang/String;)Landroid/os/ParcelFileDescriptor;' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferActivity;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupType;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-startScan-(I Z)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/server/net/NetworkStatsService$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/EmailConnectivityManager;-waitForConnectivity-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/data/ComboAlbumSet;-enumerateMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/inputmethod/dictionarypack/UpdateHandler;-tryUpdate-(Landroid/content/Context; Z)Z' : ['android.permission.INTERNET'],
	'Landroid/widget/RemoteViewsAdapter$RemoteViewsFrameLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/NsdService$NsdStateMachine$EnabledState;-enter-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/display/DisplayManagerService;-access$1400-(Lcom/android/server/display/DisplayManagerService; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/ui/InLineSettingMenu;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView$2;-onPrepared-(Landroid/media/MediaPlayer;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/BookmarkSearch;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/compose/CcBccView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/inputmethodservice/AbstractInputMethodService;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pbap/BluetoothPbapService;-setState-(I)V' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/os/Vibrator;-vibrate-(J)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/sip/SipService$SipSessionGroupExt;-onConnectivityChanged-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/soundrecorder/Recorder;-startPlayback-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/pm/PackageManagerService;-access$4100-(Lcom/android/server/pm/PackageManagerService; Ljava/lang/String; I I)I' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/gadget/WidgetSource;-reload-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppIncomingFileConfirmActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/google/android/mms/pdu/PduPersister;-loadRecipients-(I Ljava/util/HashSet; Ljava/util/HashMap; Z)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/compose/EmptyService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/base/NullFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/gallery3d/ui/AlbumSlidingWindow;-setActiveWindow-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/development/ProcessInfo;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/ui/PhotoView;-switchToHitPicture-(I I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/exchange/EasOutboxService;-acknowledgeProvisionImpl-(Lcom/android/exchange/EasSyncService; Ljava/lang/String; Ljava/lang/String; Z)Ljava/lang/String;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/am/ActivityManagerService;-crashApplication-(Lcom/android/server/am/ProcessRecord; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/UsimFileHandler;-loadEFLinearFixedAll-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity$1;-onClick-(Landroid/view/View;)V' : ['android.permission.REORDER_TASKS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-stopVoiceRecognition-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/inputmethod/dictionarypack/DictionaryDownloadProgressBar;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/agenda/AgendaListView$1;-run-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/exchange/ExchangeService;-startServiceThread-(Lcom/android/emailsync/AbstractSyncService;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/PasswordEntryKeyboardHelper;-handleShift-()V' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/hfp/HeadsetStateMachine;-access$5200-(Lcom/android/bluetooth/hfp/HeadsetStateMachine; Ljava/lang/String;)V' : ['android.permission.READ_CALL_LOG'],
	'Lcom/android/bluetooth/map/BluetoothMapContent;-msgListingHasUnread-(Ljava/lang/String; Lcom/android/bluetooth/map/BluetoothMapAppParams;)Z' : ['android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Lcom/android/calendar/month/MonthWeekEventsView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-hangupForegroundResumeBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ConversationPhotoTeaserView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/RIL;-iccIOForApp-(I I Ljava/lang/String; I I I Ljava/lang/String; Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ListActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterfw/core/SyncRunner;-processFilterNode-(Landroid/filterfw/core/Filter;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/browser/AddBookmarkPage;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/sip/SipManager;-isRegistered-(Ljava/lang/String;)Z' : ['android.permission.USE_SIP'],
	'Lcom/android/inputmethod/keyboard/internal/ScrollKeyboardView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethod/latin/InputView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-access$1300-(Lcom/android/server/LocationManagerService; Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/BackupManagerService$PerformBackupTask;-finalizeBackup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/MediaFocusControl;-filterVoiceInputKeyEvent-(Landroid/view/KeyEvent; Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/app/ResolverActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/widget/SubtitleView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/media/AudioService$SettingsObserver;-onChange-(Z)V' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothTetheringDataTracker;-startMonitoring-(Landroid/content/Context; Landroid/os/Handler;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/gsm/GsmServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/filterpacks/performance/ThroughputFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/AlbumPage$4;-onLongTap-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/calendar/alerts/QuickResponseActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/calendar/recurrencepicker/RecurrencePickerDialog;-onItemSelected-(Landroid/widget/AdapterView; Landroid/view/View; I J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/latin/LatinIME;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/power/ShutdownThread;-beginShutdownSequence-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/app/backup/BackupAgentHelper;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-deleteAndCreatePhone-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/emailcommon/service/PolicyServiceProxy;-isActive-(Landroid/content/Context; Lcom/android/emailcommon/provider/Policy;)Z' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/musicvis/vis3/Visualization3;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TableLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/widget/LockPatternUtils;-getActivePasswordQuality-()I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/keyboard/internal/KeyboardState;-onPressKey-(I Z I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/widget/LockPatternUtils;-setBiometricWeakLivelinessEnabled-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/widgets/TimelineHorizontalScrollView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DateTimeView$1;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/SearchActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/CommandsInterface;-reportSmsMemoryStatus-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/FrameSource;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/accessibility/CaptioningManager;-notifyFontScaleChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/DialogPicker;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/text/StringLogger;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NsdService;-create-(Landroid/content/Context;)Lcom/android/server/NsdService;' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/TouchExplorer$DoubleTapDetector;-onMotionEvent-(Landroid/view/MotionEvent; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/compose/ComposeActivity$SendOrSaveTask;-run-()V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_CONTACTS'],
	'Landroid/app/IActivityManager;-handleApplicationCrash-(Landroid/os/IBinder; Landroid/app/ApplicationErrorReport$CrashInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Landroid/location/LocationManager;-getProviders-(Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/TextServicesManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AnalogClock;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/accessibility/TouchExplorer;-access$3000-(Lcom/android/server/accessibility/TouchExplorer; Landroid/view/MotionEvent; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/FixedRotationFilter;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getProfileConnectionState-(I)I' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/ToGrayFilter;-performProcess-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/email/activity/setup/AccountSetupIncomingFragment;-setCallback-(Lcom/android/email/activity/setup/AccountServerBaseFragment$Callback;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/tts/compat/CompatTtsService;-getSettingsLocale-()[Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-doVisibilityChanged-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/dreams/phototable/CursorPhotoSource;-fillQueue-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/filterpacks/imageproc/StraightenFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MusicBrowserActivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-enumerateTotalMediaItems-(Lcom/android/gallery3d/data/MediaSet$ItemConsumer; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMALTEPhone;-initSstIcc-()V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/server/accessibility/ScreenMagnifier$DetectingStateHandler;-sendDelayedMotionEvents-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/NumberPicker$CustomEditText;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-killApplicationWithAppId-(Ljava/lang/String; I Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/server/usb/UsbDeviceManager$UsbHandler;-updateAudioSourceFunction-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/IConnectivityManager$Stub$Proxy;-isNetworkSupported-(I)Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorValueView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/pm/PackageManagerService;-replacePackageLI-(Landroid/content/pm/PackageParser$Package; I I Landroid/os/UserHandle; Ljava/lang/String; Lcom/android/server/pm/PackageManagerService$PackageInstalledInfo;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/inputmethod/keyboard/EmojiPalettesView;-startEmojiPalettes-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/ui/AbstractActivityController$18;-onPostExecute-(Lcom/android/mail/providers/Folder;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/musicvis/vis2/Visualization2;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/widget/TabHost;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/InputMethodManagerService;-showInputMethodMenu-()V' : ['android.permission.READ_PROFILE'],
	'Landroid/app/DownloadManager;-getUriForDownloadedFile-(J)Landroid/net/Uri;' : ['android.permission.INTERNET'],
	'Lcom/android/server/am/BroadcastQueue;-setBroadcastTimeoutLocked-(J)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/camera/PhotoModule;-onSharedPreferenceChanged-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/am/BatteryStatsService;-setBatteryState-(I I I I I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/support/v4/print/PrintHelperKitkat;-printBitmap-(Ljava/lang/String; Landroid/net/Uri;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/BackupManagerService;-bindToAgentSynchronous-(Landroid/content/pm/ApplicationInfo; I)Landroid/app/IBackupAgent;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/net/wifi/WifiManager;-disconnect-()Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/am/NativeCrashListener$NativeCrashReporter;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-initializeHdmiState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/hardware/location/GeofenceHardwareService$1;-resumeGeofence-(I I I)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/sip/SipPhone;-sendBurstDtmf-(Ljava/lang/String; I I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/hardware/location/GeofenceHardwareService$1;-unregisterForMonitorStateChangeCallback-(I Landroid/hardware/location/IGeofenceHardwareMonitorCallback;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/IccSmsInterfaceManager;-copyMessageToIccEf-(Ljava/lang/String; I [B [B)Z' : ['android.permission.WAKE_LOCK', 'android.permission.SEND_SMS', 'android.permission.RECEIVE_SMS'],
	'Landroid/filterpacks/imageproc/ImageEncoder;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-getMsisdn-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/filtershow/crop/CropView;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/service/ApiService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/pinyin/BalloonHint$BalloonView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/CheckedTextView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calculator2/CalculatorViewPager;-executeKeyEvent-(Landroid/view/KeyEvent;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/LocationManagerService;-loadProvidersLocked-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ui/PhotoView$MyGestureListener;-onSingleTapUp-(F F)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/opp/BluetoothOppTransferHistory$1;-onClick-(Landroid/content/DialogInterface; I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/sip/SipService$SipKeepAliveProcessCallback;-onResponse-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/EllipsizedMultilineTextView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/SearchActivity;-onQueryTextSubmit-(Ljava/lang/String;)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/galaxy4/Galaxy4;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/hfp/HeadsetService$BluetoothHeadsetBinder;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/content/IIntentReceiver$Stub;-performReceive-(Landroid/content/Intent; I Ljava/lang/String; Landroid/os/Bundle; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/location/ILocationManager$Stub;-getProviders-(Landroid/location/Criteria; Z)Ljava/util/List;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/AlarmManagerService;-setTimeZone-(Ljava/lang/String;)V' : ['android.permission.SET_TIME_ZONE'],
	'Lcom/android/email/activity/setup/AccountSettingsFragment;-onPause-()V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Landroid/net/wifi/WifiWatchdogStateMachine$VerifyingLinkState;-exit-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.CHANGE_NETWORK_STATE'],
	'Landroid/net/wifi/WifiStateMachine;-stopDhcp-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/pan/PanService;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.BLUETOOTH', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetooth$Stub$Proxy;-getAddress-()Ljava/lang/String;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/net/LockdownVpnTracker;-reset-()V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/magicsmoke/MagicSmoke;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/email/activity/setup/AccountSetupOptions;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-isEnabled-()Z' : ['android.permission.BLUETOOTH'],
	'Landroid/accounts/IAccountManager$Stub$Proxy;-getAccountsAsUser-(Ljava/lang/String; I)[Landroid/accounts/Account;' : ['android.permission.GET_ACCOUNTS'],
	'Landroid/widget/SpellChecker;-<init>-(Landroid/widget/TextView;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/DocumentaryFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/media/WebVttRenderingWidget$SpanLayout;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/PowerManagerService;-access$2100-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/server/am/ActivityManagerService;-goingToSleep-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/ui/PhotoFallbackEffect$PositionProvider;-getItemIndex-(Lcom/android/gallery3d/data/Path;)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperPreview;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/hfp/HeadsetService;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/bluetooth/btservice/AdapterService;-getDiscoverableTimeout-()I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/data/DataManager;-rotate-(Lcom/android/gallery3d/data/Path; I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/gallery3d/ingest/IngestService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/view/accessibility/CaptioningManager;-notifyUserStyleChanged-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/LocationManagerService;-removeUpdatesLocked-(Lcom/android/server/LocationManagerService$Receiver;)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationPagerController;-show-(Lcom/android/mail/providers/Account; Lcom/android/mail/providers/Folder; Lcom/android/mail/providers/Conversation; Z)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/app/TrimVideo;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/PhoneProxy;-setCdmaRoamingPreference-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ingest/IngestActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/SearchActivity;-onNewIntent-(Landroid/content/Intent;)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/musicvis/vis1/Visualization1;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/inputmethodservice/InputMethodService;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/pm/PackageManagerService;-loadMediaPackages-(Ljava/util/HashMap; [I Ljava/util/HashSet;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/mail/ui/AbstractActivityController$ConversationAction;-performAction-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/wallpaper/galaxy/GalaxyView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/widget/ILockSettings$Stub;-getString-(Ljava/lang/String; Ljava/lang/String; I)Ljava/lang/String;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/ConversationItemView;-bind-(Lcom/android/mail/browse/ConversationItemViewModel; Lcom/android/mail/ui/ControllableActivity; Lcom/android/mail/ui/AnimatedAdapter$ConversationListListener; Lcom/android/mail/browse/ConversationItemView$ConversationItemAreaClickListener; Lcom/android/mail/ui/ConversationSelectionSet; Lcom/android/mail/providers/Folder; I Z Z Z Z Z Lcom/android/mail/ui/AnimatedAdapter; I Landroid/graphics/Bitmap;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/ScreensaverActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/a2dp/A2dpService;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/map/BluetoothMapService$BluetoothMapBinder;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Lcom/android/server/print/PrintManagerService;-stopPrinterStateTracking-(Landroid/print/PrinterId; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/selectcalendars/CalendarColorSquare;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/ex/photo/PhotoViewPager;-setAdapter-(Landroid/support/v4/view/PagerAdapter;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/colorpicker/ColorPickerSwatch$OnColorSelectedListener;-onColorSelected-(I)V' : ['android.permission.WRITE_CALENDAR'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageRedEye;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/NativeDaemonConnector;-run-()V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/gallery3d/ui/SlideshowView;-dispatchTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/browser/NavTabScroller;-onLayout-(Z I I I I)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/bluetooth/opp/BluetoothOppBtErrorActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothGatt$Stub;-discoverServices-(I Ljava/lang/String;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/browse/ConversationPager;-setPageTransformer-(Z Landroid/support/v4/view/ViewPager$PageTransformer;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/server/accessibility/TouchExplorer;-sendHoverExitAndTouchExplorationGestureEndIfNeeded-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/MailActivity;-stopDragMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/mail/compose/AttachmentsView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/filterpacks/base/NullFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-getDataCallList-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/ui/ButteryProgressBar;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/BluetoothPbap;-finalize-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/videosink/MediaEncoderFilter;-transferInputFrames-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/content/ContentService;-getCurrentSyncs-()Ljava/util/List;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/gallery3d/filtershow/state/StateView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/PopImapSyncAdapterService;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/widgets/TimelineRelativeLayout;-playSoundEffect-(I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/text/format/DateUtils;-getRelativeTimeSpanString-(J)Ljava/lang/CharSequence;' : ['android.permission.READ_PROFILE'],
	'Landroid/net/sip/ISipService$Stub;-close-(Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK', 'android.permission.USE_SIP'],
	'Landroid/view/WindowManagerPolicy$WindowManagerFuncs;-reevaluateStatusBarVisibility-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ReceiverRestrictedContext;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/PhoneSubInfo;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.READ_PHONE_STATE'],
	'Landroid/os/IPowerManager$Stub$Proxy;-setStayOnSetting-(I)V' : ['android.permission.WRITE_SETTINGS'],
	'Lcom/android/exchange/eas/EasSyncBase;-handleResponse-(Lcom/android/exchange/EasResponse;)I' : ['android.permission.WRITE_CONTACTS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR', 'android.permission.READ_CONTACTS'],
	'Landroid/widget/TextClock;-chooseFormat-(Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/providers/downloads/ui/TrampolineActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/ISms$Stub;-getAllMessagesFromIccEf-(Ljava/lang/String;)Ljava/util/List;' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_SMS'],
	'Landroid/accounts/GrantCredentialsPermissionActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/SlideshowPage;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/view/menu/IconMenuItemView;-sendOnTextChanged-(Ljava/lang/CharSequence; I I I)V' : ['android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiStateMachine$DriverStoppedState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/emailsync/SyncManager;-checkMailboxes-()J' : ['android.permission.WAKE_LOCK', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CALENDAR', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/mail/ui/AbstractMailActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/emailcommon/utility/CertificateRequestor;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter;-moveTo-(I)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/ServiceStateTracker;-updatePhoneObject-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/browser/PhoneUi;-hideNavScreen-(I Z)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/server/content/ContentService;-getMasterSyncAutomatically-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/wifi/IWifiManager$Stub$Proxy;-removeNetwork-(I)Z' : ['android.permission.CHANGE_WIFI_STATE'],
	'Landroid/support/v4/view/accessibility/AccessibilityNodeProviderCompat$AccessibilityNodeProviderKitKatImpl$1;-performAction-(I I Landroid/os/Bundle;)Z' : ['android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/BaseUi;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/mail/browse/ConversationItemView;-toggleSelectedState-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/calendar/EventInfoActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/IBluetoothHealth;-getConnectedHealthDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/Invert;-performTearDown-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/MmiCode;-cancel-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/map/BluetoothMapService;-closeService-()V' : ['android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_SMS'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-setProtocolMode-(Landroid/bluetooth/BluetoothDevice; I)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/wallpaper/grass/GrassView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSettings;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager;-pingSupplicant-()Z' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/calendar/CalendarController;-sendEvent-(Ljava/lang/Object; J Landroid/text/format/Time; Landroid/text/format/Time; J I)V' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Lcom/android/browser/ActivityController;-onContextItemSelected-(Landroid/view/MenuItem;)Z' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyNetworkDepersonalization-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/VideoView;-onKeyDown-(I Landroid/view/KeyEvent;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/VibratorService;-doVibratorOn-(J I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/email/activity/setup/AccountSettings;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/inputmethod/dictionarypack/WordListPreference$OnActionButtonClick;-onClick-(Landroid/view/View;)V' : ['android.permission.INTERNET'],
	'Lcom/android/email/provider/EmailProvider;-dump-(Ljava/io/FileDescriptor; Ljava/io/PrintWriter; [Ljava/lang/String;)V' : ['android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/server/power/PowerManagerService;-access$1600-(Lcom/android/server/power/PowerManagerService;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Landroid/net/wifi/WifiApConfigStore$InactiveState;-enter-()V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.CHANGE_WIFI_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH', 'android.permission.READ_PROFILE', 'android.permission.BLUETOOTH_ADMIN'],
	'Landroid/hardware/location/GeofenceHardwareImpl;-access$100-(Landroid/hardware/location/GeofenceHardwareImpl;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventView;-setTime-(Landroid/widget/TextView; J)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/LegacyImapSyncAdapterService;-access$000-(Landroid/content/Context; Landroid/accounts/Account; Landroid/os/Bundle; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/printspooler/FusedPrintersProvider;-onReset-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/wallpaper/walkaround/WalkAroundWallpaper$WalkAroundEngine;-onVisibilityChanged-(Z)V' : ['android.permission.CAMERA'],
	'Lcom/android/email/service/AuthenticatorService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/bluetooth/opp/BluetoothOppLauncherActivity$2;-run-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/server/InputMethodManagerService;-switchToNextInputMethod-(Landroid/os/IBinder; Z)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/widgets/AudioTrackView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/development/InstrumentationList;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/videoeditor/service/ApiService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterpacks/imageproc/ResizeFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/PhotoUI$7;-onCancel-(Landroid/content/DialogInterface;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.WAKE_LOCK', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/widget/ActionBarContainer;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/ui/SearchActivityViewSinglePane;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/commands/svc/WifiCommand;-run-([Ljava/lang/String;)V' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/inputmethod/latin/setup/SetupStartIndicatorView$LabelView;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/app/BatchService;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/app/TrimControllerOverlay;-onClick-(Landroid/view/View;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/service/dreams/DreamService;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/bluetooth/BluetoothHeadset;-close-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/BluetoothAdapter;-disable-()Z' : ['android.permission.BLUETOOTH', 'android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/PhoneBase;-restoreSavedNetworkSelection-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/Spinner;-performItemClick-(Landroid/view/View; I J)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/AttachmentDownloadService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/gallery3d/ui/GestureRecognizer$MyGestureListener;-onSingleTapUp-(Landroid/view/MotionEvent;)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/provider/Settings$System;-getLongForUser-(Landroid/content/ContentResolver; Ljava/lang/String; I)J' : ['android.permission.READ_PROFILE'],
	'Lcom/android/quicksearchbox/ui/CorpusView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/test/mock/MockContentResolver;-getCurrentSync-()Landroid/content/SyncInfo;' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/gallery3d/gadget/WidgetTypeChooser;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/exchange/ExchangeBroadcastReceiver;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/gallery3d/data/LocalAlbumSet;-delete-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CdmaLteServiceStateTracker;-setPowerStateToDesired-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/IWifiManager;-initializeMulticastFiltering-()V' : ['android.permission.CHANGE_WIFI_MULTICAST_STATE'],
	'Lcom/android/internal/telephony/uicc/SIMFileHandler;-updateEFTransparent-(I [B Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/NetworkTimeUpdateService$3;-onReceive-(Landroid/content/Context; Landroid/content/Intent;)V' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/bluetooth/BluetoothGatt;-unregisterApp-()V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothPbap$Stub;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Landroid/bluetooth/IBluetoothPbap;-getClient-()Landroid/bluetooth/BluetoothDevice;' : ['android.permission.BLUETOOTH'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-supplyPuk-(Ljava/lang/String; Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/calendar/event/EditEventHelper$EditDoneRunnable;-run-()V' : ['android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/content/ContentResolver;-isSyncActive-(Landroid/accounts/Account; Ljava/lang/String;)Z' : ['android.permission.READ_SYNC_STATS'],
	'Lcom/android/internal/policy/impl/PhoneWindowManager;-dispatchMediaKeyRepeatWithWakeLock-(Landroid/view/KeyEvent;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/wallpaper/holospiral/HoloSpiralTestActivity;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/filterfw/core/AsyncRunner$AsyncRunnerTask;-doInBackground-([Ljava/lang/Object;)Ljava/lang/Object;' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Landroid/net/wifi/WifiStateMachine;-startNextBatchedScan-()V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService$21;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/app/ResolverActivity$1;-onPackageAppeared-(Ljava/lang/String; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/music/MediaPlaybackActivity;-cycleRepeat-()V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK'],
	'Lcom/android/deskclock/widget/multiwaveview/GlowPadView;-setGrabbedState-(I)V' : ['android.permission.VIBRATE'],
	'Lcom/android/server/content/SyncStorageEngine;-init-(Landroid/content/Context;)V' : ['android.permission.WRITE_SYNC_SETTINGS', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/printspooler/FusedPrintersProvider$PersistenceManager$ReadTask;-onPostExecute-(Ljava/util/List;)V' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/text/StringSource;-fieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/view/ContextThemeWrapper;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/RIL;-sendScreenState-(Z)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/AbsoluteLayout;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/bluetooth/btservice/AdapterService;-createBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/gallery3d/gadget/WidgetClickHandler;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityStackSupervisor;-shutdownLocked-(I)Z' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/music/TouchInterceptor;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/CommandsInterface;-setRadioPower-(Z Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/mail/photomanager/PhotoManager$PhotoLoaderThread;-loadPhotosInBackground-()V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/IPhoneSubInfo$Stub$Proxy;-getGroupIdLevel1-()Ljava/lang/String;' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/gallery3d/app/MoviePlayer;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/server/sip/SipService;-access$1300-(Lcom/android/server/sip/SipService; Landroid/net/sip/SipProfile; I)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/support/v13/app/FragmentTabHost;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkPolicyManager$Stub;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Landroid/bluetooth/IBluetoothGatt;-addCharacteristic-(I Landroid/os/ParcelUuid; I I)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/mail/browse/FolderSpanTextView;-onAttachedToWindow-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/AllInOneActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/am/ActivityManagerService;-cleanUpApplicationRecordLocked-(Lcom/android/server/am/ProcessRecord; Z Z I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Landroid/provider/CalendarContract$CalendarAlerts;-alarmExists-(Landroid/content/ContentResolver; J J J)Z' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setCdmaSubscription-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-setTimeFromNITZString-(Ljava/lang/String; J)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Lcom/android/gallery3d/app/AbstractGalleryActivity;-onPause-()V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Landroid/appwidget/AppWidgetHostView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AbsListView;-startDrag-(Landroid/content/ClipData; Landroid/view/View$DragShadowBuilder; Ljava/lang/Object; I)Z' : ['android.permission.WAKE_LOCK'],
	'Landroid/test/IsolatedContext$MockAccountManager;-editProperties-(Ljava/lang/String; Landroid/app/Activity; Landroid/accounts/AccountManagerCallback; Landroid/os/Handler;)Landroid/accounts/AccountManagerFuture;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS', 'android.permission.USE_CREDENTIALS'],
	'Lcom/android/internal/telephony/RIL;-sendEnvelope-(Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/speech/tts/TextToSpeech;-playEarcon-(Ljava/lang/String; I Ljava/util/HashMap;)I' : ['android.permission.READ_PROFILE'],
	'Lcom/android/calendar/EventInfoFragment$11;-onTouch-(Landroid/view/View; Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager;-peekAuthToken-(Landroid/accounts/Account; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Landroid/bluetooth/IBluetoothHeadset$Stub$Proxy;-connect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/RIL;-queryCallWaiting-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/service/wallpaper/WallpaperService$Engine;-setTouchEventsEnabled-(Z)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Landroid/location/LocationManager;-removeGeofence-(Landroid/location/Geofence; Landroid/app/PendingIntent;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/mail/ui/AnimatedAdapter$3;-onChanged-()V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.READ_CONTACTS'],
	'Lcom/android/email/service/PopImapSyncAdapterService$SyncAdapterImpl;-onPerformSync-(Landroid/accounts/Account; Landroid/os/Bundle; Ljava/lang/String; Landroid/content/ContentProviderClient; Landroid/content/SyncResult;)V' : ['android.permission.READ_PHONE_STATE'],
	'Lcom/android/browser/ComboViewActivity$TabsAdapter;-onTabSelected-(Landroid/app/ActionBar$Tab; Landroid/app/FragmentTransaction;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorSVRectView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/HistoryItem;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/AccountManager$4;-start-()Landroid/accounts/AccountManager$Future2Task;' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.GET_ACCOUNTS'],
	'Lcom/android/mail/ui/FolderListFragment$4;-onChanged-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/filterpacks/imageproc/FillLightFilter;-transferInputPortFrame-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/svox/pico/CheckVoiceData;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/internal/telephony/WakeLockStateMachine;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/photos/AlbumSetFragment;-getSubItemUrisForItem-(Ljava/lang/Object;)Ljava/util/ArrayList;' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/email2/ui/MailActivityEmail;-stopDragMode-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/deskclock/alarms/AlarmActivity;-updateLayout-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/internal/telephony/uicc/RuimFileHandler;-loadEFImgLinearFixed-(I Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/inputmethodcommon/InputMethodSettingsActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/IWallpaperManager$Stub;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.SET_WALLPAPER_HINTS', 'android.permission.SET_WALLPAPER'],
	'Landroid/accounts/IAccountManager$Stub;-clearPassword-(Landroid/accounts/Account;)V' : ['android.permission.MANAGE_ACCOUNTS'],
	'Lcom/android/datetimepicker/time/TimePickerDialog;-access$800-(Lcom/android/datetimepicker/time/TimePickerDialog; I)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Landroid/os/PowerManager$WakeLock;-setWorkSource-(Landroid/os/WorkSource;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/app/PhotoDataAdapter$DataListener;-onPhotoChanged-(I Lcom/android/gallery3d/data/Path;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/server/AlarmManagerService;-<init>-(Landroid/content/Context;)V' : ['android.permission.WAKE_LOCK', 'android.permission.SET_TIME_ZONE'],
	'Landroid/net/wifi/WifiStateMachine$SupplicantStoppingState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/speech/tts/TextToSpeech;-playSilence-(J I Ljava/util/HashMap;)I' : ['android.permission.READ_PROFILE'],
	'Landroid/net/INetworkPolicyManager;-isNetworkMetered-(Landroid/net/NetworkState;)Z' : ['android.permission.ACCESS_WIFI_STATE', 'android.permission.READ_PHONE_STATE'],
	'Lcom/android/email/NotificationController;-access$1200-(Landroid/content/Context; J)V' : ['android.permission.READ_CONTACTS'],
	'Lcom/android/server/wifi/WifiController$DefaultState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/gallery3d/ui/TileImageView;-dispatchTouchEvent-(Landroid/view/MotionEvent; I I Lcom/android/gallery3d/ui/GLView; Z)Z' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/bluetooth/gatt/GattService$BluetoothGattBinder;-startScanWithUuids-(I Z [Landroid/os/ParcelUuid;)V' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/app/DisableCarModeActivity;-clearWallpaper-()V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/ScreensaverActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/music/TrackBrowserActivity;-getTrackCursor-(Lcom/android/music/TrackBrowserActivity$TrackListAdapter$TrackQueryHandler; Ljava/lang/String; Z)Landroid/database/Cursor;' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/view/WindowManagerGlobal;-addView-(Landroid/view/View; Landroid/view/ViewGroup$LayoutParams; Landroid/view/Display; Landroid/view/Window;)V' : ['android.permission.SYSTEM_ALERT_WINDOW'],
	'Lcom/android/bluetooth/hdp/HealthService;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TextToSpeechService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/calendar/month/MonthByWeekFragment;-goTo-(J Z Z Z)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR', 'android.permission.WRITE_CALENDAR'],
	'Landroid/media/AudioManager;-adjustStreamVolume-(I I I)V' : ['android.permission.BLUETOOTH'],
	'Landroid/bluetooth/IBluetoothMap$Stub;-getConnectedDevices-()Ljava/util/List;' : ['android.permission.BLUETOOTH'],
	'Landroid/filterpacks/imageproc/BitmapOverlayFilter;-close-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/exchange/service/EmailSyncAdapterService$SyncHandlerSynchronizer;-modifyPing-(Z Lcom/android/emailcommon/provider/Account;)V' : ['android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS'],
	'Lcom/android/camera/CameraBackupAgent;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/deskclock/Screensaver;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/mail/ui/OnePaneController;-onOptionsItemSelected-(Landroid/view/MenuItem;)Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Landroid/net/sip/ISipService;-getPendingSession-(Ljava/lang/String;)Landroid/net/sip/ISipSession;' : ['android.permission.USE_SIP'],
	'Landroid/media/SubtitleController;-doSelectTrack-(Landroid/media/SubtitleTrack;)V' : ['android.permission.READ_PROFILE', 'android.permission.WRITE_SETTINGS'],
	'Lcom/android/music/ArtistAlbumBrowserActivity;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/camera/app/CameraApp;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/deskclock/widget/TextTime;-setFormat-(I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/browser/ShortcutActivity;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/emailcommon/service/IEmailService$Stub$Proxy;-loadAttachment-(Lcom/android/emailcommon/service/IEmailServiceCallback; J J Z)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/wallpaper/livepicker/LiveWallpaperPreview;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/server/wifi/WifiController$NoLockHeldState;-processMessage-(Landroid/os/Message;)Z' : ['android.permission.CHANGE_NETWORK_STATE', 'android.permission.SEND_SMS', 'android.permission.INTERNET', 'android.permission.WRITE_SMS', 'android.permission.ACCESS_WIFI_STATE', 'android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.READ_CALL_LOG', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.MODIFY_AUDIO_SETTINGS', 'android.permission.READ_PROFILE', 'android.permission.READ_CONTACTS', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/content/ContextWrapper;-sendStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/net/wifi/IWifiManager;-stopBatchedScan-(Landroid/net/wifi/BatchedScanSettings;)V' : ['android.permission.CHANGE_WIFI_STATE'],
	'Lcom/android/server/updates/SmsShortCodesInstallReceiver;-getCert-(Landroid/content/ContentResolver;)Ljava/security/cert/X509Certificate;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/ui/ActivityController;-onBackPressed-()Z' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/cdma/CdmaServiceStateTracker;-updateCarrierMccMncConfiguration-(Ljava/lang/String; Ljava/lang/String; Landroid/content/Context;)V' : ['android.permission.SET_TIME_ZONE'],
	'Landroid/view/inputmethod/InputMethodManager;-getCurrentInputMethodSubtype-()Landroid/view/inputmethod/InputMethodSubtype;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/browse/EmlViewerActivity;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/bluetooth/btservice/AdapterService$AdapterServiceBinder;-getRemoteClass-(Landroid/bluetooth/BluetoothDevice;)I' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/grass/GrassView;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/UiModeManagerService;-access$400-(Lcom/android/server/UiModeManagerService; I I)V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/BaseUi$FullscreenHolder;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/power/Notifier;-playWirelessChargingStartedSound-()V' : ['android.permission.WAKE_LOCK', 'android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/CropRectFilter;-initProgramInputs-(Landroid/filterfw/core/Program; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/music/MediaPlaybackService;-onDestroy-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/print/IPrintManager$Stub;-validatePrinters-(Ljava/util/List; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/exchange/service/EasService;-sendStickyOrderedBroadcast-(Landroid/content/Intent; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/filterpacks/imageproc/GrainFilter;-performOpen-(Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECORD_AUDIO', 'android.permission.CAMERA'],
	'Lcom/android/calendar/DayView$CalendarGestureListener;-onDown-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE', 'android.permission.READ_CALENDAR'],
	'Lcom/android/gallery3d/data/FilterDeleteSet;-getIndexOfItem-(Lcom/android/gallery3d/data/Path; I)I' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/dataconnection/DcTracker;-onCleanUpConnection-(Z I Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/data/UriSource;-mapMediaItems-(Ljava/util/ArrayList; Lcom/android/gallery3d/data/MediaSet$ItemConsumer;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/emailcommon/service/IEmailService$Stub;-updateFolderList-(J)V' : ['android.permission.WRITE_CONTACTS', 'android.permission.READ_SYNC_SETTINGS', 'android.permission.WRITE_SYNC_SETTINGS', 'android.permission.READ_PHONE_STATE', 'android.permission.READ_CALENDAR', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_CALENDAR', 'android.permission.INTERNET', 'android.permission.READ_CONTACTS'],
	'Lcom/android/internal/telephony/uicc/IccCardProxy;-processLockedState-()V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/support/v4/view/ViewPager$3;-run-()V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/gallery3d/ingest/ui/DateTileView;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/gallery3d/filtershow/imageshow/ImageGrad;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/bluetooth/IBluetoothInputDevice$Stub;-sendData-(Landroid/bluetooth/BluetoothDevice; Ljava/lang/String;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/internal/telephony/MccTable;-setSystemLocale-(Landroid/content/Context; Ljava/lang/String; Ljava/lang/String;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/camera/SecureCameraActivity;-sendStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Landroid/app/backup/BackupAgent$BackupServiceBinder;-doRestoreFile-(Landroid/os/ParcelFileDescriptor; J I Ljava/lang/String; Ljava/lang/String; J J I Landroid/app/backup/IBackupManager;)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED'],
	'Lcom/android/internal/telephony/Connection;-hangup-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/DigitalClock;-onPopulateAccessibilityEvent-(Landroid/view/accessibility/AccessibilityEvent;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/compose/ComposeAttachmentTile;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/accounts/IAccountManager;-getAuthToken-(Landroid/accounts/IAccountManagerResponse; Landroid/accounts/Account; Ljava/lang/String; Z Z Landroid/os/Bundle;)V' : ['android.permission.USE_CREDENTIALS'],
	'Lcom/android/bluetooth/btservice/AdapterService;-removeBond-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.BLUETOOTH_ADMIN'],
	'Lcom/android/exchange/EasSyncService;-tryAutodiscover-(Landroid/content/Context; Lcom/android/emailcommon/provider/HostAuth;)Landroid/os/Bundle;' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/email/activity/setup/AccountSettings;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/speech/tts/TextToSpeech$8;-run-(Landroid/speech/tts/ITextToSpeechService;)Ljava/util/Locale;' : ['android.permission.READ_PROFILE'],
	'Lcom/android/deskclock/alarms/AlarmKlaxon;-start-(Landroid/content/Context; Lcom/android/deskclock/provider/AlarmInstance; Z)V' : ['android.permission.WAKE_LOCK', 'android.permission.VIBRATE'],
	'Lcom/android/mail/browse/ConversationCursor;-access$1100-(Lcom/android/mail/browse/ConversationCursor;)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/browser/BrowserWebView;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/content/Context;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/InboundSmsHandler;-onQuitting-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/wifi/WifiManager;-getWifiApState-()I' : ['android.permission.ACCESS_WIFI_STATE'],
	'Lcom/android/music/AudioPreview$PreviewPlayer;-stop-()V' : ['android.permission.WAKE_LOCK'],
	'Landroid/widget/EditText;-performClick-()Z' : ['android.permission.READ_PROFILE'],
	'Landroid/widget/AutoCompleteTextView;-updateTextServicesLocaleLocked-()V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/server/ConnectivityService;-updateLockdownVpn-()Z' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Landroid/print/IPrintManager$Stub$Proxy;-createPrinterDiscoverySession-(Landroid/print/IPrinterDiscoveryObserver; I)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/mail/compose/ComposeActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/bluetooth/BluetoothHealth;-registerAppConfiguration-(Ljava/lang/String; I I I Landroid/bluetooth/BluetoothHealthCallback;)Z' : ['android.permission.BLUETOOTH'],
	'Lcom/android/wallpaper/RenderScriptWallpaper;-removeStickyBroadcast-(Landroid/content/Intent;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-updatePhoneObject-(I)V' : ['android.permission.BROADCAST_STICKY', 'android.permission.WAKE_LOCK', 'android.permission.WRITE_SETTINGS', 'android.permission.SET_TIME_ZONE'],
	'Landroid/bluetooth/IBluetoothManager$Stub;-unregisterAdapter-(Landroid/bluetooth/IBluetoothManagerCallback;)V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/calendar/month/MonthByWeekAdapter;-init-()V' : ['android.permission.READ_CALENDAR'],
	'Lcom/android/emailcommon/utility/CertificateRequestor;-sendStickyOrderedBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle; Landroid/content/BroadcastReceiver; Landroid/os/Handler; I Ljava/lang/String; Landroid/os/Bundle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/gallery3d/filtershow/colorpicker/ColorValueView;-onKeyUp-(I Landroid/view/KeyEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Landroid/filterpacks/imageproc/SaturateFilter;-notifyFieldPortValueUpdated-(Ljava/lang/String; Landroid/filterfw/core/FilterContext;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/app/ActivityManagerNative;-updateConfiguration-(Landroid/content/res/Configuration;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/quicksearchbox/util/JavaNetHttpHelper;-post-(Ljava/lang/String; Ljava/util/Map; Ljava/lang/String;)Ljava/lang/String;' : ['android.permission.INTERNET'],
	'Lcom/android/server/power/PowerManagerService;-goToSleepInternal-(J I)V' : ['android.permission.WAKE_LOCK', 'android.permission.RECEIVE_BOOT_COMPLETED', 'android.permission.READ_PROFILE'],
	'Lcom/android/browser/view/PieMenu;-layoutPieView-(Lcom/android/browser/view/PieMenu$PieView; I I F)V' : ['com.android.browser.permission.WRITE_HISTORY_BOOKMARKS', 'android.permission.GET_ACCOUNTS', 'com.android.browser.permission.READ_HISTORY_BOOKMARKS'],
	'Landroid/support/v4/print/PrintHelper;-printBitmap-(Ljava/lang/String; Landroid/graphics/Bitmap;)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/videoeditor/widgets/AudioTrackLinearLayout;-onTouchEvent-(Landroid/view/MotionEvent;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/inputmethod/dictionarypack/DownloadOverMeteredDialog;-setWallpaper-(Ljava/io/InputStream;)V' : ['android.permission.SET_WALLPAPER'],
	'Lcom/android/development/Connectivity;-removeStickyBroadcastAsUser-(Landroid/content/Intent; Landroid/os/UserHandle;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/power/DisplayPowerController;-<init>-(Landroid/os/Looper; Landroid/content/Context; Lcom/android/server/power/Notifier; Lcom/android/server/LightsService; Lcom/android/server/TwilightService; Landroid/hardware/SensorManager; Lcom/android/server/display/DisplayManagerService; Lcom/android/server/power/SuspendBlocker; Lcom/android/server/power/DisplayBlanker; Lcom/android/server/power/DisplayPowerController$Callbacks; Landroid/os/Handler;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/internal/telephony/cdma/CDMAPhone;-setVoiceMessageWaiting-(I I)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/browser/NavigationBarBase;-performAccessibilityActionInternal-(I Landroid/os/Bundle;)Z' : ['android.permission.READ_PROFILE'],
	'Lcom/android/bluetooth/map/BluetoothMapService$BluetoothMapBinder;-disconnect-(Landroid/bluetooth/BluetoothDevice;)Z' : ['android.permission.ACCESS_COARSE_LOCATION', 'android.permission.BLUETOOTH', 'android.permission.RECEIVE_SMS', 'android.permission.READ_PHONE_STATE', 'android.permission.BLUETOOTH_ADMIN', 'android.permission.READ_SMS'],
	'Landroid/support/v4/view/ViewPager;-smoothScrollTo-(I I I)V' : ['android.permission.READ_SYNC_SETTINGS'],
	'Lcom/android/internal/telephony/RIL;-hangupWaitingOrBackground-(Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Lcom/android/timezonepicker/TimeZonePickerView;-<init>-(Landroid/content/Context; Landroid/util/AttributeSet; Ljava/lang/String; J Lcom/android/timezonepicker/TimeZonePickerView$OnTimeZoneSetListener; Z)V' : ['android.permission.READ_PROFILE'],
	'Lcom/android/email/service/EasTestAuthenticatorService$EasAuthenticator;-addAccount-(Landroid/accounts/AccountAuthenticatorResponse; Ljava/lang/String; Ljava/lang/String; [Ljava/lang/String; Landroid/os/Bundle;)Landroid/os/Bundle;' : ['android.permission.AUTHENTICATE_ACCOUNTS'],
	'Lcom/android/internal/telephony/PhoneBase;-invokeOemRilRequestStrings-([Ljava/lang/String; Landroid/os/Message;)V' : ['android.permission.WAKE_LOCK'],
	'Landroid/net/IConnectivityManager;-getLinkProperties-(I)Landroid/net/LinkProperties;' : ['android.permission.ACCESS_NETWORK_STATE'],
	'Lcom/android/internal/app/HeavyWeightSwitcherActivity;-setWallpaper-(Landroid/graphics/Bitmap;)V' : ['android.permission.SET_WALLPAPER'],
	'Landroid/media/AudioService;-checkScoAudioState-()V' : ['android.permission.BLUETOOTH'],
	'Lcom/android/gallery3d/ui/EdgeView;-removeOneComponent-(Lcom/android/gallery3d/ui/GLView;)V' : ['android.permission.ACCESS_FINE_LOCATION', 'android.permission.ACCESS_NETWORK_STATE', 'android.permission.ACCESS_COARSE_LOCATION'],
	'Lcom/android/vcard/VCardParserImpl_V40;-parseItems-()V' : ['android.permission.WRITE_CONTACTS'],
	'Lcom/android/internal/telephony/gsm/GSMPhone;-notifyDataConnection-(Ljava/lang/String;)V' : ['android.permission.BROADCAST_STICKY'],
	'Lcom/android/server/accounts/AccountManagerService;-onTransact-(I Landroid/os/Parcel; Landroid/os/Parcel; I)Z' : ['android.permission.MANAGE_ACCOUNTS', 'android.permission.AUTHENTICATE_ACC