// Copyright (c) 1997, 2003 by Jim Lynch.
// Copyright (c) 2010 by Philipp Schafft.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program;  if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
//    02110-1301 USA
//
// On Debian Linux systems, the complete text of the GNU General
// Public License can be found in `/usr/doc/copyright/GPL' (on some
// installations) or /usr/share/common-licenses/GPL (on newer 
// ones).

#include "util.h"

void readline(std::istream &in, std::string &it)
{
  getline(in, it);
}

int IsSpace(const char theChar)
{
  int result = 0;
  
  switch(theChar)
    {
    case ' ':
    case '\n':
    case '\t':
    case '\r':
    case '\v':
    case '\f':
      result = 1;
      break;
    }
  
  return result;
}

void ChopTrailingWhiteSpace(std::string &it)
{
  int n = it.size();

  while(IsSpace( it[--n] ))
    ;

  it = it.substr(0, n + 1);
}

void ChopQuestionMark(std::string &it)
{
  ChopTrailingWhiteSpace(it);

  while(*(it.end() - 1) == '?')
    {
      it = it.substr(0, it.size() - 1);
      ChopTrailingWhiteSpace(it);
    }
}

