use strict;
use warnings;
use Socket;
use IO::Socket;
use FreezeThaw qw(freeze thaw);
use HTTP::Response;

socketpair(CHILD, PARENT, AF_UNIX, SOCK_STREAM, PF_UNSPEC) or die "socketpair: $!";


$SIG{CHLD} = 'IGNORE';

CHILD->autoflush(1);
PARENT->autoflush(1);

if (my $pid = fork) {
    close PARENT;
#    print CHILD "Parent Pid $$ is sending\n";
    print CHILD freeze(HTTP::Response->new(200, 'Message for code'));
    close CHILD;
    waitpid($pid,0);
} else {
    die "cannot fork: $!" unless defined $pid;
    close CHILD;
    while (my $line = <PARENT>) {
	chomp $line;
	print "Child Pid $$ just read this: `$line'\n";
	my $obj = (thaw($line))[0];
	print $obj->message."\n"
    }
    close PARENT;
    exit;
}
