# FindPCAP search and find the libpcap library path
#
# Usage:
#
#  find_package(PCAP)
#  ...
#  target_link_libraries(... ${PCAP_LIB})
#
# The following variables are to be set:
#   CMAKE_INCLUDE_PATH - find the pthread.h
#   CMAKE_LIBRARY_PATH - find the library
#
# Variable defined by this module:
#   PCAP_INCLUDE_DIR - header directory
#   PCAP_LIB         - library to link
#
# Copyright 2014 <Giuseppe Marco Randazzo> gmrandazzo@gmail.com
#
# Redistribution AND use is allowed according to the terms of the BSD 3 clause

find_path(PCAP_INCLUDE_DIR NAMES pcap.h HINTS ${CMAKE_INCLUDE_PATH})

find_library(PCAP_LIB NAMES pcap HINTS ${CMAKE_LIBRARY_PATH})

if(PCAP_INCLUDE_DIR AND PCAP_LIB)
  message(STATUS "Found libpcap")
  include_directories(${PCAP_INCLUDE_DIR})
else(PCAP_INCLUDE_DIR AND PCAP_LIB)
  message(FATAL_ERROR "libpcap not found! Please visit http://www.tcpdump.org/ or see in the arpon 'INSTALL' file.")
endif(PCAP_INCLUDE_DIR AND PCAP_LIB)
