# FindPhtread search and find the libphtread library path and header path
#
# Usage:
#
#  find_package(Pthread)
#  ...
#  target_link_libraries(... ${PTHREAD_LIB})
#
# The following variables are to be set:
#   CMAKE_INCLUDE_PATH - find the pthread.h
#   CMAKE_LIBRARY_PATH - find the library
#
# Variable defined by this module:
#   PTHREAD_INCLUDE_DIR - header directory
#   PTHREAD_LIB         - library to link
#
# Copyright 2014 <Giuseppe Marco Randazzo> gmrandazzo@gmail.com
#
# Redistribution AND use is allowed according to the terms of the BSD 3 clause

find_path(PTHREAD_INCLUDE_DIR NAMES pthread.h HINTS ${CMAKE_INCLUDE_PATH})

find_library(PTHREAD_LIB NAMES pthread HINTS ${CMAKE_LIBRARY_PATH})

if(PTHREAD_INCLUDE_DIR AND PTHREAD_LIB)
  message(STATUS "Found phtread")
  include_directories(${PTHREAD_INCLUDE_DIR})
else(PTHREAD_INCLUDE_DIR AND PTHREAD_LIB)
  message(FATAL_ERROR " pthread not found! \n Please visit  http://www.gnu.org/software/libc/libc.html or see in the arpon 'INSTALL' file.")
endif(PTHREAD_INCLUDE_DIR AND PTHREAD_LIB)
