------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                      G N A T S Y N C . O U T P U T                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2007-2008, AdaCore                      --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Characters.Conversions; use Ada.Characters.Conversions;

with Asis.Implementation;        use Asis.Implementation;

with ASIS_UL.Output;             use ASIS_UL.Output;

with Gnatvsn;

package body Gnatsync.Output is

   ------------------------
   -- Print_Version_Info --
   ------------------------

   procedure Print_Version_Info is
   begin
      Info_No_EOL ("GNATSYNC (built with ");
      Info_No_EOL (To_String (Asis.Implementation.ASIS_Implementor_Version));
      Info        (")");

      Info_No_EOL ("Copyright 2007-");
      Info_No_EOL (Gnatvsn.Current_Year);
      Info        (", AdaCore.");
   end Print_Version_Info;

   ----------------
   -- Brief_Help --
   ----------------

   procedure Brief_Help is
   begin
      --  Info ("gnatsync: the GNAT global dependency detector");
      Info ("usage: gnatsync [options] {filename} " &
            "{-files=filename} [-cargs gcc_switches]");

      Info ("");
      Info ("options:");
      Info (" -a                 - process RTL units");
      Info (" -d                 - debug mode");
      Info (" -dd                - progress indicator mode (for use in GPS)");
      Info (" -q                 - quiet mode (do not report results in "&
            "Stdout)");
      Info (" -v                 - verbose mode");
      Info (" -t                 - output execution time");
      Info (" -main=filename     - specify file containing main subprogram");
      Info (" -threads=filename  - specify file describing foreign threads");
      Info (" -o(s|m|f)          - output detalization level:");
      Info ("                      s - short, m(default) - medium, f - full");
      Info (" -wq                - turn warnings off");

      Info ("");

      Info (" -out_file=filename - send output to filename");

      Info ("");

      Info ("filename            - the name of the Ada source file " &
            "to be analyzed.");
      Info ("                      Wildcards are allowed");
      Info ("-files=filemane     - the name of the text file containing "&
            "a list");
      Info ("                      of Ada source files to analyze");
      Info ("");
      Info ("gcc_switches        - a list of switches that are " &
            "valid switches for gcc");
      Info ("");
   end Brief_Help;

   ------------------------
   -- Brief_Wrapper_Help --
   ------------------------

   procedure Brief_Wrapper_Help is
   begin
      Info ("gnatsync: the GNAT global dependency detector");
      Info ("usage: gnatsync -Pproj [options] [main_unit]");

      Info ("-Pproj    - specifies the project file to use");
      Info ("main_unit - name of source file containing the main subprogram");

      Info ("");
      Info ("options:");
      Info (" -q                 - quiet mode");
      Info (" -v                 - verbose mode");
      Info (" -t                 - output execution time");
      Info (" -o(s|m|f)          - output detalization level:");
      Info ("                      s - short, m(default) - medium, f - full");
      Info (" -gnat05            - treat argument sources as Ada 2005 units");
      Info (" -wq                - turn warnings off");
      Info (" -out_file=filename - send output to filename");
   end Brief_Wrapper_Help;

end Gnatsync.Output;
