------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--      G N A T P P . G E N E R A L _ T R A V E R S A L _ S T A C K S       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2001-2005, AdaCore                     --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

with Asis;          use Asis;
with Asis.Text;     use Asis.Text;

with GNATPP.Stacs;

with GNATPP.Layout; use GNATPP.Layout;

package GNATPP.General_Traversal_Stacks is

   -------------------------------------------------------
   --  Stack for keeping the top-down traversal history --
   -------------------------------------------------------

   type Traversal_Step_Record is record
      The_Element : Asis.Element;
      The_Span    : Asis.Text.Span;

      Layout      : Layout_Info;
   end record;

   Nil_Traversal_Step : constant Traversal_Step_Record :=
     (The_Element => Nil_Element,
      The_Span    => Nil_Span,
      Layout      => Nil_Layout_Info);

   package Traversal_Stack is new GNATPP.Stacs
     (Element_Type => Traversal_Step_Record,
      No_Element   => Nil_Traversal_Step);
   --  We need this stack for performance reasons only. When doing source
   --  traversal and corresponding reformatting, sometimes we need to know
   --  what do we have one level up. So the idea of using this stack is not to
   --  compute Enclosing_Element and Element_Span more times then we really
   --  have to do, and not to transfer the layout info as a traversal state
   --  parameter.

   --------------------------------------------------------------------
   -- Stack for keeping the starting positions of the code fragments --
   --------------------------------------------------------------------

   --  ??? Do we need this?
   --  ??? More general question - do we need the generic stack?

   package List_Start_Stack is new GNATPP.Stacs
     (Element_Type => Natural,
      No_Element   => 0);
   --  We need this stack to keep the positions of the code fragments
   --  corresponding to list elements (associations, constraints etc). We
   --  need stack for this because such lists may be nested in each other/

end GNATPP.General_Traversal_Stacks;
