/*
 * Fake Atom-4 server to test server code
 */

#include <stdio.h>
#include <exception.h>			// prog/lib version
#include "game.h"
#include "server.h"


#define SERV_PORT		4704

int main() {
  try {
    int exitflag=0;
    eventloop mainloop;
    atom4local game(16,16);
    server gamesrv(&game, &mainloop, SERV_PORT, server::ALLOW_OBSERVERS);

    fprintf(stderr, "Server initialized, waiting for connections\n");
    mainloop.run(&exitflag);
    fprintf(stderr, "Server exited\n");
  } catch(exception &e) {
    fprintf(stderr, "Caught exception: %s\n", e.message());
  }
}

