/*
 * Atom-4 X11 client: scoreboard panel
 * Header file
 *
 * $Id: xscoreboard.h,v 1.5 2003/04/06 04:16:48 hsteoh Exp hsteoh $
 */

#ifndef XSCOREBOARD_H
#define XSCOREBOARD_H

#include "game.h"
#include "xsprite.h"
#include "xutil.h"


#define NUM_WHEELS		6


class xscoreboard : public xwindow {
  atom4 *game;				// [R]
  xsprite_engine *eng;			// [R]

  Pixmap buffer;			// poor man's backing store :-)
  GC erasegc;

  xflatsprite *wheels[NUM_WHEELS];	// [[O]]

  XFontStruct *titlefont;		// Title font
  GC titlegc;
  XFontStruct *scorefont;		// regular font
  GC textgc;

  void draw_center(XFontStruct *font, GC gc, char *text, int y);
  void render_score(int player, int y);
  void render_wheel(int wheel);
public:
  // Note: the width*height here is the *external* width and height (including
  // the border), so that we can "fit" this panel into an exact amount of
  // external space without worrying about adjusting it for border widths.
  xscoreboard(xconnection *conn, xsprite_engine *eng, xwindow *parent,
              atom4 *game, int x, int y, int width, int height);
  ~xscoreboard();

  void refresh();
  void expose(XExposeEvent ev);
};


#endif // XSCOREBOARD_H
