/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of hypot() function. 500 random cases.
   $Id$
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x,y;		/* args		*/
    long z;		/* result	*/
} t[] = {

    /* x, y, hypot(x,y)	*/
    { 0xc99712ee,0xc8f76d53,0x49a33f3e }, /*   1: -1.2375978e+06 -5.0673059e+05  1.3373198e+06 */
    { 0xc2df61be,0x430b4265,0x43328424 }, /*   2: -1.1169090e+02  1.3925935e+02  1.7851617e+02 */
    { 0x69aec6c4,0x67ec9a48,0x69af66a1 }, /*   3:  2.6411467e+25  2.2346490e+24  2.6505834e+25 */
    { 0xa31312c3,0xa4440e8b,0x2447798a }, /*   4: -7.9728589e-18 -4.2513044e-17  4.3254194e-17 */
    { 0x3a4fcb37,0xb98219ab,0x3a59bce6 }, /*   5:  7.9267047e-04 -2.4814656e-04  8.3060411e-04 */
    { 0x53e625e7,0xd2c23ef8,0x53eb372d }, /*   6:  1.9769567e+12 -4.1714005e+11  2.0204860e+12 */
    { 0xf4d979da,0x7f05f5fa,0x7f05f5fa }, /*   7: -1.3784178e+32  1.7806451e+38  1.7806451e+38 */
    { 0x26d276c8,0x258eccc4,0x26d57867 }, /*   8:  1.4603873e-15  2.4771828e-16  1.4812479e-15 */
    { 0x000078ef,0x8001deb6,0x0001edc0 }, /*   9:  4.3382799e-41 -1.7172913e-40  1.7712413e-40 */
    { 0xd2dfdf6b,0x52e477a7,0x531fef44 }, /*  10: -4.8076302e+11  4.9062999e+11  6.8691401e+11 */
    { 0xa04f79f9,0xa04f2068,0x20929599 }, /*  11: -1.7573939e-19 -1.7544304e-19  2.4832357e-19 */
    { 0x0bbd83db,0x8c1547cf,0x0c30d0b9 }, /*  12:  7.2998546e-32 -1.1500152e-31  1.3621357e-31 */
    { 0x5a0e0325,0xdaaf2ec1,0x5abd06a8 }, /*  13:  9.9932260e+15 -2.4654764e+16  2.6603045e+16 */
    { 0xdb63a0f3,0x5bc3be33,0x5be26d37 }, /*  14: -6.4071785e+16  1.1019349e+17  1.2746686e+17 */
    { 0xe0e34ed7,0xe0ebd584,0x6123c5ef }, /*  15: -1.3103412e+20 -1.3594907e+20  1.8881762e+20 */
    { 0x69f70e5d,0x68d9ced3,0x69fcfc53 }, /*  16:  3.7334063e+25  8.2285501e+24  3.8230109e+25 */
    { 0x51b35c38,0xd0a8ead9,0x51b843b7 }, /*  17:  9.6293290e+10 -2.2671706e+10  9.8926256e+10 */
    { 0x24537697,0x8f8f0043,0x24537697 }, /*  18:  4.5853781e-17 -1.4100989e-29  4.5853781e-17 */
    { 0x706dab1f,0xf10165e3,0x710e633b }, /*  19:  2.9421928e+29 -6.4074784e+29  7.0506934e+29 */
    { 0x92d4de8f,0x915aaecd,0x12d69e08 }, /*  20: -1.3433946e-27 -1.7251032e-28  1.3544256e-27 */
    { 0xfe122c56,0xfdf911cf,0x7e4007ad }, /*  21: -4.8574373e+37 -4.1383780e+37  6.3812908e+37 */
    { 0xcd65e265,0xcd976738,0x4dbe1753 }, /*  22: -2.4105122e+08 -3.1751552e+08  3.9864995e+08 */
    { 0x8cf47a5e,0x0d0b5328,0x0d395905 }, /*  23: -3.7667800e-31  4.2932778e-31  5.7114680e-31 */
    { 0x09172f57,0x07ea1089,0x0919fd70 }, /*  24:  1.8198223e-33  3.5218125e-34  1.8535871e-33 */
    { 0xb6720253,0x369d96e3,0x36c6afde }, /*  25: -3.6062163e-06  4.6965301e-06  5.9213335e-06 */
    { 0xeea152ca,0x6e46e102,0x6ebd8229 }, /*  26: -2.4963586e+28  1.5387512e+28  2.9325010e+28 */
    { 0x1d15ab4d,0x9d0f757e,0x1d4f51c3 }, /*  27:  1.9808546e-21 -1.8986634e-21  2.7438492e-21 */
    { 0xdb031044,0x5c193062,0x5c1ca76c }, /*  28: -3.6891106e+16  1.7247548e+17  1.7637671e+17 */
    { 0xa08c3581,0xa14c758d,0x215824d9 }, /*  29: -2.3752328e-19 -6.9273466e-19  7.3232414e-19 */
    { 0x40fcbe06,0xc0fb32c2,0x41322bb5 }, /*  30:  7.8981962e+00 -7.8499460e+00  1.1135671e+01 */
    { 0x8bca1ec2,0x0e6fb990,0x0e6fcedc }, /*  31: -7.7853849e-32  2.9548370e-30  2.9558624e-30 */
    { 0x2f852df4,0x30b5cec5,0x30b8d4cc }, /*  32:  2.4225211e-10  1.3228251e-09  1.3448243e-09 */
    { 0x77138186,0xf69a08e5,0x772666f4 }, /*  33:  2.9917761e+33 -1.5620979e+33  3.3750368e+33 */
    { 0x450cf831,0xc4da7ebc,0x453258ab }, /*  34:  2.2555120e+03 -1.7479604e+03  2.8535417e+03 */
    { 0x0e8c9a86,0x0ee8cdef,0x0f07fc11 }, /*  35:  3.4661465e-30  5.7390722e-30  6.7045601e-30 */
    { 0xf8bfd62b,0x788ecf17,0x78ef27fb }, /*  36: -3.1127267e+34  2.3172076e+34  3.8805308e+34 */
    { 0x887e3416,0x89591ace,0x09623701 }, /*  37: -7.6496571e-34 -2.6133028e-33  2.7229623e-33 */
    { 0x8d8abbbe,0x0d39d5b4,0x0da6f98d }, /*  38: -8.5501039e-31  5.7264762e-31  1.0290617e-30 */
    { 0x3aeb3a9f,0xb96aad16,0x3aed0d10 }, /*  39:  1.7946548e-03 -2.2380459e-04  1.8085558e-03 */
    { 0xea04b39d,0x6a4d3124,0x6a745d06 }, /*  40: -4.0106602e+25  6.2015463e+25  7.3854298e+25 */
    { 0x8001b623,0x80025ea8,0x0002ec54 }, /*  41: -1.5717384e-40 -2.1762726e-40  2.6844955e-40 */
    { 0xc6b6a609,0xc59fa5f0,0x46baf55f }, /*  42: -2.3379018e+04 -5.1087422e+03  2.3930686e+04 */
    { 0xaf6402ff,0xae354fdd,0x2f68793c }, /*  43: -2.0737544e-10 -4.1225568e-11  2.1143348e-10 */
    { 0xf744cb83,0x7343007b,0x7744cbe4 }, /*  44: -3.9914761e+33  1.5449640e+31  3.9915062e+33 */
    { 0xef194ecb,0x6e0a1d4c,0x6f1d25e5 }, /*  45: -4.7446461e+28  1.0686087e+28  4.8634958e+28 */
    { 0xe4d692d6,0x62cd00a8,0x64d6f4ae }, /*  46: -3.1665471e+22  1.8908149e+21  3.1721874e+22 */
    { 0xa1157540,0x2193c626,0x21a5983a }, /*  47: -5.0638343e-19  1.0013557e-18  1.1221129e-18 */
    { 0x3b10bdcf,0xbae78b5a,0x3b3958ac }, /*  48:  2.2085791e-03 -1.7665431e-03  2.8281612e-03 */
    { 0x0b0f3314,0x8a627b50,0x0b19fca8 }, /*  49:  2.7579225e-32 -1.0904697e-32  2.9656806e-32 */
    { 0x9bb8ab98,0x1ce1de15,0x1ce6899f }, /*  50: -3.0551136e-22  1.4946658e-21  1.5255697e-21 */
    { 0x0810f627,0x8798f811,0x0823e6cd }, /*  51:  4.3622774e-34 -2.3016218e-34  4.9322333e-34 */
    { 0xb935cd9d,0xb903968b,0x39606d81 }, /*  52: -1.7338102e-04 -1.2549215e-04  2.1403098e-04 */
    { 0x3df104b0,0x3daf9e97,0x3e151b7d }, /*  53:  1.1768472e-01  8.5751705e-02  1.4561267e-01 */
    { 0xc94c3ac0,0xc9937b2a,0x49b361ef }, /*  54: -8.3652400e+05 -1.2081652e+06  1.4695019e+06 */
    { 0x000003ce,0x800004d0,0x00000623 }, /*  55:  1.3648647e-42 -1.7263997e-42  2.2014399e-42 */
    { 0xfd8875c6,0x7968ed84,0x7d8875f8 }, /*  56: -2.2673315e+37  7.5589391e+34  2.2673442e+37 */
    { 0xe7e6d86b,0xe80be3b4,0x68355c2b }, /*  57: -2.1802730e+24 -2.6424373e+24  3.4257941e+24 */
    { 0x000003b2,0x0000046a,0x000005c2 }, /*  58:  1.3256283e-42  1.5834673e-42  2.0655139e-42 */
    { 0x80000051,0x00000007,0x00000051 }, /*  59: -1.1350518e-43  9.8090893e-45  1.1350518e-43 */
    { 0x7e32c714,0xfe27d3e5,0x7e753593 }, /*  60:  5.9409064e+37 -5.5770324e+37  8.1484758e+37 */
    { 0x2e76e735,0x2ef88e11,0x2f0ac323 }, /*  61:  5.6139277e-11  1.1302970e-10  1.2620353e-10 */
    { 0x5ac5dae9,0xdb8ed0f1,0x5b9723b1 }, /*  62:  2.7845632e+16 -8.0398360e+16  8.5083929e+16 */
    { 0x3f21715f,0xb79c0c2a,0x3f21715f }, /*  63:  6.3063616e-01 -1.8602314e-05  6.3063616e-01 */
    { 0x1bb5cb8b,0x1c376895,0x1c4cb28d }, /*  64:  3.0075475e-22  6.0684790e-22  6.7728709e-22 */
    { 0xbde563ed,0xbde7c578,0x3e230c26 }, /*  65: -1.1200700e-01 -1.1316961e-01  1.5922603e-01 */
    { 0x6a476f49,0x6aa2e85e,0x6abf00fb }, /*  66:  6.0275442e+25  9.8471653e+25  1.1545473e+26 */
    { 0x8030c227,0x989af1cc,0x189af1cc }, /*  67: -4.4777526e-39 -4.0052219e-24  4.0052219e-24 */
    { 0x978da9e7,0x97c0d804,0x17ef48f9 }, /*  68: -9.1548008e-25 -1.2462239e-24  1.5463434e-24 */
    { 0x09b3371d,0x89a6184f,0x09f458ef }, /*  69:  4.3144511e-33 -3.9985906e-33  5.8824496e-33 */
    { 0xb347b8b5,0x32e4f850,0x3366351f }, /*  70: -4.6501288e-08  2.6655613e-08  5.3599361e-08 */
    { 0xc392a198,0x4330982f,0x43ab29fc }, /*  71: -2.9326245e+02  1.7659447e+02  3.4232800e+02 */
    { 0x40012e46,0x40919c42,0x409f4b0a }, /*  72:  2.0184493e+00  4.5503244e+00  4.9779100e+00 */
    { 0xa259c100,0xa1b63bb2,0x226c0c79 }, /*  73: -2.9511157e-18 -1.2348601e-18  3.1990567e-18 */
    { 0xf6abd86f,0x7805e02f,0x7807968c }, /*  74: -1.7427198e+33  1.0861289e+34  1.1000211e+34 */
    { 0x51466efa,0x52e8f6f5,0x52ea480c }, /*  75:  5.3266588e+10  5.0028783e+11  5.0311555e+11 */
    { 0x63723220,0x6203a9f0,0x63746c1d }, /*  76:  4.4677240e+21  6.0719219e+20  4.5087959e+21 */
    { 0xcf41671d,0xcdfbb5c5,0x4f43f207 }, /*  77: -3.2447603e+09 -5.2787421e+08  3.2874186e+09 */
    { 0xfd3fe384,0xf5720614,0x7d3fe384 }, /*  78: -1.5941492e+37 -3.0680154e+32  1.5941492e+37 */
    { 0x90daa2bc,0x9216ce01,0x121942d6 }, /*  79: -8.6236571e-29 -4.7585574e-28  4.8360669e-28 */
    { 0x3eb7f23e,0x4000aa3d,0x4002b410 }, /*  80:  3.5927004e-01  2.0103905e+00  2.0422401e+00 */
    { 0xa14ccdf1,0x20ed313e,0x216caa06 }, /*  81: -6.9390450e-19  4.0181947e-19  8.0184934e-19 */
    { 0xfcb52ee1,0x7cf27bc0,0x7d17593a }, /*  82: -7.5260524e+36  1.0072366e+37  1.2573545e+37 */
    { 0xdf61be94,0x5f9c6537,0x5fc0df43 }, /*  83: -1.6266602e+19  2.2538948e+19  2.7795801e+19 */
    { 0x0002ee0f,0x00007ac3,0x0002f80a }, /*  84:  2.6907032e-40  4.4038607e-41  2.7265064e-40 */
    { 0x7995dddd,0x7944d4f5,0x79b34ad1 }, /*  85:  9.7269019e+34  6.3875592e+34  1.1636732e+35 */
    { 0xc14b1d89,0x3e5436b2,0x414b2477 }, /*  86: -1.2694711e+01  2.0723990e-01  1.2696403e+01 */
    { 0x9bcb0f15,0x19f6bad8,0x1bcba4c3 }, /*  87: -3.3593279e-22  2.5511269e-23  3.3690008e-22 */
    { 0x6637cde8,0x66677b34,0x6693ca41 }, /*  88:  2.1699784e+23  2.7328484e+23  3.4895940e+23 */
    { 0xcf11ee2e,0x4f66650a,0x4f885c70 }, /*  89: -2.4483057e+09  3.8653814e+09  4.5755187e+09 */
    { 0xa30f10fa,0xa31f9df5,0x23565963 }, /*  90: -7.7556405e-18 -8.6528560e-18  1.1619892e-17 */
    { 0x0bea3b30,0x0b85cbc1,0x0c06e021 }, /*  91:  9.0222577e-32  5.1536311e-32  1.0390431e-31 */
    { 0xc296c595,0xc261ed02,0x42bc652c }, /*  92: -7.5385902e+01 -5.6481453e+01  9.4197601e+01 */
    { 0xde9eb809,0x5ecb3920,0x5f00edf8 }, /*  93: -5.7184506e+18  7.3218854e+18  9.2903543e+18 */
    { 0x8000039d,0x00000363,0x000004f4 }, /*  94: -1.2962011e-42  1.2149258e-42  1.7768465e-42 */
    { 0x8079687c,0x825cd094,0x025d55ed }, /*  95: -1.1149577e-38 -1.6222906e-37  1.6261175e-37 */
    { 0x52774ad2,0x5262a7b7,0x52a7b978 }, /*  96:  2.6552805e+11  2.4336910e+11  3.6018559e+11 */
    { 0xafa3393b,0xb2178662,0x32179c5b }, /*  97: -2.9690192e-10 -8.8199119e-09  8.8249079e-09 */
    { 0xef17c611,0x6ee18f15,0x6f3d16a8 }, /*  98: -4.6971684e+28  3.4903551e+28  5.8520057e+28 */
    { 0x581ec241,0xd81ab7d3,0x585dae17 }, /*  99:  6.9822861e+14 -6.8045724e+14  9.7495912e+14 */
    { 0x8f70444a,0x0f562517,0x0fa0ec8c }, /* 100: -1.1846066e-29  1.0558158e-29  1.5868333e-29 */
    { 0x17a9058c,0x98114dda,0x182817e4 }, /* 101:  1.0922769e-24 -1.8780116e-24  2.1725553e-24 */
    { 0xa8a9fa02,0xa5d5fda9,0x28aa026d }, /* 102: -1.8871193e-14 -3.7121497e-16  1.8874843e-14 */
    { 0x730408f1,0xf374e494,0x738b1c04 }, /* 103:  1.0460885e+31 -1.9402413e+31  2.2042770e+31 */
    { 0xe215d44e,0xe08f299e,0x6216e4ec }, /* 104: -6.9096576e+20 -8.2527601e+19  6.9587679e+20 */
    { 0xc00964c2,0xc01b42a3,0x404f52a5 }, /* 105: -2.1467748e+00 -2.4259422e+00  3.2394192e+00 */
    { 0x34d91056,0x3491216a,0x35028e5c }, /* 106:  4.0431286e-07  2.7032667e-07  4.8635934e-07 */
    { 0xd67b2fe9,0xd54bcff6,0x568026c7 }, /* 107: -6.9045798e+13 -1.4005878e+13  7.0452018e+13 */
    { 0x8000d125,0x80008891,0x0000f9c9 }, /* 108: -7.5026921e-41 -4.8990796e-41  8.9606030e-41 */
    { 0xd07ce7ba,0xd5bfb6a2,0x55bfb6a5 }, /* 109: -1.6972179e+10 -2.6348890e+13  2.6348897e+13 */
    { 0xa4a12c20,0xa513ac4d,0x25283afa }, /* 110: -6.9897371e-17 -1.2808595e-16  1.4591659e-16 */
    { 0xcb692cac,0x4cc1059a,0x4cc335c9 }, /* 111: -1.5281324e+07  1.0119906e+08  1.0234631e+08 */
    { 0xefb7233d,0x686ef940,0x6fb7233d }, /* 112: -1.1335671e+29  4.5140843e+24  1.1335671e+29 */
    { 0x03610854,0x036bdefc,0x03a2ffc3 }, /* 113:  6.6131117e-37  6.9316267e-37  9.5802243e-37 */
    { 0xb32cc9da,0xb3d5f7fd,0x33e6c08f }, /* 114: -4.0230454e-08 -9.9636942e-08  1.0745236e-07 */
    { 0x4f6cb0f7,0xd081052b,0x50845e7a }, /* 115:  3.9710205e+09 -1.7316796e+10  1.7766273e+10 */
    { 0x56430775,0x55c0fc6b,0x56599821 }, /* 116:  5.3609199e+13  2.6523795e+13  5.9811853e+13 */
    { 0xc6117dfa,0xc5b0786d,0x462a2831 }, /* 117: -9.3114941e+03 -5.6470532e+03  1.0890048e+04 */
    { 0xba7fade7,0xb98d0474,0x3a849c94 }, /* 118: -9.7533915e-04 -2.6896934e-04  1.0117465e-03 */
    { 0x0eb9b114,0x16f7b329,0x16f7b329 }, /* 119:  4.5776541e-30  4.0018068e-25  4.0018068e-25 */
    { 0x92c98dc5,0x91a82dd4,0x12cde476 }, /* 120: -1.2719832e-27 -2.6533970e-28  1.2993639e-27 */
    { 0x5401ef12,0x542ea203,0x5459ab0f }, /* 121:  2.2322469e+12  3.0001697e+12  3.7395112e+12 */
    { 0x6feab8aa,0xf0a39878,0x70adcd23 }, /* 122:  1.4528547e+29 -4.0504304e+29  4.3031121e+29 */
    { 0xad26265f,0x2e14ec1e,0x2e1a9b4f }, /* 123: -9.4445276e-12  3.3861018e-11  3.5153488e-11 */
    { 0x499e5f41,0xca1fe151,0x4a326a5e }, /* 124:  1.2973841e+06 -2.6194762e+06  2.9231595e+06 */
    { 0x8c92d767,0x8c6e422e,0x0cbd1677 }, /* 125: -2.2624502e-31 -1.8354768e-31  2.9133581e-31 */
    { 0x8000016c,0x800000a1,0x0000018e }, /* 126: -5.1007264e-43 -2.2560905e-43  5.5771679e-43 */
    { 0xb28dc9f9,0xb2fd00ce,0x3311033e }, /* 127: -1.6506407e-08 -2.9453442e-08  3.3763392e-08 */
    { 0x9690ce91,0x1707e41b,0x1719f9e0 }, /* 128: -2.3394816e-25  4.3908762e-25  4.9752353e-25 */
    { 0x78255d60,0x77d36039,0x784440e6 }, /* 129:  1.3415982e+34  8.5744239e+33  1.5921976e+34 */
    { 0x3ebb245e,0x41451181,0x414527b7 }, /* 130:  3.6551183e-01  1.2316773e+01  1.2322196e+01 */
    { 0x38c04b60,0x3890e8d8,0x38f0c82b }, /* 131:  9.1693131e-05  6.9098256e-05  1.1481376e-04 */
    { 0xcb66f420,0x4c3a2d44,0x4c42eca7 }, /* 132: -1.5135776e+07  4.8805136e+07  5.1098268e+07 */
    { 0x90f4f418,0x90993cbc,0x111077c7 }, /* 133: -9.6617116e-29 -6.0441435e-29  1.1396506e-28 */
    { 0x8000f702,0x8001ccaa,0x00020ab5 }, /* 134: -8.8609707e-41 -1.6525513e-40  1.8751195e-40 */
    { 0xc753734e,0xc7e6fcbc,0x47fe0887 }, /* 135: -5.4131305e+04 -1.1826547e+05  1.3006505e+05 */
    { 0xc39178fc,0xc2eeae3a,0x439d3c20 }, /* 136: -2.9094519e+02 -1.1934029e+02  3.1446973e+02 */
    { 0x5f930232,0xdf8b0ec4,0x5fca5b85 }, /* 137:  2.1186168e+19 -2.0040323e+19  2.9162789e+19 */
    { 0x9a88c083,0x1950d81e,0x1a8b38b0 }, /* 138: -5.6559301e-23  1.0796992e-23  5.7580636e-23 */
    { 0xf3eab349,0x7725898f,0x77258c29 }, /* 139: -3.7189752e+31  3.3574961e+33  3.3577022e+33 */
    { 0xd0e0f398,0xe7f435d2,0x67f435d2 }, /* 140: -3.0192484e+10 -2.3065005e+24  2.3065005e+24 */
    { 0x47e7eab0,0x48cc340e,0x48d44659 }, /* 141:  1.1874138e+05  4.1820844e+05  4.3473878e+05 */
    { 0x800001fc,0x0000012c,0x0000024e }, /* 142: -7.1185962e-43  4.2038954e-43  8.2676609e-43 */
    { 0xd97110f8,0xd9992449,0x59c2e2de }, /* 143: -4.2408829e+15 -5.3881959e+15  6.8569486e+15 */
    { 0x59140597,0x5921debf,0x595b586b }, /* 144:  2.6040277e+15  2.8476489e+15  3.8587648e+15 */
    { 0x6b2c1574,0xec8ed575,0x6c9071c8 }, /* 145:  2.0803655e+26 -1.3814039e+27  1.3969811e+27 */
    { 0x5aede2c2,0xdcbcca94,0x5cbd6038 }, /* 146:  3.3479446e+16 -4.2512026e+17  4.2643651e+17 */
    { 0xc32c4305,0xbe5feceb,0x432c430e }, /* 147: -1.7226180e+02 -2.1867721e-01  1.7226193e+02 */
    { 0xba7444fb,0xb7aa6746,0x3a7453d7 }, /* 148: -9.3181402e-04 -2.0313670e-05  9.3203544e-04 */
    { 0xb41ca315,0x45329ae4,0x45329ae4 }, /* 149: -1.4587961e-07  2.8576807e+03  2.8576807e+03 */
    { 0x9de82835,0x9d2a42ae,0x1df745f3 }, /* 150: -6.1451462e-21 -2.2533785e-21  6.5452681e-21 */
    { 0x00000007,0x8000000e,0x00000010 }, /* 151:  9.8090893e-45 -1.9618179e-44  2.2420775e-44 */
    { 0xb6502728,0xb52c8ff1,0x36549394 }, /* 152: -3.1017207e-06 -6.4284455e-07  3.1676364e-06 */
    { 0xbf025a8e,0xc166e4b9,0x41670982 }, /* 153: -5.0919425e-01 -1.4430840e+01  1.4439821e+01 */
    { 0x88f409d4,0x8b84562f,0x0b84643e }, /* 154: -1.4687526e-33 -5.0974225e-32  5.0995378e-32 */
    { 0x57b249a4,0xd575606d,0x57b273d6 }, /* 155:  3.9205871e+14 -1.6862156e+13  3.9242116e+14 */
    { 0x6a109bd8,0xe8208764,0x6a10f4d6 }, /* 156:  4.3705317e+25 -3.0323046e+24  4.3810381e+25 */
    { 0xac5739de,0x2de62d9e,0x2de7bebe }, /* 157: -3.0585460e-12  2.6168231e-11  2.6346366e-11 */
    { 0xe6bd1097,0xe44e390b,0x66bd2cb3 }, /* 158: -4.4641665e+23 -1.5216559e+22  4.4667591e+23 */
    { 0x5d497e5b,0x5ca5cd96,0x5d59e1a7 }, /* 159:  9.0744639e+17  3.7335532e+17  9.8125084e+17 */
    { 0x2aef5d0e,0x13e9da4a,0x2aef5d0e }, /* 160:  4.2519498e-13  5.9032719e-27  4.2519498e-13 */
    { 0x26e58221,0xa7164788,0x273d1546 }, /* 161:  1.5925339e-15 -2.0855459e-15  2.6240551e-15 */
    { 0x91e27d9f,0x9175be53,0x1200d62d }, /* 162: -3.5733933e-28 -1.9385740e-28  4.0653670e-28 */
    { 0x71957c2f,0xf17f69da,0x71c49bb6 }, /* 163:  1.4804286e+30 -1.2647463e+30  1.9471138e+30 */
    { 0x466616e7,0x43f18d3f,0x46663698 }, /* 164:  1.4725726e+04  4.8310349e+02  1.4733648e+04 */
    { 0x879d283e,0x05ae27c4,0x079d889f }, /* 165: -2.3646387e-34  1.6377489e-35  2.3703033e-34 */
    { 0x8e3c9ed0,0x8ed8ed5a,0x0eec8a95 }, /* 166: -2.3249255e-30 -5.3476672e-30  5.8311941e-30 */
    { 0x5396b3a2,0xd3f4c400,0x540fb833 }, /* 167:  1.2945177e+12 -2.1025207e+12  2.4690827e+12 */
    { 0xae4a2117,0x2e8febac,0x2eafdc7e }, /* 168: -4.5958872e-11  6.5447509e-11  7.9972459e-11 */
    { 0x74f0033f,0x72e523f9,0x74f07088 }, /* 169:  1.5212611e+32  9.0771911e+30  1.5239669e+32 */
    { 0x5f6da58f,0x5f606d8e,0x5fa36f56 }, /* 170:  1.7124250e+19  1.6171738e+19  2.3553452e+19 */
    { 0xb2e43eef,0x3a4c33b3,0x3a4c33b3 }, /* 171: -2.6571312e-08  7.7896862e-04  7.7896862e-04 */
    { 0x6211bc0e,0xe1f16afd,0x623d3bb6 }, /* 172:  6.7208216e+20 -5.5667183e+20  8.7268431e+20 */
    { 0xa475bbe2,0xa3f7e787,0x24899ceb }, /* 173: -5.3285049e-17 -2.6877849e-17  5.9680108e-17 */
    { 0x4981506b,0xc2b97642,0x4981506b }, /* 174:  1.0593414e+06 -9.2730972e+01  1.0593414e+06 */
    { 0x16f5de97,0x9c0ef02b,0x1c0ef02e }, /* 175:  3.9722359e-25 -4.7294269e-22  4.7294284e-22 */
    { 0x80000003,0x00000007,0x00000008 }, /* 176: -4.2038954e-45  9.8090893e-45  1.1210388e-44 */
    { 0x679666c4,0x6b5ff2ab,0x6b5ff375 }, /* 177:  1.4205013e+24  2.7073642e+26  2.7074015e+26 */
    { 0x04b5fa3f,0x044f2fda,0x04d165d4 }, /* 178:  4.2782710e-36  2.4354705e-36  4.9229178e-36 */
    { 0xe46d9370,0xdc27d0e2,0x646d9370 }, /* 179: -1.7530009e+22 -1.8894396e+17  1.7530009e+22 */
    { 0xd818c4d3,0x581e3343,0x585bec01 }, /* 180: -6.7188448e+14  6.9577202e+14  9.6722670e+14 */
    { 0x4200ede5,0xc2f010ad,0x42f891e0 }, /* 181:  3.2232319e+01 -1.2003257e+02  1.2428491e+02 */
    { 0x9c6d6212,0x1d1cf310,0x1d27cb70 }, /* 182: -7.8543475e-22  2.0772088e-21  2.2207441e-21 */
    { 0xc9606e75,0xca510413,0x4a586a6a }, /* 183: -9.1927131e+05 -3.4245168e+06  3.5457545e+06 */
    { 0xfa5de91b,0x776fbfcb,0x7a5df133 }, /* 184: -2.8805639e+35  4.8626913e+33  2.8809743e+35 */
    { 0x2cf1866d,0xad3ccf83,0x2d602095 }, /* 185:  6.8645562e-12 -1.0732640e-11  1.2740160e-11 */
    { 0xdf4a5c1c,0xdf6900f4,0x5f9a4e19 }, /* 186: -1.4581560e+19 -1.6789688e+19  2.2237704e+19 */
    { 0x98eb6acd,0x02541cbb,0x18eb6acd }, /* 187: -6.0853917e-24  1.5583545e-37  6.0853917e-24 */
    { 0x678073cb,0xe81aa5cf,0x68277446 }, /* 188:  1.2131978e+24 -2.9212123e+24  3.1631203e+24 */
    { 0x94a5204c,0x95525680,0x1561f632 }, /* 189: -1.6673481e-26 -4.2477399e-26  4.5632602e-26 */
    { 0x28d5ca31,0xa8d582ec,0x291712e6 }, /* 190:  2.3735437e-14 -2.3704529e-14  3.3545127e-14 */
    { 0xec3db6cc,0x6ca96e42,0x6cc22d40 }, /* 191: -9.1740085e+26  1.6386331e+27  1.8779624e+27 */
    { 0x5cd2498a,0xdba5b79e,0x5cd65458 }, /* 192:  4.7352482e+17 -9.3290521e+16  4.8262706e+17 */
    { 0xc6873d0f,0x45e7bfee,0x46932061 }, /* 193: -1.7310529e+04  7.4159912e+03  1.8832189e+04 */
    { 0xb7a3063d,0x38f81e4c,0x38fb7181 }, /* 194: -1.9434019e-05  1.1831205e-04  1.1989754e-04 */
    { 0x7688abaa,0x75febab2,0x7696c767 }, /* 195:  1.3860042e+33  6.4581545e+32  1.5290799e+33 */
    { 0x2213e3ce,0xa0c22860,0x2215de38 }, /* 196:  2.0042814e-18 -3.2891596e-19  2.0310907e-18 */
    { 0x896d1790,0x89eb63ca,0x0a03c71c }, /* 197: -2.8538916e-33 -5.6668033e-33  6.3448689e-33 */
    { 0x145e031b,0x109eaaad,0x145e03fe }, /* 198:  1.1208748e-26  6.2582979e-29  1.1208923e-26 */
    { 0x057463c8,0x0790fdea,0x0791315f }, /* 199:  1.1491152e-35  2.1815949e-34  2.1846193e-34 */
    { 0x543a3438,0x539b425b,0x5449bcf7 }, /* 200:  3.1989600e+12  1.3336664e+12  3.4658349e+12 */
    { 0x1c8526b6,0x1ca3441e,0x1cd2ad79 }, /* 201:  8.8112083e-22  1.0804043e-21  1.3941476e-21 */
    { 0xf5e2d1a5,0x7696ebd9,0x76a138ef }, /* 202: -5.7505429e+32  1.5305236e+33  1.6349893e+33 */
    { 0xe79cc24a,0x68ee7532,0x68f1a81d }, /* 203: -1.4805463e+24  9.0086808e+24  9.1295317e+24 */
    { 0x706a8230,0xf0bda0d7,0x70def3a1 }, /* 204:  2.9030752e+29 -4.6949688e+29  5.5200161e+29 */
    { 0x4e60ffa6,0xce1e2348,0x4e89819e }, /* 205:  9.4371264e+08 -6.6327808e+08  1.1534866e+09 */
    { 0x0516076a,0x86476597,0x064ae4d0 }, /* 206:  7.0543279e-36 -3.7502377e-35  3.8160082e-35 */
    { 0xe8a65557,0x65218085,0x68a65691 }, /* 207: -6.2838966e+24  4.7666986e+22  6.2840776e+24 */
    { 0xc2997700,0xc308ae1a,0x431cbefa }, /* 208: -7.6732422e+01 -1.3668008e+02  1.5674600e+02 */
    { 0x851f024e,0x845c439c,0x05284623 }, /* 209: -7.4765674e-36 -2.5891920e-36  7.9122041e-36 */
    { 0xdcce6cba,0x5c52a647,0x5ce7be04 }, /* 210: -4.6482713e+17  2.3717028e+17  5.2183715e+17 */
    { 0x8abdf06a,0x8ae06165,0x0b12fd45 }, /* 211: -1.8290472e-32 -2.1607051e-32  2.8309116e-32 */
    { 0x755e0dd9,0x75939498,0x75b8ae48 }, /* 212:  2.8148700e+32  3.7416088e+32  4.6822142e+32 */
    { 0x10e85eea,0x90f5a683,0x1129123b }, /* 213:  9.1654103e-29 -9.6892013e-29  1.3337367e-28 */
    { 0xedb65085,0xeebf4f2a,0x6ec4a9ec }, /* 214: -7.0529517e+27 -2.9603670e+28  3.0432242e+28 */
    { 0x6c411376,0xe9e42c7a,0x6c413528 }, /* 215:  9.3365834e+26 -3.4480640e+25  9.3429483e+26 */
    { 0x3d21a28c,0xb8b7bc22,0x3d21a2a6 }, /* 216:  3.9461657e-02 -8.7611625e-05  3.9461754e-02 */
    { 0x00044ab0,0x8002768a,0x0004f2c4 }, /* 217:  3.9413481e-40 -2.2619480e-40  4.5442988e-40 */
    { 0x2fa003af,0xaed553f5,0x2fa8ab04 }, /* 218:  2.9106448e-10 -9.7010323e-11  3.0680536e-10 */
    { 0x3e132963,0x3e791f22,0x3e90aba1 }, /* 219:  1.4371257e-01  2.4328282e-01  2.8255942e-01 */
    { 0x4e48e3a2,0xc586b480,0x4e48e3a2 }, /* 220:  8.4259034e+08 -4.3105625e+03  8.4259034e+08 */
    { 0x889d75dc,0x88924530,0x08d6ea6c }, /* 221: -9.4768024e-34 -8.8033213e-34  1.2934769e-33 */
    { 0x6294f629,0x60ebd50e,0x6295b063 }, /* 222:  1.3739279e+21  1.3594803e+20  1.3806374e+21 */
    { 0x35e4f0a1,0x371d1a74,0x371fb042 }, /* 223:  1.7057356e-06  9.3640883e-06  9.5181767e-06 */
    { 0x3e000000,0xc14a3d22,0x414a3faa }, /* 224:  1.2500000e-01 -1.2639925e+01  1.2640543e+01 */
    { 0xf6cea7a9,0xfe51100b,0x7e51100b }, /* 225: -2.0957299e+33 -6.9472988e+37  6.9472988e+37 */
    { 0x352b6bec,0x362c1905,0x36315a76 }, /* 226:  6.3859511e-07  2.5644561e-06  2.6427711e-06 */
    { 0x1db686d4,0x9d725e19,0x1ddb17aa }, /* 227:  4.8314408e-21 -3.2077081e-21  5.7993285e-21 */
    { 0x101c5d47,0x0f5cc352,0x1025d195 }, /* 228:  3.0837434e-29  1.0884455e-29  3.2701968e-29 */
    { 0x58b71858,0x608d6d36,0x608d6d36 }, /* 229:  1.6105215e+15  8.1526887e+19  8.1526887e+19 */
    { 0xa8804e2c,0xad27a6cb,0x2d27a6d7 }, /* 230: -1.4244756e-14 -9.5298864e-12  9.5298968e-12 */
    { 0x2df083a0,0xae711407,0x2e86b42e }, /* 231:  2.7343294e-11 -5.4814844e-11  6.1256208e-11 */
    { 0x95e504b2,0x15e64ea0,0x1622658f }, /* 232: -9.2499771e-26  9.3020309e-26  1.3118302e-25 */
    { 0x2cee7acc,0xad178a9a,0x2d40d42b }, /* 233:  6.7780000e-12 -8.6141320e-12  1.0961047e-11 */
    { 0x9c5aeda5,0x1c186042,0x1c855e32 }, /* 234: -7.2437298e-22  5.0416992e-22  8.8255506e-22 */
    { 0x5f3d19de,0xdf0554f5,0x5f676138 }, /* 235:  1.3626166e+19 -9.6075733e+18  1.6672669e+19 */
    { 0x35b996dc,0x398f8adb,0x398f8b53 }, /* 236:  1.3827480e-06  2.7378541e-04  2.7378890e-04 */
    { 0x03e58159,0x031f7f4d,0x03f2f750 }, /* 237:  1.3489107e-36  4.6872035e-37  1.4280262e-36 */
    { 0xbf9f504e,0xbf687acb,0x3fc53642 }, /* 238: -1.2446382e+00 -9.0812367e-01  1.5407183e+00 */
    { 0x8000134f,0x8000098c,0x0000158a }, /* 239: -6.9266183e-42 -3.4247734e-42  7.7267597e-42 */
    { 0x21feb342,0xa191826b,0x2212aad5 }, /* 240:  1.7259159e-18 -9.8601035e-19  1.9877127e-18 */
    { 0x53a19a8e,0x528870e8,0x53a52a15 }, /* 241:  1.3881655e+12  2.9300490e+11  1.4187512e+12 */
    { 0x4965ef11,0x491d8ab7,0x498b5d1e }, /* 242:  9.4180906e+05  6.4529144e+05  1.1416678e+06 */
    { 0x6aded78b,0x6a0ce0b6,0x6ae9b5a9 }, /* 243:  1.3469970e+26  4.2577696e+25  1.4126879e+26 */
    { 0x4fa17621,0xd0c28202,0x50c6a6f1 }, /* 244:  5.4177469e+09 -2.6106401e+10  2.6662636e+10 */
    { 0xaf5a20da,0x3f0d5f28,0x3f0d5f28 }, /* 245: -1.9838656e-10  5.5223322e-01  5.5223322e-01 */
    { 0x5216f68c,0xd2d0653b,0x52dda4e5 }, /* 246:  1.6209537e+11 -4.4752578e+11  4.7597712e+11 */
    { 0x55d7ac7e,0x57bb44a9,0x57bbc0b2 }, /* 247:  2.9641981e+13  4.1180714e+14  4.1287259e+14 */
    { 0x75e9d4c8,0x75a38d81,0x760ead3a }, /* 248:  5.9283246e+32  4.1465548e+32  7.2345665e+32 */
    { 0xc87709a1,0x49d2edc1,0x49d52d58 }, /* 249: -2.5296652e+05  1.7279281e+06  1.7463470e+06 */
    { 0xb6704759,0x369601f5,0x36c02fd1 }, /* 250: -3.5804317e-06  4.4705762e-06  5.7276125e-06 */
    { 0x800013a6,0x80000e23,0x00001835 }, /* 251: -7.0485313e-42 -5.0712991e-42  8.6838466e-42 */
    { 0x7118a7a6,0xf13a584a,0x7170e3ce }, /* 252:  7.5591034e+29 -9.2273515e+29  1.1928288e+30 */
    { 0x0317df03,0x85eccaad,0x05ecd6da }, /* 253:  4.4630917e-37 -2.2267785e-35  2.2272257e-35 */
    { 0xcf021f21,0x4f679ec1,0x4f84d583 }, /* 254: -2.1830781e+09  3.8859410e+09  4.4571704e+09 */
    { 0x0b1c20de,0x8b3134ce,0x0b6c2c88 }, /* 255:  3.0069234e-32 -3.4128686e-32  4.5485448e-32 */
    { 0x27d4f7ae,0xa6ad888b,0x27d95764 }, /* 256:  5.9110355e-15 -1.2041296e-15  6.0324348e-15 */
    { 0x38988e76,0x391165ab,0x392430e8 }, /* 257:  7.2744602e-05  1.3866152e-04  1.5658478e-04 */
    { 0x8c8850b1,0x0c19b671,0x0c9c7d1f }, /* 258: -2.1002682e-31  1.1841593e-31  2.4110910e-31 */
    { 0x01d9935f,0x02f98d76,0x02ff696c }, /* 259:  7.9924678e-38  3.6668456e-37  3.7529392e-37 */
    { 0x9b6c6832,0x1dcaf027,0x1dcb1291 }, /* 260: -1.9555130e-22  5.3717266e-21  5.3752850e-21 */
    { 0xb2adea18,0xb562df6f,0x3562f019 }, /* 261: -2.0246304e-08 -8.4516699e-07  8.4540949e-07 */
    { 0xc4c5ca5a,0x46013de9,0x460395dd }, /* 262: -1.5823235e+03  8.2714775e+03  8.4214658e+03 */
    { 0x4ce21e00,0x4e04fc91,0x4e07f502 }, /* 263:  1.1855053e+08  5.5778618e+08  5.7024525e+08 */
    { 0x4094f25f,0xc08a2e3e,0x40cb2c23 }, /* 264:  4.6545863e+00 -4.3181448e+00  6.3491378e+00 */
    { 0x80000edc,0x800004b4,0x00000f96 }, /* 265: -5.3305394e-42 -1.6871634e-42  5.5911809e-42 */
    { 0x41bc6f11,0x41c1fc44,0x4207384a }, /* 266:  2.3554232e+01  2.4248177e+01  3.3804970e+01 */
    { 0xd672c031,0x55d6e2bb,0x5684bb93 }, /* 267: -6.6726817e+13  2.9533661e+13  7.2970580e+13 */
    { 0xfae73c81,0x7e15d0fd,0x7e15d3c7 }, /* 268: -6.0032387e+35  4.9785025e+37  4.9788646e+37 */
    { 0x8f6c0b1d,0x0f095154,0x0f888a3b }, /* 269: -1.1637839e-29  6.7702847e-30  1.3463880e-29 */
    { 0x14992e2f,0x150b25b7,0x151ed557 }, /* 270:  1.5467268e-26  2.8100578e-26  3.2076141e-26 */
    { 0x0000025c,0x80000160,0x000002bb }, /* 271:  8.4638427e-43 -4.9325706e-43  9.7950763e-43 */
    { 0x00000033,0x80000026,0x00000040 }, /* 272:  7.1466222e-44 -5.3249342e-44  8.9683102e-44 */
    { 0xa0100151,0xa132a856,0x21363fb0 }, /* 273: -1.2197710e-19 -6.0531537e-19  6.1748288e-19 */
    { 0x5a9dfdef,0x5901dae4,0x5a9ed2d5 }, /* 274:  2.2235387e+16  2.2844340e+15  2.2352429e+16 */
    { 0x0000000d,0x80000070,0x00000071 }, /* 275:  1.8216880e-44 -1.5694543e-43  1.5834673e-43 */
    { 0x14e110fc,0x14b8a8f7,0x15119017 }, /* 276:  2.2725893e-26  1.8645897e-26  2.9396184e-26 */
    { 0x800001f8,0x00003894,0x0000389d }, /* 277: -7.0625443e-43  2.0296407e-41  2.0309019e-41 */
    { 0x3f3dc3c5,0xc69fdd71,0x469fdd71 }, /* 278:  7.4126846e-01 -2.0462721e+04  2.0462721e+04 */
    { 0x00026b0f,0x8028ba18,0x0028cc75 }, /* 279:  2.2207638e-40 -3.7401777e-39  3.7467652e-39 */
    { 0xbf188933,0xbe01263f,0x3f1bea67 }, /* 280: -5.9584349e-01 -1.2612246e-01  6.0904545e-01 */
    { 0xbb7569ac,0xbb400485,0x3b9bcd8d }, /* 281: -3.7447019e-03 -2.9299569e-03  4.7547282e-03 */
    { 0x0fdaabff,0x974b659b,0x174b659b }, /* 282:  2.1562710e-29 -6.5721082e-25  6.5721082e-25 */
    { 0x10310a1a,0x10f26dd4,0x11010ace }, /* 283:  3.4914877e-29  9.5621387e-29  1.0179635e-28 */
    { 0x3521891f,0xb4eb5034,0x3547d791 }, /* 284:  6.0176711e-07 -4.3830516e-07  7.4446967e-07 */
    { 0xa2b5b289,0xa224d78b,0x22c78470 }, /* 285: -4.9249180e-18 -2.2340252e-18  5.4079282e-18 */
    { 0x14e736ea,0x942fe336,0x14f75fee }, /* 286:  2.3346699e-26 -8.8800516e-27  2.4978464e-26 */
    { 0x84ec815c,0x061481ae,0x06176ba8 }, /* 287: -5.5602131e-36  2.7930980e-35  2.8479037e-35 */
    { 0x00000098,0x000005b3,0x000005bb }, /* 288:  2.1299737e-43  2.0444945e-42  2.0557048e-42 */
    { 0x3a6aa94f,0xba495947,0x3a9a9a25 }, /* 289:  8.9516205e-04 -7.6808449e-04  1.1795206e-03 */
    { 0x00000004,0x00000008,0x00000009 }, /* 290:  5.6051939e-45  1.1210388e-44  1.2611686e-44 */
    { 0x33209a1b,0x33180d44,0x335d298b }, /* 291:  3.7393061e-08  3.5402323e-08  5.1493355e-08 */
    { 0x87610803,0x091e9602,0x091f355a }, /* 292: -1.6929473e-34  1.9089092e-33  1.9164015e-33 */
    { 0xc095d977,0xc0d6cf7b,0x4102f4dc }, /* 293: -4.6827960e+00 -6.7128272e+00  8.1847801e+00 */
    { 0x090e25b1,0x88ef027b,0x0939b519 }, /* 294:  1.7110351e-33 -1.4384872e-33  2.2353717e-33 */
    { 0x000000dc,0x00000078,0x000000fb }, /* 295:  3.0828566e-43  1.6815582e-43  3.5172591e-43 */
    { 0x74a4baaf,0x747b63a1,0x74cf350f }, /* 296:  1.0440956e+32  7.9668410e+31  1.3133320e+32 */
    { 0x0018e91c,0x800ba516,0x001b7f7d }, /* 297:  2.2876758e-39 -1.0694121e-39  2.5252926e-39 */
    { 0xbb68376d,0x3b819c98,0x3bae032d }, /* 298: -3.5433427e-03  3.9554350e-03  5.3104372e-03 */
    { 0xc1e3adee,0x4277a504,0x4288474c }, /* 299: -2.8459927e+01  6.1911148e+01  6.8139252e+01 */
    { 0x05992239,0x055d7768,0x05bcf9c0 }, /* 300:  1.4400622e-35  1.0413302e-35  1.7771179e-35 */
    { 0xa367365b,0xa274baca,0x236f2b98 }, /* 301: -1.2534045e-17 -3.3167052e-18  1.2965447e-17 */
    { 0x0b5949b9,0x8b6e34c6,0x0ba13613 }, /* 302:  4.1848143e-32 -4.5876835e-32  6.2096306e-32 */
    { 0x800a165f,0x8004fe91,0x000b418f }, /* 303: -9.2638020e-40 -4.5866320e-40  1.0337084e-39 */
    { 0xf932bfe7,0x7a9d6b4c,0x7a9eff37 }, /* 304: -5.8007568e+34  4.0868342e+35  4.1277964e+35 */
    { 0x8dd67f35,0x0e317865,0x0e4f5c04 }, /* 305: -1.3219392e-30  2.1874902e-30  2.5559024e-30 */
    { 0x80000003,0x8000000a,0x0000000a }, /* 306: -4.2038954e-45 -1.4012985e-44  1.4012985e-44 */
    { 0x00000045,0x800001a5,0x000001ab }, /* 307:  9.6689594e-44 -5.8994665e-43  5.9835444e-43 */
    { 0x02a8658a,0x84fb5ca8,0x04fb950a }, /* 308:  2.4743662e-37 -5.9094908e-36  5.9146687e-36 */
    { 0xdc15c257,0xdc3d067c,0x5c712915 }, /* 309: -1.6861380e+17 -2.1282360e+17  2.7152256e+17 */
    { 0xb3589934,0x3551ecc1,0x35525c61 }, /* 310: -5.0430756e-08  7.8203090e-07  7.8365525e-07 */
    { 0x38b6699f,0x396dd5eb,0x397eb95f }, /* 311:  8.6981097e-05  2.2681772e-04  2.4292384e-04 */
    { 0xe96acd6d,0x69b48c76,0x69d75cb8 }, /* 312: -1.7741171e+25  2.7283744e+25  3.2544613e+25 */
    { 0xb060ac65,0xb005c42e,0x3082bd63 }, /* 313: -8.1735713e-10 -4.8663906e-10  9.5125718e-10 */
    { 0x66197e49,0x7868468a,0x7868468a }, /* 314:  1.8121291e+23  1.8844431e+34  1.8844431e+34 */
    { 0xa983a5da,0x2a233844,0x2a2ffe2c }, /* 315: -5.8463393e-14  1.4496829e-13  1.5631306e-13 */
    { 0xf7a271f6,0xe1658137,0x77a271f6 }, /* 316: -6.5895585e+33 -2.6460096e+20  6.5895585e+33 */
    { 0x800001c4,0x00000049,0x000001ca }, /* 317: -6.3338691e-43  1.0229479e-43  6.4179470e-43 */
    { 0x80000074,0x000ebe92,0x000ebe92 }, /* 318: -1.6255062e-43  1.3540607e-39  1.3540607e-39 */
    { 0xa76117a8,0xa91f1bd6,0x291fbabf }, /* 319: -3.1237847e-15 -3.5329236e-14  3.5467069e-14 */
    { 0x800a4bf1,0x00782cf6,0x00789dae }, /* 320: -9.4559761e-40  1.1036388e-38  1.1076824e-38 */
    { 0x082c4fdc,0x856c8fa5,0x082c5a02 }, /* 321:  5.1853241e-34 -1.1123050e-35  5.1865171e-34 */
    { 0x521c9fbd,0x4f666690,0x521caa54 }, /* 322:  1.6817372e+11  3.8654812e+09  1.6821813e+11 */
    { 0x466fe8ec,0xc73a7d6d,0x4743e5bd }, /* 323:  1.5354230e+04 -4.7741426e+04  5.0149738e+04 */
    { 0x4466df97,0x449ad7a5,0x44c122ff }, /* 324:  9.2349359e+02  1.2387389e+03  1.5450936e+03 */
    { 0xc29ddf1f,0xc25b49bd,0x42c03622 }, /* 325: -7.8935783e+01 -5.4822010e+01  9.6105728e+01 */
    { 0x800046b2,0x00007a9a,0x00008d86 }, /* 326: -2.5360700e-41  4.3981154e-41  5.0769043e-41 */
    { 0x739844f0,0x72e1094b,0x73a25479 }, /* 327:  2.4128032e+31  8.9146063e+30  2.5722211e+31 */
    { 0x3dff3430,0xc26742c0,0x426742e3 }, /* 328:  1.2461126e-01 -5.7815186e+01  5.7815319e+01 */
    { 0x2e9de7fd,0xaf6959b8,0x2f765869 }, /* 329:  7.1807428e-11 -2.1223101e-10  2.2404979e-10 */
    { 0x10e0c123,0x10926ce8,0x11061f43 }, /* 330:  8.8649996e-29  5.7754643e-29  1.0580369e-28 */
    { 0xdb90119e,0x5b6be3af,0x5bba30ae }, /* 331: -8.1103534e+16  6.6396960e+16  1.0481574e+17 */
    { 0xc318c85d,0xc2024dd0,0x431c378b }, /* 332: -1.5278267e+02 -3.2575989e+01  1.5621696e+02 */
    { 0x4497e9b0,0x421aa7a5,0x4497fd5d }, /* 333:  1.2153027e+03  3.8663715e+01  1.2159176e+03 */
    { 0x80000ae6,0x80003352,0x00003477 }, /* 334: -3.9096227e-42 -1.8410259e-41  1.8820840e-41 */
    { 0x3b20ab8c,0x39e6758d,0x3b233b71 }, /* 335:  2.4516312e-03  4.3956601e-04  2.4907256e-03 */
    { 0x97e567e9,0x16d4d489,0x17eb7ed6 }, /* 336: -1.4825009e-24  3.4384576e-25  1.5218537e-24 */
    { 0x804b231b,0x80d2561f,0x00df5a9d }, /* 337: -6.9002557e-39 -1.9316349e-38  2.0511822e-38 */
    { 0x210ffee4,0x28bee27a,0x28bee27a }, /* 338:  4.8787630e-19  2.1192456e-14  2.1192456e-14 */
    { 0x6ef1812e,0x6f44d9aa,0x6f66ef74 }, /* 339:  3.7371028e+28  6.0922202e+28  7.1471033e+28 */
    { 0xb6689785,0xb61a832a,0x368b9e47 }, /* 340: -3.4658890e-06 -2.3024136e-06  4.1609487e-06 */
    { 0x0a50b6e0,0x0958a53d,0x0a57a097 }, /* 341:  1.0049231e-32  2.6077749e-33  1.0382077e-32 */
    { 0xbaa6daca,0x3bbd2a43,0x3bc1b5b1 }, /* 342: -1.2729999e-03  5.7728603e-03  5.9115519e-03 */
    { 0x496b6702,0x49ddae76,0x49fafd94 }, /* 343:  9.6420812e+05  1.8160148e+06  2.0561145e+06 */
    { 0x8e9a0433,0x0e2eb4e3,0x0eb11061 }, /* 344: -3.7967975e-30  2.1534250e-30  4.3649641e-30 */
    { 0xe3f28814,0xe5603916,0x65624361 }, /* 345: -8.9478351e+21 -6.6178946e+22  6.6781109e+22 */
    { 0x9c0f1597,0x9a7417cc,0x1c0fe535 }, /* 346: -4.7342635e-22 -5.0477240e-23  4.7610974e-22 */
    { 0x0d7dbde7,0x8d5bb09d,0x0da7d0d7 }, /* 347:  7.8190231e-31 -6.7697176e-31  1.0342446e-30 */
    { 0x358c9bc0,0x3693e7cf,0x3698067d }, /* 348:  1.0476142e-06  4.4079275e-06  4.5307083e-06 */
    { 0xdeaa5a33,0xcfe29d2f,0x5eaa5a33 }, /* 349: -6.1375899e+18 -7.6039040e+09  6.1375899e+18 */
    { 0x061f5fe8,0x0612ff84,0x0658d0a0 }, /* 350:  2.9975037e-35  2.7647271e-35  4.0778358e-35 */
    { 0xbbce11b2,0x3e4b3b69,0x3e4b5586 }, /* 351: -6.2887305e-03  1.9846882e-01  1.9856843e-01 */
    { 0xcaecd99a,0x49374350,0x4aedf48b }, /* 352: -7.7611010e+06  7.5064500e+05  7.7973175e+06 */
    { 0x24d248d1,0x2465fae7,0x24efabd0 }, /* 353:  9.1196338e-17  4.9868982e-17  1.0394079e-16 */
    { 0x3ed34bd6,0xbe608a21,0x3eef455f }, /* 354:  4.1268796e-01 -2.1927692e-01  4.6732613e-01 */
    { 0x3910a54d,0xb90a4bd1,0x39481ed8 }, /* 355:  1.3794489e-04 -1.3188949e-04  1.9084977e-04 */
    { 0x6e686801,0xeee72546,0x6f015b07 }, /* 356:  1.7981564e+28 -3.5768049e+28  4.0033612e+28 */
    { 0x2193564e,0xa2ddbdac,0x22e0c789 }, /* 357:  9.9839521e-19 -6.0102993e-18  6.0926588e-18 */
    { 0x09fbcabf,0x898fae35,0x0a10f37b }, /* 358:  6.0616714e-33 -3.4589821e-33  6.9791414e-33 */
    { 0x16b013b9,0x17ff3e60,0x1801817d }, /* 359:  2.8446780e-25  1.6494734e-24  1.6738234e-24 */
    { 0x39087b62,0xb784f812,0x39097d86 }, /* 360:  1.3015934e-04 -1.5851143e-05  1.3112099e-04 */
    { 0xee1b94cb,0xee1548cc,0x6e579e56 }, /* 361: -1.2037514e+28 -1.1550318e+28  1.6682673e+28 */
    { 0x1eee3574,0x9e64d7b2,0x1f0421d7 }, /* 362:  2.5221338e-20 -1.2114824e-20  2.7980079e-20 */
    { 0x9fa97389,0x1fdbf866,0x200ad5c6 }, /* 363: -7.1765421e-20  9.3161048e-20  1.1759786e-19 */
    { 0xb79d54b7,0x35fe4697,0x379e21ac }, /* 364: -1.8755307e-05  1.8945019e-06  1.8850747e-05 */
    { 0x42032321,0x4267e4ea,0x428533e7 }, /* 365:  3.2784306e+01  5.7973549e+01  6.6601372e+01 */
    { 0x0000ef2a,0x80015a8e,0x0001a512 }, /* 366:  8.5795900e-41 -1.2432040e-40  1.5105157e-40 */
    { 0x029c619c,0x023a09d7,0x02b5f486 }, /* 367:  2.2978165e-37  1.3667946e-37  2.6735909e-37 */
    { 0x9c1f9eba,0x9c630d34,0x1c8ac5b3 }, /* 368: -5.2813836e-22 -7.5125064e-22  9.1831780e-22 */
    { 0xd76712ef,0x5707c169,0x5786002d }, /* 369: -2.5406851e+14  1.4926476e+14  2.9467063e+14 */
    { 0x6ff15d33,0xf0671b80,0x70825c21 }, /* 370:  1.4939712e+29 -2.8609713e+29  3.2275543e+29 */
    { 0x6930a9ce,0xe53ca15f,0x6930aa33 }, /* 371:  1.3348302e+25 -5.5673854e+22  1.3348418e+25 */
    { 0x1168872f,0x12978f96,0x129a52a5 }, /* 372:  1.8343230e-28  9.5648364e-28  9.7391398e-28 */
    { 0x0000042a,0x80024863,0x00024867 }, /* 373:  1.4937842e-42 -2.0963845e-40  2.0964406e-40 */
    { 0x304c3404,0x2fe5bb68,0x306a4af9 }, /* 374:  7.4288686e-10  4.1788017e-10  8.5235247e-10 */
    { 0x00000010,0x8000001c,0x00000020 }, /* 375:  2.2420775e-44 -3.9236357e-44  4.4841551e-44 */
    { 0x82b30c6a,0x830b2dfe,0x03257c61 }, /* 376: -2.6308811e-37 -4.0901225e-37  4.8631922e-37 */
    { 0x8000019e,0x80000007,0x0000019e }, /* 377: -5.8013756e-43 -9.8090893e-45  5.8013756e-43 */
    { 0x925edde8,0x22a325e2,0x22a325e2 }, /* 378: -7.0324369e-28  4.4221349e-18  4.4221349e-18 */
    { 0xc6f3726d,0xc6e8045e,0x47282686 }, /* 379: -3.1161213e+04 -2.9698184e+04  4.3046523e+04 */
    { 0x86acb4c9,0x88959412,0x0895f7a5 }, /* 380: -6.4964849e-35 -9.0024225e-34  9.0258323e-34 */
    { 0x803ca9d6,0x800efe16,0x003e7d16 }, /* 381: -5.5710554e-39 -1.3768458e-39  5.7386731e-39 */
    { 0x17ef055c,0x186e5210,0x18854dbb }, /* 382:  1.5446366e-24  3.0802210e-24  3.4458182e-24 */
    { 0x7c745462,0xfcd5f1c1,0x7cf65dcf }, /* 383:  5.0745277e+36 -8.8869007e+36  1.0233662e+37 */
    { 0x8c497e3c,0x8e5d4181,0x0e5d9d2d }, /* 384: -1.5522464e-31 -2.7271892e-30  2.7316031e-30 */
    { 0x5e175a52,0xddad583c,0x5e2e69a2 }, /* 385:  2.7265299e+18 -1.5613499e+18  3.1419386e+18 */
    { 0x301b4ea2,0x2fadafa5,0x3031f033 }, /* 386:  5.6500415e-10  3.1593320e-10  6.4733569e-10 */
    { 0x8c190d9f,0x0dc850fb,0x0dc93a55 }, /* 387: -1.1790790e-31  1.2345447e-30  1.2401624e-30 */
    { 0xcd7486e4,0xcdc5ff1f,0x4de8b423 }, /* 388: -2.5640506e+08 -4.1522890e+08  4.8801494e+08 */
    { 0x5190eeee,0xcd75addf,0x5190ef22 }, /* 389:  7.7810483e+10 -2.5761330e+08  7.7810909e+10 */
    { 0x0000000f,0x0000000f,0x00000015 }, /* 390:  2.1019477e-44  2.1019477e-44  2.9427268e-44 */
    { 0x5c3b5232,0xdc094276,0x5c683a1e }, /* 391:  2.1090478e+17 -1.5454059e+17  2.6146438e+17 */
    { 0xb9e62a3a,0x38f87edd,0x39ee66c9 }, /* 392: -4.3900480e-04  1.1849192e-04  4.5471478e-04 */
    { 0x00000054,0x80000025,0x0000005c }, /* 393:  1.1770907e-43 -5.1848043e-44  1.2891946e-43 */
    { 0xaafc7776,0x2edb5269,0x2edb52fa }, /* 394: -4.4847085e-13  9.9736060e-11  9.9737066e-11 */
    { 0x0f62627f,0x0f940226,0x0fba5492 }, /* 395:  1.1161630e-29  1.4594754e-29  1.8373591e-29 */
    { 0xb80be18c,0x39899012,0x398aab68 }, /* 396: -3.3350239e-05  2.6238017e-04  2.6449119e-04 */
    { 0xe0ed47c0,0xe2cfb6c2,0x62d03e1d }, /* 397: -1.3678276e+20 -1.9158226e+21  1.9206993e+21 */
    { 0x7b9c1afa,0x7adcfc07,0x7ba597cb }, /* 398:  1.6210909e+36  5.7370852e+35  1.7196154e+36 */
    { 0xc5e06735,0x460f7c08,0x46362542 }, /* 399: -7.1809009e+03  9.1830078e+03  1.1657314e+04 */
    { 0xc61ac950,0x459e0f00,0x462dcb56 }, /* 400: -9.9063281e+03  5.0578750e+03  1.1122834e+04 */
    { 0x01873e22,0x81e52d48,0x02050d9f }, /* 401:  4.9680324e-38 -8.4186290e-38  9.7752059e-38 */
    { 0x51145447,0x5053f0d2,0x511d8239 }, /* 402:  3.9816819e+10  1.4223100e+10  4.2280915e+10 */
    { 0xca42863a,0x49a4efe6,0x4a53489c }, /* 403: -3.1870865e+06  1.3511648e+06  3.4616710e+06 */
    { 0x09deadba,0x88e8c636,0x09e62833 }, /* 404:  5.3607928e-33 -1.4009591e-33  5.5408289e-33 */
    { 0x37641a99,0x389b3328,0x389dcc1a }, /* 405:  1.3596052e-05  7.4005045e-05  7.5243603e-05 */
    { 0x1511f570,0x1516dc36,0x1551e94b }, /* 406:  2.9476133e-26  3.0465975e-26  4.2391250e-26 */
    { 0xff2c0d9a,0xff313673,0x7f76fec4 }, /* 407: -2.2869784e+38 -2.3555607e+38  3.2831291e+38 */
    { 0x1608415d,0x90f840b3,0x16084161 }, /* 408:  1.1006618e-25 -9.7918437e-29  1.1006622e-25 */
    { 0xab942ebe,0x2bf229b4,0x2c0df398 }, /* 409: -1.0529006e-12  1.7206709e-12  2.0172527e-12 */
    { 0x92e2a03f,0x13000000,0x132af326 }, /* 410: -1.4302109e-27  1.6155871e-27  2.1576898e-27 */
    { 0x40d89f54,0xc03d4ab9,0x40ec6566 }, /* 411:  6.7694492e+00 -2.9576857e+00  7.3873777e+00 */
    { 0x8f49a7f6,0x110e8007,0x110f0e6f }, /* 412: -9.9424132e-30  1.1241276e-28  1.1285159e-28 */
    { 0xc2e33d7f,0x3452095f,0x42e33d7f }, /* 413: -1.1362011e+02  1.9561183e-07  1.1362011e+02 */
    { 0x57598ad9,0x5711c991,0x5782f008 }, /* 414:  2.3919037e+14  1.6029491e+14  2.8793488e+14 */
    { 0x279d756e,0x263ee230,0x279f419c }, /* 415:  4.3703571e-15  6.6226033e-16  4.4202499e-15 */
    { 0xc56f8f90,0x4597e8ef,0x45c173e6 }, /* 416: -3.8329727e+03  4.8611167e+03  6.1904873e+03 */
    { 0x408b9364,0x41655f37,0x416fc0f2 }, /* 417:  4.3617420e+00  1.4335746e+01  1.4984606e+01 */
    { 0x39c254db,0xb9e91f1a,0x3a17bf99 }, /* 418:  3.7065786e-04 -4.4464396e-04  5.7887431e-04 */
    { 0x42dc9b7f,0xc23ebf6d,0x42f0574d }, /* 419:  1.1030370e+02 -4.7686939e+01  1.2017051e+02 */
    { 0x71683455,0xf38d9c24,0x738dcbb4 }, /* 420:  1.1498206e+30 -2.2438988e+31  2.2468428e+31 */
    { 0xc86f6de0,0xc835541d,0x48962c01 }, /* 421: -2.4517550e+05 -1.8568045e+05  3.0755203e+05 */
    { 0x66edeee7,0x680c282b,0x680f471d }, /* 422:  5.6180391e+23  2.6474891e+24  2.7064409e+24 */
    { 0xae3a28ec,0xae1055a1,0x2e6b8f0c }, /* 423: -4.2327850e-11 -3.2817863e-11  5.3559865e-11 */
    { 0xf9e8c8e5,0x78d5f75a,0x79eeda02 }, /* 424: -1.5108594e+35  3.4718004e+34  1.5502355e+35 */
    { 0x00000b78,0x00001559,0x0000183c }, /* 425:  4.1142123e-42  7.6580961e-42  8.6936557e-42 */
    { 0x1c3040b5,0x1bb94f0c,0x1c471f6d }, /* 426:  5.8317147e-22  3.0656766e-22  6.5884194e-22 */
    { 0x7902c39b,0xf8999084,0x7917a3e6 }, /* 427:  4.2435371e+34 -2.4917267e+34  4.9210068e+34 */
    { 0xb3a949be,0x368d870d,0x368d8d61 }, /* 428: -7.8830894e-08  4.2178494e-06  4.2185861e-06 */
    { 0x2633864b,0x2496d0f5,0x263482ff }, /* 429:  6.2285101e-16  6.5406117e-17  6.2627578e-16 */
    { 0x4f1660eb,0xce55ba2f,0x4f1f96cf }, /* 430:  2.5229340e+09 -8.9643718e+08  2.6774607e+09 */
    { 0x9aed5958,0x1b80bb13,0x1b8dbf82 }, /* 431: -9.8165245e-23  2.1296718e-22  2.3450252e-22 */
    { 0xec587252,0x6eb1afca,0x6eb1d0bc }, /* 432: -1.0466714e+27  2.7495681e+28  2.7515596e+28 */
    { 0x6bbbe215,0xeb64350b,0x6bdbd143 }, /* 433:  4.5427354e+26 -2.7588558e+26  5.3148593e+26 */
    { 0x3b17ddfd,0xbab1fce2,0x3b30057d }, /* 434:  2.3173087e-03 -1.3579393e-03  2.6858740e-03 */
    { 0xeab17e32,0xe9ed4642,0x6abb2492 }, /* 435: -1.0728791e+26 -3.5855900e+25  1.1312091e+26 */
    { 0xf78c5032,0xf3bcb57d,0x778c50b1 }, /* 436: -5.6917821e+33 -2.9902125e+31  5.6918608e+33 */
    { 0x28437dd3,0x265b0492,0x2843f85d }, /* 437:  1.0851958e-14  7.5987082e-16  1.0878530e-14 */
    { 0x8f9a0f29,0x8e0f2be1,0x0f9b1860 }, /* 438: -1.5191412e-29 -1.7647238e-30  1.5293569e-29 */
    { 0x76526d0a,0xf61a8a88,0x76828a10 }, /* 439:  1.0669862e+33 -7.8361666e+32  1.3238258e+33 */
    { 0x44638eee,0xc3a6053f,0x447239e3 }, /* 440:  9.1023328e+02 -3.3204099e+02  9.6890448e+02 */
    { 0xfc0367b5,0xfd3d1771,0x7d3fec8c }, /* 441: -2.7291773e+36 -1.5709113e+37  1.5944423e+37 */
    { 0x815eeec3,0x0a8c20a2,0x0a8c20a2 }, /* 442: -4.0946263e-38  1.3493785e-32  1.3493785e-32 */
    { 0x86f76f7e,0x86bfa088,0x071c7b26 }, /* 443: -9.3074897e-35 -7.2082094e-35  1.1772326e-34 */
    { 0x89ef9871,0x0f6c14f6,0x0f6c14f8 }, /* 444: -5.7680512e-33  1.1639735e-29  1.1639737e-29 */
    { 0x6f3150f9,0xef694328,0x6f9280bd }, /* 445:  5.4876737e+28 -7.2191194e+28  9.0680893e+28 */
    { 0x1ae28446,0x9adedfa6,0x1b1ee381 }, /* 446:  9.3685108e-23 -9.2178372e-23  1.3142964e-22 */
    { 0x0c10186e,0x0cee3696,0x0cf8deca }, /* 447:  1.1100708e-31  3.6702559e-31  3.8344536e-31 */
    { 0x92dabeaa,0x119271de,0x12ddc994 }, /* 448: -1.3804737e-27  2.3104915e-28  1.3996754e-27 */
    { 0x0d13c8aa,0x8c30ec62,0x0d1a42cc }, /* 449:  4.5539413e-31 -1.3629681e-31  4.7535318e-31 */
    { 0x24e7e9f1,0x25d40d85,0x25dbd608 }, /* 450:  1.0057659e-16  3.6785299e-16  3.8135477e-16 */
    { 0x00740a99,0x0099b5ab,0x00c097f0 }, /* 451:  1.0656719e-38  1.4116001e-38  1.7686920e-38 */
    { 0x9e28a70e,0x1d9b2838,0x1e39a3c7 }, /* 452: -8.9283920e-21  4.1069744e-21  9.8276868e-21 */
    { 0xf9e259ea,0x7a40d543,0x7a5f9782 }, /* 453: -1.4691035e+35  2.5031161e+35  2.9023879e+35 */
    { 0x3113c1d5,0x3190eb77,0x31a2aa26 }, /* 454:  2.1501496e-09  4.2177208e-09  4.7341642e-09 */
    { 0x487e521a,0xc7de7f3c,0x488acb4d }, /* 455:  2.6042441e+05 -1.1391847e+05  2.8425041e+05 */
    { 0xf9af58df,0x7aacae60,0x7ab22892 }, /* 456: -1.1380681e+35  4.4830590e+35  4.6252585e+35 */
    { 0xc7685853,0x4a8afe18,0x4a8b0121 }, /* 457: -5.9480324e+04  4.5545080e+06  4.5548965e+06 */
    { 0xa64a11f8,0xa869b4aa,0x286a0bf5 }, /* 458: -7.0107181e-16 -1.2973274e-14  1.2992202e-14 */
    { 0x589a66d5,0xda1c5352,0x5a1d832c }, /* 459:  1.3581316e+15 -1.1000427e+16  1.1083949e+16 */
    { 0x02df6746,0x84176237,0x0419f012 }, /* 460:  3.2826181e-37 -1.7795063e-36  1.8095298e-36 */
    { 0x83c7dc70,0x03e7f5fc,0x041917e6 }, /* 461: -1.1746779e-36  1.3633435e-36  1.7996037e-36 */
    { 0xf407dd38,0xf3bec66d,0x7426016d }, /* 462: -4.3057063e+31 -3.0229521e+31  5.2609265e+31 */
    { 0xe9955270,0xe9782702,0x69c224ea }, /* 463: -2.2564906e+25 -1.8749863e+25  2.9338241e+25 */
    { 0x726704ba,0xf320f69c,0x732b02d5 }, /* 464:  4.5757921e+30 -1.2752828e+31  1.3548892e+31 */
    { 0x0ceae0ea,0x8cf3f8db,0x0d29546e }, /* 465:  3.6188774e-31 -3.7589853e-31  5.2178774e-31 */
    { 0xa2cf1fae,0xa9d3f1ad,0x29d3f1ad }, /* 466: -5.6141005e-18 -9.4122064e-14  9.4122064e-14 */
    { 0x042d9bb3,0x8c19d45b,0x0c19d45b }, /* 467:  2.0407546e-36 -1.1850595e-31  1.1850595e-31 */
    { 0xde213cda,0x5dde9bd8,0x5e43ec93 }, /* 468: -2.9046002e+18  2.0050815e+18  3.5294551e+18 */
    { 0x6a3f6d86,0x68d8d550,0x6a41564e }, /* 469:  5.7855510e+25  8.1917287e+24  5.8432561e+25 */
    { 0x3de61d0f,0xbeb1d559,0x3ebae831 }, /* 470:  1.1236011e-01 -3.4733084e-01  3.6505273e-01 */
    { 0x5ddc46dd,0x5e8b0a62,0x5e958c89 }, /* 471:  1.9840771e+18  5.0094640e+18  5.3880693e+18 */
    { 0x8000077f,0x0000098c,0x00000c23 }, /* 472: -2.6890918e-42  3.4247734e-42  4.3538343e-42 */
    { 0x274d36ec,0x2798492b,0x27b7a0c1 }, /* 473:  2.8479238e-15  4.2267804e-15  5.0966993e-15 */
    { 0xfeabbf5b,0xff2237a8,0x7f378b89 }, /* 474: -1.1414578e+38 -2.1562392e+38  2.4397323e+38 */
    { 0x9a5273b7,0x15234652,0x1a5273bb }, /* 475: -4.3520456e-23  3.2973061e-26  4.3520468e-23 */
    { 0xc348f553,0x19de5239,0x4348f553 }, /* 476: -2.0095830e+02  2.2987471e-23  2.0095830e+02 */
    { 0xf86a0e7e,0x747d0736,0x786a0f07 }, /* 477: -1.8988928e+34  8.0187827e+31  1.8989098e+34 */
    { 0xe1352ad9,0xe15d33f4,0x618ef63c }, /* 478: -2.0887176e+20 -2.5502963e+20  3.2964759e+20 */
    { 0x0c7da3a4,0xa260dfa2,0x2260dfa2 }, /* 479:  1.9539655e-31 -3.0476051e-18  3.0476051e-18 */
    { 0xc9f1ca44,0xcb597684,0x4b5b8d9f }, /* 480: -1.9807445e+06 -1.4251652e+07  1.4388639e+07 */
    { 0x199c9025,0x1932990a,0x19b43d52 }, /* 481:  1.6188241e-23  9.2332903e-24  1.8636331e-23 */
    { 0xbbabbb44,0x432d949d,0x432d949d }, /* 482: -5.2408297e-03  1.7358052e+02  1.7358052e+02 */
    { 0xd9a092f1,0x593b3b79,0x59b9def3 }, /* 483: -5.6496950e+15  3.2938257e+15  6.5397507e+15 */
    { 0x00000038,0x00000028,0x00000045 }, /* 484:  7.8472714e-44  5.6051939e-44  9.6689594e-44 */
    { 0xb670633d,0xb43feee4,0x3670afd0 }, /* 485: -3.5820551e-06 -1.7875169e-07  3.5865123e-06 */
    { 0x4140dca6,0xcbf95305,0x4bf95305 }, /* 486:  1.2053869e+01 -3.2679434e+07  3.2679434e+07 */
    { 0xb54d4ec0,0x34ed5a96,0x356d23de }, /* 487: -7.6483047e-07  4.4210600e-07  8.8341574e-07 */
    { 0x64afaca1,0xe4b65b2d,0x64fd35ba }, /* 488:  2.5924955e+22 -2.6911019e+22  3.7367181e+22 */
    { 0x2e86a734,0xae17219c,0x2e9a6849 }, /* 489:  6.1233157e-11 -3.4363276e-11  7.0216340e-11 */
    { 0xb01e0fcf,0x2febdd19,0x30453588 }, /* 490: -5.7502531e-10  4.2903350e-10  7.1744255e-10 */
    { 0x3b42ee43,0xbbb6431c,0x3bceaf8b }, /* 491:  2.9744066e-03 -5.5621993e-03  6.3075474e-03 */
    { 0xfcd25875,0xfa5b887a,0x7cd27517 }, /* 492: -8.7374117e+36 -2.8497027e+35  8.7420576e+36 */
    { 0xe13d1905,0xe2117638,0x6218f374 }, /* 493: -2.1801484e+20 -6.7082411e+20  7.0536194e+20 */
    { 0xb872e347,0xb9a07342,0x39a34c27 }, /* 494: -5.7908965e-05 -3.0603452e-04  3.1146521e-04 */
    { 0xc09af9a5,0x4442e732,0x4442e828 }, /* 495: -4.8429742e+00  7.7961243e+02  7.7962744e+02 */
    { 0xd1f21248,0x52116abf,0x523d3297 }, /* 496: -1.2996110e+11  1.5614029e+11  2.0314939e+11 */
    { 0xfb127bee,0x7b89d86b,0x7b9c1867 }, /* 497: -7.6058893e+35  1.4314683e+36  1.6209865e+36 */
    { 0x8000000e,0x0000000c,0x00000012 }, /* 498: -1.9618179e-44  1.6815582e-44  2.5223372e-44 */
    { 0xfce696f6,0x7d6b2228,0x7d82f084 }, /* 499: -9.5783210e+36  1.9534121e+37  2.1756058e+37 */
    { 0xae54492e,0xae609b8e,0x2e9a86cf }, /* 500: -4.8268216e-11 -5.1069864e-11  7.0270560e-11 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, y, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	y.lo = pgm_read_dword (& t[i].y);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = hypot (x.fl, y.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 1) x_exit (i+1);
    }
    return 0;
}
