/*
 * Copyright 2001-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.axis.encoding.ser;

import org.apache.axis.Constants;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import javax.xml.namespace.QName;
import java.io.IOException;

/**
 * Serializer for QNames.
 */
public class QNameSerializer implements SimpleValueSerializer {

    /**
     * Serialize a QName.
     */
    public void serialize(QName name, Attributes attributes,
                          Object value, SerializationContext context)
        throws IOException
    {
        // NOTE:  getValueAsString has the side-effect of priming the context
        // with the QName's namespace, so it must be called BEFORE context.startElement.
        String qnameString = getValueAsString(value, context);
        context.startElement(name, attributes);
        context.writeString(qnameString);
        context.endElement();
    }

    public static String qName2String(QName qname, 
                                      SerializationContext context) {
        String str = context.qName2String(qname);
        // work around for default namespace
        if (str == qname.getLocalPart()) {
            String namespace = qname.getNamespaceURI();
            if (namespace != null && namespace.length() > 0) {
                String prefix = 
                    context.getPrefixForURI(qname.getNamespaceURI(), 
                                            null, true);
                return prefix + ":" + str;
            }
        }
        return str;
    }

    public String getValueAsString(Object value, SerializationContext context) {
        return qName2String((QName)value, context);
    }
    
    public String getMechanismType() { return Constants.AXIS_SAX; }

    /**
     * Return XML schema for the specified type, suitable for insertion into
     * the &lt;types&gt; element of a WSDL document, or underneath an
     * &lt;element&gt; or &lt;attribute&gt; declaration.
     *
     * @param javaType the Java Class we're writing out schema for
     * @param types the Java2WSDL Types object which holds the context
     *              for the WSDL being generated.
     * @return a type element containing a schema simpleType/complexType
     * @see org.apache.axis.wsdl.fromJava.Types
     */
    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}
