/* porting.cxx
     $Id: porting.cxx,v 1.4 2001/11/27 23:57:36 elf Exp $

   written by Marc Singer
   19 June 1998

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1998 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   -----------
   DESCRIPTION
   -----------

   Portability and compatibility routines.  Here, we implement
   functions that we expect to find in the standard library. 

*/

#include "std.h"
#include "porting.h"

#if !defined (HAVE_CFMAKERAW)
int cfmakeraw (struct termios *termios_p)
{
  termios_p->c_iflag &= ~(IGNBRK|BRKINT|PARMRK|ISTRIP|INLCR|IGNCR|ICRNL|IXON);
  termios_p->c_oflag &= ~OPOST;
  termios_p->c_lflag &= ~(ECHO|ECHONL|ICANON|ISIG|IEXTEN);
  termios_p->c_cflag &= ~(CSIZE|PARENB);
  termios_p->c_cflag |= CS8;
  return 0;			// Expected return value is not documented
}
#endif


#if !defined (HAVE_VSNPRINTF)

/* vsnprintf

   is a cowardly method for reimplementing the real function.  Since
   curves doesn't really depend on this call this hack is sufficient.
   I'll have to rething this at some point.  *** FIXME

*/  

int vsnprintf (char *sz, size_t cb, const char *szFormat, va_list ap)
{
  size_t result;
#if defined (HAVE_VSPRINTF)
  result = vsprintf (sz, szFormat, ap);
  if (result >= cb) {
    fprintf (stderr, "vsnprintf overrun error\n");
    exit (1);
  }
  return result;
#else
  fprintf (stderr, "vsnprintf or vsnprintf required for to run CurVeS\n");
  exit (1);
#endif
}

#endif 

#if !defined (HAVE_RINDEX)
char* rindex (const char *sz, int c)
{
# if defined (HAVE_STRRCHR)
  return strrchr (sz, c);
#  else
  const char* pch = sz + strlen (sz);
  do {
    if (*pch == c)
      return (char*) pch;
    --pch;
  } while (pch > sz);
  return NULL;
# endif
}

#endif
