/* termcap.f
     $Id: termcap.f,v 1.8 1998/06/14 20:34:02 elf Exp $

   written by Marc Singer
   20 December 1996

   Copyright (C) 1996 Straylight Software

   -----------
   DESCRIPTION
   -----------

   This file contains data to describe the termcap fields.  We declare
   the structures this way so that we can know that the order of the
   termcap identifiers is exactly the same as the order of the entries
   in the table.  In this way, we can use an array lookup to find the
   termcap data for an field given the id.

*/

__( termcapNul,			"  ", "", -1, 0 ) // dummy entry to reserve 0
__( termcapIsAutoMargins,	"am", "am", 1,		termcapClassBoolean )
__( termcapIsBackspace,		"bs", "", -1,		termcapClassBoolean )
__( termcapIsBackspaceWrap,	"bw", "", 0,		termcapClassBoolean )
__( termcap_PT,			"pt", "", -1,		0 ) // <undocumented>
__( termcapIsNewlineWrap,	"xn", "", -1,		termcapClassBoolean )
__( termcapIsSoftwareFlow,	"xo", "", 20,		termcapClassBoolean )
__( termcapIsSoftwareFlowReq,	"  ", "", 21,		termcapClassBoolean )
__( termcapIsMetaKey,		"km", "", 8,		termcapClassBoolean )
__( termcapIsMoveWhileInsert,	"mi", "", 13,		termcapClassBoolean )
__( termcapIsCanChange,		"  ", "", 27,		termcapClassBoolean )

__( termcapNumColumns,		"co", "cols", 0,	termcapClassNumber )
__( termcapNumLines,		"li", "", 2,		termcapClassNumber )
__( termcapNumTabSpacing,	"it", "", 1,		termcapClassNumber )
__( termcapNumVirtualTerminal,	"vt", "", 6,		termcapClassNumber )
__( termcapNumAttributes,	"  ", "", 11,		termcapClassNumber )
__( termcapNumColors,		"  ", "", 13,		termcapClassNumber )
__( termcapNumPairs,		"  ", "", 14,		termcapClassNumber )

__( termcapInitCursorMotion,	"ti", "", -1,		termcapClassMethod )
__( termcapInit1,		"i1", "", -1,		termcapClassMethod )
__( termcapInit,		"is", "", 49,		termcapClassMethod )
__( termcapInit3,		"i3", "", -1,		termcapClassMethod )
__( termcapResetCursorMotion,	"te", "", -1,		termcapClassMethod )
__( termcapReset,		"rs", "", -1,		termcapClassMethod )
__( termcapReset1,		"r1", "", -1,		termcapClassMethod )
__( termcapReset2,		"r2", "", -1,		termcapClassMethod )
__( termcapReset3,		"r3", "", -1,		termcapClassMethod )
__( termcapResetTabs,		"ct", "",  4,		termcapClassMethod )

__( termcapSetTab,		"st", "", 132,		termcapClassMethod )

__( termcapEnableACS,		"eA", "", 155,		termcapClassMethod )
__( termcapStartACS,		"as", "", 25,		termcapClassMethod )
__( termcapEndACS,		"ae", "", 38,		termcapClassMethod )
__( termcapEnableKeypad,	"ks", "", 89,		termcapClassMethod )
__( termcapDisableKeypad,	"ke", "", 88,		termcapClassMethod )
__( termcapEnableAutoMargins,	"RA", "", -1,		termcapClassMethod )
__( termcapDisableAutoMargins,	"SA", "", -1,		termcapClassMethod )

__( termcapAudibleBell,		"bl", "",  1,		termcapClassMethod )
__( termcapVisibleBell,		"vb", "", 45,		termcapClassMethod )

__( termcapCarriageReturn,	"cr", "",  2,		termcapClassString )
__( termcapTab,			"ta", "", 134,		termcapClassString )
__( termcapBacktab,		"  ", "",  0,		termcapClassString )
__( termcapACS,			"ac", "", 146,		termcapClassStringMap )
__( termcapContinue,		"tc", "", -1,		termcapClassString )

__( termcapCursorStandout,	"vs", "", -1,		termcapClassMethod )
__( termcapCursorInvisible,	"vi", "", 13,		termcapClassMethod )
__( termcapCursorVisible,	"  ", "", 20,		termcapClassMethod )
__( termcapCursorNormal,	"ve", "", 16,		termcapClassMethod )
__( termcapCursorSave,		"sc", "", 128,		termcapClassMethod )
__( termcapCursorRestore,	"rc", "", 126,		termcapClassMethod )

						// MoveTo row %1, col %2
__( termcapMoveTo,		"cm", "", 10,		termcapClassMethod )
__( termcapMoveToLowerLeft,	"ll", "", 18,		termcapClassMethod )
__( termcapMoveHome,		"ho", "", 12,		termcapClassMethod )
__( termcapUpOne,		"up", "", 19,		termcapClassMethod )
						// Up %1 lines
__( termcapUp,			"UP", "", 114,		termcapClassMethod )
__( termcapDownOne,		"do", "", 11,		termcapClassMethod )
						// Down %1 lines
__( termcapDown,		"DO", "", 107,		termcapClassMethod )
__( termcapLeftOne,		"le", "", 14,		termcapClassMethod )
						// Left %1 chars
__( termcapLeft,		"LE", "", 111,		termcapClassMethod )
__( termcapRightOne,		"nd", "", 17,		termcapClassMethod )
						// Right %1 chars
__( termcapRight,		"RI", "", 113, 		termcapClassMethod )

__( termcapDeleteCharacter,	"dc", "", 21,		termcapClassMethod )
__( termcapDeleteCharacters,	"  ", "", 105,		termcapClassMethod )
__( termcapDeleteLine,		"dl", "", 22,		termcapClassMethod )
__( termcapDeleteLines,		"  ", "", 106,		termcapClassMethod )
__( termcapInsertLine,		"al", "", 53,		termcapClassMethod )
__( termcapInsertCharacter,	"ic", "", 52,		termcapClassMethod )
						// Insert %d characters
__( termcapInsertCharacters,	"IC", "", -1,		termcapClassMethod )
 
__( termcapClearScreen,		"cl", "",  5,		termcapClassMethod )
__( termcapClearBOL,		"cb", "", -1,		termcapClassMethod )
__( termcapClearEOL,		"ce", "",  6,		termcapClassMethod )
__( termcapClearEOS,		"cd", "",  7,		termcapClassMethod )

__( termcapScrollForwardLine,	"sf", "", 129,		termcapClassMethod )
__( termcapScrollReverseLine,	"sr", "", 130,		termcapClassMethod )
						// ScrollRegion from %1 to %2
__( termcapScrollRegion,	"cs", "", -1,		termcapClassMethod )

__( termcapStartStandout,	"so", "", 35,		termcapClassMethod )
__( termcapEndStandout,		"se", "", 43,		termcapClassMethod )
__( termcapStartUnderline,	"us", "", 36,		termcapClassMethod )
__( termcapEndUnderline,	"ue", "", 44,		termcapClassMethod )
__( termcapStartBold,		"md", "", 27,		termcapClassMethod )
__( termcapStartInverse,	"mr", "", 34,		termcapClassMethod )
__( termcapStartBlink,		"mb", "", 26,		termcapClassMethod )
__( termcapEndMode,		"me", "", 39,		termcapClassMethod )
__( termcapStartInsert,		"im", "", 31,		termcapClassMethod )
__( termcapEndInsert,		"ei", "", 42,		termcapClassMethod )
__( termcapStartGraphics,	"as", "", -1,		termcapClassMethod )
__( termcapEndGraphics,		"ae", "", -1,		termcapClassMethod )

__( termcapKeyUp,		"ku", "", 87,		termcapClassKey )
__( termcapKeyDown,		"kd", "", 61,		termcapClassKey )
__( termcapKeyLeft,		"kl", "", 79,		termcapClassKey )
__( termcapKeyRight,		"kr", "", 83,		termcapClassKey )
__( termcapKeyBackspace,	"kb", "", 55,		termcapClassKey )
__( termcapKeyPrevious,		"kP", "", 82,		termcapClassKey )
__( termcapKeyNext,		"kN", "", 81,		termcapClassKey )
						// <cursor home down key>
__( termcap_kH,			"kH", "", -1,		0 )
__( termcapKeyHome,		"kh", "", 76,		termcapClassKey )
__( termcapKeyEnd,		"@7", "", 164,		termcapClassKey )
__( termcapKeyDelete,		"kD", "", 59,		termcapClassKey )
__( termcapKeyInsert,		"kI", "", 77,		termcapClassKey )
__( termcapKeyF0,		"k0", "", 65,		termcapClassKey )
__( termcapKeyF1,		"k1", "", 66,		termcapClassKey )
__( termcapKeyF2,		"k2", "", 68,		termcapClassKey )
__( termcapKeyF3,		"k3", "", 69,		termcapClassKey )
__( termcapKeyF4,		"k4", "", 70,		termcapClassKey )
__( termcapKeyF5,		"k5", "", 71,		termcapClassKey )
__( termcapKeyF6,		"k6", "", 72,		termcapClassKey )
__( termcapKeyF7,		"k7", "", 73,		termcapClassKey )
__( termcapKeyF8,		"k8", "", 74,		termcapClassKey )
__( termcapKeyF9,		"k9", "", 75,		termcapClassKey )
__( termcapKeyF10,		"k;", "", 67,		termcapClassKey )
__( termcapKeyF11,		"F1", "", 216,		termcapClassKey )
__( termcapKeyF12,		"F2", "", 217,		termcapClassKey )
__( termcapKeyF13,		"  ", "", 218,		termcapClassKey )
__( termcapKeyF14,		"  ", "", 219,		termcapClassKey )
__( termcapKeyF15,		"  ", "", 220,		termcapClassKey )
__( termcapKeyF16,		"  ", "", 221,		termcapClassKey )
__( termcapKeyF17,		"  ", "", 222,		termcapClassKey )
__( termcapKeyF18,		"  ", "", 223,		termcapClassKey )
__( termcapKeyF19,		"  ", "", 224,		termcapClassKey )
__( termcapKeyF20,		"  ", "", 225,		termcapClassKey )
__( termcapKeypadUL,		"K1", "", -1,		termcapClassKey )
__( termcapKeypadCenter,	"K2", "", -1,		termcapClassKey )
__( termcapKeypadUR,		"K3", "", -1,		termcapClassKey )
__( termcapKeypadLL,		"K4", "", -1,		termcapClassKey )
__( termcapKeypadLR,		"K5", "", -1,		termcapClassKey )

__( termcapSetForeground,	"  ", "", 302,		termcapClassMethod )
__( termcapSetBackground,	"  ", "", 303,		termcapClassMethod )
__( termcapSetAnsiForeground,	"  ", "", 359,		termcapClassMethod )
__( termcapSetAnsiBackground,	"  ", "", 360,		termcapClassMethod )
