module Control.Applicative.HT where

import qualified Data.Tuple.HT as Tuple

import Control.Applicative (Applicative, liftA2, liftA3, (<$>), (<*>), )

mapPair :: (Applicative f) => (a -> f c, b -> f d) -> (a,b) -> f (c,d)
mapPair fg = uncurry (liftA2 (,)) . Tuple.mapPair fg

mapTriple ::
   (Applicative m) => (a -> m d, b -> m e, c -> m f) -> (a,b,c) -> m (d,e,f)
mapTriple fgh = Tuple.uncurry3 (liftA3 (,,)) . Tuple.mapTriple fgh


{-# INLINE liftA4 #-}
liftA4 :: Applicative f =>
   (a -> b -> c -> d -> e) ->
   f a -> f b -> f c -> f d -> f e
liftA4 f a b c d = f <$> a <*> b <*> c <*> d

{-# INLINE liftA5 #-}
liftA5 :: Applicative f =>
   (a -> b -> c -> d -> e -> g) ->
   f a -> f b -> f c -> f d -> f e -> f g
liftA5 f a b c d e = f <$> a <*> b <*> c <*> d <*> e

{-# INLINE liftA6 #-}
liftA6 :: Applicative f =>
   (a -> b -> c -> d -> e -> g -> h) ->
   f a -> f b -> f c -> f d -> f e -> f g -> f h
liftA6 f a b c d e g = f <$> a <*> b <*> c <*> d <*> e <*> g
