/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.widget;

import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;


public class UpperCaseTextField extends JTextField {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private int maxLength = 1024;
    private JComponent next = null;

    public UpperCaseTextField(int cols) {
        super(cols);
    }

    public void setMaxLength(int maxLength) {

        this.maxLength = maxLength;
    }

    public void setNext(JComponent next) {

        this.next = next;
    }

    @Override
    protected Document createDefaultModel() {

        return new UpperCaseDocument();
    }

    class UpperCaseDocument extends PlainDocument {

        /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Override
	public void insertString(int offs, String str, AttributeSet a)
            throws BadLocationException {

            if ((str == null) || (getLength() >= maxLength)) {

                return;
            }

            char[] upper = str.toCharArray();

            for (int i = 0; i < upper.length; i++) {

                upper[i] = Character.toUpperCase(upper[i]);
            }

            super.insertString(offs, new String(upper), a);

            if (getLength() >= maxLength) {

                if (next != null) {

                    next.requestFocus();
                }

                return;
            }
        }
    }
}
/*
 * $Log$
 */
