/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.progress;

public class ProgressAdapter implements ProgressVetoListener, ProgressTimeListener {

	private int progressMaximum = 0;
	private int progressCounter = 0;
	private long progressStartTime = System.currentTimeMillis();

	public int getProgressCounter() {
		return progressCounter;
	}

	public int getProgressMaximum() {
		return progressMaximum;
	}

	public long getProgressStartTime() {
		return progressStartTime;
	}

	public boolean isCanceled() {
		return false;
	}

	public boolean progress(ProgressEvent event) {
		progressCounter++;
		return true;
	}

	public void setProgressMaximum(int max) {
		this.progressMaximum = max;
	}

	public void setProgressStartTime(long startTime) {
		progressStartTime = startTime;
	}

	public boolean veto(ProgressEvent event) {
		return false;
	}

}
