/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor.javadoc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Emphasis;
import org.dbdoclet.tag.docbook.Link;
import org.dbdoclet.tag.docbook.Xref;
import org.dbdoclet.tag.javadoc.Linkplain;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.internal.html.docbook.editor.DocBookEditor;

public class LinkplainEditor extends DocBookEditor {

	private static Log logger = LogFactory.getLog(LinkplainEditor.class);

	@Override
	public EditorInstruction edit(EditorInstruction values) {

		setValues(values);
		DocBookTagFactory dbfactory = getTagFactory();

		Linkplain linkplain = (Linkplain) getHtmlElement();

		String ref = linkplain.getRef();
		logger.debug("ref=" + ref);

		if ((ref != null) && (ref.length() > 0)) {

			String label = linkplain.getTextContent();
			String name = linkplain.getAttribute("name");

			if (label != null && label.length() > 0) {

				Link elem = dbfactory.createLink(label, ref);
				setCurrent(elem);

			} else if (name != null && name.length() > 0) {
				
				Link elem = dbfactory.createLink(name, ref);
				setCurrent(elem);

			} else {
				
				Xref elem = dbfactory.createXref(ref);
				setCurrent(elem);
			}

		} else {

			Emphasis elem = dbfactory.createEmphasis(linkplain.getName());
			setCurrent(elem);
		}

		getParent().appendChild(getCurrent());

		traverse(false);

		return finalizeValues();
	}
}