/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.dita;

import org.dbdoclet.tag.TagFactory;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.xiphias.dom.TextImpl;
import org.w3c.dom.Element;

public class DitaTagFactory extends TagFactory {

	public Abstract createAbstract() {

		Abstract _abstract = new Abstract();
		return _abstract;
	}

	public B createB() {
		return new B();
	}
	
	public Body createBody() {
		return new Body();
	}

	public P createP() {
		return new P();
	}

	public P createP(String text) {
		P p = new P();
		p.appendChild(new TextImpl(text));
		return p;
	}

	public Prolog createProlog() {
		return new Prolog();
	}

	public Section createSection() {
		return new Section();
	}

	public Title createTitle() {

		Title title = new Title();
		return title;
	}

	public Title createTitle(String str) {

		Title title = new Title(str);
		return title;
	}

	public Topic createTopic() {
		return new Topic();
	}

	public Tt createTt() {
		return new Tt();
	}

	public U createU() {
		return new U();
	}

	@Override
	public Element createElement(String mapTo) {
		return null;
	}

	@Override
	protected void initialize(DocBookElement elem) {
	}
}
