/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html;

import java.io.IOException;
import java.util.ArrayList;

import org.dbdoclet.html.parser.ParserException;
import org.dbdoclet.html.tokenizer.TokenizerException;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlFragment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public interface IHtmlProvider {

	public Document traverse(HtmlDocument htmlDocument, IHtmlVisitor visitor) throws Exception;
	public DocumentFragment traverse(HtmlFragment htmlFragment, IHtmlVisitor visitor);

	public HtmlDocument parseDocument(String htmlCode) throws IOException,
			ParserException, TokenizerException;

	public HtmlFragment parseFragment(String htmlCode) throws IOException,
			ParserException, TokenizerException;
	public void setProgressListeners(ArrayList<ProgressListener> listeners);
}
