/* $Id: Packed_seqpnt.hpp 103491 2007-05-04 17:18:18Z kazimird $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqloc.asn'.
 */

#ifndef OBJECTS_SEQLOC_PACKED_SEQPNT_HPP
#define OBJECTS_SEQLOC_PACKED_SEQPNT_HPP


// generated includes
#include <objects/seqloc/Packed_seqpnt_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class NCBI_SEQLOC_EXPORT CPacked_seqpnt : public CPacked_seqpnt_Base
{
    typedef CPacked_seqpnt_Base Tparent;
public:
    //
    // See CPacked_seqpnt related function in util/sequence.hpp:
    //
    //   bool IsValid(const CPacked_seqpnt&, CScope*);
    //

    // constructor
    CPacked_seqpnt(void);
    CPacked_seqpnt(TId& id, const TPoints& points, TStrand strand = eNa_strand_unknown);

    // destructor
    ~CPacked_seqpnt(void);

    // check start or stop end of location for e_Lim fuzz
    bool IsPartialStart(ESeqLocExtremes ext) const;
    bool IsPartialStop (ESeqLocExtremes ext) const;

    // set / remove e_Lim fuzz on start or stop end
    void SetPartialStart(bool val, ESeqLocExtremes ext);
    void SetPartialStop (bool val, ESeqLocExtremes ext);
        
    /// check if parts of the seq-loc are missing
    bool IsTruncatedStart(ESeqLocExtremes ext) const;
    bool IsTruncatedStop (ESeqLocExtremes ext) const;

    /// set / remove e_Lim fuzz on start or stop
    /// (tl/tr - indicating removed parts of the seq-loc)
    void SetTruncatedStart(bool val, ESeqLocExtremes ext);
    void SetTruncatedStop (bool val, ESeqLocExtremes ext);

    // Add a point to the collection. 
    void AddPoint(TSeqPos point);
    void AddPoints(const TPoints& points);
    
    TSeqPos GetStart(ESeqLocExtremes ext) const;
    TSeqPos GetStop (ESeqLocExtremes ext) const;

    // Flip the strand (e.g. plus to minus)
    void FlipStrand(void);

private:
    // Prohibit copy constructor and assignment operator
    CPacked_seqpnt(const CPacked_seqpnt& value);
    CPacked_seqpnt& operator=(const CPacked_seqpnt& value);

    bool x_IsMinusStrand(void) const;
};



/////////////////// CPacked_seqpnt inline methods

// constructor
inline
CPacked_seqpnt::CPacked_seqpnt(void)
{
}


inline
CPacked_seqpnt::CPacked_seqpnt(TId& id, const TPoints& points, TStrand strand)
{
    SetId(id);
    copy(points.begin(), points.end(), back_inserter(SetPoints()));
    if ( strand != eNa_strand_unknown ) {
        SetStrand(strand);
    }
}


inline
void CPacked_seqpnt::AddPoint(TSeqPos point)
{
    SetPoints().push_back(point);
}


inline
void CPacked_seqpnt::AddPoints(const TPoints& points)
{
    copy(points.begin(), points.end(), back_inserter(SetPoints()));
}


/////////////////// end of CPacked_seqpnt inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_PACKED_SEQPNT_HPP
/* Original file checksum: lines: 90, chars: 2468, CRC32: e995f3e6 */
