/* $Id: Blast4_database.hpp 136117 2008-07-30 19:25:58Z camacho $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_database.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Blast4_database_.hpp


#ifndef OBJECTS_BLAST_BLAST4_DATABASE_HPP
#define OBJECTS_BLAST_BLAST4_DATABASE_HPP


// generated includes
#include <objects/blast/Blast4_database_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_database : public CBlast4_database_Base
{
    typedef CBlast4_database_Base Tparent;
public:
    // constructor
    CBlast4_database(void);
    // destructor
    ~CBlast4_database(void);

    bool operator==(const CBlast4_database& rhs) const;
    bool operator!=(const CBlast4_database& rhs) const;

    /// Returns true if the database is protein
    bool IsProtein() const;

private:
    // Prohibit copy constructor and assignment operator
    CBlast4_database(const CBlast4_database& value);
    CBlast4_database& operator=(const CBlast4_database& value);

};

/////////////////// CBlast4_database inline methods

// constructor
inline
CBlast4_database::CBlast4_database(void)
{
}

inline bool
CBlast4_database::operator==(const CBlast4_database& rhs) const
{
    if (this == &rhs) {
        return true;
    }

    if (GetName() != rhs.GetName()) {
        return false;
    }

    if (GetType() != rhs.GetType()) {
        return false;
    }
    return true;
}

inline bool
CBlast4_database::operator!=(const CBlast4_database& rhs) const
{
    return !(*this == rhs);
}

inline bool
CBlast4_database::IsProtein() const
{
    return (GetType() == objects::eBlast4_residue_type_protein) ? true : false;
}

/////////////////// end of CBlast4_database inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_BLAST_BLAST4_DATABASE_HPP
/* Original file checksum: lines: 94, chars: 2685, CRC32: a03b1a96 */
