/* $Id: Blast4_parameters.hpp 121112 2008-03-03 15:03:30Z camacho $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_parameters.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Blast4_parameters_.hpp


#ifndef OBJECTS_BLAST_BLAST4_PARAMETERS_HPP
#define OBJECTS_BLAST_BLAST4_PARAMETERS_HPP


// generated includes
#include <objects/blast/Blast4_parameters_.hpp>

#include <objects/blast/Blast4_value.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_parameters : public CBlast4_parameters_Base
{
    typedef CBlast4_parameters_Base Tparent;
public:
    /// constructor
    CBlast4_parameters(void);
    /// destructor
    ~CBlast4_parameters(void);

    /// Append Blast4_parameter
    ///
    /// If node with the specified name exists, the value is substituted
    ///
    /// @param name
    ///    A string containing Blast4_parameter node name
    /// @param  value 
    ///   An int conatinig Blast4_parameter value
    /// @return 
    ///   CRef to created Blast4_parameter    
    CRef< CBlast4_parameter> Add(const string name,const int &value); 

    
    /// Append Blast4_parameter
    ///
    /// If node with the specified name exists, the value is substituted
    ///
    /// @param name
    ///    A string containing Blast4_parameter node name
    /// @param  value 
    ///   A string conatinig Blast4_parameter value
    /// @return 
    ///   CRef to created Blast4_parameter    
    CRef< CBlast4_parameter> Add(const string name,const string &value); 

    /// Append Blast4_parameter
    ///
    /// If node with the specified name exists, the value is substituted
    ///
    /// @param name
    ///    A string containing Blast4_parameter node name
    /// @param  value 
    ///   A boolean containing Blast4_parameter value
    /// @return 
    ///   CRef to created Blast4_parameter    
    CRef< CBlast4_parameter> Add(const string name,const bool &value); 

    /// Append Blast4_parameter
    ///
    /// If node with the specified name exists, the value is substituted
    ///
    /// @param name
    ///    A string containing Blast4_parameter node name
    /// @param  value 
    ///   A double containing Blast4_parameter value
    /// @return 
    ///   CRef to created Blast4_parameter    
    CRef< CBlast4_parameter> Add(const string name,const double &value); 

    /// Append Blast4_parameter
    ///
    /// If node with the specified name exists, the value is substituted
    ///
    /// @param name
    ///    A string containing Blast4_parameter node name
    /// @param  value 
    ///   A Int8 containing Blast4_parameter value
    /// @return 
    ///   CRef to created Blast4_parameter    
    CRef< CBlast4_parameter> Add(const string name,const Int8 &value); 

    /// Append Blast4_parameter
    ///
    /// If node with the specified name exists, the value is substituted
    ///
    /// @param name
    ///    A string containing Blast4_parameter node name
    /// @param  value 
    ///   A  EBlast4_strand_type containing Blast4_parameter value
    /// @return 
    ///   CRef to created Blast4_parameter    
    CRef< CBlast4_parameter> Add(const string name,const EBlast4_strand_type &value); 

    /// Append Blast4_parameter
    ///
    /// If node with the specified name exists, the value is substituted
    ///
    /// @param name
    ///    A string containing Blast4_parameter node name
    /// @param  value 
    ///   A  CBlast4_cutoff containing Blast4_parameter value
    /// @return 
    ///   CRef to created Blast4_parameter    
    CRef< CBlast4_parameter> Add(const string name,const CBlast4_cutoff &value); 

    /// Returns Blast4_parameter with specified name 
    ///
    /// @param name
    ///  A string containg Blast4_parameter node name   
    /// @return 
    ///  CRef to CBlast4_parameter list node or empty reference if name does not exist
    /// 
    CRef <CBlast4_parameter> GetParamByName(const string name) const; 



private:
    // Prohibit copy constructor and assignment operator
    CBlast4_parameters(const CBlast4_parameters& value);
    CBlast4_parameters& operator=(const CBlast4_parameters& value); 
};

/////////////////// CBlast4_parameters inline methods

// constructor
inline
CBlast4_parameters::CBlast4_parameters(void)
{
}


/////////////////// end of CBlast4_parameters inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_BLAST_BLAST4_PARAMETERS_HPP
/* Original file checksum: lines: 94, chars: 2723, CRC32: 4fd4a8e6 */
