/* $Id: Delta_item.cpp 513588 2016-09-13 13:46:29Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'seqfeat.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

#include <objects/seq/Seq_literal.hpp>
#include <objects/seq/Seq_data.hpp>
// generated includes
#include <objects/seqfeat/Delta_item.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CDelta_item::~CDelta_item(void)
{
}

void CDelta_item::SetDeletion(void)
{
    SetSeq().SetThis();
    SetAction(eAction_del_at);
}

void CDelta_item::SetDuplication(void)
{
    SetSeq().SetThis();
    SetMultiplier() = 2;
}

void CDelta_item::SetInsertion(const CIUPACna& sequence, 
                               const TSeqPos length)
{
    const TSeqPos seq_length = length ? length : (TSeqPos)sequence.Get().size();
    SetSeq().SetLiteral().SetSeq_data().SetIupacna(sequence);
    SetSeq().SetLiteral().SetLength(seq_length);
    SetAction(eAction_ins_before);
}

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1727, CRC32: 1aff4916 */
