/*  $Id: institution_codes.inc 548845 2017-10-18 15:21:56Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Jonathan Kans et al.
 *
 * File Description:
 *   Built-in copy of institution_codes.txt.
 *
 */

static const char* const kInstitutionCollectionCodeList[] = {
" DZSJRP\ts\tDepartmento de Zoologia e Botanica, Universidade Estadual Paulista\t\t",
"A\ts\tArnold Arboretum, Harvard University\t\t",
"AA\ts\tMinistry of Science, Academy of Sciences\t\t",
"AAC\tc\tArignar Anna College\t\t",
"AAH\ts\tArnold Arboretum, Harvard University\t\t",
"AAPI\ts\tPlant Industry Laboratory\t\t",
"AAR\ts\tReliquae Aaronsohnianae\t\t",
"AARI\ts\tAnatolian Agricultural Research Institute\t\t",
"AAS\ts\tBritish Antarctic Survey\t\t",
"AASU\ts\tArmstrong State University\t\t",
"AAU\ts\tUniversity of Aarhus, Institute of Biological Sciences\t\t",
"AAU<ETH>\ts\tAddis Ababa University, Department of Biology\t\t",
"AAU<ETH>:A\ts\tAddis Ababa University, Department of Biology, Amphibian collection",
"AAUB\ts\tAnhui Agricultural University, Department of Basic Courses\t\t",
"AAUF\ts\tAnhui Agricultural University, Forest Utilization Faculty\t\t",
"ABB\tc\tAsian Bacterial Bank\t\t",
"ABD\ts\tUniversity of Aberdeen, Plant and Soil Science Department\t\t",
"ABDAM\ts\tAberdeen Art Gallery and Museum\t\t",
"ABDC\ts\tAba Institute for Drug Control\t\t",
"ABDF\ts\tUniversity of Aberdeen, Forestry Department\t\t",
"ABDH\ts\tUnited Arab Emirates University, Department of Biology\t\t",
"ABDM\ts\tMarischal College, University of Aberdeen\t\t",
"ABFM\ts\tThe Barnes Foundation Arboretum\t\t",
"ABH\ts\tUniversidad de Alicante, Centro Iberoamericano de la Biodiversidad (CIBIO)\t\t",
"ABI\ts\tCentre ORSTOM d'Adiopodoume\t\t",
"ABKMI\tc\tDepartment of Applied Biology, Faculty of science\t\t",
"ABL\ts\tAdviesbureau voor Bryologie en Lichenologie\t\t",
"ABN\ts\tRadley College\t\t",
"ABO\ts\tAboyne Castle\t\t",
"ABRC\tb\tArabidopsis Biological Resource Center\t\t",
"ABRIICC\tc\tABRIICC Agricultural Biotechnology Research Institute of Iran Culture collection\t\t",
"ABRN\ts\tCentre for Ecology and Hydrology\t\t",
"ABS<UK>\tsc\tAberystwyth University, Institute of Biological, Environmental and Rural Sciences\t\t",
"ABS<USA>\ts\tArchbold Biological Station\t\t",
"ABSH\ts\tSouthern Illinois Universitiy, Department of Plant Biology\t\t",
"ABSL\ts\tUniversity of Minnesota, American Bryological and Lichenological Society\t\t",
"ABSM\ts\tDuke University, Botany Department\t\t",
"ABT\ts\tLaboratoire de Biologie Vegetale et d'Ecologie Forestiere\t\t",
"ABTC\ts\tAustralian Biological Tissue Collection, South Australian Museum\tSAMA:ABTC",
"ABU<NGA>\ts\tAhmadu Bello University Herbarium\t\t",
"AC\ts\tAmherst College\t\t",
"ACA\ts\tAgricultural University of Athens\t\t",
"ACA-DC\tc\tGreek Coordinated Collections of Microorganisms\t\t",
"ACAD\ts\tAcadia University, K. C. Irving Environmental Science Centre & Harriet Irving Botanical Gardens\t\t",
"ACAD<AUS>\tsb\tAustralian Centre for Ancient DNA\t\t",
"ACAM\tc\tThe Australian Collection of Antarctic Microorganisms, Cooperative Research Center for the Antarctic and Southern Ocean Environment\t\t",
"ACAP\ts\tAquaculture Center of Aomori Prefecture\t\t",
"ACBC\ts\tAgriculture Canada Research Station\t\t",
"ACBR\tc\tAustrian Center of Biological Resources and Applied Mycology\t\t",
"ACBV\ts\tAgriculture Canada Research Station, The Aphids of British Columbia\t\t",
"ACC\ts\tOak Hill Park Museum\t\t",
"ACCC\tc\tAgricultural Culture Collection of China\t\t",
"ACD\ts\tAlemaya University of Agriculture\t\t",
"ACE<CHN>\ts\tAnhui College of Education, Biology Department\t\t",
"ACE<EGY>\ts\tArachnid Collection of Egypt\t\t",
"ACH\tc\tNational Mycology Reference Centre, SA Pathology\t\t",
"ACHE\ts\tInstitute of Terrestrial Ecology\t\t",
"ACK\ts\tAgriculture and Agri-Food Canada\t\t",
"ACM\tc\tAustralian Collection of Microorganisms\t\t",
"ACM<CHN>\ts\tAnhui College of Traditional Chinese Medicine, Chinese Materia Medica Department\t\t",
"ACNB\ts\tAgriculture Canada Research Station\t\t",
"ACNS\ts\tAgriculture Canada Nova Scotia\t\t",
"ACOI\tc\tCoimbra Collection of Algae\t\t",
"ACOR\ts\tUniversidad Nacional de Cordoba\t\t",
"ACTC\ts\tAustin College\t\t",
"ACU\ts\tAbilene Christian University\t\t",
"ACUNHC\ts\tAbilene Christian University, Natural History Collection\t\t",
"AD\ts\tPlant Biodiversity Centre\t\t",
"ADA\ts\tHerbarium, Department of Agriculture, South Australia\t\t",
"ADMONT\ts\tBenediktinerstift Admont\t\t",
"ADO\ts\tKirikkale University, Biology Department\t\t",
"ADR\ts\tAdrian College, Biology Department\t\t",
"ADRZ\ts\tRudjer Boskovic Institute, CIM-Botany\t\t",
"ADSH\ts\tArachnology Division\t\t",
"ADT\ts\tAntarctic Division\t\t",
"ADU\ts\tUniversity of Adelaide, Botany Department\t\t",
"ADUG\ts\tGeology Department, University of Adelaide\t\t",
"ADUZ\ts\tZoology Department, University of Adelaide\t\t",
"ADW\ts\tUniversity of Adelaide\t\t",
"AEF\ts\tUniversity of Ankara, Department of Pharmaceutical Botany\t\t",
"AEI\ts\tAmerican Entomological Institute\t\t",
"AEIC\ts\tAmerican Entomological Institute\t\t",
"AES\ts\tHerbarium, Agricultural and Forestry Experiment Station, University of Alaska\t\t",
"AESB\ts\tAgriculture Experiment Station\t\t",
"AFAQ\ts\tAmateur Fisheries Association of Queensland\t\t",
"AFES\ts\tMaritimes Forest Research Centre\t\t",
"AFGMC\ts\tAlaska Department of Fish and Game\t\t",
"AFS\ts\tUniversity of Michigan\t\t",
"AFSDU\ts\tSuleyman Demirel University, Agricultural Faculty\t\t",
"AFTC\ts\tAlaska Frozen Tissue Collection\t\t",
"AGRITEC\tb\tAGRITEC, Ltd.\t\t",
"AGRL\ts\tLethbridge Research Station\t\t",
"AGU\ts\tAstrakhan State University\t\t",
"AGUAT\ts\tUniversidad de San Carlos\t\t",
"AGUCH\ts\tFacultad de Ciencias Agronomicas de la Universidad de Chile\t\t",
"AH\ts\tUniversidad de Alcala, Departamento de Biologia Vegetal\t\t",
"AHBC\ts\tDixie College\t\t",
"AHF\ts\tAllan Hancock Foundation, University of Southern California\t\t",
"AHFH\ts\tUniversity of Southern California\t\t",
"AHLDA\tc\tAnimal Health Division Culture Collection\t\t",
"AHMA\ts\tAgharkar Research Institute, Maharashtra Association for the Cultivation of Science, Botany Group\t\t",
"AHNU\ts\tAnhui Normal University Conservation Genetics Lab\t\t",
"AHS\ts\tAustin High School\t\t",
"AHU\tc\tAHU Culture Collection\t\t",
"AHUC\ts\tUniversity of California, Agronomy and Range Science Department\t\t",
"AIB\ts\tAnhui Institute of Biology\t\t",
"AIBU\ts\tAbant Izzet Baysal Ueniversitesi, Biyoloji Boeluemue\t\t",
"AICH\ts\tAichi Kyoiku University, Biology Department\t\t",
"AIM\ts\tAuckland Institute and Museum\tAMNZ",
"AIMS\ts\tAustralian Institute of Marine Science\t\t",
"AIS\ts\tAcademie imperial des Sciences\t\t",
"AISIY\ts\tArmenian Institute for the Scientific Investigation of Cattle Breeding and Veterinary, Department of Meadows and Pastures\t\t",
"AIX\ts\tMuseum d'Histoire Naturelle d'Aix-en-Provence\t\t",
"AJ\tc\tCentral Research Laboratories\t\t",
"AJBC\ts\tAtkins Jardin Botanico de Cienfuegos\t\t",
"AJOU\ts\tAjou University, Biological Sciences Department\t\t",
"AK\ts\tAuckland War Memorial Museum\t\t",
"AKPM\ts\tAkita Prefectural Museum\t\t",
"AKSU\th\tAksaray University\t\t",
"AKU<JPN>\tc\tFaculty of Agriculture\t\t",
"AKU<NZ>\ts\tUniversity of Auckland, School of Biological Sciences\t\t",
"AL\ts\tUniversite d'Alger\t\t",
"ALA<USA-AK>\ts\tHerbarium, University of Alaska Museum of the North\t\t",
"ALA<USA-AL>\ts\tUniversity of Alabama Museum of Natural History\t\t",
"ALAJ\ts\tHerbarium, University of Alaska SE\t\t",
"ALAM\ts\tAdams State College, Biology Department\t\t",
"ALB\ts\tCivico Museo Archeologico e di Scienze Naturali Federico Eusebio\t\t",
"ALBA\ts\tUniversidad de Castilla, La Mancha, Departamento de Ciencia y Tecnologia Agroforestal\t\t",
"ALBC\ts\tAlbion College, Biology Department\t\t",
"ALBU\ts\tRocky Mountain Forest and Range Experiment Station\t\t",
"ALCB\ts\tUniversidade Federal da Bahia, Campus Universitario de Ondina\t\t",
"ALCP\tc\tAlgotheque du Laboratoire de Cryptogamie\t\t",
"ALD\ts\tAlderney Society and Museum\t\t",
"ALEX\ts\tUniversity of Alexandria, Department of Botany\t\t",
"ALF\ts\tCampus International de Baillarguet, Departement d'Elevage et de Medecine Veterinaire\t\t",
"ALGOBANK\tc\tALGOBANK\tAC<FRA>",
"ALGU\ts\tUniversidade do Algarve\t\t",
"ALIRU\tc\tAustralian Legume Inoculants Research Unit\t\t",
"ALK\ts\tAlnwick Scientific and Mechanical Institution\t\t",
"ALM<FRA>\ts\tMuseum National Historie Naturelle\t\t",
"ALM<GBR>\ts\tArt Gallery and Museum, Central Library\t\t",
"ALMA\ts\tAlma College, Biology Department\t\t",
"ALME\ts\tEstacion Experimental de Zonas Aridas\t\t",
"ALN\ts\tAlnwick Botanical Society\t\t",
"ALNHS\ts\tNatural Heritage Section-ALDCNR\t\t",
"ALT\ts\tCurtis Museum\t\t",
"ALTA\ts\tUniversity of Alberta, Biological Sciences Department\t\t",
"ALTB\ts\tUniversity of Barnaul, Altai State University\t\t",
"ALU\ts\tAlabama Museum of Natural History\t\t",
"ALUH\ts\tAlzahra University\t\t",
"AM\tsb\tAustralian Museum\tAMS",
"AM:Arachnology\ts\tAustralian Museum, Invertebrate Collections: Arachnology",
"AM:EBU\tsb\tAustralian Museum, Evolutionary Biology Unit Tissue Collection",
"AM:Entomology\ts\tAustralian Museum, Invertebrate Collections: Entomology",
"AM:Herpetology\ts\tAustralian Museum, Vertebrate Collections: Herpetology",
"AM:Ichthyology\ts\tAustralian Museum, Vertebrate Collections: Ichthyology",
"AM:Malacology\ts\tAustralian Museum, Invertebrate Collections: Malacology",
"AM:Mammalogy\ts\tAustralian Museum, Vertebrate Collections: Mammalogy",
"AM:Marine_Invertebrates\ts\tAustralian Museum, Invertebrate Collections: Marine and other invertebrates",
"AM:Mineralogy\ts\tAustralian Museum, Earth Sciences: Mineralogy and Petrology Collection",
"AM:Ornithology\ts\tAustralian Museum, Vertebrate Collections: Ornithology",
"AM:Palaeontology\ts\tAustralian Museum, Palaeontology Collection",
"AM<ARG>\ts\tAcatushun Museum at the Estancia Haberton\t\t",
"AM<BLG>\ts\tAsenovgrad Paleontology Museum\t\t",
"AMAL\ts\tAnniston Museum of Natural History\t\t",
"AMAZ\ts\tUniversidad Nacional de la Amazonia Peruana\t\t",
"AMB\ts\tAssociazione Micologica Bresadola\t\t",
"AMC\tc\tDepartment of Biologics Research\t\t",
"AMCC\ts\tAmbrose Monell Cryo Collection, American Museum of Natural History\t\t",
"AMCL\ts\tMacapa, Museu Territorial de Historia Natural \"Angelo Moreira da Costa Lima\"\t\t",
"AMD\ts\tHugo de Vries-Laboratory, University of Amsterdam\t\t",
"AMDE\ts\tBrathay Field Centre for Exploration and Field Studies\t\t",
"AMES\ts\tHarvard University\t\t",
"AMG\ts\tAlbany Museum\t\t",
"AMGS\ts\tAlbany Museum\t\t",
"AMH\ts\tAgharkar Research Institute, Mycology and Plant Pathology Department\t\t",
"AMMRL\tc\tAustralian National Reference Laboratory in Medical Mycology\t\t",
"AMMS\ts\tAcademy of Military Medical Sciences\t\t",
"AMNH\tsb\tAmerican Museum of Natural History\t\t",
"AMNH:Fish\ts\tAmerican Museum of Natural History, Ichthyology Collection",
"AMNH:FM\ts\tAmerican Museum of Natural History, Fossil Mammal Collection",
"AMNH:Herp\ts\tAmerican Museum of Natural History, Herpetology collection",
"AMNH:ORN\ts\tAmerican Museum of Natural History, Ornithology Collection",
"AMNH:R\ts\tAmerican Museum of Natural History, Reptile Collection",
"AMNH<ISL>\ts\tIcelandic Institute of Natural History, Akureyri Division\t\t",
"AMNZ\ts\tAuckland Institute and Museum\tAIM",
"AMO\ts\tHerbario AMO\t\t",
"AMP<AUS>\tc\tAustralian Mycological Panel\t\t",
"AMP<GBR>\ts\tAmpleforth College\t\t",
"AMS\ts\tAustralian Museum\tAM",
"AMSA\ts\tAlbany Museum\t\t",
"AMUZ\ts\tAligarh Muslim University\t\t",
"ANA\ts\tOrange County Department of Agriculture\t\t",
"ANACC<AUS>\tc\tAustralian National Algae Culture Collection\t\t",
"ANC\ts\tUniversita di Ancona, Dipartimento di Biotecnologie Agrarie ed Ambientali\t\t",
"ANCB\ts\tMuseo Nacional de Historia Natural, La Paz\t\t",
"AND\ts\tSlezske zemske muzeum Opava, Arboretum Nopvy Dvur, Dendrology Department\t\t",
"ANDA\ts\tAndalas University\t\t",
"ANDES\ts\tLa Universidad de Los Andes\t\t",
"ANDES:A\ts\tLa Universidad de Los Andes, Amphibian Collection",
"ANDES:O\ts\tLa Universidad de Los Andes, Ornithology Collection",
"ANES\ts\tAnadolu University, Biology Department\t\t",
"ANFC\ts\tAustralian National Fish Collection\t\t",
"ANFM\ts\tAssociazione Naturalisti Forlivesi Pro Museo\t\t",
"ANG\ts\tArboretum de la Maulevrie\t\t",
"ANGU\ts\tInstituto Nacional de Tecnologia Agropecuaria\t\t",
"ANGUC\ts\tUniversite Catholiques de l'Ouest\t\t",
"ANH\ts\tAndong National University, School of Bioresource Science\t\t",
"ANHC\ts\tArkansas Natural Heritage Commission Herbarium\t\t",
"ANIC\ts\tAustralian National Insect Collection\t\t",
"ANK\ts\tAnkara Ueniversitesi, Biyoloji Boeluemue\t\t",
"ANKO\ts\tForest Research Institute, Turkey\t\t",
"ANLW\ts\tAmt Der Niederosterreichischen Landsregierung\t\t",
"ANMR\tc\tAsian Network on Microbial Researches\t\t",
"ANSM\ts\tUniversidad Autonoma Agraria Antonio Narro, Departamento de Botanica\t\t",
"ANSP\ts\tAcademy of Natural Sciences of Philadelphia\t\t",
"ANSP:Malacology\ts\tAcademy of Natural Sciences of Philadelphia, Malacology Collection",
"ANTU\ts\tChangbai Mountain National Nature Reserve Administration Bureau\t\t",
"ANU<AUS>\ts\tAustralian National University\tANU<AUS>,ANU<AUST>",
"ANU<CHN>\ts\tAnhui University, Biology Department\t\t",
"ANUB\ts\tAnhui Normal University, Biology Department\t\t",
"ANUC\ts\tAustralian National University, Chemistry Department\t\t",
"ANUG\ts\tAnhui Normal University, Geography Department\t\t",
"ANWC\ts\tAustralian National Wildlife Collection\t\t",
"AO\ts\tMuseo Regionale di Scienze Naturali della Valle d'Aosta\t\t",
"APCC\tc\tAntarctic Protistan Culture Collection (Woods Hole Oceanographic Institution)\t\t",
"APCR\ts\tArkansas Tech University, Biological Sciences Department\t\t",
"APEI\ts\tAgriculture Canada Research Station\t\t",
"APH\ts\tSociety of Apothecaries\t\t",
"APHA\tsc\tAnimal and Plant Health Agency\tVLA",
"APHI\ts\tU.S. Department of Agriculture, Animal and Plant Health Inspection Service\t\t",
"APIY\ts\tAbovian Pedagogical Institute, Botany Department\t\t",
"APM\ts\tAlgonquin Provincial Park, Algonquin Visitor Centre\t\t",
"APMJ\ts\tAomori Prefectural Museum\t\t",
"APP\ts\tParco Nazionale del Gran Sasso e Monti della Laga - Universita di Camerino, Centro Richerche Floristiche dell'Appennino\t\t",
"APSC\ts\tAustin Peay State University, Biology Department\t\t",
"AQC\ts\tAquinas College, Biology Department\t\t",
"AQP\ts\tEstudios Fitogeograficos del Peru\t\t",
"AQUI\ts\tUniversita degli Studi di L'Aquila, Dipartimento di Scienze Ambientali\t\t",
"AR\ts\tPomor State University\t\t",
"ARAGO\ts\tUniversite Pierre et Marie Curie\t\t",
"ARAN\ts\tAlto de Zorroaga s.n., Departamento de Botanica\t\t",
"ARB\ts\tSalahiddin University, Biology Department\t\t",
"ARBH\ts\tArbroath Scientific and Natural History Society\t\t",
"ARC<ARG>\ts\tUniversidad Nacional del Comahue, Facultad de Ciencias Agrarias\t\t",
"ARC<CAN>\ts\tAtlantic Reference Centre\t\t",
"ARC<USA-NC>\tc\tAlgal Resources Collection\t\t",
"ARCH\ts\tArchbold Biological Station\t\t",
"ARCM\ts\tAtlantic Reference Centre\t\t",
"ARER\ts\tAssociazione Romana di Entomologia\t\t",
"ARG\ts\tArgotti Botanic Garden\t\t",
"ARIZ\ts\tUniversity of Arizona, Department of Plant Sciences\t\t",
"ARK\ts\tUniversity of Arkansas\t\t",
"ARKH\ts\tChingan State Nature Reserve\t\t",
"ARM\ts\tCounty Museum\t\t",
"ARMFN\ts\tArmagh Field Naturalists' Society\t\t",
"ARRI\ts\tAyurveda Regional Research Institute\t\t",
"ARSEF\tc\tARS Collection of Entomopathogenic Fungi\t\t",
"ARTH\ts\tArtvin Coruh University\t\t",
"ARUN\ts\tBotanical Survey of India, Arunachal Pradesh Regional Centre\t\t",
"AS\tc\tChina General Microbiological Culture Collection Center\t\t",
"AS<DEU>\ts\tPaleontological Collection\t\t",
"AS<PRY>\ts\tJardin Botanico\t\t",
"ASAY\ts\tAcademy of Science of Armenia\t\t",
"ASC\ts\tNorthern Arizona University, Biological Sciences Department\t\t",
"ASCC\ts\tAdams State College Collection\t\t",
"ASCU\ts\tAgricultural Scientific Collections Unit\t\t",
"ASDM\ts\tArizona-Sonora Museum\t\t",
"ASE\ts\tUniversidade Federal de Sergipe, Departamento de Biologia\t\t",
"ASH\ts\tNational Institute of Deserts Flora and Fauna\t\t",
"ASIB\tc\tAlgensammlung am Institut fur Botanik\t\t",
"ASINC\tb\tAgricultural Science Institute of North-Central Vietnam\t\t",
"ASIO\ts\tAcademia Sinica Institute of Oceanology\t\t",
"ASIZB\ts\tAcademia Sinica Institute of Zoology, Beijing\t\t",
"ASIZP\ts\tAcademia Sinica Institute of Zoology, Ichthyology Collection\tASIZP<TWN>",
"ASIZT\ts\tAcademia Sinica Institute of Zoology, Taipei\t\t",
"ASM\ts\tArts and Science University\t\t",
"ASNHC\ts\tAngelo State Natural History Collection\t\t",
"ASSAM\ts\tBotanical Survey of India, Eastern Circle\t\t",
"ASSL\ts\tAcademy of Sciences\t\t",
"AST\ts\tUniversity of Aston\t\t",
"ASTC\ts\tStephen F. Austin State University, Biology Department\t\t",
"ASTN\ts\tAshton-under-Lyne Linnean Botanical Society\t\t",
"ASTU\ts\tAssiut University\t\t",
"ASU\ts\tSchool of Life Sciences, Arizona State University\t\t",
"ASUA\ts\tAin Shams University\t\t",
"ASUF\ts\tRocky Mountain Research Station, USDA Forest Service\t\t",
"ASUMC\ts\tArizona State University, Mammal Collection\t\t",
"ASUMZ\ts\tArkansas State University, Collection of Recent Mammals\t\t",
"ASUT\ts\tFrank M. Hasbrouck Insect Collection\t\t",
"ASW\ts\tSouth Valley University, Botany Department\t\t",
"ASW<AUT>\tc\tCulture Collection of Algae at the University of Vienna\t\t",
"ATA\ts\tAtatuerk Ueniversitesi\t\t",
"ATCC\tcb\tAmerican Type Culture Collection\t\t",
"ATH\ts\tGoulandris Natural History Museum\t\t",
"ATHU\ts\tNational and Kapodistrian University of Athens, Biology Department\t\t",
"ATHUM\tc\tATHUM Culture Collection of Fungi\t\t",
"ATSC<AUS>\tb\tAustralian Tree Seed Centre\t\t",
"ATU\tc\tDept.of Biotechnology University of Tokyo\t\t",
"AU\ts\tXiamen University, Biology Department\t\t",
"AUA\ts\tAuburn University, Biological Sciences Department\t\t",
"AUB\ts\tAndrews University\t\t",
"AUBH\ts\tAthabasca University\t\t",
"AUBL\ts\tMuseum of Natural History, Beirut\t\t",
"AUBSN\ts\tAll-Union Botanical Society\t\t",
"AUCE\ts\tEl Azhar University\t\t",
"AUEM\ts\tAuburn University Entomological Museum\t\t",
"AUG\ts\tAugustana College, Biology Department\t\t",
"AUGD\ts\tDepartment of Geology and Petroleum Geology\t\t",
"AUH\ts\tAgriculture University Herbarium\t\t",
"AUM\ts\tAuburn University Museum\t\t",
"AUMC<EGY>\tc\tAssiut University Mycological Centre Culture Collection\t\t",
"AURO\ts\tAuroville Foundation\t\t",
"AUSPGRIS\tb\tAustralian Plant Genetic Resource Information Service\t\t",
"AUT\ts\tMuseum d'Histoire Naturelle\t\t",
"AUW\ts\tAcadia University, Wildlife Museum\t\t",
"AV\ts\tMuseum Requien\t\t",
"AVCH\ts\tCity of Alexandria\t\t",
"AVE\ts\tUniversidade de Aveiro, Departamento de Biologia\t\t",
"AVU\ts\tVrije Universiteit, Department of Systematic Botany\t\t",
"AWH\ts\tDr. Henri Van Heurck Museum\t\t",
"AWL\ts\tAbitibi Paper Company\t\t",
"AWQC\tc\tAustralian Water Quality Centre\t\t",
"AWRI\tc\tThe Australian Wine Research Institute\t\t",
"AYBY\ts\tBuckinghamshire County Museum Technical Centre\t\t",
"AYDN\ts\tAdnan Menderes University, Department of Biology\t\t",
"AYR\ts\tSouth Ayrshire Council\t\t",
"AZ\ts\tMuseu Carlos Machado, Natural History Department\t\t",
"AZAN\ts\tAkademia Nauk Azerbaijana-Bulgarian Academy of Science of Azerbaijan\t\t",
"AZB\ts\tHerbario Ruy Telles Palhinha - Universidade Dos Acores\t\t",
"AZU\ts\tUniversidade dos Acores, Departamento de Ciencias Agrarias\t\t",
"AZUS\ts\tCitrus College, Biological Sciences Department\t\t",
"B\ts\tBerlin Botanic Garden and Botanical Museum\tBGBM",
"BA\ts\tMuseo Argentino de Ciencias Naturales Bernardino Rivadavia\t\t",
"BAA\ts\tUniversidad de Buenos Aires, Facultad de Agronomia\t\t",
"BAAC\ts\tMusee de Beni Abbes\t\t",
"BAB\ts\tInstituto Nacional de Tecnologia Agropecuaria, Instituto de Recursos Biologicos\t\t",
"BABY\ts\tB. A. Bennett Herbarium, Yukon Government\t\t",
"BAC<CHN>\ts\tBeijing Agricultural College\t\t",
"BAC<UK>\ts\tBacup Natural History Society\t\t",
"BACC\tc\tBrucella AFSSA Culture Collection\t\t",
"BACH\ts\tBotswana College of Agriculture\t\t",
"BACP\ts\tCEFYBO, Unidad Botanica\t\t",
"BAE\ts\tWillis Museum and Art Gallery\t\t",
"BAF\ts\tUniversidad de Buenos Aires, Facultad de Farmacia y Bioquimica\t\t",
"BAFC\tsc\tUniversidad de Buenos Aires, Departamento de Ciencias Biologicas\t\t",
"BAG\ts\tMinistry of Agriculture\t\t",
"BAH<BRZ>\ts\tEmpresa Baiana de Desenvolvimento Agricola\t\t",
"BAH<GRM>\ts\tBiologische Anstalt Helgoland Marine Station\t\t",
"BAI\ts\tInstituto Forestal Nacional (IFONA), Centro Forestal Castelar\t\t",
"BAIL\ts\tConservatoire Botanique National de Bailleul\t\t",
"BAJ\ts\tInstituto Municipal de Botanica, Parque Pte. Dr. Nicolas Avellaneda\t\t",
"BAK\ts\tAcademy of Sciences of Azerbaijan\t\t",
"BAL\ts\tINTA, EEA Balcarce, Catedra de Botanica Agricola\t\t",
"BALT\ts\tTowson University, Department of Biological Sciences\t\t",
"BAMU\ts\tDr. Babasaheb Ambedkar Marathwada University\t\t",
"BAN\ts\tBanaras Hindu University, Botany Department\t\t",
"BANG\ts\tUniversite de Bangui\t\t",
"BAP\ts\tOxford Botanic Garden\t\t",
"BAR\ts\tUniversity of the West Indies, Department of Biological and Chemical Sciences\t\t",
"BARC\ts\tBeltsville Agricultural Research Center\t\t",
"BARO\ts\tMaharaja Sayajirao University of Baroda, Botany Department\t\t",
"BART\ts\tBartlett Arboretum\t\t",
"BAS<BGR>\ts\tBulgarian Academy of Science\t\t",
"BAS<CHE>\ts\tHerbarium, Botanisches Institut, Universitat Basel\t\t",
"BASBG\ts\tUniversitaet Basel, Basler Botanische Gesellschaft\t\t",
"BASSA\ts\tMuseo Civico, Bassano del Grappa\t\t",
"BASU\ts\tBu-Ali Sina University\t\t",
"BAT\ts\tBagshaw Museum\t\t",
"BATA\ts\tInstituto Nacional de Desarollo Forestal\t\t",
"BATH\ts\tBath Natural History Society\t\t",
"BATHG\ts\tGeology Museum\t\t",
"BATU\ts\tBatumi Botanical Garden, Botany Department\t\t",
"BAU\ts\tBeijing Agricultural University\t\t",
"BAV\ts\tSlovenskej akademie vied\t\t",
"BAY\ts\tMuseum d'Histoire Naturelle de Bayonne\t\t",
"BAYLU\ts\tBaylor University, Biology Department\t\t",
"BB<ARG>\ts\tUniversidad Nacional del Sur, Departamento de Agronomia\t\t",
"BB<USA-WY>\ts\tBuffalo Bill Museum\t\t",
"BBB\ts\tUniversidad Nacional del Sur, Departamento de Biologia, Bioquimica y Farmacia\t\t",
"BBF\ts\tConservatoire Botanique National de Midi-Pyrenees, Conservatoire botanique pyreneen\t\t",
"BBG\ts\tBirmingham Botanical Gardens\t\t",
"BBH\ts\tNational Science and Technology Development Agency\t\t",
"BBLF\tc\tInstitut fur Pflanzenschutz im Forst\t\t",
"BBLM\ts\tBoise District Bureau of Land Management\t\t",
"BBNP\ts\tBig Bend National Park\t\t",
"BBPP\tc\tBacteriology Branch, Plant Pathology and Microbiology Division, Department of Agricultural Science\t\t",
"BBS\ts\tUniversity of Suriname\t\t",
"BBSUK\ts\tNational Museum and Gallery, Department of Biodiversity and Systematic Biology\t\t",
"BC\ts\tInstitut Botanic de Barcelona\t\t",
"BCB\ts\tUniversitat Autonoma de Barcelona, Unitat de Botanica\t\t",
"BCC<ESP>\ts\tUniversitat de Barcelona, Departament de Biologia Vegetal (Unitat de Botanica)\t\t",
"BCC<THA>\tc\tBIOTEC Culture Collection\t\t",
"BCCDC\tc\tBC Centre for Disease Control\t\t",
"BCCM/DCG\tc\tThe Belgian Co-ordinated Collections of Micro-organisms / DCG Diatoms Collection\tDCG",
"BCCM/IHEM\tc\tThe Belgian Co-ordinated Collections of Micro-organisms / IHEM Biomedical Fungi and Yeasts Collection\tIHEM",
"BCCM/ITM\tc\tThe Belgian Co-ordinated Collections of Micro-organisms / ITM Mycobacteria Collection\tITM",
"BCCM/LMBP\tc\tBelgian Coordinated Collections of Microorganisms / LMBP Plasmid Collection\tLMBP",
"BCCM/MUCL\tc\tThe Belgian Co-ordinated Collections of Micro-organisms / MUCL (Agro)Industrial Fungi & Yeasts Collection\tMUCL",
"BCCM/ULC\tc\tThe Belgian Co-ordinated Collections of Micro-organisms / ULC of cyanobacteria\tUCL",
"BCCN\tc\tBrucella Culture Collection\t\t",
"BCCUSP\tc\tBrazilian Cyanobacteria Collection - University of Sao Paulo\t\t",
"BCF\ts\tUniversitat de Barcelona, Laboratori de Botanica\t\t",
"BCFH\ts\tBureau of Commercial Fisheries\t\t",
"BCH\ts\tBerry College\t\t",
"BCKN\ts\tBlackburn Museum and Art Gallery\t\t",
"BCL\ts\tBates College, Biology Department\t\t",
"BCM<SPN>\ts\tCampus Universitario de Tafira, Departamento de Biologia\t\t",
"BCM<USA-NY>\ts\tBrooklyn Children's Museum\t\t",
"BCMEX\ts\tUniversidad Autonoma de Baja California, Reg. MX-HR-007-BC\t\t",
"BCMM\ts\tBeijing College of Traditional Chinese Medicine\t\t",
"BCN\ts\tUniversitat de Barcelona\t\t",
"BCNP\ts\tBryce Canyon National Park\t\t",
"BCPM\ts\tBritish Columbia Provincial Museum\t\t",
"BCRC\tc\tBioresource Collection and Research Center\tCCRC",
"BCRJ\tc\tRio de Janeiro Cell Bank (Banco de Celulas do Rio de Janeiro)\t\t",
"BCRU\ts\tUniversidad Nacional del Comahue, Departamento de Botanica\t\t",
"BCTC\ts\tBirmingham Central Technical College\t\t",
"BCU\ts\tChulalongkorn University, Botany Department\t\t",
"BCUE\ts\tDepartment of Biology, Ch'ongju University of Education\t\t",
"BCUZ\ts\tBasque Country University, Laboratory of Zoology\t\t",
"BCW\ts\tBedford College, University of London\t\t",
"BCWL\ts\tBiological Control of Weeds Laboratory-Europe\t\t",
"BDD\ts\tUniversity of Bradford, Biology Department\t\t",
"BDI\ts\tPutnam Museum of History and Natural Science, Natural History Department\t\t",
"BDIARI\tsc\tBahri Dagdas International Agricultural Research Institute\t\t",
"BDK\ts\tNorth Hertfordshire Museums Service, Natural History Department\t\t",
"BDLU\ts\tLaurentian University\t\t",
"BDMU\ts\tMcMaster University\t\t",
"BDPA\ts\tArboretum, Bolestraszyce - Zamek, Department of Physiography\t\t",
"BDUC\ts\tUniversity of Calgary\t\t",
"BDUW\ts\tUniversity of Waterloo\t\t",
"BDUZ\tc\tBiological Sciences\t\t",
"BDWC\ts\tUniversity of Windsor\t\t",
"BDWL\ts\tWilfred Laurier University\t\t",
"BDWR\ts\tBridgewater College, Biology Department\t\t",
"BEAN\ts\tBridge of Allan Museum\t\t",
"BED\ts\tBedford Public Library\t\t",
"BEDF\ts\tNew England Wild Flower Society\t\t",
"BEDPL\ts\tBedford Public Library\t\t",
"BEG\tc\tInternational Bank for the Glomeromycota\tIBG",
"BEGO\ts\tBeth Gordon Institute\t\t",
"BEI\ts\tAmerican University of Beirut, Biology Department\t\t",
"BEI<USA>\tc\tBiodefense and Emerging Infections Research Resources\t\t",
"BEL\ts\tUlster Museum, Botany Department\t\t",
"BELC\ts\tBeloit College, Biology Department\t\t",
"BELUM\ts\tUlster Museum, Belfast\t\t",
"BELZ\ts\tZapovednik Belogorje State Nature Reserve\t\t",
"BENH\ts\tBritish Entomological and Natural History Society\t\t",
"BENIN\ts\tUniversite National du Benin\t\t",
"BEO\ts\tNatural History Museum, Botany Department\t\t",
"BEOU\ts\tUniversity of Belgrade, Faculty of Biology\t\t",
"BER\ts\tOrto Botanico de Bergamo \"Lorenzo Rota\"\t\t",
"BEREA\ts\tBerea College, Biology Department\t\t",
"BERN\ts\tUniversity of Bern\t\t",
"BESA\ts\tMuseum d'Histoire naturelle de Besancon\t\t",
"BESM\ts\tBvumbwe Experiment Station\t\t",
"BEV\ts\tBorough of Beverley Art Gallery and Museum\t\t",
"BEX\ts\tBexhill Museum\t\t",
"BFBI\ts\tBiologisches Forschunsstation Burgenland\t\t",
"BFD\ts\tBedfordshire Natural History Society\t\t",
"BFDL\ts\tForest Products Laboratory\t\t",
"BFIC\ts\tMuseum National d'Histoire Naturelle\t\t",
"BFRIRS\ts\tBangladesh Fisheries Research Institute\t\t",
"BFRS\ts\tBlodgett Forest Research Station\t\t",
"BFT\ts\tQueen's University, Botany Department\t\t",
"BFUS\ts\tUniversity of Sofia, Biology Faculty\t\t",
"BFY\ts\tJohn Innes Horticultural Institution\t\t",
"BG\ts\tUniversity of Bergen, Botanical Museum\t\t",
"BGAAS\ts\tBotanical Garden of the Armenian Academy of Sciences, Flora and Vegetation Department\t\t",
"BGHan\ts\tBundesanstalf fuer Geowissenschaften und Rohstoffe\t\t",
"BGIV\tc\tBanco de Glomeromycota In Vitro (Bank of Glomeromycota In Vitro)\t\t",
"BGM\ts\tBath Geology Museum (now the Royal Literary and Scientific Institution)\t\t",
"BGR\ts\tBundesanstalt fur Geowissenschaften und Rohstoffe\t\t",
"BGS\ts\tBritish Geological Survey\t\t",
"BGSC\tc\tBacillus Genetic Stock Center\t\t",
"BGSU\ts\tBowling Green State University, Biological Sciences Department\t\t",
"BH\ts\tCornell University, Department of Plant Biology\t\t",
"BHAG\ts\tT. M. Bhagalpur University, Botany Department\t\t",
"BHAV\ts\tCentral Salt and Marine Chemicals Research Institute\t\t",
"BHCB\ts\tUniversidade Federal de Minas Gerais, Departamento de Botanica\t\t",
"BHD\ts\tWilliamson Art Gallery and Museum\t\t",
"BHDL\ts\tWirral Central Area Reference Library\t\t",
"BHDS\ts\tBirkenhead School\t\t",
"BHM<UK>\ts\tUniversity of Birmingham, Birmingham Natural Society\t\t",
"BHM<USA-SD>\ts\tBlack Hills Museum of Natural History\t\t",
"BHMG\ts\tInstituto Agronomico\t\t",
"BHMH\ts\tUniversidade Federal de Minas Gerais, Museu de Historia Natural\t\t",
"BHO\ts\tOhio University, Environmental and Plant Biology Department\t\t",
"BHSC\ts\tBlack Hills State University, Biology Department\t\t",
"BHU\ts\tHumboldt-Universitaet zu Berlin, Institut fuer Biologie\t\t",
"BHUPM\ts\tMuseum fuer Naturkunde, Institut fuer Palaeontologie\t\t",
"BHUPP\ts\tBanaras Hindu University, Mycology and Plant Pathology Department\t\t",
"BHZB\ts\tFundacao Zoo-Botanica de Belo Horizonte\t\t",
"BI\ts\tIstituto Ortobotanico\t\t",
"BIA\ts\tBritish Institute of Archaeology\t\t",
"BIDA\ts\tBoise State University\t\t",
"BIE\ts\tInstituto di Entomologia\t\t",
"BIEL\ts\tUniversitaet Bielefeld, Abteilung Oekologie\t\t",
"BIGU\ts\tUniversidad de San Carlos de Guatemala, Departamento de Botanica\t\t",
"BIL\ts\tForest Research Institute, Natural Forest Department\t\t",
"BILAS\ts\tInstitute of Botany\t\t",
"BIM\ts\tBirmingham Natural History and Microscopical Society\t\t",
"BIM<BLR>\tc\tBelarus National Academy of Sciences\t\t",
"BING\ts\tState University of New York, Biological Sciences Department\t\t",
"BIO\ts\tUniversidad del Pais Vasco/EHU, Departamento de Biologia Vegetal y Ecologia (Botanica)\t\t",
"BioCC\tc\tBioCC BioCen Culture Collection\t\t",
"BIOT\ts\tRegional Center for Tropical Biology\t\t",
"BIOUG<CAN>\ts\tBiodiversity Institute of Ontario, University of Guelph\tBIO,UOG:BIO",
"BIRA\ts\tBirmingham Museums and Art Gallery, Curatorial Services\t\t",
"BIRDI\tb\tBiotechnology Research & Development Institute Vietnam\t\t",
"BIRM\ts\tUniversity of Birmingham\t\t",
"BISH\ts\tBishop Museum, Department of Natural Sciences\t\t",
"BITU\ts\tDepartment of Biology, Faculty of Science, Toyama University\t\t",
"BIUB\ts\tMongolian Academy of Sciences\t\t",
"BJ\th\tBi Jie University\t\t",
"BJA\ts\tUniversity of Burundi, Biology Department\t\t",
"BJFC\ts\tBeijing Forestry University\t\t",
"BJM\ts\tBeijing Natural History Museum\t\t",
"BJRI<BGD>\tb\tGene bank at Bangladesh Jute Research Institute\t\t",
"BJTC\ts\tCapital Normal University, Biology Department\t\t",
"BK\ts\tBangkok Herbarium\t\t",
"BKF\ts\tThe Forest Herbarium\t\t",
"BKL\ts\tBrooklyn Botanic Garden\t\t",
"BKNU\ts\tKunsan National University\t\t",
"BLA\ts\tFundacao Estadual de Pesquisa Agropecuaria\t\t",
"BLAT\ts\tSt. Xavier's College, Botany Department\t\t",
"BLCU\ts\tBee Biology and Systematics Laboratory\t\t",
"BLFU\ts\tUniversity of the Free State, Department of Botany and Genetics\t\t",
"BLGA\ts\tBurgenlandisches Landesmuseum\t\t",
"BLH\ts\tCranbrook Institute of Science\t\t",
"BLIH\ts\tBiological Laboratory Imperial Household of Japan\t\t",
"BLMAR\th\tBureau of Land Management Arcata Field Office\t\t",
"BLMLK\ts\tBureau of Land Management\t\t",
"BLMPR\th\tBureau of Land Management, Prineville Field Office\t\t",
"BLT\ts\tBelfast Natural History and Philosophical Society\t\t",
"BLUZ\ts\tMuseo de Biologia\t\t",
"BLWG\tc\tBayerische Landesanstalt fur Weinbau und Gartenbau\t\t",
"BLY\ts\tHarvey Institute, Barnsley Naturalist and Scientific Society\t\t",
"BM\ts\tThe Natural History Museum, Herbarium\t\t",
"BM<GBR-BRISTOL>\ts\tBristol Museum\t\t",
"BMAM\ts\tBeijing Natural History Museum\t\t",
"BMARI\tb\tBandaranayake Memorial Ayurvedic Research Institute\t\t",
"BMB\ts\tBooth Museum of Natural History\t\t",
"BMBN<UK>\ts\tBooth Museum of Natural History\t\t",
"BMCC\tc\tBrittany Microbe Culture collection\t\t",
"BMFM-UNAM\tc\tCulture Collection of Fungal Pathogens Strains from the Basic Mycology Laboratory of the Department of Microbiology and Parasitology, Faculty of Medicine, UNAM\t\t",
"BMGB\ts\tBarbados Museum and Historical Society\t\t",
"BMH\ts\tBournemouth Natural Science Society Museum, herbarium\t\t",
"BMHP\ts\tBermuda Department of Agriculture and Fisheries\t\t",
"BMKB\ts\tBrunei Museum\tBM<BRN>",
"BMM\ts\tBuergermeister Mueller, Museum\t\t",
"BMNH\ts\tNatural History Museum, London\t\t",
"BMNH:ENT\ts\tNatural History Museum, London, Entomology collection",
"BMNHC\ts\tBurpee Museum of Natural History\t\t",
"BMPS\ts\tBristol Museum and Philosophical Society\t\t",
"BMR\ts\tBureau of Mineral Resources\t\t",
"BMRP\ts\tBurpee Museum Rockford Paleontology\t\t",
"BMSA\ts\tNational Museum Bloemfontein\t\t",
"BMSC\ts\tBuffalo Museum of Science\t\t",
"BMUK\ts\tBolton Museum\t\t",
"BNA<ESP>\tc\tNational Bank of Algae\t\t",
"BNA<GBR>\ts\tBritish (Empire) Naturalists' Association\t\t",
"BNBE\ts\tYMCA Hostel\t\t",
"BNFF\ts\tBanff Museum\t\t",
"BNFH\th\tU.S. Forest Service, Bitterroot National Forest\t\t",
"BNH\ts\tNassau Botanical Gardens, Department of Agriculture\t\t",
"BNHD\ts\tBengal Natural History Museum\t\t",
"BNHM<CHN>\ts\tBeijing Natural History Museum\t\t",
"BNHM<IND>\ts\tBombay Natural History Museum\t\t",
"BNHS\ts\tBombay Natural History Society\t\t",
"BNI\tc\tBernhard Nocht Institute for Tropical Medicine\t\t",
"BNL\ts\tBundesamt fuer Naturschutz\t\t",
"BNM\tc\tBanco Nacional Microorganismos (National Bank of Microorganisms)\t\t",
"BNP\ts\tBanff Park Museum\t\t",
"BNPL\ts\tBrighton Public Library\t\t",
"BNRH\ts\tBuffelskloof Nature Reserve\t\t",
"BNS\ts\tBristol Museum and Art Gallery\t\t",
"BNU\ts\tBeijing Normal University, Biology Department\t\t",
"BO\ts\tHerbarium Bogoriense\t\t",
"BOC\ts\tBingham Oceanographic Collection\tYPM",
"BOCH\ts\tRuhr-Universitaet Bochum, Spezielle Botanik\t\t",
"BOD\ts\tUniversity of Oxford\t\t",
"BOG\ts\tUniversidad de La Salle\t\t",
"BOGOS<DEU>\tb\tBotanical Garden of Osnabruck University\t\t",
"BOIS\ts\tRocky Mountain Research Station\t\t",
"BOL\ts\tUniversity of Cape Town, Botany Department\t\t",
"BOLO\ts\tUniversita di Bologna\t\t",
"BOLV\ts\tNacional Forestal Martin Cardenas\t\t",
"BON\ts\tBolton Museum, Art Gallery and Aquarium\t\t",
"BONB\ts\tBolton Botanical Society\t\t",
"BONL\ts\tBolton Linnean Society\t\t",
"BONN\ts\tBotanisches Institut und Botanischer Garten der Universitaet Bonn\t\t",
"BOON\ts\tAppalachian State University, Biology Department\t\t",
"BOR\ts\tGuermonprez Museum\t\t",
"BORD\ts\tJardin Botanique de la Ville de Bordeaux\t\t",
"BORH\ts\tUniversiti Malaysia Sabah\t\t",
"BORN\ts\tInstitute for Tropical Biology and Conservation, Borneensis\t\t",
"BOROK\tc\tThe Collection of algae\t\t",
"BOSC\ts\tBoston State College, Biology Department\t\t",
"BOTU\ts\tUniversidade Estadual Paulista, Departamento de Botanica\t\t",
"BOUM\ts\tMuseum d'Histoire Naturelle de Bourges\t\t",
"BOZ\ts\tNaturmuseum Suedtirol/Museo Scienze Naturali Alto Adige\t\t",
"BP\ts\tHungarian Natural History Museum, Botanical Department\t\t",
"BPBM\ts\tBernice P. Bishop Museum\tBISHOP",
"BPBM:Fish\ts\tBernice P. Bishop Museum, Fish Collection",
"BPBM:IZ\ts\tBernice P. Bishop Museum, Invertebrate Zoology",
"BPI\tsc\tU.S. National Fungus Collections, Systematic Botany and Mycology Laboratory\t\t",
"BPI<ZAF>\ts\tBernard Price Institute for Palaeontological Research\t\t",
"BPIC\tc\tBenaki Phytopathological Institute Collection\t\t",
"BPL\ts\tMuseum of Barnstaple & North Devon\t\t",
"BPM\ts\tBeipiao Paleontological Museum\t\t",
"BPPT-ESC\tc\tBPPT Ethanol-Single Cell Protein-Fructose Syrup Technical Unit\t\t",
"BPS\ts\tCalifornia Department of Food and Agriculture\t\t",
"BPU\ts\tEoetvoes Lorand University, Department of Plant Taxonomy and Ecology\t\t",
"BR<BEL>\ts\tBotanic Garden Meise\t\t",
"BR<BRA>\tc\tJohanna Dobereiner Biological Resouce Center (CRB-JD)\t\t",
"BRA\ts\tSlovak National Museum, Botany Department\t\t",
"BRAD\ts\tUniversity of Bradford, Biology Department\t\t",
"BRC\ts\tBotanical Record Club\t\t",
"BRCC\tc\tUSDA-ARS Rhizobium Germplasm Resource Collection\t\t",
"BRCH\ts\tBotanical Research Center\t\t",
"BRE\ts\tUniversite\t\t",
"BREE\ts\tBraintree and Bocking Natural History Club\t\t",
"BREG\ts\tVorarlberger Naturschau\t\t",
"BREM\ts\tUebersee-Museum\t\t",
"BRFL\ts\tCity of Birmingham Reference Library\t\t",
"BRFM<FRA>\tc\tBanque de Ressources Fongiques de Marseille\t\t",
"BRG\ts\tUniversity of Guyana, Biology Department\t\t",
"BRGE\ts\tLaboratoire de Genetique des Plantes Superieures\t\t",
"BRH\ts\tMinistry of Natural Resources, Local Government, and the Environment\t\t",
"BRI\ts\tBrisbane Botanic Gardens Mt Coot-tha\t\t",
"BRIP\tsc\tThe Plant Pathology Herbarium, Department of Agriculture, Fisheries and Forestry\t\t",
"BRIST\ts\tUniversity of Bristol, Botany Department\t\t",
"BRISTM\ts\tBristol Museum and Art Gallery\t\t",
"BRIT\ts\tBotanical Research Institute of Texas\t\t",
"BRIU\ts\tUniversity of Queensland, Botany Department\t\t",
"BRL\ts\tBristol City Library\t\t",
"BRLU\ts\tUniversite Libre de Bruxelles\t\t",
"BRM\ts\tAlfred-Wegener-Institut fuer Polar- und Meeresforschung\t\t",
"BRMI\ts\tBirmingham and Midland Institute\t\t",
"BRN\ts\tSexey's School\t\t",
"BRNL\ts\tMendel University of Agriculture and Forestry, Department of Forest Botany, Dendrology, and Typology\t\t",
"BRNM\ts\tMoravian Museum, Botany Department\t\t",
"BRNU\ts\tMasaryk University, Department of Botany\t\t",
"BROC\ts\tState University of New York, Biological Sciences Department\t\t",
"BRS\ts\tAgriculture and Agri-Food Canada\t\t",
"BRSL\ts\tWroclaw University, Botany Department\t\t",
"BRSMG\ts\tDepartment of Geology\t\t",
"BRSN\ts\tUniversity of Wales, Bangor Research Unit\t\t",
"BRSU\th\tBryansk State University\t\t",
"BRTN\ts\tBrighton Natural History Society\t\t",
"BRU\ts\tBrown University\t\t",
"BRUN\ts\tBrunei Forestry Centre\t\t",
"BRV\ts\tColecciones paleontologicas del Departamento de Geociencias de la Universidad Nacional de Colombia\t\t",
"BRVU\ts\tVrije Universiteit Brussel\t\t",
"BRWK\ts\tBerwick-upon-Tweed Museum\t\t",
"BRY\ts\tBrigham Young University\t\t",
"BSA\ts\tBotanical Survey of India, Central Circle\t\t",
"BSB\ts\tFreie Universitaet Berlin, Institut fuer Biologie - Systematische Botanik und Pflanzengeographie\t\t",
"BSC\ts\tCentro Oriental de Ecosistemas y Biodiversidad\t\t",
"BSCA\ts\tAnza-Borrego Desert State Park\t\t",
"BSCVC\ts\tBemidji State University, Vertebrate Collections\t\t",
"BSD\ts\tBotanical Survey of India, Northern Circle\t\t",
"BSE\ts\tMoyse's Hall Museum\t\t",
"BSHC\ts\tBotanical Survey of India, Sikkim Himalayan Circle\t\t",
"BSI\ts\tBotanical Survey of India, Western Circle, Ministry of Environment and Forests\t\t",
"BSID\th\tBotanical Survey of India\t\t",
"BSIP\ts\tMinistry of Natural Resources, Department of Forests, Environment, and Conservation\t\t",
"BSIS\ts\tBotanical Survey of India, Industrial Section\t\t",
"BSJO\ts\tBotanical Survey of India, Arid Zone Circle\t\t",
"BSKU\ts\tKochi University\t\t",
"BSL\ts\tBotanical Society of London\t\t",
"BSM\ts\tBerliner Staatisches Museum\t\t",
"BSMB\tc\tBacteriology and Soil Microbiology Branch\t\t",
"BSMP\ts\tDepartment of Agriculture, Bureau of Science\t\t",
"BSN\ts\tBoston University, Biology Department\t\t",
"BSNH\ts\tBoston Society of Natural History\t\t",
"BSNS\ts\tBuffalo Society of Natural Sciences\t\t",
"BSPG\ts\tBayerische Staatssammlung fur Palaontologie und  Geologie\tBS,BSP",
"BSRA\ts\tUniversity of Basrah, Biology Department\t\t",
"BSRM\ts\tBiological Station Reference Museum at Porto Novo\t\t",
"BST\ts\tBelfast Naturalists' Field Club\t\t",
"BSTN\ts\tBoothstown Botanical Society\t\t",
"BSU\ts\tBelgorod State University, Department of Botany\t\t",
"BSUH\ts\tBall State University, Biology Department\t\t",
"BSUMC\ts\tBall State University, Mammal Collection\t\t",
"BTCC<BULG>\tc\tBulgarian Type Culture Collection\t\t",
"BTCC<INDO>\tc\tBiotechnology Culture Collection Institution Pusat Penelitian dan Pengembangan Bioteknologi-LIPI\t\t",
"BTH\ts\tMuseum, Bath Royal Literary and Scientific Institution\t\t",
"BTJW\ts\tBridger Teton National Forest\t\t",
"BTN\ts\tBooth Museum of Natural History\t\t",
"BTT\ts\tBurton-upon-Trent Natural History and Archaeological Society\t\t",
"BTU\ts\tTechnische Universitaet Berlin\t\t",
"BU\th\tBrock University\t\t",
"BUA\ts\tUniversity of Baghdad, Plant Protection Department\t\t",
"BUAG\ts\tUniversity of Agronomical Sciences and Veterinary Medicine, Botany and Plant Physiology Department\t\t",
"BUC\ts\tUniversitatea din Bucuresti\t\t",
"BUCA\ts\tInstitute of Biology, Romanian Academy\t\t",
"BUCF\ts\tForest Research and Management Institute\t\t",
"BUCM\ts\tInstitute of Biology, Romanian Academy\t\t",
"BUCSAV\tc\tBiologicky Ustav\t\t",
"BUE\ts\tUniversity of Baghdad, Biology Department\t\t",
"BUEN\ts\tProteccion de la Naturaleza\t\t",
"BUF\ts\tBuffalo Museum of Science\t\t",
"BUH\ts\tUniversity of Baghdad, Biology Department\t\t",
"BUHGC\ts\tBarton-on-Humber Grammar School\t\t",
"BUHR\ts\tBaysgarth Museum\t\t",
"BUL\ts\tNatural History Museum of Zimbabwe\t\t",
"BULQ\ts\tBishop's University\t\t",
"BULU\ts\tUludag University, Biology Department\t\t",
"BUNH\ts\tUniversity of Baghdad\t\t",
"BUNS\ts\tUniversity of Novi Sad, Department of Biology and Ecology\t\t",
"BUPL\ts\tBucknell University, Biology Department\t\t",
"BURD\ts\tUniversity of Burdwan, Botany Department\t\t",
"BURI\th\tBanasthali University\t\t",
"BURP\ts\tBurpee Museum of Natural History\t\t",
"BUS\ts\tUniversity of Miami, Biology Department\t\t",
"BUT\ts\tButler University\t\t",
"BUTC\ts\tBoston University\t\t",
"BVC\ts\tBuena Vista College\t\t",
"BVS\th\tTransylvania University of Brasov\t\t",
"BYBS\ts\tBungay Botanical Society\t\t",
"BYDG\ts\tTechnical-Agriculture Academy, Department of Botany and Ecology\t\t",
"BYU\ts\tMonte L. Bean Life Science Museum\t\t",
"BZ\ts\tHerbarium Bogoriense\t\t",
"BZCM\th\tBozhou Vocational and Technical College\t\t",
"BZF\ts\tForest Research and Development Center and Nature Conservation\t\t",
"BZM\ts\tMuseum fur Naturkunde, Berlin\t\t",
"BZT\ts\tBiological Institute Titograd\t\t",
"C\ts\tBotanical Museum, Natural History Museum of Denmark\t\t",
"CA\ts\tChicago Academy of Sciences\t\t",
"CABI\tc\tCABI Genetic Resource Collection\t\t",
"CACA\ts\tCarlsbad Caverns National Park\t\t",
"CACC<CHN>\tc\tChina Antibiotic Culture Collection Center\t\t",
"CACS\ts\tChicago Academy of Sciences, Department of Biology\t\t",
"CAEN<FRA>\ts\tJardin Botanique de la Ville de Caen\t\t",
"CAES\ts\tConnecticut Agriculture Experiment Station\t\t",
"CAF\ts\tChinese Academy of Forestry\t\t",
"CAFB\ts\tNorthern Forestry Centre, Canadian Forest Service\t\t",
"CAG\ts\tUniversita di Cagliari\t\t",
"CAH\ts\tUniversity of Zimbabwe, Biological Sciences Department\t\t",
"CAHS\ts\tCrispus Attucks High School\t\t",
"CAHUP\ts\tUniversity of the Philippines Los Banos\t\t",
"CAI\ts\tCairo University, Botany Department\t\t",
"CAIA\ts\tAin Shams University, Department of Botany\t\t",
"CAIH\ts\tDesert Research Center, Mataria, Plant Ecology\t\t",
"CAIM<EGY>\ts\tAgricultural Research Center\t\t",
"CAIM<MEX>\tc\tCollection of Aquatic Important Microorganisms\t\t",
"CAIRC\ts\tNational Research Centre, Plant Chemistry and Systematics Department\t\t",
"CAIRCC\tc\tCAIRCC\t\t",
"CAIRNS\ts\tc/o North Queensland Naturalists' Club\t\t",
"CAL\ts\tBotanical Survey of India\t\t",
"CALI\ts\tUniversity of Calicut, Botany Department\t\t",
"CALP\ts\tUniversity of the Philippines at Los Banos\t\t",
"CALU\tc\tCollection of Algae in Leningrad, St. Petersburg, State University\t\t",
"CALVIN\th\tCalvin College\t\t",
"CAM<AUST>\ts\tCentral Australian Museum\t\t",
"CAM<UK>\ts\tSt. John's College\t\t",
"CAME\ts\tUniversita di Camerino, Dipartimento de Botanica ed Ecologia\t\t",
"CAMS<ZAF>\tc\tCentre for Applied Mycological Studies\t\t",
"CAMU\ts\tCameron University, Department of Biological Sciences\t\t",
"CAN\ts\tCanadian Museum of Nature, Vascular Plant Section\t\t",
"CANA\ts\tCanadian Museum of Nature, Phycology Section\t\t",
"CANB\ts\tAustralian National Herbarium, Canberra\t\t",
"CANI\ts\tCanisius College, Biology Department\t\t",
"CANL\ts\tCanadian Museum of Nature, Lichenology Section\t\t",
"CANM\ts\tCanadian Museum of Nature, Bryology Section\t\t",
"CANT\ts\tSouth China Agricultural University, Forestry Department\t\t",
"CANTY\ts\tCanterbury Museum\t\t",
"CANU\ts\tUniversity of Canterbury, Department of Plant and Microbial Sciences\t\t",
"CAPM\tc\tCollection of Animal Pathogenic Microorganisms\t\t",
"CAR\ts\tMuseo de Historia Natural La Salle, Departamento de Botanica\t\t",
"CARAN\th\tHerbarium Carautanum\t\t",
"CARD\ts\tCaribbean Agricultural Research Institute\t\t",
"CARE\ts\tCaribbean Epidemiology Centre\t\t",
"CARI\ts\tCukurova Agricultural Research Institute\t\t",
"CARL\ts\tCarleton College, Biology Department\t\t",
"CARM\ts\tCarmarthen County Museum\t\t",
"CARS\ts\tUniversity of Surinam, Center for Agricultural Research\t\t",
"CART\ts\tCarthage College, Biology Department\t\t",
"CAS\ts\tCalifornia Academy of Sciences\t\t",
"CAS-IU\ts\tCalifornia Academy of Science, Indiana University Collection\t\t",
"CAS-SU\ts\tCalifornia Academy of Sciences, Stanford University Collection\tCAS(SU)",
"CAS:ANTH\ts\tCalifornia Academy of Sciences, Anthropology Collection",
"CAS:BOT\ts\tCalifornia Academy of Sciences, Botany Collection",
"CAS:DIA\ts\tCalifornia Academy of Sciences, Diatom collection",
"CAS:DS\ts\tCalifornia Academy of Sciences, Dudley Stanford Collection",
"CAS:EGG\ts\tCalifornia Academy of Sciences, Egg & Nest Collection",
"CAS:ENT\ts\tCalifornia Academy of Sciences, Entomology collection",
"CAS:HERP\ts\tCalifornia Academy of Sciences, Herpetology collection",
"CAS:ICH\ts\tCalifornia Academy of Sciences, Ichthyology collection",
"CAS:IU\ts\tCalifornia Academy of Sciences, Indiana University fish collection",
"CAS:IZ\ts\tCalifornia Academy of Sciences, Invertebrate Zoology collection",
"CAS:MAM\ts\tCalifornia Academy of Sciences, Mammalogy Collection",
"CAS:ORN\ts\tCalifornia Academy of Sciences, Ornithology Collection",
"CAS:SU\ts\tCalifornia Academy of Sciences, Stanford University Collection of fish",
"CAS:SUA\ts\tCalifornia Academy of Sciences, Stanford University Collection of amphibians",
"CAS:SUR\ts\tCalifornia Academy of Sciences, Stanford University Collection of reptiles",
"CAS:TYPE\ts\tCalifornia Academy of Sciences, Entomology Type Collection",
"CASM\ts\tChicago Academy of Sciences, Museum of Natural History\t\t",
"CASMB\ts\tCentre of Advanced Study in Marine Biology\t\t",
"CASS\ts\tChinese Academy of Sciences, Shenyang\t\t",
"CAT\ts\tUniversita di Catania, Dipartimento di Botanica e Orto Botanico\t\t",
"CATA\th\tCatalina Island Conservancy\t\t",
"CATH\th\tCatholicate College\t\t",
"CATIE\ts\tTropical Agricultural Research and Training Center (CATIE), Plant Production Department\t\t",
"CAU\ts\tChina Agricultural University\t\t",
"CAUP<COL>\ts\tUniversidad del Cauca\t\t",
"CAUP<CZH>\tc\tCollection of Algae of Charles University, Prague\t\t",
"CAUSC\ts\tUniversidade Federal de Santa Catarina Centro de Agrarias\t\t",
"CAVA\ts\tUniversity of California at Berkeley\t\t",
"CAWC\ts\tConservation Commission of the Northern Territory\tNTM",
"CAY\ts\tInstitut de Recherche pour le Developpement (IRD)\t\t",
"CAYM\ts\tNational Trust for the Cayman Islands\t\t",
"CB<AUST>\tc\tThe CB Rhizobium Collection\t\t",
"CB<CZE>\ts\tJihoceske Muzeum\t\t",
"CBAS\tc\tBacteria Collection of Environmemt and Health (Colecao de Bacterias do Ambiente e Saude)\t\t",
"CBC\ts\tCentre for Biodiversity Conservation\t\t",
"CBD<ITA>\ts\tCollezione Ittiologica Balma-Delmastro\t\t",
"CBD<USA>\tc\tUSF Center for Biological Defense\t\t",
"CBF\ts\tColeccion Boliviana de Fauna\tCBFC",
"CBFS\ts\tUniversity of South Bohemia, Department of Botany\t\t",
"CBG\ts\tAustralian National Botanic Gardens\t\t",
"CBM\ts\tNatural History Museum and Institute\t\t",
"CBM:ZC\ts\tNatural History Museum and Institute, Zoological Collection",
"CBMAI\tc\tBrazilian Collection of Microorganisms from the Environment and Industry (Colecao Brasileira de Microrganismos de Ambiente e Industria)\t\t",
"CBNM\ts\tCedar Breaks National Monument\t\t",
"CBNSA\th\tConservatoire botanique national Sud-Atlantique\t\t",
"CBPF\th\tConservatoire Botanique Pierre Fabre\t\t",
"CBS\tsc\tWesterdijk Fungal Biodiversity Institute\t\t",
"CBSIZA\ts\tCaspian Biological Station Institute of Zoology\t\t",
"CBTCCCAS\tc\tThe Cell Bank of Type Culture Collection of Chinese Academy of Sciences\t\t",
"CBU<CAN>\ts\tCape Breton University\t\t",
"CBU<SKOR>\ts\tChungbuk National University, School of Life Science\t\t",
"CBY\ts\tRoyal Museum and Art Gallery\t\t",
"CC\tc\tCSIRO Canberra Rhizobium Collection\t\t",
"CCA-Marburg\tc\t Culture Collection of Algae at the University of Marburg\t\t",
"CCAC<BRA>\ts\tUniversidade Federal do Ceara, Centro Ciencias Agrarias\t\t",
"CCAC<DEU>\tc\tCulture Collection of Algae at the University of Cologne\t\t",
"CCALA\tc\tCulture Collection of Autotrophic Organisms\t\t",
"CCAP\tc\tCulture Collection of Algae and Protozoa\t\t",
"CCARM\tc\tCulture Collection of Antimirobial Resistant Microorganisms\t\t",
"CCAU\ts\tCentral China Agricultural University\t\t",
"CCB<BRZ>\tc\tColecao de Culturas de Basidiomicetos\t\t",
"CCB<IND>\ts\tCentral College, Bangalore\t\t",
"CCBAS\tc\tCulture Collection of Basidiomycetes\t\t",
"CCBAU\tc\tCulture Collection, Beijing Agricultural University\t\t",
"CCC\tc\tCulture Collection of Clavicipitaceae\t\t",
"CCC<IND>\tc\tCyanobacterial Culture Collection, National Centre for Conservation and Utilisation of Blue Green Algae\t\t",
"CCCC\ts\tCarthage College\t\t",
"CCCIEB\tc\tCulture Collections of Microorgansisms of Center of Genetic Engineering and Biotechnology\t\t",
"CCCM\tc\tCanadian Center for the Culture of Microorganisms\t\t",
"CCCR\th\tFederal University of Tocantins\t\t",
"CCCryo<DEU>\tc\tCulture Collection of Cryophilic Algae\t\t",
"CCCS\tc\tCulture Collection of Ciliates and their Symbionts\t\t",
"CCCZ\ts\tUniversity of Malawi\t\t",
"CCDB<BRA>\ts\tCrustacean Collection of the Department of Biology\t\t",
"CCDM<CHN>\tc\tCulture Collection of Department of Microbiology\t\t",
"CCDM<CZH>\tc\tCulture Collection of Dairy Microorganisms Laktoflora\t\t",
"CCDMBI\tc\tCulture Collection, Department of Microbiology\t\t",
"CCEB\tc\tCulture Collection of Entomogenous Bacteria\t\t",
"CCEC\ts\tMuseum, Centre de Conservation et d'Etude des Collections\t\t",
"CCF<CUB>\tc\tColleccion de Cuttivos Finlay\t\t",
"CCF<CZE>\tc\tCulture Collection of Fungi\t\t",
"CCFC\tc\tCanadian Collection of Fungal Cultures\t\t",
"CCFEE\tc\tCulture Collection of Fungi From Extreme Environments\t\t",
"CCFHE\ts\tCornwall College of Further and Higher Education, Natural Sciences Department\t\t",
"CCFL\ts\tChad National Museum\t\t",
"CCFVB\tc\tFacultat de Veterinaria, Universitat Autonoma de Barcelona\t\t",
"CCG<CHN>\ts\tChengdu College of Geology\tCHG",
"CCG<GHN>\ts\tUniversity of Cape Coast, Botany Department\t\t",
"CCGB\tc\tCulture Collection of Bacillus and Related Genera (Instituto Oswaldo Cruz)\t\t",
"CCGVCC\tc\tChina Centre for General Viruses Culture Collection\t\t",
"CCH\th\tUniversity of Arizona South, Agricultural Extension Service\t\t",
"CCIAL\tc\tCultures Cells for Institute Adolfo Lutz\t\t",
"CCIBSO\tc\tCulture Collection IBSO\t\t",
"CCIBt\tc\tCulture Collection at the Institute of Botany, Sao Paulo\t\t",
"CCIM\tc\tCulture Collection of Industrial Microorganisms\t\t",
"CCM\tc\tCzech Collection of Microorganisms\tCCM<CZE>",
"CCM-A\tc\tColeccion de Cultivos Microbianos\t\t",
"CCM<CHN>\ts\tChangchun College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t",
"CCM<USA-MT>\ts\tCarter County Museum\t\t",
"CCMAC\tc\tCulture Collection of Macromycetes (Basidiomycotina and Ascomycotina)\t\t",
"CCMCU\tc\tCulture Collection of Microorganisms\t\t",
"CCMF\tc\tUniversity of Portsmouth\t\t",
"CCMGE\ts\tChernyshev Central Museum of Geological Explorations,Collections of the Department of Herpetology, Zoological Institute of the Russian Academy of Sciences\t\t",
"CCMH\th\tConcordia College\t\t",
"CCMI\tc\tCulture Collection of Industrial Microorganisms\t\t",
"CCML\ts\tColeccion Ictiologica del Departamento de Ciencias Marinas de la Universidad de la Laguna\t\t",
"CCMM\tc\tMoroccan Coordinated Collections of Microorganisms\t\t",
"CCMP\tc\tProvasoli-Guillard National Center for Marine Algae and Microiota\t\t",
"CCNH\ts\tCentral Michigan University, Center for Cultural and Natural History\t\t",
"CCNL\ts\tConnecticut College, Botany Department\t\t",
"CCNP\ts\tCarlsbad, Carlsbad Caverns National Park\t\t",
"CCNP<POL>\tc\tCulture Collection of Northern Poland\t\t",
"CCNU\ts\tCentral China Normal University, Biology Department\t\t",
"CCO\ts\tCarleton University, Biology Department\t\t",
"CCOS<CHE>\tc\tCulture Collection of Switzerland\t\t",
"CCPF\tc\tCollection of Phytopathogenic Fungi\t\t",
"CCR\ts\tChichester District Museum\t\t",
"CCRI\tc\tCollection du Centre de Recherche en Infectiologie\t\t",
"CCRI<IND>\tscb\tThe Central Coffee Research Institute\t\t",
"CCSIIA\tc\tCulture Collection of Sichuan Industrial Institute Antibiotics\t\t",
"CCSRL\ts\tCentro Studi e Ricerche Ligabue\t\t",
"CCSU\ts\tCentral Connecticut State University, Biological Sciences Department\t\t",
"CCT\tc\tColecao de Culturas Tropical\t\t",
"CCTCC\tc\tChina Center for Type Culture Collection\t\t",
"CCTM\tc\tCentre de Collection de Type Microbien, Institut de Microbiologie, Universite de Lausanne\t\t",
"CCTR\tc\tCulture Collection Trutnov\t\t",
"CCTS\th\tUniversidade Federal de Sao Carlos\t\t",
"CCTU\tc\tCulture Collection of Tabriz University\t\t",
"CCUF\ts\tUniversidade Federal de Alagoas, Centro de Ciencias Biologicas\t\t",
"CCUG\tc\tCulture Collection, University of Goteborg, Department of Clinical Bacteriology\t\t",
"CCVC\ts\tCentenary College, Vertebrate Collection\t\t",
"CCVCC\tc\tChina Center For Virus Culture Collection\t\t",
"CCW\ts\tCasper College\t\t",
"CCY<NLD>\tc\tCulture Collection Yerseke, Department of Marine Microbiology\t\t",
"CCY<SVK>\tc\tCulture Collection of Yeasts, Slovak Academy of Sciences, Institute of Chemistry\t\t",
"CDA<CAN>\tc\tCanadian Department of Agriculture\t\t",
"CDA<USA-CA>\ts\tCalifornia Department of Food and Agriculture\t\t",
"CDBB\tc\tColeccion Nacional de Cepas Microbianas y Cultivos Celulares\t\t",
"CDBI\ts\tChengdu Institute of Biology\t\t",
"CDC\tc\tCenters for Disease Control and Prevention\t\t",
"CDC<CHN>\ts\tChangdu Institute for Drug Control\t\t",
"CDCM\ts\tChengdu College of Traditional Chinese Medicine\t\t",
"CDFM\ts\tCardiff Museum\t\t",
"CDFN\ts\tCanadian Forest Service - Atlantic\t\t",
"CDN\ts\tWhitgift School\t\t",
"CDRI\ts\tCentral Drug Research Institute\t\t",
"CDRS\ts\tInvertebrate Collection\t\t",
"CDS\ts\tCharles Darwin Research Station, Botany Department\t\t",
"CEAM\ts\tCentro de Entomologica y Acarologia\t\t",
"CEB\ts\tTadulako University\t\t",
"CEBU\ts\tUniversity of San Carlos, Biology Department\t\t",
"CECT\tc\tColeccion Espanola de Cultivos Tipo\t\t",
"CEDD\ts\tInternational Center for Ethnomedicine and Drug Development\t\t",
"CEDiT\ts\tCentre of Excellence for Dinophyte Taxonomy\t\t",
"CEEF\ts\tEscuela Nacional de Ciencias Forestales\t\t",
"CEET\ts\tEl Colegio de la Frontera Sur, Colleccion de Insectos Asociados a Plantas Cultivadas en la Frontera Sur\t\t",
"CEL\ts\tUniversity of Illinois, Crop Sciences Department\t\t",
"CELM\ts\tColeccion Entomologica \"Luis Maria Murillo\"\t\t",
"CELMS\tc\tCollection of Environmental and Laboratory Microbial Strains\t\t",
"CEMBP\ts\tCentre of Excellence in Marine Biology\t\t",
"CEN\ts\tGenetic Resources and Biotechnology (CENARGEN), EMBRAPA\t\t",
"CENA<BRZ>\ts\tCentro de Energia Nuclear na Agricultura, Universidade de Sao Paulo\t\t",
"CENA<NIC>\ts\tCentro Nacional de Proteccion Vegetal\t\t",
"CENACUMI\tc\tCentro Nacional de Cultivos Microbianos (National Center For Microbial Cultures)\t\t",
"CENG\ts\tCentro Experimental de Nueva Guinea\t\t",
"CEP\tc\tEntomopathogenic Fungal Culture Collection of Argentina\t\t",
"CEPEC\ts\tCEPEC, CEPLAC\t\t",
"CEPH\tb\tFoundation Jean Dausset (CEPH)\t\t",
"CEPIM\tc\tCentro per gli Enterobatteri Patogeni per l'Italia Meridionale\t\t",
"CEPM\tc\tCEPM- Centre d'Etudes sur le Polymorphisme des Micro-organismes\t\t",
"CERL/BIC\ts\tUnited States Army, Biological Inventory Collection\t\t",
"CERN\ts\tUniversity\t\t",
"CES\ts\tThe Centre for Ecological Sciences,  Indian Institute of Science\t\t",
"CESJ\ts\tUniversidade Federal de Juiz de Fora, Departamento de Botanica\t\t",
"CESK\ts\tMuzeum Teainska\t\t",
"CEST\ts\tCentral Experiment Station\t\t",
"CET\ts\tCentro de Estudios Tropicales\t\t",
"CETESB\tc\tSetor de Pesquisa Tecnologica de Sistemas de Tratamento de Efluentes Domesticos\t\t",
"CEU\ts\tCollage of Eastern Utah\t\t",
"CFB\ts\tNorthern Forestry Centre, Canadian Forest Service\t\t",
"CFBH\ts\tCelio F.B. Haddad Herpetological Collection, Departamento de  Zoologia, Universidade Estadual Paulista\t\t",
"CFBP\tc\tCollection Francaise des Bacteries Phytopathogenes\t\t",
"CFCC\tcb\tChina Forestry Culture Collection Center\t\t",
"CFI\ts\tGenetic Resources and Biotechnology (CENARGEN), EMBRAPA\t\t",
"CFIA\th\tCanadian Food Inspection Agency\t\t",
"CFMR\tsc\tUSDA Forest Service, Center for Forest Mycology Research\tFPL",
"CFN\ts\tClifton College, Biology Department\t\t",
"CFNL\ts\tUniversidad Autonoma de Nuevo Leon\t\t",
"CFQ\tc\tCepario de la Facultad de Quimica\t\t",
"CFRB\ts\tChinese Academy of Forestry, Forest Research Institute\t\t",
"CFS\ts\tCanadian Forest Service, Pacific Forest Research Centre\t\t",
"CFSHB\ts\tNorth Coast Regional Botanic Gardens\t\t",
"CFUA\ts\tUniversidad Austral de Chile\t\t",
"CG\tc\tEmbrapa Collection of Fungi of Invertebrates\t\t",
"CGC\tb\tCaenorhabditis Genetics Center\t\t",
"CGE\ts\tUniversity of Cambridge, Department of Plant Sciences\t\t",
"CGEC\ts\tChina Entomological Research Institute\t\t",
"CGG\ts\tCambridge University Botanic Garden\t\t",
"CGH\ts\tNational Museum of Prague\t\t",
"CGMCC\tc\tChina General Microbiological Culture Collection Center, Chinese Academy of Sciences\t\t",
"CGMS\ts\tUniversidade Federal de Mato Grosso do Sul, Departamento de Biologia\t\t",
"CGN\ts\tCentre for Genetic Resources, The Netherlands\t\t",
"CGRIS\tb\tChinese Crop Germplasm Resources Information Network\t\t",
"CGSC\tc\tE. coli Genetic Stock Center\t\t",
"CH\ts\tCirculo Herpetologico de Panama\t\t",
"CH-AG\tc\tCollection de Recherche\t\t",
"CHA\ts\tHebei Agrotechnical Teachers College\t\t",
"CHAB\ts\tFar East Forestry Research Institute\t\t",
"CHAF\ts\tChaffey College, Biology Department\t\t",
"CHAM\ts\tI.N.T.A., E.E.A. La Rioja\t\t",
"CHAP\ts\tUniversidad Autonoma Chapingo\t\t",
"CHAPA\ts\tColegio de Postgraduados, Botanica, IRENAT\t\t",
"CHARL\ts\tCharleston Museum\t\t",
"CHAS<USA-IL>\ts\tChicago Academy of Sciences\t\t",
"CHAS<USA-SC>\ts\tSouthern Research Station\t\t",
"CHBG\ts\tChristchurch Botanic Gardens\t\t",
"CHE\ts\tSociete Nationale des Sciences Naturelles et Mathematiques de Cherbourg\t\t",
"CHEB\ts\tRegional Museum Cheb\t\t",
"CHEL\ts\tChelsea Physic Garden\t\t",
"CHELB\ts\tCheltenham College for Boys\t\t",
"CHEP\ts\tEscuela Superior Politecnica del Chimborazo\t\t",
"CHER\ts\tYu. Fedcovich Chernivtsi State University, Botany Department\t\t",
"CHFD\ts\tChelmsford and Essex Museum\t\t",
"CHI\ts\tUniversity of Illinois, Biological Sciences Department\t\t",
"CHIA\ts\tNational Chiayi Agricultural College, Forestry Department\t\t",
"CHIC\ts\tChicago Botanic Garden, Research Department\t\t",
"CHINM\ts\tInstituto Nacional de Microbiologia\t\t",
"CHIOC\ts\tHelminthological Collection of Oswaldo Cruz Institute (Coleccion. Helmintologica del Instituto Oswaldo Cruz)\t\t",
"CHIP\ts\tInstituto de Historia Natural, Departamento de Botanica\t\t",
"CHIS\ts\tAcademy of Sciences of Moldova\t\t",
"CHISA\ts\tUniversity of Agriculture\t\t",
"CHL\ts\tCheltenham Grammar School\t\t",
"CHM<UK>\ts\tCheltenham Art Gallery and Museum\t\t",
"CHM<USA-SC>\ts\tCharleston Museum\t\t",
"CHNCB\ts\tCentre d'Historia Natural de la Conca de Barbera\t\t",
"CHOCO\ts\tUniversidad Tecnologica del Choco\t\t",
"CHOM\ts\tOkresni muzeum Chomutov\t\t",
"CHPU\ts\tChelyabinsk State Pedagogical University, Botany Department\t\t",
"CHR\ts\tAllan Herbarium\tLCR:CHR",
"CHRB\ts\tRutgers University - Cook College\t\t",
"CHRG\ts\tGrosvenor Museum\t\t",
"CHSC\ts\tCalifornia State University, Biological Sciences Department\t\t",
"CHT\ts\tCheltenham College\t\t",
"CHUG\ts\tGaryounis University, Botany Department\t\t",
"CHULA\tc\tMicrobiology Department Faculty of Science\t\t",
"CHUNB\ts\tUniversity of Brasilia Herpetological Collection\t\t",
"CHUR\ts\tBuendner Natur-Museum\t\t",
"CI\ts\tCarnegie Institution of Washington, Plant Biology Department\t\t",
"CIAN<MEX-AG>\ts\tInstituto Nacional de Investigaciones Forestales, Agricolas y Pecuarias (INIFAP)\t\t",
"CIAN<MEX-CO>\ts\tCentro de Investigaciones Agricolas Nortoeste\t\t",
"CIAT\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture)\t\t",
"CIAT:Bean\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Bean Collection",
"CIAT:Cassava\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Cassava Collection",
"CIAT:Forage\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Forages Collection",
"CIAT:Rhizobium\tc\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Rhizobium Collection",
"CIB<CHN>\ts\tChengdu Institute of Biology\t\t",
"CIB<MEX-LaPaz>\ts\tCentro de Investigaciones Biologicas del Noroeste, S.C. (Mexico)\t\t",
"CIB<MEX-Veracruz>\ts\tUniversidad Veracruzana\t\t",
"CIBC\ts\tInternational Institute of Biological Control\t\t",
"CIBIO\ts\tCentro de Investigacao em Biodiversidade e Recursos Geneticos\t\t",
"CIBM\ts\tCentro Invest. Biol. Noroeste\t\t",
"CIC\ts\tAlbertson College of Idaho, Biology Department\t\t",
"CICC\tc\tChina Center for Industrial Culture Collection\t\t",
"CICCM\tc\tCawthron Institute Culture Collection of Micro-algae\t\t",
"CICESE\ts\tCentro de Investigacion Cientifica y de Educacion Superior de Ensenada\t\t",
"CICIM\tc\tCulture and Information Centre of Industrial Microorganisms of China's Univeristies\t\t",
"CICIMAR\ts\tCentro Interdisciplinario de Ciencias Marinas\t\t",
"CICV\tc\tCentro de Investigaciones en Ciencias Veterinarias\t\t",
"CICY\ts\tCentro de Investigacion Cientifica de Yucatan, A.C. (CICY)\t\t",
"CIDA\ts\tAlbertson College, Museum of Natural History\t\t",
"CIECRO\ts\tCounty Record Office, Cambridgeshire\t\t",
"CIES\tc\tCentro de Investigacion, Experimentacion y Servicios del  Champinon\t\t",
"CIFE\ts\tCentral Institute of Fisheries Education\t\t",
"CIIDIR\ts\tInstituto Politecnico Nacional\t\t",
"CIJC\ts\tMuzeului Judetean Covasna, Collection of Insects\t\t",
"CIMAP\ts\tCentral Institute of Medicinal and Aromatic Plants\t\t",
"CIMAR\ts\tUniversidad Catolica de Valparaiso, Centro de Investigaciones del Mar\t\t",
"CIMI\ts\tCentro Interdisciplinario de Investigacion para el Desarrollo Integral Regional (CIIDIR) IPN-Michoacan\t\t",
"CIMMYT\tscb\tInternational Maize and Wheat Improvement Center\t\t",
"CIMNH\ts\tAlbertson College of Idaho, Orma J. Smith Museum of Natural History\t\t",
"CIMSC\tc\tCollezione Instituto di Microbiologia\t\t",
"CINC\ts\tUniversity of Cincinnati, Biological Sciences Department\t\t",
"CIP\tc\tPasteur Institute Collection, Biological Resource Center of Pasteur Institute (CRBIP)\tCIP<FRA>",
"CIP<COL>\ts\tCentro de Investigaciones Pesqueras\t\t",
"CIP<ECU>\tc\tInternational Potato Center\t\t",
"CIP<PER>\tb\tCentro Internacional de las Papas\t\t",
"CIPDE\tc\tCollection of Insect Pathogens, Dept. of Entomology\t\t",
"CIPT\tc\tCollection Institut Pasteur Tuberculose\t\t",
"CIQR\ts\tEl Colegio de la Frontera Sur\t\t",
"CIR\ts\tRoyal Agricultural College\t\t",
"CIRAD\tsb\t Centre de Cooperation Internationale en Recherche Agronomique pour le Developpement\t\t",
"CIRUV\ts\tColeccion Ictiologica de Referencia de la Universidad del Valle\t\t",
"CIS<CHN>\ts\tAcademia Sinica and State Planning Commission\t\t",
"CIS<USA-CA>\ts\tCalifornia Insect Survey\t\t",
"CIS<USA-MI>\ts\tCranbrook Institute of Science\tCISM",
"CISM<MEX>\tc\tVerticillium dahliae from cotton\t\t",
"CISM<THAI>\tc\tNifTAL Rhizobium Collection (Asia Center)\t\t",
"CIT\ts\tCitrus Research Institute\t\t",
"CITA\ts\tThe Citadel, Biology Department\t\t",
"CIUC\ts\tCentro Interdipartimentale dell'Universita Museo di Storia Naturale e del Territorio\t\t",
"CIZ\ts\tCentro de Investigaciones Zoologicas\t\t",
"CKE\ts\tCalke Abbey\t\t",
"CL\ts\tBabes-Bolyai University\t\t",
"CLA\ts\tUniversitatea de Stiinte Agricole si Medicina Veterinara\t\t",
"CLARK\th\tDr. Charles F. and Wilhelmina Husser Clark Herbarium\t\t",
"CLCB\ts\tLaboratorul de Ecologie\t\t",
"CLCC\ts\tAugustana University College\t\t",
"CLD\ts\tCleveland Literary and Philosophical Society\t\t",
"CLE\ts\tTullie House Museum\t\t",
"CLEMS\ts\tClemson University, Biological Sciences Department\t\t",
"CLEV\ts\tCleveland Museum of Natural History\t\t",
"CLEY\ts\tCoastal Ecology Research Station\t\t",
"CLF\ts\tInstitut des Universitaires et Musee Lecoq\t\t",
"CLI\ts\tLiterary and Philosophical Institution of Chatham\t\t",
"CLIB\tc\tCollection de Levures d'Interet Biotechnologique Collection of Yeasts of Biotechnological Interest\t\t",
"CLIOC<BRA>\tc\tColecao de Leishmania do Instituto Oswaldo Cruz\tIOC:CL",
"CLM\ts\tCleveland Museum of Natural History, Botany Department\t\t",
"CLMP\ts\tDepartment of Conservation & Land Management\t\t",
"CLNP\ts\tCrater Lake National Park\t\t",
"CLOE\ts\tClitheroe Castle Museum\t\t",
"CLP\ts\tForest Products Research and Development Institute, Department of Science and Technology\t\t",
"CLQCA\tc\tColeccion de Levaduras quito catolica\t\t",
"CLR\ts\tAll Saint's Church, Colchester Borough Council\t\t",
"CLU\ts\tUniversita della Calabria\t\t",
"CM\ts\tCarnegie Museum of Natural History\tCMNH<USA-PA>",
"CM-IEA\ts\tUniversidad Autonoma de Tamaulipas (Mexico)\t\t",
"CM-MBM-UAC\ts\tColeccion Mastozoologica de la Museo de Biodiversidad Maya, Universidad  Autonoma de Campeche\tCM-MBM-UAC",
"CM-UMSNH\ts\tUniversidad de Michoacan (Mexico)\t\t",
"CM:M\ts\tCarnegie Museum of Natural History, Section of Mammals",
"CM:O\ts\tCarnegie Museum of Natural History, Section of Birds",
"CM<CHN>\ts\tChongqing Museum\t\t",
"CMA\ts\tCrayford Manor House Adult Education Centre\t\t",
"CMAA\tc\tCulture Collection of Agriculture and Environmental Importance\t\t",
"CMBGCAS\tc\tCollection of Marine Biological Germplasm\t\t",
"CMBK\ts\tThe City Museum and Art Gallery, Department of Natural History\t\t",
"CMBY\ts\tCamberley Museum\t\t",
"CMC<MEX>\ts\tColeccion Mastozoologica del Centro de Investigacion en Biodiversidad y Conservacion,Universidad Autonoma del Estado de Morelos\t\t",
"CMC<NZ>\ts\tCanterbury Museum\t\t",
"CMC<USA-MI>\ts\tCentral Michigan University, Department of Biology\t\t",
"CMCC\tc\tNational Center for Medical Culture Collections\t\t",
"CMCNA\ts\tMuseo de Ciencias Naturales y Antropologicas \"Prof. A. Serrano\"\t\t",
"CMDM-PUJ\tc\tColeccion de Microorganismos de la Pontificia Universidad Javeriana (Collection Microorganisms of the Pontificia Universidad Javeriana)\tCMDM-PUJ",
"CMEI\ts\tClements' Museum of Exotic Insects\t\t",
"CMFRI\ts\tSee FMRI\t\t",
"CMGP\ts\tCentral Museum of Geological Prospecting\t\t",
"CMH\ts\tCanadian Museum of History\t\t",
"CMIZASDPRK\ts\tCustody Museum\t\t",
"CMKKU\tc\tClinical Diagnostic Microbiology Srinagarind Hospital, Faculty of Medicine\t\t",
"CML\ts\tUniversidad Nacional de Tucuman, Coleccion de Mamiferos Lillo (Argentina)\t\t",
"CML<BRA>\tc\tColecao Micologica de Lavras\t\t",
"CMM\ts\tBradford Art Galleries and Museums, Natural Sciences Department\t\t",
"CMM<BRA>\tc\tCulture Collection of Phytopathogenic Fungi  (Colecao de Culturas de Fungos Fitopatogenicos Prof. Maria Menezes)\t\t",
"CMMC\tc\tChina Marine Microbe Collection\t\t",
"CMMED<USA-HI>\tc\tCenter for Marine Microbial Ecology & Diversity Collection\t\t",
"CMMEX\ts\tUniversidad Autonoma de Baja California\t\t",
"CMMF\th\tJardin botanique de Montreal\t\t",
"CMMI\ts\tChinese Academy of Traditional Medicine\t\t",
"CMML\ts\tColorado State University Herbarium\t\t",
"CMN\ts\tCanadian Museum of Nature\t\t",
"CMN:Annelid\ts\tCanadian Museum of Nature, Annelid Collection",
"CMN:Bird\ts\tCanadian Museum of Nature, Bird Collection",
"CMN:Crustacean\ts\tCanadian Museum of Nature, Crustacean Collection",
"CMN:Fish\ts\tCanadian Museum of Nature, Fish Collection",
"CMN:GenInvert\ts\tCanadian Museum of Nature, General Invertebrate Collextion",
"CMN:Herp\ts\tCanadian Museum of Nature, Amphibian and Reptile Collection",
"CMN:Insect\ts\tCanadian Museum of Nature, Insect Collection",
"CMN:Mammal\ts\tCanadian Museum of Nature, Mammal Collection",
"CMN:Mollusc\ts\tCanadian Museum of Nature, Mollusc Collection",
"CMN:Parasite\ts\tCanadian Museum of Nature, Parasite Collection",
"CMNAR\ts\tCanadian Museum of Nature, Amphibian and Reptile Collection\t\t",
"CMNC\ts\tCanadian Museum of Nature, Neotropical Cerambycidae Collection\t\t",
"CMNFI\ts\tCanadian Museum of Nature, Fish Collection\t\t",
"CMNH\ts\tThe Cleveland Museum of Natural History\t\t",
"CMNS\ts\tMuseum of Natural History, Shanghai\t\t",
"CMNZ\ts\tCanterbury Museum\t\t",
"CMPH\th\tColegio de Postgraduados\t\t",
"CMPR\th\tCentre for Medicinal Plants Research\t\t",
"CMS\th\tChristian Missionary Society College\t\t",
"CMSK\ts\tCity Museum, Sheffield\t\t",
"CMSU\ts\tCentral Missouri State University\t\t",
"CMU\ts\tChiang Mai University\t\t",
"CMUB\th\tChiang Mai University\t\t",
"CMUH\th\tCentral Mindanao University\t\t",
"CMUT\ts\tChiang Mai University\t\t",
"CMV\ts\tCentre Marie-Victorin\t\t",
"CMW\tc\tForestry and Agricultural Biotechnology Institute, University of Pretoria, Pretoria\t\t",
"CMY\ts\tR. G. Kar Medical College, Botany Department\t\t",
"CN<FR>\ts\tUniversite de Caen\t\t",
"CN<UK>\tc\tWellcome Collection of Bacteria, Burroughs Wellcome Research Laboratories\t\t",
"CNC\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes\t\t",
"CNC:Arachnida\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Arachnida (Mites, Ticks, Spiders)",
"CNC:Coleoptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Coleoptera (Beetles)",
"CNC:Diptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Diptera (Flies)",
"CNC:Hemiptera\t\tCanadian National Collection of Insects, Arachnids, and Nematodes, ",
"CNC:Hymenoptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Hymenoptera (Sawflies, Parasitic Wasps, Ants, Wasps, Bees)",
"CNC:Lepidoptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Lepidoptera (Butterflies, Moths)",
"CNC:Miscellaneous\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Miscellaneous Insect Orders",
"CNC:Nematoda\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Nematoda (Roundworms)",
"CNCI\ts\tCanadian National Collection Insects\t\t",
"CNCM\tc\tCollection Nationale de Cultures de Microorganismes\t\t",
"CNCTC\tc\tCzech National Collection of Type Cultures\t\t",
"CNE\ts\tVictoria Jubilee Museum\t\t",
"CNEN-LABPC\tc\tLaboratorio de Pocos de Caldas\t\t",
"CNF\ts\tCroatian Mycological Society\t\t",
"CNH\th\tCanakkale Onsekiz Mart University\t\t",
"CNHM<CRO>\ts\tCroatian Natural History Museum, Botany Department\t\t",
"CNHM<USA-OH>\ts\tCincinnati Museum of Natural History\t\t",
"CNHM<USA-OH>:ORNITH\ts\tCincinnati Museum of Natural History, Ornithology collection",
"CNHP\ts\tBeijing Natural History Museum\t\t",
"CNHS\ts\tCroydon Natural History and Scientific Society\t\t",
"CNM\ts\tCheltenham Naturalists' Association\t\t",
"CNM-CM\tc\tFilamentous fungus collection of the Spanish National Center for Microbiology\t\t",
"CNM<ESP>\ts\tCentro Nacional de Microbiologia\t\t",
"CNMC\ts\tColorado National Monument\t\t",
"CNMS\ts\tColombo National Museum\t\t",
"CNMT\th\tUniversidade Federal de Mato Grosso\t\t",
"CNPO\th\tEmbrapa Pecuaria Sul\t\t",
"CNPS\ts\tCentro Nacional de Pesquisas da Soja\t\t",
"CNPSo\tc\tCulture Collection of Diazotrophic and Plant Growth Promoting Bacteria of Embrapa Soja\t\t",
"CNR\th\tCrimean Natural Reserve\t\t",
"CNRO\ts\tCentre National de Recherches Oceanographiques\t\t",
"CNRS\ts\tCentre National de la Recherche Scientifique\t\t",
"CNRZ\tc\tCentre National de Recherches Zootechniques\t\t",
"CNS<AUS>\ts\tAustralian Tropical Herbarium\t\t",
"CNSF\th\tCentre National de Semences Forestieres\t\t",
"CNU<CHN>\ts\tCapital Normal University, College of Life Sciences\t\t",
"CNU<KOR-TJ>\ts\tChungnam National University\t\t",
"CNU<KOR>\ts\tChonbuk National University\t\t",
"CNUK\th\tChungnam National University\t\t",
"CNWGRGL\tb\tChinese National Waterfowl Germplasm Resources Gene Library\t\t",
"CO\ts\tMuseum National d'Histoire Naturelle, Department of Marine Biology\t\t",
"COA\ts\tHerbario, Universidad de Cordoba - Jardin Botanico de Cordoba\t\t",
"COA<USA-ME>\ts\tCollege of the Atlantic, Museum\t\t",
"COAD\tc\tColecao Octavio de Almeida Drumond\t\t",
"COAH\ts\tHerbario Amazonico Colombiano (Instituto Amazonico de Investigaciones Cientificas SINCHI)\tCOAH<IH>",
"COCA\ts\tComision Tecnico Consultiva de Coeficientes de Agostadero (COTECOCA)\t\t",
"COCAZ\th\tCoconino National Forest Herbarium\t\t",
"COCH\ts\tUniversidad Mayor de San Simon, Departamento de Botanica\t\t",
"COCO\ts\tColorado College, Biology Department\t\t",
"CODAGEM\ts\tUniversidad Autonoma del Estado de Mexico\t\t",
"CODIMAR\tc\tCentro de Investigaciones Biologicas del Noroeste\t\t",
"COFC\ts\tUniversidad de Cordoba, Departamento de Biologia Vegetal\t\t",
"COI\ts\tUniversity of Coimbra\t\t",
"COL\ts\tUniversidad Nacional de Colombia\t\t",
"COLG\ts\tColumbus State University, Biology Department\t\t",
"COLM\ts\tColorado National Monument\t\t",
"COLO\ts\tUniversity of Colorado\t\t",
"COLOM\ts\tColorado State Museum\t\t",
"COM\ts\tColombo Museum\t\t",
"CON\ts\tBristol, Clifton and West of England Zoological Society's Gardens\t\t",
"CONC\ts\tUniversidad de Concepcion, Departamento de Botanica\t\t",
"CONN\ts\tUniversity of Connecticut, Department of Ecology and Evolutionary Biology\t\t",
"CONV\ts\tConverse College, Biology Department\t\t",
"COP<VEN>\ts\tColeccion Ornitologica Phelps\t\t",
"COR\ts\tUniversidade Federal de Mato Grosso do Sul, Departamento de Ciencias do Ambiente\t\t",
"CORB\ts\tCorchester School\t\t",
"CORBIDI\ts\tCentro de Ornitologia y Biodiversidad\t\t",
"CORD\ts\tUniversidad Nacional de Cordoba\t\t",
"Coriell\tcb\tCoriell Institute for Medical Research\t\t",
"CORO\ts\tIUTAG, Departamento de Investigacion\t\t",
"CORT\ts\tState University of New York College at Cortland, Biological Sciences Department\t\t",
"CORU\ts\tUniversidad Veracruzana, Campus Cordoba\t\t",
"COV\ts\tHerbert Art Gallery and Museum\t\t",
"COVY\ts\tCoventry and District Natural History Society\t\t",
"CP\ts\tRoyal Veterinary and Agricultural University, Plant Biology Department\t\t",
"CPAC\tc\tCentro de Pesquisas Agropecuarias do Cerrado\t\t",
"CPAP<BRA-Belem>\ts\tCentro de Pesquisas Agropecuarias do Tropico Umido\t\t",
"CPAP<BRA-Corumba>\ts\tHerbario, Centro de Pesquisas Agropecuarias do Pantanal, EMBRAPA\t\t",
"CPATU\ts\tCentro de Pesquisa Agroflorestal da Amazonia Oriental-Embrapa\t\t",
"CPB\ts\tNational Institute for the Control of Pharmaceutical and Biological Products\t\t",
"CPC\tc\tCulture collection of Pedro Crous\t\t",
"CPCC\tc\tCanadian Phycological Culture Centre\tUTCC",
"CPDC\ts\tCentro de Pesquisas do Cacau\t\t",
"CPF\ts\tKwaZulu-Natal Nature Conservation Service\t\t",
"CPH\ts\tUniversity of the Pacific, Biological Sciences Department\t\t",
"CPHS\tc\tWHO/FAO/OIE Collaborating Centre for Reference and Research on Leptospirosis, Western Pacific Region\t\t",
"CPM\ts\tChristoffel Park Museum\t\t",
"CPMM\ts\tDr. Alvaro de Castro Provincial Museum\t\t",
"CPNP\ts\tCuc Phuong National Park\t\t",
"CPPIPP\tc\tCollection of Plant Pathogens\t\t",
"CPPLIP\ts\tCentro de Pesquisas Paleontologias Llewellyn Ivor Price\t\t",
"CPRC\ts\tCaribbean Primate Research Center Museum\t\t",
"CPRR\tc\tLaboratorio de Doenca de Chagas\t\t",
"CPS<USA-WA>\ts\tUniversity of Puget Sound, Slater Museum of Natural History\t\t",
"CPS<USA-WY/CO>\ts\tWyoming-Colorado Paleontological Society\t\t",
"CPSC\ts\tUniversity of Puget Sound\t\t",
"CPSU\ts\tCalifornia Polytechnic State University, San Luis Obispo\t\t",
"CPU\ts\tChina Pharmaceutical University\t\t",
"CPUN\ts\tUniversidad Nacional de Cajamarca, Departamento de Biologia\t\t",
"CPUP\ts\tCalifornia Polytechnic University\t\t",
"CPZ\tc\tCentro Panamericano de Zoonosis\t\t",
"CQBG\ts\tChongqing Botanical Garden\t\t",
"CQNM\ts\tChongqing Natural History Museum\t\t",
"CR\ts\tMuseo Nacional de Costa Rica\t\t",
"CRA-CIN\tc\tConsiglio per la Ricerca e sperimentazione in Agricoltura - Centro ricerche per  le Colture Industriali ( Research Centre for Industrial Crops)\t\t",
"CRA-COLMIA<ITA>\tc\tCollezione Nazionale di Microrganismi di interesse Agrario ed Industriale ed Ambientale - COL.MIA\t\t",
"CRA-OLI\tb\tCentro di Ricerca per l'Olivicoltura e l'Industria Olearia\t\t",
"CRA-PAV<ITA>\tc\tCentro di Ricerca per la Patologia Vegetale\tISPaVe",
"CRAF\ts\tUniversity of Craiova, Phytopathology Department\t\t",
"CRAI\ts\tUniversity of Craiova\t\t",
"CRBF\tc\tCollection de genomes d'organismes symbiotiques\t\t",
"CRBK\ts\tCranbrook School\t\t",
"CRBO\tc\tCentre de Ressource Biologique Oenologique\tIOEB",
"CRBY\ts\tCrosby Library\t\t",
"CRC\tc\tChlamydomonas Resource Center\t\t",
"CRCA\ts\tInstituto dos Cereais\t\t",
"CRCM\ts\tWashington State University, Charles R. Conner Museum\t\t",
"CRCM:Bird\ts\tWashington State University, Charles R. Conner Museum, bird collection",
"CRCM:Mammal\ts\tWashington State University, Charles R. Conner Museum, Mammal Collection",
"CRD\ts\tInstituto Politecnico Nacional, Coleccion Cientifica de Fauna Silvestre (Mexico)\t\t",
"CRE<CRI>\ts\tCosta Rica Expeditions\t\t",
"CRE<USA-CA>\ts\tUniversity of Southern California\t\t",
"CREG\ts\tInstituto Tecnologico Agropecuario de Jalisco\t\t",
"CRGF\tc\tCollection de Recursos Geneticos Fungicos, Instituto de Ecologia y Systematica\t\t",
"CRH\ts\tCentre de Recherche en Hydrobiologie\t\t",
"CRI\ts\tUniversidade do Extremo Sul Catarinense, Bairro Universitario\t\t",
"CRIFC\ts\tCentral Research Institute for Field Crops in Turkey\t\t",
"CRK\ts\tUniversity College, Plant Science Department\t\t",
"CRL\tc\tCentro de Referencia Para Lactobacilos\t\t",
"CRLA\ts\tCrater Lake National Park, Museum and Archives Collections\t\t",
"CRMC\ts\tCollege of the Redwoods, Mendocino Coast Campus, Biological Sciences Department\t\t",
"CRMM\ts\tCentre de Recherche sur les Mammiferes Marins\t\t",
"CRO\ts\tWellington College\t\t",
"CRP\ts\tI.N.T.A., E.E.A. Bariloche\t\t",
"CRRHA\ts\tCentre Regional de Recherches en Hydrobiologie Appliquee\t\t",
"CS<AUS>\tc\tCSIRO Collection of Living Micro-algae\t\t",
"CS<FRA>\ts\tMusee des Dinosaures d'Esperaza (Aude)\t\t",
"CS<USA-CO>\ts\tColorado State University, Biology Department\t\t",
"CSAT\ts\tColegio de Postgraduados, Campus Tabasco\t\t",
"CSAU\ts\tNational Agrarian University, Southern Branch \"Crimean Agrotechnological University\", Department of Botany, Plant Physiology and Genetics\t\t",
"CSB\ts\tSt. John's University/College of Saint Benedict, Biology Department\t\t",
"CSC\ts\tColegio del Sagrado Corazon\t\t",
"CSC-CLCH\tc\tCentro Substrati Cellulari, Cell Lines Collection and Hybridomas\t\t",
"CSCA\ts\tCalifornia State Collection of Arthropods\t\t",
"CSCC\tc\tCSIRO Starter Culture Collection\t\t",
"CSCCE\ts\tChadron State College, Entomology Collection\tCSCC",
"CSCCV\ts\tChadron State College, Collection of Vertebrates\t\t",
"CSCN\ts\tChadron State College\t\t",
"CSCS<PHL>\ts\tCebu State College of Science and Technology, Agricultural Biology Laboratory\t\t",
"CSCS<USA-CA>\ts\tCalifornia State University, Turlock\t\t",
"CSDS\ts\tDesert Studies Center\t\t",
"CSFI\ts\tCentral-South Forestry University\t\t",
"CSGP\ts\tServicos Geologicos de Portugal\t\t",
"CSGT\ts\tCollegio San Giuseppe\t\t",
"CSH\ts\tShanghai Chenshan Botanical Garden\t\t",
"CSIR\tc\tCouncil for Scientific and Industrial Research\t\t",
"CSIRO\ts\tCommonwealth Science & Industrial Research Organization\t\t",
"CSIRO:Ichthyology\ts\tCommonwealth Science & Industrial Research Organization, Australian National Fish Collection",
"CSJ\ts\tColegio de San Jose, Museo de Historia Natural, Medellin\t\t",
"CSLA\ts\tCalifornia State University, Department of Biological Sciences\t\t",
"CSLB\ts\tCalifornia State University at Long Beach\t\t",
"CSMA\tc\tCentro di Studio dei Microorganismi Autotrofi - CNR\t\t",
"CSPM\ts\tColegio Lasalle Palma de Mallorca\t\t",
"CSPU\ts\tCalifornia State Polytechnic University, Biological Sciences Department\t\t",
"CSPUP\ts\tCalifornia State Polytechnic University, Pomona\t\t",
"CSR\ts\tCaucasus State Nature Biosphere Reserve\t\t",
"CSTIU\ts\tFaculty of Science, University of Tokyo\t\t",
"CSU<USA-CO>\ts\tColorado State University\tCSUC",
"CSU<USA-OK>\ts\tUniversity of Central Oklahoma, Biology Department\t\t",
"CSUC\ts\tCalifornia State University, Chico, Vertebrate Museum\t\t",
"CSUCI\th\tCalifornia State University Channel Islands\t\t",
"CSUF\ts\tCalifornia State University, Fresno\t\t",
"CSUH\th\tChelyabinsk State University\t\t",
"CSULB\ts\tCalifornia State University, Long Beach\t\t",
"CSUN\ts\tCalifornia State University, Northridge\t\t",
"CSUNIV\th\tCharleston Southern University\t\t",
"CSUR\tc\tCollection de Souches de l'Unite des Rickettsies\t\t",
"CSUSB\th\tCalifornia State University, San Bernardino\t\t",
"CSUTC\ts\tColorado State University, Mammalogy Teaching Collection\t\t",
"CSVFC\ts\tCaradoc and Severn Valley Field Club\t\t",
"CT\ts\tUniversity of Cape Town, Botany Department\t\t",
"CTC\th\tChongqing Normal University\t\t",
"CTES\ts\tInstituto de Botanica del Nordeste\t\t",
"CTESN\ts\tUniversidad Nacional del Nordeste\t\t",
"CTM<TUN>\tc\tCentre de Biotechnologie de Sfax culture collection\t\t",
"CTN\ts\tFree Library and Museum\t\t",
"CTNRC\ts\tThai National Reference Collections\t\t",
"CTR\ts\tCharles T. Ramsden historical collection\t\t",
"CTS\ts\tChongqing Teachers College\t\t",
"CTY\ts\tCanterbury Literary and Philosophical Institution\t\t",
"CU\tsb\tCornell University\t\t",
"CUAC\ts\tClemson University\t\t",
"CUBK\ts\tDepartment of Biology, Chonbuk National University\t\t",
"CUC\tc\tCepario de la Universidad de Concepcion de Chile\t\t",
"CUE\ts\tCairo University\t\t",
"CUETM\tc\tCollection Unite Ecotoxicologie Microbienne, INSERM\t\t",
"CUFH\ts\tCumhuriyet University, Biology Department\t\t",
"CUG\ts\tCollection Universite Poitiers\t\t",
"CUH\ts\tCalcutta University, Botany Department\t\t",
"CUHK\tsc\tBiology Department, Chinese University of Hong Kong\t\t",
"CUI\ts\tCentral College, Iowa\t\t",
"CUIC\ts\tCornell University, Invertebrate Collections\t\t",
"CUMV\ts\tCornell University Museum of Vertebrates\tCUVC<USA-NY>",
"CUMV:Amph\ts\tCornell University Museum of Vertebrates, Amphibian Collection",
"CUMV:Bird\ts\tCornell University Museum of Vertebrates, Bird Collection",
"CUMV:Fish\ts\tCornell University Museum of Vertebrates, Fish Collection",
"CUMV:Mamm\ts\tCornell University Museum of Vertebrates, Mammal Collection",
"CUMV:Rept\ts\tCornell University Museum of Vertebrates, Reptile Collection",
"CUMZ<CAN>\ts\tCarleton University, Museum of Zoology\t\t",
"CUMZ<CMR>\ts\tCameroon University, Museum of Zoology\t\t",
"CUMZ<THA>\ts\tChulalongkorn University Museum of Natural History\tCUB",
"CUMZ<THA>:R\ts\tChulalongkorn University Museum of Natural History, Reptile Collection",
"CUMZ<UK>\ts\tCambridge University, Museum of Zoology\t\t",
"CUNRC\ts\tUniversidad Nacional de Rio Cuarto, Coleccion de Mamiferos (Argentina)\t\t",
"CUP\ts\tCornell University, Plant Pathology Herbarium\t\t",
"CUP<CHN>\ts\tCatholic University of Peking\t\t",
"CUP<CZE>\ts\tCharles University\t\t",
"CURLA\th\tCentro Universitario Regional del Litoral Atlantico\t\t",
"CUS\ts\tCusino Wildlife Research Station, Natural Resources Department\t\t",
"CUSC\ts\tClemson University, Vertebrate Collections\t\t",
"CUVC<COL>\ts\tUniversidad del Valle, Departamento de Biologia\t\t",
"CUW\ts\tClark University, Biology Department\t\t",
"CUWM\ts\tClark University\t\t",
"CUZ\ts\tUniversidad Nacional San Antonio Abad del Cusco\t\t",
"CV\ts\tMunicipal Museum of Chungking\t\t",
"CVCC<CHN-1>\tc\tCenter for Veterinary Culture Collection\t\t",
"CVCC<CHN-2>\tc\tChina Veterinary Culture Collection\t\t",
"CVCM\tc\tCentro Venezolano de Colecciones de Microorganismos\t\t",
"CVCW\ts\tClinch Valley College, University of Virginia, Biology Department\t\t",
"CVM\ts\tCity Museum, Natural History Department\t\t",
"CVRD\ts\tReserva Natural da Vale do Rio Doce\t\t",
"CVUL\ts\tUniversite Laval, Collection de Vertebres\t\t",
"CVULA\ts\tColeccion Vertebrados, Facultad de Ciencias, La Hechicera, Universidad de los Andes\t\t",
"CWB\ts\tKharkov State University\t\t",
"CWC\ts\tCentral Wyoming College\t\t",
"CWDR\ts\tCawdor Castle\t\t",
"CWU\ts\tV. N. Karasin National University\t\t",
"CY\tc\tCentre des Yersinia\t\t",
"CYN\ts\tChipstead Valley Primary School\t\t",
"CYP\ts\tMinistry of Agriculture, Natural Resources and Environment, Forestry Department\t\t",
"CZ-IICT\ts\tCentro de Zoologia, Instituto de Investigacao Cientifica Tropical\t\t",
"CZAA\ts\tCatedra de Zoologia Agricola\t\t",
"CZACC\ts\tColeccion Zoologia, Academia de Ciencias de Cuba\t\t",
"CZCEN\ts\tColeccion Zoologica de la Facultad de Ciencias Exactas y Naturales\t\t",
"CZH\th\tHanshan Normal University\t\t",
"CZIP\ts\tUniversidad de Magallanes, Instituto de la Patagonia (Chile)\t\t",
"CZL\ts\tCentro de Zoologia\t\t",
"CZRMA\ts\tColeccion Zoologica Regional (Mammalia) del Instituto de Historia Natural y Ecologia\t\t",
"CZUAA\ts\tUniversidad Autonoma de Aguascalientes (Mexico)\t\t",
"CZUG\ts\tUniversidad de Guadalajara,Centro de Estudios en Zoologia, Entomologia\t\t",
"DABUH\ts\tUniversity of Helsinki, Department of Applied Biology\t\t",
"DABZ\ts\tDepartment of Agriculture, Zimbabwe\t\t",
"DACB\ts\tBangladesh National Herbarium\t\t",
"DACL\ts\tLondon Research Centre\t\t",
"DACT\tc\tDept. Agricult. Chem. Technol.\t\t",
"DAFH\ts\tDepartment of Agriculture and Fisheries\t\t",
"DAG\th\tMountain Botanical Garden of the  Dagestan Scientific Centre\t\t",
"DAKAR\ts\tUniversite Cheikh Anta Diop, Departement de Biologie Vegetale\t\t",
"DAL\ts\tDalhousie University, Biology Department\t\t",
"DANV\ts\tUmweltamt Darmstadt\t\t",
"DAO\ts\tAgriculture and Agri-Food Canada\t\t",
"DAOM\tsc\tNational Mycological Herbarium, Agriculture and Agri-Food Canada\tCCFC,DAOMC",
"DAR\tc\tPlant Pathology Herbarium\t\t",
"DARI\ts\tInsect Collection, New South Wales Department of Agriculture\t\t",
"DAS\ts\tAgriculture and Agri-Food Canada\t\t",
"DASF\ts\tDepartment of Agriculture, Stock and Fisheries\t\t",
"DAU\th\tUniversity of Daugavpils\t\t",
"DAV\ts\tUniversity of California, Plant Biology\t\t",
"DAVFP\ts\tPacific Forestry Centre, Canadian Forest Service\t\t",
"DAVH\ts\tUniversity of California, Environmental Horticulture Department\t\t",
"DAWES\th\tThe Dawes Arboretum\t\t",
"DBAI\ts\tInstituto de Ciencias Biologicas\t\t",
"DBAU\ts\tUniversidade Santa Ursula\t\t",
"DBC\ts\tUniversity College, Botany Department\t\t",
"DBCUCH\ts\tUniversidad de Chile, Departamento de Biologia Celular y Genetica\t\t",
"DBFFEUCS\ts\tDepartamento de Biologia de la Faculdad de Filosofia y Educacion de la Universidad de Chile\t\t",
"DBG\ts\tSam Mitchel Herbarium of Fungi, Denver Botanic Gardens\t\t",
"DBKKU1\tc\tDepartment of Biology, Faculty of Science\t\t",
"DBKKU2\tc\tDepartment of Biology, Faculty of Science\t\t",
"DBKKU3\tc\tDepartment of Biology, Faculty of Science\t\t",
"DBM\tc\tDepartment of Biochemistry and Microbiology\t\t",
"DBMU\tc\tBoonchird lab, Department of Biotechnology, Mahidol University\t\t",
"DBMU2\tc\tPanbangred lab, Department of Biotechnology, Mahidol University\t\t",
"DBN\ts\tNational Botanic Gardens\t\t",
"DBS\tc\tDepartment of Biological Culture Collection\t\t",
"DBSE\ts\tUniversidade Federale Sergipe\t\t",
"DBSNU\ts\tDepartment of Biology, Shaanxi Normal University\t\t",
"DBUA\tc\tZoological Collection of the Biology Department, University of the Azores\t\t",
"DBUM-IPT\tc\tDepartment of Biochemistry, Faculty of Medicine, University of Malaya\t\t",
"DBUP\tc\tAlgal Culture Collection\t\t",
"DBV\tc\tDivision of Standardisation\t\t",
"DBVPG\tc\tIndustrial Yeasts Collection\t\t",
"DBY\ts\tCity of Derby Museum and Art Gallery\t\t",
"DCBU\ts\tUniversidade Federal de Sao Carlos\t\t",
"DCCBC\tcb\tDunaliella Culture Collection at Brooklyn College\t\t",
"DCDS\ts\tDipartimento di Coltivazione e Difesa delle Specie Legnose dell'Universita, Sezione Entomologia Agraria\t\t",
"DCH\ts\tDavidson College, Biology Department\t\t",
"DCMB\ts\tUniversidade do Amazonas\t\t",
"DCMD\ts\tDerby City Museum and Art Gallery\t\t",
"DCMP\ts\tUniversidade Federal do Parana\t\t",
"DCN-UNRC\ts\tDepartamento de Ciencias Naturales, Universidad Nacional de Rio Cuarto\t\t",
"DCPC\ts\tDominicusCirillus[deceased]\t\t",
"DCR\ts\tDoncaster Museum and Art Gallery\t\t",
"DD\ts\tForest Research Institute, Indian Council of Forestry Research and Education, Systematic Botany Discipline\t\t",
"DDFF\ts\tDepartamento de Defensa Fitossanitarista\t\t",
"DDMS\th\tFundacao Universidade Federal da Grande Dourados\t\t",
"DE\ts\tDebrecen University, Botany Department\t\t",
"DE-CSIRO\tc\tCSIRO Insect Pathogen Culture Collection\t\t",
"DEBU\ts\tOntario Insect Collection, University of Guelph\tUOG:DEBU",
"DECA\ts\tAgnes Scott College, Biology Department\t\t",
"DECV\ts\tDouglas Ecological Consultants\t\t",
"DEE\ts\tMcManus Galleries, Natural History Department\t\t",
"DEES\ts\tUniversidade de Sao Paulo, Piracicaba\t\t",
"DEFS\ts\tUniversidade de Sao Paulo\t\t",
"DEI\ts\tSenckenberg Deutsches Entomologisches Institut\t\t",
"DEIB\ts\tDeutsches Entomologisches Institut\t\t",
"DEK\ts\tNorthern Illinois University, Biological Sciences Department\t\t",
"DELS\ts\tUniversity of Delaware, Plant Science Department\t\t",
"DELTA\ts\tDelta Waterfowl and Wetlands Research Station\t\t",
"DEN\ts\tDenison University, Biology Department\t\t",
"DENA\ts\tWatt Institute\t\t",
"DENF\ts\tGrand Mesa-Uncompahgre-Gunnison Natonal Forests\t\t",
"DENH\ts\tUniversity of New Hampshire\t\t",
"DERM\ts\tIntermountain Experiment Station\t\t",
"DES\tsb\tDesert Botanical Garden, Research Department\t\t",
"DEV\th\tSt. Joseph's College\t\t",
"DEVA\ts\tDeath Valley National Park\t\t",
"DEWV\ts\tDavis and Elkins College, Biology and Environmental Science Department\t\t",
"DEZA\ts\tDipartimento di Entomologia e Zoologia Agraria dell'Universita\t\t",
"DEZC\ts\tDipartimento di Entomologia e Zoologia Applicate all'Ambiente \"Carlo Vidano\"\t\t",
"DFCZ\ts\tForest Research Institute, Malawi\t\t",
"DFD\ts\tDartford Borough Museum\t\t",
"DFEC<CHN>\ts\tDesert Forestry Experimental Centre\t\t",
"DFEC<USA-NY>\ts\tDepartment of Forestry and Environmental Science, State University of New York\t\t",
"DFF\tc\tForest Pathology Culture Collection, Pacific Forest Research Centre\t\t",
"DFLC\ts\tEscola Superior de Agricultura\t\t",
"DFP\tc\tDFP Culture Collection\t\t",
"DFRU\ts\tUniversity of New Brunswick\t\t",
"DFS\ts\tDumfries and Galloway Natural History and Antiquarian Society\t\t",
"DFSM\ts\tDumfries Museum\t\t",
"DFV\ts\tDivision of Fisheres\t\t",
"DGBU\ts\tDepartment of Geology, Pusan National University\t\t",
"DGN\ts\tDarlington Museum\t\t",
"DGR\tb\tDivision of Genomic Resources, University of New Mexico\t\t",
"DGR:Bird\ts\tDivision of Genomic Resources, University of New Mexico, bird tissue collection",
"DGR:Ento\ts\tDivision of Genomic Resources, University of New Mexico, entomology tissue collection",
"DGR:Fish\ts\tDivision of Genomic Resources, University of New Mexico, fish tissue collection",
"DGR:Herp\ts\tDivision of Genomic Resources, University of New Mexico, herpetology tissue collection",
"DGR:Mamm\ts\tDivision of Genomic Resources, University of New Mexico, mammal tissue collection",
"DGS\ts\tThe Manx Museum\t\t",
"DGU\th\tDaegu University\t\t",
"DGUB\tc\tDepartment of Genetics, University of Bratislava\t\t",
"DH\ts\tHobart and William Smith Colleges, Biology Department\t\t",
"DHISUB\ts\tDepartment of Hydrobiology and Ichthyology, Sofia Univiversity\t\t",
"DHL\ts\tUniversity of Louisville, Biology Department\t\t",
"DHM\ts\tUniversity of Durham, Botany Department\t\t",
"DHMB\ts\tDepartment of Harbours and Marine\t\t",
"DHNS\ts\tDunbartonshire Natural History Society\t\t",
"DI\ts\tUniversite de Bourgogne, Laboratoire de Phytobiologie Cellulaire\t\t",
"DIA\ts\tMuseu do Dundo\t\t",
"DIAM\th\tUniversidade Federal dos Vales do Jequitinhonha e Mucuri\t\t",
"DIN\ts\tMuseum National d'Histoire Naturelle\t\t",
"DINH\ts\tDelta Institute of Natural History\t\t",
"DINO\ts\tDinosaur National Monument\t\t",
"DIS\ts\tDinamation International Society\t\t",
"DISCA\ts\tEstacion Biologica de Rancho Grande, Ministerio del Ambiente y Recursos Naturales Renovables\t\t",
"DISKO\ts\tDanish Arctic Station\t\t",
"DiSTA<ITA>\ts\tPhytoplasma Collection University of Bologna\tDiSTA",
"DIX\ts\tDixie College, Natural History Museum\t\t",
"DKG\ts\tJuniper Hall Field Centre\t\t",
"DLF\ts\tStetson University, Biology Department\t\t",
"DLU\th\tDa Lat University\t\t",
"DLY\ts\tDudley and Midland Geological and Scientific Society and Field Club\t\t",
"DM<NZ>\ts\tDominion Museum\t\t",
"DM<USA-UT>\ts\tThe Dinosaur Museum\t\t",
"DMB\ts\tDurban Museum\t\t",
"DMBC\ts\tDominick Moth and Butterfly Collection\t\t",
"DMBUK\tc\tDepartment of Microbiology, Univeristy of Kelaniya\t\t",
"DMCCUS\tc\tSchool of Biological Sciences Culture Collection\t\t",
"DMCMU2\tc\tDepartment of Microbiology, Faculty of Medicine\t\t",
"DMCU\tc\tMicrobiology Department, Faculty of Science\t\t",
"DMDC\ts\tDouala Museum\t\t",
"DMFS\ts\tCrichton Royal Institution Museum\t\t",
"DMHN\th\tThe University of Newcastle\t\t",
"DMIV\tc\tDepartment of Microbiology and Immunology\t\t",
"DMKKU1\tc\tDepartment of Microbiology, Faculty of Medicine\t\t",
"DMKKU2\tc\tDepartment of Microbiology, Faculty of Medical Science\t\t",
"DMKU\tc\tDepartment of Microbiology Kasetsart University\t\t",
"DMMU1\tc\tDepartment of Microbiology, Faculty of Science\t\t",
"DMMU3\tc\tDepartment of Microbiology, Faculty of Medicine Siriraj Hospital\t\t",
"DMMZ\tc\tDepartment of Medical Microbiology, University of Zurich\t\t",
"DMNH<USA-DE>\ts\tDelaware Museum of Natural History\t\t",
"DMNH<USA-OH>\ts\tDayton Museum of Natural History, Biology Department\t\t",
"DMNS\ts\tDenver Museum of Nature and Science\tDMNH<USA-CO>,DNHC",
"DMNS:Bird\ts\tDenver Museum of Nature and Science, Ornithology Collections",
"DMNS:Mamm\ts\tDenver Museum of Nature and Science, Mammology Collection",
"DMPMC\tc\tDepartment of Microbiology, University of Western Australia\t\t",
"DMSA\ts\tDurban Museum\t\t",
"DMSC\ts\tMedicinal Plants Research Institute, Department of Medical Sciences\t\t",
"DMSP\ts\tDavis Mountains State Park\t\t",
"DMSRDE\tc\tDMSRDE Culture Collection\t\t",
"DMST\tc\tCulture Collection for Medical Microorganism, Department of Medical Sciences\t\t",
"DMTH\ts\tBritannia Royal Naval College\t\t",
"DMU\ts\tMithila University, Botany Department\t\t",
"DMUIJ\tc\tDepartment of Microbiology, Jakarta Pusat\t\t",
"DMUP\tc\tMicrobiology and Biophysics Charles University\t\t",
"DMUR\tc\tDepartment of Mycology\t\t",
"DMVB\tc\tDepartment of Microbiology, Veterinary Branch of National Strain Collection\t\t",
"DNA\ts\tDepartment of Natural Resources, Environment and the Arts\t\t",
"DNAP\th\tDepartment of Primary Industry and Fisheries\t\t",
"DNATAX\tb\tDNA-TAX\t\t",
"DNHM<CHN>\ts\tDalian Museum of Natural History\t\t",
"DNHM<USA-UT>\ts\tDinosaur Natural History Museum\t\t",
"DNPM\ts\tSetor de Paleontologia do Departamento Nacional de Producao Mineral\t\t",
"DNS\ts\tDundee Naturalists' Society\t\t",
"DNZ\th\tDonetsk Botanical Garden of the National Academy of Sciences of Ukraine\t\t",
"DO\ts\tSociete d'Agriculture Sciences et Arts\t\t",
"DOA\tc\tDepartment Of Agriculture, Thailand\t\t",
"DOMO\ts\tCollegio Mellerio Rosmini\t\t",
"DOR\ts\tDorset County Museum\t\t",
"DORC\ts\tDorset County Museum\t\t",
"DORCM\ts\tDorset Royal County Museum\t\t",
"DORT\ts\tBotanischer Garten Rombergpark, Stadt Dortmund\t\t",
"DOV\ts\tDelaware State University, Department of Agriculture and Natural Resources\t\t",
"DPBA\ts\tDepartamento de Patologia Vegetal\t\t",
"DPC\tc\tDairy Products Research Center Culture Collection Teagasc\t\t",
"DPIC\ts\tBelo Horizonte, Instituto de Ciencias Biologicas\t\t",
"DPIH\ts\tDepartment of Primary Industry (formerly DAHT)\t\t",
"DPIQM\ts\tDepartment of Primary Industries\t\t",
"DPMWA\ts\tDorthy Page Museum of Wasilla\t\t",
"DPNC\ts\tDenison Pequotsepos Nature Center\t\t",
"DPPC\ts\tDepartment of Agriculture, Taiwan\t\t",
"DPU\ts\tDePauw University, Botany and Bacteriology Department\t\t",
"DPUA\tc\tDepartamento de Patologia/ICB\t\t",
"DPUP\ts\tUniversidade Federal de Maringa\t\t",
"DQTC\ts\tDaqing Teachers College, Biology Department\t\t",
"DR\ts\tTechnische Universitaet Dresden\t\t",
"DS\ts\tCalifornia Academy of Sciences, Botany Department\t\t",
"DSC<USA-MS>\ts\tDelta State University, Biological Sciences Department\t\t",
"DSC<USA-NY>\tc\tDicty Stock Center\t\t",
"DSEC\ts\tUniversidade Federal da Paraiba\t\t",
"DSIR\ts\tDepartment of Scientific and Industrial Research\t\t",
"DSM\tc\tDeutsche Sammlung von Mikroorganismen und Zellkulturen GmbH\tDSMZ",
"DSM<TZA>\ts\tUniversity of Dar es Salaam, Botany Department\t\t",
"DSMZ\tc\tDeutsche Sammlung von Mikroorganismen und Zellkulture\t\t",
"DSP\ts\tFitzsimon's Snake Park\t\t",
"DSSC<USA-CA>\tb\tDrosophila Species Stock Center\t\t",
"DSU\ts\tDnipropetrovsk National University, Department of Geobotany, Soil, and Ecology\t\t",
"DSY\ts\tDewsbury Museum\t\t",
"DTE\th\tCentro de Investigaciones Cientificas y Transferencia de Tecnologia a la Produccion (CICyTTP-CONICET)\t\t",
"DTIC\ts\tDepartamento Parasitologia\t\t",
"DTN\ts\tDarlington and Teesdale Naturalists' Field Club\t\t",
"DU\ts\tDuke University Vertebrate Collection\t\t",
"DUB\ts\tNational Botanic Gardens\t\t",
"DUBN\ts\tDublin Naturalists' Field Club\t\t",
"DUE\ts\tUniversity of Dundee\t\t",
"DUF\ts\tUniversity of Dicle, Biological Department, Botany\t\t",
"DUGAND\th\tUniversidad del Atlantico\t\t",
"DUH\ts\tUniversity of Delhi, Botany Department\t\t",
"DUIS\ts\tUniversitaet Duisburg, Fachbereich 6, Botanik\t\t",
"DUKE\ts\tDuke University, Biology Department\t\t",
"DUL\ts\tUniversity of Minnesota, Biology Department\t\t",
"DUM<IND>\tc\tDelhi University Mycological Herbarium\t\t",
"DUM<TUR>\ts\tZooligical Museum of Science and Art Faculty\t\t",
"DUOF\th\tDuzce University\t\t",
"DUP\th\tDumlupinar University\t\t",
"DUR\ts\tSoutheastern Oklahoma State University, Biological Sciences Department\t\t",
"DUSS\ts\tUniversitaet Duesseldorf\t\t",
"DVBID\tc\tDivision Vector-Borne Infectious Diseases\t\t",
"DVCC\ts\tDiablo Valley College\t\t",
"DVCM\ts\tDiablo Valley College Museum\t\t",
"DVM\ts\tDiablo Valley College, Biology Department\t\t",
"DVNM\ts\tDeath Valley National Monument\t\t",
"DVR\ts\tDover Corporation Museum\t\t",
"DVZUT\ts\tDepartment of Vertebrate Zoology\t\t",
"DWC\ts\tWest Chester University, Biology Department\t\t",
"DWN\ts\tDarwen Library\t\t",
"DWP\th\tDisney Wilderness Preserve/The Nature Conservancy\t\t",
"DWT\tc\tWood Technology and Forest Research Division\t\t",
"DWU\ts\tDakota Wesleyan University, Biology Department\t\t",
"DZCU\ts\tCalcutta University\t\t",
"DZIB\ts\tUniversidade Estadual de Campinas\t\t",
"DZKU\ts\tDepartment of Biology, Shaanxi Normal University\t\t",
"DZMU\ts\tDepartment of Zoology, Monash University\t\t",
"DZS\ts\tDevizes Museum\t\t",
"DZSASP\ts\tDepartamento de Zoologia, Secretaria da Agricultura\t\t",
"DZUC\ts\tDepartamento de Zoologia da Universidade de Coimbra\t\t",
"DZUFRGS\ts\tDepartamento de Zoologia da Universidade Federal do Rio Grande do Sul\t\t",
"DZUH\ts\tDepartamento de Zoologia, Universidad de Havana\t\t",
"DZUL\ts\tDepartamento de Zoologia, Universidad de La Laguna\t\t",
"DZUP\ts\tUniversidade Federal do Parana, Museu de Entomologia Pe. Jesus Santiago Moure\t\t",
"DZVMLP\ts\tDepartamento Cientifico de Zoologia de Vertebrados\t\t",
"DZVU\ts\tUniversidad de Uruguay\t\t",
"E\tsb\tRoyal Botanic Garden Edinburgh\t\t",
"EA\ts\tNational Museums of Kenya\t\t",
"EAA\ts\tEstonian Agricultural University\t\t",
"EAC\ts\tUniversidade Federal do Ceara, Departamento de Biologia\t\t",
"EAFM\th\tInstituto Federal de Educacao, Ciencia e Tecnologia do Amazonas\t\t",
"EALA\th\tJardin Botanique d'Eala\t\t",
"EAN\ts\tUniversidade Federal da Paraiba, Campus III - CCA, Departamento de Fitotecnia\t\t",
"EAP\ts\tEscuela Agricola Panamericana\t\t",
"EAPZ\ts\tEscuela Agricola Panamericana\t\t",
"EAR\ts\tEarlham College, Biology Department\t\t",
"EATRO\tc\tUganda Trypanosomiasis Research Organization\t\t",
"EBA\ts\tEdinburgh Academy Field Centre\t\t",
"EBCC\ts\tUniversidad Nacional Autonoma de Mexico, Estacion de Biologia \"Chamela\"\t\t",
"EBD\ts\tEstacion Biologica de Donana\t\t",
"EBDS\ts\tEstacion Biologica de Donana\t\t",
"EBE\ts\tEastbourne Museum\t\t",
"EBF\ts\tHubei Forestry Institute\t\t",
"EBH\ts\tBotanical Society of Edinburgh\t\t",
"EBL\th\tEcosystem Research and Development Bureau\t\t",
"EBMC\ts\tUniversidad de Chile\t\t",
"EBMTV\ts\tEstacion de Biologia Marina del Instituto Tecnologico de Veracruz\t\t",
"EBNHS\ts\tEdinburgh Natural History Society\t\t",
"EBRG\ts\tMuseo de la Estacion Biologia de Rancho Grande\t\t",
"EBUAP\ts\tLaboratorio de Herpetologia, Escuela de Biologia, Benemerita Universidad Autonoma de Puebla\t\t",
"EBUM\ts\tUniversidad Michoacana de San Nicolas de Hidalgo\t\t",
"EBV\ts\tLaboratoire de Biologie Generale et de Botanique\t\t",
"ECACC\tc\tEuropean Collection of Authenticated Cell Cultures\t\t",
"ECENT\ts\tEast Central University\t\t",
"ECH\ts\tElmira College\t\t",
"ECK\th\tBuffalo State College\t\t",
"ECM\ts\tHubei College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t",
"ECNB\ts\tEscuela Nacional Ciencias\t\t",
"ECO-SC-M\ts\tColeccion Mastozoologica de El Colegio de la Frontera Sur Unidad San Cristobal de las Casas, Chiapas\t\t",
"ECOCHM\ts\tColeccion de Mamiferos del Museo de Zoologia-ECOSUR\t\t",
"ECOL\ts\tCollection du Laborataire d'Ecologie\t\t",
"ECOMAR<FRA>\ts\tECOMAR lab University of Reunion\t\t",
"ECON\ts\tHarvard University\t\t",
"ECOSCM\ts\tColeccion Mastozoologica de El Colegio de la Frontera Sur, Unidad San  Cristobal\t\t",
"ECOSUR\ts\tEl Colegio de la Frontera Sur (Mexico)\t\t",
"ECSC\ts\tEast Central University, Biology Department\t\t",
"ECSFI\ts\tEast China Sea Fisheries Institute\t\t",
"ECU\th\tEdith Cowan University\t\t",
"ECUAMZ\th\tUniversidad Estatal Amazonica\t\t",
"ECUH\th\tEast Carolina University\t\t",
"ECWP\th\tEmirates Centre for Wildlife Propagation\t\t",
"EDC\ts\tHubei Institute for Drug Control\t\t",
"EDH\ts\tPlinian Society\t\t",
"EDNC\ts\tRaleigh, North Carolina Department of Agriculture\t\t",
"EDTU\th\tTrakya Universitesi\t\t",
"EEBP\ts\tEstacao Experimental de Biologia e Piscicultura de Pirassununga\t\t",
"EELM\ts\tEstacion Experimental Agricola de la Molina\t\t",
"EERU\ts\tEconomic Entomology  Research Unit\t\t",
"EFC\ts\tEscola de Florestas\t\t",
"EFCC\ts\tEpping Forest Conservation Centre\t\t",
"EFH\ts\tForestry Commission\t\t",
"EFM\ts\tEpping Forest Museum, Corporation of London\t\t",
"EFWM\ts\tDepartment of Entomology\t\t",
"EGE\ts\tEge University\t\t",
"EGE-MACC\tc\tEge - Microalgae Culture Collection\t\t",
"EGH\ts\tUniversity of Edinburgh\t\t",
"EGHB\ts\tUniversity of Edinburgh\t\t",
"EGHF\ts\tUniversity of Edinburgh, Forestry and Natural Resources Department\t\t",
"EGNP\ts\tHomestead, Everglades National Park\t\t",
"EGR\ts\tEszterhazy Karoly College, Botany Department\t\t",
"EHCV\ts\tEmory and Henry College, Biology Department\t\t",
"EHH\ts\tUniversite d'Etat d'Haiti\t\t",
"EI\ts\tUniversidade Federal Rural do Rio de Janeiro\t\t",
"EIF\ts\tUniversidad de Chile, Departamento de Silvicultura\t\t",
"EIHU\ts\tEntomological Institute, Hokkaido University\t\t",
"EINS\ts\tEcuadorian Institute of Natural Sciences\t\t",
"EISC\ts\tShaanxi Agricultural University, Entomological Institute\t\t",
"EIU\ts\tEastern Illinois University, Biological Sciences Department\t\t",
"EJ\ts\t?Ein Yabrud collection catalogue entries at The Hebrew University\t\t",
"EKU\ts\tEastern Kentucky University\t\t",
"EKY\ts\tEastern Kentucky University, Biological Sciences Department\t\t",
"ELCAK\ts\tEntomological Laboratory, College of Agriculture\t\t",
"ELH\th\tBureau of Land Management, Eagle Lake Field Office\t\t",
"ELM\ts\tEast London Museum\t\t",
"ELMF\ts\tAugusta, Maine Forest Service\t\t",
"ELN\ts\tElgin Museum\t\t",
"ELRG\ts\tCentral Washington University, Biological Sciences Department\t\t",
"ELS\ts\tAldenham School, Biology Department\t\t",
"ELVE\ts\tNational Station for Plant Breeding\t\t",
"EM\ts\tUniversidade Federal de Ouro Preto\t\t",
"EMA\ts\tSichuan School of Chinese Materia Medica\t\t",
"EMAG\ts\tErnst-Moritz Arndt Collection, Museum der Stadt Greifswald\t\t",
"EMAU\ts\tErnst-Moritz-Arndt-Universitat Greifswald\t\t",
"EMBT\ts\tDepartment of Agriculture, Thailand\t\t",
"EMC\ts\tEastern Michigan University, Biology Department\t\t",
"EMCC\tc\tEgypt Microbial Culture Collection\t\t",
"EMEC\ts\tEssig Museum of Entomology\tEMUC",
"EMET\ts\tFaculty of Agriculture, Entomology Museum\t\t",
"EMMA\ts\tUniversidad Politecnica de Madrid, Unidad Docente Botanica, Departamento Silvopascicultura\t\t",
"EMNH\th\tThe Everhart Museum of Natural History, Science & Art\t\t",
"EMPARN\tc\tEmpresa de Pesquisa Agropecuaria do Rio Grande do Norte\t\t",
"EMU\ts\tEastern Michigan University, T. L. Hankinson Vertebrate Museum\t\t",
"EMUS\ts\tUtah State University\t\t",
"ENAG\ts\tUniversidad Nacional Agraria, Departamento de Ciencias Basicas\t\t",
"ENCB-IPN\tc\tColeccion de cultivos de la Escuela Nacional de Ciencias Biologicas\t\t",
"ENCB<MEX-Ensenada>\ts\tUniversidad de Autonoma de Baja California\t\t",
"ENCB<MEX-Mexico City>\ts\tInstituto Politecnico Nacional\t\t",
"ENG\ts\tRoyal Holloway College, University of London, Botany Department\t\t",
"ENIH\ts\tNational Institute of Health\t\t",
"ENLC\th\tEastern Nevada Landscape Coalition\t\t",
"ENMU\ts\tEastern New Mexico University, Natural History Museum\t\t",
"ENMUNHM\ts\tEastern New Mexico University, Natural History Museum\t\t",
"ENP\ts\tEverglades National Park\t\t",
"ENS\ts\tHubei College for Nationalities, Forestry Department\t\t",
"ENSJ\ts\tEscuela Normal Superior de Jalisco\t\t",
"ENT\ts\tHerbarium, Ministry of Natural Resources, Uganda\t\t",
"ENTOMOFOR\ts\tCollection of necrophagous Fauna of the Forensic Entomology Laboratory (Basque Country University)\t\t",
"EONJ\ts\tUpsala College, Biology Department\t\t",
"EOSC\ts\tEastern Oregon University, Biology Department\t\t",
"EOSCVM\ts\tEastern Oregon State College, Vertebrate Museum\t\t",
"EOSTS\ts\tOfficial Seed Testing Station, Agricultural Scientific Services, Department of Agriculture and Fisheries for Scotland\t\t",
"EPAL\ts\tEntomology Collection, Punjab Agricultural University\t\t",
"EPHR\ts\tSnow College, Biology Department\t\t",
"EPM\ts\tEpsom College Museum\t\t",
"EPN\ts\tEscuela Polytecnica Nacional\tEPNC",
"EPRL\ts\tUniversity of Puerto Rico\t\t",
"EPU\th\tCentre de Formation et de Recherche en Conservation Forestiere\t\t",
"ER\ts\tUniversitaet Erlangen-Nuernberg, Geobotanik\t\t",
"ERA\ts\tUniversidad Nacional de Entre Rios, Botanica Sistematica\t\t",
"ERAEP\tc\tRadiation Ecology Section, Biological Science Division, Office of Atomic Energy for Peace\t\t",
"ERCB\ts\tYerevan State University, Botany Department\t\t",
"ERCH\th\tErciyes University\t\t",
"ERCULE\tc\tEuropean Rumen Ciliate Culture Collection, Rowett Research Institute\t\t",
"ERE\ts\tInstitute of Botany of the National Academy of Sciences of Armenia, Department of Plant Taxonomy and Geography\t\t",
"EREM\ts\tInstitute of Botany of the National Academy of Sciences of Armenia, Mycology Department\t\t",
"ERH\ts\tBorough of Erith Museum\t\t",
"ERHM\ts\tYerevan State University, Botany Department\t\t",
"ERSAF<ITA>\ts\tRegional Agency for Agriculture and Forestry Services\t\t",
"ERZ\ts\tFuerstin-Eugenie-Institut fuer Arzneipflanzenforschung\t\t",
"ESA\ts\tUniversidade de Sao Paulo, Departamento de Botanica\t\t",
"ESAL\ts\tUniversidade Federal de Lavras, Departamento de Biologia\t\t",
"ESAP\tc\tInstituto Zimotecnico-Z\t\t",
"ESEC\ts\tEntomological Society of Egypt\t\t",
"ESK\ts\tSeker Enstituesue\t\t",
"ESN\ts\tEcole des Sciences de Niamey\t\t",
"ESNHS\ts\tScottish Natural History Society\t\t",
"ESRC\ts\tNova Scotia Department Natural Resources\t\t",
"ESRN\ts\tEscola Superior de Agricultura\t\t",
"ESS\ts\tUniversitaet Essen\t\t",
"ESSE\ts\tAnadolu University\t\t",
"ESUG\ts\tUniversity of Guam\t\t",
"ESUW\ts\tUniversity of Wyoming Insect Museum and Gallery\t\t",
"ET\ts\tEast Texas State University\t\t",
"ETE\ts\tEl Colegio de la Frontera Sur, Coleccion de insectos Asociados a Plantas Cultivadas en la Frontera Sur\t\t",
"ETH<CHE>\tc\tKultursammlungen der Eidgenosische Technische Hochschule\t\t",
"ETH<ETH>\ts\tAddis Ababa University, Biology Department\t\t",
"ETHZ\ts\tEidgenoessische Technische Hochschule-Zentrum\t\t",
"ETL\th\tLake Forest College\t\t",
"ETN\ts\tEton College Museum\t\t",
"ETNH\th\tJarvis Christian College\t\t",
"ETON\th\tEton College Museum\t\t",
"ETST\ts\tTexas A&M University, Biology Department\t\t",
"ETSU\ts\tEast Tennessee State University, Biological Sciences Department\t\t",
"EU\ts\tHubei University, Biology Department\t\t",
"EUB\ts\tLaboratory of Biology, Faculty of Science, Ehime University\t\t",
"EUMJ\ts\tEhime University\t\t",
"EUQ\ts\tDepartment of Entomology, Queensland University\t\t",
"EUSL\tc\tEastern University\t\t",
"EVA\tc\tEuropean Virus Archive\t\t",
"EVCV\ts\tErster Vorarlberger Coleopterische Verein\t\t",
"EVE\th\tThe Evergreen State College\t\t",
"EVMU\ts\tEverhart Museum, Natural History Department\t\t",
"EWH\ts\tEwha Womans University\t\t",
"EWM\th\tElizabeth Winston Mize Herbarium\t\t",
"EWNHM\ts\tEwha Womens University, Natural History Museum\t\t",
"EX\tc\tThe Culture Collection of Extremophilic Fungi\t\t",
"EXN\ts\tExton Hall\t\t",
"EXR\ts\tUniversity of Exeter, Biological Sciences Department\t\t",
"F\ts\tField Museum of Natural History, Botany Department\tFMNH:F",
"FAA\th\tUniversidad Nacional del Centro de la Provincia de Buenos Aires\t\t",
"FABR\ts\tHarmas de J. H. Fabre\t\t",
"FACHB\tc\tFreshwater Algae Culture Collection\t\t",
"FACS\ts\tFujian Agricultural College\t\t",
"FAK\ts\tDepartment of Fisheries, Faculty of Agriculture\t\t",
"FAKOU\ts\tFaculty of Agriculture, Kochi Univerisity\t\t",
"FAKU\ts\tKyoto University\t\t",
"FAN\ts\tMuseum of Fanjingshan National Nature Reserve\t\t",
"FAR\ts\tUniversity of Tarbiat-Moaallem, Biology Department\t\t",
"FARM\ts\tLongwood University, Department of Natural Sciences\t\t",
"FAU\ts\tFlorida Atlantic University, Biological Sciences Department\t\t",
"FAUC\ts\tUniversidad de Caldas, Departamento de Recursos Naturales\t\t",
"FAUN\ts\tUniversidad de Narino\t\t",
"FAVU\ts\tUniversidade Federal do Rio Grande do Sul, Faculdade Agronomia e Veterenaria\t\t",
"FB\ts\tAlbert-Ludwigs Universitaet, Institut fuer Biologie II\t\t",
"FBA\ts\tFreshwater Biological Association\t\t",
"FBC\ts\tUniversity of Sierra Leone, Fourah Bay College, Botany Department\t\t",
"FBCS\ts\tUniversidad Autonoma de Baja California Sur, Museo de Historia Natural\t\t",
"FBGMU\tc\tFaculty of Biology Gadjah Mada University\t\t",
"FBMN\ts\tMuseum fuer Naturkunde\t\t",
"FBQ\ts\tFisheries Branch, Departement of Primary Industries\t\t",
"FBUB\ts\tUniversitat Bielefeld\t\t",
"FBWA\ts\tForstlichen Bundsversuchsanstalt\t\t",
"FC-DPV\ts\tDepartmento de Paleontologia, Facultad de Ciencias\t\t",
"FCAB\ts\tPontificia Universidade Catolica do Rio de Janeiro, Nucleo Interdisciplinar de Meio Ambiente\t\t",
"FCAP\ts\tUniversidade Federal do Para\t\t",
"FCBP\tc\tFirst Fungal Culture Bank of Pakistan\t\t",
"FCDA\ts\tFresno County Department of Agriculture\t\t",
"FCL<POL>\tc\tFungal Culture Collection of Lublin\t\t",
"FCLR\ts\tFundacion Cientifica Los Roques\t\t",
"FCM\ts\tFacultad de Ciencias Marinas\t\t",
"FCME\ts\tUniversidad Nacional Autonoma de Mexico, Ciudad Universitaria, Departamento de Biologia\t\t",
"FCMM\ts\tUniversidad Nacional Autonoma de Mexico, Facultad de Ciencias\t\t",
"FCNI\ts\tForest Commission of N.S.W.\t\t",
"FCO\ts\tUniversidad de Oviedo, Departamento de Biologia de Organismos y Sistemas\t\t",
"FCQ\ts\tUniversidad Nacional de Asuncion, Departamento de Botanica, Direccion de Investigacion\t\t",
"FCRM\ts\tFisheries College Reference Museum\t\t",
"FCT\tc\tFCT (Forestry Commission Tasmania)\t\t",
"FCTH\ts\tForestry Commission of Tasmania\t\t",
"FCU\ts\tFukien Christian University\t\t",
"FCUG\tc\tFungal Cultures University of Goteborg\t\t",
"FDA\tc\tUS Food and Drug Administration\t\t",
"FDC\tc\tForsyth Dental Center\t\t",
"FDG\ts\tGuyana Forestry Commission\t\t",
"FDLW\ts\tUniversity of Wisconsin Center, Biology Department\t\t",
"FDNR\ts\tFlorida Department of Natural Resources\t\t",
"FDUC\ts\tFairleigh Dickinson University [collection transferred to FSCA].\t\t",
"FDVC\ts\tDe La Villa, Francisco\t\t",
"FEN\th\tLycee Felix Esclangon, Region PACA\t\t",
"FER\ts\tUniversita de Ferrara, Dipartimento di Biologia - Sezione di Botanica\t\t",
"FERM\tc\tPatent and Bio-Resource Center, National Institute of Advanced Industrial Science and Technology (AIST)\t\t",
"FEZA\ts\tUniversidad Nacional Autonoma de Mexico, Carrera de Biologia\t\t",
"FFB\ts\tAtlantic Forestry Centre, Canadian Forest Service\t\t",
"FFBNM\th\tFlorissant Fossil Beds National Monument\t\t",
"FFCL\ts\tNossa Senhora do Patrocinia\t\t",
"FFR\ts\tForfar Museum and Art Gallery, Meffan Institute\t\t",
"FFS\ts\tUniversity of Stellenbosch\t\t",
"FFSUC\ts\tFaculty of Forestry Sciences\t\t",
"FG\ts\tPalaontologische Hauptsammlung der Bergakadmie\t\t",
"FGC\ts\tGrassland Research Institute, Chinese Academy of Agricultural Sciences\t\t",
"FGG\ts\tFaculty of Geology and Geophysis\t\t",
"FGGUB\ts\tFacultatea de Geologie si Geofisca\t\t",
"FGIC\ts\tFrancois Genier\t\t",
"FGSC\tc\tFungal Genetics Stock Center\t\t",
"FH\ts\tThe Farlow Herbarium, Harvard University Herbaria\t\t",
"FH<USA-KS>\ts\tFort Hays\t\t",
"FHI\ts\tForestry Research Institute of Nigeria\t\t",
"FHK\ts\tDivisional Forest Office\t\t",
"FHKS\ts\tFort Hays State University\t\t",
"FHKSC\ts\tFort Hays State University\t\t",
"FHL\ts\tFriday Harbor Laboratories, University of Washington\t\t",
"FHO\ts\tUniversity of Oxford, Department of Plant Sciences\t\t",
"FHSM\ts\tFort Hays Sternberg Museum\t\t",
"FI\ts\tMuseo di Storia Naturale dell'Universita\t\t",
"FIAF\ts\tUniversita degli Studi di Firenze, Dipartimento di Biologia Vegetale\t\t",
"FICB\ts\tForest Research Centre\t\t",
"FIDS\ts\tGreat Lakes Forest Research Laboratory, Forest Insect and Disease Survey\t\t",
"FIEC\ts\tFreshwater Institute\t\t",
"FIJI\ts\tUniversity of the South Pacific\t\t",
"FIOC\ts\tFundacao Instituto Oswaldo Cruz\t\t",
"FIOC:ColTryp\tc\tFundacao Instituto Oswaldo Cruz, Collection of Trypanosoma from Wild and Domestic Mammals and Vectors",
"FIP\ts\tFlorida Institute of Paleontology\t\t",
"FIPF\ts\tUniversita di Firenze\t\t",
"FIPIA\ts\tInstitut Teknologi Bandung, Jurusan Biologi\t\t",
"FJFC\ts\tFujian Forestry College\t\t",
"FJSI\ts\tFujian Institute of Subtropical Botany\t\t",
"FKE\ts\tFolk Museum\t\t",
"FKEN\ts\tFolkestone Natural History Society\t\t",
"FLACC\tc\tFree-Living Amoebae Culture Collection\t\t",
"FLAS\ts\tFlorida Museum of Natural History Herbarium\t\t",
"FLC\ts\tFort Lewis College\t\t",
"FLD\ts\tFort Lewis College, Biology Department\t\t",
"FLIN\ts\tFlinders University\t\t",
"FLK\ts\tFalkirk District Council Museum\t\t",
"FLOR\ts\tUniversidade Federal de Santa Catarina, Departamento de Botanica\t\t",
"FLSP\ts\tOscar Scherer State Park\t\t",
"FM<CHN-Beijing>\ts\tFan Memorial Institute of Biology\t\t",
"FM<CHN-Fujian>\ts\tDepartment of Nature, Fujian Province Museum\t\t",
"FMB\ts\tInstituto Alexander von Humboldt\t\t",
"FMC\ts\tNorth Museum of Natural History and Science\t\t",
"FMH\ts\tGoddard College\t\t",
"FMJ\tc\tFaculty of Medicine, Juntendo University\t\t",
"FML\ts\tFundacion Miguel Lillo\t\t",
"FMM\ts\tMuzeum Beskyd\t\t",
"FMNH\ts\tField Museum of Natural History\tCMNH<USA-IL>",
"FMNH:ARTH\ts\tField Museum of Natural History, Arthropod Collection",
"FMNH:AVES\ts\tField Museum of Natural History, Ornithology Collection",
"FMNH:HERP\ts\tField Museum of Natural History, Herpetology Collection",
"FMNH:ICHTHY\ts\tField Museum of Natural History, Ichthyology Collection",
"FMNH:INVRT\ts\tField Museum of Natural History, Invertebrate Collection",
"FMNH:MAMM\ts\tField Museum of Natural History, Mammal Collection",
"FMNH<FIN>\ts\tFinnish Museum of Natural History\t\t",
"FMP\ts\tFujian Academy of Traditional Chinese Medicine and Pharmacology\t\t",
"FMPC\ts\tFairbanks Museum and Planetarium Collection\t\t",
"FMR\tc\tFacultad de Medicina\t\t",
"FMRI\ts\tCentral Marine Fisheries Marine Research Institute\t\t",
"FMSS\ts\tParque Zoological Nacional \"Finca Modelo\", Natural History Museum\t\t",
"FMUH\th\tFrancis Marion University\t\t",
"FNCC\tc\tFood and Nutrition Culture Collection\t\t",
"FNFR\ts\tFishlake National Forest\t\t",
"FNLO\ts\tFremont National Forest\t\t",
"FNM\ts\tFries Natuurmuseum\t\t",
"FNML\ts\tFries Natuurhistorisch Museum\t\t",
"FNP\ts\tFundy National Park\t\t",
"FNPS\ts\tSouth Florida Collections Management Center, Everglades National Park\t\t",
"FNU<CHN>\ts\tFujian Normal University\t\t",
"FNU<JPN>\ts\tNagasaki University - Fisheries\t\t",
"FOF\th\tNational University of Laos\t\t",
"FOR\ts\tForssa Museum of Natural History\t\t",
"FOSJ\ts\tFisheries and Oceans Biological Station\t\t",
"FPDB\ts\tUniversidad de Puerto Rico, Departamento de Ciencias Marinas\t\t",
"FPF\ts\tRocky Mountain Research Station, USDA Forest Service\t\t",
"FPM\ts\tFukui Prefectural Museum\t\t",
"FPRL\ts\tBuilding Research Establishment\t\t",
"FQH\ts\tFort Qu'Appelle Herbarium\t\t",
"FR\tsb\tForschungsinstitut Senckenberg\t\t",
"FRC\ts\tInstitute of Forest Genetics and Tree Breeding\t\t",
"FRC<USA-PA>\tc\tFusarium Research Center\t\t",
"FRCL\ts\tFisheries Research Centre\t\t",
"FRCS\ts\tForest Research Centre\t\t",
"FRDC\tb\tFruit Tree Research & Development Center of ThuaThien-Hue-Vietnam\t\t",
"FRI<AUST>\ts\tAustralian National Herbarium, Division of Forestry and Forest Products, CSIRO\t\t",
"FRI<JPN>\tc\tFood Research Institute, Ministry of Agriculture, Forestry and Fisheries\t\t",
"FRI<SVK>\tc\tFood Research Institute, Bratislava, Slovakia\t\t",
"FRIHP\ts\tFisheries Research Institute of Hunan Province\t\t",
"FRIM\ts\tForest Research Institute, Malaysia\t\t",
"FRLC\ts\tForest Insect and Disease Survey Reference Collection\t\t",
"FRLH\ts\tFoundation for Revitalisation of Local Health Traditions, Research Department\t\t",
"FRLM\ts\tFaculty of Fisheries, Mie University\t\t",
"FRM\ts\tFriends University, Fellow-Reeve Museum of History and Science\t\t",
"FRNZ\ts\tForest Research Institute, New Zealand\t\t",
"FRP\ts\tPalmengarten\t\t",
"FRR\tc\tFood Science Australia, Ryde\t\t",
"FRS\ts\tFalconer Museum\t\t",
"FRSKU\ts\tKyoto University, Fisheries Research Station\t\t",
"FRU\ts\tNational Academy of Science, Kyrgyzstan, Laboratory of Flora\t\t",
"FSAG\ts\tFaculte des Sciences Agronomiques de Gembloux\t\t",
"FSC<CAN>\tc\tFredericton Stock Culture Collection\t\t",
"FSC<USA-CA>\ts\tCalifornia State University, Biology Department\t\t",
"FSCA\ts\tFlorida State Collection of Arthropods, Florida Department of  Agriculture and Consumer Services, Division of Plant Industry\t\t",
"FSCL\ts\tFlorida Southern College, Biology Department\t\t",
"FSFRL\ts\tFar Seas Fisheries Research Laboratory\t\t",
"FSIU\ts\tLaboratory of Fisheries, Department of Oceanography\t\t",
"FSL\ts\tCollections de la Faculte des Sciences de Lyon\t\t",
"FSLF\ts\tRocky Mountain Forest and Range Experiment Station\t\t",
"FSMC\ts\tFlorida State Museum\tFSM",
"FSP-USP\ts\tFaculdade de Saude Publica, Universidade de Sao Paulo\t\t",
"FSSR\ts\tForest Service, USDA, Biological and Physical Resources Unit\t\t",
"FSU\ts\tFlorida State University, Department of Biological Science\t\t",
"FSUM\ts\tFlorida State University Museum\tFSU",
"FSUMC\ts\tFrostburg State University, Mammal Collection\t\t",
"FSUNS\tc\tFaculty of Science, The University of Novi Sad\t\t",
"FT\ts\tCentro Studi Erbario Tropicale, Universita degli Studi di Firenze\t\t",
"FTCC\tc\tFood Technology Culture Collection\t\t",
"FTCMU\tc\tDepartment of Food Science and Technology, Faculty of Agriculture\t\t",
"FTG\tsb\tFairchild Tropical Botanic Garden\t\t",
"FTI\tc\tCentro de Biotecnologia e Quimica-CEBIQ\t\t",
"FTOH\th\tForestry Training Institute, Olmotonyi\t\t",
"FTS\ts\tFuzhou Teachers College, Biology Department\t\t",
"FTU\ts\tUniversity of Central Florida, Biology Department\t\t",
"FU<CHN>\ts\tFudan University, Department of Biology\t\t",
"FU<JPN>\ts\tKyushu University, Department of Forest and Forest Products Sciences\t\t",
"FUB\ts\tFrei Universitat\t\t",
"FUE\ts\tFukuoka University of Education\t\t",
"FUEL\ts\tUniversidade Estadual de Londrina, Departamento de Biologia Animal e Vegetal\t\t",
"FUGR\ts\tFurman University, Biology Department\t\t",
"FUH\ts\tFirat Ueniversitesi\t\t",
"FUK\th\tFukui Botanical Garden\t\t",
"FULD\ts\tVerein fuer Naturkunde in Osthessen\t\t",
"FUMH\ts\tFerdowsi University\t\t",
"FUMT\ts\tUniversity of Tokyo\t\t",
"FUNED\ts\tFundacao Ezequiel Dias, Belo Horizonte\t\t",
"FURB\th\tUniversidade Regional de Blumenau\t\t",
"FUS\ts\tFudan University, Biology Department\t\t",
"FUSC\tc\tFlinders University Smut Collection\t\t",
"FVCC\ts\tFlathead Valley Community College, Biology Department\t\t",
"FW\ts\tTexas Christian University, Biology Department\t\t",
"FWM\ts\tFort Worth Museum of Science and History, Science Department\t\t",
"FWMSH\ts\tFort Worth Museum of Science & History\t\t",
"FWRI\ts\tFlorida Fish and Wildlife Research Institute\t\t",
"FWRI:Ichthyology\ts\tFlorida Fish and Wildlife Research Institute, Ichthyology Collection",
"FWRI:Invertebrate\ts\tFlorida Fish and Wildlife Research Institute, Invertebrate Collection",
"FWRI:SEAMAP\tc\tFlorida Fish and Wildlife Research Institute, SEAMAP Ichthyoplankton Collection",
"FWVA\ts\tFairmont State University, Biology Department\t\t",
"G\ts\tConservatoire et Jardin botaniques de la Ville de Geneve\t\t",
"GA\ts\tUniversity of Georgia, Plant Biology Department\t\t",
"GAB\ts\tNational Museum, Monuments, and Art Gallery\t\t",
"GABAS\ts\tCentre d'Etude et de Conservation des Resources Vegetales\t\t",
"GAC\ts\tGuangxi Agricultural University, Forestry Department\t\t",
"GACP\ts\tGuizhou Agricultural College, Department of Plant Protection\t\t",
"GADI\th\tGrootfontein Agricultural Development Institute\t\t",
"GAES\ts\tGeorgia Agricultural Experiment Station\t\t",
"GAFS\ts\tGanzhou Forestry School\t\t",
"GAI\ts\tFolk Museum\t\t",
"GALW\ts\tNational University of Ireland, Galway, Botany Department\t\t",
"GAM<USA-GA>\ts\tUniversity of Georgia\t\t",
"GAM<VEN>\tc\tGrupo Actinomicetales Merida Facultad de Medicina\t\t",
"GAP\th\tConservatoire Botanique National Alpin\t\t",
"GAS\ts\tGeorgia Southern University, Department of Biology\t\t",
"GAT\ts\tInstitute of Plant Genetics and Crop Plant Research\t\t",
"GAUA\ts\tGuangxi University\t\t",
"GAUBA\ts\tAustralian National University, Division of Botany and Zoology\t\t",
"GAUF\ts\tGansu Agricultural University\t\t",
"GAW\ts\tEastern Botanical Society of Glasgow\t\t",
"GAZI\ts\tGazi Ueniversitesi, Biyoloji Boeluemue\t\t",
"GB\ts\tGoeteborg University, Department of Plant and Environmental Sciences\t\t",
"GBFM\ts\tUniversidad de Panama\t\t",
"GBG<SWE>\tb\tGotheburg Botanical Garden\t\t",
"GBH\th\tHerbarium of Geo. B. Hinton\t\t",
"GBNM\ts\tGlacier Bay National Park and Preserve Museum\t\t",
"GBY\ts\tGrimsby Arts and Natural History\t\t",
"GC<GHN>\ts\tUniversity of Ghana, Botany Department\t\t",
"GC<USA-MD>\ts\tGoucher College\t\t",
"GCL\tc\tCentral Laboratories\t\t",
"GCM<GHN>\ts\tUniversity College of Ghana\t\t",
"GCM<PAK>\ts\tGovernment College, Department of Zoology\t\t",
"GCNP\ts\tGrand Canyon National Park\t\t",
"GCRL\ts\tGulf Coast Research Laboratory\t\t",
"GCTP\ts\tGlobal Colosseum\t\t",
"GCU\th\tGachon University\t\t",
"GDA\ts\tUniversidad de Granada\t\t",
"GDAC\ts\tUniversidad de Granada, Departamento de Biologia Vegetal, Botanica\t\t",
"GDB\th\tHerbarium de Gerard de Belair\t\t",
"GDGM\ts\tGuangdong Institute of Microbiology\t\t",
"GDMA\ts\tMedical University of Gdansk, Department of Biology and Pharmaceutical Botany\t\t",
"GDMCC\tc\tGuangdong Microbial Culture Collection Center\t\t",
"GDMM\ts\tGuangdong Institute of Chinese Materia Medica\t\t",
"GDMP\ts\tGuangdong Medical and Pharmaceutical College, Pharmacy Department\t\t",
"GDOR\ts\tMuseo Civico di Storia Naturale Giacomo Doria\t\t",
"GE\ts\tUniversita di Genova\t\t",
"GEIC\ts\tGuangdong Entomology Institute\t\t",
"GENT\ts\tGent University, Biology Department\t\t",
"GEO\ts\tEmory University, Biology Department\t\t",
"GES\ts\tGesneriad Research Foundation\t\t",
"GESU\ts\tState University of New York, Biology Department\t\t",
"GF\ts\tGuizhou Academy of Forestry\t\t",
"GFBI\ts\tGymnasium der Franziskaner in Bozen [= Bolzano]\t\t",
"GFC\ts\tUniversity of Great Falls, Biology Department\t\t",
"GFCC\tc\tGoa University Fungus Culture Collection and Research Unit\tGUFCC",
"GFJP\ts\tUniversidade do Estado de Minas Gerais\t\t",
"GFND\ts\tUniversity of North Dakota, Biology Department\t\t",
"GFRC\ts\tGolestan Fisheries Research Centre\t\t",
"GFS\ts\tGuizhou Forestry School\t\t",
"GFT\th\tGrumeti Fund Tanzania\t\t",
"GFW\ts\tErnst-Moritz-Arndt-Universitaet, Botanisches Institut und Botanischer Garten\t\t",
"GGB\ts\tGesneriad Gardens\t\t",
"GGM\ts\tGosudarstvennyi Geologicheskii Musei - State Geological Museum\t\t",
"GGO\ts\tUniversity of Strathclyde, Biology Department\t\t",
"GGW\ts\tBotanical Society of Glasgow\t\t",
"GH\ts\tHarvard University (The Gray Herbarium)\t\t",
"GHD\ts\tShipley Art Gallery and Saltwell Tower Museum\t\t",
"GHG\ts\tCouncil for Geosciences\t\t",
"GHPG\ts\tHarold Porter National Botanical Garden\t\t",
"GHRI\ts\tGuy Harvey Research Institute\t\t",
"GHS\ts\tGeorge Heriot's School, Biology Department\t\t",
"GI\ts\tJustus-Liebig-Universitat Giessen\t\t",
"GI-SPS\ts\tGeological Institute, Section of Palaeontology and Stratigraphy\t\t",
"GIFU<JPN>\ts\tHerbarium of Gifu Pharmaceutical University\t\t",
"GINCO\th\tAgriculture and Agri-Food Canada\t\t",
"GIUV\ts\tGeological Institute, University of Vienna\t\t",
"GJO\ts\tSteiermaerkisches Landesmuseum Joanneum, Botany Department\t\t",
"GKAR\ts\tKaroo National Botanical Garden\t\t",
"GL\ts\tUniversity of Glasgow, Botany Department\t\t",
"GLA\th\tGeorge Landis Arboretum\t\t",
"GLAC\ts\tGlacier National Park, Glacier Collection\t\t",
"GLAHM\ts\tUniversity of Glasgow, Hunterian Museum\t\t",
"GLAM\ts\tArt Gallery and Museum, Natural History Department\t\t",
"GLANH\ts\tHunterian Museum\t\t",
"GLEN\ts\tRappahannock Community College\t\t",
"GLFR\ts\tGreat Lakes Forest Research Centre\t\t",
"GLG\ts\tTrinity College\t\t",
"GLLB\ts\tLaurel Bank School\t\t",
"GLM\ts\tStaatliches Museum fuer Naturkunde Goerlitz\t\t",
"GLMC\ts\tGuilin Medical College, Pharmacy Department\t\t",
"GLNP\ts\tGlacier National Park\t\t",
"GLO\ts\tNatural History Society of Glasglow\t\t",
"GLOW\ts\tLowveld National Botanical Garden\t\t",
"GLR\ts\tGloucester City Museum and Art Gallery\t\t",
"GLW\ts\tAndersonian Naturalists' Society\t\t",
"GM\ts\tMuseum of Southeastern Moravia\t\t",
"GMACC\tc\tLaboratory of Molecular Genetics and Breeding of Edible Mushrooms\t\t",
"GMAU\ts\tGeological Museum of Amsterdam University\t\t",
"GMBL\ts\tCollege of Charleston\t\t",
"GMC\ts\tGuangxi Medical College\t\t",
"GMCE\ts\tGrosvenor Museum\t\t",
"GMDRC\th\tGranite Mountains Desert Research Center\t\t",
"GMH\ts\tSammlung Jacobi des Geiseltalmuseum Halle\t\t",
"GMHH\ts\tGeological Museum of Heilongjang Province\t\t",
"GML<USA-IL>\ts\tGorgas Memorial Laboratory\t\t",
"GML<USA-MO>\ts\tGaylord Memorial Laboratory Museum\t\t",
"GMNGZ\ts\tGlasgow Museum and Art Galleries\t\t",
"GMNH-PV\ts\tPaleo-Vertebrate Collection\t\t",
"GMNH<SWTZ>\ts\tMuseum d'Histoire Naturelle\t\t",
"GMNH<USA-GA>\ts\tGeorgia Museum of Natural History\t\t",
"GMNHJ\th\tGunma Museum of Natural History\t\t",
"GMNP\ts\tGros Morne National Park\t\t",
"GMS\ts\tHopkins Marine Station, Stanford University, Biological Sciences Department\t\t",
"GMU\ts\tN. P. Ogariov Mordovia State University, Department of Botany and Plant Physiology\t\t",
"GMUF\ts\tGeorge Mason University, Department of Environmental Science and Policy 5F2\t\t",
"GMUG\ts\tUniversitat Gottingen, Geologisches-Palaatologisches Museum\t\t",
"GMUM\ts\tInstitut fuer Palaeontologie und Geologisches Museum der Universitat\t\t",
"GMUV\ts\tGeological Museum, University of Vienna\t\t",
"GNA\ts\tGannan Arboretum of Jiangxi\t\t",
"GNDUH\th\tGuru Nanak Dev University\t\t",
"GNE\tc\tGenentech\t\t",
"GNHM\ts\tGoulandris Natural History Museum\t\t",
"GNHNA\ts\tGallery of Natural History and Native Art\t\t",
"GNHS\ts\tGuildford Natural History Society\t\t",
"GNM<SWE>\ts\tGothenburg Museum of Natural History (Goteborgs Naturhistoriska Museum)\t\t",
"GNU\ts\tGuangxi Normal University, Biology Department\t\t",
"GNUB\ts\tGuizhou Normal University, Biology Department\t\t",
"GNUC\ts\tGyeongsang National University, Biology Department\t\t",
"GNUG\ts\tGuizhou Normal University, Geography Department\t\t",
"GO\ts\tPhilosophical Society\t\t",
"GOD\ts\tCharterhouse School Museum\t\t",
"GOE<DEU>\ts\tInstitut und Museum fuer Geologie und Palaeontologie\t\t",
"GOE<GBR>\ts\tGoole Scientific Society\t\t",
"GOET\ts\tHerbarium Universitat Gottingen\t\t",
"GOFS\ts\tFree State National Botanical Garden\t\t",
"GOPU\th\tGaziosmanpasa University\t\t",
"GOW\ts\tClydebank High School\t\t",
"GP\ts\tInstituto de Geociencias, Universidade de Sao Paulo\t\t",
"GPA\ts\tGrande Prairie Regional College, Science Department\t\t",
"GPI\ts\tGeologisch-Palaeontologisches Institut\t\t",
"GPIH\ts\tGeologisch-Palaeontologiches Institut der Universitt Haemburg\t\t",
"GPIM\ts\tLehreinheit Palaeontologisches, Institut fuer Geowissenschaften\t\t",
"GPIT\ts\tInstitut und Museum fur Geologie und Palaontologie, Universitat Tubingen\t\t",
"GPM\ts\tGifu prefectural Museum\t\t",
"GPM:B\ts\tGifu prefectural Museum, Gifu prefectural Museum herbarium",
"GPM:Z\ts\tGifu prefectural Museum, Gifu prefectural Museum Zoological collection",
"GPMK\ts\tGeologisch-Palaontologisches Institut und Museum\t\t",
"GPPT\ts\tPlant Protection Institute\t\t",
"GR\ts\tUniversite J. Fourier - Grenoble I, Botanique\t\t",
"GRA\ts\tAlbany Museum\t\t",
"GRCAMC\ts\tGrand Canyon National Park Museum Collection\t\t",
"GRCH\ts\tColgate University, Biology Department\t\t",
"GREE\ts\tUniversity of Northern Colorado, Department of Biological Sciences\t\t",
"GRI\ts\tGrinnell College, Biology Department\t\t",
"GRIF\ts\tGriffith University\t\t",
"GRJC\ts\tGrand Rapids Junior College\t\t",
"GRK\ts\tMcLean Museum and Art Gallery\t\t",
"GRM\ts\tMuseum d'Histoire Naturelle de Grenoble\t\t",
"GRMP\ts\tCentral Geological Research Museum\t\t",
"GRO\ts\tState University of Groningen, Department of Plant Biology\t\t",
"GRPM\ts\tPublic Museum of Grand Rapids\t\t",
"GRS\ts\tGezira Research Station\t\t",
"GRSM\ts\tGreat Smoky Mountains National Park\t\t",
"GRSU\ts\tYanka Kupala Grodno State University, Department of Botany\t\t",
"GRSW\ts\tDesert Ecological Research Unit\t\t",
"GRTE\th\tGrand Teton National Park\t\t",
"GSAT\ts\tThe Geological Survey of Alabama\t\t",
"GSC\ts\tGeological Survey of Canada\t\t",
"GSDNM\ts\tGreat Sand Dunes National Monument\t\t",
"GSFS\ts\tGansu Forestry School\t\t",
"GSI\ts\tGeological Survey of India\t\t",
"GSM\ts\tGeologic Museum\t\t",
"GSMNP\ts\tGreat Smoky Mountains National Park\t\t",
"GSN\ts\tGeological Survey of Nambia\t\t",
"GSO\ts\tGlasgow Society of Field Naturalists'\t\t",
"GSP\ts\tGeological Survey of Portugal\t\t",
"GSU\ts\tF. Scorina Gomel State University, Department of Botany and Plant Physiology\t\t",
"GSW\ts\tGeorgia Southwestern State University, Biology Department\t\t",
"GTC\tc\tGifu Type Culture Collection\t\t",
"GTC-GIFU\tc\tGifu Type Culture Collection (GTC), Gifu University Culture Collection (GIFU)\t\t",
"GTM\ts\tGrantham Museum\t\t",
"GTNP\ts\tGrand Teton National Park\t\t",
"GTV\ts\tGregorio T. Velasquez Phycological Herbarium\t\t",
"GU\ts\tGotland University, Department of Biology\t\t",
"GU-IITG\ts\tfor Gauhati University- Indian Institute of Technology Guwahati\t\t",
"GUA\ts\tDIVEA, DEP, FEEMA, FEEMA\t\t",
"GUAD\ts\tInstitut National de la Recherche Agronomique and Parc National de Guadeloupe\t\t",
"GUADA\ts\tUniversidad Autonoma de Guadalajara\t\t",
"GUAM\ts\tUniversity of Guam, Biology Department\t\t",
"GUAT\ts\tHerbario Ulises Roja\t\t",
"GUAY\ts\tUniversidad de Guayaquil\t\t",
"GUBH\th\tGauhati University\t\t",
"GUBIOTJT\tc\tFreshwater microalgae collection and culture laboratory\t\t",
"GUCM\th\tGuangzhou University of Chinese Medicine\t\t",
"GUH\ts\tHNB Garhwal University, Botany Department\t\t",
"GUL\th\tSuleyman Demirel University\t\t",
"GUM\ts\tGlasgow University Museum (Hunter Museum)\t\t",
"GUM<IRN>\ts\tMycological herbarium of University of Guilan\t\t",
"GUMACC\tc\tGotheburg University Marine Algal Culture Collection\t\t",
"GUYN\ts\tFundacion Jardin Botanico del Orinoco\t\t",
"GVF\ts\tGeorge Vanderbilt Foundation\t\t",
"GVSC\ts\tGrand Valley State University, Biology Department\t\t",
"GW\ts\tWest of Scotland College of Agriculture, Botany Department\t\t",
"GXCM\ts\tGuangxi Traditional Chinese Medicine University, Pharmacy Department\t\t",
"GXDC\ts\tGuangxi Institute for Drug Control\t\t",
"GXEM\ts\tGuangxi Institute of Ethnomedicine\t\t",
"GXF\ts\tGuangxi Institute of Forest Survey and Design\t\t",
"GXFI\ts\tGuangxi Forestry Institute\t\t",
"GXFS\ts\tGuangxi Forestry School\t\t",
"GXMG\ts\tGuangxi Medicinal Botanic Garden\t\t",
"GXMI\ts\tGuangxi Institute of Traditional Medical and Pharmaceutical Sciences\t\t",
"GXNM\ts\tGuangxi Natural History Museum, Herbarium\t\t",
"GXSP\ts\tGuangxi School of Pharmacy\t\t",
"GZAC\ts\tGuizhou Agricultural College, College of Life Science\t\t",
"GZM\ts\tGiessener Zoologisches Museum\t\t",
"GZTM\ts\tGuizhou Institute of Traditional Chinese Medicine\t\t",
"GZU\ts\tKarl-Franzens-Universitaet Graz\t\t",
"H\ts\tUniversity of Helsinki\t\t",
"H-GSP\ts\tHoward University-Geological Survey of Pakistan Project\t\t",
"HA\ts\tUniversidad del Azuay, Escuela de Biologia del Medio Ambiente\t\t",
"HABA\ts\tAcademia de Ciencias Medicas, Fisicas y Naturales de La Habana\t\t",
"HABAYC\ts\tUniversity of Mary Hardin-Baylor, Biology Department\t\t",
"HABE\ts\tInstituto de Biologia, Departamento de Ecologia\t\t",
"HAC\ts\tInstituto de Ecologia y Sistematica\t\t",
"HACC\ts\tAcademia de Ciencias Camagueey\t\t",
"HACW\ts\tDepartment of Fishery, Huazhong Agriculture Collection\t\t",
"HAF\ts\tHainan Forestry Institute\t\t",
"HAH\th\tHoyt Arboretum\t\t",
"HAI\th\tUniversity of Haifa\t\t",
"HAJB\ts\tJardin Botanico Nacional\t\t",
"HAJU\th\tHerbario Dr. Armando Jesus Urquiola\t\t",
"HAK\ts\tHokkaido University, Faculty of Fisheries\t\t",
"HAKS\ts\tHakgala Botanic Gardens\t\t",
"HAL\ts\tMartin-Luther-Universitaet\t\t",
"HALA\ts\tUniversity of Alabama, Biological Sciences Department\t\t",
"HALE\th\tHaleakala National Park\t\t",
"HALLE\ts\tZoologisches Institut der Martin-Luther Universitaet\t\t",
"HALLST\ts\tBotanische Station\t\t",
"HALN\th\tState Agency for Environmental Protection Saxony-Anhalt\t\t",
"HALX\ts\tHalifax Literary and Philosophical Society\t\t",
"HAM\ts\tRoyal Botanical Gardens\t\t",
"HAMAB\ts\tInstituto de Pesquisas Cientificas e Tecnologicas do Estado do Amapa\t\t",
"HAMBI\tc\tHAMBI Culture Collection\t\t",
"HAMU\ts\tUniversity of Newcastle upon Tyne\t\t",
"HAN\ts\tUniversitaet Hannover\t\t",
"HANC\th\tNational Aquarium of Cuba\t\t",
"HANU\ts\tHarbin Normal University, Biology Department\t\t",
"HAO\ts\tUniversidad Privada Antenor Orrego\t\t",
"HAQ\ts\tInstitut der Technische Hochschule (RWTH), Institut fuer Biologie I\t\t",
"HAS\ts\tFundacao Zoobotanica do Rio Grande do Sul\t\t",
"HAST\ts\tResearch Center for Biodiversity, Academia Sinica\t\t",
"HASU\ts\tUniversidade do Vale do Rio dos Sinos - CCS/ Centro 2\t\t",
"HAU\th\tAlzahra University\t\t",
"HAUH\ts\tHaryana Agricultural University\t\t",
"HAVI\ts\tEastern Mennonite University, Biology Department\t\t",
"HAVO\ts\tHawaii Volcanoes National Park\t\t",
"HAW\ts\tUniversity of Hawaii, Botany Department\t\t",
"HAX\ts\tBelle Vue Museum\t\t",
"HAY\ts\tCalifornia State University, Biological Sciences Department\t\t",
"HB\ts\tHerbarium Bradeanum\t\t",
"HBA\th\tNational Botanic Garden of Latvia\t\t",
"HBARC\th\tBhabha Atomic Research Centre\t\t",
"HBAU\ts\tHebei Agricultural University\t\t",
"HBAUD\ts\tHebei Agricultural University, Handan Branch, Agriculture Department\t\t",
"HBBS\ts\tMuseo Civico di Scienze Naturali\t\t",
"HBC\ts\tHenry Brockhouse Collection\t\t",
"HBDC\ts\tHebei Institute for Drug Control\t\t",
"HBFC\ts\tHebei Forestry College, Basic Courses Department\t\t",
"HBFH\ts\tHarbor Branch Oceanographic Institution, Marine Botany Department\t\t",
"HBG\ts\tInstitut fuer Allgemeine Botanik\t\t",
"HBG<JPN>\tb\tHiroshima Botanical Garden\t\t",
"HBI\ts\tInstitute of Hydrobiology, Chinese Academy of Sciences, Phycology Department\t\t",
"HBIL\ts\tInstitut d'Estudis Ilerdencs\t\t",
"HBNU\ts\tHebei Normal University, Biology Department\t\t",
"HBOM\ts\tHarbor Branch Oceanographic Museum\tHBOI",
"HBR\ts\tUniversidade Federal de Santa Catarina\t\t",
"HBRA\th\tUniversidade Federal do Para, Campus Braganca\t\t",
"HBUM\ts\tCollege of Life Sciences Hebei Univesity, Baoding\t\t",
"HC\ts\tHangchow Christian College\t\t",
"HCAT\ts\tUniversity of Tabriz, Landscape Department\t\t",
"HCB\ts\tUniversidade de Santa Cruz do Sul, Departamento de Biologia\t\t",
"HCCA\ts\tHastings College\t\t",
"HCCN\th\tNational Institute of Agricultural Science and Technology\t\t",
"HCCV\ts\tHastings College, Collection of Vertebrates\t\t",
"HCDAL\th\tUniversidade Regional do Cariri\t\t",
"HCEN\ts\tUniversidad Nacional del Centro del Peru\t\t",
"HCF\th\tUniversidade Tecnologica Federal do Parana\t\t",
"HCH\ts\tLewis-Clark State College, Natural Sciences Department\t\t",
"HCHM\ts\tHope College, Biology Department\t\t",
"HCIB\ts\tCentro de Investigaciones Biologicas del Noroeste, S. C.\t\t",
"HCIO\ts\tIndian Agricultural Research Institute\t\t",
"HCMS\ts\tHampshire County Council Museums Service\t\t",
"HCMZ\ts\tHope College\t\t",
"HCNHSC\ts\tOhio Historical Society, Natural History Synoptic Collection\t\t",
"HCOA\ts\tCollege of the Atlantic, Herbarium\t\t",
"HCOM\th\tCentre d'Oceanologie de Marseille - University of Aix-Marseille II\t\t",
"HCT\ts\tTaiwan Forestry Research Institute\t\t",
"HCTR\ts\tHoogstraal Center for Tick Research\t\t",
"HDCF\th\tDepartment of Forestry Science\t\t",
"HDD\ts\tTolson Museum, Natural History Department\t\t",
"HDJF\th\tUniversidade Federal dos Vales do Jequitinhonha e Mucuri\t\t",
"HDOA\ts\tHawaii Department of Agriculture\t\t",
"HDSM\ts\tUniversity of Massachusetts Dartmouth\t\t",
"HDTC\ts\tHuddersfield Technical College\t\t",
"HEAC\ts\tHenan Agricultural University\t\t",
"HEB\ts\tHebden Bridge Literary and Scientific Society\t\t",
"HEBI\ts\tHenan Academy of Sciences\t\t",
"HECM\ts\tHenan College of Traditional Chinese Medicine\t\t",
"HEFG\ts\tl'Ecole de Faune de Garoua\t\t",
"HEH\ts\tEscuela Nacional de Ciencias Forestales, Departamento de Investigacion Forestal Aplicada\t\t",
"HEID\ts\tUniversitaet Heidelberg, Heidelberger Institut fuer Pflanzenwissenschaften\t\t",
"HEL\ts\tUniversity of Helsinki, Section of Botany\t\t",
"HEM\th\tUniversidad de Ciencias y Artes de Chiapas\t\t",
"HEMS\ts\tHaslemere Educational Museum\t\t",
"HENA\ts\tEscuela Nacional de Agricultura\t\t",
"HEND\ts\tHenderson State University, Biology Department\t\t",
"HENNU\ts\tHenan Normal University\t\t",
"HENU\ts\tHenan Normal University, Biology Department\t\t",
"HEPH\ts\tJardim Botanico de Brasilia\t\t",
"HER<CAN>\tc\tFelix d'Herelle Reference Center for Bacterial Viruses (Bacteriophage)\t\t",
"HER<ZAF>\ts\tHermanus Botanical Society\t\t",
"HERBAM\th\tUniversidade do Estado de Mato Grosso\t\t",
"HERT\th\tFundacao Universidade Estadual do Ceara\t\t",
"HERZ\ts\tHerzen State Pedagogical University of Russia, Department of Botany\t\t",
"HERZU\ts\tUniversidad del Zulia\t\t",
"HEUS\th\tUniversidad de Sucre\t\t",
"HF\ts\tUniversidade Federal do Para\t\t",
"HFB\ts\tHainan Forestry Bureau\t\t",
"HFBG\ts\tForestry Botanical Garden of Heilongjiang\t\t",
"HFCC\tc\tFlagellate Culture Collection, University of Cologne\t\t",
"HFD\ts\tHereford Museum\t\t",
"HFLA\th\tSapienza University of Rome - Scuola di Specializzazione in Beni Naturali e Territoriali\t\t",
"HFN\th\tHerbarium Frisicum\t\t",
"HFP\tc\tHokkaido Forest Products Research Institute\t\t",
"HFR\ts\tFinnish Forest Research Institute\t\t",
"HFRI\ts\tHunan Forestry Research Institute\t\t",
"HFSL\th\tCentro de Ensino, Faculdade Sao Lucas Ltda.\t\t",
"HFU\ts\tHerbarium of Fayoum University\t\t",
"HFV\ts\tUniversidad Austral de Chile, Instituto de Produccion y Sanidad Vegetal\t\t",
"HFX\ts\tBankfield Museum and Art Gallery\t\t",
"HGAS\ts\tGuizhou Academy of Sciences, Plant Taxonomy Group\t\t",
"HGCRL\ts\tGulf Coast Research Laboratory\t\t",
"HGI\ts\tUniversitat de Girona, Unitat de Biologia Vegetal\t\t",
"HGM\ts\tHunan Geological Museum\t\t",
"HGOM\th\tUniversidad Autonoma del Estado de Hidalgo\t\t",
"HGS\ts\tPublic Museum and Art Gallery, St. John's Place\t\t",
"HGTC\ts\tHuanggang Teachers College, Biology Department\t\t",
"HGU\th\tKhakass State University\t\t",
"HH\th\tInstituto de Investigaciones de la Amazonia Peruana\t\t",
"HHBG\ts\tHangzhou Botanical Garden\t\t",
"HHC\ts\tUniversity of Helsinki, Horticulture Department\t\t",
"HHH\ts\tHartwick College\t\t",
"HHM\ts\tCollyer's School\t\t",
"HHU\ts\tHallym University\t\t",
"HHUA\ts\tUniversidad Nacional de Huanuco Hermilio Valdizan\t\t",
"HHUF\ts\tHirosaki University, Laboratory of Plant Pathology\t\t",
"HIB\ts\tWuhan Institute of Botany\t\t",
"HIBG\th\tHiroshima Botanical Garden\t\t",
"HIC\ts\tUniversity of Kentucky, Department of Entomology, Hymenoptera Institute Collection\t\t",
"HIFP\ts\tFrench Institute\t\t",
"HILL\ts\tSir Harold Hillier Gardens\t\t",
"HIMC\ts\tInner Mongolia University\t\t",
"HIN\ts\tHitchin Priory\t\t",
"HIP\ts\tUniversidad de Magallanes\t\t",
"HIPC\ts\tInstituto Superior Pedagogico Jose Marti, Departamento de Biologia\t\t",
"HIRO\ts\tHiroshima University, Biological Science Department\t\t",
"HIRU\ts\tOkayama University of Science\t\t",
"HISA\th\tUniversidade Estadual Paulista\t\t",
"HITBC\ts\tXishuangbanna Tropical Botanical Garden, Chinese Academy of Sciences\t\t",
"HIUW\ts\tHygiene-Institut der Universitaet\t\t",
"HIWNT\ts\tHampshire and Isle of Wight Naturalists' Trust Ltd.\t\t",
"HJBC\th\tJardin Botanico Culiacan\t\t",
"HJBL\ts\tEscuela Nacional de Ciencias Forestales\t\t",
"HJBS\ts\tFundacio Jardi Botanic de Soller\t\t",
"HK\ts\tAgriculture, Fisheries, and Conservation Department\t\t",
"HKAS\ts\tCryptogamic Herbarium of Kunming Institute of Botany, Chinese Academy of Sciences\t\t",
"HKBU\ts\tHong Kong Baptist University, Biology Department\t\t",
"HKFRS\ts\tHong Kong Fisheries Research Station\t\t",
"HKGL\ts\tNaturwissenschaftliche Sammlungen des Kantons Glarus\t\t",
"HKI\tc\tHans-Knoll Institute\t\t",
"HKM\th\tUniversity of Comoros\t\t",
"HKS\th\tResearch Center of Agricultural and Natural Resources Kurdistan Province\t\t",
"HKU\ts\tUniversity of Hong Kong, Ecology and Biodiversity Department\t\t",
"HKUCC\tc\tThe University of Hong Kong Culture Collection\t\t",
"HL\ts\tHoughton Lake Wildlife Research Station, Natural Resources Department\t\t",
"HL<NLD>\tsb\tHortus Botanicus Leiden\t\t",
"HLA\ts\tHarold L. Lyon Arboretum\t\t",
"HLCM\ts\tHeilongjiang College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t",
"HLD\ts\tHessisches Landesmuseum\t\t",
"HLDG\th\tLas Cruces Biological Station, Organization for Tropical Studies\t\t",
"HLL\ts\tQueen's Gardens, College of Higher Education, Natural Science Department\t\t",
"HLMA\ts\tTown Docks Museum, Hull City Corporation\t\t",
"HLMD\ts\tHessisches Landesmuseum Darmstadt\t\t",
"HLNM\ts\tHeilongjiang Provincial Museum\t\t",
"HLO\ts\tVlastivedne Muzeum v Hlohovci\t\t",
"HLSD\th\tHillsdale College\t\t",
"HLU\ts\tUniversity of Hull, Botany Department\t\t",
"HLUC\ts\tUniversita degli Studi della Basilicata, Dipartimento di Biologia Difesa e Biotecnologie Agroforestali\t\t",
"HLUL\ts\tUniversity of Hull\t\t",
"HLX\ts\tOvenden Naturalists' Society\t\t",
"HM<DEU>\ts\tHumbolt Museum\t\t",
"HM<USA-NE>\ts\tHastings Museum\t\t",
"HMAR\th\tUniversidade Federal do Ceara\t\t",
"HMAS\tsc\tInstitute of Microbiology, Academia Sinica\t\t",
"HMC\ts\tJardin Botanico de Las Tunas\t\t",
"HME\ts\tHaslemere Educational Museum\t\t",
"HMGBH\th\tGiardini Botanici Hanbury / Hanbury Botanic Gardens\t\t",
"HMH\ts\tHoebarth Museum Horn\t\t",
"HMIM\th\tJardi Botanic Marimurtra\t\t",
"HMJAU\tsc\tHerbarium of Mycology of Jilin Agricultural University\t\t",
"HMLN\ts\tDistrict Museum\t\t",
"HMM\ts\tHorsham Museum\t\t",
"HMMNH\th\tMacedonian Museum of Natural History\t\t",
"HMN\ts\tHumbolt Museum fur Naturkunde, East Berlin\t\t",
"HMNH\ts\tHayashibara Museum of Natural History\t\t",
"HMNR\th\tMordovian State Nature Reserve\t\t",
"HMNS\ts\tHouston Museum of Natural Science\t\t",
"HMNT\ts\tHancock Museum, Newcastle University\t\t",
"HMP\ts\tHornonitrianske muzeum, Department of Natural History\t\t",
"HMS\ts\tEmbrapa Gado de Corte\t\t",
"HMUG\ts\tHunterian Museum\t\t",
"HN\ts\tNational Center for Natural Sciences and Technology, Botany Department\t\t",
"HNBU\ts\tInstitut de l'Environnement et de Recherche Agricola (INERA)\t\t",
"HNCMB\tc\tHungarian National Collection of Medical Bacteria\t\t",
"HNG\th\tUniversite. Gamal Abdel Nasser de Conakry\t\t",
"HNH\ts\tDartmouth College, Biological Sciences Department\t\t",
"HNHH\ts\tHeilongjiang Natural History Museum\t\t",
"HNHM<HUN>\ts\tHungarian Natural History Museum (Termeszettudomanyi Muzeum)\t\t",
"HNHM<HUN>:Moll\tc\tHungarian Natural History Museum (Termeszettudomanyi Muzeum), Mollusca Collection",
"HNHM<KOR>\ts\tHannam University, Department of Biology\t\t",
"HNHPS\th\tHunan Hupingshan National Nature Reserve\t\t",
"HNHR\ts\tUniversity of California, Hastings Natural History Reservation\t\t",
"HNIP\ts\tHanoi College of Pharmacy\t\t",
"HNL\th\tConseil National des Sciences\t\t",
"HNM\th\tEcole Normale Superieure de Nouakchott\t\t",
"HNMN\ts\tUniversidad Centroamericana\t\t",
"HNN\ts\tHorniman Museum of Natural History\t\t",
"HNNU\ts\tHunan Normal University, Botany Department\t\t",
"HNPGBI\th\tSeed and Plant Improvement Institute\t\t",
"HNR\ts\tHeilongjiang Academy of Sciences\t\t",
"HNT\ts\tHuntington Botanical Gardens\t\t",
"HNTS\ts\tVlastivedne muzeum\t\t",
"HNU<CHN>\ts\tHunan Normal University\t\t",
"HNU<VNM>\ts\tVietnam National University, Department of Botany\t\t",
"HNUB\ts\tNortheastern University, Biology Department\t\t",
"HNUE\ts\tHanoi National University of Education\t\t",
"HNUL\th\tNorthwestern University Inc.\t\t",
"HNWP\ts\tNorthwest Plateau Institute of Biology, Chinese Academy of Sciences\t\t",
"HNWU\ts\tNebraska Wesleyan University, Biology Department\t\t",
"HO\ts\tTasmanian Museum & Art Gallery\t\t",
"HOH\ts\tUniversitaet Hohenheim (210)\t\t",
"HOL\ts\tHolden Arboretum\t\t",
"HOLZ\ts\tPaleontological Collection\t\t",
"HOMP\ts\tOkresni muzeum Pribram Brezove Hory\t\t",
"HON\ts\tSichuan Grassland Research Institute\t\t",
"HOU\ts\tUniversity of Houston\t\t",
"HOXA\th\tEstacion biologica del Jardin Botanico de Missouri\t\t",
"HPAN\th\tUniversity of the State of Mato Grosso, UNEMAT\t\t",
"HPBR\th\tUniversidade Regional Integrada do Alto Uruguai e das Missoes\t\t",
"HPC\ts\tHoward Payne University, Biology Department\t\t",
"HPD\ts\tHampstead Scientific Society\t\t",
"HPDL\ts\tHampstead Public Library\t\t",
"HPH\ts\tMonroe County Department of Parks\t\t",
"HPL\th\tJardim Botanico Plantarum\t\t",
"HPM\ts\tHouston Museum of Natural Science\t\t",
"HPNP\th\tPumat National Park\t\t",
"HPP\ts\tUniversity of Helsinki, Plant Biology Department\t\t",
"HPPR\ts\tInstituto Superior Pedagogico de Pinar del Rio, Departamento de Biologia\t\t",
"HPSU\ts\tPortland State University, Biology Department\t\t",
"HPU\ts\tHigh Point University, Biology Department\t\t",
"HPU<USA-HI>\ts\tHawaii Pacific University\t\t",
"HPUJ\ts\tPontificia Universidad Javeriana\t\t",
"HPVC\ts\tUniversidad Pedagogico Felix Varela,, Departamento de Biologia\t\t",
"HR\ts\tMuzeum Vychodnich Cech\t\t",
"HRB\ts\tIBGE\t\t",
"HRCB\ts\tUniversidade Estadual Paulista\t\t",
"HREC\th\tHopland Research & Extension Center\t\t",
"HRJ\ts\tUniversidade do Estado do Rio de Janeiro, Departamento de Biologia Animal e Vegetal\t\t",
"HRP\ts\tUniversidad Nacional de La Patagonia, Departamento Biologia General\t\t",
"HSB\ts\tUniversidad Mayor Real y Pontificia de San Francisco Xavier de Chuquisaca\t\t",
"HSBU\th\tShahid Beheshti University\t\t",
"HSC\ts\tHumboldt State University, Biological Sciences Department\t\t",
"HSCC\tc\tCulture Collection of the Research and Development Department\t\t",
"HSI\ts\tUniversity of Helsinki, Silviculture Department\t\t",
"HSIB\ts\tShanxi Institute of Biology, Botany Department\t\t",
"HSIC\ts\tMinistry of Natural Resources, Solomon Islands\t\t",
"HSM\ts\tChrist's Hospital, Biology Department\t\t",
"HSMC\th\tWhyte Thorne Botanic Garden\t\t",
"HSNU\ts\tEast China Normal University, Biology Department\t\t",
"HSP\th\tInstituto Cientifico Michael Owen Dillon\t\t",
"HSS\ts\tDevelopment, Technological and Investigacion Service, Forest Production Department\t\t",
"HSTM\th\tUniversidade Federal do Oeste do Para\t\t",
"HSU<USA-CA>\ts\tHumboldt State University\t\t",
"HSU<USA-TX>\ts\tHardin-Simmons University, Biology Department\t\t",
"HSUCV\ts\tHardin-Simmons University, Collection of Vertebrates\t\t",
"HSUD\th\tStation of Nature Research and Environmental Education\t\t",
"HSUE\ts\tNatural History Museum, Addis Ababa\t\t",
"HSUMZ\ts\tHenderson State University, Museum of Zoology\t\t",
"HSUVM\ts\tHumboldt State University Vertebrate Museum\t\t",
"HTC\ts\tHangzhou Normal College, Biology Department\t\t",
"HTD\ts\tCollege Natural History Society\t\t",
"HTE\ts\tQueen Ethelburga's School\t\t",
"HTGN\ts\tNorris Museum and Library\t\t",
"HTIN\ts\tUniversidad Nacional Agraria de la Selva\t\t",
"HTN\ts\tHitchin Museum\t\t",
"HTO\ts\tUniversidade Federal do Tocantins, Nucleo de Estudos Ambientais\t\t",
"HTTU\ts\tTennessee Technological University, Biology Department\t\t",
"HTU\ts\tUniversity of Taiz, Biology Department\t\t",
"HTW\th\tUniversidad Nacional de la Patagonia San Juan Bosco\t\t",
"HU\ts\tUniversity of Zhejiang\t\t",
"HUA\ts\tUniversidad de Antioquia, Centro de Investigaciones\t\t",
"HUAA\ts\tUniversidad Autonoma de Aquascalientes, Departamento de Biologia\t\t",
"HUAL\ts\tUniversidad de Almeria, Departamento de Biologia Vegetal y Ecologia\t\t",
"HUAP\ts\tHerbario, Universidad Autonoma de Puebla\tBUAP",
"HUAZ\th\tUniversidad de la Amazonia\t\t",
"HUB\ts\tHacettepe University, Botany Department\t\t",
"HUBE\ts\tGolden West College, Biology/Life Sciences Department\t\t",
"HUBO\ts\tUniversita degli Studi di Bologna\t\t",
"HUC\ts\tUniversidad de Cordoba, Departamento de Biologia\t\t",
"HUCM\ts\tHunan College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t",
"HUCP\ts\tPontifica Universidade Catolica do Parana, Departamento de Ciencias Biologicas\t\t",
"HUCS\th\tUniversity of  Caxias do Sul\t\t",
"HUDC\ts\tHoward University, Biology Department\t\t",
"HUE\ts\tHunan Education College, Biology Department\t\t",
"HUEF\ts\tHacettepe Ueniversitesi\t\t",
"HUEFS\ts\tUniversidade Estadual de Feira de Santana, Departamento de Ciencias Biologicas\t\t",
"HUEG\th\tUniversidade Estadual de Goias\t\t",
"HUEM\ts\tUniversidade Estadual de Maringa, Departamento de Biologia\t\t",
"HUESB\th\tUniversidade Estadual do Sudoeste da Bahia-Campus de Jequie\t\t",
"HUESBVC\th\tUniversidade Estadual do Sudoeste da Bahia-Vitoria  da Conquista\t\t",
"HUF\ts\tHunan Forestry School\t\t",
"HUFABC\th\tUniversidade Federal do ABC\t\t",
"HUFSJ\th\tUniversidade Federal de Sao Joao del-Rei\t\t",
"HUFU\ts\tUniversidade Federal de Uberlandia, Instituto de Biologia\t\t",
"HUIC\ts\tHacettepe University Ichthyological Collection\t\t",
"HUIF\ts\tHunan Forestry Institute\t\t",
"HUJ\ts\tHebrew University of Jerusalem\t\t",
"HUJ:INV\ts\tHebrew University of Jerusalem, Invertebrate collection",
"HUKUK\tc\tCulture Collection of Animal Cells\t\t",
"HUL\ts\tFine Arts Museum\t\t",
"HULE\ts\tUniversidad Nacional Autonoma de Nicaragua, Departamento de Biologia\t\t",
"HUM\ts\tHumbolt University Zoologischen Museum\t\t",
"HUMC\th\tUniversidade de Mogi das Cruzes\t\t",
"HUMO\ts\tUniversidad Autonoma del Estado de Morelos, Centro de Educacion Ambiental e Investigacion Sierra de Huautla\t\t",
"HUMP\ts\tMuzeum v Humpolci\t\t",
"HUMZ\ts\tHokkaido University, Laboratory of Marine Zoology\t\t",
"HUNEB\th\tUniversidade do Estado da Bahia\t\t",
"HUNT\th\tHuntington University\t\t",
"HUP\th\tHazara University\t\t",
"HUPG\ts\tState University of Ponta Grossa, Departamento de Biologia\t\t",
"HUQ\ts\tUniversidad del Quindio\t\t",
"HURB\th\tUniversidade Federal do Reconcavo da Bahia\t\t",
"HURG\ts\tUniversidade do Rio Grande, Departamento de Ciencias Morfo-Biologicas\t\t",
"HUS\th\tSiauliai University\t\t",
"HUSA\ts\tUniversidad Nacional de San Agustin de Arequipa, Facultad de Ciencias Biologicas y Agropecuarias, Area de Biomedicas\t\t",
"HUSC\th\tUniversidade Santa Cecilia - UNISANTA\t\t",
"HUSEC<DEU>\tc\tKonsiliarlabor fur Hamolytisch-Uramisches Syndrom\t\t",
"HUST\ts\tHunan University of Science and Technology, School of Life Sciences\t\t",
"HUT<JPN>\tc\tHUT Culture Collection\t\t",
"HUT<PER>\ts\tHerbarium Truxillense, Universidad Nacional de La Libertad-Trujillo\t\t",
"HUTB\ts\tHainan University\t\t",
"HUTI\th\tUniversidad Tecnologica Indoamerica\t\t",
"HUTM\ts\tHunan Academy of Traditional Chinese Medicine and Pharmacy\t\t",
"HUTO\ts\tFundacao Universidade do Tocantins , UNITINS\t\t",
"HUTPL\ts\tUniversidad Tecnica Particular De Loja\t\t",
"HUVA\th\tUniversidade Estadual Vale do Acarau\t\t",
"HVASF\th\tUniversidade Federal do Vale do Sao Francisco\t\t",
"HVR\ts\tUniversidade de Tras-os-Montes e Alto Douro\t\t",
"HWA\ts\tSouthwest Agricultural University, Department of Biological Basic Courses\t\t",
"HWB\ts\tHarrow School, Biology Department\t\t",
"HWBA\ts\tBenedictine College, Biology Department\t\t",
"HWD\ts\tHollinwood Botanists' and Field Naturalists' Society\t\t",
"HWML<USA>\ts\tHoward W. Manter Laboratory of Parasitology\tUNSM:HWML",
"HXBH\ts\tFundacao CETEC\t\t",
"HXC\ts\tHendrix College, Biology Department\t\t",
"HY\ts\tOsmania University, Botany Department\t\t",
"HYD\ts\tHeywood and District Botanical Society\t\t",
"HYO\ts\tMuseum of Nature and Human Activities\t\t",
"Hyogo\ts\tMuseum of Nature and Human Activities\t\t",
"HZI<DEU>\tc\tHelmholtz Zentrum fur Infektionsforschung (Helmholtz Centre for Infection Research)\t\t",
"HZM\ts\tMuseum of Natural History (Hrvatski Zooloski Muzej)\t\t",
"HZMZ\ts\tHrvatski Narodni Zooloski Muzej\t\t",
"HZTC\ts\tHanzhong Teachers College, Biology Department\t\t",
"HZU\ts\tZhejiang University\t\t",
"I\ts\tUniversitatea Al. I. Cuza Iasi\t\t",
"IA\ts\tUniversity of Iowa, Department of Biological Sciences\t\t",
"IAA\ts\tInstituto Antarctico Argentinao, Direccion Nacional del Antartico\t\t",
"IAAA\ts\tInstituto do Acucar e do Alcool\t\t",
"IABH\ts\tAl-Bayt University, Biology Department\t\t",
"IABHU<JPN>\tscb\tInstitute for Amphibian Biology, Graduate School of Science, Hiroshima University\t\t",
"IAC\ts\tInstituto Agronomico de Campinas\t\t",
"IACC\ts\tInstituto Agronomico de Campinas\t\t",
"IACM\ts\tInstituto Agronomico\t\t",
"IADIZA-CM\ts\tInstituto Argentino de Investigaciones de las Zonas Aridas\t\t",
"IAFB\tc\tCollection of Industrial Microorganisms\t\t",
"IAGB\ts\tUniversitatea Al. I. Cuza Iasi\t\t",
"IAL<BRA-Bahia>\ts\tHerbario, Centro Nacional de Pesquisa de Mandioca e Fruticultura, EMBRAPA\t\t",
"IAL<BRA-SaoPaulo>\tc\tSecao de Colecao de Culturas\t\t",
"IALCEL\tc\tSecao de Culturas Celulares\t\t",
"IALMIC\tc\tMicoteca do Insituto Adolfo Lutz\t\t",
"IAM\tc\tIAM Culture Collection, Center for Cellular and Molecular Research\t\t",
"IAM<RUS>\ts\tNational Alliance of Shidlovskiy \"Ice Age\", Ice Age Museum\t\t",
"IAN\ts\tEmbrapa Amazonia Oriental\t\t",
"IAPG\ts\tInstitute of Animal Physiology and Genetics, Academy of Sciences of the Czech Republic\t\t",
"IARI\tsb\tIndian Agricultural Research Institute\t\t",
"IASI\ts\tUniversitatea Agronomica, Disciplina de Botanica\t\t",
"IAUGH\th\tIslamic Azad University Garmsar\t\t",
"IAUH\th\tIslamic Azad University\t\t",
"IAUM\th\tIslamic Azad University of Mashhad\t\t",
"IAUNT\th\tIslamica Azad University, North Tehran Branch\t\t",
"IAV\tsb\tInstitut Agronomique et Veterinaire Hassan II, Departement d'Ecologie Vegetale\t\t",
"IAVH\ts\tInstituto de Ivestigacion de los Recursos Biologicos Alexander von Humboldt\t\t",
"IB\ts\tUniversitat Innsbruck\t\t",
"IBA<ESP>\ts\tInstituto Asturiano de Taxonomia y Ecologia Vegetal\t\t",
"IBA<POL>\tc\tCollection of Microorganisms Producing Antibiotics\t\t",
"IBAR\th\tIbaraki University\t\t",
"IBAUNC\ts\tUniversidad Nacional de Cuyo, Instituto de Biologia Animal\t\t",
"IBBS\ts\tInsitute of Biology and Soil Science, Russian Academy of Sciences\t\t",
"IBE\ts\tInstitute for Botanical Exploration\t\t",
"IBE<ESP>\ts\tInstitut de Biologia Evolutiva, (CSIC-UPF)\t\t",
"IBEF\ts\tMuseum of the Izumi Board of Education\t\t",
"IBF\ts\tTiroler Landesmuseum Ferdinandeum\t\t",
"IBGE\ts\tReserva Ecologica do IBGE\t\t",
"IBH\ts\tUniversidad Nacional Autonoma de Mexico, Instituto de Biologia\t\t",
"IBI\ts\tInstituto Biologico, Laboratorio de Micologia\t\t",
"IBIR\ts\tInstitutul Agronomic\t\t",
"IBIW\ts\tI. D. Papanin Institute for Biology of Inland Waters\t\t",
"IBK\ts\tGuangxi Institute of Botany\t\t",
"IBL<ISR>\ts\tIndependent Biological Laboratories\t\t",
"IBL<POL>\ts\tForest Research Institute, Poland\t\t",
"IBL<PRT>\tc\tBotanical Institute, Lisbon Faculty of Sciences\t\t",
"IBL<USA-MD>\tc\tInsect Biocontrol Laboratory (USDA-ARS, Beltsville)\t\t",
"IBLP\ts\tInstytut Badawczy Lesnictwa\t\t",
"IBMUNC\ts\tUniversidad Nacional de Cuyo, Instituto de Biologia Animal\t\t",
"IBP\ts\tInstituto de Biologia do Parana\t\t",
"IBPPM\tc\tInstitute of Biochemistry and Physiology of Plants and Microorganisms of the Russian Academy of Sciences\t\t",
"IBRC\tsc\tIranian Biological Resource Center\t\t",
"IBRP<BRA>\ts\tInstituto Biologico de Ribeirao Preto\t\t",
"IBRP<JPN>\ts\tInstitute for Breeding Research, Tokyo University of Agriculture\t\t",
"IBS\ts\tIrish Biogeographical Society\t\t",
"IBSBF\tc\tBiological Institute Culture Collection of Phytopathogenic Bacteria\t\t",
"IBSC\ts\tSouth China Botanical Garden\t\t",
"IBSD\ts\tDinghushan Biosphere Reserve\t\t",
"IBSP\ts\tInstituto Biologico de Sao Paulo\t\t",
"IBT\tc\tIBT Culture Collection of Fungi, Mycology Group, Technical University of Denmark\t\t",
"IBTS\ts\tInstitutul de Biologie, Tr. Savulescu\t\t",
"IBUG\ts\tUniversidad de Guadalajara\t\t",
"IBUNAM\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico\tUNAM",
"IBUNAM:CFB\tb\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion de Fotocolectas Biologicas",
"IBUNAM:CNAC\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Acaros",
"IBUNAM:CNAN\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Aracnidos",
"IBUNAM:CNAR\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Anfibios y Reptiles",
"IBUNAM:CNAV\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Aves",
"IBUNAM:CNCR\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Crustaceos",
"IBUNAM:CNHE\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Helmintos",
"IBUNAM:CNIN\ts\tColeccion Nacional de Insectos, Universidad Nacional Autonoma de Mexico\tIBUNAM:CNIN",
"IBUNAM:CNIN\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Insectos",
"IBUNAM:CNMA\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Mamiferos",
"IBUNAM:CNMO\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Moluscos",
"IBUNAM:CNPE\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Peces",
"IBUNAM:MEXU\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Herbario Nacional",
"IBUP\ts\tInstitute of Biology\t\t",
"IBUS\ts\tUniversidade Federal do Rio de Janeiro\t\t",
"IBUT\ts\tInstituto Butanta\t\t",
"IBY\ts\tBotanical Institute of Guangxi\t\t",
"ICA\ts\tInstituto Colombiano Agropecuario, Tibaitata\t\t",
"ICARDA<SYR>\tsb\tInternational Center for Agricultural Research in the Dry Areas\t\t",
"ICBB\tc\tICBB Culture Collection for Microorganisms and Cell Culture\t\t",
"ICBU\ts\tBishop's University, Natural History Museum\t\t",
"ICCF\tc\tCollection of Industrial Microorganisms\t\t",
"ICEB\ts\tEurouniversity\t\t",
"ICEL\ts\tIcelandic Institute of Natural History\t\t",
"ICF\ts\tINIFAP\t\t",
"ICFC\tc\tIIB-INTECH Collection of Fungal Cultures\t\t",
"ICGC\ts\tIstituto Calasanzio\t\t",
"ICHUM\ts\tInvertebrate Collection of the Hokkaido University Museum\t\t",
"ICIS\ts\tIdaho Museum of Natural History\t\t",
"ICM\ts\tInstituto de Ciencias del Mar\tICMD",
"ICMP\tc\tInternational Collection of Microorganisms from Plants\tPDDCC ",
"ICN<BRA>\ts\tUniversidade Federal do Rio Grande do Sul, Departamento de Botanica\t\t",
"ICN<COL>\ts\tInstituto de Ciencias Naturales, Museo de Historia Natural\t\t",
"ICP\ts\tIslamia College, University of Peshawar, Botany Department\t\t",
"ICPB\tc\tInternational Collection of Phytopathogenic Bacteria\t\t",
"ICPPB\ts\tInternational Collection of Plant Pathogenic Bacteria\t\t",
"ICPR\ts\tBiological Control Research Institute\t\t",
"ICRC\ts\tInsect Control and Research\t\t",
"ICRG\ts\tInstitute of Entomology\t\t",
"ICRI\ts\tZhonghan (Sun Yat-Sen) University, Research Institute of Entomology\t\t",
"ICRISAT\tb\tInternational Crops Research for the Semi-Arid Tropics\t\t",
"ICS-CC<ZAF>\tc\tInfection Control Services , National Health Laboratory Service 3\t\t",
"ICST\ts\tImperial College of Science, Technology & Medicine, Department of Biological Sciences\t\t",
"ICUI\ts\tUniversity of Iowa\t\t",
"ICVI\ts\tThe Volcani Center\t\t",
"ID\ts\tUniversity of Idaho, Biological Sciences Department\t\t",
"IDAC\tcb\tThe International Depositary Authority of Canada\t\t",
"IDEA\ts\tInstituto de Agronomia\t\t",
"IDF\ts\tUniversity of Idaho\t\t",
"IDS\ts\tIdaho State University, Biological Sciences Department\t\t",
"IE\tsc\tCepario de Hongos del Instituto de Ecologia\t\t",
"IEA\ts\tInstituto DI Entomologia Agraria\t\t",
"IEAB\ts\tIstituto di Entomologia Agraria dell'Universita\t\t",
"IEAM\ts\tIstituto di Entomologia dell'Universita degli Studi [= Istituto di Entomologia Agraria dell'Universita, Milan]\t\t",
"IEAP\ts\tIstituto di Entomologia Agraria dell'Universita\t\t",
"IEAPM\tc\tInstituto de Estudos do Mar \"Almirante Paulo Moreira\"\t\t",
"IEAS\ts\tInstitute of Entomology\t\t",
"IEAU\ts\tIstituto di Entomologia Agraria dell'Universita\t\t",
"IEB\ts\tInstituto de Ecologia, A.C.\t\t",
"IEBC\tc\tInternational Entomopathogenic Bacillus Centre (WHO)\t\t",
"IEBR\ts\tInstitute of Ecology and Biological Resources\t\t",
"IEC\ts\tCentre D'Etude sur les Ressources Vegetales\t\t",
"IECA\ts\tCzech Academy of Science, Institute of Entomology\t\t",
"IEEUACH\ts\tUniversidad Austral de Chile, Instituto de Ecologia y Evolucion\t\t",
"IEGG\ts\tUniversita di Bologna, Istituto di Entomologia \"Guido Grandi\"\t\t",
"IEGM\tc\tRegional Specialized Collection of Alkanotrophic Microorganisms\t\t",
"IEI\ts\tInstitut d'Estudis Ilerdencs\t\t",
"IEM\tc\tCzech National Collection of Type Cultures\t\t",
"IEME\ts\tInstitute for Evolution, Morphology, and Ecology of Animals\t\t",
"IEMM\ts\tInstituto de Ecologia\t\t",
"IENU\ts\tIstituto di Entomologia, Universita degli Studi\t\t",
"IEPA\ts\tIstituto di Entomologia Agraria dell'Universita\t\t",
"IER\th\tInstitut d'Economie Rurale\t\t",
"IEUC\ts\tIstituto di Entomologia Agraria dell'Universita Cattolica\t\t",
"IEUP\ts\tIstituto di Entomologia, Universita degli Studi\t\t",
"IEVB\ts\tInstitut de Zoologie [Institut Ed. Van Beneden]\t\t",
"IFAM\tc\tInstitut fur Allgemeine Mikrobiologie\t\t",
"IFAN\ts\tInstitut Fondamental d'Afrique Noire\t\t",
"IFBM\tc\tStreptokokken Sammlung\t\t",
"IFE\ts\tObafemi Awolowo University, Botany Department\t\t",
"IFFB\ts\tInstitut fuer Forstenentomologie und Forstschutz\t\t",
"IFG<USA-CA>\ts\tInstitute of Forest Genetics\t\t",
"IFGD\ts\tIdaho Fish and Game\t\t",
"IFGH\ts\tIdaho Fish and Game Department\t\t",
"IFGP\ts\tPacific Southwest Research Station, USDA Forest Service\t\t",
"IFI\ts\tImperial Fisheries Institute\t\t",
"IFM<AUS>\tc\tIFM Quality Services Pty Ltd\t\t",
"IFM<JPN>\tc\tResearch Center for Pathogenic Fungi and Microbial Toxicoses, Chiba University\t\t",
"IFO\tc\tInstitute for Fermentation\t\t",
"IFP\ts\tInstitute of Applied Ecology, Academia Sinica\t\t",
"IFRD\ts\tResearch Institute of Resource Insects\t\t",
"IFRDCC\tc\tInternational Fungal Research and Development Culture Collection\t\t",
"IFREMER\ts\tInstitut Francais pour l'Etude de la Mer\t\t",
"IFRI\ts\tIndian Forest Research Institute\t\t",
"IFRPD\tc\tInstitute of Food Research and Product Development, Kasetsart University\t\t",
"IFSA\ts\tInstituto Florestal\t\t",
"IG\ts\tInstitute of Geology\t\t",
"IGB<ISR>\tsb\tIsrael Plant Gene Bank\t\t",
"IGC\tc\tPortuguese Yeast Culture Collection\t\t",
"IGCAGS\ts\tInstitute of geology, Chinese Academy of Geological Science\t\t",
"IGCU\ts\tInstituto de Geologia, Ciudad Universitaria\t\t",
"IGESALQ\tc\tColecao Microorganismos\t\t",
"IGF\ts\tInstituto di Geologia e Paleontologia\t\t",
"IGGDC\th\tInstitute of Geology and Geophysics, Chinese Academy of Sciences\t\t",
"IGL\ts\tInstitute fuer Geowissenschaften Leoben\t\t",
"IGM<MEX>\ts\tInstituto de Geologia\t\t",
"IGM<MNG>\ts\tGeological Institute, Mongolian Academy of Sciences\t\t",
"IGPH\ts\tInstitut fuer Geologie und Palaeontologie der Universitat Hannover\t\t",
"IGUS\ts\tUniversitat des Saarlandes\t\t",
"IGWH\ts\tInstitut fuer Geowissenschaften aus dem Martin-Lurther- Universitat\t\t",
"IH\ts\tInstituto de Segunda Ensenanza de La Habana\t\t",
"IHASW\ts\tInstitute of Hydrobiology, Academia Sinica\t\t",
"IHB\ts\tInstitute of Hydrobiology, Chinese Academy of Sciences\t\t",
"IHCAS\ts\tMuseum of Institute of Hydrobiology, Chainese Academy of Sciences\t\t",
"IHEM\tc\tScientific Institute of Public Health, Mycology Section\tBCCM/IHEM ",
"IHUG\ts\tInstitut fuer Hygiene der Iniversitaet\t\t",
"IIBM-UNAM\tc\tIndustrial Culture Collection\t\t",
"IIBUV\ts\tInvestigaciones Biologicas de la Universidad Veracruzana (Mexico)\t\t",
"IICT\ts\tCentro de Zoologia do I.I.C.T.\t\t",
"IID\tc\tLaboratory Culture Collection\t\t",
"IIES\ts\tInstituto Investigaciones Entomologicas Salta\t\t",
"IIPB\ts\tInstituto de Ciencias del Mar\t\t",
"IITA\tb\tInternational Institute of Tropical Agriculture\t\t",
"IJ\ts\tInstitute of Jamaica\t\t",
"IJFM\tc\tInstituto Jaime Ferran de Microbiologia Consejo Superior de Investigaciones Cientificas\t\t",
"IJSM\ts\tInstitute of Jamaica, Natural History Museum\t\t",
"IK\ts\tZoological Institute, Ukrainian Academy of Sciences\t\t",
"ILCA\ts\tInternational Livestock Research Institute\t\t",
"ILF\ts\tIflracombe Museum\t\t",
"ILH\ts\tIowa Lakeside Laboratory\t\t",
"ILL\tsc\tUniversity of Illinois, Plant Biology Department\t\t",
"ILLS\ts\tIllinois Natural History Survey\t\t",
"ILMA\ts\tIstituto Leonardo Murialdo\t\t",
"ILPLA\ts\tMuseo de La Plata, Instituto de Limnologia\t\t",
"IM<CUB>\ts\tInstituto de Segunda Ensenanza de Matanzas\t\t",
"IM<IND>\ts\tIndian Museum\t\t",
"IMAGE\tb\tThe I.M.A.G.E Consortium\t\t",
"IMARPE\ts\tInstituto del Mar del Peru\t\t",
"IMAS\tc\tInstitute for Marine and Antarctic Studies\t\t",
"IMAU\tc\tInner Mongolia Agricultural University, Key Laboratory of Dairy Biotechnology and Engineering\t\t",
"IMC\ts\tSichuan Academy of Traditional Chinese Medicine and Pharmacy\t\t",
"IMCC\tc\tInha Microbe Culture Collection, Inha University\t\t",
"IMCN\ts\tInstituto Vallecaucano de Investigaciones Cientificas\t\t",
"IMD\tc\tIndustrial Microbiology Dublin\t\t",
"IMD<CHN>\ts\tInstitute of Medicinal Plant Development, Chinese Academy of Medical Sciences\t\t",
"IMDC\ts\tInner Mongolia Institute for Drug Control\t\t",
"IMDY\ts\tChinese Academy of Medical Sciences, Yunnan Branch\t\t",
"IMET\tc\tNational Kurturensammlung fuer Mikroorganismen\t\t",
"IMFA\ts\tInner Mongolia Academy of Forestry\t\t",
"IMI\tsc\tCABI Bioscience Genetic Resource Collection\t\t",
"IML\ts\tInstituto Miguel Lillo\t\t",
"IMLA\ts\tFundacion e Instituto Miguel Lillo\t\t",
"IMM<CHN-Bejing>\ts\tChinese Academy of Medical Science\t\t",
"IMM<CHN-Hohhot>\ts\tInner Mongolian Museum\t\t",
"IMMH\tc\tCollection of Animal Viruses\t\t",
"IMMIB\tc\tCulture Collection of the Institute of Medical Microbiology and Immunology of the University of Bonn\t\t",
"IMPC\ts\tSichuan Academy of Traditional Chinese Medicine and Pharmacy\t\t",
"IMRU\tc\tWaksman Institute of Microbiology\t\t",
"IMS<TZA>\ts\tInstitute of Marine Sciences\t\t",
"IMS<USA-NC>\ts\tUniversity of North Carolina at Chapel Hill\t\t",
"IMSNU\tc\tInstitute of Microbiology, Seoul National University\t\t",
"IMSSM\ts\tInstituto Mexicano del Seguro Social\t\t",
"IMT<BRA>\tc\tMicoteca do Instituto de Medicina Tropical de Sao Paulo\t\t",
"IMT<JPN>\ts\tImperial Museum\t\t",
"IMTU\ts\tInstitute of Medicine, Community Medicine Department\t\t",
"IMUFRJ\tc\tInstituto de Microbiologia of Universidade Federal do Rio de Janeiro\t\t",
"IMVS\tc\tIMVS Culture Collection\t\t",
"IMYZA\tc\tInstituto de Microbiologia y Zoologia Agricola\t\t",
"INA<PRT>\ts\tInstituto Nun'Alvres, Departamento de Biologia\t\t",
"INA<RUS>\tc\tCulture Collection of the Institute of New Antibiotics\t\t",
"INALI\ts\tInstituto Limnologia\t\t",
"INB\ts\tInstituto Nacional de Biodiversidad, Departamento de Botanica\t\t",
"INBC\ts\tInstituto Nacional de Biodiversidad (INBio)\t\t",
"INBio\ts\tNational Biodiversity Institute, Costa Rica\t\t",
"INBP\ts\tInventorio Biologico Nacional [Museo Nacional de Historia Natural del Paraguay]\t\t",
"INC\ts\tInstituto Nacional de Cultura, Museo de Ciencias Naturales (Panama)\t\t",
"INCQS\tc\tFundacao Oswaldo Cruz-FIOCRUZ\t\t",
"IND\ts\tIndiana University, Department of Biology\t\t",
"IND-AN\ts\tAmphibian Collection\t\t",
"IND-M\ts\tLa Unidad de Investigacion \"Federico Medem\"-Inderena (Colombia)\t\t",
"INDRE\tc\tPathogen Fungi and Actinomycetes Collection\t\t",
"INEGI\ts\tInstituto Nacional de Estadistica Geografia e Informatica, Departamento de Botanica\t\t",
"INEP\th\tInstitute of the Industrial Ecology Problems of the North of Kola Science Center of the Russian Academy of Sciences.\t\t",
"INER\ts\tIstituto Nazionale di Entomologia\t\t",
"INFYB\ts\tInstituto Nacional de Farmacologia y Bromatologia, Farmacobotanica\t\t",
"INGU\th\tIngush State University\t\t",
"INH\ts\tInstitut National d'Horticulture, Departement de Sciences Biologiques\t\t",
"INH<ECU>\ts\tInstituto Nacional de Higiene\t\t",
"INHM\ts\tIraq Natural History Museum\t\t",
"INHS\ts\tIllinois Natural History Survey\t\t",
"INIA\ts\tInstituto Nacional de Investigaciones Forestales y Agropecurias\t\t",
"INIA<CHL>\tb\tEl Instituto de Investigaciones Agropecuarias\t\t",
"INIA<ESP>\tb\tInstituto Nacional de Investigacion y Tecnologia Agraria y Alimentaria\t\t",
"INIBP\ts\tInstituto Nacional de Investigaciones Biologico Pesqueras\t\t",
"INIDA\ts\tInstituto Nacional de Investigacao e Desenvolvimento Agrario - Cape Verde\t\t",
"INIDEP\ts\tInstituto Nacional de Investigacion y Desarrollo Pesquero\t\t",
"INIF\tc\tColeccion de Microhongos\t\t",
"INIFAT\tc\tINIFAT Fungus Collection\t\t",
"INIP\ts\tInstituto Nacional de Investigacao das Pescas\t\t",
"INIR\ts\tColeccion de Termitas Mexicanas\t\t",
"INLA\ts\tINIA Subestacion Experimental Control Biologico La Cruz\t\t",
"INM<JPN>\ts\tIbaraki Nature Museum\t\t",
"INMI\tc\tInstitute of Microbiology, Russian Academy of Sciences\t\t",
"INPA\ts\tInstituto Nacional de Pesquisas da Amazonia\t\t",
"INPA:CR\ts\tInstituto Nacional de Pesquisas da Amazonia, Crustacea Collection",
"INPA:H\ts\tInstituto Nacional de Pesquisas da Amazonia, Collection of Amphibians and Reptiles",
"INPA:LMM\tc\tInstituto Nacional de Pesquisas da Amazonia, Laboratorio de Micologia Medica Divisao de Microbiologia e Nutricao",
"INPC\ts\tNational Pusa Collections\t\t",
"INRA\tb\tInstitut National de la Recherche Agronomique\t\t",
"INRA:CGAB\tcb\tInstitut National de la Recherche Agronomique, Collection of Germplasms of Agaricus bisporus",
"INU\th\tInonu University\t\t",
"INV\ts\tInverness Museum and Art Gallery\t\t",
"INVA\ts\tInvergordon Academy\t\t",
"INVAM\tc\tInternational Culture Collection of (Vesicular) Arbuscular Mycorrhizal Fungi\t\t",
"INVEMAR\ts\tInstituto de Investigaciones Marinas de Punta de Betin\t\t",
"IO<BRA>\ts\tInstituto Oceanografico da Universidade de Sao Paulo\t\t",
"IO<PRT>\ts\tInstituto de Oceanografia da Universidade de Lisboa\t\t",
"IOAN\ts\tShirshov Institute of Oceanography\t\t",
"IOC\tc\tColecao de Culturas de Fungos do Instituto Oswaldo Cruz\t\t",
"IOCAS\ts\tInstitute of Oceanology, Chinese Academy of Scineces\t\t",
"IOEB\tc\tCentre de ressources biologiques oenologiques\tCRBO",
"IOH\ts\tAcademia de Ciencias\t\t",
"IOM\ts\tInstitute of Oceanology, Academy of Sciences\t\t",
"IOPM\ts\tIzu Oceanic Park Museum\t\t",
"IORD\ts\tTakai University, Institute of Oceanic Research and Development\t\t",
"IOS\ts\tInstitute of Oceanographic Sciences\t\t",
"IOUSP\tc\tMarine Microalgae Culture Collection\t\t",
"IOWA\ts\tUniversity of Iowa, Museum of Natural History\t\t",
"IPA\ts\tEmpresa Pernambucana de Pesquisa Agropecuaria, IPA\t\t",
"IPA:germplasm bank\tb\tEmpresa Pernambucana de Pesquisa Agropecuaria, IPA, ",
"IPAE<RUS>\ts\tInstitute of Plant and Animal Ecology Ural Branch of Russian Academy of Sciences\t\t",
"IPB<BRA>\ts\tInstituto Paranaense de Botanica\t\t",
"IPB<DEU>\ts\tInstitut fuer Palaeontologie\t\t",
"IPBIR\tb\tIntegrated Primate Biomaterials and Information Resource\t\t",
"IPCN\ts\tInstituto Patagonico de Ciencias Naturales\t\t",
"IPE\ts\tInstituto Pirenaico de Ecologia\t\t",
"IPEE RAS\ts\tA.N. Severtzov Institute of Ecology and Evolution, Russian Academy of Sciences\t\t",
"IPEF\ts\tInstitut fuer Pflanzenschutzforschung\t\t",
"IPFUB\ts\tInstitute for Paleontology of the Freie Universitat\t\t",
"IPGR<BGR>\tb\tInstitute for Plant Genetic Resources\t\t",
"IPHG\ts\tInstitut fur Palaeontologie und Historische Geologie\t\t",
"IPK\tsb\tLeibniz Institute of Plant Genetics and Crop Plant Research\t\t",
"IPKUP\ts\tPaleontologiscsky Institute\t\t",
"IPLA\tc\tInstituto de Productos Lacteos de Asturias\t\t",
"IPMB<DEU>\ts\tInstitut fur Pharmazie und Molekulare Biotechnologie\t\t",
"IPMC\ts\tInstitut Paleontologic Dr. M. Crusfafont Sabadell\t\t",
"IPMGO\ts\tInstitut fur Paleontologie und Museum, Gottingen Universitat\t\t",
"IPMY\ts\tUniversidad Pedagogica Libertador, Nucleo Maracay, Departamento de Biologia\t\t",
"IPN\ts\tInstituto Politecnico Nacional\t\t",
"IPO\ts\tPlant Research International\t\t",
"IPPAS\tc\tCulture Collection of Microalgae IPPAS\tIPPRAS",
"IPRN\ts\tInstituto de Pesquisas de Recursos Naturais Renovaveis\t\t",
"IPS\ts\tIpswich Museum\t\t",
"IPSLI\ts\tIpswich Literary Institute\t\t",
"IPSM\ts\tIpswich Museum\t\t",
"IPSN\ts\tInstituto de Paleontologia de Sabadella\t\t",
"IPT\tc\tAgrupamento de Biotecnologia, Culture Collection of Microorganisms\t\t",
"IPTB\ts\tInstituto de Pesquisas Tecnologicas\t\t",
"IPUW\ts\tInstitut fuer Palaeontologie der Universitaet Wien\t\t",
"IPW\ts\tInstutut fuer Palaeontologie der Uinversitaet Wurzburg\t\t",
"IQW\th\tSenckenberg Forschungsinstitut und Naturmuseen\t\t",
"IRAG\ts\tInstitut National de la Recherche Agronomique de Antilles et Guyane\t\t",
"IRAI\th\tParque da Ciencia Newton Freire Maia\t\t",
"IRAN\tsc\tIranian Research Institute of Plant Protection, Department of Botany\t\t",
"IRAQ\ts\tIraq Natural History Museum\t\t",
"IRBR\ts\tUniversidad de Oriente, Departamento de Biologia\t\t",
"IRCW\ts\tMadison, University of Wisconsin\t\t",
"IRD\ts\tInstitut de Recherche pour le Developpement\t\t",
"IRDA\ts\tAgriculture Department\t\t",
"IREC\ts\tInstitut de Recherches Entomologique de la Caribe\t\t",
"IRGC\tb\tInternational Rice Genebank Collection\t\t",
"IRK\ts\tSiberian Institute of Plant Physiology and Biochemistry\t\t",
"IRKU\ts\tIrkutsk State University, Department of Botany and Genetics\t\t",
"IRP\ts\tIsle Royale National Park\t\t",
"IRRI\tsb\tInternational Rice Research Institute\t\t",
"IRSAC\ts\tInstitute de Recherche Scientific en Afrique Centrale\t\t",
"IRSC\ts\tInstitut de Recherches Scientifiques au Congo\t\t",
"IRSM\ts\tInstitut Recherche Scientifique de Madagascar\t\t",
"IRSN\ts\tInstitut Royal des Sciences Naturelles de Belgique\t\t",
"IRSNB\ts\tInstitut Royal des Sciences Naturelles de Belgique\t\t",
"IRVC\ts\tUniversity of California, UCI Arboretum Mail\t\t",
"IS\ts\tUniversity of Molise, Department of Science and Technology for Environment and Territory\t\t",
"ISAB\ts\tIstituto Sant'Antonio dei Padri Francescani\t\t",
"ISAR\ts\tAcademy of Science\t\t",
"ISAS\ts\tKunming Institute of Zoology\t\t",
"ISB\ts\tInstitute of Spelology \"Emile Racovita\"\t\t",
"ISBB\ts\tInstitutul de Stiinte Biologice\t\t",
"ISBC\ts\tInstitute of Soil Biology, Academy of Science of the Czech Republic\t\t",
"ISBC:CMF\tcb\tInstitute of Soil Biology, Academy of Science of the Czech Republic, Collection of Microscopic Fungi",
"ISC<FRA>\tc\tInternational Salmonella Centre (W.H.O.)\t\t",
"ISC<USA-IA>\ts\tIowa State University, Botany Department\t\t",
"ISCM\ts\tInstitut Scientifique Cheripen\t\t",
"ISE\th\tUniversidade Federal de Sergipe, Campus Professor Alberto Carvalho\t\t",
"ISEA\ts\tInstitute of Systematics and Evolution of Animals\t\t",
"ISEAK\ts\tInstytut Systematyki i Ewolucji Zwierz\t\t",
"ISEM\ts\tInstitut des Sciences de l'Evolution Montpellier \t\t\t",
"ISER\ts\tInstitutul Speologie Emil G. Racovita\t\t",
"ISH\ts\tInstitut fuer Seefischerei\t\t",
"ISI\ts\tGeological Museum, Indian Statistical Institute\t\t",
"ISIS\ts\tNaturforschende Gesellschaft Isis\t\t",
"ISKW\th\tIshikawa Museum of Natural History\t\t",
"ISL\ts\tQuaid-I-Azam University, Biological Sciences Department\t\t",
"ISM\ts\tIllinois State Museum\tISMS",
"ISMAR\th\tConsiglio Nazionale delle Ricerche, Istituto di Scienze  Marine\t\t",
"ISMC\ts\tIndiana Department of Natural Resources\t\t",
"ISNHC\ts\tState Historical Society of Iowa\t\t",
"ISNP\ts\tIstituto Sperimentale per la Nutrizione delle Piante\t\t",
"ISP\tc\tInternational Cooperative Project for Description and Deposition of Type Cultures\t\t",
"ISPaVe\tc\tIstituto Sperimentale per la Patologia Vegetale\tCRA-PAV",
"ISRA\ts\tRoyal Academy\t\t",
"ISRI\tc\tIndonesian Sugar Research Institute, Pusat Penelitian Perkebunan Gula Indonesia\t\t",
"ISS\tc\tInstitute of Soil Science Collection of Bacteria\t\t",
"ISTC\ts\tUniversity of Northern Iowa, Biology Department\t\t",
"ISTE\ts\tUniversity of Istanbul, Department of Pharmaceutical Botany\t\t",
"ISTF\ts\tIstanbul University, Botany Department\t\t",
"ISTO\ts\tUniversity of Istanbul, Orman Fakueltesi\t\t",
"ISTPM\ts\tInstitut Scientifique et Technique des Peches Maritimes\t\t",
"ISU<USA-IL>\ts\tIllinois State University, Biological Sciences Department\t\t",
"ISU<USA-IN>\ts\tIndiana State University\t\t",
"ISUC\ts\tNormal, Illinois State University\t\t",
"ISUI\ts\tIowa State University\t\t",
"ISUVC\ts\tIndiana State University\t\t",
"ISZA\ts\tIstituto Sperimentale per la Zoologia Agraria\t\t",
"ISZP\ts\tInstitute of Systematic Zoology\t\t",
"ITAE\ts\tIstituto Tecnico Agrario Enologico\t\t",
"ITAL\tc\tBanco de Fermentos Lacticos\t\t",
"ITALSL\tc\tSecao de Leite e Derivados\t\t",
"ITALSM\tc\tSecao de Microbiologia\t\t",
"ITBCC\tc\tInstitute of Technology Bandung Culture Collection\t\t",
"ITBCZ\ts\tInstitute of Tropical Biology Collection of Zoology\t\t",
"ITBZC\ts\tInstitute of Tropical Biology, Zoology Collection\t\t",
"ITC\tb\tInternational Transit Centre\t\t",
"ITCC<IND>\tc\tIndian Type Culture Collection\t\t",
"ITCC<ITA>\ts\tIstituto Tecnico Stattale \"Camillo Cavour\"\t\t",
"ITCO\ts\tIstituto Tecnico Commerciale \"Oronzio Gabriele Costa\"\t\t",
"ITCV\ts\tInstituto Tecnologico de Ciudad Victoria, Departamento de Micologia\t\t",
"ITD\tc\tColeccion de Cepas Microbianas\t\t",
"ITDI\tc\tIndustrial Technology Development Institute\t\t",
"ITEM\tc\tInstitute of Toxins and Mycotoxins from Plant Parasites\t\t",
"ITG\tc\tITG\t\t",
"ITH\tc\tW.H.O./F.A.O. Collaborating Centre for Reference and Research on Leptospirosis\t\t",
"ITHA\ts\tInstituut voor Tropische Hygiene\t\t",
"ITIC\ts\tUniversidad de El Salvador, Escuela de Biologia\t\t",
"ITLJ\ts\tNational Institute of Agro-environmental Sciences\t\t",
"ITMH\th\tMuhimbili University of Health and Allied Sciences\t\t",
"ITMM\ts\tInstituto Tecnologico de Monterrey\t\t",
"ITT\ts\tInstituto Technologico de Ciudad Victoria\t\t",
"IU\ts\tIndiana University\t\t",
"IUI\ts\tInha University, Biology Department\t\t",
"IUIC\ts\tIndiana University\t\t",
"IUK\ts\tUniversite de Kinshasa, Departement de Biologie\t\t",
"IUM\ts\tIwate University, Biology Department\t\t",
"IUP\ts\tIndiana University of Pennsylvania, Biology Department\t\t",
"IUQ\ts\tLaboratorio de Ictiologia\t\t",
"IVAU\ts\tInstituut Voor Aardwetenschappen\t\t",
"IVB\ts\tInstitute of  Vertebrate Biology, Academy of Sciences of the Czech Republic\t\t",
"IVF\ts\tChinese Academy of Agricultural Sciences\t\t",
"IVGU\th\tIvanovo State University\t\t",
"IVIC\ts\tInstituto Venezolano de Investigaciones Cientificas\t\t",
"IVPP\ts\tInstitute of Vertebrate Paleontology and Paleoanthropology\tIVPP AS",
"IZ<BRA>\tc\tDepartamento de Tecnologia Rural\t\t",
"IZ<CUB>\ts\tInstituto de Zoologia\t\t",
"IZ<KAZ>\ts\tInstitute of Zoology\t\t",
"IZ<TUR>\ts\tAegean Agricultural Research Institute, Department of Plant Genetic Resources\t\t",
"IZA\ts\tUniversita di l'Aguila, Instituto di Zoologia\t\t",
"IZAC<ARG>\ts\tUniversidad Nacional de La Rioja-Sede Chamical\t\t",
"IZAC<CUB>\ts\tAcademia de Ciencias de Cuba, Instituto de Zoologia\t\t",
"IZAS\ts\tInstitut Zoologii Akademii Nauk Ukraini - Institute of Zoology of the Academy of Sciences of Ukraine\t\t",
"IZASK\ts\tInstitue of Zoology of the Kazakh Academy of Sciences\t\t",
"IZBE\ts\tInstitute of Zoology and Botany\t\t",
"IZBT\ts\tL'Institut de Zoologie et Botanique de Tartu\t\t",
"IZCAS\ts\tInstitute of Zoology, Chinese Academy of Sciences\tZMIOZ",
"IZCR\ts\tIstituto di Zoologia\t\t",
"IZEF\ts\tEge Ueniversitesi, Farmasoetik Botanik Kuersuesue\t\t",
"IZET-UCV<VEN>\ts\tInstituto de Zoologia y Ecologia Tropical\t\t",
"IZGAS\ts\tGeorgian Academy of Sciences, Insititute of Zoology\t\t",
"IZPAN\ts\tZoological Institute, Polish Academy of Sciences\t\t",
"IZPC\ts\tUniversidade do Porto\t\t",
"IZSI\ts\tIstituto di Zoologia\t\t",
"IZSSA\tc\tCollection of Experimental Zooprophylactic Institute of Sardinia (Istituto Zooprofilattico Sperimentale della Sardegna \"G.Pegreffi\", Sassari))\t\t",
"IZTA\ts\tUniversidad Nacional Autonoma de Mexico, Iztacala, Jefatura de Biologia\t\t",
"IZUA\ts\tUniversidad Austral de Chile, Instituto de Zoologia\t\t",
"IZUC\ts\tUniversidad de Concepcion, Instituto de Zoologia\t\t",
"IZUCS\ts\tUniversita DI Cagliari\t\t",
"IZUE\ts\tUniversitat -Erlangen-Nurnberg\t\t",
"IZUG\ts\tIstituto di Zoologia dell'Universita\t\t",
"IZUI\ts\tInstitut fuer Zoologie der Universitat Innsbruck\t\t",
"IZUM\ts\tIstituto di Zoologia dell'Universita\t\t",
"IZUP\ts\tIstituto di Zoologia dell'Universita\t\t",
"IZUW\ts\tInstitut fuer Zoologie der Universitat Wien\t\t",
"IZW\ts\tInstitut Zoologii\t\t",
"IZWU\ts\tPaleozology Department, Institute of Zoology, Worclaw University\t\t",
"J\ts\tUniversity of the Witwatersrand, Botany Department\t\t",
"JA\ts\tConsejeria de Medio Ambiente (Junta de Andalucia), Direccion General de Gestion del Medio Natural\t\t",
"JAC\ts\tUniversity of Jodhpur, Botany Department\t\t",
"JACA\ts\tInstituto Pirenaico de Ecologia, CSIC\t\t",
"JAEN\ts\tUniversidad de Jaen, Botanica\t\t",
"JAS\ts\tJiangxi Academy of Sciences\t\t",
"JATH\ts\tUniversity of Szeged\t\t",
"JAUM\ts\tJardin Botanico Joaquin Antonio Uribe\t\t",
"JAY\ts\tFondation Cognacq-Jay\t\t",
"JBAG\ts\tJardin Botanico Atlantico, Ayuntamiento de Gijon\t\t",
"JBB\th\tJardin Botanico Jose Celestino Mutis\t\t",
"JBC<MEX>\tb\tFrancisco Javier Clavijero Botanic Garden\tXAL",
"JBCC\th\tAlaska State Museum\t\t",
"JBG\ts\tJohannesburg Botanic Garden\t\t",
"JBGP\ts\tJardin Botanico Guillermo Pineres\t\t",
"JBL\ts\tJardin Botanico Lankester, Universidad de Costa Rica\t\t",
"JBN\ts\tJardin Botanico Nacional\t\t",
"JBSD\ts\tJardin Botanico Nacional Dr. Rafael M. Moscoso\t\t",
"JBVN\ts\tJardin Botanique de la Ville de Nice, Service des Espaces Verts\t\t",
"JBVPF\tsb\tJardin botanique de la Ville de Paris\t\t",
"JBWM\ts\tJ.B. Wallis Museum of Entomology\t\t",
"JCB\ts\tSt. Joseph's College\t\t",
"JCE\ts\tJiangxi College of Education, Biology Department\t\t",
"JCM\tc\tJapan Collection of Microorganisms\t\t",
"JCRB\tc\tJapanese Collection of Research Bioresources Cell Bank\t\t",
"JCT\tc\tJames Cook Townsville\t\t",
"JE\ts\tHerbarium Haussknecht, Jena\t\t",
"JEF\ts\tIndiana University Southeast, Biology Department\t\t",
"JEL\tc\tJoyce E. Longcore Chytrid Collection at the University of Maine\t\t",
"JEL<LVA>\ts\tLatvian Agricultural Academy, Plant Protection Department\t\t",
"JEPS\ts\tUniversity of California, Jepson Herbarium\t\t",
"JES\th\tUniversidad Autonoma Chapingo\t\t",
"JESW\ts\tJohn Evelyn Society's Museum\t\t",
"JEY\ts\tBoys' Grammar School, Victoria College\t\t",
"JF\ts\tJonkershoek Forestry Research Centre, Environment Affairs Department\t\t",
"JFBM\ts\tJames Ford Bell Museum of Natural History\t\t",
"JHH\ts\tNew York State Herbarium\t\t",
"JHS\th\tRegional Research Institute\t\t",
"JHWU\ts\tWittenberg University, Biology Department\t\t",
"JIC\tb\tJohn Innes Centre\t\t",
"JII\ts\tJohn Innes Institute\t\t",
"JIU\ts\tJishou University, Biology Department\t\t",
"JJF\ts\tJiujiang Forestry Institute\t\t",
"JJT\ts\tJiujiang Teachers College, Biology Department\t\t",
"JJU\ts\tJeonju University\t\t",
"JLFC\ts\tForestry College of Beihua University, Forestry Department\t\t",
"JLMP\ts\tJilin Academy of Traditional Chinese Medicine and Materia Medica\t\t",
"JM\ts\tJura Museum, Eichstatt\t\t",
"JME\th\tJura-Museum Eichstatt\t\t",
"JMM\ts\tEarlham College, Joseph Moore Museum\t\t",
"JMRC\tc\tJena Microbial Resource Collection\t\t",
"JMRC:SF\tc\tJena Microbial Resource Collection, Subcollection Fungi",
"JMSMC\ts\tJiamusi Medical College, Department of Pharmacy\t\t",
"JMUH\ts\tJames Madison University, Department of Biology\t\t",
"JN\ts\tJinggang Mountain Nature Reserve\t\t",
"JNR\ts\tJiulian Mountain Nature Reserve, Administration Department\t\t",
"JNU<CHN>\ts\tJi Nan University\t\t",
"JNU<KOR>\ts\tChonbuk National University, Faculty of Biological Sciences\t\t",
"JNUB\th\tJeju National University\t\t",
"JOE\ts\tUniversity of Joensuu, Biology Department\t\t",
"JOI\th\tUniversidade da Regiao de Joinville\t\t",
"JOMU\th\tJohn Muir National Historic Site\t\t",
"JONK\ts\tJonkershoek Herbarium\t\t",
"JOTR\th\tJoshua Tree National Park\t\t",
"JP\ts\tPhyletisches Museum Jena\t\t",
"JPB\ts\tUniversidade Federal da Paraiba, Cidade Universitaria, Departamento de Sistematica e Ecologia\t\t",
"JPMP\ts\tJanus Pannonius Museum\t\t",
"JPU\ts\tJanus Pannonius University, Botany Department\t\t",
"JRAU\ts\tUniversity of Johannesburg, Department of Botany and Plant Biotechnology\t\t",
"JROH\th\tJasper Ridge Biological Preserve, Stanford University\t\t",
"JRY\ts\tJersey College for Girls\t\t",
"JSHC\ts\tJay S. Haft Collection\t\t",
"JSMPE\ts\tJoint Soviet Mongolian Paleontolgical Expedition\tJRMPE",
"JSPC<CHN>\ts\tShandong University, Biology Department\t\t",
"JSPC<CZE>\ts\tJ. Rusek Collection\t\t",
"JSU\ts\tJacksonville State University, Biology Department\t\t",
"JSY\ts\tMuseum and Art Gallery of La Societe Jersiaise\t\t",
"JTNM\ts\tJoshua Tree National Monument\t\t",
"JTPC\ts\tColorado Entomological Museum (formerly John T. Polhemus collection)\t\t",
"JU\ts\tJinan University\t\t",
"JUA\ts\tUniversidad Nacional de Jujuy, Facultad de Ciencias Agrarias\t\t",
"JUG\ts\tJiwaji University, Botany Department\t\t",
"JUJ\ts\tHebei Agricultural University\t\t",
"JVC\ts\tJardin Botanico Canario Viera y Clavijo\t\t",
"JVR\ts\tUniversidad Nacional\t\t",
"JXAU\ts\tJiangxi Agricultural University, Forestry Department\t\t",
"JXCM\ts\tJiangxi College of Traditional Chinese Medicine, Pharmacy Department\t\t",
"JXF\ts\tJiangxi Forestry Institute\t\t",
"JXM\ts\tJiangxi Institute of Materia Medica\t\t",
"JXU\ts\tJiangxi University, Biology Department\t\t",
"JYV\ts\tUniversity of Jyvaeskylae, Natural History Department\t\t",
"K\tsb\tRoyal Botanic Gardens, Kew\t\t",
"K(M)\ts\tMycology Collection of Kew Royal Botanical Gardens\t\t",
"KA\ts\tVytautas Magnus University\t\t",
"KABA\ts\tUniversity of Kabul\t\t",
"KAC\tc\tKalmar Algae Collection\t\t",
"KACC\tc\tKorean Agricultural Culture Collection\t\t",
"KAG\ts\tKagoshima University Museum\t\t",
"KAGS\ts\tKagoshima University, Biology Department\t\t",
"KAI\ts\tHenan University, Biology Department\t\t",
"KAMA\ts\tYokohama University\t\t",
"KANA\ts\tKanazawa University\t\t",
"KAND\th\tKandalaksha State Nature Reserve\t\t",
"KANU\ts\tUniversity of Kansas\t\t",
"KAR\ts\tUniversity of Tehran, Horticulture Department\t\t",
"KARI\ts\tKenya Agricultural Research Institute\t\t",
"KARS\ts\tKawanda Agricultural Research Station\t\t",
"KAS\ts\tUniversitaet Gesamthochschule Kassel, Morphologie und Systematik der Pflanzen\t\t",
"KASH\ts\tUniversity of Kashmir\t\t",
"KASSEL\ts\tNaturkundemuseum im Ottoneum\t\t",
"KATH\ts\tDepartment of Plant Resources\t\t",
"KATO\ts\tKaradeniz Technical University, Department of Forest Botany\t\t",
"KATO:Fungi\ts\tKaradeniz Technical University, Department of Forest Botany, Fungi collection",
"KAUM\ts\tKagoshima University Museum\t\t",
"KAUM:I\ts\tKagoshima University Museum, Ichthyology Collection",
"KAW\ts\tKawanda Research Station, Department of Agriculture\t\t",
"KAZ\ts\tKazan State University\t\t",
"KB\ts\tNational Biological Resources Center, Department of Biological Sciences\t\t",
"KBAI\ts\tKuban Agricultural State University, Department of Biology and Ecology\t\t",
"KBG<JPN>\tb\tKyoto Botanical Garden\t\t",
"KBHG\ts\tH. M. Berbekov Kabardian-Balkarian State University, Department of Botany\t\t",
"KBRYO\ts\tCentre College of Kentucky\t\t",
"KBSMS\ts\tKellogg Biological Station, Michigan State University\t\t",
"KBT\ts\tStewarty Museum\t\t",
"KCCM\tc\tKorean Culture Center of Microorganisms, Department of Food Engineering\t\t",
"KCFS\ts\tKing's College\t\t",
"KCK\ts\tDick Institute\t\t",
"KCLB\tc\tKorean Cell Line Bank\t\t",
"KCOM\tc\tKorean Collection for Oral Microbiology\t\t",
"KCS\ts\tUniversity of London, King's College, Botany Department\t\t",
"KCTC\tc\tKorean Collection for Type Cultures\t\t",
"KDL\ts\tKendal Museum\t\t",
"KDR\ts\tBewdley Museum\t\t",
"KE\ts\tKent State University, Biological Sciences Department\t\t",
"KEF\ts\tKunming Edible Fungi Institute\t\t",
"KEI\ts\tUniversity of Transkei, Botany Department\t\t",
"KEIB\ts\tKatedra Ekologii i Biogeografii\t\t",
"KEIU\ts\tKorea University\t\t",
"KEM\ts\tUniversity of Kemerovo, Department of Botany\t\t",
"KEMC\tc\tKorea Environmental Microorganism Center, Kyonggi University\t\t",
"KEMH\tc\tKEMH/PMH Culture collection\t\t",
"KEN\ts\tLongwood Gardens, Horticulture Department\t\t",
"KEND\ts\tKendal Natural History Society\t\t",
"KEP\ts\tForest Research Institute Malaysia\t\t",
"KESC\ts\tKeene State College, Department of Biology\t\t",
"KEVO\ts\tUniversity of Turku\t\t",
"KF\th\tKerman University of Medical Sciences\t\t",
"KFBG\th\tKadoorie Farm and Botanic Garden\t\t",
"KFCC\tc\tKorean Federation of Culture Collection\t\t",
"KFI\ts\tHongnung Arboretum, Silviculture Department\t\t",
"KFRI\ts\tKerala Forest Research Institute\t\t",
"KFRS\ts\tKanudi Fisheries Research Station\t\t",
"KFTA\ts\tSaint Petersburg State S. M. Kirov Forest Technology Academy, Botany and Dendrology Department\t\t",
"KFUH\ts\tKing Faisal University, Chemistry and Botany Department\t\t",
"KG\th\tInternational Phytochemistry Research and Production Institute\t\t",
"KGU\ts\tGeology and Mineralogy Museum\t\t",
"KGY\ts\tCliffe Castle Art Gallery and Museum\t\t",
"KH\ts\tKorea National Arboretum\t\t",
"KHA\ts\tInstitute for Water and Ecology Problems, Far East Branch, Russian Academy of Sciences, Laboratory of Plant Ecology\t\t",
"KHD\ts\tKathryn Kalmbach Herbarium of Vascular Plants, Denver Botanic Gardens\t\t",
"KHER\ts\tKherson Pedagogical University, Botany Department\t\t",
"KHF\ts\tForest Research and Education Institute, Soba\t\t",
"KHMM\ts\tKultur Historisches Museum\t\t",
"KHMS\ts\tMuzeum `umavy\t\t",
"KHOR\ts\tPamir Biological Institute\t\t",
"KHU\ts\tUniversity of Khartoum, Botany Department\t\t",
"KHUG\ts\tAussenstelle der Universitaet\t\t",
"KHUS\ts\tKyung Hee University, Biology Department\t\t",
"KIEL\ts\tChristian-Albrechts-Universitaet Kiel\t\t",
"KIFB\ts\tKorean Institute of Freshwater Biology\t\t",
"KIOM\th\tKorea Institute of Oriental Medicine\t\t",
"KIP\th\tInstitut National pour l'Etude et la Recherche Agronomique\t\t",
"KIRI\ts\tUniversity of Rhode Island, Department of Biological Sciences\t\t",
"KIS\th\tUniversite de Kisangani\t\t",
"KISA\th\tInstitut Congolais  pour la Conservation de la Nature\t\t",
"KIT\tc\tLaboratorium voor Tropische Hygiene\t\t",
"KIUJ\ts\tKyusu University\t\t",
"KIZ\ts\tKunming Institute of Zoology, Chinese Academy of Sciences\t\t",
"KKFC<THA>\ts\tKasetsart  University Kamphaengsaen campus Fungus Collection\t\t",
"KKM\ts\tKirkleatham Museum\t\t",
"KKU\ts\tHerbarium, Department of Biology, Khon Kaen University\t\t",
"KKUA\ts\tKhon Kaen University\t\t",
"KKUK\ts\tKon-Kuk University\t\t",
"KL\ts\tLandesmuseum fuer Kaernten\t\t",
"KLA\ts\tHerbarium, Department of Agriculture, Malaysia\t\t",
"KLE\ts\tUniversity of Keele, Biological Sciences Department\t\t",
"KLGU\ts\tKaliningrad State University, Department of Botany and Plant Ecology\t\t",
"KLH\ts\tK. E. Tsiolkovsky Kaluga State Pedagogical University, Department of Botany and Ecology\t\t",
"KLN\ts\tLynn Museum and Art Gallery\t\t",
"KLU\ts\tUniversity of Malaya\t\t",
"KM<CAN>\ts\tKelowna Museum\t\t",
"KM<CZE>\ts\tSprava Krkonoaskeho narodniho parku\t\t",
"KM<POL>\ts\tMuzeum Przyrodnicze Uniwersytetu Jagiellonskiego\t\t",
"KM<RUS>\ts\tKotel'nich Museum\t\t",
"KMG\ts\tMcGregor Museum\t\t",
"KMK<MOL>\ts\tKraevedscheskii Musei Kishineva - Museum of Regional Study\t\t",
"KMK<ZAF>\ts\tKaffarian Museum\t\t",
"KMKV\ts\tKarlovarske muzeum\t\t",
"KMM\tc\tCollection of Marine Microorganisms\t\t",
"KMMA\ts\tRoyal Museum for Central Africa\tRMCA",
"KMMCC\tc\tKorea Marine Microalgae Culture Center\t\t",
"KMN\ts\tAdger Museum of Natural History and Botanical Garden, Botany Department\t\t",
"KMNH\ts\tKitakyushu Museum and Institute of Natural History, Botany Department\t\t",
"KMU\ts\tKarl-Marx-Universitat Leipzeg\t\t",
"KMV\ts\tKunming Municipal Museum\t\t",
"KMVC\ts\tKrajske Muzeum Vychodnich Cech\t\t",
"KNFY\ts\tKlamath National Forest, Resources Department\t\t",
"KNH\th\tKongju National University\t\t",
"KNHM\ts\tThe Educational Science Museum [=Kuwait Natural History Museum?]\t\t",
"KNK\ts\tNorthern Kentucky University, Department of Biological Sciences\t\t",
"KNL\ts\tKinneil Museum\t\t",
"KNOX\ts\tKnox College, Department of Biology\t\t",
"KNP\ts\tSouth African National Parks, Scientific Services\t\t",
"KNU\ts\tKyungpook National University, Biology Department\t\t",
"KNUC\ts\tKangweon National University\t\t",
"KNUH\ts\tKyung-Nam University, Biology Department\t\t",
"KNWR\ts\tKenai National Wildlife Refuge\t\t",
"KNWR:Ento\ts\tKenai National Wildlife Refuge, Entomology Collection",
"KNWR:Herb\ts\tKenai National Wildlife Refuge, Herbarium",
"KNY\ts\tLiterary and Scientific Institution of Kilkenny\t\t",
"KNYA\ts\tSelcuk Ueniversitesi, Biyoloji Boeluemue\t\t",
"KO\ts\tP. J. Safarik University\t\t",
"KOCH\ts\tKochi University, Department of Natural Environmental Science\t\t",
"KOELN\ts\tUniversitaet Koeln, Arbeitsgruppe Geobotanik und Phytotaxonomie\t\t",
"KOLABIC\ts\tKorean Lichen & Allied Bioresource Center\tKoLRI",
"KONL\ts\tBodensee-Naturmuseum\t\t",
"KOPRI\tc\tKorean Polar Research Institute\t\t",
"KOPRI:KCCPM\tc\tKorean Polar Research Institute, KOPRI Culture Collection of Polar Microorganisms",
"KOR\ts\tInstitute of Dendrology\t\t",
"KOS\tc\tCollection of Salmonella Microorganisms\t\t",
"KPABG\ts\tPolar-Alpine Botanical Garden-Institute, Department of Flora and Vegetation\t\t",
"KPBG\ts\tKings Park and Botanic Garden, Botanic Gardens and Parks Authority\t\t",
"KPE\ts\tKyungpook Earth, Kyungpook National University\t\t",
"KPM\ts\tKanagawa Prefectural Museum of Natural History\t\t",
"KPM-NI\ts\tKanagawa Prefectural Museum of Natural History\t\t",
"KPMC\ts\tKalamazoo, Kalamazoo Public Museum\t\t",
"KR\ts\tStaatliches Museum fuer Naturkunde Karlsruhe\t\t",
"KRA\ts\tJagiellonian University\t\t",
"KRAM\ts\tPolish Academy of Sciences, Department of Plant Systematics\t\t",
"KRAS\ts\tKrasnoyarsk State Pedagogical University, Department of Botany\t\t",
"KRB\th\tKebun Raya Bogor\t\t",
"KRDY\ts\tKirkcaldy Museum and Art Gallery\t\t",
"KRF\ts\tV. N. Sukachev Institute of Forest and Wood\t\t",
"KRG\ts\tWestfield Museum\t\t",
"KRIB\ts\tKorea Research Institute of Bioscience and Biotechnology, Plant Diversity Research Center\t\t",
"KRMS\ts\tSternwarte Kremsmuenster, Stift\t\t",
"KRP\tsb\tKebun Raya Purwodadi (Purwodadi Botanic Gardens, Indonesia)\t\t",
"KRSF\ts\tKoronivia Research Station\t\t",
"KRSU\ts\tKrasnoyarsk State University, Department of Biogeocoenology\t\t",
"KSAN\ts\tSouth African National Parks\t\t",
"KSBS\ts\tLawrence, University of Kansas, State Biological Survey of Kansas\t\t",
"KSC\ts\tKansas State University\t\t",
"KSEM\ts\tKansas Snow Entomological Museum\t\t",
"KSHS\ts\tKochi Senior High School\t\t",
"KSK\ts\tFitz Part Museum and Art Gallery\t\t",
"KSO\ts\tTweedside Physical and Antiquarian Society Museum\t\t",
"KSP\ts\tPittsburg State University, Biology Department\t\t",
"KSPI\th\tKostanay State Pedagogical Institute\t\t",
"KSRV\ts\tKhosrov State Reserve\t\t",
"KSTC\ts\tEmporia State University\t\t",
"KSU\ts\tKing Saud University, Botany and Microbiology Department\t\t",
"KSUC\ts\tKansas State University\tKSU",
"KSUP\ts\tKing Saud University\t\t",
"KTC\ts\tPedagogical University, Botany Department\t\t",
"KTG\ts\tKettering and District Naturalists' Society and Field Club\t\t",
"KTU\ts\tUniversity of Silesia, Department of Plant Systematics\t\t",
"KTUH\ts\tKuwait University, Botany and Microbiology Department\t\t",
"KU\ts\tUniversity of Kansas Natural History Museum\tKUMNA,KUVP,UK",
"KU-MACC\tc\tKobe University Macroalgal Culture Collection\t\t",
"KU:H\ts\tUniversity of Kansas Natural History Museum, Herpetology Collection",
"KU:I\ts\tUniversity of Kansas Natural History Museum, Ichthyology collection",
"KU:IP\ts\tUniversity of Kansas Natural History Museum, Invertebrate Paleontology Collection",
"KU:IT\tsb\tUniversity of Kansas Natural History Museum, Ichthyology tissue collection",
"KU:IZ\ts\tUniversity of Kansas Natural History Museum, Invertebrate Zoology Collection",
"KU:M\ts\tUniversity of Kansas Natural History Museum, Mammology Collection",
"KU:O\ts\tUniversity of Kansas Natural History Museum, Ornithology Collection",
"KU:PB\ts\tUniversity of Kansas Natural History Museum, Paleobotany Collection",
"KU:VP\ts\tUniversity of Kansas Natural History Museum, Vertebrate Paleontology Collection",
"KU<CHN>\ts\tKwangsi University\t\t",
"KUBL\ts\tYoshida College, Biological Laboratory\t\t",
"KUEC\ts\tKyushu University Entomology Collection\t\t",
"KUEL\ts\tKyushu University, Entomology Laboratory\t\t",
"KUFC\tc\tKasetsart University Fungus Collection\t\t",
"KUFF\ts\tDepartment of Forest Biology, Faculty of Forestry at Kasetsart University\t\t",
"KUFS\th\tKabul University\t\t",
"KUH\ts\tUniversity of Karachi, Botany Department\t\t",
"KUHE\ts\tKyoto University, Graduate School of Human and Environmental Studies\t\t",
"KUIC\ts\tKagoshima University\t\t",
"KUKENS\tc\tCentre for Research and Application of Culture Collections of Microorganisms\t\t",
"KUKI\ts\tKurukshetra University\t\t",
"KUM\ts\tResource Management Support Center\t\t",
"KUMA\ts\tKumamoto University, Biology Department\t\t",
"KUMF\ts\tKasetsart University Museum of Fisheries\t\t",
"KUN\ts\tKunming Institute of Botany, Chinese Academy of Sciences\t\t",
"KUNE\ts\tKunming Institute of Ecology, Academia Sinica\t\t",
"KUO\ts\tKuopio Natural History Museum\t\t",
"KURS\ts\tKursk State University, Department of Botany\t\t",
"KUS\ts\tKorea University, Biology Department\t\t",
"KUU\ts\tUniversity of Science and Technology\t\t",
"KUW\th\tKakatiya University\t\t",
"KUZ<JPN>\ts\tZoological Collection of the Kyoto University\t\t",
"KUZC\ts\tKyushu University, Zoological Collection\t\t",
"KVCH\ts\tKivach Nature Reserve\t\t",
"KW\ts\tNational Academy of Sciences of Ukraine\t\t",
"KWHA\ts\tUkrainian National Academy of Sciences\t\t",
"KWHU\th\tO. V. Fomin Botanical Garden of National Taras Schevchenko University of Kiev\t\t",
"KWNU\ts\tKangwon National University, Biology Department\t\t",
"KWP\ts\tKenelm W. Philip Collection, University of Alaska Museum of the North\t\t",
"KWP:Ento\ts\tKenelm W. Philip Collection, University of Alaska Museum of the North, Lepidoptera collection",
"KY\ts\tUniversity of Kentucky\t\t",
"KYM\ts\tUniversity of Helsinki, Kymenlaakso Society of Naturalists\t\t",
"KYO\ts\tKyoto University, Botany Department\t\t",
"KYUM<JPN>\ts\tKyushu University Museum\t\t",
"L\tsb\tNational Herbarium of the Netherlands (NHN)\t\t",
"LA\ts\tUniversity of California\t\t",
"LABCC\tc\tLactic acid bacteria culture collection\t\t",
"LAC\ts\tXian Institute of Lacquer\t\t",
"LACM\ts\tNatural History Museum of Los Angeles County\t\t",
"LACM:Crustacea\ts\tNatural History Museum of Los Angeles County, Crustacea Department",
"LACM:Echinoderms\ts\tNatural History Museum of Los Angeles County, Echinoderms Department",
"LACM:Entomology\ts\tNatural History Museum of Los Angeles County, Entomology Department",
"LACM:Herpetology\ts\tNatural History Museum of Los Angeles County, Section of Herpetology",
"LACM:Ichthyology\ts\tNatural History Museum of Los Angeles County, Ichthyology Department",
"LACM:Malacology\ts\tNatural History Museum of Los Angeles County, Malacology Department",
"LACM:Mammalogy\ts\tNatural History Museum of Los Angeles County, Mammalogy Department",
"LACM:Ornithology\ts\tNatural History Museum of Los Angeles County, Ornithology Department",
"LAE\ts\tPapua New Guinea Forest Research Institute\t\t",
"LAF\ts\tUniversity of Louisiana at Lafayette, Biology Department\t\t",
"LAGO\ts\tPacific Northwest Forest and Range Experiment Station\t\t",
"LAGU\ts\tAsociacion Jardin Botanico La Laguna, Urbanizacion Plan de La Laguna\t\t",
"LAH\ts\tUniversity of the Punjab, Botany Department\t\t",
"LAJC\ts\tOtero Junior College, Biology Department\t\t",
"LAM\ts\tNatural History Museum of Los Angeles County, Botanical Studies\t\t",
"LAME\ts\tLake Mead National Recreation Area\t\t",
"LAMU\ts\tLamar University, Biology Department\t\t",
"LAN\ts\tLancing College, Biology Department\t\t",
"LANC\ts\tUniversity of Lancaster, Department of Biological Sciences\t\t",
"LAPC\ts\tPierce College, Life Sciences Department\t\t",
"LAPL\ts\tLapland State Biosphere Reserve\t\t",
"LARRI\ts\tLiving Aquatic Resources Research Institute\t\t",
"LASCA\ts\tThe Los Angeles County Arboretum\t\t",
"LAT\ts\tSaint Vincent College, Biology Department\t\t",
"LATV\ts\tUniversity of Latvia, Laboratory of Botany\t\t",
"LAU\ts\tMusee et Jardins Botaniques Cantonaux\t\t",
"LAUN\ts\tLaunceston College\t\t",
"LAUS\ts\tLaunceston Museum\t\t",
"LAV\ts\tDauntsey's School\t\t",
"LAVO\ts\tLassen Volcanic National Park\t\t",
"LBC\ts\tUniversity of the Philippines at Los Banos\t\t",
"LBG<CHE>\tc\tInstitute for Agricultural Bacteriology and Fermentation Biology\t\t",
"LBG<CHN>\ts\tLushan Botanical Garden\t\t",
"LBIT\ts\tLaboratoire de Biologie des Insectes\t\t",
"LBL\ts\tM. Curie-Sklodowska University, Department of Biology and Earth Science\t\t",
"LBLC\ts\tM. Curie-Sklodowska University\t\t",
"LBM<BRA>\tc\tLaboratorio de Biologia Molecula Depto de Biologia Celular\t\t",
"LBM<JPN>\ts\tLake Biwa Museum\t\t",
"LBN\ts\tLembaga Biologi Nasional\t\t",
"LBRP\ts\tLaboratorio de Biodiversidade de Recursos Pesqueiros\t\t",
"LBUCH\ts\tLaboratorio de Biologia\t\t",
"LBV\ts\tCENAREST\t\t",
"LC\th\tLewis & Clark College\t\t",
"LCC<CAN>\tc\tLabatt Culture Collection, Technology Development\t\t",
"LCC<POL>\tc\tUniversity of Warmia and Mazury in Olsztyn\t\t",
"LCDI\ts\tLuther College, Biology Department\t\t",
"LCEU\ts\tLane Community College\t\t",
"LCF\ts\tI.N.T.A.\t\t",
"LCFM\ts\tMusee d'Histoire Naturelle\t\t",
"LCG\ts\tLeamington College for Girls\t\t",
"LCH\ts\tLetchworth Museum and Art Gallery\t\t",
"LCM\ts\tUniversidad de Chile, Laboratorio de Citogenetica de Mamiferos\t\t",
"LCMI\ts\tLoyola College\t\t",
"LCN\ts\tLincoln City and County Museum\t\t",
"LCO\ts\tInternational Red Locust Control Organization for Central and Southern Africa\t\t",
"LCP\tc\tFungal Strain Collection, Laboratory of Cryptogamy\t\t",
"LCR\ts\tRatcliffe College\t\t",
"LCS\ts\tInternational Red Locust Control Service\t\t",
"LCU\ts\tCatholic University of America\t\t",
"LCVA\ts\tLakeland College, Environmental Sciences Department\t\t",
"LD\ts\tBotanical Museum, Lunds University\t\t",
"LDL\ts\tLudlow Museum\t\t",
"LDM\ts\tLatvian Natural Histotry Museum, department of Entomology\t\t",
"LDPC\ts\tL. Deharveng, Universite Paul Sabatier\t\t",
"LDS\ts\tUniversity of Leeds\t\t",
"LDSN\ts\tLeeds Naturalists' Club\t\t",
"LDSP\ts\tLeeds Philosophical and Literary Society Museum\t\t",
"LE<BRA>\tc\tServico de Microbiologia e Imunologia\t\t",
"LE<RUS>\ts\tV. L. Komarov Botanical Institute\t\t",
"LEA\ts\tUniversity of Lethbridge, Biological Sciences Department\t\t",
"LEB<ESP>\ts\tUniversidad de Leon, Departamento de Biologia, Botanica\t\t",
"LEB<LVA>\ts\tEntomological Society of Latvia\t\t",
"LEC\ts\tUniversita degli Studi di Lecce, Dipartimento di Biologia\t\t",
"LECB\ts\tSaint Petersburg State University, Botany Department\t\t",
"LEDLIE\th\tPatricia Ledlie Herbarium\t\t",
"LEF\ts\tEconomic Forestry Institute of Liaoning Province\t\t",
"LEH\th\tLehigh University\t\t",
"LEI\ts\tLeicester Literary and Philosophical Society\t\t",
"LeishCryoBank\tc\tInternational Cryobank of Leishmania\t\t",
"LEIUG\ts\tDepartment of Geology Leicester University\t\t",
"LEMA\ts\tUniversite du Maine\t\t",
"LEMQ\ts\tLyman Entomological Museum, McGill University,\tLEM",
"LEMT\ts\tEge University, Lodos Entomological Museum\t\t",
"LENUD\ts\tLenin University of Dagestan, Botany Department\t\t",
"LEP\ts\tAll-Union Institute for Plant Protection\t\t",
"LES\ts\tLeeds City Museum, Natural History Department\t\t",
"LET\ts\tLetchworth Naturalist's Society\t\t",
"LEUN\ts\tBischoefliches Gymnasium Josephinum\t\t",
"LEV\ts\tMinistry of Agriculture and Fisheries, Plant Protection Centre\t\t",
"LEYN\ts\tLeyton Reference Library\t\t",
"LFBKU\ts\tLaboratory of Fishery Biology\t\t",
"LFCC\ts\tLord Fairfax Community College, Natural Resources Department\t\t",
"LFG\ts\tCentre de Recherche de la Nature, des Forets et du Bois\t\t",
"LFM\ts\tMerseyside County Museums (formerly Liverpool Free Museum)\t\t",
"LG\ts\tUniversite de Liege, Departement de Botanique\t\t",
"LGBH\ts\tLoughborough Public Library\t\t",
"LGEMA<BRA>\ts\tLaboratorio de Genetica e Evolucao Molecular de Aves, Universidade de Sao Paulo\t\t",
"LGHF\ts\tUniversite de Liege\t\t",
"LGICT\ts\tLaboratoire de Geologie de l'Institut Catholique de Toulouse\t\t",
"LGM\ts\tLeningrad School of Mines\t\t",
"LGM-USP\tc\tDepartamento de Microbiologia Lab. de Genetica de Microrganismos\t\t",
"LGO\ts\tColumbia University\t\t",
"LGPUT\ts\tLaboratory of Geology and Palaeontology\t\t",
"LGU\ts\tLeningrad State University\t\t",
"LHMS<ZAF >\tb\tLeslie Hill Molecular Systematics Laboratory\t\t",
"LHT\ts\tLahti City Museum\t\t",
"LI\ts\tOberoesterreichischen Landesmuseums, Botanische Abteilung\t\t",
"LI:EVAR\ts\tOberoesterreichischen Landesmuseums, Botanische Abteilung, Evertebrata Varia (Invertebrates other than Insects)",
"LI:INS\ts\tOberoesterreichischen Landesmuseums, Botanische Abteilung, Insect collection",
"LI:VERT\ts\tOberoesterreichischen Landesmuseums, Botanische Abteilung, Vertebrate collection",
"LIA\tc\tCryobank of Microorganisms\t\t",
"LIAIP\ts\tLaboratory of Ichthyology\t\t",
"LIB\ts\tUniversity of Liberia\t\t",
"LICPP\ts\tThe Crown Prince's Palace\t\t",
"LIG\ts\tSociedade de Geografia de Lisboa\t\t",
"LIH-UNAM\tc\tCulture Collection of Histoplasma capsulatum Strains from the Fungal Immunology Laboratory of the Department of Microbiology and Parasitology, Faculty of Medicine, UNAM\t\t",
"LIHUBA\ts\tUniversidad de Buenos Aires, Laboratorio de Investigaciones Herpetologicas\t\t",
"LIL\ts\tFundacion Miguel Lillo\t\t",
"LILLE\ts\tInstitut Catholique de Lille, Laboratoire de Biologie Vegetale\t\t",
"LIM\ts\tSeveroceske muzeum\t\t",
"LIMFC\ts\tLimerick Field Club\t\t",
"LIMK\ts\tLimerick Museum\t\t",
"LIMO\th\tUniversite de Limoges\t\t",
"LIN-SB\tc\tLimnological Institute, Siberian Branch, Russian Academy of Sciences\t\t",
"LINC\ts\tLincoln University, Plant Sciences Group\t\t",
"LINCO\th\tLinfield College\t\t",
"LINF\ts\tShanxi Normal University, Biology Department\t\t",
"LINHM\ts\tLong Island Natural History Museum\t\t",
"LINN\ts\tLinnean Society of London\t\t",
"LIP\ts\tUniversite de Lille, Departement de Botanique\t\t",
"LIPIMC\tc\tLembaga Ilmu Pengetahuan Indonesia, Indonesian Institute for Sciences\t\t",
"LIPP\tc\tLeptospirotheque\t\t",
"LIRP\ts\tLaboratorio de Ictiologia, Faculdade de Filosofia\t\t",
"LISC\ts\tInstituto de Investigacao Cientifica Tropical\t\t",
"LISE\ts\tEstacao Agronomica Nacional\t\t",
"LISFA\ts\tInstituto Nacional de Investigacao Agraria, Departamento Ecologia, Recursos Naturais e Ambiente\t\t",
"LISI\ts\tInstituto Superior de Agronomia\t\t",
"LISJC\ts\tJardim-Museu Agricola Tropical\t\t",
"LISM\ts\tMissao de Estudos Agronomicos do Ultramar\t\t",
"LISU\ts\tMuseu Nacional de Historia Natural\t\t",
"LISVA\ts\tMinisterio da Educacao\t\t",
"LIT\ts\tOkresni vlastivedne muzeum\t\t",
"LIUSP<BRA>\ts\tLaboratorio de Ictiogenetica, Universidade de Sao Paulo\t\t",
"LIV\ts\tLiverpool Museum\t\t",
"LIVC\ts\tLiverpool Botanic Garden\t\t",
"LIVCM\ts\tLiverpool County Museum\t\t",
"LIVNFC\ts\tLiverpool Naturalists' Field Club\t\t",
"LIVU\ts\tHartley Botanical Laboratories\t\t",
"LJC\tc\tColeccion de fitopatogenos de cultivos horticolas\t\t",
"LJF\th\tSlovenian Forestry Institute\t\t",
"LJM\ts\tPrirodoslovni Muzej Slovenije\t\t",
"LJS\th\tScientific Research Centre\t\t",
"LJU\ts\tUniversity of Ljubljana, Botany Department\t\t",
"LKHD\ts\tLakehead University, Biology Department\t\t",
"LL\ts\tUniversity of Texas at Austin, Plant Resources Center\t\t",
"LLANOS\th\tUniversidad de los Llanos\t\t",
"LLC\ts\tOur Lady of the Lake University, Biology Department\t\t",
"LLN\ts\tLincolnshire Naturalists' Union\t\t",
"LLO\ts\tLloyd Library and Museum\t\t",
"LM\ts\tSeccao de Botanica e Ecologia\t\t",
"LMA\ts\tNational Institute of Agronomic Research, Botany Department\t\t",
"LMAD\ts\tLobbecke Museum und Aquazoo\t\t",
"LMC\ts\tInstituto de Investigacao Cientifica de Mozambique\t\t",
"LMCH\tc\tLaboratoire de Microbiologie\t\t",
"LMD\tc\tLaboratorium voor Microbiologie der Landbouwhogeschool\t\t",
"LMG\tc\tBelgian Coordinated Collections of Microorganisms/ LMG Bacteria Collection\tBCCM/LMG",
"LMJ<AUT>\ts\tLandesmuseum Joanneum Graz\t\t",
"LMJ<MOZ>\ts\tCentro de Investigacao Cientifica Algodoeira, Botanical Department\t\t",
"LMKG\ts\tLandesmuseum fur Karnten\t\t",
"LMND\ts\tLandessammlungen fuer Naturkunde\t\t",
"LMNH\ts\tMuseum d'Histoire naturelle\t\t",
"LMO\th\tLandesmuseum Natur und Mensch\t\t",
"LMRZ\ts\tLivingstone Museum\t\t",
"LMS\tc\tCarolina Biological Supply Company\t\t",
"LMSZ\ts\tLatvian University, Museum of Systemic Zoology\t\t",
"LMU\ts\tEduardo Mondlane University, Department of Biological Sciences\t\t",
"LMZG\ts\tLocal Museum\t\t",
"LNAF\ts\tLiaoning Academy of Forestry\t\t",
"LNAU\th\tLuhansk National Agrarian University\t\t",
"LNCM\ts\tLiaoning College of Traditional Chinese Medicine\t\t",
"LNCN\th\tLincoln Memorial University\t\t",
"LNHS\ts\tLondon Natural History Society\t\t",
"LNK\ts\tLandessammlungen fuer Naturkunde\t\t",
"LNKD\ts\tLandessammlung fuer Naturkunde\t\t",
"LNMD\ts\tLandessammlungen fuer Naturkunde\t\t",
"LNMO\ts\tOldenburg, Landesmuseum Natur und Mensch\t\t",
"LNNU\ts\tLiaoning Normal University, Biology Department\t\t",
"LNPV<FRA>\tc\t Laboratoire National de la Protection des Vegetaux\t\t",
"LO\ts\tType Collection\t\t",
"LOB\ts\tCalifornia State University, Biological Sciences Department\t\t",
"LOC\ts\tOccidental College, Biology Department\t\t",
"LOCK\tc\tCentre of Industrial Microorganisms Collection\t\t",
"LOD\ts\tLodz University, Department of Geobotany and Plant Ecology\t\t",
"LOJA\ts\tUniversidad Nacional de Loja, Departamento de Botanica y Ecologia\t\t",
"LOMA\ts\tLa Sierra University, Biology Department\t\t",
"LON\ts\tLembaga Oseanologie Nasional\t\t",
"LOU\ts\tC.I.T.A.-Xunta de Galicia\t\t",
"LP<ARG>\ts\tMuseo de La Plata, Herbario\t\t",
"LP<RUS>\ts\tLaboratory of Palaeontology\t\t",
"LPA\ts\tJardin Botanico Canario Viera y Clavijo\t\t",
"LPAG\ts\tUniversidad Nacional de La Plata, Area de Botanica\t\t",
"LPB\ts\tHerbario Nacional de Bolivia\t\t",
"LPC\th\tMuseo de La Plata\t\t",
"LPD\ts\tLaboratorio de Botanica de la Direccion de Agricultura\t\t",
"LPFU\ts\tLehrstuhl fur Palaontologie\t\t",
"LPL\ts\tThe University\t\t",
"LPN\ts\tLittlehampton Museum\t\t",
"LPS\ts\tUniversidad Nacional de La Plata, Instituto de Botanica Carlos Spegazzini\t\t",
"LPSC\tc\tLa Plata Spegazzini Collection\t\t",
"LPSP\ts\tLumus Pond State Park, Whale Wallow Nature Center\t\t",
"LPUB\ts\tLaboratorul de Paleontologie\t\t",
"LPUP\ts\tLaboratoire de Parasitologie\t\t",
"LPVM\ts\tLaboratoire de Paleontologie des Vertebres et de Paleontologie\t\t",
"LPVPH\ts\tLaboratoire de Paleontologie des Vertebres et de Paleontologie Humaine\t\t",
"LR\ts\tMuseum d'Histoire Naturelle\t\t",
"LRL\ts\tHistoric Society of Lancashire and Cheshire\t\t",
"LRS\ts\tAgriculture Research Center, Land Resource Sciences Section\t\t",
"LRTE\ts\tLa Retraite (Convent School)\t\t",
"LRU\ts\tUniversity of Arkansas at Little Rock, Biology Department\t\t",
"LS<CUB>\ts\tColegio de La Salle\t\t",
"LS<GBR>\ts\tLinnean Society of London\tLSUK",
"LSA\ts\tLytham St. Annes Public Library\t\t",
"LSAM\ts\tLouisiana State Arthropod Museum\t\t",
"LSC\ts\tLyndon State College, Natural Sciences Department\t\t",
"LSCR\ts\tOrganization for Tropical Studies, La Selva Biological Station\t\t",
"LSDC\ts\tLiangshan Institute for Drug Control\t\t",
"LSHB\tc\tBiochemistry Department\t\t",
"LSHI\ts\tUniversite Nationale du Zaire\t\t",
"LSN\ts\tLord Wandsworth College Natural History Museum\t\t",
"LSP\ts\tLake Superior Provincial Park\t\t",
"LSR\ts\tLeicestershire Museums Service\t\t",
"LSRFC\ts\tLeicestershire Flora Committee\t\t",
"LSSC\ts\tLake Superior State College\t\t",
"LSTM\tc\tDepartment of Parasitology\t\t",
"LSU\ts\tLouisiana State University, Biological Sciences Department\t\t",
"LSUHC\ts\tLa Sierra University, Herpetological Collection\t\t",
"LSUM\ts\tLouisiana State University, Biological Sciences Department\t\t",
"LSUMZ\ts\tLouisiana State University, Musuem of Zoology\tLSUMNS",
"LSUMZ:FrozenTissue\ts\tLouisiana State University, Musuem of Zoology, Frozen Tissue Collection",
"LSUMZ:Herpetology\ts\tLouisiana State University, Musuem of Zoology, Herpetology Collection",
"LSUMZ:Ichthyology\ts\tLouisiana State University, Musuem of Zoology, Ichthyology Collection",
"LSUMZ:Mammalogy\ts\tLouisiana State University, Musuem of Zoology, Mammal Collection",
"LSUMZ:Ornithology\ts\tLouisiana State University, Musuem of Zoology, Bird Collection",
"LSUS\ts\tMuseum of Life Sciences, Louisiana State University\t\t",
"LT\ts\tUniversite de Montreal\t\t",
"LTB\ts\tLa Trobe University, Botany Department\t\t",
"LTCC-IOC\tc\tLeishmania Type Culture Collection\t\t",
"LTH\ts\tMuseum of Louth Naturalists' Antiquity and Literary Society\t\t",
"LTHP\ts\tLouth Public Library\t\t",
"LTI\tc\tCryobank of Microorganisms-Destructors\t\t",
"LTM\ts\tTekovske muzeum\t\t",
"LTN\ts\tLuton Museum and Art Gallery\t\t",
"LTR\ts\tUniversity of Leicester, Biology Department\t\t",
"LTU\ts\tLouisiana Tech University\t\t",
"LU<CHN>\ts\tLingnan University\t\t",
"LU<RUS>\ts\tSt. Petersburg University\t\t",
"LUA\ts\tInstituto de Investigacao Agronomica\t\t",
"LUAI\ts\tex-Centro Nacional de Investigacao Cientifica (CNIC)\t\t",
"LUB\ts\tNaturhistorisches Museum zu Luebeck\t\t",
"LUBA\ts\tInstituto Superior de Ciencias da Educacao\t\t",
"LUBEE\tb\tLubee Bat Conservancy\t\t",
"LUCAS\ts\tFrancesc de Lucas i Alcover\t\t",
"LUCCA\ts\tComune di Lucca\t\t",
"LUCH\ts\tMusee du Pays de Luchon\t\t",
"LUD\ts\tLudlow Natural History Society\t\t",
"LUG\ts\tMuseo cantonale di storia naturale\t\t",
"LUGO\ts\tUniversidad de Satniago de Compostela, Departamento de Produccion Vegetal\t\t",
"LUH\ts\tUniversity of Lagos, Department of Botany\t\t",
"LUH<NLD>\tc\tLeiden University Medical Center\t\t",
"LUKI\th\tInstitut National pour l'Etude et la Recherche Agronomiques\t\t",
"LUNZ\ts\tLincoln University Entomology Research Museum\t\t",
"LUQ\ts\tLaval University\t\t",
"LUS\ts\tLushan Botanical Garden\t\t",
"LUSC\th\tUniversidade do Estado de Santa Catarina\t\t",
"LUW\ts\tLandbouwuniversiteit Wageningen, Department of Entomology\t\t",
"LUX\ts\tMusee national d'histoire naturelle\t\t",
"LV\ts\tCatholic University of Leuven, Laboratory of Plant Systematics\t\t",
"LVNP\ts\tLassen Volcanic National Park\t\t",
"LVP-GSC\ts\tLaboratory of Vertebrate Paleontology\t\t",
"LW\ts\tIvan Franko National University of Lviv, Botany Department\t\t",
"LWA\ts\tAgricultural Experiment Station\t\t",
"LWD\ts\tMuseum Dzieduszyckich\t\t",
"LWG\ts\tNational Botanical Research Institute\t\t",
"LWI\th\tCentre de Recherche en Sciences Naturelles (CRSN/Lwiro)\t\t",
"LWKS\ts\tInstitute of Ecology of the Carpathians\t\t",
"LWL<DEU>\ts\tLWL-Museum fuer Naturkunde\t\t",
"LWL<DEU>:DNA\tb\tLWL-Museum fuer Naturkunde, LWL-DNA- und Gewebearchiv",
"LWS\ts\tMuseum of Natural History, Lviv\t\t",
"LWSM\ts\tLewes Museum, Ann of Cleves House\t\t",
"LWU\ts\tUniversity of Lucknow, Botany Department\t\t",
"LY\tsc\tUniversite Claude Bernard\t\t",
"LYAC\ts\tLaiyang Agricultural College, Department of Basic Courses\t\t",
"LYCC\tc\tLallemand Yeast Culture Collection\t\t",
"LycoCC\tc\tThe Lycoming College Culture Collection\t\t",
"LYD\ts\tMpumalanga Parks Board\t\t",
"LYJB\ts\tJardin Botanique de Lyon\t\t",
"LYN\ts\tLynchburg College, Biology Department\t\t",
"LZ\ts\tUniversitaet Leipzig\t\t",
"LZAH\ts\tLanzhou Institute of Animal Science, Chinese Academy of Agricultural Sciences\t\t",
"LZD\ts\tLanzhou Institute of Desert Research, Academia Sinica\t\t",
"LZFD\ts\tLaboratoire Zoologique\t\t",
"LZLP\ts\tUniversidade de Lisboa\t\t",
"LZU\ts\tLanzhou University\t\t",
"LZUH\ts\tLaboratoire de Zoologie, Universite de Hanoi\t\t",
"M\ts\tBotanische Staatssammlung Muenchen\t\t",
"MA\ts\tReal Jardin Botanico\t\t",
"MA:Algae\ts\tReal Jardin Botanico, Algae collection",
"MA:Fungi\ts\tReal Jardin Botanico, Fungi collection",
"MA:FunHist\ts\tReal Jardin Botanico, Historical fungi colleciton",
"MA:Hepat\ts\tReal Jardin Botanico, Liverwort collection",
"MA:Lichen\ts\tReal Jardin Botanico, Lichen collection",
"MA:Musci\ts\tReal Jardin Botanico, Bryophyte collection",
"MAA\ts\tEscuela Tecnica Superior de Ingenieros Agronomos, Departamento de Produccion Vegetal\t\t",
"MAAS\ts\tNatuurhistorisch Museum Maastricht, Botany Department\t\t",
"MAC\ts\tInstituto do Meio Ambiente\t\t",
"MAC-APU\ts\tMinisterio de Agricultura y Cria\t\t",
"MAC-PAY\ts\tMinisterio de Agricultura y Cria\t\t",
"MACA\ts\tParque da Reserva de Siac Pai van Coloane Island\t\t",
"MACB\ts\tUniversidad Complutense, Departamento de Biologia Vegetal 1\t\t",
"MACF\ts\tCalifornia State University, Biological Science Department\t\t",
"MACLPI\ts\tMinisterio de Agricultura y Cria, Seccion de Pesca Interior y Piscicultura\t\t",
"MACN\ts\tMuseo Argentino de Ciencias Naturales Bernardino Rivadavia\t\t",
"MACN-RN\ts\tMuseo Argentino de Cicencis Naturales, Coleccion Rio Negro\t\t",
"MACNCH\ts\tMuseo Argentino de Ciencias Naturales\t\t",
"MACO\ts\tMarlborough College, Biology Department\t\t",
"MAD<IND>\ts\tMadras Museum\t\t",
"MAD<USA-WI>\ts\tForest Products Laboratory\t\t",
"MADJ\ts\tJardim Botanico da Madeira\t\t",
"MADM\ts\tMuseu Municipal do Funchal\t\t",
"MADS\ts\tMuseu de Historia Natural do Seminario do Funchal\t\t",
"MAF\ts\tUniversidad Complutense, Departamento de Biologia Vegetal II\t\t",
"MAFF\tc\tMAFF Genebank, Ministry of Agriculture Forestry and Fisheries\t\t",
"MAFF<FJI>\ts\tColo-i-Suva Silvicultural Station\t\t",
"MAFI\ts\tMagyar Allami Foeldtani Intezet, Budapest - Hungarian Geological Survey\t\t",
"MAFST\ts\tInstituto Forestal de la Moncloa\t\t",
"MAG\ts\tInstitute of Biological Problems of the North\t\t",
"MAGB\ts\tNational Museum and Art Gallery, Gaberone\t\t",
"MAGD\ts\tNorthern Territory Museum of Arts and Sciences\t\t",
"MAGNT<AUS>\ts\tMuseums and Art Galleries of the Northern Territory\tNTM<AUS>",
"MAGNT<AUS>:A\ts\tMuseums and Art Galleries of the Northern Territory, Arachnid Collection",
"MAGNT<AUS>:C\ts\tMuseums and Art Galleries of the Northern Territory, Cnidarian Collection",
"MAGNT<AUS>:Cr\ts\tMuseums and Art Galleries of the Northern Territory, Crustacean Collection",
"MAGNT<AUS>:D\ts\tMuseums and Art Galleries of the Northern Territory, Minor Invertebrate Collection",
"MAGNT<AUS>:E\ts\tMuseums and Art Galleries of the Northern Territory, Ascidian Collection",
"MAGNT<AUS>:G\ts\tMuseums and Art Galleries of the Northern Territory, Bryozoan Collection",
"MAGNT<AUS>:I\ts\tMuseums and Art Galleries of the Northern Territory, Insect Collection",
"MAGNT<AUS>:M\ts\tMuseums and Art Galleries of the Northern Territory, Myriapod Collection",
"MAGNT<AUS>:N\ts\tMuseums and Art Galleries of the Northern Territory, Pycnogonid Collection",
"MAGNT<AUS>:P\ts\tMuseums and Art Galleries of the Northern Territory, Malacology Collection",
"MAGNT<AUS>:Q\ts\tMuseums and Art Galleries of the Northern Territory, Echinoderm Collection",
"MAGNT<AUS>:R\ts\tMuseums and Art Galleries of the Northern Territory, Herpetology Collection",
"MAGNT<AUS>:S\ts\tMuseums and Art Galleries of the Northern Territory, Fish Collection",
"MAGNT<AUS>:T\ts\tMuseums and Art Galleries of the Northern Territory, Bird Collection",
"MAGNT<AUS>:U\ts\tMuseums and Art Galleries of the Northern Territory, Mammal Collection",
"MAGNT<AUS>:W\ts\tMuseums and Art Galleries of the Northern Territory, Annelid Collection",
"MAGNT<AUS>:Z\ts\tMuseums and Art Galleries of the Northern Territory, Poriferan Collection",
"MAH\ts\tDepartment of Agricultural Research\t\t",
"MAIA\ts\tInstituto Nacional de Investigaciones Agrarias, Departamento de Ecologia\t\t",
"MAIC\ts\tMediterranean Agronomic Institute of Chania, Department of Natural Products\t\t",
"MAINE\ts\tUniversity of Maine, Department of Biological Sciences\t\t",
"MAIS\ts\tInstitut d'Elevage et de Medecine Veterinaire des Pays Tropicaux, Departement de Botanique\t\t",
"MAK\ts\tTokyo Metropolitan University\t\t",
"MAKAR\ts\tInstitut Planina i More\t\t",
"MAKFUNGI\ts\tFungi Macedonici\t\t",
"MAL\ts\tBotanic Gardens of Malawi\t\t",
"MALA\ts\tMalaspina University, Biology Department\t\t",
"MALC\ts\tMuseu Municipal de la Vila d'Alcover\t\t",
"MALS\ts\tManti-LaSal National Forest\t\t",
"MAMU\ts\tUniversity of Sydney, Macleay Museum\t\t",
"MAN\ts\tUniversitas Cenderawasih\t\t",
"MANCH\ts\tUniversity of Manchester\t\t",
"MAND\ts\tAgricultural College and Research Institute\t\t",
"MANK\ts\tMinnesota State University-Mankato, Department of Biological Sciences\t\t",
"MAO\tc\tMircen Afrique Ouest\t\t",
"MAPA\ts\tMuseu Anchieta Porto Alegra\t\t",
"MAPR\ts\tUniversity of Puerto Rico, Mayagueez Campus, Biology Department\t\t",
"MAR\tc\tGrasslands Rhizobium Collection\t\t",
"MARDI\th\tMalaysian Agricultural Research and Development Institute\t\t",
"MARE\ts\tMarmara University, Department of Pharmaceutical Botany\t\t",
"MARI\th\tMari State University\t\t",
"MARK\th\tCadi Ayyad University\t\t",
"MARO\ts\tMarylhurst College\t\t",
"MARS\ts\tUniversite de Provence Centre St-Charles, case 4\t\t",
"MARSSJ\ts\tUniversite Paul Cezanne\t\t",
"MARY\ts\tUniversity of Maryland\t\t",
"MASE\ts\tMaseru Experiment Station\t\t",
"MASS\ts\tUniversity of Massachusetts, Biology Department\t\t",
"MATSU\ts\tEhime University, Forestry Department\t\t",
"MAU\ts\tMauritius Sugar Industry Research Institute\t\t",
"MAUAM\th\tUniversidad Autonoma de Madrid\t\t",
"MAY\ts\tAdygean State University, Department of Botany\t\t",
"MB<DEU-Berlin>\ts\tMuseum of Natural History of Humboldt-University\t\t",
"MB<DEU-Marburg>\ts\tPhilipps-Universitaet, Spezielle Botanik\t\t",
"MB<PRT>\ts\tUniversidade de Lisboa, Museu Bocage\t\t",
"MBA\ts\tEnvironmental Protection Agency\t\t",
"MBAB\ts\tMuseo Biblioteca Archivio\t\t",
"MBAC\ts\tMuseo del Dipartimento di Biologia Animale dell'Universita\t\t",
"MBAP\ts\tMuseo del Dipartimento di Biologia Animale dell'Universita\t\t",
"MBBJ\ts\tMuseum Zoologicum Bogoriense, Entomology Collection\t\t",
"MBC\tsb\tMontgomery Botanical Center\tMBC<USA>",
"MBCG\ts\tMuseo di Scienze Naturali \"Enrico Caffi\"\t\t",
"MBCSC\ts\tMarine Biodiversity Collection of South China Sea, Chinese Academy of Sciences\t\t",
"MBCSC:Fish\ts\tMarine Biodiversity Collection of South China Sea, Chinese Academy of Sciences, Fish Collection",
"Mbg\ts\tFachberich Geowissenschaften\t\t",
"MBH\ts\tMarlborough College\t\t",
"MBIC\tc\tMarine Biotechnology Institute Culture Collection\t\t",
"MBK\ts\tKochi Prefectural Makino Botanical Garden, Botany Department\t\t",
"MBL\ts\tMuseu Nacional de Historia Natural\t\t",
"MBLUZ\ts\tMuseo de Biologia de la Universidad del Zulia\t\t",
"MBM<BRA>\ts\tMuseu Botanico Municipal\t\t",
"MBM<USA-CA>\ts\tSan Jose State University, Museum of Birds and Mammals\t\t",
"MBM<USA-NV>\ts\tMarjorie Barrick Museum\t\t",
"MBML\ts\tMuseu de Biologia Mello Leitao\t\t",
"MBMU\tc\tInstitute of Molecular Biology and Genetics (IMBG), Mahidol University\t\t",
"MBR\ts\tMuseo Argention de Ciencias Naturales \"Bernardino Rivadavia\"\t\t",
"MBS\ts\tManchester Banksian Society\t\t",
"MBSL\ts\tRoyal Medico-Botanical Society\t\t",
"MBSN\ts\tMuseo Brembano di Scienze Naturali\t\t",
"MBUCV\ts\tMuseo de Biologia de la Universidad Central de Venezuela\tCBFC,MBUC",
"MBZH\ts\tMuseo y Biblioteca de la Zoologia\t\t",
"MC\ts\tMuseo de Cipolleti\t\t",
"MCA\ts\tMuhlenberg College, Biology Department\t\t",
"MCAS\ts\tMuseo Civico Archeologico e di Scienze Naturali \"F. Eusebio\"\t\t",
"MCBR\ts\tMuseo Civico \"Baldassarre Romano\"\t\t",
"MCC\tc\tMicrobial Culture Collection\t\t",
"MCC-UPLB\tc\tMicrobial Culture Collection\t\t",
"MCCB\ts\tMuseo Civico \"Craveri\"\t\t",
"MCCC\tc\tMarine Culture Collection of China\t\t",
"MCCI\ts\tMuseo Civico di Storia Natural de Carmognola\t\t",
"MCCM<DEU>\tc\tMedical Culture Collection Marburg\t\t",
"MCCM<IND>\ts\tMadras Christian College\t\t",
"MCD\ts\tMuzeul Civilizatiei Dacice si Romane Deva\t\t",
"MCDNL\th\tMcDaniel College\t\t",
"MCES\ts\tMuseum of the Center for Entomological Studies\t\t",
"MCF\th\tSts. Cyril and Methodius University\t\t",
"MCF-PVPH\ts\tMuseo Carmen Funes\t\t",
"MCFB\ts\tMuseo de la Cienica Fundacion\t\t",
"MCFM\ts\tMuseo Civico \"Francesco Mina Palumbo\"\t\t",
"MCFS\ts\tMuseo Civico di Storia Naturale, Ferrara\t\t",
"MCG\ts\tMuseo Civico DI Storia Naturale 'Giacomo Doria'\t\t",
"McGMK\ts\tMcGregor Memorial Museum\t\t",
"MCGS\ts\tMuseo Civico \"Giuseppe Scarabelli\"\t\t",
"MCITM\tc\tBacterial Culture Collection\t\t",
"MCIZ\ts\tMuseo Cambria, Istituto di Zoologia dell'Universita\t\t",
"MCJ\ts\tMissouri Southern State College, Biology Department\t\t",
"MCLSBB\ts\tMuseo Colegio La Salle Bonanova de Barcelona\t\t",
"MCM(CMFRI)\ts\tReference Collection\t\t",
"MCM<CAN>\ts\tHamilton College, McMaster University, Biology Department\t\t",
"MCM<FRA>\ts\tInstitut de Paleontologie, Museum d'Histoire naturelle\t\t",
"MCM<IND>\tc\tMACS Collection of Microorganisms\t\t",
"MCM<PRT>\ts\tMuseu Carlos Machado\t\t",
"MCMC\ts\tMuseo de Historia Natural de la Ciudad de Mexico\t\t",
"McMJ\ts\tMc Master University\t\t",
"MCMS\ts\tMuseo Civico di Storia Naturale, Morgegno\t\t",
"MCN\ts\tMcNeese State University, Biology Department\t\t",
"MCNA\ts\tMuseo de Ciencias naturals de Alava\t\t",
"MCNC\ts\tMuseo de Ciencias Naturales\t\t",
"MCNG\ts\tMuseo de Ciencias Naturales de la UNELLEZ en Guanare\t\t",
"MCNPV\ts\tFundacao Zoobotanica do Rio Grande do Sul\tMCN",
"MCNS\ts\tUniversidad Nacional de Salta, Facultad de Ciencias Naturales\t\t",
"MCNV\ts\tMuseo Civico di Storia Naturale, Venice\t\t",
"MCNZ\ts\tPorto Alegre, Museu de Ciencias Naturais da Fundacao Zoo-Botanica do Rio Grande do Sul\t\t",
"MCP<BRA>\ts\tPontificia Universidade Catolica do Rio Grande do Sul\t\t",
"MCP<USA-MA>\ts\tMassachusetts College of Pharmacy and Allied Health Sciences, Biological Sciences Department\t\t",
"MCPM\ts\tMilwaukee City Public Museum\t\t",
"MCPPV\ts\tMuseu de Ciencias e Tecnologia\tMCP",
"MCPUCRGS\ts\tMuseu de Ciencias da Pontificia Universidade Catolica do Rio Grande do Sul\t\t",
"MCR\ts\tManchester Literary and Philosophical Society\t\t",
"MCRA\ts\tSezione Archeologia, Storia e Scienze Naturali\t\t",
"MCRBS\ts\tManchester Botanical and Horticultural Society\t\t",
"MCSB\ts\tMuseo Civico di Scienze Naturali\t\t",
"MCSC\ts\tColorado Springs, May Natural History Museum\t\t",
"MCSF\ts\tMuseo Civico di Scienze Naturali\t\t",
"MCSG\ts\tMuseo Civico di Storia Naturale, Grosseto\t\t",
"MCSN<ITA-Genova>\ts\tMuseo Civico di Storia Naturale \"Giacomo Doria\"\t\t",
"MCSN<ITA-Verona>\ts\tMuseo Civico di Storia Naturale, Verona\t\t",
"MCSNC\ts\tMuseo Civico di Storia Naturale, Carmagnola\tMSNC",
"MCSNIO\ts\tMuseo Civico di Scienze Naturali di Induno Olona\t\t",
"MCST\ts\tMuseo Civico di Storia Naturale, Trieste\t\t",
"MCT\ts\tMichigan Technological University, Biological Sciences Department\t\t",
"MCTC\ts\tMichigan Technological University, Biological Sciences Department\t\t",
"MCTF\ts\tMichigan Technological University\t\t",
"MCTP\ts\tMuseu de Ciencias\t\t",
"MCVE\ts\tMuseo di Storia Naturale di Venezia\t\t",
"MCVM\ts\tMuseo Civico, Villa Mirabello\t\t",
"MCW\ts\tMilton College, Biology Department\t\t",
"MCZ\ts\tMuseum of Comparative Zoology, Harvard University\tMCZC",
"MCZ:Cryo\ts\tMuseum of Comparative Zoology, Harvard University, Cryogenic Collection",
"MCZ:Ent\ts\tMuseum of Comparative Zoology, Harvard University, Entomology Collection",
"MCZ:Herp\ts\tMuseum of Comparative Zoology, Harvard University, Herpetology Collection",
"MCZ:Ich\ts\tMuseum of Comparative Zoology, Harvard University, Ichthyology Collection",
"MCZ:IP\ts\tMuseum of Comparative Zoology, Harvard University, Invertebrate Paleontology Collection",
"MCZ:IZ\ts\tMuseum of Comparative Zoology, Harvard University, Invertebrate Zoology Collection",
"MCZ:Mala\ts\tMuseum of Comparative Zoology, Harvard University, Malacology Collection",
"MCZ:Mamm\ts\tMuseum of Comparative Zoology, Harvard University, Mammalogy Collection",
"MCZ:Orn\ts\tMuseum of Comparative Zoology, Harvard University, Ornithology Collection",
"MCZR\ts\tMuseo Civico di Zoologia\t\t",
"MD<AGO>\ts\tMuseu Regional do Dundo\t\t",
"MD<DEU>\ts\tMuseum Donaueschingen\t\t",
"MDC\tc\tMicrobial Depository Center (National Microbial Culture Collection of the Republic of Armenia)\t\t",
"MDE\ts\tMusee des Dinosaures in Esperaza\t\t",
"MDFW\ts\tMassachusetts Division of Fisheries and Wildlife\t\t",
"MDH<GBR>\ts\tDorman Museum\t\t",
"MDH<USA-MI>\tc\tMichigan Department of Health\t\t",
"MDI\th\tMalaysian Agricultural Research and Development Institute\t\t",
"MDKY\ts\tMorehead State University, Biological and Environmental Sciences Department\t\t",
"MDLA\ts\tMuseu do Dundo\t\t",
"MDM\ts\tMifune Dinosaur Museum\t\t",
"MDNR\ts\tManitoba Conservation\t\t",
"MDP\ts\tMuseum de Poligny\t\t",
"MDRG\ts\tMuseum voor Dierkunde, Rijksuniversiteit\t\t",
"MDTN\ts\tMiddleton Botanical Society\t\t",
"MDUG\ts\tUniversidad Guanajuato, Museo Alfredo Duges\t\t",
"MDZAU\ts\tMuseum Deptartment of Zoology\t\t",
"MECB\ts\tUniversidade Federal de Pelotas, Museu Entomologico Ceslau Biezanko\t\t",
"MECG\ts\tMedical Entomology Collection Gallery\t\t",
"MECN\ts\tMuseo Ecuadoriano de Ciencias Naturales\tDHMECN",
"MEDEL\ts\tUniversidad Nacional de Colombia - Sede de Medellin, Departamento de Biologia\t\t",
"MEFLG\ts\tMuseo Entomologico Francisco Luis Gallego\t\t",
"MEL\ts\tRoyal Botanic Gardens Victoria\t\t",
"MELG\ts\tGeology Department, University of Melbourne\t\t",
"MELIT\th\tBogdan Khmel'nysckyi State Pedagogical University of Melitopol'\t\t",
"MELU\ts\tUniversity of Melbourne\t\t",
"MEM\ts\tUniversity of Memphis, Biology Department\t\t",
"MEMO\ts\tInstituto Tecnologico y de Estudios Superiores de Monterrey, Departamento de Recursos Naturales\t\t",
"MEN\ts\tUNCuyo, Catedra de Botanica Agricola, Departamento de Ciencias Biologicas\t\t",
"MEPAN\ts\tMuseum of Evolution, Polish Academy of Sciences\t\t",
"MER\ts\tUniversidad de Los Andes\t\t",
"MERC\ts\tUniversidad de Los Andes, Centro Jardin Botanico\t\t",
"MERCA\th\tMercer Arboretum and Botanic Gardens\t\t",
"MERF\ts\tUniversidad de Los Andes\t\t",
"MERL\ts\tInstituto Argentino de Investigaciones de las Zonas Aridas (CRICYTME)\t\t",
"MESA\ts\tMesa State College, Biology Department\t\t",
"MEUC\ts\tUniversidad de Chile\t\t",
"MEX\ts\tMuseo de Historia Natural de la Ciudad de Mexico\t\t",
"MEXU\ts\tHerbario Nacional de Mexico, Universidad Nacional Autonoma de Mexico\tIBUNAM:MEXU",
"MFA\ts\tMuseo Provincial de Ciencias Naturales Florentino Ameghino, Seccion Botanica\t\t",
"MFA-ZV-M\ts\tMuseo Florentino Ameghino, Coleccion de Mastozoologia (Argentina)\t\t",
"MFAP\ts\tArchaeology and Palaeontology\t\t",
"MFB\ts\tSouthern Research Station\t\t",
"MFC\tc\tMatsushima Fungus Collection\t\t",
"MFGC\tc\tMargot Forde Germplasm Centre, AgResearch GrasslandsWar\t\t",
"MFLB\ts\tMarine Fisheries Laboratory\t\t",
"MFLU\tsc\tMae Fah Laung University Herbarium\tMFLU<THA>",
"MFLUCC\tc\tMae Fah Luang University Culture Collection\t\t",
"MfN<DEU>\ts\tMuseum fur Naturkunde\t\t",
"MFNB\ts\tMuseo Friulano di Storia Naturale\t\t",
"MFP\ts\tMuseo Felipe Poey\t\t",
"MFRU\ts\tMalawi Fisheries Research Unit\t\t",
"MFS\ts\tMuseo dei Fisiocritici\t\t",
"MFSN\ts\tMuseo Friulano di Storia Naturale of Udine\t\t",
"MFU\ts\tMuseo Friulano di Storia Naturale\t\t",
"MFUM\ts\tMuseum of Ferdowsi University of Mashhad\t\t",
"MFUW\ts\tChinzombo Research Station, Chinzombo Wildlife Research Station\t\t",
"MFW\ts\tMuseum Freriks\t\t",
"MG<BRA>\ts\tMuseu Paraense Emilio Goeldi, Departamento de Botanica\t\t",
"MG<CHN>\ts\tMuseum of Zoology\t\t",
"MGA\ts\tInstituto Pedagogico de Varones\t\t",
"MGAB\ts\tMuzeul de Istorie Naturala \"Grigore Antipa\"\t\t",
"MGAP\ts\tMuseu Anchieta\t\t",
"MGB\ts\tMuseo de Geologia (del Seminario Diocesano) de Barcelona\t\t",
"MGC\ts\tUniversidad de Malaga, Departamento de Biologia Vegetal\t\t",
"MGDL\ts\tMuseum d'Histoire Naturalle du Grand-Duchy de Luxembourg\t\t",
"MGF\ts\tMuseum George Frey\t\t",
"MGFT\ts\tMuseum G. Frey\t\t",
"MGH\ts\tMuseum Godeffroy\t\t",
"MGHF\ts\tMuseo Geologico H. Fuenzalida\t\t",
"MGHNL\ts\tMusee Guimet d'Histoire Naturelle de Lyon\t\t",
"MGHSJ\ts\tMatuyama Girl's High School\t\t",
"MGI\ts\tGeological Institute of the Mongolian Academy of Sciences\t\t",
"MGL\ts\tMusee Geologique de Lausanne\t\t",
"MGR\ts\tUniversity of Michigan\t\t",
"MGRI\ts\tMoscow Geological Prospecting Institute\t\t",
"MGS\ts\tUpper Silesian Museum, Department of Natural History\t\t",
"MGSI\ts\tMuseum of the Geological Survey of Iran\t\t",
"MGSP\ts\tMuseum of the Geological Survey of Portugal\t\t",
"MGUG\ts\tMuseum fuer Geologie und Palaontologie der Georg-August-Universitat\t\t",
"MGUH\ts\tMuseum Geologicum Universitatis Hafniensis\t\t",
"MGUP\ts\tMuseo Geologico della Universita Pisa\t\t",
"MGUV\ts\tMuseo del Departamento de Geologia, Universidad de Valencia\t\t",
"MGUWR\ts\tInstitute of Geological Sciences, University of Wroclaw\t\t",
"MH<CHE>\ts\tNaturhistorisches Museum, Basel\t\t",
"MH<IND>\ts\tTamil Nadu Agricultural University\t\t",
"MHA\ts\tMain Botanical Garden of the Russian Academy of Sciences\t\t",
"MHES\th\tMuseo de Historia Natural de El Salvador\t\t",
"MHH\tc\tInstitute of Virology\t\t",
"MHL\ts\tMildenhall and District Museum\t\t",
"MHM\ts\tMalham Tarn Field Centre\t\t",
"MHMN\ts\tMuseu Historic Municipal de Novelda\t\t",
"MHNA\ts\tMuseum d'Histoire Naturelle d'Autun\t\t",
"MHNB\ts\tMuseum d'Histoire Naturelle de Bale\t\t",
"MHNC<CHE>\ts\tMusee d'Histoire Naturelle - La Chaux-de-Fonds\t\t",
"MHNC<CHL>\ts\tMuseo de Historia Natural de Concepcion (Chile)\t\t",
"MHNCI\ts\tMuseu de Historia Natural Capao de Imbuia (Brazil)\t\t",
"MHNCSJ\ts\tMuseo de Historia Natural\t\t",
"MHNES\ts\tMuseo de Historia Natural de El Salvador\t\t",
"MHNG\ts\tNatural History Museum of Geneva\t\t",
"MHNG:Herp\ts\tNatural History Museum of Geneva, Herpetology collection",
"MHNG:Invertebrate\ts\tNatural History Museum of Geneva, Invertebrate collection",
"MHNH\ts\tMuseo Nacional de Historia Natural de Cuba\tMNHNCU",
"MHNI\ts\tMuseu Hist. Naturales Universidade Federal Minas Gerais\t\t",
"MHNJP\ts\tUniversidad Nacional Mayor de San Marcos\t\t",
"MHNL\ts\tMusee Guimet d'Histoire Naturelle de Lyon\t\t",
"MHNLR\ts\tMuseum d'Histoire Naturelle\tMHNR",
"MHNLS\ts\tColeccion de Mastozoologia, Museo de Historia Natural de La Salle\t\t",
"MHNM\ts\tMuseo Nacional de Historia Natural y Antropologia\t\t",
"MHNN<CHE>\ts\tNeuchatel Musee d'Histoire Naturel\t\t",
"MHNN<FRA>\ts\tMusee d'Histoire Naturalle\t\t",
"MHNNICE\ts\tMueusm d'Histoire Naturelle de Nice\t\t",
"MHNP\ts\tMuseum d'Histoire Naturelle Perpignan\t\t",
"MHNSM\ts\tMuseo de Historia Natural, Universidad Nacional Mayor de San Marcos\t\t",
"MHNT\ts\tMuseum d'Histoire Naturelle Toulouse\t\t",
"MHNUNC\ts\tDepartamento de Ictiologia del Museo de Historia Natural de la Universidad Nacional de Colombia\t\t",
"MHNV\ts\tMuseo de Historia Natural de Valparaiso\t\t",
"MHP\ts\tFort Hays State University, Sternberg Museum of Natural History\t\t",
"MHU\ts\tMakerere University, Botany Department\t\t",
"MHUA\ts\tMuseo de Herpetologia de la Universidad de Antioquia\t\t",
"MHV\ts\tMusee de Haute Volta\t\t",
"MHWK\ts\tMuch Wenlock Museum\t\t",
"MI\ts\tUniversita degli Studi di Milano, Dipartimento di Biologia\t\t",
"MIB\ts\tUniversity of Milano - Bicocca, Department of Biotechnology and Biosciences\t\t",
"MIB:ZPL\ts\tUniversity of Milano - Bicocca, Department of Biotechnology and Biosciences, ZooPlantLab",
"MIC\ts\tMar Ivanios College (Zoology museum)\t\t",
"MICG\th\tUniversidad de San Carlos de Guatemala\t\t",
"MICH\ts\tUniversity of Michigan\t\t",
"MICKKU\tc\tMICKKU Culture Collection\t\t",
"MID\ts\tMiddlebury College, Biology Department\t\t",
"MII\ts\tMuseum of Irish Industry\t\t",
"MIKU\ts\tMarine Biological Institute, Kyoto University\t\t",
"MIL\ts\tMilwaukee Public Museum\t\t",
"MIM\ts\tMinusinsk N. M. Martjanov Regional Museum\t\t",
"MIMB\ts\tMuseum of the Institute of Marine Biology\t\t",
"MIMM\ts\tMauritius Institute\t\t",
"MIN\ts\tUniversity of Minnesota\t\t",
"MINC\ts\tUniversidad Politecnica\t\t",
"MINI\ts\tMuzeul de Istoria Naturala\t\t",
"MIPV\ts\tUniversita degli Studi di Milano, Laboratorio di Micologia e Batteriologia Fitopathologica\t\t",
"MIRR\th\tMuseu Integrado de Roraima\t\t",
"MISR\ts\tMacaulay Land Use Research Institute\t\t",
"MISS\ts\tUniversity of Mississippi, Department of Biology\t\t",
"MISSA\ts\tMississippi State University, Department of Biological Sciences\t\t",
"MISU\th\tMinot State University\t\t",
"MIT\tc\tMassachusetts Institute of Technology\t\t",
"MIWG\ts\tMuseum of he Isle of Wight Geology\t\t",
"MIZA\ts\tMuseuo del Instituto de Zoologia Agricola\t\t",
"MIZL\ts\tMusee de l'Institut de Zoologie\t\t",
"MIZT\ts\tUniversita di Torino\t\t",
"MJ\ts\tMuzeum Vysociny\t\t",
"MJCM\ts\tMuseo de Ciencias Naturales y Antropologicas \"Prof. Juan C.Moyano\" (Argentina)\t\t",
"MJG<ARG>\ts\tMuseo Jorge Gerhold\t\t",
"MJG<AUT>\ts\tLandesmuseum Joanneum\t\t",
"MJG<DEU>\ts\tJohannes Gutenberg-Universitat\t\t",
"MJH\ts\tMuzeul Judetean Hunedoara\t\t",
"MJMO\ts\tUniversidad Centro Occidental, Decanato de Agronomia\t\t",
"MJS\ts\tXiaolongshan Forestry Experiment Bureau\t\t",
"MJSD\ts\tMuseum-Jardin des Sciences\t\t",
"MK\ts\tNational Museum of Kenya\t\t",
"MKMEL\th\tHerbarium Melovskiorum\t\t",
"MKNDC\th\tInstitute of Biology\t\t",
"MKNH\th\tInstitute of Biology\t\t",
"ML\ts\tMusee de Lectoure\t\t",
"MLAV\ts\tMusees de Laval\t\t",
"MLGU\th\tInstitut National pour l'Etude et la Recherche  Agronomiques\t\t",
"MLLD\tc\tMicrobiological Research Laboratory, Soil and Water Section, Department of Land Development\t\t",
"MLMJI\tc\tDepartment of Plant Protection, Faculty of Agricultural Production\t\t",
"MLP\ts\tMuseo de La Plata\tMLPA",
"MLRU\tc\tMicrobiology Laboratory, Department of Biology, Faculty of Science\t\t",
"MLS<AUS>\ts\tMarine Laboratory Sydney\t\t",
"MLS<COL>\ts\tMuseo del Instituto de La Salle\t\t",
"MLS<GBR>\ts\tLathallan Preparatory School\t\t",
"MLSU\ts\tSt. Petersburg State University, Zoology Museum\t\t",
"MLUH\ts\tMartin Luther Universitat\tMLU",
"MLY\ts\tArboretum Mlynany\t\t",
"MLZ\ts\tMoore Laboratory of Zoology, Occidental College\t\t",
"MLZ:Bird\ts\tMoore Laboratory of Zoology, Occidental College, Bird Collection",
"MLZ:Mamm\ts\tMoore Laboratory of Zoology, Occidental College, Mammal Collection",
"MM<CAN>\ts\tManitoba Museum\t\t",
"MM<COL>\ts\tMuseo del Mar\t\t",
"MM<DEU>\ts\tMagdeburg Museum\t\t",
"MM<FRA>\ts\tUniversity of Montpellier\t\t",
"MMB\ts\tMoravske Muzeum\t\t",
"MMBC\ts\tMoravske Muzeum [Moravian Museum]\t\t",
"MMBS\ts\tMukaishima Marine Biological Station\t\t",
"MMCC\tc\tMARDI Microbial Culture Collection\t\t",
"MMChPV\ts\tMuseo Municipal El Chocon\t\t",
"MMCM\ts\tMuseum of Malawi\t\t",
"MMF\ts\tMuseu Municipal do Funchal\t\t",
"MMG\ts\tMuseo Marino de la Isla de Gorgona\t\t",
"MMH\ts\tMunicipal Museum\t\t",
"MMI\ts\tRegionalni muzeum\t\t",
"MMK\ts\tMcGregor Museum\t\t",
"MMKZ\ts\tAlexander McGregor Memorial Museum\t\t",
"MML\tc\tMedical Microbiological Laboratory\t\t",
"MMMN\ts\tManitoba Museum of Man and Nature, Botany Department\t\t",
"MMMZ\ts\tMutare Museum\t\t",
"MMNH<MNG>\ts\tMongolian Museum of Natural History\t\t",
"MMNH<USA-MN>\ts\tBell Museum of Natural History\t\t",
"MMNHS\ts\tMacedonian Museum of Natural History\t\t",
"MMNS\ts\tMississippi Museum of Natural Science\t\t",
"MMP\ts\tMuseo de Mar del Plata (Argentina)\t\t",
"MMRF\tc\tMarine Microbial Reference Facility\t\t",
"MMS\ts\tMontshire Museum of Science\t\t",
"MMTT\ts\tIran National Museum of Natural History\t\t",
"MMUE\ts\tMuseum of Manchester University\t\t",
"MMUS\ts\tMacleay Museum, University of Sydney\t\t",
"MN\ts\tMuseu Nacional, Universidade Federal do Rio de Janeiro\t\t",
"MNA\ts\tMuseum of Northern Arizona\t\t",
"MNA<ITA>\ts\tThe Museo Nazionale dell'Antartide  (Italian National Antarctic  Museum in Genoa).\t\t",
"MNAV\ts\tMuseo Naturalistico-Archeologico\t\t",
"MNB\ts\tMuseum fuer Naturkunde der Humboldt-Universitaet\t\t",
"MNCE\ts\tMuseu de Historia Natural Capao da Embuia\t\t",
"MNCN\tsb\tMuseo Nacional de Ciencias Naturales\t\t",
"MNCN:ADN\tsb\tMuseo Nacional de Ciencias Naturales, Coleccion de Tejidos y ADN",
"MNCN:Ent\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de entomologia",
"MNCN:Herpeto\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de anfibios y reptiles",
"MNCN:ICTIO\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de ictiologia",
"MNCN:Inverte\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de invertebrados",
"MNCN:Malac\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de malacologia",
"MNCN:Mam\ts\tMuseo Nacional de Ciencias Naturales, Colession de mamiferos",
"MNCN:Ornit\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de aves",
"MNCR\ts\tMuseo Nacional de Costa Rica\t\t",
"MND\ts\tMuseum Natura Docet\t\t",
"MNDG\ts\tMuseo Nacional \"David J. Guzman\"\t\t",
"MNE\ts\tMaidstone Museum and Art Gallery\t\t",
"MNFD\ts\tMuseum fuer Naturkunde\t\t",
"MNG\ts\tSammlung Eisfeld des Museums der Natur Gotha\t\t",
"MNGA\ts\tMuzeul National de Istorie Natural \"Grigore Antipa\"\t\t",
"MNGC\ts\tMuseo Nacional de Historia Natural, Guatemala City\t\t",
"MNH\ts\tMuseo de Ciencias Naturales de Tenerife\t\t",
"MNHCI\ts\tMuseu de Historia Natural Capao da Imbuia\t\t",
"MNHM<DEU>\ts\tNaturhistorisches Museum Mainz/Landessammlung fuer Naturkunde Rheinland-Pfalz\t\t",
"MNHM<USA-CO>\ts\tJohn May Museum of Natural History\t\t",
"MNHN\ts\tMuseum National d'Histoire Naturelle\t\t",
"MNHN:IC\ts\tMuseum National d'Histoire Naturelle, Ichtyologie collection",
"MNHN:IE\ts\tMuseum National d'Histoire Naturelle, Echinoderm collection",
"MNHN:IK\ts\tMuseum National d'Histoire Naturelle,  Cnidarians Collection",
"MNHN:IM\ts\tMuseum National d'Histoire Naturelle, Marine Invertebrate Collection",
"MNHN:IU\ts\tMuseum National d'Histoire Naturelle, Crustacean collection",
"MNHN:M\ts\tMuseum National d'Histoire Naturelle, Mammal collection",
"MNHN:P\ts\tMuseum National d'Histoire Naturelle, Paleontology Collection",
"MNHN<CUB>\ts\tMuseo Nacional de Historia Natural, Departamento de Colecciones\t\t",
"MNHN<URY>\ts\tMuseo Nacional de Historia  Natural de Montevideo\t\t",
"MNHNCH\ts\tMuseo Nacional de Historia Natural de Chile\tMNHN ,MNHNC",
"MNHNCU\ts\tMuseo Nacional de Historia Natural, Havana\tMNHC",
"MNHNJP\ts\tUniversidad Nacional Mayor de San Marcos\t\t",
"MNHNLES\ts\tMuseum National d'Histoire Naturelle Lesotho\t\t",
"MNHNM\ts\tMuseo Nacional de Historia Natural, Mexico City\t\t",
"MNHNP\ts\tMuseo Nacional de Historia Natural del Paraguay\t\t",
"MNHNSD\ts\tMuseo Nacional de Historia Natural, Santo Domingo\tMHND",
"MNHNUL\ts\tMuseu Nacional de Historia Natural de Universidade de Lisboa\t\t",
"MNHP\ts\tPrinceton University\t\t",
"MNHS\ts\tManchester Natural History Society\t\t",
"MNK\ts\tMuseo de Historia Natural \"Noel Kempff Mercado\"\t\t",
"MNK:A\ts\tMuseo de Historia Natural \"Noel Kempff Mercado\", Amphibian Collection",
"MNK:R\ts\tMuseo de Historia Natural \"Noel Kempff Mercado\", Reptile Collection",
"MNKNU\ts\tMuseum of Nature, V.N. Karazin Kharkiv National University\t\t",
"MNKS\ts\tMilton Keynes Development Corporation\t\t",
"MNMB\ts\tMagyar Nenzeti Museum\t\t",
"MNMS\ts\tMuseo Nacional de Ciencias Naturales\t\t",
"MNN\ts\tMusee National du Niger\t\t",
"MNNC\ts\tMuseo Nacional de Historia Natural, Santiago\t\t",
"MNNHN\ts\tMuseum National d'Historie Naturelle\t\t",
"MNNIT\tc\tMotilal Nehru National Institute of Technology\t\t",
"MNNW\ts\tMuseum fuer Naturkunde\t\t",
"MNRJ\ts\tMuseu Nacional/Universidade Federal de Rio de Janeiro\t\t",
"MNSB\ts\tMuseum of Natural Sciences\t\t",
"MNSL\ts\tMuseum of Natural Sciences\t\t",
"MNUFR\ts\tMongolian National University\t\t",
"MNVD\th\tMuseum fur Naturkunde und Vorgeschichte Dessau\t\t",
"MNVL\ts\tMuseum d'Histoire Naturelle de Ville de Lille\t\t",
"MNZ\ts\tMuseum of New Zealand Te Papa Tongarewa\t\t",
"MO\ts\tMissouri Botanical Garden\t\t",
"MOAR\ts\tMorris Arboretum, University of Pennsylvania, Botany Department\t\t",
"MOBR\th\tEstacion de Investigaciones Marinas de Margarita, Fundacion La Salle de Ciencias Naturales\t\t",
"MOC\ts\tWestern Oregon University, Biology Department\t\t",
"MOD\ts\tUniversita degli Studi di Modena e Reggio Emilia, Dipartimento de Biologia Animale\t\t",
"MODNR\ts\tDivision of State Parks, Department of Natural Resources\t\t",
"MOFUNG\ts\tMuseu Oceanogr. Fundacao Univerdidade Rio Grande\t\t",
"MOG\ts\tNational Range Agency\t\t",
"MOL\ts\tUniversidad Nacional Agraria La Molina, Departamento Academico de Biologia\t\t",
"MOLA\tc\tMicrobial Observatory of the Laboratoire Arago\t\t",
"MOM\ts\tMusee Oceanographique Monaco\t\t",
"MONA\ts\tMusee Oceanographique de Monaco\t\t",
"MONT\ts\tMontana State University\t\t",
"MONTU\ts\tUniversity of Montana\t\t",
"MONZ\ts\tMuseum of New Zealand\t\t",
"MOR<USA-IL>\ts\tMorton Arboretum, Research Department\t\t",
"MOR<USA-MT>\ts\tMuseum of the Rockies\t\t",
"MOS\ts\tCollege of Agriculture and Forestry\t\t",
"MOSG\ts\tMuzeul Orasului Sf. Gheorghe\t\t",
"MOSI\ts\tMuseum of Science and Industry\t\t",
"MOSM\ts\tAll-Russian Research Institute of Medicinal and Aromatic Plants\t\t",
"MOSN\ts\tMuseo Ornitologico e di Scienze Naturali\t\t",
"MOSP\ts\tMoscow State Pedagogical University, Botany Department\t\t",
"MOSS\th\tUniversidade Federal Rural do Semi-Arido\t\t",
"MOT\ts\tMote Marine Laboratory\t\t",
"MOTH\ts\tMuseum of the Hemispheres\t\t",
"MOUFPE\ts\tOceanographic Museum of the Federal University of Pernambuco\t\t",
"MOVC\ts\tCornell College, Biology Department\t\t",
"MOVI\ts\tMuseu Oceanografico do Vale do Itajai\t\t",
"MP<CZE>\ts\tVychodoceske muzeum Pardubice\t\t",
"MP<USA-NY>\ts\tMohonk Preserve, Inc.\t\t",
"MP<ZAF>\ts\tTransvaal Museum\t\t",
"MPA\ts\tEcole National Superieure Agronomique, Biologie et Pathologie Vegetales\t\t",
"MPC\ts\tMonterey Peninsula College, Life Science Museum\t\t",
"MPCA\ts\tMuseo Provincial \"Carlos Ameghino\"\t\t",
"MPCNyO\ts\tMuseo Provincial de Ciencias Naturales, Puerto Madryn\t\t",
"MPCRM\ts\tMuseo Paleontologico Cittadino della Rocca\t\t",
"MPE\ts\tF. R. Long Herbarium\t\t",
"MPEF-PV\ts\tMuso Paleontologico Egidio Fergulio\t\t",
"MPEG\ts\tMuseu Paraense Emilio Goeldi\t\t",
"MPEP\ts\tMusee de Paleontologie et de l'evolution\t\t",
"MPGB\ts\tMuseum of Portuguese Guinea\t\t",
"MPH\th\tShahid Behershti University\t\t",
"MPKV\tc\tBiological Nitrogen Fixation Project College of Agriculture\t\t",
"MPL\ts\tMusee de Port Louis\t\t",
"MPLN\ts\tMuseo Provinciale di Storia Naturale\t\t",
"MPM\ts\tMilwaukee Public Museum\t\t",
"MPM<JPN>\ts\tMeguro Parasitological Museum\t\t",
"MPMP\ts\tNational Museum of the Philippines\t\t",
"MPN\ts\tMassey University, Ecology Group\t\t",
"MPPD\ts\tUniversity of Minnesota, Plant Pathology Department\t\t",
"MPPE\ts\tPaletnologica ed Etnologico dei Padri Francescani\t\t",
"MPR\ts\tMount Makulu Pasture Research Station\t\t",
"MPSC\ts\tMuseu de Paleontologia de Santana do Cariri\t\t",
"MPSN\ts\tMuseo Provinciale di Scienze Naturali\t\t",
"MPSP\ts\tMuseu Paulista\t\t",
"MPSU\tc\tDepartment of Microbiology, Songkla University\t\t",
"MPT\ts\tMuseuo Provincial de Teurel\t\t",
"MPU\ts\tUniversite Montpellier II\t\t",
"MPUC\ts\tPontificia Universidade Catolica do Rio Grande do Sul, Laboratorio de Botanica\t\t",
"MPUM\ts\tMuseo Paleontologia Universita degli Studi di Milano\t\t",
"MPUN\ts\tMuseo Paleontologicom\t\t",
"MPUNR\ts\tDepartamento de Geologia, Universidad de Chile\t\t",
"MPV\ts\tMuseo Paleontologico Municipal de Valencia\t\t",
"MPZ\ts\tMuseo Paleontologico de la Universidad de Zaragoza\t\t",
"MQ\ts\tGansu Institute of Desert Control\t\t",
"MQU\ts\tMacquarie University\t\t",
"MRA\ts\tMuseo Requieu\t\t",
"MRA<USA-VA>\tc\tMalaria Research and Reference Reagent Resource Center\t\t",
"MRAC\ts\tMusee Royal de l'Afrique Centrale\t\t",
"MRC<TUR>\tc\tTUBITAK Marmara Research Center Culture Collection\t\t",
"MRC<USA-MT>\ts\tRocky Mountain Research Station\t\t",
"MRC<ZAF>\tc\tNational Research Institute for Nutritional Diseases\t\t",
"MRCA\ts\tMusee Royal de l'Afrique Centrale\t\t",
"MRCN\ts\tMuseu Rio-Grandense de Ciencias Naturais\t\t",
"MRD\ts\tMoorhead State University, Biology Department\t\t",
"MRF\ts\tMuseum of Histoire naturelle\t\t",
"MRGS\ts\tMuseu do Rio Grande do Sul\t\t",
"MRI\ts\tMurray Royal Institution\t\t",
"MRNP\ts\tMount Rainier National Park\t\t",
"MRSC\ts\tMount Makulu Central Research Station\t\t",
"MRSH\ts\tMatopos Research Station\t\t",
"MRSN\ts\tMuseo Regionale di Scienze Naturali\t\t",
"MRSN<USA>\tc\tMultidrug Resistant Organism Repository and Surveillance Network\t\t",
"MRSP\ts\tMuseo Regionale di Scienze Naturali, St. Pierre\t\t",
"MRST\ts\tMuseo Regionale di Storia Naturale, Terrasini\t\t",
"MS\ts\tUniversita di Messina, Dipartimento di Scienze Botaniche\t\t",
"MSA\ts\tMuseum of Science and Art\t\t",
"MSB\ts\tMuseum of Southwestern Biology\t\t",
"MSB:Bird\ts\tMuseum of Southwestern Biology, Bird Collection",
"MSB:Fishes\ts\tMuseum of Southwestern Biology, Fish Collection",
"MSB:Herp\ts\tMuseum of Southwestern Biology, Herpetology Collection",
"MSB:Mamm\ts\tMuseum of Southwestern Biology, Mammal Collection",
"MSB:Para\ts\tMuseum of Southwestern Biology, Parasitology Collection",
"MSB<BGR>\ts\tMuseum Sophia\t\t",
"MSB<DEU>\ts\tLudwig-Maximilians-Universitaet\t\t",
"MSC\ts\tMichigan State University, Botany and Plant Pathology Department\t\t",
"MSCL\tc\tMicrobial Strain Collection of Latvia\t\t",
"MSCMU\tc\tMicrobiology Section, Chiang Mai University (MSCMU)\t\t",
"MSCW\ts\tMississippi University for Women\t\t",
"MSDB\ts\tMuseo di Storia Naturale \"Don Bosco\"\t\t",
"MSDS\tc\tMicrobiology Section, Biological Science Division, Department of Science Services\t\t",
"MSE\ts\tAngus Museums\t\t",
"MSEM\ts\tMuseu Geologic del Seminari de Barcelona\t\t",
"MSEN\ts\tMontrose Natural History and Antiquarian Society\t\t",
"MSF\ts\tSauriermuseum Frick\t\t",
"MSGP\ts\tNusee des Services Geologiques du Portugal\t\t",
"MSI\tsc\tMarine Science Institute, University of the Philippines\t\t",
"MSI:PMS-ICBG\tc\tMarine Science Institute, University of the Philippines, Philippine Mollusk Symbiont-International Cooperative Biodiversity Group",
"MSIE\ts\tMuseum of Shanghai\t\t",
"MSINR\ts\tMuseum Sichuan Institute of Natural Resources\t\t",
"MSIR\ts\tMauritius Sugar Industry\t\t",
"MSJC\ts\tSt. Joseph's College, Natural History Museum\t\t",
"MSK\ts\tNational Academy of Sciences of Belarus, Flora and Systematic Laboratory\t\t",
"MSKH\ts\tCentral Botanical Garden\t\t",
"MSKU\ts\tBelarusian State University, Botany Department\t\t",
"MSL\ts\tRoyal Medical Society of London\t\t",
"MSLH\ts\tChinese University of Hong Kong, Marine Sciences Laboratory\tMSLKHC",
"MSLY\ts\tMossley Botanical Society\t\t",
"MSM<JPN>\ts\tMarine Science Museum, Tokai Univ.\t\t",
"MSM<PRI>\ts\tUniversity of Puerto Rico, Marino Puertorriqueno\t\t",
"MSNA\ts\tMuseo di Storia Naturale e Arte Archeologica\t\t",
"MSNG\ts\tMuseo Civico di Storia Naturale di Genova 'Giacomo Doria'\t\t",
"MSNM\ts\tMuseo Civico di Storia Naturale di Milano\t\t",
"MSNO\ts\tMuseum des Sciences Naturelles\t\t",
"MSNP\ts\tMuseo di Scienze Naturali\t\t",
"MSNT<ITA-Torino>\ts\tMuseo Regionale di Scienze Naturali, Torino\t\t",
"MSNT<ITA-Torino>:FAZC\ts\tMuseo Regionale di Scienze Naturali, Torino, Franco Andreone Zoological Collection",
"MSNT<ITA-Turin>\ts\tMuseo Civico DI Storia Naturale DI Torino\t\t",
"MSNU\ts\tMuseo di Storia Naturale dell'Universita\t\t",
"MSNV\ts\tMuseo Civico di Storia Naturale di Venezia\t\t",
"MSNVR\ts\tMuseo Civico di Storia Naturale di Verona\t\t",
"MSPC\ts\tMuseo di Storia Naturale \"Pietro Calderini\"\t\t",
"MSPP\tc\tMycology Section, Plant Pathology and Microbiology Division, Department of Agricultural Science\t\t",
"MSSC\ts\tMidwestern State University\t\t",
"MSTFM\ts\tMiddle School of the Third Factory Machinery\t\t",
"MSTR\ts\tWestfaelisches Museum fuer Naturkunde\t\t",
"MSU<THA>\tc\tAcetobacter\t\t",
"MSU<USA-MI>\ts\tMichigan State University Museum\tMSUC,MSUM",
"MSUB\ts\tMontana State University\t\t",
"MSUD\ts\tI. I. Mecynikov State University of Odessa, Department of Morphology and Systematics of Plants\t\t",
"MSUH\ts\tUniversity of Mosul, Biology Department\t\t",
"MSUMC\ts\tMurray State University\t\t",
"MSUMZ\ts\tMemphis State University\t\t",
"MSUN\ts\tWestfaelische Wilhelms-Universitaet\t\t",
"MSUT\ts\tMuseum of Natural History, Tirane\t\t",
"MSUZ\ts\tMississippi State University, Zoological Collections\t\t",
"MSV\ts\tMuseum der Stadt Villach\t\t",
"MT<CAN>\ts\tUniversite de Montreal\t\t",
"MT<RUS>\ts\tMus. Tinro, Vladyvostok\t\t",
"MTA\ts\tMaden Tetkik ve Arama Enstituesue\t\t",
"MTCC\tc\tMicrobial Type Culture Collection & Gene Bank\t\t",
"MTCHT\th\tMar Thoma College\t\t",
"MTD\ts\tMuseum of Zoology Senckenberg Dresden\t\t",
"MTD:T\ts\tMuseum of Zoology Senckenberg Dresden, Tissue collection",
"MTD:TD\ts\tMuseum of Zoology Senckenberg Dresden, Herpetological Tissue Collection",
"MTDO\th\tChiba University\t\t",
"MTEC\ts\tMontana State University\t\t",
"MTJB\ts\tJardin botanique de Montreal\t\t",
"MTKD\ts\tStaatliches Museum fuer Tierkunde\t\t",
"MTKKU\tc\tDepartment of Clinical Microbiology, Faculty of Medical Technology\t\t",
"MTMG\ts\tMcGill University, Macdonald Campus, Plant Science Department\t\t",
"MTN\ts\tMalton Field Naturalists' Society\t\t",
"MTQA\ts\tMuseum of Tropical Queensland\tMTQ",
"MTSN\ts\tTrento Museum of Natural Sciences\t\t",
"MTSU\ts\tMiddle Tennessee State University, Biology Department\t\t",
"MTUF\ts\tUniversity Museum, Tokyo University of Fisheries\t\t",
"MU<TUR>\tc\tMugla University Collection of Microorganisms\t\t",
"MU<USA-OH>\ts\tMiami University, Botany Department, Willard Sherman Turrell Herbarium\t\t",
"MU<USA-TX>\ts\tMidwestern University\t\t",
"MUACC\tc\tMurdoch University Algal Culture Collection\t\t",
"MUAF\tc\tCulture collection of Mendel University of Agriculture and Forestry in Brno\t\t",
"MUB\ts\tUniversidad de Murcia, Departamento de Biologia Vegetal, Botanica\t\t",
"MUBI\t\tMuseo de Biodiversidad del Peru, Cusco\t\t",
"MUCC\tc\tMurdoch University Culture Collection\t\t",
"MUCC<JPN>\tc\tMie University Culture Collection (Culture Collection, Laboratory of Plant Pathology)\t\t",
"MUCL\tc\tMycotheque de l'Universite Catholique de Louvain\tBCCM/MUCL",
"MUCPv\ts\tMuseo de la Universidad Nacional del Comahue\tMPCA",
"MUCR\ts\tMuseo de Insectos\t\t",
"MUCV\ts\tMonash University, Biological Sciences Department\t\t",
"MUDH\ts\tThe Hague, Museon\t\t",
"MUFE\ts\tUniversity of Marmara, Department of Botany\t\t",
"MUFM\ts\tManipur University Fish Museum\t\t",
"MUFS\ts\tDepartment of Animal Science, Miyazaki  University\t\t",
"MUGM\ts\tMuseo de Ciencias Naturales, Coleccion \"Gustavo Orces\" (Ecuador)\t\t",
"MUGT\ts\tMuseo de Ciencias Naturales de la Universidad de Guayaquil\t\t",
"MUH\th\tMirpur University of Science & Technology\t\t",
"MUHW\ts\tMarshall University, Biological Sciences Department\t\t",
"MUJ\ts\tMuseo Javeriano de Historia Natural, Laboratoriao de Entomologia\t\t",
"MUL\tc\tDepartment of Microbiology MUL-B 250\t\t",
"MULU\ts\tMuseum Ludovicae Ulricae, Zoology Institute of the University of Uppsala\t\t",
"MUM\tc\tMicoteca da Universidade do Minho\t\t",
"MUMF\ts\tDepartment of Life Sciences\t\t",
"MUMH<JPN>\ts\tMie University Mycological Herbarium\t\t",
"MUMZ\ts\tUniversity of Missouri, Museum of Zoology\t\t",
"MUNC\ts\tSt. John's, Memorial University of Newfoundland\t\t",
"MUNZ\ts\tMassey University\t\t",
"MUO\ts\tStovall Museum of Science and History\t\t",
"MUP\ts\tUniversidade do Porto, Museu do Historia Natural\t\t",
"MUR\ts\tMurray State University, Department of Biological Sciences\t\t",
"MURD\ts\tMurdoch University\t\t",
"MURU\ts\tMurdoch University\t\t",
"MUS\ts\tMuskingum College, Biology Department\t\t",
"MUSA\ts\tUniversidad Nacional de San Agustin, Museo de Historia Natural (Peru)\t\t",
"MUSK\ts\tMuskegon Community College, Life Science Department\t\t",
"MUSM\ts\tMuseo de Historia Natural de la Universidad Nacional Mayor de San Marcos en Lima\t\t",
"MUSN\ts\tMuseo Universitario di Storia Naturale e della Strumentazione Scientifica\t\t",
"MUST\th\tAl-Mustansiriya University\t\t",
"MUT<ITA>\tc\tMycotheca Universitatis Taurinensis\t\t",
"MUZ\th\tKing Abdulaziz City for Science and Technology\t\t",
"MV\ts\tUniversity of Montana Museum\t\t",
"MVC\ts\tUniversity of Charleston, Natural Sciences Department\t\t",
"MVDA\ts\tMinisterio de Ganaderia y Agricultura\t\t",
"MVEN\ts\tNaturhistorisch Museum\t\t",
"MVFA\ts\tUniversidad de la Republica, Laboratorio de Botanica\t\t",
"MVFQ\ts\tUniversidad de la Republica, Catedra de Botanica Farmaceutica\t\t",
"MVHC\ts\tUniversidad de la Republica, Seccion Micologia\t\t",
"MVJB\ts\tMuseo y Jardin Botanico\t\t",
"MVM\ts\tMuseo Nacional de Historia Natural, Departamento de Botanica\t\t",
"MVMA\ts\tMuseum of Victoria\t\t",
"MVN\ts\tPublic Library\t\t",
"MVNP\ts\tMesa Verde National Park\t\t",
"MVP\ts\tMuseum of Vicotria\t\t",
"MVSC\ts\tMillersville University, Biology Department\t\t",
"MVUP\ts\tMuseo de Vertebrados de la Universidad de Panama\t\t",
"MVZ\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley\t\t",
"MVZ:Bird\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Bird Collection",
"MVZ:Egg\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Egg Collection",
"MVZ:Herp\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Herpetology Collection",
"MVZ:Hild\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Milton Hildebrand collection",
"MVZ:Img\tb\tMuseum of Vertebrate Zoology, University of California at Berkeley, Image Collection",
"MVZ:Mamm\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Mammal Collection",
"MVZ:Page\tb\tMuseum of Vertebrate Zoology, University of California at Berkeley, Notebook Page Collection",
"MW<NLD>\ts\tMuseum Wasmann\t\t",
"MW<RUS>\tsb\tMoscow State University Herbarium\t\t",
"MWC\ts\tMuseum of Western Colorado\t\t",
"MWCF\ts\tMary Washington College, Department of Biology\t\t",
"MWFB\ts\tUniversity of California, Davis, Museum of Wildlife and Fisheries Biology\t\t",
"MWG\ts\tMoscow State University, Department of Biogeography\t\t",
"MWI\ts\tWestern Illinois University, Biological Sciences Department\t\t",
"MWNH\ts\tMuseum Wiesbaden, Department of Natural Science\t\t",
"MWSJ\ts\tMissouri Western State College, Biology Department\t\t",
"MWSU\ts\tMidwestern State University\t\t",
"MY\ts\tUniversidad Central de Venezuela, Botanica\t\t",
"MYDC\ts\tMianyang Institute for Drug Control\t\t",
"MYF\ts\tUniversidad Central de Venezuela\t\t",
"MZ-ICACH\ts\tInstituto de Ciencias y Artes de Chiapas, Museo Zoologico (Mexico)\t\t",
"MZ<CZE>\ts\tJihomoravske muzeum Znojmo\t\t",
"MZ<POL>\ts\tMuseum of the Earth, Polish Academy of Sciences\t\t",
"MZAF\ts\tMuseo Zoologico dell'Accademia dei Fisiocritici\t\t",
"MZB\ts\tMuseum Zoologicum Bogoriense\t\t",
"MZB:Amp\ts\tMuseum Zoologicum Bogoriense, Amphibian Collection",
"MZB:Ornith\ts\tMuseum Zoologicum Bogoriense, Ornithology Collection",
"MZBL\ts\tMuseo de Zoologica\t\t",
"MZBS\ts\tMuseo Zoologia\t\t",
"MZCP\ts\tUniversidade de Coimbra\t\t",
"MZCR\ts\tMuseo de Zoologia\t\t",
"MZFC\ts\tMuseo de Zoologia \"Alfonso L. Herrera\"\t\t",
"MZFN\ts\tMuseo Zoologico dell'Universita \"Federico II\"\t\t",
"MZGZ\ts\tMuseum Zoologia del Giardino Zoologico\t\t",
"MZH\ts\tZoolgical Museum, Finnish Museum of Natural History\t\t",
"MZKI\tc\tMicrobial Culture Collection of National Institute of Chemistry\t\t",
"MZL\ts\tMusee Zoologique\t\t",
"MZLS\ts\tMusee Zoologique\t\t",
"MZLU\ts\tLund University\t\t",
"MZN\ts\tMusee Zoologie\t\t",
"MZNA\ts\tUniversidad de Navarra, Museum of Zoology\t\t",
"MZNC\ts\tUniversidad Nacional de Cordoba, Museo de Zoolog&iacutea\t\t",
"MZP\ts\tMuzeum Ziemi Polska Akademia Nauk\t\t",
"MZPW\ts\tPolish Academy of Science, Museum of the Institute of Zoology\t\t",
"MZRF\ts\tMuseo Zangheri di Storia Naturale della Romagna\t\t",
"MZRO\ts\tMuseo Civico di Storia Naturale \"P. Zangheri\"\t\t",
"MZS\ts\tUniversite de Strasbourg, Musee de Zoologie\t\t",
"MZSF\ts\tUniversite de Strasbourg, Museum Zoologique\t\t",
"MZSP\ts\tSao Paulo, Museu de Zoologia da Universidade de Sao Paulo\t\t",
"MZTG\ts\tMuseum Zoologia\tIHN",
"MZUABCS\ts\tMuseo de Zoologia de la Universidad Automica de Baja California Sur\t\t",
"MZUB\ts\tMuseo di Zoologia\t\t",
"MZUC<CHL>\ts\tMuseo de Zoologia, Universidad de Concepcion\t\t",
"MZUC<ITA>\ts\tUniversita di Cagliari\t\t",
"MZUCR\ts\tUniversidad de Costa Rica, Museo de Zoologia\t\t",
"MZUEL\ts\tMuseu de Zoologia da Universidade Estadual de Londrina\tMZUEL",
"MZUESC<BRA>\ts\tMuseu de Zoologia da Universidade Estadual de Santa Cruz\t\t",
"MZUF\ts\tMuseo Zoologico La Specola, Universita di Firenze\t\t",
"MZUFBA\ts\tMuseu de Zoologia, Universidade Federal da Bahia, Salvador\t\t",
"MZUN\ts\tMuseo Zoologico di Universita degli Studi\t\t",
"MZUNAP\ts\tMuseo de Zoologia de la Universidad Nacional de la Amazonia Peruana\t\t",
"MZUP<ITA-Padova>\ts\tMuseo Zoologia\t\t",
"MZUP<ITA-Parma>\ts\tMuseo Zoologico di Universita degli Studi\t\t",
"MZUR\ts\tMuseo di Zoologia dell'Universita di Roma \"La Sapienza\"\tMZUL",
"MZUR:BAU\ts\tMuseo di Zoologia dell'Universita di Roma \"La Sapienza\", Zoological collection of the Department of Biology and Biotechnology",
"MZUS\ts\tMusee de Zoologie de l'Universite de Strasbourg\t\t",
"MZUSP\ts\tMuseu de Zoologia da Universidade de Sao Paulo\t\t",
"MZUT<ITA-Torino>\ts\tMuseo di Zoologia, Instituto di Zoologia e Anatomia Comparata Universita di Torino\t\t",
"MZUT<ITA-Turin>\ts\tMuseo e Instituto DI Zoologia Sistematica dell' UniversitaDI Torino\t\t",
"MZUTH\ts\tMuseum of Zoology, University of Thessaloniki\t\t",
"MZUTI\ts\tMuseo de Zoologia, Universidad Tecnologica Indoamerica\t\t",
"MZUVN\ts\tMusee Zool. Univ. et Ville de Nancy\t\t",
"MZV<POL>\ts\tMuzeum i Instytut Zoologii\t\t",
"MZV<RUS>\ts\tZoological Museum Varsovite\t\t",
"MZYU\ts\tMuseum of Zoology, Yunnan University\t\t",
"N\ts\tNanjing University, Biology Department\t\t",
"NA\ts\tUnited States National Arboretum, USDA/ARS\t\t",
"NABG\ts\tBotanical Garden\t\t",
"NAC\ts\tNagano Nature Conservation Research Institute\t\t",
"NAI\ts\tUniversity of Nairobi, Botany Department\t\t",
"NAIC\ts\tNational Agricultural Insect Collection\t\t",
"NAKU\th\tNamik Kemal University\t\t",
"NAM\ts\tFacultes Universitaires Notre-Dame de la Paix\t\t",
"NAN\ts\tNantong Teachers College, Biology Department\t\t",
"NAP<CHN>\ts\tInstitute of Zoology, Academia Sinica (formerly National Academy of Peiping)\t\t",
"NAP<ITA>\ts\tUniversita Degli Studi di Napoli Federico II, Dipartimento di Biologia Vegetale\t\t",
"NARA\ts\tNational Aquatic Resources Agency\t\t",
"NARI\ts\tNational Agricultural Research Institute\t\t",
"NARL\ts\tNational Agricultural Research Laboratories\t\t",
"NAS\ts\tInstitute of Botany, Jiangsu Province and Chinese Academy of Sciences\t\t",
"NASC<UK>\tb\tEuropean Arabidopsis Stock Centre\t\t",
"NASC<USA-MA>\ts\tMassachusetts College of Liberal Arts, Biology Department\t\t",
"NAT\ts\tSeale-Hayne Agricultural College\t\t",
"NATC\ts\tNorthwestern State University, Biological Sciences Department\t\t",
"NAU\ts\tNanjing Agricultural University, Department of Plant Science\t\t",
"NAUF\ts\tNorthern Arizona University\t\t",
"NAUJ\ts\tNanjing, Nanjing Agricultural University\t\t",
"NAUVM\ts\tNorthern Arizona University, Museum of Vertebrates\t\t",
"NAVA\ts\tNavajo Natural Heritage Program, Navajo Department of Fish & Wildlife\t\t",
"NBAIM\tc\tNational Bureau of Agriculturally Important Microorganisms\t\t",
"NBFGR\ts\tNational Bureau of Fish Genetic Resources (Indian Council of Agricultural Research)\t\t",
"NBFGR:CHN\ts\tNational Bureau of Fish Genetic Resources (Indian Council of Agricultural Research), Cochin Unit",
"NBG\ts\tNational Botanical Institute\t\t",
"NBGB<BEL>\tsb\tNational Botanical Garden, Belgium\t\t",
"NBIMCC\tc\tNational Bank for Industrial Microorganisms and Cell Cultures\t\t",
"NBM\ts\tNew Brunswick Museum\t\t",
"NBMB\ts\tSt. John's, New Brunswick Museum\t\t",
"NBME\ts\tNational Butterfly Museum (Saruman Museum)\t\t",
"NBNM\ts\tNational Park Service\t\t",
"NBPC\ts\tNational Birds of Prey Centre\t\t",
"NBPGR\tb\tNational Bureau of Plant Genetic Resources\t\t",
"NBRC\tc\tNITE Biological Resource Center\t\t",
"NBRP\tb\tNational Bio-Resource Project\t\t",
"NBSB\ts\tNational Biomonitoring Specimen Bank, U.S. Geological Survey\t\t",
"NBSB:Bird\ts\tNational Biomonitoring Specimen Bank, U.S. Geological Survey, bird collection",
"NBSB:Mamm\ts\tNational Biomonitoring Specimen Bank, U.S. Geological Survey, mammal tissue collection",
"NBSI\ts\tBiologische Station Neusiedler See\t\t",
"NBV\ts\tKoninklijke Nederlandse Botanische Vereniging\t\t",
"NBY\ts\tNewbury District Museum\t\t",
"NBYC\ts\tNewberry College, Department of Biology\t\t",
"NCAIM\tc\tNational Collection of Agricultural and Industrial Microorganisms\t\t",
"NCAM\tc\tNational Collection of Agricultural Microorganisms\t\t",
"NCAS\ts\tRutgers University, Biological Sciences Department\t\t",
"NCATG\ts\tNorth Carolina A & T State University, Biology Department\t\t",
"NCAW\ts\tNorth-West College of Agriculture\t\t",
"NCB\tc\tNational Culture Bank\t\t",
"NCBS\ts\tYale University, Connecticut Botanical Society\t\t",
"NCC<FRA>\tc\tNantes Culture Collection\t\t",
"NCC<USA-CA>\ts\tSonoma State University, Biology Department\t\t",
"NCCB\tc\tThe Netherlands Culture Collection of Bacteria\tNCCB<NLD>",
"NCCBH\ts\tNature Conservancy Council, Balloch\t\t",
"NCCE\ts\tNature Conservancy Council, Edinburgh\t\t",
"NCCH\ts\tNature Conservancy Council\t\t",
"NCCN\ts\tNature Conservancy Council, Norwich\t\t",
"NCCP\tc\tNational Culture Collection for Pathogens\t\t",
"NCCP<PAK>\tc\tNational Culture Collection of Pakistan\t\t",
"NCCPF\tc\tNational Culture Collection of Pathogenic Fungi\t\t",
"NCDC\tc\tNational Collection of Dairy Cultures\t\t",
"NCE\ts\tUniversity of Newcastle upon Tyne, School of Biological Sciences\t\t",
"NCF\ts\tDepartment of Forest Insects, Northwest College of Forestry\t\t",
"NCFB\tc\tNational Collection of Food Bacteria\t\t",
"NCH\ts\tNorwich Botanical Society\t\t",
"NCHU\ts\tNational Chung Hsing University\t\t",
"NCHU:ZOOL\ts\tNational Chung Hsing University, Department of Life Science",
"NCIM\tc\tNational Collection of Industrial Microorganisms\t\t",
"NCIMB\tc\tNational Collections of Industrial Food and Marine Bacteria (incorporating the NCFB)\tNCIB,NCMB",
"NCIP\ts\tPusat Penelitian dan Pengembangan Oseanologi\t\t",
"NCKU\ts\tNational Cheng-Kung University, Biology Department\t\t",
"NCLN\ts\tNew College\t\t",
"NCMA\ts\tRaleigh, North Carolina Department of Environmental Health and Natural Resources\t\t",
"NCMH\tc\tThe North Carolina Memorial Hostital\t\t",
"NCMK\ts\tNorwich Castle Museum\t\t",
"NCP\th\tNational  Collection of Passiflora\t\t",
"NCPF\tc\tNational Collection of Pathogenic Fungi\t\t",
"NCPPB\tc\tNational Collection of Plant Pathogenic Bacteria\t\t",
"NCPV\tc\tNational Collection of Pathogenic Viruses\t\t",
"NCS\ts\tNorth Carolina State University\t\t",
"NCSC<THA>\tc\tNational Center of Streptococcus Collection, Department of Microbiology, Faculty of Medical Science\t\t",
"NCSC<USA-NC>\ts\tNorth Carolina State University, Botany Department\t\t",
"NCSLG\th\tNorth Carolina State University\t\t",
"NCSM\ts\tNorth Carolina Museum of Natural Sciences\tNCSMNS",
"NCSU\ts\tNorth Carolina State University Collections\t\t",
"NCTC\tc\tNational Collection of Type Cultures\t\t",
"NCU\ts\tUniversity of North Carolina, North Carolina Botanical Garden\t\t",
"NCUT\ts\tNicolaus Copernicus University\t\t",
"NCWRF\tc\tNational Collection of Wood Rotting Fungi\t\t",
"NCY\ts\tConservatoire et Jardins Botaniques de Nancy\t\t",
"NCYC\tc\tNational Collection of Yeast Cultures\t\t",
"ND\ts\tUniversity of Notre Dame, Department of Biological Sciences\t\t",
"NDA\ts\tNorth Dakota State University, Animal and Range Sciences Department\t\t",
"NDAA\ts\tOrange, New South Wales Department of Agriculture\t\t",
"NDAT\ts\tDepartment of Agriculture, Tunisia\t\t",
"NDFC\ts\tNewfoundland Department of Forestry\t\t",
"NDG\ts\tUniversity of Notre Dame, Department of Biological Sciences\t\t",
"NDO\ts\tDivision of Forest Research, Forest Department\t\t",
"NDSR\ts\tNational Drosophila Species Resource Center\t\t",
"NDSU\ts\tNorth Dakota State University\t\t",
"NDTC\ts\tNingde Teachers College, Biology Department\t\t",
"NE\ts\tUniversity of New England\t\t",
"NEB\ts\tUniversity of Nebraska State Museum\t\t",
"NEBC\ts\tHarvard University\t\t",
"NEBK\th\tUniversity of Nebraska at Kearney\t\t",
"NEFI\ts\tNortheastern Forestry University, Forestry Department\t\t",
"NEM\tc\tFaculte de Medecine Necker-Enfants Malades\t\t",
"NEMO\ts\tTruman State University\t\t",
"NEMSU\ts\tTruman State University\t\t",
"NEMU\ts\tNewark Museum\t\t",
"NENU\ts\tNortheast Normal University, Biology Department\t\t",
"NEPCC\tc\tNorth East Pacific Culture Collection\t\t",
"NESH\ts\tUniversity of Nevada\t\t",
"NEU\ts\tUniversite de Neuchatel, Laboratoire de botanique evolutive\t\t",
"NEUN\th\tNear East University\t\t",
"NEW\ts\tUniversity of Newcastle\t\t",
"NEWHM\ts\tHancock Museum\t\t",
"NEZ\ts\tMuseum, Zoology Department, University of New England\t\t",
"NF\ts\tNanjing Forestry University, Forest Resources and Environment\t\t",
"NFCCI\tc\tNational Fungal Culture Collection of India\t\t",
"NFCCP\tc\tNational Fungal Culture Collection of Pakistan\t\t",
"NFLD\ts\tMemorial University of Newfoundland, Biology Department\t\t",
"NFM\ts\tNewfoundland Museum\t\t",
"NFO\ts\tNiagara Parks Botanical Gardens and School of Horticulture\t\t",
"NFRC\ts\tNorthern Forest Research Centre\t\t",
"NFRDI\tc\tNational Fisheries Research & Development Institute\t\t",
"NFRI\tc\tNorwegian Forest Research Institute\t\t",
"NFRN\ts\tCanadian Forest Service, NRCan\t\t",
"NGBB\th\tNezahat Gokyigit Botanik Bahcesi\t\t",
"NGCPR\th\tNaoroji Godrej Centre for Plant Research\t\t",
"NGI\ts\tNanjing Geographical Institute\t\t",
"NGM\ts\tBromley House Library\t\t",
"NGMC\ts\tNational Geological Museum of China\t\t",
"NGR\tc\tPlant Pathology\t\t",
"NH\ts\tSouth African National Biodiversity Institute\t\t",
"NHA\ts\tUniversity of New Hampshire, Plant Biology Department\t\t",
"NHCP\th\tNational Bureau of Plant Genetic Resources\t\t",
"NHES\ts\tConnecticut Agricultural Experiment Station, Entomology Department\t\t",
"NHG\ts\tNaturhistorische Gesellschaft e. V., Abteilung Botanik\t\t",
"NHI\th\tNatural History Institute\t\t",
"NHIC\ts\tOntario Ministry of Natural Resources\t\t",
"NHL\tc\tNational Institute of Hygienic Sciences\t\t",
"NHM<CHE>\ts\tNaturhistorisches Museum, Bern\t\t",
"NHM<GBR-Nottingham>\ts\tUniversity of Nottingham, Botany Department\t\t",
"NHMA\ts\tNatural History Museum, Denmark\t\t",
"NHMB<CHE>\ts\tNaturhistorisches Museum, Basel\t\t",
"NHMB<HUN>\ts\tNatural History Museum Bucharest\t\t",
"NHMBe\ts\tNaturhistorisches Museum Bern\t\t",
"NHMC<GRC>\ts\tNatural History Museum of Crete, University of Crete, Department of Botany\t\t",
"NHMC<MMR>\ts\tNatural History Museum, Rangoon\t\t",
"NHME\ts\tNatuurhistorisch Museum\t\t",
"NHMF\th\tNatural History Museum Fribourg\t\t",
"NHMG<CHN>\ts\tNatural History Museum of Guangxi\t\t",
"NHMG<SWE>\ts\tGoteborgs Naturhistoriska Museet\t\t",
"NHMK\ts\tLandesmuseum fuer Karnten\t\t",
"NHML\ts\tNatural History Museum, Tripoli\t\t",
"NHMM\ts\tNatuurhistorische Museum Maastricht\t\t",
"NHMM-LS\ts\tNaturhistorisches Museum/Landessammlung fuer Naturkunde Rheinland-Pfalz\t\t",
"NHMN\ts\tNottingham Natural History Museum (Wollaton Hall)\t\t",
"NHMR<HRV>\ts\tNatural History Museum Rijeka\t\t",
"NHMR<ISL>\ts\tNatural History Museum, Reykjavik\t\t",
"NHMR<NLD>\ts\tNatuurhistorisch Museum\t\t",
"NHMS\th\tNatural History Museum Split\t\t",
"NHMTU\ts\tNatural History Museum, Tribhuvan University\t\t",
"NHMUK\tsb\tNatural History Museum, London\tBM,BM(NH),BMNH,NHM,NHM R,NMH",
"NHMUK<PAK>\ts\tNatural History Museum, Karachi\t\t",
"NHMW\ts\tNaturhistorisches Museum, Wien\t\t",
"NHNC\ts\tLa Chaux-de-Fons\t\t",
"NHNE\ts\tNew England College, Biology Department\t\t",
"NHR\th\tInstitute of Scientific and Technological Research (IRST)\t\t",
"NHRI\ts\tIslandic Museum of Natural History\t\t",
"NHRM\ts\tNaturhistoriska Rijkmuseet\t\t",
"NHRS\ts\tSwedish Museum of Natural History, Entomology Collections\t\t",
"NHSD\ts\tNatural History Society of Dublin\t\t",
"NHST\ts\tMuseum of Natural History, Reunion\t\t",
"NHT\ts\tTropical Pesticides Research Institute\t\t",
"NHV\ts\tInstitut fuer Landwirtschaftliche Botanik\t\t",
"NI<JPN>\tc\tNagao Institute\t\t",
"NI<SVK>\ts\tSlovenska pol'nohospodarska Univerzita, Katedra botaniky\t\t",
"NIAB\tb\tNational Institute of Agricultural Botany\t\t",
"NIAES\tc\tNational Institute for Agro-Environmental Sciences\t\t",
"NIAH\tc\tNational Institute of Animal Health\t\t",
"NIAID\tc\tNational Institute of Allergy and Infectious Diseases\t\t",
"NIAS\tsb\tNational Institute of Agrobiological Sciences\t\t",
"NIBH\tc\tNational Institute of Bioscience and Human-Technology\t\t",
"NIBR\tscb\tNational Institute of Biological Resources\tNNIBR",
"NIBSC\tb\tNational Institute for Biological Standards and Control\t\t",
"NICC\ts\tNational Insect Collection\t\t",
"NICD\ts\tMalaria Research Center\t\t",
"NICE\ts\tMuseum d'Histoire Naturelle\t\t",
"NICH\ts\tHattori Botanical Laboratory\t\t",
"NIES\tc\tMicrobial Culture Collection\t\t",
"NIFI\ts\tNational Inland Fisheries Institute\t\t",
"NIFRS\ts\tNational Research Institute of Fisheries Science\t\t",
"NIG\ts\tNanjing Geographical Institute\t\t",
"NIGL\ts\tNanjing Institute of Geography and Limnology\t\t",
"NIGP\ts\tNaking Institute of Geology and Palaeontology\t\t",
"NIHHS\th\tNational Institute of Horticultural and Herbal Science, RDA\t\t",
"NIM\th\tMuseum d'histoire naturelle de Nimes\t\t",
"NIMM\th\tNational Institute of Medicinal Materials\t\t",
"NINF\ts\tNewfoundland Insectarium\t\t",
"NIO\ts\tNational Institute of Oceanography\t\t",
"NIOCC\tc\tNational Institute of Oceanography Culture Collection\t\t",
"NIPH\tc\tNational Institute of Public Health, Collection A. Nemec\t\t",
"NIPR\ts\tNational Institute of Polar Research, Biological Data Department\t\t",
"NIT\ts\tJardim Botanico de Niteroi\t\t",
"NIVA\tc\tCulture Collection of Algae (NIVA)\t\t",
"NIWA\ts\tNational Institute of Water and Atmospheric Research\t\t",
"NJ\ts\tNjala University College\t\t",
"NJM<CZE>\ts\tOkresni vlastivedne muzeum\t\t",
"NJM<JPN>\tc\tNippon Veterinary and Animal Science University\t\t",
"NJNU\ts\tNanjing Normal University, Biology Department\t\t",
"NJSM\ts\tNew Jersey State Museum\t\t",
"NKA\tc\tNationales Konsiliarlabor fur Adenoviren\t\t",
"NKMC\ts\tNational Kweiyang Medical College\t\t",
"NKME\ts\tNaturkundemuseum Erfurt\t\t",
"NKMU\ts\tNankai University Museum\t\t",
"NKU\ts\tNankai University, Biology Department\t\t",
"NKUM\ts\tNankai University\t\t",
"NLEC\ts\tNeal L. Evenhuis\t\t",
"NLH\ts\tAgricultural University of Norway, Department of Biology and Nature Conservation\t\t",
"NLHD\ts\tNiedersachsisches Landesmuseum\t\t",
"NLPS\ts\tNottingham Literary and Philosophical Society\t\t",
"NLSN\ts\tNotre Dame University, Biological Sciences Department\t\t",
"NLU\ts\tUniversity of Louisiana at Monroe, Museum of Natural History\t\t",
"NLUH\ts\tUniversity of the Philippines College Baguio\t\t",
"NM\ts\tNorthern Michigan University, Biology Department\t\t",
"NMAC\ts\tInner Mongolia Agricultural University, Department of Pratacultural Science\t\t",
"NMAG\ts\tNaturhistorisches Museum, Augsburg\t\t",
"NMB\tc\tNingbo Marine Biotechnology\t\t",
"NMB<CHE>\ts\tNaturhistorishes Museum\t\t",
"NMB<ZAF>\ts\tNational Museum, Bloemfontein\t\t",
"NMB<ZAF>:P\ts\tNational Museum, Bloemfontein, The Protozoan collection of the National Museum",
"NMBA<ARG>\ts\tNational Museum, Buenos Aires\t\t",
"NMBA<AUT>\ts\tNaturhistorisches Museum der Benediktiner-Abtei\t\t",
"NMBA<CHE>\ts\tNaturhistorisches Museum, Basel\t\t",
"NMBE\ts\tNaturhistorisches Museum der Burgergemeinde Bern\tNHM",
"NMBO\ts\tNational Museum, Bloemfontein\t\t",
"NMBT\th\tNatuurmuseum Brabant\t\t",
"NMBZ\ts\tNatural History Museum of Zimbabwe\t\t",
"NMC\ts\tNew Mexico State University, Department of Biology\t\t",
"NMC<CAN>\ts\tCanadian Museum of Nature\tCMN",
"NMCC<IND>\tc\tNorth Maharashtra Microbial Culture Collection Centre\t\t",
"NMCDC\ts\tInner Mongolia Center for Endemic Disease Control and Research\t\t",
"NMCI<JPN>\ts\tNoto Marine Center Ishikawa Prefecture\t\t",
"NMCI<JPN>:AR\ts\tNoto Marine Center Ishikawa Prefecture, Arthropoda collection",
"NMCI<JPN>:EC\ts\tNoto Marine Center Ishikawa Prefecture, Echinodermata",
"NMCI<JPN>:IV\ts\tNoto Marine Center Ishikawa Prefecture, Invertebrata",
"NMCI<JPN>:MO\ts\tNoto Marine Center Ishikawa Prefecture, Mollusca collection",
"NMCI<JPN>:P\ts\tNoto Marine Center Ishikawa Prefecture, Pisces  and Coelenterata",
"NMCI<JPN>:S\ts\tNoto Marine Center Ishikawa Prefecture, Sea weed",
"NMCL\ts\tNaturkunde-Museum\t\t",
"NMCR\ts\tNew Mexico State University, Department of Animal and Range Sciences\t\t",
"NME\ts\tSammlung des Naturkundemseum Erfurt\t\t",
"NMED\ts\tNew Mexico Environment Department\t\t",
"NMEG\ts\tNaturkundesmuseum\t\t",
"NMFC\ts\tInner Mongolia Forestry College, Desert Control and Utilization Department\t\t",
"NMFSH\ts\tNational Marine Fisheries Service\t\t",
"NMG\ts\tNaturhistoriska Riksmuseet\t\t",
"NMI\ts\tNational Museum of Ireland\t\t",
"NMI<POL>\tc\tBacteria collection of National Institute of Public Health, National Medicines Institute, Poland\t\t",
"NMID\ts\tNational Museum of Ireland\t\t",
"NMK\ts\tNational Museums of Kenya\t\t",
"NMKE\ts\tNational Museum of Kenya\t\t",
"NMKL\ts\tNational Museum of Malaysia\t\t",
"NML\tc\tNational Microbiology Laboratory, Public Health Agency of Canada\tNML-HCCC",
"NMLS\ts\tNatur-Museum Luzern\t\t",
"NMLU\ts\tNatur-Museum Luzern, Botany Department\t\t",
"NMMA\ts\tNantucket Maria Mitchell Association, Natural Sciences Department\t\t",
"NMMBP\ts\tNational Museum of Marine Biology and Aquarium\tMNNB-P",
"NMMH\ts\tNorth Manchurian Museum\t\t",
"NMML\ts\tNational Marine Mammal Laboratory\t\t",
"NMMNH\ts\tNew Mexico Museum of Natural History and Science\t\t",
"NMMNH:Mamm\ts\tNew Mexico Museum of Natural History and Science, Mammal collection",
"NMN\ts\tNorthamptonshire Natural History Society\t\t",
"NMND\ts\tNational Museum of Natural History, New Delhi\t\t",
"NMNH<IND>\ts\tNational Museum of Natural History, New Delhi\t\t",
"NMNHI\ts\tNational Museum of Natural History, New Delhi\t\t",
"NMNK\ts\tNational Museum of Nepal\t\t",
"NMNL\th\tNatuurmuseum Nijmegen e.o.\t\t",
"NMNS\ts\tNational Museum of Natural Science\t\t",
"NMNW\ts\tNational Museum of Namibia\t\t",
"NMNZ\ts\tNational Museum of New Zealand\t\t",
"NMNZ:AI\ts\tNational Museum of New Zealand, Insects",
"NMNZ:AM\ts\tNational Museum of New Zealand, Amphibians",
"NMNZ:AS\ts\tNational Museum of New Zealand, Spiders",
"NMNZ:CR\ts\tNational Museum of New Zealand, Crustacea",
"NMNZ:M\ts\tNational Museum of New Zealand, Molluscs",
"NMNZ:MM\ts\tNational Museum of New Zealand, Marine Mammals",
"NMNZ:OR\ts\tNational Museum of New Zealand, Birds",
"NMNZ:P\ts\tNational Museum of New Zealand, Fish",
"NMNZ:RE\ts\tNational Museum of New Zealand, Reptiles",
"NMNZ:S\ts\tNational Museum of New Zealand, Fossil Vertebrates",
"NMNZ:TS\ts\tNational Museum of New Zealand, Tissue Collection",
"NMNZ:TSA\ts\tNational Museum of New Zealand, Tissue Collection",
"NMP<CZE>\ts\tNational Museum (Prague)\t\t",
"NMP<ZAF>\ts\tNatal Museum\t\t",
"NMPC\ts\tNational Museum Prague\tMNHP<CZE>",
"NMPC:ENT\ts\tNational Museum Prague, Entomology Collection",
"NMPG<CHN>\ts\tZhejiang Institute of Traditional Chinese Medicine\t\t",
"NMPG<DEU>\ts\tMuseum der Natur-Gotha\t\t",
"NMPI\ts\tDivision of Plant Industry\t\t",
"NMQR\ts\tNational Museum, Bloemfontein\t\t",
"NMR\th\tSemyung University\t\t",
"NMRC<USA-MD>\tc\tNaval Medical Research Center\t\t",
"NMRC<USA-MD>:RDD\tc\tNaval Medical Research Center, Rickettsial Diseases Division",
"NMS\ts\tNational Museums of Scotland\tNMSZ,NSMZ,RSM<GBR>,RSME",
"NMS-G\ts\tNational Museums of Scotland - Geology & Zoology\t\t",
"NMSA\ts\tNatal Museum\t\t",
"NMSL\ts\tNational Museum of Sri Lanka\t\t",
"NMSR\ts\tNaturhistorisches Museum im Thuringer Landes museum Heidecksburg zu Rudolstadt\t\t",
"NMSU<USA-MO>\ts\tNorthwest Missouri State University, Biology Department\t\t",
"NMSU<USA-NM>\ts\tNew Mexico State University\t\t",
"NMTC\ts\tInner Mongolia Normal University, Biology Department\t\t",
"NMTT\ts\tNational Museum and Art Gallery, Port-of-Spain\t\t",
"NMV<AUS>\ts\tMuseum Victoria\tNMM",
"NMV<AUS>:A\ts\tMuseum Victoria, Ichthyology",
"NMV<AUS>:AV\ts\tMuseum Victoria, Entomology - Australian Voucher Specimens",
"NMV<AUS>:B\ts\tMuseum Victoria, Ornithology",
"NMV<AUS>:BE\ts\tMuseum Victoria, Ornithology - Eggs",
"NMV<AUS>:BUP\ts\tMuseum Victoria, Buprestidae",
"NMV<AUS>:C\ts\tMuseum Victoria, Mammology",
"NMV<AUS>:COL\ts\tMuseum Victoria, Coleoptera",
"NMV<AUS>:D\ts\tMuseum Victoria, Herpetology",
"NMV<AUS>:DIP\ts\tMuseum Victoria, Diptera",
"NMV<AUS>:DTB\ts\tMuseum Victoria, Ornithology - Donald Thompson Collection",
"NMV<AUS>:DTD\ts\tMuseum Victoria, Herpetology - Donald Thompson Collection",
"NMV<AUS>:F\ts\tMuseum Victoria, Invertebrates Collection",
"NMV<AUS>:G\tb\tMuseum Victoria, DNA Products",
"NMV<AUS>:H\ts\tMuseum Victoria, Hygrobatidae",
"NMV<AUS>:HEM\ts\tMuseum Victoria, Hemiptera",
"NMV<AUS>:HET\ts\tMuseum Victoria, Heteroptera",
"NMV<AUS>:HLW\ts\tMuseum Victoria, Ornithology - H.L. White Collection",
"NMV<AUS>:HYM\ts\tMuseum Victoria, Hymenoptera",
"NMV<AUS>:ISO\ts\tMuseum Victoria, Isoptera",
"NMV<AUS>:J\ts\tMuseum Victoria, Crustacea",
"NMV<AUS>:K\ts\tMuseum Victoria, Arachnology",
"NMV<AUS>:LEP\ts\tMuseum Victoria, Lepidoptera",
"NMV<AUS>:MEC\ts\tMuseum Victoria, Mecoptera",
"NMV<AUS>:MEG\ts\tMuseum Victoria, Megaloptera",
"NMV<AUS>:NEU\ts\tMuseum Victoria, Neuroptera",
"NMV<AUS>:NOH\ts\tMuseum Victoria, Northofagus Project",
"NMV<AUS>:ODO\ts\tMuseum Victoria, Odonata",
"NMV<AUS>:P\ts\tMuseum Victoria, Paleontology & Paleobotany",
"NMV<AUS>:T\ts\tMuseum Victoria, Entomlogy Type Collection",
"NMV<AUS>:TRI\ts\tMuseum Victoria, Trichoptera",
"NMV<AUS>:Z\ts\tMuseum Victoria, Tissue Collection",
"NMV<JPN>\ts\tNakagawa Museum at Nakagawa-cho\t\t",
"NMW<AUT>\ts\tNaturhistorisches Museum, Wien\tNHMV",
"NMW<GBR>\ts\tNational Museums & Galleries of Wales, Department of Biodiversity and Systematic Biology\t\t",
"NMWC\ts\tNational Museum of Wales\t\t",
"NMWZ\ts\tNational Museum of Wales\t\t",
"NMZB\ts\tNational Museum of Zimbabwe\t\t",
"NMZL\ts\tNational Museum of Zambia\t\t",
"NNA\ts\tNanning Arboretum\t\t",
"NNHMK\ts\tNational Natural History Museum of the Ukraine\t\t",
"NNKN\ts\tNoordbrabants Natuurmuseum\t\t",
"NNM\ts\tNationaal Natuurhistroisch Museum\t\t",
"NNMN\ts\tNationaal Natuurhistorisch Museum Naturalis\t\t",
"NNSU\ts\tN. I. Lobachevsky Nizhni Novgorod State University, Department of Botany\t\t",
"NO\ts\tTulane University, Department of Ecology and Evolutionary Biology\t\t",
"NOAA\ts\tNational Oceanic and Atmospeheric Administration\t\t",
"NOAA:MarFor\ts\tNational Oceanic and Atmospeheric Administration, Marine Forensics",
"NOAS\ts\tNew Orleans Academy of Science\t\t",
"NOCC\ts\tNational Orchid Conservation Center\t\t",
"NOCS-DC\ts\tNational Oceanography Center Southampton Discovery Collections\t\t",
"NODCAR\tc\tmarwa mokhtar Abd Rabo\t\t",
"NoF\tc\tThe Fungus Culture Collection of the Northern Forestry Centre\t\t",
"NOI\ts\tNanhai Oceanographic Institute\t\t",
"NOLS\ts\tUniversity of New Orleans, Biological Sciences Department\t\t",
"NOSU\ts\tNortheastern State University, Natural Sciences and Mathematics Department\t\t",
"NOT\ts\tNottingham City Natural History Museum\t\t",
"NOTM\ts\tUniversity of Nottingham, Manuscript Department\t\t",
"NOU\ts\tInstitut de Recherche pour le Developpement, Botany and Applied Ecology Department\t\t",
"NPA\ts\tNanjing Institute of Geology and Paleontology, Academia Sinica\t\t",
"NPB\ts\tNatal Parks, Game, and Fish Preservation Board, Research Section\t\t",
"NPC\ts\tNational Pusa Collection\t\t",
"NPIB\ts\tNorthwest Plateau Institute of Biology\t\t",
"NPP\tc\tN.P.P\t\t",
"NPRI\ts\tSeoul National University\t\t",
"NPS\ts\tUnited States National Park Service\t\t",
"NPSC\ts\tNorthern Prairie Science Center\t\t",
"NPT\ts\tNewport Museum and Art Gallery\t\t",
"NPWRC\ts\tNorthern Prairie Research Center\t\t",
"NR\th\tInstitute of Forest Ecology Slovak Academy of Sciences\t\t",
"NRC\tc\tDivision of Biological Sciences, National Research Council of Canada\t\t",
"NRC<EGY>\ts\tNational Research Centre\t\t",
"NRCC\ts\tNational Research Council of Canada\t\t",
"NRCS\tc\tNational Reference Center for Streptococci in Aachen\t\t",
"NRIBAS\ts\tNational Research Institute of Biology, Academia Sinica\t\t",
"NRIC\tc\tNODAI Research Institute Culture Collection\t\t",
"NRL\tc\tNeisseria Reference Laboratory\t\t",
"NRM\ts\tSwedish Museum of Natural History\t\t",
"NRN\ts\tNairn Literary Society Library, Public Library\t\t",
"NRNZ\ts\tNorthland Regional Museum\t\t",
"NRPSU\tc\tDepartment of Agro-industry, Faculty of Natural Resources\t\t",
"NRRL\tc\tAgricultural Research Service Culture Collection\t\t",
"NRRL:MOLD\tsc\tAgricultural Research Service Culture Collection, Mold collection",
"NRRL:PROK\tsc\tAgricultural Research Service Culture Collection, Prokaryotic collection",
"NRRL:YEAST\tsc\tAgricultural Research Service Culture Collection, Yeast Collection",
"NRS\ts\tNaturhistoriska Riksmuseet\t\t",
"NRWC\ts\tN. R. Whitney Collection\t\t",
"NRZM\tc\tGerman Reference Center for Meningococci\t\t",
"NS\ts\tCentral Siberian Botanical Garden\t\t",
"NSAC\ts\tNova Scotia Agricultural College, Department of Environmental Sciences\t\t",
"NSCA\ts\tNorth Scotland College of Agriculture\t\t",
"NSCNFB\tc\tNovi Sad Collection of Nitrogen Fixing Bacteria\t\t",
"NSCPM\tc\tNational State Collection of Pathogenic Microorganisms\t\t",
"NSDA\ts\tNevada Division of Agriculture\t\t",
"NSK\ts\tSiberian Central Botanical Garden, Laboratory for Plant Systematics and Floristic Genesis\t\t",
"NSM<CAN>\ts\tNova Scotia Museum of Natural History\t\t",
"NSM<CHN>\ts\tSun Yat-Sen Tomb and Memorial Park Commission\t\t",
"NSM<JPN>\ts\tNSM-PV, National Science Museum\t\t",
"NSMC<CAN>\ts\tNova Scotia Museum\t\t",
"NSMC<USA-NV>\ts\tNevada State Museum\t\t",
"NSMHS\ts\tNevada State Museum and Historical Society\t\t",
"NSMK\ts\tNational Science Museum\t\t",
"NSMT\ts\tNational Museum of Nature and Science, Tokyo\t\t",
"NSMW\ts\tNaturwissenschftlich Sammlung, Museum Wiesbaden\t\t",
"NSNR\ts\tNova Scotia Department of Natural Resources\t\t",
"NSPM\ts\tNova Scotia Museum of Natural History\t\t",
"NSRF\ts\tNova Scotia Research Foundation\t\t",
"NSS\ts\tUniversity of Liverpool Botanic Gardens\t\t",
"NSU\ts\tNortheastern State University, Biological Collections\t\t",
"NSUL\ts\tNorthwestern State University of Louisiana\t\t",
"NSW\ts\tRoyal Botanic Gardens\t\t",
"NSWA\ts\tNew South Wales Department of Agriculture\t\t",
"NSWF\ts\tState Forests of New South Wales\t\t",
"NSWGS\ts\tGeological Survey of New South Wales\t\t",
"NSYU\ts\tNational Sun Yat-sen University\t\t",
"NT\ts\tDepartment of Natural Resources, Environment and the Arts\t\t",
"NTCCI\tc\tCulture Collection, Microbiology and Cell Biology Laboratory\t\t",
"NTDPIF\ts\tNorthern Territory Department of Primary Industry and Fisheries\t\t",
"NTLN\ts\tCounty Record Office, County Archives Department\t\t",
"NTM\ts\tMuseum and Art Gallery of the Northern Territory\t\t",
"NTM<FRA>\ts\tMuseum d'Histoire Naturelle de Nantes\t\t",
"NTN\ts\tCentral Museum and Art Gallery\t\t",
"NTNU\ts\tNational Taiwan Normal University\tNTNUB",
"NTNU-VM\ts\tNorwegian University of Science and Technology, Museum of Natural History and Archaeology\t\t",
"NTOU\tsc\tInstitute of Marine Biology, National Taiwan Ocean University\t\t",
"NTS\ts\tNevada Operations Office, U.S. Department of Energy\t\t",
"NTSC\ts\tUniversity of North Texas, Biological Sciences Department\t\t",
"NTUC\ts\tNational Taiwan University\t\t",
"NTUF\ts\tNational Taiwan University, Forestry Department\t\t",
"NTUM\ts\tNational Taiwan University\t\t",
"NTUMA\ts\tNational Taiwan University\t\t",
"NU<THA>\tc\tDepartment of Microbiology, Faculty of Science\t\t",
"NU<ZAF>\ts\tUniversity of Natal, School of Botany and Zoology\t\t",
"NUA\tc\tDepartment of Microbiology, National University of Athens\t\t",
"NUM\ts\tNagoya University\t\t",
"NUOL\ts\tNational University of Laos\t\t",
"NUSDM\tc\tDepartment of Microbiology, National University of Singapore\t\t",
"NUSMBS\ts\tNiigata University, Sado Marine Biological Station\t\t",
"NUV\ts\tNorwich University, Biology and Life Sciences Department\t\t",
"NUVC\ts\tNortheastern University, Vertebrate Collection\t\t",
"NVDA\ts\tNevada State Department of Agriculture\t\t",
"NVMC\ts\tNevada State Museum\t\t",
"NVRL\ts\tNaturforschende Verein in Riga\t\t",
"NVRW\ts\tNaturhistorisches Verein der Preussische Rheinland und Westfalens\t\t",
"NWAU\ts\tNorth-West Agricultural University\t\t",
"NWC\ts\tUniversity of Northern Iowa, Nixon Wilson Collection\t\t",
"NWC<GBR>\tb\tNational Willows Collection\t\t",
"NWFC\tsb\tNorthwest University of Agriculture Forestry Science & Technology\t\t",
"NWH\ts\tNorfolk Museums and Archaeology Service, Natural History Department\t\t",
"NWK\ts\tNewark District Council Museum\t\t",
"NWMSU\ts\tNorthwest Missouri State University\t\t",
"NWOSU\ts\tNorthwestern Oklahoma State University, Biology Department\t\t",
"NWSW\ts\tNaturwissenschaftliche Sammlungen der Stadt Winterthur\t\t",
"NWT\ts\tHarper Adams Agricultural College\t\t",
"NWTC\ts\tNorthwest Normal University\t\t",
"NWU\ts\tNorthwestern University, Botany Department\t\t",
"NWUB\ts\tNorthwest Normal University, Biology Department\t\t",
"NX\ts\tUniversidade do Estado de Mato Grosso - Campus de Nova Xavantina, Departamento de Ciencias Biologicas\t\t",
"NXAC\ts\tNingxia Agricultural College\t\t",
"NXF\ts\tNingxia Academy of Agriculture and Forestry Sciences\t\t",
"NY\ts\tNew York Botanical Garden\t\t",
"NYA\ts\tNanyue Arboretum\t\t",
"NYAS\ts\tSilvicultural Research Station\t\t",
"NYBG\ts\tNew York Botanical Garden\t\t",
"NYS\ts\tNew York State Museum\t\t",
"NYSM\ts\tNew York State Museum\t\t",
"NYZS\ts\tNew York Zoological Society\t\t",
"NZAC\ts\tNew Zealand Arthropod Collection\tLCR:NZAC",
"NZCS\ts\tUniversity, National Zoological Collection of Suriname\t\t",
"NZFRI\ts\tNew Zealand Forest Research Institute Limited\t\t",
"NZFS\tc\tForest Research Culture Collection\t\t",
"NZG\ts\tNational Zoological Gardens of South Africa\t\t",
"NZOI\ts\tNew Zealand Oceanographic Institute\t\t",
"NZRD\tc\tNew Zealand Reference Culture Collection of Microorganisms, Dairy Section\t\t",
"NZRM\tc\tNew Zealand Reference Culture Collection, Medical Section\t\t",
"NZRP\tc\tNew Zealand Reference Culture Collection and Soil Section\t\t",
"NZSI\ts\tZoological Survey of India, National Zoological Collection\t\t",
"O\ts\tBotanical Museum, Natural History Museum, Oslo\t\t",
"OAC\ts\tOAC Herbarium, Biodiversity Institute of Ontario\tUOG:OAC",
"OAKL\ts\tOakland Museum of California, Natural Sciences Department\t\t",
"OAMB\ts\tOpen Air Museum of Ethnography and Natural Sciences\t\t",
"OAX\ts\tInstituto Politecnico Nacional (CIIDIR-Oax., I.P.N.)\t\t",
"OAXM\ts\tCentro Interdisciplinario de Estudios, Coleccion Mastozoologica (Mexico)\t\t",
"OB\th\tStation Umwelt- und Natur Oberhausen\t\t",
"OBG<OMN>\ts\tThe Oman Botanic Garden\t\t",
"OBI\ts\tCalifornia Polytechnic State University, Biological Sciences Department\t\t",
"OBPF\ts\tPlanting Fields Arboretum State Historic Park\t\t",
"OC\ts\tOberlin College, Biology Department\t\t",
"OCHA\ts\tOchanomizu University\t\t",
"OCLA\ts\tUniversity of Science and Arts of Oklahoma\t\t",
"OCM\tc\tOregon Collection of Methanogens\t\t",
"OCNF\ts\tOchoco National Forest\t\t",
"OCSA\ts\tVeterinary Research Institute\t\t",
"OCU\th\tOklahoma City University\t\t",
"ODAC\ts\tOregon Department of Agriculture\t\t",
"ODU\ts\tOld Dominion University, Department of Biological Sciences\t\t",
"OFC\ts\tOrielton Field Centre\t\t",
"OGDF\ts\tForest Service Region 4, USDA\t\t",
"OGL\tb\tOcean Genome Legacy\t\t",
"OGL:OGR\tb\tOcean Genome Legacy, Ocean Genome Resource",
"OGU\ts\tOdesskij Gosudarstvennij Universitet\t\t",
"OH\ts\tAgricultural Museum of Praha\t\t",
"OHBR\ts\tOntario Hydro\t\t",
"OHHI\th\tOrel State University\t\t",
"OHM\ts\tOldham Microscopical and Natural History Society\t\t",
"OHN\ts\tRegionherbariet i Oskarshamn\t\t",
"OHSC\ts\tOhio Historical Society\t\t",
"OKA\ts\tOksky State Biosphere Reserve\t\t",
"OKAY\ts\tOkayama University of Science, Department of Biosphere-Geosphere System Science\t\t",
"OKL\ts\tUniversity of Oklahoma, Botany and Microbiology Department/ Oklahoma Biological Survey\t\t",
"OKLA\ts\tOklahoma State University, Botany Department\t\t",
"OL\ts\tPalacky University, Botany Department\t\t",
"OLAN\ts\tMinisterio de Recursos Naturales\t\t",
"OLD\ts\tUniversitat Oldenburg\t\t",
"OLDM\ts\tLibraries, Art Galleries and Museums\t\t",
"OLDS\ts\tOlds College, Horticulture Department\t\t",
"OLE\ts\tOundle School, Biology Department\t\t",
"OLM\ts\tVlastivedne muzeum v Olomouci\t\t",
"OLML\ts\tOberoesterreichisches Landesmuseum\t\t",
"OLP\ts\tUniverzity Palackeho, Katedra biologie\t\t",
"OLS\th\tUniversity of Warmia and Mazury\t\t",
"OLTC\ts\tTeachers Training College, Botany Department\t\t",
"OLV\ts\tOlivet College, Biology Department\t\t",
"OLYM\th\tOlympic National Park\t\t",
"OM\ts\tOtago Museum\t\t",
"OMA\ts\tUniversity of Nebraska Omaha, Biology Department\t\t",
"OMC<NZL>\ts\tCatalogues in Otago Museum\t\t",
"OMC<USA>\ts\tMills College, Biology Department\t\t",
"OMJ\ts\tOkresni muzeum a galerie\t\t",
"OMKH\ts\tOblastni muzeum Kutna Hora\t\t",
"OMNH<JPN>\ts\tOsaka Museum of Natural History\t\t",
"OMNH<USA-OK>\ts\tOklahoma Museum of Natural History\t\t",
"OMNHN\ts\tThe Sam Noble Oklahoma State Museum of Natural History\t\t",
"OMNHO\ts\tOsaka Museum of Natural History\t\t",
"OMNO\ts\tOklahoma Museum of Natural History\t\t",
"OMNZ\ts\tOtago Museum\t\t",
"OMP\ts\tPolabske muzeum v Podebradech\t\t",
"OMPB\ts\tOsservatorio per le Malattie delle Piante per la Regione Emilia-Romagna\t\t",
"OMPG\ts\tOsservatorio per le Malattie delle Piante per le Province di Genova e La Spezia\t\t",
"OMPS\ts\tOsservatorio per le Malattie delle Piante per la Sardegna\t\t",
"OMSK\th\tOmsk Pedagogical Univeristy\t\t",
"OMSKM\ts\tOmsk State Agrarian University, Department of Forestry and Plant Conservation\t\t",
"OMUB\ts\tOndokuz Mayis University, Biology Department\t\t",
"ON\ts\tOman Natural History Museum\t\t",
"ONNC\ts\tOffice de la Recherche Scientifique et Technique d'Outre-Mer\t\t",
"ONP\ts\tOlympic National Park\t\t",
"ONPC\ts\tOlympic National Park\t\t",
"OOM\ts\tKameyama Botanical Garden\t\t",
"OP\ts\tSilesian Museum\t\t",
"OPANM\ts\tOtdel Paleontologii i Biostratigrafii Akademii Nauk Moldovkoi Republiki\t\t",
"OPM\ts\tOkinawa Prefectual Museum\t\t",
"ORE\ts\tUniversity of Oregon, Biology Department\t\t",
"OREB\ts\tKarolinska Hoegre Allmaenna Laeroverket\t\t",
"ORI\ts\tOcean Research Institute\t\t",
"ORIS\ts\tInstitute of Steppe of the Ural branch of Russian Academy of Sciences\t\t",
"ORIT\ts\tUniversity of Tokyo\t\t",
"ORM\ts\tMusee des Sciences Naturelles, Departement de Botanique\t\t",
"ORS\tc\tCulture Collection of the Laboratory of Soil Microbiology, ORSTOM\t\t",
"ORSAY\tsb\tUniversite Paris-Sud - Parc Botanique de Launay\t\t",
"ORSC\ts\tOffice de la Recherche Scientifique et Technique d'Outre-Mer\t\t",
"ORST\ts\tOffice de la Recherche Scientifique et Technique d'Outre-Mer\t\t",
"ORSTOM\ts\tOffice de la Recherche scientifique et Technique Outre-mer\t\t",
"ORT\ts\tInstituto Canario de Investigaciones Agrarias (ICIA)\t\t",
"ORTN\ts\tOrton Hall\t\t",
"ORU\ts\tOral Roberts University, Biology Department\t\t",
"OS<USA-OH>\ts\tOhio State University\t\t",
"OS<USA-OR>\ts\tOregon State University\t\t",
"OSA\ts\tOsaka Museum of Natural History\t\t",
"OSAC\ts\tOregon State Arthropod Collection\t\t",
"OSAL\ts\tOhio State University Acarology Laboratory\t\t",
"OSB\ts\tSociety of Botanists\t\t",
"OSBU\ts\tUniversitat Osnabruck, Spezielle Botanik\t\t",
"OSC\ts\tOregon State University, Botany and Plant Pathology Department\t\t",
"OSEC\ts\tK.C Emerson Museum\t\t",
"OSH\ts\tUniversity of Wisconsin Oshkosh, Biology and Microbiology Department\t\t",
"OSI\ts\tOrdnance Survey of Ireland\t\t",
"OSM<CZE>\ts\tOstravske muzeum\t\t",
"OSM<USA-OH>\ts\tOhio State University Museum\t\t",
"OSMC\ts\tSt. Martin's College, Biology Department\t\t",
"OSN\ts\tMuseum am Schoelerberg, Natur und Umwelt\t\t",
"OSTR\th\tUniversity of Ostrava\t\t",
"OSU<USA-OH>\ts\tOhio State University\t\t",
"OSU<USA-OK>\ts\tOklahoma State University, Collection of Vertebrates\t\t",
"OSUC\ts\tOregon State University\t\t",
"OSUF\ts\tOregon State University, Department of Wood Science and Engineering\t\t",
"OSUFW\ts\tOregon State University, Department of Fisheries and Wildlife Mammal Collection\t\t",
"OSUMZ\ts\tOhio State University, Museum of Biological Diversity\t\t",
"OSUO\ts\tOregon State University, School of Oceanography\t\t",
"OSUS\ts\tOklahoma State University\t\t",
"OSW\th\tState University of New York at Oswego\t\t",
"OSWY\ts\tOswestry Museum\t\t",
"OTA\ts\tUniversity of Otago, Botany Department\t\t",
"OTF\ts\tCanadian Forest Service\t\t",
"OTM<NZL>\ts\tOtago Museum\t\t",
"OTM<USA-MT>\ts\tOld Trail Museum\t\t",
"OTSC\ts\tOrganization for Tropical Studies\t\t",
"OTT\ts\tUniversity of Ottawa, Biology Department\t\t",
"OU\ts\tFossil Catalgoue in the Geology Museum\t\t",
"OUA\ts\tUniversite de Ouagadougou\t\t",
"OULU\ts\tUniversity of Oulu, Biology Department\t\t",
"OUM\ts\tOxford University Museum of Natural History\tOUMNH",
"OUPR\ts\tUniversidade Federal de Ouro Preto, Campus Universitario\t\t",
"OUSM\ts\tOklahoma University Stovall Museum\t\t",
"OUT\tc\tDepartment of Biotechnology\t\t",
"OUVC\ts\tOhio University Vertebrate Collection\t\t",
"OVMB\ts\tOkresni vlastivedne muzeum\t\t",
"OWU\ts\tOhio Wesleyan University, Botany-Microbiology Department\t\t",
"OXD\ts\tWadham College\t\t",
"OXF\ts\tUniversity of Oxford, Department of Plant Sciences\t\t",
"OXM\ts\tMagdalen College Library\t\t",
"P\ts\tHerbier National de Paris\tP<FRA>",
"PA\th\tUniversidade Federal do Oeste do Para\t\t",
"PAC\ts\tPennsylvania State University, Biology Department\t\t",
"PACA\ts\tInstituto Anchietano de Pesquisas/UNISINOS\t\t",
"PACMA\ts\tPennsylvania State University, Biology Department\t\t",
"PAD\ts\tUniversita degli Studi di Padova, Centro Interdipartimentale Musei Scientifici\t\t",
"PADA\ts\tPennsylvania Department of Agriculture\t\t",
"PAE\ts\tStiftung Herbarium Paul Aellen, Universitat Basel\t\t",
"PAL\ts\tUniversita degli Studi di Palermo, Dipartimento de Scienze Botaniche\t\t",
"PALEON\ts\tWyoming Dinosaur International Society\t\t",
"PAM\ts\tPennsylvania Department of Agriculture\t\t",
"PAMC\tc\tPolar and Alpine Microbial Collection\t\t",
"PAMG\ts\tEmpresa de Pesquisa Agropecuaria de Minas Gerais (EPAMIG), Departamento de Pesquisa\t\t",
"PAMP\ts\tUniversidad de Navarra, Departamento de Botanica\t\t",
"PAMUH\th\tPamukkale University\t\t",
"PAN\ts\tPanjab University, Botany Department\t\t",
"PAP\ts\tMusee de Tahiti et des Iles\t\t",
"PAR\ts\tMuseo de Ciencias Naturales y Antropologicas Prof. Antonio Serrano, Departamento de Botanica\t\t",
"PARMA\ts\tUniversita degli Studi di Parma\t\t",
"PAS\ts\tJava Sugar Experimental Station\t\t",
"PASA\ts\tPasadena City College, Life Sciences Department\t\t",
"PASG\ts\tPaleontological Section of the Georgian Academy of Sciences\t\t",
"PASM\ts\tPalomar College, Life Sciences Department\t\t",
"PASSM\ts\tPeabody Academy of Science\t\t",
"PAT\ts\tMuseum National d'Histoire Naturelle\t\t",
"PAUH\ts\tUniversity of Texas-Pan American, Biology Department\t\t",
"PAUMC\ts\tPan American University, Mammal Collection\t\t",
"PAUP\ts\tPunjab Agricultural University\t\t",
"PAV\ts\tUniversita di Pavia, Dipartimento de Ecologia del Territorio\t\t",
"PAY\ts\tPaisley Philosophical Institute\t\t",
"PBB\th\tResearch Center for the Conservation of Natural Resources University and Phu An Botanic Gardens\t\t",
"PBC<USA-HI>\tc\tPacific Bacterial Collection\t\t",
"PBF\tc\tPerum Bio Farma\t\t",
"PBH\ts\tPeterborough City Museum\t\t",
"PBL\ts\tBotanical Survey of India, Andaman & Nicobar Circle\t\t",
"PBM\ts\tMahidol University, Department of Pharmaceutical Botany\t\t",
"PBP\ts\tPatagonia Botanical Park\t\t",
"PBS\ts\tChambers Institute, Tweeddale Museum\t\t",
"PBZT\ts\tParc Botanique et Zoologique de Tsimbazaza\t\t",
"PC\ts\tMuseum National d'Histoire Naturelle\t\t",
"PCC\tc\tPasteur Culture Collection of Cyanobacteria\t\t",
"PCE\th\tHugh Nicholson and Tony Abbott Herbarium\t\t",
"PCH\ts\tPrestwich and Pilkington Botanical Society\t\t",
"PCM<IND>\ts\tPresidency College, Botany Department\t\t",
"PCM<POL>\tc\tPolish Collection of Microorganisms\t\t",
"PCMB\tb\tThe Pacific Center for Molecular Biodiversity\tBPBM:PCMB",
"PCNZ\ts\tLincoln Plant Health Station\t\t",
"PCU<FRA>\ts\tMuseum National d'Histoire Naturelle\t\t",
"PCU<THA>\tc\tDepartment of Microbiology, Faculty of Pharmaceutical Sciences\t\t",
"PD\tc\tDutch Plant Protection Service, Culture Collection of Plant Pathogenic Bacteria\t\t",
"PDA\ts\tRoyal Botanic Gardens, Department of Agriculture\t\t",
"PDBK<KOR>\tb\tPlant DNA Bank in Korea\t\t",
"PDD\ts\tNew Zealand Fungal and Plant Disease Herbarium\tLCR:PDD",
"PDTFAU\ts\tPaleoantropoloji Dil ve Tarih Cografya Facueltesi\t\t",
"PE\ts\tInstitute of Botany, Chinese Academy of Sciences\t\t",
"PECA\ts\tPratt Education Center and Aquarium\t\t",
"PECS\ts\tJanus Pannonius Museum, Natural History Department\t\t",
"PEFO\ts\tPetrified Forest\t\t",
"PEI\tcb\tPaul-Ehrlich-Institut\t\t",
"PEI<CAN>\ts\tAgriculture and Agri-Food Canada\t\t",
"PEL\tsc\tUniversidade Federal de Pelotas, Departamento de Botanica\t\t",
"PEL:LIPP\tc\tUniversidade Federal de Pelotas, Departamento de Botanica, Laboratory Plant-Pathogen Interaction",
"PEM<CHN>\ts\tBeijing Medical University, Botany Department\t\t",
"PEM<ZAF>\ts\tPort Elizabeth Museum\t\t",
"PEN\ts\tPenrith Museum\t\t",
"PENN\ts\tUniversity of Pennsylvania Herbarium\t\t",
"PER\th\tCity Museum\t\t",
"PERM\ts\tUniversity of Perm, Botany Department\t\t",
"PERTH\ts\tWestern Australian Herbarium\t\t",
"PERU\ts\tUniversita di Perugia, Dipartimento di Biologia Vegetale\t\t",
"PES\ts\tUniversity of Peshawar, Natural Drug Division\t\t",
"PESA\ts\tCentro Ricerche Floristiche Marche\t\t",
"PET\ts\tNational University of Peking Teachers' College\t\t",
"PEU\ts\tUniversity of Port Elizabeth, Botany Department\t\t",
"PEUFR\ts\tUniversidade Federal Rural de Pernambuco, Departamento de Biologia\t\t",
"PEY\ts\tPeking University, Biology Department\t\t",
"PFC\ts\tPfeiffer University, Biology Department\t\t",
"PFCA\ts\tPacific Forestry Centre Arthropod Reference Collection\t\t",
"PFES\ts\tPetawawa National Forestry Institute, Canadian Forest Service\t\t",
"PFI\ts\tPercy FitzPatrick Institute of African Ornithology\t\t",
"PFRA\ts\tTree Nursery\t\t",
"PFRS\ts\tPacific Southwest Forest and Range Experiment Station\t\t",
"PFSS\ts\tPetrified Forest National Park\t\t",
"PG\th\tPlant Gateway\t\t",
"PGC\tc\tPeterhof Genetic Collection of Microalgae\t\t",
"PGFA\ts\tPyatigorsk State Pharmaceutical Academy, Botany Department\t\t",
"PGL\ts\tPreussiche Geologische Landesanstalt\t\t",
"PGM\ts\tPacific Grove Museum of Natural History\t\t",
"PGMNH\ts\tPacific Grove Museum of Natural History\t\t",
"PGR\tc\tPlant Gene Resources of Canada national and international base and active collections\t\t",
"PGRC<CAN>\tb\tPlant Gene Resources of Canada\t\t",
"PGRC<CAN>:CN\tb\tPlant Gene Resources of Canada, Canadian National Plant Germplasm System",
"PGSC<USA-NC>\tc\tPseudomonas Genetic Stock Center\t\t",
"PH\ts\tAcademy of Natural Sciences, Botany Department\t\t",
"PHA\ts\tPharmaceutical Society of Great Britain\t\t",
"PHARM\th\tSouthern Cross University\t\t",
"PHBL\tc\tPhilip Harris Biological Ltd.\t\t",
"PHEL\ts\tPlant Health and Environment Laboratory\t\t",
"PHEO\th\tKaradag Natural Reserve\t\t",
"PHG\ts\tPeper Harow\t\t",
"PHH\ts\tUniversity of Science, Ho Chi Minh City Vietnam National University\t\t",
"PHIL\ts\tUniversity of the Sciences in Philadelphia, Biological Sciences Department\t\t",
"PI<DEU>\ts\tInstitut und Museum fuer Geologie und Palaeontologie\t\t",
"PI<ITA>\ts\tUniversita di Pisa, Dipartimento di Scienze Botaniche\t\t",
"PI<RUS>\ts\tPaleontological Institute\t\t",
"PIAGR\th\tUniversity of Pisa\t\t",
"PICRC\th\tPalau International Coral Reef Center\t\t",
"PIHG\ts\tFlorida Department of Agriculture and Consumer Services\t\t",
"PIHU\ts\tPaleontological Institut of Helsingfors\t\t",
"PIKN\ts\tKoronivia Research Station\t\t",
"PIMUI\ts\tPalaeontologische Institut und Museum der Universitaet in Innsbruck\t\t",
"PIMUZ\ts\tPalaontologisches Institut und Museum der Universitat Zurich\t\t",
"PIN<GBR>\ts\tPhilosophical Institution of Newport\t\t",
"PIN<RUS>\ts\tPaleontological Institute, Russian Academy of Sciences\t\t",
"PINN\ts\tPinnacles National Monument\t\t",
"PIR\tc\tBulgarian Research Culture Collection\t\t",
"PISR\ts\tPechora-Ilych State Reserve, Russia\t\t",
"PIUU\ts\tPaleontological Institut, University of Uppsala\t\t",
"PKDC\ts\tDivisao de Museu de Historia Natural\t\t",
"PKM\ts\tV. G. Belinsk Pedagogical Institute of Penza\t\t",
"PL\ts\tZapadoceske muzeum\t\t",
"PLAT\th\tState University of New York, College at Plattsburgh\t\t",
"PLES\th\tPlyos State Museum\t\t",
"PLFV\ts\tPrincipality of Liechtenstein\t\t",
"PLH\ts\tPlymouth City Museum and Art Gallery\t\t",
"PLP\th\tInstitute of Himalayan Bioresource Technology\t\t",
"PLU\th\tPacific Lutheran University\t\t",
"PLY\tsc\tPlymouth Institution and Athenaeum\t\t",
"PLYMOUTH\tc\tPlymouth Culture Collection\t\t",
"PLYP\ts\tUniversity of Plymouth, Department of Biological Sciences\t\t",
"PM\ts\tPeabody Essex Museum, Natural History Department\t\t",
"PM<USA-AK>\ts\tPratt Museum\t\t",
"PM<USA-IA>\ts\tPutnam Museum of History and Natural Science\t\t",
"PMA<CAN>\ts\tProvincial Museum of Alberta\t\t",
"PMA<PAN>\ts\tUniversidad de Panama\t\t",
"PMAA\ts\tPalaeontological Collections, Provincial Museum and Achieves of Alberta\t\t",
"PMAE\ts\tRoyal Alberta Museum\t\t",
"PMAG\ts\tPerth Museum and Art Gallery\t\t",
"PMAM\ts\tBeijing Natural History Museum\t\t",
"PMAU\ts\tPeterborough Museum and Art Gallery\t\t",
"PMB\ts\tPrirodnjacki Muzej Srpske Zemije\t\t",
"PMBC\ts\tPhuket Marine Biological Centre\t\t",
"PMFP\ts\tPapeete Museum\t\t",
"PMG<BRA>\ts\tHorto Florestal\t\t",
"PMG<GBR>\ts\tPaisley Museum of Geological Collection\t\t",
"PMH\ts\tCity Museum and Records Office\t\t",
"PMHPS\ts\tPortsmouth Philosophical Society\t\t",
"PMHU\ts\tPalaontologisches Museum\t\t",
"PMIG\ts\tPhyletisches Museum\t\t",
"PMJ\ts\tPhyletisches Museum\t\t",
"PMK<RUS>\ts\tPugachev Regional Museum\t\t",
"PMK<SVK>\ts\tPodunajske muzeum\t\t",
"PMNH<PAK>\ts\tPakistan Museum of Natural History\t\t",
"PMNH<USA-CT>\ts\tPeabody Museum of Natural History\t\t",
"PMNH<USA-MA>\ts\tPratt Museum of Natural History\t\t",
"PMQ\ts\tPublic Museum\t\t",
"PMR\ts\tPrirodoslovni muzej Rijeka\t\t",
"PMS<MKD>\ts\tPrirodonamen Muzej Skopje\t\t",
"PMS<USA-CA>\ts\tPacific Marine Station\t\t",
"PMS<USA-MA>\ts\tPeabody Essex Museum\t\t",
"PMSD\ts\tPettigrew Museum\t\t",
"PMSL\ts\tSlovenian Museum of Natural History (Prirodosloveni Muzej Slovenije)\t\t",
"PMSP\ts\tPrefeitura do Municipio de Sao Paulo, Departamento de Parques e Areas Verdes\t\t",
"PMU<RUS>\ts\tPaleontological Museum of Undory\t\t",
"PMU<SWE>\ts\tPaleontological Museum of Uppsala\t\t",
"PMV\ts\tProvincial Museum\t\t",
"PNBG\ts\tUniversity of the Philippines\t\t",
"PNCM-BIOTECH\tc\tPhilippine National Collection of Microorganisms\t\t",
"PND\th\tDr. Shivaram Karantha  Pilikula Nisarga Dhama\t\t",
"PNG\ts\tDivision of Primary Industry\t\t",
"PNGM\ts\tNational Museum and Art Gallery, Port Moresby\t\t",
"PNH\ts\tPhilippine National Herbarium\t\t",
"PNICMM-INP\ts\tInstituto Nacional de la Pesca (Mexico)\t\t",
"PNL\ts\tPolytechnic of North London, Food and Biological Sciences Department\t\t",
"PNM\ts\tPhilippine National Museum\t\t",
"PNPC\ts\tChickasaw National Recreational Area [formerly Platt National Park]\t\t",
"PNZ\ts\tPenlee House Museum\t\t",
"PO<PRT>\ts\tUniversidade do Porto, Departamento de Botanica\t\t",
"PO<RUS>\ts\tCollection of the Zoological Institute of the Russian Academy of Sciences\t\t",
"POFS\ts\tForest Service, USDA\t\t",
"POKM<RUS-Penza>\ts\tPenza Regional Local History Museum\t\t",
"POKM<RUS-Perm>\ts\tPerm Regional Lore Museum\t\t",
"POL-F\ts\tPollichia, Pfalzmuseum fur Naturkunde Thallichtenberg\t\t",
"POLL\ts\tPfalzmuseum fuer Naturkunde\t\t",
"POM\ts\tPomona College\t\t",
"POP\ts\tTatranske muzeum v Poprade\t\t",
"POR\ts\tUniversita degli Studi di Napoli\t\t",
"PORE\ts\tPoint Reyes National Seashore\t\t",
"PORT\ts\tBioCentro-UNELLEZ\t\t",
"PORUN\ts\tUniversita degli Studi di Napoli, Dip Ar Bo Pa Ve - Sezione Botanica\t\t",
"POZ\ts\tAdam Mickiewicz University, Department of Plant Taxonomy\t\t",
"POZG\ts\tAdam Mickiewicz University, Department of Geobotany\t\t",
"POZM\ts\tAdam Mickiewicz University, Department of Plant Ecology and Environment Protection\t\t",
"POZNB\ts\tAgricultural Academy, Botany Department\t\t",
"POZW\ts\tAdam Mickiewicz University\t\t",
"PPC\th\tPalawan State University\t\t",
"PPCC<AUS>\tc\tPlant Pathology Culture Collection\t\t",
"PPCC<NZL>\ts\tPlant Protection Centre Collection\t\t",
"PPCD\ts\tWest Virginia Department of Agriculture\t\t",
"PPDD\ts\tMinistry of Agriculture\t\t",
"PPFI\ts\tPakistan Forest Institute\t\t",
"PPHM\ts\tPanhandle-Plains Historical Museum\t\t",
"PPI\ts\tNational Pingtung University of Science and Technology, Department of Forestry\t\t",
"PPIHAS\tc\tPlant Protection Institute, Centre for Agricultural Research, Hungarian Academy of Sciences\tPPIHAS",
"PPIU\ts\tM. Utemisov Western Kazakhstanian State University, V. V. Ivanov Department of Botany\t\t",
"PPKMI\tc\tPlant Production Technology Department, Faculty of Agricultural Technology\t\t",
"PPKU1\tc\tDepartment of Plant Pathology, Faculty of Agriculture, Thailand\t\t",
"PPKU2\tc\tDepartment of Plant Pathology, Faculty of Agriculture, Thailand\t\t",
"PPKU3\tc\tDepartment of Plant Pathology, Faculty of Agriculture, Thailand\t\t",
"PPKU4\tc\tDepartment of Plant Pathology, Faculty of Agriculture, Thailand\t\t",
"PPKU5\tc\tDepartment of Plant Pathology, Faculty of Agriculture, Thailand\t\t",
"PPKU6\tc\tDepartment of Plant Pathology, Faculty of Agriculture, Thailand\t\t",
"PPL\ts\tAgricultural Development and Advisory Service, Harpenden Laboratory\t\t",
"PPNP\ts\tPoint Pelee National Park\t\t",
"PPPO\ts\tPusat Penelitian dan Pengembangan Oseanologi\t\t",
"PPPPB\tc\tARC-Plant Protection Research Institute, Plant Pathogenic and Plant Protecting Bacteria\t\t",
"PPRI\tc\tARC-Plant Protection Research, National Collection of Fungi: Culture Collection\t\t",
"PPRL\th\tUSDA-ARS Poisonous Plant Research Lab\t\t",
"PPRZ\ts\tPlant Protection Research Institute\t\t",
"PPSIO\ts\tP. P. Shirshov Institute of Oceanology\t\t",
"PPU\th\tPerm State Teacher Training University\t\t",
"PQFC\tb\tPhu Qui's Fruit Tree Center-Vietnam\t\t",
"PR\ts\tNational Museum in Prague, Department of Botany\t\t",
"PRA\ts\tInstitute of Botany, Academy of Sciences\t\t",
"PRB\ts\tPrague Botanical Garden\t\t",
"PRC\ts\tCharles University, Botany Department\t\t",
"PRE\ts\tNational Botanical Institute - Pretoria\t\t",
"PREM\ts\tSouth African National Collection of Fungi Herbarium\t\t",
"PRF\ts\tSouth African Forestry Research Institute, Environment Affairs Department\t\t",
"PRG\ts\tUniversidad Nacional Pedro Ruiz Gallo\t\t",
"PRH\ts\tPerthshire Society of Natural Science\t\t",
"PRI\ts\tCollege of Eastern Utah, Biology Department\t\t",
"PRICO\ts\tUniversity of Puerto Rico\t\t",
"PRL\tc\tPrairie Regional Laboratory\t\t",
"PRM\ts\tNational Museum, Mycological Department\t\t",
"PROIMI\tc\tPlanta Piloto de Procesos Industriales Microbiologicos\t\t",
"PRU\ts\tUniversity of Pretoria, Botany Department\t\t",
"PRV\ts\tPorvoo Museum of Natural History\t\t",
"PSAE\ts\tAlberta Environmental Centre\t\t",
"PSGB\ts\tUniversity of Bradford, Pharmacy Department\t\t",
"PSK\th\tPskov State University\t\t",
"PSM\ts\tUniversity of Puget Sound, James R. Slater Museum of Natural History\t\t",
"PSO\ts\tUniversidad de Narino\t\t",
"PSP\ts\tParasitic Seed Plants\t\t",
"PSS<GBR>\ts\tPhilosophical Society of Southampton\t\t",
"PSS<MNG>\ts\tPaleontology and Stratigraphic Section of the Geological Institute of the Mongolian Academy of Sciences\t\t",
"PSU<THA>\ts\tPrince of Songkla University, Biology Department\t\t",
"PSU<USA-OR>\ts\tPortland State University, Vertebrate Biology Museum\t\t",
"PSU<USA-OR>:Mamm\ts\tPortland State University, Vertebrate Biology Museum, Mammal Collection",
"PSU<USA-PA>\ts\tPennsylvania State University\t\t",
"PSUB\ts\tUniversity of Botswana\t\t",
"PSUC\ts\tFrost Entomological Museum\t\t",
"PSUMC\ts\tPittsburg State University\t\t",
"PSY\ts\tPaisley Museum\t\t",
"PTBG\ts\tNational Tropical Botanical Garden\t\t",
"PTCC\tc\tPakistan Type Culture Collections\t\t",
"PTCCI\tc\tPersian Type Culture Collection\t\t",
"PTH\ts\tPerth Museum and Art Gallery, Herbarium\tPER",
"PTHL\ts\tLiterary and Antiquarian Society of Perth\t\t",
"PTIS\ts\tPotato Introduction Station\t\t",
"PTN\ts\tEllesmere Chambers\t\t",
"PTTC\tc\tPranakorn Teacher Training College, Department of Biology, Faculty of Science and Technology\t\t",
"PTZ\ts\tKarelian Scientific Centre, Russian Academy of Sciences\t\t",
"PU\ts\tPrinceton University\t\t",
"PU-HI\ts\tDepartment of Palaeontology, Universidad Complutense of Madrid\t\t",
"PUA\ts\tPacific Union College, Biology Department\t\t",
"PUC<CHN>\ts\tBeijing University\t\t",
"PUC<ZAF>\ts\tNorth-West University\t\t",
"PUCMNH\ts\tPacific Union College, Museum of Natural History\t\t",
"PUCP\ts\tPunjab University\t\t",
"PUH\ts\tUniversity of the Philippines, Institute of Biology\t\t",
"PUL\ts\tPurdue University, Department of Botany and Plant Pathology\t\t",
"PUM\ts\tUniversita DI Pisa\t\t",
"PUN\ts\tPunjabi University, Botany Department\t\t",
"PUO\ts\tPortland University\t\t",
"PUP\ts\tUniversity of Peshawar, Botany Department\t\t",
"PUR\ts\tPurdue University, Department of Botany and Plant Pathology\t\t",
"PURC\ts\tPurdue University\t\t",
"PUS\ts\tPuslinch House\t\t",
"PUSC\ts\tUniversity of Southern Colorado, Life Sciences Department\t\t",
"PVB\th\tInstitute of Ecology of the Volga River Basin, Russian Academy of Science\t\t",
"PVF\tc\tPusat Veterinaria Farma\t\t",
"PVGB\tc\tPlant Virus GenBank\t\t",
"PVHR\ts\tUniversite Paris VI\t\t",
"PVL\ts\tPaleontologia de Vertebrados Lillo\t\t",
"PVNH\ts\tORSTOM\t\t",
"PVPH\ts\tPaleontolga de Vertebrados\t\t",
"PVSJ\ts\tMuseo do Ciencias Naturles\t\t",
"PW\ts\tPaleontological Collections\t\t",
"PWRC\ts\tPatuxent Wildlife Research Center\t\t",
"PWU\th\tV.G.Korolenko Poltava National Pedagogical University\t\t",
"PY\ts\tCentro de Estudios y Colecciones Biologicas para la Conservacion\t\t",
"PYCC\tc\tPortuguese Yeast Culture Collection\t\t",
"PYU\ts\tYunnan University, Laboratory of Pteridophyta\t\t",
"PZL\ts\tPenzance Library\t\t",
"PZV\ts\tPetrozavodsk State University, Department of Botany and Plant Physiology\t\t",
"Q\ts\tUniversidad Central\t\t",
"QAME\ts\tDireccion Nacional Forestal, Ministerio de Agricultura y Ganaderia\t\t",
"QAP\ts\tUniversidad Central\t\t",
"QBG\ts\tQueen Sirikit Botanic Garden\t\t",
"QC\ts\tNational Museum of Natural History, Bulawayo\t\t",
"QCA\ts\tPontificia Universidad Catolica del Ecuador, Departamento de Biologia\t\t",
"QCAZ\ts\tMuseo de Zoologia, Pontifica Universidad Catolica del Ecuador\t\t",
"QCAZ:A\ts\tMuseo de Zoologia, Pontifica Universidad Catolica del Ecuador, Amphibian Collection",
"QCAZ:R\ts\tMuseo de Zoologia, Pontifica Universidad Catolica del Ecuador, Reptile Collection",
"QCC\tc\t Qatari Culture Collection\t\t",
"QCNE\ts\tHerbario Nacional del Ecuador\t\t",
"QD\ts\tOcean University of China\t\t",
"QDC\ts\tQinghai Institute for Drug Control\t\t",
"QDPC\ts\tQueensland Department of Primary Industries\t\t",
"QDPI\ts\tQueensland Department of Primary Industries\t\t",
"QEF\ts\tUniversite Laval, Laboratoire d'ecologie forestiere\t\t",
"QF\ts\tInstitute of Forestry\t\t",
"QFA\ts\tUniversite Laval\t\t",
"QFB\ts\tLaurentian Forestry Centre, Canadian Forest Service\t\t",
"QFBE\ts\tLaurentian Forestry Centre, Canadian Forest Service\t\t",
"QFMQ\ts\tQueenstown Museum\t\t",
"QFS\ts\tUniversite Laval\t\t",
"QG\ts\tGeneral Grassland Station of Qinghai\t\t",
"QIBX\ts\tQinghai Institute of Biology\t\t",
"QIMR\ts\tQueensland Institute of Medical Research\t\t",
"QK\ts\tQueen's University, Biology Department\t\t",
"QM\ts\tQueensland Museum\t\t",
"QM<USA-MA>\ts\tU.S. Army Natick Research and Development Center\t\t",
"QM<ZWE>\ts\tQueen Victoria Museum\t\t",
"QMB\ts\tQueensland Museum, Brisbane\t\t",
"QMC\ts\tQueen Mary College\t\t",
"QMEX\ts\tUniversidad Autonoma de Queretaro, Centro Universitario\t\t",
"QMOR\ts\tCollection Entomologique Ouellet-Robert\t\t",
"QMP\ts\tMusee du Quebec\t\t",
"QPAR\ts\tMinistere du Tourisme de la Chasse et de la Peche du Quebec, Laboratoire de Recherches\t\t",
"QPH\ts\tSeminaire de Quebec\t\t",
"QPIM\ts\tDepartment of Primary Industries\t\t",
"QPLS\ts\tBiblioteca Ecuatoriana Aurelio Espinosa Polit\t\t",
"QPNRA\ts\tPrograma Nacional de Regionalizacion, Ministerio de Agricultura y Ganaderia, Departamento de Ecologia\t\t",
"QRS\ts\tAustralian National Herbarium, Division of Plant Industry, CSIRO\t\t",
"QSA\ts\tInstitut de technologie agroalimentaire\t\t",
"QSMI\ts\tQueen Saovabha Memorial Institute\t\t",
"QTC\ts\tQiqihar Teachers College, Biology Department\t\t",
"QUA\ts\tQinghai University, Agriculture Department\t\t",
"QUC\ts\tUniversite Laval, Departement de biologie\t\t",
"QUE\ts\tComplexe scientifique\t\t",
"QUSF\ts\tUniversidad San Francisco de Quito, Biology Department\t\t",
"QVG\ts\tQueen Victoria Museum\t\t",
"QVM\ts\tQueen Victoria Museum\t\t",
"QVMS\ts\tQueen Victoria Memorial Museum\t\t",
"QWA\ts\tUniversity of the North, Qwa Qwa Campus\t\t",
"QYTC\ts\tQingyang Teachers College, Biology Department\t\t",
"R<BRA>\ts\tUniversidade Federal do Rio de Janeiro, Departamento de Botanica\t\t",
"R<CHL>\ts\tDepartamento de Geologia, Universidad de Chile\t\t",
"RAB\ts\tInstitut Scientifique, Departement de Botanique et d'Ecologie Vegetale\t\t",
"RAF\ts\tMyanmar Forest Herbarium\t\t",
"RAM\ts\tRamsey Public Library\t\t",
"RAM<CAN>\ts\tRoyal Alberta Museum\t\t",
"RAME\ts\tRoyal Albert Memorial Museum\t\t",
"RAMK\ts\tRamkhamhaeng University, Biology Department\t\t",
"RAMM\ts\tRoyal Albert Memorial Museum, Leisure and Tourism Department\t\t",
"RANG\ts\tYangon University\t\t",
"RANK\th\tResearch Center of Agriculture and Natural Resources of Kermanshah province\t\t",
"RARS\ts\tRegina Research Station\t\t",
"RAS\ts\tUnion of Burma Applied Research Institute, Pharmaceutical Department\t\t",
"RAU\ts\tLaboratoire de Biologie Vegetale\t\t",
"RAW\ts\tPakistan Agricultural Research Council\t\t",
"RB\ts\tJardim Botanico do Rio de Janeiro\t\t",
"RBCM\ts\tRoyal British Columbia Museum\t\t",
"RBCM:Mamm\ts\tRoyal British Columbia Museum, Mammal Collection",
"RBE\ts\tUniversidade Federal Rural do Rio de Janeiro\t\t",
"RBF\tc\tRaiffeisen Bioforschung\t\t",
"RBINS\ts\tRoyal Belgian Institute of Natural Sciences\t\t",
"RBR\ts\tUniversidade Federal Rural do Rio de Janeiro, Departamento de Botanica\t\t",
"RBS\ts\tRoyal Botanic Society\t\t",
"RBY\ts\tEast Divisional Library\t\t",
"RCAM\ts\tRutgers University, Biology Department\t\t",
"RCAT\tc\tRegional Collection of Animal Viruses and Tissue Cultures\t\t",
"RCB\tc\tRIKEN Cell Bank\t\t",
"RCC\tc\tRoscoff Culture Collection\t\t",
"RCDM\tc\tRepublican Centre for Deposition of Microorganisms of the National Academy of Sciences and Ministry of Education and Science of Armenia\t\t",
"RCHM\ts\tRochdale Museum Service\t\t",
"RCHP\ts\tRochdale Equitable Pioneers' Memorial Museum\t\t",
"RCMC\ts\tRockford College\t\t",
"RCN\ts\tRichmond Naturalists' Field Club\t\t",
"RCR\ts\tRochester Public Museum\t\t",
"RCS\ts\tRoyal College of Surgeon's Museum\tRCSM",
"RCSL\ts\tRoyal College of Surgeons\t\t",
"RCVC\th\tUniversidad Nacional de Rio Cuarto\t\t",
"RDAF\ts\tResearch Department South East Asian Fisheries Development Centre\t\t",
"RDG\ts\tReading Museum and Archive Service\t\t",
"RDS\ts\tRoyal Dublin Society\t\t",
"RE\ts\tLiaoning Reed Science Institute\t\t",
"RED\ts\tUniversity of Redlands, Biology Department\t\t",
"REDM\ts\tReading Museum and Archive Service\t\t",
"REED\th\tReed College\t\t",
"REG\ts\tUniversitaet Regensburg, Regensburgische Botanische Gesellschaft\t\t",
"REGGIO\th\tUniversita Mediterranea di Reggio Calabria\t\t",
"RELC\ts\tINIFAP-SAGAR\t\t",
"REN\ts\tCampus Scientifique de Beaulieu, Laboratoire de Botanique\t\t",
"RENO\ts\tUniversity of Nevada, Environmental and Resource Sciences Department\t\t",
"RENZ\ts\tUniversitaet Basel, The Swiss Orchid Foundation\t\t",
"REP\ts\tDesert Experiment Station of the W.I.R.\t\t",
"RESC\ts\tShasta College\t\t",
"RET\ts\tHerbarium Amanitarum Rooseveltensis\t\t",
"REU\ts\tUniversite de la Reunion\t\t",
"RFA\ts\tUniversidade Federal do Rio de Janeiro, Departamento de Botanica\t\t",
"RFE\ts\tRadcliffe Literary and Scientific Society Museum\t\t",
"RFFP\th\tUniversidade do Estado do Rio de Janeiro\t\t",
"RFNS\ts\tRochdale Field Naturalists' Society\t\t",
"RGM\ts\tNationaal Natuurhistorisch Museum Leiden\t\t",
"RGMC\ts\tMusee Royal de l'Afrique Centrale\t\t",
"RGY\ts\tRugby School Natural History Society Museum\t\t",
"Rh-EF\ts\tMuseum of Grannat\t\t",
"RHK\th\tSt. Berchmans College\t\t",
"RHLCY\ts\tReservoir of Heilongtan\t\t",
"RHM\ts\tPublic Reference Library\t\t",
"RHMC\ts\tRed House Museum\t\t",
"RHMD\ts\tNational Institute of Science Communication\t\t",
"RHMU\tc\tDepartment of Pathology, Faculty of Medical Science, Ramathibordi Hospital\t\t",
"RHS\tc\tPlant Pathology, The Royal Horticultural Society\t\t",
"RHT\ts\tSt. Joseph's College\t\t",
"RI\ts\tRudjer Boskovic Institute\t\t",
"RIA\tc\tThe Russia Research Institute for Antibiotics Culture Collection\t\t",
"RIB\tc\tNational Research Institute of Brewing, Tax Administration Agency\t\t",
"RIBM\tc\tResearch Institute for Brewing and Malting\t\t",
"RICK\ts\tBrigham Young University - Idaho, Department of Biology\t\t",
"RICP<CZE>\tc\tCrop Research Institute\t\t",
"RIFAV\tb\tResearch Institute for Fruits and Vegetables\t\t",
"RIFFL\ts\tResearch Institute of Freshwater Fisheries\t\t",
"RIFY\tc\tInstitute of Enology and Viticulture, Yamanashi University\t\t",
"RIG\ts\tUniversity of Latvia, Department of Botany and Ecology\t\t",
"RIGB\ts\tLatvian State Center of Plant Protection\t\t",
"RIGG\ts\tUniversity of Latvia\t\t",
"RIM\ts\tL'Ecole d'Agriculture\t\t",
"RIMD\tc\tResearch Institute for Microbial Diseases, Research Center for Emerging Infectious Diseases\t\t",
"RIN\ts\tResearch Institute for Nature Management, Botany Department\t\t",
"RIOC\ts\tUniversidad Nacional de Rio Cuarto\t\t",
"RIPO\tc\tPlant Virus Collection\t\t",
"RITFC\tc\tResearch Institute for Tobacco and Fibre Crops\t\t",
"RIVE<SVK>\tc\tResearch Institute for Viticulture and Enology\t\t",
"RIVE<USA-WI>\ts\tUniversity of Wisconsin, Biology Department\t\t",
"RIY\ts\tNational Agriculture and Water Research Center\t\t",
"RIZ\ts\tInstituto de Zootecnia\t\t",
"RKT\th\tRegional Research Institute (Ayurveda)\t\t",
"RLS\ts\tRoyal Latin School\t\t",
"RM<CAN>\ts\tMcGill University, Redpath Museum\t\t",
"RM<NZL>\tc\tRumen Microorganisms\t\t",
"RM<SGP>\ts\tRaffles Museum\t\t",
"RM<USA-WY>\ts\tUniversity of Wyoming Herbarium\t\t",
"RMA<USA-CA>\tc\tR. M. Alden Research Lab\t\t",
"RMBL\ts\tRocky Mountain Biological Laboratory\t\t",
"RMBR\ts\tRaffles Museum of Biodiversity Research\t\t",
"RMCA\ts\tRoyal Museum for Central Africa\t\t",
"RMDRC\ts\tRocky Mountain Dinosaur Resource Center\t\t",
"RMF\tc\tRocky Mountain Herbarium, Fungi\t\t",
"RMFM\ts\tRichmond Marine Fossils Museum\t\t",
"RMNH\ts\tNaturalis Biodiversity Center\t\t",
"RMNH:ACA\ts\tNaturalis Biodiversity Center, Acari collection",
"RMNH:AVES\ts\tNaturalis Biodiversity Center, bird collection",
"RMNH:BRA\ts\tNaturalis Biodiversity Center, brachiopod collection",
"RMNH:BRY\ts\tNaturalis Biodiversity Center, bryozoan collection",
"RMNH:COEL\ts\tNaturalis Biodiversity Center, Coelomate collection",
"RMNH:CRUS\ts\tNaturalis Biodiversity Center, crustacean collection",
"RMNH:CRUS.D\ts\tNaturalis Biodiversity Center, decapod collection",
"RMNH:INS\ts\tNaturalis Biodiversity Center, Insect collection",
"RMNH:MAM\ts\tNaturalis Biodiversity Center, Mammal collection",
"RMNH:MOL\ts\tNaturalis Biodiversity Center, mollusc collection",
"RMNH:PISC\ts\tNaturalis Biodiversity Center, fish collection",
"RMNH:POR\ts\tNaturalis Biodiversity Center, poriferan collection",
"RMNHD\ts\tNaturalis Biodiversity Center\t\t",
"RMNP\ts\tRiding Mountain National Park\t\t",
"RMRC\tb\tRegional Medical Research Centre\t\t",
"RMS\ts\tUniversity of Wyoming Herbarium\t\t",
"RMSC\ts\tRocky Mountain Forest and Range Experiment Station\t\t",
"RMSCC\tc\tRoche Molecular Systems Culture Collection\t\t",
"RMTV\th\tUniversity of Rome Tor Vergata\t\t",
"RMWC\ts\tRandolph-Macon Woman's College, Biology Department\t\t",
"RNG\ts\tUniversity of Reading\t\t",
"RNMUT\ts\tRepublic Nature Museum of Uzbekistan\t\t",
"RO\ts\tUniversita degli Studi di Roma La Sapienza, Dipartimento di Biologia Vegetale\t\t",
"ROAN\ts\tVirginia Western Community College, Biology Department\t\t",
"ROCH\ts\tRochester Academy of Science\t\t",
"ROHB\ts\tCattedra di Micologia, Dipartimento di Biologia Vegetale\t\t",
"ROIG\ts\tEstacion Experimental de Plantas Medicinales Dr. Juan T. Roig\t\t",
"ROM\ts\tRoyal Ontario Museum\t\t",
"ROM:ENT\ts\tRoyal Ontario Museum, Entomology collection",
"ROM:HERP\ts\tRoyal Ontario Museum, Herpetology collection",
"ROM:ICH\ts\tRoyal Ontario Museum, Fish collection",
"ROM:IZ\ts\tRoyal Ontario Museum, Invertebrate Zoology Collection",
"ROM:MAM\ts\tRoyal Ontario Museum, Mammal Collection",
"ROM:ORN\ts\tRoyal Ontario Museum, Ornithology Collection",
"ROME\ts\tRoyal Ontario Museum, Entomology Collection\tROM:ENT",
"ROML\ts\tNational University of Lesotho, Biology Department\t\t",
"ROMO\ts\tRocky Mountain National Park\t\t",
"RON\th\tUniversidade Federal de Rondonia\t\t",
"ROO\ts\tAgricultural Research Council-Range and Forage Institute\t\t",
"ROPA\ts\tSonoma State University, Biology Department\t\t",
"ROPV\ts\tIstituto Sperimentale per la Patologia Vegetale\t\t",
"ROST\ts\tUniversitaet Rostock\t\t",
"ROV\ts\tMuseo Civico di Rovereto\t\t",
"ROZ\ts\tStredoceske muzeum\t\t",
"RPM\ts\tReading Public Museum\t\t",
"RPMH\ts\tRoemer Pelizaeus Museum Hildesheim\t\t",
"RPN\ts\tRipon Mechanics Institute\t\t",
"RPPMC\ts\tRondeau Provincial Park\t\t",
"RPPR\ts\tInternationl Institute of Tropical Forestry\t\t",
"RPSC\ts\tRio Palenque Science Center\t\t",
"RPSP\ts\tUniversidade de Sao Paulo\t\t",
"RPTN\ts\tRepton School, Biology Department\t\t",
"RRCBI\ts\tRegional Research Centre (Ay.)\t\t",
"RRIASR\tc\tFungal Pathogens of Hevea Rubber in Sri Lanka\t\t",
"RRJ\tc\tRRL , Jammu INDIA\t\t",
"RRLB\ts\tRegional Research Laboratory\t\t",
"RRLH\ts\tRegional Research Laboratory\t\t",
"RSA\ts\tRancho Santa Ana Botanic Garden\t\t",
"RSCS\tc\tMedical Culture Collection\t\t",
"RSDR\ts\tDesert Institute, Turkmenistan Academy of Sciences\t\t",
"RSKK\tc\tRefik Saydam National Type Culture Collection-RSKK\t\t",
"RSM<CAN>\ts\tRoyal Saskatchewan Museum\tSMNH<CAN>",
"RSM<GBR>\ts\tRoyal Scottish Museum\tNMSZ,RSME",
"RSU\th\tRyazan State University\t\t",
"RSY\ts\tButeshire Natural History Society, The Museum\t\t",
"RTE\ts\tHolmesdale Natural History Club Museum\t\t",
"RTHM\ts\tMunidipal Museum and Art Gallery\t\t",
"RTMP\ts\tRoyal Tyrell Museum of Paleontology\t\t",
"RU\ts\tUniversity of Reading, Agricultural Botany Department\t\t",
"RUBL\ts\tUniversity of Rajasthan, Botany Department\t\t",
"RUDZ\ts\tRhodes University\t\t",
"RUEB\ts\tEidgenoessische Technische Hochschule ETH\t\t",
"RUH\ts\tRhodes University, Botany Department\t\t",
"RUHV\ts\tRadford University, Biology Department\t\t",
"RUIC\ts\tRutgers University\t\t",
"RUMF\ts\tUniversity Museum, University of the Ryukyus\t\t",
"RUNYON\ts\tRobert Runyon Herbarium\t\t",
"RUPP\th\tRoyal University of Phnom Penh\t\t",
"RUSI\ts\tJ.L.B. Smith Institute of Ichthyology (formerly of Rhodes University)\t\t",
"RUSU\ts\tUniversidade Santa Ursula\t\t",
"RUT\ts\tDouglass College, Rutgers University, Biological Sciences Department\t\t",
"RUTPP\ts\tCook College, Rutgers University, Plant Pathology Department\t\t",
"RUY\ts\tMid-Staffordshire Field Club\t\t",
"RV<ITA>\tc\tCollection of Leptospira Strains\t\t",
"RV<RUS>\ts\tMolotov State University of Rostov, Botany Department\t\t",
"RVP\ts\tMuseo Provincial de Historia Natural de La Pampa (Argentina)\t\t",
"RWBG\ts\tRostov State University\t\t",
"RWC\ts\tState University of New York, Roosevelt Wildlife Collection\t\t",
"RWDN\ts\tUniversity of Glasgow Field Station\t\t",
"RWPM\ts\tRoger Williams Park Museum of Natural History\t\t",
"RYCC\tc\tRoseworthy Yeast Culture Collection\t\t",
"RYD\ts\tSchool of Art\t\t",
"RYU\ts\tUniversity of the Ryukyus, Biology Department\t\t",
"S\ts\tSwedish Museum of Natural History, Botany Departments\t\t",
"SA\ts\tMuseum national d'Histoire Naturelle, Laboratiore de Paleontologie\t\t",
"SAAR\ts\tZentrum fuer Biodokumentation des Saarlandes\t\t",
"SAAS\ts\tSaasveld, Port Elizabeth Technikon\t\t",
"SAB\ts\tSociety of Amateur Botanists\t\t",
"SACA\ts\tSouth-west Agricultural University\t\t",
"SACC\ts\tSt. Ambrose College\t\t",
"SACL\ts\tSanta Clara University, Biology Department\t\t",
"SACON\ts\tSalim Ali Centre for Ornithology and Natural History\t\t",
"SACS\ts\tShenyang Agricultural College\t\t",
"SACT\ts\tCalifornia State University, Biological Sciences Department\t\t",
"SAF\th\tDepartment of Agricultural and Forest Sciences\t\t",
"SAFB\ts\tUniversity of Saskatchewan, Forestry Department\t\t",
"SAFU\ts\tUniversity of San Francisco\t\t",
"SAG\tc\tSammlung von Algenkulturen at Universitat Gottingen\t\t",
"SAG<CHL>\tc\tColeccion de Micoligica Laboratorio Regional, Servicio Agricola y Ganadero\t\t",
"SAIAB\tsb\tSouth African Institute of Aquatic Biodiversity\t\t",
"SAIM\ts\tSouth African Institute for Medical Research\t\t",
"SAIMR\ts\tSouth African Institute for Medical Research\t\t",
"SAITP\tc\tSchool of Pharmacy and Medical Sciences, University of South Australia\t\t",
"SAK\ts\tInstitute of Marine Geology and Geophysics, Far East Branch, Island Ecological Problems Department\t\t",
"SAKH\ts\tSakhalin Botanical Garden\t\t",
"SAL\ts\tKansas Wesleyan University, Biology Department\t\t",
"SALA\ts\tUniversidad de Salamanca, Departamento de Botanica\t\t",
"SALAF\ts\tUniversidad de Salamanca\t\t",
"SALF\ts\tSalford Royal Free Museum and Library\t\t",
"SALFM\ts\tSalford Natural History Museum, Salford City Council\t\t",
"SALLE\ts\tInstituto Geobiologico La Salle\t\t",
"SAM<ZAF>\ts\tSouth African Museum\tSAMK",
"SAMA\tsb\tSouth Australian Museum\tSAM",
"SAMC\ts\tIziko Museum of Capetown\t\t",
"SAMF\th\tSamford University\t\t",
"SAMU\ts\tSavaria Museum, Department of Natural History\t\t",
"SAN\ts\tForest Research Centre, Forest Department\t\t",
"SANBI\ts\tSouth African National Biodiversity Institute\t\t",
"SANC\ts\tSouth African National Collection of Insects\tNCIP<ZAF>",
"SANT\ts\tUniversidad de Santiago de Compostela\t\t",
"SANT:Algae\ts\tUniversidad de Santiago de Compostela, algae collection",
"SANT:Bryo\ts\tUniversidad de Santiago de Compostela, bryophyte collection",
"SANT:Lich\ts\tUniversidad de Santiago de Compostela, lichen collection",
"SANU\ts\tShaanxi Normal University, Biology Department\t\t",
"SAO\ts\tSammlung Oberli\t\t",
"SAP\ts\tHerbarium of Graduate School of Science, Hokkaido University\t\t",
"SAPA\ts\tHokkaido University Museum (Fungal collection)\t\t",
"SAPCL\ts\tSt. Andrews Presbyterian College, Biology Department\t\t",
"SAPS\ts\tHokkaido University Museum (Plant collection)\t\t",
"SAPT\th\tHokkaido University Botanic Garden\t\t",
"SAR\ts\tDepartment of Forestry\t\t",
"SARA\ts\tZemaljski Muzej Bosne I. Herzegovine\t\t",
"SARAT\ts\tDepartment of Morphology and Systematic Botany\t\t",
"SARBG\th\tSaratov State University Botanical Garden\t\t",
"SARC\ts\tRoanoke College, Biology Department\t\t",
"SARI\ts\tSakarya Agricultural Research Institute\t\t",
"SAS\ts\tSammlung Arnhardt des Museums Schloss Wilhelmsburg Schmalkalden\t\t",
"SASK\ts\tUniversity of Saskatchewan, Plant Sciences Department\t\t",
"SASSA\ts\tUniversita di Sassari, Dipartimento di Scienze del Farmaco\t\t",
"SASSC\tb\tSENDAI Arabidopsis Seed Stock Center\t\t",
"SASY\ts\tInstitute for Biological Problems of Cryolithozone\t\t",
"SAT\ts\tAngelo State University, Biology Department\t\t",
"SAU<CHN>\ts\tSichuan Agricultural University, Department of Basic Courses\t\t",
"SAU<USA-AR>\ts\tSouthern Arkansas University\t\t",
"SAUF\ts\tSichuan Agricultural University, Forestry Department\t\t",
"SAUT\ts\tSichuan Agricultural University\t\t",
"SAV\ts\tInstitute of Botany, Slovak Academy of Sciences\t\t",
"SAV:F\ts\tInstitute of Botany, Slovak Academy of Sciences, Fungal Collection",
"SAWV\ts\tSalem International University, Department of Bioscience\t\t",
"SB\ts\tSaint Bernard Abbey\t\t",
"SBBG\ts\tSanta Barbara Botanic Garden\t\t",
"SBC\ts\tUniversity of California, Biological Sciences Department\t\t",
"SBCC\ts\tSanta Barbara City College, Department of Biological Sciences\t\t",
"SBCM\ts\tSan Bernardino County Museum\t\t",
"SBDE\ts\tSino-Belgian Dinosaur expedition\t\t",
"SBG\ts\tBotanical Garden of Stavropol State University, Botany Department\t\t",
"SBH\ts\tS Blair Hedges Collection\t\t",
"SBKA\ts\tStiftssammlungen des Benediktinerstiftskrems-Munster\t\t",
"SBM<MYS>\ts\tSabah Museum\t\t",
"SBM<USA-CA>\ts\tSanta Barbara Museum of Natural History\t\t",
"SBMN\ts\tSanta Barbara Museum of Natural History\t\t",
"SBMNH\ts\tSanta Barbara Museum of Natural History\t\t",
"SBNHM\ts\tSanta Barbara Natural History Museum\t\t",
"SBP\ts\tStation Biologique de Paimpont\t\t",
"SBSC\ts\tRobert A. Vines Environmental Science Center\t\t",
"SBSFU\tc\tSchool of Biological Sciences\t\t",
"SBT\ts\tBergius Foundation\t\t",
"SBU\ts\tSaint Bonaventure University, Biology Department\t\t",
"SBUG<DEU>\tc\tDepartment of Biology of the University of Greifswald\t\t",
"SBY\ts\tSalisbury and South Wiltshire Museum\t\t",
"SC\ts\tSalem College, Biology Department\t\t",
"SCA\ts\tLimbe Botanical & Zoological Gardens\t\t",
"SCAC\ts\tSouth China Agricultural College\t\t",
"SCAR\ts\tWood End Museum\t\t",
"SCARB\ts\tBoys' High School\t\t",
"SCB\ts\tStation Centrale de Boukoko\t\t",
"SCCAP\tc\tScandinavian Culture Collection of Algae and Protozoa\t\t",
"SCCBC\ts\tSelkirk College, Environmental Sciences and Technologies Department\t\t",
"SCCN\th\tScott Christian College\t\t",
"SCDH\ts\tSouth Carolina Department of Health and Environmental Control\t\t",
"SCFI\ts\tSichuan Academy of Forestry\t\t",
"SCFQ\ts\tService canadien de la faune\t\t",
"SCFS\th\tUniversity of California-Berkeley, Sagehen Creek Field Station\t\t",
"SCH\ts\tMuseum zu Allerheiligen\t\t",
"SCHG\ts\tGeorge Museum\t\t",
"SCHN\ts\tSmith College, Biological Sciences Department\t\t",
"SCIEA\ts\tSouth China Institute of Endangered Animals\t\t",
"SCL\ts\tSt. Cloud State University, Department of Biological Sciences\t\t",
"SCM\ts\tSheffield City Museums\t\t",
"SCN\ts\tSociedad de Ciencias Naturales \"La Salle\"\t\t",
"SCNHM\ts\tSouthwestern College, Natural History Museum\t\t",
"SCNU\ts\tSichuan Normal University\t\t",
"SCP\th\tSociedad Cientifica del Paraguay\t\t",
"SCPS\ts\tScarborough Philosophical and Archaeological Society Museum\t\t",
"SCR\ts\tScripps Institution of Oceanography, Herbarium\t\t",
"SCS\ts\tAgriculture and Agri-Food Canada, Semiarid Prairie\t\t",
"SCSC\ts\tSaint Cloud State University\t\t",
"SCSFRI\ts\tSouth China Sea Fisheries Research Institute\t\t",
"SCSG\th\tSouth China Sea Institute of Oceanology, Academia Sinica\t\t",
"SCSIO\ts\tSouth China Sea Institute of Oceanology, Academia Sinica\tSCSG",
"SCSM\ts\tSouth Carolina State Museum\t\t",
"SCT\ts\tFriend's School\t\t",
"SCTCC\tc\tSichuan Type Culture Collection\t\t",
"SCU\ts\tShandong Christian University\t\t",
"SCUF\ts\tUniversidade Federal de Santa Catarina\t\t",
"SCUI\th\tSuez Canal University\t\t",
"SCUM\ts\tSichuan University Museum\t\t",
"SCV\tb\tState Collection of Viruses\t\t",
"SCZ\ts\tSmithsonian Tropical Research Institute\t\t",
"SD\ts\tHerbarium, San Diego Natural History Museum\t\t",
"SDAKS\ts\tSouth Dakota State University\t\t",
"SDAU\ts\tShandong Agricultural University\t\t",
"SDC\ts\tSouth Dakota State University, Department of Biology\t\t",
"SDCM\ts\tShandong College of Traditional Chinese Medicine\t\t",
"SDFI\ts\tShandong Forestry Institute\t\t",
"SDFS\ts\tShandong Forestry School\t\t",
"SDI\ts\tSouthend Institute\t\t",
"SDM<GBR>\ts\tStroud and District Museum\t\t",
"SDM<USA-CA>\ts\tSan Diego Mesa College, Botany Department\t\t",
"SDMP\ts\tShandong Institute of Traditional Chinese Medicine and Materia Medica\t\t",
"SDN\ts\tBorough of Thamesdown Museum and Art Gallery\t\t",
"SDNCU\tcb\tThe Specimen Depository of the Graduate School of Natural Sciences, Nagoya City University\t\t",
"SDNH<SWZ>\ts\tMalkerns Agricultural Research Station\t\t",
"SDNHM\ts\tSan Diego Natural History Museum\tSDMC,SDNH,SDSNH",
"SDNU\ts\tShandong Normal University, Biology Department\t\t",
"SDSM\ts\tSouth Dakota School of Mines and Technology\t\t",
"SDSU<USA-CA>\ts\tSan Diego State University\t\t",
"SDSU<USA-CA>:Arthropods\ts\tSan Diego State University, Museum of Biodiversity Terrestrial Arthropod Collection",
"SDSU<USA-CA>:Birds\ts\tSan Diego State University, Museum of Biodiversity Birds Collection",
"SDSU<USA-CA>:Fish\ts\tSan Diego State University, Museum of Biodiversity Fish Collection",
"SDSU<USA-CA>:Greenhouse\tb\tSan Diego State University, Greenhouse",
"SDSU<USA-CA>:Herbarium\ts\tSan Diego State University, Herbarium",
"SDSU<USA-CA>:Herps\ts\tSan Diego State University, Museum of Biodiversity Amphibians & Reptiles Collection",
"SDSU<USA-CA>:Mammals\ts\tSan Diego State University, Museum of Biodiversity Mammal Collection",
"SDSU<USA-SD>\ts\tSeverin-McDaniel Insect Collection\t\t",
"SDU\ts\tUniversity of South Dakota, Department of Biology\t\t",
"SEAARI\ts\tSouth Eastern Anatolian Agricultural Research Institute\t\t",
"SEAC\ts\tEstacion Experimental de Agricolas de la Campara\t\t",
"SEAMEO\tc\tSeameo-Biotrop\t\t",
"SEAN\ts\tMuseo Entomologico\t\t",
"SEBR\tc\tSanofi ELF Biorecherches\t\t",
"SECM\ts\tScience Education Center\t\t",
"SEFES\ts\tSoutheastern Forest Experiment Station\t\t",
"SEFSC\ts\tSoutheast Fisheries Science Center\t\t",
"SEFSC:MMMGL\ts\tSoutheast Fisheries Science Center, Marine Mammal Molecular Genetics Laboratory",
"SEHU\ts\tHokkaido University Insect Collection\t\t",
"SEIG\ts\tSocieta Entomologica Italiana\t\t",
"SEL\ts\tMarie Selby Botanical Gardens\t\t",
"SELU\ts\tSoutheastern Louisiana University, Biological Sciences Department\t\t",
"SEMC\ts\tSnow Entomological Museum\tKU:SEMC",
"SEMIA\tc\tRhizobium Culture Collection\t\t",
"SEMK\ts\tSnow Entomological Museum\t\t",
"SEMM\ts\tStation Experimental de la Maboke\t\t",
"SEMO\ts\tSoutheast Missouri State University, Department of Biology\t\t",
"SERC<USA-MD>\ts\tSmithsonian Environmental Research Center\t\t",
"SERG\ts\tInstitut de Recherche Agronomique de Guinee\t\t",
"SERO\ts\tSociedad para el Estudio de los Recursos Bioticos de Oaxaca\t\t",
"SERTC\ts\tSoutheastern Regional Taxonomic Center\t\t",
"SES\ts\tSoutheastern Shanxi Teachers School, Biochemistry Department\t\t",
"SETON\ts\tPhilmont Scout Ranch, Seton Memorial Library\t\t",
"SEV\ts\tUniversidad de Sevilla, Departamento de Biologia Vegetal y Ecologia\t\t",
"SEVF\ts\tUniversidad de Sevilla, Departamento de Botanica\t\t",
"SEY\ts\tSeychelles Natural History Museum\t\t",
"SF\ts\tUniversidad Nacional del Litoral\t\t",
"SFAC\ts\tStephen F. Austin State University\t\t",
"SFB\ts\tSalgues Foundation of Brignoles for Development of Biological Sciences\t\t",
"SFC\ts\tLaboratory of Fishes\t\t",
"SFD\ts\tSheffield Galleries and Museums Trust, City Museum\t\t",
"SFDK\ts\tSarawak Forestry Department\t\t",
"SFDL\ts\tSheffield Literary and Philosophical Society\t\t",
"SFDN\ts\tSheffield Naturalists' Club\t\t",
"SFI\tb\tSlovenian Forestry Institute\t\t",
"SFPA\ts\tFundacao Estadual de Pesquisa Agropecuaria\t\t",
"SFRF\ts\tForest Service, Region 5, USDA\t\t",
"SFRP\ts\tSouthern Research Station\t\t",
"SFRS\ts\tSea Fisheries Research Station\t\t",
"SFS\ts\tUniversite de Sherbrooke, Departement de biologie\t\t",
"SFSU\ts\tSan Francisco State University, Department of Biology\t\t",
"SFT\ts\tStowlangtoft Hall\t\t",
"SFU\ts\tShanghai Fisheries University\t\t",
"SFUC\ts\tSimon Fraser University\t\t",
"SFUV\ts\tSimon Fraser University, Biological Sciences Department\t\t",
"SFV\ts\tCalifornia State University, Department of Biology\t\t",
"SFVS\ts\tSan Fernando Valley State University\t\t",
"SG\ts\tShanghai Botanical Garden\t\t",
"SGBH\ts\tMuseum of Staffordshire County\t\t",
"SGE\ts\tStamford Park Museum\t\t",
"SGEL\ts\tStalybridge Library\t\t",
"SGGS\ts\tThe Museum\t\t",
"SGGW\ts\tWarsaw University of Life Sciences\t\t",
"SGMA\ts\tUniversidade Nova de Lisboa\t\t",
"SGN\th\tSouthern Institute of Ecology\t\t",
"SGO\ts\tHerbario, Museo Nacional de Historia Natural, Santiago\t\t",
"SGSC\tc\tSalmonella Genetic Stock Centre\t\t",
"SGWG\ts\tSammlung der Sektion Geologische Wissenschaften der Ernst-Moritz-Arndt University\t\t",
"SH\ts\tAcademia Sinica\t\t",
"SHB\ts\tShanghai Baptist College\t\t",
"SHC\ts\tSacred Heart College\t\t",
"SHCP\ts\tSouthern Highlands Conservation Programme\t\t",
"SHCT\ts\tShanghai Teachers College of Technology, Biology Department\t\t",
"SHD\ts\tUniversity of Sheffield, Botany Department\t\t",
"SHDC\ts\tShanghai Institute for Drug Control\t\t",
"SHG\ts\tSohag University, Botany Department\t\t",
"SHI\ts\tHerbarium, Shihezi University\t\t",
"SHIN\ts\tShinshu University\t\t",
"SHJ\ts\tSt. John's University\t\t",
"SHM<CHN>\ts\tShanghai Museum of Natural History, Botanical Department\t\t",
"SHM<USA-SD>\ts\tSiouxland Heritage Museum\t\t",
"SHMC\ts\tLuther College, Sherman A. Hoslett Museum of Natural History\t\t",
"SHMH\ts\tUniversite l'Aurore, Musee Heude\t\t",
"SHMI\ts\tShanghai Institute of Materia Medica, Chinese Academy of Sciences, Phytochemistry Department\t\t",
"SHMU\ts\tShanghai Medical University\t\t",
"SHOR\ts\tShorter College, Biology Department\t\t",
"SHSND\ts\tNorth Dakota Heritage Center\t\t",
"SHST\ts\tSam Houston State University, Department of Biological Sciences\t\t",
"SHSU\ts\tSam Houston State University, Vertebrate Natural History Collection\t\t",
"SHTC\ts\tCalifornia State University, Biology Department\t\t",
"SHTU\ts\tShanghai Teachers University, Biology Department\t\t",
"SHY\ts\tRowley's House Museum\t\t",
"SHYAN\ts\tShropshire Archaeological and Natural History Society\t\t",
"SHYB\ts\tShrewsbury School\t\t",
"SHYL\ts\tShrewsbury School\t\t",
"SHYN\ts\tShrewsbury Natural History Society\t\t",
"SHYP\ts\tShrewsbury Public Library\t\t",
"SI\ts\tInstituto de Botanica Darwinion\t\t",
"SIAC<CHN>\ts\tSichuan Institute of Agriculture\t\t",
"SIAC<ITA>\ts\tAccademia dei Fisiocritici Onlus\t\t",
"SIB\ts\tSibiu Natural History Museum\t\t",
"SIBAC\ts\tSouthwest Institute of Biology\t\t",
"SIBS\th\tInstitute of Biology of the Southern Seas\t\t",
"SICH\ts\tSimpson College, Biology and Environmental Sciences Department\t\t",
"SIEMEA\ts\tSevertsov Insitute for Evolutionary Morphology and Animal Ecology\t\t",
"SIENA\ts\tUniversita di Siena, Dipartimento di Scienze Ambientali \"G. Sarfatti\"\t\t",
"SIF\ts\tSenckenbergisches Institut\t\t",
"SIFS\ts\tSichuan Forestry School\t\t",
"SIGMA\ts\tStation Internationale de Geobotanique Mediterraneenne et Alpine\t\t",
"SIIS\ts\tStaten Island Institute of Arts and Sciences\t\t",
"SIM\ts\tStaten Island Institute of Arts and Sciences, Science Department\t\t",
"SIMF\ts\tTaurida National University, Botany Department\t\t",
"SIMS\ts\tSherkin Island Marine Station\t\t",
"SING\ts\tSingapore Botanic Gardens\t\t",
"SINU\ts\tNational University of Singapore, Biological Sciences Department\t\t",
"SIO\ts\tScripps Institution of Oceanography\t\t",
"SIO:BIC\ts\tScripps Institution of Oceanography, Benthic Invertebrates Collection",
"SITC\ts\tSichuan Teachers College, Biology Department\t\t",
"SIU\ts\tSouthern Illinois University, Plant Biology Department\t\t",
"SIUC\ts\tResearch Museum of Zoology, Southern Illinois University at Carbondale\t\t",
"SIUC:H\ts\tResearch Museum of Zoology, Southern Illinois University at Carbondale, Herpetology Collection",
"SIUCM\ts\tSouthern Illinois University\t\t",
"SIUE\ts\tSouthern Illinois University, Edwardsville\t\t",
"SIZK\ts\tSchmaulhausen Institute of Zoology\t\t",
"SJ\ts\tDepartamento de Recursos Naturales y Ambientales\t\t",
"SJAC\ts\tSan Joaquin County Agriculture Commissioner\t\t",
"SJC\ts\tSir John Cass College, Chemistry and Biology Department\t\t",
"SJCA\ts\tSt. John's College\t\t",
"SJCRY\ts\tSt. John's College of Ripon and York\t\t",
"SJER\ts\tUnited States Forest Service, San Joaquin Experimental Range\t\t",
"SJFM\ts\tFairbanks Museum and Planetarium\t\t",
"SJNM\ts\tSan Juan College\t\t",
"SJPC\ts\tSergei J. Paramonov personal collection -- destroyed\t\t",
"SJRP\ts\tUNESP, Campus Sao Jose Rio Preto, Departamento Zoologia e Botanica\t\t",
"SJSC\ts\tSan Jose State University, J. Gordon Edwards Museum of Entomology\t\t",
"SJSU\ts\tSan Jose State University, Biological Sciences Department\t\t",
"SJUBC\ts\tSaint John's University, Biology Collections\t\t",
"SK\ts\tKatedralskolan\t\t",
"SKK\ts\tSung Kyun Kwan University, Biological Sciences Department\t\t",
"SKM\ts\tSkokholm Field Centre\t\t",
"SKN\ts\tCraven Museum Service\t\t",
"SKR\ts\tLatvian Research Institute of Agriculture, Plant Protection Department\t\t",
"SKT\ts\tStockport Heritage Services\t\t",
"SKU\ts\tSri Krishnadevaraya University, Botany Department\t\t",
"SKUK\tc\tSimpanan Kultur Universiti Kebangsaan\t\t",
"SL\ts\tUniversity of Sierra Leone, Njala University College, Biological Sciences Department\t\t",
"SLBI\ts\tSouth London Botanical Institute\t\t",
"SLC\ts\tEast High School, Science Department\t\t",
"SLFC\ts\tSlapton Ley Field Centre\t\t",
"SlgInnsb\ts\tPaleontological Collection\t\t",
"SLJG\ts\tSteiermarkisches Landesmuseum Joanneum\t\t",
"SLL\ts\tSociete Linneenne de Lyon\t\t",
"SLO\ts\tKomenskeho University, Katedra botaniky\t\t",
"SLPM\ts\tUniversidad Autonoma de San Luis Potosi\t\t",
"SLRO\ts\tSlippery Rock University, Biology Department\t\t",
"SLSC\ts\tSt. Louis, St. Louis Science Center\t\t",
"SLSK\ts\tSt. Leonard's and St. Katherine's Schools\t\t",
"SLTC\ts\tTeachers College, Botany Department\t\t",
"SLU<CAN>\ts\tLaurentian University, Biology Department\t\t",
"SLU<USA-LA>\ts\tSoutheastern Louisiana University, Vertebrate Museum\t\t",
"SLUB\ts\tSt. Louis University Museum\t\t",
"SLUBGH\th\tShah Abdul Latif University\t\t",
"SLUM\ts\tSaint Louis University Museum Ichthylogy Collection\t\t",
"SM<CHN>\ts\tChongqing Municipal Academy of Chinese Materia Medica\t\t",
"SM<DEU-Frankfurt>\ts\tSenckenberg Museum\t\t",
"SM<DEU-Langenaltheim>\ts\tSchwegler Museum\t\t",
"SM<MYS>\ts\tSarawak Museum\t\t",
"SM<USA-FL>\ts\tSanford Museum Collections\t\t",
"SM<USA-TX>\ts\tStrecker Museum, Baylor University\t\t",
"SMAG\ts\tSouthland Museum and Art Gallery\t\t",
"SMAO\ts\tSimao Forestry Bureau\t\t",
"SMB\ts\tMarianske Muzeum, Natural History Department\t\t",
"SMBB\ts\tStredoslovenske muzeum\t\t",
"SMBL\ts\tSeto Marine Biological Laboratory, Kyoto University\t\t",
"SMC\ts\tSedgwick Museum\t\t",
"SMCC\tc\tSubsurface Microbial Culture Collection\t\t",
"SMCC-W\tc\tSubsurface Microbial Culture Collection--Western Branch\t\t",
"SMCW\ts\tSaint Michael's College, Biology Department\t\t",
"SMDB\ts\tUniversidade Federal de Santa Maria, Departamento de Biologia\t\t",
"SME<FRA>\ts\tStation Marine d'Endoume\t\t",
"SME<GBR>\ts\tSedgwick Museum of Geology\t\t",
"SMF<DEU>\ts\tForschungsinstitut und Natur-Museum Senckenberg\t\t",
"SMF<PER>\ts\tUniversidad Nacional Mayor de San Marcos\t\t",
"SMH\ts\tSaint Meinrad College of Liberal Arts, Biology Department\t\t",
"SMI\ts\tPrince Rupert Forest Region, Research Section\t\t",
"SMIP\tc\tSecao de Maricultura\t\t",
"SMJM\ts\tSabah Museum\t\t",
"SMK\ts\tSarawak Museum\tSM",
"SMKM\ts\tSelangor Museum\t\t",
"SMM\ts\tScience Museum of Minnesota\t\t",
"SMMC\ts\tSecond Military Medical College\t\t",
"SMN\ts\tSimao District National Medical and Pharmaceutical Institute\t\t",
"SMNG\ts\tSenckenberg Museum fuer Naturkunde Goerlitz\t\t",
"SMNH<CAN>\ts\tSaskatchewan Museum of Natural History\t\t",
"SMNH<ISR>\ts\tSteinhardt Museum of Natural History\t\t",
"SMNH<SWE>\ts\tSwedish Museum of Natural History\t\t",
"SMNH<UKR>\ts\tState Museum of Natural History\t\t",
"SMNH<USA-KS>\ts\tSchmidt Museum of Natural History, Emporia State University\t\t",
"SMNK\ts\tStaatliches Museum fuer Naturkunde Karlsruhe (State Museum of Natural History)\t\t",
"SMNS\ts\tStaatliches Museum fuer Naturkund Stuttgart\t\t",
"SMOC\ts\tSlezske Muzeum Opava\t\t",
"SMP<SUR>\ts\tSurinaams Museum\t\t",
"SMP<USA-PA>\ts\tThe State Museum of Pennsylvania\t\t",
"SMPM\ts\tScience Museum of Minnesota\t\t",
"SMR\ts\tSamara State University, Department for Ecology, Botany, and Nature Protection\t\t",
"SMRG\tc\tSoil Microbiology Research Group, Division of Soil Science, Department of Agriculture\t\t",
"SMRS\ts\tStavropol Museum of Regional Studies\t\t",
"SMS\ts\tMissouri State University, Department of Biology\t\t",
"SMSM\ts\tSarawak Museum\t\t",
"SMTP\ts\tSwedish Malaise Trap Project\t\t",
"SMTWA\tc\tSchool of Medical Technology Western Australia\t\t",
"SMU\ts\tSt. Mary's University\t\t",
"SMU<KOR>\ts\tSangmiung University\t\t",
"SMU<USA-TX>\ts\tShuler Museum of Paleontology, Southern Methodist University\tSMP",
"SMVM\ts\tNational Archives and Museum\t\t",
"SMW<GBR>\ts\tSchool of Medicine for Women\t\t",
"SMW<NAM>\ts\tState Museum\tSMWN",
"SMWN\ts\tState Museum\tSMW",
"SMWU\ts\tSang Miung Women's University\t\t",
"SN\ts\tSouth China Normal University, Biology Department\t\t",
"SNC\ts\tSaint Norbert College\t\t",
"SNCBSH\ts\tState of North Carolina Biological Station\t\t",
"SNGM\ts\tColeccion Paleontologica\t\t",
"SNHM\ts\tSudan Natural History Museum\t\t",
"SNHS\ts\tGuildford Museum\t\t",
"SNM<SVK>\ts\tSlovak National Museum\tSNMB",
"SNM<USA-NM>\ts\tWestern New Mexico University, Department of Natural Sciences\t\t",
"SNMB\ts\tStaatliches Naturhistorisches Museum\t\t",
"SNMBR\ts\tStaatliches Naturhistorisches Museum in Braunschweig\t\t",
"SNMC\ts\tSlovenske Narodne Muzeum\t\t",
"SNMG\ts\tStaatliches Museum fuer Naturkunde\t\t",
"SNMH\th\tSree Narayana Mangalam College\t\t",
"SNMNH\ts\tSaudi Arabian National Museum of Natural History\t\t",
"SNOMNH\ts\tSam Nobel Oklahoma Museum of Natural History\t\t",
"SNP<MYS>\ts\tSabah Parks, Botany Section\t\t",
"SNPH\ts\tSehlabathebe National Park\t\t",
"SNSD\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology\t\t",
"SNSD:Moll\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, ",
"SNU\ts\tSeoul National University, School of Biological Sciences\t\t",
"SNUA\ts\tSeoul National University, The Arboretum\t\t",
"SNW\ts\tShropshire and North Wales Natural History and Antiquarian Society\t\t",
"SO\ts\tSofia University \"St. Kliment Ohridski\", Botany Department\t\t",
"SOA\ts\tAgricultural University of Plovdiv, Botany Department\t\t",
"SOB\ts\tHusite Museum Tabor\t\t",
"SOC\ts\tSouthern Oregon University, Biology Department\t\t",
"SOF\th\tSofyivka National Dendrological Park\t\t",
"SOFM\ts\tNational Museum of Natural History, Sofia\t\t",
"SOFRI\tb\tSouthern Fruit Research Institute  Vietnam\t\t",
"SOGS\ts\tPal. Coll, Sokoto State Government Palaeontological Collection\t\t",
"SOIC\ts\tNatural History Museum, National Insect Collection\t\t",
"SOKO\ts\tOkresni muzeum Sokolov (Regional Muzeum), Botany Department\t\t",
"SOM\ts\tBulgarian Academy of Sciences\t\t",
"SOMF\ts\tBulgarian Academy of Sciences\t\t",
"SORO\th\tUniversidade Federal de Sao Carlos, campus Sorocaba\t\t",
"SOSCMVNH\ts\tSouthern Oregon State College, Museum of Vertebrate Natural History\t\t",
"SOSN\ts\tSilesian Medical School in Katowice, Department of Pharmaceutical Botany\t\t",
"SOSSRC\ts\tSave Our Seas Shark Research Center, Nova Southeastern University\t\t",
"SOTO\ts\tCollege of the Ozarks, Biology Department\t\t",
"SOTON\ts\tSouthampton University\t\t",
"SOUT\ts\tLong Island University\t\t",
"SP\ts\tInstituto de Botanica\t\t",
"SPA\ts\tSwedish Museum of Natural History, Section for Palaeobotany\t\t",
"SPAL\ts\tMunicipio di Reggio Emilia, Musei Civici\t\t",
"SPB\ts\tUniversidade de Sao Paulo\t\t",
"SPC\ts\tSeattle Pacific University, Biology Department, Suite 205\t\t",
"SPF\ts\tUniversidade de Sao Paulo, Departamento de Botanica\t\t",
"SPFR\ts\tUniversidade de Sao Paulo, Departamento de Biologia\t\t",
"SPH\ts\tFox Research Forest\t\t",
"SPI\ts\tStavropol Pedagogical Institute, Botany Department\t\t",
"SPL\ts\tPalynological Laboratory\t\t",
"SPLT\ts\tSouth Plains College, Science Department\t\t",
"SPM\ts\tSabah Parks\t\t",
"SPMCC\tc\tSungei Putih Microbial Culture Collection\t\t",
"SPMO\tc\tSalt Plains Microbial Observatory\t\t",
"SPMS\ts\tUniversity of South Florida\t\t",
"SPN\ts\tSouthampton University, Biology Department\t\t",
"SPNRI\ts\tSichuan Province, Natural Resources Institute\t\t",
"SPR\ts\tSpringfield Science Museum, Natural Science Department\t\t",
"SPRY\ts\tBurton Constable Foundation\t\t",
"SPSF\ts\tInstituto Florestal\t\t",
"SPSU\th\tSt. Petersburg State University\t\t",
"SPT\ts\tBotanic Gardens Museum\t\t",
"SPTS\ts\tSouthport Scientific Society\t\t",
"SPWH\ts\tMarine Biological Laboratory\t\t",
"SQB\th\tSociete quebecoise de bryologie\t\t",
"SQF\ts\tUniversidad de Chile, Laboratorio de Botanica, Escuela de Quimica y Farmacia\t\t",
"SQUH\th\tSultan Qaboos University\t\t",
"SR\ts\tSichuan Institute of Natural Resources\t\t",
"SRAICC\tc\tSRAI's culture collection\t\t",
"SRCG\ts\tBaylor University\t\t",
"SRD\ts\tPassmore Edwards Museum\t\t",
"SRF\ts\tShangrao Forestry Institute\t\t",
"SRFA\ts\tUniversidad Nacional de La Pampa\t\t",
"SRGH\ts\tBotanic Garden\t\t",
"SRI\ts\tSerengetti Research Institute\t\t",
"SRNP\ts\tInsects of the Area Conservacion Guanacaste, northwestern Costa Rica\t\t",
"SRP\ts\tBoise State University, Biology Department\t\t",
"SRR\ts\tKoninklijke Shell (Shell Research N.V.)\t\t",
"SRRC\tc\tSouthern Regional Research Center, Agricultural Research Service, United States Department of Agriculture\t\t",
"SRS\th\tUniversidade do Sul de Santa Catarina\t\t",
"SRSC\ts\tSul Ross State University, Department of Biology\t\t",
"SRSU\ts\tSul Ross State University\t\t",
"SS\ts\tUniversita di Sassari, Dipartimento di Botanica ed Ecologia Vegetale\t\t",
"SSC\ts\tSacramento State University\t\t",
"SSCMU\tc\tSoil Science and Conservation Department Faculty of Agriculture\t\t",
"SSCN\ts\tMusum of the Biological Laboratory\t\t",
"SSD\ts\tSammlung Simon des Stattlichen Museum fur Mineralogie und Geologie Dresden\t\t",
"SSF\ts\tSammlung des Senckenbrug-Museum\t\t",
"SSI<DNK>\tc\tStatens Serum Institute\t\t",
"SSIC\tc\tCollaborating Centre for Reference and Research on Escherichia and Klebsiella\t\t",
"SSJC\ts\tSan Joaquin County, Agriculture Department\t\t",
"SSKKU\tc\tDepartment of Soil Science, Faculty of Agriculture\t\t",
"SSL\ts\tSammlung Langenhan an der Sektion Geophysik der Karl-Marx-Universitat Lepzig\t\t",
"SSLP\ts\tRocky Mountain Research Station\t\t",
"SSM<USA-GA>\ts\tSavannah Science Museum\t\t",
"SSM<USA-MA>\ts\tSpringfield Science Museum\t\t",
"SSMF\ts\tGreat Lakes Forestry Centre, Canadian Forest Service\t\t",
"SSMJI\tc\tScience Section, Department of General Education, Faculty of Agricultural Business\t\t",
"SSMM\ts\tShanxi School of Chinese Materia Medica\t\t",
"SSMS\ts\tSuriname State Museum\t\t",
"SSNR\ts\tSocieta per GL Studi Naturalistica della Romagna\t\t",
"SSOFM\ts\tSanabe Shizenkan Open Field Museum\t\t",
"SSPW\ts\tPerivale Wood Nature Reserve\t\t",
"SSU\ts\tSaratov State University\t\t",
"SSUC\ts\tPontificia Universidad Catolica de Chile, Departamento de Ecologia\t\t",
"ST\ts\tSuzhou Teachers College, Biology Department\t\t",
"STA\ts\tUniversity of St. Andrews, School of Environmental and Evolutionary Biology\t\t",
"STAL\ts\tVerulamium Museum\t\t",
"STAR\ts\tArkansas State University, Biological Sciences Department\t\t",
"STASH\ts\tSt. Beuno's College\t\t",
"STB\ts\tSt. Bartholomew's Hospital\t\t",
"STC\ts\tSichuan Teacher's College\t\t",
"STCR\ts\tUniversite de la Reunion\t\t",
"STD\ts\tPrittlewell Priory Museum\t\t",
"STDCM\ts\tSouthend Central Museum\t\t",
"STE\ts\tNational Botanical Institute\t\t",
"STE-U\tc\tCulture collection of the Department of Plant Pathology, University of Stellenbosch\t\t",
"STEU\tsc\tUniversity of Stellenbosch, Botany Department\t\t",
"STFX\ts\tSt. Francis Xavier University, Biology Department\t\t",
"STG\ts\tSt. Martin's Convent\t\t",
"STI\ts\tStirling Smith Art Gallery and Museum\t\t",
"STIU\ts\tUniversity of Stirling, Biological Sciences Department\t\t",
"STK\ts\tStoke-on-Trent Athenaeum\t\t",
"STL\ts\tInstituto Nacional de Limnologia, Departamento Macrofitas\t\t",
"STM<DEU>\ts\tStettinger Museum\t\t",
"STM<FRA>\tc\tLaboratoire des Symbioses Tropicales et Mediterraneennes\t\t",
"STM<GBR>\ts\tStreatham Antiquarian and Natural History Society\t\t",
"STMC\ts\tSchool of Tropical Medicine\t\t",
"STNF\th\tShasta-Trinity National Forest\t\t",
"STO\ts\tThe Potteries Museum & Art Gallery\t\t",
"STP\ts\tLa Societe Guernesiaise, Priaulx Library\t\t",
"STPCM\ts\tIsland Museum, Candie Gardens\t\t",
"STPE\ts\tFlorida Marine Research Institute, Florida Department of Environmental Protection\t\t",
"STPH\th\tDireccao Geral do Ambiente, Cabinet of Environment, Ministry of Natural Resources and Environment\t\t",
"STPS\ts\tSt. Paul's School\t\t",
"STR\ts\tInstitut de Botanique\t\t",
"STRI\tsc\tSmithsonian Tropical Research Institute\t\t",
"STRI:ICBG-Panama\tc\tSmithsonian Tropical Research Institute,  International Cooperative Biodiversity Groups",
"STS\ts\tStromness Museum\t\t",
"STT\ts\tSt. Thomas's Hospital Medical School Library\t\t",
"STU\ts\tStaatliches Museum fuer Naturkunde Stuttgart\t\t",
"STUM\ts\tSanto Tomas University Museum\t\t",
"SU<CHN>\ts\tSuzhou University\t\t",
"SU<USA-CA>\ts\tStanford University\t\t",
"SU<USA-OR>\ts\tOregon State University\t\t",
"SUA\ts\tSokoine University of Agriculture, Forest Biology Department\t\t",
"SUB\ts\tUniversitat Bonn\t\t",
"SUCEA\ts\tThe University at Albany\t\t",
"SUCH\ts\tSukhumi Botanical Garden of Georgian Academy of Sciences\t\t",
"SUCN\ts\tState University of California\t\t",
"SUCO\ts\tState University of New York, College at Oneonta, Biology Department\t\t",
"SUD\ts\tStroud and District Museum\t\t",
"SUEL\ts\tNatural History Museum of Bakony Mountains\t\t",
"SUF\ts\tShimonoseki University of Fisheries\t\t",
"SUFA\th\tSulaimania University\t\t",
"SUFAF\th\tSiirt University Flora and Fauna Center\t\t",
"SUHC\ts\tSalisbury University, Department of Biology\t\t",
"SUK\ts\tShivaji University Kolhapur\t\t",
"SUM<CZE>\ts\tOkresni vlastivedne muzeum v Sumperku\t\t",
"SUM<ZAF>\ts\tStellenbosch University\t\t",
"SUN\ts\tSunderland Museum\t\t",
"SUND\ts\tSunderland Natural History and Antiquarian Society\t\t",
"SUNIV\ts\tUniversity of Stockholm\t\t",
"SUNY\ts\tState University of New York\t\t",
"SUNYO\ts\tState University of New York at Oneonta\t\t",
"SURCO\th\tUniversidad Surcolombiana\t\t",
"SUU\th\tSouthern Utah University\t\t",
"SUVA\ts\tUniversity of the South Pacific\t\t",
"SUVM\ts\tShippensburg University, Vertebrate Museum\t\t",
"SUWS\ts\tUniversity of Wisconsin-Superior, Department of Biology and Earth Science\t\t",
"SV\ts\tAntigua Estacion Experimental Agronomica\t\t",
"SVCK\tc\tSammlung von Conjugaten Kulturen\t\t",
"SVER\ts\tInstitute of Plant and Animal Ecology, Laboratory of Plant Ecology and Geobotany\t\t",
"SVG\ts\tArkeologisk museum i Stavanger\t\t",
"SVIEC\tc\tSecao de Virus\t\t",
"SVUTY\th\tSri Venkateswara University\t\t",
"SVVC\ts\tSeminario Vescovile\t\t",
"SWA\ts\tSwansea Museum\t\t",
"SWAT\th\tUniversity of Swat Pakistan\t\t",
"SWAU\ts\tSouthwest Agricultural University, Horticulture Department\t\t",
"SWBR\ts\tSweet Briar College, Biology Department\t\t",
"SWC<GBR>\ts\tSammlung des Cambridge, University of Zoology\t\t",
"SWC<USA-PA>\ts\tSwarthmore College, Biology Department\t\t",
"SWCTU\ts\tSouthwest Teachers University, Biology Department\t\t",
"SWE\ts\tChandos House, Stowe School\t\t",
"SWF\ts\tFlorida Gulf Coast University\t\t",
"SWFC\ts\tSouthwest Forestry College\t\t",
"SWFSC\ts\tSouthwest Fisheries Science Center\t\t",
"SWGC\th\tGrenfell Campus, Memorial University of Newfoundland\t\t",
"SWIBASC\ts\tAcademia Sinica\t\t",
"SWMT\ts\tRhodes College, Biology Department\t\t",
"SWN\ts\tSaffron Walden Museum\t\t",
"SWNHS\ts\tSaffron Walden Horticultural Society\t\t",
"SWRS\ts\tSouthwestern Research Station\t\t",
"SWSL\ts\tUSDA/ARS, Southern Weed Science Research Unit\t\t",
"SWT\ts\tSouthwest Texas State University, Department of Biology\t\t",
"SWTN\ts\tSwinton and Pendlebury Botanical Society\t\t",
"SWU\th\tSungshin Women's University\t\t",
"SWU2\tc\tDepartment of Biology, Faculty of Science\t\t",
"SXAU\ts\tShanxi Agricultural University, Forestry Department\t\t",
"SXDC\ts\tShaanxi Institute for Drug Control\t\t",
"SXIM\th\tShaanxi Institute of Microbiology\t\t",
"SXMP\ts\tShaanxi Academy of Traditional Chinese Medicine and Pharmacology\t\t",
"SXU\ts\tShanxi University, Biology Department\t\t",
"SY\ts\tShenyang Municipal Academy of Landscape Gardening\t\t",
"SYAU\ts\tShenyang Agricultural University\t\t",
"SYAUF\ts\tShenyang Agricultural University, Forestry Department\t\t",
"SYD\ts\tUniversity of Sydney\t\t",
"SYKO\ts\tKomi Scientific Centre, Ural Division, Russian Academy of Sciences, Department of Geobotany and Plant Cover Restoration\t\t",
"SYKT\ts\tSyktyvkar State University, Botany Department\t\t",
"SYPC\ts\tShenyang College of Pharmacy, Pharmaceutical Botany Department\t\t",
"SYR\ts\tSyracuse University, Plant Sciences Department\t\t",
"SYRF\ts\tState University of New York\t\t",
"SYS\ts\tSun Yatsen University, Biology Department\t\t",
"SYS:Z\ts\tSun Yatsen University, Biology Department, Zoology Collection",
"SYSBM\ts\tThe Museum of Biology Sun Yat-sen University\t\t",
"SYSU\ts\tNational Sun Yat-Sen University, Department of Biological Sciences\t\t",
"SYT\ts\tStonyhurst College\t\t",
"SZ\ts\tSichuan University, Biological Department\t\t",
"SZB\ts\tHaus der Natur\t\t",
"SZCU\ts\tDepartment of Systematic Zoology\t\t",
"SZCZ\th\tUniversity of Szczecin\t\t",
"SZE<HUN>\ts\tMora Ferenc Museum, Natural Science Department\t\t",
"SZE<TUR>\ts\tZoology Department, Aegean University, Science Faculty\t\t",
"SZG\ts\tShenzhen Fairy Lake Botanical Garden\t\t",
"SZL\ts\tLandesherbar von Salzburg\t\t",
"SZM\ts\tSaitama Zoogeographical Museum\t\t",
"SZMC\tc\tSzeged Microbiological Collection\t\t",
"SZMN\ts\tSiberian Zoological Museum\t\t",
"SZPT\ts\tShenzhen Polytechnic\t\t",
"SZPT:ENT\ts\tShenzhen Polytechnic, Entomology Collection",
"SZU\ts\tUniversity of Salzburg, Department of Organismic Biology\t\t",
"SZUB\th\tUniversity of Szczecin\t\t",
"T\ts\tTavera, Department of Geology and Geophysics\t\t",
"TA\ts\tTimescale Adventures Research and Interpretive Center\t\t",
"TAA\ts\tEstonian Agricultural University, Institute of Agricultural and Environmental Sciences\t\t",
"TAAM\ts\tInstitute of Agricultural and Environmental Sciences of the Estonian University of Life Sciences\tTAAM<EST>",
"TAC\ts\tTarleton State University, Biological Sciences Department\t\t",
"TAD\ts\tBotanical Institute of the Tajikistan Academy of Sciences, Department of Flora and Systematics of Higher Plants\t\t",
"TAES\ts\tTexas A&M University, Department of Rangeland Ecology and Management\t\t",
"TAFIRI\ts\tTanzania Fisheries Research Institute\t\t",
"TAI\ts\tNational Taiwan University, Institute of Ecology and Evolutionary Biology\t\t",
"TAIC\ts\tTexas A&M University-Kingsville, Department of Biology\t\t",
"TAIE\th\tEndemic Species Research Institute\t\t",
"TAIF\ts\tTaiwan Forestry Research Institute\t\t",
"TAIM\ts\tTaiwan Museum\t\t",
"TAIU\ts\tTexas A&M University - Kingsville, Texas A&I Collections\t\t",
"TAK\ts\tLenin State University\t\t",
"TAL\th\tJardin botanique de Talence\t\t",
"TALE\ts\tLaboratoire Geologique\t\t",
"TALL\ts\tTallinn Botanic Garden, Department of Environmental Education\t\t",
"TAM\ts\tEstonian Museum of Natural History, Botany Department\t\t",
"TAMA\tc\tMycology & Metabolic Diversity Research Center, Tamagawa University Research Institute\t\t",
"TAMU\ts\tTexas A&M University, Biology Department\t\t",
"TAN\ts\tParc de Tsimbazaza, Departement Botanique\t\t",
"TANE\ts\tTanta University, Botany Department\t\t",
"TAR\ts\tConsiglio Nazionale delle Ricerche\t\t",
"TARI<CHN>\ts\tTaiwan Agricultural Research Institute\t\t",
"TARI<IRN>\ts\tResearch Institute of Forests and Rangelands, Botanical Department\t\t",
"TARI<TUR>\ts\tTrakya  Agricultural Research Institute\t\t",
"TASH\ts\tNational Academy of Science, Uzbekistan\t\t",
"TASM\ts\tUzbek Academy of Sciences, Laboratory of Mycology\t\t",
"TAU<GRC>\ts\tAristotle University of Thessaloniki, Biology Department\t\t",
"TAU<ISR>\ts\tTel-Aviv University\t\t",
"TAUF\ts\tAristotle University of Thessaloniki, Department of Forestry and Natural Environment\t\t",
"TAWES\th\tMaryland Department of Natural Resources\t\t",
"TB\ts\tTbilisi State University, Botany Department\t\t",
"TBG<JPN>\tb\tTsukuba Botanical Garden\t\t",
"TBGT\ts\tTropical Botanic Garden and Research Institute\t\t",
"TBI\ts\tGeorgian Academy of Sciences\t\t",
"TBIP\ts\tResearch Institute of Plant Protection\t\t",
"TBPH\th\tIovel Kutateladze Institute of Pharmacochemistry\t\t",
"TBY\ts\tTenby Museum\t\t",
"TCB\ts\tNational Chung Hsing University, Botany Department\t\t",
"TCC/USP\tc\tTrypanosomatid Culture Collection, University of Sao Paulo\tTRYCC",
"TCD\ts\tTrinity College\t\t",
"TCDL\ts\tTrinity College Library, Manuscript Department\t\t",
"TCDU<IRL>\tb\tTrinity College, Dublin University, Department of Zoology DNA repository\t\t",
"TCDU<UGA>\ts\tMinistry of Animal Industry and Fisheries\t\t",
"TCF\ts\tNational Chung Hsing University, Forestry Department\t\t",
"TCFB\tc\tTasmanian Collection of Fish Bacteria\t\t",
"TCMM\tc\tThai Collection of Medical Microorganism, Department of Pathology, Faculty of Veterinary Science\t\t",
"TCNM\ts\tTimpanogos Cave National Monument\t\t",
"TCSW\ts\tTexas Women's University, Biology Department\t\t",
"TCWC\ts\tTexas Cooperative Wildlife Collection\t\t",
"TCWC:Birds\ts\tTexas Cooperative Wildlife Collection, Collection of Birds",
"TCWC:Fish\ts\tTexas Cooperative Wildlife Collection, Collection of Fishes",
"TCWC:Herp\ts\tTexas Cooperative Wildlife Collection, Collection of Amphibians and Reptiles",
"TCWC:Invrt\ts\tTexas Cooperative Wildlife Collection, Collection of Marine Invertebrate",
"TCWC:Mamm\ts\tTexas Cooperative Wildlife Collection,  Mammal collection",
"TDA\ts\tDepartment of Agriculture, Tasmania\t\t",
"TDAH\ts\tTasmanian Department of Agriculture\t\t",
"TDMP\ts\tTa-Dzong Museum\t\t",
"TDN\ts\tTodmorden Botanical Society\t\t",
"TDNA\tb\tToulouse DNA databank\t\t",
"TDY\ts\tTyldesley Natural History Society\t\t",
"TEA\ts\tTea Research Institute\t\t",
"TEB\ts\tTeberda State Reserve\t\t",
"TECLA\ts\tCentro Nacional de Tecnologia Agropecuaria\t\t",
"TEF\ts\tCentre National de la Recherche Appliquee au Developement Rural, Departement des Recherches Forestieres et Piscicoles\t\t",
"TEFH\ts\tUniversidad Nacional Autonoma de Honduras, Departamento de Biologia\t\t",
"TEH\ts\tUniversity of Tehran\t\t",
"TELA\ts\tTel Aviv University, Botany Department\t\t",
"TELY\ts\tTate Library\t\t",
"TENHS\ts\tToynbee Natural History Society\t\t",
"TENN\ts\tDepartment of Ecology and Evolutionary Biology, University of Tennessee\t\t",
"TEPB\ts\tUniversidade Federal do Piaui, Departamento de Biologia\t\t",
"TER\ts\tIndiana State University, Life Science Department\t\t",
"TESC\ts\tThe Evergreen State College\t\t",
"TESRI\ts\tTaiwan Endemic Species Research Institute\t\t",
"TEU\ts\tTeikyo University, Education Department\t\t",
"TEUI\th\tU.S. Forest Service Southwest Region, Terrestrial Ecological Unit Inventory\t\t",
"TEX\ts\tUniversity of Texas at Austin, Plant Resources Center\t\t",
"TEXA\ts\tBlackland Experiment Station\t\t",
"TF<JPN>\ts\tForestry and Forest Products Research Institute\t\t",
"TF<THA>\ts\tDepartment of Mineral Resources\t\t",
"TFA\ts\tForestry and Forest Products Research Institute\t\t",
"TFAV\ts\tServicio Autonomo para el Desarrollo Ambiental del Estado Amazonas\t\t",
"TFC\ts\tUniversidad de La Laguna, Departamento de Biologia Vegetal (Botanica)\t\t",
"TFC<EST>\tc\tTartu Fungal Culture Collection\t\t",
"TFD\ts\tTanzania Forestry Research Institute\t\t",
"TFDA\ts\tTasmanian Fisheries Development Authority\t\t",
"TFIC\ts\tTasmanian Forest Insect Collection\t\t",
"TFM\ts\tForestry and Forest Products Research Institute\t\t",
"TFMC\ts\tMuseo de Ciencias Naturales de Santa Cruz de Tenerife\t\t",
"TFRI\ts\tTaiwan Fisheries Research Institute\t\t",
"TGM\ts\tJanashia State Museum of Georgia\t\t",
"TGPI\ts\tTiraspolskij Gosudarstvennij Pedagogiceskij Institut\t\t",
"TGRC\tb\tC.M. Rick Tomato Genetics Resource Center\t\t",
"TGU\th\tUniversity of Montenegro\t\t",
"TH\ts\tUniversity of Tokyo\t\t",
"THBC\ts\tTechnische Hochschule\t\t",
"THIB\ts\tNicholls State University, Department of Biological Sciences\t\t",
"THIM\ts\tNational Biodiversity Centre\t\t",
"THL\ts\tGrierson Museum\t\t",
"THO\ts\tRobert Dick Museum Library\t\t",
"THRI\ts\tSequoia and Kings Canyon National Parks\t\t",
"THS\ts\tTsumura Laboratory\t\t",
"THUP\ts\tTunghai University\t\t",
"TI\ts\tHerbarium of the Department of Botany, University of Tokyo\t\t",
"TIC\ts\tCalifornia Department of Fish and Game\t\t",
"TIE\ts\tTianjin Natural History Museum, Botany Department\t\t",
"TIK\ts\tAgricultural Research Centre, Plant Pathology Department\t\t",
"TIMGP\ts\tInstitut und Museum fuer Geologie und Palaeontologie der Unversitaet\t\t",
"TIMJ\ts\tTainai Insect Museum\t\t",
"TIMM\tc\tInstitute of Medical Mycology\t\t",
"TIPR\ts\tInstitute of Pharmaceutical Research\t\t",
"TISTR\tc\tTISTR Culture Collection Bangkok MIRCEN\t\t",
"TIU\ts\tTokyo Imperial University, Science College Museum\t\t",
"TJDC\ts\tTianjin Municipal Institute for Drug Control, Department of Traditional Chinese Medicine\t\t",
"TJMP\ts\tTianjin Institute of Medical and Pharmaceutical Sciences\t\t",
"TK\ts\tTomsk State University\t\t",
"TK<MEX>\ts\tColeccion de mamiferos del Centro Interdisciplinario de Investigacion para el Desarrollo Integral Regional Unidad Durango\t\t",
"TKB\ts\tUniversity of Tsukuba\t\t",
"TKNM\ts\tTwickenham Girls' School\t\t",
"TKPM\ts\tTokushima Prefectural Museum\t\t",
"TKU\ts\tTokyo Kyoiku University\t\t",
"TL\ts\tUniversite Paul Sabatier\t\t",
"TLA\ts\tEcole Nationale Superieure Agronomique\t\t",
"TLF\ts\tUniversite Paul Sabatier\t\t",
"TLHR\ts\tThueringer Landesmuseum Heidecksburg\t\t",
"TLJ\ts\tUniversite Paul-Sabatier\t\t",
"TLM\ts\tMuseum d'Histoire Naturelle de Toulouse\t\t",
"TLMF\ts\tTiroler Landesmuseum Ferdinandeum\t\t",
"TLON\ts\tMuseum d'Histoire Naturelle\t\t",
"TLP\ts\tFaculte de Medecine, Chaire de Botanique\t\t",
"TLS\ts\tTunbridge Wells Museum and Art Gallery\t\t",
"TLXM\ts\tUniversidad Autonoma de Tlaxcala\t\t",
"TM<DEU>\ts\tTeylers Museum, Paleontologische\t\t",
"TM<SVK>\ts\tSlovak National Museum\t\t",
"TM<ZAF>\ts\tTransvaal Museum\tTRM",
"TMAG\ts\tTasmanian Museum & Art Gallery\t\t",
"TMAL\ts\tTameside Metropolitan Borough Museum\t\t",
"TMBS\ts\tTatsuo Tanaka Memorial Biological Laboratory\t\t",
"TMC<AUS>\ts\tTate Museum Collection\t\t",
"TMC<USA-CO>\tc\tTrudeau Mycobacterial Culture Collection, Trudeau Institute\t\t",
"TMC<USA-ID>\tc\tThe Mollicutes Collection\t\t",
"TMDU\ts\tTokyo Medical and Dental University\t\t",
"TMFE\ts\tElasmobranchii Collection of the Department of Fisheries, Tokai University\t\t",
"TMH\ts\tTasmanian Museum and Art Gallery\t\t",
"TMHN\ts\tTeyler Museum\t\t",
"TMI\ts\tTottori Mycological Institute\t\t",
"TMM\ts\tTexas Memorial Museum\t\t",
"TMMC\ts\tTexas Memorial Museum\t\t",
"TMNH\ts\tTianjin Museum of Natural History\t\t",
"TMP<FIN>\ts\tTampere Museums\t\t",
"TMP<ZAF>\ts\tTransvaal Museum\t\t",
"TMRC\th\tShahid Beheshti University of Medical Sciences\t\t",
"TMS\ts\tToleco Museum of Health and Natural History\t\t",
"TMSA\ts\tTransvaal Museum\t\t",
"TMTC\ts\tTaiwan Provincial Museum\t\t",
"TNAU\ts\tTamil Nadu Agricultural University\t\t",
"TNFC\ts\tTynside Naturalists' Field Club\t\t",
"TNFS\ts\tUSDA Forest Service, Alaska Region\t\t",
"TNHC\ts\tTexas Memorial Museum, Texas Natural History Collection\t\t",
"TNHM\ts\tUniversity of Texas\t\t",
"TNM\ts\tNational Museum of Natural Science, Botany Department\t\t",
"TNP\ts\tMuseum of Tatra National Park\t\t",
"TNS\ts\tNational Science Museum, Department of Botany\t\t",
"TNSC<BEL>\ts\tThierry Neef de Sainval\t\t",
"TNSC<USA-NJ>\ts\tTrailside Nature and Science Center\t\t",
"TNSM\ts\tThailand Natural History Museum\tTHNHM",
"TNU\ts\tNational Taiwan Normal University, Herbarium\t\t",
"TNZ\ts\tTianjin Nat. Hist. Mus.\t\t",
"TO\ts\tUniversita degli Studi di Torino, Dipartimento di Biologia Vegetale\t\t",
"TOD\ts\tTodmorden Free Library\t\t",
"TOFO\ts\tUniversity of Tokyo, Section of Forest Botany\t\t",
"TOGO\ts\tUniversite du Lome, Laboratoire de Botanique et Ecologie Vegetale\t\t",
"TOGR\ts\tMuseo di Storia Naturale Don Bosco\t\t",
"TOHO\ts\tToho University\t\t",
"TOKE\ts\tTokyo University of Education\t\t",
"TOLI\ts\tUniversidad del Tolima, Departamento de Biologia\t\t",
"TOM\ts\tIstituto Missioni Consolata\t\t",
"TOM<CAN>\tc\tTomicus collection Canadian Forest Service\t\t",
"TON\th\tMinistry of Agriculture and Food, Forestry and Fisheries\t\t",
"TONG\ts\tTonghua Teachers College, Biology Department\t\t",
"TOR\ts\tTorquay Museum\t\t",
"TOU\th\tUniversity of Tours\t\t",
"TOYA\ts\tToyama Science Museum, Botany Department\t\t",
"TPI\ts\tThe Pirbright Institute\t\t",
"TPI:ENT\ts\tThe Pirbright Institute, Entomology collection",
"TPII\ts\tThanksgiving Point Institute\t\t",
"TPNG\ts\tDepartment of Primary Industry\t\t",
"TPV\ts\tPrairie View A & M University, Biology Department\t\t",
"TR\ts\tMuseo Tridentino di Scienze Naturali\t\t",
"TRA\ts\tAmerican Plant Life Society\t\t",
"TRD\ts\tAncient House Museum\t\t",
"TRE\ts\tTrencianske muzeum, Scientific Department\t\t",
"TRES\ts\tTresco Abbey\t\t",
"TRH\ts\tNorwegian University of Science and Technology, Department of Natural History\t\t",
"TRIN\ts\tThe National Herbarium of Trinidad and Tobago\t\t",
"TRM\ts\tVlastivedne muzeum Trutnov\t\t",
"TRN\ts\tN. Copernicus University\t\t",
"TRO\ts\tRoyal Horticultural Society of Cornwall\t\t",
"TROM\ts\tUniversity of Tromsoe, Botanical Department\t\t",
"TROY\ts\tTroy State University, Department of Biological and Environmental Sciences\t\t",
"TRPM\th\tTottori Prefectural Museum\t\t",
"TRT\ts\tRoyal Ontario Museum, Department of Natural History\t\t",
"TRTC\ts\tRoyal Ontario Museum, Center for Biodiversity and Conservation Biology\t\t",
"TRTE\ts\tErindale College, University of Toronto, Department of Biology\t\t",
"TRTS\ts\tScarborough College, University of Toronto, Botany Department\t\t",
"TRU\ts\tRoyal Cornwall Museum\t\t",
"TRV\ts\tTransvaal Museum\t\t",
"TS\ts\tNational University of Shandong, Biology Department\t\t",
"TSB\ts\tUniversita degli Studi di Trieste, Dipartimento di Biologia\t\t",
"TSC\ts\tTarleton State University, Tarleton State Collection\t\t",
"TsGM\ts\tCentral Geological Museum\t\t",
"TSH\th\tUniversity of Tsukuba\t\t",
"TSM\ts\tErbario, Museo Civico di Storia Naturale, Trieste\t\t",
"TSMHN\ts\tTeylers Strichtina Museum\t\t",
"TsNIGRI\ts\tTsentralny Nauchno-Issledovatelskii Geolgo-Razvedochni Muzei (Chernyshev's Central Museum of Geological Exploration)\t\t",
"TSSMC\ts\tTeton Science School\t\t",
"TSTN\ts\tTroston Hall\t\t",
"TSU\ts\tMiye University\t\t",
"TSY\tc\tLaboratory of Mycology, Division of Microbiology\t\t",
"TTC\ts\tTexas Tech University, Biological Sciences Department\t\t",
"TTCC\ts\tTexas Tech University\t\t",
"TTMB\ts\tTermeszettudomanyi Muzeum\t\t",
"TTN\ts\tSomerset County Museum\t\t",
"TTRS\ts\tTall Timbers Research Station, Fire Ecology Laboratory\t\t",
"TTU\ts\tTexas Tech University, Museum\t\t",
"TTY\ts\tWestonbirt School\t\t",
"TU<DEU>\ts\tInstitut fur Geologie und Palaontologie, Technische Universitat Braunschweig\t\t",
"TU<EST>\ts\tUniversity of Tartu, Botanical and Mycological Museum\t\t",
"TU<USA-LA>\ts\tTulane University, Museum of Natural History\t\t",
"TU<USA-LA>:Birds\ts\tTulane University, Museum of Natural History, Ornithological Collection",
"TU<USA-LA>:Fish\ts\tTulane University, Museum of Natural History, Fish Collection",
"TU<USA-LA>:Herptiles\ts\tTulane University, Museum of Natural History, Amphibian And Reptile Collection",
"TU<USA-LA>:Invertebrates\ts\tTulane University, Museum of Natural History, Invertebrate Collection",
"TU<USA-LA>:Mammals\ts\tTulane University, Museum of Natural History, Mammal Collection",
"TUAT\ts\tTokyo University of Agriculture\t\t",
"TUB\ts\tEberhard-Karls-Universitaet Tuebingen, Institut fuer Biologie I\t\t",
"TUBSB\tb\tTohoku University Brassica Seed Bank\t\t",
"TUC\ts\tUniversity of Arizona, Ecology and Evolutionary Biology Department\t\t",
"TUCH\ts\tTribhuvan University, Central Department of Botany\t\t",
"TUCIM\tc\tTU Wien collection of industrial microorganisms\t\t",
"TUFC\ts\tTottori University Fungal Culture Collection\t\t",
"TUFIL\ts\tTokyo University of Fisheries, Ichthyological Laboratory\t\t",
"TUFT\ts\tTufts University, Biology Department\t\t",
"TUH\ts\tTehran University, Department of Biology\t\t",
"TULE\ts\tTokyo University of Agriculture & Technology\t\t",
"TULS\ts\tUniversity of Tulsa\t\t",
"TULV\ts\tJardin Botanico Juan Maria Cespedes\t\t",
"TUM\th\tTechnische Universitat Munchen\t\t",
"TUMH\ts\tTottori Fungus/Mushroom Resource and Research Center\t\t",
"TUN\ts\tUniversite de Tunis, Laboratoire de Biologie Vegetale\t\t",
"TUNG\ts\tTunghai University, Biology Department\t\t",
"TUP\ts\tTrent University, Biology Department\t\t",
"TUPH\ts\tInstitute of Public Health Research\t\t",
"TUR\ts\tUniversity of Turku\t\t",
"TURA\ts\tAabo Akademi University, Biology Department\t\t",
"TURP\ts\tTurpan Eremophytes Botanical Garden\t\t",
"TUS\ts\tTohoku University, Biological Institute\t\t",
"TUSG\ts\tTohoku University\t\t",
"TUT\ts\tDaejeon University, Department of Biology\t\t",
"TUTC\ts\tTunghai University\t\t",
"TUZ\ts\tTartu University Zoological Department\t\t",
"TV\ts\tCentro de Estratigrafia e Paleobiologia da Universidade Nova de Lisboa\t\t",
"TVBG\ts\tTver State University\t\t",
"TVY\ts\tTurvey Abbey\t\t",
"TWC\ts\tTexas Wesleyan College, Museum of Zoology\t\t",
"TWRA\ts\tTennessee Wildlife Resources Agency\t\t",
"TYF\ts\tShangxi Forestry Institute\t\t",
"TYM\th\tBotanic Gardens of Toyama\t\t",
"TZM\ts\tNational Science Museum\t\t",
"U\ts\tNationaal Herbarium Nederland, Utrecht University branch\t\t",
"UA<GRC>\ts\tDepartment of Historical Geology and Paleontology\t\t",
"UA<USA-AL>\ts\tUniversity of Alabama Collection\t\t",
"UA<USA-AZ>\ts\tUniversity of Arizona\t\t",
"UAAAC\ts\tUniversity of Alaska Anchorage Avian Collection\t\t",
"UAAH\ts\tHerbarium, Department of Biological Sciences, University of Alaska Anchorage\t\t",
"UAAM\ts\tThe Arthropod Museum, University of Arkansas\t\t",
"UAB<ESP>\ts\tUniversidad Autonoma de Barcelona\t\t",
"UABC\ts\tUniversidad Autonoma de Baja California\t\t",
"UABCS\ts\tUniversidad Nacional Autonoma de Baja California Sur (Mexico)\t\t",
"UABD\ts\tUniversity of Alabama\t\t",
"UAC\ts\tUniversity of Calgary, Department of Biological Sciences\t\t",
"UACC\ts\tUniveridad Autonoma de Chapingo\t\t",
"UACCC\tc\tUniversity of Alabama Chytrid Culture Collection\tUA-SEC",
"UADBA\ts\tUniversity dAntananarivo, Department de Biologie Animale\t\t",
"UADY\ts\tUniversidad Autonoma de Yucatan, Departamento de Botanica\t\t",
"UAEM\ts\tUniveridad Autonoma de Morelos\t\t",
"UAEU\ts\tUnited Arab Emirates University\t\t",
"UAGC\ts\tUniversidad Autonoma de Guerrero, Area de Ciencias Naturales\t\t",
"UAIC<CIV>\ts\tUniversity of Abidjan\t\t",
"UAIC<USA-AL>\ts\tUniversity of Alabama, Ichthyological Collection\t\t",
"UAIC<USA-AZ>\ts\tUniversity of Arizona\t\t",
"UALRVC\ts\tUniversity of Arkansas at Little Rock, Vertebrate Collection\t\t",
"UAM\ts\tUniversity of Alaska, Museum of the North\tUAF",
"UAM:Bird\ts\tUniversity of Alaska, Museum of the North, Bird Collection",
"UAM:Bryo\ts\tUniversity of Alaska, Museum of the North, Bryozoan Collection",
"UAM:Crus\ts\tUniversity of Alaska, Museum of the North, Marine Arthropod Collection",
"UAM:Ento\ts\tUniversity of Alaska, Museum of the North, Insect Collection",
"UAM:ES\ts\tUniversity of Alaska, Museum of the North, Earth Science",
"UAM:Fish\ts\tUniversity of Alaska, Museum of the North, Fish Collection",
"UAM:Herb\ts\tUniversity of Alaska, Museum of the North, UAM Herbarium",
"UAM:Herp\ts\tUniversity of Alaska, Museum of the North, Amphibian and Reptile Collection",
"UAM:Mamm\ts\tUniversity of Alaska, Museum of the North, Mammal Collection",
"UAM:Moll\ts\tUniversity of Alaska, Museum of the North, Mollusc Collection",
"UAM:Paleo\ts\tUniversity of Alaska, Museum of the North, paleontology collection",
"UAM<ESP>\tc\tUniversidad Autonoma De Madrid culture collection of cyanobacteria\t\t",
"UAM<USA-AL>\ts\tUniversity of Alabama, Malacology Collection\t\t",
"UAM<USA-AR>\ts\tUniversity of Arkansas at Monticello\t\t",
"UAM<VEN>\ts\tUniversidad de los Andes, Facultad de Ciencias\t\t",
"UAMH\tscb\tUniversity of Alberta Microfungus Collection and Herbarium\t\t",
"UAMI\ts\tUniversidad Autonoma Metropolitana, Unidad Iztapalapa (Mexico)\t\t",
"UAMIZ\ts\tUniversidad Autonoma Metropolitana, Iztapalapa, Departamento de Biologia\t\t",
"UAMM\ts\tUniversidad de los Andes\t\t",
"UAMZ\ts\tUniversity of Alberta Museum of Zoology\t\t",
"UAMZC\ts\tUniversity of Arkansas, Museum Zoological Collections\t\t",
"UANL\ts\tUniversidad Autonoma de Nuevo Leon\t\t",
"UAPC\th\tUniversity of Alberta\t\t",
"UARK\ts\tUniversity of Arkansas\t\t",
"UAS\ts\tUniversidad Autonoma de Sinaloa\t\t",
"UAS-B\ts\tUniversity of Agricultural Sciences Bangalore\t\t",
"UASB\ts\tUniversity of Agricultural Sciences, Bangalore\t\t",
"UASC\ts\tMuseo de Historia Natural \"Noel Kempff Mercado\"\t\t",
"UASK\ts\tUkrainian Academy of Science\t\t",
"UASM\ts\tUniversity of Alberta, E.H. Strickland Entomological Museum\t\t",
"UAT\ts\tUniversidad Autonoma de Tamaulipas\t\t",
"UAVP\ts\tUniversity of Alberta, Laboratory for Vertebrate Paleontology\t\t",
"UAWC<WBK>\tb\tUnion of Agricultural Work Committees\t\t",
"UAY\ts\tUniversidad Autonoma de Yucatan, Facultad de Medicina Veterinaria y Zootecnia\t\t",
"UAZ\ts\tUniversity of Arizona\t\t",
"UB\tsc\tUniversity of Brasilia Herbarium\t\t",
"UB<FRA>\ts\tLaboratoire de Biostratigraphie\t\t",
"UBA\ts\tMongolian Academy of Sciences\t\t",
"UBC\ts\tBeaty Biodiversity Museum, University of British Columbia\t\t",
"UBC:CTC\ts\tBeaty Biodiversity Museum, University of British Columbia, Cowan Tetrapod Collection",
"UBC:Fish\ts\tBeaty Biodiversity Museum, University of British Columbia, Fish Collection",
"UBC:SEM\ts\tBeaty Biodiversity Museum, University of British Columbia, Spencer Entomological Museum",
"UBCC\tc\tUniversity of Barcelona Culture Collection\t\t",
"UBCZ\ts\tUniversity of British Columbia, Spencer Entomological Museum\t\t",
"UBDH\th\tUniversiti Brunei Darussalam\t\t",
"UBJTL\ts\tUniversidad Bogota Jorge Tadeo Lozano\t\t",
"UBL\ts\tUniversite du Benin\t\t",
"UBOCC\tc\tUniversite de Bretagne Occidentale\t\t",
"UBT\ts\tOekologisch-Botanischer Garten\t\t",
"UBU\ts\tMongolian State University, Botany Department\t\t",
"UC<AUS>\tscb\tUniversity of Canberra Wildlife Tissue Collection\t\t",
"UC<USA-CA>\ts\tUniversity of California, University Herbarium\t\t",
"UC<USA-MI>\tc\tUpjohn Culture Collection\t\t",
"UCAC\ts\tUniversity of Central Arkansas, Department of Biology\t\t",
"UCAM\ts\tUniversidad Autonoma de Campeche\t\t",
"UCB\ts\tUniversity of California at Berkeley\t\t",
"UCBG\ts\tUniversity of Botswana, Department of Biological Sciences\t\t",
"UCBL\ts\tCentre de Paleontologie Stratigraphique et Paleoecologie\t\t",
"UCBMG\tc\tUniversity of California Berkeley Mycogarden\t\t",
"UCC\ts\tUniversity of Cincinnati\t\t",
"UCC<IRL>\ts\tUniversity College Cork\t\t",
"UCCC\ts\tUniversidad de Concepcion, Museo de Zoologia\t\t",
"UCCM\tc\tUniversity of Calabar Collection of Microorganisms\t\t",
"UCD\tscb\tUniversity of California, Davis\t\t",
"UCDBA\ts\tUniversity of Chicago\t\t",
"UCDFST\tc\tPhaff Yeast Culture Collection\t\t",
"UCFC\ts\tUniversity of Central Florida\t\t",
"UCGC\ts\tUniversity of Colorado, Geological Museum\t\t",
"UCGE\tc\tUnit Cell of Genetic Engineering, Department of Biochemistry\t\t",
"UCH\th\tUniversidad Autonoma de Chiriqui\t\t",
"UCHT\ts\tUniversity of Tennessee, Chattanooga, Department of Biological and Environmental Sciences\t\t",
"UCI\ts\tUniversity of Ibadan, Botany and Microbiology Department\t\t",
"UCJ\ts\tUniversite d'Abidjan, Departemente de Botanique\t\t",
"UCL<BEL>\tc\tCatholic University of Louvain\t\t",
"UCL<GBR>\ts\tUniversity College London\t\t",
"UCLA\ts\tUniversity of California at Los Angeles\t\t",
"UCLAF\tc\tHMR/Romainville\t\t",
"UCLGMZ\ts\tGrant Museum of Zoology and Comparative Anatomy\t\t",
"UCLZ\ts\tUniversity College London\t\t",
"UCM<ESP>\ts\tUniversidad Complutense Madrid\t\t",
"UCM<UKR>\tc\tUkrainian Collection of Microorganisms, Zabolotny Institute of Microbiology and Virology\t\t",
"UCM<USA-CO>\ts\tUniversity of Colorado Museum\t\t",
"UCM<USA-CO>:Bird\ts\tUniversity of Colorado Museum, University of Colorado Museum Bird Collection",
"UCM<USA-CO>:Fish\ts\tUniversity of Colorado Museum, University of Colorado Museum Fish collection",
"UCM<USA-CO>:Herp\ts\tUniversity of Colorado Museum, University of Colorado Museum Amplibian and Reptile collection",
"UCM<USA-CO>:Mamm\ts\tUniversity of Colorado Museum, University of Colorado Museum Mammal Collection",
"UCMC\ts\tUniversity of Colorado Museum\t\t",
"UCME\ts\tFaculdad de Biologia, Departamento de Zoologia\t\t",
"UCMM\ts\tPontificia Universidad Catolica Madre y Maestra\t\t",
"UCMP\ts\tUniversity of California Museum of Paleontology\t\t",
"UCMS\ts\tStorrs, University of Connecticut\t\t",
"UCNW\ts\tUniversity of Wales\t\t",
"UCNZ\ts\tUniversity of Canterbury\t\t",
"UCOB\ts\tUniversidad Centroccidental Lisandro Alvarado, Departamento de Ciencias Biologicas\t\t",
"UCOCV\ts\tUniversity of Central Oklahoma, Collection of Vertebrates\t\t",
"UCONN\ts\tUniversity of Connecticut\t\t",
"UCP\ts\tUniversidad del Cauca\tMHNUC ",
"UCPC\ts\tUniversidad del Cauca\t\t",
"UCR<CRI>\ts\tUniversidad de Costa Rica, Museo de Zoologia\t\t",
"UCR<USA-CA>\ts\tUniversity of California, Riverside\t\t",
"UCR<USA-CA>:ENT\ts\tUniversity of California, Riverside, Entomology Collection",
"UCS<USA-CT>\ts\tUniversity of Connecticut\t\t",
"UCS<USA-NY>\ts\tUnion College, Department of Biological Sciences\t\t",
"UCSA\ts\tUniversity College of Swansea, Botany Department\t\t",
"UCSB\ts\tUniversity of California, Santa Barbara\t\t",
"UCSC\ts\tUniversity of California, Department of Environmental Studies\t\t",
"UCSW\ts\tUniversity College, Botany Department\t\t",
"UCVC\ts\tUniversidad Catolica de Valparaiso\t\t",
"UCWI\ts\tUniversity of the West Indies, Department of Life Sciences\t\t",
"UDBC\ts\tUniversidad Distrital\t\t",
"UDCC\ts\tUniversity of Delaware\t\t",
"UDEL\ts\tUniversity of Delaware\t\t",
"UDM\ts\tMuseo Friulano di Storia Naturale\t\t",
"UDO\ts\tUniversidad de Oriente\t\t",
"UDONECI\ts\tUniversidad de Oriente\t\t",
"UDSM\ts\tUniversity of Dar es Salaam\t\t",
"UDU\ts\tUdmurt State University, Department of Biology and Chemistry\t\t",
"UDW\ts\tUniversity of Durban-Westville, Botany Department\t\t",
"UEA\ts\tUniversity of East Anglia\t\t",
"UEC\ts\tUniversidade Estadual de Campinas, Departamento de Botanica\t\t",
"UEFS\ts\tLaboratorio de Ictiologia\t\t",
"UENF\ts\tUniversidade Estadual do Norte Fluminense\t\t",
"UESC\th\tUniversidade Estadual de Santa Cruz\t\t",
"UESS\ts\tUniversidad de El Salvador\t\t",
"UEVH\ts\tUniversidade de Evora, Departamento de Biologia\t\t",
"UF\tsb\tUniversity of Florida Museum of Natural History\tFLMNH",
"UF/FGS\ts\tFlorida Geological Survey\t\t",
"UF:Herpetology\ts\tUniversity of Florida Museum of Natural History, Herpetology Collection",
"UF:Ichthyology\ts\tUniversity of Florida Museum of Natural History, Fish Collection",
"UF:Invertebrate\ts\tUniversity of Florida Museum of Natural History, Invertebrate Zoology and Malacology Collection",
"UF:Mammalogy\ts\tUniversity of Florida Museum of Natural History, Mammalogy Collection",
"UF:Ornithology\ts\tUniversity of Florida Museum of Natural History, Ornithology Skins and Skeletons Collection",
"UF:Porifera\ts\tUniversity of Florida Museum of Natural History, ",
"UFA\ts\tUfa Scientific Centre, Russian Academy of Sciences\t\t",
"UFACPZ\th\tUniversidade Federal do Acre/Parque Zoobotanico\t\t",
"UFC\ts\tUniversidade Federal do Ceara, Departamento de Biologia\t\t",
"UFES\ts\tUniversidade Federal do Espirito Santo\t\t",
"UFG\ts\tUniversidade Federal de Goias, Unidade de Conservacao\t\t",
"UFH\ts\tUniversity of Fort Hare, Botany Department\t\t",
"UFHNH\ts\tUtah Field House of Natural History State Park\t\t",
"UFJF\ts\tUniversidade Federal de Juiz de Fora\t\t",
"UFMA\ts\tUniversidade Federal do Maranhao, Curso de Farmacia\t\t",
"UFMG<BRA>\ts\tUniversidade Federal de Minas Gerais\t\t",
"UFMI\ts\tUniversidade Federal de Mato Grosso, Instituto de Biociencias\t\t",
"UFMT\ts\tUniversidade Federal de Mato Grosso\t\t",
"UFNH\ts\tUtah Field House Natural History [address unknown]\t\t",
"UFOP\ts\t Universidade Federal de Ouro Preto\t\t",
"UFP\ts\tUniversidade Federal de Pernambuco, Departamento de Botanica\t\t",
"UFPB\ts\tDepartamento de Sistematica e Ecologia\t\t",
"UFPEDA\tc\tUniversidade Federal de Pernambuco\t\t",
"UFRG\ts\tInstituto de Biologia\t\t",
"UFRGS\ts\tUniversidade Federale do Rio Grande do Sul\t\t",
"UFRJ<herbarium>\tsc\tHerbario e Colecao Fitopathologica \"Verlande Duarte Silveira\"\t\t",
"UFRJ<museum>\ts\tDepartramento de Zoologia, Universidade Federal do Rio de Janeiro\t\t",
"UFRJ<museum>:POR\ts\tDepartramento de Zoologia, Universidade Federal do Rio de Janeiro, Porifera collection",
"UFRJIM\tc\tDepartamento de Microbiologia Medica\t\t",
"UFRN\ts\tUniversidade Federal do Rio Grande do Norte\t\t",
"UFRN:Fungos\ts\tUniversidade Federal do Rio Grande do Norte, Fungal collection",
"UFRR\th\tUniversidade Federal de Roraima\t\t",
"UFS\ts\tNyabyeya Forestry College, Department of Environmental Forestry\t\t",
"UFSC\ts\tUniversidade Federal de Santa Catarina\t\t",
"UFScarCC\tc\tFreshwater Microalgae Collection Cultures\t\t",
"UFU\th\tUral Federal University\t\t",
"UFVB\ts\tVicosa, Universidade Federal de Vicosa, Museum of Entomology\t\t",
"UG<ESP>\ts\tMuseo del Departamento de Estratigrafia y Paleontologia\t\t",
"UG<GHA>\ts\tUniversity of Ghana\t\t",
"UGAMNH\ts\tUniversity of Georgia Museum of Natural History\t\t",
"UGCA\ts\tUniversity of Georgia\t\t",
"UGDA\ts\tGdansk University, Department of Plant Taxonomy and Nature Conservation\t\t",
"UGDZ\ts\tUniversity of Guelph, Department of Zoology\t\t",
"UGG\ts\tUniversity of Guam\t\t",
"UGGE\ts\tUniversidad de Guayaquil\t\t",
"UGGG\ts\tUniversity of Guyana\t\t",
"UGM\ts\tUniversity of Guam\t\t",
"UGMD\ts\tZoology Museum of the University of Ghent\t\t",
"UH\ts\tUniversity of Hawaii\t\t",
"UHCC\tc\tUniversity of Helsinki Cyanobacteria Culture Collection\t\t",
"UHI\ts\tUssishkin House, Botany Department\t\t",
"UHM\ts\tManoa, College of Tropical Agriculture, Department of Entomology\t\t",
"UI<NGA>\ts\tUniversity of Ibadan\t\t",
"UI<USA-UT>\ts\tBureau of Land Management\t\t",
"UICC\tc\tUniversity of Indonesia Culture Collection\t\t",
"UIDA\ts\tUniversity of Idaho, Bird and Mammal Museum\t\t",
"UIM\ts\tUniversity of Idaho\t\t",
"UIMNH\ts\tUniversity of Illinois, Museum of Natural History\t\t",
"UIS\ts\tUniversidad Industrial de Santander, Departamento de Biologia\t\t",
"UIS:H\ts\tUniversidad Industrial de Santander, Departamento de Biologia, Collecion Herpetologica",
"UISMHN\ts\tUniversidad Industrial de Santander, Museo de Historia Natural\t\t",
"UJAT\ts\tUniversidad Juarez Autonoma de Tabasco\t\t",
"UJB\tc\tUniversity of Jaffna Botany\t\t",
"UJIM\ts\tUniversity of Jordan Insect Museum\t\t",
"UK<USA-KY>\ts\tUniversity of Kentucky\t\t",
"UKEN\ts\tUniversity of Kentucky\t\t",
"UKKP\tc\tUniversiti Kebangsaan Kultur Perubatan\t\t",
"UKKY\ts\tUniversity of Kunming\t\t",
"UKM<DEU>\ts\tUniversitaetsklinikum Muenster\t\t",
"UKMB\ts\tUniversiti Kebangsaan Malaysia, Botany Department\t\t",
"UKMHC\ts\tUniversiti Kebangsaan Malaysia\t\t",
"UKMHC:HC\ts\tUniversiti Kebangsaan Malaysia, Herpetological Collection",
"UKMS<MYS>\ts\tUniversiti Kebangsaan Malaysia, Kampus Sabah\t\t",
"UKMS<SDN>\ts\tSudan Natural History Museum\t\t",
"UKS\ts\tUniversity of Khartoum\t\t",
"UKSPI\ts\tUst-Kamenogorsk State Pedagogical Institute, Botany Department\t\t",
"UL\ts\tUniversity of Louisville\t\t",
"ULABG\ts\tUniversidad de los Andes, Laboratorio de Biogeografia\t\t",
"ULCI\ts\tUniversidad de la Laguna\t\t",
"ULF\ts\tUniversite Laval, Departement des Sciences forestieres\t\t",
"ULKY\ts\tUniversity of Louisville\t\t",
"ULLZ\ts\tUniversity of Louisiana at Layafette Zoological Collection\tUSLZ",
"ULM\ts\tUniversitaet Ulm, Abteilung Systematische Botanik und Oekologie\t\t",
"ULMG\ts\tUniversity of Leipzig\t\t",
"ULN\ts\tUniversity of Lagos\t\t",
"ULQC\ts\tUniversity of Laval\t\t",
"ULS\ts\tUniversidad de La Serena, Departamento de Biologia\t\t",
"ULT\ts\tAl-Faateh University, Botany Department\t\t",
"ULV\ts\tUniversidad Central de Las Villas\t\t",
"UM<DEU>\ts\tUniversity of Marburg\t\t",
"UM<USA-TN>\ts\tUniversity of Memphis, Mammal Collection\t\t",
"UM<ZWE>\ts\tUmtali Museum\t\t",
"UMA\ts\tUniversity of Massachusetts, Museum of Zoology\t\t",
"UMAN\ts\tUniversity of Manitoba, Zoological Collection\t\t",
"UMB\ts\tUebersee-Museums\t\t",
"UMBB\ts\tUebersee-Museum, Bremen or Department of Zoology, University of Bremen\t\t",
"UMBC\ts\tUniveristy of Malawi\t\t",
"UMBS\ts\tUniversity of Michigan\t\t",
"UMD\ts\tUniversity of Minnesota, Duluth\t\t",
"UMDC\ts\tUniversity of Maryland\t\t",
"UMDE\ts\tUniversity of Maine\t\t",
"UME\ts\tUmeaa University\t\t",
"UMEC\ts\tUniversity of Massachusetts\t\t",
"UMED\ts\tUniversity of Moi\t\t",
"UMF<USA-FL>\ts\tUniversity of Miami\t\t",
"UMF<USA-ME>\ts\tUniversity of Maine, Farmington\t\t",
"UMF<USA-MI>\ts\tUniversity of Michigan, Biology Department\t\t",
"UMFFTD\tc\tFood and Fermentation Technology Division, University of Mumbai\t\t",
"UMFK\ts\tUniversity of Maine at Fort Kent, Biology Department\t\t",
"UMH\ts\tUniversidad Miguel Hernandez, Departamento de Biologia Aplicada\t\t",
"UMHB\ts\tUniversity of Mary Hardin-Baylor\t\t",
"UMIC\ts\tUniversity of Mississippi\t\t",
"UMIM\ts\tUniveristy of Miami Ichthyological Museum\t\t",
"UMIP\tc\tCollection de Champignons et Actinomycetes Pathogenes\t\t",
"UMKC\ts\tUniversity of Missouri\t\t",
"UMKL\ts\tUniversity of Malaysia\t\t",
"UMKU\ts\tUganda Museum\t\t",
"UMM\th\tUniversity of Maine at Machias\t\t",
"UMML\ts\tUniversity of Miami Marine Laboratory\t\t",
"UMMP\ts\tUniversity of Michigan\t\t",
"UMMZ\ts\tUniversity of Michigan, Museum of Zoology\t\t",
"UMMZ:MC\ts\tUniversity of Michigan, Museum of Zoology, Mollusk Collection",
"UMNH\ts\tUtah Museum of Natural History\t\t",
"UMNH:Mamm\ts\tUtah Museum of Natural History, Mammal collection",
"UMO<GBR>\ts\tUniversity Museum of Natural History\t\t",
"UMO<USA-ME>\ts\tUniversity of Maine\t\t",
"UMO<USA-MO>\ts\tDunn-Palmer Herbarium, University of Missouri, Museum Support Center\t\t",
"UMOC\ts\tUniversity of Missouri, Museum of Zoology\t\t",
"UMRC\tc\tUniversity of Minnesota Rhizobium Collection\t\t",
"UMRM\ts\tW.R. Enns Entomology Museum\t\t",
"UMS\ts\tUniversiti Malaysia Sabah\t\t",
"UMSA\ts\tInstituto de Ecologia\t\t",
"UMSNH\ts\tIchthyology Collection of the Laboratory of Aquatic Biology, Michoacan University of San Nicolas de Hidalgo\t\t",
"UMSP\ts\tUniversity of Minnesota\t\t",
"UMSS\ts\tUniversidad Mayor de San Simon, Facultad de Ciencias y Tecnologia, Centro de Biodiversidad, Zoologia,Laboratorio de Ictiologia\t\t",
"UMT\ts\tMutare Museum\t\t",
"UMUT\ts\tUniversity Museum, University of Tokyo\t\t",
"UMUTZ\ts\tDepartment of Zoology, University Museum\t\t",
"UMZ\ts\tUnivesity Museum of Zoology, Cambridge University\t\t",
"UMZC\ts\tUniversity Museum of Zoology Cambridge\t\t",
"UMZM\ts\tUniversity of Montana, Zoological Museum\t\t",
"UN\ts\tUniversity of Nebraska\t\t",
"UNA\ts\tUniversity of Alabama, Department of Biological Sciences\t\t",
"UNAB\ts\tUniversidad Nacional, Facultad de Agronomia\t\t",
"UNAC\ts\tUniversidad Nacional Agraria\t\t",
"UNAD\ts\tUniversidad Nacional Agraria\t\t",
"UNAF\ts\tUniversity of North Alabama, Department of Biology\t\t",
"UNAH\ts\tUniversidad Nacional Autonoma de Honduras\t\t",
"UNAM\ts\tUniversidad Nacional Autonoma de Mexico\tIBUNAM",
"UNAM:CNAC\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Acaros",
"UNAM:CNAN\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Aracnidos",
"UNAM:CNAR\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Anfibios",
"UNAM:CNAV\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Aves",
"UNAM:CNCR\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Crustaceos",
"UNAM:CNHE\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Helmintos",
"UNAM:CNIN\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Insectos",
"UNAM:CNMA\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Mamiferos",
"UNAM:CNMO\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Moluscos",
"UNAM:CNPE\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional de Peces",
"UNAM:CNPGG\ts\tUniversidad Nacional Autonoma de Mexico, Coleccion Nacional del Phylum Porifera Gerardo Green",
"UNAN\ts\tUniversidad Nacional Autonoma de Nicaragua\t\t",
"UNB\ts\tConnell Memorial Herbarium\t\t",
"UNC-B\ts\tUniversity of Northern Colorado\t\t",
"UNCA\th\tUniversity of North Carolina at Asheville\t\t",
"UNCB\ts\tUniversidad Nacional de Colombia, Insituto de Ciencias Naturales de la Universidad Nacional\t\t",
"UNCC<COL>\ts\tUniversidad Nacional de Caldas, Museo de Historia Natural\t\t",
"UNCC<USA-NC>\ts\tUniversity of North Carolina, Biology Department\t\t",
"UNCG\tc\tUniversity of North  Carolina at Greensboro\t\t",
"UNCM\ts\tMuseo de Entomologia \"Francisco Luis Gallego\"\t\t",
"UNCP\ts\tUniversidad Nacional de Colombia\t\t",
"UNCW\ts\tUniversity of North Carolina at Wilmington\t\t",
"UND\ts\tUniversity of North Dakota, Vertebrate Museum\t\t",
"UNDH\ts\tUniversity of Natal Durban\t\t",
"UNEFM\ts\tUniversidad Experimental Francisco de Miranda\t\t",
"UNEVR\ts\tUniversity of Nevada, Museum of Biology\t\t",
"UNEX\ts\tUniversidad de Extremadura, Departamento de Botanica\t\t",
"UNEX:FECRGA\tc\tUniversidad de Extremadura, Departamento de Botanica, Fungal Endophytes Collection of the  Research Group of Agronomy",
"UNH\ts\tUniversity of New Hampshire\t\t",
"UNI\ts\tUniversity of Northern Iowa\t\t",
"UNIMAS<MYS>\ts\tUniversiti Malaysia Sarawak\t\t",
"UNIN\ts\tUniversity of the North, Botany Department\t\t",
"UNIP\ts\tUniversidade Paulista, Laboratorio de Botanica\t\t",
"UNIQEM\tc\tInstitute of Microbiology, Russian Academy of Sciences\t\t",
"UNITEC\th\tUnitec Institute of Technology\t\t",
"UNL<MEX>\ts\tUniversidad Autonoma de Nuevo Leon\t\t",
"UNL<PRT>\ts\tCentro de Estratigrafia e Paleobiologia da Universidade Nova de Lisboa\t\t",
"UNL<USA-NE>\ts\tUniversity of Nebraska State Museum\t\t",
"UNLO\ts\tUniversidad Nacional Experimental de los Llanos Occidental\t\t",
"UNLP\ts\tUniversidad Nacional de La Plata\t\t",
"UNLV\ts\tUniversity of Nevada, Las Vegas, Department of Biological Sciences\t\t",
"UNM\ts\tUniversity of New Mexico, Department of Biology\t\t",
"UNMC\ts\tUniversity of New Mexico\t\t",
"UNMDP\ts\tUniversidad Nacional de Mar del Plata, Mar del Plata, Argentina\t\t",
"UNN\ts\tUniversity of Nigeria, Botany Department\t\t",
"UNNEC\ts\tUniversidad Nacional del Nordeste, Facultad de Ciencias Exactas y Naturales y Agrimensura\t\t",
"UNNF\ts\tUniversite de Nancy\t\t",
"UNO\ts\tUniversity of Nebraska at Omaha\t\t",
"UNOAL\ts\tUniversity of Northern Alabama\t\t",
"UNOVC\ts\tUniversity of New Orleans\t\t",
"UNPSJB-Pv\ts\tUniversidad Nacional de la Patagonia\t\t",
"UNR<ARG>\ts\tUniversidad Nacional de Rosario, Botanica y Ecologia Vegetal\t\t",
"UNR<USA-NV>\ts\tUniversity of Nevada, Museum of Biology\t\t",
"UNS\ts\tUniversity of Science, Ho Chi Minh City, Vietnam\t\t",
"UNSA\ts\tUniversity of Natal\t\t",
"UNSL\ts\tUniversidad Nacional de San Luis\t\t",
"UNSM\ts\tUniversity of Nebraska State Museum\t\t",
"UNSW\tc\tMicrobiology Culture Collection, University of New South Wales\t\t",
"UNSW<AUS>\ts\tJohn T. Waterhouse Herbarium\t\t",
"UNT\ts\tUniversidad nacional de Tucumn\t\t",
"UNWH\ts\tUniversity of North-West, Biological Sciences Department\t\t",
"UO\ts\tUniversity of Oklahoma\t\t",
"UO<CZE>\ts\tUniversity of Ostrava\t\t",
"UOA/HCPF<GRC>\tc\tUOA/HCPF University of Athens/Hellenic Collection of Pathogenic Fungi\t\t",
"UOG\ts\tUniversity of Guelph\t\t",
"UOG:BIO\tb\tUniversity of Guelph, Biodiversity Institute of Ontario",
"UOG:DEBU\ts\tUniversity of Guelph, Ontario Insect Collection",
"UOIC\ts\tUniversity of Oregon\t\t",
"UOJ\ts\tUniversidad del Oriente, Departamento de Agronomia\t\t",
"UOM\ts\tUniversity of Missouri\t\t",
"UOMNH\ts\tUniversity of Oregon, Museum of Natural History\t\t",
"UOMZ\ts\tUniversity of Oklahoma, Stovall Museum of Zoology\t\t",
"UOP\ts\tUniversity of Opole\t\t",
"UOPJ\ts\tOsaka Prefecture University\t\t",
"UOS\ts\tUniversity of the South, Biology Department\t\t",
"UP\ts\tUniversity of Papua and New Guinea\t\t",
"UPA\ts\tUniversity of Patras, Department of Plant Biology\t\t",
"UPCB\ts\tUniversidade Federal do Parana, Departamento de Botanica\t\t",
"UPCC\tc\tNatural Sciences Research Institute Culture Collection\t\t",
"UPCT\th\tUniversidad Politecnica De Cartagena\t\t",
"UPEI\ts\tUniversity of Prince Edward Island, Biology Department\t\t",
"UPF\ts\tUniversite de Polynesie Francaise Herbarium\t\t",
"UPIE\tb\tUnidad de Patologia Infecciosa y Epidemiologia\t\t",
"UPLB\ts\tMuseum of Natural History, University of the Philippines\t\t",
"UPM<FRA>\ts\tDepartement des Siences de la Terre\t\t",
"UPM<MYS>\ts\tUniversiti Pertanian Malaysia, Biology Department\t\t",
"UPM<RUS>\ts\tUdory Paleontological Museum\t\t",
"UPMR\tc\tRhizobium Collection\t\t",
"UPMSI\ts\tMarine Science Institute\t\t",
"UPNA\ts\tUniversidad Publica de Navarra, Departamento de Ciencias del Medio Natural\t\t",
"UPNG\ts\tUniversity of Papua New Guinea, Division of Biological Sciences\t\t",
"UPOL\ts\tUniversity Palacky Olomouc\t\t",
"UPOS\ts\tUniversidad Pablo de Olavide, Ciencias Ambientales (Botanica)\t\t",
"UPP\ts\tUppingham School Museum\t\t",
"UPPC\ts\tUniversity of the Philippines\t\t",
"UPR\ts\tPuerto Rico Botanic Garden, University of Puerto Rico\t\t",
"UPRG\ts\tUniversidad Nacional \"Pedro Ruiz Gallo\"\t\t",
"UPRM\tc\tUniversity of Puerto Rico at Mayagueez, Rhizobium Culture Collection\t\t",
"UPRP\ts\tUniversity of Puerto Rico at Rio Piedras\t\t",
"UPRRP\ts\tUniversity of Puerto Rico, Biology Department\t\t",
"UPS\ts\tUppsala University, Museum of Evolution, Botany Section (Fytoteket)\t\t",
"UPSA\ts\tUniversity of Pretoria\t\t",
"UPSC\tc\tFungal Culture Collection at the Botanical Museum\t\t",
"UPSU\ts\tUlyanovsk State Pedagogical University, Department of Botany\t\t",
"UPSV\ts\tUppsala University, Department of Plant Ecology\t\t",
"UPTC\ts\tUniversidad Pedogogica y Tecnologica de Colombia, Escuela de Ciencias Biologicas\t\t",
"UPVB\ts\tDepartamento de Geologia, Universidad del Pais Vasco\t\t",
"UPVLP\ts\tLaboratorio de Paleontolgia of the Universdad del Pais Vasco/Euskal Herriko Unibersitatea\t\t",
"UQAM\ts\tUniversite du Quebec a Montreal, Departement des Sciences biologiques\t\t",
"UQAR\ts\tUniversite du Quebec a Rimouski, Departement de biologie\t\t",
"UQIC\ts\tUniversity of Queensland Insect Collection\t\t",
"UQTR\ts\tUniversite du Quebec a Trois-Rivieres, Departement de chimie-biologie\t\t",
"URB\ts\tRyukyu University Department of Zoology\t\t",
"URIC\ts\tUniversity of Rhode Island\t\t",
"URIMC\ts\tUniversity of Rhode Island, Mammal Collection\t\t",
"URM<BRA>\tc\tUniversidade Federal de Pernambuco\t\t",
"URM<JPN>\ts\tUniversity of the Ryukyus\t\t",
"URMU\ts\tMuseo Nacional de Historia Natural, Montevideo\t\t",
"URO\ts\tUniversity of the Ryukyus\t\t",
"URP\ts\tMuseo de Historia Natural, Universidad Ricardo Palma\t\t",
"URT\ts\tUniversita degli Studi di Roma Tre, Dipartimento di Biologia\t\t",
"URV\ts\tUniversity of Richmond, Biology Department\t\t",
"US\ts\tSmithsonian Institution, Department of Botany\tUSNM:US",
"US<ZAF>\ts\tUniversity of Stellenbosch\t\t",
"USA\ts\tUniversity of South Alabama\t\t",
"USAC<AUS>\ts\tUniversity of Western Australia\t\t",
"USAC<GTM>\ts\tUniversidad de San Carlos de Guatemala\t\t",
"USAM\ts\tUniversity of South Alabama, Department of Biological Sciences\t\t",
"USANHC\ts\tUniversity of South Alabama, Vertebrate Natural History Collection\t\t",
"USAS\ts\tUniversity of Regina, Biology Department\t\t",
"USB\tc\tBacterial collection of Universita degli studi della basilicata, Dipartimento di Biologia\t\t",
"USBCF\ts\tU. S. Bureau of Commercial Fisheries\t\t",
"USBS\ts\tSchool of Biological Sciences, University of Science\t\t",
"USC\ts\tUniversity of Southern California, Biological Sciences Department\t\t",
"USCC\ts\tUniversity of Southern Colorado\t\t",
"USCG\ts\tUniversidad de San Carlos de Guatemala\t\t",
"USCH\ts\tUniversity of South Carolina, Department of Biological Sciences\t\t",
"USCP\ts\tUniversity of San Carlos\t\t",
"USCS\ts\tUniversity of South Carolina, Science and Mathematics Department\t\t",
"USCWH\ts\tUnited Services College\t\t",
"USD<DOM>\ts\tUniversidad Autonoma de Santo Domingo\t\t",
"USD<USA-SD>\ts\tUniversity of South Dakota\t\t",
"USDA\tsb\tUnited States Department of Agriculture\t\t",
"USDA:CFRA\tb\tUnited States Department of Agriculture, Corvallis Fragaria Catalog",
"USDA:GRIN\tb\tUnited States Department of Agriculture, Germplasm Resources Information Network",
"USDA:NCGR\tb\tUnited States Department of Agriculture, National Clonal Germplasm Repository",
"USDA:NSGC\tsb\tUnited States Department of Agriculture, National Small Grains Collection",
"USDA:PGRU\tsb\tUnited States Department of Agriculture, Plant Genetic Resources Unit",
"USDA:USNPC\ts\tUnited States Department of Agriculture, US National Parasite Collection",
"USDAK\ts\tW. H. Over State Museum\t\t",
"USF\ts\tUniversity of South Florida, Biology Department\t\t",
"USF:CBD\tc\tUniversity of South Florida, Biology Department, Center for Biological Defense",
"USFC\ts\tU. S. Fish Commission\t\t",
"USFS\ts\tRocky Mountain Forest and Range Experiment Station\t\t",
"USGS\ts\tU.S. Geological Survey\t\t",
"USGS:ASC\ts\tU.S. Geological Survey, Alaska Science Center",
"USH\ts\tUshaw College\t\t",
"USI\ts\tUniversity of Southern Indiana\t\t",
"USJ\ts\tUniversidad de Costa Rica\t\t",
"USLH\ts\tUniversity of Louisiana Lafayette, Department of Renewable Resources\t\t",
"USM<MYS>\ts\tUniversiti Sains Malaysia\t\t",
"USM<MYS>:VCRU\ts\tUniversiti Sains Malaysia, Vector Control Research Unit",
"USM<PER>\ts\tUniversidad Nacional Mayor de San Marcos, Museo de Historia Natural, Herbario\t\t",
"USMMC\ts\tUniversiti Sains Malaysia Mollusc Collection\t\t",
"USMP\th\tUniversiti Sains Malaysia\t\t",
"USMS\ts\tUniversity of Southern Mississippi, Department of Biological Sciences\t\t",
"USNC\ts\tSmithsonian Institution, Paleobiology Department\t\t",
"USNM\tsb\tNational Museum of Natural History, Smithsonian Institution\tNMNH",
"USNM:Birds\ts\tNational Museum of Natural History, Smithsonian Institution, Division of Birds",
"USNM:ENT\ts\tNational Museum of Natural History, Smithsonian Institution, Entomology Collection",
"USNM:FISH\ts\tNational Museum of Natural History, Smithsonian Institution, National Fish Collection",
"USNM:Herp\ts\tNational Museum of Natural History, Smithsonian Institution, Division of Amphibians and Reptiles",
"USNM:IZ\ts\tNational Museum of Natural History, Smithsonian Institution, Department of Invertebrate Zoology",
"USNM:LAB\tb\tNational Museum of Natural History, Smithsonian Institution, Laboratories of Analytical Biology",
"USNM:MAMM\ts\tNational Museum of Natural History, Smithsonian Institution, Division of Mammals",
"USNTC\ts\tU.S. National Tick Collection\t\t",
"USON\ts\tUniversidad de Sonora, Departamento de Investigaciones Cientificas y Technologicas\t\t",
"USP<BRA>\ts\tUniversidade de Sao Paulo\t\t",
"USP<ESP>\ts\tUniversidad San Pablo-CEU (Departamento de Biologia Vegetal (seccion Botanica)\t\t",
"USP<FJI>\ts\tUniversity of the South Pacific\t\t",
"USPIY\ts\tK. D. Ushinsky Yaroslavl State Pedagogical University, Department of Botany\t\t",
"USRC\ts\tUniversity of Regina\t\t",
"USRCB\tc\tUkrainian Scientific-Research Cell Bank.\t\t",
"USSC\ts\tU.S. Soil Conservation Service\t\t",
"USTF\ts\tTechnologische Faculteit\t\t",
"USTK\ts\tUniversity of Science and Technology, Museum of Natural History\t\t",
"USU\ts\tUnited States Department of Agriculture\t\t",
"USUUB\th\tUtah State University Uintah Basin\t\t",
"USZ\ts\tUniversidad Autonoma Gabriel Rene Moreno\t\t",
"UT<USA-TN>\ts\tUniversity of Tennessee\t\t",
"UT<USA-UT>\ts\tUniversity of Utah Herbarium\t\t",
"UTA\ts\tUniversity of Texas at Arlington\t\t",
"UTA:A\ts\tUniversity of Texas at Arlington, Amphibian Collection",
"UTA:R\ts\tUniversity of Texas at Arlington, Reptile collection",
"UTAI\ts\tTel Aviv University\t\t",
"UTC\ts\tUtah State University, Biology Department\t\t",
"UTCI\ts\tUniversity of Tennessee at Chattanooga Insect Collection\t\t",
"UTD\ts\tUniversity of Texas, Plant Resources Center\t\t",
"UTE\ts\tUniversity of Tartu\t\t",
"UTEP\ts\tUniversity of Texas at El Paso Biodiversity Collections\t\t",
"UTEP:Bird\ts\tUniversity of Texas at El Paso Biodiversity Collections, Ornithology Collection",
"UTEP:Ento\ts\tUniversity of Texas at El Paso Biodiversity Collections, Entomology Collection",
"UTEP:ES\ts\tUniversity of Texas at El Paso Biodiversity Collections, Earth Science  fossils Collections",
"UTEP:Fish\ts\tUniversity of Texas at El Paso Biodiversity Collections, Ichthyology collection",
"UTEP:Herb\ts\tUniversity of Texas at El Paso Biodiversity Collections, Herbarium",
"UTEP:Herp\ts\tUniversity of Texas at El Paso Biodiversity Collections, Herpetology Collection",
"UTEP:INV\ts\tUniversity of Texas at El Paso Biodiversity Collections, Invertebrates - Molluscs Collections",
"UTEP:Zoo\ts\tUniversity of Texas at El Paso Biodiversity Collections, Zooplankton collections",
"UTEX\tc\tThe Culture Collection of Algae at the University of Texas Austin\t\t",
"UTG\ts\tUniversity of Tuebingen\t\t",
"UTGD\ts\tGeology Department, The University of Tasmania\t\t",
"UTHSC\tc\tUniversity of Texas Health Science Center\t\t",
"UTIM\ts\tUniversity of Tennessee Insect Museum\t\t",
"UTKI\ts\tUniversity of Teheran\t\t",
"UTLH\ts\tUniversity of Technology, Human Sciences Department\t\t",
"UTLPA\ts\tUniversity of Texas at Austin, Laboratory of Physical Anthropology\t\t",
"UTMC\ts\tUniversidad del Magdalena\t\t",
"UTMC<IRN>\tc\tUniversity of Tehran Microorganisms Collection\t\t",
"UTMZ\ts\tUniversity of Tennessee, Museum of Zoology\t\t",
"UTV\ts\tUniversita degli Studi della Tuscia, Dipartimento di Agrobiologia e Agrochimica\t\t",
"UTZM\ts\tUniversity of Tsukubo\t\t",
"UU<SWE>\ts\tUniversity of Uppsala\t\t",
"UU<UKR>\ts\tUzhgorod State University, Botany Department\t\t",
"UU<USA-UT>\ts\tUniversity of Utah, Department of Biology\t\t",
"UUC\tc\tJanet A. Robertson Collection of Ureaplasma urealyticum Cultures\t\t",
"UUDE\th\tBuryat State University\t\t",
"UUH\ts\tInstitute of General and Experimental Biology, Department of Floristics and Geobotany\t\t",
"UUVP\ts\tUniversity of Utah, Vertebrate Paleontology\t\t",
"UUZM\ts\tUppsala University, Zoological Museum\t\t",
"UV<CHL>\ts\tUniversity of Valparaiso\t\t",
"UV<COL>\ts\tDepartamento de Biologia de la Universidad del Valle\t\t",
"UVA\ts\tGeological Institute of the University of Amsterdam\t\t",
"UVAL\ts\tUniversidad del Valle de Guatemala\t\t",
"UVC\ts\tColeccion de Anfibios y Reptiles, Universidad del Valle, Cali\t\t",
"UVCC\ts\tUniversity of Vermont\t\t",
"UVCE\ts\tColecao Entomologica, Laboratorio de Entomologia Sistematica\t\t",
"UVCO\ts\tUniversidad de Valle\t\t",
"UVG\ts\tUniversidad del Valle\t\t",
"UVGC\ts\tCollecion de Artropodos\t\t",
"UVIC\ts\tUniversity of Victoria, Biology Department\t\t",
"UVM\ts\tZadock Thompson Natural History Collection, University of Vermont\t\t",
"UVP\ts\tUtah State Vertebrate Paleontology Collection\t\t",
"UVSC\ts\tUtah Valley State College, Biology Department\t\t",
"UVST\ts\tSouthwest Texas Junior College, Biology Department\t\t",
"UVV\ts\tUniversita di Venezia, Dipartimento de Scienze Ambientali\t\t",
"UW\ts\tUniversity of Washington Fish Collection\t\t",
"UWA\ts\tUniversity of Western Australia, Botany Department\t\t",
"UWAL\th\tUniversity of West Alabama\t\t",
"UWBM\ts\tUniversity of Washington, Burke Museum\t\t",
"UWBM:Mamm\ts\tUniversity of Washington, Burke Museum, Burke Museum's mammal collection",
"UWBM:ORN\ts\tUniversity of Washington, Burke Museum, Ornithology Collection",
"UWC\ts\tUniversity of the Western Cape, Botany Department\t\t",
"UWCC<USA-WA>\tc\tUniversity of Washington Culture Collection\t\t",
"UWCP\ts\tUniversity of Wroclaw\t\t",
"UWEC\ts\tUniversity of Wisconsin, Department of Biology\t\t",
"UWFP\ts\tUniversity of West Florida, Department of Biology\t\t",
"UWGB\ts\tUniversity of Wisconsin-Green Bay, MAC 212\t\t",
"UWI\ts\tUniversity of the West Indies (Trinidad and Tobago)\t\t",
"UWIC\ts\tUniversity of the West Indies, Trinidad and Tobago\t\t",
"UWIJ\ts\tUniversity of the West Indies, Jamaica\t\t",
"UWIZM\ts\tThe University of the West Indies Zoology Museum\t\t",
"UWJ\ts\tUniversity of Wisconsin, Biology Department\t\t",
"UWL\ts\tUniversity of Wisconsin, Biology Department\t\t",
"UWM\ts\tUniversity of Wisconsin, Biological Sciences Department\t\t",
"UWMA\ts\tUniversity of Wisconsin, Milwaukee, Department of Anthropology\t\t",
"UWMIL\ts\tUniversity of Wisconsin, Milwaukee, Department of Biological Sciences\t\t",
"UWO\tsc\tUniversity of Western Ontario\t\t",
"UWOC\ts\tUniversity of Western Ontario\t\t",
"UWP\ts\tUniversity of Wrocklaw\t\t",
"UWPG\ts\tUniversity of Winnipeg, Biology Department\t\t",
"UWSP\ts\tUniversity of Wisconsin-Stevens Point,\t\t",
"UWW\ts\tUniversity of Wisconsin - Whitewater, Biological Sciences Department\t\t",
"UWYMV\ts\tUniversity of Wyoming Museum of Vertebrates\t\t",
"UWYMV:Bird\ts\tUniversity of Wyoming Museum of Vertebrates, Bird Collection",
"UWYMV:Fish\ts\tUniversity of Wyoming Museum of Vertebrates, Fish Collection",
"UWYMV:Herp\ts\tUniversity of Wyoming Museum of Vertebrates, Herpetology Collection",
"UWYMV:Mamm\ts\tUniversity of Wyoming Museum of Vertebrates, Mammal Collection",
"UWZM\ts\tUniversity of Wisconsin, Zoological Museum\t\t",
"UYIC\ts\tInstituto de Biologia\t\t",
"UZ<ESP>\ts\tHerbario de la Universidad de Zaragoza\t\t",
"UZA\ts\tUnidad de Zoologia Aplicada, Departamento de Ecologia\t\t",
"UZIU\ts\tUppsala University\t\t",
"UZL\ts\tUniversity of Zambia, Biological Sciences Department\t\t",
"UZMC\ts\tUniversidad del Zulia\t\t",
"UZMH\ts\tUniversity Museum (Zoology)\t\t",
"UZMO\ts\tZoologisk Museum\t\t",
"V\ts\tRoyal British Columbia Museum - Herbarium\t\t",
"VA\ts\tUniversity of Virginia\t\t",
"VAB\ts\tUniversitat de Valencia, Departamento de Biologia Vegetal\t\t",
"VAIC\ts\tVictorian Agricultural Insect Collection\t\t",
"VAL\tsb\tUniversitat de Valencia (Jardin Botanico de Valencia)\t\t",
"VALA\ts\tUniversidad Politecnica, Departamento de Botanica\t\t",
"VALD\ts\tUniversidad Austral de Chile, Instituto de Botanica\t\t",
"VALLE\ts\tUniversidad Nacional de Colombia, Departamento de Ciencias Basicas\t\t",
"VALPL\ts\tUniversidad de Playa Ancha, Departamento de Biologia y Quimica\t\t",
"VAN\ts\tSociete Polymathique du Morbihan\t\t",
"VANF\ts\tYuezuencue Yil University, Biology Section\t\t",
"VAS\ts\tVassar College, Biology Department\t\t",
"VBCM\ts\tUniversidad Complutense de Madrid\t\t",
"VBGI\ts\tBotanical Garden-Institute\t\t",
"VBI\ts\tInstitute of Ecology and Botany of the Hungarian Academy of Sciences, Botanical Department\t\t",
"VCRC\tc\tVolcani Center Rhizobium Collection (VCRC)\t\t",
"VCU\ts\tVirginia Commonwealth University, Biology Department\t\t",
"VDAC\ts\tVirginia Department of Agriculture and Consumer Services\t\t",
"VDAM\ts\tInstitute of Plant Science\t\t",
"VDB\ts\tVanderbilt University, Department of Biological Sciences\t\t",
"VECTOR\tsc\tState Research Center of Virology and Biotechnology\t\t",
"VEN\ts\tFundacion Instituto Botanico de Venezuela Dr. Tobias Lasser\t\t",
"VENDA\ts\tThohoyandou Botanical Gardens, Department of Agriculture, Land & Environment\t\t",
"VER\ts\tHerbario, Museo Civico di Storia Naturale, Verona\t\t",
"VETMED\ts\tUniversity of Veterinary Medicine\t\t",
"VF\ts\tUniversidad de Valencia, Departamento de Biologia Vegetal, Botanica\t\t",
"VFM\th\tForest Inventory and Planning Institute\t\t",
"VFWD\ts\tVermont Fish and Wildlife Department\t\t",
"VFWO\th\tU.S. Fish and Wildlife Service, Ventura Fish and Wildlife Office\t\t",
"VGZ\ts\tVoronezh State Biosphere Reserve, Research Department\t\t",
"VH\th\tVivekanand Arts Sardar Dalipsingh Commerce and Science College\t\t",
"VHS<AUS>\tc\tVegetation Health Service  ( Phytophthora cultures )\t\t",
"VI<NOR>\tc\tMykotektet, National Veterinary Institute\t\t",
"VI<SWE>\ts\tGotlands Fornsal\t\t",
"VIA\ts\tFONAIAP-CENIAP\t\t",
"VIAM\tc\tInstitute of Applied Microbiology, University of Agricultural Sciences\t\t",
"VIAY\ts\tVeterinarian Institute of Armenia, Botany Department\t\t",
"VIC\ts\tUniversidade Federal de Vicosa, Departamento de Biologia Vegetal\t\t",
"VICA\ts\tAgriculture Department\t\t",
"VICF\ts\tForestry Department\t\t",
"VICH\ts\tPlant Protection Department\t\t",
"VIES\th\tFederal University of Espirito Santo\t\t",
"VIL\ts\tUniversite de Paris-Sud\t\t",
"VIMS\ts\tVirginia Institute of Marine Science\t\t",
"VIST\ts\tUniversity of the Virgin Islands, Natural Resources Program\t\t",
"VIT\ts\tMuseo de Ciencias Naturales de Alava, Departamento de Botanica\t\t",
"VIZR\tc\tCollection for plant protection, All-Russian Institute of Plant Protection\t\t",
"VKM\tc\tAll-Russian Collection of Microorganisms\t\t",
"VKPM\tc\tRussian National Collection of Industrial Microorganisms\t\t",
"VLA\ts\tFar Eastern Branch, Russian Academy of Sciences, Botany Department\t\t",
"VM\ts\tOkresni vlastivedne muzeum\t\t",
"VMI\th\tVirginia Military Institute\t\t",
"VMIL\ts\tVirginia Military Institute, Biology Department\t\t",
"VMKSC\ts\tKearney State University, Vertebrate Museum\t\t",
"VMM\ts\tVanderbilt Marine Museum\t\t",
"VMNH\ts\tVirginia Museum of Natural History\t\t",
"VMSL\ts\tI.N.T.A., E.E.A. San Luis, Pastizales Naturales\t\t",
"VNC\ts\tLos Angeles Valley College, Life Sciences Department\t\t",
"VNF\th\tVietnam Forestry Herbarium\t\t",
"VNGA\ts\tVorarlberger Naturschau\t\t",
"VNIRO\ts\tInstitute of Oceanography\t\t",
"VNM\th\tInstitute of Tropical Biology\t\t",
"VNMN\ts\tVietnam National Museum of Nature\t\t",
"VOA\ts\tOstrobothnian Museum\t\t",
"VOR\ts\tVoronezh State University, Biology and Plant Ecology Department\t\t",
"VORB\th\tBotanical Garden Dr. B.M. Kozo-Polyansky, Voronezh State University\t\t",
"VORG\ts\tVoronezh State University, Faculty of Geography and Geoecology\t\t",
"VPB\tc\tVeterinary Pathology and Bacteriology Collection\t\t",
"VPCI\tc\tFungal Culture Collection\t\t",
"VPI\tsc\tVirginia Polytechnic Institute and State University\t\t",
"VPIC\ts\tVirginia Polytechnic Institute and State University\t\t",
"VPIMM\ts\tVirginia Polytechnic University, Mammal Museum\t\t",
"VPM\ts\tVolgograd Provincial Museum\t\t",
"VPRI\tc\tVictoria Department of Primary Industries, Plant Disease Herbarium\t\t",
"VRLI\tc\tDepartment of Virology\t\t",
"VSC\ts\tValdosta State University, Biology Department\t\t",
"VSC-L\ts\tLyndon State College, Mammal Collection\t\t",
"VSCA\ts\tVisayas State College of Agriculture\t\t",
"VSM<NOR>\ts\tDet Kgl. Norske Videnskabers Selskab Museet\t\t",
"VSM<SVK>\ts\tEastern Slovakian (Vychodoslovenske) Museum, Natural History Department\t\t",
"VSRI\ts\tN.I. Vavilov All-Russian Scientific Research Instiutte of Plant Industry\t\t",
"VSUH\ts\tVirginia State University, Life Sciences Department\t\t",
"VT\ts\tPringle Herbarium, University of Vermont\t\t",
"VTA\th\tJardin Botanique de la Villa Thuret\t\t",
"VTB\tc\tBanco de Celulas Humanas e Animais Laboratorio de Patologia Celular e Molecular\t\t",
"VTCC\tc\tVietnam Type Culture Collection, Center of Biotechnology\t\t",
"VTMH\ts\tVirginia Tech Massey Herbarium\t\t",
"VTT\tc\tVTT Biotechnology, Culture Collection\t\t",
"VU\ts\tVoronezh State University\t\t",
"VU<NLD>\ts\tVrije Universiteit Amsterdam\t\t",
"VUT\tc\tSchool of Veterinary Medicine, Faculty of Agriculture\t\t",
"VUW\ts\tVictoria University\t\t",
"VUWE\ts\tVictoria University\t\t",
"VYH\tc\tFinnish Environment Institute (SYKE)\t\t",
"VYM\ts\tMuzeum Vyakovska\t\t",
"W\ts\tNaturhistorisches Museum Wien, Department of Botany\t\t",
"WA\ts\tHerbarium, Faculty of Biology, University of Warsaw\t\t",
"WAB\ts\tWabash College, Biological Sciences Department\t\t",
"WABG\ts\tUniversity of Warsaw Botanic Garden\t\t",
"WAC\tc\tDepartment of Agriculture Western Australia Plant Pathogen Collection\t\t",
"WACA<USA-AZ>\ts\tWalnut Canyon National Monument\t\t",
"WACA<USA-OR>\ts\tWork Amber Collection\t\t",
"WACC\tc\tWestern Australian Culture Collection\t\t",
"WADA\ts\tWestern Australia Department of Agriculture\t\t",
"WAG\ts\tWageningen University\t\t",
"WAHO\ts\tInstitute of Horticultural Plant Breeding, Department of Biosystematics\t\t",
"WAI\th\tWaimea Valley\t\t",
"WAIK\ts\tUniversity of Waikato, Biological Sciences Department\t\t",
"WAITE\tc\tInsect Pathology Pathogen Collection\t\t",
"WAL\tc\tWadsworth Anaerobe Laboratory, Wadsworth Hospital Center\t\t",
"WAM\ts\tWestern Australian Museum\t\t",
"WAMP\ts\tWestern Australian Museum\t\t",
"WAN\ts\tForest Research Station\t\t",
"WANF\ts\tWasatch-Cache National Forest\t\t",
"WAPA\th\tWar in the Pacific National Historical Park\t\t",
"WAR\ts\tWarwickshire Museum, Natural History Department\t\t",
"WARC\tc\tNew Zealand Reference Culture Collection\t\t",
"WARK\ts\tWestern Illinois University, Biology Department\t\t",
"WARM\ts\tCentral Missouri State University, Biology Department\t\t",
"WARMS\ts\tWarwickshire Museum, Natural History Department\t\t",
"WARS\ts\tWildlife Advisory and Research Service\t\t",
"WASH\ts\tWashburn University, Biology Department\t\t",
"WAT\ts\tUniversity of Waterloo, Biology Department\t\t",
"WAU\ts\tWau Ecology Institute\t\t",
"WAUF\ts\tWarsaw Agricultural University, Department of Plant Pathology\t\t",
"WAVI\ts\tColby College, Biology Department\t\t",
"WB<DEU>\ts\tUniversitaet Wuerzburg\t\t",
"WB<USA-WI>\tc\tDepartment of Bacteriology, University of Wisconsin\t\t",
"WBCH\ts\tWisbech and Fenland Museum\t\t",
"WBG\ts\tWaimea Botanical Garden\t\t",
"WBM\ts\tUniversitaet Wuerzburg\t\t",
"WBR\ts\tLaboratoire de Paleontologie, Unversite de Montpellier\t\t",
"WBS\ts\tLandbouwuniversiteit\t\t",
"WCE\ts\tUniversity of London, Westfield College, Biology Department\t\t",
"WCH\ts\tGreenwich Borough Museum\t\t",
"WCL\ts\tWillesden Borough Council\t\t",
"WCP\ts\tWalla Walla College, Biological Sciences Department\t\t",
"WCR\ts\tWinchester City Museum\t\t",
"WCRP\ts\tWinchester Public Library\t\t",
"WCSBG\th\tWest China Subalpine Botanical Garden\t\t",
"WCSU\ts\tWestern Connecticut State University, Department of Biological and Environmental Sciences\t\t",
"WCU\ts\tWest China University of Medical Sciences\t\t",
"WCUH\ts\tWestern Carolina University, Department of Biology\t\t",
"WCUM\tc\tWorking Collection\t\t",
"WCUUM\ts\tWest China Union University\t\t",
"WCW\ts\tWhitman College, Department of Biology\t\t",
"WDds\tc\tRaul Lopez Sanchez\t\t",
"WDNE\ts\tBureau of Land Management, Winnemucca District\t\t",
"WECO\ts\tWesleyan University, Biology Department\t\t",
"WEIC\ts\tWau Ecology Institute\t\t",
"WELC\ts\tWellesley College, Biological Sciences Department\t\t",
"WELT\ts\tMuseum of New Zealand Te Papa Tongarewa\t\t",
"WELTU\ts\tVictoria University of Wellington\t\t",
"WERN\ts\tWerneth Park Study Centre and Natural History Museum\t\t",
"WET\ts\tWartburg College, Biology Department\t\t",
"WFBM\ts\tW.F. Barr Entomological Collection\t\t",
"WFBVA\ts\tFederal Forest Research Centre Vienna, Department of Vegetation Science\t\t",
"WFIS\ts\tWagner Free Institute of Science\t\t",
"WFU\ts\tWake Forest University, Biology Department\t\t",
"WFUVC\ts\tWake Forest University, Vertebrate Collection\t\t",
"WGC\ts\tState University of West Georgia, Biology Department\t\t",
"WGCH\th\tWilton Garden Club\t\t",
"WGD\ts\tWashington Game Department\t\t",
"WGMM\ts\tWoodspring Museum\t\t",
"WGRC\tb\tWheat Genetics Resource Center\t\t",
"WGRS\ts\tWestern Ghat Regional Station of the Zoological Survey of India at Calicut\t\t",
"WH\ts\tWuhan University\t\t",
"WHB\ts\tUniversitaet fuer Bodenkultur\t\t",
"WHIT\ts\tWhittier College, Biology Department\t\t",
"WHM\ts\tWest Highland Museum\t\t",
"WHN\ts\tWhitehaven Museum\t\t",
"WHOI\ts\tWoods Hole Oceanographic Institution\t\t",
"WHT\ts\tWildlife Heritage Trust\t\t",
"WHY\ts\tWhitby Museum\t\t",
"WHYNC\ts\tWhytby Naturalists' Club\t\t",
"WI\ts\tVilnius University, Botany and Genetics Department\t\t",
"WIAP\ts\tWistar Institute of Anatomy\t\t",
"WIB\ts\tMinistry of Environment and Parks, Resource Quality Section\t\t",
"WIBF\ts\tWest Indian Beetle Fauna Project Collection\t\t",
"WIBG\ts\tWindward Islands Banana Grower's Association\t\t",
"WICA\ts\tWind Cave National Park\t\t",
"WICH\th\tWichita State University\t\t",
"WIES\ts\tMuseum Wiesbaden\t\t",
"WII\ts\tWildlife Institute of India, Department of Habitat Ecology\t\t",
"WILLI\ts\tThe College of William and Mary, Department of Biology\t\t",
"WILLU\ts\tWillamette University\t\t",
"WIN\ts\tUniversity of Manitoba, Botany Department\t\t",
"WINC\ts\tWaite Insect & Nematode Collection\t\t",
"WIND\ts\tNational Botanical Research Institute\t\t",
"WINDM\ts\tDelta Marsh Field Station (University of Manitoba)\t\t",
"WINF\ts\tForestry and Rural Developmen Department\t\t",
"WINFM\ts\tForestry and Rural Developmen Department\t\t",
"WINO\ts\tSaint Mary's College, Biology Department\t\t",
"WINU\th\tWinthrop University\t\t",
"WIR\tsb\tN. I. Vavilov Institute of Plant Industry, Department of Introduction and Systematics\t\t",
"WIS\ts\tUniversity of Wisconsin, Botany Department\t\t",
"WIU\ts\tWestern Illinois University, Museum of Natural History\t\t",
"WIUC\ts\tWestern Illinois University\t\t",
"WJC\ts\tWilliam Jewell College, Biology Department\t\t",
"WKD\ts\tWakefield Museum\t\t",
"WKDS\ts\tWakefield Grammar School\t\t",
"WKSU\ts\tWestern Kentucky State University\t\t",
"WKU\ts\tWestern Kentucky University, Department of Biology\t\t",
"WL\ts\tWolong Nature Reserve\t\t",
"WLH\ts\tWilberforce Library\t\t",
"WLK\ts\tBritish Columbia Ministry of Forests\t\t",
"WLMH\ts\tWest Lake Musuem\t\t",
"WLU\ts\tWilfrid Laurier University, Biology Department\t\t",
"WM\ts\tGezira Research Station\t\t",
"WMGC\ts\tGordon College, Biology Department\t\t",
"WMM\ts\tWitte Memorial Museum\t\t",
"WMNH\ts\tWakayama Prefectural Museum of Natural History\t\t",
"WMS\ts\tWakes Museum\t\t",
"WMU\ts\tWestern Michigan University, Biological Sciences Department\t\t",
"WMW\ts\tVestry House Museum\t\t",
"WNC\ts\tUniversity of North Carolina Wilmington, Department of Biology and Marine Biology\t\t",
"WNHM\ts\tOklahoma Baptist University, Webster Natural History Museum\t\t",
"WNLM\ts\tNiederoesterreichisches Landesmuseum\t\t",
"WNMU\ts\tWestern New Mexico University Museum\t\t",
"WNMU:Bird\ts\tWestern New Mexico University Museum, bird collection",
"WNMU:Fish\ts\tWestern New Mexico University Museum, fish collection",
"WNMU:Mamm\ts\tWestern New Mexico University Museum, mammal collection",
"WNRE\ts\tWhiteshell Nuclear Research Establishment\t\t",
"WNS\ts\tWiesbaden Naturwissenschaftliche Sammlung der Stadt\t\t",
"WNU\ts\tNorthwest University, Biology Department\t\t",
"WOCB\ts\tUniversity of Windsor, Biological Sciences Department\t\t",
"WOCSB\tb\tWheeler Orchid Collection and Species Bank\t\t",
"WOH\ts\tSouthwestern Oklahoma State University, Biology Department\t\t",
"WOLL\ts\tUniversity of Wollongong, Department of Biological Sciences\t\t",
"WOS\ts\tCity Museum and Art Gallery\t\t",
"WOSNH\ts\tWorcestershire Natural History Society Museum\t\t",
"WPBS\tc\tWPBS Rhizobium Collection\t\t",
"WPC\tcb\tWorld Phytophthora Genetic Resource Collection\t\t",
"WPH\ts\tWaterton Lakes National Park\t\t",
"WPL\ts\tWhitechapel Museum\t\t",
"WPMM\ts\tState Museum of Pennsylvania\t\t",
"WRC<JPN>\tb\tWildlife Research Center of Kyoto University\t\t",
"WRHM\ts\tInstitute of Terrestrial Ecology\t\t",
"WRL\tc\tThe Wellcome Bacterial Collection\t\t",
"WRN\ts\tWarrington Museum and Art Gallery\t\t",
"WRNFC\ts\tWarrington Field Naturalists' Club\t\t",
"WRO\ts\tUniversity of Bristol, Long Ashton Research Station\t\t",
"WRSL\ts\tWroclaw University, Botany Department\t\t",
"WS\ts\tWashington State University\t\t",
"WSBC\ts\tWichita State University\t\t",
"WSBC<DEU>\tc\tResearch collection of Bacillus cereus group species\t\t",
"WSC\ts\tWestfield State College, Museum and Herbarium\t\t",
"WSCH\ts\tWestfield State College, Biology Department\t\t",
"WSCO\ts\tWeber State University, Botany Department\t\t",
"WSF\tc\tWisconsin Soil Fungi Collection\t\t",
"WSFA\ts\tWilmington College, Biology Department\t\t",
"WSL\tb\tSwiss Federal Institute for Forest, Snow and Landscape Research\t\t",
"WSLC\tc\tResearch collection of Listeria (Weihenstephan Microbial Strain Collection)\t\t",
"WSM\ts\tWeston-super-Mare Museum and Art Gallery\t\t",
"WSM<AUS>\tc\tWestern Australian Soil Microbiology culture collection, Murdoch. University\t\t",
"WSNM\ts\tWhite Sands National Monument\t\t",
"WSP\ts\tWashington State University, Plant Pathology Department\t\t",
"WSRP\ts\tUniversity of Podlasie, Botany Department\t\t",
"WSU<USA-UT>\ts\tWeber State University, Bird and Mammal Collection\t\t",
"WSU<USA-WA>\ts\tWashington State University\t\t",
"WSUMNH\ts\tWayne State University, Museum of Natural History\t\t",
"WSY\ts\tRoyal Horticultural Society's Gardens\t\t",
"WTR\ts\tWinchester College, Biology Department\t\t",
"WTS\ts\tWest Texas A&M University, Department of Life, Earth and Environmental Sciences\t\t",
"WTSU\ts\tWest Texas A&M University, Natural History Collection\t\t",
"WTU\ts\tUniversity of Washington\t\t",
"WTU:Fungal Collection\ts\tUniversity of Washington, F",
"WTUH\ts\tUniversity of Washington Botanic Gardens, College of Forest Resources\t\t",
"WU\ts\tUniversitaet Wien\t\t",
"WU<USA-TX>\ts\tWayland University\t\t",
"WUD\ts\tWayne State University, Biological Sciences Department\t\t",
"WUH\ts\tWuhu School of Traditional Chinese Medicine\t\t",
"WUK\ts\tNorthwestern Institute of Botany\t\t",
"WUM\ts\tUniversity of Witwatersrand\t\t",
"WUME\ts\tWillamette University\t\t",
"WUP\th\tDepartment of Pharmacognosy, Universitat Wien\t\t",
"WVA\ts\tWest Virginia University, Biology Department\t\t",
"WVBS\ts\tWest Virginia Biological Survey\t\t",
"WVDH\tc\tWest Virginia Hygienic Laboratory\t\t",
"WVIT\ts\tWest Virginia University, Biology Department\t\t",
"WVMS\ts\tMarshall University, West Virginia Mammal Survey\t\t",
"WVN\ts\tWhitehaven Scientific Association\t\t",
"WVUC\ts\tWest Virginia University\t\t",
"WVW\ts\tWest Virginia Wesleyan College, Biology Department\t\t",
"WWB\ts\tWestern Washington University, Biology Department\t\t",
"WWC\th\tWarren Wilson College\t\t",
"WWF\ts\tWelder Wildlife Foundation\t\t",
"WWM\ts\tWerner Wildlife Museum\t\t",
"WWSP\ts\tWeymouth Woods Sandhills Nature Preserve\t\t",
"WXDC\ts\tWanxian Institute of Drug Control\t\t",
"WXM\ts\tNorth East Wales Institute, Department of Natural Science\t\t",
"WYAC\ts\tUniversity of Wyoming, Range Ecology and Watershed Management Department\t\t",
"WYCO\ts\tWytheville Community College, Biology Department\t\t",
"WYE\ts\tUniversity of London, Wye College\t\t",
"XAG\ts\tXinjiang Academy of Animal Sciences\t\t",
"XAL\ts\tInstituto de Ecologia, A.C.\t\t",
"XALU\ts\tUniversidad Veracruzana\t\t",
"XBGH\ts\tXian Botanical Garden\t\t",
"XCH\ts\tSt. Xavier's College, Botany Department\t\t",
"XFCFC\ts\tXiamen Fisheries College\t\t",
"XIAS\ts\tXichang Agricultural School\t\t",
"XIN\ts\tSouthwestern Guizhou Institute of Forestry\t\t",
"XJA\ts\tXinjiang Agricultural University\t\t",
"XJBI\ts\tXinjiang Institute of Ecology and Geography\t\t",
"XJDC\ts\tXinjiang Institute for Drug Control\t\t",
"XJFA\ts\tXinjiang Academy of Forestry Sciences\t\t",
"XJNU\ts\tXinjiang Normal University, Biology Department\t\t",
"XJU\ts\tXinjiang University, Biology Department\t\t",
"XJUG\ts\tXinjiang University, Geography Department\t\t",
"XM\ts\tXinjiang Medical College, Pharmacy Department\t\t",
"XMU\ts\tXiamen University\t\t",
"XNC\ts\tDepartment of Biology, Xinxiang Normal College\t\t",
"XOLO\ts\tUniversidad Autonoma Chapingo, Departamento de Fitotecnia\t\t",
"XTNM\ts\tXinjiang Institute of Traditional Chinese and Minorities Medicine\t\t",
"XUM\ts\tHope Department of Entomology\t\t",
"XYTC\ts\tXinyang Teachers College, Biology Department\t\t",
"XZ\ts\tTibet Plateau Institute of Biology\t\t",
"XZDC\ts\tTibet Institute for Drug Control\t\t",
"XZTC\ts\tXuzhou Teachers College, Biology Department\t\t",
"Y\ts\tYale University, Samuel Jones Record Memorial Collection\t\t",
"YA\ts\tNational Herbarium of Cameroon\t\t",
"YAF\ts\tYunnan Academy of Forestry\t\t",
"YAI\ts\tArmenian Agricultural Academy, Botany Department\t\t",
"YAK\ts\tForest Survey and Design Institute\t\t",
"YALT\ts\tThe State Nikita Botanical Gardens, Flora and Vegetation\t\t",
"YAM\ts\tYamaguchi University, Plant Pathology Department\t\t",
"YAMA\th\tYamagata Prefectural Museum\t\t",
"YAR\ts\tYaroslavl State University, Department of Biology and Ecology\t\t",
"YBDC\ts\tYibin Institute for Drug Control\t\t",
"YBI\ts\tInstitut National pour l'Etude et la Recherche Agronomique, Departement de Botanique\t\t",
"YBLF\tc\tYamanouchi Pharmaceutical Co., Ltd.\t\t",
"YBU\ts\tYibin University, College of Life Science and Food Engineering\t\t",
"YCE\ts\tYunnan College of Education, Biology Department\t\t",
"YCH\ts\tYavapai College, Biology Department\t\t",
"YCM\ts\tYokosuka City Museum\t\t",
"YCP\ts\tYunnan Laboratory for Conservation of Rare, Endangered & Endemic Forest Plants, State Forestry Administration\t\t",
"YDC\ts\tYunnan Institute for Drug Control\t\t",
"Yeast Collection of Department of Microbiology, Stellenbosch University\tc\tYeast Collection of Department of Microbiology, Stellenbosch University\t\t",
"YELLO\ts\tYellowstone National Park\t\t",
"YEO\ts\tYeovil Museum\t\t",
"YF\ts\tYanbei Forestry Institute\t\t",
"YFS\ts\tYunnan Forestry School\t\t",
"YFTC\ts\tYale Fish Tissue Collection\t\t",
"YH\ts\tLutheran College\t\t",
"YHB<CAN>\ts\tYukon Heritage Board , Paleontology Collections\t\t",
"YIM\tc\tYunnan Institute of Microbiology\t\t",
"YIM<herbarium>\ts\tYunnan Institute of Pharmacology\t\t",
"YIO\ts\tYamashina Institute for Ornithology\t\t",
"YK\ts\tBootham School\t\t",
"YKN\ts\tYorkshire Naturalists' Trust Limited\t\t",
"YL\ts\tNorthwest Sci-tech University of Agriculture and Forestry\t\t",
"YLD\ts\tYulin Institute of Desert Control Research\t\t",
"YM<CHN>\tc\tStrains Collection of Yunnan Institute of Microbiology, Yunnan University, China\t\t",
"YM<GBR>\ts\tYork Museum\t\t",
"YM<USA-CA>\ts\tNational Park Service, Yosemite National Park\t\t",
"YMF\ts\tKey Laboratory of Industrial Microbiology & Fermentation Technology\t\t",
"YMUK\ts\tThe Yorkshire Museum\t\t",
"YNP\ts\tThe Yosemite Museum\t\t",
"YNU\ts\tYokohama National University\t\t",
"YNUB\ts\tYunnan Normal University, Biology Department\t\t",
"YNUGI\ts\tYokohama National University - Geological Institute\t\t",
"YNUH\ts\tYeungnam University, Biology Department\t\t",
"YOLA\ts\tMari State University, Department of Plant Biology\t\t",
"YPM\ts\tYale Peabody Museum of Natural History\t\t",
"YPM/PU\ts\tPrinceton University Collection in Yale Peabody Museum\t\t",
"YPM:ENT\ts\tYale Peabody Museum of Natural History, Entomology Collection",
"YPM:HER\ts\tYale Peabody Museum of Natural History, Herpetology Collection",
"YPM:ICH\ts\tYale Peabody Museum of Natural History, Ichthyology Collection",
"YPM:IZ\ts\tYale Peabody Museum of Natural History, Invertebrate Zoology Collection",
"YPM:MAM\ts\tYale Peabody Museum of Natural History, Mammology Collection",
"YPM:ORN\ts\tYale Peabody Museum of Natural History, Ornithology Collection",
"YPMC\ts\tYellowstone National Park\t\t",
"YRK\ts\tYorkshire Museum, Biology Department\t\t",
"YU<CHN>\ts\tYunnan University\t\t",
"YU<JOR>\ts\tDepartment of Earth and Environmental Sciences, Yarmouk University\t\t",
"YU<USA-CT>\ts\tYale University, Botany Division\t\t",
"YUC\ts\tINIREB\t\t",
"YUKU\ts\tYunnan University, Biology Department\t\t",
"YUO\ts\tYoungstown State University, Biological Sciences Department\t\t",
"YUTO\ts\tYork University, Biology Department\t\t",
"YXDC\ts\tYuxi District Institute for Drug Control\t\t",
"YZU\ts\tYuzhou University\t\t",
"Z\ts\tUniversitaet Zuerich\t\t",
"ZA\ts\tUniversity of Zagreb, Botany Department\t\t",
"ZAD\ts\tMount Makulu Research Station\t\t",
"ZAGR\ts\tUniversity of Zagreb\t\t",
"ZAHO\ts\tUniversity of Zagreb, Botany Department\t\t",
"ZAR\ts\tInstitut de Paleontologie du Museum National Historie Naturelle\t\t",
"ZAU\ts\tZhejiang Agricultural University\t\t",
"ZAUC\ts\tZhejian Agricultural University\t\t",
"ZBMM\ts\tMaharaja's College, Zoology and Botany Museum\t\t",
"ZCA\ts\tZhelimu College of Animal Husbandry, Range Science Department\t\t",
"ZCM\ts\tShetland Museum\t\t",
"ZDC\ts\tZhejiang Institute for Drug Control\t\t",
"ZDEU\ts\tZoology Department, Ege University\t\t",
"ZDKU\ts\tKharkiv National University\t\t",
"ZDM\ts\tZigong dinosaur Museum\t\t",
"ZEA\ts\tUniversidad de Guadalajara, Centro Universitario de la Costa Sur, Departamento de Ecologia y Recursos Naturales\t\t",
"ZFMK\tsb\tZoologisches Forschungsmuseum Alexander Koenig\t\t",
"ZFMK:COL\ts\tZoologisches Forschungsmuseum Alexander Koenig, Coleoptera collection",
"ZFMK:FSJF\ts\tZoologisches Forschungsmuseum Alexander Koenig, fish collection of Jeorg Freyhof",
"ZFMK:ICH\ts\tZoologisches Forschungsmuseum Alexander Koenig, Ichthyological Collection",
"ZFSN\ts\tLaboratoire de Zoologie de la Faculte Des Sciences\t\t",
"ZGLC\ts\tNatural History Museum, Limassol\t\t",
"ZHAN\ts\tZhanjiang Teachers College, Biology Department\t\t",
"ZhM\ts\tZhejinag Museum\t\t",
"ZIA\ts\tNational Academy of Sciences of Armenia\t\t",
"ZIAN\ts\tZoological Institute, Academy of Sciences\t\t",
"ZICUP\ts\tZoological Institute Charles University\t\t",
"ZIHU\ts\tHiroshima University, Zoological Institute\t\t",
"ZIK\ts\tUkrainian Academy of Sciences, Zoological Institute\t\t",
"ZIKU\ts\tZoological Institute, Kochi University\t\t",
"ZIL\ts\tAcademy of Sciences, Zoological Institute\t\t",
"ZIM\tc\tZIM Culture Collection of Industrial Microorganisms\t\t",
"ZIN\ts\tZoological Institute of the Russian Academy of Sciences\tZIAS",
"ZIS\ts\tUniversitaet Saarbruecken\t\t",
"ZISB\ts\tInstitute of Zoology\t\t",
"ZISP\ts\tZoological Institute, Russian Academy of Sciences\tIN",
"ZIT\ts\tGrusinian Academy of Sciences\t\t",
"ZITIU\ts\tZoological Institute, Tokyo Imperial University\t\t",
"ZIUG\ts\tZoologisches Institut\t\t",
"ZIUL\ts\tZoologisches Institut der Universitaet\t\t",
"ZIUN\ts\tUniversita DI Napoli\t\t",
"ZIUS<AUT>\ts\tZoologisches Institute der Universitat\t\t",
"ZIUS<SWE>\ts\tZoologiska Institutionen\t\t",
"ZIUT\ts\tDepartment of Zoology, Faculty of Science, University of Tokyo\t\t",
"ZIUU\ts\tUppsala Universitet, Zoologiska Museum\t\t",
"ZIUW\ts\tUniversitaet Wien, Zoologisches Institut\t\t",
"ZIUZ\ts\tZagreb University\t\t",
"ZJFC\ts\tZhejiang Forestry College, Forestry Department\t\t",
"ZJFI\ts\tZhejiang Forestry Institute, Bamboo Department\t\t",
"ZJMA\ts\tZhejiang Academy of Medical Sciences\t\t",
"ZJU\tb\tZhejiang University College of Sciences\t\t",
"ZLMU\ts\tMeijo University\t\t",
"ZLSYU\ts\tZoological Laboratory\t\t",
"ZLVG\tc\tCulture collection of the Laboratory of Forest Protection at the Slovenian Forestry Institute\t\t",
"ZM\ts\tZhejiang Museum of Natural History\t\t",
"ZMA\ts\tUniversiteit van Amsterdam, Zoologisch Museum\t\t",
"ZMA:POR\ts\tUniversiteit van Amsterdam, Zoologisch Museum, Porifera collection",
"ZMAN\ts\tInstituut voor Taxonomische Zoologie, Zoologisch Museum\t\t",
"ZMAU\ts\tZoological Museum Andhra University\t\t",
"ZMB\ts\tZoologisches Museum der Humboldt-Universitaet zu Berlin\t\t",
"ZMBJ\ts\tBanding Zoological Museum\t\t",
"ZMBN\ts\tMuseum of Zoology at the University of Bergen, Invertebrate Collection\tBMBN",
"ZMC\ts\tDeptment of Biology, Zunyi Medical College\t\t",
"ZMFMIB\ts\tZoologial Museum Fan Memorial Institute of Biology\t\t",
"ZMG<DEU-Gottingen>\ts\tZoologisches Museum der Universitat Gottingen\t\t",
"ZMG<DEU-Greifswald>\ts\tZoologischen Museums Greifswald\t\t",
"ZMH\ts\tZoologisches Museum Hamburg\t\t",
"ZMHB\ts\tMuseum fuer Naturkunde der Humboldt-Universitat\t\t",
"ZMHU\ts\tZoologisches Museum der Humboldt Universitaet\t\t",
"ZMJU\ts\tZoological Museum, Jagiellonian University\t\t",
"ZMK<DEU>\ts\tZoologisches Museum der Universitat Kiel\t\t",
"ZMK<DNK>\ts\tZoological Museum, Copenhagen\t\t",
"ZMK<NOR>\ts\tZoological Musem, Kristiania\t\t",
"ZMKR\ts\tKoenigsberg Zoologisches Museum\t\t",
"ZMKU\ts\tKiev Zoological Museum\t\t",
"ZMKU<THA>\ts\tZoological Museum, Kasetsart University\t\t",
"ZML\ts\tSt Petersburg State University\t\t",
"ZMLP\ts\tUniversity of Punjab\t\t",
"ZMLU\ts\tLunds Universitet, Zoologiska Institutionen\t\t",
"ZMMGU\ts\tZoological Museum\t\t",
"ZMMU\ts\tZoological Museum, Moscow Lomonosov State University\tZMM,ZMUM",
"ZMMU:Birds\ts\tZoological Museum, Moscow Lomonosov State University, Bird Collection",
"ZMMU:Fishes\ts\tZoological Museum, Moscow Lomonosov State University, Fishes Collection",
"ZMMU:Herps\ts\tZoological Museum, Moscow Lomonosov State University, Ampibia and Reptilia Collection",
"ZMMU:Insects\ts\tZoological Museum, Moscow Lomonosov State University, Insects Collection",
"ZMMU:Invertebrates\ts\tZoological Museum, Moscow Lomonosov State University, Invertebrates Collection",
"ZMMU:Mamm\ts\tZoological Museum, Moscow Lomonosov State University, Mammal Collection",
"ZMNH\ts\tZhejiang Museum of Natural History\t\t",
"ZMO\ts\tZoology Museum, Oxford University\t\t",
"ZMS\ts\tZentralmuseum Senckenberg (SENCKENBERG world of biodiversity)\t\t",
"ZMSZ\ts\tZemaljski Mujski\t\t",
"ZMT<CZE>\ts\tZapadomoravske muzeum v Trebici\t\t",
"ZMT<GEO>\ts\tGeorgian State Museum, Zoological Section\t\t",
"ZMTAU\ts\tZoological Museum Tel Aviv University\t\t",
"ZMU\ts\tZhejiang Medical University, Pharmacy Department\t\t",
"ZMUA<CHN>\ts\tZooligal Museum, University of Amoy\t\t",
"ZMUA<GRC>\ts\tZoological Museum, University of Athens\t\t",
"ZMUAS\ts\tZoological Museum Ukrainian Academy of Sciences\t\t",
"ZMUB\ts\tMuseum of Zoology at the University of Bergen, Vertebrate collections\t\t",
"ZMUB:BIRD\ts\tMuseum of Zoology at the University of Bergen, Vertebrate collections, Bird collection",
"ZMUB:HERP\ts\tMuseum of Zoology at the University of Bergen, Vertebrate collections, Herptile collection",
"ZMUB:ICHT\ts\tMuseum of Zoology at the University of Bergen, Vertebrate collections, Fish Collections",
"ZMUB:MAMM\ts\tMuseum of Zoology at the University of Bergen, Vertebrate collections, Mammal collection",
"ZMUC\tsb\tZoological Museum, University of Copenhagen\t\t",
"ZMUD\ts\tUniversity of Dhaka, Zoology Museum\t\t",
"ZMUH<DEU>\ts\tZoologisches Institut und Zoologisches Museum, Universitat Hamburg\t\t",
"ZMUH<VNM>\ts\tZoological Museum, University of Hanoi\t\t",
"ZMUI\ts\tZoological Museum, University of Istanbul\t\t",
"ZMUL\ts\tUniversitetets Lund, Zoologiska Museet\t\t",
"ZMUN\ts\tZoology, Natural History Museum, University of Oslo\t\t",
"ZMUO<FIN>\ts\tUniversity of Oulu Zoological Museum\t\t",
"ZMUO<NOR>\ts\tUniversitetets I Oslo, Zoologisk Museum\t\t",
"ZMUP\ts\tZoological Museum of the University of Patras\t\t",
"ZMUT\ts\tUniversity of Tokyo, Department of Zoology\t\t",
"ZMUU\ts\tUppsala Universitet, Zoologiska Museet\t\t",
"ZMUZ\ts\tZoologisches Museum der Universitat Zurich\t\t",
"ZNG\th\tBulent Ecevit University\t\t",
"ZNM\ts\tZhejiang Natural Museum\t\t",
"ZNP\ts\tZion National Park\t\t",
"ZNPC\ts\tSpringdale, Zion National Park\t\t",
"ZNU\ts\tZhejiang Normal University, Biology Department\t\t",
"ZOM\ts\tHerbarium, Department of Agriculture, Malawi\t\t",
"ZPAL\ts\tZoological Institute of Paleobiology, Polish Academy of Sciences\t\t",
"ZPB\ts\tInstitute of Conservation and Natural History of the Soutpansberg\t\t",
"ZRC\ts\tZoological Reference Collection, National University of Singapore\t\t",
"ZSBS\ts\tZoologische Sammlung des Bayerischen Staates\t\t",
"ZSI\ts\t Zoological Survey of India\t\t",
"ZSI-CRS\ts\tZoological Survey of India, Central Regional Station\t\t",
"ZSI-E\ts\tZoological Survey of India\t\t",
"ZSI-M\ts\tZoological Survey of India\t\t",
"ZSI-NRS\ts\tZoological Survey of India\t\t",
"ZSI-SRS\ts\tZoological Survey of India, Southern Regional Station\t\t",
"ZSI-WRS\ts\tZoological Survey of India\t\t",
"ZSIC\ts\tZoological Survey of India\t\t",
"ZSLC\ts\tZoological Society of London\t\t",
"ZSM\tsb\tZoologische Staatssammlung Munchen\tZSMH",
"ZSM/CMK\ts\tZoologische Museum Staatssammlung\t\t",
"ZSM/LIPI\ts\tZoologische Museum Staatssammlung\t\t",
"ZSM:Lep\ts\tZoologische Staatssammlung Munchen, Lepidoptera",
"ZSM:Mol\ts\tZoologische Staatssammlung Munchen, Mollusca",
"ZSMC\ts\tZoologische Staatssammlung\t\t",
"ZSP<PAK>\ts\tZoological Survey of Pakistan\t\t",
"ZSP<USA-PA>\ts\tZoological Society of Philadelphia\t\t",
"ZSS\ts\tSukkulenten-Sammlung Zuerich\t\t",
"ZT\ts\tEidgenoessische Technische Hochschule Zuerich\t\t",
"ZTNH\ts\tUniversity of Vermont, Zadock Thompson Natural History Collections\t\t",
"ZTS\ts\tInstitute of Nature Conservation, Polish Academy of Sciences, Tatra Field Station\t\t",
"ZUAB\ts\tZoologia--Universidad Autonoma de Barcelona\t\t",
"ZUAC\ts\tUniversity of Antananarivo\t\t",
"ZUEC\ts\tMuseu de Zoologia da Universidade Estadual de Campinas\t\t",
"ZUFES\ts\tUniversidad Federal do Espirito Santo\t\t",
"ZUFRJ\ts\tDepartamento de Zoolgia, Instituto de Biologia\t\t",
"ZUFSM<BRA>\ts\tUniversidade Federal de Santa Maria, Laboratorio de Herpetologia\t\t",
"ZULU\ts\tUniversity of Zululand, Botany Department\t\t",
"ZUMT\ts\tDepartment of Zoology, University Museum\t\t",
"ZUTC\ts\tZoological Museum University of Tehran\t\t",
"ZV\ts\tTechnical University, Department of Phytology\t\t",
"ZVC\ts\tDepto. de Zoologia Vertebrados de la Facultad de Humanidades y Ciencias\t\t",
"ZVCB<URY>\ts\tVertebrate Collection, Facultad de Ciencias, Universidad de la Republica\t\t",
"ZVS\ts\tBundesamt fuer Naturschutz\t\t",
"ZY\th\tZunyi Normal College\t\t",
"ZYTC\ts\tZhangye Teachers College, Chemistry-Biology Department\t\t",
"ZZN\tc\tZavod za naravoslovje\t\t",
"ZZSZ\ts\tZoology Department, Faculty of Natural Sciences, University of Zagreb\t\t"
};
