////////////////////////////////////////////////////////////////////////////////////////
//
// Nestopia - NES/Famicom emulator written in C++
//
// Copyright (C) 2003-2008 Martin Freij
//
// This file is part of Nestopia.
//
// Nestopia is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Nestopia is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Nestopia; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
////////////////////////////////////////////////////////////////////////////////////////

#ifndef NST_BOARD_SUBOR_H
#define NST_BOARD_SUBOR_H

#ifdef NST_PRAGMA_ONCE
#pragma once
#endif

namespace Nes
{
	namespace Core
	{
		namespace Boards
		{
			namespace Subor
			{
				class Type0 : public Board
				{
				public:

					explicit Type0(const Context& c)
					: Board(c) {}

				private:

					void SubReset(bool);
					void SubSave(State::Saver&) const;
					void SubLoad(State::Loader&,dword);

					virtual uint GetMode() const;

					NES_DECL_POKE( 8000 );

					byte regs[4];
				};

				class Type1 : public Type0
				{
				public:

					explicit Type1(const Context& c)
					: Type0(c) {}

				private:

					uint GetMode() const;
				};

				class StudyNGame : public Board
				{
				public:

					explicit StudyNGame(const Context& c)
					: Board(c) {}

				private:

					void SubReset(bool);
				};
			}
		}
	}
}

#endif
