/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.makeproject.ui.utils;

import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;

public class PathPanel extends javax.swing.JPanel {
    /** Creates new form PathPanel */
    public PathPanel() {
        initComponents();
        pathButtonGroup.add(relOrAbsRadioButton);
        pathButtonGroup.add(relRadioButton);
        pathButtonGroup.add(absRadioButton);

	setMode(MakeProjectOptions.getPathMode());
    }
    
    private void setMode(MakeProjectOptions.PathMode mode) {
	MakeOptions.getInstance().setPathMode(mode);
        switch (mode) {
            case ABS:
                absRadioButton.setSelected(true);
                break;
            case REL:
                relRadioButton.setSelected(true);
                break;
            case REL_OR_ABS:
                relOrAbsRadioButton.setSelected(true);
                break;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        pathButtonGroup = new javax.swing.ButtonGroup();
        pathPanel = new javax.swing.JPanel();
        pathLabel = new javax.swing.JLabel();
        relOrAbsRadioButton = new javax.swing.JRadioButton();
        relRadioButton = new javax.swing.JRadioButton();
        absRadioButton = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        pathPanel.setLayout(new java.awt.GridBagLayout());

        pathLabel.setLabelFor(pathPanel);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(pathLabel, bundle.getString("PATHPANEL_PATHLABEL_TXT")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        pathPanel.add(pathLabel, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(relOrAbsRadioButton, bundle.getString("PATHPANEL_AUTO_TXT")); // NOI18N
        relOrAbsRadioButton.setToolTipText(bundle.getString("PATHPANEL_AUTO_TT")); // NOI18N
        relOrAbsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                relOrAbsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        pathPanel.add(relOrAbsRadioButton, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(relRadioButton, bundle.getString("PATHPANEL_REL_TXT")); // NOI18N
        relRadioButton.setToolTipText(bundle.getString("PATHPANEL_REL_TT")); // NOI18N
        relRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                relRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        pathPanel.add(relRadioButton, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(absRadioButton, bundle.getString("PATHPANEL_ABS_TXT")); // NOI18N
        absRadioButton.setToolTipText(bundle.getString("PATHPANEL_ABS_TT")); // NOI18N
        absRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                absRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        pathPanel.add(absRadioButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(pathPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void absRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_absRadioButtonActionPerformed
	MakeOptions.getInstance().setPathMode(MakeProjectOptions.PathMode.ABS);
    }//GEN-LAST:event_absRadioButtonActionPerformed

    private void relRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_relRadioButtonActionPerformed
	MakeOptions.getInstance().setPathMode(MakeProjectOptions.PathMode.REL);
    }//GEN-LAST:event_relRadioButtonActionPerformed

    private void relOrAbsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_relOrAbsRadioButtonActionPerformed
	MakeOptions.getInstance().setPathMode(MakeProjectOptions.PathMode.REL_OR_ABS);
    }//GEN-LAST:event_relOrAbsRadioButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton absRadioButton;
    private javax.swing.ButtonGroup pathButtonGroup;
    private javax.swing.JLabel pathLabel;
    private javax.swing.JPanel pathPanel;
    private javax.swing.JRadioButton relOrAbsRadioButton;
    private javax.swing.JRadioButton relRadioButton;
    // End of variables declaration//GEN-END:variables
    
}
