/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;


/**
 *
 * @author  blaha
 */
public class SendEmailPanel extends javax.swing.JPanel implements ChangeListener {

    public static final String IS_VALID = "SendEmailPanel_isValid"; //NOI18N

    private final ServiceLocatorStrategyPanel slcPanel;
    private final ChangeSupport changeSupport = new ChangeSupport(this);
    private String errorMsg = null;

    /** Creates new form SendEmailPanel */
    public SendEmailPanel(String lastLocator, ClasspathInfo cpInfo) {
        initComponents();

        changeSupport.addChangeListener(this);
        scanningLabel.setVisible(SourceUtils.isScanInProgress());

        slcPanel = new ServiceLocatorStrategyPanel(lastLocator, cpInfo);
        serviceLocatorPanel.add(slcPanel,BorderLayout.CENTER);
        slcPanel.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                changeSupport.fireChange();
            }
        });
        jndiNameTextField.getDocument().addDocumentListener(new DocumentListener() {
            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                fireChange();
            }
            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                fireChange();
            }
            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                fireChange();
            }
            private void fireChange() {
                changeSupport.fireChange();
            }
        });
    }
    
    public String getServiceLocator(){
        return slcPanel.classSelected();
    }
    
    public String getJndiName(){
        return jndiNameTextField.getText();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jndiNameLabel = new javax.swing.JLabel();
        jndiNameTextField = new javax.swing.JTextField();
        serviceLocatorPanel = new javax.swing.JPanel();
        scanningLabel = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(jndiNameLabel, org.openide.util.NbBundle.getBundle(SendEmailPanel.class).getString("LBL_jndiName")); // NOI18N

        jndiNameTextField.setColumns(30);

        serviceLocatorPanel.setLayout(new java.awt.BorderLayout());

        scanningLabel.setFont(new java.awt.Font("Dialog", 2, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(scanningLabel, org.openide.util.NbBundle.getMessage(SendEmailPanel.class, "LBL_ScanningInProgress")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(serviceLocatorPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jndiNameLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jndiNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 1, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(scanningLabel)
                        .addGap(0, 73, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(6, 6, 6)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jndiNameLabel)
                    .addComponent(jndiNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(serviceLocatorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(scanningLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(SendEmailPanel.class, "ACSD_SpecifyMailResource")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SendEmailPanel.class, "ACSD_SpecifyMailResource")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jndiNameLabel;
    private javax.swing.JTextField jndiNameTextField;
    private javax.swing.JLabel scanningLabel;
    private javax.swing.JPanel serviceLocatorPanel;
    // End of variables declaration//GEN-END:variables
    
    protected boolean isEmptyJndiName() {
        return jndiNameTextField.getText().trim().equals("");
    }

    @NbBundle.Messages("sendEmailPanel.error.empty.jndi.name=JNDI name cannot be empty")
    String getErrorMessage() {
        if (!verifyComponents()) {
            return errorMsg;
        } else if (!slcPanel.verifyComponents()) {
            return slcPanel.getErrorMessage();
        } else {
            return null;
        }
    }

    private boolean verifyComponents() {
        if (isEmptyJndiName()) {
            errorMsg = Bundle.sendEmailPanel_error_empty_jndi_name();
            return false;
        } else {
            errorMsg = null;
            return true;
        }
    }

    public boolean valid() {
        return verifyComponents() && slcPanel.verifyComponents();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        // update scanning label visibility
        scanningLabel.setVisible(SourceUtils.isScanInProgress());

        if (valid()) {
            firePropertyChange(IS_VALID, false, true);
        } else {
            firePropertyChange(IS_VALID, true, false);
        }
    }
    
}
