/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2012 Sun Microsystems, Inc.
 */
package org.netbeans.modules.php.project.copysupport;

import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 * UI for failed files.
 */
@org.netbeans.api.annotations.common.SuppressWarnings("SE_BAD_FIELD_STORE")
public final class FailedFilesPanel extends JPanel {

    private static final long serialVersionUID = 146876432354L;

    private final ListModel<String> failedFilesListModel;


    private FailedFilesPanel(boolean local, List<String> failedFiles) {
        failedFilesListModel = new FailedFilesListModel(failedFiles);
        initComponents();
        init(local);
    }

    public static void local(String projectName, List<String> failedFiles) {
        show(true, projectName, failedFiles);
    }

    public static void remote(String projectName, List<String> failedFiles) {
        show(false, projectName, failedFiles);
    }

    private static void show(boolean local, String projectName, List<String> failedFiles) {
        FailedFilesPanel panel = new FailedFilesPanel(local, failedFiles);
        DialogDescriptor descriptor = new DialogDescriptor(
                panel,
                projectName,
                true,
                new Object[] {DialogDescriptor.OK_OPTION},
                DialogDescriptor.OK_OPTION,
                DialogDescriptor.DEFAULT_ALIGN,
                null,
                null);
        DialogDisplayer.getDefault().notify(descriptor);
    }

    @NbBundle.Messages({
        "FailedFilesPanel.title.local=Copy Support failed for:",
        "FailedFilesPanel.title.remote=Upload Files On Save failed for:"
    })
    private void init(boolean local) {
        /// title
        String title;
        if (local) {
            title = Bundle.FailedFilesPanel_title_local();
        } else {
            title = Bundle.FailedFilesPanel_title_remote();
        }
        titleLabel.setText(title);
        // files
        failedFilesList.setModel(failedFilesListModel);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        titleLabel = new JLabel();
        failedFilesScrollPane = new JScrollPane();
        failedFilesList = new JList<String>();

        Mnemonics.setLocalizedText(titleLabel, "TITLE"); // NOI18N

        failedFilesList.setEnabled(false);
        failedFilesScrollPane.setViewportView(failedFilesList);

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(Alignment.LEADING)
                    .addComponent(failedFilesScrollPane)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(titleLabel)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(titleLabel)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(failedFilesScrollPane)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JList<String> failedFilesList;
    private JScrollPane failedFilesScrollPane;
    private JLabel titleLabel;
    // End of variables declaration//GEN-END:variables

    //~ Inner classes

    private static final class FailedFilesListModel implements ListModel<String> {

        private final List<String> failedFiles;


        public FailedFilesListModel(List<String> failedFiles) {
            this.failedFiles = new ArrayList<>(failedFiles);
        }

        @Override
        public int getSize() {
            return failedFiles.size();
        }

        @Override
        public String getElementAt(int index) {
            return failedFiles.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            // noop
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            // noop
        }

    }

}
