/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Vector;
import net.claribole.zvtm.engine.Location;
import net.claribole.zvtm.engine.Portal;

public class CameraPortal
extends Portal {
    Color borderColor;
    Color bkgColor;
    Camera camera;
    VirtualSpace cameraSpace;
    long viewWC;
    long viewNC;
    long viewEC;
    long viewSC;
    float uncoef;
    Vector drawnGlyphs;
    Glyph[] gll;
    int camIndex;
    Stroke standardStroke;
    AffineTransform standardTransform;

    public CameraPortal(int x, int y, int w, int h, Camera c) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.updateDimensions();
        this.camera = c;
        this.cameraSpace = this.camera.getOwningSpace();
        this.camIndex = this.camera.getIndex();
    }

    public void setOwningView(View v) {
        super.setOwningView(v);
        this.camera.setOwningView(v);
    }

    public void setBorder(Color bc) {
        this.borderColor = bc;
    }

    public Color getBorder() {
        return this.borderColor;
    }

    public void setBackgroundColor(Color bc) {
        this.bkgColor = bc;
    }

    public Color getBackgroundColor() {
        return this.bkgColor;
    }

    public LongPoint getVSCoordinates(int cx, int cy) {
        float uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
        return new LongPoint((long)((float)this.camera.posx + (float)(cx - this.x - this.w / 2) * uncoef), (long)((float)this.camera.posy - (float)(cy - this.y - this.h / 2) * uncoef));
    }

    public long[] getVisibleRegion(long[] res) {
        float uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
        res[0] = (long)((float)this.camera.posx - (float)(this.w / 2) * uncoef);
        res[1] = (long)((float)this.camera.posy + (float)(this.h / 2) * uncoef);
        res[2] = (long)((float)this.camera.posx + (float)(this.w / 2) * uncoef);
        res[3] = (long)((float)this.camera.posy - (float)(this.h / 2) * uncoef);
        return res;
    }

    public long[] getVisibleRegion() {
        return this.getVisibleRegion(new long[4]);
    }

    public Location getGlobalView() {
        float tmpRatio;
        long[] wnes = this.cameraSpace.findFarmostGlyphCoords();
        long dx = (wnes[2] + wnes[0]) / 2L;
        long dy = (wnes[1] + wnes[3]) / 2L;
        long[] regBounds = this.getVisibleRegion();
        long[] trRegBounds = new long[]{regBounds[0] + dx - this.camera.posx, regBounds[3] + dy - this.camera.posy};
        float currentAlt = this.camera.getAltitude() + this.camera.getFocal();
        float ratio = 0.0f;
        if (trRegBounds[0] != 0L) {
            ratio = (float)(dx - wnes[0]) / (float)(dx - trRegBounds[0]);
        }
        if (trRegBounds[1] != 0L && (tmpRatio = (float)(dy - wnes[3]) / (float)(dy - trRegBounds[1])) > ratio) {
            ratio = tmpRatio;
        }
        return new Location(dx, dy, currentAlt * Math.abs(ratio));
    }

    public Location getGlobalView(int d, VirtualSpaceManager vsm) {
        Location l = this.getGlobalView();
        float dAlt = l.alt - this.camera.getAltitude() - this.camera.getFocal();
        Vector<Object> prms = new Vector<Object>();
        prms.add(new Float(dAlt));
        prms.add(new LongPoint(l.vx - this.camera.posx, l.vy - this.camera.posy));
        vsm.animator.createCameraAnimation(d, (short)6, prms, this.camera.getID());
        return l;
    }

    public Location getSeamlessView(Camera c) {
        int hvw = c.getOwningView().getFrame().getWidth() / 2;
        int hvh = c.getOwningView().getFrame().getHeight() / 2;
        float uncoef = (c.focal + c.altitude) / c.focal;
        long[] wnes = new long[]{(long)((float)c.getOwningView().mouse.vx - (float)(this.w / 2) * uncoef), (long)((float)c.getOwningView().mouse.vy + (float)(this.h / 2) * uncoef), (long)((float)c.getOwningView().mouse.vx + (float)(this.w / 2) * uncoef), (long)((float)c.getOwningView().mouse.vy - (float)(this.h / 2) * uncoef)};
        return new Location((wnes[2] + wnes[0]) / 2L, (wnes[1] + wnes[3]) / 2L, this.camera.focal * ((float)(wnes[2] - wnes[0]) / (float)this.w));
    }

    public boolean coordInside(int cx, int cy) {
        return cx >= this.x && cx <= this.x + this.w && cy >= this.y && cy <= this.y + this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        g2d.setClip(this.x, this.y, this.w, this.h);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        Vector vector = this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = (long)((float)this.camera.posx - (float)(this.w / 2) * this.uncoef);
            this.viewNC = (long)((float)this.camera.posy + (float)(this.h / 2) * this.uncoef);
            this.viewEC = (long)((float)this.camera.posx + (float)(this.w / 2) * this.uncoef);
            this.viewSC = (long)((float)this.camera.posy - (float)(this.h / 2) * this.uncoef);
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                    }
                    continue;
                }
            }
        }
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
    }
}

