(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47414,       1191]
NotebookOptionsPosition[     46574,       1161]
NotebookOutlinePosition[     46963,       1178]
CellTagsIndexPosition[     46920,       1175]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", " ", 
    RowBox[{"NotebookDirectory", "[", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "PrintVector`"}]}], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4975401175502357`*^9, 3.497540122081654*^9}, {
   3.4975401577475357`*^9, 3.4975404433537083`*^9}, {3.497540482896634*^9, 
   3.4975405759100437`*^9}, {3.497541105993033*^9, 3.497541123798511*^9}, {
   3.497542050468046*^9, 3.497542062974934*^9}, {3.497542456642642*^9, 
   3.497542474403122*^9}, {3.497542524646307*^9, 3.497542533911161*^9}, {
   3.4975426113736467`*^9, 3.497542615636695*^9}, 3.49754300944394*^9, 
   3.497543161820746*^9, {3.4975433080968943`*^9, 3.497543333089579*^9}, {
   3.497634816866467*^9, 3.497634822396894*^9}, 3.497634889182472*^9, {
   3.4976349550362673`*^9, 3.497635002695628*^9}, {3.497635080038419*^9, 
   3.4976350905563173`*^9}, {3.497720303149754*^9, 3.497720340683272*^9}, 
   3.497720446950582*^9, {3.497720543770192*^9, 3.497720554263856*^9}, {
   3.497720624718094*^9, 3.4977206409163923`*^9}, {3.497720745653871*^9, 
   3.497720821394751*^9}, {3.497720852170191*^9, 3.497720892717999*^9}, {
   3.497720926142789*^9, 3.497720963010685*^9}, {3.49772100166604*^9, 
   3.4977210066482897`*^9}, {3.497721154131791*^9, 3.4977211732733927`*^9}, {
   3.497721253141778*^9, 3.497721260212431*^9}, {3.4977213873833313`*^9, 
   3.497721394326082*^9}, {3.4977214268766117`*^9, 3.497721450684969*^9}, 
   3.517368305980814*^9, 3.517368338946211*^9, {3.548337349389185*^9, 
   3.54833735124184*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", "64"}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Working", " ", 
    RowBox[{"precision", "."}]}], " ", "*)"}]}]], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.5173364544175253`*^9, 3.517336455143111*^9}, {
  3.548337583667452*^9, 3.548337584482711*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"GenerateFilename", "[", "prefix_", "]"}], "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Length", "[", "NN", "]"}]}], ","}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Dimension", "."}], " ", "*)"}], "}"}], ",", 
    RowBox[{"Return", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{"prefix", ",", 
        RowBox[{"\"\<nfft_\>\"", "<>", 
         RowBox[{"ToString", "[", "d", "]"}], "<>", "\"\<d_\>\"", "<>", 
         RowBox[{"StringJoin", "[", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"x", ",", 
               RowBox[{
                RowBox[{"ToString", "[", "x", "]"}], "<>", "\"\<_\>\""}]}], 
              "]"}], ",", "NN"}], "]"}], "<>", 
           RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<.txt\>\""}], 
          "]"}]}]}], "}"}], "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"GenerateFilenameAdjoint", "[", "prefix_", "]"}], "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Length", "[", "NN", "]"}]}], ","}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Dimension", "."}], " ", "*)"}], "}"}], ",", 
    RowBox[{"Return", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{"prefix", ",", 
        RowBox[{"\"\<nfft_adjoint_\>\"", "<>", 
         RowBox[{"ToString", "[", "d", "]"}], "<>", "\"\<d_\>\"", "<>", 
         RowBox[{"StringJoin", "[", 
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"x", ",", 
               RowBox[{
                RowBox[{"ToString", "[", "x", "]"}], "<>", "\"\<_\>\""}]}], 
              "]"}], ",", "NN"}], "]"}], "<>", 
           RowBox[{"ToString", "[", "M", "]"}], "<>", "\"\<.txt\>\""}], 
          "]"}]}]}], "}"}], "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Generate", "[", 
   RowBox[{"NN_", ",", "M_", ",", "FilenameGenerator_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Length", "[", "NN", "]"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Dimension", "."}], " ", "*)"}], "\[IndentingNewLine]", 
      "file"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"k", ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"Ceiling", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"NN", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "/", "2"}], "]"}], ",", 
            RowBox[{"Floor", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"NN", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "-", "1"}], ")"}], "/", 
              "2"}], "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"II", "[", 
       RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Outer", "[", 
         RowBox[{"List", ",", "II"}], "]"}], ",", 
        RowBox[{"d", "-", "1"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Index", " ", 
       RowBox[{"set", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"x", " ", "=", 
      RowBox[{"Transpose", "[", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", "M", ",", 
           RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}], "]"}]}], " ", 
     ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", 
       RowBox[{"nodes", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"fhat", " ", "=", " ", 
      RowBox[{"(*", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"i", "\[Equal]", "1"}], ",", "1", ",", "0"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "II", "]"}]}], "}"}]}], "]"}], "*)"}], " ", 
      
      RowBox[{"RandomComplex", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], ",", 
          RowBox[{"1", "+", "\[ImaginaryI]"}]}], "}"}], ",", 
        RowBox[{"Length", "[", "II", "]"}], ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", "Fourier", " ", 
       RowBox[{"coefficients", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"fhat", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "2"}], "*", "\[Pi]", "*", "\[ImaginaryI]", "*", 
             RowBox[{"Dot", "[", 
              RowBox[{
               RowBox[{"II", "[", 
                RowBox[{"[", "k", "]"}], "]"}], ",", 
               RowBox[{"x", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", 
            RowBox[{"Length", "[", "II", "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "M"}], "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Function", " ", 
       RowBox[{"values", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"filename", "=", 
      RowBox[{"FilenameGenerator", "[", 
       RowBox[{"NN", ",", "M"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"file", " ", "=", " ", 
      RowBox[{"OpenWrite", "[", "filename", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "d", "]"}], " ", "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerVectorRaw", "[", "NN", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "M", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", 
         RowBox[{"Flatten", "[", "x", "]"}], "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "fhat", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "f", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Close", "[", "file", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Print", "[", "filename", "]"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FileBaseName", "[", 
         RowBox[{"FileNameTake", "[", 
          RowBox[{"filename", ",", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", " ", 
        RowBox[{"FileNameTake", "[", 
         RowBox[{"filename", ",", 
          RowBox[{"-", "2"}]}], "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GenerateAdjoint", "[", 
   RowBox[{"NN_", ",", "M_", ",", "FilenameGenerator_"}], "]"}], ":=", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Length", "[", "NN", "]"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"Dimension", "."}], " ", "*)"}], "\[IndentingNewLine]", 
      "file"}], "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeedRandom", "[", "1", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"k", ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", 
            RowBox[{"Ceiling", "[", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"NN", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "/", "2"}], "]"}], ",", 
            RowBox[{"Floor", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"NN", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "-", "1"}], ")"}], "/", 
              "2"}], "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"II", "[", 
       RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"II", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Outer", "[", 
         RowBox[{"List", ",", "II"}], "]"}], ",", 
        RowBox[{"d", "-", "1"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Index", " ", 
       RowBox[{"set", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"x", "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", "M", ",", 
           RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "d"}], "}"}]}], "]"}], "]"}]}], " ", 
     ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", 
       RowBox[{"nodes", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"f", "=", 
      RowBox[{"RandomComplex", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], ",", 
          RowBox[{"1", "+", "\[ImaginaryI]"}]}], "}"}], ",", "M", ",", 
        RowBox[{"WorkingPrecision", "\[Rule]", "P"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Random", " ", "function", " ", 
       RowBox[{"values", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"fhat", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"[", "j", "]"}], "]"}], "*", 
           RowBox[{"Exp", "[", 
            RowBox[{"2", "*", "\[Pi]", "*", "\[ImaginaryI]", "*", 
             RowBox[{"Dot", "[", 
              RowBox[{
               RowBox[{"II", "[", 
                RowBox[{"[", "k", "]"}], "]"}], ",", 
               RowBox[{"x", "[", 
                RowBox[{"[", "j", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "M"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", 
          RowBox[{"Length", "[", "II", "]"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"(*", " ", 
      RowBox[{"Pseudo", " ", "Fourier", " ", 
       RowBox[{"coefficients", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"filename", "=", 
      RowBox[{"FilenameGenerator", "[", 
       RowBox[{"NN", ",", "M"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"file", " ", "=", " ", 
      RowBox[{"OpenWrite", "[", "filename", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "d", "]"}], " ", "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerVectorRaw", "[", "NN", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatIntegerRaw", "[", "M", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", 
         RowBox[{"Flatten", "[", "x", "]"}], "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "fhat", "]"}], "<>", 
        "\"\<\\n\>\""}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"WriteString", "[", 
      RowBox[{"file", ",", " ", 
       RowBox[{
        RowBox[{"FormatVectorRaw", "[", "f", "]"}], "<>", "\"\<\\n\>\""}]}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Close", "[", "file", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"Print", "[", "filename", "]"}], ";"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"Return", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FileBaseName", "[", 
         RowBox[{"FileNameTake", "[", 
          RowBox[{"filename", ",", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", " ", 
        RowBox[{"FileNameTake", "[", 
         RowBox[{"filename", ",", 
          RowBox[{"-", "2"}]}], "]"}]}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakeTestcase", "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"Generate", "[", 
   RowBox[{"NN", ",", "M", ",", 
    RowBox[{"GenerateFilename", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<data\>\""}], "}"}],
       "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakeTestcaseAdjoint", "[", 
   RowBox[{"NN_", ",", "M_"}], "]"}], ":=", 
  RowBox[{"GenerateAdjoint", "[", 
   RowBox[{"NN", ",", "M", ",", 
    RowBox[{"GenerateFilenameAdjoint", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<data\>\""}], "}"}],
       "]"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Formatter", "[", "x_", "]"}], ":=", 
   RowBox[{"\"\<&\>\"", "<>", "x"}]}], ";"}]}], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.4975401175502357`*^9, 3.497540122081654*^9}, {
   3.4975401577475357`*^9, 3.4975404433537083`*^9}, {3.497540482896634*^9, 
   3.4975405759100437`*^9}, {3.497541105993033*^9, 3.497541123798511*^9}, {
   3.497542050468046*^9, 3.497542062974934*^9}, {3.497542456642642*^9, 
   3.497542474403122*^9}, {3.497542524646307*^9, 3.497542533911161*^9}, {
   3.4975426113736467`*^9, 3.497542615636695*^9}, 3.49754300944394*^9, 
   3.497543161820746*^9, {3.4975433080968943`*^9, 3.497543333089579*^9}, {
   3.497634816866467*^9, 3.497634822396894*^9}, 3.497634889182472*^9, {
   3.497635656084387*^9, 3.4976356567772627`*^9}, {3.4976358827461843`*^9, 
   3.497635902805756*^9}, {3.497639560178165*^9, 3.4976395887805*^9}, {
   3.497717629788444*^9, 3.497717664775313*^9}, {3.4977177954171267`*^9, 
   3.497717811441677*^9}, {3.497717946124824*^9, 3.4977179590024843`*^9}, {
   3.497718091880231*^9, 3.497718097174159*^9}, {3.4977181869580393`*^9, 
   3.4977182306418543`*^9}, {3.4977182817373667`*^9, 3.497718295439774*^9}, {
   3.4977185155717163`*^9, 3.497718516178872*^9}, {3.4977186098337307`*^9, 
   3.497718655031732*^9}, {3.497720354018293*^9, 3.497720361711935*^9}, {
   3.51646665501819*^9, 3.516466703700296*^9}, {3.516466744180666*^9, 
   3.516466850500287*^9}, {3.516466920776816*^9, 3.516466924558702*^9}, {
   3.5164671087352133`*^9, 3.516467132940102*^9}, {3.5164672595898933`*^9, 
   3.516467335735387*^9}, {3.516467446831277*^9, 3.5164675178909597`*^9}, {
   3.516467566236536*^9, 3.516467602081119*^9}, {3.516467646594492*^9, 
   3.516467693982851*^9}, {3.516467799630619*^9, 3.5164678145625057`*^9}, {
   3.516467907906891*^9, 3.516467931231696*^9}, {3.516467974227989*^9, 
   3.516468069686613*^9}, {3.5164681647268057`*^9, 3.516468322329309*^9}, {
   3.516468353208788*^9, 3.516468402515073*^9}, {3.516468569358057*^9, 
   3.5164688697654257`*^9}, {3.516469069967986*^9, 3.516469104912592*^9}, {
   3.516469281838047*^9, 3.516469282536112*^9}, {3.516469343196455*^9, 
   3.5164693448977213`*^9}, {3.516641118739716*^9, 3.51664112101792*^9}, {
   3.5170662585360413`*^9, 3.517066346582275*^9}, {3.517066422311091*^9, 
   3.517066427735291*^9}, {3.517068514164235*^9, 3.517068550246681*^9}, {
   3.517068593075931*^9, 3.5170685931933107`*^9}, {3.517068669073209*^9, 
   3.5170686693269997`*^9}, {3.517068780917268*^9, 3.5170688290906487`*^9}, {
   3.517068882706683*^9, 3.5170688831366453`*^9}, {3.517068913481579*^9, 
   3.517068922846977*^9}, {3.5170689796719627`*^9, 3.517068986237167*^9}, {
   3.517069122334919*^9, 3.517069164248382*^9}, {3.5170692558435507`*^9, 
   3.517069255983468*^9}, {3.517069318241144*^9, 3.517069318331732*^9}, {
   3.517069353096478*^9, 3.517069353285783*^9}, {3.517069394183385*^9, 
   3.51706939429727*^9}, {3.5170694669148607`*^9, 3.517069467074445*^9}, {
   3.517069521880518*^9, 3.517069561354265*^9}, {3.5170708977239847`*^9, 
   3.517070898060605*^9}, {3.517070929587063*^9, 3.517071052229973*^9}, {
   3.5170711918685713`*^9, 3.51707122081702*^9}, {3.5170712579552593`*^9, 
   3.517071258184224*^9}, {3.517073554532979*^9, 3.517073566800956*^9}, {
   3.51707363019388*^9, 3.5170736389107037`*^9}, {3.517073698959797*^9, 
   3.51707370067715*^9}, {3.5171618948918943`*^9, 3.5171619115024137`*^9}, {
   3.517250721250164*^9, 3.5172507217341347`*^9}, {3.5173346932505627`*^9, 
   3.517334838578896*^9}, {3.517334905472475*^9, 3.517334917950143*^9}, {
   3.517334957247117*^9, 3.517334978535076*^9}, {3.517335011733391*^9, 
   3.5173350406442137`*^9}, {3.5173351201064262`*^9, 3.517335137793874*^9}, {
   3.517335375660467*^9, 3.517335412963312*^9}, {3.517335455731798*^9, 
   3.517335551041175*^9}, {3.517335604376453*^9, 3.5173357376825*^9}, {
   3.517335798572322*^9, 3.51733580322344*^9}, {3.5173358514269238`*^9, 
   3.517335963393672*^9}, {3.517336003163329*^9, 3.517336058165167*^9}, {
   3.517336256363311*^9, 3.517336305265251*^9}, {3.51733636389287*^9, 
   3.517336367248146*^9}, {3.51733647413474*^9, 3.5173364746654367`*^9}, {
   3.517336559248983*^9, 3.517336561848617*^9}, {3.517367626541649*^9, 
   3.517367705336946*^9}, {3.517367791656136*^9, 3.517367810533764*^9}, {
   3.5173680054015837`*^9, 3.5173681448802223`*^9}, {3.517368202592416*^9, 
   3.517368212221806*^9}, {3.5173682793361473`*^9, 3.517368279723124*^9}, {
   3.517368363455708*^9, 3.517368401466815*^9}, {3.517368451212386*^9, 
   3.517368463409952*^9}, {3.517368495795951*^9, 3.517368510236106*^9}, {
   3.517368551091064*^9, 3.517368595286662*^9}, {3.517368631352521*^9, 
   3.5173686772721653`*^9}, {3.517383983727648*^9, 3.5173840466805964`*^9}, {
   3.517384159065975*^9, 3.517384167298918*^9}, {3.51738422514648*^9, 
   3.517384227338999*^9}, {3.518195295280732*^9, 3.518195305846961*^9}, {
   3.518195456601633*^9, 3.518195460327448*^9}, {3.518196187080405*^9, 
   3.518196205713777*^9}, 3.518196243875588*^9, {3.518197087019044*^9, 
   3.5181970888272057`*^9}, {3.548336163833386*^9, 3.548336166412342*^9}, {
   3.548336343704324*^9, 3.548336358860406*^9}, {3.5483364701780357`*^9, 
   3.548336484144067*^9}, {3.548336529883884*^9, 3.548336540969346*^9}, {
   3.548344607348515*^9, 3.548344608870598*^9}, {3.5923892698495417`*^9, 
   3.592389323105822*^9}, {3.5923893582569227`*^9, 3.592389367606283*^9}, {
   3.5923894106691723`*^9, 3.592389474381781*^9}, {3.592391112320978*^9, 
   3.5923912308065453`*^9}, {3.5923912730704737`*^9, 
   3.5923912743941193`*^9}, {3.592391386648828*^9, 3.592391388062999*^9}, {
   3.592671923328158*^9, 3.592671924175865*^9}, {3.592672814161797*^9, 
   3.592672817923629*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"1", "D", " ", "Testcases", " ", 
    RowBox[{"Trafo", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "10", ",", "20", ",", "50"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "20", ",", "50"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {X(setup_file),X(destroy_file),ABSPATH(\\\"\>\"", "<>", " ", 
         
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_1d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5173840443832397`*^9, 3.517384081724496*^9}, {
   3.517384180922477*^9, 3.517384425381447*^9}, {3.51767461454566*^9, 
   3.5176746284180737`*^9}, {3.517674660990048*^9, 3.517674671275931*^9}, {
   3.517674784712487*^9, 3.51767478525749*^9}, {3.517674879128593*^9, 
   3.517674881205332*^9}, {3.518114950576809*^9, 3.518114954403322*^9}, {
   3.518115098971106*^9, 3.5181151104874153`*^9}, {3.518194668914782*^9, 
   3.5181946821969357`*^9}, {3.518194734269782*^9, 3.518194735094262*^9}, {
   3.518194773462639*^9, 3.518194875034071*^9}, {3.518194949105473*^9, 
   3.518194987735242*^9}, 3.51819521869759*^9, {3.5181952521605186`*^9, 
   3.518195257942354*^9}, {3.518196034802575*^9, 3.5181960559626827`*^9}, {
   3.518196971634709*^9, 3.518197069048802*^9}, {3.5181975442351294`*^9, 
   3.518197547442575*^9}, {3.518197629827517*^9, 3.518197630432558*^9}, {
   3.5483363721060057`*^9, 3.548336382723646*^9}, {3.548336568717052*^9, 
   3.548336631597205*^9}, {3.548336745404522*^9, 3.5483368903217897`*^9}, {
   3.5483372613781643`*^9, 3.548337281078226*^9}, {3.548337760289608*^9, 
   3.548337791653308*^9}, {3.5483379559441223`*^9, 3.548337985056346*^9}, {
   3.548338045405122*^9, 3.54833809056406*^9}, {3.5483442863008347`*^9, 
   3.548344431490254*^9}, {3.548344516346612*^9, 3.54834452160181*^9}, {
   3.5483445634454823`*^9, 3.548344603589292*^9}, {3.548344673892972*^9, 
   3.548344674043014*^9}, {3.592389147832615*^9, 3.592389157634921*^9}, {
   3.592389233361754*^9, 3.592389234211445*^9}, {3.592753373285009*^9, 
   3.592753400216855*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"1", "D", " ", "Testcases", " ", 
    RowBox[{"Adjoint", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "10", ",", "20", ",", "50"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "20", ",", "50"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcaseAdjoint", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {X(setup_file),X(destroy_file),ABSPATH(\\\"\>\"", "<>", " ", 
         
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_adjoint_1d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5923913241559067`*^9, 3.59239137175106*^9}, {
   3.592391411465201*^9, 3.592391432390818*^9}, 3.59239160556382*^9, {
   3.592753355642009*^9, 3.5927533696953897`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"2", "D", " ", "Testcases", " ", 
    RowBox[{"Trafo", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"20", ",", "50"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {X(setup_file),X(destroy_file),ABSPATH(\\\"\>\"", "<>", " ", 
         
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_2d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.518197155351283*^9, 3.5181971627478523`*^9}, {
  3.518197246832231*^9, 3.518197473939831*^9}, {3.518197565862846*^9, 
  3.5181975665474453`*^9}, {3.5181976205553493`*^9, 3.518197620890814*^9}, {
  3.548344631084435*^9, 3.54834465895175*^9}, {3.548344709542242*^9, 
  3.5483447374599237`*^9}, {3.548344793350206*^9, 3.548344809958082*^9}, {
  3.5483466580895443`*^9, 3.5483466669263077`*^9}, {3.592389149645561*^9, 
  3.5923891601308613`*^9}, {3.592389236836712*^9, 3.5923892391240053`*^9}, {
  3.592753404204129*^9, 3.592753420555386*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"2", "D", " ", "Testcases", " ", 
    RowBox[{"Adjoint", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", 
      RowBox[{"20", ",", "50"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcaseAdjoint", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {X(setup_file),X(destroy_file),ABSPATH(\\\"\>\"", "<>", " ", 
         
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_adjoint_2d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5927534252297688`*^9, 3.592753429445117*^9}, {
  3.59275346161097*^9, 3.592753483004318*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"3", "D", " ", "Testcases", " ", 
    RowBox[{"Trafo", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {X(setup_file),X(destroy_file),ABSPATH(\\\"\>\"", "<>", " ", 
         
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_3d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.518197606681448*^9, 3.518197615153542*^9}, {
  3.5483451910722103`*^9, 3.5483452622079287`*^9}, {3.5483453352624826`*^9, 
  3.548345337453582*^9}, {3.548345370487627*^9, 3.5483453706498127`*^9}, {
  3.5483467419758577`*^9, 3.548346746749652*^9}, {3.548346925708653*^9, 
  3.5483469438417873`*^9}, {3.548347041873805*^9, 3.548347042368384*^9}, {
  3.5483471141121607`*^9, 3.54834711944681*^9}, {3.54834715646264*^9, 
  3.5483471569767027`*^9}, {3.548347414821805*^9, 3.548347416066527*^9}, {
  3.59238915108247*^9, 3.592389162230815*^9}, {3.592389241524185*^9, 
  3.5923892421869593`*^9}, {3.592753716172439*^9, 3.592753721792017*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"3", "D", " ", "Testcases", " ", 
    RowBox[{"Adjoint", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcaseAdjoint", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {X(setup_file),X(destroy_file),ABSPATH(\\\"\>\"", "<>", " ", 
         
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_adjoint_3d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.592753731395296*^9, 3.592753781509344*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"4", "D", " ", "Testcases"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "=", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"NN", ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "d"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NN", "[", 
      RowBox[{"[", "0", "]"}], "]"}], "=", "Sequence"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"NN", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{"List", ",", "NN"}], "]"}], ",", 
       RowBox[{"d", "-", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", "=", 
     RowBox[{"{", "10", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"Flatten", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], ",", "1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"y", ",", 
        RowBox[{"\"\<static const testcase_delegate_file_t \>\"", " ", "<>", 
         RowBox[{"y", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<>", 
         "\"\< = {X(setup_file),X(destroy_file),ABSPATH(\\\"\>\"", "<>", " ", 
         
         RowBox[{"y", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "<>", "\"\<\\\")};\\n\>\""}]}], 
       "]"}], ",", "x"}], "]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FormatVector", "[", 
    RowBox[{
     RowBox[{"x", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", " ", 
     "\"\<*testcases_3d_file\>\"", ",", " ", 
     "\"\<testcase_delegate_file_t\>\"", ",", " ", "Formatter"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"FormatVector", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"MakeTestcase", "[", 
            RowBox[{
             RowBox[{"NN", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", 
             RowBox[{"M", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"Length", "[", "M", "]"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "NN", "]"}]}], "}"}]}], "]"}], "]"}], ",", 
      "\"\<filenames\>\""}], "]"}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.548337660709242*^9, 3.5483376910598288`*^9}, {
  3.548347420747239*^9, 3.548347430447401*^9}, {3.5923891526665897`*^9, 
  3.59238916503076*^9}, {3.592389244924111*^9, 3.592389245598806*^9}}]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1920, 1068},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 6, \
2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1621, 27, 43, "Input",
 InitializationCell->True,
 InitializationGroup->True],
Cell[2169, 49, 352, 10, 27, "Input",
 InitializationCell->True,
 InitializationGroup->True],
Cell[2524, 61, 21252, 486, 808, "Input",
 InitializationCell->True,
 InitializationGroup->True],
Cell[23779, 549, 4303, 100, 163, "Input"],
Cell[28085, 651, 2959, 81, 178, "Input"],
Cell[31047, 734, 3219, 84, 163, "Input"],
Cell[34269, 820, 2790, 78, 163, "Input"],
Cell[37062, 900, 3258, 83, 163, "Input"],
Cell[40323, 985, 2684, 75, 163, "Input"],
Cell[43010, 1062, 3560, 97, 178, "Input"]
}
]
*)

(* End of internal cache information *)
