/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - World
*/

#ifndef __WORLD_H_INCLUDED__
#define __WORLD_H_INCLUDED__

struct World
{
	Tile		**tile;
	uint		width;
	uint		height;
	bool		refreshStaticPart;
	SDL_Surface	*staticPart;
	Tile		**nonStaticTile;
	uint		nonStaticTiles;
	Object		*firstObject;
	Object		*lastObject;
	uint		bgnd;
	uint		bgndImage;
	Object		*hero;
	Object		*icecream;
	uint		candyCount;	
	
	SlashTDP::World	world;
	
	World();
	~World();
	
	void newWorld(int nwidth, int nheight);
	void loadWorld(String file);
	void saveWorld(String file);
	
	void prepareForPhysics();
	
	Object *createObject(uint code, int x, int y);
	Object *createParticleObject(uint code, int x, int y, float a, float f,
		int life);
	void removeObject(Object *obj);
	void removeAllObjects();
	void recalcBobbing();
	
	Object *objectAt(int x, int y);
	
	Tile *objectCollideWithWorld(Object *obj);

	void drawStaticPart();	
	void draw();
	
	void animate();
};

extern World	*world;

#endif

