# io.js TC Meeting 2015-03-18

## Links

* **Public YouTube feed**: http://www.youtube.com/watch?v=tQwVcuYCiZ4
* **Google Plus Event page**: https://plus.google.com/events/cneon2drmol62u4drm8aegjnrkk
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/1187
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1It6PTEBQ7OjW8P88hCLoXvcWKA3Q8dY2eYEHIF6FvS4

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* [#1134](https://github.com/nodejs/io.js/pull/1134) Add Docker working group
* [#1140](https://github.com/nodejs/io.js/pull/1140) Revert stream base / @piscisaureus / merge policy questions
* [#1130](https://github.com/nodejs/io.js/pull/1130) Nominating Jeremiah Senkpiel @Fishrock123 to the TC
* [#1077](https://github.com/nodejs/io.js/pull/1077) Pass args to process.nextTick() / @trevnorris

## Minutes

### Present

* Ben (TC)
* Bert (TC)
* Chris (TC)
* Fedor (TC)
* Trevor (TC)
* Rod

### Mini stand-up

* Ben: reviewing bugs, fixing pull requests
* Bert: debugging Windows issues (related to #1005), working on a more helpful CI dashboard
* Chris: working on tools to inspect amount of ecosystem breakage that changes cause
* Fedor: working through PayPal leak issue, working on net.socket() changes
* Rod: ..
* Trevor: misc PRs, process.nextTick(), timer bug

### Review of last meeting

* lib: fix process.send() sync i/o regression [#774](https://github.com/nodejs/io.js/issues/774) / @bnoordhuis
* iojs: introduce internal modules [#848](https://github.com/nodejs/io.js/issues/848) / @chrisdickinson / @trevnorris / (@vkurchatkin)
* url: significantly improve the performance of the url module [#933](https://github.com/nodejs/io.js/issues/933) / @mikeal
* Ship websockets in core [#1010](https://github.com/nodejs/io.js/issues/1010) / @piscisaureus
* RFC: upgrade to V8 4.2? [#1026](https://github.com/nodejs/io.js/issues/1026) / @bnoordhuis
* Colin resigning from TC [#1056](https://github.com/nodejs/io.js/pull/1056)

### [#1134](https://github.com/nodejs/io.js/pull/1134) Add Docker working group

* Rod: originally conceived to be a “sub-WG” of Build WG but this makes sense because there is little overlap with the Build team or skills required for the Build team.
* Rod: this group is already maintaining official Docker images or io.js located at https://github.com/nodejs/docker-iojs which are also the “official” Docker images for io.js.

### [#1140](https://github.com/nodejs/io.js/pull/1140) Revert stream base / @piscisaureus / merge policy questions

* Bert: in favour of stream_base now and don’t want it reverted given the fixes that have been made. The real problem was the introduction of a major change that lead to a lot of breakage and a lot of fix commits. Proposed that we have a “ng” (or similar) branch with releases for testing before merging.
* Chris: agree that we need a canary policy of some kind to deal with this
* Bert: feature flags are a good way of dealing with this and letting them test changes
* Ben: time-based releases like Rust and Chrome
* Fedor: main problem is that we didn’t have enough tests for this feature when it was merged.
* Rod: there’s awkwardness around releasing given that we only have one tip and we can’t cut patch releases once we have semver-minor changes are merged.
* Trevor: should have semver-minor branches where patch fixes go in and minor changes go in to master/whatever.
* Discussion about git process
* Discussion about semver
* Discussion about minor/patch and what it communicates
* Discussion about test coverage
* Rod asked OpenSSL fix: agreed to punt on a release until OpenSSL fix has been released and go immediately after that.

### [#1130](https://github.com/nodejs/io.js/pull/1130) Nominating Jeremiah Senkpiel @Fishrock123 to the TC

* Rod: there was some off-record discussion about TC membership process related to #1130 and #1131.
  - Neither individual was asked and it would be good to at least have it passed by them first
  - Would be good to have a smooth on-boarding mechanism to bringing someone on to meetings before officially making them TC, agreed to invite Jeremiah to next TC _if_ he’s interested in being involved.
  - Generally agreed that increasing the size of the TC is a good thing (minus the meeting-overhead added by more people)

### [#1077](https://github.com/nodejs/io.js/pull/1077) Pass args to process.nextTick() / @trevnorris

* Trevor: passing arguments / context through process.nextTick() in core is common and would be significantly faster if we use a setArgs() feature.
* Chris: needed in readable-stream
* Discussed API concerns and how underscored methods still become defacto in userland
* Chris: could land the internal-module PR and use a Symbol for setArg
* Trevor: major speed increase comes from flattening the call-structure, there’s no additional stack entries for passing arguments. Particularly in crypto, nextTick() is called a lot.
* Rod: we need perf numbers from a user-experience perspective, perhaps that will make it more compelling to merge or perhaps it will make this look trivial that it’s not worth the cost of introducting ugly API
* Trevor: will go off and come back with numbers

### Major version bump

* Ben: proposed making a new integration branch to merge all of the semver-minor features, plus a V8 upgrade, we can start pushing out nightly-style releases for playing around and punt the decision on _how_ to do a major release down the road a little.
* Group agreed, Rod agreed to help come up with a release mechanism for nightlies to couple with this.

### Next meeting

* 25th March 2015
