local  en = {
   welcome = "Welcome",
   version = "Your version is %{vers}.",
   error = "Error",
   warning = "Warning",
   host = "Host %{host}",
   hour = "Hour",
   day = "Day",
   week = "Week",
   month = "Month",
   time = "Time",
   sent = "Sent",
   received = "Received",
   difference = "Difference",
   total = "Total",
   today = "Today",
   actions = "Actions",
   delete = "Delete",
   undo = "Undo",
   empty = "Empty",
   clone = "Clone",
   from = "from",
   protocol = "Protocol",
   port = "Port",
   ports = "Ports",
   max_rate = "Max Rate",
   duration = "Duration",
   traffic = "Traffic",
   packets = "Packets",
   broadcast_traffic = "Broadcast Traffic",
   save = "Save",
   close = "Close",
   remove = "Remove",
   save_settings = "Save Settings",
   save_configuration = "Save Configuration",
   all = "All",
   define = "Define",
   traffic_policy = "Traffic Policy",
   unlimited = "&infin;",
   bytes = "Bytes",
   packets = "Packets",
   flow = "Flow",
   flows = "Flows",
   talkers = "Talkers",
   protocols = "Protocols",
   overview = "Overview",
   unknown = "Unknown",
   ssl_certificate = "SSL Certificate",
   tcp_flags = "TCP Flags",
   any = "any",
   interface_ifname = "Interface %{ifname}",
   ip_address = "IP Address",
   info = "Info",
   os = "Operating System",
   ipv4 = "IPv4",
   ipv6 = "IPv6",
   application = "Application",
   applications = "Applications",
   key = "Key",
   client = "Client",
   server = "Server",
   begin = "Begin",
   ["end"] = "End",
   status = "Status",
   vlan = "VLAN",
   breakdown = "Breakdown",
   interface = "Interface",
   other = "Other",
   name = "Name",
   bridge = "Bridge",
   mtu = "MTU",
   speed = "Speed",
   pkts = "Pkts",
   icmp = "ICMP",
   arp = "ARP",
   percentage = "Percentage",
   previous = "Previous",
   ["next"] = "Next",
   abort = "Abort",
   chart = "Chart",
   ingress = "Ingress",
   egress = "Egress",
   mac_address = "MAC Address",
   as_number = "AS number",
   asn = "ASN",
   as = "AS",
   peers = "Peers",
   activities = "Activities",
   dns = "DNS",
   http = "HTTP",
   similarity = "Similarity",
   quotas = "Quotas",
   l7_protocol = "L7 Protocol",
   l7_protocols = "L7 Protocols",
   activity = "Activity",
   ["os"] = "OS",
   download = "Download",
   notes = "NOTES:",
   aggregation = "Aggregation",
   refresh = "Refresh",
   l4_protocol = "L4 Protocol",
   l4_protocols = "L4 Protocols",
   throughput = "Throughput",
   seen_since = "Seen Since",
   language = "Language",
   remote_networks = "Remote Networks",

   locales = {
      en = "English",
      it = "Italian",
      jp = "Japanese",
   },

   graphs = {
      arp_requests = "ARP Requests",
      arp_replies = "ARP Replies",
      packet_drops = "Packet Drops",
      active_flows = "Active Flows",
      active_hosts = "Active Hosts",
      active_devices = "Active Devices",
      active_http_servers = "Active HTTP Servers",
      zmq_received_flows = "ZMQ Received Flows",
      tcp_packets_lost = "TCP Packets Lost",
      tcp_packets_ooo = "TCP Packets Out-Of-Order",
      tcp_packets_retr = "TCP Retransmitted Packets",
      tcp_retr_ooo_lost = "TCP Retransmitted Out-Of-Order and Lost",
      tcp_syn_packets = "TCP SYN Packets",
      tcp_synack_packets = "TCP SYN+ACK Packets",
      tcp_finack_packets = "TCP FIN+ACK Packets",
      tcp_rst_packets = "TCP RST Packets",
      average_traffic = "Average Traffic/sec",
      top_senders = "Top Senders",
      top_receivers = "Top Receivers",
      top_profiles = "Top Profiles",
      all_ndpi_protocols  = "All Applications",
      all_ndpi_categories = "All Categories",
      note_click_to_zoom = "Left-click on the chart to zoom in, right-click to zoom out.",
      note_protocols_shown = "Protocols not seen in the selected timeframe are not listed in the dropdown.",
      note_ases_traffic = "Traffic shown is sent and received by the autonomous system.",
      note_ases_sent = "Traffic sent is the traffic sent by the autonomous system.",
      note_ases_rcvd = "Traffic received the traffic received by the autonomous system.",
   },

   flows_page = {
      recently_active_flows = "Recently Active %{filter} Flows",
      active_flows = "Active %{filter} Flows",
      flows = "%{filter} Flows",
      network = " [ Network %{network} ]",
      local_only = "Local Only",
      remote_only = "Remote Only",
      local_cli_remote_srv = "Local Client - Remote Server",
      local_srv_remote_cli = "Local Server - Remote Client",
      all_hosts = "All Hosts",
      hosts = "Hosts",
      direction = "Direction",
      all_flows = "All Flows",
      one_way_multicast = "One-Way Multicast/Broadcast",
      one_way_non_multicast = "One-Way Non-Multicast/Non-Broadcast",
      multicast = "Multicast/Broadcast",
      non_multicast = "Non-Multicast/Non-Broadcast",
      normal = "Normal",
      alerted = "Alerted",
      blocked = "Blocked",
      all_proto = "All Proto",
      ip_version = "IP Version",
      all_ip_versions = "All Versions",
      ipv4_only = "IPv4 Only",
      ipv6_only = "IPv6 Only",
      device_ip = "Flow Exporter",
      all_devices = "All Flow Exporters",
      inIfIdx = "Input Interface",
      all_inIfIdx = "All Input Interfaces",
      outIfIdx = "Output Interface",
      all_outIfIdx = "All Output Interfaces",
      vlan = "VLAN",
      all_vlan_ids = "All VLANs",
      client_as = "Client AS",
      server_as = "Server AS",
      all_ases = "All ASes",
      actual_throughput = "Actual Thpt",
      total_bytes = "Total Bytes",
      applications = "Applications",
      l4_proto = "L4 Proto",
      source_id = "Source Id",
   },

   traffic_report = {
      daily = "Daily",
      weekly = "Weekly",
      monthly = "Monthly",
      header_daily = "Daily report",
      header_weekly = "Weekly report",
      header_monthly = "Monthly report",
      current_day = "Current Day",
      current_week = "Current Week",
      current_month = "Current Month",
      previous_day = "Previous Day",
      previous_week = "Previous Week",
      previous_month = "Previous Month",
   },

   report = {
      period = "Interval",
      begin_date_time = "Begin Date/Time",
      end_date_time = "End Date/Time",
      date = "%{month}-%{day}-%{year}",
      generate = "Generate",
      invalid_begin_date = "Invalid Begin Date",
      please_check_format = "please check its format",
      please_choose_valid = "please choose a valid begin/end date and time",
      invalid_begin_end = "Invalid Begin/End",
      invalid_begin = "Invalid Begin",
      please_choose_valid_date_and_time = "please choose a valid date and time",
      invalid_to = "Invalid To",
      traffic_report = "Traffic Report",
      starting = "Starting",
      network_interface = "Network Interface",
      report_for_subject = "Report - %{num_min} - for %{subject} starting %{dt}",
      filter_report = "Filter Report",
      toggle_all = "Toggle All",
      submit_filter = "Submit Filter",
      application_breakdown = "Application Breakdown",
      local_networks = "Local Networks",
      local_remote = "Local/Remote",
      remote_local = "remote/local",
      total_traffic = "Total Traffic",
      applications = "Applications",
      top_talkers = "Top Talkers",
      top_countries = "Top Countries",
      top_local_hosts = "Top Local Hosts",
      top_remote_hosts = "Top Remote Hosts",
      top_local_os = "Top Local OS",
      top_non_local_os = "Top Non-Local OS",
      top_asn = "Top ASN",
      top_networks = "Top Networks",
      reports_professional_only = "Reports are only available in the Professional version",
      senders = "Senders",
      receivers = "Receivers",
   },

   topk_heuristic = {
      precision = {
	 disabled = "Disabled",
	 more_accurate = "More Accurate",
	 less_accurate = "Less Accurate",
	 aggressive = "Aggressive",
      },
   },

   shaping = {
      protocols = "Protocols",
      manage_policies = "Manage Policies",
      bandwidth_manager = "Bandwidth Manager",
      shaper0_message = "Shaper 0 is the default shaper used for local hosts that have no shaper defined",
      set_max_rate_to = "Set max rate to",
      for_no_shaping = "for no shaping",
      for_dropping_all_traffic = "for dropping all traffic",
      protocols_policies = "Protocols Policies",
      select_to_clone = "Select an existing network to clone the protocol rules from",
      initial_empty_protocols = "Initial protocols rules will be empty",
      initial_clone_protocols = "Initial protocol rules will be cloned",
      shaper_id = "Shaper Id",
      applied_to = "Applied to",
      notes = "NOTES",
      shapers_in_use_message = "Shapers can be deleted only if they are not applied to any network",
      no_shapers_available = "No shapers available",
      protocol_families = "Protocol Families",
      traffic_to = "Traffic to",
      traffic_from = "Traffic from",
      protocol_policy = "Traffic Policy",
      daily_traffic_quota = "Daily Traffic Quota",
      daily_time_quota = "Daily Time Quota",
      daily_traffic = "Daily Traffic (Current / Quota)",
      no_quota_data = "No quota set",
      no_quota_applied = "No Quota",
      daily_time = "Daily Time (Current / Quota)",
      delete_policy = "Delete Policy",
      confirm_delete_policy = "Do you really want to delete",
      policy_from_pool = "policy from pool",
      delete_shaper = "Delete Shaper",
      confirm_delete_shaper = "Do you really want to delete shaper ",
      note_drop_core = "Dropping some core protocols can have side effects on other protocols. For instance if you block DNS,<br>symbolic host names are no longer resolved, and thus only communication with numeric IPs work.",
      note_default_pool_config = "Policies and quotas only apply to user-defined host pools. Select a different pool or create a new one <a href='%{url}'>here</a>.",
      note_quota_unlimited = "Set Traffic and Time Quota to 0 for unlimited traffic.",
      note_target_type = "You can modify what to show into the Target column via the Policy Target Type field in the <a href=\"%{url}\">Traffic Briding preferences</a> expert view.",
      note_traffic_categories = "You can configure the Traffic Categories from the <a href=\"%{url}\">applications page</a>.",
      see_quotas_here = "Visit the host pool <a href='%{url}'>quotas page</a> for the full overview of the active host pool quotas.",
      no_quota_traffic = "No quota related traffic so far",
      delete_all_policies = "Delete all Policies",
      confirm_delete_all_policies = "Do you really want ot delete all the \"%{pool_name}\" pool policies",
   },

   alert_messages = {
      open_files_limit_too_small = "Ntopng detected that the maximum number of files MySQL can open is potentially too small. "..
	 "This can result in flow data loss due to errors such as "..
	 "[Out of resources when opening file './ntopng/flowsv6#P#p22.MYD' (Errcode: 24 - Too many open files)][23]. "..
	 "Make sure to increase open_files_limit or, if you just want to ignore this warning, disable the check from the preferences.",

      -- Add here new alert entity formattings, lower case
      host_entity = "host %{entity_value}",
      interface_entity = "interface %{entity_value}",
      network_entity = "network %{entity_value}",
   },

   show_alerts = {
      alerts = "Alerts",
      engaged_alerts = "Engaged Alerts",
      past_alerts = "Past Alerts",
      flow_alerts = "Flow Alerts",
      older_5_minutes_ago = "older than 5 minutes ago",
      older_30_minutes_ago = "older than 30 minutes ago",
      older_1_hour_ago = "older than 1 hour ago",
      older_1_day_ago = " older than 1 day ago",
      older_1_week_ago = "older than 1 week ago",
      older_1_month_ago = "older than 1 month ago",
      older_6_months_ago = "older than 6 months ago",
      older_1_year_ago = "older than 1 year ago",
      alert_actions = "Actions",
      alert_severity = "Severity",
      alert_type = "Alert Type",
      alert_datetime = "Date/Time",
      alert_duration = "Duration",
      alert_description = "Description",
      alert_counts = "Counts",
      last_minute = "Last Minute",
      last_hour = "Last Hour",
      last_day = "Last Day",
      delete_alerts_configuration = "Delete Alerts Configuration",
      delete_config_btn = "Delete Local %{conf}s Common Configuration",
      delete_config_message = "Do you really want to delete the common %{granularity} alerts configuration of local %{conf}s",
      delete_all = "Delete All",
      iface_delete_config_btn = "Delete Interface %{iface} Configuration",
      iface_delete_config_confirm = "Do you really want to delete the %{granularity} alerts configuration for interface",
      network_delete_config_btn = "Delete Network %{network} Configured Alerts",
      network_delete_config_confirm = "Do you really want to delete the %{granularity} alerts configuration for network",
      host_delete_config_btn = "Delete Host %{host} Configured Alerts",
      host_delete_config_confirm = "Do you really want to delete the %{granularity} alerts configuration for host",
      explorer = "Explore",
      purge_num_alerts = "Purge [%{num_alerts} alerts]",
      delete_alert = "Delete Alert",
      confirm_delete_alert = "Do you really want to delete the specified alert",
      reset_alert_database = "Flush Alerts Data",
      reset_alert_database_message = "This action will remove any alerts related data, including<ul>"..
            "<li>Runtime alerts status</li>"..
            "<li>Alerts configuration</li>"..
            "<li>Persistent alerts SQLite storage</li>"..
            "</ul><br>Do you really want to proceed",
      flush_data = "Flush Data",
      minute = "Minute",
      five_minutes = "Five minutes",
      hourly = "Hourly",
      daily = "Daily",
      startup = "Startup",
      no_recorded_alerts_message = "No recorded alerts for interface %{ifname}",
      alerts_are_disabled_message = "Alerts are disabled. Please check the preferences page to enable them.",
   },

   alerts_dashboard = {
      flow_alert_origins  = "Flow Alert Origins",
      flow_alert_targets  = "Flow Alert Targets",
      engaged_for_longest = "Past Alerts Engaged for Longest",
      starting_on = "starting on",
      total_alerts = "Total Alerts",
      no_alerts = "No alerts",
      not_engaged = "Not engaged",

      trailing_msg = "Time Window",
      one_min = "Last Minute",
      five_mins = "Last 5 Minutes",
      one_hour = "Last Hour",
      one_day = "Last Day",

      involving_msg = "Flow Alerts Involving",
      all_hosts = "All Hosts",
      local_only = "Local Hosts Only",
      remote_only = "Remote Hosts Only",
      local_origin_remote_target = "Local Origin - Remote Target",
      remote_origin_local_target = "Remote Origin - Local Target",

      search_criteria = "Dashboard Settings",
      submit = "Update Dashboard",

      alert_severity = "Severity",
      alert_type = "Type",
      alert_duration = "Duration",
      alert_counts = "Counts",
      custom_period = "Custom Period",
      last_minute = "Last Minute",
      last_hour = "Last Hour",
      last_day = "Last Day"
   },

   flow_alerts_explorer = {
      label = "Flow Alerts Explorer",
      flow_alert_origin  = "Alert Origin",
      flow_alert_target  = "Alert Target",

      type_explorer = "Type Explorer",
      type_alerts_by_type = "Flow Alerts By Type",
      by_target_port = "By Target Port",
      origins = "Origins",
      targets = "Targets",

      visual_explorer = "Visual Explorer",
      search = "Search Flow Alerts",

      summary_total = "Total Flow Alerts",
      summary_n_origins = "Total Origins",
      summary_n_targets = "Total Targets",
      summary_cli2srv = "Total Origin to Target Traffic",
      summary_srv2cli = "Total Target to Origin Traffic"
   },

   db_explorer = {
      observation_period = "Observation Period",
      client_server_host = "Client/Server Host",
      application_protocol = "Application Protocol",
      search_flows = "Search Flows",
      pcaps = "Pcaps",
      unable_to_find_flow = "Unable to find the specified flow",
      flow_peers = "Flow Peers",
      vlan_id = "VLAN Id",
      first_last_seen = "First / Last Seen",
      client_server_breakdown = "Client vs Server Traffic Breakdown",
      this_flow_has_been_reset = "This flow has been reset and probably the server application is down",
      this_flow_is_completed = "This flow is completed and will soon expire",
      this_flow_is_active = "This flow is active",
      network_latency_breakdown = "Network Latency Breakdown",
      ms_client = "%{client} ms (client)",
      ms_server = "%{server} ms (server)",
      http_method = "HTTP Method",
      server_name = "Server Name",
      response_code = "Response Code",
      http_host = "HTTP Host",
      dns_query = "DNS Query",
      interface_name = "Instance Name",
      selected_saved = "Select saved",
      extract_pcap = "Extract pcap",
      request_failed = "Request failed",
      ok_request_sent = "OK, request sent",
      all = "all",
      unsave = "Remove",
      application_flows = "Application flows",
      talkers_with_this_host = "Talkers with this host",
      host_name = "Host Name",
      traffic_sent = "Traffic Sent",
      traffic_received = "Traffic Received",
      total_traffic = "Total Traffic",
      total_packets = "Total Packets",
      query_in_progress = "Database query in progress, waiting to receive results...",
      abort = "Abort",
      total_flows = "Total Flows",
      total_packets = "Total Packets",
      traffic_rate = "Average Traffic Rate",
      packet_rate = "Average Packet Rate",
      summary = "Summary",
      applications_between = "Applications between %{peer1} and %{peer2}",
      host_talkers = "%{host} talkers",
      app_talkers = "%{app} talkers",
      app_talkers_with = "%{app} talkers with %{peer}",
      app_flows_between = "%{app} application flows between %{peer1} and %{peer2}",
      traffic_volume = "Traffic Volume",
      protocol_id = "Protocol id",
      l4_proto = "L4 Proto",
      average_throughput = "Avg Thpt",
      pcap_requests_and_status = "Pcap Requests and Statuses",
      task_id = "Task Id",
      filter_bpf = "Filter (BPF)",
      top_proto_ipv4_flows = "Top %{proto} IPv4 Flows",
      top_proto_ipv6_flows = "Top %{proto} IPv6 Flows",
      top_flows_ipv4 = "Top IPv4 Flows [%{date_from} - %{date_to}]",
      top_flows_ipv6 = "Top IPv6 Flows [%{date_from} - %{date_to}]",
      app_between_talkers_pairs = "applications between pairs of talkers",
      protocol_flows_between = "%{proto} protocol flows between %{peer1} and %{peer2}",
      get_proto_talkers = "Get Talkers using this protocol",
      hosts_talking_proto_with = "Hosts talking %{proto} with {host}",
      last_hour_flows = "Flows seen in the last hour",
      download_flows = "Download flows",
      empty_query_response = "Empty query response (database down or query killed/timed out?)",
   },

   traffic_profiles = {
      edit_traffic_profiles = "Edit Traffic Profiles",
      traffic_filter_bpf = "Traffic Filter (nBPF Format)",
      profile_name = "Profile Name",
      no_profiles = "No profiles set",
      note = "Note",
      http_traffic = "HTTP",
      host_traffic = "Host",
      facebook_traffic = "Facebook",
      see_ndpi_protos = "(use %{option} to print all nDPI supported protocols)",
      destination_network = "Destination network",
      simple_filter_examples = "Simple Filters Examples",
      advanced_filter_examples = "Advanced Filters Examples",
      traffic_between = "Traffic between hosts",
      traffic_from_to = "Traffic from an host to another",
      host_http_https = "Host HTTP/HTTPS",
      source_ethernet = "Source MAC address",
      note_0 = "Traffic profile names allow alpha-numeric characters, spaces, and underscores",
      note_1 = "Traffic profiles are applied to flows. Each flow can have up to one profile, thus in case of multiple profile matches, only the first one is selected",
      enter_profile_name = "Enter a profile name",
      enter_profile_filter = "Enter the profile filter",
      invalid_bpf = "Invalid BPF filter",
      duplicate_profile = "Duplicate profile name",
      delete_profile = "Delete Profile",
      confirm_delete_profile = "Do you really want to delete the profile",
      max_profiles_num = "With this version of ntopng you can only create %{maxnum} profiles. Upgrade to the enterprise version to remove this limit",
   },

   host_pools = {
      edit_host_pools = "Edit Host Pools",
      pool = "Pool Name",
      manage_pools = "Manage Pool Membership",
      create_pools = "Manage Pools",
      empty_pool = "Empty Pool",
      delete_pool = "Delete Pool",
      remove_member = "Remove Member",
      pool_name = "Pool Name",
      no_pools_defined = "No Host Pools defined.",
      create_pool_hint = "You can create new pools from the Manage Pools tab.",
      member_address = "Member Address",
      specify_pool_name = "Specify a pool name",
      specify_member_address = "Specify an IPv4/IPv6 address or network or a MAC address",
      invalid_member = "Invalid member address format",
      duplicate_member = "Duplicate member address",
      duplicate_pool = "Duplicate pool name",
      confirm_delete_pool = "Do you really want to delete host pool",
      confirm_remove_member = "Do you really want to remove member",
      confirm_empty_pool = "Do you really want to remove all members from the host pool",
      from_pool = "from host pool",
      and_associated_members = "its RRD data and any associated members",
      search_member = "Search Member",
      network_normalized = "network \"%{network}\" has a non-zero host identifier. Using \"%{network_normalized}\".",
      member_exists = "member \"%{member_name}\" not added. It is already assigned to pool \"%{member_pool}\".",
      children_safe = "Safe Search",
      enforce_quotas_per_pool_member = "Per-Member Quotas",
      enforce_shapers_per_pool_member = "Per-Member Shapers",
      alias_or_manufacturer = "Alias / Manufacturer",
      manufacturer_filter = "Manufacturer: %{manufacturer}",
      member_filter = "Member: %{member}",
      view = "View",
      change_pool = "Switch Pool",
      new_pool = "New Pool",
      change_member_pool = "Change Member Pool",
      select_new_pool = "Select a new pool from the dropdown below to assign member \"%{member}\" to:",
      max_pools_message = "With this version of ntopng you can only create %{maxnum} host pools. Upgrade to the enterprise version to remove this limit.",
      max_members_message = "With this version of ntopng you can only assign %{maxnum} members per host pool. Upgrade to the enterprise version to remove this limit.",
      members_limit_reached = "members limit reached",
      cannot_delete_cp = "A pool cannot be deleted if there is any Captive Portal user associated",
      per_member_quotas = "When the per-member quotas option is set, each host will have a separate quota count. When unset, all the hosts traffic will count as a whole to the quota limit",
      per_member_shapers = "When the per-member shapers option is set, each host will its own shapers. When unset, all the hosts belonging to the same pool will share the same shapers",
   },

   discover = {
      network_discovery = "Network Discovery",
      network_discovery_datetime = "Last Network Discovery",
      err_unable_to_arp_discovery = "Unable to start ARP network discovery",
      device = "Device",
      network_discovery_not_enabled = "A network discovery is in progress. The page will refresh periodically.",
      error_unable_to_decode_json = "Unable to decode cache JSON discovery data.",
      error_no_discovery_cached = "No discovery data has been cached yet.",
   },

   snmp = {
      snmp_device = "SNMP Device",
      view_device = "View Device",
      snmp_interface = "SNMP Interface",
      note = "NOTE",
      bound_interface_description = "Binding a network interface to an SNMP interface is useful to compare network traffic monitored by ntopng with that reported by SNMP",
   },

   dashboard = {
      top_local_talkers = "Top Local Talkers",
      actual_traffic = "Actual Traffic",
      realtime_app_traffic = "Realtime Top Application Traffic",
      realtime_traffic = "Network Interfaces: Realtime Traffic",
      top_remote_destinations = "Top Remote Destinations",
      lastday_app_traffic = "Top Application Traffic Last Day View",
      lastday_traffic = "Network Interfaces: Last Day View",
   },

   about = {
      about = "About",
      licence = "License",
      cpu_load = "CPU load",
      ram_memory = "RAM",
      version = "Version",
      licence_generation = "Click on the above URL to generate your professional version license, or <br>purchase a license at <a href=\"%{purchase_url}\">e-shop</a>. If you are no-profit, research or an education<br>institution please read <a href=\"%{universities_url}\">this</a>.",
      specify_licence = "Specify here your ntopng License",
      save_licence = "Save Licence",
      built_on = "Built on",
      maxmind = "This product includes GeoLite data created by <a href=\"%{maxmind_url}\">MaxMind</a>.",
      system_id = "System Id",
      runtime_status = "Runtime Status",
      platform = "Platform",
      startup_line = "Startup Line",
      last_log = "Last Log Trace",
   },

   prefs = {
      expert_view = "Expert View",
      simple_view = "Simple View",
      search_preferences = "Search Preferences",
      authentication = "Authentication",
      multiple_ldap_authentication_title = "Authentication Method",
      multiple_ldap_authentication_description = "Local (Local only), LDAP (LDAP server only), LDAP/Local (Authenticate with LDAP server, if fails it uses local authentication).",
      multiple_ldap_account_type_title = "LDAP Accounts Type",
      multiple_ldap_account_type_description = "Choose your account type",
      ldap_server_address_title = "LDAP Server Address",
      ldap_server_address_description = "IP address and port of LDAP server (e.g. ldaps://localhost:636). Default: \"ldap://localhost:389\".",
      user_authentication = "User Authentication",
      network_interfaces = "Network Interfaces",
      cache_settings = "Cache Settings",
      timeseries = "Timeseries",
      mysql = "MySQL",
      external_alerts = "External Alerts Report",
      protocols = "Protocols",
      flow_database_dump = "Flow Database Dump",
      snmp = "SNMP",
      nbox_integration = "nBox Integration",
      network_discovery = "Network Discovery",
      misc = "Misc",
      traffic_bridging = "Traffic Bridging",
      dynamic_network_interfaces = "Dynamic Network Interfaces",
      zmq_interfaces = "ZMQ Interfaces",
      dynamic_interfaces_creation_title = "Disaggregation Criterion",
      dynamic_interfaces_creation_description = "ntopng can use a criterion to disaggregate incoming traffic. "..
        "When a disaggregation criterion is selected, ntopng will use the criterion value to divert incoming traffic to dynamically-created interfaces. "..
        "For example, when the VLAN Id criterion is selected, a dynamic interface will be created for each VLAN Id observed, "..
	"and the incoming traffic will be diverted to one dynamic interface depending the VLAN Id value. ",
      dynamic_interfaces_creation_note_0 = "VLAN Id disaggregation is supported both for physical interfaces as well as for flows received over ZMQ. The other disaggregation criteria are only supported for ZMQ flows and will be ineffective for physical interfaces.",
      dynamic_interfaces_creation_note_1 = "Criterion changes will not affect existing interfaces.",
      dynamic_interfaces_creation_note_2 = "When using the Ingress Interface criterion on non-sflow devices, %%INPUT_SNMP must appear into the nprobe template.",
      toggle_src_with_post_nat_src_title = "Use Post-Nat Source IPv4 Addresses and Ports",
      toggle_src_with_post_nat_src_description = "Replace IPv4 source addresses (%%IPV4_SRC_ADDR) and ports (%%L4_SRC_PORT) with their post-nat values (%%POST_NAT_SRC_IPV4_ADDR and %%POST_NAPT_SRC_TRANSPORT_PORT).",
      toggle_dst_with_post_nat_dst_title = "Use Post-Nat Destination IPv4 Addresses and Ports",
      toggle_dst_with_post_nat_dst_description = "Replace IPv4 destination addresses (%%IPV4_DST_ADDR) and ports (%%L4_DST_PORT) with their post-nat values (%%POST_NAT_DST_IPV4_ADDR and %%POST_NAPT_DST_TRANSPORT_PORT).",
      idle_timeout_settings = "Idle Timeout Settings",
      local_host_max_idle_title = "Local Host Idle Timeout",
      local_host_max_idle_description = "Inactivity time after which a local host is considered idle (sec). "..
            "Idle local hosts are dumped to a cache so their counters can be restored in case they become active again. "..
            "Counters include, but are not limited to, packets and bytes total and per Layer-7 application. "..
            "Default: 5 min.",
      non_local_host_max_idle_title = "Remote Host Idle Timeout",
      non_local_host_max_idle_description = "Inactivity time after which a remote host is considered idle. Default: 1 min.",
      flow_max_idle_title = "Flow Idle Timeout",
      flow_max_idle_description = "Inactivity time after which a flow is considered idle. Default: 1 min.",
      housekeeping_frequency_title = "Hosts Statistics Update Frequency",
      housekeeping_frequency_description = "Some host statistics such as throughputs are updated periodically. "..
            "This timeout regulates how often ntopng will update these statistics. "..
            "Larger values are less computationally intensive and tend to average out minor variations. "..
            "Smaller values are more computationally intensive and tend to highlight minor variations. "..
            "Values in the order of few seconds are safe. " ..
	 "Default: 5 seconds.",
      interfaces_timeseries = "Interfaces Timeseries",
      local_hosts_timeseries = "Local Hosts Timeseries",
      l2_devices_timeseries = "Devices Timeseries",
      other_timeseries = "Other Timeseries",
      toggle_traffic_rrd_creation_title = "Traffic",
      toggle_traffic_rrd_creation_description = "Toggle the creation of bytes and packets timeseries.",
      toggle_ndpi_timeseries_creation_title = "Layer-7 Applications",
      toggle_ndpi_timeseries_creation_description = "Toggle the creation of Layer-7 application timeseries. Creating a timeseries per protocol requires more disk space and extra I/O and, in general, it is not needed.",
      toggle_flow_rrds_title = "Flow Devices",
      toggle_flow_rrds_description = "Toggle the creation of bytes timeseries for each port of the remote device as received through ZMQ (e.g. sFlow/NetFlow/SNMP).<br>"..
            "For non sFlow devices, %%INPUT_SNMP and %%OUTPUT_SNMP must appear into the nprobe template.",
      toggle_pools_rrds_title = "Host Pools",
      toggle_pools_rrds_description = "Toggle the creation of bytes and application protocols timeseries for defined host pools.",
      toggle_vlan_rrds_title = "VLANs",
      toggle_vlan_rrds_description = "Toggle the creation of bytes and application timeseries for VLANs.",
      toggle_asn_rrds_title = "Autonomous Systems",
      toggle_asn_rrds_description = "Toggle the creation of bytes and application timeseries for autonomous systems.",
      toggle_tcp_flags_rrds_title = "TCP Flags",
      toggle_tcp_flags_rrds_description = "Toggle the creation of TCP flags SYN, SYN+ACK, FIN+ACK and RST timeseries for network interfaces.",
      toggle_tcp_retr_ooo_lost_rrds_title = "TCP Out of Order, Lost and Retransmitted Segments",
      toggle_tcp_retr_ooo_lost_rrds_description = "Toggle the creation of timeseries for out-of-order, lost and retransmitted TCP segments. Timeseries will be created for network interfaces, autonomous systems, local networks and vlans.",
      local_hosts_cache_settings = "Local Hosts Cache Settings",
      toggle_local_host_cache_enabled_title = "Idle Local Hosts Cache",
      toggle_local_host_cache_enabled_description = "Toggle the creation of cache entries for idle local hosts. "..
            "Cached local hosts counters are restored automatically to their previous values "..
            " upon detection of additional host traffic.",
      toggle_active_local_host_cache_enabled_title = "Active Local Hosts Cache",
      toggle_active_local_host_cache_enabled_description = "Toggle the creation of cache entries for active local hosts. "..
            "Caching active local hosts periodically can be useful to protect host counters against "..
            "failures (e.g., power losses). This is particularly important for local hosts that seldomly go idle "..
            "as it guarantees that their counters will be cached after the specified time interval.",
      active_local_host_cache_interval_title = "Active Local Host Cache Interval",
      active_local_host_cache_interval_description = "Interval between consecutive active local hosts cache dumps. Default: 1 hour.",
      local_host_cache_duration_title = "Local Hosts Cache Duration",
      local_host_cache_duration_description = "Time after which a cached local host is deleted from the cache. Default: 1 hour.",
      databases = "Databases",
      minute_top_talkers_retention_title = "Top Talkers Storage",
      minute_top_talkers_retention_description = "Number of days to keep one minute resolution top talkers statistics. Default: 365 days.",
      rrd_files_retention_title = "Timeseries Retention",
      rrd_files_retention_description = "The maximum number of days non-updated timeseries are preserved before being deleted.",
      mysql_retention_title = "MySQL storage",
      mysql_retention_description = "Duration in days of data retention for the MySQL database. Default: 7 days.<br>MySQL is used to store exported flows data.<br>"..
            "Flows dump is only possible if the ntopng instance has been launched with option ",
      toggle_mysql_check_open_files_limit_title = "Enable MySQL alerts",
      toggle_mysql_check_open_files_limit_description = "Enable MySQL alerts generations due to periodic checks of MySQL open_files_limit.<br>"..
            "The open_files_limit check is useful to detect when the number of open MySQL files is high, which could lead to database insertion errors.",
      disable_alerts_generation_title = "Enable Alerts",
      disable_alerts_generation_description = "Toggle the overall generation of alerts.",
      toggle_flow_alerts_iface_title = "Enable Flow Alerts",
      toggle_flow_alerts_iface_description = "Enable flow alert generation when the network interface is alerted.",
      security_alerts = "Security Alerts",
      toggle_alert_probing_title = "Enable Probing Alerts",
      toggle_alert_probing_description = "Enable alerts generated when probing attempts are detected.",
      toggle_ssl_alerts_title = "Enable SSL Alerts",
      toggle_ssl_alerts_description = "Enable alerts generated when the SSL certificate provided by a server does not match the certificate Common Name.",
      toggle_dns_alerts_title = "Enable DNS Alerts",
      toggle_dns_alerts_description = "Enable alerts generated when the DNS query is invalid",
      toggle_malware_probing_title = "Enable Hosts Malware Blacklists",
      toggle_malware_probing_description = "Enable alerts generated by traffic sent/received by "..
            "<a href=\"%{url}\">malware-marked hosts</a>. Overnight new blacklist rules are refreshed.",
      alerts_retention = "Alerts Retention",
      max_num_alerts_per_entity_title = "Maximum Number of Alerts per Entity",
      max_num_alerts_per_entity_description = "The maximum number of alerts per alarmable entity. Alarmable entities are hosts, networks, interfaces. Alerts are checked periodically and, in case the actual number of alerts exceeds the maximum number for a given entity, oldest alerts will be deleted to preserve a number of alerts equal to the 80%% of the maximum configured number. "..
            "Default: 1024.",
      max_num_flow_alerts_title = "Maximum Number of Flow Alerts",
      max_num_flow_alerts_description = "The maximum number of flow alerts. Alerts are checked periodically and, in case the actual number of flow alerts exceeds the configured maximum number, oldest alerts will be deleted to preserve a number of alerts equal to the 80%% of the maximum configured number. Default: 16384.",
      internal_log = "Internal Log",
      toggle_alert_syslog_title = "Alerts On Syslog",
      toggle_alert_syslog_description = "Enable alerts logging on system syslog.",
      slack_integration = "Slack Integration",
      toggle_slack_notification_title = "Enable <a href=\"%{url}\">Slack</a> Notification",
      toggle_slack_notification_description = "Toggle the alert notification via slack. See integration instructions <a href='%{url}'>here</a>.",
      sender_username_title = "Notification Sender Username",
      sender_username_description = "Set the username of the sender of slack notifications",
      slack_webhook_title = "Notification Webhook",
      slack_webhook_description = "Send your notification to this slack URL",
      nagios_integration = "Nagios Integration",
      toggle_alert_nagios_title = "Send Alerts To Nagios",
      toggle_alert_nagios_description = "Enable sending ntopng alerts to Nagios NSCA (Nagios Service Check Acceptor).",
      nagios_nsca_host_title = "Nagios NSCA Host",
      nagios_nsca_host_description = "Address of the host where the Nagios NSCA daemon is running. Default: localhost.",
      nagios_nsca_port_title = "Nagios NSCA Port",
      nagios_nsca_port_description = "Port where the Nagios daemon's NSCA is listening. Default: 5667.",
      nagios_send_nsca_executable_title = "Nagios send_nsca executable",
      nagios_send_nsca_executable_description = "Absolute path to the Nagios NSCA send_nsca utility. Default: /usr/local/nagios/bin/send_nsca",
      nagios_send_nsca_config_title = "Nagios send_nsca configuration",
      nagios_send_nsca_config_description = "Absolute path to the Nagios NSCA send_nsca utility configuration file. Default: /usr/local/nagios/etc/send_nsca.cfg",
      nagios_host_name_title = "Nagios host_name",
      nagios_host_name_description = "The host_name exactly as specified in Nagios host definition for the ntopng host. Default: ntopng-host",
      nagios_service_name_title = "Nagios service_description",
      nagios_service_name_description = "The service description exactly as specified in Nagios passive service definition for the ntopng host. Default: NtopngAlert",
      toggle_top_sites_title = "Top HTTP Sites",
      toggle_top_sites_description = "Toggle the creation of top visited web sites for local hosts. Top sites are created using an <a href=\"%{url}\">heuristic</a> that maintain no more than 20 sites per local host. The heuristic fully operates in memory and does not require any interaction with the disk. Top sites are cleared every 5 minutes. An historical archive of top visited web sites can be created, for each local host, by periodically polling the JSON <i class=\"fa fa-download fa-sm\"></i> download link accessible from the host details page.",
      logging = "Logging",
      toggle_logging_level_title = "Log level",
      toggle_logging_level_description = "Choose the runtime logging level.",
      toggle_access_log_title = "Enable HTTP Access Log",
      toggle_access_log_description = "Toggle the creation of HTTP access log in the data dump directory. Settings will have effect at next ntop startup.",
      tiny_flows = "Tiny Flows Dump",
      toggle_flow_db_dump_export_title = "Tiny Flows Export",
      toggle_flow_db_dump_export_description = "Toggle the export of tiny flows, that are flows with few packets or bytes."..
            "Reducing flow cardinality in databases, speeds-up insert and searched. Tuning tiny flows can help to limit flow cardinality while not reducing visibility on dumped information.",
      max_num_packets_per_tiny_flow_title = "Maximum Number of Packets per Tiny Flow",
      max_num_packets_per_tiny_flow_description = "The maximum number of packets a flow must have to be considered a tiny flow. Default: 3.",
      max_num_bytes_per_tiny_flow_title = "Maximum Number of Bytes per Tiny Flow",
      max_num_bytes_per_tiny_flow_description = "The maximum number of bytes a flow must have to be considered a tiny flow. Default: 64.",
      toggle_snmp_rrds_title = "SNMP Devices Timeseries",
      toggle_snmp_rrds_description = "Toggle the creation of bytes timeseries for each port of the SNMP devices. For each device port" ..
	 " will be created an RRD with ingress/egress bytes.",
      default_snmp_community_title = "Default SNMP Community",
      default_snmp_community_description = "The default SNMP community is used when trying to walk the SNMP MIB of a selected local host that has not been configured through the SNMP devices page.",
      nbox_integration = "nBox Integration",
      toggle_nbox_integration_title = "Enable nBox Support",
      toggle_nbox_integration_description = "Enable sending ntopng requests (e.g., to download pcap files) to an nBox. Pcap requests are issued "..
            "from the historical data browser when browsing 'Talkers' and 'Protocols'. Each request carry information on the search criteria "..
            "generated by the user when drilling-down historical data. Requests are queued and pcaps become available for download from a dedicated 'Pcaps' tab once generated.",
      nbox_user_title = "nBox User",
      nbox_user_description = "User that has privileges to access the nBox. Default: nbox",
      nbox_password_title = "nBox Password",
      nbox_password_description = "Password associated to the nBox user. Default: nbox",

      toggle_network_discovery_title = "Active Network Discovery",
      toggle_network_discovery_description = "Toggle the periodic discovery of network devices using multiple techniques that include ARP scan, MDNS and SSDP.",
      network_discovery_interval_title = "Active Network Discovery Interval",
      network_discovery_interval_description = "Interval between consecutive discoveries of networks. Default: 15 min.",

      web_user_interface = "Web User Interface",
      toggle_autologout_title = "Auto Logout",
      toggle_autologout_description = "Toggle the automatic logout of web interface users with expired sessions.",
      google_apis_browser_key_title = "Google APIs Browser Key",
      google_apis_browser_key_description = "Graphical hosts geomaps are based on Google Maps APIs. Google recently changed Maps API access policies "..
            "and now requires a browser API key to be submitted for every request. Detailed information on how to obtain an API key "..
            "<a href=\"%{url}\">can be found here</a>. "..
            "Once obtained, the API key can be placed in this field.",
      report = "Report",
      toggle_thpt_content_title = "Throughput Unit",
      toggle_thpt_content_description = "Select the throughput unit to be displayed in traffic reports.",
      max_ui_strlen_title = "Maximum Displayed String Length",
      max_ui_strlen_description = "Shorten strings longer than the specified maximum number of characters.",
      topk_heuristic_precision_title = "Top-K Heuristic",
      topk_heuristic_precision_description = "Use an heuristic when aggregating historical top hosts, countries, etc, to build traffic reports. Useful when building reports over long-periods.",
      traffic_shaping = "Traffic Shaping",
      toggle_shaping_directions_title = "Split Shaping Directions",
      toggle_shaping_directions_description = "Enable this option to be able to set different shaping policies for ingress and egress traffic.",
      toggle_captive_portal_title = "Captive Portal",
      toggle_captive_portal_description = "Enable the web captive portal for authenticating network users.",
      captive_portal_url_title = "Redirection URL",
      captive_portal_url_description = "The URL your clients will be redirected to after a successful captive portal authentication.",
      captive_portal_disabled_message = "This button is <b>disabled</b> as the ntopng web GUI has NOT been started on port 80 that is required by the captive portal (-w command line parameter, e.g. -w 80,3000).",
      bind_dn_title = "LDAP Bind DN",
      bind_dn_description = "Bind Distinguished Name of LDAP server. Example:",
      bind_pwd_title = "LDAP Bind Authentication Password",
      bind_pwd_description = "Bind password used for authenticating with the LDAP server.",
      search_path_title = "LDAP Search Path",
      search_path_description = "Root path used to search the users.",
      user_group_title = "LDAP User Group",
      user_group_description = "Group name to which user has to belong in order to authenticate as unprivileged user.",
      admin_group_title = "LDAP Admin Group",
      admin_group_description = "Group name to which user has to belong in order to authenticate as an administrator.",
      toggle_ldap_anonymous_bind_title = "LDAP Anonymous Binding",
      toggle_ldap_anonymous_bind_description = "Enable anonymous binding.",
      slack_notification_severity_preference_title = "Notification Preference Based On Severity",
      slack_notification_severity_preference_description = "Errors (errors only), Errors and Warnings (errors and warnings, no info), All (every kind of alerts will be notified).",
      ingress_flow_interface = "Ingress Interface",
      ingress_vrf_id = "Ingress VRF Id",
      probe_ip_address = "Probe IP",
      vlan = "VLAN Id",
      none = "None",
      per_protocol = "Per Protocol",
      per_category = "Per Category",
      both = "Both",
      errors = "Errors",
      errors_and_warnings = "Errors and Warnings",
      all = "All",
      ldap = "LDAP",
      ["local"] = "Local",
      ldap_local = "LDAP/Local",
      posix = "Posix",
      samaccount = "sAMAccount",
      host_mask = "Mask Host IP Addresses",
      toggle_host_mask_title = "Mask Host IP Addresses",
      toggle_host_mask_description = "For privacy reasons it might be necessary to mask hosts IP addresses. For instance if you are an ISP you are not supposed to know which local addresses are accessing remote hosts.",
      no_host_mask = "Don't Mask Hosts",
      local_host_mask = "Mask Local Hosts",
      remote_host_mask = "Mask Remote Hosts",
      dns = "DNS",
      safe_search_dns_title = "Safe Search DNS",
      safe_search_dns_description = "The DNS server to be used to perform <a href='%{url}'>Safe Search</a> queries.<br>"..
            "Safe Search can be enabled for individual host pools from the host pools configuration page. Default: 208.67.222.123.",
      global_dns_title = "Global Primary DNS",
      global_dns_description = "A DNS server to redirect the clients DNS requests to for non Safe Search host pools. If empty, the redirection is disabled and the default DNS is used.",
      secondary_dns_title = "Global Secondary DNS",
      secondary_dns_description = "A fallback DNS server to use when the global primary DNS server is not available.",
      featured_dns_title = "Featured DNS Servers",
      featured_dns_description = "The following is a list of secure DNS servers. You can use them as a global DNS servers or as as safe search provider.",
      dns_service = "Service",
      primary_dns = "Primary DNS",
      secondary_dns = "Secondary DNS",
      quick_network_setup = "Quick Network Setup",
      network_mode = "Network Operational Mode",
      network_mode_description = "Specifying the operational mode of this network box",
      router_mode = "Router",
      transparent_bridge = "Transparent Bridge",
      network_mode_router = "<b>Router:</b> you need to <u>disable the DHCP on your router</u> and let this box dynamically assign IP addresses (DHCP) to local hosts and become their gateway. This box will use your router as gateway to the Internet, and thus it must have a static IP address configured in order to reach your router.",
      network_mode_bridge = "<b>Transparent Bridge</b>: your hosts will be connected to this box either using the embedded access point or through the optional ethernet interface and won't notice any change in IP address configuration.",
      policy_target_type = "Policy Target Type",
      policy_target_type_description = "Specify if you wish to set the policies on single protocols or on traffic categories",
   },

   entity_thresholds = {
      flow_attacker_title = "Flow Flood Attacker",
      flow_attacker_description = "Max number of sent flows/sec over which a host is considered a flooder",
      flow_victim_title = "Flow Flood Victim",
      flow_victim_description = "Max number of received flows/sec over which a host is considered under flood attack",
      syn_attacker_title = "SYN Flood Attacker",
      syn_attacker_description = "Max number of sent TCP SYN packets/sec over which a host is considered a flooder",
      syn_victim_title = "SYN Flood Victim",
      syn_victim_description = "Max number of received TCP SYN packets/sec over which a host is considered under SYN flood attack",
   },

   export_data = {
      export_data = "Export Host Data",
      hosts = "Hosts",
      all_hosts = "All",
      local_hosts = "Local",
      remote_hosts = "Remote",
      single = "Single",
      ip_or_mac_address = "IP or MAC Address",
      export_json_data = "Export JSON Data",
      note_maximum_number = "The maximum number of downloadable hosts is 32,768.",
      note_active_hosts = "Only active hosts are returned.",
   },

   if_stats_overview = {
      snmp = "SNMP",
      iface_switch_active_msg = "The selected interface <b>%{interface}</b> [ifid: %{ifid}] is now active",
      iface_switch_error_msg = "Error while switching interfaces",
      iface_switch_empty_session_msg = "Empty session",
      id = "Id",
      state = "State",
      active = "Active",
      paused = "Paused",
      remote_probe = "Remote Probe",
      interface_name = "Interface Name",
      interface_ip = "Interface IP",
      probe_ip = "Probe IP",
      public_probe_ip = "Public Probe IP",
      probe_timeout_lifetime = "Lifetime Timeout",
      probe_timeout_idle = "Idle Timeout",
      probe_zmq_num_flow_exports = "Exported Flows",
      probe_zmq_num_endpoints = "Active Probe ZMQ Endpoints",
      family = "Family",
      in_path_interface = "In-Path Interface (Bump in the Wire)",
      has_traffic_directions = "with RX/TX Directions",
      packet_dumper = "Packet Dumper",
      dumped_packets = "Dumped Packets",
      dumped_files = "Dumped Files",
      traffic_breakdown = "Traffic Breakdown",
      zmq_rx_statistics = "ZMQ RX Statistics",
      collected_flows = "Collected Flows",
      interface_rx_updates = "Interface RX Updates",
      sflow_counter_updates = "sFlow Counter Updates",
      zmq_message_drops = "ZMQ Message Drops",
      ingress_traffic = "Ingress Traffic",
      received_traffic = "Received Traffic",
      dropped_packets = "Dropped Packets",
      note = "NOTE",
      note_drops_sflow = "Drops are reported only for sFlow as NetFlow does not report them.<br>In <A HREF=https://www.ietf.org/rfc/rfc3176.txt>sFlow</A> drops are computed according to drops value part of the flow sample.",
      note_drop_ifstats_dynamic = "Drops are available in the main interface",
      flows_export_statistics = "Flows Export Statistics",
      exported_flows = "Exported Flows",
      dropped_flows = "Dropped Flows",
      reset_counters = "Reset Counters",
      all_counters = "All Counters",
      drops_only = "Drops Only",
      bridged_traffic = "Bridged Traffic",
      ingress_packets = "Ingress Packets",
      egress_packets = "Egress Packets",
      shaped_filtered_packets = "Shaped/Filtered Packets",
      send_error = "Send Error",
      buffer_full = "Buffer Full",
      note_packets = "In ethernet networks, each packet has an <A HREF=\"https://en.wikipedia.org/wiki/Ethernet_frame\">overhead of 24 bytes</A> [preamble (7 bytes), start of frame (1 byte), CRC (4 bytes), and <A HREF=\"http://en.wikipedia.org/wiki/Interframe_gap\">IFG</A> (12 bytes)]. Such overhead needs to be accounted to the interface traffic, but it is not added to the traffic being exchanged between IP addresses. This is because such data contributes to interface load, but it cannot be accounted in the traffic being exchanged by hosts, and thus expect little discrepancies between host and interface traffic values.",
   },

   packets_page = {
      tcp_packets_analysis = "TCP Packets Analysis",
      retransmissions = "Retransmissions",
      out_of_order = "Out of Order",
      lost = "Lost",
      size_distribution = "Size Distribution",
      tcp_flags_distribution = "TCP Flags Distribution",
      ip_version_distribution = "IP Version Distribution",
      sent_distribution = "Sent Distribution",
      arp_distribution = "ARP Distribution",
      received_distribution = "Received Distribution",
   },

   traffic_page = {
      no_traffic_observed_message = "No traffic has been observed for the specified host",
      l4_proto_overview = "L4 Protocol Overview",
      rcvd  = "Rcvd",
   },

   ports_page = {
      client_ports = "Client Ports",
      server_ports = "Server Ports",
   },

   peers_page = {
      top_peers_for_host = "Top %{hostkey} Peers",
      top_peer_protocol = "Top Peer Protocols",
      traffic_volume = "Traffic Volume",
      host = "Host",
      no_active_flows_message = "No active flows have been observed for the specified host",
   },

   ndpi_page = {
      live_flows_count = "Live Flows Count",
      note = "NOTE",
      note_live_flows_chart = "This chart depicts only TCP connections.",
      application_protocol = "Application Protocol",
      application_protocol_category = "Application Protocol Category",
      total_since_startup = "Total (Since Startup)",
      overview = "%{what} Overview",
      sent_only = "Sent only",
      received_only = "Received only",
      note = "NOTE",
      note_historical_per_protocol_traffic = "Historical %{what} traffic data can be enabled via ntopng <a href='%{url}'>%{flask_icon} Preferences</a>.",
      note_possible_probing_alert = "An icon like %{icon} indicates a possible probing (or application server down) alert as the host has received traffic for a specific application protocol without sending back any data. You can use <A HREF='%{url}'>historical reports</A> to drill-down this issue.",
      note_protocol_usage_time = "Protocol usage time is computed on discrete slot intervals.",
      unable_to_find_host = "Unable to find %{host_ip} (data expired ?)",
      sent = "Sent",
      rcvd = "Rcvd",
   },

   icmp_page = {
      icmp_message = "ICMP Message",
      last_sent_peer = "Last Sent Peer",
      last_rcvd_peer = "Last Rcvd Peer",
      packets_sent = "Packets Sent",
      packets_received = "Packets Received",
   },

   arp_page = {
      arp_type = "ARP Type",
   },

   packetdump_page = {
      packet_dump = "Packets Eligible for Dump",
      dump_all_traffic = "All Packets",
      dump_unknown_traffic = "Unknown Layer-7 Flows Packets",
      packet_dump_to_disk = "Packet Dump To Disk",
      dump_traffic_to_disk = "Dump Traffic To Disk",
      dump_traffic_to_disk_on_security_alert = "Dump Traffic To Disk On Security Alert",
      packet_dump_to_tap = "Packet Dump To Tap",
      dump_traffic_to_tap = "Packet Dump To Tap",
      num_dumped_packets = "%{num_pkts} packets dumped",
      packet_dump_to_tap_disabled_message = "Disabled. Please restart ntopng with --enable-taps",
      sampling_rate = "Sampling Rate",
      note = "NOTE",
      dump_to_disk_parameters = "Dump To Disk Parameters",
      pcap_dump_directory = "Pcap Dump Directory",
      max_packets_per_file = "Max Packets per File",
      max_packets_per_file_description = "Maximum number of packets to store on a pcap file before creating a new file.",
      max_duration_file = "Max Duration of File",
      max_duration_file_description = "Maximum pcap file duration before creating a new file.",
      note_max_duration_file = "a dump file is closed when it reaches first the maximum size or duration specified.",
      max_dump_files = "Max Total Size of Dump Files",
      max_size_dump_files_description = "Maximum total size of created pcap files, computed as the sum of the size of every pcap file.",
      note_max_size_dump_files = "Maximum total size is checked daily. Older dump files are deleted untile the current total size is below the configured threshold.",
   },

   activities_page = {
      host_activity = "Host Activity",
   },

   dns_page = {
      dns_breakdown = "DNS Breakdown",
      queries = "Queries",
      positive_replies = "Positive Replies",
      error_replies = "Error Replies",
      reply_breakdown = "Reply Breakdown",
      dns_query_sent_distribution = "DNS Query Sent Distribution",
      rcvd = "Rcvd",
      request_vs_reply = "Request vs Reply",
      ratio = "Ratio",
      replies = "Replies",
      note = "NOTE",
      note_dns_ratio = "Ideally the request vs reply DNS ratio should be 1 (one reply per request). When much lower than that then there are issues worth to be investigated as it means that the number of replies received is much lower than expected and this can indicate that we are using unresponsive DNS resolvers or that they are misconfigured (e.g. they have been move to another IP).",
   },

   http_page = {
      top_visited_sites = "Top Visited Sites",
      current_sites = "Current Sites",
      contacts = "Contacts",
      last_5_minutes_sites = "Last 5 Minute Sites",
      http_queries ="HTTP Queries",
      method = "Method",
      requests = "Requests",
      distribution = "Distribution",
      other_method = "Other Method",
      http_responses = "HTTP Responses",
      response_code ="Response code",
      responses = "Responses",
      response_code_1xx = "1xx (Informational)",
      response_code_2xx = "2xx (Success)",
      response_code_3xx = "3xx (Redirection)",
      response_code_4xx = "4xx (Client Error)",
      response_code_5xx = "5xx (Server Error)",
      virtual_hosts = "Virtual Hosts",
      traffic_sent = "Traffic Sent",
      traffic_received = "Traffic Received",
      requests_served = "Requests Served",
   },

   categories_page = {
      traffic_category = "Traffic Category",
      target = "Target",
      search_application = "Search Application",
   },

   snmp_page = {
      not_configured_as_snmp_device_message = "Host %{host_ip} has not been configured as an SNMP device.",
      guide_snmp_page_message = "Visit page <a href='%{url}'> SNMP</a> to add this host to the list of configured SNMP devices.",
      trying_to_retrive_message = "Trying to retrieve host SNMP MIB using the default community \'%{community}\'",
      showing_snmp_mib_info_default_community_message = "Showing SNMP MIB information retrieved using the default community \'%{community}\'",
      unable_to_retrive_snmp_default_community_message = "Unable to retrieve host SNMP MIB using the default community \'%{community}\'.",
   },

   contacts_page = {
      client_contacts_initiator = "Client Contacts (Initiator)",
      server_contacts_receiver = "Server Contacts (Receiver)",
      no_client_contacts_so_far = "No client contacts so far",
      server_address = "Server Address",
      contacts = "Contacts",
      no_server_contacts_so_far = "No server contacts so far",
      client_address = "Client Address",
      no_contacts_message = "No contacts for this host",
   },

   host_config = {
      host_alias = "Host Alias",
      host_pool = "Host Pool",
      trigger_host_alerts = "Trigger Host Alerts",
      trigger_alerts_for_host = "Trigger alerts for Host %{host}",
      dump_host_traffic = "Dump Host Traffic",
      dump_traffic = "Dump Traffic",
      dump_host_traffic_description = "Host traffic dump requires either \"%{to_disk}\" or \"%{to_tap}\" to be <A HREF=\"%{url}\"><i class='fa fa-sm fa-cog' aria-hidden='true'></i> enabled</A>.",
      host_traffic_policy = "Host Traffic Policy",
      drop_all_host_traffic = "Drop All Host Traffic",
      modify_host_pool_policy_btn = "Modify Host Pool Policy",
   },

   sprobe_page = {
      users = "Users",
      processes = "Processes",
      tree = "Tree",
      active_memory = "Active memory",
      latency = "Latency",
      top_users = "Top Users",
      top_processes = "Top Processes",
      processes_traffic_tree = "Processes Traffic Tree",
      show_more_info = "Mouse over to show the process information or double click to show more information.",
   },

   if_stats_config = {
      custom_name = "Custom Name",
      custom_name_popup_msg = "Specify an alias for the interface",
      interface_speed = "Interface Speed (Mbit/s)",
      interface_speed_popup_msg = "Specify the maximum interface speed",
      refresh_rate = "Realtime Stats Refresh Rate (sec)",
      refresh_rate_popup_msg = "Specify the stats refresh rate for the interface",
      scaling_factor = "Ingress Packets Sampling Rate",
      scaling_factor_popup_msg = "This should match your capture interface sampling rate",
      trigger_interface_alerts = "Trigger Interface Alerts",
      interface_rrd_creation = "Create Interface Timeseries",
      interface_network_discovery = "Periodic Interface Network Discovery",
   },

   bridge_wizard = {
      bridge_wizard = "Bridge Wizard",
      intro_1 = "This wizard will help you to setup some basic configuration to enable bridge specific features of ntopng. "..
            "You are going to configure the bridge interface <b>%{iface}</b>.",
      start = "Start",
      guests = "Guests",
      safe_search_guest = "Children",
      captive_portal_available = "The captive portal is <b>not running</b>.",
      captive_portal_running = "Note: the captive portal is <b>up and running</b>.",
      captive_portal_unavailable = "Note: the captive portal is <b>disabled</b>.<br>Add the -w command line parameter (e.g. -w 80,3000) to enable it.",
      warning_configuration_exist = "A bridge configuration already exists. It will be discarder after clicking the save button.",
      click_on_next = "Click on the Next button to proceed.",
      configure_host_pools = "Host Pools",
      host_pool_info = "An host pool represents an aggregation of network hosts.<br>You need to create an host pool to start applying traffic policies to it.",
      the_guests_pool = "A \"%{guests}\" pool, with p2p traffic blocked",
      the_children_pool = "The \"%{safe_search}\" pool, with <a target='_blank' href='%{url}'>Safe Search</a> enabled for adult content filtering",
      also_create_these_pools = "Also create these pools:",
      create_custom_pool = "Create a pool with this name:",
      configure_user = "Captive Portal",
      configure_user_message = "Please specifify the '%{pool}' pool credentials your clients will use to access your network.",
      username = "Username",
      username_title = "The username your clients will use to login",
      password = "Password",
      password_title = "The password your clients will use to login",
      policy = "Policy",
      define_policy = "When running in bridge mode, it is possible to limit the traffic flowing through the bridge by the mean of traffic policies.<br><br>"..
            "You can define an initial set of policies to be applied to the %{pool} pool members from one of the presets below:",
      fine_tune = "You can fine tune the specific policies at any time through the <a target='_blank' href='%{url}'>Traffic Policy</a> page.",
      done = "Apply",
      configuration_complete = "You are going to apply the specified settings on the bridge interface <b>%{iface}</b>.<br><br>"..
            "Click on the save button below to apply the configured settings.<br><br><br>"..
            "You can access more advanced settings from the following pages:",
      host_pools_config = "Host Pools",
      policies_config = "Traffic Policies, Shaping and Quotas",
      captive_portal_users = "Captive Portal Users",
      business_preset = "Business: no P2P, limited social networks and games time",
      children_preset = "Children: Safe Search enabled, limited games time, no social networks or chat",
      no_obfuscation_preset = "No Obfuscation: no obfuscation software (e.g. VPNs)",
      walled_garden_preset = "Walled Garden: no obfuscation software, no social networks",
      no_preset = "Do not use a preset",
      predefined_users_message = "The access credentials to the additional pools will be the followings:<ul>"..[[
        <li>Username <b>%{guests_username}</b> and password <b>%{guests_password}</b> to grant access as a %{guests} pool member</li>
        <li>Username <b>%{children_username}</b> and password <b>%{children_password}</b> to grant access as a %{children} pool member</li>
      </ul>]],
      no_local_networks = "No local networks found.<br>Please add the -m option to your ntopng configuration (e.g. -m \"192.168.1.0/24\") and restart ntopng",
      pool_name_error = "Please choose a different pool name",
      username_error = "Please choose a different username",
      password_format_error = "The password must be at least 5 characters long and must not contain some special characters",
   },

   alerts_thresholds_config = {
      every_minute = "Every Minute",
      every_5_minutes = "Every 5 Minutes",
      hourly = "Hourly",
      daily = "Daily",
      activity_time = "Activity Time",
      dns_traffic = "DNS Traffic",
      idle_time = "Idle Time",
      p2p_traffic = "P2P Traffic",
      throughput = "Throughput",
      inner_traffic = "Inner Traffic",
      ingress_traffic = "Ingress Traffic",
      egress_traffic = "Egress Traffic",
      threshold_type = "Threshold Type",
      thresholds_single_source = "%{source} %{alt_name} Thresholds",
      common_thresholds_local_sources = "Local %{source}s Common Thresholds",
      alert_active_description = "Activity time since last check (seconds).",
      alert_bytes_description = "Layer 2 bytes delta (sent + received)",
      alert_dns_description = "Layer 2 bytes delta (sent + received) for DNS detected traffic",
      alert_idle_description = "Idle time since last packet seen (seconds)",
      alert_packets_description = "Packets delta (sent + received)",
      alert_p2p_description = "Layer 2 bytes delta (sent + received) for peer-to-peer detected traffic",
      alert_throughput_description = "Average throughput (sent + received) [Mbps]",
      alert_flows_description = "Flows delta (as client + as server)",
      alert_network_ingress_description = "Ingress Bytes delta",
      alert_network_egress_description = "Egress Bytes delta",
      alert_network_inner_description = "Inner Bytes delta",
      notes = "NOTES",
      note_control_threshold_checks_periods ="Thresholds listed in these tabs are checked periodically. Use tabs to control threshold checks periods.",
      note_thresholds_expressed_as_delta = "Some thresholds are expressed as a delta. A delta is the difference of the same quantity between two consecutive checks.",
      note_consecutive_checks = "Consecutive checks are not necessarily performed on consecutive periods. For example, if an host goes idle, its thresholds will not be checked until it becomes active again.",
      note_deltas_of_idle_host_become_active = "Deltas of an idle host that becomes active again will be computed as the difference of the same quantity during the latest check and the most recent check performed when the host was active before going idle.",
      note_attacker_victime_threshold = "An attacker/victim threshold is considered exceeded if the corresponding host has exceeded the configured threshold for at least three seconds when performing the periodic check.",
   },

   mac_stats = {
      layer_2_host_devices = "Layer 2 %{device_type} Host Devices",
      layer_2_dev_devices = "Layer 2 %{device_type} Devices",
      all_layer_2_devices = "All Layer 2 Devices",
      dev_layer_2_devices = "%{device_type} Layer 2 Devices",
      layer_2_devices_with_manufacturer = "%{title} from '%{manufacturer}' manufacturer",
      filter_macs = "Filter MACs",
      manufacturer = "Manufacturer",
      all_devices = "All Devices",
      hosts_only = "Hosts Only",
      dhcp_only = "DHCP Only",
      all_manufacturers = "All Manufacturers",
      arp_total = "ARP",
   },

   details = {
      first_last_seen = "First / Last Seen",
      sent_vs_received_traffic_breakdown = "Sent vs Received Traffic Breakdown",
      traffic_sent_received = "Traffic Sent / Received",
      address_resolution_protocol = "Address Resolution Protocol",
      show_hosts = "Show Hosts",
      arp_requests = "ARP Requests",
      arp_replies = "ARP Replies",
      ago = "ago",
      rcvd = "Rcvd",
      router_access_point_mac_address = "(Router/AccessPoint) MAC Address",
      additional_mac_address = "Additional MAC Address",
      host_snmp_localization ="Host SNMP Localization",
      flow_snmp_localization ="Flow SNMP Localization",
      note_hosts_located_snmp_device = "Hosts are located in SNMP devices using the <A HREF=%{url}>Bridge MIB</A>.",
      device_port = "Device Port",
      input_device_port = "Device Input Port",
      output_device_port = "Device Output Port",
      host_pool = "Host Pool",
      source_id = "Source Id",
      vlan_id = "VLAN ID",
      alerts = "Alerts",
      note = "NOTE",
      whois_lookup = "Whois Lookup",
      label_local_host = "Local Host",
      label_remote = "Remote",
      label_private_ip = "Private IP",
      label_system_ip = "System IP",
      label_blacklisted_host = "Blacklisted Host",
      flows_non_packet_iface = "Recently Active Flows / Total",
      flows_packet_iface = "Active Flows / Total Active / Low Goodput",
      flows_packet_pcap_dump_iface = "Flows / Total Active / Low Goodput",
      flows_dropped_by_bridge = "Flows Blocked due to Traffic Policies",
      as_client = "As Client",
      as_server = "As Server",
      tcp_packets_sent_analysis = "TCP Packets Sent Analysis",
      retransmissions = "Retransmissions",
      out_of_order = "Out of Order",
      lost = "Lost",
      further_host_names_information = "Further Host Names/Information",
      l4_proto = "L4 Proto",
      total_traffic = "Total Traffic",
      goodput = "Goodput",
      device_type = "Device Type"
   },

   host_details = {
      host_parameter_missing_message = "Host parameter is missing (internal error ?)",
      host_cannot_be_found_message = "Host %{host} cannot be found.",
      host = "Host",
      trace_debug_host_info = "Host:%{hostinfo}, Vlan: %{vlan}",
      trace_debug_restored_host_info = "Restored Host Info",
      restore_from_cache_message = "Click <a href=%{js_code}> here</a> to restore it from cache.",
      trace_debug_host_ip = "Host:%{hostip}, Vlan: %{vlan}",
      snmp = "SNMP",
      change_host_pool_popup_msg = "Change Host Pool",
      blocked_traffic = "Blocked Traffic",
      host_traffic_blocked_quota = "Some host traffic has been blocked by an exceeded quota",
      host_traffic_blocked_shaper = "Some host traffic has been blocked by a blocking shaper",
      host_traffic_blocked_quota_and_shaper = "Some host traffic has been blocked by an exceeded quota and a blocking shaper",
      unknown_device_type = "Unknown Device Type",
   },

   mac_details = {
      mac = "Mac",
      mac_parameter_missing_message = "Mac parameter is missing (internal error ?)",
      mac_cannot_be_found_message = "Mac %{mac} cannot be found.",
   },

   network_details = {
      network = "Network",
      network_parameter_missing_message = "Network parameter is missing (internal error?)",
      no_available_stats_for_network = "No available stats for network %{network}",
   },

   as_details = {
      as = "Autonomous System",
      as_parameter_missing_message = "Autonomous System parameter is missing (internal error?)",
      no_available_data_for_as = "No available data for AS %{asn}.",
      as_timeseries_enable_message = "AS timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
   },

   port_details = {
      l4_port = "L4 Port",
      active_flows_for_host_and_port = "Active Flows for %{host}:%{port}",
      active_flows_on_port_symbolic = "Active Flows on Port %{port} [%{symbolic_port}]",
      active_flows_on_port = "Active Flows on Port %{port}",
   },

   flow_details = {
      flow_peers_client_server = "Flow Peers [ Client / Server ]",
      flow_cannot_be_found_message = "This flow cannot be found.",
      drop_flow_traffic_btn = "Drop Flow Traffic",
      flow_shapers = "Flow Shapers",
      flow_quota = "Flow Quota",
      network_latency_breakdown = "Network Latency Breakdown",
      packet_inter_arrival_time = "Packet Inter-Arrival Time <br>[ Min / Avg / Max ]",
      application_latency = "Application Latency",
      looks_like_idle_flow_message = "This looks like an <font color=red>idle flow</font> with periodic transmissions just to keep it alive.",
      tcp_packet_analysis = "TCP Packet Analysis",
      ssl_certificate = "SSL Certificate",
      client_requested = "Client Requested",
      server_certificate = "Server Certificate",
      certificates_not_match = "Certificates don't match",
      computed_as_tcp_window_size_rtt = "Computed as TCP Window Size / RTT",
      max_estimated_tcp_throughput = "Max (Estimated) TCP Throughput",
      throughput_trend = "Throughput Trend",
      flow_reset_msg = "This flow has been reset",
      flow_reset_by_resetter_msg = "This flow has been reset by %{resetter}",
      flow_completed_msg = "This flow is completed and will expire soon",
      flow_active_msg = "This flow is active",
      flow_peer_roles_inaccurate_msg = "However, flow begin has not been seen: peer roles (client/server) might be inaccurate",
      icmp_info = "ICMP Info",
      flow_status = "Flow Status",
      actual_peak_throughput = "Actual / Peak Throughput",
      client_process_information = "Client Process Information",
      server_process_information = "Server Process Information",
      user_name = "User Name",
      process_pid_name = "Process PID/Name",
      son_of_father_process = "son of <a href ='%{url}'>%{proc_father_pid}/%{proc_father_name}</a>",
      average_cpu_load = "Average CPU Load",
      io_wait_time_percentage = "I/O Wait Time Percentage",
      memory_actual_peak = "Memory Actual / Peak",
      vm_page_faults = "VM Page Faults",
      process_information_report_warning = "Process information report is limited unless you use ntopng with <A HREF='%{url}'>nProbe</A> and the sprobe plugin",
      dns_query = "DNS Query",
      bittorrent_hash = "BitTorrent hash",
      ssh_signature = "SSH Signature",
      http_method = "HTTP Method",
      server_name = "Server Name",
      url = "URL",
      response_code = "Response Code",
      profile_name = "Profile Name",
      dump_flow_traffic = "Dump Flow Traffic",
      additional_flow_elements = "Additional Flow Elements",

      normal = "Normal",
      slow_tcp_connection = "Slow TCP Connection",
      slow_application_header = "Slow Application Header",
      slow_data_exchange = "Slow Data Exchange (Slowloris?)",
      low_goodput = "Low Goodput",
      suspicious_tcp_syn_probing = "Suspicious TCP SYN Probing (or server port down)",
      tcp_connection_issues = "TCP Connection Issues (Retransmission, OOO, Lost)",
      suspicious_tcp_probing = "Suspicious TCP Probing",
      flow_emitted = "Flow emitted when network interface was alerted",
      tcp_connection_refused = "TCP connection refused",
      ssl_certificate_mismatch = "SSL Certificate Mismatch",
      dns_invalid_query = "Invalid DNS query",
      unknown_status = "Unknown status (%{status})",
      sip_protocol_information = "SIP Protocol Information",
      call_id = "Call-ID",
      call_initiator = "Call Initiator",
      called_party = "Called Party",
      rtp_codecs = "RTP Codecs",
      rtp_stream_peers = "RTP Stream Peers",
      rtp_flow = "RTP Flow",
      cancel_bye_failure_reason_cause = "Cancel/Bye/Failure Reason Cause",
      c_ip_addresses = "C IP Addresses",
      call_state = "Call State",
      call_started = "Call Started",
      ongoing_call = "Ongoing Call",
      call_completed = "Call Completed",
      call_error = "Call Error",
      call_canceled = "Call Canceled",
      rtp_protocol_information = "RTP Protocol Information",
      sync_source_id = "Sync Source ID",
      round_trip_time = "Round Trip Time",
      rtp_transit_in_out = "RTP Transit IN / OUT",
      dtmf_tones_sent = "DTMF tones sent during the call",
      first_last_flow_sequence = "First / Last Flow Sequence",
      sip_call_id = "SIP Call-ID",
      call_quality_indicators = "Call Quality Indicators",
      forward = "Forward",
      reverse = "Reverse",
      jitter = "Jitter",
      lost_packets = "Lost Packets",
      dropped_packets = "Dropped Packets",
      max_packet_interarrival_time = "Max Packet Interarrival Time",
      payload_type = "Payload Type",
      pseudo_mos = "(Pseudo) MOS",
      r_factor = "R-Factor",
      desirable_label = "Desirable",
      acceptable_label = "Acceptable",
      reach_connection_label = "Reach Connection",
      not_recommended_label = "Not Recommended",
      imsi = "IMSI (International mobile Subscriber Identity)",
      nsapi = "NSAPI",
      gsm_cell_lac = "GSM Cell LAC (Location Area Code)",
      gsm_cell_identifier = "GSM Cell Identifier",
      sac_service_area_code = "SAC (Service Area Code)",
   },

   vlan_details = {
      vlan_id_parameter_missing_or_invalid_message = "Vlan_Id parameter is missing or is not valid",
      no_available_stats_for_vlan_message = "No available stats for VLAN %{vlan_id}. Please wait a few minutes to allow ntopng to harvest new statistics.",
   },

   pool_details = {
      pool_parameter_missing_message = "Pool parameter is missing (internal error ?)",
      no_available_data_for_host_pool_message = "No available data for Host Pool '%{pool_name}'.",
      host_pool_timeseries_enable_message = "Host Pool timeseries can be enabled from the <A HREF=\"%{url}\">%{icon_flask} Preferences</A>. Few minutes are necessary to see the first data points.",
      host_pool = "Host Pool",
   },

   network_alert_config = {
      trigger_network_alerts = "Trigger Network Alerts",
      trigger_alerts_for_network = "Trigger alerts for Network %{network}",
   },

   local_flow_matrix = {
      local_hosts_active_flows_matrix = "Local Hosts Active Flows Matrix",
      error_no_local_hosts = "No local hosts can be found",
   },

   tree_map = {
      hosts_treemap = "Hosts TreeMap",
   },

   geo_map = {
      hosts_geomap = "Hosts GeoMap",
      note = "NOTE",
      geolocation_error = "Geolocation error",
      using_default_location = "Using default location.",
      browser_reported_home_map = "Browser reported home map location",
      latitude = "Latitude",
      longitude = "Longitude",
      unavailable_geolocation = "Geolocation not supported by your browser or disabled.",
      note_requirements_visualize_maps = "In order to visualize maps you must",
      note_working_internet_connection = "Have a working Internet connection.",
      note_compiled_ntopng_with_geolocation = "Have compiled ntopng with geolocation and started with it.",
      note_active_flows = "Have active flows between peers with public IP addresses.",
      note_html_browser_geolocation = "HTML <A HREF=%{url}>browser geolocation</A> is used to place on map hosts based on unknown locations.",
      note_google_maps_browser_api_key = "A Google Maps Browser API Key may be required. Detailed information on key generation <a href='%{url_google}'>can be found here</a>.<br>"..
            "Once generated, the key can be submitted via ntopng <a href='%{url_prefs}'><i class=\"fa fa-flask\"></i> Preferences</a>.",
   },

   top_hosts = {
      top_hosts_local = "Top Hosts (Local)",
   },

   http_servers_stats = {
      bytes_sent = "Bytes Sent",
      bytes_received = "Bytes Received",
      total_requests = "Total Requests",
      actual_requests = "Actual Requests",
      local_http_servers = "Local HTTP Servers",
      http_virtual_host = "HTTP Virtual Host",
      http_server_ip = "HTTP Server IP",
   },

   local_hosts_stats = {
      looking_glass = "Looking Glass",
      criteria = "Criteria",
   },

   os_stats = {
      hosts_by_operating_system = "Hosts by Operating System",
   },

   country_stats = {
      hosts_by_country = "Hosts by Country",
   },

   as_stats = {
      autonomous_systems = "Autonomous Systems",
   },

   pool_stats = {
      host_pool_list = "Host Pool List",
   },

   network_stats = {
      networks = "Networks",
      networks_traffic_with_ipver = "%{networks} with IPv%{ipver} traffic",
      network_list = "Network List",
      network_name = "Network Name",
      note_overlapping_networks = "NOTE: In case you have defined overlapping networks:",
      note_see_both_network_entries = "You will see both network entries in the above table.",
      note_broader_network = "The broader network will not include hosts defined in smaller networks.",
   },

   hosts_stats = {
      ipver_title = "IPv%{version_num}",
      asn_title = "for AS %{asn}",
      country_title = "for Country %{country}",
      mac_title = "with Mac %{mac}",
      pool_title = "for Pool %{poolname}",
      vlan_title = "VLAN %{vlan}",
      hosts = "Hosts",
      as_info = "AS Info",
      as_path = "AS Path",
      as_geolocation = "AS Geolocation",
      as_prefixes = "AS Prefixes",
      bgp_updates = "BGP Updates",
      filter_hosts = "Filter Hosts",
      all_hosts = "All Hosts",
      local_hosts_only = "Local Hosts Only",
      remote_hosts_only = "Remote Hosts Only",
      filtered_hosts_only = "Hosts With Blocked Traffic",
      host_pool = "Host Pool %{pool_name}",
      source_id = "Source Id",
      location = "Location",
      httpbl = "HTTP:BL",
      more_info_about_as_popup_msg = "More Information about AS",
      blocking_traffic_policy_popup_msg = "Host traffic is affected by a blocking Traffic Policy",
      label_local_host = "Local Host",
      label_remote_host = "Remote Host",
      label_blacklisted_host = "Blacklisted Host",
   },

   unknown_devices = {
      unassigned_devices = "Unassigned Devices",
      assign_device_pool = "Assign Device to a Pool",
      select_pool = "Please select an host pool from the dropdown below to assign '%{mac}' to:",
      assign_pool = "Assign To Pool",
      device_name = "Device Name",
      first_seen = "First Seen",
      last_seen = "Last Seen",
      filter_devices = "Filter Devices",
      all_devices = "All Devices",
      active_only = "Active Only",
      inactive_only = "Inactive Only",
      no_pools = "An host pool must be created in order to assign unknown devices to.",
   },

   vlan_stats = {
      vlans = "VLANs",
      vlan_id = "VLAN ID",
   },

   icmp_v4_types = {
      type_0_0_echo_reply = "Echo Reply",
      type_3_0_network_unreachable = "Network Unreachable",
      type_3_1_host_unreachable = "Host Unreachable",
      type_3_2_protocol_unreachable = "Protocol Unreachable",
      type_3_3_port_unreachable = "Port Unreachable",
      type_3_4_fragmentation_needed_but_no_fragment_bit_set = "Fragmentation needed but no fragment bit set",
      type_3_5_source_routing_failed = "Source routing failed",
      type_3_6_destination_network_unknown = "Destination network unknown",
      type_3_7_destination_host_unknown = "Destination host unknown",
      type_3_8_source_host_isolated = "Source host isolated (obsolete)",
      type_3_9_destination_network_administratively_prohibited = "Destination network administratively prohibited",
      type_3_10_destination_host_administratively_prohibited = "Destination host administratively prohibited",
      type_3_11_network_unreachable_for_tos = "Network unreachable for TOS",
      type_3_12_host_unreachable_for_tos = "Host unreachable for TOS",
      type_3_13_communication_administratively_prohibited_by_filtering = "Communication administratively prohibited by filtering",
      type_3_14_host_precedence_violation = "Host precedence violation",
      type_3_15_precedence_cutoff_in_effect = "Precedence cutoff in effect",
      type_4_0_source_quench = "Source quench",
      type_5_0_redirect_for_network = "Redirect for network",
      type_5_1_redirect_for_host = "Redirect for host",
      type_5_2_redirect_for_tos_and_network = "Redirect for TOS and network",
      type_5_3_redirect_for_tos_and_host = "Redirect for TOS and host",
      type_8_0_echo_request_x = "Echo request x",
      type_9_0_router_advertisement = "Router advertisement",
      type_10_0_route_solicitation = "Route solicitation",
      type_11_0_ttl_equals_0_during_transit = "TTL equals 0 during transit",
      type_11_1_ttl_equals_0_during_reassembly = "TTL equals 0 during reassembly",
      type_12_0_ip_header_bad = "IP header bad (catchall error)",
      type_12_1_required_options_missing = "Required options missing",
      type_13_0_timestamp_request = "Timestamp request (obsolete)",
      type_14_0_timestamp_reply = "Timestamp reply (obsolete)",
      type_15_0_information_request = "Information request (obsolete)",
      type_16_0_information_reply = "Information reply (obsolete)",
      type_17_0_address_mask_request = "Address mask request",
      type_18_0_address_mask_reply = "Address mask reply",
   },

   icmp_v6_types = {
      type_0_reserved = "Reserved",
      type_1_destination_unreachable = "Destination Unreachable",
      type_2_packet_too_big = "Packet Too Big",
      type_3_time_exceeded = "Time Exceeded",
      type_4_parameter_problem = "Parameter Problem",
      type_100_private_experimentation = "Private experimentation",
      type_101_private_experimentation = "Private experimentation",
      -- type_102-126_unassigned = "Unassigned",
      type_127_reserved_for_expansion_of_icmpv6_error_messages = "Reserved for expansion of ICMPv6 error messages",
      type_128_echo_request = "Echo Request",
      type_129_echo_reply = "Echo Reply",
      type_130_multicast_listener_query = "Multicast Listener Query",
      type_131_multicast_listener_report = "Multicast Listener Report",
      type_132_multicast_listener_done = "Multicast Listener Done",
      type_133_router_solicitation = "Router Solicitation",
      type_134_router_advertisement = "Router Advertisement",
      type_135_neighbor_solicitation = "Neighbor Solicitation",
      type_136_neighbor_advertisement = "Neighbor Advertisement",
      type_137_redirect_message = "Redirect Message",
      type_138_router_renumbering = "Router Renumbering",
      type_139_icmp_node_information_query = "ICMP Node Information Query",
      type_140_icmp_node_information_response = "ICMP Node Information Response",
      type_141_inverse_neighbor_discovery_solicitation_message = "Inverse Neighbor Discovery Solicitation Message",
      type_142_inverse_neighbor_discovery_advertisement_message = "Inverse Neighbor Discovery Advertisement Message",
      type_143_version_2_multicast_listener_report = "Version 2 Multicast Listener Report",
      type_144_home_agent_address_discovery_request_message = "Home Agent Address Discovery Request Message",
      type_145_home_agent_address_discovery_reply_message = "Home Agent Address Discovery Reply Message",
      type_146_mobile_prefix_solicitation = "Mobile Prefix Solicitation",
      type_147_mobile_prefix_advertisement = "Mobile Prefix Advertisement",
      type_148_certification_path_solicitation_message = "Certification Path Solicitation Message",
      type_149_certification_path_advertisement_message = "Certification Path Advertisement Message",
      type_150_icmp_messages_utilized_by_experimental_mobility_protocols = "ICMP messages utilized by experimental mobility protocols",
      type_151_multicast_router_advertisement = "Multicast Router Advertisement",
      type_152_multicast_router_solicitation = "Multicast Router Solicitation",
      type_153_multicast_router_termination = "Multicast Router Termination",
      type_154_fmipv6_messages = "FMIPv6 Messages",
      type_155_rpl_control_message = "RPL Control Message",
      type_156_ilnpv6_locator_update_message = "ILNPv6 Locator Update Message",
      type_157_duplicate_address_request = "Duplicate Address Request",
      type_158_duplicate_address_confirmation = "Duplicate Address Confirmation",
      type_159_mpl_control_message = "MPL Control Message",
      -- type_160-199_unassigned = "Unassigned",
      type_200_private_experimentation = "Private experimentation",
      type_201_private_experimentation = "Private experimentation",
      type_255_reserved_for_expansion_of_icmpv6_informational_messages = "Reserved for expansion of ICMPv6 informational messages",
   },

   icmp_v4_msgs = {
      type_0_0_echo_reply = "Echo Reply",
      type_3_0_destination_network_unreachable = "Destination Network Unreachable",
      type_3_1_destination_host_unreachable = "Destination Host Unreachable",
      type_3_2_destination_protocol_unreachable = "Destination Protocol Unreachable",
      type_3_3_destination_port_unreachable = "Destination Port Unreachable",
      type_3_4_fragmentation_required = "Fragmentation required, and DF flag set",
      type_3_6_destination_network_unknown = "Destination Network Unknown",
      type_3_7_destination_host_unknown = "Destination Host Unknown",
      type_3_0_destination_unreachable = "Destination Unreachable",
      type_4_0_source_quench = "Source Quench",
      type_5_0_redirect = "Redirect",
      type_8_0_echo_request = "Echo Request",
      type_9_0_router_advertisement = "Router Advertisement",
      type_10_0_router_selection = "Router Selection",
      type_11_0_ttl_expired_in_transit = "Time Exceeded: TTL expired in transit",
      type_11_1_fragment_reassembly_time_exceeded = "Time Exceeded: Fragment reassembly time exceeded",
      type_12_0_parameter_problem = "Parameter Problem",
      type_13_0_timestamp_request = "Timestamp Request",
      type_14_0_timestamp_reply = "Timestamp Reply",
      type_15_0_information_request = "Information Request",
      type_16_0_information_reply = "Information Reply",
      type_17_0_address_mask_request = "Address Mask Request",
      type_18_0_address_mask_reply = "Address Mask Reply",
      type_30_0_traceroute = "Traceroute",
   },

   icmp_v6_msgs = {
      type_1_0_destination_unreachable = "Destination Unreachable",
      type_2_0_packet_too_big = "Packet Too Big",
      type_3_0_hop_limit_exceeded_in_transit = "Time Exceeded: hop limit exceeded in transit",
      type_3_1_fragment_reassembly_time_exceeded = "Time Exceeded: fragment reassembly time exceeded",
      type_4_0_parameter_problem = "Parameter Problem",
      type_128_0_echo_request = "Echo Request",
      type_129_0_echo_reply = "Echo Reply",
      type_133_0_router_solicitation = "Router Solicitation",
      type_134_0_router_advertisement = "Router Advertisement",
      type_135_0_neighbor_solicitation = "Neighbor Solicitation",
      type_136_0_neighbor_advertisement = "Neighbor Advertisement",
   },

   flow_fields_description = {
      in_bytes = "Incoming flow bytes (src->dst)",
      in_pkts = "Incoming flow packets (src->dst)",
      protocol = "IP protocol byte",
      protocol_map = "IP protocol name",
      src_tos = "TOS/DSCP (src->dst)",
      tcp_flags = "Cumulative of all flow TCP flags",
      l4_src_port = "IPv4 source port",
      l4_src_port_map = "Layer 4 source port symbolic name",
      ipv4_src_addr = "IPv4 source address",
      ipv4_src_mask = "IPv4 source subnet mask (/<bits>)",
      input_snmp = "Input interface SNMP idx",
      l4_dst_port = "IPv4 destination port",
      l4_dst_port_map = "Layer 4 destination port symbolic name",
      l4_srv_port = "Layer 4 server port",
      l4_srv_port_map = "Layer 4 server port symbolic name",
      ipv4_dst_addr = "IPv4 destination address",
      ipv4_dst_mask = "IPv4 dest subnet mask (/<bits>)",
      output_snmp = "Output interface SNMP idx",
      ipv4_next_hop = "IPv4 next hop address",
      src_as = "Source BGP AS",
      dst_as = "Destination BGP AS",
      last_switched = "SysUptime (msec) of the last flow pkt",
      first_switched = "SysUptime (msec) of the first flow pkt",
      out_bytes = "Outgoing flow bytes (dst->src) [Aliased to %%DST_TO_SRC_BYTES]",
      out_pkts = "Outgoing flow packets (dst->src) [Aliased to %%DST_TO_SRC_PKTS]",
      ipv6_src_addr = "IPv6 source address",
      ipv6_dst_addr = "IPv6 destination address",
      ipv6_src_mask = "IPv6 source mask",
      ipv6_dst_mask = "IPv6 destination mask",
      icmp_type = "ICMP Type * 256 + ICMP code",
      sampling_interval = "Sampling rate",
      sampling_algorithm = "Sampling type (deterministic/random)",
      flow_active_timeout = "Activity timeout of flow cache entries",
      flow_inactive_timeout = "Inactivity timeout of flow cache entries",
      engine_type = "Flow switching engine",
      engine_id = "Id of the flow switching engine",
      total_bytes_exp = "Total bytes exported",
      total_pkts_exp = "Total flow packets exported",
      total_flows_exp = "Total number of exported flows",
      min_ttl = "Min flow TTL",
      max_ttl = "Max flow TTL",
      dst_tos = "TOS/DSCP (dst->src)",
      in_src_mac = "Source MAC Address",
      out_src_mac = "Source MAC Address, potentially modified by a middlebox function after the Observation Point",
      src_vlan = "Source VLAN (inner VLAN in QinQ)",
      dst_vlan = "Destination VLAN (inner VLAN in QinQ)",
      dot1q_src_vlan = "Source VLAN (outer VLAN in QinQ)",
      dot1q_dst_vlan = "Destination VLAN (outer VLAN in QinQ)",
      ip_protocol_version = "[4=IPv4][6=IPv6]",
      direction = "Flow direction [0=src->dst, 1=dst->src]",
      ipv6_next_hop = "IPv6 next hop address",
      mpls_label_1 = "MPLS label at position 1",
      mpls_label_2 = "MPLS label at position 2",
      mpls_label_3 = "MPLS label at position 3",
      mpls_label_4 = "MPLS label at position 4",
      mpls_label_5 = "MPLS label at position 5",
      mpls_label_6 = "MPLS label at position 6",
      mpls_label_7 = "MPLS label at position 7",
      mpls_label_8 = "MPLS label at position 8",
      mpls_label_9 = "MPLS label at position 9",
      mpls_label_10 = "MPLS label at position 10",
      in_dst_mac = "Destination MAC Address",
      out_dst_mac = "Destination MAC Address, potentially modified by a middlebox function after the Observation Point",
      application_id = "Collected Application Id (Cisco or IXIA)",
      packet_section_offset = "Packet section offset",
      sampled_packet_size = "Sampled packet size",
      sampled_packet_id = "Sampled packet id",
      exporter_ipv4_address = "Flow exporter IPv4 Address",
      exporter_ipv6_address = "Flow exporter IPv6 Address",
      flow_id = "Serial Flow Identifier",
      flow_start_sec = "Seconds (epoch) of the first flow packet",
      flow_end_sec = "Seconds (epoch) of the last flow packet",
      flow_start_milliseconds = "Msec (epoch) of the first flow packet",
      flow_start_microseconds = "uSec (epoch) of the first flow packet",
      flow_end_milliseconds = "Msec (epoch) of the last flow packet",
      flow_end_microseconds = "uSec (epoch) of the first flow packet",
      firewall_event = "Firewall Event 0=ignore, 1=flow created, 2=flow deleted, 3=flow denied, 4=flow alert, 5=flow update",
      biflow_direction = "1=initiator, 2=reverseInitiator",
      ingress_vrfid = "Ingress VRF ID",
      flow_duration_milliseconds = "Flow duration (msec)",
      flow_duration_microseconds = "Flow duration (usec)",
      icmp_ipv4_type = "ICMP Type",
      icmp_ipv4_code = "ICMP Code",
      post_nat_src_ipv4_addr = "Post NAT Source IPv4 Address",
      post_nat_dst_ipv4_addr = "Post NAT Destination IPv4 Address",
      post_napt_src_transport_port = "Post NAPT Source Transport Port",
      post_napt_dst_transport_port = "Post NAPT Destination Transport Port",
      observation_point_type = "Observation point type",
      observation_point_id = "Observation point id",
      selector_id = "Selector id",
      ipfix_sampling_algorithm = "Sampling algorithm",
      sampling_size = "Number of packets to sample",
      sampling_population = "Sampling population",
      frame_length = "Original L2 frame length",
      packets_observed = "Tot number of packets seen",
      packets_selected = "Number of pkts selected for sampling",
      selector_name = "Sampler name",
      application_name = "Palo Alto App-Id",
      user_name = "Palo Alto User-Id",
      src_fragments = "Num fragmented packets src->dst",
      dst_fragments = "Num fragmented packets dst->src",
      client_nw_latency_ms = "Network RTT/2 client <-> nprobe (msec)",
      server_nw_latency_ms = "Network RTT/2 nprobe <-> server (msec)",
      appl_latency_ms = "Application latency (msec), a.k.a. server response time",
      nprobe_ipv4_address = "IPv4 address of the host were nProbe runs",
      src_to_dst_max_throughput = "Src to dst max thpt (bps)",
      src_to_dst_min_throughput = "Src to dst min thpt (bps)",
      src_to_dst_avg_throughput = "Src to dst average thpt (bps)",
      dst_to_src_max_throughput = "Dst to src max thpt (bps)",
      dst_to_src_min_throughput = "Dst to src min thpt (bps)",
      dst_to_src_avg_throughput = "Dst to src average thpt (bps)",
      num_pkts_up_to_128_bytes = "# packets whose IP size <= 128",
      num_pkts_128_to_256_bytes = "# packets whose IP size > 128 and <= 256",
      num_pkts_256_to_512_bytes = "# packets whose IP size > 256 and < 512",
      num_pkts_512_to_1024_bytes = "# packets whose IP size > 512 and < 1024",
      num_pkts_1024_to_1514_bytes = "# packets whose IP size > 1024 and <= 1514",
      num_pkts_over_1514_bytes = "# packets whose IP size > 1514",
      cumulative_icmp_type = "Cumulative OR of ICMP type packets",
      src_ip_country = "Country where the src IP is located",
      src_ip_city = "City where the src IP is located",
      dst_ip_country = "Country where the dst IP is located",
      dst_ip_city = "City where the dst IP is located",
      src_ip_long = "Longitude where the src IP is located",
      src_ip_lat = "Latitude where the src IP is located",
      dst_ip_long = "Longitude where the dst IP is located",
      dst_ip_lat = "Latitude where the dst IP is located",
      flow_proto_port = "L7 port that identifies the flow protocol or 0 if unknown",
      upstream_tunnel_id = "Upstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
      upstream_session_id = "Upstream session identifier (e.g. L2TP) or 0 if unknown",
      longest_flow_pkt = "Longest packet (bytes) of the flow",
      shortest_flow_pkt = "Shortest packet (bytes) of the flow",
      retransmitted_in_bytes = "Number of retransmitted TCP flow bytes (src->dst)",
      retransmitted_in_pkts = "Number of retransmitted TCP flow packets (src->dst)",
      retransmitted_out_bytes = "Number of retransmitted TCP flow bytes (dst->src)",
      retransmitted_out_pkts = "Number of retransmitted TCP flow packets (dst->src)",
      ooorder_in_pkts = "Number of out of order TCP flow packets (dst->src)",
      ooorder_out_pkts = "Number of out of order TCP flow packets (src->dst)",
      untunneled_protocol = "Untunneled IP protocol byte",
      untunneled_ipv4_src_addr = "Untunneled IPv4 source address",
      untunneled_l4_src_port = "Untunneled IPv4 source port",
      untunneled_ipv4_dst_addr = "Untunneled IPv4 destination address",
      untunneled_l4_dst_port = "Untunneled IPv4 destination port",
      l7_proto = "Layer 7 protocol (numeric)",
      l7_proto_name = "Layer 7 protocol name",
      downstream_tunnel_id = "Downstream tunnel identifier (e.g. GTP TEID, VXLAN VNI) or 0 if unknown",
      downstream_session_id = "Downstream session identifier (e.g. L2TP) or 0 if unknown",
      ssl_server_name = "SSL server name",
      bittorrent_hash = "BITTORRENT hash",
      flow_user_name = "Flow username of the tunnel (if known)",
      flow_server_name = "Flow server name (if known)",
      plugin_name = "Plugin name used by this flow (if any)",
      untunneled_ipv6_src_addr = "Untunneled IPv6 source address",
      untunneled_ipv6_dst_addr = "Untunneled IPv6 destination address",
      num_pkts_ttl_eq_1 = "# packets with TTL = 1",
      num_pkts_ttl_2_5 = "# packets with TTL > 1 and TTL <= 5",
      num_pkts_ttl_5_32 = "# packets with TTL > 5 and TTL <= 32",
      num_pkts_ttl_32_64 = "# packets with TTL > 32 and <= 64",
      num_pkts_ttl_64_96 = "# packets with TTL > 64 and <= 96",
      num_pkts_ttl_96_128 = "# packets with TTL > 96 and <= 128",
      num_pkts_ttl_128_160 = "# packets with TTL > 128 and <= 160",
      num_pkts_ttl_160_192 = "# packets with TTL > 160 and <= 192",
      num_pkts_ttl_192_224 = "# packets with TTL > 192 and <= 224",
      num_pkts_ttl_224_255 = "# packets with TTL > 224 and <= 255",
      in_src_osi_sap = "OSI Source SAP (OSI Traffic Only)",
      out_dst_osi_sap = "OSI Destination SAP (OSI Traffic Only)",
      duration_in = "Client to Server stream duration (msec)",
      duration_out = "Client to Server stream duration (msec)",
      tcp_win_min_in = "Min TCP Window (src->dst)",
      tcp_win_max_in = "Max TCP Window (src->dst)",
      tcp_win_mss_in = "TCP Max Segment Size (src->dst)",
      tcp_win_scale_in = "TCP Window Scale (src->dst)",
      tcp_win_min_out = "Min TCP Window (dst->src)",
      tcp_win_max_out = "Max TCP Window (dst->src)",
      tcp_win_mss_out = "TCP Max Segment Size (dst->src)",
      tcp_win_scale_out = "TCP Window Scale (dst->src)",
      payload_hash = "Initial flow payload hash",
      src_as_map = "Organization name for SRC_AS",
      dst_as_map = "Organization name for DST_AS",
      src_as_path_1 = "Src AS path position 1",
      src_as_path_2 = "Src AS path position 2",
      src_as_path_3 = "Src AS path position 3",
      src_as_path_4 = "Src AS path position 4",
      src_as_path_5 = "Src AS path position 5",
      src_as_path_6 = "Src AS path position 6",
      src_as_path_7 = "Src AS path position 7",
      src_as_path_8 = "Src AS path position 8",
      src_as_path_9 = "Src AS path position 9",
      src_as_path_10 = "Src AS path position 10",
      dst_as_path_1 = "Dest AS path position 1",
      dst_as_path_2 = "Dest AS path position 2",
      dst_as_path_3 = "Dest AS path position 3",
      dst_as_path_4 = "Dest AS path position 4",
      dst_as_path_5 = "Dest AS path position 5",
      dst_as_path_6 = "Dest AS path position 6",
      dst_as_path_7 = "Dest AS path position 7",
      dst_as_path_8 = "Dest AS path position 8",
      dst_as_path_9 = "Dest AS path position 9",
      dst_as_path_10 = "Dest AS path position 10",
      dhcp_client_mac = "MAC of the DHCP client",
      dhcp_client_ip = "DHCP assigned client IPv4 address",
      dhcp_client_name = "DHCP client name",
      dhcp_remote_id = "DHCP agent remote Id",
      dhcp_subscriber_id = "DHCP subscribed Id",
      dhcp_message_type = "DHCP message type",
      diameter_req_msg_type = "DIAMETER Request Msg Type",
      diameter_rsp_msg_type = "DIAMETER Response Msg Type",
      diameter_req_origin_host = "DIAMETER Origin Host Request",
      diameter_rsp_origin_host = "DIAMETER Origin Host Response",
      diameter_req_user_name = "DIAMETER Request User Name",
      diameter_rsp_result_code = "DIAMETER Response Result Code",
      diameter_exp_res_vendor_id = "DIAMETER Response Experimental Result Vendor Id",
      diameter_exp_res_result_code = "DIAMETER Response Experimental Result Code",
      diameter_hop_by_hop_id = "DIAMETER Hop by Hop Identifier",
      diameter_clr_cancel_type = "DIAMETER Cancellation Type",
      diameter_clr_flags = "DIAMETER CLR Flags",
      dns_query = "DNS query",
      dns_query_id = "DNS query transaction Id",
      dns_query_type = "DNS query type (e.g. 1=A, 2=NS..)",
      dns_ret_code = "DNS return code (e.g. 0=no error)",
      dns_num_answers = "DNS # of returned answers",
      dns_ttl_answer = "TTL of the first A record (if any)",
      dns_response = "DNS response(s)",
      ftp_login = "FTP client login",
      ftp_password = "FTP client password",
      ftp_command = "FTP client command",
      ftp_command_ret_code = "FTP client command return code",
      gtpv0_req_msg_type = "GTPv0 Request Msg Type",
      gtpv0_rsp_msg_type = "GTPv0 Response Msg Type",
      gtpv0_tid = "GTPv0 Tunnel Identifier",
      gtpv0_apn_name = "GTPv0 APN Name",
      gtpv0_end_user_ip = "GTPv0 End User IP Address",
      gtpv0_end_user_msisdn = "GTPv0 End User MSISDN",
      gtpv0_rai_mcc = "GTPv0 Mobile Country Code",
      gtpv0_rai_mnc = "GTPv0 Mobile Network Code",
      gtpv0_rai_cell_lac = "GTPv0 Cell Location Area Code",
      gtpv0_rai_cell_rac = "GTPv0 Cell Routing Area Code",
      gtpv0_response_cause = "GTPv0 Cause of Operation",
      gtpv1_req_msg_type = "GTPv1 Request Msg Type",
      gtpv1_rsp_msg_type = "GTPv1 Response Msg Type",
      gtpv1_c2s_teid_data = "GTPv1 Client->Server TunnelId Data",
      gtpv1_c2s_teid_ctrl = "GTPv1 Client->Server TunnelId Control",
      gtpv1_s2c_teid_data = "GTPv1 Server->Client TunnelId Data",
      gtpv1_s2c_teid_ctrl = "GTPv1 Server->Client TunnelId Control",
      gtpv1_end_user_ip = "GTPv1 End User IP Address",
      gtpv1_end_user_imsi = "GTPv1 End User IMSI",
      gtpv1_end_user_msisdn = "GTPv1 End User MSISDN",
      gtpv1_end_user_imei = "GTPv1 End User IMEI",
      gtpv1_apn_name = "GTPv1 APN Name",
      gtpv1_rat_type = "GTPv1 RAT Type",
      gtpv1_rai_mcc = "GTPv1 RAI Mobile Country Code",
      gtpv1_rai_mnc = "GTPv1 RAI Mobile Network Code",
      gtpv1_rai_lac = "GTPv1 RAI Location Area Code",
      gtpv1_rai_rac = "GTPv1 RAI Routing Area Code",
      gtpv1_uli_mcc = "GTPv1 ULI Mobile Country Code",
      gtpv1_uli_mnc = "GTPv1 ULI Mobile Network Code",
      gtpv1_uli_cell_lac = "GTPv1 ULI Cell Location Area Code",
      gtpv1_uli_cell_ci = "GTPv1 ULI Cell CI",
      gtpv1_uli_sac = "GTPv1 ULI SAC",
      gtpv1_response_cause = "GTPv1 Cause of Operation",
      gtpv2_req_msg_type = "GTPv2 Request Msg Type",
      gtpv2_rsp_msg_type = "GTPv2 Response Msg Type",
      gtpv2_c2s_s1u_gtpu_teid = "GTPv2 Client->Svr S1U GTPU TEID",
      gtpv2_c2s_s1u_gtpu_ip = "GTPv2 Client->Svr S1U GTPU IP",
      gtpv2_s2c_s1u_gtpu_teid = "GTPv2 Srv->Client S1U GTPU TEID",
      gtpv2_s5_s8_gtpc_teid = "GTPv2 S5/S8 SGW GTPC TEIDs",
      gtpv2_s2c_s1u_gtpu_ip = "GTPv2 Srv->Client S1U GTPU IP",
      gtpv2_c2s_s5_s8_gtpu_teid = "GTPv2 Client->Srv S5/S8 PGW GTPU TEID",
      gtpv2_s2c_s5_s8_gtpu_teid = "GTPv2 Srv->Client S5/S8 PGW GTPU TEID",
      gtpv2_c2s_s5_s8_gtpu_ip = "GTPv2 Client->Srv S5/S8 PGW GTPU IP",
      gtpv2_s2c_s5_s8_gtpu_ip = "GTPv2 Srv->Client S5/S8 PGW GTPU IP",
      gtpv2_end_user_imsi = "GTPv2 End User IMSI",
      gtpv2_end_user_msisdn = "GTPv2 End User MSISDN",
      gtpv2_apn_name = "GTPv2 APN Name",
      gtpv2_uli_mcc = "GTPv2 Mobile Country Code",
      gtpv2_uli_mnc = "GTPv2 Mobile Network Code",
      gtpv2_uli_cell_tac = "GTPv2 Tracking Area Code",
      gtpv2_uli_cell_id = "GTPv2 Cell Identifier",
      gtpv2_response_cause = "GTPv2 Cause of Operation",
      gtpv2_rat_type = "GTPv2 RAT Type",
      gtpv2_pdn_ip = "GTPV2 PDN IP Address",
      gtpv2_end_user_imei = "GTPv2 End User IMEI",
      gtpv2_c2s_s5_s8_gtpc_ip = "GTPv2 Client->Svr S5/S8 GTPC IP",
      gtpv2_s2c_s5_s8_gtpc_ip = "GTPv2 Svr->Client S5/S8 GTPC IP",
      gtpv2_c2s_s5_s8_sgw_gtpu_teid = "GTPv2 Client->Srv S5/S8 SGW GTPU TEID",
      gtpv2_s2c_s5_s8_sgw_gtpu_teid = "GTPv2 Srv->Client S5/S8 SGW GTPU TEID",
      gtpv2_c2s_s5_s8_sgw_gtpu_ip = "GTPv2 Client->Srv S5/S8 SGW GTPU IP",
      gtpv2_s2c_s5_s8_sgw_gtpu_ip = "GTPv2 Srv->Client S5/S8 SGW GTPU IP",
      http_url = "HTTP URL (IXIA URI)",
      http_method = "HTTP METHOD",
      http_ret_code = "HTTP return code (e.g. 200, 304...)",
      http_referer = "HTTP Referer",
      http_ua = "HTTP User Agent",
      http_mime = "HTTP Mime Type",
      http_host = "HTTP Host Name (IXIA Host Name)",
      http_site = "HTTP server without host name",
      http_x_forwarded_for = "HTTP X-Forwarded-For",
      http_via = "HTTP Via",
      imap_login = "Mail sender",
      mysql_server_version = "MySQL server version",
      mysql_username = "MySQL username",
      mysql_db = "MySQL database in use",
      mysql_query = "MySQL Query",
      mysql_response = "MySQL server response",
      mysql_appl_latency_usec = "MySQL request->response latecy (usec)",
      netbios_query_name = "NETBIOS Query Name",
      netbios_query_type = "NETBIOS Query Type",
      netbios_response = "NETBIOS Query Response",
      netbios_query_os = "NETBIOS Query OS",
      oracle_username = "Oracle Username",
      oracle_query = "Oracle Query",
      oracle_rsp_code = "Oracle Response Code",
      oracle_rsp_string = "Oracle Response String",
      oracle_query_duration = "Oracle Query Duration (msec)",
      pop_user = "POP3 user login",
      src_proc_pid = "Src process PID",
      src_proc_name = "Src process name",
      src_proc_uid = "Src process UID",
      src_proc_user_name = "Src process user name",
      src_father_proc_pid = "Src father process PID",
      src_father_proc_name = "Src father process name",
      src_proc_actual_memory = "Src process actual memory (bytes)",
      src_proc_peak_memory = "Src process peak memory (bytes)",
      src_proc_average_cpu_load = "Src process avg load (%% * 100)",
      src_proc_num_page_faults = "Src process num pagefaults",
      src_proc_pctg_iowait = "Src process iowait time %% (%% * 100)",
      dst_proc_pid = "Dst process PID",
      dst_proc_name = "Dst process name",
      dst_proc_uid = "Dst process UID",
      dst_proc_user_name = "Dst process user name",
      dst_father_proc_pid = "Dst father process PID",
      dst_father_proc_name = "Dst father process name",
      dst_proc_actual_memory = "Dst process actual memory (bytes)",
      dst_proc_peak_memory = "Dst process peak memory (bytes)",
      dst_proc_average_cpu_load = "Dst process avg load (%% * 100)",
      dst_proc_num_page_faults = "Dst process num pagefaults",
      dst_proc_pctg_iowait = "Src process iowait time %% (%% * 100)",
      radius_req_msg_type = "RADIUS Request Msg Type",
      radius_rsp_msg_type = "RADIUS Response Msg Type",
      radius_user_name = "RADIUS User Name (Access Only)",
      radius_calling_station_id = "RADIUS Calling Station Id",
      radius_called_station_id = "RADIUS Called Station Id",
      radius_nas_ip_addr = "RADIUS NAS IP Address",
      radius_nas_identifier = "RADIUS NAS Identifier",
      radius_user_imsi = "RADIUS User IMSI (Extension)",
      radius_user_imei = "RADIUS User MSISDN (Extension)",
      radius_framed_ip_addr = "RADIUS Framed IP",
      radius_acct_session_id = "RADIUS Accounting Session Name",
      radius_acct_status_type = "RADIUS Accounting Status Type",
      radius_acct_in_octets = "RADIUS Accounting Input Octets",
      radius_acct_out_octets = "RADIUS Accounting Output Octets",
      radius_acct_in_pkts = "RADIUS Accounting Input Packets",
      radius_acct_out_pkts = "RADIUS Accounting Output Packets",
      rtp_ssrc = "RTP Sync Source ID",
      rtp_first_seq = "First flow RTP Seq Number",
      rtp_first_ts = "First flow RTP timestamp",
      rtp_last_seq = "Last flow RTP Seq Number",
      rtp_last_ts = "Last flow RTP timestamp",
      rtp_in_jitter = "RTP jitter (ms * 1000)",
      rtp_out_jitter = "RTP jitter (ms * 1000)",
      rtp_in_pkt_lost = "Packet lost in stream (src->dst)",
      rtp_out_pkt_lost = "Packet lost in stream (dst->src)",
      rtp_in_pkt_drop = "Packet discarded by Jitter Buffer (src->dst)",
      rtp_out_pkt_drop = "Packet discarded by Jitter Buffer (dst->src)",
      rtp_in_payload_type = "RTP payload type",
      rtp_out_payload_type = "RTP payload type",
      rtp_in_max_delta = "Max delta (ms*100) between consecutive pkts (src->dst)",
      rtp_out_max_delta = "Max delta (ms*100) between consecutive pkts (dst->src)",
      rtp_sip_call_id = "SIP call-id corresponding to this RTP stream",
      rtp_mos = "RTP pseudo-MOS (value * 100) (average both directions)",
      rtp_in_mos = "RTP pseudo-MOS (value * 100) (src->dst)",
      rtp_out_mos = "RTP pseudo-MOS (value * 100) (dst->src)",
      rtp_r_factor = "RTP pseudo-R_FACTOR (value * 100) (average both directions)",
      rtp_in_r_factor = "RTP pseudo-R_FACTOR (value * 100) (src->dst)",
      rtp_out_r_factor = "RTP pseudo-R_FACTOR (value * 100) (dst->src)",
      rtp_in_transit = "RTP Transit (value * 100) (src->dst)",
      rtp_out_transit = "RTP Transit (value * 100) (dst->src)",
      rtp_rtt = "RTP Round Trip Time (ms)",
      rtp_dtmf_tones = "DTMF tones sent (if any) during the call",
      s1ap_enb_ue_s1ap_id = "S1AP ENB Identifier",
      s1ap_mme_ue_s1ap_id = "S1AP MME Identifier",
      s1ap_msg_emm_type_mme_to_enb = "S1AP EMM Message Type from MME to ENB",
      s1ap_msg_esm_type_mme_to_enb = "S1AP ESM Message Type from MME to ENB",
      s1ap_msg_emm_type_enb_to_mme = "S1AP EMM Message Type from ENB to MME",
      s1ap_msg_esm_type_enb_to_mme = "S1AP ESM Message Type from ENB to MME",
      s1ap_cause_enb_to_mme = "S1AP Cause from ENB to MME",
      s1ap_detailed_cause_enb_to_mme = "S1AP Detailed Cause from ENB to MME",
      sip_call_id = "SIP call-id",
      sip_calling_party = "SIP Call initiator",
      sip_called_party = "SIP Called party",
      sip_rtp_codecs = "SIP RTP codecs",
      sip_invite_time = "SIP time (epoch) of INVITE",
      sip_trying_time = "SIP time (epoch) of Trying",
      sip_ringing_time = "SIP time (epoch) of RINGING",
      sip_invite_ok_time = "SIP time (epoch) of INVITE OK",
      sip_invite_failure_time = "SIP time (epoch) of INVITE FAILURE",
      sip_bye_time = "SIP time (epoch) of BYE",
      sip_bye_ok_time = "SIP time (epoch) of BYE OK",
      sip_cancel_time = "SIP time (epoch) of CANCEL",
      sip_cancel_ok_time = "SIP time (epoch) of CANCEL OK",
      sip_rtp_ipv4_src_addr = "SIP RTP stream source IP",
      sip_rtp_l4_src_port = "SIP RTP stream source port",
      sip_rtp_ipv4_dst_addr = "SIP RTP stream dest IP",
      sip_rtp_l4_dst_port = "SIP RTP stream dest port",
      sip_response_code = "SIP failure response code",
      sip_reason_cause = "SIP Cancel/Bye/Failure reason cause",
      sip_c_ip = "SIP C IP adresses",
      sip_call_state = "SIP Call State",
      smtp_mail_from = "Mail sender",
      smtp_rcpt_to = "Mail recipient",
      ssdp_host = "SSDP Host",
      ssdp_usn = "SSDP USN",
      ssdp_server = "SSDP Server",
      ssdp_type = "SSDP Type",
      ssdp_method = "SSDP Method",
   },

   please_wait_page = {
      waiting_for_db_msg = "Database schema migration in progress, waiting for database <b>%{dbname}</b> to become operational. You will be redirected as soon as the database is ready. Depending on the size of the existing database, this operation can take a long time. Migrations are performed only once and only during major version upgrades. If in doubt, please contact the developers at <a href='mailto:info@ntop.org'>info@ntop.org</a>.",
      operations_on_database_msg = "Operations currently performed on the database are the following: ",
      database = "Database",
      state = "State",
      command = "Command",
      id = "Id",
      user = "User",
      time = "Time",
      info = "Info",
      host = "Host",
   },

   index_page = {
      dashboard = "Dashboard",
      hosts = "Hosts",
      applications = "Applications",
      asns = "ASNs",
      senders = "Senders",
      top_flow_talkers = "Top Flow Talkers",
      refresh_frequency = "Refresh frequency",
      minute = "Minute",
      seconds = "Seconds",
      never = "Never",
      live_update = "Live update",
      refresh = "Refresh",
      refresh_graph_popup_msg = "Refresh graph",
      no_packet_warning = "No packet has been received yet on interface %{ifname}.<p>Please wait %{countdown} seconds until this page reloads.",
   },

   hosts_comparison = {
      hosts_parameter_missing_message = "Hosts parameter is missing (internal error ?)",
   },

   sflows_stats = {
      total_bytes = "Total Bytes",
      active_flows = "Active Flows",
      l4_proto = "L4 Proto",
      client_process = "Client Process",
      client_peer = "Client Peer",
      server_process = "Server Process",
      server_peer = "Server Peer",
   },

   processes_stats = {
      timeline = "Timeline",
      active_processes_title = "Active Processes: Realtime View",
      flows_count = "Flows Count",
      active_since = "Active Since",
      traffic_sent = "Traffic Sent",
      traffic_rcvd = "Traffic Rcvd",
      processes_timeline_title = "Processes Timeline",
      legend = "Legend",
      ["type"] = "Type",
      stack = "Stack",
      lines = "Lines",
      top_l7_protocols = "Top L7 Protocols",
      top_l4_protocols = "Top L4 Protocols",
      top_hosts = "Top Hosts",
      top_hosts_traffic = "Top Hosts Traffic",
      missing_pid_name_message = "Missing pid name",
      no_traffic_detected = "No traffic detected for this process, flow process expired, or process terminated.",
   },

   user_info = {
      top_applications = "Top Applications",
      top_l7_protocols = "Top L7 Protocols",
      top_l4_protocols = "Top L4 Protocols",
      missing_user_name_message = "Missing user name",
   },

   login = {
      welcome_to = "Welcome to %{product}",
      username_ph = "Username (default admin)",
      password_ph = "Password (default admin)",
      login = "Login",
      donation = "If you find %{product} useful, please support us by making a small <A href=\"%{donation_url}\">donation</A>. Your funding will help to run and foster the development of this project. Thank you.",
      license = "%{product} is released under <a href=\"%{license_url}\">%{license}</a>.",
      password_mismatch = "Passwords do not match",
      password_not_valid = "Please specify a different password",
      change_password = "Change Password",
      must_change_password = "Default admin password must be changed. Please enter a new password below.",
      password = "Password",
      confirm_password = "Confirm Password",
      logout = "Logout",
      logging_out = "Logging out...",
      device_label = "Device Label",
      username = "Username",
      enter_credentials = "Please enter your credentials for accessing this network.",
      internet_redirecting = "We're redirecting you to the Internet...",
      auth_success = "Authentication Successful",
   },

   policy_presets = {
    default = "Default",
    child = "Child",
    child_description = "A preset for children. Blocks social networks and limits game time",
    business = "Business",
    business_description = "A preset for business company employees",
    no_obfuscation = "No Obfuscation",
    no_obfuscation_description = "A preset to prevent traffic obfuscation",
    walled_garden = "Walled Garden",
    walled_garden_description = "Blocks VPN and Social Networks",
    guests = "Guests",
    guests_description = "A preset for guests. Only basic navigation allowed",
  },

  -- NOTE: do not add "Device" in these mappings
  device_types = {
    unknown = "Unknown",
    printer = "Printer",
    video = "Video",
    workstation = "Computer",
    laptop = "Laptop",
    tablet = "Tablet",
    phone = "Phone",
    tv = "TV",
    networking = "Router/Switch",
    wifi = "Wireless Network",
    nas = "NAS",
    multimedia = "Multimedia",
    iot = "IoT",
  },

   noTraffic = "No traffic has been reported for the specified date/time selection",
   error_rrd_low_resolution = "You are asking to fetch data at lower resolution than the one available on RRD, which will lead to invalid data."..
      "<br>If you still want data with such granularity, please tune <a href=\"%{prefs}\">Protocol/Networks Timeseries</a> preferences",
   error_rrd_cannot_complete_dump = "Cannot complete local hosts RRD dump. Disk slow or too many local hosts?",
   error_no_search_results = "No results found. Please modify your search criteria.";
   enterpriseOnly = "This feature is only available in the ntopng enterprise edition",
   no_results_found = "No results found",
   purged_error_message = "Very likely it is expired and ntopng has purged it from memory. You can set purge idle timeout settings from the <a href=\"%{url}\"><i class=\"fa fa-flask\"></i> Preferences</a>.",

   uploaders = "Upload Volume",
   downloaders = "Download Volume",
   unknowers =  "Unknown Traffic Volume",
   incomingflows = "Incoming Flows Count",
   outgoingflows = "Outgoing Flows Count",

   flow_search_criteria = "Flow Search Criteria",
   flow_search_results = "Flow Search Results",
   flow_search_from_aggregated = "(Aggregated)",
   summary = "Summary",
   date_from = "Begin Date/Time:",
   date_to    = "End Date/Time:"

}

return {en = en}
