#!/usr/bin/env python
from distutils.core import setup
from distutils.command.install import INSTALL_SCHEMES
from distutils.command.build import build
from os.path import join as path_join, exists as path_exists, dirname
from os import system
from glob import glob
from os import mkdir

def mkdirParents(path):
    dirnames = path.split('/')
    if path[0] == '/':
        dirnames = dirnames[1:]
        fullpath = '/'
    else:
        fullpath = './'
    for dirname in dirnames:
        fullpath = path_join(fullpath, dirname)
        if not path_exists(fullpath):
            mkdir(fullpath)

def gettextMO():
    for po_filename in glob('nulog-web/po/*/LC_MESSAGES/*.po'):
        # 'nulog-web/po/fr/LC_MESSAGES/*.po'
        # => 'build/share/locale/fr/LC_MESSAGES/nulog.mo'
        mo_filename = po_filename[:-3]+".mo"
        mo_filename = ['build', 'share', 'locale'] + mo_filename.split('/')[2:]
        mo_filename = path_join(*mo_filename)
        yield (po_filename, mo_filename)

class build_nulog2(build):
    def build_gettext(self):
        for po_filename, mo_filename in gettextMO():
            # Create directory
            self.announce("Compiling %s -> %s" % (po_filename, mo_filename))
            self.mkpath(dirname(mo_filename))

            # Compile PO to MO
            command = "msgfmt %s -o %s" % (po_filename, mo_filename)
            exitcode = system(command)
            if exitcode:
                raise RuntimeError("msgfmt failed, command: %r" % command)

    def run(self):
        self.build_gettext()
        build.run(self)

INSTALL_SCHEMES['unix_prefix']['scripts'] = '$base/sbin'

data_files = [
    ('/etc/nulog/', ['default.wrapper.conf',
                    'nulog-core/default.core.conf', 'nulog-web/default.nulog.conf']),
]
for po_filename, mo_filename in gettextMO():
    dest_dir = dirname(mo_filename).split('/')[1:]
    dest_dir = path_join(*dest_dir)
    data_files.append( (dest_dir, [mo_filename]) )
from pprint import pprint; pprint(data_files)

setup(name="Nulog",
      version="2.0-rc1",
      description="Firewall log analysis interface",
      author="INL",
      author_email="nulog-users@listes.inl.fr",
      url="http://software.inl.fr/trac/wiki/EdenWall/NuLog2",
      packages=['nulog-core', 'nulog-web', 'auth', 'nucentral', 'nucentral/client', 'nucentral/core'],
      scripts=['nulog.tac'],
      data_files=data_files,
      package_data={'nulog-web': ['css/*', 'img/*', 'xml/*', 'js/*', 'doc/*']},
      cmdclass={'build': build_nulog2},
)

