/*
 * Copyright(C) 2007 INL
 * Written by Romain Bignon <romain AT inl.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * $Id: nulog.js 11643 2007-12-11 18:29:08Z romain $
 */

/*******************
 *     PLUGINS     *
 *******************/
// Add a function to object for create an image when rehash a fragment
$.fn.image = function(src)
{
    return this.each(function(){
        $("<img />").appendTo(this).each(function(){
            this.src = src;
        });
    });
}

/*****************
 * AJAX COMMANDS *
 *****************/

function ajax_receive_cmd(c)
{
    var parv = c.split(" ");

    if(parv[0] == "FRAG")
    {
        if(parv[1] == "ADDED")
        { /* FRAG ADDED <fragname> <newfragname> */
	    window.location = '.'; // TODO check if this is really a clean method.
        }
        else if(parv[1] == "REMOVED")
        { /* FRAG REMOVED <fragname> */
            $('div#' + parv[2]).remove();
        }
    }
    else if(parv[0] == "FRAGPOS")
    {
        if(parv[1] == "MODIFIED")
            update_fragments();
    }
    else if(parv[0] == "RESETED")
    {
        document.location.reload(1);
    }
    else if(parv[0] == "ERROR")
    { /* ERROR <message> */
        alert("There is an error:\n" + c);
    }
}
function ajax_command()
{
    if (this.href.indexOf('remfrag') > 0 && !confirm("Are you sure you want to remove this box?"))
        return false;
    else if (this.href.indexOf('reset') > 0 && !confirm("Are you sure you want to reset your settings?"))
        return false;
    $.get(this.href, ajax_receive_cmd);
    return false;
}

function limit_change()
{
    var div = $($(this).parents('div.frag')[0]);

    var url = document.URL.split("/");
    var page = url[url.length-1].split("?");
    var args = "";
    if(page.length > 1)
        args = page[1];

    ajax_refresh(div, 'frag/' + div[0].id + '/?limit=' + this.value + '&' + args);
}

function limit_open()
{

}

function limit_close()
{
}

function title_change(input)
{
    var td = input.parent();
    var h3 = td.find('h3');
    var div = $(input.parents('div.frag')[0]);

    $.get('cmd/session/modfrag/?frag=' + div[0].id + '&title=' + input[0].value, ajax_receive_cmd);

    h3.each(function() { h3.find('span')[0].innerHTML = input[0].value; });

    input.css('display', 'none');
    h3.css('display', '');
    input.remove();
}

function title_edit()
{
    var td = $($(this).parents('td.title')[0]);
    var fragtitle = td.find('h3').find('span')[0].innerHTML;

    td.find('h3').css('display', 'none');

    /* We have to put 'display: none' in input tag, and to remove none from display attribute,
     * because when appendTo() is called, h3.style.display="none" isn't executed.
     * If we remove display to new input object in the callback function, it will be
     * executed after hiding h3.
     */
    td.each(function(){
        var input = $("<input type='text' maxlength='50' style='display: none' />").appendTo(this).each(function(){
            this.value = fragtitle;
            this.style.display = "";
        });
        input.focus();
        // When the input object lose focus, we call title_change().
        input.blur(function() { title_change(input); });
        input.keypress(function (e) {
                if (e.keyCode == 13 || e.keyCode == 27)
                    title_change(input);
            });
    });
}

/*****************
 *  AJAX RELOAD  *
 *****************/

function ajax_refresh(div, link)
{
    // Showing a gif to show this fragment is refreshing
    var body = div.find('tbody');
    body = body[body.length-1];

    $(body).empty();
    $(body).image("img/ajax-loader.gif");

    // Loading fragment. We call update_links as call back.
    try
    {
        div.load(link, {}, update_fragments);
    }
    catch(e)
    {
        alert("An exception has been raised during ajax request.");
        /* To debug, I catch exceptions to return false. */
    }
    return false; // stop link effect
}

/****************
 *  FRAG DRAG   *
 ****************/

function frag_start_move(e, ui)
{
    ui.helper.style.width = ui.helper.clientWidth + 'px';
    //$(ui.helper).css('width', ui.helper.clientWidth);
    $(ui.helper).css('z-index', '100');
}
function findPos(obj) {
    var curleft = curtop = 0;
    if (obj.offsetParent) {
        curleft = obj.offsetLeft
        curtop = obj.offsetTop
        while (obj = obj.offsetParent) {
            curleft += obj.offsetLeft
            curtop += obj.offsetTop
        }
    }
    return [curleft,curtop];
}
function frag_get_column(columns, x)
{
    var col = 0;
    for(col = 0; col < columns.length; ++col)
    {
        if(columns[col].childNodes.length == 0)
            continue;
        var x_frag = findPos(columns[col].childNodes[0])[0];
        if(x < x_frag)
        {
            col = col-1;
            break;
        }
    }
    if(col >= columns.length)
        col = columns.length - 1;
    if(col < 0)
        col = 0;

    return col;
}
function frag_in_move(e, ui)
{
    var pos = findPos(ui.helper);
    var x = pos[0]+ui.helper.clientWidth/2;
    var y = pos[1];

    var columns = $(".column");

    $(".frag_shadow").remove();

    var col = frag_get_column(columns, x);
    var nodes = columns[col].childNodes;
    var div = $("<div class='frag_shadow' style='height: " + ui.helper.clientHeight + "px' />");

    for(frag = 0; frag < nodes.length; ++frag)
    {
        var y_frag = findPos(nodes[frag])[1];
        if(y < y_frag)
        {
            div.insertBefore(nodes[frag]);
            return;
        }
    }
    $(columns[col]).append(div);
}

function frag_stop_move(e, ui)
{
    var shadow = $(".frag_shadow");
    var frag = $(ui.helper);

    if(shadow.length == 0)
        return;

    var sPath = window.location.pathname;
    var page = sPath.substring(sPath.lastIndexOf('/') + 1);

    var column = 0;
    var columns = $(".column");
    for(var i=0; i < columns.length; i++)
    {
        if(columns[i] == shadow.parent('div.column')[0])
        {
            column = i;
            break;
        }
    }
    var col = $(".column")[column];
    var pos = 0;
    for(var i=0; i < col.childNodes.length; i++)
    {
        if(col.childNodes[i] == shadow[0])
        {
            pos = i;
            break;
        }
    }

    frag.parent().each(function() { $(this).insertAfter(shadow); });
    ui.helper.style.width = '';
    ui.helper.style.position = '';
    ui.helper.style.top = '';
    ui.helper.style.left = '';
    ui.helper.style.zIndex = 100;
    shadow.remove();

    $.get('cmd/session/modfragpos/?page=' + page + '&frag=' + ui.helper.id + '&column=' + column + '&pos=' + pos,
            ajax_receive_cmd);
}

/****************
 *     MAIN     *
 ****************/

function update_fragments()
{
    /* This function is called when a fragment is updated...
     * So we update all binds in fragments divs.
     *
     * PLEASE, unbind all callbacks before add a bind!
     * If there isn't any unbind() for a bind(), after a fragment
     * update, there will two calls of your bind!
     *
     * Note that you only have to add binds in this function for fragments
     * binds. For global binds, please use main() function.
     */
    $("a.load").unbind("click");
    $("a.cmd").unbind("click");
    $("div.frag").unbind("mouseover");
    $("div.frag").unbind("mouseout");
    $("div.toolbar_button").unbind("click");
    $("a.reduce").unbind("click");
    $("div.frag").draggableDestroy();
    $("img.title").unbind("click");
    $("select.chlimit").unbind("change");
    $("select.chlimit").unbind("focus");
    $("select.chlimit").unbind("blur");

    $("a.load").click(function() { return ajax_refresh($(this).parents('div.frag'), this.href); });
    $("a.cmd").click(ajax_command);

    $("div.frag").mouseover(function () {
            $(this).find('td.buttons').find('img').each(function () {
                    this.src = this.src.replace(/_g.png/,"_c.png");
                });
            $(this).find('img.title').css('visibility', 'visible');
            $(this).find('div.toolbar_button').css('visibility', 'visible');
        });
    $("div.frag").mouseout(function () {
            $(this).find('td.buttons').find('img').each(function () {
                    this.src = this.src.replace(/_c.png/,"_g.png");
                });
            $(this).find('img.title').css('visibility', 'hidden');
            $(this).find('div.toolbar_button').css('visibility', 'hidden');
        });
    $("div.toolbar_button").click(function () {
            var frag = $(this).parents('div.frag');
            var toolbar = frag.find('div.toolbar');
            if(toolbar[0].style.display == 'none')
                toolbar.show("slow");
            else
                toolbar.hide("slow");

            return false;
        });
    $("a.reduce").click(function() {
            var frag = $(this).parents('div.frag');
            var body = frag.find('div.boxbody');
            if(body[0].style.display == 'none')
                body.show("slow");
            else
                body.hide("slow");

            return false;
        });
    if ($("div.frag").length > 1)
        $("div.frag").draggable({handle:'.movebar',
                                 start: frag_start_move,
                                 stop: frag_stop_move,
                                 drag: frag_in_move
                                });
    else
        $("div.movebar").each(function () { $(this).removeClass('movebar'); });
    $("img.title").click(title_edit);
    $("select.chlimit").change(limit_change);
    $("select.chlimit").focus(limit_open);
    $("select.chlimit").blur(limit_close);
}

function main()
{
    update_fragments();
    $("a.showsearch").unbind("click");
    $("a.showsearch").click(function () {
            if ($('form.search')[0].style.display == 'none')
                $('form.search').show("slow");
            else
                $('form.search').hide("slow");

            return false;
        });
    $("a.hide").click(function() {
            var mother = $(this).parents('div#leftmenu');
            var body = mother.find('div#menucontent');
            var image = $(this).find('img')[0];
            if(body[0].style.display == 'none') {
                body.show("fast");
		image.src = image.src.replace(/_r.png/,"_l.png");
	    } else {
                body.hide("fast");
		image.src = image.src.replace(/_l.png/,"_r.png");
    	    }

            return false;
        });
    $("a#changestate").click(function () {
            var toolbar = $('div.statemenu');
            if(toolbar[0].style.display == 'none')
                toolbar.show("normal");
            else
                toolbar.hide("normal");

            return false;
        });


}

/* When document is loaded, we call the main function */
$(document).ready(main);
