// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectAnyList_HeaderFile
#define _IFSelect_SelectAnyList_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IFSelect_SelectAnyList_HeaderFile
#include <Handle_IFSelect_SelectAnyList.hxx>
#endif

#ifndef _Handle_IFSelect_IntParam_HeaderFile
#include <Handle_IFSelect_IntParam.hxx>
#endif
#ifndef _IFSelect_SelectDeduct_HeaderFile
#include <IFSelect_SelectDeduct.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class IFSelect_IntParam;
class Standard_OutOfRange;
class Interface_InterfaceError;
class Interface_EntityIterator;
class Standard_Transient;
class Interface_Graph;
class TCollection_AsciiString;


//! A SelectAnyList kind Selection selects a List of an Entity, as <br>
//!           well as this Entity contains some. A List contains sub-entities <br>
//!           as one per Item, or several (for instance if an Entity binds <br>
//!           couples of sub-entities, each item is one of these couples). <br>
//!           Remark that only Entities are taken into account (neither <br>
//!           Reals, nor Strings, etc...) <br>
//! <br>
//!           To define the list on which to work, SelectAnyList has two <br>
//!           deferred methods : NbItems (which gives the length of the <br>
//!           list), FillResult (which fills an EntityIterator). They are <br>
//!           intended to get a List in an Entity of the required Type (and <br>
//!           consider that list is empty if Entity has not required Type) <br>
//! <br>
//!           In addition, remark that some types of Entity define more than <br>
//!           one list in each instance : a given sub-class of SelectAnyList <br>
//!           must be attached to one list <br>
//! <br>
//!           SelectAnyList keeps or rejects a sub-set of the list, <br>
//!           that is the Items of which rank in the list is in a given <br>
//!           range (for instance form 2nd to 6th, etc...) <br>
//!           Range is defined by two Integer values. In order to allow <br>
//!           external control of them, these values are not directly <br>
//!           defined as fields, but accessed through IntParams, that is, <br>
//!           referenced as Transient (Handle) objects <br>
//! <br>
//!           Warning : the Input can be any kind of Selection, BUT its <br>
//!           RootResult must have zero (empty) or one Entity maximum <br>
class IFSelect_SelectAnyList : public IFSelect_SelectDeduct {

public:

  //! Keeps Input Entity, as having required type. It works by <br>
//!           keeping in <iter>, only suitable Entities (SelectType can be <br>
//!           used). Called by RootResult (which waits for ONE ENTITY MAX) <br>
  Standard_EXPORT   virtual  void KeepInputEntity(Interface_EntityIterator& iter) const = 0;
  //! Returns count of Items in the list in the Entity <ent> <br>
//!           If <ent> has not required type, returned value must be Zero <br>
  Standard_EXPORT   virtual  Standard_Integer NbItems(const Handle(Standard_Transient)& ent) const = 0;
  //! Sets a Range for numbers, with a lower and a upper limits <br>
  Standard_EXPORT     void SetRange(const Handle(IFSelect_IntParam)& rankfrom,const Handle(IFSelect_IntParam)& rankto) ;
  //! Sets a unique number (only one Entity will be sorted as True) <br>
  Standard_EXPORT     void SetOne(const Handle(IFSelect_IntParam)& rank) ;
  //! Sets a Lower limit but no upper limit <br>
  Standard_EXPORT     void SetFrom(const Handle(IFSelect_IntParam)& rankfrom) ;
  //! Sets an Upper limit but no lower limit (equivalent to lower 1) <br>
  Standard_EXPORT     void SetUntil(const Handle(IFSelect_IntParam)& rankto) ;
  //! Returns True if a Lower limit is defined <br>
  Standard_EXPORT     Standard_Boolean HasLower() const;
  //! Returns Lower limit (if there is; else, value is senseless) <br>
  Standard_EXPORT     Handle_IFSelect_IntParam Lower() const;
  //! Returns Integer Value of Lower Limit (0 if none) <br>
  Standard_EXPORT     Standard_Integer LowerValue() const;
  //! Returns True if a Lower limit is defined <br>
  Standard_EXPORT     Standard_Boolean HasUpper() const;
  //! Returns Upper limit (if there is; else, value is senseless) <br>
  Standard_EXPORT     Handle_IFSelect_IntParam Upper() const;
  //! Returns Integer Value of Upper Limit (0 if none) <br>
  Standard_EXPORT     Standard_Integer UpperValue() const;
  //! Returns the list of selected entities (list of entities <br>
//!           complying with rank criterium) <br>
//!           Error if the input list has more than one Item <br>
  Standard_EXPORT     Interface_EntityIterator RootResult(const Interface_Graph& G) const;
  //! Puts into <res>, the sub-entities of the list, from n1 to <br>
//!           n2 included. Remark that adequation with Entity's type and <br>
//!           length of list has already been made at this stage <br>
//!           Called by RootResult <br>
  Standard_EXPORT   virtual  void FillResult(const Standard_Integer n1,const Standard_Integer n2,const Handle(Standard_Transient)& ent,Interface_EntityIterator& res) const = 0;
  //! Returns a text defining the criterium : "Componants of List " <br>
//!           then Specific List Label, then, following cases : <br>
//!           " From .. Until .." or "From .." or "Until .." or "Rank no .." <br>
//!           Specific type is given by deferred method ListLabel <br>
  Standard_EXPORT     TCollection_AsciiString Label() const;
  //! Returns the specific label for the list, which is included as <br>
//!           a part of Label <br>
  Standard_EXPORT   virtual  TCollection_AsciiString ListLabel() const = 0;




  DEFINE_STANDARD_RTTI(IFSelect_SelectAnyList)

protected:




private: 


Handle_IFSelect_IntParam thelower;
Handle_IFSelect_IntParam theupper;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
