// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESConvGeom_HeaderFile
#define _IGESConvGeom_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESGeom_SplineCurve_HeaderFile
#include <Handle_IGESGeom_SplineCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom_BSplineCurve_HeaderFile
#include <Handle_Geom_BSplineCurve.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Handle_IGESGeom_SplineSurface_HeaderFile
#include <Handle_IGESGeom_SplineSurface.hxx>
#endif
#ifndef _Handle_Geom_BSplineSurface_HeaderFile
#include <Handle_Geom_BSplineSurface.hxx>
#endif
class IGESGeom_SplineCurve;
class Geom_BSplineCurve;
class Geom2d_BSplineCurve;
class IGESGeom_SplineSurface;
class Geom_BSplineSurface;
class IGESConvGeom_GeomBuilder;


//! This package is intended to gather geometric conversion which <br>
//!           are not immediate but can be used for several purposes : <br>
//!           mainly, standard conversion to and from CasCade geometric and <br>
//!           topologic data, and adaptations of IGES files as required <br>
//!           (as replacing Spline entities to BSpline equivalents). <br>
class IGESConvGeom  {
public:

  DEFINE_STANDARD_ALLOC

  //! basic tool to build curves from IGESGeom (arrays of points, <br>
//!           Transformations, evaluation of points in a datum) <br>//! Converts a SplineCurve from IGES to a BSplineCurve from CasCade <br>
//!           <epscoef> gives tolerance to consider coefficient to be nul <br>
//!           <epsgeom> gives tolerance to consider poles to be equal <br>
//!           The returned value is a status with these possible values : <br>
//!           - 0  OK, done <br>
//!           - 1  the result is not guaranteed to be C0 (with <epsgeom>) <br>
//!           - 2  SplineType not processed (allowed : max 3) <br>
//!                (no result produced) <br>
//!           - 3  error during creation of control points <br>
//!                (no result produced) <br>
//!           - 4  polynomial equation is not correct (no result produced) <br>
//!           - 5  less than one segment (no result produced) <br>
  Standard_EXPORT   static  Standard_Integer SplineCurveFromIGES(const Handle(IGESGeom_SplineCurve)& igesent,const Standard_Real epscoef,const Standard_Real epsgeom,Handle(Geom_BSplineCurve)& result) ;
  //! Tries to increase curve continuity with tolerance <epsgeom> <br>
//!           <continuity> is the new desired continuity, can be 1 or 2 <br>
//!           (more than 2 is considered as 2). <br>
//!           Returns the new maximum continuity obtained on all knots. <br>
//!           Remark that, for instance with <continuity> = 2, even if not <br>
//!           all the knots can be passed to C2, all knots which can be are. <br>
  Standard_EXPORT   static  Standard_Integer IncreaseCurveContinuity(const Handle(Geom_BSplineCurve)& curve,const Standard_Real epsgeom,const Standard_Integer continuity = 2) ;
  
  Standard_EXPORT   static  Standard_Integer IncreaseCurveContinuity(const Handle(Geom2d_BSplineCurve)& curve,const Standard_Real epsgeom,const Standard_Integer continuity = 2) ;
  //! Converts a SplineSurface from IGES to a BSplineSurface from CasCade <br>
//!           <epscoef> gives tolerance to consider coefficient to be nul <br>
//!           <epsgeom> gives tolerance to consider poles to be equal <br>
//!           The returned value is a status with these possible values : <br>
//!           - 0  OK, done <br>
//!           - 1  the result is not guaranteed to be C0 (with <epsgeom>) <br>
//!           - 2  degree is not compatible with code boundary type <br>
//!                (warning) but C0 is OK <br>
//!           - 3  idem but C0 is not guaranteed (warning) <br>
//!           - 4  degree has been determined to be nul, either in U or V <br>
//!                (no result produced) <br>
//!           - 5  less than one segment in U or V (no result produced) <br>
  Standard_EXPORT   static  Standard_Integer SplineSurfaceFromIGES(const Handle(IGESGeom_SplineSurface)& igesent,const Standard_Real epscoef,const Standard_Real epsgeom,Handle(Geom_BSplineSurface)& result) ;
  //! Tries to increase Surface continuity with tolerance <epsgeom> <br>
//!           <continuity> is the new desired continuity, can be 1 or 2 <br>
//!           (more than 2 is considered as 2). <br>
//!           Returns the new maximum continuity obtained on all knots. <br>
//!           Remark that, for instance with <continuity> = 2, even if not <br>
//!           all the knots can be passed to C2, all knots which can be are. <br>
  Standard_EXPORT   static  Standard_Integer IncreaseSurfaceContinuity(const Handle(Geom_BSplineSurface)& surface,const Standard_Real epsgeom,const Standard_Integer continuity = 2) ;





protected:





private:




friend class IGESConvGeom_GeomBuilder;

};





// other Inline functions and methods (like "C++: function call" methods)


#endif
