// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeAnalysis_HeaderFile
#define _ShapeAnalysis_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_ShapeExtend_WireData_HeaderFile
#include <Handle_ShapeExtend_WireData.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Wire;
class TopoDS_Face;
class ShapeExtend_WireData;
class TopoDS_Shape;
class TopoDS_Vertex;
class ShapeAnalysis_Geom;
class ShapeAnalysis_Curve;
class ShapeAnalysis_Surface;
class ShapeAnalysis_Edge;
class ShapeAnalysis_Wire;
class ShapeAnalysis_WireOrder;
class ShapeAnalysis_WireVertex;
class ShapeAnalysis_CheckSmallFace;
class ShapeAnalysis_Shell;
class ShapeAnalysis_ShapeTolerance;
class ShapeAnalysis_ShapeContents;
class ShapeAnalysis_FreeBounds;
class ShapeAnalysis_FreeBoundData;
class ShapeAnalysis_FreeBoundsProperties;
class ShapeAnalysis_TransferParameters;
class ShapeAnalysis_TransferParametersProj;
class ShapeAnalysis_SequenceOfFreeBounds;
class ShapeAnalysis_HSequenceOfFreeBounds;
class ShapeAnalysis_DataMapOfShapeListOfReal;
class ShapeAnalysis_SequenceNodeOfSequenceOfFreeBounds;
class ShapeAnalysis_DataMapNodeOfDataMapOfShapeListOfReal;
class ShapeAnalysis_DataMapIteratorOfDataMapOfShapeListOfReal;


//! This package is intended to analyze geometrical objects <br>
//! and topological shapes. Analysis domain includes both <br>
//! exploring geometrical and topological properties of <br>
//! shapes and checking their conformance to Open CASCADE requirements. <br>
//! The directions of analysis provided by tools of this package are: <br>
//! computing quantities of subshapes, <br>
//! computing parameters of points on curve and surface, <br>
//! computing surface singularities, <br>
//! checking edge and wire consistency, <br>
//! checking edges order in the wire, <br>
//! checking face bounds orientation, <br>
//! checking small faces, <br>
//! analyzing shape tolerances, <br>
//! analyzing of free bounds of the shape. <br>
class ShapeAnalysis  {
public:

  DEFINE_STANDARD_ALLOC

  //! Returns the outer wire on the face <Face>. <br>
//!          This is replacement of the method BRepTools::OuterWire <br>
//!          until it works badly. <br>
//!          Returns the first wire oriented as outer according to <br>
//!          FClass2d_Classifier. If none, last wire is returned. <br>
  Standard_EXPORT   static  TopoDS_Wire OuterWire(const TopoDS_Face& face) ;
  //! Returns a total area of 2d wire <br>
  Standard_EXPORT   static  Standard_Real TotCross2D(const Handle(ShapeExtend_WireData)& sewd,const TopoDS_Face& aFace) ;
  //! Returns a total area of 3d wire <br>
  Standard_EXPORT   static  Standard_Real ContourArea(const TopoDS_Wire& theWire) ;
  //! Returns True if <F> has outer bound. <br>
  Standard_EXPORT   static  Standard_Boolean IsOuterBound(const TopoDS_Face& face) ;
  //! Returns a shift required to move point <br>
//!          <Val> to the range [ToVal-Period/2,ToVal+Period/2]. <br>
//!          This shift will be the divisible by Period. <br>
//!          Intended for adjusting parameters on periodic surfaces. <br>
  Standard_EXPORT   static  Standard_Real AdjustByPeriod(const Standard_Real Val,const Standard_Real ToVal,const Standard_Real Period) ;
  //! Returns a shift required to move point <br>
//!          <Val> to the range [ValMin,ValMax]. <br>
//!          This shift will be the divisible by Period <br>
//!          with Period = ValMax - ValMin. <br>
//!          Intended for adjusting parameters on periodic surfaces. <br>
  Standard_EXPORT   static  Standard_Real AdjustToPeriod(const Standard_Real Val,const Standard_Real ValMin,const Standard_Real ValMax) ;
  //! Finds the start and end vertices of the shape <br>
//!          Shape can be of the following type: <br>
//!          vertex: V1 and V2 are the same and equal to <shape>, <br>
//!          edge  : V1 is start and V2 is end vertex (see ShapeAnalysis_Edge <br>
//!                  methods FirstVertex and LastVertex), <br>
//!          wire  : V1 is start vertex of the first edge, V2 is end vertex <br>
//!                  of the last edge (also see ShapeAnalysis_Edge). <br>
//!                  If wire contains no edges V1 and V2 are nullified <br>
//!          If none of the above V1 and V2 are nullified <br>
  Standard_EXPORT   static  void FindBounds(const TopoDS_Shape& shape,TopoDS_Vertex& V1,TopoDS_Vertex& V2) ;
  //! Computes exact UV bounds of all wires on the face <br>
  Standard_EXPORT   static  void GetFaceUVBounds(const TopoDS_Face& F,Standard_Real& Umin,Standard_Real& Umax,Standard_Real& Vmin,Standard_Real& Vmax) ;





protected:





private:




friend class ShapeAnalysis_Geom;
friend class ShapeAnalysis_Curve;
friend class ShapeAnalysis_Surface;
friend class ShapeAnalysis_Edge;
friend class ShapeAnalysis_Wire;
friend class ShapeAnalysis_WireOrder;
friend class ShapeAnalysis_WireVertex;
friend class ShapeAnalysis_CheckSmallFace;
friend class ShapeAnalysis_Shell;
friend class ShapeAnalysis_ShapeTolerance;
friend class ShapeAnalysis_ShapeContents;
friend class ShapeAnalysis_FreeBounds;
friend class ShapeAnalysis_FreeBoundData;
friend class ShapeAnalysis_FreeBoundsProperties;
friend class ShapeAnalysis_TransferParameters;
friend class ShapeAnalysis_TransferParametersProj;
friend class ShapeAnalysis_SequenceOfFreeBounds;
friend class ShapeAnalysis_HSequenceOfFreeBounds;
friend class ShapeAnalysis_DataMapOfShapeListOfReal;
friend class ShapeAnalysis_SequenceNodeOfSequenceOfFreeBounds;
friend class ShapeAnalysis_DataMapNodeOfDataMapOfShapeListOfReal;
friend class ShapeAnalysis_DataMapIteratorOfDataMapOfShapeListOfReal;

};





// other Inline functions and methods (like "C++: function call" methods)


#endif
