// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_ModelCopier_HeaderFile
#define _IFSelect_ModelCopier_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IFSelect_ModelCopier_HeaderFile
#include <Handle_IFSelect_ModelCopier.hxx>
#endif

#ifndef _IFSelect_SequenceOfInterfaceModel_HeaderFile
#include <IFSelect_SequenceOfInterfaceModel.hxx>
#endif
#ifndef _TColStd_SequenceOfAsciiString_HeaderFile
#include <TColStd_SequenceOfAsciiString.hxx>
#endif
#ifndef _IFSelect_SequenceOfAppliedModifiers_HeaderFile
#include <IFSelect_SequenceOfAppliedModifiers.hxx>
#endif
#ifndef _Handle_IFSelect_ShareOut_HeaderFile
#include <Handle_IFSelect_ShareOut.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IFSelect_AppliedModifiers_HeaderFile
#include <Handle_IFSelect_AppliedModifiers.hxx>
#endif
#ifndef _Handle_IFSelect_WorkLibrary_HeaderFile
#include <Handle_IFSelect_WorkLibrary.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class IFSelect_ShareOut;
class TColStd_HArray1OfInteger;
class TColStd_HSequenceOfHAsciiString;
class TCollection_AsciiString;
class Interface_InterfaceModel;
class IFSelect_AppliedModifiers;
class Interface_CheckIterator;
class IFSelect_ShareOutResult;
class IFSelect_WorkLibrary;
class Interface_Protocol;
class Interface_CopyTool;
class Interface_Graph;
class Interface_EntityIterator;


//! This class performs the Copy operations involved by the <br>
//!           description of a ShareOut (evaluated by a ShareOutResult) <br>
//!           plus, if there are, the Modifications on the results, with <br>
//!           the help of Modifiers. Each Modifier can work on one or more <br>
//!           resulting packets, accoding its criteria : it operates on a <br>
//!           Model once copied and filled with the content of the packet. <br>
//! <br>
//!           Modifiers can be : <br>
//!           - Model Modifiers, inheriting from the specific class Modifier <br>
//!             able to run on the content of a Model (header or entities), <br>
//!             activated by the ModelCopier itself <br>
//!           - File Modifiers, inheriting directly from GeneralModifier, <br>
//!             intended to be activated under the control of a WorkLibrary, <br>
//!             once the Model has been produced (i.e. to act on output <br>
//!             format, or other specific file features) <br>
//! <br>
//!           The Copy operations can be : <br>
//!           - immediately put to files : for each packet, a Model is <br>
//!             created and filled, then the file is output, at that's all <br>
//!           - memorized : for each packet, a Model is created and filled, <br>
//!             it is memorized with the corresponding file name. <br>
//!             it is possible to query the result of memorization (list of <br>
//!             produced Models and their file names) <br>
//!             -> it is also possible to send it into the files : <br>
//!                once files are written, the result is cleared <br>
//! <br>
//!           In addition, a list of really written files is managed : <br>
//!           A first call to BeginSentFiles clears the list and commands, <br>
//!           either to begin a new list, or to stop recording it. A call <br>
//!           to SentFiles returns the list (if recording has been required) <br>
//!           This list allows to globally exploit the set of produced files <br>
//! <br>
//!           Remark : For operations which concern specific Entities, see <br>
//!           also in package IFAdapt : a sub-class of ModelCopier allows <br>
//!           to work with EntityModifier, in addition to Modifier itself <br>
//!           which still applies to a whole copied Model. <br>
class IFSelect_ModelCopier : public MMgt_TShared {

public:

  //! Creates an empty ModelCopier <br>
  Standard_EXPORT   IFSelect_ModelCopier();
  //! Sets the ShareOut, which is used to define Modifiers to apply <br>
  Standard_EXPORT     void SetShareOut(const Handle(IFSelect_ShareOut)& sho) ;
  //! Clears the list of produced Models <br>
  Standard_EXPORT     void ClearResult() ;
  //! Records a new File to be sent, as a couple <br>
//!           (Name as AsciiString, Content as InterfaceModel) <br>
//!           Returns True if Done, False if <filename> is already attached <br>
//!             to another File <br>
  Standard_EXPORT     Standard_Boolean AddFile(const TCollection_AsciiString& filename,const Handle(Interface_InterfaceModel)& content) ;
  //! Changes the Name attached to a File which was formerly defined <br>
//!           by a call to AddFile <br>
//!           Returns True if Done, False else : if <num> out of range or if <br>
//!             the new <filename> is already attached to another File <br>
//!           Remark : Giving an empty File Name is equivalent to ClearFile <br>
  Standard_EXPORT     Standard_Boolean NameFile(const Standard_Integer num,const TCollection_AsciiString& filename) ;
  //! Clears the Name attached to a File which was formerly defined <br>
//!           by a call to AddFile. This Clearing can be undone by a call to <br>
//!           NameFile (with same <num>) <br>
//!           Returns True if Done, False else : if <num> is out of range <br>
  Standard_EXPORT     Standard_Boolean ClearFile(const Standard_Integer num) ;
  //! Sets a list of File Modifiers to be applied on a file <br>
  Standard_EXPORT     Standard_Boolean SetAppliedModifiers(const Standard_Integer num,const Handle(IFSelect_AppliedModifiers)& applied) ;
  //! Clears the list of File Modifiers to be applied on a file <br>
  Standard_EXPORT     Standard_Boolean ClearAppliedModifiers(const Standard_Integer num) ;
  //! Performs the Copy Operations, which include the Modifications <br>
//!           defined by the list of Modifiers. Memorizes the result, as a <br>
//!           list of InterfaceModels with the corresponding FileNames <br>
//!           They can then be sent, by the method Send, or queried <br>
//!           Copy calls internal method Copying. <br>
//!           Returns the produced CheckList <br>
  Standard_EXPORT     Interface_CheckIterator Copy(IFSelect_ShareOutResult& eval,const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol) ;
  //! Sends the formerly defined results (see method Copy) to files, <br>
//!           then clears it <br>
//!           Remark : A Null File Name cause file to be not produced <br>
  Standard_EXPORT     Interface_CheckIterator SendCopied(const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol) ;
  //! Performs the Copy Operations (which include the Modifications) <br>
//!           and Sends the result on files, without memorizing it. <br>
//!           (the memorized result is ignored : neither queried not filled) <br>
  Standard_EXPORT     Interface_CheckIterator Send(IFSelect_ShareOutResult& eval,const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol) ;
  //! Sends a model (defined in <G>) into one file, without managing <br>
//!           remaining data, already sent files, etc. Applies the Model and <br>
//!           File Modifiers. <br>
//!           Returns True if well done, False else <br>
  Standard_EXPORT     Interface_CheckIterator SendAll(const Standard_CString filename,const Interface_Graph& G,const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol) ;
  //! Sends a part of a model into one file. Model is gotten from <br>
//!           <G>, the part is defined in <iter>. <br>
//!           Remaining data are managed and can be later be worked on. <br>
//!           Returns True if well done, False else <br>
  Standard_EXPORT     Interface_CheckIterator SendSelected(const Standard_CString filename,const Interface_Graph& G,const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol,const Interface_EntityIterator& iter) ;
  //! Produces a Model copied from the Remaining List as <newmod> <br>
//!           <newmod> is a Null Handle if this list is empty <br>
//!           <WL> performs the copy by using <TC> <br>
//!           <TC> is assumed to have been defined with the starting model <br>
//!           same as defined by <G>. <br>
  Standard_EXPORT     void CopiedRemaining(const Interface_Graph& G,const Handle(IFSelect_WorkLibrary)& WL,Interface_CopyTool& TC,Handle(Interface_InterfaceModel)& newmod) ;
  //! Updates Graph status for remaining data, for each entity : <br>
//!           - Entities just Sent to file or Copied (by CopiedRemaining) <br>
//!             have their status set to 1 <br>
//!           - the other keep their former status (1 for Send/Copied, <br>
//!             0 for Remaining) <br>
//!           These status are computed by Copying/Sending/CopiedRemaining <br>
//!           Then, SetRemaining updates graph status, and mustr be called <br>
//!           just after one of these method has been called <br>
//!           Returns True if done, False if remaining info if not in phase <br>
//!           which the Graph (not same counts of items) <br>
  Standard_EXPORT     Standard_Boolean SetRemaining(Interface_Graph& CG) const;
  //! Returns the count of Files produced, i.e. the count of Models <br>
//!           memorized (produced by the mmethod Copy) with their file names <br>
  Standard_EXPORT     Standard_Integer NbFiles() const;
  //! Returns the File Name for a file given its rank <br>
//!           It is empty after a call to ClearFile on same <num> <br>
  Standard_EXPORT     TCollection_AsciiString FileName(const Standard_Integer num) const;
  //! Returns the content of a file before sending, under the form <br>
//!           of an InterfaceModel, given its rank <br>
  Standard_EXPORT     Handle_Interface_InterfaceModel FileModel(const Standard_Integer num) const;
  //! Returns the list of File Modifiers to be applied on a file <br>
//!           when it will be sent, as computed by CopiedModel : <br>
//!           If it is a null handle, no File Modifier has to be applied. <br>
  Standard_EXPORT     Handle_IFSelect_AppliedModifiers AppliedModifiers(const Standard_Integer num) const;
  //! Begins a sequence of recording the really sent files <br>
//!           <sho> : the default file numbering is cleared <br>
//!           If <record> is False, clears the list and stops recording <br>
//!           If <record> is True, clears the list and commands recording <br>
//!           Creation time corresponds to "stop recording" <br>
  Standard_EXPORT     void BeginSentFiles(const Handle(IFSelect_ShareOut)& sho,const Standard_Boolean record) ;
  //! Adds the name of a just sent file, if BeginSentFiles <br>
//!           has commanded recording; else does nothing <br>
//!           It is called by methods SendCopied Sending <br>
  Standard_EXPORT     void AddSentFile(const Standard_CString filename) ;
  //! Returns the list of recorded names of sent files. Can be empty <br>
//!           (if no file has been sent). Returns a Null Handle if <br>
//!           BeginSentFiles has stopped recording. <br>
  Standard_EXPORT     Handle_TColStd_HSequenceOfHAsciiString SentFiles() const;




  DEFINE_STANDARD_RTTI(IFSelect_ModelCopier)

protected:

  //! Internal routine which does the effective Copy. It allows to <br>
//!           work, either with a standard CopyTool, or a specialised one <br>
//!           Copying itself is done by <WL> which uses a CopyTool <br>
  Standard_EXPORT     Interface_CheckIterator Copying(IFSelect_ShareOutResult& eval,const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol,Interface_CopyTool& TC) ;
  //! Internal routine which does the effective Send. It allows to <br>
//!           work, either with a standard CopyTool, or a specialised one <br>
  Standard_EXPORT     Interface_CheckIterator Sending(IFSelect_ShareOutResult& eval,const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol,Interface_CopyTool& TC) ;
  //! Performs the Copy of a unitary Packet <br>
//!             Input parameters are : <br>
//!           <G> is the graph which defines the starting entities, it <br>
//!             contains the original InterfaceModel <br>
//!           <WL> performs the copy by using <TC> <br>
//!           <protocol> is the used protocol (can be usefull for Modifiers) <br>
//!           <topcopy> is the list of Entities which are the Roots of the <br>
//!             packet to be copied <br>
//!           <filename> is the name of the file which will receive it <br>
//!           <dispid> is the Identifier of the Dispatch which have produced <br>
//!             this packet, <numod> is the rank of the packet for this <br>
//!             Dispatch <br>
//!           <TC> is a CopyTool, which performs the copy <br>
//! <br>
//!               Returned values (as arguments) are : <br>
//!           <newmod> is the result of the copy, as a new InterfaceModel on <br>
//!           which Model Modifiers have already been applied (if there are) <br>
//!           <applied> determines the File Modifiers which remain to be <br>
//!           applied (when the file itself will be output) : for each File <br>
//!           Modifier recorded in <me>, <applied>'s Value is : <br>
//!           - Null if this Modifier has not to be applied <br>
//!           - an empty list if this Modifier has to be applied without <br>
//!             distinguishing specific entities <br>
//!           - a list of numbers of entities in <model> if this Modifier <br>
//!             concerns particularly these entities (which are the results <br>
//!             of copying the result of its input selection) <br>
//!           <checks> is the produced Check List (by Modifiers as required) <br>
//! <br>
//!  Warning : File Modifiers are evaluated at the time of Copy itself <br>
//!           If their list is changed between this Copy and the Sending <br>
//!           itself of the file, these changes are ignored <br>
  Standard_EXPORT     void CopiedModel(const Interface_Graph& G,const Handle(IFSelect_WorkLibrary)& WL,const Handle(Interface_Protocol)& protocol,const Interface_EntityIterator& topcopy,const TCollection_AsciiString& filename,const Standard_Integer dispnum,const Standard_Integer numod,Interface_CopyTool& TC,Handle(Interface_InterfaceModel)& newmod,Handle(IFSelect_AppliedModifiers)& applied,Interface_CheckIterator& checks) const;



private: 


IFSelect_SequenceOfInterfaceModel thefilemodels;
TColStd_SequenceOfAsciiString thefilenames;
IFSelect_SequenceOfAppliedModifiers theapplieds;
Handle_IFSelect_ShareOut theshareout;
Handle_TColStd_HArray1OfInteger theremain;
Handle_TColStd_HSequenceOfHAsciiString thesentfiles;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
