// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ChFi2d_Builder_HeaderFile
#define _ChFi2d_Builder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _ChFi2d_ConstructionError_HeaderFile
#include <ChFi2d_ConstructionError.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopTools_SequenceOfShape_HeaderFile
#include <TopTools_SequenceOfShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopoDS_Face;
class TopoDS_Edge;
class TopoDS_Vertex;
class TopTools_SequenceOfShape;


//! This  class contains  the algorithm  used to build <br>
//!          fillet on planar wire. <br>
class ChFi2d_Builder  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   ChFi2d_Builder();
  //! The face  <F> can be build  on a closed or an open <br>
//!          wire. <br>
  Standard_EXPORT   ChFi2d_Builder(const TopoDS_Face& F);
  
  Standard_EXPORT     void Init(const TopoDS_Face& F) ;
  
  Standard_EXPORT     void Init(const TopoDS_Face& RefFace,const TopoDS_Face& ModFace) ;
  //! Add  a fillet  of   radius  <Radius> on  the  wire <br>
//!          between the two edges connected to the vertex <V>. <br>
//!          <AddFillet> returns the  fillet edge. The returned <br>
//!          edge has  sense only   if the status   <status> is <br>
//!          <IsDone> <br>
  Standard_EXPORT     TopoDS_Edge AddFillet(const TopoDS_Vertex& V,const Standard_Real Radius) ;
  //! modify the fillet radius and return the new fillet <br>
//!          edge. this    edge has sense  only if   the status <br>
//!          <status> is <IsDone>. <br>
  Standard_EXPORT     TopoDS_Edge ModifyFillet(const TopoDS_Edge& Fillet,const Standard_Real Radius) ;
  //! removes the fillet <Fillet> and returns the vertex <br>
//!          connecting the two adjacent edges to  this fillet. <br>
  Standard_EXPORT     TopoDS_Vertex RemoveFillet(const TopoDS_Edge& Fillet) ;
  //! Add a chamfer on  the  wire between the two  edges <br>
//!          connected <E1> and  <E2>. <AddChamfer> returns the <br>
//!          chamfer  edge. This  edge  has  sense only if  the <br>
//!          status <status> is <IsDone>. <br>
  Standard_EXPORT     TopoDS_Edge AddChamfer(const TopoDS_Edge& E1,const TopoDS_Edge& E2,const Standard_Real D1,const Standard_Real D2) ;
  //! Add  a chamfer on the   wire between the two edges <br>
//!          connected to the vertex <V>. The chamfer will make <br>
//!          an  angle <Ang> with the edge  <E>, and one of its <br>
//!          extremities  will be on  <E>  at distance <D>. The <br>
//!          returned   edge has sense   only   if the   status <br>
//!          <status> is <IsDone>. <br>
//!  Warning: The value of <Ang> must be expressed in Radian. <br>
  Standard_EXPORT     TopoDS_Edge AddChamfer(const TopoDS_Edge& E,const TopoDS_Vertex& V,const Standard_Real D,const Standard_Real Ang) ;
  //! modify the chamfer <Chamfer>  and returns  the new <br>
//!          chamfer edge. <br>
//!          This edge as sense only  if the status <status> is <br>
//!          <IsDone>. <br>
  Standard_EXPORT     TopoDS_Edge ModifyChamfer(const TopoDS_Edge& Chamfer,const TopoDS_Edge& E1,const TopoDS_Edge& E2,const Standard_Real D1,const Standard_Real D2) ;
  //! modify the  chamfer <Chamfer>  and returns the new <br>
//!          chamfer edge. This    edge as sense  only   if the <br>
//!          status <status>   is  <IsDone>. <br>
//!  Warning: The value of <Ang> must be expressed in Radian. <br>
  Standard_EXPORT     TopoDS_Edge ModifyChamfer(const TopoDS_Edge& Chamfer,const TopoDS_Edge& E,const Standard_Real D,const Standard_Real Ang) ;
  //! removes   the chamfer  <Chamfer>   and returns the <br>
//!          vertex connecting  the two adjacent  edges to this <br>
//!          chamfer. <br>
  Standard_EXPORT     TopoDS_Vertex RemoveChamfer(const TopoDS_Edge& Chamfer) ;
  //! returns the modified face <br>
        TopoDS_Face Result() const;
  
        Standard_Boolean IsModified(const TopoDS_Edge& E) const;
  //! returns the list of new edges <br>
       const TopTools_SequenceOfShape& FilletEdges() const;
  
        Standard_Integer NbFillet() const;
  //! returns the list of new edges <br>
       const TopTools_SequenceOfShape& ChamferEdges() const;
  
        Standard_Integer NbChamfer() const;
  
        Standard_Boolean HasDescendant(const TopoDS_Edge& E) const;
  //! returns the modified edge if <E> has descendant or <br>
//!          <E> in the other case. <br>
       const TopoDS_Edge& DescendantEdge(const TopoDS_Edge& E) const;
  //! Returns the parent edge of  <E> <br>
//!  Warning: If <E>is a basis edge,  the returned edge would be <br>
//!          equal to <E> <br>
  Standard_EXPORT    const TopoDS_Edge& BasisEdge(const TopoDS_Edge& E) const;
  
        ChFi2d_ConstructionError Status() const;





protected:





private:

  //! Is internaly used by <AddFillet>. <br>
//!  Warning: <TrimE1>, <TrimE2>, <Fillet> has sense only if the <br>
//!          status <status> is equal to <IsDone> <br>
  Standard_EXPORT     void ComputeFillet(const TopoDS_Vertex& V,const TopoDS_Edge& E1,const TopoDS_Edge& E2,const Standard_Real Radius,TopoDS_Edge& TrimE1,TopoDS_Edge& TrimE2,TopoDS_Edge& Fillet) ;
  //! Is internaly used by  <AddChamfer>. The chamfer is <br>
//!          computed  from  a  vertex,   two  edges   and  two <br>
//!          distances <br>
//!  Warning: <TrimE1>, <TrimE2> and <Chamfer> has sense only if <br>
//!          if the status <status> is equal to <IsDone> <br>
  Standard_EXPORT     void ComputeChamfer(const TopoDS_Vertex& V,const TopoDS_Edge& E1,const TopoDS_Edge& E2,const Standard_Real D1,const Standard_Real D2,TopoDS_Edge& TrimE1,TopoDS_Edge& TrimE2,TopoDS_Edge& Chamfer) ;
  //! Is internaly used by <AddChamfer>.  The chamfer is <br>
//!          computed from   an  edge,  a  vertex,   a distance <br>
//!    	    and an angle <br>
//!  Warning: <TrimE1>,  <TrimE2>, and <Chamfer> has <br>
//!          sense only   if  the status <status> is   equal to <br>
//!          <IsDone> <br>
  Standard_EXPORT     void ComputeChamfer(const TopoDS_Vertex& V,const TopoDS_Edge& E1,const Standard_Real D,const Standard_Real Ang,const TopoDS_Edge& E2,TopoDS_Edge& TrimE1,TopoDS_Edge& TrimE2,TopoDS_Edge& Chamfer) ;
  //! Is   internaly  used     by  <ComputeFillet>. <br>
//!          <NewExtr1> and  <NewExtr2>  will  contains the new <br>
//!          extremities of <AdjEdge1> and <AdjEdge2> <br>
//!  Warning: The  returned  edge has sense   only if the status <br>
//!          <status> is equal to <IsDone> <br>
//!          or to one of those specific cases : <br>
//!          	<FirstEdgeDegenerated> <br>
//!          	<LastEdgeDegenerated> <br>
//!          	<BothEdgesDegenerated> <br>
  Standard_EXPORT     TopoDS_Edge BuildFilletEdge(const TopoDS_Vertex& V,const TopoDS_Edge& AdjEdge1,const TopoDS_Edge& AdjEdge2,const Standard_Real Radius,TopoDS_Vertex& NewExtr1,TopoDS_Vertex& NewExtr2) ;
  //! Is   internaly  used     by  <ComputeFillet>. <br>
//!          <NewExtr1> and  <NewExtr2>  will  contains the new <br>
//!          extremities of <AdjEdge1> and <AdjEdge2> <br>
//!  Warning: The  returned  edge has sense   only if the status <br>
//!          <status> is equal to <IsDone> <br>
  Standard_EXPORT     TopoDS_Edge BuildChamferEdge(const TopoDS_Vertex& V,const TopoDS_Edge& AdjEdge1,const TopoDS_Edge& AdjEdge2,const Standard_Real D1,const Standard_Real D2,TopoDS_Vertex& NewExtr1,TopoDS_Vertex& NewExtr2) ;
  //! Is   internaly  used     by  <ComputeFillet>. <br>
//!          <NewExtr1> and  <NewExtr2>  will  contains the new <br>
//!          extremities of <AdjEdge1> and <AdjEdge2> <br>
//!  Warning: The  returned  edge has sense   only if the status <br>
//!          <status> is equal to <IsDone> <br>
  Standard_EXPORT     TopoDS_Edge BuildChamferEdge(const TopoDS_Vertex& V,const TopoDS_Edge& AdjEdge2,const Standard_Real D,const Standard_Real Ang,const TopoDS_Edge& AdjEdge1,TopoDS_Vertex& NewExtr1,TopoDS_Vertex& NewExtr2) ;
  //! replaces in  the  new face  <newFace> <OldE1>  and <br>
//!          <OldE2>  by <E1>, <Fillet> and <E2> <br>
//!	    or by <Fillet> and <E2> if <E1> is degenerated <br>
//!	    or by <E1> and <Fillet> if <E2> is degenerated <br>
//!	    or by <Fillet> if <E1> and <E2> are degenerated . <br>
  Standard_EXPORT     void BuildNewWire(const TopoDS_Edge& OldE1,const TopoDS_Edge& OldE2,const TopoDS_Edge& E1,const TopoDS_Edge& Fillet,const TopoDS_Edge& E2) ;
  //! Changes <OldExtr> of <E1> by <NewExtr> <br>
  Standard_EXPORT     TopoDS_Edge BuildNewEdge(const TopoDS_Edge& E1,const TopoDS_Vertex& OldExtr,const TopoDS_Vertex& NewExtr) const;
  //! Changes <OldExtr> of <E1> by <NewExtr> <br>
//!	    returns E1 and IsDegenerated = Standard_True <br>
//!	    if the new edge is degenerated <br>
  Standard_EXPORT     TopoDS_Edge BuildNewEdge(const TopoDS_Edge& E1,const TopoDS_Vertex& OldExtr,const TopoDS_Vertex& NewExtr,Standard_Boolean& IsDegenerated) const;
  //! Writes <NewEdge> in  <fillets> if <Id> is equal to <br>
//!          1, or in <chamfers> if <Id> is Equal to 2. <br>
//!          Writes  the  modifications  in  <history> : <br>
//!          <TrimE1> is given by <E1>, <TrimE2> by <E2> <br>
//!          if <TrimE1> and <TrimE2> are not degenerated. <br>
  Standard_EXPORT     void UpDateHistory(const TopoDS_Edge& E1,const TopoDS_Edge& E2,const TopoDS_Edge& TrimE1,const TopoDS_Edge& TrimE2,const TopoDS_Edge& NewEdge,const Standard_Integer Id) ;
  //! Writes the  modifications in  <history> . <TrimE1> <br>
//!          is given by <E1>, <TrimE2> by <E2>. <br>
  Standard_EXPORT     void UpDateHistory(const TopoDS_Edge& E1,const TopoDS_Edge& E2,const TopoDS_Edge& TrimE1,const TopoDS_Edge& TrimE2) ;
  
  Standard_EXPORT     Standard_Boolean IsAFillet(const TopoDS_Edge& E) const;
  
  Standard_EXPORT     Standard_Boolean IsAChamfer(const TopoDS_Edge& E) const;


ChFi2d_ConstructionError status;
TopoDS_Face refFace;
TopoDS_Face newFace;
TopTools_SequenceOfShape fillets;
TopTools_SequenceOfShape chamfers;
TopTools_DataMapOfShapeShape history;


};


#include <ChFi2d_Builder.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
