// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gce_MakeDir_HeaderFile
#define _gce_MakeDir_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _gce_Root_HeaderFile
#include <gce_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class gp_Vec;
class gp_XYZ;
class gp_Pnt;
class gp_Dir;


//! This class implements the following algorithms used <br>
//!           to create a Dir from gp. <br>
//!           * Create a Dir parallel to another and passing <br>
//!             through a point. <br>
//!           * Create a Dir passing through 2 points. <br>
//!           * Create a Dir from its axis (Ax1 from gp). <br>
//!           * Create a Dir from a point and a direction. <br>
class gce_MakeDir  : public gce_Root {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Normalizes the vector V and creates a direction. <br>
//!            Status is "NullVector" if V.Magnitude() <= Resolution. <br>
  Standard_EXPORT   gce_MakeDir(const gp_Vec& V);
  //! Creates a direction from a triplet of coordinates. <br>
//!            Status is "NullVector" if Coord.Modulus() <= <br>
//!            Resolution from gp. <br>
  Standard_EXPORT   gce_MakeDir(const gp_XYZ& Coord);
  //! Creates a direction with its 3 cartesian coordinates. <br>
//!            Status is "NullVector" if Sqrt(Xv*Xv + Yv*Yv + Zv*Zv) <br>
//!            <= Resolution <br>
  Standard_EXPORT   gce_MakeDir(const Standard_Real Xv,const Standard_Real Yv,const Standard_Real Zv);
  //! Make a Dir from gp <TheDir> passing through 2 <br>
//!           Pnt <P1>,<P2>. <br>
//!           Status is "ConfusedPoints" if <p1> and <P2> are confused. <br>
//! Warning <br>
//! If an error occurs (that is, when IsDone returns <br>
//! false), the Status function returns: <br>
//! -   gce_ConfusedPoints if points P1 and P2 are coincident, or <br>
//! -   gce_NullVector if one of the following is less <br>
//!   than or equal to gp::Resolution(): <br>
//!   -   the magnitude of vector V, <br>
//!   -   the modulus of Coord, <br>
//!   -   Sqrt(Xv*Xv + Yv*Yv + Zv*Zv). <br>
  Standard_EXPORT   gce_MakeDir(const gp_Pnt& P1,const gp_Pnt& P2);
  //! Returns the constructed unit vector. <br>
//! Exceptions StdFail_NotDone if no unit vector is constructed. <br>
  Standard_EXPORT    const gp_Dir& Value() const;
  
  Standard_EXPORT    const gp_Dir& Operator() const;
Standard_EXPORT operator gp_Dir() const;





protected:





private:



gp_Dir TheDir;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
